"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from compass_api_sdk.types import BaseModel
from enum import Enum
from typing import Optional
from typing_extensions import NotRequired, TypedDict


class CreateAccountRequestChain(str, Enum):
    ARBITRUM = "arbitrum"
    BASE = "base"
    ETHEREUM = "ethereum"


class CreateAccountRequestTypedDict(TypedDict):
    r"""Request to create a compass account."""

    chain: CreateAccountRequestChain
    sender: str
    r"""The address of the transaction sender."""
    owner: str
    r"""The address that will own and control the compass account"""
    estimate_gas: NotRequired[bool]
    r"""Determines whether to estimate gas costs for transactions, also verifying that the transaction can be successfully executed."""


class CreateAccountRequest(BaseModel):
    r"""Request to create a compass account."""

    chain: CreateAccountRequestChain

    sender: str
    r"""The address of the transaction sender."""

    owner: str
    r"""The address that will own and control the compass account"""

    estimate_gas: Optional[bool] = None
    r"""Determines whether to estimate gas costs for transactions, also verifying that the transaction can be successfully executed."""
