"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from compass_api_sdk.types import BaseModel
from compass_api_sdk.utils import validate_const
import pydantic
from pydantic.functional_validators import AfterValidator
from typing import Literal
from typing_extensions import Annotated, TypedDict


class CompassAPIBackendV2ModelsEarnReadResponsePositionsVaultPositionTypedDict(
    TypedDict
):
    id: str
    r"""Base64-encoded position identifier."""
    vault_address: str
    r"""The vault address you are depositing to."""
    amount_in_underlying_token: str
    r"""The user's position value denominated in the underlying token."""
    token_name: str
    r"""Symbol of the underlying token (e.g., USDC)."""
    vault_name: str
    r"""Name of the vault token (share token)."""
    type: Literal["VAULT"]
    r"""The market type discriminator."""


class CompassAPIBackendV2ModelsEarnReadResponsePositionsVaultPosition(BaseModel):
    id: str
    r"""Base64-encoded position identifier."""

    vault_address: str
    r"""The vault address you are depositing to."""

    amount_in_underlying_token: str
    r"""The user's position value denominated in the underlying token."""

    token_name: str
    r"""Symbol of the underlying token (e.g., USDC)."""

    vault_name: str
    r"""Name of the vault token (share token)."""

    TYPE: Annotated[
        Annotated[Literal["VAULT"], AfterValidator(validate_const("VAULT"))],
        pydantic.Field(alias="type"),
    ] = "VAULT"
    r"""The market type discriminator."""
