"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from compass_api_sdk.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from pydantic import model_serializer
from typing_extensions import NotRequired, TypedDict


class CompassAPIBackendV1ModelsPendleReadResponseMarketUserPositionTypedDict(TypedDict):
    claimable_yield: str
    r"""The amount of yield that can be claimed in the underlying token."""
    sy_balance: str
    r"""The amount of SY tokens the user currently holds."""
    pt_balance: str
    r"""The amount of PT tokens the user currently holds."""
    yt_balance: str
    r"""The amount of YT tokens the user currently holds."""
    lp_balance: str
    r"""The amount of LP tokens the user currently holds."""
    underlying_token_balance: str
    r"""The amount of underlying tokens the user currently holds."""
    accounting_asset_balance: NotRequired[Nullable[str]]
    r"""The amount of accounting assets the user currently holds."""


class CompassAPIBackendV1ModelsPendleReadResponseMarketUserPosition(BaseModel):
    claimable_yield: str
    r"""The amount of yield that can be claimed in the underlying token."""

    sy_balance: str
    r"""The amount of SY tokens the user currently holds."""

    pt_balance: str
    r"""The amount of PT tokens the user currently holds."""

    yt_balance: str
    r"""The amount of YT tokens the user currently holds."""

    lp_balance: str
    r"""The amount of LP tokens the user currently holds."""

    underlying_token_balance: str
    r"""The amount of underlying tokens the user currently holds."""

    accounting_asset_balance: OptionalNullable[str] = UNSET
    r"""The amount of accounting assets the user currently holds."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["accounting_asset_balance"]
        nullable_fields = ["accounting_asset_balance"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
