"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .reserve import Reserve, ReserveTypedDict
from compass_api_sdk.types import BaseModel
from compass_api_sdk.utils import validate_const
from enum import Enum
import pydantic
from pydantic.functional_validators import AfterValidator
from typing import Literal
from typing_extensions import Annotated, TypedDict


class Borrowratemode(int, Enum):
    r"""The interest rate mode to borrow: 1 represents stable interest rate mode. 2 represents variable interest rate mode"""

    ONE = 1
    TWO = 2


class BorrowTypedDict(TypedDict):
    id: str
    r"""The id of a historical transaction on aave"""
    timestamp: int
    r"""Timestamp in unix time"""
    tx_hash: str
    r"""Transaction hash. You can paste these into the search bar on etherscan"""
    amount: float
    r"""Quantity of token"""
    borrow_rate_mode: Borrowratemode
    r"""The interest rate mode to borrow: 1 represents stable interest rate mode. 2 represents variable interest rate mode"""
    reserve: ReserveTypedDict
    asset_price_usd: float
    r"""Price of token in USD"""
    block: int
    action: Literal["Borrow"]
    r"""The type of transaction"""


class Borrow(BaseModel):
    id: str
    r"""The id of a historical transaction on aave"""

    timestamp: int
    r"""Timestamp in unix time"""

    tx_hash: Annotated[str, pydantic.Field(alias="txHash")]
    r"""Transaction hash. You can paste these into the search bar on etherscan"""

    amount: float
    r"""Quantity of token"""

    borrow_rate_mode: Annotated[Borrowratemode, pydantic.Field(alias="borrowRateMode")]
    r"""The interest rate mode to borrow: 1 represents stable interest rate mode. 2 represents variable interest rate mode"""

    reserve: Reserve

    asset_price_usd: Annotated[float, pydantic.Field(alias="assetPriceUSD")]
    r"""Price of token in USD"""

    block: int

    ACTION: Annotated[
        Annotated[Literal["Borrow"], AfterValidator(validate_const("Borrow"))],
        pydantic.Field(alias="action"),
    ] = "Borrow"
    r"""The type of transaction"""
