"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .useroperation import UserOperation, UserOperationTypedDict
from compass_api_sdk.types import BaseModel
from enum import Enum
from typing import List, Optional
from typing_extensions import NotRequired, TypedDict


class BatchedUserOperationsRequestChain(str, Enum):
    ARBITRUM = "arbitrum"
    BASE = "base"
    ETHEREUM = "ethereum"


class BatchedUserOperationsRequestTypedDict(TypedDict):
    r"""Request model for batching user operations.

    Used for smart account batching and 5792 batching.
    """

    chain: BatchedUserOperationsRequestChain
    sender: str
    r"""The address of the transaction sender."""
    operations: List[UserOperationTypedDict]
    r"""List of possible user operations"""
    estimate_gas: NotRequired[bool]
    r"""Determines whether to estimate gas costs for transactions, also verifying that the transaction can be successfully executed."""


class BatchedUserOperationsRequest(BaseModel):
    r"""Request model for batching user operations.

    Used for smart account batching and 5792 batching.
    """

    chain: BatchedUserOperationsRequestChain

    sender: str
    r"""The address of the transaction sender."""

    operations: List[UserOperation]
    r"""List of possible user operations"""

    estimate_gas: Optional[bool] = None
    r"""Determines whether to estimate gas costs for transactions, also verifying that the transaction can be successfully executed."""
