"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .compass_api_backend_v2_models_safe_transact_response_batched_safe_operations_eip712domain import (
    CompassAPIBackendV2ModelsSafeTransactResponseBatchedSafeOperationsEip712Domain,
    CompassAPIBackendV2ModelsSafeTransactResponseBatchedSafeOperationsEip712DomainTypedDict,
)
from .compass_api_backend_v2_models_safe_transact_response_batched_safe_operations_eip712types import (
    CompassAPIBackendV2ModelsSafeTransactResponseBatchedSafeOperationsEip712Types,
    CompassAPIBackendV2ModelsSafeTransactResponseBatchedSafeOperationsEip712TypesTypedDict,
)
from .safetxmessage import SafeTxMessage, SafeTxMessageTypedDict
from compass_api_sdk.types import BaseModel
from compass_api_sdk.utils import validate_const
import pydantic
from pydantic.functional_validators import AfterValidator
from typing import Literal
from typing_extensions import Annotated, TypedDict


class BatchedSafeOperationsResponseInputTypedDict(TypedDict):
    r"""Response containing EIP-712 typed data for Safe transaction signing."""

    domain: CompassAPIBackendV2ModelsSafeTransactResponseBatchedSafeOperationsEip712DomainTypedDict
    r"""The EIP-712 domain separator for Safe transactions."""
    types: CompassAPIBackendV2ModelsSafeTransactResponseBatchedSafeOperationsEip712TypesTypedDict
    r"""The type definitions for EIP-712 structured data."""
    message: SafeTxMessageTypedDict
    r"""The message data for a Safe transaction."""
    primary_type: Literal["SafeTx"]
    r"""Primary type for the structured data"""


class BatchedSafeOperationsResponseInput(BaseModel):
    r"""Response containing EIP-712 typed data for Safe transaction signing."""

    domain: (
        CompassAPIBackendV2ModelsSafeTransactResponseBatchedSafeOperationsEip712Domain
    )
    r"""The EIP-712 domain separator for Safe transactions."""

    types: CompassAPIBackendV2ModelsSafeTransactResponseBatchedSafeOperationsEip712Types
    r"""The type definitions for EIP-712 structured data."""

    message: SafeTxMessage
    r"""The message data for a Safe transaction."""

    PRIMARY_TYPE: Annotated[
        Annotated[Literal["SafeTx"], AfterValidator(validate_const("SafeTx"))],
        pydantic.Field(alias="primaryType"),
    ] = "SafeTx"
    r"""Primary type for the structured data"""
