"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from compass_api_sdk.types import BaseModel
from compass_api_sdk.utils import validate_const
from enum import Enum
import pydantic
from pydantic.functional_validators import AfterValidator
from typing import Literal, Optional, Union
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict


AerodromeSlipstreamWithdrawLiquidityProvisionRequestPercentageForWithdrawalTypedDict = TypeAliasType(
    "AerodromeSlipstreamWithdrawLiquidityProvisionRequestPercentageForWithdrawalTypedDict",
    Union[float, str],
)
r"""How much liquidity to take out in percentage."""


AerodromeSlipstreamWithdrawLiquidityProvisionRequestPercentageForWithdrawal = (
    TypeAliasType(
        "AerodromeSlipstreamWithdrawLiquidityProvisionRequestPercentageForWithdrawal",
        Union[float, str],
    )
)
r"""How much liquidity to take out in percentage."""


class AerodromeSlipstreamWithdrawLiquidityProvisionRequestChain(str, Enum):
    BASE = "base"


class AerodromeSlipstreamWithdrawLiquidityProvisionRequestTypedDict(TypedDict):
    token_id: int
    r"""Token ID of the NFT representing the liquidity provisioned position."""
    percentage_for_withdrawal: AerodromeSlipstreamWithdrawLiquidityProvisionRequestPercentageForWithdrawalTypedDict
    r"""How much liquidity to take out in percentage."""
    chain: AerodromeSlipstreamWithdrawLiquidityProvisionRequestChain
    sender: str
    r"""The address of the transaction sender."""
    action_type: Literal["AERODROME_SLIPSTREAM_WITHDRAW_LIQUIDITY_PROVISION"]
    estimate_gas: NotRequired[bool]
    r"""Determines whether to estimate gas costs for transactions, also verifying that the transaction can be successfully executed."""


class AerodromeSlipstreamWithdrawLiquidityProvisionRequest(BaseModel):
    token_id: int
    r"""Token ID of the NFT representing the liquidity provisioned position."""

    percentage_for_withdrawal: (
        AerodromeSlipstreamWithdrawLiquidityProvisionRequestPercentageForWithdrawal
    )
    r"""How much liquidity to take out in percentage."""

    chain: AerodromeSlipstreamWithdrawLiquidityProvisionRequestChain

    sender: str
    r"""The address of the transaction sender."""

    ACTION_TYPE: Annotated[
        Annotated[
            Optional[Literal["AERODROME_SLIPSTREAM_WITHDRAW_LIQUIDITY_PROVISION"]],
            AfterValidator(
                validate_const("AERODROME_SLIPSTREAM_WITHDRAW_LIQUIDITY_PROVISION")
            ),
        ],
        pydantic.Field(alias="action_type"),
    ] = "AERODROME_SLIPSTREAM_WITHDRAW_LIQUIDITY_PROVISION"

    estimate_gas: Optional[bool] = None
    r"""Determines whether to estimate gas costs for transactions, also verifying that the transaction can be successfully executed."""
