"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from compass_api_sdk.types import BaseModel
from compass_api_sdk.utils import validate_const
from enum import Enum
import pydantic
from pydantic.functional_validators import AfterValidator
from typing import Literal, Optional, Union
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict


AerodromeSlipstreamSellExactlyRequestAmountInTypedDict = TypeAliasType(
    "AerodromeSlipstreamSellExactlyRequestAmountInTypedDict", Union[float, str]
)
r"""The amount of the token to swap from"""


AerodromeSlipstreamSellExactlyRequestAmountIn = TypeAliasType(
    "AerodromeSlipstreamSellExactlyRequestAmountIn", Union[float, str]
)
r"""The amount of the token to swap from"""


AerodromeSlipstreamSellExactlyRequestAmountOutMinimumTypedDict = TypeAliasType(
    "AerodromeSlipstreamSellExactlyRequestAmountOutMinimumTypedDict", Union[float, str]
)
r"""The minimum amount of the token to swap to, defaults to 0"""


AerodromeSlipstreamSellExactlyRequestAmountOutMinimum = TypeAliasType(
    "AerodromeSlipstreamSellExactlyRequestAmountOutMinimum", Union[float, str]
)
r"""The minimum amount of the token to swap to, defaults to 0"""


class AerodromeSlipstreamSellExactlyRequestChain(str, Enum):
    BASE = "base"


class AerodromeSlipstreamSellExactlyRequestTypedDict(TypedDict):
    r"""Request model for selling exactly an amount of tokens."""

    token_in: str
    r"""The symbol or address of the token to swap from."""
    token_out: str
    r"""The symbol or address of the token to swap to."""
    tick_spacing: int
    r"""The tick spacing of the pool"""
    amount_in: AerodromeSlipstreamSellExactlyRequestAmountInTypedDict
    r"""The amount of the token to swap from"""
    chain: AerodromeSlipstreamSellExactlyRequestChain
    sender: str
    r"""The address of the transaction sender."""
    action_type: Literal["AERODROME_SLIPSTREAM_SELL_EXACTLY"]
    amount_out_minimum: NotRequired[
        AerodromeSlipstreamSellExactlyRequestAmountOutMinimumTypedDict
    ]
    r"""The minimum amount of the token to swap to, defaults to 0"""
    estimate_gas: NotRequired[bool]
    r"""Determines whether to estimate gas costs for transactions, also verifying that the transaction can be successfully executed."""


class AerodromeSlipstreamSellExactlyRequest(BaseModel):
    r"""Request model for selling exactly an amount of tokens."""

    token_in: str
    r"""The symbol or address of the token to swap from."""

    token_out: str
    r"""The symbol or address of the token to swap to."""

    tick_spacing: int
    r"""The tick spacing of the pool"""

    amount_in: AerodromeSlipstreamSellExactlyRequestAmountIn
    r"""The amount of the token to swap from"""

    chain: AerodromeSlipstreamSellExactlyRequestChain

    sender: str
    r"""The address of the transaction sender."""

    ACTION_TYPE: Annotated[
        Annotated[
            Optional[Literal["AERODROME_SLIPSTREAM_SELL_EXACTLY"]],
            AfterValidator(validate_const("AERODROME_SLIPSTREAM_SELL_EXACTLY")),
        ],
        pydantic.Field(alias="action_type"),
    ] = "AERODROME_SLIPSTREAM_SELL_EXACTLY"

    amount_out_minimum: Optional[
        AerodromeSlipstreamSellExactlyRequestAmountOutMinimum
    ] = None
    r"""The minimum amount of the token to swap to, defaults to 0"""

    estimate_gas: Optional[bool] = None
    r"""Determines whether to estimate gas costs for transactions, also verifying that the transaction can be successfully executed."""
