"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from compass_api_sdk.types import BaseModel
from compass_api_sdk.utils import validate_const
import pydantic
from pydantic.functional_validators import AfterValidator
from typing import Literal, Optional, Union
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict


AerodromeSlipstreamSellExactlyParamsAmountInTypedDict = TypeAliasType(
    "AerodromeSlipstreamSellExactlyParamsAmountInTypedDict", Union[float, str]
)
r"""The amount of the token to swap from"""


AerodromeSlipstreamSellExactlyParamsAmountIn = TypeAliasType(
    "AerodromeSlipstreamSellExactlyParamsAmountIn", Union[float, str]
)
r"""The amount of the token to swap from"""


AerodromeSlipstreamSellExactlyParamsAmountOutMinimumTypedDict = TypeAliasType(
    "AerodromeSlipstreamSellExactlyParamsAmountOutMinimumTypedDict", Union[float, str]
)
r"""The minimum amount of the token to swap to, defaults to 0"""


AerodromeSlipstreamSellExactlyParamsAmountOutMinimum = TypeAliasType(
    "AerodromeSlipstreamSellExactlyParamsAmountOutMinimum", Union[float, str]
)
r"""The minimum amount of the token to swap to, defaults to 0"""


class AerodromeSlipstreamSellExactlyParamsTypedDict(TypedDict):
    r"""Parameters model for selling exactly an amount of tokens."""

    token_in: str
    r"""The symbol or address of the token to swap from."""
    token_out: str
    r"""The symbol or address of the token to swap to."""
    tick_spacing: int
    r"""The tick spacing of the pool"""
    amount_in: AerodromeSlipstreamSellExactlyParamsAmountInTypedDict
    r"""The amount of the token to swap from"""
    action_type: Literal["AERODROME_SLIPSTREAM_SELL_EXACTLY"]
    amount_out_minimum: NotRequired[
        AerodromeSlipstreamSellExactlyParamsAmountOutMinimumTypedDict
    ]
    r"""The minimum amount of the token to swap to, defaults to 0"""


class AerodromeSlipstreamSellExactlyParams(BaseModel):
    r"""Parameters model for selling exactly an amount of tokens."""

    token_in: str
    r"""The symbol or address of the token to swap from."""

    token_out: str
    r"""The symbol or address of the token to swap to."""

    tick_spacing: int
    r"""The tick spacing of the pool"""

    amount_in: AerodromeSlipstreamSellExactlyParamsAmountIn
    r"""The amount of the token to swap from"""

    ACTION_TYPE: Annotated[
        Annotated[
            Optional[Literal["AERODROME_SLIPSTREAM_SELL_EXACTLY"]],
            AfterValidator(validate_const("AERODROME_SLIPSTREAM_SELL_EXACTLY")),
        ],
        pydantic.Field(alias="action_type"),
    ] = "AERODROME_SLIPSTREAM_SELL_EXACTLY"

    amount_out_minimum: Optional[
        AerodromeSlipstreamSellExactlyParamsAmountOutMinimum
    ] = None
    r"""The minimum amount of the token to swap to, defaults to 0"""
