"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from compass_api_sdk.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from compass_api_sdk.utils import validate_const
from enum import Enum
import pydantic
from pydantic import model_serializer
from pydantic.functional_validators import AfterValidator
from typing import Literal, Optional, Union
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict


AerodromeSlipstreamMintLiquidityProvisionRequestAmount0DesiredTypedDict = TypeAliasType(
    "AerodromeSlipstreamMintLiquidityProvisionRequestAmount0DesiredTypedDict",
    Union[float, str],
)
r"""The desired amount of the first token to deposit"""


AerodromeSlipstreamMintLiquidityProvisionRequestAmount0Desired = TypeAliasType(
    "AerodromeSlipstreamMintLiquidityProvisionRequestAmount0Desired", Union[float, str]
)
r"""The desired amount of the first token to deposit"""


AerodromeSlipstreamMintLiquidityProvisionRequestAmount1DesiredTypedDict = TypeAliasType(
    "AerodromeSlipstreamMintLiquidityProvisionRequestAmount1DesiredTypedDict",
    Union[float, str],
)
r"""The desired amount of the second token to deposit"""


AerodromeSlipstreamMintLiquidityProvisionRequestAmount1Desired = TypeAliasType(
    "AerodromeSlipstreamMintLiquidityProvisionRequestAmount1Desired", Union[float, str]
)
r"""The desired amount of the second token to deposit"""


AerodromeSlipstreamMintLiquidityProvisionRequestAmount0MinTypedDict = TypeAliasType(
    "AerodromeSlipstreamMintLiquidityProvisionRequestAmount0MinTypedDict",
    Union[float, str],
)
r"""The minimum amount of the first token to deposit"""


AerodromeSlipstreamMintLiquidityProvisionRequestAmount0Min = TypeAliasType(
    "AerodromeSlipstreamMintLiquidityProvisionRequestAmount0Min", Union[float, str]
)
r"""The minimum amount of the first token to deposit"""


AerodromeSlipstreamMintLiquidityProvisionRequestAmount1MinTypedDict = TypeAliasType(
    "AerodromeSlipstreamMintLiquidityProvisionRequestAmount1MinTypedDict",
    Union[float, str],
)
r"""The minimum amount of the second token to deposit"""


AerodromeSlipstreamMintLiquidityProvisionRequestAmount1Min = TypeAliasType(
    "AerodromeSlipstreamMintLiquidityProvisionRequestAmount1Min", Union[float, str]
)
r"""The minimum amount of the second token to deposit"""


class AerodromeSlipstreamMintLiquidityProvisionRequestChain(str, Enum):
    BASE = "base"


class AerodromeSlipstreamMintLiquidityProvisionRequestTypedDict(TypedDict):
    r"""Request model for minting a new liquidity position."""

    token0: str
    r"""The symbol or address of the first token in the pair."""
    token1: str
    r"""The symbol or address of the second token in the pair."""
    tick_spacing: int
    r"""The tick spacing of the pool"""
    tick_lower: int
    r"""The lower tick of the range to mint the position in"""
    tick_upper: int
    r"""The upper tick of the range to mint the position in"""
    amount0_desired: (
        AerodromeSlipstreamMintLiquidityProvisionRequestAmount0DesiredTypedDict
    )
    r"""The desired amount of the first token to deposit"""
    amount1_desired: (
        AerodromeSlipstreamMintLiquidityProvisionRequestAmount1DesiredTypedDict
    )
    r"""The desired amount of the second token to deposit"""
    amount0_min: AerodromeSlipstreamMintLiquidityProvisionRequestAmount0MinTypedDict
    r"""The minimum amount of the first token to deposit"""
    amount1_min: AerodromeSlipstreamMintLiquidityProvisionRequestAmount1MinTypedDict
    r"""The minimum amount of the second token to deposit"""
    chain: AerodromeSlipstreamMintLiquidityProvisionRequestChain
    sender: str
    r"""The address of the transaction sender."""
    action_type: Literal["AERODROME_SLIPSTREAM_MINT_LIQUIDITY_PROVISION"]
    recipient: NotRequired[Nullable[str]]
    r"""The address that will receive the LP tokens"""
    estimate_gas: NotRequired[bool]
    r"""Determines whether to estimate gas costs for transactions, also verifying that the transaction can be successfully executed."""


class AerodromeSlipstreamMintLiquidityProvisionRequest(BaseModel):
    r"""Request model for minting a new liquidity position."""

    token0: str
    r"""The symbol or address of the first token in the pair."""

    token1: str
    r"""The symbol or address of the second token in the pair."""

    tick_spacing: int
    r"""The tick spacing of the pool"""

    tick_lower: int
    r"""The lower tick of the range to mint the position in"""

    tick_upper: int
    r"""The upper tick of the range to mint the position in"""

    amount0_desired: AerodromeSlipstreamMintLiquidityProvisionRequestAmount0Desired
    r"""The desired amount of the first token to deposit"""

    amount1_desired: AerodromeSlipstreamMintLiquidityProvisionRequestAmount1Desired
    r"""The desired amount of the second token to deposit"""

    amount0_min: AerodromeSlipstreamMintLiquidityProvisionRequestAmount0Min
    r"""The minimum amount of the first token to deposit"""

    amount1_min: AerodromeSlipstreamMintLiquidityProvisionRequestAmount1Min
    r"""The minimum amount of the second token to deposit"""

    chain: AerodromeSlipstreamMintLiquidityProvisionRequestChain

    sender: str
    r"""The address of the transaction sender."""

    ACTION_TYPE: Annotated[
        Annotated[
            Optional[Literal["AERODROME_SLIPSTREAM_MINT_LIQUIDITY_PROVISION"]],
            AfterValidator(
                validate_const("AERODROME_SLIPSTREAM_MINT_LIQUIDITY_PROVISION")
            ),
        ],
        pydantic.Field(alias="action_type"),
    ] = "AERODROME_SLIPSTREAM_MINT_LIQUIDITY_PROVISION"

    recipient: OptionalNullable[str] = UNSET
    r"""The address that will receive the LP tokens"""

    estimate_gas: Optional[bool] = None
    r"""Determines whether to estimate gas costs for transactions, also verifying that the transaction can be successfully executed."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["action_type", "recipient", "estimate_gas"]
        nullable_fields = ["recipient"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
