"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from compass_api_sdk.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from compass_api_sdk.utils import validate_const
import pydantic
from pydantic import model_serializer
from pydantic.functional_validators import AfterValidator
from typing import Literal, Optional, Union
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict


AerodromeSlipstreamMintLiquidityProvisionParamsAmount0DesiredTypedDict = TypeAliasType(
    "AerodromeSlipstreamMintLiquidityProvisionParamsAmount0DesiredTypedDict",
    Union[float, str],
)
r"""The desired amount of the first token to deposit"""


AerodromeSlipstreamMintLiquidityProvisionParamsAmount0Desired = TypeAliasType(
    "AerodromeSlipstreamMintLiquidityProvisionParamsAmount0Desired", Union[float, str]
)
r"""The desired amount of the first token to deposit"""


AerodromeSlipstreamMintLiquidityProvisionParamsAmount1DesiredTypedDict = TypeAliasType(
    "AerodromeSlipstreamMintLiquidityProvisionParamsAmount1DesiredTypedDict",
    Union[float, str],
)
r"""The desired amount of the second token to deposit"""


AerodromeSlipstreamMintLiquidityProvisionParamsAmount1Desired = TypeAliasType(
    "AerodromeSlipstreamMintLiquidityProvisionParamsAmount1Desired", Union[float, str]
)
r"""The desired amount of the second token to deposit"""


AerodromeSlipstreamMintLiquidityProvisionParamsAmount0MinTypedDict = TypeAliasType(
    "AerodromeSlipstreamMintLiquidityProvisionParamsAmount0MinTypedDict",
    Union[float, str],
)
r"""The minimum amount of the first token to deposit"""


AerodromeSlipstreamMintLiquidityProvisionParamsAmount0Min = TypeAliasType(
    "AerodromeSlipstreamMintLiquidityProvisionParamsAmount0Min", Union[float, str]
)
r"""The minimum amount of the first token to deposit"""


AerodromeSlipstreamMintLiquidityProvisionParamsAmount1MinTypedDict = TypeAliasType(
    "AerodromeSlipstreamMintLiquidityProvisionParamsAmount1MinTypedDict",
    Union[float, str],
)
r"""The minimum amount of the second token to deposit"""


AerodromeSlipstreamMintLiquidityProvisionParamsAmount1Min = TypeAliasType(
    "AerodromeSlipstreamMintLiquidityProvisionParamsAmount1Min", Union[float, str]
)
r"""The minimum amount of the second token to deposit"""


class AerodromeSlipstreamMintLiquidityProvisionParamsTypedDict(TypedDict):
    r"""Parameters model for minting a new liquidity position."""

    token0: str
    r"""The symbol or address of the first token in the pair."""
    token1: str
    r"""The symbol or address of the second token in the pair."""
    tick_spacing: int
    r"""The tick spacing of the pool"""
    tick_lower: int
    r"""The lower tick of the range to mint the position in"""
    tick_upper: int
    r"""The upper tick of the range to mint the position in"""
    amount0_desired: (
        AerodromeSlipstreamMintLiquidityProvisionParamsAmount0DesiredTypedDict
    )
    r"""The desired amount of the first token to deposit"""
    amount1_desired: (
        AerodromeSlipstreamMintLiquidityProvisionParamsAmount1DesiredTypedDict
    )
    r"""The desired amount of the second token to deposit"""
    amount0_min: AerodromeSlipstreamMintLiquidityProvisionParamsAmount0MinTypedDict
    r"""The minimum amount of the first token to deposit"""
    amount1_min: AerodromeSlipstreamMintLiquidityProvisionParamsAmount1MinTypedDict
    r"""The minimum amount of the second token to deposit"""
    action_type: Literal["AERODROME_SLIPSTREAM_MINT_LIQUIDITY_PROVISION"]
    recipient: NotRequired[Nullable[str]]
    r"""The address that will receive the LP tokens"""


class AerodromeSlipstreamMintLiquidityProvisionParams(BaseModel):
    r"""Parameters model for minting a new liquidity position."""

    token0: str
    r"""The symbol or address of the first token in the pair."""

    token1: str
    r"""The symbol or address of the second token in the pair."""

    tick_spacing: int
    r"""The tick spacing of the pool"""

    tick_lower: int
    r"""The lower tick of the range to mint the position in"""

    tick_upper: int
    r"""The upper tick of the range to mint the position in"""

    amount0_desired: AerodromeSlipstreamMintLiquidityProvisionParamsAmount0Desired
    r"""The desired amount of the first token to deposit"""

    amount1_desired: AerodromeSlipstreamMintLiquidityProvisionParamsAmount1Desired
    r"""The desired amount of the second token to deposit"""

    amount0_min: AerodromeSlipstreamMintLiquidityProvisionParamsAmount0Min
    r"""The minimum amount of the first token to deposit"""

    amount1_min: AerodromeSlipstreamMintLiquidityProvisionParamsAmount1Min
    r"""The minimum amount of the second token to deposit"""

    ACTION_TYPE: Annotated[
        Annotated[
            Optional[Literal["AERODROME_SLIPSTREAM_MINT_LIQUIDITY_PROVISION"]],
            AfterValidator(
                validate_const("AERODROME_SLIPSTREAM_MINT_LIQUIDITY_PROVISION")
            ),
        ],
        pydantic.Field(alias="action_type"),
    ] = "AERODROME_SLIPSTREAM_MINT_LIQUIDITY_PROVISION"

    recipient: OptionalNullable[str] = UNSET
    r"""The address that will receive the LP tokens"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["action_type", "recipient"]
        nullable_fields = ["recipient"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
