"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from compass_api_sdk.types import BaseModel
from compass_api_sdk.utils import validate_const
from enum import Enum
import pydantic
from pydantic.functional_validators import AfterValidator
from typing import Literal, Optional, Union
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict


AerodromeSlipstreamIncreaseLiquidityProvisionRequestAmount0DesiredTypedDict = (
    TypeAliasType(
        "AerodromeSlipstreamIncreaseLiquidityProvisionRequestAmount0DesiredTypedDict",
        Union[float, str],
    )
)
r"""The desired amount of the first token to deposit"""


AerodromeSlipstreamIncreaseLiquidityProvisionRequestAmount0Desired = TypeAliasType(
    "AerodromeSlipstreamIncreaseLiquidityProvisionRequestAmount0Desired",
    Union[float, str],
)
r"""The desired amount of the first token to deposit"""


AerodromeSlipstreamIncreaseLiquidityProvisionRequestAmount1DesiredTypedDict = (
    TypeAliasType(
        "AerodromeSlipstreamIncreaseLiquidityProvisionRequestAmount1DesiredTypedDict",
        Union[float, str],
    )
)
r"""The desired amount of the second token to deposit"""


AerodromeSlipstreamIncreaseLiquidityProvisionRequestAmount1Desired = TypeAliasType(
    "AerodromeSlipstreamIncreaseLiquidityProvisionRequestAmount1Desired",
    Union[float, str],
)
r"""The desired amount of the second token to deposit"""


AerodromeSlipstreamIncreaseLiquidityProvisionRequestAmount0MinTypedDict = TypeAliasType(
    "AerodromeSlipstreamIncreaseLiquidityProvisionRequestAmount0MinTypedDict",
    Union[float, str],
)
r"""The minimum amount of the first token to deposit"""


AerodromeSlipstreamIncreaseLiquidityProvisionRequestAmount0Min = TypeAliasType(
    "AerodromeSlipstreamIncreaseLiquidityProvisionRequestAmount0Min", Union[float, str]
)
r"""The minimum amount of the first token to deposit"""


AerodromeSlipstreamIncreaseLiquidityProvisionRequestAmount1MinTypedDict = TypeAliasType(
    "AerodromeSlipstreamIncreaseLiquidityProvisionRequestAmount1MinTypedDict",
    Union[float, str],
)
r"""The minimum amount of the second token to deposit"""


AerodromeSlipstreamIncreaseLiquidityProvisionRequestAmount1Min = TypeAliasType(
    "AerodromeSlipstreamIncreaseLiquidityProvisionRequestAmount1Min", Union[float, str]
)
r"""The minimum amount of the second token to deposit"""


class AerodromeSlipstreamIncreaseLiquidityProvisionRequestChain(str, Enum):
    BASE = "base"


class AerodromeSlipstreamIncreaseLiquidityProvisionRequestTypedDict(TypedDict):
    token_id: int
    r"""Token ID of the NFT representing the liquidity provisioned position."""
    amount0_desired: (
        AerodromeSlipstreamIncreaseLiquidityProvisionRequestAmount0DesiredTypedDict
    )
    r"""The desired amount of the first token to deposit"""
    amount1_desired: (
        AerodromeSlipstreamIncreaseLiquidityProvisionRequestAmount1DesiredTypedDict
    )
    r"""The desired amount of the second token to deposit"""
    amount0_min: AerodromeSlipstreamIncreaseLiquidityProvisionRequestAmount0MinTypedDict
    r"""The minimum amount of the first token to deposit"""
    amount1_min: AerodromeSlipstreamIncreaseLiquidityProvisionRequestAmount1MinTypedDict
    r"""The minimum amount of the second token to deposit"""
    chain: AerodromeSlipstreamIncreaseLiquidityProvisionRequestChain
    sender: str
    r"""The address of the transaction sender."""
    action_type: Literal["AERODROME_SLIPSTREAM_INCREASE_LIQUIDITY_PROVISION"]
    estimate_gas: NotRequired[bool]
    r"""Determines whether to estimate gas costs for transactions, also verifying that the transaction can be successfully executed."""


class AerodromeSlipstreamIncreaseLiquidityProvisionRequest(BaseModel):
    token_id: int
    r"""Token ID of the NFT representing the liquidity provisioned position."""

    amount0_desired: AerodromeSlipstreamIncreaseLiquidityProvisionRequestAmount0Desired
    r"""The desired amount of the first token to deposit"""

    amount1_desired: AerodromeSlipstreamIncreaseLiquidityProvisionRequestAmount1Desired
    r"""The desired amount of the second token to deposit"""

    amount0_min: AerodromeSlipstreamIncreaseLiquidityProvisionRequestAmount0Min
    r"""The minimum amount of the first token to deposit"""

    amount1_min: AerodromeSlipstreamIncreaseLiquidityProvisionRequestAmount1Min
    r"""The minimum amount of the second token to deposit"""

    chain: AerodromeSlipstreamIncreaseLiquidityProvisionRequestChain

    sender: str
    r"""The address of the transaction sender."""

    ACTION_TYPE: Annotated[
        Annotated[
            Optional[Literal["AERODROME_SLIPSTREAM_INCREASE_LIQUIDITY_PROVISION"]],
            AfterValidator(
                validate_const("AERODROME_SLIPSTREAM_INCREASE_LIQUIDITY_PROVISION")
            ),
        ],
        pydantic.Field(alias="action_type"),
    ] = "AERODROME_SLIPSTREAM_INCREASE_LIQUIDITY_PROVISION"

    estimate_gas: Optional[bool] = None
    r"""Determines whether to estimate gas costs for transactions, also verifying that the transaction can be successfully executed."""
