"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from compass_api_sdk.types import BaseModel
from compass_api_sdk.utils import validate_const
import pydantic
from pydantic.functional_validators import AfterValidator
from typing import Literal, Optional, Union
from typing_extensions import Annotated, TypeAliasType, TypedDict


AerodromeSlipstreamIncreaseLiquidityProvisionParamsAmount0DesiredTypedDict = (
    TypeAliasType(
        "AerodromeSlipstreamIncreaseLiquidityProvisionParamsAmount0DesiredTypedDict",
        Union[float, str],
    )
)
r"""The desired amount of the first token to deposit"""


AerodromeSlipstreamIncreaseLiquidityProvisionParamsAmount0Desired = TypeAliasType(
    "AerodromeSlipstreamIncreaseLiquidityProvisionParamsAmount0Desired",
    Union[float, str],
)
r"""The desired amount of the first token to deposit"""


AerodromeSlipstreamIncreaseLiquidityProvisionParamsAmount1DesiredTypedDict = (
    TypeAliasType(
        "AerodromeSlipstreamIncreaseLiquidityProvisionParamsAmount1DesiredTypedDict",
        Union[float, str],
    )
)
r"""The desired amount of the second token to deposit"""


AerodromeSlipstreamIncreaseLiquidityProvisionParamsAmount1Desired = TypeAliasType(
    "AerodromeSlipstreamIncreaseLiquidityProvisionParamsAmount1Desired",
    Union[float, str],
)
r"""The desired amount of the second token to deposit"""


AerodromeSlipstreamIncreaseLiquidityProvisionParamsAmount0MinTypedDict = TypeAliasType(
    "AerodromeSlipstreamIncreaseLiquidityProvisionParamsAmount0MinTypedDict",
    Union[float, str],
)
r"""The minimum amount of the first token to deposit"""


AerodromeSlipstreamIncreaseLiquidityProvisionParamsAmount0Min = TypeAliasType(
    "AerodromeSlipstreamIncreaseLiquidityProvisionParamsAmount0Min", Union[float, str]
)
r"""The minimum amount of the first token to deposit"""


AerodromeSlipstreamIncreaseLiquidityProvisionParamsAmount1MinTypedDict = TypeAliasType(
    "AerodromeSlipstreamIncreaseLiquidityProvisionParamsAmount1MinTypedDict",
    Union[float, str],
)
r"""The minimum amount of the second token to deposit"""


AerodromeSlipstreamIncreaseLiquidityProvisionParamsAmount1Min = TypeAliasType(
    "AerodromeSlipstreamIncreaseLiquidityProvisionParamsAmount1Min", Union[float, str]
)
r"""The minimum amount of the second token to deposit"""


class AerodromeSlipstreamIncreaseLiquidityProvisionParamsTypedDict(TypedDict):
    r"""Endpoint parameters for increasing liquidity provision on aerodrome slipstream.

    This action is performed on the NonfungiblePosition Manager to increase the
    liquidity of an existing position.
    """

    token_id: int
    r"""Token ID of the NFT representing the liquidity provisioned position."""
    amount0_desired: (
        AerodromeSlipstreamIncreaseLiquidityProvisionParamsAmount0DesiredTypedDict
    )
    r"""The desired amount of the first token to deposit"""
    amount1_desired: (
        AerodromeSlipstreamIncreaseLiquidityProvisionParamsAmount1DesiredTypedDict
    )
    r"""The desired amount of the second token to deposit"""
    amount0_min: AerodromeSlipstreamIncreaseLiquidityProvisionParamsAmount0MinTypedDict
    r"""The minimum amount of the first token to deposit"""
    amount1_min: AerodromeSlipstreamIncreaseLiquidityProvisionParamsAmount1MinTypedDict
    r"""The minimum amount of the second token to deposit"""
    action_type: Literal["AERODROME_SLIPSTREAM_INCREASE_LIQUIDITY_PROVISION"]


class AerodromeSlipstreamIncreaseLiquidityProvisionParams(BaseModel):
    r"""Endpoint parameters for increasing liquidity provision on aerodrome slipstream.

    This action is performed on the NonfungiblePosition Manager to increase the
    liquidity of an existing position.
    """

    token_id: int
    r"""Token ID of the NFT representing the liquidity provisioned position."""

    amount0_desired: AerodromeSlipstreamIncreaseLiquidityProvisionParamsAmount0Desired
    r"""The desired amount of the first token to deposit"""

    amount1_desired: AerodromeSlipstreamIncreaseLiquidityProvisionParamsAmount1Desired
    r"""The desired amount of the second token to deposit"""

    amount0_min: AerodromeSlipstreamIncreaseLiquidityProvisionParamsAmount0Min
    r"""The minimum amount of the first token to deposit"""

    amount1_min: AerodromeSlipstreamIncreaseLiquidityProvisionParamsAmount1Min
    r"""The minimum amount of the second token to deposit"""

    ACTION_TYPE: Annotated[
        Annotated[
            Optional[Literal["AERODROME_SLIPSTREAM_INCREASE_LIQUIDITY_PROVISION"]],
            AfterValidator(
                validate_const("AERODROME_SLIPSTREAM_INCREASE_LIQUIDITY_PROVISION")
            ),
        ],
        pydantic.Field(alias="action_type"),
    ] = "AERODROME_SLIPSTREAM_INCREASE_LIQUIDITY_PROVISION"
