"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from compass_api_sdk.types import BaseModel
from compass_api_sdk.utils import validate_const
from enum import Enum
import pydantic
from pydantic.functional_validators import AfterValidator
from typing import Literal, Optional, Union
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict


AerodromeSlipstreamBuyExactlyRequestAmountOutTypedDict = TypeAliasType(
    "AerodromeSlipstreamBuyExactlyRequestAmountOutTypedDict", Union[float, str]
)
r"""The amount of the token to swap to"""


AerodromeSlipstreamBuyExactlyRequestAmountOut = TypeAliasType(
    "AerodromeSlipstreamBuyExactlyRequestAmountOut", Union[float, str]
)
r"""The amount of the token to swap to"""


AerodromeSlipstreamBuyExactlyRequestAmountInMaximumTypedDict = TypeAliasType(
    "AerodromeSlipstreamBuyExactlyRequestAmountInMaximumTypedDict", Union[float, str]
)
r"""The maximum amount of the token to swap from"""


AerodromeSlipstreamBuyExactlyRequestAmountInMaximum = TypeAliasType(
    "AerodromeSlipstreamBuyExactlyRequestAmountInMaximum", Union[float, str]
)
r"""The maximum amount of the token to swap from"""


class AerodromeSlipstreamBuyExactlyRequestChain(str, Enum):
    BASE = "base"


class AerodromeSlipstreamBuyExactlyRequestTypedDict(TypedDict):
    r"""Request model for buying exactly an amount of tokens."""

    token_in: str
    r"""The symbol of the token to swap from."""
    token_out: str
    r"""The symbol of the token to swap to."""
    tick_spacing: int
    r"""The tick spacing of the pool"""
    amount_out: AerodromeSlipstreamBuyExactlyRequestAmountOutTypedDict
    r"""The amount of the token to swap to"""
    amount_in_maximum: AerodromeSlipstreamBuyExactlyRequestAmountInMaximumTypedDict
    r"""The maximum amount of the token to swap from"""
    chain: AerodromeSlipstreamBuyExactlyRequestChain
    sender: str
    r"""The address of the transaction sender."""
    action_type: Literal["AERODROME_SLIPSTREAM_BUY_EXACTLY"]
    estimate_gas: NotRequired[bool]
    r"""Determines whether to estimate gas costs for transactions, also verifying that the transaction can be successfully executed."""


class AerodromeSlipstreamBuyExactlyRequest(BaseModel):
    r"""Request model for buying exactly an amount of tokens."""

    token_in: str
    r"""The symbol of the token to swap from."""

    token_out: str
    r"""The symbol of the token to swap to."""

    tick_spacing: int
    r"""The tick spacing of the pool"""

    amount_out: AerodromeSlipstreamBuyExactlyRequestAmountOut
    r"""The amount of the token to swap to"""

    amount_in_maximum: AerodromeSlipstreamBuyExactlyRequestAmountInMaximum
    r"""The maximum amount of the token to swap from"""

    chain: AerodromeSlipstreamBuyExactlyRequestChain

    sender: str
    r"""The address of the transaction sender."""

    ACTION_TYPE: Annotated[
        Annotated[
            Optional[Literal["AERODROME_SLIPSTREAM_BUY_EXACTLY"]],
            AfterValidator(validate_const("AERODROME_SLIPSTREAM_BUY_EXACTLY")),
        ],
        pydantic.Field(alias="action_type"),
    ] = "AERODROME_SLIPSTREAM_BUY_EXACTLY"

    estimate_gas: Optional[bool] = None
    r"""Determines whether to estimate gas costs for transactions, also verifying that the transaction can be successfully executed."""
