"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from compass_api_sdk.types import BaseModel
from compass_api_sdk.utils import validate_const
from enum import Enum
import pydantic
from pydantic.functional_validators import AfterValidator
from typing import Literal, Optional, Union
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict


AaveWithdrawRequestAmountTypedDict = TypeAliasType(
    "AaveWithdrawRequestAmountTypedDict", Union[float, str]
)
r"""The amount of the asset to withdraw"""


AaveWithdrawRequestAmount = TypeAliasType(
    "AaveWithdrawRequestAmount", Union[float, str]
)
r"""The amount of the asset to withdraw"""


class AaveWithdrawRequestChain(str, Enum):
    ARBITRUM = "arbitrum"
    BASE = "base"
    ETHEREUM = "ethereum"


class AaveWithdrawRequestTypedDict(TypedDict):
    token: str
    r"""The symbol of the underlying asset to withdraw.."""
    amount: AaveWithdrawRequestAmountTypedDict
    r"""The amount of the asset to withdraw"""
    recipient: str
    r"""The address of the recipient of the withdrawn funds."""
    chain: AaveWithdrawRequestChain
    sender: str
    r"""The address of the transaction sender."""
    action_type: Literal["AAVE_WITHDRAW"]
    estimate_gas: NotRequired[bool]
    r"""Determines whether to estimate gas costs for transactions, also verifying that the transaction can be successfully executed."""


class AaveWithdrawRequest(BaseModel):
    token: str
    r"""The symbol of the underlying asset to withdraw.."""

    amount: AaveWithdrawRequestAmount
    r"""The amount of the asset to withdraw"""

    recipient: str
    r"""The address of the recipient of the withdrawn funds."""

    chain: AaveWithdrawRequestChain

    sender: str
    r"""The address of the transaction sender."""

    ACTION_TYPE: Annotated[
        Annotated[
            Optional[Literal["AAVE_WITHDRAW"]],
            AfterValidator(validate_const("AAVE_WITHDRAW")),
        ],
        pydantic.Field(alias="action_type"),
    ] = "AAVE_WITHDRAW"

    estimate_gas: Optional[bool] = None
    r"""Determines whether to estimate gas costs for transactions, also verifying that the transaction can be successfully executed."""
