"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from compass_api_sdk.types import BaseModel
from compass_api_sdk.utils import validate_const
import pydantic
from pydantic.functional_validators import AfterValidator
from typing import Literal, Optional, Union
from typing_extensions import Annotated, TypeAliasType, TypedDict


AaveWithdrawParamsAmountTypedDict = TypeAliasType(
    "AaveWithdrawParamsAmountTypedDict", Union[float, str]
)
r"""The amount of the asset to withdraw"""


AaveWithdrawParamsAmount = TypeAliasType("AaveWithdrawParamsAmount", Union[float, str])
r"""The amount of the asset to withdraw"""


class AaveWithdrawParamsTypedDict(TypedDict):
    token: str
    r"""The symbol of the underlying asset to withdraw.."""
    amount: AaveWithdrawParamsAmountTypedDict
    r"""The amount of the asset to withdraw"""
    recipient: str
    r"""The address of the recipient of the withdrawn funds."""
    action_type: Literal["AAVE_WITHDRAW"]


class AaveWithdrawParams(BaseModel):
    token: str
    r"""The symbol of the underlying asset to withdraw.."""

    amount: AaveWithdrawParamsAmount
    r"""The amount of the asset to withdraw"""

    recipient: str
    r"""The address of the recipient of the withdrawn funds."""

    ACTION_TYPE: Annotated[
        Annotated[
            Optional[Literal["AAVE_WITHDRAW"]],
            AfterValidator(validate_const("AAVE_WITHDRAW")),
        ],
        pydantic.Field(alias="action_type"),
    ] = "AAVE_WITHDRAW"
