"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from compass_api_sdk.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from compass_api_sdk.utils import validate_const
import pydantic
from pydantic import model_serializer
from pydantic.functional_validators import AfterValidator
from typing import Literal, Optional, Union
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict


AaveSupplyParamsAmountTypedDict = TypeAliasType(
    "AaveSupplyParamsAmountTypedDict", Union[float, str]
)
r"""The amount of the asset to supply"""


AaveSupplyParamsAmount = TypeAliasType("AaveSupplyParamsAmount", Union[float, str])
r"""The amount of the asset to supply"""


class AaveSupplyParamsTypedDict(TypedDict):
    token: str
    r"""The symbol or address of the underlying asset to supply as collateral. You can borrow against it.."""
    amount: AaveSupplyParamsAmountTypedDict
    r"""The amount of the asset to supply"""
    action_type: Literal["AAVE_SUPPLY"]
    on_behalf_of: NotRequired[Nullable[str]]
    r"""The address on behalf of whom the supply is made. Defaults to the transaction sender."""


class AaveSupplyParams(BaseModel):
    token: str
    r"""The symbol or address of the underlying asset to supply as collateral. You can borrow against it.."""

    amount: AaveSupplyParamsAmount
    r"""The amount of the asset to supply"""

    ACTION_TYPE: Annotated[
        Annotated[
            Optional[Literal["AAVE_SUPPLY"]],
            AfterValidator(validate_const("AAVE_SUPPLY")),
        ],
        pydantic.Field(alias="action_type"),
    ] = "AAVE_SUPPLY"

    on_behalf_of: OptionalNullable[str] = UNSET
    r"""The address on behalf of whom the supply is made. Defaults to the transaction sender."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["action_type", "on_behalf_of"]
        nullable_fields = ["on_behalf_of"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
