"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from compass_api_sdk.types import BaseModel, Nullable, UNSET_SENTINEL
from pydantic import model_serializer
from typing_extensions import TypedDict


class AaveReserveOverviewResponseTypedDict(TypedDict):
    tvl: float
    r"""Total tokens supplied in an Aave Reserve in USD. E.G. How much WBTC has been supplied on Aave in USD."""
    total_borrowed: float
    r"""Total tokens borrowed in an Aave Reserve converted to USD. E.G. How much WBTC has been supplied on Aave (in USD)."""
    utilization_ratio: Nullable[float]
    r"""Total borrowed divided by total supplied in an Aave Reserve. E.G. How much WBTC has been borrowed on Aaave divided by the amount supplied"""


class AaveReserveOverviewResponse(BaseModel):
    tvl: float
    r"""Total tokens supplied in an Aave Reserve in USD. E.G. How much WBTC has been supplied on Aave in USD."""

    total_borrowed: float
    r"""Total tokens borrowed in an Aave Reserve converted to USD. E.G. How much WBTC has been supplied on Aave (in USD)."""

    utilization_ratio: Nullable[float]
    r"""Total borrowed divided by total supplied in an Aave Reserve. E.G. How much WBTC has been borrowed on Aaave divided by the amount supplied"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["utilization_ratio"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
