"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from compass_api_sdk.types import BaseModel
from compass_api_sdk.utils import validate_const
import pydantic
from pydantic.functional_validators import AfterValidator
from typing import Literal, Optional
from typing_extensions import Annotated, TypedDict


class AavePositionTypedDict(TypedDict):
    id: str
    r"""Base64-encoded position identifier."""
    amount_in_underlying_token: str
    r"""The user's position value denominated in the supplied asset."""
    token_name: str
    r"""Symbol of the Aave reserve asset (e.g., USDC)."""
    type: Literal["AAVE"]
    r"""The market type discriminator."""
    vault_address: Literal["None"]
    vault_name: Literal["None"]


class AavePosition(BaseModel):
    id: str
    r"""Base64-encoded position identifier."""

    amount_in_underlying_token: str
    r"""The user's position value denominated in the supplied asset."""

    token_name: str
    r"""Symbol of the Aave reserve asset (e.g., USDC)."""

    TYPE: Annotated[
        Annotated[Literal["AAVE"], AfterValidator(validate_const("AAVE"))],
        pydantic.Field(alias="type"),
    ] = "AAVE"
    r"""The market type discriminator."""

    VAULT_ADDRESS: Annotated[
        Annotated[Optional[Literal["None"]], AfterValidator(validate_const("None"))],
        pydantic.Field(alias="vault_address"),
    ] = "None"

    VAULT_NAME: Annotated[
        Annotated[Optional[Literal["None"]], AfterValidator(validate_const("None"))],
        pydantic.Field(alias="vault_name"),
    ] = "None"
