"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .signedauthorization import SignedAuthorization, SignedAuthorizationTypedDict
from compass_api_sdk.types import (
    BaseModel,
    Nullable,
    OptionalNullable,
    UNSET,
    UNSET_SENTINEL,
)
from enum import Enum
from pydantic import model_serializer
from typing import Optional, Union
from typing_extensions import NotRequired, TypeAliasType, TypedDict


class AaveLoopRequestChain(str, Enum):
    ARBITRUM = "arbitrum"
    BASE = "base"
    ETHEREUM = "ethereum"


InitialCollateralAmountTypedDict = TypeAliasType(
    "InitialCollateralAmountTypedDict", Union[float, str]
)
r"""Amount of collateral token to supply to Aave"""


InitialCollateralAmount = TypeAliasType("InitialCollateralAmount", Union[float, str])
r"""Amount of collateral token to supply to Aave"""


MultiplierTypedDict = TypeAliasType("MultiplierTypedDict", Union[float, str])
r"""Leverage multiplier. Total loop collateral will be calculated as `multiplier` x `initial_collateral_amount`"""


Multiplier = TypeAliasType("Multiplier", Union[float, str])
r"""Leverage multiplier. Total loop collateral will be calculated as `multiplier` x `initial_collateral_amount`"""


MaxSlippagePercentTypedDict = TypeAliasType(
    "MaxSlippagePercentTypedDict", Union[float, str]
)
r"""Maximum allowed slippage for token swaps in percentage"""


MaxSlippagePercent = TypeAliasType("MaxSlippagePercent", Union[float, str])
r"""Maximum allowed slippage for token swaps in percentage"""


LoanToValueTypedDict = TypeAliasType("LoanToValueTypedDict", Union[float, str])
r"""Loan To Value percentage of the loop"""


LoanToValue = TypeAliasType("LoanToValue", Union[float, str])
r"""Loan To Value percentage of the loop"""


class AaveLoopRequestTypedDict(TypedDict):
    r"""Request model for executing an Aave loop strategy."""

    chain: AaveLoopRequestChain
    sender: str
    r"""The address of the transaction sender."""
    collateral_token: str
    r"""Symbol or address of token to supply to Aave.."""
    borrow_token: str
    r"""Symbol or address of token to borrow from Aave.."""
    initial_collateral_amount: InitialCollateralAmountTypedDict
    r"""Amount of collateral token to supply to Aave"""
    multiplier: MultiplierTypedDict
    r"""Leverage multiplier. Total loop collateral will be calculated as `multiplier` x `initial_collateral_amount`"""
    max_slippage_percent: MaxSlippagePercentTypedDict
    r"""Maximum allowed slippage for token swaps in percentage"""
    loan_to_value: LoanToValueTypedDict
    r"""Loan To Value percentage of the loop"""
    estimate_gas: NotRequired[bool]
    r"""Determines whether to estimate gas costs for transactions, also verifying that the transaction can be successfully executed."""
    signed_authorization: NotRequired[Nullable[SignedAuthorizationTypedDict]]
    r"""EIP-7702 authorization. Required when `is_account_abstraction` is False."""
    is_account_abstraction: NotRequired[bool]
    r"""Whether to use account abstraction for the transaction."""


class AaveLoopRequest(BaseModel):
    r"""Request model for executing an Aave loop strategy."""

    chain: AaveLoopRequestChain

    sender: str
    r"""The address of the transaction sender."""

    collateral_token: str
    r"""Symbol or address of token to supply to Aave.."""

    borrow_token: str
    r"""Symbol or address of token to borrow from Aave.."""

    initial_collateral_amount: InitialCollateralAmount
    r"""Amount of collateral token to supply to Aave"""

    multiplier: Multiplier
    r"""Leverage multiplier. Total loop collateral will be calculated as `multiplier` x `initial_collateral_amount`"""

    max_slippage_percent: MaxSlippagePercent
    r"""Maximum allowed slippage for token swaps in percentage"""

    loan_to_value: LoanToValue
    r"""Loan To Value percentage of the loop"""

    estimate_gas: Optional[bool] = None
    r"""Determines whether to estimate gas costs for transactions, also verifying that the transaction can be successfully executed."""

    signed_authorization: OptionalNullable[SignedAuthorization] = UNSET
    r"""EIP-7702 authorization. Required when `is_account_abstraction` is False."""

    is_account_abstraction: Optional[bool] = None
    r"""Whether to use account abstraction for the transaction."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "estimate_gas",
            "signed_authorization",
            "is_account_abstraction",
        ]
        nullable_fields = ["signed_authorization"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
