"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .borrow import Borrow, BorrowTypedDict
from .liquidationcall import LiquidationCall, LiquidationCallTypedDict
from .repay import Repay, RepayTypedDict
from .supply import Supply, SupplyTypedDict
from .swapborrowrate import SwapBorrowRate, SwapBorrowRateTypedDict
from .usageascollateral import UsageAsCollateral, UsageAsCollateralTypedDict
from .withdraw import Withdraw, WithdrawTypedDict
from compass_api_sdk.types import BaseModel
from compass_api_sdk.utils import get_discriminator
from pydantic import Discriminator, Tag
from typing import List, Union
from typing_extensions import Annotated, TypeAliasType, TypedDict


AaveHistoricalTransactionsResponseTransactionTypedDict = TypeAliasType(
    "AaveHistoricalTransactionsResponseTransactionTypedDict",
    Union[
        WithdrawTypedDict,
        RepayTypedDict,
        SupplyTypedDict,
        UsageAsCollateralTypedDict,
        BorrowTypedDict,
        SwapBorrowRateTypedDict,
        LiquidationCallTypedDict,
    ],
)


AaveHistoricalTransactionsResponseTransaction = Annotated[
    Union[
        Annotated[Borrow, Tag("Borrow")],
        Annotated[LiquidationCall, Tag("LiquidationCall")],
        Annotated[Withdraw, Tag("Withdraw")],
        Annotated[Repay, Tag("Repay")],
        Annotated[Supply, Tag("Supply")],
        Annotated[SwapBorrowRate, Tag("SwapBorrowRate")],
        Annotated[UsageAsCollateral, Tag("UsageAsCollateral")],
    ],
    Discriminator(lambda m: get_discriminator(m, "action", "action")),
]


class AaveHistoricalTransactionsResponseTypedDict(TypedDict):
    r"""Response model for getting Aave historical transactions."""

    offset: int
    r"""Specifies how many transactions to skip before returning results, letting you choose the starting point for the data you want to receive."""
    limit: int
    r"""Sets the maximum number of transactions to include in the response, helping control the size of the returned dataset."""
    transactions: List[AaveHistoricalTransactionsResponseTransactionTypedDict]


class AaveHistoricalTransactionsResponse(BaseModel):
    r"""Response model for getting Aave historical transactions."""

    offset: int
    r"""Specifies how many transactions to skip before returning results, letting you choose the starting point for the data you want to receive."""

    limit: int
    r"""Sets the maximum number of transactions to include in the response, helping control the size of the returned dataset."""

    transactions: List[AaveHistoricalTransactionsResponseTransaction]
