"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from .basesdk import BaseSDK
from compass_api_sdk import errors, models, utils
from compass_api_sdk._hooks import HookContext
from compass_api_sdk.types import OptionalNullable, UNSET
from compass_api_sdk.utils.unmarshal_json_response import unmarshal_json_response
from typing import Any, Mapping, Optional, Union


class GasSponsorship(BaseSDK):
    def gas_sponsorship_prepare(
        self,
        *,
        owner: str,
        chain: models.Chain,
        eip_712: Union[
            models.SponsorGasRequestEip712, models.SponsorGasRequestEip712TypedDict
        ],
        signature: str,
        sender: str,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.SponsorGasResponse:
        r"""Prepare gas-sponsored transaction

        Prepare a gas-sponsored transaction to be signed and submitted by `sender`.

        The `owner` submits their off-chain signature of EIP-712 typed data along with the data itself.

        The `sender` will sign and submit the transaction returned from this endpoint, effectively sponsoring the gas for the transaction on behalf of the `owner`.

        :param owner: The owner of the smart account's address.
        :param chain: The chain to use.
        :param eip_712: The EIP-712 typed data that was signed.
        :param signature: The EIP-712 signed typed data signature.
        :param sender: The address of the wallet which will send the transaction.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.SponsorGasRequest(
            owner=owner,
            chain=chain,
            eip_712=utils.get_pydantic_model(eip_712, models.SponsorGasRequestEip712),
            signature=signature,
            sender=sender,
        )

        req = self._build_request(
            method="POST",
            path="/v2/gas_sponsorship/prepare",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request, False, False, "json", models.SponsorGasRequest
            ),
            allow_empty_value=None,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="v2_gas_sponsorship_prepare",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.SponsorGasResponse, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.HTTPValidationErrorData, http_res
            )
            raise errors.HTTPValidationError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)

        raise errors.APIError("Unexpected response received", http_res)

    async def gas_sponsorship_prepare_async(
        self,
        *,
        owner: str,
        chain: models.Chain,
        eip_712: Union[
            models.SponsorGasRequestEip712, models.SponsorGasRequestEip712TypedDict
        ],
        signature: str,
        sender: str,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.SponsorGasResponse:
        r"""Prepare gas-sponsored transaction

        Prepare a gas-sponsored transaction to be signed and submitted by `sender`.

        The `owner` submits their off-chain signature of EIP-712 typed data along with the data itself.

        The `sender` will sign and submit the transaction returned from this endpoint, effectively sponsoring the gas for the transaction on behalf of the `owner`.

        :param owner: The owner of the smart account's address.
        :param chain: The chain to use.
        :param eip_712: The EIP-712 typed data that was signed.
        :param signature: The EIP-712 signed typed data signature.
        :param sender: The address of the wallet which will send the transaction.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.SponsorGasRequest(
            owner=owner,
            chain=chain,
            eip_712=utils.get_pydantic_model(eip_712, models.SponsorGasRequestEip712),
            signature=signature,
            sender=sender,
        )

        req = self._build_request_async(
            method="POST",
            path="/v2/gas_sponsorship/prepare",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request, False, False, "json", models.SponsorGasRequest
            ),
            allow_empty_value=None,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="v2_gas_sponsorship_prepare",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.SponsorGasResponse, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.HTTPValidationErrorData, http_res
            )
            raise errors.HTTPValidationError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)

        raise errors.APIError("Unexpected response received", http_res)

    def gas_sponsorship_approve_transfer(
        self,
        *,
        owner: str,
        chain: models.Chain,
        token: str,
        gas_sponsorship: Optional[bool] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.ApproveTransferResponse:
        r"""Approve token transfer

        Prepare a one-time permit2 approval transaction for a given token.

        This is only required if the `owner` would like to transfer tokens from their wallet to their Earn Account with gas-sponsorship.

        This approval transaction itself can be submitted with gas-sponsorship.
        In this case, EIP-712 typed data will be returned and should be signed by the `owner` off-chain.
        This signature can then be submitted to the 'Prepare gas-sponsored transaction' endpoint (`/gas_sponsorship/prepare`).
        Gas-sponsored approvals can only be achieved by ERC-20 tokens that support permit (EIP-2612).
        Some tokens, like USDT and WETH, do not allow for this behavior.
        In the case of non-permit tokens, the one-time approval transaction can be submitted in the conventional manner where the `owner` must sign, submit and pay gas for the transaction.

        :param owner: The owner of the smart account's address.
        :param chain: The chain to use.
        :param token: The token you would like to transfer with gas sponsorship.
        :param gas_sponsorship: Optionally request gas sponsorship. If set to `true`, EIP-712 signature data will be returned that must be signed by the `owner` and submitted to the `/gas_sponsorship/prepare` endpoint.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.ApproveTransferRequest(
            owner=owner,
            chain=chain,
            token=token,
            gas_sponsorship=gas_sponsorship,
        )

        req = self._build_request(
            method="POST",
            path="/v2/gas_sponsorship/approve_transfer",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request, False, False, "json", models.ApproveTransferRequest
            ),
            allow_empty_value=None,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="v2_gas_sponsorship_approve_transfer",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.ApproveTransferResponse, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.HTTPValidationErrorData, http_res
            )
            raise errors.HTTPValidationError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)

        raise errors.APIError("Unexpected response received", http_res)

    async def gas_sponsorship_approve_transfer_async(
        self,
        *,
        owner: str,
        chain: models.Chain,
        token: str,
        gas_sponsorship: Optional[bool] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.ApproveTransferResponse:
        r"""Approve token transfer

        Prepare a one-time permit2 approval transaction for a given token.

        This is only required if the `owner` would like to transfer tokens from their wallet to their Earn Account with gas-sponsorship.

        This approval transaction itself can be submitted with gas-sponsorship.
        In this case, EIP-712 typed data will be returned and should be signed by the `owner` off-chain.
        This signature can then be submitted to the 'Prepare gas-sponsored transaction' endpoint (`/gas_sponsorship/prepare`).
        Gas-sponsored approvals can only be achieved by ERC-20 tokens that support permit (EIP-2612).
        Some tokens, like USDT and WETH, do not allow for this behavior.
        In the case of non-permit tokens, the one-time approval transaction can be submitted in the conventional manner where the `owner` must sign, submit and pay gas for the transaction.

        :param owner: The owner of the smart account's address.
        :param chain: The chain to use.
        :param token: The token you would like to transfer with gas sponsorship.
        :param gas_sponsorship: Optionally request gas sponsorship. If set to `true`, EIP-712 signature data will be returned that must be signed by the `owner` and submitted to the `/gas_sponsorship/prepare` endpoint.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.ApproveTransferRequest(
            owner=owner,
            chain=chain,
            token=token,
            gas_sponsorship=gas_sponsorship,
        )

        req = self._build_request_async(
            method="POST",
            path="/v2/gas_sponsorship/approve_transfer",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request, False, False, "json", models.ApproveTransferRequest
            ),
            allow_empty_value=None,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="v2_gas_sponsorship_approve_transfer",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.ApproveTransferResponse, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.HTTPValidationErrorData, http_res
            )
            raise errors.HTTPValidationError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)

        raise errors.APIError("Unexpected response received", http_res)
