"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from compass_api_sdk.errors import CompassAPIError
from compass_api_sdk.types import BaseModel
from compass_api_sdk.utils import validate_const
from dataclasses import dataclass, field
import httpx
import pydantic
from pydantic.functional_validators import AfterValidator
from typing import Literal, Optional
from typing_extensions import Annotated


class MintPrepareNotFoundResponseErrorData(BaseModel):
    bridge_id: str
    r"""The bridge identifier."""

    message: str
    r"""Human-readable message explaining the status."""

    STATUS: Annotated[
        Annotated[
            Optional[Literal["burn_not_found"]],
            AfterValidator(validate_const("burn_not_found")),
        ],
        pydantic.Field(alias="status"),
    ] = "burn_not_found"
    r"""Indicates the burn event was not found on the source chain."""


@dataclass(unsafe_hash=True)
class MintPrepareNotFoundResponseError(CompassAPIError):
    r"""Response when the burn event has not been found yet.

    This means the burn transaction hasn't been confirmed on-chain yet, or the user
    hasn't broadcast the burn transaction.
    """

    data: MintPrepareNotFoundResponseErrorData = field(hash=False)

    def __init__(
        self,
        data: MintPrepareNotFoundResponseErrorData,
        raw_response: httpx.Response,
        body: Optional[str] = None,
    ):
        fallback = body or raw_response.text
        message = str(data.message) or fallback
        super().__init__(message, raw_response, body)
        object.__setattr__(self, "data", data)
