"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from .basesdk import BaseSDK
from compass_api_sdk import errors, models, utils
from compass_api_sdk._hooks import HookContext
from compass_api_sdk.types import OptionalNullable, UNSET
from compass_api_sdk.utils.unmarshal_json_response import unmarshal_json_response
from typing import Any, Mapping, Optional, Union


class ERC4626Vaults(BaseSDK):
    def vaults_vault(
        self,
        *,
        chain: models.V1VaultsVaultChain,
        vault_address: str,
        block: OptionalNullable[int] = UNSET,
        user_address: OptionalNullable[str] = UNSET,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.VaultGetVaultResponse:
        r"""Get Vault & User Position

        Get Vault data & User Position.

        The user position is only included if 'user_address' parameter is included.

        :param chain:
        :param vault_address: The vault address of the desired vault position.
        :param block: Optional block number (defaults to latest).
        :param user_address: The user address of the desired vault position. Only include if you would like the user position included in the response. Defaults to `None`.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.V1VaultsVaultRequest(
            chain=chain,
            block=block,
            vault_address=vault_address,
            user_address=user_address,
        )

        req = self._build_request(
            method="GET",
            path="/v1/vaults/vault",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            allow_empty_value=None,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="v1_vaults_vault",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.VaultGetVaultResponse, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.HTTPValidationErrorData, http_res
            )
            raise errors.HTTPValidationError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)

        raise errors.APIError("Unexpected response received", http_res)

    async def vaults_vault_async(
        self,
        *,
        chain: models.V1VaultsVaultChain,
        vault_address: str,
        block: OptionalNullable[int] = UNSET,
        user_address: OptionalNullable[str] = UNSET,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.VaultGetVaultResponse:
        r"""Get Vault & User Position

        Get Vault data & User Position.

        The user position is only included if 'user_address' parameter is included.

        :param chain:
        :param vault_address: The vault address of the desired vault position.
        :param block: Optional block number (defaults to latest).
        :param user_address: The user address of the desired vault position. Only include if you would like the user position included in the response. Defaults to `None`.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.V1VaultsVaultRequest(
            chain=chain,
            block=block,
            vault_address=vault_address,
            user_address=user_address,
        )

        req = self._build_request_async(
            method="GET",
            path="/v1/vaults/vault",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            allow_empty_value=None,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="v1_vaults_vault",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.VaultGetVaultResponse, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.HTTPValidationErrorData, http_res
            )
            raise errors.HTTPValidationError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)

        raise errors.APIError("Unexpected response received", http_res)

    def vaults_deposit(
        self,
        *,
        vault_address: str,
        amount: Union[
            models.VaultDepositRequestAmount, models.VaultDepositRequestAmountTypedDict
        ],
        chain: models.VaultDepositRequestChain,
        sender: str,
        receiver: OptionalNullable[str] = UNSET,
        estimate_gas: Optional[bool] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.TransactionResponse:
        r"""Deposit to Vault

        Deposit tokens into a Vault (ERC-4626 Standard) to earn passive yield.

        Each vault accepts one unique token that can be deposited.
        <Info>
        **Required Allowances**

        In order to make this transaction, token allowances need to be set for the following contracts.

        - `<vault_address>`
        </Info>


        :param vault_address: The vault address you are depositing to.
        :param amount: The amount of tokens to deposit into the vault.
        :param chain:
        :param sender: The address of the transaction sender.
        :param receiver: The address which will receive the shares from the vault representing their proportional ownership of the vault's assets. Defaults to the sender.
        :param estimate_gas: Determines whether to estimate gas costs for transactions, also verifying that the transaction can be successfully executed.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.VaultDepositRequest(
            vault_address=vault_address,
            amount=amount,
            receiver=receiver,
            chain=chain,
            sender=sender,
            estimate_gas=estimate_gas,
        )

        req = self._build_request(
            method="POST",
            path="/v1/vaults/deposit",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request, False, False, "json", models.VaultDepositRequest
            ),
            allow_empty_value=None,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="v1_vaults_deposit",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.TransactionResponse, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.HTTPValidationErrorData, http_res
            )
            raise errors.HTTPValidationError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)

        raise errors.APIError("Unexpected response received", http_res)

    async def vaults_deposit_async(
        self,
        *,
        vault_address: str,
        amount: Union[
            models.VaultDepositRequestAmount, models.VaultDepositRequestAmountTypedDict
        ],
        chain: models.VaultDepositRequestChain,
        sender: str,
        receiver: OptionalNullable[str] = UNSET,
        estimate_gas: Optional[bool] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.TransactionResponse:
        r"""Deposit to Vault

        Deposit tokens into a Vault (ERC-4626 Standard) to earn passive yield.

        Each vault accepts one unique token that can be deposited.
        <Info>
        **Required Allowances**

        In order to make this transaction, token allowances need to be set for the following contracts.

        - `<vault_address>`
        </Info>


        :param vault_address: The vault address you are depositing to.
        :param amount: The amount of tokens to deposit into the vault.
        :param chain:
        :param sender: The address of the transaction sender.
        :param receiver: The address which will receive the shares from the vault representing their proportional ownership of the vault's assets. Defaults to the sender.
        :param estimate_gas: Determines whether to estimate gas costs for transactions, also verifying that the transaction can be successfully executed.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.VaultDepositRequest(
            vault_address=vault_address,
            amount=amount,
            receiver=receiver,
            chain=chain,
            sender=sender,
            estimate_gas=estimate_gas,
        )

        req = self._build_request_async(
            method="POST",
            path="/v1/vaults/deposit",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request, False, False, "json", models.VaultDepositRequest
            ),
            allow_empty_value=None,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="v1_vaults_deposit",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.TransactionResponse, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.HTTPValidationErrorData, http_res
            )
            raise errors.HTTPValidationError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)

        raise errors.APIError("Unexpected response received", http_res)

    def vaults_withdraw(
        self,
        *,
        vault_address: str,
        amount: Any,
        chain: models.VaultWithdrawRequestChain,
        sender: str,
        receiver: OptionalNullable[str] = UNSET,
        estimate_gas: Optional[bool] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.TransactionResponse:
        r"""Withdraw from Vault

        Withdraw deposited tokens from a Vault (ERC-4626 Standard).

        The passive yield earned on token deposits is represented by the increased value of
        the shares received upon depositing tokens. Trade in these shares for the tokens you
        deposited plus any accrued yield.

        :param vault_address: The vault address you are withdrawing from.
        :param amount: The amount of tokens to withdraw from the vault. If set to 'ALL', your total deposited token amount will be withdrawn.
        :param chain:
        :param sender: The address of the transaction sender.
        :param receiver: The address which will receive the tokens withdrawn. Defaults to the sender.
        :param estimate_gas: Determines whether to estimate gas costs for transactions, also verifying that the transaction can be successfully executed.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.VaultWithdrawRequest(
            vault_address=vault_address,
            amount=amount,
            receiver=receiver,
            chain=chain,
            sender=sender,
            estimate_gas=estimate_gas,
        )

        req = self._build_request(
            method="POST",
            path="/v1/vaults/withdraw",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request, False, False, "json", models.VaultWithdrawRequest
            ),
            allow_empty_value=None,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="v1_vaults_withdraw",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.TransactionResponse, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.HTTPValidationErrorData, http_res
            )
            raise errors.HTTPValidationError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)

        raise errors.APIError("Unexpected response received", http_res)

    async def vaults_withdraw_async(
        self,
        *,
        vault_address: str,
        amount: Any,
        chain: models.VaultWithdrawRequestChain,
        sender: str,
        receiver: OptionalNullable[str] = UNSET,
        estimate_gas: Optional[bool] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.TransactionResponse:
        r"""Withdraw from Vault

        Withdraw deposited tokens from a Vault (ERC-4626 Standard).

        The passive yield earned on token deposits is represented by the increased value of
        the shares received upon depositing tokens. Trade in these shares for the tokens you
        deposited plus any accrued yield.

        :param vault_address: The vault address you are withdrawing from.
        :param amount: The amount of tokens to withdraw from the vault. If set to 'ALL', your total deposited token amount will be withdrawn.
        :param chain:
        :param sender: The address of the transaction sender.
        :param receiver: The address which will receive the tokens withdrawn. Defaults to the sender.
        :param estimate_gas: Determines whether to estimate gas costs for transactions, also verifying that the transaction can be successfully executed.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.VaultWithdrawRequest(
            vault_address=vault_address,
            amount=amount,
            receiver=receiver,
            chain=chain,
            sender=sender,
            estimate_gas=estimate_gas,
        )

        req = self._build_request_async(
            method="POST",
            path="/v1/vaults/withdraw",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request, False, False, "json", models.VaultWithdrawRequest
            ),
            allow_empty_value=None,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="v1_vaults_withdraw",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.TransactionResponse, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.HTTPValidationErrorData, http_res
            )
            raise errors.HTTPValidationError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)

        raise errors.APIError("Unexpected response received", http_res)
