"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from .basesdk import BaseSDK
from compass_api_sdk import errors, models, utils
from compass_api_sdk._hooks import HookContext
from compass_api_sdk.types import OptionalNullable, UNSET
from compass_api_sdk.utils.unmarshal_json_response import unmarshal_json_response
from typing import Any, Mapping, Optional, Union


class Bridge(BaseSDK):
    def cctp_burn(
        self,
        *,
        owner: str,
        chain: models.DepositForBurnRequestChain,
        amount: Union[
            models.DepositForBurnRequestAmount,
            models.DepositForBurnRequestAmountTypedDict,
        ],
        destination_chain: models.DestinationChain,
        gas_sponsorship: Optional[bool] = None,
        transfer_mode: Optional[models.DepositForBurnRequestTransferMode] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.DepositForBurnResponse:
        r"""Initiate USDC bridging

        Bridge USDC to any chain for any Product account using Circle's CCTP Protocol.

        **Transfer modes:**
        - `standard` (default): ~15-19 minute transfers, **free** (no fee)
        - `fast`: ~30 second transfers, requires a small fee (typically ~0.01%)

        The fee for fast mode is automatically calculated based on Circle's current rates.

        **Flow:**
        1. Call this endpoint with `gas_sponsorship=false` to get an unsigned transaction,
        or `gas_sponsorship=true` to get EIP-712 typed data for gas-sponsored execution
        2. Owner signs the transaction or typed data
        3. Broadcast the transaction on the source chain (or submit to `/gas_sponsorship/prepare`)
        4. Wait for Circle's attestation service to attest the burn
        5. Call the mint endpoint to receive USDC on the destination chain

        **Supported chains:**
        - Ethereum (domain 0)
        - Arbitrum (domain 3)
        - Base (domain 6)

        **Note:** The USDC must already be deposited in the Product Account. If approval is needed
        for the TokenMessengerV2 contract, it will be included in the transaction automatically.

        :param owner: The primary wallet address that owns and controls the Product Account.
        :param chain: The source chain where USDC will be burned.
        :param amount: The amount of USDC to bridge (in token units, e.g., 100.5 for 100.5 USDC).
        :param destination_chain: The destination chain where USDC will be minted.
        :param gas_sponsorship: Optionally request gas sponsorship. If set to `true`, EIP-712 typed data will be returned that must be signed by the `owner` and submitted to the 'Prepare gas-sponsored transaction' endpoint (`/gas_sponsorship/prepare`).
        :param transfer_mode: Transfer speed mode. 'fast': ~30 second transfers using confirmed finality (requires a small fee taken from transfer amount). 'standard': ~15-19 minute transfers using full finality (free, no fee). Default is 'standard'.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.DepositForBurnRequest(
            owner=owner,
            chain=chain,
            amount=amount,
            destination_chain=destination_chain,
            gas_sponsorship=gas_sponsorship,
            transfer_mode=transfer_mode,
        )

        req = self._build_request(
            method="POST",
            path="/v2/cctp/burn",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request, False, False, "json", models.DepositForBurnRequest
            ),
            allow_empty_value=None,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="v2_cctp_burn",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.DepositForBurnResponse, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.HTTPValidationErrorData, http_res
            )
            raise errors.HTTPValidationError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)

        raise errors.APIError("Unexpected response received", http_res)

    async def cctp_burn_async(
        self,
        *,
        owner: str,
        chain: models.DepositForBurnRequestChain,
        amount: Union[
            models.DepositForBurnRequestAmount,
            models.DepositForBurnRequestAmountTypedDict,
        ],
        destination_chain: models.DestinationChain,
        gas_sponsorship: Optional[bool] = None,
        transfer_mode: Optional[models.DepositForBurnRequestTransferMode] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.DepositForBurnResponse:
        r"""Initiate USDC bridging

        Bridge USDC to any chain for any Product account using Circle's CCTP Protocol.

        **Transfer modes:**
        - `standard` (default): ~15-19 minute transfers, **free** (no fee)
        - `fast`: ~30 second transfers, requires a small fee (typically ~0.01%)

        The fee for fast mode is automatically calculated based on Circle's current rates.

        **Flow:**
        1. Call this endpoint with `gas_sponsorship=false` to get an unsigned transaction,
        or `gas_sponsorship=true` to get EIP-712 typed data for gas-sponsored execution
        2. Owner signs the transaction or typed data
        3. Broadcast the transaction on the source chain (or submit to `/gas_sponsorship/prepare`)
        4. Wait for Circle's attestation service to attest the burn
        5. Call the mint endpoint to receive USDC on the destination chain

        **Supported chains:**
        - Ethereum (domain 0)
        - Arbitrum (domain 3)
        - Base (domain 6)

        **Note:** The USDC must already be deposited in the Product Account. If approval is needed
        for the TokenMessengerV2 contract, it will be included in the transaction automatically.

        :param owner: The primary wallet address that owns and controls the Product Account.
        :param chain: The source chain where USDC will be burned.
        :param amount: The amount of USDC to bridge (in token units, e.g., 100.5 for 100.5 USDC).
        :param destination_chain: The destination chain where USDC will be minted.
        :param gas_sponsorship: Optionally request gas sponsorship. If set to `true`, EIP-712 typed data will be returned that must be signed by the `owner` and submitted to the 'Prepare gas-sponsored transaction' endpoint (`/gas_sponsorship/prepare`).
        :param transfer_mode: Transfer speed mode. 'fast': ~30 second transfers using confirmed finality (requires a small fee taken from transfer amount). 'standard': ~15-19 minute transfers using full finality (free, no fee). Default is 'standard'.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.DepositForBurnRequest(
            owner=owner,
            chain=chain,
            amount=amount,
            destination_chain=destination_chain,
            gas_sponsorship=gas_sponsorship,
            transfer_mode=transfer_mode,
        )

        req = self._build_request_async(
            method="POST",
            path="/v2/cctp/burn",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request, False, False, "json", models.DepositForBurnRequest
            ),
            allow_empty_value=None,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="v2_cctp_burn",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.DepositForBurnResponse, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.HTTPValidationErrorData, http_res
            )
            raise errors.HTTPValidationError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)

        raise errors.APIError("Unexpected response received", http_res)

    def cctp_mint(
        self,
        *,
        bridge_id: str,
        burn_tx_hash: str,
        sender: str,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.V2CctpMintResponse:
        r"""Complete USDC bridging

        Prepare a receiveMessage transaction to mint USDC to any Product Account on the
        destination chain.

        **How it works:**

        This endpoint uses the `bridge_id` from `/burn` to:
        1. Look up the bridge session
        2. Check if Circle's attestation is ready
        3. Depending on the status of the attestation return the following:
        - if attestation is still pending, return URLs for real-time updates
        - if attestation is ready, return a transaction to complete the bridging process
        - if the minting for a given `bridge_id` has been completed, informs with `completed` status

        **Request parameters:**

        - `bridge_id`: The bridge ID returned from `/burn`
        - `burn_tx_hash`: The transaction hash of the burn transaction on the source chain

        **Response codes:**

        - **200 OK**: Attestation is ready, mint transaction is included
        - **202 Accepted**: Attestation is pending, SSE URL for real-time updates is included (The real-time update endpoints are in progress)
        - **404 Not found**: Bridge not found

        **After receiving 202:**

        Either:
        - Connect to the SSE stream at `sse_url` and wait for `attestation_ready` event (The SSE stream and status endpoint are in progress. Keep an eye on the updates from our team)
        - Poll this endpoint periodically until you get 200

        :param bridge_id: The bridge identifier returned from /burn endpoint. This is used to look up the bridge session.
        :param burn_tx_hash: The transaction hash of the burn transaction on the source chain. This is used to find the DepositForBurn event and extract the CCTP message.
        :param sender: The wallet address that will sign and send the mint transaction. This can be any wallet, the receiver of the minted USDC is not determined by this sender.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.MintPrepareRequest(
            bridge_id=bridge_id,
            burn_tx_hash=burn_tx_hash,
            sender=sender,
        )

        req = self._build_request(
            method="POST",
            path="/v2/cctp/mint",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request, False, False, "json", models.MintPrepareRequest
            ),
            allow_empty_value=None,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="v2_cctp_mint",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["404", "422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.Response200V2CctpMint, http_res)
        if utils.match_response(http_res, "202", "application/json"):
            return unmarshal_json_response(models.MintPreparePendingResponse, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                errors.MintPrepareNotFoundResponseErrorData, http_res
            )
            raise errors.MintPrepareNotFoundResponseError(response_data, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.HTTPValidationErrorData, http_res
            )
            raise errors.HTTPValidationError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)

        raise errors.APIError("Unexpected response received", http_res)

    async def cctp_mint_async(
        self,
        *,
        bridge_id: str,
        burn_tx_hash: str,
        sender: str,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.V2CctpMintResponse:
        r"""Complete USDC bridging

        Prepare a receiveMessage transaction to mint USDC to any Product Account on the
        destination chain.

        **How it works:**

        This endpoint uses the `bridge_id` from `/burn` to:
        1. Look up the bridge session
        2. Check if Circle's attestation is ready
        3. Depending on the status of the attestation return the following:
        - if attestation is still pending, return URLs for real-time updates
        - if attestation is ready, return a transaction to complete the bridging process
        - if the minting for a given `bridge_id` has been completed, informs with `completed` status

        **Request parameters:**

        - `bridge_id`: The bridge ID returned from `/burn`
        - `burn_tx_hash`: The transaction hash of the burn transaction on the source chain

        **Response codes:**

        - **200 OK**: Attestation is ready, mint transaction is included
        - **202 Accepted**: Attestation is pending, SSE URL for real-time updates is included (The real-time update endpoints are in progress)
        - **404 Not found**: Bridge not found

        **After receiving 202:**

        Either:
        - Connect to the SSE stream at `sse_url` and wait for `attestation_ready` event (The SSE stream and status endpoint are in progress. Keep an eye on the updates from our team)
        - Poll this endpoint periodically until you get 200

        :param bridge_id: The bridge identifier returned from /burn endpoint. This is used to look up the bridge session.
        :param burn_tx_hash: The transaction hash of the burn transaction on the source chain. This is used to find the DepositForBurn event and extract the CCTP message.
        :param sender: The wallet address that will sign and send the mint transaction. This can be any wallet, the receiver of the minted USDC is not determined by this sender.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.MintPrepareRequest(
            bridge_id=bridge_id,
            burn_tx_hash=burn_tx_hash,
            sender=sender,
        )

        req = self._build_request_async(
            method="POST",
            path="/v2/cctp/mint",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request, False, False, "json", models.MintPrepareRequest
            ),
            allow_empty_value=None,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="v2_cctp_mint",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["404", "422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.Response200V2CctpMint, http_res)
        if utils.match_response(http_res, "202", "application/json"):
            return unmarshal_json_response(models.MintPreparePendingResponse, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                errors.MintPrepareNotFoundResponseErrorData, http_res
            )
            raise errors.MintPrepareNotFoundResponseError(response_data, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.HTTPValidationErrorData, http_res
            )
            raise errors.HTTPValidationError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)

        raise errors.APIError("Unexpected response received", http_res)
