"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from .basesdk import BaseSDK
from compass_api_sdk import errors, models, utils
from compass_api_sdk._hooks import HookContext
from compass_api_sdk.types import OptionalNullable, UNSET
from compass_api_sdk.utils.unmarshal_json_response import unmarshal_json_response
from typing import Any, Mapping, Optional, Union


class AerodromeSlipstream(BaseSDK):
    def aerodrome_slipstream_liquidity_provision_positions(
        self,
        *,
        chain: models.V1AerodromeSlipstreamLiquidityProvisionPositionsChain,
        user: Optional[str] = None,
        pool: OptionalNullable[str] = UNSET,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.AerodromeLPPositionsResponse:
        r"""List LP Positions

        Retrieve the total number of Liquidity Provider (LP) positions associated with a
        specific sender.

        This endpoint allows users to query and obtain detailed information about their LP
        positions, including the number of active positions they hold. The response model,
        AerodromeLPPositionsInfo, provides a structured representation of the LP positions
        data, ensuring clarity and ease of use. This functionality is essential for users
        managing their liquidity provision activities, enabling them to make informed
        decisions based on their current positions.

        :param chain:
        :param user: The user to get positions for.
        :param pool: Optional pool address to filter positions by. If provided, only positions for this pool will be returned.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.V1AerodromeSlipstreamLiquidityProvisionPositionsRequest(
            chain=chain,
            user=user,
            pool=pool,
        )

        req = self._build_request(
            method="GET",
            path="/v1/aerodrome_slipstream/liquidity_provision/positions",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            allow_empty_value=None,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="v1_aerodrome_slipstream_liquidity_provision_positions",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(
                models.AerodromeLPPositionsResponse, http_res
            )
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.HTTPValidationErrorData, http_res
            )
            raise errors.HTTPValidationError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)

        raise errors.APIError("Unexpected response received", http_res)

    async def aerodrome_slipstream_liquidity_provision_positions_async(
        self,
        *,
        chain: models.V1AerodromeSlipstreamLiquidityProvisionPositionsChain,
        user: Optional[str] = None,
        pool: OptionalNullable[str] = UNSET,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.AerodromeLPPositionsResponse:
        r"""List LP Positions

        Retrieve the total number of Liquidity Provider (LP) positions associated with a
        specific sender.

        This endpoint allows users to query and obtain detailed information about their LP
        positions, including the number of active positions they hold. The response model,
        AerodromeLPPositionsInfo, provides a structured representation of the LP positions
        data, ensuring clarity and ease of use. This functionality is essential for users
        managing their liquidity provision activities, enabling them to make informed
        decisions based on their current positions.

        :param chain:
        :param user: The user to get positions for.
        :param pool: Optional pool address to filter positions by. If provided, only positions for this pool will be returned.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.V1AerodromeSlipstreamLiquidityProvisionPositionsRequest(
            chain=chain,
            user=user,
            pool=pool,
        )

        req = self._build_request_async(
            method="GET",
            path="/v1/aerodrome_slipstream/liquidity_provision/positions",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            allow_empty_value=None,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="v1_aerodrome_slipstream_liquidity_provision_positions",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(
                models.AerodromeLPPositionsResponse, http_res
            )
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.HTTPValidationErrorData, http_res
            )
            raise errors.HTTPValidationError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)

        raise errors.APIError("Unexpected response received", http_res)

    def aerodrome_slipstream_pool_price(
        self,
        *,
        chain: models.V1AerodromeSlipstreamPoolPriceChain,
        token_in: str,
        token_out: str,
        tick_spacing: Optional[int] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.AerodromeSlipstreamPoolPriceResponse:
        r"""Pool Price

        This endpoint retrieves the current price of a pool, indicating how many token0
        you can purchase for 1 token1.

        Note that this is an instantaneous price and may change during any trade. For a more
        accurate representation of the trade ratios between the two assets, consider using
        the quote endpoint.

        :param chain:
        :param token_in: The symbol or address of a token in the pool.
        :param token_out: The symbol or address of a token in the pool.
        :param tick_spacing: The tick spacing of the pool
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.V1AerodromeSlipstreamPoolPriceRequest(
            chain=chain,
            token_in=token_in,
            token_out=token_out,
            tick_spacing=tick_spacing,
        )

        req = self._build_request(
            method="GET",
            path="/v1/aerodrome_slipstream/pool_price",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            allow_empty_value=None,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="v1_aerodrome_slipstream_pool_price",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(
                models.AerodromeSlipstreamPoolPriceResponse, http_res
            )
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.HTTPValidationErrorData, http_res
            )
            raise errors.HTTPValidationError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)

        raise errors.APIError("Unexpected response received", http_res)

    async def aerodrome_slipstream_pool_price_async(
        self,
        *,
        chain: models.V1AerodromeSlipstreamPoolPriceChain,
        token_in: str,
        token_out: str,
        tick_spacing: Optional[int] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.AerodromeSlipstreamPoolPriceResponse:
        r"""Pool Price

        This endpoint retrieves the current price of a pool, indicating how many token0
        you can purchase for 1 token1.

        Note that this is an instantaneous price and may change during any trade. For a more
        accurate representation of the trade ratios between the two assets, consider using
        the quote endpoint.

        :param chain:
        :param token_in: The symbol or address of a token in the pool.
        :param token_out: The symbol or address of a token in the pool.
        :param tick_spacing: The tick spacing of the pool
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.V1AerodromeSlipstreamPoolPriceRequest(
            chain=chain,
            token_in=token_in,
            token_out=token_out,
            tick_spacing=tick_spacing,
        )

        req = self._build_request_async(
            method="GET",
            path="/v1/aerodrome_slipstream/pool_price",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            allow_empty_value=None,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="v1_aerodrome_slipstream_pool_price",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(
                models.AerodromeSlipstreamPoolPriceResponse, http_res
            )
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.HTTPValidationErrorData, http_res
            )
            raise errors.HTTPValidationError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)

        raise errors.APIError("Unexpected response received", http_res)

    def aerodrome_slipstream_swap_sell_exactly(
        self,
        *,
        token_in: str,
        token_out: str,
        tick_spacing: int,
        amount_in: Union[
            models.AerodromeSlipstreamSellExactlyRequestAmountIn,
            models.AerodromeSlipstreamSellExactlyRequestAmountInTypedDict,
        ],
        chain: models.AerodromeSlipstreamSellExactlyRequestChain,
        sender: str,
        amount_out_minimum: Optional[
            Union[
                models.AerodromeSlipstreamSellExactlyRequestAmountOutMinimum,
                models.AerodromeSlipstreamSellExactlyRequestAmountOutMinimumTypedDict,
            ]
        ] = None,
        estimate_gas: Optional[bool] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.TransactionResponse:
        r"""Swap - from Specified Amount

        This endpoint allows users to trade a specific amount of one token into another
        token using the Aerodrome Slipstream protocol.

        The transaction is executed by specifying the exact amount of the input token to be
        sold, and the system calculates the amount of the output token that will be
        received. The operation ensures that the trade is conducted within the constraints
        of the current market conditions, taking into account the liquidity and price
        impact. This endpoint is suitable for users who want to sell a precise quantity of a
        token and are willing to accept the resulting amount of the other token.
        <Info>
        **Required Allowances**

        In order to make this transaction, token allowances need to be set for the following contracts.

        - `AerodromeSlipstreamRouter`
        </Info>


        :param token_in: The symbol or address of the token to swap from.
        :param token_out: The symbol or address of the token to swap to.
        :param tick_spacing: The tick spacing of the pool
        :param amount_in: The amount of the token to swap from
        :param chain:
        :param sender: The address of the transaction sender.
        :param amount_out_minimum: The minimum amount of the token to swap to, defaults to 0
        :param estimate_gas: Determines whether to estimate gas costs for transactions, also verifying that the transaction can be successfully executed.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.AerodromeSlipstreamSellExactlyRequest(
            token_in=token_in,
            token_out=token_out,
            tick_spacing=tick_spacing,
            amount_in=amount_in,
            amount_out_minimum=amount_out_minimum,
            chain=chain,
            sender=sender,
            estimate_gas=estimate_gas,
        )

        req = self._build_request(
            method="POST",
            path="/v1/aerodrome_slipstream/swap/sell_exactly",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request,
                False,
                False,
                "json",
                models.AerodromeSlipstreamSellExactlyRequest,
            ),
            allow_empty_value=None,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="v1_aerodrome_slipstream_swap_sell_exactly",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.TransactionResponse, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.HTTPValidationErrorData, http_res
            )
            raise errors.HTTPValidationError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)

        raise errors.APIError("Unexpected response received", http_res)

    async def aerodrome_slipstream_swap_sell_exactly_async(
        self,
        *,
        token_in: str,
        token_out: str,
        tick_spacing: int,
        amount_in: Union[
            models.AerodromeSlipstreamSellExactlyRequestAmountIn,
            models.AerodromeSlipstreamSellExactlyRequestAmountInTypedDict,
        ],
        chain: models.AerodromeSlipstreamSellExactlyRequestChain,
        sender: str,
        amount_out_minimum: Optional[
            Union[
                models.AerodromeSlipstreamSellExactlyRequestAmountOutMinimum,
                models.AerodromeSlipstreamSellExactlyRequestAmountOutMinimumTypedDict,
            ]
        ] = None,
        estimate_gas: Optional[bool] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.TransactionResponse:
        r"""Swap - from Specified Amount

        This endpoint allows users to trade a specific amount of one token into another
        token using the Aerodrome Slipstream protocol.

        The transaction is executed by specifying the exact amount of the input token to be
        sold, and the system calculates the amount of the output token that will be
        received. The operation ensures that the trade is conducted within the constraints
        of the current market conditions, taking into account the liquidity and price
        impact. This endpoint is suitable for users who want to sell a precise quantity of a
        token and are willing to accept the resulting amount of the other token.
        <Info>
        **Required Allowances**

        In order to make this transaction, token allowances need to be set for the following contracts.

        - `AerodromeSlipstreamRouter`
        </Info>


        :param token_in: The symbol or address of the token to swap from.
        :param token_out: The symbol or address of the token to swap to.
        :param tick_spacing: The tick spacing of the pool
        :param amount_in: The amount of the token to swap from
        :param chain:
        :param sender: The address of the transaction sender.
        :param amount_out_minimum: The minimum amount of the token to swap to, defaults to 0
        :param estimate_gas: Determines whether to estimate gas costs for transactions, also verifying that the transaction can be successfully executed.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.AerodromeSlipstreamSellExactlyRequest(
            token_in=token_in,
            token_out=token_out,
            tick_spacing=tick_spacing,
            amount_in=amount_in,
            amount_out_minimum=amount_out_minimum,
            chain=chain,
            sender=sender,
            estimate_gas=estimate_gas,
        )

        req = self._build_request_async(
            method="POST",
            path="/v1/aerodrome_slipstream/swap/sell_exactly",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request,
                False,
                False,
                "json",
                models.AerodromeSlipstreamSellExactlyRequest,
            ),
            allow_empty_value=None,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="v1_aerodrome_slipstream_swap_sell_exactly",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.TransactionResponse, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.HTTPValidationErrorData, http_res
            )
            raise errors.HTTPValidationError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)

        raise errors.APIError("Unexpected response received", http_res)

    def aerodrome_slipstream_swap_buy_exactly(
        self,
        *,
        token_in: str,
        token_out: str,
        tick_spacing: int,
        amount_out: Union[
            models.AerodromeSlipstreamBuyExactlyRequestAmountOut,
            models.AerodromeSlipstreamBuyExactlyRequestAmountOutTypedDict,
        ],
        amount_in_maximum: Union[
            models.AerodromeSlipstreamBuyExactlyRequestAmountInMaximum,
            models.AerodromeSlipstreamBuyExactlyRequestAmountInMaximumTypedDict,
        ],
        chain: models.AerodromeSlipstreamBuyExactlyRequestChain,
        sender: str,
        estimate_gas: Optional[bool] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.TransactionResponse:
        r"""Swap - into Specified Amount

        This endpoint facilitates the trading of tokens by allowing users to specify the
        exact amount of the output token they wish to receive.

        Utilizing the Aerodrome Slipstream protocol, the system calculates the necessary
        amount of the input token required to achieve the desired output. This operation is
        particularly useful for users who have a specific target amount of the output token
        in mind and are willing to provide the corresponding input token amount. The
        transaction is executed with consideration of current market conditions, including
        liquidity and price impact, ensuring that the trade is completed efficiently and
        effectively.
        <Info>
        **Required Allowances**

        In order to make this transaction, token allowances need to be set for the following contracts.

        - `AerodromeSlipstreamRouter`
        </Info>


        :param token_in: The symbol of the token to swap from.
        :param token_out: The symbol of the token to swap to.
        :param tick_spacing: The tick spacing of the pool
        :param amount_out: The amount of the token to swap to
        :param amount_in_maximum: The maximum amount of the token to swap from
        :param chain:
        :param sender: The address of the transaction sender.
        :param estimate_gas: Determines whether to estimate gas costs for transactions, also verifying that the transaction can be successfully executed.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.AerodromeSlipstreamBuyExactlyRequest(
            token_in=token_in,
            token_out=token_out,
            tick_spacing=tick_spacing,
            amount_out=amount_out,
            amount_in_maximum=amount_in_maximum,
            chain=chain,
            sender=sender,
            estimate_gas=estimate_gas,
        )

        req = self._build_request(
            method="POST",
            path="/v1/aerodrome_slipstream/swap/buy_exactly",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request,
                False,
                False,
                "json",
                models.AerodromeSlipstreamBuyExactlyRequest,
            ),
            allow_empty_value=None,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="v1_aerodrome_slipstream_swap_buy_exactly",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.TransactionResponse, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.HTTPValidationErrorData, http_res
            )
            raise errors.HTTPValidationError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)

        raise errors.APIError("Unexpected response received", http_res)

    async def aerodrome_slipstream_swap_buy_exactly_async(
        self,
        *,
        token_in: str,
        token_out: str,
        tick_spacing: int,
        amount_out: Union[
            models.AerodromeSlipstreamBuyExactlyRequestAmountOut,
            models.AerodromeSlipstreamBuyExactlyRequestAmountOutTypedDict,
        ],
        amount_in_maximum: Union[
            models.AerodromeSlipstreamBuyExactlyRequestAmountInMaximum,
            models.AerodromeSlipstreamBuyExactlyRequestAmountInMaximumTypedDict,
        ],
        chain: models.AerodromeSlipstreamBuyExactlyRequestChain,
        sender: str,
        estimate_gas: Optional[bool] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.TransactionResponse:
        r"""Swap - into Specified Amount

        This endpoint facilitates the trading of tokens by allowing users to specify the
        exact amount of the output token they wish to receive.

        Utilizing the Aerodrome Slipstream protocol, the system calculates the necessary
        amount of the input token required to achieve the desired output. This operation is
        particularly useful for users who have a specific target amount of the output token
        in mind and are willing to provide the corresponding input token amount. The
        transaction is executed with consideration of current market conditions, including
        liquidity and price impact, ensuring that the trade is completed efficiently and
        effectively.
        <Info>
        **Required Allowances**

        In order to make this transaction, token allowances need to be set for the following contracts.

        - `AerodromeSlipstreamRouter`
        </Info>


        :param token_in: The symbol of the token to swap from.
        :param token_out: The symbol of the token to swap to.
        :param tick_spacing: The tick spacing of the pool
        :param amount_out: The amount of the token to swap to
        :param amount_in_maximum: The maximum amount of the token to swap from
        :param chain:
        :param sender: The address of the transaction sender.
        :param estimate_gas: Determines whether to estimate gas costs for transactions, also verifying that the transaction can be successfully executed.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.AerodromeSlipstreamBuyExactlyRequest(
            token_in=token_in,
            token_out=token_out,
            tick_spacing=tick_spacing,
            amount_out=amount_out,
            amount_in_maximum=amount_in_maximum,
            chain=chain,
            sender=sender,
            estimate_gas=estimate_gas,
        )

        req = self._build_request_async(
            method="POST",
            path="/v1/aerodrome_slipstream/swap/buy_exactly",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request,
                False,
                False,
                "json",
                models.AerodromeSlipstreamBuyExactlyRequest,
            ),
            allow_empty_value=None,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="v1_aerodrome_slipstream_swap_buy_exactly",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.TransactionResponse, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.HTTPValidationErrorData, http_res
            )
            raise errors.HTTPValidationError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)

        raise errors.APIError("Unexpected response received", http_res)

    def aerodrome_slipstream_liquidity_provision_mint(
        self,
        *,
        token0: str,
        token1: str,
        tick_spacing: int,
        tick_lower: int,
        tick_upper: int,
        amount0_desired: Union[
            models.AerodromeSlipstreamMintLiquidityProvisionRequestAmount0Desired,
            models.AerodromeSlipstreamMintLiquidityProvisionRequestAmount0DesiredTypedDict,
        ],
        amount1_desired: Union[
            models.AerodromeSlipstreamMintLiquidityProvisionRequestAmount1Desired,
            models.AerodromeSlipstreamMintLiquidityProvisionRequestAmount1DesiredTypedDict,
        ],
        amount0_min: Union[
            models.AerodromeSlipstreamMintLiquidityProvisionRequestAmount0Min,
            models.AerodromeSlipstreamMintLiquidityProvisionRequestAmount0MinTypedDict,
        ],
        amount1_min: Union[
            models.AerodromeSlipstreamMintLiquidityProvisionRequestAmount1Min,
            models.AerodromeSlipstreamMintLiquidityProvisionRequestAmount1MinTypedDict,
        ],
        chain: models.AerodromeSlipstreamMintLiquidityProvisionRequestChain,
        sender: str,
        recipient: OptionalNullable[str] = UNSET,
        estimate_gas: Optional[bool] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.TransactionResponse:
        r"""Open a New LP Position

        Initiate a new Liquidity Provider (LP) position by minting tokens.

        This endpoint allows users to open a new LP position, enabling them to participate
        in liquidity provision. The minting process involves creating a new position with
        specified parameters, such as token amounts and pool details. The response will
        confirm the successful creation of the LP position, providing users with the
        necessary information to manage their newly minted position. This functionality is
        crucial for users looking to expand their liquidity provision activities, offering
        them the opportunity to engage in decentralized finance (DeFi) markets effectively.
        <Info>
        **Required Allowances**

        In order to make this transaction, token allowances need to be set for the following contracts.

        - `AerodromeSlipstreamNonfungiblePositionManager`
        </Info>


        :param token0: The symbol or address of the first token in the pair.
        :param token1: The symbol or address of the second token in the pair.
        :param tick_spacing: The tick spacing of the pool
        :param tick_lower: The lower tick of the range to mint the position in
        :param tick_upper: The upper tick of the range to mint the position in
        :param amount0_desired: The desired amount of the first token to deposit
        :param amount1_desired: The desired amount of the second token to deposit
        :param amount0_min: The minimum amount of the first token to deposit
        :param amount1_min: The minimum amount of the second token to deposit
        :param chain:
        :param sender: The address of the transaction sender.
        :param recipient: The address that will receive the LP tokens
        :param estimate_gas: Determines whether to estimate gas costs for transactions, also verifying that the transaction can be successfully executed.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.AerodromeSlipstreamMintLiquidityProvisionRequest(
            token0=token0,
            token1=token1,
            tick_spacing=tick_spacing,
            tick_lower=tick_lower,
            tick_upper=tick_upper,
            amount0_desired=amount0_desired,
            amount1_desired=amount1_desired,
            amount0_min=amount0_min,
            amount1_min=amount1_min,
            recipient=recipient,
            chain=chain,
            sender=sender,
            estimate_gas=estimate_gas,
        )

        req = self._build_request(
            method="POST",
            path="/v1/aerodrome_slipstream/liquidity_provision/mint",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request,
                False,
                False,
                "json",
                models.AerodromeSlipstreamMintLiquidityProvisionRequest,
            ),
            allow_empty_value=None,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="v1_aerodrome_slipstream_liquidity_provision_mint",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.TransactionResponse, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.HTTPValidationErrorData, http_res
            )
            raise errors.HTTPValidationError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)

        raise errors.APIError("Unexpected response received", http_res)

    async def aerodrome_slipstream_liquidity_provision_mint_async(
        self,
        *,
        token0: str,
        token1: str,
        tick_spacing: int,
        tick_lower: int,
        tick_upper: int,
        amount0_desired: Union[
            models.AerodromeSlipstreamMintLiquidityProvisionRequestAmount0Desired,
            models.AerodromeSlipstreamMintLiquidityProvisionRequestAmount0DesiredTypedDict,
        ],
        amount1_desired: Union[
            models.AerodromeSlipstreamMintLiquidityProvisionRequestAmount1Desired,
            models.AerodromeSlipstreamMintLiquidityProvisionRequestAmount1DesiredTypedDict,
        ],
        amount0_min: Union[
            models.AerodromeSlipstreamMintLiquidityProvisionRequestAmount0Min,
            models.AerodromeSlipstreamMintLiquidityProvisionRequestAmount0MinTypedDict,
        ],
        amount1_min: Union[
            models.AerodromeSlipstreamMintLiquidityProvisionRequestAmount1Min,
            models.AerodromeSlipstreamMintLiquidityProvisionRequestAmount1MinTypedDict,
        ],
        chain: models.AerodromeSlipstreamMintLiquidityProvisionRequestChain,
        sender: str,
        recipient: OptionalNullable[str] = UNSET,
        estimate_gas: Optional[bool] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.TransactionResponse:
        r"""Open a New LP Position

        Initiate a new Liquidity Provider (LP) position by minting tokens.

        This endpoint allows users to open a new LP position, enabling them to participate
        in liquidity provision. The minting process involves creating a new position with
        specified parameters, such as token amounts and pool details. The response will
        confirm the successful creation of the LP position, providing users with the
        necessary information to manage their newly minted position. This functionality is
        crucial for users looking to expand their liquidity provision activities, offering
        them the opportunity to engage in decentralized finance (DeFi) markets effectively.
        <Info>
        **Required Allowances**

        In order to make this transaction, token allowances need to be set for the following contracts.

        - `AerodromeSlipstreamNonfungiblePositionManager`
        </Info>


        :param token0: The symbol or address of the first token in the pair.
        :param token1: The symbol or address of the second token in the pair.
        :param tick_spacing: The tick spacing of the pool
        :param tick_lower: The lower tick of the range to mint the position in
        :param tick_upper: The upper tick of the range to mint the position in
        :param amount0_desired: The desired amount of the first token to deposit
        :param amount1_desired: The desired amount of the second token to deposit
        :param amount0_min: The minimum amount of the first token to deposit
        :param amount1_min: The minimum amount of the second token to deposit
        :param chain:
        :param sender: The address of the transaction sender.
        :param recipient: The address that will receive the LP tokens
        :param estimate_gas: Determines whether to estimate gas costs for transactions, also verifying that the transaction can be successfully executed.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.AerodromeSlipstreamMintLiquidityProvisionRequest(
            token0=token0,
            token1=token1,
            tick_spacing=tick_spacing,
            tick_lower=tick_lower,
            tick_upper=tick_upper,
            amount0_desired=amount0_desired,
            amount1_desired=amount1_desired,
            amount0_min=amount0_min,
            amount1_min=amount1_min,
            recipient=recipient,
            chain=chain,
            sender=sender,
            estimate_gas=estimate_gas,
        )

        req = self._build_request_async(
            method="POST",
            path="/v1/aerodrome_slipstream/liquidity_provision/mint",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request,
                False,
                False,
                "json",
                models.AerodromeSlipstreamMintLiquidityProvisionRequest,
            ),
            allow_empty_value=None,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="v1_aerodrome_slipstream_liquidity_provision_mint",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.TransactionResponse, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.HTTPValidationErrorData, http_res
            )
            raise errors.HTTPValidationError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)

        raise errors.APIError("Unexpected response received", http_res)

    def aerodrome_slipstream_liquidity_provision_increase(
        self,
        *,
        token_id: int,
        amount0_desired: Union[
            models.AerodromeSlipstreamIncreaseLiquidityProvisionRequestAmount0Desired,
            models.AerodromeSlipstreamIncreaseLiquidityProvisionRequestAmount0DesiredTypedDict,
        ],
        amount1_desired: Union[
            models.AerodromeSlipstreamIncreaseLiquidityProvisionRequestAmount1Desired,
            models.AerodromeSlipstreamIncreaseLiquidityProvisionRequestAmount1DesiredTypedDict,
        ],
        amount0_min: Union[
            models.AerodromeSlipstreamIncreaseLiquidityProvisionRequestAmount0Min,
            models.AerodromeSlipstreamIncreaseLiquidityProvisionRequestAmount0MinTypedDict,
        ],
        amount1_min: Union[
            models.AerodromeSlipstreamIncreaseLiquidityProvisionRequestAmount1Min,
            models.AerodromeSlipstreamIncreaseLiquidityProvisionRequestAmount1MinTypedDict,
        ],
        chain: models.AerodromeSlipstreamIncreaseLiquidityProvisionRequestChain,
        sender: str,
        estimate_gas: Optional[bool] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.TransactionResponse:
        r"""Increase an LP Position

        Increase the liquidity of an existing Liquidity Provider (LP) position.

        This endpoint allows users to add more tokens to their current LP position,
        enhancing their participation in liquidity provision. By increasing liquidity, users
        can potentially earn more rewards and improve their position in the pool. The
        process involves specifying additional token amounts and updating the pool details.
        The response will confirm the successful increase of the LP position, providing
        users with updated information about their enhanced position. This functionality is
        vital for users aiming to optimize their liquidity provision strategy, enabling them
        to adapt to market conditions and maximize their returns in decentralized finance
        (DeFi) markets.
        <Info>
        **Required Allowances**

        In order to make this transaction, token allowances need to be set for the following contracts.

        - `AerodromeSlipstreamRouter`
        </Info>


        :param token_id: Token ID of the NFT representing the liquidity provisioned position.
        :param amount0_desired: The desired amount of the first token to deposit
        :param amount1_desired: The desired amount of the second token to deposit
        :param amount0_min: The minimum amount of the first token to deposit
        :param amount1_min: The minimum amount of the second token to deposit
        :param chain:
        :param sender: The address of the transaction sender.
        :param estimate_gas: Determines whether to estimate gas costs for transactions, also verifying that the transaction can be successfully executed.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.AerodromeSlipstreamIncreaseLiquidityProvisionRequest(
            token_id=token_id,
            amount0_desired=amount0_desired,
            amount1_desired=amount1_desired,
            amount0_min=amount0_min,
            amount1_min=amount1_min,
            chain=chain,
            sender=sender,
            estimate_gas=estimate_gas,
        )

        req = self._build_request(
            method="POST",
            path="/v1/aerodrome_slipstream/liquidity_provision/increase",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request,
                False,
                False,
                "json",
                models.AerodromeSlipstreamIncreaseLiquidityProvisionRequest,
            ),
            allow_empty_value=None,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="v1_aerodrome_slipstream_liquidity_provision_increase",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.TransactionResponse, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.HTTPValidationErrorData, http_res
            )
            raise errors.HTTPValidationError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)

        raise errors.APIError("Unexpected response received", http_res)

    async def aerodrome_slipstream_liquidity_provision_increase_async(
        self,
        *,
        token_id: int,
        amount0_desired: Union[
            models.AerodromeSlipstreamIncreaseLiquidityProvisionRequestAmount0Desired,
            models.AerodromeSlipstreamIncreaseLiquidityProvisionRequestAmount0DesiredTypedDict,
        ],
        amount1_desired: Union[
            models.AerodromeSlipstreamIncreaseLiquidityProvisionRequestAmount1Desired,
            models.AerodromeSlipstreamIncreaseLiquidityProvisionRequestAmount1DesiredTypedDict,
        ],
        amount0_min: Union[
            models.AerodromeSlipstreamIncreaseLiquidityProvisionRequestAmount0Min,
            models.AerodromeSlipstreamIncreaseLiquidityProvisionRequestAmount0MinTypedDict,
        ],
        amount1_min: Union[
            models.AerodromeSlipstreamIncreaseLiquidityProvisionRequestAmount1Min,
            models.AerodromeSlipstreamIncreaseLiquidityProvisionRequestAmount1MinTypedDict,
        ],
        chain: models.AerodromeSlipstreamIncreaseLiquidityProvisionRequestChain,
        sender: str,
        estimate_gas: Optional[bool] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.TransactionResponse:
        r"""Increase an LP Position

        Increase the liquidity of an existing Liquidity Provider (LP) position.

        This endpoint allows users to add more tokens to their current LP position,
        enhancing their participation in liquidity provision. By increasing liquidity, users
        can potentially earn more rewards and improve their position in the pool. The
        process involves specifying additional token amounts and updating the pool details.
        The response will confirm the successful increase of the LP position, providing
        users with updated information about their enhanced position. This functionality is
        vital for users aiming to optimize their liquidity provision strategy, enabling them
        to adapt to market conditions and maximize their returns in decentralized finance
        (DeFi) markets.
        <Info>
        **Required Allowances**

        In order to make this transaction, token allowances need to be set for the following contracts.

        - `AerodromeSlipstreamRouter`
        </Info>


        :param token_id: Token ID of the NFT representing the liquidity provisioned position.
        :param amount0_desired: The desired amount of the first token to deposit
        :param amount1_desired: The desired amount of the second token to deposit
        :param amount0_min: The minimum amount of the first token to deposit
        :param amount1_min: The minimum amount of the second token to deposit
        :param chain:
        :param sender: The address of the transaction sender.
        :param estimate_gas: Determines whether to estimate gas costs for transactions, also verifying that the transaction can be successfully executed.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.AerodromeSlipstreamIncreaseLiquidityProvisionRequest(
            token_id=token_id,
            amount0_desired=amount0_desired,
            amount1_desired=amount1_desired,
            amount0_min=amount0_min,
            amount1_min=amount1_min,
            chain=chain,
            sender=sender,
            estimate_gas=estimate_gas,
        )

        req = self._build_request_async(
            method="POST",
            path="/v1/aerodrome_slipstream/liquidity_provision/increase",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request,
                False,
                False,
                "json",
                models.AerodromeSlipstreamIncreaseLiquidityProvisionRequest,
            ),
            allow_empty_value=None,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="v1_aerodrome_slipstream_liquidity_provision_increase",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.TransactionResponse, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.HTTPValidationErrorData, http_res
            )
            raise errors.HTTPValidationError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)

        raise errors.APIError("Unexpected response received", http_res)

    def aerodrome_slipstream_liquidity_provision_withdraw(
        self,
        *,
        token_id: int,
        percentage_for_withdrawal: Union[
            models.AerodromeSlipstreamWithdrawLiquidityProvisionRequestPercentageForWithdrawal,
            models.AerodromeSlipstreamWithdrawLiquidityProvisionRequestPercentageForWithdrawalTypedDict,
        ],
        chain: models.AerodromeSlipstreamWithdrawLiquidityProvisionRequestChain,
        sender: str,
        estimate_gas: Optional[bool] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.TransactionResponse:
        r"""Withdraw an LP Position

        Withdraw an existing Liquidity Provider (LP) position.

        This endpoint allows users to remove their tokens from an LP position, effectively
        closing their participation in the liquidity pool. The withdrawal process involves
        specifying the LP position to be closed, and the response will confirm the
        successful removal of liquidity, providing users with details about the withdrawn
        tokens and any remaining balances. This functionality is essential for users who
        wish to exit their liquidity provision activities, enabling them to reclaim their
        assets and potentially reallocate them to other investment opportunities. The
        endpoint ensures a smooth and secure withdrawal process, facilitating users'
        strategic management of their decentralized finance (DeFi) portfolios.
        <Info>
        **Required Allowances**

        In order to make this transaction, token allowances need to be set for the following contracts.

        - `AerodromeSlipstreamNonfungiblePositionManager`
        </Info>


        :param token_id: Token ID of the NFT representing the liquidity provisioned position.
        :param percentage_for_withdrawal: How much liquidity to take out in percentage.
        :param chain:
        :param sender: The address of the transaction sender.
        :param estimate_gas: Determines whether to estimate gas costs for transactions, also verifying that the transaction can be successfully executed.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.AerodromeSlipstreamWithdrawLiquidityProvisionRequest(
            token_id=token_id,
            percentage_for_withdrawal=percentage_for_withdrawal,
            chain=chain,
            sender=sender,
            estimate_gas=estimate_gas,
        )

        req = self._build_request(
            method="POST",
            path="/v1/aerodrome_slipstream/liquidity_provision/withdraw",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request,
                False,
                False,
                "json",
                models.AerodromeSlipstreamWithdrawLiquidityProvisionRequest,
            ),
            allow_empty_value=None,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="v1_aerodrome_slipstream_liquidity_provision_withdraw",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.TransactionResponse, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.HTTPValidationErrorData, http_res
            )
            raise errors.HTTPValidationError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)

        raise errors.APIError("Unexpected response received", http_res)

    async def aerodrome_slipstream_liquidity_provision_withdraw_async(
        self,
        *,
        token_id: int,
        percentage_for_withdrawal: Union[
            models.AerodromeSlipstreamWithdrawLiquidityProvisionRequestPercentageForWithdrawal,
            models.AerodromeSlipstreamWithdrawLiquidityProvisionRequestPercentageForWithdrawalTypedDict,
        ],
        chain: models.AerodromeSlipstreamWithdrawLiquidityProvisionRequestChain,
        sender: str,
        estimate_gas: Optional[bool] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.TransactionResponse:
        r"""Withdraw an LP Position

        Withdraw an existing Liquidity Provider (LP) position.

        This endpoint allows users to remove their tokens from an LP position, effectively
        closing their participation in the liquidity pool. The withdrawal process involves
        specifying the LP position to be closed, and the response will confirm the
        successful removal of liquidity, providing users with details about the withdrawn
        tokens and any remaining balances. This functionality is essential for users who
        wish to exit their liquidity provision activities, enabling them to reclaim their
        assets and potentially reallocate them to other investment opportunities. The
        endpoint ensures a smooth and secure withdrawal process, facilitating users'
        strategic management of their decentralized finance (DeFi) portfolios.
        <Info>
        **Required Allowances**

        In order to make this transaction, token allowances need to be set for the following contracts.

        - `AerodromeSlipstreamNonfungiblePositionManager`
        </Info>


        :param token_id: Token ID of the NFT representing the liquidity provisioned position.
        :param percentage_for_withdrawal: How much liquidity to take out in percentage.
        :param chain:
        :param sender: The address of the transaction sender.
        :param estimate_gas: Determines whether to estimate gas costs for transactions, also verifying that the transaction can be successfully executed.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.AerodromeSlipstreamWithdrawLiquidityProvisionRequest(
            token_id=token_id,
            percentage_for_withdrawal=percentage_for_withdrawal,
            chain=chain,
            sender=sender,
            estimate_gas=estimate_gas,
        )

        req = self._build_request_async(
            method="POST",
            path="/v1/aerodrome_slipstream/liquidity_provision/withdraw",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request,
                False,
                False,
                "json",
                models.AerodromeSlipstreamWithdrawLiquidityProvisionRequest,
            ),
            allow_empty_value=None,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="v1_aerodrome_slipstream_liquidity_provision_withdraw",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.TransactionResponse, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.HTTPValidationErrorData, http_res
            )
            raise errors.HTTPValidationError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)

        raise errors.APIError("Unexpected response received", http_res)
