"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from .basesdk import BaseSDK
from compass_api_sdk import errors, models, utils
from compass_api_sdk._hooks import HookContext
from compass_api_sdk.types import OptionalNullable, UNSET
from compass_api_sdk.utils.unmarshal_json_response import unmarshal_json_response
from typing import Any, Mapping, Optional, Union


class AaveV3(BaseSDK):
    def aave_aave_supported_tokens(
        self,
        *,
        chain: models.V1AaveAaveSupportedTokensChain,
        block: OptionalNullable[int] = UNSET,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.AaveSupportedTokensResponse:
        r"""Aave Supported Tokens

        Returns the list of supported tokens on Aave for the specified network, along
        with key metadata.

        For each token, the response includes:
        - The symbol and contract address.
        - Whether the token is currently enabled for supplying (depositing).
        - Whether it is enabled for borrowing.

        :param chain:
        :param block: Optional block number (defaults to latest).
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.V1AaveAaveSupportedTokensRequest(
            chain=chain,
            block=block,
        )

        req = self._build_request(
            method="GET",
            path="/v1/aave/aave_supported_tokens",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            allow_empty_value=None,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="v1_aave_aave_supported_tokens",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.AaveSupportedTokensResponse, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.HTTPValidationErrorData, http_res
            )
            raise errors.HTTPValidationError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)

        raise errors.APIError("Unexpected response received", http_res)

    async def aave_aave_supported_tokens_async(
        self,
        *,
        chain: models.V1AaveAaveSupportedTokensChain,
        block: OptionalNullable[int] = UNSET,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.AaveSupportedTokensResponse:
        r"""Aave Supported Tokens

        Returns the list of supported tokens on Aave for the specified network, along
        with key metadata.

        For each token, the response includes:
        - The symbol and contract address.
        - Whether the token is currently enabled for supplying (depositing).
        - Whether it is enabled for borrowing.

        :param chain:
        :param block: Optional block number (defaults to latest).
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.V1AaveAaveSupportedTokensRequest(
            chain=chain,
            block=block,
        )

        req = self._build_request_async(
            method="GET",
            path="/v1/aave/aave_supported_tokens",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            allow_empty_value=None,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="v1_aave_aave_supported_tokens",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.AaveSupportedTokensResponse, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.HTTPValidationErrorData, http_res
            )
            raise errors.HTTPValidationError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)

        raise errors.APIError("Unexpected response received", http_res)

    def aave_rate(
        self,
        *,
        chain: models.V1AaveRateChain,
        token: str,
        block: OptionalNullable[int] = UNSET,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.AaveRateResponse:
        r"""Interest Rates

        Returns the latest APY and APR rates for a specified token on Aave, for both
        deposits and loans.

        **Annual percentage yield (APY)** is the yearly return/cost after continuous
        compounding of the per-second rate stored on-chain. This value is the same value as
        seen the on [app.aave.com](
        https://app.aave.com/)
        but more up-to-date as it is taken directly from the
        blockchain every time this endpoint is called.

        **Annual percentage rate (APR)** is the yearly simple interest rate (no
        compounding).

        For APY/APR on loans Aave offers both stable and fixed rates on certain tokens.

        :param chain:
        :param token: The symbol or address of the token to fetch the user's position on..
        :param block: Optional block number (defaults to latest).
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.V1AaveRateRequest(
            chain=chain,
            block=block,
            token=token,
        )

        req = self._build_request(
            method="GET",
            path="/v1/aave/rate",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            allow_empty_value=None,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="v1_aave_rate",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.AaveRateResponse, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.HTTPValidationErrorData, http_res
            )
            raise errors.HTTPValidationError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)

        raise errors.APIError("Unexpected response received", http_res)

    async def aave_rate_async(
        self,
        *,
        chain: models.V1AaveRateChain,
        token: str,
        block: OptionalNullable[int] = UNSET,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.AaveRateResponse:
        r"""Interest Rates

        Returns the latest APY and APR rates for a specified token on Aave, for both
        deposits and loans.

        **Annual percentage yield (APY)** is the yearly return/cost after continuous
        compounding of the per-second rate stored on-chain. This value is the same value as
        seen the on [app.aave.com](
        https://app.aave.com/)
        but more up-to-date as it is taken directly from the
        blockchain every time this endpoint is called.

        **Annual percentage rate (APR)** is the yearly simple interest rate (no
        compounding).

        For APY/APR on loans Aave offers both stable and fixed rates on certain tokens.

        :param chain:
        :param token: The symbol or address of the token to fetch the user's position on..
        :param block: Optional block number (defaults to latest).
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.V1AaveRateRequest(
            chain=chain,
            block=block,
            token=token,
        )

        req = self._build_request_async(
            method="GET",
            path="/v1/aave/rate",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            allow_empty_value=None,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="v1_aave_rate",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.AaveRateResponse, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.HTTPValidationErrorData, http_res
            )
            raise errors.HTTPValidationError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)

        raise errors.APIError("Unexpected response received", http_res)

    def aave_avg_rate(
        self,
        *,
        chain: models.V1AaveAvgRateChain,
        token: str,
        days: int,
        block: OptionalNullable[int] = UNSET,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.AaveAvgRateResponse:
        r"""Interest Rates: Time Average

        Provides time-weighted averages of deposit and borrow rates for Aave reserves.

        :param chain:
        :param token: The symbol or address of the token..
        :param days: The number of days for which the average shall be calculated.
        :param block: Optional block number (defaults to latest).
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.V1AaveAvgRateRequest(
            chain=chain,
            block=block,
            token=token,
            days=days,
        )

        req = self._build_request(
            method="GET",
            path="/v1/aave/avg_rate",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            allow_empty_value=None,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="v1_aave_avg_rate",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.AaveAvgRateResponse, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.HTTPValidationErrorData, http_res
            )
            raise errors.HTTPValidationError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)

        raise errors.APIError("Unexpected response received", http_res)

    async def aave_avg_rate_async(
        self,
        *,
        chain: models.V1AaveAvgRateChain,
        token: str,
        days: int,
        block: OptionalNullable[int] = UNSET,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.AaveAvgRateResponse:
        r"""Interest Rates: Time Average

        Provides time-weighted averages of deposit and borrow rates for Aave reserves.

        :param chain:
        :param token: The symbol or address of the token..
        :param days: The number of days for which the average shall be calculated.
        :param block: Optional block number (defaults to latest).
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.V1AaveAvgRateRequest(
            chain=chain,
            block=block,
            token=token,
            days=days,
        )

        req = self._build_request_async(
            method="GET",
            path="/v1/aave/avg_rate",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            allow_empty_value=None,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="v1_aave_avg_rate",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.AaveAvgRateResponse, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.HTTPValidationErrorData, http_res
            )
            raise errors.HTTPValidationError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)

        raise errors.APIError("Unexpected response received", http_res)

    def aave_std_rate(
        self,
        *,
        chain: models.V1AaveStdRateChain,
        token: str,
        days: int,
        block: OptionalNullable[int] = UNSET,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.AaveSTDRateResponse:
        r"""Interest Rates: Standard Deviation

        Returns the historical standard deviation of lending and borrowing rates for Aave
        reserves, illustrating market volatility.

        :param chain:
        :param token: The symbol or address of the token..
        :param days: The number of days for which the standard deviation shall be calculated.
        :param block: Optional block number (defaults to latest).
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.V1AaveStdRateRequest(
            chain=chain,
            block=block,
            token=token,
            days=days,
        )

        req = self._build_request(
            method="GET",
            path="/v1/aave/std_rate",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            allow_empty_value=None,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="v1_aave_std_rate",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.AaveSTDRateResponse, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.HTTPValidationErrorData, http_res
            )
            raise errors.HTTPValidationError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)

        raise errors.APIError("Unexpected response received", http_res)

    async def aave_std_rate_async(
        self,
        *,
        chain: models.V1AaveStdRateChain,
        token: str,
        days: int,
        block: OptionalNullable[int] = UNSET,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.AaveSTDRateResponse:
        r"""Interest Rates: Standard Deviation

        Returns the historical standard deviation of lending and borrowing rates for Aave
        reserves, illustrating market volatility.

        :param chain:
        :param token: The symbol or address of the token..
        :param days: The number of days for which the standard deviation shall be calculated.
        :param block: Optional block number (defaults to latest).
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.V1AaveStdRateRequest(
            chain=chain,
            block=block,
            token=token,
            days=days,
        )

        req = self._build_request_async(
            method="GET",
            path="/v1/aave/std_rate",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            allow_empty_value=None,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="v1_aave_std_rate",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.AaveSTDRateResponse, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.HTTPValidationErrorData, http_res
            )
            raise errors.HTTPValidationError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)

        raise errors.APIError("Unexpected response received", http_res)

    def aave_reserve_overview(
        self,
        *,
        chain: models.V1AaveReserveOverviewChain,
        token: str,
        block: OptionalNullable[int] = UNSET,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.AaveReserveOverviewResponse:
        r"""Reserve Overview

        Returns key metrics for Aave Reserves:
        - Total Supplied (TVL) in USD
        - Total Borrowed in USD
        - Utilization Ratio

        See below for more info:

        :param chain:
        :param token: The symbol or address of the asset..
        :param block: Optional block number (defaults to latest).
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.V1AaveReserveOverviewRequest(
            chain=chain,
            block=block,
            token=token,
        )

        req = self._build_request(
            method="GET",
            path="/v1/aave/reserve_overview",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            allow_empty_value=None,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="v1_aave_reserve_overview",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.AaveReserveOverviewResponse, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.HTTPValidationErrorData, http_res
            )
            raise errors.HTTPValidationError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)

        raise errors.APIError("Unexpected response received", http_res)

    async def aave_reserve_overview_async(
        self,
        *,
        chain: models.V1AaveReserveOverviewChain,
        token: str,
        block: OptionalNullable[int] = UNSET,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.AaveReserveOverviewResponse:
        r"""Reserve Overview

        Returns key metrics for Aave Reserves:
        - Total Supplied (TVL) in USD
        - Total Borrowed in USD
        - Utilization Ratio

        See below for more info:

        :param chain:
        :param token: The symbol or address of the asset..
        :param block: Optional block number (defaults to latest).
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.V1AaveReserveOverviewRequest(
            chain=chain,
            block=block,
            token=token,
        )

        req = self._build_request_async(
            method="GET",
            path="/v1/aave/reserve_overview",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            allow_empty_value=None,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="v1_aave_reserve_overview",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.AaveReserveOverviewResponse, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.HTTPValidationErrorData, http_res
            )
            raise errors.HTTPValidationError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)

        raise errors.APIError("Unexpected response received", http_res)

    def aave_token_price(
        self,
        *,
        chain: models.V1AaveTokenPriceChain,
        token: str,
        block: OptionalNullable[int] = UNSET,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.AaveTokenPriceResponse:
        r"""Token Prices

        This endpoint retrieves the current price of a specified token in USD as
        determined by the Aave protocol.

        It utilizes the Aave V3 Oracle to fetch the token price, ensuring accurate and up-
        to-date information. The request requires the token identifier and the blockchain
        network (chain) on which the token resides. The response provides the token price in
        a standardized format, converted from Wei to the base currency decimals defined by
        Aave.

        :param chain:
        :param token: The symbol or address of the asset whose price you want..
        :param block: Optional block number (defaults to latest).
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.V1AaveTokenPriceRequest(
            chain=chain,
            block=block,
            token=token,
        )

        req = self._build_request(
            method="GET",
            path="/v1/aave/token_price",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            allow_empty_value=None,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="v1_aave_token_price",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.AaveTokenPriceResponse, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.HTTPValidationErrorData, http_res
            )
            raise errors.HTTPValidationError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)

        raise errors.APIError("Unexpected response received", http_res)

    async def aave_token_price_async(
        self,
        *,
        chain: models.V1AaveTokenPriceChain,
        token: str,
        block: OptionalNullable[int] = UNSET,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.AaveTokenPriceResponse:
        r"""Token Prices

        This endpoint retrieves the current price of a specified token in USD as
        determined by the Aave protocol.

        It utilizes the Aave V3 Oracle to fetch the token price, ensuring accurate and up-
        to-date information. The request requires the token identifier and the blockchain
        network (chain) on which the token resides. The response provides the token price in
        a standardized format, converted from Wei to the base currency decimals defined by
        Aave.

        :param chain:
        :param token: The symbol or address of the asset whose price you want..
        :param block: Optional block number (defaults to latest).
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.V1AaveTokenPriceRequest(
            chain=chain,
            block=block,
            token=token,
        )

        req = self._build_request_async(
            method="GET",
            path="/v1/aave/token_price",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            allow_empty_value=None,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="v1_aave_token_price",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.AaveTokenPriceResponse, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.HTTPValidationErrorData, http_res
            )
            raise errors.HTTPValidationError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)

        raise errors.APIError("Unexpected response received", http_res)

    def aave_liquidity_change(
        self,
        *,
        chain: models.V1AaveLiquidityChangeChain,
        token: str,
        start_block: int,
        end_block: int,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.AaveLiquidityChangeResponse:
        r"""Liquidity Index

        This endpoint retrieves the change in the reserve liquidity index between two
        provided blocks.

        This is then converted to a percentage change. The liquidity index represents the
        change in debt and interest accrual over each block. Aave does not store individual
        user balances directly. Instead, it keeps a scaled balance and uses the liquidity
        index to compute real balances dynamically. If a user was to have deposited tokens
        at the start block, a positive liquidity index change will represent accrued
        interest and a profit. If tokens were borrowed at the start block, this debt will
        increase, compound on itself and represent large debt. The reverse in both cases is
        true if the liquidity index is negative.

        :param chain:
        :param token: The symbol or address of the asset to get liquidity change for..
        :param start_block: The start block to calculate liquidity change from.
        :param end_block: The end block to calculate liquidity change to.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.V1AaveLiquidityChangeRequest(
            chain=chain,
            token=token,
            start_block=start_block,
            end_block=end_block,
        )

        req = self._build_request(
            method="GET",
            path="/v1/aave/liquidity/change",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            allow_empty_value=None,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="v1_aave_liquidity_change",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.AaveLiquidityChangeResponse, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.HTTPValidationErrorData, http_res
            )
            raise errors.HTTPValidationError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)

        raise errors.APIError("Unexpected response received", http_res)

    async def aave_liquidity_change_async(
        self,
        *,
        chain: models.V1AaveLiquidityChangeChain,
        token: str,
        start_block: int,
        end_block: int,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.AaveLiquidityChangeResponse:
        r"""Liquidity Index

        This endpoint retrieves the change in the reserve liquidity index between two
        provided blocks.

        This is then converted to a percentage change. The liquidity index represents the
        change in debt and interest accrual over each block. Aave does not store individual
        user balances directly. Instead, it keeps a scaled balance and uses the liquidity
        index to compute real balances dynamically. If a user was to have deposited tokens
        at the start block, a positive liquidity index change will represent accrued
        interest and a profit. If tokens were borrowed at the start block, this debt will
        increase, compound on itself and represent large debt. The reverse in both cases is
        true if the liquidity index is negative.

        :param chain:
        :param token: The symbol or address of the asset to get liquidity change for..
        :param start_block: The start block to calculate liquidity change from.
        :param end_block: The end block to calculate liquidity change to.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.V1AaveLiquidityChangeRequest(
            chain=chain,
            token=token,
            start_block=start_block,
            end_block=end_block,
        )

        req = self._build_request_async(
            method="GET",
            path="/v1/aave/liquidity/change",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            allow_empty_value=None,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="v1_aave_liquidity_change",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.AaveLiquidityChangeResponse, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.HTTPValidationErrorData, http_res
            )
            raise errors.HTTPValidationError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)

        raise errors.APIError("Unexpected response received", http_res)

    def aave_user_position_summary(
        self,
        *,
        chain: models.V1AaveUserPositionSummaryChain,
        user: str,
        block: OptionalNullable[int] = UNSET,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.AaveUserPositionSummaryResponse:
        r"""Positions - Total

        This endpoint retrieves a comprehensive summary of a user's position on the AAVE
        platform.

        It provides key financial metrics including the total collateral deposited, total
        debt accrued, available borrowing capacity, liquidation threshold, maximum loan-to-
        value ratio, and the health factor of the user's account. These metrics are
        calculated by aggregating data across all open positions held by the user, offering
        a holistic view of their financial standing within the AAVE ecosystem.

        :param chain:
        :param user: The user to get position summary for.
        :param block: Optional block number (defaults to latest).
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.V1AaveUserPositionSummaryRequest(
            chain=chain,
            block=block,
            user=user,
        )

        req = self._build_request(
            method="GET",
            path="/v1/aave/user_position_summary",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            allow_empty_value=None,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="v1_aave_user_position_summary",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(
                models.AaveUserPositionSummaryResponse, http_res
            )
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.HTTPValidationErrorData, http_res
            )
            raise errors.HTTPValidationError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)

        raise errors.APIError("Unexpected response received", http_res)

    async def aave_user_position_summary_async(
        self,
        *,
        chain: models.V1AaveUserPositionSummaryChain,
        user: str,
        block: OptionalNullable[int] = UNSET,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.AaveUserPositionSummaryResponse:
        r"""Positions - Total

        This endpoint retrieves a comprehensive summary of a user's position on the AAVE
        platform.

        It provides key financial metrics including the total collateral deposited, total
        debt accrued, available borrowing capacity, liquidation threshold, maximum loan-to-
        value ratio, and the health factor of the user's account. These metrics are
        calculated by aggregating data across all open positions held by the user, offering
        a holistic view of their financial standing within the AAVE ecosystem.

        :param chain:
        :param user: The user to get position summary for.
        :param block: Optional block number (defaults to latest).
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.V1AaveUserPositionSummaryRequest(
            chain=chain,
            block=block,
            user=user,
        )

        req = self._build_request_async(
            method="GET",
            path="/v1/aave/user_position_summary",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            allow_empty_value=None,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="v1_aave_user_position_summary",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(
                models.AaveUserPositionSummaryResponse, http_res
            )
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.HTTPValidationErrorData, http_res
            )
            raise errors.HTTPValidationError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)

        raise errors.APIError("Unexpected response received", http_res)

    def aave_user_position_per_token(
        self,
        *,
        chain: models.V1AaveUserPositionPerTokenChain,
        user: str,
        token: str,
        block: OptionalNullable[int] = UNSET,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.AaveUserPositionPerTokenResponse:
        r"""Positions - per Token

        This endpoint retrieves the user's position for a specific token on the AAVE
        platform.

        It provides key financial metrics including the current aToken balance, current
        stable debt, current variable debt, principal stable debt, principal variable debt,
        stable borrow rate, stable borrow rate for new loans, variable borrow rate, and
        liquidity rate. These metrics are calculated by aggregating data across all open
        positions held by the user for the specified token, offering a detailed view of
        their financial standing within the AAVE ecosystem.

        :param chain:
        :param user: The user to fetch the token-specific position of.
        :param token: The symbol or address of the asset to fetch the user's position on..
        :param block: Optional block number (defaults to latest).
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.V1AaveUserPositionPerTokenRequest(
            chain=chain,
            block=block,
            user=user,
            token=token,
        )

        req = self._build_request(
            method="GET",
            path="/v1/aave/user_position_per_token",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            allow_empty_value=None,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="v1_aave_user_position_per_token",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(
                models.AaveUserPositionPerTokenResponse, http_res
            )
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.HTTPValidationErrorData, http_res
            )
            raise errors.HTTPValidationError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)

        raise errors.APIError("Unexpected response received", http_res)

    async def aave_user_position_per_token_async(
        self,
        *,
        chain: models.V1AaveUserPositionPerTokenChain,
        user: str,
        token: str,
        block: OptionalNullable[int] = UNSET,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.AaveUserPositionPerTokenResponse:
        r"""Positions - per Token

        This endpoint retrieves the user's position for a specific token on the AAVE
        platform.

        It provides key financial metrics including the current aToken balance, current
        stable debt, current variable debt, principal stable debt, principal variable debt,
        stable borrow rate, stable borrow rate for new loans, variable borrow rate, and
        liquidity rate. These metrics are calculated by aggregating data across all open
        positions held by the user for the specified token, offering a detailed view of
        their financial standing within the AAVE ecosystem.

        :param chain:
        :param user: The user to fetch the token-specific position of.
        :param token: The symbol or address of the asset to fetch the user's position on..
        :param block: Optional block number (defaults to latest).
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.V1AaveUserPositionPerTokenRequest(
            chain=chain,
            block=block,
            user=user,
            token=token,
        )

        req = self._build_request_async(
            method="GET",
            path="/v1/aave/user_position_per_token",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            allow_empty_value=None,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="v1_aave_user_position_per_token",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(
                models.AaveUserPositionPerTokenResponse, http_res
            )
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.HTTPValidationErrorData, http_res
            )
            raise errors.HTTPValidationError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)

        raise errors.APIError("Unexpected response received", http_res)

    def aave_historical_transactions(
        self,
        *,
        chain: models.V1AaveHistoricalTransactionsChain,
        user_address: str,
        offset: Optional[int] = None,
        limit: Optional[int] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.AaveHistoricalTransactionsResponse:
        r"""Historical Transactions

        This endpoint retrieves historical transactions for a user on the AAVE platform.

        It returns a list of transactions including deposits, withdrawals, borrows, and
        repayments. Each transaction includes details such as the token, amount, timestamp,
        and transaction type. This provides a comprehensive view of the user's historical
        activity within the AAVE protocol.

        ⚠️ Data comes from the official Aave subgraph (
        https://github.com/aave/protocol-subgraphs)
        and thus this particular endpoint may be less reliable than our other endpoints. ⚠️

        :param chain:
        :param user_address: The address of the user to get historical transactions for.
        :param offset: The offset of the first item to return.
        :param limit: The number of items to return.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.V1AaveHistoricalTransactionsRequest(
            offset=offset,
            limit=limit,
            chain=chain,
            user_address=user_address,
        )

        req = self._build_request(
            method="GET",
            path="/v1/aave/historical_transactions",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            allow_empty_value=None,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="v1_aave_historical_transactions",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(
                models.AaveHistoricalTransactionsResponse, http_res
            )
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.HTTPValidationErrorData, http_res
            )
            raise errors.HTTPValidationError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)

        raise errors.APIError("Unexpected response received", http_res)

    async def aave_historical_transactions_async(
        self,
        *,
        chain: models.V1AaveHistoricalTransactionsChain,
        user_address: str,
        offset: Optional[int] = None,
        limit: Optional[int] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.AaveHistoricalTransactionsResponse:
        r"""Historical Transactions

        This endpoint retrieves historical transactions for a user on the AAVE platform.

        It returns a list of transactions including deposits, withdrawals, borrows, and
        repayments. Each transaction includes details such as the token, amount, timestamp,
        and transaction type. This provides a comprehensive view of the user's historical
        activity within the AAVE protocol.

        ⚠️ Data comes from the official Aave subgraph (
        https://github.com/aave/protocol-subgraphs)
        and thus this particular endpoint may be less reliable than our other endpoints. ⚠️

        :param chain:
        :param user_address: The address of the user to get historical transactions for.
        :param offset: The offset of the first item to return.
        :param limit: The number of items to return.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.V1AaveHistoricalTransactionsRequest(
            offset=offset,
            limit=limit,
            chain=chain,
            user_address=user_address,
        )

        req = self._build_request_async(
            method="GET",
            path="/v1/aave/historical_transactions",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            allow_empty_value=None,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="v1_aave_historical_transactions",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(
                models.AaveHistoricalTransactionsResponse, http_res
            )
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.HTTPValidationErrorData, http_res
            )
            raise errors.HTTPValidationError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)

        raise errors.APIError("Unexpected response received", http_res)

    def aave_supply(
        self,
        *,
        token: str,
        amount: Union[
            models.AaveSupplyRequestAmount, models.AaveSupplyRequestAmountTypedDict
        ],
        chain: models.AaveSupplyRequestChain,
        sender: str,
        on_behalf_of: OptionalNullable[str] = UNSET,
        estimate_gas: Optional[bool] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.TransactionResponse:
        r"""Supply/Lend

        By supplying assets, users can earn interest on their deposits.

        The supplied collateral can be used as a basis for borrowing other assets, allowing
        users to leverage their positions. In combination with a trading protocol, this can
        create leverage.

        Overall, this endpoint is a critical component for users looking to maximize their
        asset utility within the AAVEv3 ecosystem, providing both earning potential and
        borrowing flexibility.
        <Info>
        **Required Allowances**

        In order to make this transaction, token allowances need to be set for the following contracts.

        - `AaveV3Pool`
        </Info>


        :param token: The symbol or address of the underlying asset to supply as collateral. You can borrow against it..
        :param amount: The amount of the asset to supply
        :param chain:
        :param sender: The address of the transaction sender.
        :param on_behalf_of: The address on behalf of whom the supply is made. Defaults to the transaction sender.
        :param estimate_gas: Determines whether to estimate gas costs for transactions, also verifying that the transaction can be successfully executed.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.AaveSupplyRequest(
            token=token,
            amount=amount,
            on_behalf_of=on_behalf_of,
            chain=chain,
            sender=sender,
            estimate_gas=estimate_gas,
        )

        req = self._build_request(
            method="POST",
            path="/v1/aave/supply",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request, False, False, "json", models.AaveSupplyRequest
            ),
            allow_empty_value=None,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="v1_aave_supply",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.TransactionResponse, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.HTTPValidationErrorData, http_res
            )
            raise errors.HTTPValidationError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)

        raise errors.APIError("Unexpected response received", http_res)

    async def aave_supply_async(
        self,
        *,
        token: str,
        amount: Union[
            models.AaveSupplyRequestAmount, models.AaveSupplyRequestAmountTypedDict
        ],
        chain: models.AaveSupplyRequestChain,
        sender: str,
        on_behalf_of: OptionalNullable[str] = UNSET,
        estimate_gas: Optional[bool] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.TransactionResponse:
        r"""Supply/Lend

        By supplying assets, users can earn interest on their deposits.

        The supplied collateral can be used as a basis for borrowing other assets, allowing
        users to leverage their positions. In combination with a trading protocol, this can
        create leverage.

        Overall, this endpoint is a critical component for users looking to maximize their
        asset utility within the AAVEv3 ecosystem, providing both earning potential and
        borrowing flexibility.
        <Info>
        **Required Allowances**

        In order to make this transaction, token allowances need to be set for the following contracts.

        - `AaveV3Pool`
        </Info>


        :param token: The symbol or address of the underlying asset to supply as collateral. You can borrow against it..
        :param amount: The amount of the asset to supply
        :param chain:
        :param sender: The address of the transaction sender.
        :param on_behalf_of: The address on behalf of whom the supply is made. Defaults to the transaction sender.
        :param estimate_gas: Determines whether to estimate gas costs for transactions, also verifying that the transaction can be successfully executed.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.AaveSupplyRequest(
            token=token,
            amount=amount,
            on_behalf_of=on_behalf_of,
            chain=chain,
            sender=sender,
            estimate_gas=estimate_gas,
        )

        req = self._build_request_async(
            method="POST",
            path="/v1/aave/supply",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request, False, False, "json", models.AaveSupplyRequest
            ),
            allow_empty_value=None,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="v1_aave_supply",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.TransactionResponse, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.HTTPValidationErrorData, http_res
            )
            raise errors.HTTPValidationError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)

        raise errors.APIError("Unexpected response received", http_res)

    def aave_borrow(
        self,
        *,
        token: str,
        amount: Union[
            models.AaveBorrowRequestAmount, models.AaveBorrowRequestAmountTypedDict
        ],
        interest_rate_mode: models.InterestRateMode,
        chain: models.AaveBorrowRequestChain,
        sender: str,
        on_behalf_of: OptionalNullable[str] = UNSET,
        estimate_gas: Optional[bool] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.TransactionResponse:
        r"""Borrow

        You will pay interest for your borrows.

        Price changes in the assets may lead to some or all of your collateral being
        liquidated, if the borrow position becomes unhealthy.
        <Info>
        **Required Allowances**

        In order to make this transaction, token allowances need to be set for the following contracts.

        - `AaveV3Pool`
        </Info>


        :param token: The symbol or address of the underlying asset to borrow..
        :param amount: The amount of the asset to borrow
        :param interest_rate_mode: On AAVE there are 2 different interest modes.

            A stable (but typically higher rate), or a variable rate.
        :param chain:
        :param sender: The address of the transaction sender.
        :param on_behalf_of: The address on behalf of whom the supply is made
        :param estimate_gas: Determines whether to estimate gas costs for transactions, also verifying that the transaction can be successfully executed.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.AaveBorrowRequest(
            token=token,
            amount=amount,
            interest_rate_mode=interest_rate_mode,
            on_behalf_of=on_behalf_of,
            chain=chain,
            sender=sender,
            estimate_gas=estimate_gas,
        )

        req = self._build_request(
            method="POST",
            path="/v1/aave/borrow",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request, False, False, "json", models.AaveBorrowRequest
            ),
            allow_empty_value=None,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="v1_aave_borrow",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.TransactionResponse, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.HTTPValidationErrorData, http_res
            )
            raise errors.HTTPValidationError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)

        raise errors.APIError("Unexpected response received", http_res)

    async def aave_borrow_async(
        self,
        *,
        token: str,
        amount: Union[
            models.AaveBorrowRequestAmount, models.AaveBorrowRequestAmountTypedDict
        ],
        interest_rate_mode: models.InterestRateMode,
        chain: models.AaveBorrowRequestChain,
        sender: str,
        on_behalf_of: OptionalNullable[str] = UNSET,
        estimate_gas: Optional[bool] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.TransactionResponse:
        r"""Borrow

        You will pay interest for your borrows.

        Price changes in the assets may lead to some or all of your collateral being
        liquidated, if the borrow position becomes unhealthy.
        <Info>
        **Required Allowances**

        In order to make this transaction, token allowances need to be set for the following contracts.

        - `AaveV3Pool`
        </Info>


        :param token: The symbol or address of the underlying asset to borrow..
        :param amount: The amount of the asset to borrow
        :param interest_rate_mode: On AAVE there are 2 different interest modes.

            A stable (but typically higher rate), or a variable rate.
        :param chain:
        :param sender: The address of the transaction sender.
        :param on_behalf_of: The address on behalf of whom the supply is made
        :param estimate_gas: Determines whether to estimate gas costs for transactions, also verifying that the transaction can be successfully executed.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.AaveBorrowRequest(
            token=token,
            amount=amount,
            interest_rate_mode=interest_rate_mode,
            on_behalf_of=on_behalf_of,
            chain=chain,
            sender=sender,
            estimate_gas=estimate_gas,
        )

        req = self._build_request_async(
            method="POST",
            path="/v1/aave/borrow",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request, False, False, "json", models.AaveBorrowRequest
            ),
            allow_empty_value=None,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="v1_aave_borrow",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.TransactionResponse, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.HTTPValidationErrorData, http_res
            )
            raise errors.HTTPValidationError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)

        raise errors.APIError("Unexpected response received", http_res)

    def aave_repay(
        self,
        *,
        token: str,
        amount: Union[
            models.AaveRepayRequestAmount, models.AaveRepayRequestAmountTypedDict
        ],
        interest_rate_mode: models.InterestRateMode,
        chain: models.AaveRepayRequestChain,
        sender: str,
        on_behalf_of: OptionalNullable[str] = UNSET,
        estimate_gas: Optional[bool] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.TransactionResponse:
        r"""Repay Loans

        This endpoint allows users to repay a portion or the entirety of their borrowed
        tokens on the Aave platform.

        By repaying borrowed amounts, users can improve their health factor, which is a
        measure of the safety of their loan position. A higher health factor reduces the
        risk of liquidation, ensuring a more secure borrowing experience. The endpoint
        requires specifying the chain and the details of the repayment transaction,
        including the amount and the asset to be repaid.
        <Info>
        **Required Allowances**

        In order to make this transaction, token allowances need to be set for the following contracts.

        - `AaveV3Pool`
        </Info>


        :param token: The symbol of the underlying asset to repay..
        :param amount: The amount of the asset to repay
        :param interest_rate_mode: On AAVE there are 2 different interest modes.

            A stable (but typically higher rate), or a variable rate.
        :param chain:
        :param sender: The address of the transaction sender.
        :param on_behalf_of: The address on behalf of whom the supply is made
        :param estimate_gas: Determines whether to estimate gas costs for transactions, also verifying that the transaction can be successfully executed.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.AaveRepayRequest(
            token=token,
            amount=amount,
            interest_rate_mode=interest_rate_mode,
            on_behalf_of=on_behalf_of,
            chain=chain,
            sender=sender,
            estimate_gas=estimate_gas,
        )

        req = self._build_request(
            method="POST",
            path="/v1/aave/repay",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request, False, False, "json", models.AaveRepayRequest
            ),
            allow_empty_value=None,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="v1_aave_repay",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.TransactionResponse, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.HTTPValidationErrorData, http_res
            )
            raise errors.HTTPValidationError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)

        raise errors.APIError("Unexpected response received", http_res)

    async def aave_repay_async(
        self,
        *,
        token: str,
        amount: Union[
            models.AaveRepayRequestAmount, models.AaveRepayRequestAmountTypedDict
        ],
        interest_rate_mode: models.InterestRateMode,
        chain: models.AaveRepayRequestChain,
        sender: str,
        on_behalf_of: OptionalNullable[str] = UNSET,
        estimate_gas: Optional[bool] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.TransactionResponse:
        r"""Repay Loans

        This endpoint allows users to repay a portion or the entirety of their borrowed
        tokens on the Aave platform.

        By repaying borrowed amounts, users can improve their health factor, which is a
        measure of the safety of their loan position. A higher health factor reduces the
        risk of liquidation, ensuring a more secure borrowing experience. The endpoint
        requires specifying the chain and the details of the repayment transaction,
        including the amount and the asset to be repaid.
        <Info>
        **Required Allowances**

        In order to make this transaction, token allowances need to be set for the following contracts.

        - `AaveV3Pool`
        </Info>


        :param token: The symbol of the underlying asset to repay..
        :param amount: The amount of the asset to repay
        :param interest_rate_mode: On AAVE there are 2 different interest modes.

            A stable (but typically higher rate), or a variable rate.
        :param chain:
        :param sender: The address of the transaction sender.
        :param on_behalf_of: The address on behalf of whom the supply is made
        :param estimate_gas: Determines whether to estimate gas costs for transactions, also verifying that the transaction can be successfully executed.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.AaveRepayRequest(
            token=token,
            amount=amount,
            interest_rate_mode=interest_rate_mode,
            on_behalf_of=on_behalf_of,
            chain=chain,
            sender=sender,
            estimate_gas=estimate_gas,
        )

        req = self._build_request_async(
            method="POST",
            path="/v1/aave/repay",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request, False, False, "json", models.AaveRepayRequest
            ),
            allow_empty_value=None,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="v1_aave_repay",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.TransactionResponse, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.HTTPValidationErrorData, http_res
            )
            raise errors.HTTPValidationError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)

        raise errors.APIError("Unexpected response received", http_res)

    def aave_withdraw(
        self,
        *,
        token: str,
        amount: Union[
            models.AaveWithdrawRequestAmount, models.AaveWithdrawRequestAmountTypedDict
        ],
        recipient: str,
        chain: models.AaveWithdrawRequestChain,
        sender: str,
        estimate_gas: Optional[bool] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.TransactionResponse:
        r"""Unstake

        This endpoint facilitates the withdrawal of collateral from the Aave protocol.

        Users can withdraw a portion or all of their collateral, which may increase the risk
        of liquidation if there are outstanding borrows. The withdrawal process also
        includes the collection of any interest earned on the collateral. It is important
        for users to carefully consider their outstanding debts and the potential impact on
        their liquidation threshold before proceeding with a withdrawal. This endpoint is
        designed to provide a seamless and efficient way to manage your collateral within
        the Aave ecosystem.
        <Info>
        **Required Allowances**

        In order to make this transaction, token allowances need to be set for the following contracts.

        - `AaveV3Pool`
        </Info>


        :param token: The symbol of the underlying asset to withdraw..
        :param amount: The amount of the asset to withdraw
        :param recipient: The address of the recipient of the withdrawn funds.
        :param chain:
        :param sender: The address of the transaction sender.
        :param estimate_gas: Determines whether to estimate gas costs for transactions, also verifying that the transaction can be successfully executed.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.AaveWithdrawRequest(
            token=token,
            amount=amount,
            recipient=recipient,
            chain=chain,
            sender=sender,
            estimate_gas=estimate_gas,
        )

        req = self._build_request(
            method="POST",
            path="/v1/aave/withdraw",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request, False, False, "json", models.AaveWithdrawRequest
            ),
            allow_empty_value=None,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="v1_aave_withdraw",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.TransactionResponse, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.HTTPValidationErrorData, http_res
            )
            raise errors.HTTPValidationError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)

        raise errors.APIError("Unexpected response received", http_res)

    async def aave_withdraw_async(
        self,
        *,
        token: str,
        amount: Union[
            models.AaveWithdrawRequestAmount, models.AaveWithdrawRequestAmountTypedDict
        ],
        recipient: str,
        chain: models.AaveWithdrawRequestChain,
        sender: str,
        estimate_gas: Optional[bool] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.TransactionResponse:
        r"""Unstake

        This endpoint facilitates the withdrawal of collateral from the Aave protocol.

        Users can withdraw a portion or all of their collateral, which may increase the risk
        of liquidation if there are outstanding borrows. The withdrawal process also
        includes the collection of any interest earned on the collateral. It is important
        for users to carefully consider their outstanding debts and the potential impact on
        their liquidation threshold before proceeding with a withdrawal. This endpoint is
        designed to provide a seamless and efficient way to manage your collateral within
        the Aave ecosystem.
        <Info>
        **Required Allowances**

        In order to make this transaction, token allowances need to be set for the following contracts.

        - `AaveV3Pool`
        </Info>


        :param token: The symbol of the underlying asset to withdraw..
        :param amount: The amount of the asset to withdraw
        :param recipient: The address of the recipient of the withdrawn funds.
        :param chain:
        :param sender: The address of the transaction sender.
        :param estimate_gas: Determines whether to estimate gas costs for transactions, also verifying that the transaction can be successfully executed.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.AaveWithdrawRequest(
            token=token,
            amount=amount,
            recipient=recipient,
            chain=chain,
            sender=sender,
            estimate_gas=estimate_gas,
        )

        req = self._build_request_async(
            method="POST",
            path="/v1/aave/withdraw",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request, False, False, "json", models.AaveWithdrawRequest
            ),
            allow_empty_value=None,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="v1_aave_withdraw",
                oauth2_scopes=None,
                security_source=self.sdk_configuration.security,
            ),
            request=req,
            error_status_codes=["422", "4XX", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return unmarshal_json_response(models.TransactionResponse, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.HTTPValidationErrorData, http_res
            )
            raise errors.HTTPValidationError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.APIError("API error occurred", http_res, http_res_text)

        raise errors.APIError("Unexpected response received", http_res)
