# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at
#
#   http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.
def get_provider_info():
    return {
        'package-name': 'apache-airflow-providers-qubole',
        'name': 'Qubole',
        'description': '`Qubole <https://www.qubole.com/>`__\n',
        'versions': ['1.0.0'],
        'integrations': [
            {'integration-name': 'Qubole', 'external-doc-url': 'https://www.qubole.com/', 'tags': ['service']}
        ],
        'operators': [
            {
                'integration-name': 'Qubole',
                'python-modules': [
                    'airflow.providers.qubole.operators.qubole',
                    'airflow.providers.qubole.operators.qubole_check',
                ],
            }
        ],
        'sensors': [
            {'integration-name': 'Qubole', 'python-modules': ['airflow.providers.qubole.sensors.qubole']}
        ],
        'hooks': [
            {
                'integration-name': 'Qubole',
                'python-modules': [
                    'airflow.providers.qubole.hooks.qubole',
                    'airflow.providers.qubole.hooks.qubole_check',
                ],
            }
        ],
        'hook-class-names': ['airflow.providers.qubole.hooks.qubole.QuboleHook'],
        'extra-links': ['airflow.providers.qubole.operators.qubole.QDSLink'],
    }
