define(["@jupyter-widgets/base"], function(__WEBPACK_EXTERNAL_MODULE_854__) { return /******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId]) {
/******/ 			return installedModules[moduleId].exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			i: moduleId,
/******/ 			l: false,
/******/ 			exports: {}
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.l = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// define getter function for harmony exports
/******/ 	__webpack_require__.d = function(exports, name, getter) {
/******/ 		if(!__webpack_require__.o(exports, name)) {
/******/ 			Object.defineProperty(exports, name, {
/******/ 				configurable: false,
/******/ 				enumerable: true,
/******/ 				get: getter
/******/ 			});
/******/ 		}
/******/ 	};
/******/
/******/ 	// getDefaultExport function for compatibility with non-harmony modules
/******/ 	__webpack_require__.n = function(module) {
/******/ 		var getter = module && module.__esModule ?
/******/ 			function getDefault() { return module['default']; } :
/******/ 			function getModuleExports() { return module; };
/******/ 		__webpack_require__.d(getter, 'a', getter);
/******/ 		return getter;
/******/ 	};
/******/
/******/ 	// Object.prototype.hasOwnProperty.call
/******/ 	__webpack_require__.o = function(object, property) { return Object.prototype.hasOwnProperty.call(object, property); };
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "";
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(__webpack_require__.s = 380);
/******/ })
/************************************************************************/
/******/ ([
/* 0 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (immutable) */ __webpack_exports__["g"] = isDisposable;
/* harmony export (immutable) */ __webpack_exports__["f"] = dispose;
/* harmony export (immutable) */ __webpack_exports__["e"] = combinedDisposable;
/* harmony export (immutable) */ __webpack_exports__["h"] = toDisposable;
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "b", function() { return DisposableStore; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return Disposable; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "d", function() { return MutableDisposable; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "c", function() { return ImmortalReference; });
/**
 * Enables logging of potentially leaked disposables.
 *
 * A disposable is considered leaked if it is not disposed or not registered as the child of
 * another disposable. This tracking is very simple an only works for classes that either
 * extend Disposable or use a DisposableStore. This means there are a lot of false positives.
 */
var TRACK_DISPOSABLES = false;
var __is_disposable_tracked__ = '__is_disposable_tracked__';
function markTracked(x) {
    if (!TRACK_DISPOSABLES) {
        return;
    }
    if (x && x !== Disposable.None) {
        try {
            x[__is_disposable_tracked__] = true;
        }
        catch (_a) {
            // noop
        }
    }
}
function trackDisposable(x) {
    if (!TRACK_DISPOSABLES) {
        return x;
    }
    var stack = new Error('Potentially leaked disposable').stack;
    setTimeout(function () {
        if (!x[__is_disposable_tracked__]) {
            console.log(stack);
        }
    }, 3000);
    return x;
}
function isDisposable(thing) {
    return typeof thing.dispose === 'function'
        && thing.dispose.length === 0;
}
function dispose(disposables) {
    if (Array.isArray(disposables)) {
        disposables.forEach(function (d) {
            if (d) {
                markTracked(d);
                d.dispose();
            }
        });
        return [];
    }
    else if (disposables) {
        markTracked(disposables);
        disposables.dispose();
        return disposables;
    }
    else {
        return undefined;
    }
}
function combinedDisposable() {
    var disposables = [];
    for (var _i = 0; _i < arguments.length; _i++) {
        disposables[_i] = arguments[_i];
    }
    disposables.forEach(markTracked);
    return trackDisposable({ dispose: function () { return dispose(disposables); } });
}
function toDisposable(fn) {
    var self = trackDisposable({
        dispose: function () {
            markTracked(self);
            fn();
        }
    });
    return self;
}
var DisposableStore = /** @class */ (function () {
    function DisposableStore() {
        this._toDispose = new Set();
        this._isDisposed = false;
    }
    /**
     * Dispose of all registered disposables and mark this object as disposed.
     *
     * Any future disposables added to this object will be disposed of on `add`.
     */
    DisposableStore.prototype.dispose = function () {
        if (this._isDisposed) {
            return;
        }
        markTracked(this);
        this._isDisposed = true;
        this.clear();
    };
    /**
     * Dispose of all registered disposables but do not mark this object as disposed.
     */
    DisposableStore.prototype.clear = function () {
        this._toDispose.forEach(function (item) { return item.dispose(); });
        this._toDispose.clear();
    };
    DisposableStore.prototype.add = function (t) {
        if (!t) {
            return t;
        }
        if (t === this) {
            throw new Error('Cannot register a disposable on itself!');
        }
        markTracked(t);
        if (this._isDisposed) {
            console.warn(new Error('Trying to add a disposable to a DisposableStore that has already been disposed of. The added object will be leaked!').stack);
        }
        else {
            this._toDispose.add(t);
        }
        return t;
    };
    return DisposableStore;
}());

var Disposable = /** @class */ (function () {
    function Disposable() {
        this._store = new DisposableStore();
        trackDisposable(this);
    }
    Disposable.prototype.dispose = function () {
        markTracked(this);
        this._store.dispose();
    };
    Disposable.prototype._register = function (t) {
        if (t === this) {
            throw new Error('Cannot register a disposable on itself!');
        }
        return this._store.add(t);
    };
    Disposable.None = Object.freeze({ dispose: function () { } });
    return Disposable;
}());

/**
 * Manages the lifecycle of a disposable value that may be changed.
 *
 * This ensures that when the disposable value is changed, the previously held disposable is disposed of. You can
 * also register a `MutableDisposable` on a `Disposable` to ensure it is automatically cleaned up.
 */
var MutableDisposable = /** @class */ (function () {
    function MutableDisposable() {
        this._isDisposed = false;
        trackDisposable(this);
    }
    Object.defineProperty(MutableDisposable.prototype, "value", {
        get: function () {
            return this._isDisposed ? undefined : this._value;
        },
        set: function (value) {
            if (this._isDisposed || value === this._value) {
                return;
            }
            if (this._value) {
                this._value.dispose();
            }
            if (value) {
                markTracked(value);
            }
            this._value = value;
        },
        enumerable: true,
        configurable: true
    });
    MutableDisposable.prototype.clear = function () {
        this.value = undefined;
    };
    MutableDisposable.prototype.dispose = function () {
        this._isDisposed = true;
        markTracked(this);
        if (this._value) {
            this._value.dispose();
        }
        this._value = undefined;
    };
    return MutableDisposable;
}());

var ImmortalReference = /** @class */ (function () {
    function ImmortalReference(object) {
        this.object = object;
    }
    ImmortalReference.prototype.dispose = function () { };
    return ImmortalReference;
}());



/***/ }),
/* 1 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return Range; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__position_js__ = __webpack_require__(12);
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/

/**
 * A range in the editor. (startLineNumber,startColumn) is <= (endLineNumber,endColumn)
 */
var Range = /** @class */ (function () {
    function Range(startLineNumber, startColumn, endLineNumber, endColumn) {
        if ((startLineNumber > endLineNumber) || (startLineNumber === endLineNumber && startColumn > endColumn)) {
            this.startLineNumber = endLineNumber;
            this.startColumn = endColumn;
            this.endLineNumber = startLineNumber;
            this.endColumn = startColumn;
        }
        else {
            this.startLineNumber = startLineNumber;
            this.startColumn = startColumn;
            this.endLineNumber = endLineNumber;
            this.endColumn = endColumn;
        }
    }
    /**
     * Test if this range is empty.
     */
    Range.prototype.isEmpty = function () {
        return Range.isEmpty(this);
    };
    /**
     * Test if `range` is empty.
     */
    Range.isEmpty = function (range) {
        return (range.startLineNumber === range.endLineNumber && range.startColumn === range.endColumn);
    };
    /**
     * Test if position is in this range. If the position is at the edges, will return true.
     */
    Range.prototype.containsPosition = function (position) {
        return Range.containsPosition(this, position);
    };
    /**
     * Test if `position` is in `range`. If the position is at the edges, will return true.
     */
    Range.containsPosition = function (range, position) {
        if (position.lineNumber < range.startLineNumber || position.lineNumber > range.endLineNumber) {
            return false;
        }
        if (position.lineNumber === range.startLineNumber && position.column < range.startColumn) {
            return false;
        }
        if (position.lineNumber === range.endLineNumber && position.column > range.endColumn) {
            return false;
        }
        return true;
    };
    /**
     * Test if range is in this range. If the range is equal to this range, will return true.
     */
    Range.prototype.containsRange = function (range) {
        return Range.containsRange(this, range);
    };
    /**
     * Test if `otherRange` is in `range`. If the ranges are equal, will return true.
     */
    Range.containsRange = function (range, otherRange) {
        if (otherRange.startLineNumber < range.startLineNumber || otherRange.endLineNumber < range.startLineNumber) {
            return false;
        }
        if (otherRange.startLineNumber > range.endLineNumber || otherRange.endLineNumber > range.endLineNumber) {
            return false;
        }
        if (otherRange.startLineNumber === range.startLineNumber && otherRange.startColumn < range.startColumn) {
            return false;
        }
        if (otherRange.endLineNumber === range.endLineNumber && otherRange.endColumn > range.endColumn) {
            return false;
        }
        return true;
    };
    /**
     * Test if `range` is strictly in this range. `range` must start after and end before this range for the result to be true.
     */
    Range.prototype.strictContainsRange = function (range) {
        return Range.strictContainsRange(this, range);
    };
    /**
     * Test if `otherRange` is strinctly in `range` (must start after, and end before). If the ranges are equal, will return false.
     */
    Range.strictContainsRange = function (range, otherRange) {
        if (otherRange.startLineNumber < range.startLineNumber || otherRange.endLineNumber < range.startLineNumber) {
            return false;
        }
        if (otherRange.startLineNumber > range.endLineNumber || otherRange.endLineNumber > range.endLineNumber) {
            return false;
        }
        if (otherRange.startLineNumber === range.startLineNumber && otherRange.startColumn <= range.startColumn) {
            return false;
        }
        if (otherRange.endLineNumber === range.endLineNumber && otherRange.endColumn >= range.endColumn) {
            return false;
        }
        return true;
    };
    /**
     * A reunion of the two ranges.
     * The smallest position will be used as the start point, and the largest one as the end point.
     */
    Range.prototype.plusRange = function (range) {
        return Range.plusRange(this, range);
    };
    /**
     * A reunion of the two ranges.
     * The smallest position will be used as the start point, and the largest one as the end point.
     */
    Range.plusRange = function (a, b) {
        var startLineNumber;
        var startColumn;
        var endLineNumber;
        var endColumn;
        if (b.startLineNumber < a.startLineNumber) {
            startLineNumber = b.startLineNumber;
            startColumn = b.startColumn;
        }
        else if (b.startLineNumber === a.startLineNumber) {
            startLineNumber = b.startLineNumber;
            startColumn = Math.min(b.startColumn, a.startColumn);
        }
        else {
            startLineNumber = a.startLineNumber;
            startColumn = a.startColumn;
        }
        if (b.endLineNumber > a.endLineNumber) {
            endLineNumber = b.endLineNumber;
            endColumn = b.endColumn;
        }
        else if (b.endLineNumber === a.endLineNumber) {
            endLineNumber = b.endLineNumber;
            endColumn = Math.max(b.endColumn, a.endColumn);
        }
        else {
            endLineNumber = a.endLineNumber;
            endColumn = a.endColumn;
        }
        return new Range(startLineNumber, startColumn, endLineNumber, endColumn);
    };
    /**
     * A intersection of the two ranges.
     */
    Range.prototype.intersectRanges = function (range) {
        return Range.intersectRanges(this, range);
    };
    /**
     * A intersection of the two ranges.
     */
    Range.intersectRanges = function (a, b) {
        var resultStartLineNumber = a.startLineNumber;
        var resultStartColumn = a.startColumn;
        var resultEndLineNumber = a.endLineNumber;
        var resultEndColumn = a.endColumn;
        var otherStartLineNumber = b.startLineNumber;
        var otherStartColumn = b.startColumn;
        var otherEndLineNumber = b.endLineNumber;
        var otherEndColumn = b.endColumn;
        if (resultStartLineNumber < otherStartLineNumber) {
            resultStartLineNumber = otherStartLineNumber;
            resultStartColumn = otherStartColumn;
        }
        else if (resultStartLineNumber === otherStartLineNumber) {
            resultStartColumn = Math.max(resultStartColumn, otherStartColumn);
        }
        if (resultEndLineNumber > otherEndLineNumber) {
            resultEndLineNumber = otherEndLineNumber;
            resultEndColumn = otherEndColumn;
        }
        else if (resultEndLineNumber === otherEndLineNumber) {
            resultEndColumn = Math.min(resultEndColumn, otherEndColumn);
        }
        // Check if selection is now empty
        if (resultStartLineNumber > resultEndLineNumber) {
            return null;
        }
        if (resultStartLineNumber === resultEndLineNumber && resultStartColumn > resultEndColumn) {
            return null;
        }
        return new Range(resultStartLineNumber, resultStartColumn, resultEndLineNumber, resultEndColumn);
    };
    /**
     * Test if this range equals other.
     */
    Range.prototype.equalsRange = function (other) {
        return Range.equalsRange(this, other);
    };
    /**
     * Test if range `a` equals `b`.
     */
    Range.equalsRange = function (a, b) {
        return (!!a &&
            !!b &&
            a.startLineNumber === b.startLineNumber &&
            a.startColumn === b.startColumn &&
            a.endLineNumber === b.endLineNumber &&
            a.endColumn === b.endColumn);
    };
    /**
     * Return the end position (which will be after or equal to the start position)
     */
    Range.prototype.getEndPosition = function () {
        return new __WEBPACK_IMPORTED_MODULE_0__position_js__["a" /* Position */](this.endLineNumber, this.endColumn);
    };
    /**
     * Return the start position (which will be before or equal to the end position)
     */
    Range.prototype.getStartPosition = function () {
        return new __WEBPACK_IMPORTED_MODULE_0__position_js__["a" /* Position */](this.startLineNumber, this.startColumn);
    };
    /**
     * Transform to a user presentable string representation.
     */
    Range.prototype.toString = function () {
        return '[' + this.startLineNumber + ',' + this.startColumn + ' -> ' + this.endLineNumber + ',' + this.endColumn + ']';
    };
    /**
     * Create a new range using this range's start position, and using endLineNumber and endColumn as the end position.
     */
    Range.prototype.setEndPosition = function (endLineNumber, endColumn) {
        return new Range(this.startLineNumber, this.startColumn, endLineNumber, endColumn);
    };
    /**
     * Create a new range using this range's end position, and using startLineNumber and startColumn as the start position.
     */
    Range.prototype.setStartPosition = function (startLineNumber, startColumn) {
        return new Range(startLineNumber, startColumn, this.endLineNumber, this.endColumn);
    };
    /**
     * Create a new empty range using this range's start position.
     */
    Range.prototype.collapseToStart = function () {
        return Range.collapseToStart(this);
    };
    /**
     * Create a new empty range using this range's start position.
     */
    Range.collapseToStart = function (range) {
        return new Range(range.startLineNumber, range.startColumn, range.startLineNumber, range.startColumn);
    };
    // ---
    Range.fromPositions = function (start, end) {
        if (end === void 0) { end = start; }
        return new Range(start.lineNumber, start.column, end.lineNumber, end.column);
    };
    Range.lift = function (range) {
        if (!range) {
            return null;
        }
        return new Range(range.startLineNumber, range.startColumn, range.endLineNumber, range.endColumn);
    };
    /**
     * Test if `obj` is an `IRange`.
     */
    Range.isIRange = function (obj) {
        return (obj
            && (typeof obj.startLineNumber === 'number')
            && (typeof obj.startColumn === 'number')
            && (typeof obj.endLineNumber === 'number')
            && (typeof obj.endColumn === 'number'));
    };
    /**
     * Test if the two ranges are touching in any way.
     */
    Range.areIntersectingOrTouching = function (a, b) {
        // Check if `a` is before `b`
        if (a.endLineNumber < b.startLineNumber || (a.endLineNumber === b.startLineNumber && a.endColumn < b.startColumn)) {
            return false;
        }
        // Check if `b` is before `a`
        if (b.endLineNumber < a.startLineNumber || (b.endLineNumber === a.startLineNumber && b.endColumn < a.startColumn)) {
            return false;
        }
        // These ranges must intersect
        return true;
    };
    /**
     * Test if the two ranges are intersecting. If the ranges are touching it returns true.
     */
    Range.areIntersecting = function (a, b) {
        // Check if `a` is before `b`
        if (a.endLineNumber < b.startLineNumber || (a.endLineNumber === b.startLineNumber && a.endColumn <= b.startColumn)) {
            return false;
        }
        // Check if `b` is before `a`
        if (b.endLineNumber < a.startLineNumber || (b.endLineNumber === a.startLineNumber && b.endColumn <= a.startColumn)) {
            return false;
        }
        // These ranges must intersect
        return true;
    };
    /**
     * A function that compares ranges, useful for sorting ranges
     * It will first compare ranges on the startPosition and then on the endPosition
     */
    Range.compareRangesUsingStarts = function (a, b) {
        if (a && b) {
            var aStartLineNumber = a.startLineNumber | 0;
            var bStartLineNumber = b.startLineNumber | 0;
            if (aStartLineNumber === bStartLineNumber) {
                var aStartColumn = a.startColumn | 0;
                var bStartColumn = b.startColumn | 0;
                if (aStartColumn === bStartColumn) {
                    var aEndLineNumber = a.endLineNumber | 0;
                    var bEndLineNumber = b.endLineNumber | 0;
                    if (aEndLineNumber === bEndLineNumber) {
                        var aEndColumn = a.endColumn | 0;
                        var bEndColumn = b.endColumn | 0;
                        return aEndColumn - bEndColumn;
                    }
                    return aEndLineNumber - bEndLineNumber;
                }
                return aStartColumn - bStartColumn;
            }
            return aStartLineNumber - bStartLineNumber;
        }
        var aExists = (a ? 1 : 0);
        var bExists = (b ? 1 : 0);
        return aExists - bExists;
    };
    /**
     * A function that compares ranges, useful for sorting ranges
     * It will first compare ranges on the endPosition and then on the startPosition
     */
    Range.compareRangesUsingEnds = function (a, b) {
        if (a.endLineNumber === b.endLineNumber) {
            if (a.endColumn === b.endColumn) {
                if (a.startLineNumber === b.startLineNumber) {
                    return a.startColumn - b.startColumn;
                }
                return a.startLineNumber - b.startLineNumber;
            }
            return a.endColumn - b.endColumn;
        }
        return a.endLineNumber - b.endLineNumber;
    };
    /**
     * Test if the range spans multiple lines.
     */
    Range.spansMultipleLines = function (range) {
        return range.endLineNumber > range.startLineNumber;
    };
    return Range;
}());



/***/ }),
/* 2 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "b", function() { return Event; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return Emitter; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "e", function() { return PauseableEmitter; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "d", function() { return EventMultiplexer; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "c", function() { return EventBufferer; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "f", function() { return Relay; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__errors_js__ = __webpack_require__(8);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__functional_js__ = __webpack_require__(114);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2__lifecycle_js__ = __webpack_require__(0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3__linkedList_js__ = __webpack_require__(84);
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();




var Event;
(function (Event) {
    Event.None = function () { return __WEBPACK_IMPORTED_MODULE_2__lifecycle_js__["a" /* Disposable */].None; };
    /**
     * Given an event, returns another event which only fires once.
     */
    function once(event) {
        return function (listener, thisArgs, disposables) {
            if (thisArgs === void 0) { thisArgs = null; }
            // we need this, in case the event fires during the listener call
            var didFire = false;
            var result;
            result = event(function (e) {
                if (didFire) {
                    return;
                }
                else if (result) {
                    result.dispose();
                }
                else {
                    didFire = true;
                }
                return listener.call(thisArgs, e);
            }, null, disposables);
            if (didFire) {
                result.dispose();
            }
            return result;
        };
    }
    Event.once = once;
    /**
     * Given an event and a `map` function, returns another event which maps each element
     * through the mapping function.
     */
    function map(event, map) {
        return snapshot(function (listener, thisArgs, disposables) {
            if (thisArgs === void 0) { thisArgs = null; }
            return event(function (i) { return listener.call(thisArgs, map(i)); }, null, disposables);
        });
    }
    Event.map = map;
    /**
     * Given an event and an `each` function, returns another identical event and calls
     * the `each` function per each element.
     */
    function forEach(event, each) {
        return snapshot(function (listener, thisArgs, disposables) {
            if (thisArgs === void 0) { thisArgs = null; }
            return event(function (i) { each(i); listener.call(thisArgs, i); }, null, disposables);
        });
    }
    Event.forEach = forEach;
    function filter(event, filter) {
        return snapshot(function (listener, thisArgs, disposables) {
            if (thisArgs === void 0) { thisArgs = null; }
            return event(function (e) { return filter(e) && listener.call(thisArgs, e); }, null, disposables);
        });
    }
    Event.filter = filter;
    /**
     * Given an event, returns the same event but typed as `Event<void>`.
     */
    function signal(event) {
        return event;
    }
    Event.signal = signal;
    /**
     * Given a collection of events, returns a single event which emits
     * whenever any of the provided events emit.
     */
    function any() {
        var events = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            events[_i] = arguments[_i];
        }
        return function (listener, thisArgs, disposables) {
            if (thisArgs === void 0) { thisArgs = null; }
            return __WEBPACK_IMPORTED_MODULE_2__lifecycle_js__["e" /* combinedDisposable */].apply(void 0, events.map(function (event) { return event(function (e) { return listener.call(thisArgs, e); }, null, disposables); }));
        };
    }
    Event.any = any;
    /**
     * Given an event and a `merge` function, returns another event which maps each element
     * and the cumulative result through the `merge` function. Similar to `map`, but with memory.
     */
    function reduce(event, merge, initial) {
        var output = initial;
        return map(event, function (e) {
            output = merge(output, e);
            return output;
        });
    }
    Event.reduce = reduce;
    /**
     * Given a chain of event processing functions (filter, map, etc), each
     * function will be invoked per event & per listener. Snapshotting an event
     * chain allows each function to be invoked just once per event.
     */
    function snapshot(event) {
        var listener;
        var emitter = new Emitter({
            onFirstListenerAdd: function () {
                listener = event(emitter.fire, emitter);
            },
            onLastListenerRemove: function () {
                listener.dispose();
            }
        });
        return emitter.event;
    }
    Event.snapshot = snapshot;
    function debounce(event, merge, delay, leading, leakWarningThreshold) {
        if (delay === void 0) { delay = 100; }
        if (leading === void 0) { leading = false; }
        var subscription;
        var output = undefined;
        var handle = undefined;
        var numDebouncedCalls = 0;
        var emitter = new Emitter({
            leakWarningThreshold: leakWarningThreshold,
            onFirstListenerAdd: function () {
                subscription = event(function (cur) {
                    numDebouncedCalls++;
                    output = merge(output, cur);
                    if (leading && !handle) {
                        emitter.fire(output);
                        output = undefined;
                    }
                    clearTimeout(handle);
                    handle = setTimeout(function () {
                        var _output = output;
                        output = undefined;
                        handle = undefined;
                        if (!leading || numDebouncedCalls > 1) {
                            emitter.fire(_output);
                        }
                        numDebouncedCalls = 0;
                    }, delay);
                });
            },
            onLastListenerRemove: function () {
                subscription.dispose();
            }
        });
        return emitter.event;
    }
    Event.debounce = debounce;
    /**
     * Given an event, it returns another event which fires only once and as soon as
     * the input event emits. The event data is the number of millis it took for the
     * event to fire.
     */
    function stopwatch(event) {
        var start = new Date().getTime();
        return map(once(event), function (_) { return new Date().getTime() - start; });
    }
    Event.stopwatch = stopwatch;
    /**
     * Given an event, it returns another event which fires only when the event
     * element changes.
     */
    function latch(event) {
        var firstCall = true;
        var cache;
        return filter(event, function (value) {
            var shouldEmit = firstCall || value !== cache;
            firstCall = false;
            cache = value;
            return shouldEmit;
        });
    }
    Event.latch = latch;
    /**
     * Buffers the provided event until a first listener comes
     * along, at which point fire all the events at once and
     * pipe the event from then on.
     *
     * ```typescript
     * const emitter = new Emitter<number>();
     * const event = emitter.event;
     * const bufferedEvent = buffer(event);
     *
     * emitter.fire(1);
     * emitter.fire(2);
     * emitter.fire(3);
     * // nothing...
     *
     * const listener = bufferedEvent(num => console.log(num));
     * // 1, 2, 3
     *
     * emitter.fire(4);
     * // 4
     * ```
     */
    function buffer(event, nextTick, _buffer) {
        if (nextTick === void 0) { nextTick = false; }
        if (_buffer === void 0) { _buffer = []; }
        var buffer = _buffer.slice();
        var listener = event(function (e) {
            if (buffer) {
                buffer.push(e);
            }
            else {
                emitter.fire(e);
            }
        });
        var flush = function () {
            if (buffer) {
                buffer.forEach(function (e) { return emitter.fire(e); });
            }
            buffer = null;
        };
        var emitter = new Emitter({
            onFirstListenerAdd: function () {
                if (!listener) {
                    listener = event(function (e) { return emitter.fire(e); });
                }
            },
            onFirstListenerDidAdd: function () {
                if (buffer) {
                    if (nextTick) {
                        setTimeout(flush);
                    }
                    else {
                        flush();
                    }
                }
            },
            onLastListenerRemove: function () {
                if (listener) {
                    listener.dispose();
                }
                listener = null;
            }
        });
        return emitter.event;
    }
    Event.buffer = buffer;
    var ChainableEvent = /** @class */ (function () {
        function ChainableEvent(event) {
            this.event = event;
        }
        ChainableEvent.prototype.map = function (fn) {
            return new ChainableEvent(map(this.event, fn));
        };
        ChainableEvent.prototype.forEach = function (fn) {
            return new ChainableEvent(forEach(this.event, fn));
        };
        ChainableEvent.prototype.filter = function (fn) {
            return new ChainableEvent(filter(this.event, fn));
        };
        ChainableEvent.prototype.reduce = function (merge, initial) {
            return new ChainableEvent(reduce(this.event, merge, initial));
        };
        ChainableEvent.prototype.latch = function () {
            return new ChainableEvent(latch(this.event));
        };
        ChainableEvent.prototype.debounce = function (merge, delay, leading, leakWarningThreshold) {
            if (delay === void 0) { delay = 100; }
            if (leading === void 0) { leading = false; }
            return new ChainableEvent(debounce(this.event, merge, delay, leading, leakWarningThreshold));
        };
        ChainableEvent.prototype.on = function (listener, thisArgs, disposables) {
            return this.event(listener, thisArgs, disposables);
        };
        ChainableEvent.prototype.once = function (listener, thisArgs, disposables) {
            return once(this.event)(listener, thisArgs, disposables);
        };
        return ChainableEvent;
    }());
    function chain(event) {
        return new ChainableEvent(event);
    }
    Event.chain = chain;
    function fromNodeEventEmitter(emitter, eventName, map) {
        if (map === void 0) { map = function (id) { return id; }; }
        var fn = function () {
            var args = [];
            for (var _i = 0; _i < arguments.length; _i++) {
                args[_i] = arguments[_i];
            }
            return result.fire(map.apply(void 0, args));
        };
        var onFirstListenerAdd = function () { return emitter.on(eventName, fn); };
        var onLastListenerRemove = function () { return emitter.removeListener(eventName, fn); };
        var result = new Emitter({ onFirstListenerAdd: onFirstListenerAdd, onLastListenerRemove: onLastListenerRemove });
        return result.event;
    }
    Event.fromNodeEventEmitter = fromNodeEventEmitter;
    function fromDOMEventEmitter(emitter, eventName, map) {
        if (map === void 0) { map = function (id) { return id; }; }
        var fn = function () {
            var args = [];
            for (var _i = 0; _i < arguments.length; _i++) {
                args[_i] = arguments[_i];
            }
            return result.fire(map.apply(void 0, args));
        };
        var onFirstListenerAdd = function () { return emitter.addEventListener(eventName, fn); };
        var onLastListenerRemove = function () { return emitter.removeEventListener(eventName, fn); };
        var result = new Emitter({ onFirstListenerAdd: onFirstListenerAdd, onLastListenerRemove: onLastListenerRemove });
        return result.event;
    }
    Event.fromDOMEventEmitter = fromDOMEventEmitter;
    function fromPromise(promise) {
        var emitter = new Emitter();
        var shouldEmit = false;
        promise
            .then(undefined, function () { return null; })
            .then(function () {
            if (!shouldEmit) {
                setTimeout(function () { return emitter.fire(undefined); }, 0);
            }
            else {
                emitter.fire(undefined);
            }
        });
        shouldEmit = true;
        return emitter.event;
    }
    Event.fromPromise = fromPromise;
    function toPromise(event) {
        return new Promise(function (c) { return once(event)(c); });
    }
    Event.toPromise = toPromise;
})(Event || (Event = {}));
var _globalLeakWarningThreshold = -1;
var LeakageMonitor = /** @class */ (function () {
    function LeakageMonitor(customThreshold, name) {
        if (name === void 0) { name = Math.random().toString(18).slice(2, 5); }
        this.customThreshold = customThreshold;
        this.name = name;
        this._warnCountdown = 0;
    }
    LeakageMonitor.prototype.dispose = function () {
        if (this._stacks) {
            this._stacks.clear();
        }
    };
    LeakageMonitor.prototype.check = function (listenerCount) {
        var _this = this;
        var threshold = _globalLeakWarningThreshold;
        if (typeof this.customThreshold === 'number') {
            threshold = this.customThreshold;
        }
        if (threshold <= 0 || listenerCount < threshold) {
            return undefined;
        }
        if (!this._stacks) {
            this._stacks = new Map();
        }
        var stack = new Error().stack.split('\n').slice(3).join('\n');
        var count = (this._stacks.get(stack) || 0);
        this._stacks.set(stack, count + 1);
        this._warnCountdown -= 1;
        if (this._warnCountdown <= 0) {
            // only warn on first exceed and then every time the limit
            // is exceeded by 50% again
            this._warnCountdown = threshold * 0.5;
            // find most frequent listener and print warning
            var topStack_1;
            var topCount_1 = 0;
            this._stacks.forEach(function (count, stack) {
                if (!topStack_1 || topCount_1 < count) {
                    topStack_1 = stack;
                    topCount_1 = count;
                }
            });
            console.warn("[" + this.name + "] potential listener LEAK detected, having " + listenerCount + " listeners already. MOST frequent listener (" + topCount_1 + "):");
            console.warn(topStack_1);
        }
        return function () {
            var count = (_this._stacks.get(stack) || 0);
            _this._stacks.set(stack, count - 1);
        };
    };
    return LeakageMonitor;
}());
/**
 * The Emitter can be used to expose an Event to the public
 * to fire it from the insides.
 * Sample:
    class Document {

        private readonly _onDidChange = new Emitter<(value:string)=>any>();

        public onDidChange = this._onDidChange.event;

        // getter-style
        // get onDidChange(): Event<(value:string)=>any> {
        // 	return this._onDidChange.event;
        // }

        private _doIt() {
            //...
            this._onDidChange.fire(value);
        }
    }
 */
var Emitter = /** @class */ (function () {
    function Emitter(options) {
        this._disposed = false;
        this._options = options;
        this._leakageMon = _globalLeakWarningThreshold > 0
            ? new LeakageMonitor(this._options && this._options.leakWarningThreshold)
            : undefined;
    }
    Object.defineProperty(Emitter.prototype, "event", {
        /**
         * For the public to allow to subscribe
         * to events from this Emitter
         */
        get: function () {
            var _this = this;
            if (!this._event) {
                this._event = function (listener, thisArgs, disposables) {
                    if (!_this._listeners) {
                        _this._listeners = new __WEBPACK_IMPORTED_MODULE_3__linkedList_js__["a" /* LinkedList */]();
                    }
                    var firstListener = _this._listeners.isEmpty();
                    if (firstListener && _this._options && _this._options.onFirstListenerAdd) {
                        _this._options.onFirstListenerAdd(_this);
                    }
                    var remove = _this._listeners.push(!thisArgs ? listener : [listener, thisArgs]);
                    if (firstListener && _this._options && _this._options.onFirstListenerDidAdd) {
                        _this._options.onFirstListenerDidAdd(_this);
                    }
                    if (_this._options && _this._options.onListenerDidAdd) {
                        _this._options.onListenerDidAdd(_this, listener, thisArgs);
                    }
                    // check and record this emitter for potential leakage
                    var removeMonitor;
                    if (_this._leakageMon) {
                        removeMonitor = _this._leakageMon.check(_this._listeners.size);
                    }
                    var result;
                    result = {
                        dispose: function () {
                            if (removeMonitor) {
                                removeMonitor();
                            }
                            result.dispose = Emitter._noop;
                            if (!_this._disposed) {
                                remove();
                                if (_this._options && _this._options.onLastListenerRemove) {
                                    var hasListeners = (_this._listeners && !_this._listeners.isEmpty());
                                    if (!hasListeners) {
                                        _this._options.onLastListenerRemove(_this);
                                    }
                                }
                            }
                        }
                    };
                    if (disposables instanceof __WEBPACK_IMPORTED_MODULE_2__lifecycle_js__["b" /* DisposableStore */]) {
                        disposables.add(result);
                    }
                    else if (Array.isArray(disposables)) {
                        disposables.push(result);
                    }
                    return result;
                };
            }
            return this._event;
        },
        enumerable: true,
        configurable: true
    });
    /**
     * To be kept private to fire an event to
     * subscribers
     */
    Emitter.prototype.fire = function (event) {
        if (this._listeners) {
            // put all [listener,event]-pairs into delivery queue
            // then emit all event. an inner/nested event might be
            // the driver of this
            if (!this._deliveryQueue) {
                this._deliveryQueue = new __WEBPACK_IMPORTED_MODULE_3__linkedList_js__["a" /* LinkedList */]();
            }
            for (var iter = this._listeners.iterator(), e = iter.next(); !e.done; e = iter.next()) {
                this._deliveryQueue.push([e.value, event]);
            }
            while (this._deliveryQueue.size > 0) {
                var _a = this._deliveryQueue.shift(), listener = _a[0], event_1 = _a[1];
                try {
                    if (typeof listener === 'function') {
                        listener.call(undefined, event_1);
                    }
                    else {
                        listener[0].call(listener[1], event_1);
                    }
                }
                catch (e) {
                    Object(__WEBPACK_IMPORTED_MODULE_0__errors_js__["e" /* onUnexpectedError */])(e);
                }
            }
        }
    };
    Emitter.prototype.dispose = function () {
        if (this._listeners) {
            this._listeners.clear();
        }
        if (this._deliveryQueue) {
            this._deliveryQueue.clear();
        }
        if (this._leakageMon) {
            this._leakageMon.dispose();
        }
        this._disposed = true;
    };
    Emitter._noop = function () { };
    return Emitter;
}());

var PauseableEmitter = /** @class */ (function (_super) {
    __extends(PauseableEmitter, _super);
    function PauseableEmitter(options) {
        var _this = _super.call(this, options) || this;
        _this._isPaused = 0;
        _this._eventQueue = new __WEBPACK_IMPORTED_MODULE_3__linkedList_js__["a" /* LinkedList */]();
        _this._mergeFn = options && options.merge;
        return _this;
    }
    PauseableEmitter.prototype.pause = function () {
        this._isPaused++;
    };
    PauseableEmitter.prototype.resume = function () {
        if (this._isPaused !== 0 && --this._isPaused === 0) {
            if (this._mergeFn) {
                // use the merge function to create a single composite
                // event. make a copy in case firing pauses this emitter
                var events = this._eventQueue.toArray();
                this._eventQueue.clear();
                _super.prototype.fire.call(this, this._mergeFn(events));
            }
            else {
                // no merging, fire each event individually and test
                // that this emitter isn't paused halfway through
                while (!this._isPaused && this._eventQueue.size !== 0) {
                    _super.prototype.fire.call(this, this._eventQueue.shift());
                }
            }
        }
    };
    PauseableEmitter.prototype.fire = function (event) {
        if (this._listeners) {
            if (this._isPaused !== 0) {
                this._eventQueue.push(event);
            }
            else {
                _super.prototype.fire.call(this, event);
            }
        }
    };
    return PauseableEmitter;
}(Emitter));

var EventMultiplexer = /** @class */ (function () {
    function EventMultiplexer() {
        var _this = this;
        this.hasListeners = false;
        this.events = [];
        this.emitter = new Emitter({
            onFirstListenerAdd: function () { return _this.onFirstListenerAdd(); },
            onLastListenerRemove: function () { return _this.onLastListenerRemove(); }
        });
    }
    Object.defineProperty(EventMultiplexer.prototype, "event", {
        get: function () {
            return this.emitter.event;
        },
        enumerable: true,
        configurable: true
    });
    EventMultiplexer.prototype.add = function (event) {
        var _this = this;
        var e = { event: event, listener: null };
        this.events.push(e);
        if (this.hasListeners) {
            this.hook(e);
        }
        var dispose = function () {
            if (_this.hasListeners) {
                _this.unhook(e);
            }
            var idx = _this.events.indexOf(e);
            _this.events.splice(idx, 1);
        };
        return Object(__WEBPACK_IMPORTED_MODULE_2__lifecycle_js__["h" /* toDisposable */])(Object(__WEBPACK_IMPORTED_MODULE_1__functional_js__["a" /* once */])(dispose));
    };
    EventMultiplexer.prototype.onFirstListenerAdd = function () {
        var _this = this;
        this.hasListeners = true;
        this.events.forEach(function (e) { return _this.hook(e); });
    };
    EventMultiplexer.prototype.onLastListenerRemove = function () {
        var _this = this;
        this.hasListeners = false;
        this.events.forEach(function (e) { return _this.unhook(e); });
    };
    EventMultiplexer.prototype.hook = function (e) {
        var _this = this;
        e.listener = e.event(function (r) { return _this.emitter.fire(r); });
    };
    EventMultiplexer.prototype.unhook = function (e) {
        if (e.listener) {
            e.listener.dispose();
        }
        e.listener = null;
    };
    EventMultiplexer.prototype.dispose = function () {
        this.emitter.dispose();
    };
    return EventMultiplexer;
}());

/**
 * The EventBufferer is useful in situations in which you want
 * to delay firing your events during some code.
 * You can wrap that code and be sure that the event will not
 * be fired during that wrap.
 *
 * ```
 * const emitter: Emitter;
 * const delayer = new EventDelayer();
 * const delayedEvent = delayer.wrapEvent(emitter.event);
 *
 * delayedEvent(console.log);
 *
 * delayer.bufferEvents(() => {
 *   emitter.fire(); // event will not be fired yet
 * });
 *
 * // event will only be fired at this point
 * ```
 */
var EventBufferer = /** @class */ (function () {
    function EventBufferer() {
        this.buffers = [];
    }
    EventBufferer.prototype.wrapEvent = function (event) {
        var _this = this;
        return function (listener, thisArgs, disposables) {
            return event(function (i) {
                var buffer = _this.buffers[_this.buffers.length - 1];
                if (buffer) {
                    buffer.push(function () { return listener.call(thisArgs, i); });
                }
                else {
                    listener.call(thisArgs, i);
                }
            }, undefined, disposables);
        };
    };
    EventBufferer.prototype.bufferEvents = function (fn) {
        var buffer = [];
        this.buffers.push(buffer);
        var r = fn();
        this.buffers.pop();
        buffer.forEach(function (flush) { return flush(); });
        return r;
    };
    return EventBufferer;
}());

/**
 * A Relay is an event forwarder which functions as a replugabble event pipe.
 * Once created, you can connect an input event to it and it will simply forward
 * events from that input event through its own `event` property. The `input`
 * can be changed at any point in time.
 */
var Relay = /** @class */ (function () {
    function Relay() {
        var _this = this;
        this.listening = false;
        this.inputEvent = Event.None;
        this.inputEventListener = __WEBPACK_IMPORTED_MODULE_2__lifecycle_js__["a" /* Disposable */].None;
        this.emitter = new Emitter({
            onFirstListenerDidAdd: function () {
                _this.listening = true;
                _this.inputEventListener = _this.inputEvent(_this.emitter.fire, _this.emitter);
            },
            onLastListenerRemove: function () {
                _this.listening = false;
                _this.inputEventListener.dispose();
            }
        });
        this.event = this.emitter.event;
    }
    Object.defineProperty(Relay.prototype, "input", {
        set: function (event) {
            this.inputEvent = event;
            if (this.listening) {
                this.inputEventListener.dispose();
                this.inputEventListener = event(this.emitter.fire, this.emitter);
            }
        },
        enumerable: true,
        configurable: true
    });
    Relay.prototype.dispose = function () {
        this.inputEventListener.dispose();
        this.emitter.dispose();
    };
    return Relay;
}());



/***/ }),
/* 3 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (immutable) */ __webpack_exports__["t"] = clearNode;
/* harmony export (immutable) */ __webpack_exports__["R"] = removeNode;
/* harmony export (immutable) */ __webpack_exports__["M"] = isInDOM;
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "I", function() { return hasClass; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "f", function() { return addClass; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "g", function() { return addClasses; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "P", function() { return removeClass; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Q", function() { return removeClasses; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Y", function() { return toggleClass; });
/* harmony export (immutable) */ __webpack_exports__["j"] = addDisposableListener;
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "o", function() { return addStandardDisposableListener; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "n", function() { return addStandardDisposableGenericMouseDownListner; });
/* harmony export (immutable) */ __webpack_exports__["h"] = addDisposableGenericMouseDownListner;
/* harmony export (immutable) */ __webpack_exports__["i"] = addDisposableGenericMouseUpListner;
/* harmony export (immutable) */ __webpack_exports__["k"] = addDisposableNonBubblingMouseOutListener;
/* harmony export (immutable) */ __webpack_exports__["l"] = addDisposableNonBubblingPointerOutListener;
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "U", function() { return runAtThisOrScheduleAtNextAnimationFrame; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "W", function() { return scheduleAtNextAnimationFrame; });
/* harmony export (immutable) */ __webpack_exports__["m"] = addDisposableThrottledListener;
/* harmony export (immutable) */ __webpack_exports__["z"] = getComputedStyle;
/* harmony export (immutable) */ __webpack_exports__["y"] = getClientArea;
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "b", function() { return Dimension; });
/* harmony export (immutable) */ __webpack_exports__["F"] = getTopLeftOffset;
/* harmony export (immutable) */ __webpack_exports__["C"] = getDomNodePagePosition;
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "e", function() { return StandardWindow; });
/* harmony export (immutable) */ __webpack_exports__["H"] = getTotalWidth;
/* harmony export (immutable) */ __webpack_exports__["B"] = getContentWidth;
/* harmony export (immutable) */ __webpack_exports__["A"] = getContentHeight;
/* harmony export (immutable) */ __webpack_exports__["G"] = getTotalHeight;
/* harmony export (immutable) */ __webpack_exports__["K"] = isAncestor;
/* harmony export (immutable) */ __webpack_exports__["x"] = findParentWithClass;
/* unused harmony export isShadowRoot */
/* harmony export (immutable) */ __webpack_exports__["N"] = isInShadowDOM;
/* harmony export (immutable) */ __webpack_exports__["E"] = getShadowRoot;
/* harmony export (immutable) */ __webpack_exports__["w"] = createStyleSheet;
/* harmony export (immutable) */ __webpack_exports__["v"] = createCSSRule;
/* harmony export (immutable) */ __webpack_exports__["O"] = removeCSSRulesContainingSelector;
/* harmony export (immutable) */ __webpack_exports__["L"] = isHTMLElement;
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "d", function() { return EventType; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "c", function() { return EventHelper; });
/* harmony export (immutable) */ __webpack_exports__["V"] = saveParentsScrollTop;
/* harmony export (immutable) */ __webpack_exports__["T"] = restoreParentsScrollTop;
/* harmony export (immutable) */ __webpack_exports__["Z"] = trackFocus;
/* harmony export (immutable) */ __webpack_exports__["q"] = append;
/* unused harmony export Namespace */
/* harmony export (immutable) */ __webpack_exports__["a"] = $;
/* harmony export (immutable) */ __webpack_exports__["X"] = show;
/* harmony export (immutable) */ __webpack_exports__["J"] = hide;
/* harmony export (immutable) */ __webpack_exports__["S"] = removeTabIndexAndUpdateFocus;
/* harmony export (immutable) */ __webpack_exports__["D"] = getElementsByTagName;
/* harmony export (immutable) */ __webpack_exports__["u"] = computeScreenAwareSize;
/* harmony export (immutable) */ __webpack_exports__["_0"] = windowOpenNoOpener;
/* harmony export (immutable) */ __webpack_exports__["p"] = animate;
/* harmony export (immutable) */ __webpack_exports__["s"] = asDomUri;
/* harmony export (immutable) */ __webpack_exports__["r"] = asCSSUrl;
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__browser_js__ = __webpack_require__(23);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__event_js__ = __webpack_require__(53);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2__keyboardEvent_js__ = __webpack_require__(58);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3__mouseEvent_js__ = __webpack_require__(45);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4__common_async_js__ = __webpack_require__(15);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5__common_errors_js__ = __webpack_require__(8);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6__common_event_js__ = __webpack_require__(2);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_7__common_lifecycle_js__ = __webpack_require__(0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_8__common_platform_js__ = __webpack_require__(14);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_9__common_arrays_js__ = __webpack_require__(18);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_10__common_network_js__ = __webpack_require__(46);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_11__canIUse_js__ = __webpack_require__(99);
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __spreadArrays = (this && this.__spreadArrays) || function () {
    for (var s = 0, i = 0, il = arguments.length; i < il; i++) s += arguments[i].length;
    for (var r = Array(s), k = 0, i = 0; i < il; i++)
        for (var a = arguments[i], j = 0, jl = a.length; j < jl; j++, k++)
            r[k] = a[j];
    return r;
};












function clearNode(node) {
    while (node.firstChild) {
        node.removeChild(node.firstChild);
    }
}
function removeNode(node) {
    if (node.parentNode) {
        node.parentNode.removeChild(node);
    }
}
function isInDOM(node) {
    while (node) {
        if (node === document.body) {
            return true;
        }
        node = node.parentNode || node.host;
    }
    return false;
}
var _manualClassList = new /** @class */ (function () {
    function class_1() {
        this._lastStart = -1;
        this._lastEnd = -1;
    }
    class_1.prototype._findClassName = function (node, className) {
        var classes = node.className;
        if (!classes) {
            this._lastStart = -1;
            return;
        }
        className = className.trim();
        var classesLen = classes.length, classLen = className.length;
        if (classLen === 0) {
            this._lastStart = -1;
            return;
        }
        if (classesLen < classLen) {
            this._lastStart = -1;
            return;
        }
        if (classes === className) {
            this._lastStart = 0;
            this._lastEnd = classesLen;
            return;
        }
        var idx = -1, idxEnd;
        while ((idx = classes.indexOf(className, idx + 1)) >= 0) {
            idxEnd = idx + classLen;
            // a class that is followed by another class
            if ((idx === 0 || classes.charCodeAt(idx - 1) === 32 /* Space */) && classes.charCodeAt(idxEnd) === 32 /* Space */) {
                this._lastStart = idx;
                this._lastEnd = idxEnd + 1;
                return;
            }
            // last class
            if (idx > 0 && classes.charCodeAt(idx - 1) === 32 /* Space */ && idxEnd === classesLen) {
                this._lastStart = idx - 1;
                this._lastEnd = idxEnd;
                return;
            }
            // equal - duplicate of cmp above
            if (idx === 0 && idxEnd === classesLen) {
                this._lastStart = 0;
                this._lastEnd = idxEnd;
                return;
            }
        }
        this._lastStart = -1;
    };
    class_1.prototype.hasClass = function (node, className) {
        this._findClassName(node, className);
        return this._lastStart !== -1;
    };
    class_1.prototype.addClasses = function (node) {
        var _this = this;
        var classNames = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            classNames[_i - 1] = arguments[_i];
        }
        classNames.forEach(function (nameValue) { return nameValue.split(' ').forEach(function (name) { return _this.addClass(node, name); }); });
    };
    class_1.prototype.addClass = function (node, className) {
        if (!node.className) { // doesn't have it for sure
            node.className = className;
        }
        else {
            this._findClassName(node, className); // see if it's already there
            if (this._lastStart === -1) {
                node.className = node.className + ' ' + className;
            }
        }
    };
    class_1.prototype.removeClass = function (node, className) {
        this._findClassName(node, className);
        if (this._lastStart === -1) {
            return; // Prevent styles invalidation if not necessary
        }
        else {
            node.className = node.className.substring(0, this._lastStart) + node.className.substring(this._lastEnd);
        }
    };
    class_1.prototype.removeClasses = function (node) {
        var _this = this;
        var classNames = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            classNames[_i - 1] = arguments[_i];
        }
        classNames.forEach(function (nameValue) { return nameValue.split(' ').forEach(function (name) { return _this.removeClass(node, name); }); });
    };
    class_1.prototype.toggleClass = function (node, className, shouldHaveIt) {
        this._findClassName(node, className);
        if (this._lastStart !== -1 && (shouldHaveIt === undefined || !shouldHaveIt)) {
            this.removeClass(node, className);
        }
        if (this._lastStart === -1 && (shouldHaveIt === undefined || shouldHaveIt)) {
            this.addClass(node, className);
        }
    };
    return class_1;
}());
var _nativeClassList = new /** @class */ (function () {
    function class_2() {
    }
    class_2.prototype.hasClass = function (node, className) {
        return Boolean(className) && node.classList && node.classList.contains(className);
    };
    class_2.prototype.addClasses = function (node) {
        var _this = this;
        var classNames = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            classNames[_i - 1] = arguments[_i];
        }
        classNames.forEach(function (nameValue) { return nameValue.split(' ').forEach(function (name) { return _this.addClass(node, name); }); });
    };
    class_2.prototype.addClass = function (node, className) {
        if (className && node.classList) {
            node.classList.add(className);
        }
    };
    class_2.prototype.removeClass = function (node, className) {
        if (className && node.classList) {
            node.classList.remove(className);
        }
    };
    class_2.prototype.removeClasses = function (node) {
        var _this = this;
        var classNames = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            classNames[_i - 1] = arguments[_i];
        }
        classNames.forEach(function (nameValue) { return nameValue.split(' ').forEach(function (name) { return _this.removeClass(node, name); }); });
    };
    class_2.prototype.toggleClass = function (node, className, shouldHaveIt) {
        if (node.classList) {
            node.classList.toggle(className, shouldHaveIt);
        }
    };
    return class_2;
}());
// In IE11 there is only partial support for `classList` which makes us keep our
// custom implementation. Otherwise use the native implementation, see: http://caniuse.com/#search=classlist
var _classList = __WEBPACK_IMPORTED_MODULE_0__browser_js__["i" /* isIE */] ? _manualClassList : _nativeClassList;
var hasClass = _classList.hasClass.bind(_classList);
var addClass = _classList.addClass.bind(_classList);
var addClasses = _classList.addClasses.bind(_classList);
var removeClass = _classList.removeClass.bind(_classList);
var removeClasses = _classList.removeClasses.bind(_classList);
var toggleClass = _classList.toggleClass.bind(_classList);
var DomListener = /** @class */ (function () {
    function DomListener(node, type, handler, options) {
        this._node = node;
        this._type = type;
        this._handler = handler;
        this._options = (options || false);
        this._node.addEventListener(this._type, this._handler, this._options);
    }
    DomListener.prototype.dispose = function () {
        if (!this._handler) {
            // Already disposed
            return;
        }
        this._node.removeEventListener(this._type, this._handler, this._options);
        // Prevent leakers from holding on to the dom or handler func
        this._node = null;
        this._handler = null;
    };
    return DomListener;
}());
function addDisposableListener(node, type, handler, useCaptureOrOptions) {
    return new DomListener(node, type, handler, useCaptureOrOptions);
}
function _wrapAsStandardMouseEvent(handler) {
    return function (e) {
        return handler(new __WEBPACK_IMPORTED_MODULE_3__mouseEvent_js__["b" /* StandardMouseEvent */](e));
    };
}
function _wrapAsStandardKeyboardEvent(handler) {
    return function (e) {
        return handler(new __WEBPACK_IMPORTED_MODULE_2__keyboardEvent_js__["a" /* StandardKeyboardEvent */](e));
    };
}
var addStandardDisposableListener = function addStandardDisposableListener(node, type, handler, useCapture) {
    var wrapHandler = handler;
    if (type === 'click' || type === 'mousedown') {
        wrapHandler = _wrapAsStandardMouseEvent(handler);
    }
    else if (type === 'keydown' || type === 'keypress' || type === 'keyup') {
        wrapHandler = _wrapAsStandardKeyboardEvent(handler);
    }
    return addDisposableListener(node, type, wrapHandler, useCapture);
};
var addStandardDisposableGenericMouseDownListner = function addStandardDisposableListener(node, handler, useCapture) {
    var wrapHandler = _wrapAsStandardMouseEvent(handler);
    return addDisposableGenericMouseDownListner(node, wrapHandler, useCapture);
};
function addDisposableGenericMouseDownListner(node, handler, useCapture) {
    return addDisposableListener(node, __WEBPACK_IMPORTED_MODULE_8__common_platform_js__["c" /* isIOS */] && __WEBPACK_IMPORTED_MODULE_11__canIUse_js__["a" /* BrowserFeatures */].pointerEvents ? EventType.POINTER_DOWN : EventType.MOUSE_DOWN, handler, useCapture);
}
function addDisposableGenericMouseUpListner(node, handler, useCapture) {
    return addDisposableListener(node, __WEBPACK_IMPORTED_MODULE_8__common_platform_js__["c" /* isIOS */] && __WEBPACK_IMPORTED_MODULE_11__canIUse_js__["a" /* BrowserFeatures */].pointerEvents ? EventType.POINTER_UP : EventType.MOUSE_UP, handler, useCapture);
}
function addDisposableNonBubblingMouseOutListener(node, handler) {
    return addDisposableListener(node, 'mouseout', function (e) {
        // Mouse out bubbles, so this is an attempt to ignore faux mouse outs coming from children elements
        var toElement = (e.relatedTarget);
        while (toElement && toElement !== node) {
            toElement = toElement.parentNode;
        }
        if (toElement === node) {
            return;
        }
        handler(e);
    });
}
function addDisposableNonBubblingPointerOutListener(node, handler) {
    return addDisposableListener(node, 'pointerout', function (e) {
        // Mouse out bubbles, so this is an attempt to ignore faux mouse outs coming from children elements
        var toElement = (e.relatedTarget);
        while (toElement && toElement !== node) {
            toElement = toElement.parentNode;
        }
        if (toElement === node) {
            return;
        }
        handler(e);
    });
}
var _animationFrame = null;
function doRequestAnimationFrame(callback) {
    if (!_animationFrame) {
        var emulatedRequestAnimationFrame = function (callback) {
            return setTimeout(function () { return callback(new Date().getTime()); }, 0);
        };
        _animationFrame = (self.requestAnimationFrame
            || self.msRequestAnimationFrame
            || self.webkitRequestAnimationFrame
            || self.mozRequestAnimationFrame
            || self.oRequestAnimationFrame
            || emulatedRequestAnimationFrame);
    }
    return _animationFrame.call(self, callback);
}
/**
 * Schedule a callback to be run at the next animation frame.
 * This allows multiple parties to register callbacks that should run at the next animation frame.
 * If currently in an animation frame, `runner` will be executed immediately.
 * @return token that can be used to cancel the scheduled runner (only if `runner` was not executed immediately).
 */
var runAtThisOrScheduleAtNextAnimationFrame;
/**
 * Schedule a callback to be run at the next animation frame.
 * This allows multiple parties to register callbacks that should run at the next animation frame.
 * If currently in an animation frame, `runner` will be executed at the next animation frame.
 * @return token that can be used to cancel the scheduled runner.
 */
var scheduleAtNextAnimationFrame;
var AnimationFrameQueueItem = /** @class */ (function () {
    function AnimationFrameQueueItem(runner, priority) {
        if (priority === void 0) { priority = 0; }
        this._runner = runner;
        this.priority = priority;
        this._canceled = false;
    }
    AnimationFrameQueueItem.prototype.dispose = function () {
        this._canceled = true;
    };
    AnimationFrameQueueItem.prototype.execute = function () {
        if (this._canceled) {
            return;
        }
        try {
            this._runner();
        }
        catch (e) {
            Object(__WEBPACK_IMPORTED_MODULE_5__common_errors_js__["e" /* onUnexpectedError */])(e);
        }
    };
    // Sort by priority (largest to lowest)
    AnimationFrameQueueItem.sort = function (a, b) {
        return b.priority - a.priority;
    };
    return AnimationFrameQueueItem;
}());
(function () {
    /**
     * The runners scheduled at the next animation frame
     */
    var NEXT_QUEUE = [];
    /**
     * The runners scheduled at the current animation frame
     */
    var CURRENT_QUEUE = null;
    /**
     * A flag to keep track if the native requestAnimationFrame was already called
     */
    var animFrameRequested = false;
    /**
     * A flag to indicate if currently handling a native requestAnimationFrame callback
     */
    var inAnimationFrameRunner = false;
    var animationFrameRunner = function () {
        animFrameRequested = false;
        CURRENT_QUEUE = NEXT_QUEUE;
        NEXT_QUEUE = [];
        inAnimationFrameRunner = true;
        while (CURRENT_QUEUE.length > 0) {
            CURRENT_QUEUE.sort(AnimationFrameQueueItem.sort);
            var top_1 = CURRENT_QUEUE.shift();
            top_1.execute();
        }
        inAnimationFrameRunner = false;
    };
    scheduleAtNextAnimationFrame = function (runner, priority) {
        if (priority === void 0) { priority = 0; }
        var item = new AnimationFrameQueueItem(runner, priority);
        NEXT_QUEUE.push(item);
        if (!animFrameRequested) {
            animFrameRequested = true;
            doRequestAnimationFrame(animationFrameRunner);
        }
        return item;
    };
    runAtThisOrScheduleAtNextAnimationFrame = function (runner, priority) {
        if (inAnimationFrameRunner) {
            var item = new AnimationFrameQueueItem(runner, priority);
            CURRENT_QUEUE.push(item);
            return item;
        }
        else {
            return scheduleAtNextAnimationFrame(runner, priority);
        }
    };
})();
var MINIMUM_TIME_MS = 16;
var DEFAULT_EVENT_MERGER = function (lastEvent, currentEvent) {
    return currentEvent;
};
var TimeoutThrottledDomListener = /** @class */ (function (_super) {
    __extends(TimeoutThrottledDomListener, _super);
    function TimeoutThrottledDomListener(node, type, handler, eventMerger, minimumTimeMs) {
        if (eventMerger === void 0) { eventMerger = DEFAULT_EVENT_MERGER; }
        if (minimumTimeMs === void 0) { minimumTimeMs = MINIMUM_TIME_MS; }
        var _this = _super.call(this) || this;
        var lastEvent = null;
        var lastHandlerTime = 0;
        var timeout = _this._register(new __WEBPACK_IMPORTED_MODULE_4__common_async_js__["e" /* TimeoutTimer */]());
        var invokeHandler = function () {
            lastHandlerTime = (new Date()).getTime();
            handler(lastEvent);
            lastEvent = null;
        };
        _this._register(addDisposableListener(node, type, function (e) {
            lastEvent = eventMerger(lastEvent, e);
            var elapsedTime = (new Date()).getTime() - lastHandlerTime;
            if (elapsedTime >= minimumTimeMs) {
                timeout.cancel();
                invokeHandler();
            }
            else {
                timeout.setIfNotSet(invokeHandler, minimumTimeMs - elapsedTime);
            }
        }));
        return _this;
    }
    return TimeoutThrottledDomListener;
}(__WEBPACK_IMPORTED_MODULE_7__common_lifecycle_js__["a" /* Disposable */]));
function addDisposableThrottledListener(node, type, handler, eventMerger, minimumTimeMs) {
    return new TimeoutThrottledDomListener(node, type, handler, eventMerger, minimumTimeMs);
}
function getComputedStyle(el) {
    return document.defaultView.getComputedStyle(el, null);
}
function getClientArea(element) {
    // Try with DOM clientWidth / clientHeight
    if (element !== document.body) {
        return new Dimension(element.clientWidth, element.clientHeight);
    }
    // If visual view port exits and it's on mobile, it should be used instead of window innerWidth / innerHeight, or document.body.clientWidth / document.body.clientHeight
    if (__WEBPACK_IMPORTED_MODULE_8__common_platform_js__["c" /* isIOS */] && window.visualViewport) {
        var width = window.visualViewport.width;
        var height = window.visualViewport.height - (__WEBPACK_IMPORTED_MODULE_0__browser_js__["l" /* isStandalone */]
            // in PWA mode, the visual viewport always includes the safe-area-inset-bottom (which is for the home indicator)
            // even when you are using the onscreen monitor, the visual viewport will include the area between system statusbar and the onscreen keyboard
            // plus the area between onscreen keyboard and the bottom bezel, which is 20px on iOS.
            ? (20 + 4) // + 4px for body margin
            : 0);
        return new Dimension(width, height);
    }
    // Try innerWidth / innerHeight
    if (window.innerWidth && window.innerHeight) {
        return new Dimension(window.innerWidth, window.innerHeight);
    }
    // Try with document.body.clientWidth / document.body.clientHeight
    if (document.body && document.body.clientWidth && document.body.clientHeight) {
        return new Dimension(document.body.clientWidth, document.body.clientHeight);
    }
    // Try with document.documentElement.clientWidth / document.documentElement.clientHeight
    if (document.documentElement && document.documentElement.clientWidth && document.documentElement.clientHeight) {
        return new Dimension(document.documentElement.clientWidth, document.documentElement.clientHeight);
    }
    throw new Error('Unable to figure out browser width and height');
}
var SizeUtils = /** @class */ (function () {
    function SizeUtils() {
    }
    // Adapted from WinJS
    // Converts a CSS positioning string for the specified element to pixels.
    SizeUtils.convertToPixels = function (element, value) {
        return parseFloat(value) || 0;
    };
    SizeUtils.getDimension = function (element, cssPropertyName, jsPropertyName) {
        var computedStyle = getComputedStyle(element);
        var value = '0';
        if (computedStyle) {
            if (computedStyle.getPropertyValue) {
                value = computedStyle.getPropertyValue(cssPropertyName);
            }
            else {
                // IE8
                value = computedStyle.getAttribute(jsPropertyName);
            }
        }
        return SizeUtils.convertToPixels(element, value);
    };
    SizeUtils.getBorderLeftWidth = function (element) {
        return SizeUtils.getDimension(element, 'border-left-width', 'borderLeftWidth');
    };
    SizeUtils.getBorderRightWidth = function (element) {
        return SizeUtils.getDimension(element, 'border-right-width', 'borderRightWidth');
    };
    SizeUtils.getBorderTopWidth = function (element) {
        return SizeUtils.getDimension(element, 'border-top-width', 'borderTopWidth');
    };
    SizeUtils.getBorderBottomWidth = function (element) {
        return SizeUtils.getDimension(element, 'border-bottom-width', 'borderBottomWidth');
    };
    SizeUtils.getPaddingLeft = function (element) {
        return SizeUtils.getDimension(element, 'padding-left', 'paddingLeft');
    };
    SizeUtils.getPaddingRight = function (element) {
        return SizeUtils.getDimension(element, 'padding-right', 'paddingRight');
    };
    SizeUtils.getPaddingTop = function (element) {
        return SizeUtils.getDimension(element, 'padding-top', 'paddingTop');
    };
    SizeUtils.getPaddingBottom = function (element) {
        return SizeUtils.getDimension(element, 'padding-bottom', 'paddingBottom');
    };
    SizeUtils.getMarginLeft = function (element) {
        return SizeUtils.getDimension(element, 'margin-left', 'marginLeft');
    };
    SizeUtils.getMarginTop = function (element) {
        return SizeUtils.getDimension(element, 'margin-top', 'marginTop');
    };
    SizeUtils.getMarginRight = function (element) {
        return SizeUtils.getDimension(element, 'margin-right', 'marginRight');
    };
    SizeUtils.getMarginBottom = function (element) {
        return SizeUtils.getDimension(element, 'margin-bottom', 'marginBottom');
    };
    return SizeUtils;
}());
// ----------------------------------------------------------------------------------------
// Position & Dimension
var Dimension = /** @class */ (function () {
    function Dimension(width, height) {
        this.width = width;
        this.height = height;
    }
    return Dimension;
}());

function getTopLeftOffset(element) {
    // Adapted from WinJS.Utilities.getPosition
    // and added borders to the mix
    var offsetParent = element.offsetParent;
    var top = element.offsetTop;
    var left = element.offsetLeft;
    while ((element = element.parentNode) !== null
        && element !== document.body
        && element !== document.documentElement) {
        top -= element.scrollTop;
        var c = isShadowRoot(element) ? null : getComputedStyle(element);
        if (c) {
            left -= c.direction !== 'rtl' ? element.scrollLeft : -element.scrollLeft;
        }
        if (element === offsetParent) {
            left += SizeUtils.getBorderLeftWidth(element);
            top += SizeUtils.getBorderTopWidth(element);
            top += element.offsetTop;
            left += element.offsetLeft;
            offsetParent = element.offsetParent;
        }
    }
    return {
        left: left,
        top: top
    };
}
/**
 * Returns the position of a dom node relative to the entire page.
 */
function getDomNodePagePosition(domNode) {
    var bb = domNode.getBoundingClientRect();
    return {
        left: bb.left + StandardWindow.scrollX,
        top: bb.top + StandardWindow.scrollY,
        width: bb.width,
        height: bb.height
    };
}
var StandardWindow = new /** @class */ (function () {
    function class_3() {
    }
    Object.defineProperty(class_3.prototype, "scrollX", {
        get: function () {
            if (typeof window.scrollX === 'number') {
                // modern browsers
                return window.scrollX;
            }
            else {
                return document.body.scrollLeft + document.documentElement.scrollLeft;
            }
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(class_3.prototype, "scrollY", {
        get: function () {
            if (typeof window.scrollY === 'number') {
                // modern browsers
                return window.scrollY;
            }
            else {
                return document.body.scrollTop + document.documentElement.scrollTop;
            }
        },
        enumerable: true,
        configurable: true
    });
    return class_3;
}());
// Adapted from WinJS
// Gets the width of the element, including margins.
function getTotalWidth(element) {
    var margin = SizeUtils.getMarginLeft(element) + SizeUtils.getMarginRight(element);
    return element.offsetWidth + margin;
}
function getContentWidth(element) {
    var border = SizeUtils.getBorderLeftWidth(element) + SizeUtils.getBorderRightWidth(element);
    var padding = SizeUtils.getPaddingLeft(element) + SizeUtils.getPaddingRight(element);
    return element.offsetWidth - border - padding;
}
// Adapted from WinJS
// Gets the height of the content of the specified element. The content height does not include borders or padding.
function getContentHeight(element) {
    var border = SizeUtils.getBorderTopWidth(element) + SizeUtils.getBorderBottomWidth(element);
    var padding = SizeUtils.getPaddingTop(element) + SizeUtils.getPaddingBottom(element);
    return element.offsetHeight - border - padding;
}
// Adapted from WinJS
// Gets the height of the element, including its margins.
function getTotalHeight(element) {
    var margin = SizeUtils.getMarginTop(element) + SizeUtils.getMarginBottom(element);
    return element.offsetHeight + margin;
}
// ----------------------------------------------------------------------------------------
function isAncestor(testChild, testAncestor) {
    while (testChild) {
        if (testChild === testAncestor) {
            return true;
        }
        testChild = testChild.parentNode;
    }
    return false;
}
function findParentWithClass(node, clazz, stopAtClazzOrNode) {
    while (node && node.nodeType === node.ELEMENT_NODE) {
        if (hasClass(node, clazz)) {
            return node;
        }
        if (stopAtClazzOrNode) {
            if (typeof stopAtClazzOrNode === 'string') {
                if (hasClass(node, stopAtClazzOrNode)) {
                    return null;
                }
            }
            else {
                if (node === stopAtClazzOrNode) {
                    return null;
                }
            }
        }
        node = node.parentNode;
    }
    return null;
}
function isShadowRoot(node) {
    return (node && !!node.host && !!node.mode);
}
function isInShadowDOM(domNode) {
    return !!getShadowRoot(domNode);
}
function getShadowRoot(domNode) {
    while (domNode.parentNode) {
        if (domNode === document.body) {
            // reached the body
            return null;
        }
        domNode = domNode.parentNode;
    }
    return isShadowRoot(domNode) ? domNode : null;
}
function createStyleSheet(container) {
    if (container === void 0) { container = document.getElementsByTagName('head')[0]; }
    var style = document.createElement('style');
    style.type = 'text/css';
    style.media = 'screen';
    container.appendChild(style);
    return style;
}
var _sharedStyleSheet = null;
function getSharedStyleSheet() {
    if (!_sharedStyleSheet) {
        _sharedStyleSheet = createStyleSheet();
    }
    return _sharedStyleSheet;
}
function getDynamicStyleSheetRules(style) {
    if (style && style.sheet && style.sheet.rules) {
        // Chrome, IE
        return style.sheet.rules;
    }
    if (style && style.sheet && style.sheet.cssRules) {
        // FF
        return style.sheet.cssRules;
    }
    return [];
}
function createCSSRule(selector, cssText, style) {
    if (style === void 0) { style = getSharedStyleSheet(); }
    if (!style || !cssText) {
        return;
    }
    style.sheet.insertRule(selector + '{' + cssText + '}', 0);
}
function removeCSSRulesContainingSelector(ruleName, style) {
    if (style === void 0) { style = getSharedStyleSheet(); }
    if (!style) {
        return;
    }
    var rules = getDynamicStyleSheetRules(style);
    var toDelete = [];
    for (var i = 0; i < rules.length; i++) {
        var rule = rules[i];
        if (rule.selectorText.indexOf(ruleName) !== -1) {
            toDelete.push(i);
        }
    }
    for (var i = toDelete.length - 1; i >= 0; i--) {
        style.sheet.deleteRule(toDelete[i]);
    }
}
function isHTMLElement(o) {
    if (typeof HTMLElement === 'object') {
        return o instanceof HTMLElement;
    }
    return o && typeof o === 'object' && o.nodeType === 1 && typeof o.nodeName === 'string';
}
var EventType = {
    // Mouse
    CLICK: 'click',
    DBLCLICK: 'dblclick',
    MOUSE_UP: 'mouseup',
    MOUSE_DOWN: 'mousedown',
    MOUSE_OVER: 'mouseover',
    MOUSE_MOVE: 'mousemove',
    MOUSE_OUT: 'mouseout',
    MOUSE_ENTER: 'mouseenter',
    MOUSE_LEAVE: 'mouseleave',
    POINTER_UP: 'pointerup',
    POINTER_DOWN: 'pointerdown',
    POINTER_MOVE: 'pointermove',
    CONTEXT_MENU: 'contextmenu',
    WHEEL: 'wheel',
    // Keyboard
    KEY_DOWN: 'keydown',
    KEY_PRESS: 'keypress',
    KEY_UP: 'keyup',
    // HTML Document
    LOAD: 'load',
    BEFORE_UNLOAD: 'beforeunload',
    UNLOAD: 'unload',
    ABORT: 'abort',
    ERROR: 'error',
    RESIZE: 'resize',
    SCROLL: 'scroll',
    FULLSCREEN_CHANGE: 'fullscreenchange',
    WK_FULLSCREEN_CHANGE: 'webkitfullscreenchange',
    // Form
    SELECT: 'select',
    CHANGE: 'change',
    SUBMIT: 'submit',
    RESET: 'reset',
    FOCUS: 'focus',
    FOCUS_IN: 'focusin',
    FOCUS_OUT: 'focusout',
    BLUR: 'blur',
    INPUT: 'input',
    // Local Storage
    STORAGE: 'storage',
    // Drag
    DRAG_START: 'dragstart',
    DRAG: 'drag',
    DRAG_ENTER: 'dragenter',
    DRAG_LEAVE: 'dragleave',
    DRAG_OVER: 'dragover',
    DROP: 'drop',
    DRAG_END: 'dragend',
    // Animation
    ANIMATION_START: __WEBPACK_IMPORTED_MODULE_0__browser_js__["m" /* isWebKit */] ? 'webkitAnimationStart' : 'animationstart',
    ANIMATION_END: __WEBPACK_IMPORTED_MODULE_0__browser_js__["m" /* isWebKit */] ? 'webkitAnimationEnd' : 'animationend',
    ANIMATION_ITERATION: __WEBPACK_IMPORTED_MODULE_0__browser_js__["m" /* isWebKit */] ? 'webkitAnimationIteration' : 'animationiteration'
};
var EventHelper = {
    stop: function (e, cancelBubble) {
        if (e.preventDefault) {
            e.preventDefault();
        }
        else {
            // IE8
            e.returnValue = false;
        }
        if (cancelBubble) {
            if (e.stopPropagation) {
                e.stopPropagation();
            }
            else {
                // IE8
                e.cancelBubble = true;
            }
        }
    }
};
function saveParentsScrollTop(node) {
    var r = [];
    for (var i = 0; node && node.nodeType === node.ELEMENT_NODE; i++) {
        r[i] = node.scrollTop;
        node = node.parentNode;
    }
    return r;
}
function restoreParentsScrollTop(node, state) {
    for (var i = 0; node && node.nodeType === node.ELEMENT_NODE; i++) {
        if (node.scrollTop !== state[i]) {
            node.scrollTop = state[i];
        }
        node = node.parentNode;
    }
}
var FocusTracker = /** @class */ (function (_super) {
    __extends(FocusTracker, _super);
    function FocusTracker(element) {
        var _this = _super.call(this) || this;
        _this._onDidFocus = _this._register(new __WEBPACK_IMPORTED_MODULE_6__common_event_js__["a" /* Emitter */]());
        _this.onDidFocus = _this._onDidFocus.event;
        _this._onDidBlur = _this._register(new __WEBPACK_IMPORTED_MODULE_6__common_event_js__["a" /* Emitter */]());
        _this.onDidBlur = _this._onDidBlur.event;
        var hasFocus = isAncestor(document.activeElement, element);
        var loosingFocus = false;
        var onFocus = function () {
            loosingFocus = false;
            if (!hasFocus) {
                hasFocus = true;
                _this._onDidFocus.fire();
            }
        };
        var onBlur = function () {
            if (hasFocus) {
                loosingFocus = true;
                window.setTimeout(function () {
                    if (loosingFocus) {
                        loosingFocus = false;
                        hasFocus = false;
                        _this._onDidBlur.fire();
                    }
                }, 0);
            }
        };
        _this._refreshStateHandler = function () {
            var currentNodeHasFocus = isAncestor(document.activeElement, element);
            if (currentNodeHasFocus !== hasFocus) {
                if (hasFocus) {
                    onBlur();
                }
                else {
                    onFocus();
                }
            }
        };
        _this._register(Object(__WEBPACK_IMPORTED_MODULE_1__event_js__["a" /* domEvent */])(element, EventType.FOCUS, true)(onFocus));
        _this._register(Object(__WEBPACK_IMPORTED_MODULE_1__event_js__["a" /* domEvent */])(element, EventType.BLUR, true)(onBlur));
        return _this;
    }
    return FocusTracker;
}(__WEBPACK_IMPORTED_MODULE_7__common_lifecycle_js__["a" /* Disposable */]));
function trackFocus(element) {
    return new FocusTracker(element);
}
function append(parent) {
    var children = [];
    for (var _i = 1; _i < arguments.length; _i++) {
        children[_i - 1] = arguments[_i];
    }
    children.forEach(function (child) { return parent.appendChild(child); });
    return children[children.length - 1];
}
var SELECTOR_REGEX = /([\w\-]+)?(#([\w\-]+))?((.([\w\-]+))*)/;
var Namespace;
(function (Namespace) {
    Namespace["HTML"] = "http://www.w3.org/1999/xhtml";
    Namespace["SVG"] = "http://www.w3.org/2000/svg";
})(Namespace || (Namespace = {}));
function _$(namespace, description, attrs) {
    var children = [];
    for (var _i = 3; _i < arguments.length; _i++) {
        children[_i - 3] = arguments[_i];
    }
    var match = SELECTOR_REGEX.exec(description);
    if (!match) {
        throw new Error('Bad use of emmet');
    }
    attrs = __assign({}, (attrs || {}));
    var tagName = match[1] || 'div';
    var result;
    if (namespace !== Namespace.HTML) {
        result = document.createElementNS(namespace, tagName);
    }
    else {
        result = document.createElement(tagName);
    }
    if (match[3]) {
        result.id = match[3];
    }
    if (match[4]) {
        result.className = match[4].replace(/\./g, ' ').trim();
    }
    Object.keys(attrs).forEach(function (name) {
        var value = attrs[name];
        if (typeof value === 'undefined') {
            return;
        }
        if (/^on\w+$/.test(name)) {
            result[name] = value;
        }
        else if (name === 'selected') {
            if (value) {
                result.setAttribute(name, 'true');
            }
        }
        else {
            result.setAttribute(name, value);
        }
    });
    Object(__WEBPACK_IMPORTED_MODULE_9__common_arrays_js__["d" /* coalesce */])(children)
        .forEach(function (child) {
        if (child instanceof Node) {
            result.appendChild(child);
        }
        else {
            result.appendChild(document.createTextNode(child));
        }
    });
    return result;
}
function $(description, attrs) {
    var children = [];
    for (var _i = 2; _i < arguments.length; _i++) {
        children[_i - 2] = arguments[_i];
    }
    return _$.apply(void 0, __spreadArrays([Namespace.HTML, description, attrs], children));
}
$.SVG = function (description, attrs) {
    var children = [];
    for (var _i = 2; _i < arguments.length; _i++) {
        children[_i - 2] = arguments[_i];
    }
    return _$.apply(void 0, __spreadArrays([Namespace.SVG, description, attrs], children));
};
function show() {
    var elements = [];
    for (var _i = 0; _i < arguments.length; _i++) {
        elements[_i] = arguments[_i];
    }
    for (var _a = 0, elements_1 = elements; _a < elements_1.length; _a++) {
        var element = elements_1[_a];
        element.style.display = '';
        element.removeAttribute('aria-hidden');
    }
}
function hide() {
    var elements = [];
    for (var _i = 0; _i < arguments.length; _i++) {
        elements[_i] = arguments[_i];
    }
    for (var _a = 0, elements_2 = elements; _a < elements_2.length; _a++) {
        var element = elements_2[_a];
        element.style.display = 'none';
        element.setAttribute('aria-hidden', 'true');
    }
}
function findParentWithAttribute(node, attribute) {
    while (node && node.nodeType === node.ELEMENT_NODE) {
        if (node instanceof HTMLElement && node.hasAttribute(attribute)) {
            return node;
        }
        node = node.parentNode;
    }
    return null;
}
function removeTabIndexAndUpdateFocus(node) {
    if (!node || !node.hasAttribute('tabIndex')) {
        return;
    }
    // If we are the currently focused element and tabIndex is removed,
    // standard DOM behavior is to move focus to the <body> element. We
    // typically never want that, rather put focus to the closest element
    // in the hierarchy of the parent DOM nodes.
    if (document.activeElement === node) {
        var parentFocusable = findParentWithAttribute(node.parentElement, 'tabIndex');
        if (parentFocusable) {
            parentFocusable.focus();
        }
    }
    node.removeAttribute('tabindex');
}
function getElementsByTagName(tag) {
    return Array.prototype.slice.call(document.getElementsByTagName(tag), 0);
}
/**
 * Find a value usable for a dom node size such that the likelihood that it would be
 * displayed with constant screen pixels size is as high as possible.
 *
 * e.g. We would desire for the cursors to be 2px (CSS px) wide. Under a devicePixelRatio
 * of 1.25, the cursor will be 2.5 screen pixels wide. Depending on how the dom node aligns/"snaps"
 * with the screen pixels, it will sometimes be rendered with 2 screen pixels, and sometimes with 3 screen pixels.
 */
function computeScreenAwareSize(cssPx) {
    var screenPx = window.devicePixelRatio * cssPx;
    return Math.max(1, Math.floor(screenPx)) / window.devicePixelRatio;
}
/**
 * See https://github.com/Microsoft/monaco-editor/issues/601
 * To protect against malicious code in the linked site, particularly phishing attempts,
 * the window.opener should be set to null to prevent the linked site from having access
 * to change the location of the current page.
 * See https://mathiasbynens.github.io/rel-noopener/
 */
function windowOpenNoOpener(url) {
    if (__WEBPACK_IMPORTED_MODULE_8__common_platform_js__["f" /* isNative */] || __WEBPACK_IMPORTED_MODULE_0__browser_js__["g" /* isEdgeWebView */]) {
        // In VSCode, window.open() always returns null...
        // The same is true for a WebView (see https://github.com/Microsoft/monaco-editor/issues/628)
        window.open(url);
    }
    else {
        var newTab = window.open();
        if (newTab) {
            newTab.opener = null;
            newTab.location.href = url;
        }
    }
}
function animate(fn) {
    var step = function () {
        fn();
        stepDisposable = scheduleAtNextAnimationFrame(step);
    };
    var stepDisposable = scheduleAtNextAnimationFrame(step);
    return Object(__WEBPACK_IMPORTED_MODULE_7__common_lifecycle_js__["h" /* toDisposable */])(function () { return stepDisposable.dispose(); });
}
__WEBPACK_IMPORTED_MODULE_10__common_network_js__["a" /* RemoteAuthorities */].setPreferredWebSchema(/^https:/.test(window.location.href) ? 'https' : 'http');
function asDomUri(uri) {
    if (!uri) {
        return uri;
    }
    if (__WEBPACK_IMPORTED_MODULE_10__common_network_js__["b" /* Schemas */].vscodeRemote === uri.scheme) {
        return __WEBPACK_IMPORTED_MODULE_10__common_network_js__["a" /* RemoteAuthorities */].rewrite(uri);
    }
    return uri;
}
/**
 * returns url('...')
 */
function asCSSUrl(uri) {
    if (!uri) {
        return "url('')";
    }
    return "url('" + asDomUri(uri).toString(true).replace(/'/g, '%27') + "')";
}


/***/ }),
/* 4 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (immutable) */ __webpack_exports__["x"] = isFalsyOrWhitespace;
/* harmony export (immutable) */ __webpack_exports__["F"] = pad;
/* harmony export (immutable) */ __webpack_exports__["r"] = format;
/* harmony export (immutable) */ __webpack_exports__["o"] = escape;
/* harmony export (immutable) */ __webpack_exports__["p"] = escapeRegExpCharacters;
/* harmony export (immutable) */ __webpack_exports__["Q"] = trim;
/* unused harmony export ltrim */
/* harmony export (immutable) */ __webpack_exports__["K"] = rtrim;
/* harmony export (immutable) */ __webpack_exports__["k"] = convertSimple2RegExpPattern;
/* harmony export (immutable) */ __webpack_exports__["N"] = startsWith;
/* harmony export (immutable) */ __webpack_exports__["m"] = endsWith;
/* harmony export (immutable) */ __webpack_exports__["l"] = createRegExp;
/* harmony export (immutable) */ __webpack_exports__["I"] = regExpLeadsToEndlessLoop;
/* harmony export (immutable) */ __webpack_exports__["H"] = regExpFlags;
/* harmony export (immutable) */ __webpack_exports__["q"] = firstNonWhitespaceIndex;
/* harmony export (immutable) */ __webpack_exports__["t"] = getLeadingWhitespace;
/* harmony export (immutable) */ __webpack_exports__["D"] = lastNonWhitespaceIndex;
/* harmony export (immutable) */ __webpack_exports__["e"] = compare;
/* harmony export (immutable) */ __webpack_exports__["f"] = compareIgnoreCase;
/* harmony export (immutable) */ __webpack_exports__["B"] = isLowerAsciiLetter;
/* harmony export (immutable) */ __webpack_exports__["C"] = isUpperAsciiLetter;
/* harmony export (immutable) */ __webpack_exports__["n"] = equalsIgnoreCase;
/* harmony export (immutable) */ __webpack_exports__["O"] = startsWithIgnoreCase;
/* harmony export (immutable) */ __webpack_exports__["c"] = commonPrefixLength;
/* harmony export (immutable) */ __webpack_exports__["d"] = commonSuffixLength;
/* harmony export (immutable) */ __webpack_exports__["z"] = isHighSurrogate;
/* harmony export (immutable) */ __webpack_exports__["A"] = isLowSurrogate;
/* harmony export (immutable) */ __webpack_exports__["u"] = getNextCodePoint;
/* harmony export (immutable) */ __webpack_exports__["E"] = nextCharLength;
/* harmony export (immutable) */ __webpack_exports__["G"] = prevCharLength;
/* harmony export (immutable) */ __webpack_exports__["i"] = containsRTL;
/* harmony export (immutable) */ __webpack_exports__["g"] = containsEmoji;
/* harmony export (immutable) */ __webpack_exports__["v"] = isBasicASCII;
/* harmony export (immutable) */ __webpack_exports__["h"] = containsFullWidthCharacter;
/* harmony export (immutable) */ __webpack_exports__["y"] = isFullWidthCharacter;
/* harmony export (immutable) */ __webpack_exports__["w"] = isEmojiImprecise;
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return UTF8_BOM_CHARACTER; });
/* harmony export (immutable) */ __webpack_exports__["P"] = startsWithUTF8BOM;
/* harmony export (immutable) */ __webpack_exports__["L"] = safeBtoa;
/* harmony export (immutable) */ __webpack_exports__["J"] = repeat;
/* harmony export (immutable) */ __webpack_exports__["j"] = containsUppercaseCharacter;
/* harmony export (immutable) */ __webpack_exports__["M"] = singleLetterHash;
/* harmony export (immutable) */ __webpack_exports__["s"] = getGraphemeBreakType;
/* harmony export (immutable) */ __webpack_exports__["b"] = breakBetweenGraphemeBreakType;
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
function isFalsyOrWhitespace(str) {
    if (!str || typeof str !== 'string') {
        return true;
    }
    return str.trim().length === 0;
}
/**
 * @returns the provided number with the given number of preceding zeros.
 */
function pad(n, l, char) {
    if (char === void 0) { char = '0'; }
    var str = '' + n;
    var r = [str];
    for (var i = str.length; i < l; i++) {
        r.push(char);
    }
    return r.reverse().join('');
}
var _formatRegexp = /{(\d+)}/g;
/**
 * Helper to produce a string with a variable number of arguments. Insert variable segments
 * into the string using the {n} notation where N is the index of the argument following the string.
 * @param value string to which formatting is applied
 * @param args replacements for {n}-entries
 */
function format(value) {
    var args = [];
    for (var _i = 1; _i < arguments.length; _i++) {
        args[_i - 1] = arguments[_i];
    }
    if (args.length === 0) {
        return value;
    }
    return value.replace(_formatRegexp, function (match, group) {
        var idx = parseInt(group, 10);
        return isNaN(idx) || idx < 0 || idx >= args.length ?
            match :
            args[idx];
    });
}
/**
 * Converts HTML characters inside the string to use entities instead. Makes the string safe from
 * being used e.g. in HTMLElement.innerHTML.
 */
function escape(html) {
    return html.replace(/[<>&]/g, function (match) {
        switch (match) {
            case '<': return '&lt;';
            case '>': return '&gt;';
            case '&': return '&amp;';
            default: return match;
        }
    });
}
/**
 * Escapes regular expression characters in a given string
 */
function escapeRegExpCharacters(value) {
    return value.replace(/[\\\{\}\*\+\?\|\^\$\.\[\]\(\)]/g, '\\$&');
}
/**
 * Removes all occurrences of needle from the beginning and end of haystack.
 * @param haystack string to trim
 * @param needle the thing to trim (default is a blank)
 */
function trim(haystack, needle) {
    if (needle === void 0) { needle = ' '; }
    var trimmed = ltrim(haystack, needle);
    return rtrim(trimmed, needle);
}
/**
 * Removes all occurrences of needle from the beginning of haystack.
 * @param haystack string to trim
 * @param needle the thing to trim
 */
function ltrim(haystack, needle) {
    if (!haystack || !needle) {
        return haystack;
    }
    var needleLen = needle.length;
    if (needleLen === 0 || haystack.length === 0) {
        return haystack;
    }
    var offset = 0;
    while (haystack.indexOf(needle, offset) === offset) {
        offset = offset + needleLen;
    }
    return haystack.substring(offset);
}
/**
 * Removes all occurrences of needle from the end of haystack.
 * @param haystack string to trim
 * @param needle the thing to trim
 */
function rtrim(haystack, needle) {
    if (!haystack || !needle) {
        return haystack;
    }
    var needleLen = needle.length, haystackLen = haystack.length;
    if (needleLen === 0 || haystackLen === 0) {
        return haystack;
    }
    var offset = haystackLen, idx = -1;
    while (true) {
        idx = haystack.lastIndexOf(needle, offset - 1);
        if (idx === -1 || idx + needleLen !== offset) {
            break;
        }
        if (idx === 0) {
            return '';
        }
        offset = idx;
    }
    return haystack.substring(0, offset);
}
function convertSimple2RegExpPattern(pattern) {
    return pattern.replace(/[\-\\\{\}\+\?\|\^\$\.\,\[\]\(\)\#\s]/g, '\\$&').replace(/[\*]/g, '.*');
}
/**
 * Determines if haystack starts with needle.
 */
function startsWith(haystack, needle) {
    if (haystack.length < needle.length) {
        return false;
    }
    if (haystack === needle) {
        return true;
    }
    for (var i = 0; i < needle.length; i++) {
        if (haystack[i] !== needle[i]) {
            return false;
        }
    }
    return true;
}
/**
 * Determines if haystack ends with needle.
 */
function endsWith(haystack, needle) {
    var diff = haystack.length - needle.length;
    if (diff > 0) {
        return haystack.indexOf(needle, diff) === diff;
    }
    else if (diff === 0) {
        return haystack === needle;
    }
    else {
        return false;
    }
}
function createRegExp(searchString, isRegex, options) {
    if (options === void 0) { options = {}; }
    if (!searchString) {
        throw new Error('Cannot create regex from empty string');
    }
    if (!isRegex) {
        searchString = escapeRegExpCharacters(searchString);
    }
    if (options.wholeWord) {
        if (!/\B/.test(searchString.charAt(0))) {
            searchString = '\\b' + searchString;
        }
        if (!/\B/.test(searchString.charAt(searchString.length - 1))) {
            searchString = searchString + '\\b';
        }
    }
    var modifiers = '';
    if (options.global) {
        modifiers += 'g';
    }
    if (!options.matchCase) {
        modifiers += 'i';
    }
    if (options.multiline) {
        modifiers += 'm';
    }
    if (options.unicode) {
        modifiers += 'u';
    }
    return new RegExp(searchString, modifiers);
}
function regExpLeadsToEndlessLoop(regexp) {
    // Exit early if it's one of these special cases which are meant to match
    // against an empty string
    if (regexp.source === '^' || regexp.source === '^$' || regexp.source === '$' || regexp.source === '^\\s*$') {
        return false;
    }
    // We check against an empty string. If the regular expression doesn't advance
    // (e.g. ends in an endless loop) it will match an empty string.
    var match = regexp.exec('');
    return !!(match && regexp.lastIndex === 0);
}
function regExpFlags(regexp) {
    return (regexp.global ? 'g' : '')
        + (regexp.ignoreCase ? 'i' : '')
        + (regexp.multiline ? 'm' : '')
        + (regexp.unicode ? 'u' : '');
}
/**
 * Returns first index of the string that is not whitespace.
 * If string is empty or contains only whitespaces, returns -1
 */
function firstNonWhitespaceIndex(str) {
    for (var i = 0, len = str.length; i < len; i++) {
        var chCode = str.charCodeAt(i);
        if (chCode !== 32 /* Space */ && chCode !== 9 /* Tab */) {
            return i;
        }
    }
    return -1;
}
/**
 * Returns the leading whitespace of the string.
 * If the string contains only whitespaces, returns entire string
 */
function getLeadingWhitespace(str, start, end) {
    if (start === void 0) { start = 0; }
    if (end === void 0) { end = str.length; }
    for (var i = start; i < end; i++) {
        var chCode = str.charCodeAt(i);
        if (chCode !== 32 /* Space */ && chCode !== 9 /* Tab */) {
            return str.substring(start, i);
        }
    }
    return str.substring(start, end);
}
/**
 * Returns last index of the string that is not whitespace.
 * If string is empty or contains only whitespaces, returns -1
 */
function lastNonWhitespaceIndex(str, startIndex) {
    if (startIndex === void 0) { startIndex = str.length - 1; }
    for (var i = startIndex; i >= 0; i--) {
        var chCode = str.charCodeAt(i);
        if (chCode !== 32 /* Space */ && chCode !== 9 /* Tab */) {
            return i;
        }
    }
    return -1;
}
function compare(a, b) {
    if (a < b) {
        return -1;
    }
    else if (a > b) {
        return 1;
    }
    else {
        return 0;
    }
}
function compareIgnoreCase(a, b) {
    var len = Math.min(a.length, b.length);
    for (var i = 0; i < len; i++) {
        var codeA = a.charCodeAt(i);
        var codeB = b.charCodeAt(i);
        if (codeA === codeB) {
            // equal
            continue;
        }
        if (isUpperAsciiLetter(codeA)) {
            codeA += 32;
        }
        if (isUpperAsciiLetter(codeB)) {
            codeB += 32;
        }
        var diff = codeA - codeB;
        if (diff === 0) {
            // equal -> ignoreCase
            continue;
        }
        else if (isLowerAsciiLetter(codeA) && isLowerAsciiLetter(codeB)) {
            //
            return diff;
        }
        else {
            return compare(a.toLowerCase(), b.toLowerCase());
        }
    }
    if (a.length < b.length) {
        return -1;
    }
    else if (a.length > b.length) {
        return 1;
    }
    else {
        return 0;
    }
}
function isLowerAsciiLetter(code) {
    return code >= 97 /* a */ && code <= 122 /* z */;
}
function isUpperAsciiLetter(code) {
    return code >= 65 /* A */ && code <= 90 /* Z */;
}
function isAsciiLetter(code) {
    return isLowerAsciiLetter(code) || isUpperAsciiLetter(code);
}
function equalsIgnoreCase(a, b) {
    return a.length === b.length && doEqualsIgnoreCase(a, b);
}
function doEqualsIgnoreCase(a, b, stopAt) {
    if (stopAt === void 0) { stopAt = a.length; }
    for (var i = 0; i < stopAt; i++) {
        var codeA = a.charCodeAt(i);
        var codeB = b.charCodeAt(i);
        if (codeA === codeB) {
            continue;
        }
        // a-z A-Z
        if (isAsciiLetter(codeA) && isAsciiLetter(codeB)) {
            var diff = Math.abs(codeA - codeB);
            if (diff !== 0 && diff !== 32) {
                return false;
            }
        }
        // Any other charcode
        else {
            if (String.fromCharCode(codeA).toLowerCase() !== String.fromCharCode(codeB).toLowerCase()) {
                return false;
            }
        }
    }
    return true;
}
function startsWithIgnoreCase(str, candidate) {
    var candidateLength = candidate.length;
    if (candidate.length > str.length) {
        return false;
    }
    return doEqualsIgnoreCase(str, candidate, candidateLength);
}
/**
 * @returns the length of the common prefix of the two strings.
 */
function commonPrefixLength(a, b) {
    var i, len = Math.min(a.length, b.length);
    for (i = 0; i < len; i++) {
        if (a.charCodeAt(i) !== b.charCodeAt(i)) {
            return i;
        }
    }
    return len;
}
/**
 * @returns the length of the common suffix of the two strings.
 */
function commonSuffixLength(a, b) {
    var i, len = Math.min(a.length, b.length);
    var aLastIndex = a.length - 1;
    var bLastIndex = b.length - 1;
    for (i = 0; i < len; i++) {
        if (a.charCodeAt(aLastIndex - i) !== b.charCodeAt(bLastIndex - i)) {
            return i;
        }
    }
    return len;
}
// --- unicode
// http://en.wikipedia.org/wiki/Surrogate_pair
// Returns the code point starting at a specified index in a string
// Code points U+0000 to U+D7FF and U+E000 to U+FFFF are represented on a single character
// Code points U+10000 to U+10FFFF are represented on two consecutive characters
//export function getUnicodePoint(str:string, index:number, len:number):number {
//	const chrCode = str.charCodeAt(index);
//	if (0xD800 <= chrCode && chrCode <= 0xDBFF && index + 1 < len) {
//		const nextChrCode = str.charCodeAt(index + 1);
//		if (0xDC00 <= nextChrCode && nextChrCode <= 0xDFFF) {
//			return (chrCode - 0xD800) << 10 + (nextChrCode - 0xDC00) + 0x10000;
//		}
//	}
//	return chrCode;
//}
function isHighSurrogate(charCode) {
    return (0xD800 <= charCode && charCode <= 0xDBFF);
}
function isLowSurrogate(charCode) {
    return (0xDC00 <= charCode && charCode <= 0xDFFF);
}
/**
 * get the code point that begins at offset `offset`
 */
function getNextCodePoint(str, len, offset) {
    var charCode = str.charCodeAt(offset);
    if (isHighSurrogate(charCode) && offset + 1 < len) {
        var nextCharCode = str.charCodeAt(offset + 1);
        if (isLowSurrogate(nextCharCode)) {
            return ((charCode - 0xD800) << 10) + (nextCharCode - 0xDC00) + 0x10000;
        }
    }
    return charCode;
}
/**
 * get the code point that ends right before offset `offset`
 */
function getPrevCodePoint(str, offset) {
    var charCode = str.charCodeAt(offset - 1);
    if (isLowSurrogate(charCode) && offset > 1) {
        var prevCharCode = str.charCodeAt(offset - 2);
        if (isHighSurrogate(prevCharCode)) {
            return ((prevCharCode - 0xD800) << 10) + (charCode - 0xDC00) + 0x10000;
        }
    }
    return charCode;
}
function nextCharLength(str, offset) {
    var graphemeBreakTree = GraphemeBreakTree.getInstance();
    var initialOffset = offset;
    var len = str.length;
    var initialCodePoint = getNextCodePoint(str, len, offset);
    offset += (initialCodePoint >= 65536 /* UNICODE_SUPPLEMENTARY_PLANE_BEGIN */ ? 2 : 1);
    var graphemeBreakType = graphemeBreakTree.getGraphemeBreakType(initialCodePoint);
    while (offset < len) {
        var nextCodePoint = getNextCodePoint(str, len, offset);
        var nextGraphemeBreakType = graphemeBreakTree.getGraphemeBreakType(nextCodePoint);
        if (breakBetweenGraphemeBreakType(graphemeBreakType, nextGraphemeBreakType)) {
            break;
        }
        offset += (nextCodePoint >= 65536 /* UNICODE_SUPPLEMENTARY_PLANE_BEGIN */ ? 2 : 1);
        graphemeBreakType = nextGraphemeBreakType;
    }
    return (offset - initialOffset);
}
function prevCharLength(str, offset) {
    var graphemeBreakTree = GraphemeBreakTree.getInstance();
    var initialOffset = offset;
    var initialCodePoint = getPrevCodePoint(str, offset);
    offset -= (initialCodePoint >= 65536 /* UNICODE_SUPPLEMENTARY_PLANE_BEGIN */ ? 2 : 1);
    var graphemeBreakType = graphemeBreakTree.getGraphemeBreakType(initialCodePoint);
    while (offset > 0) {
        var prevCodePoint = getPrevCodePoint(str, offset);
        var prevGraphemeBreakType = graphemeBreakTree.getGraphemeBreakType(prevCodePoint);
        if (breakBetweenGraphemeBreakType(prevGraphemeBreakType, graphemeBreakType)) {
            break;
        }
        offset -= (prevCodePoint >= 65536 /* UNICODE_SUPPLEMENTARY_PLANE_BEGIN */ ? 2 : 1);
        graphemeBreakType = prevGraphemeBreakType;
    }
    return (initialOffset - offset);
}
/**
 * Generated using https://github.com/alexandrudima/unicode-utils/blob/master/generate-rtl-test.js
 */
var CONTAINS_RTL = /(?:[\u05BE\u05C0\u05C3\u05C6\u05D0-\u05F4\u0608\u060B\u060D\u061B-\u064A\u066D-\u066F\u0671-\u06D5\u06E5\u06E6\u06EE\u06EF\u06FA-\u0710\u0712-\u072F\u074D-\u07A5\u07B1-\u07EA\u07F4\u07F5\u07FA-\u0815\u081A\u0824\u0828\u0830-\u0858\u085E-\u08BD\u200F\uFB1D\uFB1F-\uFB28\uFB2A-\uFD3D\uFD50-\uFDFC\uFE70-\uFEFC]|\uD802[\uDC00-\uDD1B\uDD20-\uDE00\uDE10-\uDE33\uDE40-\uDEE4\uDEEB-\uDF35\uDF40-\uDFFF]|\uD803[\uDC00-\uDCFF]|\uD83A[\uDC00-\uDCCF\uDD00-\uDD43\uDD50-\uDFFF]|\uD83B[\uDC00-\uDEBB])/;
/**
 * Returns true if `str` contains any Unicode character that is classified as "R" or "AL".
 */
function containsRTL(str) {
    return CONTAINS_RTL.test(str);
}
/**
 * Generated using https://github.com/alexandrudima/unicode-utils/blob/master/generate-emoji-test.js
 */
var CONTAINS_EMOJI = /(?:[\u231A\u231B\u23F0\u23F3\u2600-\u27BF\u2B50\u2B55]|\uD83C[\uDDE6-\uDDFF\uDF00-\uDFFF]|\uD83D[\uDC00-\uDE4F\uDE80-\uDEFC\uDFE0-\uDFEB]|\uD83E[\uDD00-\uDDFF\uDE70-\uDE73\uDE78-\uDE82\uDE90-\uDE95])/;
function containsEmoji(str) {
    return CONTAINS_EMOJI.test(str);
}
var IS_BASIC_ASCII = /^[\t\n\r\x20-\x7E]*$/;
/**
 * Returns true if `str` contains only basic ASCII characters in the range 32 - 126 (including 32 and 126) or \n, \r, \t
 */
function isBasicASCII(str) {
    return IS_BASIC_ASCII.test(str);
}
function containsFullWidthCharacter(str) {
    for (var i = 0, len = str.length; i < len; i++) {
        if (isFullWidthCharacter(str.charCodeAt(i))) {
            return true;
        }
    }
    return false;
}
function isFullWidthCharacter(charCode) {
    // Do a cheap trick to better support wrapping of wide characters, treat them as 2 columns
    // http://jrgraphix.net/research/unicode_blocks.php
    //          2E80 — 2EFF   CJK Radicals Supplement
    //          2F00 — 2FDF   Kangxi Radicals
    //          2FF0 — 2FFF   Ideographic Description Characters
    //          3000 — 303F   CJK Symbols and Punctuation
    //          3040 — 309F   Hiragana
    //          30A0 — 30FF   Katakana
    //          3100 — 312F   Bopomofo
    //          3130 — 318F   Hangul Compatibility Jamo
    //          3190 — 319F   Kanbun
    //          31A0 — 31BF   Bopomofo Extended
    //          31F0 — 31FF   Katakana Phonetic Extensions
    //          3200 — 32FF   Enclosed CJK Letters and Months
    //          3300 — 33FF   CJK Compatibility
    //          3400 — 4DBF   CJK Unified Ideographs Extension A
    //          4DC0 — 4DFF   Yijing Hexagram Symbols
    //          4E00 — 9FFF   CJK Unified Ideographs
    //          A000 — A48F   Yi Syllables
    //          A490 — A4CF   Yi Radicals
    //          AC00 — D7AF   Hangul Syllables
    // [IGNORE] D800 — DB7F   High Surrogates
    // [IGNORE] DB80 — DBFF   High Private Use Surrogates
    // [IGNORE] DC00 — DFFF   Low Surrogates
    // [IGNORE] E000 — F8FF   Private Use Area
    //          F900 — FAFF   CJK Compatibility Ideographs
    // [IGNORE] FB00 — FB4F   Alphabetic Presentation Forms
    // [IGNORE] FB50 — FDFF   Arabic Presentation Forms-A
    // [IGNORE] FE00 — FE0F   Variation Selectors
    // [IGNORE] FE20 — FE2F   Combining Half Marks
    // [IGNORE] FE30 — FE4F   CJK Compatibility Forms
    // [IGNORE] FE50 — FE6F   Small Form Variants
    // [IGNORE] FE70 — FEFF   Arabic Presentation Forms-B
    //          FF00 — FFEF   Halfwidth and Fullwidth Forms
    //               [https://en.wikipedia.org/wiki/Halfwidth_and_fullwidth_forms]
    //               of which FF01 - FF5E fullwidth ASCII of 21 to 7E
    // [IGNORE]    and FF65 - FFDC halfwidth of Katakana and Hangul
    // [IGNORE] FFF0 — FFFF   Specials
    charCode = +charCode; // @perf
    return ((charCode >= 0x2E80 && charCode <= 0xD7AF)
        || (charCode >= 0xF900 && charCode <= 0xFAFF)
        || (charCode >= 0xFF01 && charCode <= 0xFF5E));
}
/**
 * A fast function (therefore imprecise) to check if code points are emojis.
 * Generated using https://github.com/alexandrudima/unicode-utils/blob/master/generate-emoji-test.js
 */
function isEmojiImprecise(x) {
    return ((x >= 0x1F1E6 && x <= 0x1F1FF) || (x >= 9728 && x <= 10175) || (x >= 127744 && x <= 128591)
        || (x >= 128640 && x <= 128764) || (x >= 128992 && x <= 129003) || (x >= 129280 && x <= 129535)
        || (x >= 129648 && x <= 129651) || (x >= 129656 && x <= 129666) || (x >= 129680 && x <= 129685));
}
// -- UTF-8 BOM
var UTF8_BOM_CHARACTER = String.fromCharCode(65279 /* UTF8_BOM */);
function startsWithUTF8BOM(str) {
    return !!(str && str.length > 0 && str.charCodeAt(0) === 65279 /* UTF8_BOM */);
}
function safeBtoa(str) {
    return btoa(encodeURIComponent(str)); // we use encodeURIComponent because btoa fails for non Latin 1 values
}
function repeat(s, count) {
    var result = '';
    for (var i = 0; i < count; i++) {
        result += s;
    }
    return result;
}
function containsUppercaseCharacter(target, ignoreEscapedChars) {
    if (ignoreEscapedChars === void 0) { ignoreEscapedChars = false; }
    if (!target) {
        return false;
    }
    if (ignoreEscapedChars) {
        target = target.replace(/\\./g, '');
    }
    return target.toLowerCase() !== target;
}
/**
 * Produces 'a'-'z', followed by 'A'-'Z'... followed by 'a'-'z', etc.
 */
function singleLetterHash(n) {
    var LETTERS_CNT = (90 /* Z */ - 65 /* A */ + 1);
    n = n % (2 * LETTERS_CNT);
    if (n < LETTERS_CNT) {
        return String.fromCharCode(97 /* a */ + n);
    }
    return String.fromCharCode(65 /* A */ + n - LETTERS_CNT);
}
//#region Unicode Grapheme Break
function getGraphemeBreakType(codePoint) {
    var graphemeBreakTree = GraphemeBreakTree.getInstance();
    return graphemeBreakTree.getGraphemeBreakType(codePoint);
}
function breakBetweenGraphemeBreakType(breakTypeA, breakTypeB) {
    // http://www.unicode.org/reports/tr29/#Grapheme_Cluster_Boundary_Rules
    // !!! Let's make the common case a bit faster
    if (breakTypeA === 0 /* Other */) {
        // see https://www.unicode.org/Public/13.0.0/ucd/auxiliary/GraphemeBreakTest-13.0.0d10.html#table
        return (breakTypeB !== 5 /* Extend */ && breakTypeB !== 7 /* SpacingMark */);
    }
    // Do not break between a CR and LF. Otherwise, break before and after controls.
    // GB3                                        CR × LF
    // GB4                       (Control | CR | LF) ÷
    // GB5                                           ÷ (Control | CR | LF)
    if (breakTypeA === 2 /* CR */) {
        if (breakTypeB === 3 /* LF */) {
            return false; // GB3
        }
    }
    if (breakTypeA === 4 /* Control */ || breakTypeA === 2 /* CR */ || breakTypeA === 3 /* LF */) {
        return true; // GB4
    }
    if (breakTypeB === 4 /* Control */ || breakTypeB === 2 /* CR */ || breakTypeB === 3 /* LF */) {
        return true; // GB5
    }
    // Do not break Hangul syllable sequences.
    // GB6                                         L × (L | V | LV | LVT)
    // GB7                                  (LV | V) × (V | T)
    // GB8                                 (LVT | T) × T
    if (breakTypeA === 8 /* L */) {
        if (breakTypeB === 8 /* L */ || breakTypeB === 9 /* V */ || breakTypeB === 11 /* LV */ || breakTypeB === 12 /* LVT */) {
            return false; // GB6
        }
    }
    if (breakTypeA === 11 /* LV */ || breakTypeA === 9 /* V */) {
        if (breakTypeB === 9 /* V */ || breakTypeB === 10 /* T */) {
            return false; // GB7
        }
    }
    if (breakTypeA === 12 /* LVT */ || breakTypeA === 10 /* T */) {
        if (breakTypeB === 10 /* T */) {
            return false; // GB8
        }
    }
    // Do not break before extending characters or ZWJ.
    // GB9                                           × (Extend | ZWJ)
    if (breakTypeB === 5 /* Extend */ || breakTypeB === 13 /* ZWJ */) {
        return false; // GB9
    }
    // The GB9a and GB9b rules only apply to extended grapheme clusters:
    // Do not break before SpacingMarks, or after Prepend characters.
    // GB9a                                          × SpacingMark
    // GB9b                                  Prepend ×
    if (breakTypeB === 7 /* SpacingMark */) {
        return false; // GB9a
    }
    if (breakTypeA === 1 /* Prepend */) {
        return false; // GB9b
    }
    // Do not break within emoji modifier sequences or emoji zwj sequences.
    // GB11    \p{Extended_Pictographic} Extend* ZWJ × \p{Extended_Pictographic}
    if (breakTypeA === 13 /* ZWJ */ && breakTypeB === 14 /* Extended_Pictographic */) {
        // Note: we are not implementing the rule entirely here to avoid introducing states
        return false; // GB11
    }
    // GB12                          sot (RI RI)* RI × RI
    // GB13                        [^RI] (RI RI)* RI × RI
    if (breakTypeA === 6 /* Regional_Indicator */ && breakTypeB === 6 /* Regional_Indicator */) {
        // Note: we are not implementing the rule entirely here to avoid introducing states
        return false; // GB12 & GB13
    }
    // GB999                                     Any ÷ Any
    return true;
}
var GraphemeBreakTree = /** @class */ (function () {
    function GraphemeBreakTree() {
        this._data = getGraphemeBreakRawData();
    }
    GraphemeBreakTree.getInstance = function () {
        if (!GraphemeBreakTree._INSTANCE) {
            GraphemeBreakTree._INSTANCE = new GraphemeBreakTree();
        }
        return GraphemeBreakTree._INSTANCE;
    };
    GraphemeBreakTree.prototype.getGraphemeBreakType = function (codePoint) {
        // !!! Let's make 7bit ASCII a bit faster: 0..31
        if (codePoint < 32) {
            if (codePoint === 10 /* LineFeed */) {
                return 3 /* LF */;
            }
            if (codePoint === 13 /* CarriageReturn */) {
                return 2 /* CR */;
            }
            return 4 /* Control */;
        }
        // !!! Let's make 7bit ASCII a bit faster: 32..126
        if (codePoint < 127) {
            return 0 /* Other */;
        }
        var data = this._data;
        var nodeCount = data.length / 3;
        var nodeIndex = 1;
        while (nodeIndex <= nodeCount) {
            if (codePoint < data[3 * nodeIndex]) {
                // go left
                nodeIndex = 2 * nodeIndex;
            }
            else if (codePoint > data[3 * nodeIndex + 1]) {
                // go right
                nodeIndex = 2 * nodeIndex + 1;
            }
            else {
                // hit
                return data[3 * nodeIndex + 2];
            }
        }
        return 0 /* Other */;
    };
    GraphemeBreakTree._INSTANCE = null;
    return GraphemeBreakTree;
}());
function getGraphemeBreakRawData() {
    // generated using https://github.com/alexandrudima/unicode-utils/blob/master/generate-grapheme-break.js
    return JSON.parse('[0,0,0,51592,51592,11,44424,44424,11,72251,72254,5,7150,7150,7,48008,48008,11,55176,55176,11,128420,128420,14,3276,3277,5,9979,9980,14,46216,46216,11,49800,49800,11,53384,53384,11,70726,70726,5,122915,122916,5,129320,129327,14,2558,2558,5,5906,5908,5,9762,9763,14,43360,43388,8,45320,45320,11,47112,47112,11,48904,48904,11,50696,50696,11,52488,52488,11,54280,54280,11,70082,70083,1,71350,71350,7,73111,73111,5,127892,127893,14,128726,128727,14,129473,129474,14,2027,2035,5,2901,2902,5,3784,3789,5,6754,6754,5,8418,8420,5,9877,9877,14,11088,11088,14,44008,44008,5,44872,44872,11,45768,45768,11,46664,46664,11,47560,47560,11,48456,48456,11,49352,49352,11,50248,50248,11,51144,51144,11,52040,52040,11,52936,52936,11,53832,53832,11,54728,54728,11,69811,69814,5,70459,70460,5,71096,71099,7,71998,71998,5,72874,72880,5,119149,119149,7,127374,127374,14,128335,128335,14,128482,128482,14,128765,128767,14,129399,129400,14,129680,129685,14,1476,1477,5,2377,2380,7,2759,2760,5,3137,3140,7,3458,3459,7,4153,4154,5,6432,6434,5,6978,6978,5,7675,7679,5,9723,9726,14,9823,9823,14,9919,9923,14,10035,10036,14,42736,42737,5,43596,43596,5,44200,44200,11,44648,44648,11,45096,45096,11,45544,45544,11,45992,45992,11,46440,46440,11,46888,46888,11,47336,47336,11,47784,47784,11,48232,48232,11,48680,48680,11,49128,49128,11,49576,49576,11,50024,50024,11,50472,50472,11,50920,50920,11,51368,51368,11,51816,51816,11,52264,52264,11,52712,52712,11,53160,53160,11,53608,53608,11,54056,54056,11,54504,54504,11,54952,54952,11,68108,68111,5,69933,69940,5,70197,70197,7,70498,70499,7,70845,70845,5,71229,71229,5,71727,71735,5,72154,72155,5,72344,72345,5,73023,73029,5,94095,94098,5,121403,121452,5,126981,127182,14,127538,127546,14,127990,127990,14,128391,128391,14,128445,128449,14,128500,128505,14,128752,128752,14,129160,129167,14,129356,129356,14,129432,129442,14,129648,129651,14,129751,131069,14,173,173,4,1757,1757,1,2274,2274,1,2494,2494,5,2641,2641,5,2876,2876,5,3014,3016,7,3262,3262,7,3393,3396,5,3570,3571,7,3968,3972,5,4228,4228,7,6086,6086,5,6679,6680,5,6912,6915,5,7080,7081,5,7380,7392,5,8252,8252,14,9096,9096,14,9748,9749,14,9784,9786,14,9833,9850,14,9890,9894,14,9938,9938,14,9999,9999,14,10085,10087,14,12349,12349,14,43136,43137,7,43454,43456,7,43755,43755,7,44088,44088,11,44312,44312,11,44536,44536,11,44760,44760,11,44984,44984,11,45208,45208,11,45432,45432,11,45656,45656,11,45880,45880,11,46104,46104,11,46328,46328,11,46552,46552,11,46776,46776,11,47000,47000,11,47224,47224,11,47448,47448,11,47672,47672,11,47896,47896,11,48120,48120,11,48344,48344,11,48568,48568,11,48792,48792,11,49016,49016,11,49240,49240,11,49464,49464,11,49688,49688,11,49912,49912,11,50136,50136,11,50360,50360,11,50584,50584,11,50808,50808,11,51032,51032,11,51256,51256,11,51480,51480,11,51704,51704,11,51928,51928,11,52152,52152,11,52376,52376,11,52600,52600,11,52824,52824,11,53048,53048,11,53272,53272,11,53496,53496,11,53720,53720,11,53944,53944,11,54168,54168,11,54392,54392,11,54616,54616,11,54840,54840,11,55064,55064,11,65438,65439,5,69633,69633,5,69837,69837,1,70018,70018,7,70188,70190,7,70368,70370,7,70465,70468,7,70712,70719,5,70835,70840,5,70850,70851,5,71132,71133,5,71340,71340,7,71458,71461,5,71985,71989,7,72002,72002,7,72193,72202,5,72281,72283,5,72766,72766,7,72885,72886,5,73104,73105,5,92912,92916,5,113824,113827,4,119173,119179,5,121505,121519,5,125136,125142,5,127279,127279,14,127489,127490,14,127570,127743,14,127900,127901,14,128254,128254,14,128369,128370,14,128400,128400,14,128425,128432,14,128468,128475,14,128489,128494,14,128715,128720,14,128745,128745,14,128759,128760,14,129004,129023,14,129296,129304,14,129340,129342,14,129388,129392,14,129404,129407,14,129454,129455,14,129485,129487,14,129659,129663,14,129719,129727,14,917536,917631,5,13,13,2,1160,1161,5,1564,1564,4,1807,1807,1,2085,2087,5,2363,2363,7,2402,2403,5,2507,2508,7,2622,2624,7,2691,2691,7,2786,2787,5,2881,2884,5,3006,3006,5,3072,3072,5,3170,3171,5,3267,3268,7,3330,3331,7,3406,3406,1,3538,3540,5,3655,3662,5,3897,3897,5,4038,4038,5,4184,4185,5,4352,4447,8,6068,6069,5,6155,6157,5,6448,6449,7,6742,6742,5,6783,6783,5,6966,6970,5,7042,7042,7,7143,7143,7,7212,7219,5,7412,7412,5,8206,8207,4,8294,8303,4,8596,8601,14,9410,9410,14,9742,9742,14,9757,9757,14,9770,9770,14,9794,9794,14,9828,9828,14,9855,9855,14,9882,9882,14,9900,9903,14,9929,9933,14,9963,9967,14,9987,9988,14,10006,10006,14,10062,10062,14,10175,10175,14,11744,11775,5,42607,42607,5,43043,43044,7,43263,43263,5,43444,43445,7,43569,43570,5,43698,43700,5,43766,43766,5,44032,44032,11,44144,44144,11,44256,44256,11,44368,44368,11,44480,44480,11,44592,44592,11,44704,44704,11,44816,44816,11,44928,44928,11,45040,45040,11,45152,45152,11,45264,45264,11,45376,45376,11,45488,45488,11,45600,45600,11,45712,45712,11,45824,45824,11,45936,45936,11,46048,46048,11,46160,46160,11,46272,46272,11,46384,46384,11,46496,46496,11,46608,46608,11,46720,46720,11,46832,46832,11,46944,46944,11,47056,47056,11,47168,47168,11,47280,47280,11,47392,47392,11,47504,47504,11,47616,47616,11,47728,47728,11,47840,47840,11,47952,47952,11,48064,48064,11,48176,48176,11,48288,48288,11,48400,48400,11,48512,48512,11,48624,48624,11,48736,48736,11,48848,48848,11,48960,48960,11,49072,49072,11,49184,49184,11,49296,49296,11,49408,49408,11,49520,49520,11,49632,49632,11,49744,49744,11,49856,49856,11,49968,49968,11,50080,50080,11,50192,50192,11,50304,50304,11,50416,50416,11,50528,50528,11,50640,50640,11,50752,50752,11,50864,50864,11,50976,50976,11,51088,51088,11,51200,51200,11,51312,51312,11,51424,51424,11,51536,51536,11,51648,51648,11,51760,51760,11,51872,51872,11,51984,51984,11,52096,52096,11,52208,52208,11,52320,52320,11,52432,52432,11,52544,52544,11,52656,52656,11,52768,52768,11,52880,52880,11,52992,52992,11,53104,53104,11,53216,53216,11,53328,53328,11,53440,53440,11,53552,53552,11,53664,53664,11,53776,53776,11,53888,53888,11,54000,54000,11,54112,54112,11,54224,54224,11,54336,54336,11,54448,54448,11,54560,54560,11,54672,54672,11,54784,54784,11,54896,54896,11,55008,55008,11,55120,55120,11,64286,64286,5,66272,66272,5,68900,68903,5,69762,69762,7,69817,69818,5,69927,69931,5,70003,70003,5,70070,70078,5,70094,70094,7,70194,70195,7,70206,70206,5,70400,70401,5,70463,70463,7,70475,70477,7,70512,70516,5,70722,70724,5,70832,70832,5,70842,70842,5,70847,70848,5,71088,71089,7,71102,71102,7,71219,71226,5,71231,71232,5,71342,71343,7,71453,71455,5,71463,71467,5,71737,71738,5,71995,71996,5,72000,72000,7,72145,72147,7,72160,72160,5,72249,72249,7,72273,72278,5,72330,72342,5,72752,72758,5,72850,72871,5,72882,72883,5,73018,73018,5,73031,73031,5,73109,73109,5,73461,73462,7,94031,94031,5,94192,94193,7,119142,119142,7,119155,119162,4,119362,119364,5,121476,121476,5,122888,122904,5,123184,123190,5,126976,126979,14,127184,127231,14,127344,127345,14,127405,127461,14,127514,127514,14,127561,127567,14,127778,127779,14,127896,127896,14,127985,127986,14,127995,127999,5,128326,128328,14,128360,128366,14,128378,128378,14,128394,128397,14,128405,128406,14,128422,128423,14,128435,128443,14,128453,128464,14,128479,128480,14,128484,128487,14,128496,128498,14,128640,128709,14,128723,128724,14,128736,128741,14,128747,128748,14,128755,128755,14,128762,128762,14,128981,128991,14,129096,129103,14,129292,129292,14,129311,129311,14,129329,129330,14,129344,129349,14,129360,129374,14,129394,129394,14,129402,129402,14,129413,129425,14,129445,129450,14,129466,129471,14,129483,129483,14,129511,129535,14,129653,129655,14,129667,129670,14,129705,129711,14,129731,129743,14,917505,917505,4,917760,917999,5,10,10,3,127,159,4,768,879,5,1471,1471,5,1536,1541,1,1648,1648,5,1767,1768,5,1840,1866,5,2070,2073,5,2137,2139,5,2307,2307,7,2366,2368,7,2382,2383,7,2434,2435,7,2497,2500,5,2519,2519,5,2563,2563,7,2631,2632,5,2677,2677,5,2750,2752,7,2763,2764,7,2817,2817,5,2879,2879,5,2891,2892,7,2914,2915,5,3008,3008,5,3021,3021,5,3076,3076,5,3146,3149,5,3202,3203,7,3264,3265,7,3271,3272,7,3298,3299,5,3390,3390,5,3402,3404,7,3426,3427,5,3535,3535,5,3544,3550,7,3635,3635,7,3763,3763,7,3893,3893,5,3953,3966,5,3981,3991,5,4145,4145,7,4157,4158,5,4209,4212,5,4237,4237,5,4520,4607,10,5970,5971,5,6071,6077,5,6089,6099,5,6277,6278,5,6439,6440,5,6451,6456,7,6683,6683,5,6744,6750,5,6765,6770,7,6846,6846,5,6964,6964,5,6972,6972,5,7019,7027,5,7074,7077,5,7083,7085,5,7146,7148,7,7154,7155,7,7222,7223,5,7394,7400,5,7416,7417,5,8204,8204,5,8233,8233,4,8288,8292,4,8413,8416,5,8482,8482,14,8986,8987,14,9193,9203,14,9654,9654,14,9733,9733,14,9745,9745,14,9752,9752,14,9760,9760,14,9766,9766,14,9774,9775,14,9792,9792,14,9800,9811,14,9825,9826,14,9831,9831,14,9852,9853,14,9872,9873,14,9880,9880,14,9885,9887,14,9896,9897,14,9906,9916,14,9926,9927,14,9936,9936,14,9941,9960,14,9974,9974,14,9982,9985,14,9992,9997,14,10002,10002,14,10017,10017,14,10055,10055,14,10071,10071,14,10145,10145,14,11013,11015,14,11503,11505,5,12334,12335,5,12951,12951,14,42612,42621,5,43014,43014,5,43047,43047,7,43204,43205,5,43335,43345,5,43395,43395,7,43450,43451,7,43561,43566,5,43573,43574,5,43644,43644,5,43710,43711,5,43758,43759,7,44005,44005,5,44012,44012,7,44060,44060,11,44116,44116,11,44172,44172,11,44228,44228,11,44284,44284,11,44340,44340,11,44396,44396,11,44452,44452,11,44508,44508,11,44564,44564,11,44620,44620,11,44676,44676,11,44732,44732,11,44788,44788,11,44844,44844,11,44900,44900,11,44956,44956,11,45012,45012,11,45068,45068,11,45124,45124,11,45180,45180,11,45236,45236,11,45292,45292,11,45348,45348,11,45404,45404,11,45460,45460,11,45516,45516,11,45572,45572,11,45628,45628,11,45684,45684,11,45740,45740,11,45796,45796,11,45852,45852,11,45908,45908,11,45964,45964,11,46020,46020,11,46076,46076,11,46132,46132,11,46188,46188,11,46244,46244,11,46300,46300,11,46356,46356,11,46412,46412,11,46468,46468,11,46524,46524,11,46580,46580,11,46636,46636,11,46692,46692,11,46748,46748,11,46804,46804,11,46860,46860,11,46916,46916,11,46972,46972,11,47028,47028,11,47084,47084,11,47140,47140,11,47196,47196,11,47252,47252,11,47308,47308,11,47364,47364,11,47420,47420,11,47476,47476,11,47532,47532,11,47588,47588,11,47644,47644,11,47700,47700,11,47756,47756,11,47812,47812,11,47868,47868,11,47924,47924,11,47980,47980,11,48036,48036,11,48092,48092,11,48148,48148,11,48204,48204,11,48260,48260,11,48316,48316,11,48372,48372,11,48428,48428,11,48484,48484,11,48540,48540,11,48596,48596,11,48652,48652,11,48708,48708,11,48764,48764,11,48820,48820,11,48876,48876,11,48932,48932,11,48988,48988,11,49044,49044,11,49100,49100,11,49156,49156,11,49212,49212,11,49268,49268,11,49324,49324,11,49380,49380,11,49436,49436,11,49492,49492,11,49548,49548,11,49604,49604,11,49660,49660,11,49716,49716,11,49772,49772,11,49828,49828,11,49884,49884,11,49940,49940,11,49996,49996,11,50052,50052,11,50108,50108,11,50164,50164,11,50220,50220,11,50276,50276,11,50332,50332,11,50388,50388,11,50444,50444,11,50500,50500,11,50556,50556,11,50612,50612,11,50668,50668,11,50724,50724,11,50780,50780,11,50836,50836,11,50892,50892,11,50948,50948,11,51004,51004,11,51060,51060,11,51116,51116,11,51172,51172,11,51228,51228,11,51284,51284,11,51340,51340,11,51396,51396,11,51452,51452,11,51508,51508,11,51564,51564,11,51620,51620,11,51676,51676,11,51732,51732,11,51788,51788,11,51844,51844,11,51900,51900,11,51956,51956,11,52012,52012,11,52068,52068,11,52124,52124,11,52180,52180,11,52236,52236,11,52292,52292,11,52348,52348,11,52404,52404,11,52460,52460,11,52516,52516,11,52572,52572,11,52628,52628,11,52684,52684,11,52740,52740,11,52796,52796,11,52852,52852,11,52908,52908,11,52964,52964,11,53020,53020,11,53076,53076,11,53132,53132,11,53188,53188,11,53244,53244,11,53300,53300,11,53356,53356,11,53412,53412,11,53468,53468,11,53524,53524,11,53580,53580,11,53636,53636,11,53692,53692,11,53748,53748,11,53804,53804,11,53860,53860,11,53916,53916,11,53972,53972,11,54028,54028,11,54084,54084,11,54140,54140,11,54196,54196,11,54252,54252,11,54308,54308,11,54364,54364,11,54420,54420,11,54476,54476,11,54532,54532,11,54588,54588,11,54644,54644,11,54700,54700,11,54756,54756,11,54812,54812,11,54868,54868,11,54924,54924,11,54980,54980,11,55036,55036,11,55092,55092,11,55148,55148,11,55216,55238,9,65056,65071,5,65529,65531,4,68097,68099,5,68159,68159,5,69446,69456,5,69688,69702,5,69808,69810,7,69815,69816,7,69821,69821,1,69888,69890,5,69932,69932,7,69957,69958,7,70016,70017,5,70067,70069,7,70079,70080,7,70089,70092,5,70095,70095,5,70191,70193,5,70196,70196,5,70198,70199,5,70367,70367,5,70371,70378,5,70402,70403,7,70462,70462,5,70464,70464,5,70471,70472,7,70487,70487,5,70502,70508,5,70709,70711,7,70720,70721,7,70725,70725,7,70750,70750,5,70833,70834,7,70841,70841,7,70843,70844,7,70846,70846,7,70849,70849,7,71087,71087,5,71090,71093,5,71100,71101,5,71103,71104,5,71216,71218,7,71227,71228,7,71230,71230,7,71339,71339,5,71341,71341,5,71344,71349,5,71351,71351,5,71456,71457,7,71462,71462,7,71724,71726,7,71736,71736,7,71984,71984,5,71991,71992,7,71997,71997,7,71999,71999,1,72001,72001,1,72003,72003,5,72148,72151,5,72156,72159,7,72164,72164,7,72243,72248,5,72250,72250,1,72263,72263,5,72279,72280,7,72324,72329,1,72343,72343,7,72751,72751,7,72760,72765,5,72767,72767,5,72873,72873,7,72881,72881,7,72884,72884,7,73009,73014,5,73020,73021,5,73030,73030,1,73098,73102,7,73107,73108,7,73110,73110,7,73459,73460,5,78896,78904,4,92976,92982,5,94033,94087,7,94180,94180,5,113821,113822,5,119141,119141,5,119143,119145,5,119150,119154,5,119163,119170,5,119210,119213,5,121344,121398,5,121461,121461,5,121499,121503,5,122880,122886,5,122907,122913,5,122918,122922,5,123628,123631,5,125252,125258,5,126980,126980,14,127183,127183,14,127245,127247,14,127340,127343,14,127358,127359,14,127377,127386,14,127462,127487,6,127491,127503,14,127535,127535,14,127548,127551,14,127568,127569,14,127744,127777,14,127780,127891,14,127894,127895,14,127897,127899,14,127902,127984,14,127987,127989,14,127991,127994,14,128000,128253,14,128255,128317,14,128329,128334,14,128336,128359,14,128367,128368,14,128371,128377,14,128379,128390,14,128392,128393,14,128398,128399,14,128401,128404,14,128407,128419,14,128421,128421,14,128424,128424,14,128433,128434,14,128444,128444,14,128450,128452,14,128465,128467,14,128476,128478,14,128481,128481,14,128483,128483,14,128488,128488,14,128495,128495,14,128499,128499,14,128506,128591,14,128710,128714,14,128721,128722,14,128725,128725,14,128728,128735,14,128742,128744,14,128746,128746,14,128749,128751,14,128753,128754,14,128756,128758,14,128761,128761,14,128763,128764,14,128884,128895,14,128992,129003,14,129036,129039,14,129114,129119,14,129198,129279,14,129293,129295,14,129305,129310,14,129312,129319,14,129328,129328,14,129331,129338,14,129343,129343,14,129351,129355,14,129357,129359,14,129375,129387,14,129393,129393,14,129395,129398,14,129401,129401,14,129403,129403,14,129408,129412,14,129426,129431,14,129443,129444,14,129451,129453,14,129456,129465,14,129472,129472,14,129475,129482,14,129484,129484,14,129488,129510,14,129536,129647,14,129652,129652,14,129656,129658,14,129664,129666,14,129671,129679,14,129686,129704,14,129712,129718,14,129728,129730,14,129744,129750,14,917504,917504,4,917506,917535,4,917632,917759,4,918000,921599,4,0,9,4,11,12,4,14,31,4,169,169,14,174,174,14,1155,1159,5,1425,1469,5,1473,1474,5,1479,1479,5,1552,1562,5,1611,1631,5,1750,1756,5,1759,1764,5,1770,1773,5,1809,1809,5,1958,1968,5,2045,2045,5,2075,2083,5,2089,2093,5,2259,2273,5,2275,2306,5,2362,2362,5,2364,2364,5,2369,2376,5,2381,2381,5,2385,2391,5,2433,2433,5,2492,2492,5,2495,2496,7,2503,2504,7,2509,2509,5,2530,2531,5,2561,2562,5,2620,2620,5,2625,2626,5,2635,2637,5,2672,2673,5,2689,2690,5,2748,2748,5,2753,2757,5,2761,2761,7,2765,2765,5,2810,2815,5,2818,2819,7,2878,2878,5,2880,2880,7,2887,2888,7,2893,2893,5,2903,2903,5,2946,2946,5,3007,3007,7,3009,3010,7,3018,3020,7,3031,3031,5,3073,3075,7,3134,3136,5,3142,3144,5,3157,3158,5,3201,3201,5,3260,3260,5,3263,3263,5,3266,3266,5,3270,3270,5,3274,3275,7,3285,3286,5,3328,3329,5,3387,3388,5,3391,3392,7,3398,3400,7,3405,3405,5,3415,3415,5,3457,3457,5,3530,3530,5,3536,3537,7,3542,3542,5,3551,3551,5,3633,3633,5,3636,3642,5,3761,3761,5,3764,3772,5,3864,3865,5,3895,3895,5,3902,3903,7,3967,3967,7,3974,3975,5,3993,4028,5,4141,4144,5,4146,4151,5,4155,4156,7,4182,4183,7,4190,4192,5,4226,4226,5,4229,4230,5,4253,4253,5,4448,4519,9,4957,4959,5,5938,5940,5,6002,6003,5,6070,6070,7,6078,6085,7,6087,6088,7,6109,6109,5,6158,6158,4,6313,6313,5,6435,6438,7,6441,6443,7,6450,6450,5,6457,6459,5,6681,6682,7,6741,6741,7,6743,6743,7,6752,6752,5,6757,6764,5,6771,6780,5,6832,6845,5,6847,6848,5,6916,6916,7,6965,6965,5,6971,6971,7,6973,6977,7,6979,6980,7,7040,7041,5,7073,7073,7,7078,7079,7,7082,7082,7,7142,7142,5,7144,7145,5,7149,7149,5,7151,7153,5,7204,7211,7,7220,7221,7,7376,7378,5,7393,7393,7,7405,7405,5,7415,7415,7,7616,7673,5,8203,8203,4,8205,8205,13,8232,8232,4,8234,8238,4,8265,8265,14,8293,8293,4,8400,8412,5,8417,8417,5,8421,8432,5,8505,8505,14,8617,8618,14,9000,9000,14,9167,9167,14,9208,9210,14,9642,9643,14,9664,9664,14,9728,9732,14,9735,9741,14,9743,9744,14,9746,9746,14,9750,9751,14,9753,9756,14,9758,9759,14,9761,9761,14,9764,9765,14,9767,9769,14,9771,9773,14,9776,9783,14,9787,9791,14,9793,9793,14,9795,9799,14,9812,9822,14,9824,9824,14,9827,9827,14,9829,9830,14,9832,9832,14,9851,9851,14,9854,9854,14,9856,9861,14,9874,9876,14,9878,9879,14,9881,9881,14,9883,9884,14,9888,9889,14,9895,9895,14,9898,9899,14,9904,9905,14,9917,9918,14,9924,9925,14,9928,9928,14,9934,9935,14,9937,9937,14,9939,9940,14,9961,9962,14,9968,9973,14,9975,9978,14,9981,9981,14,9986,9986,14,9989,9989,14,9998,9998,14,10000,10001,14,10004,10004,14,10013,10013,14,10024,10024,14,10052,10052,14,10060,10060,14,10067,10069,14,10083,10084,14,10133,10135,14,10160,10160,14,10548,10549,14,11035,11036,14,11093,11093,14,11647,11647,5,12330,12333,5,12336,12336,14,12441,12442,5,12953,12953,14,42608,42610,5,42654,42655,5,43010,43010,5,43019,43019,5,43045,43046,5,43052,43052,5,43188,43203,7,43232,43249,5,43302,43309,5,43346,43347,7,43392,43394,5,43443,43443,5,43446,43449,5,43452,43453,5,43493,43493,5,43567,43568,7,43571,43572,7,43587,43587,5,43597,43597,7,43696,43696,5,43703,43704,5,43713,43713,5,43756,43757,5,43765,43765,7,44003,44004,7,44006,44007,7,44009,44010,7,44013,44013,5,44033,44059,12,44061,44087,12,44089,44115,12,44117,44143,12,44145,44171,12,44173,44199,12,44201,44227,12,44229,44255,12,44257,44283,12,44285,44311,12,44313,44339,12,44341,44367,12,44369,44395,12,44397,44423,12,44425,44451,12,44453,44479,12,44481,44507,12,44509,44535,12,44537,44563,12,44565,44591,12,44593,44619,12,44621,44647,12,44649,44675,12,44677,44703,12,44705,44731,12,44733,44759,12,44761,44787,12,44789,44815,12,44817,44843,12,44845,44871,12,44873,44899,12,44901,44927,12,44929,44955,12,44957,44983,12,44985,45011,12,45013,45039,12,45041,45067,12,45069,45095,12,45097,45123,12,45125,45151,12,45153,45179,12,45181,45207,12,45209,45235,12,45237,45263,12,45265,45291,12,45293,45319,12,45321,45347,12,45349,45375,12,45377,45403,12,45405,45431,12,45433,45459,12,45461,45487,12,45489,45515,12,45517,45543,12,45545,45571,12,45573,45599,12,45601,45627,12,45629,45655,12,45657,45683,12,45685,45711,12,45713,45739,12,45741,45767,12,45769,45795,12,45797,45823,12,45825,45851,12,45853,45879,12,45881,45907,12,45909,45935,12,45937,45963,12,45965,45991,12,45993,46019,12,46021,46047,12,46049,46075,12,46077,46103,12,46105,46131,12,46133,46159,12,46161,46187,12,46189,46215,12,46217,46243,12,46245,46271,12,46273,46299,12,46301,46327,12,46329,46355,12,46357,46383,12,46385,46411,12,46413,46439,12,46441,46467,12,46469,46495,12,46497,46523,12,46525,46551,12,46553,46579,12,46581,46607,12,46609,46635,12,46637,46663,12,46665,46691,12,46693,46719,12,46721,46747,12,46749,46775,12,46777,46803,12,46805,46831,12,46833,46859,12,46861,46887,12,46889,46915,12,46917,46943,12,46945,46971,12,46973,46999,12,47001,47027,12,47029,47055,12,47057,47083,12,47085,47111,12,47113,47139,12,47141,47167,12,47169,47195,12,47197,47223,12,47225,47251,12,47253,47279,12,47281,47307,12,47309,47335,12,47337,47363,12,47365,47391,12,47393,47419,12,47421,47447,12,47449,47475,12,47477,47503,12,47505,47531,12,47533,47559,12,47561,47587,12,47589,47615,12,47617,47643,12,47645,47671,12,47673,47699,12,47701,47727,12,47729,47755,12,47757,47783,12,47785,47811,12,47813,47839,12,47841,47867,12,47869,47895,12,47897,47923,12,47925,47951,12,47953,47979,12,47981,48007,12,48009,48035,12,48037,48063,12,48065,48091,12,48093,48119,12,48121,48147,12,48149,48175,12,48177,48203,12,48205,48231,12,48233,48259,12,48261,48287,12,48289,48315,12,48317,48343,12,48345,48371,12,48373,48399,12,48401,48427,12,48429,48455,12,48457,48483,12,48485,48511,12,48513,48539,12,48541,48567,12,48569,48595,12,48597,48623,12,48625,48651,12,48653,48679,12,48681,48707,12,48709,48735,12,48737,48763,12,48765,48791,12,48793,48819,12,48821,48847,12,48849,48875,12,48877,48903,12,48905,48931,12,48933,48959,12,48961,48987,12,48989,49015,12,49017,49043,12,49045,49071,12,49073,49099,12,49101,49127,12,49129,49155,12,49157,49183,12,49185,49211,12,49213,49239,12,49241,49267,12,49269,49295,12,49297,49323,12,49325,49351,12,49353,49379,12,49381,49407,12,49409,49435,12,49437,49463,12,49465,49491,12,49493,49519,12,49521,49547,12,49549,49575,12,49577,49603,12,49605,49631,12,49633,49659,12,49661,49687,12,49689,49715,12,49717,49743,12,49745,49771,12,49773,49799,12,49801,49827,12,49829,49855,12,49857,49883,12,49885,49911,12,49913,49939,12,49941,49967,12,49969,49995,12,49997,50023,12,50025,50051,12,50053,50079,12,50081,50107,12,50109,50135,12,50137,50163,12,50165,50191,12,50193,50219,12,50221,50247,12,50249,50275,12,50277,50303,12,50305,50331,12,50333,50359,12,50361,50387,12,50389,50415,12,50417,50443,12,50445,50471,12,50473,50499,12,50501,50527,12,50529,50555,12,50557,50583,12,50585,50611,12,50613,50639,12,50641,50667,12,50669,50695,12,50697,50723,12,50725,50751,12,50753,50779,12,50781,50807,12,50809,50835,12,50837,50863,12,50865,50891,12,50893,50919,12,50921,50947,12,50949,50975,12,50977,51003,12,51005,51031,12,51033,51059,12,51061,51087,12,51089,51115,12,51117,51143,12,51145,51171,12,51173,51199,12,51201,51227,12,51229,51255,12,51257,51283,12,51285,51311,12,51313,51339,12,51341,51367,12,51369,51395,12,51397,51423,12,51425,51451,12,51453,51479,12,51481,51507,12,51509,51535,12,51537,51563,12,51565,51591,12,51593,51619,12,51621,51647,12,51649,51675,12,51677,51703,12,51705,51731,12,51733,51759,12,51761,51787,12,51789,51815,12,51817,51843,12,51845,51871,12,51873,51899,12,51901,51927,12,51929,51955,12,51957,51983,12,51985,52011,12,52013,52039,12,52041,52067,12,52069,52095,12,52097,52123,12,52125,52151,12,52153,52179,12,52181,52207,12,52209,52235,12,52237,52263,12,52265,52291,12,52293,52319,12,52321,52347,12,52349,52375,12,52377,52403,12,52405,52431,12,52433,52459,12,52461,52487,12,52489,52515,12,52517,52543,12,52545,52571,12,52573,52599,12,52601,52627,12,52629,52655,12,52657,52683,12,52685,52711,12,52713,52739,12,52741,52767,12,52769,52795,12,52797,52823,12,52825,52851,12,52853,52879,12,52881,52907,12,52909,52935,12,52937,52963,12,52965,52991,12,52993,53019,12,53021,53047,12,53049,53075,12,53077,53103,12,53105,53131,12,53133,53159,12,53161,53187,12,53189,53215,12,53217,53243,12,53245,53271,12,53273,53299,12,53301,53327,12,53329,53355,12,53357,53383,12,53385,53411,12,53413,53439,12,53441,53467,12,53469,53495,12,53497,53523,12,53525,53551,12,53553,53579,12,53581,53607,12,53609,53635,12,53637,53663,12,53665,53691,12,53693,53719,12,53721,53747,12,53749,53775,12,53777,53803,12,53805,53831,12,53833,53859,12,53861,53887,12,53889,53915,12,53917,53943,12,53945,53971,12,53973,53999,12,54001,54027,12,54029,54055,12,54057,54083,12,54085,54111,12,54113,54139,12,54141,54167,12,54169,54195,12,54197,54223,12,54225,54251,12,54253,54279,12,54281,54307,12,54309,54335,12,54337,54363,12,54365,54391,12,54393,54419,12,54421,54447,12,54449,54475,12,54477,54503,12,54505,54531,12,54533,54559,12,54561,54587,12,54589,54615,12,54617,54643,12,54645,54671,12,54673,54699,12,54701,54727,12,54729,54755,12,54757,54783,12,54785,54811,12,54813,54839,12,54841,54867,12,54869,54895,12,54897,54923,12,54925,54951,12,54953,54979,12,54981,55007,12,55009,55035,12,55037,55063,12,55065,55091,12,55093,55119,12,55121,55147,12,55149,55175,12,55177,55203,12,55243,55291,10,65024,65039,5,65279,65279,4,65520,65528,4,66045,66045,5,66422,66426,5,68101,68102,5,68152,68154,5,68325,68326,5,69291,69292,5,69632,69632,7,69634,69634,7,69759,69761,5]');
}
//#endregion


/***/ }),
/* 5 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (immutable) */ __webpack_exports__["a"] = localize;
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
function _format(message, args) {
    var result;
    if (args.length === 0) {
        result = message;
    }
    else {
        result = message.replace(/\{(\d+)\}/g, function (match, rest) {
            var index = rest[0];
            return typeof args[index] !== 'undefined' ? args[index] : match;
        });
    }
    return result;
}
function localize(data, message) {
    var args = [];
    for (var _i = 2; _i < arguments.length; _i++) {
        args[_i - 2] = arguments[_i];
    }
    return _format(message, args);
}


/***/ }),
/* 6 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var isOldIE = function isOldIE() {
  var memo;
  return function memorize() {
    if (typeof memo === 'undefined') {
      // Test for IE <= 9 as proposed by Browserhacks
      // @see http://browserhacks.com/#hack-e71d8692f65334173fee715c222cb805
      // Tests for existence of standard globals is to allow style-loader
      // to operate correctly into non-standard environments
      // @see https://github.com/webpack-contrib/style-loader/issues/177
      memo = Boolean(window && document && document.all && !window.atob);
    }

    return memo;
  };
}();

var getTarget = function getTarget() {
  var memo = {};
  return function memorize(target) {
    if (typeof memo[target] === 'undefined') {
      var styleTarget = document.querySelector(target); // Special case to return head of iframe instead of iframe itself

      if (window.HTMLIFrameElement && styleTarget instanceof window.HTMLIFrameElement) {
        try {
          // This will throw an exception if access to iframe is blocked
          // due to cross-origin restrictions
          styleTarget = styleTarget.contentDocument.head;
        } catch (e) {
          // istanbul ignore next
          styleTarget = null;
        }
      }

      memo[target] = styleTarget;
    }

    return memo[target];
  };
}();

var stylesInDom = [];

function getIndexByIdentifier(identifier) {
  var result = -1;

  for (var i = 0; i < stylesInDom.length; i++) {
    if (stylesInDom[i].identifier === identifier) {
      result = i;
      break;
    }
  }

  return result;
}

function modulesToDom(list, options) {
  var idCountMap = {};
  var identifiers = [];

  for (var i = 0; i < list.length; i++) {
    var item = list[i];
    var id = options.base ? item[0] + options.base : item[0];
    var count = idCountMap[id] || 0;
    var identifier = "".concat(id, " ").concat(count);
    idCountMap[id] = count + 1;
    var index = getIndexByIdentifier(identifier);
    var obj = {
      css: item[1],
      media: item[2],
      sourceMap: item[3]
    };

    if (index !== -1) {
      stylesInDom[index].references++;
      stylesInDom[index].updater(obj);
    } else {
      stylesInDom.push({
        identifier: identifier,
        updater: addStyle(obj, options),
        references: 1
      });
    }

    identifiers.push(identifier);
  }

  return identifiers;
}

function insertStyleElement(options) {
  var style = document.createElement('style');
  var attributes = options.attributes || {};

  if (typeof attributes.nonce === 'undefined') {
    var nonce =  true ? __webpack_require__.nc : null;

    if (nonce) {
      attributes.nonce = nonce;
    }
  }

  Object.keys(attributes).forEach(function (key) {
    style.setAttribute(key, attributes[key]);
  });

  if (typeof options.insert === 'function') {
    options.insert(style);
  } else {
    var target = getTarget(options.insert || 'head');

    if (!target) {
      throw new Error("Couldn't find a style target. This probably means that the value for the 'insert' parameter is invalid.");
    }

    target.appendChild(style);
  }

  return style;
}

function removeStyleElement(style) {
  // istanbul ignore if
  if (style.parentNode === null) {
    return false;
  }

  style.parentNode.removeChild(style);
}
/* istanbul ignore next  */


var replaceText = function replaceText() {
  var textStore = [];
  return function replace(index, replacement) {
    textStore[index] = replacement;
    return textStore.filter(Boolean).join('\n');
  };
}();

function applyToSingletonTag(style, index, remove, obj) {
  var css = remove ? '' : obj.media ? "@media ".concat(obj.media, " {").concat(obj.css, "}") : obj.css; // For old IE

  /* istanbul ignore if  */

  if (style.styleSheet) {
    style.styleSheet.cssText = replaceText(index, css);
  } else {
    var cssNode = document.createTextNode(css);
    var childNodes = style.childNodes;

    if (childNodes[index]) {
      style.removeChild(childNodes[index]);
    }

    if (childNodes.length) {
      style.insertBefore(cssNode, childNodes[index]);
    } else {
      style.appendChild(cssNode);
    }
  }
}

function applyToTag(style, options, obj) {
  var css = obj.css;
  var media = obj.media;
  var sourceMap = obj.sourceMap;

  if (media) {
    style.setAttribute('media', media);
  } else {
    style.removeAttribute('media');
  }

  if (sourceMap && btoa) {
    css += "\n/*# sourceMappingURL=data:application/json;base64,".concat(btoa(unescape(encodeURIComponent(JSON.stringify(sourceMap)))), " */");
  } // For old IE

  /* istanbul ignore if  */


  if (style.styleSheet) {
    style.styleSheet.cssText = css;
  } else {
    while (style.firstChild) {
      style.removeChild(style.firstChild);
    }

    style.appendChild(document.createTextNode(css));
  }
}

var singleton = null;
var singletonCounter = 0;

function addStyle(obj, options) {
  var style;
  var update;
  var remove;

  if (options.singleton) {
    var styleIndex = singletonCounter++;
    style = singleton || (singleton = insertStyleElement(options));
    update = applyToSingletonTag.bind(null, style, styleIndex, false);
    remove = applyToSingletonTag.bind(null, style, styleIndex, true);
  } else {
    style = insertStyleElement(options);
    update = applyToTag.bind(null, style, options);

    remove = function remove() {
      removeStyleElement(style);
    };
  }

  update(obj);
  return function updateStyle(newObj) {
    if (newObj) {
      if (newObj.css === obj.css && newObj.media === obj.media && newObj.sourceMap === obj.sourceMap) {
        return;
      }

      update(obj = newObj);
    } else {
      remove();
    }
  };
}

module.exports = function (list, options) {
  options = options || {}; // Force single-tag solution on IE6-9, which has a hard limit on the # of <style>
  // tags it will allow on a page

  if (!options.singleton && typeof options.singleton !== 'boolean') {
    options.singleton = isOldIE();
  }

  list = list || [];
  var lastIdentifiers = modulesToDom(list, options);
  return function update(newList) {
    newList = newList || [];

    if (Object.prototype.toString.call(newList) !== '[object Array]') {
      return;
    }

    for (var i = 0; i < lastIdentifiers.length; i++) {
      var identifier = lastIdentifiers[i];
      var index = getIndexByIdentifier(identifier);
      stylesInDom[index].references--;
    }

    var newLastIdentifiers = modulesToDom(newList, options);

    for (var _i = 0; _i < lastIdentifiers.length; _i++) {
      var _identifier = lastIdentifiers[_i];

      var _index = getIndexByIdentifier(_identifier);

      if (stylesInDom[_index].references === 0) {
        stylesInDom[_index].updater();

        stylesInDom.splice(_index, 1);
      }
    }

    lastIdentifiers = newLastIdentifiers;
  };
};

/***/ }),
/* 7 */
/***/ (function(module, exports, __webpack_require__) {

"use strict";


/*
  MIT License http://www.opensource.org/licenses/mit-license.php
  Author Tobias Koppers @sokra
*/
// css base code, injected by the css-loader
// eslint-disable-next-line func-names
module.exports = function (useSourceMap) {
  var list = []; // return the list of modules as css string

  list.toString = function toString() {
    return this.map(function (item) {
      var content = cssWithMappingToString(item, useSourceMap);

      if (item[2]) {
        return "@media ".concat(item[2], " {").concat(content, "}");
      }

      return content;
    }).join('');
  }; // import a list of modules into the list
  // eslint-disable-next-line func-names


  list.i = function (modules, mediaQuery, dedupe) {
    if (typeof modules === 'string') {
      // eslint-disable-next-line no-param-reassign
      modules = [[null, modules, '']];
    }

    var alreadyImportedModules = {};

    if (dedupe) {
      for (var i = 0; i < this.length; i++) {
        // eslint-disable-next-line prefer-destructuring
        var id = this[i][0];

        if (id != null) {
          alreadyImportedModules[id] = true;
        }
      }
    }

    for (var _i = 0; _i < modules.length; _i++) {
      var item = [].concat(modules[_i]);

      if (dedupe && alreadyImportedModules[item[0]]) {
        // eslint-disable-next-line no-continue
        continue;
      }

      if (mediaQuery) {
        if (!item[2]) {
          item[2] = mediaQuery;
        } else {
          item[2] = "".concat(mediaQuery, " and ").concat(item[2]);
        }
      }

      list.push(item);
    }
  };

  return list;
};

function cssWithMappingToString(item, useSourceMap) {
  var content = item[1] || ''; // eslint-disable-next-line prefer-destructuring

  var cssMapping = item[3];

  if (!cssMapping) {
    return content;
  }

  if (useSourceMap && typeof btoa === 'function') {
    var sourceMapping = toComment(cssMapping);
    var sourceURLs = cssMapping.sources.map(function (source) {
      return "/*# sourceURL=".concat(cssMapping.sourceRoot || '').concat(source, " */");
    });
    return [content].concat(sourceURLs).concat([sourceMapping]).join('\n');
  }

  return [content].join('\n');
} // Adapted from convert-source-map (MIT)


function toComment(sourceMap) {
  // eslint-disable-next-line no-undef
  var base64 = btoa(unescape(encodeURIComponent(JSON.stringify(sourceMap))));
  var data = "sourceMappingURL=data:application/json;charset=utf-8;base64,".concat(base64);
  return "/*# ".concat(data, " */");
}

/***/ }),
/* 8 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* unused harmony export ErrorHandler */
/* unused harmony export errorHandler */
/* harmony export (immutable) */ __webpack_exports__["e"] = onUnexpectedError;
/* harmony export (immutable) */ __webpack_exports__["f"] = onUnexpectedExternalError;
/* harmony export (immutable) */ __webpack_exports__["g"] = transformErrorForSerialization;
/* harmony export (immutable) */ __webpack_exports__["d"] = isPromiseCanceledError;
/* harmony export (immutable) */ __webpack_exports__["a"] = canceled;
/* harmony export (immutable) */ __webpack_exports__["b"] = illegalArgument;
/* harmony export (immutable) */ __webpack_exports__["c"] = illegalState;
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
// Avoid circular dependency on EventEmitter by implementing a subset of the interface.
var ErrorHandler = /** @class */ (function () {
    function ErrorHandler() {
        this.listeners = [];
        this.unexpectedErrorHandler = function (e) {
            setTimeout(function () {
                if (e.stack) {
                    throw new Error(e.message + '\n\n' + e.stack);
                }
                throw e;
            }, 0);
        };
    }
    ErrorHandler.prototype.emit = function (e) {
        this.listeners.forEach(function (listener) {
            listener(e);
        });
    };
    ErrorHandler.prototype.onUnexpectedError = function (e) {
        this.unexpectedErrorHandler(e);
        this.emit(e);
    };
    // For external errors, we don't want the listeners to be called
    ErrorHandler.prototype.onUnexpectedExternalError = function (e) {
        this.unexpectedErrorHandler(e);
    };
    return ErrorHandler;
}());

var errorHandler = new ErrorHandler();
function onUnexpectedError(e) {
    // ignore errors from cancelled promises
    if (!isPromiseCanceledError(e)) {
        errorHandler.onUnexpectedError(e);
    }
    return undefined;
}
function onUnexpectedExternalError(e) {
    // ignore errors from cancelled promises
    if (!isPromiseCanceledError(e)) {
        errorHandler.onUnexpectedExternalError(e);
    }
    return undefined;
}
function transformErrorForSerialization(error) {
    if (error instanceof Error) {
        var name_1 = error.name, message = error.message;
        var stack = error.stacktrace || error.stack;
        return {
            $isError: true,
            name: name_1,
            message: message,
            stack: stack
        };
    }
    // return as is
    return error;
}
var canceledName = 'Canceled';
/**
 * Checks if the given error is a promise in canceled state
 */
function isPromiseCanceledError(error) {
    return error instanceof Error && error.name === canceledName && error.message === canceledName;
}
/**
 * Returns an error that signals cancellation.
 */
function canceled() {
    var error = new Error(canceledName);
    error.name = error.message;
    return error;
}
function illegalArgument(name) {
    if (name) {
        return new Error("Illegal argument: " + name);
    }
    else {
        return new Error('Illegal argument');
    }
}
function illegalState(name) {
    if (name) {
        return new Error("Illegal state: " + name);
    }
    else {
        return new Error('Illegal state');
    }
}


/***/ }),
/* 9 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* unused harmony export loadLanguage */
/* harmony export (immutable) */ __webpack_exports__["a"] = registerLanguage;
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/

// Allow for running under nodejs/requirejs in tests
var _monaco = (typeof monaco === 'undefined' ? self.monaco : monaco);
var languageDefinitions = {};
var lazyLanguageLoaders = {};
var LazyLanguageLoader = /** @class */ (function () {
    function LazyLanguageLoader(languageId) {
        var _this = this;
        this._languageId = languageId;
        this._loadingTriggered = false;
        this._lazyLoadPromise = new Promise(function (resolve, reject) {
            _this._lazyLoadPromiseResolve = resolve;
            _this._lazyLoadPromiseReject = reject;
        });
    }
    LazyLanguageLoader.getOrCreate = function (languageId) {
        if (!lazyLanguageLoaders[languageId]) {
            lazyLanguageLoaders[languageId] = new LazyLanguageLoader(languageId);
        }
        return lazyLanguageLoaders[languageId];
    };
    LazyLanguageLoader.prototype.whenLoaded = function () {
        return this._lazyLoadPromise;
    };
    LazyLanguageLoader.prototype.load = function () {
        var _this = this;
        if (!this._loadingTriggered) {
            this._loadingTriggered = true;
            languageDefinitions[this._languageId].loader().then(function (mod) { return _this._lazyLoadPromiseResolve(mod); }, function (err) { return _this._lazyLoadPromiseReject(err); });
        }
        return this._lazyLoadPromise;
    };
    return LazyLanguageLoader;
}());
function loadLanguage(languageId) {
    return LazyLanguageLoader.getOrCreate(languageId).load();
}
function registerLanguage(def) {
    var languageId = def.id;
    languageDefinitions[languageId] = def;
    _monaco.languages.register(def);
    var lazyLanguageLoader = LazyLanguageLoader.getOrCreate(languageId);
    _monaco.languages.setMonarchTokensProvider(languageId, lazyLanguageLoader.whenLoaded().then(function (mod) { return mod.language; }));
    _monaco.languages.onLanguage(languageId, function () {
        lazyLanguageLoader.load().then(function (mod) {
            _monaco.languages.setLanguageConfiguration(languageId, mod.conf);
        });
    });
}


/***/ }),
/* 10 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "b", function() { return _util; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return IInstantiationService; });
/* harmony export (immutable) */ __webpack_exports__["c"] = createDecorator;
/* harmony export (immutable) */ __webpack_exports__["d"] = optional;
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
// ------ internal util
var _util;
(function (_util) {
    _util.serviceIds = new Map();
    _util.DI_TARGET = '$di$target';
    _util.DI_DEPENDENCIES = '$di$dependencies';
    function getServiceDependencies(ctor) {
        return ctor[_util.DI_DEPENDENCIES] || [];
    }
    _util.getServiceDependencies = getServiceDependencies;
})(_util || (_util = {}));
var IInstantiationService = createDecorator('instantiationService');
function storeServiceDependency(id, target, index, optional) {
    if (target[_util.DI_TARGET] === target) {
        target[_util.DI_DEPENDENCIES].push({ id: id, index: index, optional: optional });
    }
    else {
        target[_util.DI_DEPENDENCIES] = [{ id: id, index: index, optional: optional }];
        target[_util.DI_TARGET] = target;
    }
}
/**
 * A *only* valid way to create a {{ServiceIdentifier}}.
 */
function createDecorator(serviceId) {
    if (_util.serviceIds.has(serviceId)) {
        return _util.serviceIds.get(serviceId);
    }
    var id = function (target, key, index) {
        if (arguments.length !== 3) {
            throw new Error('@IServiceName-decorator can only be used to decorate a parameter');
        }
        storeServiceDependency(id, target, index, false);
    };
    id.toString = function () { return serviceId; };
    _util.serviceIds.set(serviceId, id);
    return id;
}
/**
 * Mark a service dependency as optional.
 */
function optional(serviceIdentifier) {
    return function (target, key, index) {
        if (arguments.length !== 3) {
            throw new Error('@optional-decorator can only be used to decorate a parameter');
        }
        storeServiceDependency(serviceIdentifier, target, index, true);
    };
}


/***/ }),
/* 11 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return Command; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "c", function() { return EditorCommand; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "b", function() { return EditorAction; });
/* harmony export (immutable) */ __webpack_exports__["j"] = registerLanguageCommand;
/* harmony export (immutable) */ __webpack_exports__["e"] = registerDefaultLanguageCommand;
/* harmony export (immutable) */ __webpack_exports__["k"] = registerModelAndPositionCommand;
/* harmony export (immutable) */ __webpack_exports__["l"] = registerModelCommand;
/* harmony export (immutable) */ __webpack_exports__["g"] = registerEditorCommand;
/* harmony export (immutable) */ __webpack_exports__["f"] = registerEditorAction;
/* harmony export (immutable) */ __webpack_exports__["i"] = registerInstantiatedEditorAction;
/* harmony export (immutable) */ __webpack_exports__["h"] = registerEditorContribution;
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "d", function() { return EditorExtensionsRegistry; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__base_common_errors_js__ = __webpack_require__(8);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__base_common_uri_js__ = __webpack_require__(24);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2__services_codeEditorService_js__ = __webpack_require__(30);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3__common_core_position_js__ = __webpack_require__(12);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4__common_services_modelService_js__ = __webpack_require__(48);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5__common_services_resolverService_js__ = __webpack_require__(86);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6__platform_actions_common_actions_js__ = __webpack_require__(66);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_7__platform_commands_common_commands_js__ = __webpack_require__(27);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_8__platform_contextkey_common_contextkey_js__ = __webpack_require__(17);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_9__platform_keybinding_common_keybindingsRegistry_js__ = __webpack_require__(87);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_10__platform_registry_common_platform_js__ = __webpack_require__(41);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_11__platform_telemetry_common_telemetry_js__ = __webpack_require__(100);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_12__base_common_types_js__ = __webpack_require__(20);
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();













var Command = /** @class */ (function () {
    function Command(opts) {
        this.id = opts.id;
        this.precondition = opts.precondition;
        this._kbOpts = opts.kbOpts;
        this._menuOpts = opts.menuOpts;
        this._description = opts.description;
    }
    Command.prototype.register = function () {
        var _this = this;
        if (Array.isArray(this._menuOpts)) {
            this._menuOpts.forEach(this._registerMenuItem, this);
        }
        else if (this._menuOpts) {
            this._registerMenuItem(this._menuOpts);
        }
        if (this._kbOpts) {
            var kbWhen = this._kbOpts.kbExpr;
            if (this.precondition) {
                if (kbWhen) {
                    kbWhen = __WEBPACK_IMPORTED_MODULE_8__platform_contextkey_common_contextkey_js__["a" /* ContextKeyExpr */].and(kbWhen, this.precondition);
                }
                else {
                    kbWhen = this.precondition;
                }
            }
            __WEBPACK_IMPORTED_MODULE_9__platform_keybinding_common_keybindingsRegistry_js__["a" /* KeybindingsRegistry */].registerCommandAndKeybindingRule({
                id: this.id,
                handler: function (accessor, args) { return _this.runCommand(accessor, args); },
                weight: this._kbOpts.weight,
                when: kbWhen,
                primary: this._kbOpts.primary,
                secondary: this._kbOpts.secondary,
                win: this._kbOpts.win,
                linux: this._kbOpts.linux,
                mac: this._kbOpts.mac,
                description: this._description
            });
        }
        else {
            __WEBPACK_IMPORTED_MODULE_7__platform_commands_common_commands_js__["a" /* CommandsRegistry */].registerCommand({
                id: this.id,
                handler: function (accessor, args) { return _this.runCommand(accessor, args); },
                description: this._description
            });
        }
    };
    Command.prototype._registerMenuItem = function (item) {
        __WEBPACK_IMPORTED_MODULE_6__platform_actions_common_actions_js__["c" /* MenuRegistry */].appendMenuItem(item.menuId, {
            group: item.group,
            command: {
                id: this.id,
                title: item.title,
            },
            when: item.when,
            order: item.order
        });
    };
    return Command;
}());

var EditorCommand = /** @class */ (function (_super) {
    __extends(EditorCommand, _super);
    function EditorCommand() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    /**
     * Create a command class that is bound to a certain editor contribution.
     */
    EditorCommand.bindToContribution = function (controllerGetter) {
        return /** @class */ (function (_super) {
            __extends(EditorControllerCommandImpl, _super);
            function EditorControllerCommandImpl(opts) {
                var _this = _super.call(this, opts) || this;
                _this._callback = opts.handler;
                return _this;
            }
            EditorControllerCommandImpl.prototype.runEditorCommand = function (accessor, editor, args) {
                var controller = controllerGetter(editor);
                if (controller) {
                    this._callback(controllerGetter(editor), args);
                }
            };
            return EditorControllerCommandImpl;
        }(EditorCommand));
    };
    EditorCommand.prototype.runCommand = function (accessor, args) {
        var _this = this;
        var codeEditorService = accessor.get(__WEBPACK_IMPORTED_MODULE_2__services_codeEditorService_js__["a" /* ICodeEditorService */]);
        // Find the editor with text focus or active
        var editor = codeEditorService.getFocusedCodeEditor() || codeEditorService.getActiveCodeEditor();
        if (!editor) {
            // well, at least we tried...
            return;
        }
        return editor.invokeWithinContext(function (editorAccessor) {
            var kbService = editorAccessor.get(__WEBPACK_IMPORTED_MODULE_8__platform_contextkey_common_contextkey_js__["c" /* IContextKeyService */]);
            if (!kbService.contextMatchesRules(Object(__WEBPACK_IMPORTED_MODULE_12__base_common_types_js__["n" /* withNullAsUndefined */])(_this.precondition))) {
                // precondition does not hold
                return;
            }
            return _this.runEditorCommand(editorAccessor, editor, args);
        });
    };
    return EditorCommand;
}(Command));

var EditorAction = /** @class */ (function (_super) {
    __extends(EditorAction, _super);
    function EditorAction(opts) {
        var _this = _super.call(this, EditorAction.convertOptions(opts)) || this;
        _this.label = opts.label;
        _this.alias = opts.alias;
        return _this;
    }
    EditorAction.convertOptions = function (opts) {
        var menuOpts;
        if (Array.isArray(opts.menuOpts)) {
            menuOpts = opts.menuOpts;
        }
        else if (opts.menuOpts) {
            menuOpts = [opts.menuOpts];
        }
        else {
            menuOpts = [];
        }
        function withDefaults(item) {
            if (!item.menuId) {
                item.menuId = 7 /* EditorContext */;
            }
            if (!item.title) {
                item.title = opts.label;
            }
            item.when = __WEBPACK_IMPORTED_MODULE_8__platform_contextkey_common_contextkey_js__["a" /* ContextKeyExpr */].and(opts.precondition, item.when);
            return item;
        }
        if (Array.isArray(opts.contextMenuOpts)) {
            menuOpts.push.apply(menuOpts, opts.contextMenuOpts.map(withDefaults));
        }
        else if (opts.contextMenuOpts) {
            menuOpts.push(withDefaults(opts.contextMenuOpts));
        }
        opts.menuOpts = menuOpts;
        return opts;
    };
    EditorAction.prototype.runEditorCommand = function (accessor, editor, args) {
        this.reportTelemetry(accessor, editor);
        return this.run(accessor, editor, args || {});
    };
    EditorAction.prototype.reportTelemetry = function (accessor, editor) {
        accessor.get(__WEBPACK_IMPORTED_MODULE_11__platform_telemetry_common_telemetry_js__["a" /* ITelemetryService */]).publicLog2('editorActionInvoked', { name: this.label, id: this.id });
    };
    return EditorAction;
}(EditorCommand));

//#endregion EditorAction
// --- Registration of commands and actions
function registerLanguageCommand(id, handler) {
    __WEBPACK_IMPORTED_MODULE_7__platform_commands_common_commands_js__["a" /* CommandsRegistry */].registerCommand(id, function (accessor, args) { return handler(accessor, args || {}); });
}
function registerDefaultLanguageCommand(id, handler) {
    registerLanguageCommand(id, function (accessor, args) {
        var resource = args.resource, position = args.position;
        if (!(resource instanceof __WEBPACK_IMPORTED_MODULE_1__base_common_uri_js__["a" /* URI */])) {
            throw Object(__WEBPACK_IMPORTED_MODULE_0__base_common_errors_js__["b" /* illegalArgument */])('resource');
        }
        if (!__WEBPACK_IMPORTED_MODULE_3__common_core_position_js__["a" /* Position */].isIPosition(position)) {
            throw Object(__WEBPACK_IMPORTED_MODULE_0__base_common_errors_js__["b" /* illegalArgument */])('position');
        }
        var model = accessor.get(__WEBPACK_IMPORTED_MODULE_4__common_services_modelService_js__["a" /* IModelService */]).getModel(resource);
        if (model) {
            var editorPosition = __WEBPACK_IMPORTED_MODULE_3__common_core_position_js__["a" /* Position */].lift(position);
            return handler(model, editorPosition, args);
        }
        return accessor.get(__WEBPACK_IMPORTED_MODULE_5__common_services_resolverService_js__["a" /* ITextModelService */]).createModelReference(resource).then(function (reference) {
            return new Promise(function (resolve, reject) {
                try {
                    var result = handler(reference.object.textEditorModel, __WEBPACK_IMPORTED_MODULE_3__common_core_position_js__["a" /* Position */].lift(position), args);
                    resolve(result);
                }
                catch (err) {
                    reject(err);
                }
            }).finally(function () {
                reference.dispose();
            });
        });
    });
}
function registerModelAndPositionCommand(id, handler) {
    __WEBPACK_IMPORTED_MODULE_7__platform_commands_common_commands_js__["a" /* CommandsRegistry */].registerCommand(id, function (accessor) {
        var args = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            args[_i - 1] = arguments[_i];
        }
        var resource = args[0], position = args[1];
        Object(__WEBPACK_IMPORTED_MODULE_12__base_common_types_js__["a" /* assertType */])(__WEBPACK_IMPORTED_MODULE_1__base_common_uri_js__["a" /* URI */].isUri(resource));
        Object(__WEBPACK_IMPORTED_MODULE_12__base_common_types_js__["a" /* assertType */])(__WEBPACK_IMPORTED_MODULE_3__common_core_position_js__["a" /* Position */].isIPosition(position));
        var model = accessor.get(__WEBPACK_IMPORTED_MODULE_4__common_services_modelService_js__["a" /* IModelService */]).getModel(resource);
        if (model) {
            var editorPosition = __WEBPACK_IMPORTED_MODULE_3__common_core_position_js__["a" /* Position */].lift(position);
            return handler(model, editorPosition, args.slice(2));
        }
        return accessor.get(__WEBPACK_IMPORTED_MODULE_5__common_services_resolverService_js__["a" /* ITextModelService */]).createModelReference(resource).then(function (reference) {
            return new Promise(function (resolve, reject) {
                try {
                    var result = handler(reference.object.textEditorModel, __WEBPACK_IMPORTED_MODULE_3__common_core_position_js__["a" /* Position */].lift(position), args.slice(2));
                    resolve(result);
                }
                catch (err) {
                    reject(err);
                }
            }).finally(function () {
                reference.dispose();
            });
        });
    });
}
function registerModelCommand(id, handler) {
    __WEBPACK_IMPORTED_MODULE_7__platform_commands_common_commands_js__["a" /* CommandsRegistry */].registerCommand(id, function (accessor) {
        var args = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            args[_i - 1] = arguments[_i];
        }
        var resource = args[0];
        Object(__WEBPACK_IMPORTED_MODULE_12__base_common_types_js__["a" /* assertType */])(__WEBPACK_IMPORTED_MODULE_1__base_common_uri_js__["a" /* URI */].isUri(resource));
        var model = accessor.get(__WEBPACK_IMPORTED_MODULE_4__common_services_modelService_js__["a" /* IModelService */]).getModel(resource);
        if (model) {
            return handler(model, args.slice(1));
        }
        return accessor.get(__WEBPACK_IMPORTED_MODULE_5__common_services_resolverService_js__["a" /* ITextModelService */]).createModelReference(resource).then(function (reference) {
            return new Promise(function (resolve, reject) {
                try {
                    var result = handler(reference.object.textEditorModel, args.slice(1));
                    resolve(result);
                }
                catch (err) {
                    reject(err);
                }
            }).finally(function () {
                reference.dispose();
            });
        });
    });
}
function registerEditorCommand(editorCommand) {
    EditorContributionRegistry.INSTANCE.registerEditorCommand(editorCommand);
    return editorCommand;
}
function registerEditorAction(ctor) {
    EditorContributionRegistry.INSTANCE.registerEditorAction(new ctor());
}
function registerInstantiatedEditorAction(editorAction) {
    EditorContributionRegistry.INSTANCE.registerEditorAction(editorAction);
}
function registerEditorContribution(id, ctor) {
    EditorContributionRegistry.INSTANCE.registerEditorContribution(id, ctor);
}
var EditorExtensionsRegistry;
(function (EditorExtensionsRegistry) {
    function getEditorCommand(commandId) {
        return EditorContributionRegistry.INSTANCE.getEditorCommand(commandId);
    }
    EditorExtensionsRegistry.getEditorCommand = getEditorCommand;
    function getEditorActions() {
        return EditorContributionRegistry.INSTANCE.getEditorActions();
    }
    EditorExtensionsRegistry.getEditorActions = getEditorActions;
    function getEditorContributions() {
        return EditorContributionRegistry.INSTANCE.getEditorContributions();
    }
    EditorExtensionsRegistry.getEditorContributions = getEditorContributions;
    function getSomeEditorContributions(ids) {
        return EditorContributionRegistry.INSTANCE.getEditorContributions().filter(function (c) { return ids.indexOf(c.id) >= 0; });
    }
    EditorExtensionsRegistry.getSomeEditorContributions = getSomeEditorContributions;
    function getDiffEditorContributions() {
        return EditorContributionRegistry.INSTANCE.getDiffEditorContributions();
    }
    EditorExtensionsRegistry.getDiffEditorContributions = getDiffEditorContributions;
})(EditorExtensionsRegistry || (EditorExtensionsRegistry = {}));
// Editor extension points
var Extensions = {
    EditorCommonContributions: 'editor.contributions'
};
var EditorContributionRegistry = /** @class */ (function () {
    function EditorContributionRegistry() {
        this.editorContributions = [];
        this.diffEditorContributions = [];
        this.editorActions = [];
        this.editorCommands = Object.create(null);
    }
    EditorContributionRegistry.prototype.registerEditorContribution = function (id, ctor) {
        this.editorContributions.push({ id: id, ctor: ctor });
    };
    EditorContributionRegistry.prototype.getEditorContributions = function () {
        return this.editorContributions.slice(0);
    };
    EditorContributionRegistry.prototype.getDiffEditorContributions = function () {
        return this.diffEditorContributions.slice(0);
    };
    EditorContributionRegistry.prototype.registerEditorAction = function (action) {
        action.register();
        this.editorActions.push(action);
    };
    EditorContributionRegistry.prototype.getEditorActions = function () {
        return this.editorActions.slice(0);
    };
    EditorContributionRegistry.prototype.registerEditorCommand = function (editorCommand) {
        editorCommand.register();
        this.editorCommands[editorCommand.id] = editorCommand;
    };
    EditorContributionRegistry.prototype.getEditorCommand = function (commandId) {
        return (this.editorCommands[commandId] || null);
    };
    EditorContributionRegistry.INSTANCE = new EditorContributionRegistry();
    return EditorContributionRegistry;
}());
__WEBPACK_IMPORTED_MODULE_10__platform_registry_common_platform_js__["a" /* Registry */].add(Extensions.EditorCommonContributions, EditorContributionRegistry.INSTANCE);


/***/ }),
/* 12 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return Position; });
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
/**
 * A position in the editor.
 */
var Position = /** @class */ (function () {
    function Position(lineNumber, column) {
        this.lineNumber = lineNumber;
        this.column = column;
    }
    /**
     * Create a new position from this position.
     *
     * @param newLineNumber new line number
     * @param newColumn new column
     */
    Position.prototype.with = function (newLineNumber, newColumn) {
        if (newLineNumber === void 0) { newLineNumber = this.lineNumber; }
        if (newColumn === void 0) { newColumn = this.column; }
        if (newLineNumber === this.lineNumber && newColumn === this.column) {
            return this;
        }
        else {
            return new Position(newLineNumber, newColumn);
        }
    };
    /**
     * Derive a new position from this position.
     *
     * @param deltaLineNumber line number delta
     * @param deltaColumn column delta
     */
    Position.prototype.delta = function (deltaLineNumber, deltaColumn) {
        if (deltaLineNumber === void 0) { deltaLineNumber = 0; }
        if (deltaColumn === void 0) { deltaColumn = 0; }
        return this.with(this.lineNumber + deltaLineNumber, this.column + deltaColumn);
    };
    /**
     * Test if this position equals other position
     */
    Position.prototype.equals = function (other) {
        return Position.equals(this, other);
    };
    /**
     * Test if position `a` equals position `b`
     */
    Position.equals = function (a, b) {
        if (!a && !b) {
            return true;
        }
        return (!!a &&
            !!b &&
            a.lineNumber === b.lineNumber &&
            a.column === b.column);
    };
    /**
     * Test if this position is before other position.
     * If the two positions are equal, the result will be false.
     */
    Position.prototype.isBefore = function (other) {
        return Position.isBefore(this, other);
    };
    /**
     * Test if position `a` is before position `b`.
     * If the two positions are equal, the result will be false.
     */
    Position.isBefore = function (a, b) {
        if (a.lineNumber < b.lineNumber) {
            return true;
        }
        if (b.lineNumber < a.lineNumber) {
            return false;
        }
        return a.column < b.column;
    };
    /**
     * Test if this position is before other position.
     * If the two positions are equal, the result will be true.
     */
    Position.prototype.isBeforeOrEqual = function (other) {
        return Position.isBeforeOrEqual(this, other);
    };
    /**
     * Test if position `a` is before position `b`.
     * If the two positions are equal, the result will be true.
     */
    Position.isBeforeOrEqual = function (a, b) {
        if (a.lineNumber < b.lineNumber) {
            return true;
        }
        if (b.lineNumber < a.lineNumber) {
            return false;
        }
        return a.column <= b.column;
    };
    /**
     * A function that compares positions, useful for sorting
     */
    Position.compare = function (a, b) {
        var aLineNumber = a.lineNumber | 0;
        var bLineNumber = b.lineNumber | 0;
        if (aLineNumber === bLineNumber) {
            var aColumn = a.column | 0;
            var bColumn = b.column | 0;
            return aColumn - bColumn;
        }
        return aLineNumber - bLineNumber;
    };
    /**
     * Clone this position.
     */
    Position.prototype.clone = function () {
        return new Position(this.lineNumber, this.column);
    };
    /**
     * Convert to a human-readable representation.
     */
    Position.prototype.toString = function () {
        return '(' + this.lineNumber + ',' + this.column + ')';
    };
    // ---
    /**
     * Create a `Position` from an `IPosition`.
     */
    Position.lift = function (pos) {
        return new Position(pos.lineNumber, pos.column);
    };
    /**
     * Test if `obj` is an `IPosition`.
     */
    Position.isIPosition = function (obj) {
        return (obj
            && (typeof obj.lineNumber === 'number')
            && (typeof obj.column === 'number'));
    };
    return Position;
}());



/***/ }),
/* 13 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "c", function() { return IThemeService; });
/* harmony export (immutable) */ __webpack_exports__["f"] = themeColorFromId;
/* unused harmony export DARK */
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "b", function() { return HIGH_CONTRAST; });
/* harmony export (immutable) */ __webpack_exports__["d"] = getThemeTypeSelector;
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return Extensions; });
/* harmony export (immutable) */ __webpack_exports__["e"] = registerThemingParticipant;
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__instantiation_common_instantiation_js__ = __webpack_require__(10);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__base_common_lifecycle_js__ = __webpack_require__(0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2__registry_common_platform_js__ = __webpack_require__(41);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3__base_common_event_js__ = __webpack_require__(2);
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/




var IThemeService = Object(__WEBPACK_IMPORTED_MODULE_0__instantiation_common_instantiation_js__["c" /* createDecorator */])('themeService');
function themeColorFromId(id) {
    return { id: id };
}
// base themes
var DARK = 'dark';
var HIGH_CONTRAST = 'hc';
function getThemeTypeSelector(type) {
    switch (type) {
        case DARK: return 'vs-dark';
        case HIGH_CONTRAST: return 'hc-black';
        default: return 'vs';
    }
}
// static theming participant
var Extensions = {
    ThemingContribution: 'base.contributions.theming'
};
var ThemingRegistry = /** @class */ (function () {
    function ThemingRegistry() {
        this.themingParticipants = [];
        this.themingParticipants = [];
        this.onThemingParticipantAddedEmitter = new __WEBPACK_IMPORTED_MODULE_3__base_common_event_js__["a" /* Emitter */]();
    }
    ThemingRegistry.prototype.onThemeChange = function (participant) {
        var _this = this;
        this.themingParticipants.push(participant);
        this.onThemingParticipantAddedEmitter.fire(participant);
        return Object(__WEBPACK_IMPORTED_MODULE_1__base_common_lifecycle_js__["h" /* toDisposable */])(function () {
            var idx = _this.themingParticipants.indexOf(participant);
            _this.themingParticipants.splice(idx, 1);
        });
    };
    ThemingRegistry.prototype.getThemingParticipants = function () {
        return this.themingParticipants;
    };
    return ThemingRegistry;
}());
var themingRegistry = new ThemingRegistry();
__WEBPACK_IMPORTED_MODULE_2__registry_common_platform_js__["a" /* Registry */].add(Extensions.ThemingContribution, themingRegistry);
function registerThemingParticipant(participant) {
    return themingRegistry.onThemeChange(participant);
}


/***/ }),
/* 14 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* WEBPACK VAR INJECTION */(function(process, global) {/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "h", function() { return isWindows; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "e", function() { return isMacintosh; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "d", function() { return isLinux; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "f", function() { return isNative; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "g", function() { return isWeb; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "c", function() { return isIOS; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "b", function() { return globals; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "i", function() { return setImmediate; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return OS; });
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var LANGUAGE_DEFAULT = 'en';
var _isWindows = false;
var _isMacintosh = false;
var _isLinux = false;
var _isNative = false;
var _isWeb = false;
var _isIOS = false;
var _locale = undefined;
var _language = LANGUAGE_DEFAULT;
var _translationsConfigFile = undefined;
var _userAgent = undefined;
var isElectronRenderer = (typeof process !== 'undefined' && typeof process.versions !== 'undefined' && typeof process.versions.electron !== 'undefined' && process.type === 'renderer');
// OS detection
if (typeof navigator === 'object' && !isElectronRenderer) {
    _userAgent = navigator.userAgent;
    _isWindows = _userAgent.indexOf('Windows') >= 0;
    _isMacintosh = _userAgent.indexOf('Macintosh') >= 0;
    _isIOS = _userAgent.indexOf('Macintosh') >= 0 && !!navigator.maxTouchPoints && navigator.maxTouchPoints > 0;
    _isLinux = _userAgent.indexOf('Linux') >= 0;
    _isWeb = true;
    _locale = navigator.language;
    _language = _locale;
}
else if (typeof process === 'object') {
    _isWindows = (process.platform === 'win32');
    _isMacintosh = (process.platform === 'darwin');
    _isLinux = (process.platform === 'linux');
    _locale = LANGUAGE_DEFAULT;
    _language = LANGUAGE_DEFAULT;
    var rawNlsConfig = process.env['VSCODE_NLS_CONFIG'];
    if (rawNlsConfig) {
        try {
            var nlsConfig = JSON.parse(rawNlsConfig);
            var resolved = nlsConfig.availableLanguages['*'];
            _locale = nlsConfig.locale;
            // VSCode's default language is 'en'
            _language = resolved ? resolved : LANGUAGE_DEFAULT;
            _translationsConfigFile = nlsConfig._translationsConfigFile;
        }
        catch (e) {
        }
    }
    _isNative = true;
}
var _platform = 0 /* Web */;
if (_isMacintosh) {
    _platform = 1 /* Mac */;
}
else if (_isWindows) {
    _platform = 3 /* Windows */;
}
else if (_isLinux) {
    _platform = 2 /* Linux */;
}
var isWindows = _isWindows;
var isMacintosh = _isMacintosh;
var isLinux = _isLinux;
var isNative = _isNative;
var isWeb = _isWeb;
var isIOS = _isIOS;
var _globals = (typeof self === 'object' ? self : typeof global === 'object' ? global : {});
var globals = _globals;
var setImmediate = (function defineSetImmediate() {
    if (globals.setImmediate) {
        return globals.setImmediate.bind(globals);
    }
    if (typeof globals.postMessage === 'function' && !globals.importScripts) {
        var pending_1 = [];
        globals.addEventListener('message', function (e) {
            if (e.data && e.data.vscodeSetImmediateId) {
                for (var i = 0, len = pending_1.length; i < len; i++) {
                    var candidate = pending_1[i];
                    if (candidate.id === e.data.vscodeSetImmediateId) {
                        pending_1.splice(i, 1);
                        candidate.callback();
                        return;
                    }
                }
            }
        });
        var lastId_1 = 0;
        return function (callback) {
            var myId = ++lastId_1;
            pending_1.push({
                id: myId,
                callback: callback
            });
            globals.postMessage({ vscodeSetImmediateId: myId }, '*');
        };
    }
    if (typeof process !== 'undefined' && typeof process.nextTick === 'function') {
        return process.nextTick.bind(process);
    }
    var _promise = Promise.resolve();
    return function (callback) { return _promise.then(callback); };
})();
var OS = (_isMacintosh ? 2 /* Macintosh */ : (_isWindows ? 1 /* Windows */ : 3 /* Linux */));

/* WEBPACK VAR INJECTION */}.call(__webpack_exports__, __webpack_require__(85), __webpack_require__(98)))

/***/ }),
/* 15 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (immutable) */ __webpack_exports__["i"] = isThenable;
/* harmony export (immutable) */ __webpack_exports__["f"] = createCancelablePromise;
/* harmony export (immutable) */ __webpack_exports__["j"] = raceCancellation;
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return Delayer; });
/* harmony export (immutable) */ __webpack_exports__["l"] = timeout;
/* harmony export (immutable) */ __webpack_exports__["g"] = disposableTimeout;
/* harmony export (immutable) */ __webpack_exports__["h"] = first;
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "e", function() { return TimeoutTimer; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "c", function() { return IntervalTimer; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "d", function() { return RunOnceScheduler; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "k", function() { return runWhenIdle; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "b", function() { return IdleValue; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__cancellation_js__ = __webpack_require__(25);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__errors_js__ = __webpack_require__(8);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2__lifecycle_js__ = __webpack_require__(0);
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/



function isThenable(obj) {
    return obj && typeof obj.then === 'function';
}
function createCancelablePromise(callback) {
    var source = new __WEBPACK_IMPORTED_MODULE_0__cancellation_js__["b" /* CancellationTokenSource */]();
    var thenable = callback(source.token);
    var promise = new Promise(function (resolve, reject) {
        source.token.onCancellationRequested(function () {
            reject(__WEBPACK_IMPORTED_MODULE_1__errors_js__["a" /* canceled */]());
        });
        Promise.resolve(thenable).then(function (value) {
            source.dispose();
            resolve(value);
        }, function (err) {
            source.dispose();
            reject(err);
        });
    });
    return new /** @class */ (function () {
        function class_1() {
        }
        class_1.prototype.cancel = function () {
            source.cancel();
        };
        class_1.prototype.then = function (resolve, reject) {
            return promise.then(resolve, reject);
        };
        class_1.prototype.catch = function (reject) {
            return this.then(undefined, reject);
        };
        class_1.prototype.finally = function (onfinally) {
            return promise.finally(onfinally);
        };
        return class_1;
    }());
}
function raceCancellation(promise, token, defaultValue) {
    return Promise.race([promise, new Promise(function (resolve) { return token.onCancellationRequested(function () { return resolve(defaultValue); }); })]);
}
/**
 * A helper to delay execution of a task that is being requested often.
 *
 * Following the throttler, now imagine the mail man wants to optimize the number of
 * trips proactively. The trip itself can be long, so he decides not to make the trip
 * as soon as a letter is submitted. Instead he waits a while, in case more
 * letters are submitted. After said waiting period, if no letters were submitted, he
 * decides to make the trip. Imagine that N more letters were submitted after the first
 * one, all within a short period of time between each other. Even though N+1
 * submissions occurred, only 1 delivery was made.
 *
 * The delayer offers this behavior via the trigger() method, into which both the task
 * to be executed and the waiting period (delay) must be passed in as arguments. Following
 * the example:
 *
 * 		const delayer = new Delayer(WAITING_PERIOD);
 * 		const letters = [];
 *
 * 		function letterReceived(l) {
 * 			letters.push(l);
 * 			delayer.trigger(() => { return makeTheTrip(); });
 * 		}
 */
var Delayer = /** @class */ (function () {
    function Delayer(defaultDelay) {
        this.defaultDelay = defaultDelay;
        this.timeout = null;
        this.completionPromise = null;
        this.doResolve = null;
        this.doReject = null;
        this.task = null;
    }
    Delayer.prototype.trigger = function (task, delay) {
        var _this = this;
        if (delay === void 0) { delay = this.defaultDelay; }
        this.task = task;
        this.cancelTimeout();
        if (!this.completionPromise) {
            this.completionPromise = new Promise(function (c, e) {
                _this.doResolve = c;
                _this.doReject = e;
            }).then(function () {
                _this.completionPromise = null;
                _this.doResolve = null;
                if (_this.task) {
                    var task_1 = _this.task;
                    _this.task = null;
                    return task_1();
                }
                return undefined;
            });
        }
        this.timeout = setTimeout(function () {
            _this.timeout = null;
            if (_this.doResolve) {
                _this.doResolve(null);
            }
        }, delay);
        return this.completionPromise;
    };
    Delayer.prototype.isTriggered = function () {
        return this.timeout !== null;
    };
    Delayer.prototype.cancel = function () {
        this.cancelTimeout();
        if (this.completionPromise) {
            if (this.doReject) {
                this.doReject(__WEBPACK_IMPORTED_MODULE_1__errors_js__["a" /* canceled */]());
            }
            this.completionPromise = null;
        }
    };
    Delayer.prototype.cancelTimeout = function () {
        if (this.timeout !== null) {
            clearTimeout(this.timeout);
            this.timeout = null;
        }
    };
    Delayer.prototype.dispose = function () {
        this.cancelTimeout();
    };
    return Delayer;
}());

function timeout(millis, token) {
    if (!token) {
        return createCancelablePromise(function (token) { return timeout(millis, token); });
    }
    return new Promise(function (resolve, reject) {
        var handle = setTimeout(resolve, millis);
        token.onCancellationRequested(function () {
            clearTimeout(handle);
            reject(__WEBPACK_IMPORTED_MODULE_1__errors_js__["a" /* canceled */]());
        });
    });
}
function disposableTimeout(handler, timeout) {
    if (timeout === void 0) { timeout = 0; }
    var timer = setTimeout(handler, timeout);
    return Object(__WEBPACK_IMPORTED_MODULE_2__lifecycle_js__["h" /* toDisposable */])(function () { return clearTimeout(timer); });
}
function first(promiseFactories, shouldStop, defaultValue) {
    if (shouldStop === void 0) { shouldStop = function (t) { return !!t; }; }
    if (defaultValue === void 0) { defaultValue = null; }
    var index = 0;
    var len = promiseFactories.length;
    var loop = function () {
        if (index >= len) {
            return Promise.resolve(defaultValue);
        }
        var factory = promiseFactories[index++];
        var promise = Promise.resolve(factory());
        return promise.then(function (result) {
            if (shouldStop(result)) {
                return Promise.resolve(result);
            }
            return loop();
        });
    };
    return loop();
}
var TimeoutTimer = /** @class */ (function () {
    function TimeoutTimer(runner, timeout) {
        this._token = -1;
        if (typeof runner === 'function' && typeof timeout === 'number') {
            this.setIfNotSet(runner, timeout);
        }
    }
    TimeoutTimer.prototype.dispose = function () {
        this.cancel();
    };
    TimeoutTimer.prototype.cancel = function () {
        if (this._token !== -1) {
            clearTimeout(this._token);
            this._token = -1;
        }
    };
    TimeoutTimer.prototype.cancelAndSet = function (runner, timeout) {
        var _this = this;
        this.cancel();
        this._token = setTimeout(function () {
            _this._token = -1;
            runner();
        }, timeout);
    };
    TimeoutTimer.prototype.setIfNotSet = function (runner, timeout) {
        var _this = this;
        if (this._token !== -1) {
            // timer is already set
            return;
        }
        this._token = setTimeout(function () {
            _this._token = -1;
            runner();
        }, timeout);
    };
    return TimeoutTimer;
}());

var IntervalTimer = /** @class */ (function () {
    function IntervalTimer() {
        this._token = -1;
    }
    IntervalTimer.prototype.dispose = function () {
        this.cancel();
    };
    IntervalTimer.prototype.cancel = function () {
        if (this._token !== -1) {
            clearInterval(this._token);
            this._token = -1;
        }
    };
    IntervalTimer.prototype.cancelAndSet = function (runner, interval) {
        this.cancel();
        this._token = setInterval(function () {
            runner();
        }, interval);
    };
    return IntervalTimer;
}());

var RunOnceScheduler = /** @class */ (function () {
    function RunOnceScheduler(runner, timeout) {
        this.timeoutToken = -1;
        this.runner = runner;
        this.timeout = timeout;
        this.timeoutHandler = this.onTimeout.bind(this);
    }
    /**
     * Dispose RunOnceScheduler
     */
    RunOnceScheduler.prototype.dispose = function () {
        this.cancel();
        this.runner = null;
    };
    /**
     * Cancel current scheduled runner (if any).
     */
    RunOnceScheduler.prototype.cancel = function () {
        if (this.isScheduled()) {
            clearTimeout(this.timeoutToken);
            this.timeoutToken = -1;
        }
    };
    /**
     * Cancel previous runner (if any) & schedule a new runner.
     */
    RunOnceScheduler.prototype.schedule = function (delay) {
        if (delay === void 0) { delay = this.timeout; }
        this.cancel();
        this.timeoutToken = setTimeout(this.timeoutHandler, delay);
    };
    /**
     * Returns true if scheduled.
     */
    RunOnceScheduler.prototype.isScheduled = function () {
        return this.timeoutToken !== -1;
    };
    RunOnceScheduler.prototype.onTimeout = function () {
        this.timeoutToken = -1;
        if (this.runner) {
            this.doRun();
        }
    };
    RunOnceScheduler.prototype.doRun = function () {
        if (this.runner) {
            this.runner();
        }
    };
    return RunOnceScheduler;
}());

/**
 * Execute the callback the next time the browser is idle
 */
var runWhenIdle;
(function () {
    if (typeof requestIdleCallback !== 'function' || typeof cancelIdleCallback !== 'function') {
        var dummyIdle_1 = Object.freeze({
            didTimeout: true,
            timeRemaining: function () { return 15; }
        });
        runWhenIdle = function (runner) {
            var handle = setTimeout(function () { return runner(dummyIdle_1); });
            var disposed = false;
            return {
                dispose: function () {
                    if (disposed) {
                        return;
                    }
                    disposed = true;
                    clearTimeout(handle);
                }
            };
        };
    }
    else {
        runWhenIdle = function (runner, timeout) {
            var handle = requestIdleCallback(runner, typeof timeout === 'number' ? { timeout: timeout } : undefined);
            var disposed = false;
            return {
                dispose: function () {
                    if (disposed) {
                        return;
                    }
                    disposed = true;
                    cancelIdleCallback(handle);
                }
            };
        };
    }
})();
/**
 * An implementation of the "idle-until-urgent"-strategy as introduced
 * here: https://philipwalton.com/articles/idle-until-urgent/
 */
var IdleValue = /** @class */ (function () {
    function IdleValue(executor) {
        var _this = this;
        this._didRun = false;
        this._executor = function () {
            try {
                _this._value = executor();
            }
            catch (err) {
                _this._error = err;
            }
            finally {
                _this._didRun = true;
            }
        };
        this._handle = runWhenIdle(function () { return _this._executor(); });
    }
    IdleValue.prototype.dispose = function () {
        this._handle.dispose();
    };
    IdleValue.prototype.getValue = function () {
        if (!this._didRun) {
            this._handle.dispose();
            this._executor();
        }
        if (this._error) {
            throw this._error;
        }
        return this._value;
    };
    return IdleValue;
}());



/***/ }),
/* 16 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "r", function() { return LanguageIdentifier; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "A", function() { return TokenMetadata; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "F", function() { return completionKindToCssClass; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "E", function() { return completionKindFromString; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "y", function() { return SignatureHelpTriggerKind; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "h", function() { return DocumentHighlightKind; });
/* harmony export (immutable) */ __webpack_exports__["G"] = isLocationLink;
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "z", function() { return SymbolKinds; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "n", function() { return FoldingRangeKind; });
/* unused harmony export WorkspaceFileEdit */
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "D", function() { return WorkspaceTextEdit; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "u", function() { return ReferenceProviderRegistry; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "v", function() { return RenameProviderRegistry; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "d", function() { return CompletionProviderRegistry; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "x", function() { return SignatureHelpProviderRegistry; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "p", function() { return HoverProviderRegistry; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "m", function() { return DocumentSymbolProviderRegistry; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "i", function() { return DocumentHighlightProviderRegistry; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "f", function() { return DefinitionProviderRegistry; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "e", function() { return DeclarationProviderRegistry; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "q", function() { return ImplementationProviderRegistry; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "C", function() { return TypeDefinitionProviderRegistry; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "b", function() { return CodeLensProviderRegistry; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return CodeActionProviderRegistry; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "g", function() { return DocumentFormattingEditProviderRegistry; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "j", function() { return DocumentRangeFormattingEditProviderRegistry; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "t", function() { return OnTypeFormattingEditProviderRegistry; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "s", function() { return LinkProviderRegistry; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "c", function() { return ColorProviderRegistry; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "w", function() { return SelectionRangeRegistry; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "o", function() { return FoldingRangeProviderRegistry; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "l", function() { return DocumentSemanticTokensProviderRegistry; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "k", function() { return DocumentRangeSemanticTokensProviderRegistry; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "B", function() { return TokenizationRegistry; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__base_common_types_js__ = __webpack_require__(20);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__base_common_uri_js__ = __webpack_require__(24);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2__core_range_js__ = __webpack_require__(1);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3__modes_languageFeatureRegistry_js__ = __webpack_require__(397);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4__modes_tokenizationRegistry_js__ = __webpack_require__(400);
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/





/**
 * @internal
 */
var LanguageIdentifier = /** @class */ (function () {
    function LanguageIdentifier(language, id) {
        this.language = language;
        this.id = id;
    }
    return LanguageIdentifier;
}());

/**
 * @internal
 */
var TokenMetadata = /** @class */ (function () {
    function TokenMetadata() {
    }
    TokenMetadata.getLanguageId = function (metadata) {
        return (metadata & 255 /* LANGUAGEID_MASK */) >>> 0 /* LANGUAGEID_OFFSET */;
    };
    TokenMetadata.getTokenType = function (metadata) {
        return (metadata & 1792 /* TOKEN_TYPE_MASK */) >>> 8 /* TOKEN_TYPE_OFFSET */;
    };
    TokenMetadata.getFontStyle = function (metadata) {
        return (metadata & 14336 /* FONT_STYLE_MASK */) >>> 11 /* FONT_STYLE_OFFSET */;
    };
    TokenMetadata.getForeground = function (metadata) {
        return (metadata & 8372224 /* FOREGROUND_MASK */) >>> 14 /* FOREGROUND_OFFSET */;
    };
    TokenMetadata.getBackground = function (metadata) {
        return (metadata & 4286578688 /* BACKGROUND_MASK */) >>> 23 /* BACKGROUND_OFFSET */;
    };
    TokenMetadata.getClassNameFromMetadata = function (metadata) {
        var foreground = this.getForeground(metadata);
        var className = 'mtk' + foreground;
        var fontStyle = this.getFontStyle(metadata);
        if (fontStyle & 1 /* Italic */) {
            className += ' mtki';
        }
        if (fontStyle & 2 /* Bold */) {
            className += ' mtkb';
        }
        if (fontStyle & 4 /* Underline */) {
            className += ' mtku';
        }
        return className;
    };
    TokenMetadata.getInlineStyleFromMetadata = function (metadata, colorMap) {
        var foreground = this.getForeground(metadata);
        var fontStyle = this.getFontStyle(metadata);
        var result = "color: " + colorMap[foreground] + ";";
        if (fontStyle & 1 /* Italic */) {
            result += 'font-style: italic;';
        }
        if (fontStyle & 2 /* Bold */) {
            result += 'font-weight: bold;';
        }
        if (fontStyle & 4 /* Underline */) {
            result += 'text-decoration: underline;';
        }
        return result;
    };
    return TokenMetadata;
}());

/**
 * @internal
 */
var completionKindToCssClass = (function () {
    var data = Object.create(null);
    data[0 /* Method */] = 'method';
    data[1 /* Function */] = 'function';
    data[2 /* Constructor */] = 'constructor';
    data[3 /* Field */] = 'field';
    data[4 /* Variable */] = 'variable';
    data[5 /* Class */] = 'class';
    data[6 /* Struct */] = 'struct';
    data[7 /* Interface */] = 'interface';
    data[8 /* Module */] = 'module';
    data[9 /* Property */] = 'property';
    data[10 /* Event */] = 'event';
    data[11 /* Operator */] = 'operator';
    data[12 /* Unit */] = 'unit';
    data[13 /* Value */] = 'value';
    data[14 /* Constant */] = 'constant';
    data[15 /* Enum */] = 'enum';
    data[16 /* EnumMember */] = 'enum-member';
    data[17 /* Keyword */] = 'keyword';
    data[25 /* Snippet */] = 'snippet';
    data[18 /* Text */] = 'text';
    data[19 /* Color */] = 'color';
    data[20 /* File */] = 'file';
    data[21 /* Reference */] = 'reference';
    data[22 /* Customcolor */] = 'customcolor';
    data[23 /* Folder */] = 'folder';
    data[24 /* TypeParameter */] = 'type-parameter';
    return function (kind) {
        return data[kind] || 'property';
    };
})();
/**
 * @internal
 */
var completionKindFromString = (function () {
    var data = Object.create(null);
    data['method'] = 0 /* Method */;
    data['function'] = 1 /* Function */;
    data['constructor'] = 2 /* Constructor */;
    data['field'] = 3 /* Field */;
    data['variable'] = 4 /* Variable */;
    data['class'] = 5 /* Class */;
    data['struct'] = 6 /* Struct */;
    data['interface'] = 7 /* Interface */;
    data['module'] = 8 /* Module */;
    data['property'] = 9 /* Property */;
    data['event'] = 10 /* Event */;
    data['operator'] = 11 /* Operator */;
    data['unit'] = 12 /* Unit */;
    data['value'] = 13 /* Value */;
    data['constant'] = 14 /* Constant */;
    data['enum'] = 15 /* Enum */;
    data['enum-member'] = 16 /* EnumMember */;
    data['enumMember'] = 16 /* EnumMember */;
    data['keyword'] = 17 /* Keyword */;
    data['snippet'] = 25 /* Snippet */;
    data['text'] = 18 /* Text */;
    data['color'] = 19 /* Color */;
    data['file'] = 20 /* File */;
    data['reference'] = 21 /* Reference */;
    data['customcolor'] = 22 /* Customcolor */;
    data['folder'] = 23 /* Folder */;
    data['type-parameter'] = 24 /* TypeParameter */;
    data['typeParameter'] = 24 /* TypeParameter */;
    return function (value, strict) {
        var res = data[value];
        if (typeof res === 'undefined' && !strict) {
            res = 9 /* Property */;
        }
        return res;
    };
})();
var SignatureHelpTriggerKind;
(function (SignatureHelpTriggerKind) {
    SignatureHelpTriggerKind[SignatureHelpTriggerKind["Invoke"] = 1] = "Invoke";
    SignatureHelpTriggerKind[SignatureHelpTriggerKind["TriggerCharacter"] = 2] = "TriggerCharacter";
    SignatureHelpTriggerKind[SignatureHelpTriggerKind["ContentChange"] = 3] = "ContentChange";
})(SignatureHelpTriggerKind || (SignatureHelpTriggerKind = {}));
/**
 * A document highlight kind.
 */
var DocumentHighlightKind;
(function (DocumentHighlightKind) {
    /**
     * A textual occurrence.
     */
    DocumentHighlightKind[DocumentHighlightKind["Text"] = 0] = "Text";
    /**
     * Read-access of a symbol, like reading a variable.
     */
    DocumentHighlightKind[DocumentHighlightKind["Read"] = 1] = "Read";
    /**
     * Write-access of a symbol, like writing to a variable.
     */
    DocumentHighlightKind[DocumentHighlightKind["Write"] = 2] = "Write";
})(DocumentHighlightKind || (DocumentHighlightKind = {}));
/**
 * @internal
 */
function isLocationLink(thing) {
    return thing
        && __WEBPACK_IMPORTED_MODULE_1__base_common_uri_js__["a" /* URI */].isUri(thing.uri)
        && __WEBPACK_IMPORTED_MODULE_2__core_range_js__["a" /* Range */].isIRange(thing.range)
        && (__WEBPACK_IMPORTED_MODULE_2__core_range_js__["a" /* Range */].isIRange(thing.originSelectionRange) || __WEBPACK_IMPORTED_MODULE_2__core_range_js__["a" /* Range */].isIRange(thing.targetSelectionRange));
}
/**
 * @internal
 */
var SymbolKinds;
(function (SymbolKinds) {
    var byName = new Map();
    byName.set('file', 0 /* File */);
    byName.set('module', 1 /* Module */);
    byName.set('namespace', 2 /* Namespace */);
    byName.set('package', 3 /* Package */);
    byName.set('class', 4 /* Class */);
    byName.set('method', 5 /* Method */);
    byName.set('property', 6 /* Property */);
    byName.set('field', 7 /* Field */);
    byName.set('constructor', 8 /* Constructor */);
    byName.set('enum', 9 /* Enum */);
    byName.set('interface', 10 /* Interface */);
    byName.set('function', 11 /* Function */);
    byName.set('variable', 12 /* Variable */);
    byName.set('constant', 13 /* Constant */);
    byName.set('string', 14 /* String */);
    byName.set('number', 15 /* Number */);
    byName.set('boolean', 16 /* Boolean */);
    byName.set('array', 17 /* Array */);
    byName.set('object', 18 /* Object */);
    byName.set('key', 19 /* Key */);
    byName.set('null', 20 /* Null */);
    byName.set('enum-member', 21 /* EnumMember */);
    byName.set('struct', 22 /* Struct */);
    byName.set('event', 23 /* Event */);
    byName.set('operator', 24 /* Operator */);
    byName.set('type-parameter', 25 /* TypeParameter */);
    var byKind = new Map();
    byKind.set(0 /* File */, 'file');
    byKind.set(1 /* Module */, 'module');
    byKind.set(2 /* Namespace */, 'namespace');
    byKind.set(3 /* Package */, 'package');
    byKind.set(4 /* Class */, 'class');
    byKind.set(5 /* Method */, 'method');
    byKind.set(6 /* Property */, 'property');
    byKind.set(7 /* Field */, 'field');
    byKind.set(8 /* Constructor */, 'constructor');
    byKind.set(9 /* Enum */, 'enum');
    byKind.set(10 /* Interface */, 'interface');
    byKind.set(11 /* Function */, 'function');
    byKind.set(12 /* Variable */, 'variable');
    byKind.set(13 /* Constant */, 'constant');
    byKind.set(14 /* String */, 'string');
    byKind.set(15 /* Number */, 'number');
    byKind.set(16 /* Boolean */, 'boolean');
    byKind.set(17 /* Array */, 'array');
    byKind.set(18 /* Object */, 'object');
    byKind.set(19 /* Key */, 'key');
    byKind.set(20 /* Null */, 'null');
    byKind.set(21 /* EnumMember */, 'enum-member');
    byKind.set(22 /* Struct */, 'struct');
    byKind.set(23 /* Event */, 'event');
    byKind.set(24 /* Operator */, 'operator');
    byKind.set(25 /* TypeParameter */, 'type-parameter');
    /**
     * @internal
     */
    function fromString(value) {
        return byName.get(value);
    }
    SymbolKinds.fromString = fromString;
    /**
     * @internal
     */
    function toString(kind) {
        return byKind.get(kind);
    }
    SymbolKinds.toString = toString;
    /**
     * @internal
     */
    function toCssClassName(kind, inline) {
        return "codicon " + (inline ? 'inline' : 'block') + " codicon-symbol-" + (byKind.get(kind) || 'property');
    }
    SymbolKinds.toCssClassName = toCssClassName;
})(SymbolKinds || (SymbolKinds = {}));
var FoldingRangeKind = /** @class */ (function () {
    /**
     * Creates a new [FoldingRangeKind](#FoldingRangeKind).
     *
     * @param value of the kind.
     */
    function FoldingRangeKind(value) {
        this.value = value;
    }
    /**
     * Kind for folding range representing a comment. The value of the kind is 'comment'.
     */
    FoldingRangeKind.Comment = new FoldingRangeKind('comment');
    /**
     * Kind for folding range representing a import. The value of the kind is 'imports'.
     */
    FoldingRangeKind.Imports = new FoldingRangeKind('imports');
    /**
     * Kind for folding range representing regions (for example marked by `#region`, `#endregion`).
     * The value of the kind is 'region'.
     */
    FoldingRangeKind.Region = new FoldingRangeKind('region');
    return FoldingRangeKind;
}());

/**
 * @internal
 */
var WorkspaceFileEdit;
(function (WorkspaceFileEdit) {
    /**
     * @internal
     */
    function is(thing) {
        return Object(__WEBPACK_IMPORTED_MODULE_0__base_common_types_js__["i" /* isObject */])(thing) && (Boolean(thing.newUri) || Boolean(thing.oldUri));
    }
    WorkspaceFileEdit.is = is;
})(WorkspaceFileEdit || (WorkspaceFileEdit = {}));
/**
 * @internal
 */
var WorkspaceTextEdit;
(function (WorkspaceTextEdit) {
    /**
     * @internal
     */
    function is(thing) {
        return Object(__WEBPACK_IMPORTED_MODULE_0__base_common_types_js__["i" /* isObject */])(thing) && __WEBPACK_IMPORTED_MODULE_1__base_common_uri_js__["a" /* URI */].isUri(thing.resource) && Object(__WEBPACK_IMPORTED_MODULE_0__base_common_types_js__["i" /* isObject */])(thing.edit);
    }
    WorkspaceTextEdit.is = is;
})(WorkspaceTextEdit || (WorkspaceTextEdit = {}));
// --- feature registries ------
/**
 * @internal
 */
var ReferenceProviderRegistry = new __WEBPACK_IMPORTED_MODULE_3__modes_languageFeatureRegistry_js__["a" /* LanguageFeatureRegistry */]();
/**
 * @internal
 */
var RenameProviderRegistry = new __WEBPACK_IMPORTED_MODULE_3__modes_languageFeatureRegistry_js__["a" /* LanguageFeatureRegistry */]();
/**
 * @internal
 */
var CompletionProviderRegistry = new __WEBPACK_IMPORTED_MODULE_3__modes_languageFeatureRegistry_js__["a" /* LanguageFeatureRegistry */]();
/**
 * @internal
 */
var SignatureHelpProviderRegistry = new __WEBPACK_IMPORTED_MODULE_3__modes_languageFeatureRegistry_js__["a" /* LanguageFeatureRegistry */]();
/**
 * @internal
 */
var HoverProviderRegistry = new __WEBPACK_IMPORTED_MODULE_3__modes_languageFeatureRegistry_js__["a" /* LanguageFeatureRegistry */]();
/**
 * @internal
 */
var DocumentSymbolProviderRegistry = new __WEBPACK_IMPORTED_MODULE_3__modes_languageFeatureRegistry_js__["a" /* LanguageFeatureRegistry */]();
/**
 * @internal
 */
var DocumentHighlightProviderRegistry = new __WEBPACK_IMPORTED_MODULE_3__modes_languageFeatureRegistry_js__["a" /* LanguageFeatureRegistry */]();
/**
 * @internal
 */
var DefinitionProviderRegistry = new __WEBPACK_IMPORTED_MODULE_3__modes_languageFeatureRegistry_js__["a" /* LanguageFeatureRegistry */]();
/**
 * @internal
 */
var DeclarationProviderRegistry = new __WEBPACK_IMPORTED_MODULE_3__modes_languageFeatureRegistry_js__["a" /* LanguageFeatureRegistry */]();
/**
 * @internal
 */
var ImplementationProviderRegistry = new __WEBPACK_IMPORTED_MODULE_3__modes_languageFeatureRegistry_js__["a" /* LanguageFeatureRegistry */]();
/**
 * @internal
 */
var TypeDefinitionProviderRegistry = new __WEBPACK_IMPORTED_MODULE_3__modes_languageFeatureRegistry_js__["a" /* LanguageFeatureRegistry */]();
/**
 * @internal
 */
var CodeLensProviderRegistry = new __WEBPACK_IMPORTED_MODULE_3__modes_languageFeatureRegistry_js__["a" /* LanguageFeatureRegistry */]();
/**
 * @internal
 */
var CodeActionProviderRegistry = new __WEBPACK_IMPORTED_MODULE_3__modes_languageFeatureRegistry_js__["a" /* LanguageFeatureRegistry */]();
/**
 * @internal
 */
var DocumentFormattingEditProviderRegistry = new __WEBPACK_IMPORTED_MODULE_3__modes_languageFeatureRegistry_js__["a" /* LanguageFeatureRegistry */]();
/**
 * @internal
 */
var DocumentRangeFormattingEditProviderRegistry = new __WEBPACK_IMPORTED_MODULE_3__modes_languageFeatureRegistry_js__["a" /* LanguageFeatureRegistry */]();
/**
 * @internal
 */
var OnTypeFormattingEditProviderRegistry = new __WEBPACK_IMPORTED_MODULE_3__modes_languageFeatureRegistry_js__["a" /* LanguageFeatureRegistry */]();
/**
 * @internal
 */
var LinkProviderRegistry = new __WEBPACK_IMPORTED_MODULE_3__modes_languageFeatureRegistry_js__["a" /* LanguageFeatureRegistry */]();
/**
 * @internal
 */
var ColorProviderRegistry = new __WEBPACK_IMPORTED_MODULE_3__modes_languageFeatureRegistry_js__["a" /* LanguageFeatureRegistry */]();
/**
 * @internal
 */
var SelectionRangeRegistry = new __WEBPACK_IMPORTED_MODULE_3__modes_languageFeatureRegistry_js__["a" /* LanguageFeatureRegistry */]();
/**
 * @internal
 */
var FoldingRangeProviderRegistry = new __WEBPACK_IMPORTED_MODULE_3__modes_languageFeatureRegistry_js__["a" /* LanguageFeatureRegistry */]();
/**
 * @internal
 */
var DocumentSemanticTokensProviderRegistry = new __WEBPACK_IMPORTED_MODULE_3__modes_languageFeatureRegistry_js__["a" /* LanguageFeatureRegistry */]();
/**
 * @internal
 */
var DocumentRangeSemanticTokensProviderRegistry = new __WEBPACK_IMPORTED_MODULE_3__modes_languageFeatureRegistry_js__["a" /* LanguageFeatureRegistry */]();
/**
 * @internal
 */
var TokenizationRegistry = new __WEBPACK_IMPORTED_MODULE_4__modes_tokenizationRegistry_js__["a" /* TokenizationRegistryImpl */]();


/***/ }),
/* 17 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return ContextKeyExpr; });
/* unused harmony export ContextKeyDefinedExpr */
/* unused harmony export ContextKeyEqualsExpr */
/* unused harmony export ContextKeyNotEqualsExpr */
/* unused harmony export ContextKeyNotExpr */
/* unused harmony export ContextKeyRegexExpr */
/* unused harmony export ContextKeyNotRegexExpr */
/* unused harmony export ContextKeyAndExpr */
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "b", function() { return ContextKeyOrExpr; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "d", function() { return RawContextKey; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "c", function() { return IContextKeyService; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "e", function() { return SET_CONTEXT_COMMAND_ID; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__base_common_strings_js__ = __webpack_require__(4);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__instantiation_common_instantiation_js__ = __webpack_require__(10);
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();


var ContextKeyExpr = /** @class */ (function () {
    function ContextKeyExpr() {
    }
    ContextKeyExpr.has = function (key) {
        return ContextKeyDefinedExpr.create(key);
    };
    ContextKeyExpr.equals = function (key, value) {
        return ContextKeyEqualsExpr.create(key, value);
    };
    ContextKeyExpr.regex = function (key, value) {
        return ContextKeyRegexExpr.create(key, value);
    };
    ContextKeyExpr.not = function (key) {
        return ContextKeyNotExpr.create(key);
    };
    ContextKeyExpr.and = function () {
        var expr = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            expr[_i] = arguments[_i];
        }
        return ContextKeyAndExpr.create(expr);
    };
    ContextKeyExpr.or = function () {
        var expr = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            expr[_i] = arguments[_i];
        }
        return ContextKeyOrExpr.create(expr);
    };
    ContextKeyExpr.deserialize = function (serialized, strict) {
        if (strict === void 0) { strict = false; }
        if (!serialized) {
            return undefined;
        }
        return this._deserializeOrExpression(serialized, strict);
    };
    ContextKeyExpr._deserializeOrExpression = function (serialized, strict) {
        var _this = this;
        var pieces = serialized.split('||');
        return ContextKeyOrExpr.create(pieces.map(function (p) { return _this._deserializeAndExpression(p, strict); }));
    };
    ContextKeyExpr._deserializeAndExpression = function (serialized, strict) {
        var _this = this;
        var pieces = serialized.split('&&');
        return ContextKeyAndExpr.create(pieces.map(function (p) { return _this._deserializeOne(p, strict); }));
    };
    ContextKeyExpr._deserializeOne = function (serializedOne, strict) {
        serializedOne = serializedOne.trim();
        if (serializedOne.indexOf('!=') >= 0) {
            var pieces = serializedOne.split('!=');
            return ContextKeyNotEqualsExpr.create(pieces[0].trim(), this._deserializeValue(pieces[1], strict));
        }
        if (serializedOne.indexOf('==') >= 0) {
            var pieces = serializedOne.split('==');
            return ContextKeyEqualsExpr.create(pieces[0].trim(), this._deserializeValue(pieces[1], strict));
        }
        if (serializedOne.indexOf('=~') >= 0) {
            var pieces = serializedOne.split('=~');
            return ContextKeyRegexExpr.create(pieces[0].trim(), this._deserializeRegexValue(pieces[1], strict));
        }
        if (/^\!\s*/.test(serializedOne)) {
            return ContextKeyNotExpr.create(serializedOne.substr(1).trim());
        }
        return ContextKeyDefinedExpr.create(serializedOne);
    };
    ContextKeyExpr._deserializeValue = function (serializedValue, strict) {
        serializedValue = serializedValue.trim();
        if (serializedValue === 'true') {
            return true;
        }
        if (serializedValue === 'false') {
            return false;
        }
        var m = /^'([^']*)'$/.exec(serializedValue);
        if (m) {
            return m[1].trim();
        }
        return serializedValue;
    };
    ContextKeyExpr._deserializeRegexValue = function (serializedValue, strict) {
        if (Object(__WEBPACK_IMPORTED_MODULE_0__base_common_strings_js__["x" /* isFalsyOrWhitespace */])(serializedValue)) {
            if (strict) {
                throw new Error('missing regexp-value for =~-expression');
            }
            else {
                console.warn('missing regexp-value for =~-expression');
            }
            return null;
        }
        var start = serializedValue.indexOf('/');
        var end = serializedValue.lastIndexOf('/');
        if (start === end || start < 0 /* || to < 0 */) {
            if (strict) {
                throw new Error("bad regexp-value '" + serializedValue + "', missing /-enclosure");
            }
            else {
                console.warn("bad regexp-value '" + serializedValue + "', missing /-enclosure");
            }
            return null;
        }
        var value = serializedValue.slice(start + 1, end);
        var caseIgnoreFlag = serializedValue[end + 1] === 'i' ? 'i' : '';
        try {
            return new RegExp(value, caseIgnoreFlag);
        }
        catch (e) {
            if (strict) {
                throw new Error("bad regexp-value '" + serializedValue + "', parse error: " + e);
            }
            else {
                console.warn("bad regexp-value '" + serializedValue + "', parse error: " + e);
            }
            return null;
        }
    };
    return ContextKeyExpr;
}());

function cmp(a, b) {
    var aType = a.getType();
    var bType = b.getType();
    if (aType !== bType) {
        return aType - bType;
    }
    switch (aType) {
        case 1 /* Defined */:
            return a.cmp(b);
        case 2 /* Not */:
            return a.cmp(b);
        case 3 /* Equals */:
            return a.cmp(b);
        case 4 /* NotEquals */:
            return a.cmp(b);
        case 6 /* Regex */:
            return a.cmp(b);
        case 7 /* NotRegex */:
            return a.cmp(b);
        case 5 /* And */:
            return a.cmp(b);
        default:
            throw new Error('Unknown ContextKeyExpr!');
    }
}
var ContextKeyDefinedExpr = /** @class */ (function () {
    function ContextKeyDefinedExpr(key) {
        this.key = key;
    }
    ContextKeyDefinedExpr.create = function (key) {
        return new ContextKeyDefinedExpr(key);
    };
    ContextKeyDefinedExpr.prototype.getType = function () {
        return 1 /* Defined */;
    };
    ContextKeyDefinedExpr.prototype.cmp = function (other) {
        if (this.key < other.key) {
            return -1;
        }
        if (this.key > other.key) {
            return 1;
        }
        return 0;
    };
    ContextKeyDefinedExpr.prototype.equals = function (other) {
        if (other instanceof ContextKeyDefinedExpr) {
            return (this.key === other.key);
        }
        return false;
    };
    ContextKeyDefinedExpr.prototype.evaluate = function (context) {
        return (!!context.getValue(this.key));
    };
    ContextKeyDefinedExpr.prototype.keys = function () {
        return [this.key];
    };
    ContextKeyDefinedExpr.prototype.negate = function () {
        return ContextKeyNotExpr.create(this.key);
    };
    return ContextKeyDefinedExpr;
}());

var ContextKeyEqualsExpr = /** @class */ (function () {
    function ContextKeyEqualsExpr(key, value) {
        this.key = key;
        this.value = value;
    }
    ContextKeyEqualsExpr.create = function (key, value) {
        if (typeof value === 'boolean') {
            if (value) {
                return ContextKeyDefinedExpr.create(key);
            }
            return ContextKeyNotExpr.create(key);
        }
        return new ContextKeyEqualsExpr(key, value);
    };
    ContextKeyEqualsExpr.prototype.getType = function () {
        return 3 /* Equals */;
    };
    ContextKeyEqualsExpr.prototype.cmp = function (other) {
        if (this.key < other.key) {
            return -1;
        }
        if (this.key > other.key) {
            return 1;
        }
        if (this.value < other.value) {
            return -1;
        }
        if (this.value > other.value) {
            return 1;
        }
        return 0;
    };
    ContextKeyEqualsExpr.prototype.equals = function (other) {
        if (other instanceof ContextKeyEqualsExpr) {
            return (this.key === other.key && this.value === other.value);
        }
        return false;
    };
    ContextKeyEqualsExpr.prototype.evaluate = function (context) {
        // Intentional ==
        // eslint-disable-next-line eqeqeq
        return (context.getValue(this.key) == this.value);
    };
    ContextKeyEqualsExpr.prototype.keys = function () {
        return [this.key];
    };
    ContextKeyEqualsExpr.prototype.negate = function () {
        return ContextKeyNotEqualsExpr.create(this.key, this.value);
    };
    return ContextKeyEqualsExpr;
}());

var ContextKeyNotEqualsExpr = /** @class */ (function () {
    function ContextKeyNotEqualsExpr(key, value) {
        this.key = key;
        this.value = value;
    }
    ContextKeyNotEqualsExpr.create = function (key, value) {
        if (typeof value === 'boolean') {
            if (value) {
                return ContextKeyNotExpr.create(key);
            }
            return ContextKeyDefinedExpr.create(key);
        }
        return new ContextKeyNotEqualsExpr(key, value);
    };
    ContextKeyNotEqualsExpr.prototype.getType = function () {
        return 4 /* NotEquals */;
    };
    ContextKeyNotEqualsExpr.prototype.cmp = function (other) {
        if (this.key < other.key) {
            return -1;
        }
        if (this.key > other.key) {
            return 1;
        }
        if (this.value < other.value) {
            return -1;
        }
        if (this.value > other.value) {
            return 1;
        }
        return 0;
    };
    ContextKeyNotEqualsExpr.prototype.equals = function (other) {
        if (other instanceof ContextKeyNotEqualsExpr) {
            return (this.key === other.key && this.value === other.value);
        }
        return false;
    };
    ContextKeyNotEqualsExpr.prototype.evaluate = function (context) {
        // Intentional !=
        // eslint-disable-next-line eqeqeq
        return (context.getValue(this.key) != this.value);
    };
    ContextKeyNotEqualsExpr.prototype.keys = function () {
        return [this.key];
    };
    ContextKeyNotEqualsExpr.prototype.negate = function () {
        return ContextKeyEqualsExpr.create(this.key, this.value);
    };
    return ContextKeyNotEqualsExpr;
}());

var ContextKeyNotExpr = /** @class */ (function () {
    function ContextKeyNotExpr(key) {
        this.key = key;
    }
    ContextKeyNotExpr.create = function (key) {
        return new ContextKeyNotExpr(key);
    };
    ContextKeyNotExpr.prototype.getType = function () {
        return 2 /* Not */;
    };
    ContextKeyNotExpr.prototype.cmp = function (other) {
        if (this.key < other.key) {
            return -1;
        }
        if (this.key > other.key) {
            return 1;
        }
        return 0;
    };
    ContextKeyNotExpr.prototype.equals = function (other) {
        if (other instanceof ContextKeyNotExpr) {
            return (this.key === other.key);
        }
        return false;
    };
    ContextKeyNotExpr.prototype.evaluate = function (context) {
        return (!context.getValue(this.key));
    };
    ContextKeyNotExpr.prototype.keys = function () {
        return [this.key];
    };
    ContextKeyNotExpr.prototype.negate = function () {
        return ContextKeyDefinedExpr.create(this.key);
    };
    return ContextKeyNotExpr;
}());

var ContextKeyRegexExpr = /** @class */ (function () {
    function ContextKeyRegexExpr(key, regexp) {
        this.key = key;
        this.regexp = regexp;
        //
    }
    ContextKeyRegexExpr.create = function (key, regexp) {
        return new ContextKeyRegexExpr(key, regexp);
    };
    ContextKeyRegexExpr.prototype.getType = function () {
        return 6 /* Regex */;
    };
    ContextKeyRegexExpr.prototype.cmp = function (other) {
        if (this.key < other.key) {
            return -1;
        }
        if (this.key > other.key) {
            return 1;
        }
        var thisSource = this.regexp ? this.regexp.source : '';
        var otherSource = other.regexp ? other.regexp.source : '';
        if (thisSource < otherSource) {
            return -1;
        }
        if (thisSource > otherSource) {
            return 1;
        }
        return 0;
    };
    ContextKeyRegexExpr.prototype.equals = function (other) {
        if (other instanceof ContextKeyRegexExpr) {
            var thisSource = this.regexp ? this.regexp.source : '';
            var otherSource = other.regexp ? other.regexp.source : '';
            return (this.key === other.key && thisSource === otherSource);
        }
        return false;
    };
    ContextKeyRegexExpr.prototype.evaluate = function (context) {
        var value = context.getValue(this.key);
        return this.regexp ? this.regexp.test(value) : false;
    };
    ContextKeyRegexExpr.prototype.keys = function () {
        return [this.key];
    };
    ContextKeyRegexExpr.prototype.negate = function () {
        return ContextKeyNotRegexExpr.create(this);
    };
    return ContextKeyRegexExpr;
}());

var ContextKeyNotRegexExpr = /** @class */ (function () {
    function ContextKeyNotRegexExpr(_actual) {
        this._actual = _actual;
        //
    }
    ContextKeyNotRegexExpr.create = function (actual) {
        return new ContextKeyNotRegexExpr(actual);
    };
    ContextKeyNotRegexExpr.prototype.getType = function () {
        return 7 /* NotRegex */;
    };
    ContextKeyNotRegexExpr.prototype.cmp = function (other) {
        return this._actual.cmp(other._actual);
    };
    ContextKeyNotRegexExpr.prototype.equals = function (other) {
        if (other instanceof ContextKeyNotRegexExpr) {
            return this._actual.equals(other._actual);
        }
        return false;
    };
    ContextKeyNotRegexExpr.prototype.evaluate = function (context) {
        return !this._actual.evaluate(context);
    };
    ContextKeyNotRegexExpr.prototype.keys = function () {
        return this._actual.keys();
    };
    ContextKeyNotRegexExpr.prototype.negate = function () {
        return this._actual;
    };
    return ContextKeyNotRegexExpr;
}());

var ContextKeyAndExpr = /** @class */ (function () {
    function ContextKeyAndExpr(expr) {
        this.expr = expr;
    }
    ContextKeyAndExpr.create = function (_expr) {
        var expr = ContextKeyAndExpr._normalizeArr(_expr);
        if (expr.length === 0) {
            return undefined;
        }
        if (expr.length === 1) {
            return expr[0];
        }
        return new ContextKeyAndExpr(expr);
    };
    ContextKeyAndExpr.prototype.getType = function () {
        return 5 /* And */;
    };
    ContextKeyAndExpr.prototype.cmp = function (other) {
        if (this.expr.length < other.expr.length) {
            return -1;
        }
        if (this.expr.length > other.expr.length) {
            return 1;
        }
        for (var i = 0, len = this.expr.length; i < len; i++) {
            var r = cmp(this.expr[i], other.expr[i]);
            if (r !== 0) {
                return r;
            }
        }
        return 0;
    };
    ContextKeyAndExpr.prototype.equals = function (other) {
        if (other instanceof ContextKeyAndExpr) {
            if (this.expr.length !== other.expr.length) {
                return false;
            }
            for (var i = 0, len = this.expr.length; i < len; i++) {
                if (!this.expr[i].equals(other.expr[i])) {
                    return false;
                }
            }
            return true;
        }
        return false;
    };
    ContextKeyAndExpr.prototype.evaluate = function (context) {
        for (var i = 0, len = this.expr.length; i < len; i++) {
            if (!this.expr[i].evaluate(context)) {
                return false;
            }
        }
        return true;
    };
    ContextKeyAndExpr._normalizeArr = function (arr) {
        var expr = [];
        if (arr) {
            for (var i = 0, len = arr.length; i < len; i++) {
                var e = arr[i];
                if (!e) {
                    continue;
                }
                if (e instanceof ContextKeyAndExpr) {
                    expr = expr.concat(e.expr);
                    continue;
                }
                if (e instanceof ContextKeyOrExpr) {
                    // Not allowed, because we don't have parens!
                    throw new Error("It is not allowed to have an or expression here due to lack of parens! For example \"a && (b||c)\" is not supported, use \"(a&&b) || (a&&c)\" instead.");
                }
                expr.push(e);
            }
            expr.sort(cmp);
        }
        return expr;
    };
    ContextKeyAndExpr.prototype.keys = function () {
        var result = [];
        for (var _i = 0, _a = this.expr; _i < _a.length; _i++) {
            var expr = _a[_i];
            result.push.apply(result, expr.keys());
        }
        return result;
    };
    ContextKeyAndExpr.prototype.negate = function () {
        var result = [];
        for (var _i = 0, _a = this.expr; _i < _a.length; _i++) {
            var expr = _a[_i];
            result.push(expr.negate());
        }
        return ContextKeyOrExpr.create(result);
    };
    return ContextKeyAndExpr;
}());

var ContextKeyOrExpr = /** @class */ (function () {
    function ContextKeyOrExpr(expr) {
        this.expr = expr;
    }
    ContextKeyOrExpr.create = function (_expr) {
        var expr = ContextKeyOrExpr._normalizeArr(_expr);
        if (expr.length === 0) {
            return undefined;
        }
        if (expr.length === 1) {
            return expr[0];
        }
        return new ContextKeyOrExpr(expr);
    };
    ContextKeyOrExpr.prototype.getType = function () {
        return 8 /* Or */;
    };
    ContextKeyOrExpr.prototype.equals = function (other) {
        if (other instanceof ContextKeyOrExpr) {
            if (this.expr.length !== other.expr.length) {
                return false;
            }
            for (var i = 0, len = this.expr.length; i < len; i++) {
                if (!this.expr[i].equals(other.expr[i])) {
                    return false;
                }
            }
            return true;
        }
        return false;
    };
    ContextKeyOrExpr.prototype.evaluate = function (context) {
        for (var i = 0, len = this.expr.length; i < len; i++) {
            if (this.expr[i].evaluate(context)) {
                return true;
            }
        }
        return false;
    };
    ContextKeyOrExpr._normalizeArr = function (arr) {
        var expr = [];
        if (arr) {
            for (var i = 0, len = arr.length; i < len; i++) {
                var e = arr[i];
                if (!e) {
                    continue;
                }
                if (e instanceof ContextKeyOrExpr) {
                    expr = expr.concat(e.expr);
                    continue;
                }
                expr.push(e);
            }
            expr.sort(cmp);
        }
        return expr;
    };
    ContextKeyOrExpr.prototype.keys = function () {
        var result = [];
        for (var _i = 0, _a = this.expr; _i < _a.length; _i++) {
            var expr = _a[_i];
            result.push.apply(result, expr.keys());
        }
        return result;
    };
    ContextKeyOrExpr.prototype.negate = function () {
        var result = [];
        for (var _i = 0, _a = this.expr; _i < _a.length; _i++) {
            var expr = _a[_i];
            result.push(expr.negate());
        }
        var terminals = function (node) {
            if (node instanceof ContextKeyOrExpr) {
                return node.expr;
            }
            return [node];
        };
        // We don't support parens, so here we distribute the AND over the OR terminals
        // We always take the first 2 AND pairs and distribute them
        while (result.length > 1) {
            var LEFT = result.shift();
            var RIGHT = result.shift();
            var all = [];
            for (var _b = 0, _c = terminals(LEFT); _b < _c.length; _b++) {
                var left = _c[_b];
                for (var _d = 0, _e = terminals(RIGHT); _d < _e.length; _d++) {
                    var right = _e[_d];
                    all.push(ContextKeyExpr.and(left, right));
                }
            }
            result.unshift(ContextKeyExpr.or.apply(ContextKeyExpr, all));
        }
        return result[0];
    };
    return ContextKeyOrExpr;
}());

var RawContextKey = /** @class */ (function (_super) {
    __extends(RawContextKey, _super);
    function RawContextKey(key, defaultValue) {
        var _this = _super.call(this, key) || this;
        _this._defaultValue = defaultValue;
        return _this;
    }
    RawContextKey.prototype.bindTo = function (target) {
        return target.createKey(this.key, this._defaultValue);
    };
    RawContextKey.prototype.getValue = function (target) {
        return target.getContextKeyValue(this.key);
    };
    RawContextKey.prototype.toNegated = function () {
        return ContextKeyExpr.not(this.key);
    };
    return RawContextKey;
}(ContextKeyDefinedExpr));

var IContextKeyService = Object(__WEBPACK_IMPORTED_MODULE_1__instantiation_common_instantiation_js__["c" /* createDecorator */])('contextKeyService');
var SET_CONTEXT_COMMAND_ID = 'setContext';


/***/ }),
/* 18 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (immutable) */ __webpack_exports__["v"] = tail;
/* harmony export (immutable) */ __webpack_exports__["w"] = tail2;
/* harmony export (immutable) */ __webpack_exports__["g"] = equals;
/* harmony export (immutable) */ __webpack_exports__["c"] = binarySearch;
/* harmony export (immutable) */ __webpack_exports__["i"] = findFirstInSorted;
/* harmony export (immutable) */ __webpack_exports__["r"] = mergeSort;
/* harmony export (immutable) */ __webpack_exports__["o"] = groupBy;
/* harmony export (immutable) */ __webpack_exports__["d"] = coalesce;
/* harmony export (immutable) */ __webpack_exports__["p"] = isFalsyOrEmpty;
/* harmony export (immutable) */ __webpack_exports__["q"] = isNonEmptyArray;
/* harmony export (immutable) */ __webpack_exports__["e"] = distinct;
/* harmony export (immutable) */ __webpack_exports__["f"] = distinctES6;
/* harmony export (immutable) */ __webpack_exports__["n"] = fromSet;
/* harmony export (immutable) */ __webpack_exports__["k"] = firstIndex;
/* harmony export (immutable) */ __webpack_exports__["j"] = first;
/* harmony export (immutable) */ __webpack_exports__["l"] = firstOrDefault;
/* harmony export (immutable) */ __webpack_exports__["m"] = flatten;
/* harmony export (immutable) */ __webpack_exports__["u"] = range;
/* harmony export (immutable) */ __webpack_exports__["a"] = arrayInsert;
/* harmony export (immutable) */ __webpack_exports__["t"] = pushToStart;
/* harmony export (immutable) */ __webpack_exports__["s"] = pushToEnd;
/* harmony export (immutable) */ __webpack_exports__["h"] = find;
/* harmony export (immutable) */ __webpack_exports__["b"] = asArray;
/**
 * Returns the last element of an array.
 * @param array The array.
 * @param n Which element from the end (default is zero).
 */
function tail(array, n) {
    if (n === void 0) { n = 0; }
    return array[array.length - (1 + n)];
}
function tail2(arr) {
    if (arr.length === 0) {
        throw new Error('Invalid tail call');
    }
    return [arr.slice(0, arr.length - 1), arr[arr.length - 1]];
}
function equals(one, other, itemEquals) {
    if (itemEquals === void 0) { itemEquals = function (a, b) { return a === b; }; }
    if (one === other) {
        return true;
    }
    if (!one || !other) {
        return false;
    }
    if (one.length !== other.length) {
        return false;
    }
    for (var i = 0, len = one.length; i < len; i++) {
        if (!itemEquals(one[i], other[i])) {
            return false;
        }
    }
    return true;
}
function binarySearch(array, key, comparator) {
    var low = 0, high = array.length - 1;
    while (low <= high) {
        var mid = ((low + high) / 2) | 0;
        var comp = comparator(array[mid], key);
        if (comp < 0) {
            low = mid + 1;
        }
        else if (comp > 0) {
            high = mid - 1;
        }
        else {
            return mid;
        }
    }
    return -(low + 1);
}
/**
 * Takes a sorted array and a function p. The array is sorted in such a way that all elements where p(x) is false
 * are located before all elements where p(x) is true.
 * @returns the least x for which p(x) is true or array.length if no element fullfills the given function.
 */
function findFirstInSorted(array, p) {
    var low = 0, high = array.length;
    if (high === 0) {
        return 0; // no children
    }
    while (low < high) {
        var mid = Math.floor((low + high) / 2);
        if (p(array[mid])) {
            high = mid;
        }
        else {
            low = mid + 1;
        }
    }
    return low;
}
/**
 * Like `Array#sort` but always stable. Usually runs a little slower `than Array#sort`
 * so only use this when actually needing stable sort.
 */
function mergeSort(data, compare) {
    _sort(data, compare, 0, data.length - 1, []);
    return data;
}
function _merge(a, compare, lo, mid, hi, aux) {
    var leftIdx = lo, rightIdx = mid + 1;
    for (var i = lo; i <= hi; i++) {
        aux[i] = a[i];
    }
    for (var i = lo; i <= hi; i++) {
        if (leftIdx > mid) {
            // left side consumed
            a[i] = aux[rightIdx++];
        }
        else if (rightIdx > hi) {
            // right side consumed
            a[i] = aux[leftIdx++];
        }
        else if (compare(aux[rightIdx], aux[leftIdx]) < 0) {
            // right element is less -> comes first
            a[i] = aux[rightIdx++];
        }
        else {
            // left element comes first (less or equal)
            a[i] = aux[leftIdx++];
        }
    }
}
function _sort(a, compare, lo, hi, aux) {
    if (hi <= lo) {
        return;
    }
    var mid = lo + ((hi - lo) / 2) | 0;
    _sort(a, compare, lo, mid, aux);
    _sort(a, compare, mid + 1, hi, aux);
    if (compare(a[mid], a[mid + 1]) <= 0) {
        // left and right are sorted and if the last-left element is less
        // or equals than the first-right element there is nothing else
        // to do
        return;
    }
    _merge(a, compare, lo, mid, hi, aux);
}
function groupBy(data, compare) {
    var result = [];
    var currentGroup = undefined;
    for (var _i = 0, _a = mergeSort(data.slice(0), compare); _i < _a.length; _i++) {
        var element = _a[_i];
        if (!currentGroup || compare(currentGroup[0], element) !== 0) {
            currentGroup = [element];
            result.push(currentGroup);
        }
        else {
            currentGroup.push(element);
        }
    }
    return result;
}
/**
 * @returns New array with all falsy values removed. The original array IS NOT modified.
 */
function coalesce(array) {
    return array.filter(function (e) { return !!e; });
}
/**
 * @returns false if the provided object is an array and not empty.
 */
function isFalsyOrEmpty(obj) {
    return !Array.isArray(obj) || obj.length === 0;
}
function isNonEmptyArray(obj) {
    return Array.isArray(obj) && obj.length > 0;
}
/**
 * Removes duplicates from the given array. The optional keyFn allows to specify
 * how elements are checked for equalness by returning a unique string for each.
 */
function distinct(array, keyFn) {
    if (!keyFn) {
        return array.filter(function (element, position) {
            return array.indexOf(element) === position;
        });
    }
    var seen = Object.create(null);
    return array.filter(function (elem) {
        var key = keyFn(elem);
        if (seen[key]) {
            return false;
        }
        seen[key] = true;
        return true;
    });
}
function distinctES6(array) {
    var seen = new Set();
    return array.filter(function (element) {
        if (seen.has(element)) {
            return false;
        }
        seen.add(element);
        return true;
    });
}
function fromSet(set) {
    var result = [];
    set.forEach(function (o) { return result.push(o); });
    return result;
}
function firstIndex(array, fn) {
    for (var i = 0; i < array.length; i++) {
        var element = array[i];
        if (fn(element)) {
            return i;
        }
    }
    return -1;
}
function first(array, fn, notFoundValue) {
    if (notFoundValue === void 0) { notFoundValue = undefined; }
    var index = firstIndex(array, fn);
    return index < 0 ? notFoundValue : array[index];
}
function firstOrDefault(array, notFoundValue) {
    return array.length > 0 ? array[0] : notFoundValue;
}
function flatten(arr) {
    var _a;
    return (_a = []).concat.apply(_a, arr);
}
function range(arg, to) {
    var from = typeof to === 'number' ? arg : 0;
    if (typeof to === 'number') {
        from = arg;
    }
    else {
        from = 0;
        to = arg;
    }
    var result = [];
    if (from <= to) {
        for (var i = from; i < to; i++) {
            result.push(i);
        }
    }
    else {
        for (var i = from; i > to; i--) {
            result.push(i);
        }
    }
    return result;
}
/**
 * Insert `insertArr` inside `target` at `insertIndex`.
 * Please don't touch unless you understand https://jsperf.com/inserting-an-array-within-an-array
 */
function arrayInsert(target, insertIndex, insertArr) {
    var before = target.slice(0, insertIndex);
    var after = target.slice(insertIndex);
    return before.concat(insertArr, after);
}
/**
 * Pushes an element to the start of the array, if found.
 */
function pushToStart(arr, value) {
    var index = arr.indexOf(value);
    if (index > -1) {
        arr.splice(index, 1);
        arr.unshift(value);
    }
}
/**
 * Pushes an element to the end of the array, if found.
 */
function pushToEnd(arr, value) {
    var index = arr.indexOf(value);
    if (index > -1) {
        arr.splice(index, 1);
        arr.push(value);
    }
}
function find(arr, predicate) {
    for (var i = 0; i < arr.length; i++) {
        var element = arr[i];
        if (predicate(element, i, arr)) {
            return element;
        }
    }
    return undefined;
}
function asArray(x) {
    return Array.isArray(x) ? x : [x];
}


/***/ }),
/* 19 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return Extensions; });
/* harmony export (immutable) */ __webpack_exports__["_45"] = registerColor;
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "W", function() { return foreground; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "U", function() { return errorForeground; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "V", function() { return focusBorder; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "e", function() { return contrastBorder; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "b", function() { return activeContrastBorder; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "_56", function() { return textLinkForeground; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "_55", function() { return textCodeBlockBackground; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "_59", function() { return widgetShadow; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Z", function() { return inputBackground; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "_1", function() { return inputForeground; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "_0", function() { return inputBorder; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Y", function() { return inputActiveOptionBorder; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "X", function() { return inputActiveOptionBackground; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "_5", function() { return inputValidationInfoBackground; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "_7", function() { return inputValidationInfoForeground; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "_6", function() { return inputValidationInfoBorder; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "_8", function() { return inputValidationWarningBackground; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "_10", function() { return inputValidationWarningForeground; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "_9", function() { return inputValidationWarningBorder; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "_2", function() { return inputValidationErrorBackground; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "_4", function() { return inputValidationErrorForeground; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "_3", function() { return inputValidationErrorBorder; });
/* unused harmony export selectBackground */
/* unused harmony export selectForeground */
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "_40", function() { return pickerGroupForeground; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "_39", function() { return pickerGroupBorder; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "c", function() { return badgeBackground; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "d", function() { return badgeForeground; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "_47", function() { return scrollbarShadow; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "_49", function() { return scrollbarSliderBackground; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "_50", function() { return scrollbarSliderHoverBackground; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "_48", function() { return scrollbarSliderActiveBackground; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "_44", function() { return progressBarBackground; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "q", function() { return editorErrorForeground; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "p", function() { return editorErrorBorder; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "P", function() { return editorWarningForeground; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "O", function() { return editorWarningBorder; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "H", function() { return editorInfoForeground; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "G", function() { return editorInfoBorder; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "z", function() { return editorHintForeground; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "y", function() { return editorHintBorder; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "o", function() { return editorBackground; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "x", function() { return editorForeground; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Q", function() { return editorWidgetBackground; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "S", function() { return editorWidgetForeground; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "R", function() { return editorWidgetBorder; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "T", function() { return editorWidgetResizeBorder; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "K", function() { return editorSelectionBackground; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "L", function() { return editorSelectionForeground; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "F", function() { return editorInactiveSelection; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "M", function() { return editorSelectionHighlight; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "N", function() { return editorSelectionHighlightBorder; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "r", function() { return editorFindMatch; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "t", function() { return editorFindMatchHighlight; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "v", function() { return editorFindRangeHighlight; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "s", function() { return editorFindMatchBorder; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "u", function() { return editorFindMatchHighlightBorder; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "w", function() { return editorFindRangeHighlightBorder; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "D", function() { return editorHoverHighlight; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "A", function() { return editorHoverBackground; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "C", function() { return editorHoverForeground; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "B", function() { return editorHoverBorder; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "E", function() { return editorHoverStatusBarBackground; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "n", function() { return editorActiveLinkForeground; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "J", function() { return editorLightBulbForeground; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "I", function() { return editorLightBulbAutoFixForeground; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "g", function() { return defaultInsertColor; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "h", function() { return defaultRemoveColor; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "j", function() { return diffInserted; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "l", function() { return diffRemoved; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "k", function() { return diffInsertedOutline; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "m", function() { return diffRemovedOutline; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "i", function() { return diffBorder; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "_17", function() { return listFocusBackground; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "_18", function() { return listFocusForeground; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "_11", function() { return listActiveSelectionBackground; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "_12", function() { return listActiveSelectionForeground; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "_23", function() { return listInactiveSelectionBackground; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "_24", function() { return listInactiveSelectionForeground; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "_22", function() { return listInactiveFocusBackground; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "_20", function() { return listHoverBackground; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "_21", function() { return listHoverForeground; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "_13", function() { return listDropBackground; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "_19", function() { return listHighlightForeground; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "_14", function() { return listFilterWidgetBackground; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "_16", function() { return listFilterWidgetOutline; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "_15", function() { return listFilterWidgetNoMatchesOutline; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "_58", function() { return treeIndentGuidesStroke; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "_26", function() { return menuBorder; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "_27", function() { return menuForeground; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "_25", function() { return menuBackground; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "_30", function() { return menuSelectionForeground; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "_28", function() { return menuSelectionBackground; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "_29", function() { return menuSelectionBorder; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "_31", function() { return menuSeparatorBackground; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "_53", function() { return snippetTabstopHighlightBackground; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "_54", function() { return snippetTabstopHighlightBorder; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "_51", function() { return snippetFinalTabstopHighlightBackground; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "_52", function() { return snippetFinalTabstopHighlightBorder; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "_37", function() { return overviewRulerFindMatchForeground; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "_38", function() { return overviewRulerSelectionHighlightForeground; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "_33", function() { return minimapFindMatch; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "_34", function() { return minimapSelection; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "_32", function() { return minimapError; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "_35", function() { return minimapWarning; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "_41", function() { return problemsErrorIconForeground; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "_43", function() { return problemsWarningIconForeground; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "_42", function() { return problemsInfoIconForeground; });
/* harmony export (immutable) */ __webpack_exports__["f"] = darken;
/* unused harmony export lighten */
/* harmony export (immutable) */ __webpack_exports__["_57"] = transparent;
/* harmony export (immutable) */ __webpack_exports__["_36"] = oneOf;
/* harmony export (immutable) */ __webpack_exports__["_46"] = resolveColorValue;
/* unused harmony export workbenchColorsSchemaId */
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__registry_common_platform_js__ = __webpack_require__(41);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__base_common_color_js__ = __webpack_require__(28);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2__base_common_event_js__ = __webpack_require__(2);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3__nls_js__ = __webpack_require__(5);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4__jsonschemas_common_jsonContributionRegistry_js__ = __webpack_require__(306);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5__base_common_async_js__ = __webpack_require__(15);
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/






// color registry
var Extensions = {
    ColorContribution: 'base.contributions.colors'
};
var ColorRegistry = /** @class */ (function () {
    function ColorRegistry() {
        this._onDidChangeSchema = new __WEBPACK_IMPORTED_MODULE_2__base_common_event_js__["a" /* Emitter */]();
        this.onDidChangeSchema = this._onDidChangeSchema.event;
        this.colorSchema = { type: 'object', properties: {} };
        this.colorReferenceSchema = { type: 'string', enum: [], enumDescriptions: [] };
        this.colorsById = {};
    }
    ColorRegistry.prototype.registerColor = function (id, defaults, description, needsTransparency, deprecationMessage) {
        if (needsTransparency === void 0) { needsTransparency = false; }
        var colorContribution = { id: id, description: description, defaults: defaults, needsTransparency: needsTransparency, deprecationMessage: deprecationMessage };
        this.colorsById[id] = colorContribution;
        var propertySchema = { type: 'string', description: description, format: 'color-hex', defaultSnippets: [{ body: '${1:#ff0000}' }] };
        if (deprecationMessage) {
            propertySchema.deprecationMessage = deprecationMessage;
        }
        this.colorSchema.properties[id] = propertySchema;
        this.colorReferenceSchema.enum.push(id);
        this.colorReferenceSchema.enumDescriptions.push(description);
        this._onDidChangeSchema.fire();
        return id;
    };
    ColorRegistry.prototype.resolveDefaultColor = function (id, theme) {
        var colorDesc = this.colorsById[id];
        if (colorDesc && colorDesc.defaults) {
            var colorValue = colorDesc.defaults[theme.type];
            return resolveColorValue(colorValue, theme);
        }
        return undefined;
    };
    ColorRegistry.prototype.getColorSchema = function () {
        return this.colorSchema;
    };
    ColorRegistry.prototype.toString = function () {
        var _this = this;
        var sorter = function (a, b) {
            var cat1 = a.indexOf('.') === -1 ? 0 : 1;
            var cat2 = b.indexOf('.') === -1 ? 0 : 1;
            if (cat1 !== cat2) {
                return cat1 - cat2;
            }
            return a.localeCompare(b);
        };
        return Object.keys(this.colorsById).sort(sorter).map(function (k) { return "- `" + k + "`: " + _this.colorsById[k].description; }).join('\n');
    };
    return ColorRegistry;
}());
var colorRegistry = new ColorRegistry();
__WEBPACK_IMPORTED_MODULE_0__registry_common_platform_js__["a" /* Registry */].add(Extensions.ColorContribution, colorRegistry);
function registerColor(id, defaults, description, needsTransparency, deprecationMessage) {
    return colorRegistry.registerColor(id, defaults, description, needsTransparency, deprecationMessage);
}
// ----- base colors
var foreground = registerColor('foreground', { dark: '#CCCCCC', light: '#616161', hc: '#FFFFFF' }, __WEBPACK_IMPORTED_MODULE_3__nls_js__["a" /* localize */]('foreground', "Overall foreground color. This color is only used if not overridden by a component."));
var errorForeground = registerColor('errorForeground', { dark: '#F48771', light: '#A1260D', hc: '#F48771' }, __WEBPACK_IMPORTED_MODULE_3__nls_js__["a" /* localize */]('errorForeground', "Overall foreground color for error messages. This color is only used if not overridden by a component."));
var focusBorder = registerColor('focusBorder', { dark: __WEBPACK_IMPORTED_MODULE_1__base_common_color_js__["a" /* Color */].fromHex('#0E639C').transparent(0.8), light: __WEBPACK_IMPORTED_MODULE_1__base_common_color_js__["a" /* Color */].fromHex('#007ACC').transparent(0.4), hc: '#F38518' }, __WEBPACK_IMPORTED_MODULE_3__nls_js__["a" /* localize */]('focusBorder', "Overall border color for focused elements. This color is only used if not overridden by a component."));
var contrastBorder = registerColor('contrastBorder', { light: null, dark: null, hc: '#6FC3DF' }, __WEBPACK_IMPORTED_MODULE_3__nls_js__["a" /* localize */]('contrastBorder', "An extra border around elements to separate them from others for greater contrast."));
var activeContrastBorder = registerColor('contrastActiveBorder', { light: null, dark: null, hc: focusBorder }, __WEBPACK_IMPORTED_MODULE_3__nls_js__["a" /* localize */]('activeContrastBorder', "An extra border around active elements to separate them from others for greater contrast."));
var textLinkForeground = registerColor('textLink.foreground', { light: '#006AB1', dark: '#3794FF', hc: '#3794FF' }, __WEBPACK_IMPORTED_MODULE_3__nls_js__["a" /* localize */]('textLinkForeground', "Foreground color for links in text."));
var textCodeBlockBackground = registerColor('textCodeBlock.background', { light: '#dcdcdc66', dark: '#0a0a0a66', hc: __WEBPACK_IMPORTED_MODULE_1__base_common_color_js__["a" /* Color */].black }, __WEBPACK_IMPORTED_MODULE_3__nls_js__["a" /* localize */]('textCodeBlockBackground', "Background color for code blocks in text."));
// ----- widgets
var widgetShadow = registerColor('widget.shadow', { dark: '#000000', light: '#A8A8A8', hc: null }, __WEBPACK_IMPORTED_MODULE_3__nls_js__["a" /* localize */]('widgetShadow', 'Shadow color of widgets such as find/replace inside the editor.'));
var inputBackground = registerColor('input.background', { dark: '#3C3C3C', light: __WEBPACK_IMPORTED_MODULE_1__base_common_color_js__["a" /* Color */].white, hc: __WEBPACK_IMPORTED_MODULE_1__base_common_color_js__["a" /* Color */].black }, __WEBPACK_IMPORTED_MODULE_3__nls_js__["a" /* localize */]('inputBoxBackground', "Input box background."));
var inputForeground = registerColor('input.foreground', { dark: foreground, light: foreground, hc: foreground }, __WEBPACK_IMPORTED_MODULE_3__nls_js__["a" /* localize */]('inputBoxForeground', "Input box foreground."));
var inputBorder = registerColor('input.border', { dark: null, light: null, hc: contrastBorder }, __WEBPACK_IMPORTED_MODULE_3__nls_js__["a" /* localize */]('inputBoxBorder', "Input box border."));
var inputActiveOptionBorder = registerColor('inputOption.activeBorder', { dark: '#007ACC00', light: '#007ACC00', hc: contrastBorder }, __WEBPACK_IMPORTED_MODULE_3__nls_js__["a" /* localize */]('inputBoxActiveOptionBorder', "Border color of activated options in input fields."));
var inputActiveOptionBackground = registerColor('inputOption.activeBackground', { dark: transparent(focusBorder, 0.5), light: transparent(focusBorder, 0.3), hc: null }, __WEBPACK_IMPORTED_MODULE_3__nls_js__["a" /* localize */]('inputOption.activeBackground', "Background color of activated options in input fields."));
var inputValidationInfoBackground = registerColor('inputValidation.infoBackground', { dark: '#063B49', light: '#D6ECF2', hc: __WEBPACK_IMPORTED_MODULE_1__base_common_color_js__["a" /* Color */].black }, __WEBPACK_IMPORTED_MODULE_3__nls_js__["a" /* localize */]('inputValidationInfoBackground', "Input validation background color for information severity."));
var inputValidationInfoForeground = registerColor('inputValidation.infoForeground', { dark: null, light: null, hc: null }, __WEBPACK_IMPORTED_MODULE_3__nls_js__["a" /* localize */]('inputValidationInfoForeground', "Input validation foreground color for information severity."));
var inputValidationInfoBorder = registerColor('inputValidation.infoBorder', { dark: '#007acc', light: '#007acc', hc: contrastBorder }, __WEBPACK_IMPORTED_MODULE_3__nls_js__["a" /* localize */]('inputValidationInfoBorder', "Input validation border color for information severity."));
var inputValidationWarningBackground = registerColor('inputValidation.warningBackground', { dark: '#352A05', light: '#F6F5D2', hc: __WEBPACK_IMPORTED_MODULE_1__base_common_color_js__["a" /* Color */].black }, __WEBPACK_IMPORTED_MODULE_3__nls_js__["a" /* localize */]('inputValidationWarningBackground', "Input validation background color for warning severity."));
var inputValidationWarningForeground = registerColor('inputValidation.warningForeground', { dark: null, light: null, hc: null }, __WEBPACK_IMPORTED_MODULE_3__nls_js__["a" /* localize */]('inputValidationWarningForeground', "Input validation foreground color for warning severity."));
var inputValidationWarningBorder = registerColor('inputValidation.warningBorder', { dark: '#B89500', light: '#B89500', hc: contrastBorder }, __WEBPACK_IMPORTED_MODULE_3__nls_js__["a" /* localize */]('inputValidationWarningBorder', "Input validation border color for warning severity."));
var inputValidationErrorBackground = registerColor('inputValidation.errorBackground', { dark: '#5A1D1D', light: '#F2DEDE', hc: __WEBPACK_IMPORTED_MODULE_1__base_common_color_js__["a" /* Color */].black }, __WEBPACK_IMPORTED_MODULE_3__nls_js__["a" /* localize */]('inputValidationErrorBackground', "Input validation background color for error severity."));
var inputValidationErrorForeground = registerColor('inputValidation.errorForeground', { dark: null, light: null, hc: null }, __WEBPACK_IMPORTED_MODULE_3__nls_js__["a" /* localize */]('inputValidationErrorForeground', "Input validation foreground color for error severity."));
var inputValidationErrorBorder = registerColor('inputValidation.errorBorder', { dark: '#BE1100', light: '#BE1100', hc: contrastBorder }, __WEBPACK_IMPORTED_MODULE_3__nls_js__["a" /* localize */]('inputValidationErrorBorder', "Input validation border color for error severity."));
var selectBackground = registerColor('dropdown.background', { dark: '#3C3C3C', light: __WEBPACK_IMPORTED_MODULE_1__base_common_color_js__["a" /* Color */].white, hc: __WEBPACK_IMPORTED_MODULE_1__base_common_color_js__["a" /* Color */].black }, __WEBPACK_IMPORTED_MODULE_3__nls_js__["a" /* localize */]('dropdownBackground', "Dropdown background."));
var selectForeground = registerColor('dropdown.foreground', { dark: '#F0F0F0', light: null, hc: __WEBPACK_IMPORTED_MODULE_1__base_common_color_js__["a" /* Color */].white }, __WEBPACK_IMPORTED_MODULE_3__nls_js__["a" /* localize */]('dropdownForeground', "Dropdown foreground."));
var pickerGroupForeground = registerColor('pickerGroup.foreground', { dark: '#3794FF', light: '#0066BF', hc: __WEBPACK_IMPORTED_MODULE_1__base_common_color_js__["a" /* Color */].white }, __WEBPACK_IMPORTED_MODULE_3__nls_js__["a" /* localize */]('pickerGroupForeground', "Quick picker color for grouping labels."));
var pickerGroupBorder = registerColor('pickerGroup.border', { dark: '#3F3F46', light: '#CCCEDB', hc: __WEBPACK_IMPORTED_MODULE_1__base_common_color_js__["a" /* Color */].white }, __WEBPACK_IMPORTED_MODULE_3__nls_js__["a" /* localize */]('pickerGroupBorder', "Quick picker color for grouping borders."));
var badgeBackground = registerColor('badge.background', { dark: '#4D4D4D', light: '#C4C4C4', hc: __WEBPACK_IMPORTED_MODULE_1__base_common_color_js__["a" /* Color */].black }, __WEBPACK_IMPORTED_MODULE_3__nls_js__["a" /* localize */]('badgeBackground', "Badge background color. Badges are small information labels, e.g. for search results count."));
var badgeForeground = registerColor('badge.foreground', { dark: __WEBPACK_IMPORTED_MODULE_1__base_common_color_js__["a" /* Color */].white, light: '#333', hc: __WEBPACK_IMPORTED_MODULE_1__base_common_color_js__["a" /* Color */].white }, __WEBPACK_IMPORTED_MODULE_3__nls_js__["a" /* localize */]('badgeForeground', "Badge foreground color. Badges are small information labels, e.g. for search results count."));
var scrollbarShadow = registerColor('scrollbar.shadow', { dark: '#000000', light: '#DDDDDD', hc: null }, __WEBPACK_IMPORTED_MODULE_3__nls_js__["a" /* localize */]('scrollbarShadow', "Scrollbar shadow to indicate that the view is scrolled."));
var scrollbarSliderBackground = registerColor('scrollbarSlider.background', { dark: __WEBPACK_IMPORTED_MODULE_1__base_common_color_js__["a" /* Color */].fromHex('#797979').transparent(0.4), light: __WEBPACK_IMPORTED_MODULE_1__base_common_color_js__["a" /* Color */].fromHex('#646464').transparent(0.4), hc: transparent(contrastBorder, 0.6) }, __WEBPACK_IMPORTED_MODULE_3__nls_js__["a" /* localize */]('scrollbarSliderBackground', "Scrollbar slider background color."));
var scrollbarSliderHoverBackground = registerColor('scrollbarSlider.hoverBackground', { dark: __WEBPACK_IMPORTED_MODULE_1__base_common_color_js__["a" /* Color */].fromHex('#646464').transparent(0.7), light: __WEBPACK_IMPORTED_MODULE_1__base_common_color_js__["a" /* Color */].fromHex('#646464').transparent(0.7), hc: transparent(contrastBorder, 0.8) }, __WEBPACK_IMPORTED_MODULE_3__nls_js__["a" /* localize */]('scrollbarSliderHoverBackground', "Scrollbar slider background color when hovering."));
var scrollbarSliderActiveBackground = registerColor('scrollbarSlider.activeBackground', { dark: __WEBPACK_IMPORTED_MODULE_1__base_common_color_js__["a" /* Color */].fromHex('#BFBFBF').transparent(0.4), light: __WEBPACK_IMPORTED_MODULE_1__base_common_color_js__["a" /* Color */].fromHex('#000000').transparent(0.6), hc: contrastBorder }, __WEBPACK_IMPORTED_MODULE_3__nls_js__["a" /* localize */]('scrollbarSliderActiveBackground', "Scrollbar slider background color when clicked on."));
var progressBarBackground = registerColor('progressBar.background', { dark: __WEBPACK_IMPORTED_MODULE_1__base_common_color_js__["a" /* Color */].fromHex('#0E70C0'), light: __WEBPACK_IMPORTED_MODULE_1__base_common_color_js__["a" /* Color */].fromHex('#0E70C0'), hc: contrastBorder }, __WEBPACK_IMPORTED_MODULE_3__nls_js__["a" /* localize */]('progressBarBackground', "Background color of the progress bar that can show for long running operations."));
var editorErrorForeground = registerColor('editorError.foreground', { dark: '#F48771', light: '#E51400', hc: null }, __WEBPACK_IMPORTED_MODULE_3__nls_js__["a" /* localize */]('editorError.foreground', 'Foreground color of error squigglies in the editor.'));
var editorErrorBorder = registerColor('editorError.border', { dark: null, light: null, hc: __WEBPACK_IMPORTED_MODULE_1__base_common_color_js__["a" /* Color */].fromHex('#E47777').transparent(0.8) }, __WEBPACK_IMPORTED_MODULE_3__nls_js__["a" /* localize */]('errorBorder', 'Border color of error boxes in the editor.'));
var editorWarningForeground = registerColor('editorWarning.foreground', { dark: '#CCA700', light: '#E9A700', hc: null }, __WEBPACK_IMPORTED_MODULE_3__nls_js__["a" /* localize */]('editorWarning.foreground', 'Foreground color of warning squigglies in the editor.'));
var editorWarningBorder = registerColor('editorWarning.border', { dark: null, light: null, hc: __WEBPACK_IMPORTED_MODULE_1__base_common_color_js__["a" /* Color */].fromHex('#FFCC00').transparent(0.8) }, __WEBPACK_IMPORTED_MODULE_3__nls_js__["a" /* localize */]('warningBorder', 'Border color of warning boxes in the editor.'));
var editorInfoForeground = registerColor('editorInfo.foreground', { dark: '#75BEFF', light: '#75BEFF', hc: null }, __WEBPACK_IMPORTED_MODULE_3__nls_js__["a" /* localize */]('editorInfo.foreground', 'Foreground color of info squigglies in the editor.'));
var editorInfoBorder = registerColor('editorInfo.border', { dark: null, light: null, hc: __WEBPACK_IMPORTED_MODULE_1__base_common_color_js__["a" /* Color */].fromHex('#75BEFF').transparent(0.8) }, __WEBPACK_IMPORTED_MODULE_3__nls_js__["a" /* localize */]('infoBorder', 'Border color of info boxes in the editor.'));
var editorHintForeground = registerColor('editorHint.foreground', { dark: __WEBPACK_IMPORTED_MODULE_1__base_common_color_js__["a" /* Color */].fromHex('#eeeeee').transparent(0.7), light: '#6c6c6c', hc: null }, __WEBPACK_IMPORTED_MODULE_3__nls_js__["a" /* localize */]('editorHint.foreground', 'Foreground color of hint squigglies in the editor.'));
var editorHintBorder = registerColor('editorHint.border', { dark: null, light: null, hc: __WEBPACK_IMPORTED_MODULE_1__base_common_color_js__["a" /* Color */].fromHex('#eeeeee').transparent(0.8) }, __WEBPACK_IMPORTED_MODULE_3__nls_js__["a" /* localize */]('hintBorder', 'Border color of hint boxes in the editor.'));
/**
 * Editor background color.
 * Because of bug https://monacotools.visualstudio.com/DefaultCollection/Monaco/_workitems/edit/13254
 * we are *not* using the color white (or #ffffff, rgba(255,255,255)) but something very close to white.
 */
var editorBackground = registerColor('editor.background', { light: '#fffffe', dark: '#1E1E1E', hc: __WEBPACK_IMPORTED_MODULE_1__base_common_color_js__["a" /* Color */].black }, __WEBPACK_IMPORTED_MODULE_3__nls_js__["a" /* localize */]('editorBackground', "Editor background color."));
/**
 * Editor foreground color.
 */
var editorForeground = registerColor('editor.foreground', { light: '#333333', dark: '#BBBBBB', hc: __WEBPACK_IMPORTED_MODULE_1__base_common_color_js__["a" /* Color */].white }, __WEBPACK_IMPORTED_MODULE_3__nls_js__["a" /* localize */]('editorForeground', "Editor default foreground color."));
/**
 * Editor widgets
 */
var editorWidgetBackground = registerColor('editorWidget.background', { dark: '#252526', light: '#F3F3F3', hc: '#0C141F' }, __WEBPACK_IMPORTED_MODULE_3__nls_js__["a" /* localize */]('editorWidgetBackground', 'Background color of editor widgets, such as find/replace.'));
var editorWidgetForeground = registerColor('editorWidget.foreground', { dark: foreground, light: foreground, hc: foreground }, __WEBPACK_IMPORTED_MODULE_3__nls_js__["a" /* localize */]('editorWidgetForeground', 'Foreground color of editor widgets, such as find/replace.'));
var editorWidgetBorder = registerColor('editorWidget.border', { dark: '#454545', light: '#C8C8C8', hc: contrastBorder }, __WEBPACK_IMPORTED_MODULE_3__nls_js__["a" /* localize */]('editorWidgetBorder', 'Border color of editor widgets. The color is only used if the widget chooses to have a border and if the color is not overridden by a widget.'));
var editorWidgetResizeBorder = registerColor('editorWidget.resizeBorder', { light: null, dark: null, hc: null }, __WEBPACK_IMPORTED_MODULE_3__nls_js__["a" /* localize */]('editorWidgetResizeBorder', "Border color of the resize bar of editor widgets. The color is only used if the widget chooses to have a resize border and if the color is not overridden by a widget."));
/**
 * Editor selection colors.
 */
var editorSelectionBackground = registerColor('editor.selectionBackground', { light: '#ADD6FF', dark: '#264F78', hc: '#f3f518' }, __WEBPACK_IMPORTED_MODULE_3__nls_js__["a" /* localize */]('editorSelectionBackground', "Color of the editor selection."));
var editorSelectionForeground = registerColor('editor.selectionForeground', { light: null, dark: null, hc: '#000000' }, __WEBPACK_IMPORTED_MODULE_3__nls_js__["a" /* localize */]('editorSelectionForeground', "Color of the selected text for high contrast."));
var editorInactiveSelection = registerColor('editor.inactiveSelectionBackground', { light: transparent(editorSelectionBackground, 0.5), dark: transparent(editorSelectionBackground, 0.5), hc: transparent(editorSelectionBackground, 0.5) }, __WEBPACK_IMPORTED_MODULE_3__nls_js__["a" /* localize */]('editorInactiveSelection', "Color of the selection in an inactive editor. The color must not be opaque so as not to hide underlying decorations."), true);
var editorSelectionHighlight = registerColor('editor.selectionHighlightBackground', { light: lessProminent(editorSelectionBackground, editorBackground, 0.3, 0.6), dark: lessProminent(editorSelectionBackground, editorBackground, 0.3, 0.6), hc: null }, __WEBPACK_IMPORTED_MODULE_3__nls_js__["a" /* localize */]('editorSelectionHighlight', 'Color for regions with the same content as the selection. The color must not be opaque so as not to hide underlying decorations.'), true);
var editorSelectionHighlightBorder = registerColor('editor.selectionHighlightBorder', { light: null, dark: null, hc: activeContrastBorder }, __WEBPACK_IMPORTED_MODULE_3__nls_js__["a" /* localize */]('editorSelectionHighlightBorder', "Border color for regions with the same content as the selection."));
/**
 * Editor find match colors.
 */
var editorFindMatch = registerColor('editor.findMatchBackground', { light: '#A8AC94', dark: '#515C6A', hc: null }, __WEBPACK_IMPORTED_MODULE_3__nls_js__["a" /* localize */]('editorFindMatch', "Color of the current search match."));
var editorFindMatchHighlight = registerColor('editor.findMatchHighlightBackground', { light: '#EA5C0055', dark: '#EA5C0055', hc: null }, __WEBPACK_IMPORTED_MODULE_3__nls_js__["a" /* localize */]('findMatchHighlight', "Color of the other search matches. The color must not be opaque so as not to hide underlying decorations."), true);
var editorFindRangeHighlight = registerColor('editor.findRangeHighlightBackground', { dark: '#3a3d4166', light: '#b4b4b44d', hc: null }, __WEBPACK_IMPORTED_MODULE_3__nls_js__["a" /* localize */]('findRangeHighlight', "Color of the range limiting the search. The color must not be opaque so as not to hide underlying decorations."), true);
var editorFindMatchBorder = registerColor('editor.findMatchBorder', { light: null, dark: null, hc: activeContrastBorder }, __WEBPACK_IMPORTED_MODULE_3__nls_js__["a" /* localize */]('editorFindMatchBorder', "Border color of the current search match."));
var editorFindMatchHighlightBorder = registerColor('editor.findMatchHighlightBorder', { light: null, dark: null, hc: activeContrastBorder }, __WEBPACK_IMPORTED_MODULE_3__nls_js__["a" /* localize */]('findMatchHighlightBorder', "Border color of the other search matches."));
var editorFindRangeHighlightBorder = registerColor('editor.findRangeHighlightBorder', { dark: null, light: null, hc: transparent(activeContrastBorder, 0.4) }, __WEBPACK_IMPORTED_MODULE_3__nls_js__["a" /* localize */]('findRangeHighlightBorder', "Border color of the range limiting the search. The color must not be opaque so as not to hide underlying decorations."), true);
/**
 * Editor hover
 */
var editorHoverHighlight = registerColor('editor.hoverHighlightBackground', { light: '#ADD6FF26', dark: '#264f7840', hc: '#ADD6FF26' }, __WEBPACK_IMPORTED_MODULE_3__nls_js__["a" /* localize */]('hoverHighlight', 'Highlight below the word for which a hover is shown. The color must not be opaque so as not to hide underlying decorations.'), true);
var editorHoverBackground = registerColor('editorHoverWidget.background', { light: editorWidgetBackground, dark: editorWidgetBackground, hc: editorWidgetBackground }, __WEBPACK_IMPORTED_MODULE_3__nls_js__["a" /* localize */]('hoverBackground', 'Background color of the editor hover.'));
var editorHoverForeground = registerColor('editorHoverWidget.foreground', { light: editorWidgetForeground, dark: editorWidgetForeground, hc: editorWidgetForeground }, __WEBPACK_IMPORTED_MODULE_3__nls_js__["a" /* localize */]('hoverForeground', 'Foreground color of the editor hover.'));
var editorHoverBorder = registerColor('editorHoverWidget.border', { light: editorWidgetBorder, dark: editorWidgetBorder, hc: editorWidgetBorder }, __WEBPACK_IMPORTED_MODULE_3__nls_js__["a" /* localize */]('hoverBorder', 'Border color of the editor hover.'));
var editorHoverStatusBarBackground = registerColor('editorHoverWidget.statusBarBackground', { dark: lighten(editorHoverBackground, 0.2), light: darken(editorHoverBackground, 0.05), hc: editorWidgetBackground }, __WEBPACK_IMPORTED_MODULE_3__nls_js__["a" /* localize */]('statusBarBackground', "Background color of the editor hover status bar."));
/**
 * Editor link colors
 */
var editorActiveLinkForeground = registerColor('editorLink.activeForeground', { dark: '#4E94CE', light: __WEBPACK_IMPORTED_MODULE_1__base_common_color_js__["a" /* Color */].blue, hc: __WEBPACK_IMPORTED_MODULE_1__base_common_color_js__["a" /* Color */].cyan }, __WEBPACK_IMPORTED_MODULE_3__nls_js__["a" /* localize */]('activeLinkForeground', 'Color of active links.'));
/**
 * Editor lighbulb icon colors
 */
var editorLightBulbForeground = registerColor('editorLightBulb.foreground', { dark: '#FFCC00', light: '#DDB100', hc: '#FFCC00' }, __WEBPACK_IMPORTED_MODULE_3__nls_js__["a" /* localize */]('editorLightBulbForeground', "The color used for the lightbulb actions icon."));
var editorLightBulbAutoFixForeground = registerColor('editorLightBulbAutoFix.foreground', { dark: '#75BEFF', light: '#007ACC', hc: '#75BEFF' }, __WEBPACK_IMPORTED_MODULE_3__nls_js__["a" /* localize */]('editorLightBulbAutoFixForeground', "The color used for the lightbulb auto fix actions icon."));
/**
 * Diff Editor Colors
 */
var defaultInsertColor = new __WEBPACK_IMPORTED_MODULE_1__base_common_color_js__["a" /* Color */](new __WEBPACK_IMPORTED_MODULE_1__base_common_color_js__["c" /* RGBA */](155, 185, 85, 0.2));
var defaultRemoveColor = new __WEBPACK_IMPORTED_MODULE_1__base_common_color_js__["a" /* Color */](new __WEBPACK_IMPORTED_MODULE_1__base_common_color_js__["c" /* RGBA */](255, 0, 0, 0.2));
var diffInserted = registerColor('diffEditor.insertedTextBackground', { dark: defaultInsertColor, light: defaultInsertColor, hc: null }, __WEBPACK_IMPORTED_MODULE_3__nls_js__["a" /* localize */]('diffEditorInserted', 'Background color for text that got inserted. The color must not be opaque so as not to hide underlying decorations.'), true);
var diffRemoved = registerColor('diffEditor.removedTextBackground', { dark: defaultRemoveColor, light: defaultRemoveColor, hc: null }, __WEBPACK_IMPORTED_MODULE_3__nls_js__["a" /* localize */]('diffEditorRemoved', 'Background color for text that got removed. The color must not be opaque so as not to hide underlying decorations.'), true);
var diffInsertedOutline = registerColor('diffEditor.insertedTextBorder', { dark: null, light: null, hc: '#33ff2eff' }, __WEBPACK_IMPORTED_MODULE_3__nls_js__["a" /* localize */]('diffEditorInsertedOutline', 'Outline color for the text that got inserted.'));
var diffRemovedOutline = registerColor('diffEditor.removedTextBorder', { dark: null, light: null, hc: '#FF008F' }, __WEBPACK_IMPORTED_MODULE_3__nls_js__["a" /* localize */]('diffEditorRemovedOutline', 'Outline color for text that got removed.'));
var diffBorder = registerColor('diffEditor.border', { dark: null, light: null, hc: contrastBorder }, __WEBPACK_IMPORTED_MODULE_3__nls_js__["a" /* localize */]('diffEditorBorder', 'Border color between the two text editors.'));
/**
 * List and tree colors
 */
var listFocusBackground = registerColor('list.focusBackground', { dark: '#062F4A', light: '#D6EBFF', hc: null }, __WEBPACK_IMPORTED_MODULE_3__nls_js__["a" /* localize */]('listFocusBackground', "List/Tree background color for the focused item when the list/tree is active. An active list/tree has keyboard focus, an inactive does not."));
var listFocusForeground = registerColor('list.focusForeground', { dark: null, light: null, hc: null }, __WEBPACK_IMPORTED_MODULE_3__nls_js__["a" /* localize */]('listFocusForeground', "List/Tree foreground color for the focused item when the list/tree is active. An active list/tree has keyboard focus, an inactive does not."));
var listActiveSelectionBackground = registerColor('list.activeSelectionBackground', { dark: '#094771', light: '#0074E8', hc: null }, __WEBPACK_IMPORTED_MODULE_3__nls_js__["a" /* localize */]('listActiveSelectionBackground', "List/Tree background color for the selected item when the list/tree is active. An active list/tree has keyboard focus, an inactive does not."));
var listActiveSelectionForeground = registerColor('list.activeSelectionForeground', { dark: __WEBPACK_IMPORTED_MODULE_1__base_common_color_js__["a" /* Color */].white, light: __WEBPACK_IMPORTED_MODULE_1__base_common_color_js__["a" /* Color */].white, hc: null }, __WEBPACK_IMPORTED_MODULE_3__nls_js__["a" /* localize */]('listActiveSelectionForeground', "List/Tree foreground color for the selected item when the list/tree is active. An active list/tree has keyboard focus, an inactive does not."));
var listInactiveSelectionBackground = registerColor('list.inactiveSelectionBackground', { dark: '#37373D', light: '#E4E6F1', hc: null }, __WEBPACK_IMPORTED_MODULE_3__nls_js__["a" /* localize */]('listInactiveSelectionBackground', "List/Tree background color for the selected item when the list/tree is inactive. An active list/tree has keyboard focus, an inactive does not."));
var listInactiveSelectionForeground = registerColor('list.inactiveSelectionForeground', { dark: null, light: null, hc: null }, __WEBPACK_IMPORTED_MODULE_3__nls_js__["a" /* localize */]('listInactiveSelectionForeground', "List/Tree foreground color for the selected item when the list/tree is inactive. An active list/tree has keyboard focus, an inactive does not."));
var listInactiveFocusBackground = registerColor('list.inactiveFocusBackground', { dark: null, light: null, hc: null }, __WEBPACK_IMPORTED_MODULE_3__nls_js__["a" /* localize */]('listInactiveFocusBackground', "List/Tree background color for the focused item when the list/tree is inactive. An active list/tree has keyboard focus, an inactive does not."));
var listHoverBackground = registerColor('list.hoverBackground', { dark: '#2A2D2E', light: '#F0F0F0', hc: null }, __WEBPACK_IMPORTED_MODULE_3__nls_js__["a" /* localize */]('listHoverBackground', "List/Tree background when hovering over items using the mouse."));
var listHoverForeground = registerColor('list.hoverForeground', { dark: null, light: null, hc: null }, __WEBPACK_IMPORTED_MODULE_3__nls_js__["a" /* localize */]('listHoverForeground', "List/Tree foreground when hovering over items using the mouse."));
var listDropBackground = registerColor('list.dropBackground', { dark: listFocusBackground, light: listFocusBackground, hc: null }, __WEBPACK_IMPORTED_MODULE_3__nls_js__["a" /* localize */]('listDropBackground', "List/Tree drag and drop background when moving items around using the mouse."));
var listHighlightForeground = registerColor('list.highlightForeground', { dark: '#0097fb', light: '#0066BF', hc: focusBorder }, __WEBPACK_IMPORTED_MODULE_3__nls_js__["a" /* localize */]('highlight', 'List/Tree foreground color of the match highlights when searching inside the list/tree.'));
var listFilterWidgetBackground = registerColor('listFilterWidget.background', { light: '#efc1ad', dark: '#653723', hc: __WEBPACK_IMPORTED_MODULE_1__base_common_color_js__["a" /* Color */].black }, __WEBPACK_IMPORTED_MODULE_3__nls_js__["a" /* localize */]('listFilterWidgetBackground', 'Background color of the type filter widget in lists and trees.'));
var listFilterWidgetOutline = registerColor('listFilterWidget.outline', { dark: __WEBPACK_IMPORTED_MODULE_1__base_common_color_js__["a" /* Color */].transparent, light: __WEBPACK_IMPORTED_MODULE_1__base_common_color_js__["a" /* Color */].transparent, hc: '#f38518' }, __WEBPACK_IMPORTED_MODULE_3__nls_js__["a" /* localize */]('listFilterWidgetOutline', 'Outline color of the type filter widget in lists and trees.'));
var listFilterWidgetNoMatchesOutline = registerColor('listFilterWidget.noMatchesOutline', { dark: '#BE1100', light: '#BE1100', hc: contrastBorder }, __WEBPACK_IMPORTED_MODULE_3__nls_js__["a" /* localize */]('listFilterWidgetNoMatchesOutline', 'Outline color of the type filter widget in lists and trees, when there are no matches.'));
var treeIndentGuidesStroke = registerColor('tree.indentGuidesStroke', { dark: '#585858', light: '#a9a9a9', hc: '#a9a9a9' }, __WEBPACK_IMPORTED_MODULE_3__nls_js__["a" /* localize */]('treeIndentGuidesStroke', "Tree stroke color for the indentation guides."));
/**
 * Menu colors
 */
var menuBorder = registerColor('menu.border', { dark: null, light: null, hc: contrastBorder }, __WEBPACK_IMPORTED_MODULE_3__nls_js__["a" /* localize */]('menuBorder', "Border color of menus."));
var menuForeground = registerColor('menu.foreground', { dark: selectForeground, light: foreground, hc: selectForeground }, __WEBPACK_IMPORTED_MODULE_3__nls_js__["a" /* localize */]('menuForeground', "Foreground color of menu items."));
var menuBackground = registerColor('menu.background', { dark: selectBackground, light: selectBackground, hc: selectBackground }, __WEBPACK_IMPORTED_MODULE_3__nls_js__["a" /* localize */]('menuBackground', "Background color of menu items."));
var menuSelectionForeground = registerColor('menu.selectionForeground', { dark: listActiveSelectionForeground, light: listActiveSelectionForeground, hc: listActiveSelectionForeground }, __WEBPACK_IMPORTED_MODULE_3__nls_js__["a" /* localize */]('menuSelectionForeground', "Foreground color of the selected menu item in menus."));
var menuSelectionBackground = registerColor('menu.selectionBackground', { dark: listActiveSelectionBackground, light: listActiveSelectionBackground, hc: listActiveSelectionBackground }, __WEBPACK_IMPORTED_MODULE_3__nls_js__["a" /* localize */]('menuSelectionBackground', "Background color of the selected menu item in menus."));
var menuSelectionBorder = registerColor('menu.selectionBorder', { dark: null, light: null, hc: activeContrastBorder }, __WEBPACK_IMPORTED_MODULE_3__nls_js__["a" /* localize */]('menuSelectionBorder', "Border color of the selected menu item in menus."));
var menuSeparatorBackground = registerColor('menu.separatorBackground', { dark: '#BBBBBB', light: '#888888', hc: contrastBorder }, __WEBPACK_IMPORTED_MODULE_3__nls_js__["a" /* localize */]('menuSeparatorBackground', "Color of a separator menu item in menus."));
/**
 * Snippet placeholder colors
 */
var snippetTabstopHighlightBackground = registerColor('editor.snippetTabstopHighlightBackground', { dark: new __WEBPACK_IMPORTED_MODULE_1__base_common_color_js__["a" /* Color */](new __WEBPACK_IMPORTED_MODULE_1__base_common_color_js__["c" /* RGBA */](124, 124, 124, 0.3)), light: new __WEBPACK_IMPORTED_MODULE_1__base_common_color_js__["a" /* Color */](new __WEBPACK_IMPORTED_MODULE_1__base_common_color_js__["c" /* RGBA */](10, 50, 100, 0.2)), hc: new __WEBPACK_IMPORTED_MODULE_1__base_common_color_js__["a" /* Color */](new __WEBPACK_IMPORTED_MODULE_1__base_common_color_js__["c" /* RGBA */](124, 124, 124, 0.3)) }, __WEBPACK_IMPORTED_MODULE_3__nls_js__["a" /* localize */]('snippetTabstopHighlightBackground', "Highlight background color of a snippet tabstop."));
var snippetTabstopHighlightBorder = registerColor('editor.snippetTabstopHighlightBorder', { dark: null, light: null, hc: null }, __WEBPACK_IMPORTED_MODULE_3__nls_js__["a" /* localize */]('snippetTabstopHighlightBorder', "Highlight border color of a snippet tabstop."));
var snippetFinalTabstopHighlightBackground = registerColor('editor.snippetFinalTabstopHighlightBackground', { dark: null, light: null, hc: null }, __WEBPACK_IMPORTED_MODULE_3__nls_js__["a" /* localize */]('snippetFinalTabstopHighlightBackground', "Highlight background color of the final tabstop of a snippet."));
var snippetFinalTabstopHighlightBorder = registerColor('editor.snippetFinalTabstopHighlightBorder', { dark: '#525252', light: new __WEBPACK_IMPORTED_MODULE_1__base_common_color_js__["a" /* Color */](new __WEBPACK_IMPORTED_MODULE_1__base_common_color_js__["c" /* RGBA */](10, 50, 100, 0.5)), hc: '#525252' }, __WEBPACK_IMPORTED_MODULE_3__nls_js__["a" /* localize */]('snippetFinalTabstopHighlightBorder', "Highlight border color of the final stabstop of a snippet."));
var overviewRulerFindMatchForeground = registerColor('editorOverviewRuler.findMatchForeground', { dark: '#d186167e', light: '#d186167e', hc: '#AB5A00' }, __WEBPACK_IMPORTED_MODULE_3__nls_js__["a" /* localize */]('overviewRulerFindMatchForeground', 'Overview ruler marker color for find matches. The color must not be opaque so as not to hide underlying decorations.'), true);
var overviewRulerSelectionHighlightForeground = registerColor('editorOverviewRuler.selectionHighlightForeground', { dark: '#A0A0A0CC', light: '#A0A0A0CC', hc: '#A0A0A0CC' }, __WEBPACK_IMPORTED_MODULE_3__nls_js__["a" /* localize */]('overviewRulerSelectionHighlightForeground', 'Overview ruler marker color for selection highlights. The color must not be opaque so as not to hide underlying decorations.'), true);
var minimapFindMatch = registerColor('minimap.findMatchHighlight', { light: '#d18616', dark: '#d18616', hc: '#AB5A00' }, __WEBPACK_IMPORTED_MODULE_3__nls_js__["a" /* localize */]('minimapFindMatchHighlight', 'Minimap marker color for find matches.'), true);
var minimapSelection = registerColor('minimap.selectionHighlight', { light: '#ADD6FF', dark: '#264F78', hc: '#ffffff' }, __WEBPACK_IMPORTED_MODULE_3__nls_js__["a" /* localize */]('minimapSelectionHighlight', 'Minimap marker color for the editor selection.'), true);
var minimapError = registerColor('minimap.errorHighlight', { dark: new __WEBPACK_IMPORTED_MODULE_1__base_common_color_js__["a" /* Color */](new __WEBPACK_IMPORTED_MODULE_1__base_common_color_js__["c" /* RGBA */](255, 18, 18, 0.7)), light: new __WEBPACK_IMPORTED_MODULE_1__base_common_color_js__["a" /* Color */](new __WEBPACK_IMPORTED_MODULE_1__base_common_color_js__["c" /* RGBA */](255, 18, 18, 0.7)), hc: new __WEBPACK_IMPORTED_MODULE_1__base_common_color_js__["a" /* Color */](new __WEBPACK_IMPORTED_MODULE_1__base_common_color_js__["c" /* RGBA */](255, 50, 50, 1)) }, __WEBPACK_IMPORTED_MODULE_3__nls_js__["a" /* localize */]('minimapError', 'Minimap marker color for errors.'));
var minimapWarning = registerColor('minimap.warningHighlight', { dark: editorWarningForeground, light: editorWarningForeground, hc: editorWarningBorder }, __WEBPACK_IMPORTED_MODULE_3__nls_js__["a" /* localize */]('overviewRuleWarning', 'Minimap marker color for warnings.'));
var problemsErrorIconForeground = registerColor('problemsErrorIcon.foreground', { dark: editorErrorForeground, light: editorErrorForeground, hc: editorErrorForeground }, __WEBPACK_IMPORTED_MODULE_3__nls_js__["a" /* localize */]('problemsErrorIconForeground', "The color used for the problems error icon."));
var problemsWarningIconForeground = registerColor('problemsWarningIcon.foreground', { dark: editorWarningForeground, light: editorWarningForeground, hc: editorWarningForeground }, __WEBPACK_IMPORTED_MODULE_3__nls_js__["a" /* localize */]('problemsWarningIconForeground', "The color used for the problems warning icon."));
var problemsInfoIconForeground = registerColor('problemsInfoIcon.foreground', { dark: editorInfoForeground, light: editorInfoForeground, hc: editorInfoForeground }, __WEBPACK_IMPORTED_MODULE_3__nls_js__["a" /* localize */]('problemsInfoIconForeground', "The color used for the problems info icon."));
// ----- color functions
function darken(colorValue, factor) {
    return function (theme) {
        var color = resolveColorValue(colorValue, theme);
        if (color) {
            return color.darken(factor);
        }
        return undefined;
    };
}
function lighten(colorValue, factor) {
    return function (theme) {
        var color = resolveColorValue(colorValue, theme);
        if (color) {
            return color.lighten(factor);
        }
        return undefined;
    };
}
function transparent(colorValue, factor) {
    return function (theme) {
        var color = resolveColorValue(colorValue, theme);
        if (color) {
            return color.transparent(factor);
        }
        return undefined;
    };
}
function oneOf() {
    var colorValues = [];
    for (var _i = 0; _i < arguments.length; _i++) {
        colorValues[_i] = arguments[_i];
    }
    return function (theme) {
        for (var _i = 0, colorValues_1 = colorValues; _i < colorValues_1.length; _i++) {
            var colorValue = colorValues_1[_i];
            var color = resolveColorValue(colorValue, theme);
            if (color) {
                return color;
            }
        }
        return undefined;
    };
}
function lessProminent(colorValue, backgroundColorValue, factor, transparency) {
    return function (theme) {
        var from = resolveColorValue(colorValue, theme);
        if (from) {
            var backgroundColor = resolveColorValue(backgroundColorValue, theme);
            if (backgroundColor) {
                if (from.isDarkerThan(backgroundColor)) {
                    return __WEBPACK_IMPORTED_MODULE_1__base_common_color_js__["a" /* Color */].getLighterColor(from, backgroundColor, factor).transparent(transparency);
                }
                return __WEBPACK_IMPORTED_MODULE_1__base_common_color_js__["a" /* Color */].getDarkerColor(from, backgroundColor, factor).transparent(transparency);
            }
            return from.transparent(factor * transparency);
        }
        return undefined;
    };
}
// ----- implementation
/**
 * @param colorValue Resolve a color value in the context of a theme
 */
function resolveColorValue(colorValue, theme) {
    if (colorValue === null) {
        return undefined;
    }
    else if (typeof colorValue === 'string') {
        if (colorValue[0] === '#') {
            return __WEBPACK_IMPORTED_MODULE_1__base_common_color_js__["a" /* Color */].fromHex(colorValue);
        }
        return theme.getColor(colorValue);
    }
    else if (colorValue instanceof __WEBPACK_IMPORTED_MODULE_1__base_common_color_js__["a" /* Color */]) {
        return colorValue;
    }
    else if (typeof colorValue === 'function') {
        return colorValue(theme);
    }
    return undefined;
}
var workbenchColorsSchemaId = 'vscode://schemas/workbench-colors';
var schemaRegistry = __WEBPACK_IMPORTED_MODULE_0__registry_common_platform_js__["a" /* Registry */].as(__WEBPACK_IMPORTED_MODULE_4__jsonschemas_common_jsonContributionRegistry_js__["a" /* Extensions */].JSONContribution);
schemaRegistry.registerSchema(workbenchColorsSchemaId, colorRegistry.getColorSchema());
var delayer = new __WEBPACK_IMPORTED_MODULE_5__base_common_async_js__["d" /* RunOnceScheduler */](function () { return schemaRegistry.notifySchemaChanged(workbenchColorsSchemaId); }, 200);
colorRegistry.onDidChangeSchema(function () {
    if (!delayer.isScheduled()) {
        delayer.schedule();
    }
});
// setTimeout(_ => console.log(colorRegistry.toString()), 5000);


/***/ }),
/* 20 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (immutable) */ __webpack_exports__["d"] = isArray;
/* harmony export (immutable) */ __webpack_exports__["j"] = isString;
/* harmony export (immutable) */ __webpack_exports__["i"] = isObject;
/* harmony export (immutable) */ __webpack_exports__["h"] = isNumber;
/* harmony export (immutable) */ __webpack_exports__["e"] = isBoolean;
/* harmony export (immutable) */ __webpack_exports__["k"] = isUndefined;
/* harmony export (immutable) */ __webpack_exports__["l"] = isUndefinedOrNull;
/* harmony export (immutable) */ __webpack_exports__["a"] = assertType;
/* harmony export (immutable) */ __webpack_exports__["f"] = isEmptyObject;
/* harmony export (immutable) */ __webpack_exports__["g"] = isFunction;
/* harmony export (immutable) */ __webpack_exports__["m"] = validateConstraints;
/* unused harmony export validateConstraint */
/* unused harmony export getAllPropertyNames */
/* harmony export (immutable) */ __webpack_exports__["c"] = getAllMethodNames;
/* harmony export (immutable) */ __webpack_exports__["b"] = createProxyObject;
/* harmony export (immutable) */ __webpack_exports__["n"] = withNullAsUndefined;
/* harmony export (immutable) */ __webpack_exports__["o"] = withUndefinedAsNull;
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var _typeof = {
    number: 'number',
    string: 'string',
    undefined: 'undefined',
    object: 'object',
    function: 'function'
};
/**
 * @returns whether the provided parameter is a JavaScript Array or not.
 */
function isArray(array) {
    if (Array.isArray) {
        return Array.isArray(array);
    }
    if (array && typeof (array.length) === _typeof.number && array.constructor === Array) {
        return true;
    }
    return false;
}
/**
 * @returns whether the provided parameter is a JavaScript String or not.
 */
function isString(str) {
    if (typeof (str) === _typeof.string || str instanceof String) {
        return true;
    }
    return false;
}
/**
 *
 * @returns whether the provided parameter is of type `object` but **not**
 *	`null`, an `array`, a `regexp`, nor a `date`.
 */
function isObject(obj) {
    // The method can't do a type cast since there are type (like strings) which
    // are subclasses of any put not positvely matched by the function. Hence type
    // narrowing results in wrong results.
    return typeof obj === _typeof.object
        && obj !== null
        && !Array.isArray(obj)
        && !(obj instanceof RegExp)
        && !(obj instanceof Date);
}
/**
 * In **contrast** to just checking `typeof` this will return `false` for `NaN`.
 * @returns whether the provided parameter is a JavaScript Number or not.
 */
function isNumber(obj) {
    if ((typeof (obj) === _typeof.number || obj instanceof Number) && !isNaN(obj)) {
        return true;
    }
    return false;
}
/**
 * @returns whether the provided parameter is a JavaScript Boolean or not.
 */
function isBoolean(obj) {
    return obj === true || obj === false;
}
/**
 * @returns whether the provided parameter is undefined.
 */
function isUndefined(obj) {
    return typeof (obj) === _typeof.undefined;
}
/**
 * @returns whether the provided parameter is undefined or null.
 */
function isUndefinedOrNull(obj) {
    return isUndefined(obj) || obj === null;
}
function assertType(condition, type) {
    if (!condition) {
        throw new Error(type ? "Unexpected type, expected '" + type + "'" : 'Unexpected type');
    }
}
var hasOwnProperty = Object.prototype.hasOwnProperty;
/**
 * @returns whether the provided parameter is an empty JavaScript Object or not.
 */
function isEmptyObject(obj) {
    if (!isObject(obj)) {
        return false;
    }
    for (var key in obj) {
        if (hasOwnProperty.call(obj, key)) {
            return false;
        }
    }
    return true;
}
/**
 * @returns whether the provided parameter is a JavaScript Function or not.
 */
function isFunction(obj) {
    return typeof obj === _typeof.function;
}
function validateConstraints(args, constraints) {
    var len = Math.min(args.length, constraints.length);
    for (var i = 0; i < len; i++) {
        validateConstraint(args[i], constraints[i]);
    }
}
function validateConstraint(arg, constraint) {
    if (isString(constraint)) {
        if (typeof arg !== constraint) {
            throw new Error("argument does not match constraint: typeof " + constraint);
        }
    }
    else if (isFunction(constraint)) {
        try {
            if (arg instanceof constraint) {
                return;
            }
        }
        catch (_a) {
            // ignore
        }
        if (!isUndefinedOrNull(arg) && arg.constructor === constraint) {
            return;
        }
        if (constraint.length === 1 && constraint.call(undefined, arg) === true) {
            return;
        }
        throw new Error("argument does not match one of these constraints: arg instanceof constraint, arg.constructor === constraint, nor constraint(arg) === true");
    }
}
function getAllPropertyNames(obj) {
    var res = [];
    var proto = Object.getPrototypeOf(obj);
    while (Object.prototype !== proto) {
        res = res.concat(Object.getOwnPropertyNames(proto));
        proto = Object.getPrototypeOf(proto);
    }
    return res;
}
function getAllMethodNames(obj) {
    var methods = [];
    for (var _i = 0, _a = getAllPropertyNames(obj); _i < _a.length; _i++) {
        var prop = _a[_i];
        if (typeof obj[prop] === 'function') {
            methods.push(prop);
        }
    }
    return methods;
}
function createProxyObject(methodNames, invoke) {
    var createProxyMethod = function (method) {
        return function () {
            var args = Array.prototype.slice.call(arguments, 0);
            return invoke(method, args);
        };
    };
    var result = {};
    for (var _i = 0, methodNames_1 = methodNames; _i < methodNames_1.length; _i++) {
        var methodName = methodNames_1[_i];
        result[methodName] = createProxyMethod(methodName);
    }
    return result;
}
/**
 * Converts null to undefined, passes all other values through.
 */
function withNullAsUndefined(x) {
    return x === null ? undefined : x;
}
/**
 * Converts undefined to null, passes all other values through.
 */
function withUndefinedAsNull(x) {
    return typeof x === 'undefined' ? null : x;
}


/***/ }),
/* 21 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return Selection; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__position_js__ = __webpack_require__(12);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__range_js__ = __webpack_require__(1);
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();


/**
 * A selection in the editor.
 * The selection is a range that has an orientation.
 */
var Selection = /** @class */ (function (_super) {
    __extends(Selection, _super);
    function Selection(selectionStartLineNumber, selectionStartColumn, positionLineNumber, positionColumn) {
        var _this = _super.call(this, selectionStartLineNumber, selectionStartColumn, positionLineNumber, positionColumn) || this;
        _this.selectionStartLineNumber = selectionStartLineNumber;
        _this.selectionStartColumn = selectionStartColumn;
        _this.positionLineNumber = positionLineNumber;
        _this.positionColumn = positionColumn;
        return _this;
    }
    /**
     * Transform to a human-readable representation.
     */
    Selection.prototype.toString = function () {
        return '[' + this.selectionStartLineNumber + ',' + this.selectionStartColumn + ' -> ' + this.positionLineNumber + ',' + this.positionColumn + ']';
    };
    /**
     * Test if equals other selection.
     */
    Selection.prototype.equalsSelection = function (other) {
        return (Selection.selectionsEqual(this, other));
    };
    /**
     * Test if the two selections are equal.
     */
    Selection.selectionsEqual = function (a, b) {
        return (a.selectionStartLineNumber === b.selectionStartLineNumber &&
            a.selectionStartColumn === b.selectionStartColumn &&
            a.positionLineNumber === b.positionLineNumber &&
            a.positionColumn === b.positionColumn);
    };
    /**
     * Get directions (LTR or RTL).
     */
    Selection.prototype.getDirection = function () {
        if (this.selectionStartLineNumber === this.startLineNumber && this.selectionStartColumn === this.startColumn) {
            return 0 /* LTR */;
        }
        return 1 /* RTL */;
    };
    /**
     * Create a new selection with a different `positionLineNumber` and `positionColumn`.
     */
    Selection.prototype.setEndPosition = function (endLineNumber, endColumn) {
        if (this.getDirection() === 0 /* LTR */) {
            return new Selection(this.startLineNumber, this.startColumn, endLineNumber, endColumn);
        }
        return new Selection(endLineNumber, endColumn, this.startLineNumber, this.startColumn);
    };
    /**
     * Get the position at `positionLineNumber` and `positionColumn`.
     */
    Selection.prototype.getPosition = function () {
        return new __WEBPACK_IMPORTED_MODULE_0__position_js__["a" /* Position */](this.positionLineNumber, this.positionColumn);
    };
    /**
     * Create a new selection with a different `selectionStartLineNumber` and `selectionStartColumn`.
     */
    Selection.prototype.setStartPosition = function (startLineNumber, startColumn) {
        if (this.getDirection() === 0 /* LTR */) {
            return new Selection(startLineNumber, startColumn, this.endLineNumber, this.endColumn);
        }
        return new Selection(this.endLineNumber, this.endColumn, startLineNumber, startColumn);
    };
    // ----
    /**
     * Create a `Selection` from one or two positions
     */
    Selection.fromPositions = function (start, end) {
        if (end === void 0) { end = start; }
        return new Selection(start.lineNumber, start.column, end.lineNumber, end.column);
    };
    /**
     * Create a `Selection` from an `ISelection`.
     */
    Selection.liftSelection = function (sel) {
        return new Selection(sel.selectionStartLineNumber, sel.selectionStartColumn, sel.positionLineNumber, sel.positionColumn);
    };
    /**
     * `a` equals `b`.
     */
    Selection.selectionsArrEqual = function (a, b) {
        if (a && !b || !a && b) {
            return false;
        }
        if (!a && !b) {
            return true;
        }
        if (a.length !== b.length) {
            return false;
        }
        for (var i = 0, len = a.length; i < len; i++) {
            if (!this.selectionsEqual(a[i], b[i])) {
                return false;
            }
        }
        return true;
    };
    /**
     * Test if `obj` is an `ISelection`.
     */
    Selection.isISelection = function (obj) {
        return (obj
            && (typeof obj.selectionStartLineNumber === 'number')
            && (typeof obj.selectionStartColumn === 'number')
            && (typeof obj.positionLineNumber === 'number')
            && (typeof obj.positionColumn === 'number'));
    };
    /**
     * Create with a direction.
     */
    Selection.createWithDirection = function (startLineNumber, startColumn, endLineNumber, endColumn, direction) {
        if (direction === 0 /* LTR */) {
            return new Selection(startLineNumber, startColumn, endLineNumber, endColumn);
        }
        return new Selection(endLineNumber, endColumn, startLineNumber, startColumn);
    };
    return Selection;
}(__WEBPACK_IMPORTED_MODULE_1__range_js__["a" /* Range */]));



/***/ }),
/* 22 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return EditorContextKeys; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__platform_contextkey_common_contextkey_js__ = __webpack_require__(17);
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/

var EditorContextKeys;
(function (EditorContextKeys) {
    EditorContextKeys.editorSimpleInput = new __WEBPACK_IMPORTED_MODULE_0__platform_contextkey_common_contextkey_js__["d" /* RawContextKey */]('editorSimpleInput', false);
    /**
     * A context key that is set when the editor's text has focus (cursor is blinking).
     */
    EditorContextKeys.editorTextFocus = new __WEBPACK_IMPORTED_MODULE_0__platform_contextkey_common_contextkey_js__["d" /* RawContextKey */]('editorTextFocus', false);
    /**
     * A context key that is set when the editor's text or an editor's widget has focus.
     */
    EditorContextKeys.focus = new __WEBPACK_IMPORTED_MODULE_0__platform_contextkey_common_contextkey_js__["d" /* RawContextKey */]('editorFocus', false);
    /**
     * A context key that is set when any editor input has focus (regular editor, repl input...).
     */
    EditorContextKeys.textInputFocus = new __WEBPACK_IMPORTED_MODULE_0__platform_contextkey_common_contextkey_js__["d" /* RawContextKey */]('textInputFocus', false);
    EditorContextKeys.readOnly = new __WEBPACK_IMPORTED_MODULE_0__platform_contextkey_common_contextkey_js__["d" /* RawContextKey */]('editorReadonly', false);
    EditorContextKeys.writable = EditorContextKeys.readOnly.toNegated();
    EditorContextKeys.hasNonEmptySelection = new __WEBPACK_IMPORTED_MODULE_0__platform_contextkey_common_contextkey_js__["d" /* RawContextKey */]('editorHasSelection', false);
    EditorContextKeys.hasOnlyEmptySelection = EditorContextKeys.hasNonEmptySelection.toNegated();
    EditorContextKeys.hasMultipleSelections = new __WEBPACK_IMPORTED_MODULE_0__platform_contextkey_common_contextkey_js__["d" /* RawContextKey */]('editorHasMultipleSelections', false);
    EditorContextKeys.hasSingleSelection = EditorContextKeys.hasMultipleSelections.toNegated();
    EditorContextKeys.tabMovesFocus = new __WEBPACK_IMPORTED_MODULE_0__platform_contextkey_common_contextkey_js__["d" /* RawContextKey */]('editorTabMovesFocus', false);
    EditorContextKeys.tabDoesNotMoveFocus = EditorContextKeys.tabMovesFocus.toNegated();
    EditorContextKeys.isInEmbeddedEditor = new __WEBPACK_IMPORTED_MODULE_0__platform_contextkey_common_contextkey_js__["d" /* RawContextKey */]('isInEmbeddedEditor', false);
    EditorContextKeys.canUndo = new __WEBPACK_IMPORTED_MODULE_0__platform_contextkey_common_contextkey_js__["d" /* RawContextKey */]('canUndo', false);
    EditorContextKeys.canRedo = new __WEBPACK_IMPORTED_MODULE_0__platform_contextkey_common_contextkey_js__["d" /* RawContextKey */]('canRedo', false);
    // -- mode context keys
    EditorContextKeys.languageId = new __WEBPACK_IMPORTED_MODULE_0__platform_contextkey_common_contextkey_js__["d" /* RawContextKey */]('editorLangId', '');
    EditorContextKeys.hasCompletionItemProvider = new __WEBPACK_IMPORTED_MODULE_0__platform_contextkey_common_contextkey_js__["d" /* RawContextKey */]('editorHasCompletionItemProvider', false);
    EditorContextKeys.hasCodeActionsProvider = new __WEBPACK_IMPORTED_MODULE_0__platform_contextkey_common_contextkey_js__["d" /* RawContextKey */]('editorHasCodeActionsProvider', false);
    EditorContextKeys.hasCodeLensProvider = new __WEBPACK_IMPORTED_MODULE_0__platform_contextkey_common_contextkey_js__["d" /* RawContextKey */]('editorHasCodeLensProvider', false);
    EditorContextKeys.hasDefinitionProvider = new __WEBPACK_IMPORTED_MODULE_0__platform_contextkey_common_contextkey_js__["d" /* RawContextKey */]('editorHasDefinitionProvider', false);
    EditorContextKeys.hasDeclarationProvider = new __WEBPACK_IMPORTED_MODULE_0__platform_contextkey_common_contextkey_js__["d" /* RawContextKey */]('editorHasDeclarationProvider', false);
    EditorContextKeys.hasImplementationProvider = new __WEBPACK_IMPORTED_MODULE_0__platform_contextkey_common_contextkey_js__["d" /* RawContextKey */]('editorHasImplementationProvider', false);
    EditorContextKeys.hasTypeDefinitionProvider = new __WEBPACK_IMPORTED_MODULE_0__platform_contextkey_common_contextkey_js__["d" /* RawContextKey */]('editorHasTypeDefinitionProvider', false);
    EditorContextKeys.hasHoverProvider = new __WEBPACK_IMPORTED_MODULE_0__platform_contextkey_common_contextkey_js__["d" /* RawContextKey */]('editorHasHoverProvider', false);
    EditorContextKeys.hasDocumentHighlightProvider = new __WEBPACK_IMPORTED_MODULE_0__platform_contextkey_common_contextkey_js__["d" /* RawContextKey */]('editorHasDocumentHighlightProvider', false);
    EditorContextKeys.hasDocumentSymbolProvider = new __WEBPACK_IMPORTED_MODULE_0__platform_contextkey_common_contextkey_js__["d" /* RawContextKey */]('editorHasDocumentSymbolProvider', false);
    EditorContextKeys.hasReferenceProvider = new __WEBPACK_IMPORTED_MODULE_0__platform_contextkey_common_contextkey_js__["d" /* RawContextKey */]('editorHasReferenceProvider', false);
    EditorContextKeys.hasRenameProvider = new __WEBPACK_IMPORTED_MODULE_0__platform_contextkey_common_contextkey_js__["d" /* RawContextKey */]('editorHasRenameProvider', false);
    EditorContextKeys.hasSignatureHelpProvider = new __WEBPACK_IMPORTED_MODULE_0__platform_contextkey_common_contextkey_js__["d" /* RawContextKey */]('editorHasSignatureHelpProvider', false);
    // -- mode context keys: formatting
    EditorContextKeys.hasDocumentFormattingProvider = new __WEBPACK_IMPORTED_MODULE_0__platform_contextkey_common_contextkey_js__["d" /* RawContextKey */]('editorHasDocumentFormattingProvider', false);
    EditorContextKeys.hasDocumentSelectionFormattingProvider = new __WEBPACK_IMPORTED_MODULE_0__platform_contextkey_common_contextkey_js__["d" /* RawContextKey */]('editorHasDocumentSelectionFormattingProvider', false);
    EditorContextKeys.hasMultipleDocumentFormattingProvider = new __WEBPACK_IMPORTED_MODULE_0__platform_contextkey_common_contextkey_js__["d" /* RawContextKey */]('editorHasMultipleDocumentFormattingProvider', false);
    EditorContextKeys.hasMultipleDocumentSelectionFormattingProvider = new __WEBPACK_IMPORTED_MODULE_0__platform_contextkey_common_contextkey_js__["d" /* RawContextKey */]('editorHasMultipleDocumentSelectionFormattingProvider', false);
})(EditorContextKeys || (EditorContextKeys = {}));


/***/ }),
/* 23 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (immutable) */ __webpack_exports__["c"] = getZoomLevel;
/* harmony export (immutable) */ __webpack_exports__["b"] = getTimeSinceLastZoomLevelChanged;
/* harmony export (immutable) */ __webpack_exports__["o"] = onDidChangeZoomLevel;
/* harmony export (immutable) */ __webpack_exports__["a"] = getPixelRatio;
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "i", function() { return isIE; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "e", function() { return isEdge; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "f", function() { return isEdgeOrIE; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "h", function() { return isFirefox; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "m", function() { return isWebKit; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "d", function() { return isChrome; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "k", function() { return isSafari; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "n", function() { return isWebkitWebView; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "j", function() { return isIPad; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "g", function() { return isEdgeWebView; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "l", function() { return isStandalone; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__common_event_js__ = __webpack_require__(2);
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/

var WindowManager = /** @class */ (function () {
    function WindowManager() {
        // --- Zoom Level
        this._zoomLevel = 0;
        this._lastZoomLevelChangeTime = 0;
        this._onDidChangeZoomLevel = new __WEBPACK_IMPORTED_MODULE_0__common_event_js__["a" /* Emitter */]();
        this.onDidChangeZoomLevel = this._onDidChangeZoomLevel.event;
    }
    WindowManager.prototype.getZoomLevel = function () {
        return this._zoomLevel;
    };
    WindowManager.prototype.getTimeSinceLastZoomLevelChanged = function () {
        return Date.now() - this._lastZoomLevelChangeTime;
    };
    // --- Pixel Ratio
    WindowManager.prototype.getPixelRatio = function () {
        var ctx = document.createElement('canvas').getContext('2d');
        var dpr = window.devicePixelRatio || 1;
        var bsr = ctx.webkitBackingStorePixelRatio ||
            ctx.mozBackingStorePixelRatio ||
            ctx.msBackingStorePixelRatio ||
            ctx.oBackingStorePixelRatio ||
            ctx.backingStorePixelRatio || 1;
        return dpr / bsr;
    };
    WindowManager.INSTANCE = new WindowManager();
    return WindowManager;
}());
function getZoomLevel() {
    return WindowManager.INSTANCE.getZoomLevel();
}
/** Returns the time (in ms) since the zoom level was changed */
function getTimeSinceLastZoomLevelChanged() {
    return WindowManager.INSTANCE.getTimeSinceLastZoomLevelChanged();
}
function onDidChangeZoomLevel(callback) {
    return WindowManager.INSTANCE.onDidChangeZoomLevel(callback);
}
function getPixelRatio() {
    return WindowManager.INSTANCE.getPixelRatio();
}
var userAgent = navigator.userAgent;
var isIE = (userAgent.indexOf('Trident') >= 0);
var isEdge = (userAgent.indexOf('Edge/') >= 0);
var isEdgeOrIE = isIE || isEdge;
var isFirefox = (userAgent.indexOf('Firefox') >= 0);
var isWebKit = (userAgent.indexOf('AppleWebKit') >= 0);
var isChrome = (userAgent.indexOf('Chrome') >= 0);
var isSafari = (!isChrome && (userAgent.indexOf('Safari') >= 0));
var isWebkitWebView = (!isChrome && !isSafari && isWebKit);
var isIPad = (userAgent.indexOf('iPad') >= 0 || (isSafari && navigator.maxTouchPoints > 0));
var isEdgeWebView = isEdge && (userAgent.indexOf('WebView/') >= 0);
var isStandalone = (window.matchMedia && window.matchMedia('(display-mode: standalone)').matches);


/***/ }),
/* 24 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return URI; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__platform_js__ = __webpack_require__(14);
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var _a;

var _schemePattern = /^\w[\w\d+.-]*$/;
var _singleSlashStart = /^\//;
var _doubleSlashStart = /^\/\//;
function _validateUri(ret, _strict) {
    // scheme, must be set
    if (!ret.scheme && _strict) {
        throw new Error("[UriError]: Scheme is missing: {scheme: \"\", authority: \"" + ret.authority + "\", path: \"" + ret.path + "\", query: \"" + ret.query + "\", fragment: \"" + ret.fragment + "\"}");
    }
    // scheme, https://tools.ietf.org/html/rfc3986#section-3.1
    // ALPHA *( ALPHA / DIGIT / "+" / "-" / "." )
    if (ret.scheme && !_schemePattern.test(ret.scheme)) {
        throw new Error('[UriError]: Scheme contains illegal characters.');
    }
    // path, http://tools.ietf.org/html/rfc3986#section-3.3
    // If a URI contains an authority component, then the path component
    // must either be empty or begin with a slash ("/") character.  If a URI
    // does not contain an authority component, then the path cannot begin
    // with two slash characters ("//").
    if (ret.path) {
        if (ret.authority) {
            if (!_singleSlashStart.test(ret.path)) {
                throw new Error('[UriError]: If a URI contains an authority component, then the path component must either be empty or begin with a slash ("/") character');
            }
        }
        else {
            if (_doubleSlashStart.test(ret.path)) {
                throw new Error('[UriError]: If a URI does not contain an authority component, then the path cannot begin with two slash characters ("//")');
            }
        }
    }
}
// for a while we allowed uris *without* schemes and this is the migration
// for them, e.g. an uri without scheme and without strict-mode warns and falls
// back to the file-scheme. that should cause the least carnage and still be a
// clear warning
function _schemeFix(scheme, _strict) {
    if (!scheme && !_strict) {
        return 'file';
    }
    return scheme;
}
// implements a bit of https://tools.ietf.org/html/rfc3986#section-5
function _referenceResolution(scheme, path) {
    // the slash-character is our 'default base' as we don't
    // support constructing URIs relative to other URIs. This
    // also means that we alter and potentially break paths.
    // see https://tools.ietf.org/html/rfc3986#section-5.1.4
    switch (scheme) {
        case 'https':
        case 'http':
        case 'file':
            if (!path) {
                path = _slash;
            }
            else if (path[0] !== _slash) {
                path = _slash + path;
            }
            break;
    }
    return path;
}
var _empty = '';
var _slash = '/';
var _regexp = /^(([^:/?#]+?):)?(\/\/([^/?#]*))?([^?#]*)(\?([^#]*))?(#(.*))?/;
/**
 * Uniform Resource Identifier (URI) http://tools.ietf.org/html/rfc3986.
 * This class is a simple parser which creates the basic component parts
 * (http://tools.ietf.org/html/rfc3986#section-3) with minimal validation
 * and encoding.
 *
 *       foo://example.com:8042/over/there?name=ferret#nose
 *       \_/   \______________/\_________/ \_________/ \__/
 *        |           |            |            |        |
 *     scheme     authority       path        query   fragment
 *        |   _____________________|__
 *       / \ /                        \
 *       urn:example:animal:ferret:nose
 */
var URI = /** @class */ (function () {
    /**
     * @internal
     */
    function URI(schemeOrData, authority, path, query, fragment, _strict) {
        if (_strict === void 0) { _strict = false; }
        if (typeof schemeOrData === 'object') {
            this.scheme = schemeOrData.scheme || _empty;
            this.authority = schemeOrData.authority || _empty;
            this.path = schemeOrData.path || _empty;
            this.query = schemeOrData.query || _empty;
            this.fragment = schemeOrData.fragment || _empty;
            // no validation because it's this URI
            // that creates uri components.
            // _validateUri(this);
        }
        else {
            this.scheme = _schemeFix(schemeOrData, _strict);
            this.authority = authority || _empty;
            this.path = _referenceResolution(this.scheme, path || _empty);
            this.query = query || _empty;
            this.fragment = fragment || _empty;
            _validateUri(this, _strict);
        }
    }
    URI.isUri = function (thing) {
        if (thing instanceof URI) {
            return true;
        }
        if (!thing) {
            return false;
        }
        return typeof thing.authority === 'string'
            && typeof thing.fragment === 'string'
            && typeof thing.path === 'string'
            && typeof thing.query === 'string'
            && typeof thing.scheme === 'string'
            && typeof thing.fsPath === 'function'
            && typeof thing.with === 'function'
            && typeof thing.toString === 'function';
    };
    Object.defineProperty(URI.prototype, "fsPath", {
        // ---- filesystem path -----------------------
        /**
         * Returns a string representing the corresponding file system path of this URI.
         * Will handle UNC paths, normalizes windows drive letters to lower-case, and uses the
         * platform specific path separator.
         *
         * * Will *not* validate the path for invalid characters and semantics.
         * * Will *not* look at the scheme of this URI.
         * * The result shall *not* be used for display purposes but for accessing a file on disk.
         *
         *
         * The *difference* to `URI#path` is the use of the platform specific separator and the handling
         * of UNC paths. See the below sample of a file-uri with an authority (UNC path).
         *
         * ```ts
            const u = URI.parse('file://server/c$/folder/file.txt')
            u.authority === 'server'
            u.path === '/shares/c$/file.txt'
            u.fsPath === '\\server\c$\folder\file.txt'
        ```
         *
         * Using `URI#path` to read a file (using fs-apis) would not be enough because parts of the path,
         * namely the server name, would be missing. Therefore `URI#fsPath` exists - it's sugar to ease working
         * with URIs that represent files on disk (`file` scheme).
         */
        get: function () {
            // if (this.scheme !== 'file') {
            // 	console.warn(`[UriError] calling fsPath with scheme ${this.scheme}`);
            // }
            return _makeFsPath(this);
        },
        enumerable: true,
        configurable: true
    });
    // ---- modify to new -------------------------
    URI.prototype.with = function (change) {
        if (!change) {
            return this;
        }
        var scheme = change.scheme, authority = change.authority, path = change.path, query = change.query, fragment = change.fragment;
        if (scheme === undefined) {
            scheme = this.scheme;
        }
        else if (scheme === null) {
            scheme = _empty;
        }
        if (authority === undefined) {
            authority = this.authority;
        }
        else if (authority === null) {
            authority = _empty;
        }
        if (path === undefined) {
            path = this.path;
        }
        else if (path === null) {
            path = _empty;
        }
        if (query === undefined) {
            query = this.query;
        }
        else if (query === null) {
            query = _empty;
        }
        if (fragment === undefined) {
            fragment = this.fragment;
        }
        else if (fragment === null) {
            fragment = _empty;
        }
        if (scheme === this.scheme
            && authority === this.authority
            && path === this.path
            && query === this.query
            && fragment === this.fragment) {
            return this;
        }
        return new _URI(scheme, authority, path, query, fragment);
    };
    // ---- parse & validate ------------------------
    /**
     * Creates a new URI from a string, e.g. `http://www.msft.com/some/path`,
     * `file:///usr/home`, or `scheme:with/path`.
     *
     * @param value A string which represents an URI (see `URI#toString`).
     */
    URI.parse = function (value, _strict) {
        if (_strict === void 0) { _strict = false; }
        var match = _regexp.exec(value);
        if (!match) {
            return new _URI(_empty, _empty, _empty, _empty, _empty);
        }
        return new _URI(match[2] || _empty, percentDecode(match[4] || _empty), percentDecode(match[5] || _empty), percentDecode(match[7] || _empty), percentDecode(match[9] || _empty), _strict);
    };
    /**
     * Creates a new URI from a file system path, e.g. `c:\my\files`,
     * `/usr/home`, or `\\server\share\some\path`.
     *
     * The *difference* between `URI#parse` and `URI#file` is that the latter treats the argument
     * as path, not as stringified-uri. E.g. `URI.file(path)` is **not the same as**
     * `URI.parse('file://' + path)` because the path might contain characters that are
     * interpreted (# and ?). See the following sample:
     * ```ts
    const good = URI.file('/coding/c#/project1');
    good.scheme === 'file';
    good.path === '/coding/c#/project1';
    good.fragment === '';
    const bad = URI.parse('file://' + '/coding/c#/project1');
    bad.scheme === 'file';
    bad.path === '/coding/c'; // path is now broken
    bad.fragment === '/project1';
    ```
     *
     * @param path A file system path (see `URI#fsPath`)
     */
    URI.file = function (path) {
        var authority = _empty;
        // normalize to fwd-slashes on windows,
        // on other systems bwd-slashes are valid
        // filename character, eg /f\oo/ba\r.txt
        if (__WEBPACK_IMPORTED_MODULE_0__platform_js__["h" /* isWindows */]) {
            path = path.replace(/\\/g, _slash);
        }
        // check for authority as used in UNC shares
        // or use the path as given
        if (path[0] === _slash && path[1] === _slash) {
            var idx = path.indexOf(_slash, 2);
            if (idx === -1) {
                authority = path.substring(2);
                path = _slash;
            }
            else {
                authority = path.substring(2, idx);
                path = path.substring(idx) || _slash;
            }
        }
        return new _URI('file', authority, path, _empty, _empty);
    };
    URI.from = function (components) {
        return new _URI(components.scheme, components.authority, components.path, components.query, components.fragment);
    };
    // ---- printing/externalize ---------------------------
    /**
     * Creates a string representation for this URI. It's guaranteed that calling
     * `URI.parse` with the result of this function creates an URI which is equal
     * to this URI.
     *
     * * The result shall *not* be used for display purposes but for externalization or transport.
     * * The result will be encoded using the percentage encoding and encoding happens mostly
     * ignore the scheme-specific encoding rules.
     *
     * @param skipEncoding Do not encode the result, default is `false`
     */
    URI.prototype.toString = function (skipEncoding) {
        if (skipEncoding === void 0) { skipEncoding = false; }
        return _asFormatted(this, skipEncoding);
    };
    URI.prototype.toJSON = function () {
        return this;
    };
    URI.revive = function (data) {
        if (!data) {
            return data;
        }
        else if (data instanceof URI) {
            return data;
        }
        else {
            var result = new _URI(data);
            result._formatted = data.external;
            result._fsPath = data._sep === _pathSepMarker ? data.fsPath : null;
            return result;
        }
    };
    return URI;
}());

var _pathSepMarker = __WEBPACK_IMPORTED_MODULE_0__platform_js__["h" /* isWindows */] ? 1 : undefined;
// eslint-disable-next-line @typescript-eslint/class-name-casing
var _URI = /** @class */ (function (_super) {
    __extends(_URI, _super);
    function _URI() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this._formatted = null;
        _this._fsPath = null;
        return _this;
    }
    Object.defineProperty(_URI.prototype, "fsPath", {
        get: function () {
            if (!this._fsPath) {
                this._fsPath = _makeFsPath(this);
            }
            return this._fsPath;
        },
        enumerable: true,
        configurable: true
    });
    _URI.prototype.toString = function (skipEncoding) {
        if (skipEncoding === void 0) { skipEncoding = false; }
        if (!skipEncoding) {
            if (!this._formatted) {
                this._formatted = _asFormatted(this, false);
            }
            return this._formatted;
        }
        else {
            // we don't cache that
            return _asFormatted(this, true);
        }
    };
    _URI.prototype.toJSON = function () {
        var res = {
            $mid: 1
        };
        // cached state
        if (this._fsPath) {
            res.fsPath = this._fsPath;
            res._sep = _pathSepMarker;
        }
        if (this._formatted) {
            res.external = this._formatted;
        }
        // uri components
        if (this.path) {
            res.path = this.path;
        }
        if (this.scheme) {
            res.scheme = this.scheme;
        }
        if (this.authority) {
            res.authority = this.authority;
        }
        if (this.query) {
            res.query = this.query;
        }
        if (this.fragment) {
            res.fragment = this.fragment;
        }
        return res;
    };
    return _URI;
}(URI));
// reserved characters: https://tools.ietf.org/html/rfc3986#section-2.2
var encodeTable = (_a = {},
    _a[58 /* Colon */] = '%3A',
    _a[47 /* Slash */] = '%2F',
    _a[63 /* QuestionMark */] = '%3F',
    _a[35 /* Hash */] = '%23',
    _a[91 /* OpenSquareBracket */] = '%5B',
    _a[93 /* CloseSquareBracket */] = '%5D',
    _a[64 /* AtSign */] = '%40',
    _a[33 /* ExclamationMark */] = '%21',
    _a[36 /* DollarSign */] = '%24',
    _a[38 /* Ampersand */] = '%26',
    _a[39 /* SingleQuote */] = '%27',
    _a[40 /* OpenParen */] = '%28',
    _a[41 /* CloseParen */] = '%29',
    _a[42 /* Asterisk */] = '%2A',
    _a[43 /* Plus */] = '%2B',
    _a[44 /* Comma */] = '%2C',
    _a[59 /* Semicolon */] = '%3B',
    _a[61 /* Equals */] = '%3D',
    _a[32 /* Space */] = '%20',
    _a);
function encodeURIComponentFast(uriComponent, allowSlash) {
    var res = undefined;
    var nativeEncodePos = -1;
    for (var pos = 0; pos < uriComponent.length; pos++) {
        var code = uriComponent.charCodeAt(pos);
        // unreserved characters: https://tools.ietf.org/html/rfc3986#section-2.3
        if ((code >= 97 /* a */ && code <= 122 /* z */)
            || (code >= 65 /* A */ && code <= 90 /* Z */)
            || (code >= 48 /* Digit0 */ && code <= 57 /* Digit9 */)
            || code === 45 /* Dash */
            || code === 46 /* Period */
            || code === 95 /* Underline */
            || code === 126 /* Tilde */
            || (allowSlash && code === 47 /* Slash */)) {
            // check if we are delaying native encode
            if (nativeEncodePos !== -1) {
                res += encodeURIComponent(uriComponent.substring(nativeEncodePos, pos));
                nativeEncodePos = -1;
            }
            // check if we write into a new string (by default we try to return the param)
            if (res !== undefined) {
                res += uriComponent.charAt(pos);
            }
        }
        else {
            // encoding needed, we need to allocate a new string
            if (res === undefined) {
                res = uriComponent.substr(0, pos);
            }
            // check with default table first
            var escaped = encodeTable[code];
            if (escaped !== undefined) {
                // check if we are delaying native encode
                if (nativeEncodePos !== -1) {
                    res += encodeURIComponent(uriComponent.substring(nativeEncodePos, pos));
                    nativeEncodePos = -1;
                }
                // append escaped variant to result
                res += escaped;
            }
            else if (nativeEncodePos === -1) {
                // use native encode only when needed
                nativeEncodePos = pos;
            }
        }
    }
    if (nativeEncodePos !== -1) {
        res += encodeURIComponent(uriComponent.substring(nativeEncodePos));
    }
    return res !== undefined ? res : uriComponent;
}
function encodeURIComponentMinimal(path) {
    var res = undefined;
    for (var pos = 0; pos < path.length; pos++) {
        var code = path.charCodeAt(pos);
        if (code === 35 /* Hash */ || code === 63 /* QuestionMark */) {
            if (res === undefined) {
                res = path.substr(0, pos);
            }
            res += encodeTable[code];
        }
        else {
            if (res !== undefined) {
                res += path[pos];
            }
        }
    }
    return res !== undefined ? res : path;
}
/**
 * Compute `fsPath` for the given uri
 */
function _makeFsPath(uri) {
    var value;
    if (uri.authority && uri.path.length > 1 && uri.scheme === 'file') {
        // unc path: file://shares/c$/far/boo
        value = "//" + uri.authority + uri.path;
    }
    else if (uri.path.charCodeAt(0) === 47 /* Slash */
        && (uri.path.charCodeAt(1) >= 65 /* A */ && uri.path.charCodeAt(1) <= 90 /* Z */ || uri.path.charCodeAt(1) >= 97 /* a */ && uri.path.charCodeAt(1) <= 122 /* z */)
        && uri.path.charCodeAt(2) === 58 /* Colon */) {
        // windows drive letter: file:///c:/far/boo
        value = uri.path[1].toLowerCase() + uri.path.substr(2);
    }
    else {
        // other path
        value = uri.path;
    }
    if (__WEBPACK_IMPORTED_MODULE_0__platform_js__["h" /* isWindows */]) {
        value = value.replace(/\//g, '\\');
    }
    return value;
}
/**
 * Create the external version of a uri
 */
function _asFormatted(uri, skipEncoding) {
    var encoder = !skipEncoding
        ? encodeURIComponentFast
        : encodeURIComponentMinimal;
    var res = '';
    var scheme = uri.scheme, authority = uri.authority, path = uri.path, query = uri.query, fragment = uri.fragment;
    if (scheme) {
        res += scheme;
        res += ':';
    }
    if (authority || scheme === 'file') {
        res += _slash;
        res += _slash;
    }
    if (authority) {
        var idx = authority.indexOf('@');
        if (idx !== -1) {
            // <user>@<auth>
            var userinfo = authority.substr(0, idx);
            authority = authority.substr(idx + 1);
            idx = userinfo.indexOf(':');
            if (idx === -1) {
                res += encoder(userinfo, false);
            }
            else {
                // <user>:<pass>@<auth>
                res += encoder(userinfo.substr(0, idx), false);
                res += ':';
                res += encoder(userinfo.substr(idx + 1), false);
            }
            res += '@';
        }
        authority = authority.toLowerCase();
        idx = authority.indexOf(':');
        if (idx === -1) {
            res += encoder(authority, false);
        }
        else {
            // <auth>:<port>
            res += encoder(authority.substr(0, idx), false);
            res += authority.substr(idx);
        }
    }
    if (path) {
        // lower-case windows drive letters in /C:/fff or C:/fff
        if (path.length >= 3 && path.charCodeAt(0) === 47 /* Slash */ && path.charCodeAt(2) === 58 /* Colon */) {
            var code = path.charCodeAt(1);
            if (code >= 65 /* A */ && code <= 90 /* Z */) {
                path = "/" + String.fromCharCode(code + 32) + ":" + path.substr(3); // "/c:".length === 3
            }
        }
        else if (path.length >= 2 && path.charCodeAt(1) === 58 /* Colon */) {
            var code = path.charCodeAt(0);
            if (code >= 65 /* A */ && code <= 90 /* Z */) {
                path = String.fromCharCode(code + 32) + ":" + path.substr(2); // "/c:".length === 3
            }
        }
        // encode the rest of the path
        res += encoder(path, true);
    }
    if (query) {
        res += '?';
        res += encoder(query, false);
    }
    if (fragment) {
        res += '#';
        res += !skipEncoding ? encodeURIComponentFast(fragment, false) : fragment;
    }
    return res;
}
// --- decode
function decodeURIComponentGraceful(str) {
    try {
        return decodeURIComponent(str);
    }
    catch (_a) {
        if (str.length > 3) {
            return str.substr(0, 3) + decodeURIComponentGraceful(str.substr(3));
        }
        else {
            return str;
        }
    }
}
var _rEncodedAsHex = /(%[0-9A-Za-z][0-9A-Za-z])+/g;
function percentDecode(str) {
    if (!str.match(_rEncodedAsHex)) {
        return str;
    }
    return str.replace(_rEncodedAsHex, function (match) { return decodeURIComponentGraceful(match); });
}


/***/ }),
/* 25 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return CancellationToken; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "b", function() { return CancellationTokenSource; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__event_js__ = __webpack_require__(2);
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/

var shortcutEvent = Object.freeze(function (callback, context) {
    var handle = setTimeout(callback.bind(context), 0);
    return { dispose: function () { clearTimeout(handle); } };
});
var CancellationToken;
(function (CancellationToken) {
    function isCancellationToken(thing) {
        if (thing === CancellationToken.None || thing === CancellationToken.Cancelled) {
            return true;
        }
        if (thing instanceof MutableToken) {
            return true;
        }
        if (!thing || typeof thing !== 'object') {
            return false;
        }
        return typeof thing.isCancellationRequested === 'boolean'
            && typeof thing.onCancellationRequested === 'function';
    }
    CancellationToken.isCancellationToken = isCancellationToken;
    CancellationToken.None = Object.freeze({
        isCancellationRequested: false,
        onCancellationRequested: __WEBPACK_IMPORTED_MODULE_0__event_js__["b" /* Event */].None
    });
    CancellationToken.Cancelled = Object.freeze({
        isCancellationRequested: true,
        onCancellationRequested: shortcutEvent
    });
})(CancellationToken || (CancellationToken = {}));
var MutableToken = /** @class */ (function () {
    function MutableToken() {
        this._isCancelled = false;
        this._emitter = null;
    }
    MutableToken.prototype.cancel = function () {
        if (!this._isCancelled) {
            this._isCancelled = true;
            if (this._emitter) {
                this._emitter.fire(undefined);
                this.dispose();
            }
        }
    };
    Object.defineProperty(MutableToken.prototype, "isCancellationRequested", {
        get: function () {
            return this._isCancelled;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(MutableToken.prototype, "onCancellationRequested", {
        get: function () {
            if (this._isCancelled) {
                return shortcutEvent;
            }
            if (!this._emitter) {
                this._emitter = new __WEBPACK_IMPORTED_MODULE_0__event_js__["a" /* Emitter */]();
            }
            return this._emitter.event;
        },
        enumerable: true,
        configurable: true
    });
    MutableToken.prototype.dispose = function () {
        if (this._emitter) {
            this._emitter.dispose();
            this._emitter = null;
        }
    };
    return MutableToken;
}());
var CancellationTokenSource = /** @class */ (function () {
    function CancellationTokenSource(parent) {
        this._token = undefined;
        this._parentListener = undefined;
        this._parentListener = parent && parent.onCancellationRequested(this.cancel, this);
    }
    Object.defineProperty(CancellationTokenSource.prototype, "token", {
        get: function () {
            if (!this._token) {
                // be lazy and create the token only when
                // actually needed
                this._token = new MutableToken();
            }
            return this._token;
        },
        enumerable: true,
        configurable: true
    });
    CancellationTokenSource.prototype.cancel = function () {
        if (!this._token) {
            // save an object by returning the default
            // cancelled token when cancellation happens
            // before someone asks for the token
            this._token = CancellationToken.Cancelled;
        }
        else if (this._token instanceof MutableToken) {
            // actually cancel
            this._token.cancel();
        }
    };
    CancellationTokenSource.prototype.dispose = function (cancel) {
        if (cancel === void 0) { cancel = false; }
        if (cancel) {
            this.cancel();
        }
        if (this._parentListener) {
            this._parentListener.dispose();
        }
        if (!this._token) {
            // ensure to initialize with an empty token if we had none
            this._token = CancellationToken.None;
        }
        else if (this._token instanceof MutableToken) {
            // actually dispose
            this._token.dispose();
        }
    };
    return CancellationTokenSource;
}());



/***/ }),
/* 26 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return FastDomNode; });
/* harmony export (immutable) */ __webpack_exports__["b"] = createFastDomNode;
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__dom_js__ = __webpack_require__(3);
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/

var FastDomNode = /** @class */ (function () {
    function FastDomNode(domNode) {
        this.domNode = domNode;
        this._maxWidth = -1;
        this._width = -1;
        this._height = -1;
        this._top = -1;
        this._left = -1;
        this._bottom = -1;
        this._right = -1;
        this._fontFamily = '';
        this._fontWeight = '';
        this._fontSize = -1;
        this._fontFeatureSettings = '';
        this._lineHeight = -1;
        this._letterSpacing = -100;
        this._className = '';
        this._display = '';
        this._position = '';
        this._visibility = '';
        this._backgroundColor = '';
        this._layerHint = false;
        this._contain = 'none';
    }
    FastDomNode.prototype.setMaxWidth = function (maxWidth) {
        if (this._maxWidth === maxWidth) {
            return;
        }
        this._maxWidth = maxWidth;
        this.domNode.style.maxWidth = this._maxWidth + 'px';
    };
    FastDomNode.prototype.setWidth = function (width) {
        if (this._width === width) {
            return;
        }
        this._width = width;
        this.domNode.style.width = this._width + 'px';
    };
    FastDomNode.prototype.setHeight = function (height) {
        if (this._height === height) {
            return;
        }
        this._height = height;
        this.domNode.style.height = this._height + 'px';
    };
    FastDomNode.prototype.setTop = function (top) {
        if (this._top === top) {
            return;
        }
        this._top = top;
        this.domNode.style.top = this._top + 'px';
    };
    FastDomNode.prototype.unsetTop = function () {
        if (this._top === -1) {
            return;
        }
        this._top = -1;
        this.domNode.style.top = '';
    };
    FastDomNode.prototype.setLeft = function (left) {
        if (this._left === left) {
            return;
        }
        this._left = left;
        this.domNode.style.left = this._left + 'px';
    };
    FastDomNode.prototype.setBottom = function (bottom) {
        if (this._bottom === bottom) {
            return;
        }
        this._bottom = bottom;
        this.domNode.style.bottom = this._bottom + 'px';
    };
    FastDomNode.prototype.setRight = function (right) {
        if (this._right === right) {
            return;
        }
        this._right = right;
        this.domNode.style.right = this._right + 'px';
    };
    FastDomNode.prototype.setFontFamily = function (fontFamily) {
        if (this._fontFamily === fontFamily) {
            return;
        }
        this._fontFamily = fontFamily;
        this.domNode.style.fontFamily = this._fontFamily;
    };
    FastDomNode.prototype.setFontWeight = function (fontWeight) {
        if (this._fontWeight === fontWeight) {
            return;
        }
        this._fontWeight = fontWeight;
        this.domNode.style.fontWeight = this._fontWeight;
    };
    FastDomNode.prototype.setFontSize = function (fontSize) {
        if (this._fontSize === fontSize) {
            return;
        }
        this._fontSize = fontSize;
        this.domNode.style.fontSize = this._fontSize + 'px';
    };
    FastDomNode.prototype.setFontFeatureSettings = function (fontFeatureSettings) {
        if (this._fontFeatureSettings === fontFeatureSettings) {
            return;
        }
        this._fontFeatureSettings = fontFeatureSettings;
        this.domNode.style.fontFeatureSettings = this._fontFeatureSettings;
    };
    FastDomNode.prototype.setLineHeight = function (lineHeight) {
        if (this._lineHeight === lineHeight) {
            return;
        }
        this._lineHeight = lineHeight;
        this.domNode.style.lineHeight = this._lineHeight + 'px';
    };
    FastDomNode.prototype.setLetterSpacing = function (letterSpacing) {
        if (this._letterSpacing === letterSpacing) {
            return;
        }
        this._letterSpacing = letterSpacing;
        this.domNode.style.letterSpacing = this._letterSpacing + 'px';
    };
    FastDomNode.prototype.setClassName = function (className) {
        if (this._className === className) {
            return;
        }
        this._className = className;
        this.domNode.className = this._className;
    };
    FastDomNode.prototype.toggleClassName = function (className, shouldHaveIt) {
        __WEBPACK_IMPORTED_MODULE_0__dom_js__["Y" /* toggleClass */](this.domNode, className, shouldHaveIt);
        this._className = this.domNode.className;
    };
    FastDomNode.prototype.setDisplay = function (display) {
        if (this._display === display) {
            return;
        }
        this._display = display;
        this.domNode.style.display = this._display;
    };
    FastDomNode.prototype.setPosition = function (position) {
        if (this._position === position) {
            return;
        }
        this._position = position;
        this.domNode.style.position = this._position;
    };
    FastDomNode.prototype.setVisibility = function (visibility) {
        if (this._visibility === visibility) {
            return;
        }
        this._visibility = visibility;
        this.domNode.style.visibility = this._visibility;
    };
    FastDomNode.prototype.setBackgroundColor = function (backgroundColor) {
        if (this._backgroundColor === backgroundColor) {
            return;
        }
        this._backgroundColor = backgroundColor;
        this.domNode.style.backgroundColor = this._backgroundColor;
    };
    FastDomNode.prototype.setLayerHinting = function (layerHint) {
        if (this._layerHint === layerHint) {
            return;
        }
        this._layerHint = layerHint;
        this.domNode.style.transform = this._layerHint ? 'translate3d(0px, 0px, 0px)' : '';
    };
    FastDomNode.prototype.setContain = function (contain) {
        if (this._contain === contain) {
            return;
        }
        this._contain = contain;
        this.domNode.style.contain = this._contain;
    };
    FastDomNode.prototype.setAttribute = function (name, value) {
        this.domNode.setAttribute(name, value);
    };
    FastDomNode.prototype.removeAttribute = function (name) {
        this.domNode.removeAttribute(name);
    };
    FastDomNode.prototype.appendChild = function (child) {
        this.domNode.appendChild(child.domNode);
    };
    FastDomNode.prototype.removeChild = function (child) {
        this.domNode.removeChild(child.domNode);
    };
    return FastDomNode;
}());

function createFastDomNode(domNode) {
    return new FastDomNode(domNode);
}


/***/ }),
/* 27 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "b", function() { return ICommandService; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return CommandsRegistry; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__base_common_lifecycle_js__ = __webpack_require__(0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__base_common_types_js__ = __webpack_require__(20);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2__instantiation_common_instantiation_js__ = __webpack_require__(10);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3__base_common_event_js__ = __webpack_require__(2);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4__base_common_linkedList_js__ = __webpack_require__(84);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5__base_common_map_js__ = __webpack_require__(38);
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var __spreadArrays = (this && this.__spreadArrays) || function () {
    for (var s = 0, i = 0, il = arguments.length; i < il; i++) s += arguments[i].length;
    for (var r = Array(s), k = 0, i = 0; i < il; i++)
        for (var a = arguments[i], j = 0, jl = a.length; j < jl; j++, k++)
            r[k] = a[j];
    return r;
};






var ICommandService = Object(__WEBPACK_IMPORTED_MODULE_2__instantiation_common_instantiation_js__["c" /* createDecorator */])('commandService');
var CommandsRegistry = new /** @class */ (function () {
    function class_1() {
        this._commands = new Map();
        this._onDidRegisterCommand = new __WEBPACK_IMPORTED_MODULE_3__base_common_event_js__["a" /* Emitter */]();
        this.onDidRegisterCommand = this._onDidRegisterCommand.event;
    }
    class_1.prototype.registerCommand = function (idOrCommand, handler) {
        var _this = this;
        if (!idOrCommand) {
            throw new Error("invalid command");
        }
        if (typeof idOrCommand === 'string') {
            if (!handler) {
                throw new Error("invalid command");
            }
            return this.registerCommand({ id: idOrCommand, handler: handler });
        }
        // add argument validation if rich command metadata is provided
        if (idOrCommand.description) {
            var constraints_1 = [];
            for (var _i = 0, _a = idOrCommand.description.args; _i < _a.length; _i++) {
                var arg = _a[_i];
                constraints_1.push(arg.constraint);
            }
            var actualHandler_1 = idOrCommand.handler;
            idOrCommand.handler = function (accessor) {
                var args = [];
                for (var _i = 1; _i < arguments.length; _i++) {
                    args[_i - 1] = arguments[_i];
                }
                Object(__WEBPACK_IMPORTED_MODULE_1__base_common_types_js__["m" /* validateConstraints */])(args, constraints_1);
                return actualHandler_1.apply(void 0, __spreadArrays([accessor], args));
            };
        }
        // find a place to store the command
        var id = idOrCommand.id;
        var commands = this._commands.get(id);
        if (!commands) {
            commands = new __WEBPACK_IMPORTED_MODULE_4__base_common_linkedList_js__["a" /* LinkedList */]();
            this._commands.set(id, commands);
        }
        var removeFn = commands.unshift(idOrCommand);
        var ret = Object(__WEBPACK_IMPORTED_MODULE_0__base_common_lifecycle_js__["h" /* toDisposable */])(function () {
            removeFn();
            var command = _this._commands.get(id);
            if (command === null || command === void 0 ? void 0 : command.isEmpty()) {
                _this._commands.delete(id);
            }
        });
        // tell the world about this command
        this._onDidRegisterCommand.fire(id);
        return ret;
    };
    class_1.prototype.registerCommandAlias = function (oldId, newId) {
        return CommandsRegistry.registerCommand(oldId, function (accessor) {
            var _a;
            var args = [];
            for (var _i = 1; _i < arguments.length; _i++) {
                args[_i - 1] = arguments[_i];
            }
            return (_a = accessor.get(ICommandService)).executeCommand.apply(_a, __spreadArrays([newId], args));
        });
    };
    class_1.prototype.getCommand = function (id) {
        var list = this._commands.get(id);
        if (!list || list.isEmpty()) {
            return undefined;
        }
        return list.iterator().next().value;
    };
    class_1.prototype.getCommands = function () {
        var result = new Map();
        for (var _i = 0, _a = Object(__WEBPACK_IMPORTED_MODULE_5__base_common_map_js__["d" /* keys */])(this._commands); _i < _a.length; _i++) {
            var key = _a[_i];
            var command = this.getCommand(key);
            if (command) {
                result.set(key, command);
            }
        }
        return result;
    };
    return class_1;
}());


/***/ }),
/* 28 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "c", function() { return RGBA; });
/* unused harmony export HSLA */
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "b", function() { return HSVA; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return Color; });
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
function roundFloat(number, decimalPoints) {
    var decimal = Math.pow(10, decimalPoints);
    return Math.round(number * decimal) / decimal;
}
var RGBA = /** @class */ (function () {
    function RGBA(r, g, b, a) {
        if (a === void 0) { a = 1; }
        this.r = Math.min(255, Math.max(0, r)) | 0;
        this.g = Math.min(255, Math.max(0, g)) | 0;
        this.b = Math.min(255, Math.max(0, b)) | 0;
        this.a = roundFloat(Math.max(Math.min(1, a), 0), 3);
    }
    RGBA.equals = function (a, b) {
        return a.r === b.r && a.g === b.g && a.b === b.b && a.a === b.a;
    };
    return RGBA;
}());

var HSLA = /** @class */ (function () {
    function HSLA(h, s, l, a) {
        this.h = Math.max(Math.min(360, h), 0) | 0;
        this.s = roundFloat(Math.max(Math.min(1, s), 0), 3);
        this.l = roundFloat(Math.max(Math.min(1, l), 0), 3);
        this.a = roundFloat(Math.max(Math.min(1, a), 0), 3);
    }
    HSLA.equals = function (a, b) {
        return a.h === b.h && a.s === b.s && a.l === b.l && a.a === b.a;
    };
    /**
     * Converts an RGB color value to HSL. Conversion formula
     * adapted from http://en.wikipedia.org/wiki/HSL_color_space.
     * Assumes r, g, and b are contained in the set [0, 255] and
     * returns h in the set [0, 360], s, and l in the set [0, 1].
     */
    HSLA.fromRGBA = function (rgba) {
        var r = rgba.r / 255;
        var g = rgba.g / 255;
        var b = rgba.b / 255;
        var a = rgba.a;
        var max = Math.max(r, g, b);
        var min = Math.min(r, g, b);
        var h = 0;
        var s = 0;
        var l = (min + max) / 2;
        var chroma = max - min;
        if (chroma > 0) {
            s = Math.min((l <= 0.5 ? chroma / (2 * l) : chroma / (2 - (2 * l))), 1);
            switch (max) {
                case r:
                    h = (g - b) / chroma + (g < b ? 6 : 0);
                    break;
                case g:
                    h = (b - r) / chroma + 2;
                    break;
                case b:
                    h = (r - g) / chroma + 4;
                    break;
            }
            h *= 60;
            h = Math.round(h);
        }
        return new HSLA(h, s, l, a);
    };
    HSLA._hue2rgb = function (p, q, t) {
        if (t < 0) {
            t += 1;
        }
        if (t > 1) {
            t -= 1;
        }
        if (t < 1 / 6) {
            return p + (q - p) * 6 * t;
        }
        if (t < 1 / 2) {
            return q;
        }
        if (t < 2 / 3) {
            return p + (q - p) * (2 / 3 - t) * 6;
        }
        return p;
    };
    /**
     * Converts an HSL color value to RGB. Conversion formula
     * adapted from http://en.wikipedia.org/wiki/HSL_color_space.
     * Assumes h in the set [0, 360] s, and l are contained in the set [0, 1] and
     * returns r, g, and b in the set [0, 255].
     */
    HSLA.toRGBA = function (hsla) {
        var h = hsla.h / 360;
        var s = hsla.s, l = hsla.l, a = hsla.a;
        var r, g, b;
        if (s === 0) {
            r = g = b = l; // achromatic
        }
        else {
            var q = l < 0.5 ? l * (1 + s) : l + s - l * s;
            var p = 2 * l - q;
            r = HSLA._hue2rgb(p, q, h + 1 / 3);
            g = HSLA._hue2rgb(p, q, h);
            b = HSLA._hue2rgb(p, q, h - 1 / 3);
        }
        return new RGBA(Math.round(r * 255), Math.round(g * 255), Math.round(b * 255), a);
    };
    return HSLA;
}());

var HSVA = /** @class */ (function () {
    function HSVA(h, s, v, a) {
        this.h = Math.max(Math.min(360, h), 0) | 0;
        this.s = roundFloat(Math.max(Math.min(1, s), 0), 3);
        this.v = roundFloat(Math.max(Math.min(1, v), 0), 3);
        this.a = roundFloat(Math.max(Math.min(1, a), 0), 3);
    }
    HSVA.equals = function (a, b) {
        return a.h === b.h && a.s === b.s && a.v === b.v && a.a === b.a;
    };
    // from http://www.rapidtables.com/convert/color/rgb-to-hsv.htm
    HSVA.fromRGBA = function (rgba) {
        var r = rgba.r / 255;
        var g = rgba.g / 255;
        var b = rgba.b / 255;
        var cmax = Math.max(r, g, b);
        var cmin = Math.min(r, g, b);
        var delta = cmax - cmin;
        var s = cmax === 0 ? 0 : (delta / cmax);
        var m;
        if (delta === 0) {
            m = 0;
        }
        else if (cmax === r) {
            m = ((((g - b) / delta) % 6) + 6) % 6;
        }
        else if (cmax === g) {
            m = ((b - r) / delta) + 2;
        }
        else {
            m = ((r - g) / delta) + 4;
        }
        return new HSVA(Math.round(m * 60), s, cmax, rgba.a);
    };
    // from http://www.rapidtables.com/convert/color/hsv-to-rgb.htm
    HSVA.toRGBA = function (hsva) {
        var h = hsva.h, s = hsva.s, v = hsva.v, a = hsva.a;
        var c = v * s;
        var x = c * (1 - Math.abs((h / 60) % 2 - 1));
        var m = v - c;
        var _a = [0, 0, 0], r = _a[0], g = _a[1], b = _a[2];
        if (h < 60) {
            r = c;
            g = x;
        }
        else if (h < 120) {
            r = x;
            g = c;
        }
        else if (h < 180) {
            g = c;
            b = x;
        }
        else if (h < 240) {
            g = x;
            b = c;
        }
        else if (h < 300) {
            r = x;
            b = c;
        }
        else if (h < 360) {
            r = c;
            b = x;
        }
        r = Math.round((r + m) * 255);
        g = Math.round((g + m) * 255);
        b = Math.round((b + m) * 255);
        return new RGBA(r, g, b, a);
    };
    return HSVA;
}());

var Color = /** @class */ (function () {
    function Color(arg) {
        if (!arg) {
            throw new Error('Color needs a value');
        }
        else if (arg instanceof RGBA) {
            this.rgba = arg;
        }
        else if (arg instanceof HSLA) {
            this._hsla = arg;
            this.rgba = HSLA.toRGBA(arg);
        }
        else if (arg instanceof HSVA) {
            this._hsva = arg;
            this.rgba = HSVA.toRGBA(arg);
        }
        else {
            throw new Error('Invalid color ctor argument');
        }
    }
    Color.fromHex = function (hex) {
        return Color.Format.CSS.parseHex(hex) || Color.red;
    };
    Object.defineProperty(Color.prototype, "hsla", {
        get: function () {
            if (this._hsla) {
                return this._hsla;
            }
            else {
                return HSLA.fromRGBA(this.rgba);
            }
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Color.prototype, "hsva", {
        get: function () {
            if (this._hsva) {
                return this._hsva;
            }
            return HSVA.fromRGBA(this.rgba);
        },
        enumerable: true,
        configurable: true
    });
    Color.prototype.equals = function (other) {
        return !!other && RGBA.equals(this.rgba, other.rgba) && HSLA.equals(this.hsla, other.hsla) && HSVA.equals(this.hsva, other.hsva);
    };
    /**
     * http://www.w3.org/TR/WCAG20/#relativeluminancedef
     * Returns the number in the set [0, 1]. O => Darkest Black. 1 => Lightest white.
     */
    Color.prototype.getRelativeLuminance = function () {
        var R = Color._relativeLuminanceForComponent(this.rgba.r);
        var G = Color._relativeLuminanceForComponent(this.rgba.g);
        var B = Color._relativeLuminanceForComponent(this.rgba.b);
        var luminance = 0.2126 * R + 0.7152 * G + 0.0722 * B;
        return roundFloat(luminance, 4);
    };
    Color._relativeLuminanceForComponent = function (color) {
        var c = color / 255;
        return (c <= 0.03928) ? c / 12.92 : Math.pow(((c + 0.055) / 1.055), 2.4);
    };
    /**
     *	http://24ways.org/2010/calculating-color-contrast
     *  Return 'true' if lighter color otherwise 'false'
     */
    Color.prototype.isLighter = function () {
        var yiq = (this.rgba.r * 299 + this.rgba.g * 587 + this.rgba.b * 114) / 1000;
        return yiq >= 128;
    };
    Color.prototype.isLighterThan = function (another) {
        var lum1 = this.getRelativeLuminance();
        var lum2 = another.getRelativeLuminance();
        return lum1 > lum2;
    };
    Color.prototype.isDarkerThan = function (another) {
        var lum1 = this.getRelativeLuminance();
        var lum2 = another.getRelativeLuminance();
        return lum1 < lum2;
    };
    Color.prototype.lighten = function (factor) {
        return new Color(new HSLA(this.hsla.h, this.hsla.s, this.hsla.l + this.hsla.l * factor, this.hsla.a));
    };
    Color.prototype.darken = function (factor) {
        return new Color(new HSLA(this.hsla.h, this.hsla.s, this.hsla.l - this.hsla.l * factor, this.hsla.a));
    };
    Color.prototype.transparent = function (factor) {
        var _a = this.rgba, r = _a.r, g = _a.g, b = _a.b, a = _a.a;
        return new Color(new RGBA(r, g, b, a * factor));
    };
    Color.prototype.isTransparent = function () {
        return this.rgba.a === 0;
    };
    Color.prototype.isOpaque = function () {
        return this.rgba.a === 1;
    };
    Color.prototype.opposite = function () {
        return new Color(new RGBA(255 - this.rgba.r, 255 - this.rgba.g, 255 - this.rgba.b, this.rgba.a));
    };
    Color.prototype.toString = function () {
        return '' + Color.Format.CSS.format(this);
    };
    Color.getLighterColor = function (of, relative, factor) {
        if (of.isLighterThan(relative)) {
            return of;
        }
        factor = factor ? factor : 0.5;
        var lum1 = of.getRelativeLuminance();
        var lum2 = relative.getRelativeLuminance();
        factor = factor * (lum2 - lum1) / lum2;
        return of.lighten(factor);
    };
    Color.getDarkerColor = function (of, relative, factor) {
        if (of.isDarkerThan(relative)) {
            return of;
        }
        factor = factor ? factor : 0.5;
        var lum1 = of.getRelativeLuminance();
        var lum2 = relative.getRelativeLuminance();
        factor = factor * (lum1 - lum2) / lum1;
        return of.darken(factor);
    };
    Color.white = new Color(new RGBA(255, 255, 255, 1));
    Color.black = new Color(new RGBA(0, 0, 0, 1));
    Color.red = new Color(new RGBA(255, 0, 0, 1));
    Color.blue = new Color(new RGBA(0, 0, 255, 1));
    Color.cyan = new Color(new RGBA(0, 255, 255, 1));
    Color.lightgrey = new Color(new RGBA(211, 211, 211, 1));
    Color.transparent = new Color(new RGBA(0, 0, 0, 0));
    return Color;
}());

(function (Color) {
    var Format;
    (function (Format) {
        var CSS;
        (function (CSS) {
            function formatRGB(color) {
                if (color.rgba.a === 1) {
                    return "rgb(" + color.rgba.r + ", " + color.rgba.g + ", " + color.rgba.b + ")";
                }
                return Color.Format.CSS.formatRGBA(color);
            }
            CSS.formatRGB = formatRGB;
            function formatRGBA(color) {
                return "rgba(" + color.rgba.r + ", " + color.rgba.g + ", " + color.rgba.b + ", " + +(color.rgba.a).toFixed(2) + ")";
            }
            CSS.formatRGBA = formatRGBA;
            function formatHSL(color) {
                if (color.hsla.a === 1) {
                    return "hsl(" + color.hsla.h + ", " + (color.hsla.s * 100).toFixed(2) + "%, " + (color.hsla.l * 100).toFixed(2) + "%)";
                }
                return Color.Format.CSS.formatHSLA(color);
            }
            CSS.formatHSL = formatHSL;
            function formatHSLA(color) {
                return "hsla(" + color.hsla.h + ", " + (color.hsla.s * 100).toFixed(2) + "%, " + (color.hsla.l * 100).toFixed(2) + "%, " + color.hsla.a.toFixed(2) + ")";
            }
            CSS.formatHSLA = formatHSLA;
            function _toTwoDigitHex(n) {
                var r = n.toString(16);
                return r.length !== 2 ? '0' + r : r;
            }
            /**
             * Formats the color as #RRGGBB
             */
            function formatHex(color) {
                return "#" + _toTwoDigitHex(color.rgba.r) + _toTwoDigitHex(color.rgba.g) + _toTwoDigitHex(color.rgba.b);
            }
            CSS.formatHex = formatHex;
            /**
             * Formats the color as #RRGGBBAA
             * If 'compact' is set, colors without transparancy will be printed as #RRGGBB
             */
            function formatHexA(color, compact) {
                if (compact === void 0) { compact = false; }
                if (compact && color.rgba.a === 1) {
                    return Color.Format.CSS.formatHex(color);
                }
                return "#" + _toTwoDigitHex(color.rgba.r) + _toTwoDigitHex(color.rgba.g) + _toTwoDigitHex(color.rgba.b) + _toTwoDigitHex(Math.round(color.rgba.a * 255));
            }
            CSS.formatHexA = formatHexA;
            /**
             * The default format will use HEX if opaque and RGBA otherwise.
             */
            function format(color) {
                if (color.isOpaque()) {
                    return Color.Format.CSS.formatHex(color);
                }
                return Color.Format.CSS.formatRGBA(color);
            }
            CSS.format = format;
            /**
             * Converts an Hex color value to a Color.
             * returns r, g, and b are contained in the set [0, 255]
             * @param hex string (#RGB, #RGBA, #RRGGBB or #RRGGBBAA).
             */
            function parseHex(hex) {
                var length = hex.length;
                if (length === 0) {
                    // Invalid color
                    return null;
                }
                if (hex.charCodeAt(0) !== 35 /* Hash */) {
                    // Does not begin with a #
                    return null;
                }
                if (length === 7) {
                    // #RRGGBB format
                    var r = 16 * _parseHexDigit(hex.charCodeAt(1)) + _parseHexDigit(hex.charCodeAt(2));
                    var g = 16 * _parseHexDigit(hex.charCodeAt(3)) + _parseHexDigit(hex.charCodeAt(4));
                    var b = 16 * _parseHexDigit(hex.charCodeAt(5)) + _parseHexDigit(hex.charCodeAt(6));
                    return new Color(new RGBA(r, g, b, 1));
                }
                if (length === 9) {
                    // #RRGGBBAA format
                    var r = 16 * _parseHexDigit(hex.charCodeAt(1)) + _parseHexDigit(hex.charCodeAt(2));
                    var g = 16 * _parseHexDigit(hex.charCodeAt(3)) + _parseHexDigit(hex.charCodeAt(4));
                    var b = 16 * _parseHexDigit(hex.charCodeAt(5)) + _parseHexDigit(hex.charCodeAt(6));
                    var a = 16 * _parseHexDigit(hex.charCodeAt(7)) + _parseHexDigit(hex.charCodeAt(8));
                    return new Color(new RGBA(r, g, b, a / 255));
                }
                if (length === 4) {
                    // #RGB format
                    var r = _parseHexDigit(hex.charCodeAt(1));
                    var g = _parseHexDigit(hex.charCodeAt(2));
                    var b = _parseHexDigit(hex.charCodeAt(3));
                    return new Color(new RGBA(16 * r + r, 16 * g + g, 16 * b + b));
                }
                if (length === 5) {
                    // #RGBA format
                    var r = _parseHexDigit(hex.charCodeAt(1));
                    var g = _parseHexDigit(hex.charCodeAt(2));
                    var b = _parseHexDigit(hex.charCodeAt(3));
                    var a = _parseHexDigit(hex.charCodeAt(4));
                    return new Color(new RGBA(16 * r + r, 16 * g + g, 16 * b + b, (16 * a + a) / 255));
                }
                // Invalid color
                return null;
            }
            CSS.parseHex = parseHex;
            function _parseHexDigit(charCode) {
                switch (charCode) {
                    case 48 /* Digit0 */: return 0;
                    case 49 /* Digit1 */: return 1;
                    case 50 /* Digit2 */: return 2;
                    case 51 /* Digit3 */: return 3;
                    case 52 /* Digit4 */: return 4;
                    case 53 /* Digit5 */: return 5;
                    case 54 /* Digit6 */: return 6;
                    case 55 /* Digit7 */: return 7;
                    case 56 /* Digit8 */: return 8;
                    case 57 /* Digit9 */: return 9;
                    case 97 /* a */: return 10;
                    case 65 /* A */: return 10;
                    case 98 /* b */: return 11;
                    case 66 /* B */: return 11;
                    case 99 /* c */: return 12;
                    case 67 /* C */: return 12;
                    case 100 /* d */: return 13;
                    case 68 /* D */: return 13;
                    case 101 /* e */: return 14;
                    case 69 /* E */: return 14;
                    case 102 /* f */: return 15;
                    case 70 /* F */: return 15;
                }
                return 0;
            }
        })(CSS = Format.CSS || (Format.CSS = {}));
    })(Format = Color.Format || (Color.Format = {}));
})(Color || (Color = {}));


/***/ }),
/* 29 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* unused harmony export createTextBufferFactory */
/* unused harmony export createTextBuffer */
/* unused harmony export LONG_LINE_BOUNDARY */
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "b", function() { return TextModel; });
/* unused harmony export ModelDecorationOverviewRulerOptions */
/* unused harmony export ModelDecorationMinimapOptions */
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return ModelDecorationOptions; });
/* unused harmony export DidChangeDecorationsEmitter */
/* unused harmony export DidChangeContentEmitter */
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__base_common_errors_js__ = __webpack_require__(8);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__base_common_event_js__ = __webpack_require__(2);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2__base_common_lifecycle_js__ = __webpack_require__(0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3__base_common_strings_js__ = __webpack_require__(4);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4__base_common_uri_js__ = __webpack_require__(24);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5__config_editorOptions_js__ = __webpack_require__(32);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6__core_position_js__ = __webpack_require__(12);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_7__core_range_js__ = __webpack_require__(1);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_8__core_selection_js__ = __webpack_require__(21);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_9__model_js__ = __webpack_require__(49);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_10__editStack_js__ = __webpack_require__(389);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_11__indentationGuesser_js__ = __webpack_require__(390);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_12__intervalTree_js__ = __webpack_require__(391);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_13__pieceTreeTextBuffer_pieceTreeTextBufferBuilder_js__ = __webpack_require__(392);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_14__textModelEvents_js__ = __webpack_require__(395);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_15__textModelSearch_js__ = __webpack_require__(156);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_16__textModelTokens_js__ = __webpack_require__(396);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_17__wordHelper_js__ = __webpack_require__(117);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_18__modes_languageConfigurationRegistry_js__ = __webpack_require__(42);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_19__modes_nullMode_js__ = __webpack_require__(67);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_20__modes_supports_js__ = __webpack_require__(159);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_21__modes_supports_richEditBrackets_js__ = __webpack_require__(160);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_22__base_common_types_js__ = __webpack_require__(20);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_23__tokensStore_js__ = __webpack_require__(158);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_24__base_common_color_js__ = __webpack_require__(28);
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();

























function createTextBufferBuilder() {
    return new __WEBPACK_IMPORTED_MODULE_13__pieceTreeTextBuffer_pieceTreeTextBufferBuilder_js__["a" /* PieceTreeTextBufferBuilder */]();
}
function createTextBufferFactory(text) {
    var builder = createTextBufferBuilder();
    builder.acceptChunk(text);
    return builder.finish();
}
function createTextBuffer(value, defaultEOL) {
    var factory = (typeof value === 'string' ? createTextBufferFactory(value) : value);
    return factory.create(defaultEOL);
}
var MODEL_ID = 0;
var LIMIT_FIND_COUNT = 999;
var LONG_LINE_BOUNDARY = 10000;
var invalidFunc = function () { throw new Error("Invalid change accessor"); };
var TextModel = /** @class */ (function (_super) {
    __extends(TextModel, _super);
    //#endregion
    function TextModel(source, creationOptions, languageIdentifier, associatedResource) {
        if (associatedResource === void 0) { associatedResource = null; }
        var _this = _super.call(this) || this;
        //#region Events
        _this._onWillDispose = _this._register(new __WEBPACK_IMPORTED_MODULE_1__base_common_event_js__["a" /* Emitter */]());
        _this.onWillDispose = _this._onWillDispose.event;
        _this._onDidChangeDecorations = _this._register(new DidChangeDecorationsEmitter());
        _this.onDidChangeDecorations = _this._onDidChangeDecorations.event;
        _this._onDidChangeLanguage = _this._register(new __WEBPACK_IMPORTED_MODULE_1__base_common_event_js__["a" /* Emitter */]());
        _this.onDidChangeLanguage = _this._onDidChangeLanguage.event;
        _this._onDidChangeLanguageConfiguration = _this._register(new __WEBPACK_IMPORTED_MODULE_1__base_common_event_js__["a" /* Emitter */]());
        _this.onDidChangeLanguageConfiguration = _this._onDidChangeLanguageConfiguration.event;
        _this._onDidChangeTokens = _this._register(new __WEBPACK_IMPORTED_MODULE_1__base_common_event_js__["a" /* Emitter */]());
        _this.onDidChangeTokens = _this._onDidChangeTokens.event;
        _this._onDidChangeOptions = _this._register(new __WEBPACK_IMPORTED_MODULE_1__base_common_event_js__["a" /* Emitter */]());
        _this.onDidChangeOptions = _this._onDidChangeOptions.event;
        _this._onDidChangeAttached = _this._register(new __WEBPACK_IMPORTED_MODULE_1__base_common_event_js__["a" /* Emitter */]());
        _this.onDidChangeAttached = _this._onDidChangeAttached.event;
        _this._eventEmitter = _this._register(new DidChangeContentEmitter());
        // Generate a new unique model id
        MODEL_ID++;
        _this.id = '$model' + MODEL_ID;
        _this.isForSimpleWidget = creationOptions.isForSimpleWidget;
        if (typeof associatedResource === 'undefined' || associatedResource === null) {
            _this._associatedResource = __WEBPACK_IMPORTED_MODULE_4__base_common_uri_js__["a" /* URI */].parse('inmemory://model/' + MODEL_ID);
        }
        else {
            _this._associatedResource = associatedResource;
        }
        _this._attachedEditorCount = 0;
        _this._buffer = createTextBuffer(source, creationOptions.defaultEOL);
        _this._options = TextModel.resolveOptions(_this._buffer, creationOptions);
        var bufferLineCount = _this._buffer.getLineCount();
        var bufferTextLength = _this._buffer.getValueLengthInRange(new __WEBPACK_IMPORTED_MODULE_7__core_range_js__["a" /* Range */](1, 1, bufferLineCount, _this._buffer.getLineLength(bufferLineCount) + 1), 0 /* TextDefined */);
        // !!! Make a decision in the ctor and permanently respect this decision !!!
        // If a model is too large at construction time, it will never get tokenized,
        // under no circumstances.
        if (creationOptions.largeFileOptimizations) {
            _this._isTooLargeForTokenization = ((bufferTextLength > TextModel.LARGE_FILE_SIZE_THRESHOLD)
                || (bufferLineCount > TextModel.LARGE_FILE_LINE_COUNT_THRESHOLD));
        }
        else {
            _this._isTooLargeForTokenization = false;
        }
        _this._isTooLargeForSyncing = (bufferTextLength > TextModel.MODEL_SYNC_LIMIT);
        _this._versionId = 1;
        _this._alternativeVersionId = 1;
        _this._isDisposed = false;
        _this._isDisposing = false;
        _this._languageIdentifier = languageIdentifier || __WEBPACK_IMPORTED_MODULE_19__modes_nullMode_js__["a" /* NULL_LANGUAGE_IDENTIFIER */];
        _this._languageRegistryListener = __WEBPACK_IMPORTED_MODULE_18__modes_languageConfigurationRegistry_js__["a" /* LanguageConfigurationRegistry */].onDidChange(function (e) {
            if (e.languageIdentifier.id === _this._languageIdentifier.id) {
                _this._onDidChangeLanguageConfiguration.fire({});
            }
        });
        _this._instanceId = __WEBPACK_IMPORTED_MODULE_3__base_common_strings_js__["M" /* singleLetterHash */](MODEL_ID);
        _this._lastDecorationId = 0;
        _this._decorations = Object.create(null);
        _this._decorationsTree = new DecorationsTrees();
        _this._commandManager = new __WEBPACK_IMPORTED_MODULE_10__editStack_js__["a" /* EditStack */](_this);
        _this._isUndoing = false;
        _this._isRedoing = false;
        _this._trimAutoWhitespaceLines = null;
        _this._tokens = new __WEBPACK_IMPORTED_MODULE_23__tokensStore_js__["d" /* TokensStore */]();
        _this._tokens2 = new __WEBPACK_IMPORTED_MODULE_23__tokensStore_js__["e" /* TokensStore2 */]();
        _this._tokenization = new __WEBPACK_IMPORTED_MODULE_16__textModelTokens_js__["a" /* TextModelTokenization */](_this);
        return _this;
    }
    TextModel.createFromString = function (text, options, languageIdentifier, uri) {
        if (options === void 0) { options = TextModel.DEFAULT_CREATION_OPTIONS; }
        if (languageIdentifier === void 0) { languageIdentifier = null; }
        if (uri === void 0) { uri = null; }
        return new TextModel(text, options, languageIdentifier, uri);
    };
    TextModel.resolveOptions = function (textBuffer, options) {
        if (options.detectIndentation) {
            var guessedIndentation = Object(__WEBPACK_IMPORTED_MODULE_11__indentationGuesser_js__["a" /* guessIndentation */])(textBuffer, options.tabSize, options.insertSpaces);
            return new __WEBPACK_IMPORTED_MODULE_9__model_js__["e" /* TextModelResolvedOptions */]({
                tabSize: guessedIndentation.tabSize,
                indentSize: guessedIndentation.tabSize,
                insertSpaces: guessedIndentation.insertSpaces,
                trimAutoWhitespace: options.trimAutoWhitespace,
                defaultEOL: options.defaultEOL
            });
        }
        return new __WEBPACK_IMPORTED_MODULE_9__model_js__["e" /* TextModelResolvedOptions */]({
            tabSize: options.tabSize,
            indentSize: options.indentSize,
            insertSpaces: options.insertSpaces,
            trimAutoWhitespace: options.trimAutoWhitespace,
            defaultEOL: options.defaultEOL
        });
    };
    TextModel.prototype.onDidChangeRawContentFast = function (listener) {
        return this._eventEmitter.fastEvent(function (e) { return listener(e.rawContentChangedEvent); });
    };
    TextModel.prototype.onDidChangeRawContent = function (listener) {
        return this._eventEmitter.slowEvent(function (e) { return listener(e.rawContentChangedEvent); });
    };
    TextModel.prototype.onDidChangeContentFast = function (listener) {
        return this._eventEmitter.fastEvent(function (e) { return listener(e.contentChangedEvent); });
    };
    TextModel.prototype.onDidChangeContent = function (listener) {
        return this._eventEmitter.slowEvent(function (e) { return listener(e.contentChangedEvent); });
    };
    TextModel.prototype.dispose = function () {
        this._isDisposing = true;
        this._onWillDispose.fire();
        this._languageRegistryListener.dispose();
        this._tokenization.dispose();
        this._isDisposed = true;
        _super.prototype.dispose.call(this);
        this._isDisposing = false;
    };
    TextModel.prototype._assertNotDisposed = function () {
        if (this._isDisposed) {
            throw new Error('Model is disposed!');
        }
    };
    TextModel.prototype._emitContentChangedEvent = function (rawChange, change) {
        if (this._isDisposing) {
            // Do not confuse listeners by emitting any event after disposing
            return;
        }
        this._eventEmitter.fire(new __WEBPACK_IMPORTED_MODULE_14__textModelEvents_js__["a" /* InternalModelContentChangeEvent */](rawChange, change));
    };
    TextModel.prototype.setValue = function (value) {
        this._assertNotDisposed();
        if (value === null) {
            // There's nothing to do
            return;
        }
        var textBuffer = createTextBuffer(value, this._options.defaultEOL);
        this.setValueFromTextBuffer(textBuffer);
    };
    TextModel.prototype._createContentChanged2 = function (range, rangeOffset, rangeLength, text, isUndoing, isRedoing, isFlush) {
        return {
            changes: [{
                    range: range,
                    rangeOffset: rangeOffset,
                    rangeLength: rangeLength,
                    text: text,
                }],
            eol: this._buffer.getEOL(),
            versionId: this.getVersionId(),
            isUndoing: isUndoing,
            isRedoing: isRedoing,
            isFlush: isFlush
        };
    };
    TextModel.prototype.setValueFromTextBuffer = function (textBuffer) {
        this._assertNotDisposed();
        if (textBuffer === null) {
            // There's nothing to do
            return;
        }
        var oldFullModelRange = this.getFullModelRange();
        var oldModelValueLength = this.getValueLengthInRange(oldFullModelRange);
        var endLineNumber = this.getLineCount();
        var endColumn = this.getLineMaxColumn(endLineNumber);
        this._buffer = textBuffer;
        this._increaseVersionId();
        // Flush all tokens
        this._tokens.flush();
        this._tokens2.flush();
        // Destroy all my decorations
        this._decorations = Object.create(null);
        this._decorationsTree = new DecorationsTrees();
        // Destroy my edit history and settings
        this._commandManager = new __WEBPACK_IMPORTED_MODULE_10__editStack_js__["a" /* EditStack */](this);
        this._trimAutoWhitespaceLines = null;
        this._emitContentChangedEvent(new __WEBPACK_IMPORTED_MODULE_14__textModelEvents_js__["b" /* ModelRawContentChangedEvent */]([
            new __WEBPACK_IMPORTED_MODULE_14__textModelEvents_js__["d" /* ModelRawFlush */]()
        ], this._versionId, false, false), this._createContentChanged2(new __WEBPACK_IMPORTED_MODULE_7__core_range_js__["a" /* Range */](1, 1, endLineNumber, endColumn), 0, oldModelValueLength, this.getValue(), false, false, true));
    };
    TextModel.prototype.setEOL = function (eol) {
        this._assertNotDisposed();
        var newEOL = (eol === 1 /* CRLF */ ? '\r\n' : '\n');
        if (this._buffer.getEOL() === newEOL) {
            // Nothing to do
            return;
        }
        var oldFullModelRange = this.getFullModelRange();
        var oldModelValueLength = this.getValueLengthInRange(oldFullModelRange);
        var endLineNumber = this.getLineCount();
        var endColumn = this.getLineMaxColumn(endLineNumber);
        this._onBeforeEOLChange();
        this._buffer.setEOL(newEOL);
        this._increaseVersionId();
        this._onAfterEOLChange();
        this._emitContentChangedEvent(new __WEBPACK_IMPORTED_MODULE_14__textModelEvents_js__["b" /* ModelRawContentChangedEvent */]([
            new __WEBPACK_IMPORTED_MODULE_14__textModelEvents_js__["c" /* ModelRawEOLChanged */]()
        ], this._versionId, false, false), this._createContentChanged2(new __WEBPACK_IMPORTED_MODULE_7__core_range_js__["a" /* Range */](1, 1, endLineNumber, endColumn), 0, oldModelValueLength, this.getValue(), false, false, false));
    };
    TextModel.prototype._onBeforeEOLChange = function () {
        // Ensure all decorations get their `range` set.
        var versionId = this.getVersionId();
        var allDecorations = this._decorationsTree.search(0, false, false, versionId);
        this._ensureNodesHaveRanges(allDecorations);
    };
    TextModel.prototype._onAfterEOLChange = function () {
        // Transform back `range` to offsets
        var versionId = this.getVersionId();
        var allDecorations = this._decorationsTree.collectNodesPostOrder();
        for (var i = 0, len = allDecorations.length; i < len; i++) {
            var node = allDecorations[i];
            var delta = node.cachedAbsoluteStart - node.start;
            var startOffset = this._buffer.getOffsetAt(node.range.startLineNumber, node.range.startColumn);
            var endOffset = this._buffer.getOffsetAt(node.range.endLineNumber, node.range.endColumn);
            node.cachedAbsoluteStart = startOffset;
            node.cachedAbsoluteEnd = endOffset;
            node.cachedVersionId = versionId;
            node.start = startOffset - delta;
            node.end = endOffset - delta;
            Object(__WEBPACK_IMPORTED_MODULE_12__intervalTree_js__["d" /* recomputeMaxEnd */])(node);
        }
    };
    TextModel.prototype.onBeforeAttached = function () {
        this._attachedEditorCount++;
        if (this._attachedEditorCount === 1) {
            this._onDidChangeAttached.fire(undefined);
        }
    };
    TextModel.prototype.onBeforeDetached = function () {
        this._attachedEditorCount--;
        if (this._attachedEditorCount === 0) {
            this._onDidChangeAttached.fire(undefined);
        }
    };
    TextModel.prototype.isAttachedToEditor = function () {
        return this._attachedEditorCount > 0;
    };
    TextModel.prototype.getAttachedEditorCount = function () {
        return this._attachedEditorCount;
    };
    TextModel.prototype.isTooLargeForSyncing = function () {
        return this._isTooLargeForSyncing;
    };
    TextModel.prototype.isTooLargeForTokenization = function () {
        return this._isTooLargeForTokenization;
    };
    TextModel.prototype.isDisposed = function () {
        return this._isDisposed;
    };
    TextModel.prototype.isDominatedByLongLines = function () {
        this._assertNotDisposed();
        if (this.isTooLargeForTokenization()) {
            // Cannot word wrap huge files anyways, so it doesn't really matter
            return false;
        }
        var smallLineCharCount = 0;
        var longLineCharCount = 0;
        var lineCount = this._buffer.getLineCount();
        for (var lineNumber = 1; lineNumber <= lineCount; lineNumber++) {
            var lineLength = this._buffer.getLineLength(lineNumber);
            if (lineLength >= LONG_LINE_BOUNDARY) {
                longLineCharCount += lineLength;
            }
            else {
                smallLineCharCount += lineLength;
            }
        }
        return (longLineCharCount > smallLineCharCount);
    };
    Object.defineProperty(TextModel.prototype, "uri", {
        get: function () {
            return this._associatedResource;
        },
        enumerable: true,
        configurable: true
    });
    //#region Options
    TextModel.prototype.getOptions = function () {
        this._assertNotDisposed();
        return this._options;
    };
    TextModel.prototype.getFormattingOptions = function () {
        return {
            tabSize: this._options.indentSize,
            insertSpaces: this._options.insertSpaces
        };
    };
    TextModel.prototype.updateOptions = function (_newOpts) {
        this._assertNotDisposed();
        var tabSize = (typeof _newOpts.tabSize !== 'undefined') ? _newOpts.tabSize : this._options.tabSize;
        var indentSize = (typeof _newOpts.indentSize !== 'undefined') ? _newOpts.indentSize : this._options.indentSize;
        var insertSpaces = (typeof _newOpts.insertSpaces !== 'undefined') ? _newOpts.insertSpaces : this._options.insertSpaces;
        var trimAutoWhitespace = (typeof _newOpts.trimAutoWhitespace !== 'undefined') ? _newOpts.trimAutoWhitespace : this._options.trimAutoWhitespace;
        var newOpts = new __WEBPACK_IMPORTED_MODULE_9__model_js__["e" /* TextModelResolvedOptions */]({
            tabSize: tabSize,
            indentSize: indentSize,
            insertSpaces: insertSpaces,
            defaultEOL: this._options.defaultEOL,
            trimAutoWhitespace: trimAutoWhitespace
        });
        if (this._options.equals(newOpts)) {
            return;
        }
        var e = this._options.createChangeEvent(newOpts);
        this._options = newOpts;
        this._onDidChangeOptions.fire(e);
    };
    TextModel.prototype.detectIndentation = function (defaultInsertSpaces, defaultTabSize) {
        this._assertNotDisposed();
        var guessedIndentation = Object(__WEBPACK_IMPORTED_MODULE_11__indentationGuesser_js__["a" /* guessIndentation */])(this._buffer, defaultTabSize, defaultInsertSpaces);
        this.updateOptions({
            insertSpaces: guessedIndentation.insertSpaces,
            tabSize: guessedIndentation.tabSize,
            indentSize: guessedIndentation.tabSize,
        });
    };
    TextModel._normalizeIndentationFromWhitespace = function (str, indentSize, insertSpaces) {
        var spacesCnt = 0;
        for (var i = 0; i < str.length; i++) {
            if (str.charAt(i) === '\t') {
                spacesCnt += indentSize;
            }
            else {
                spacesCnt++;
            }
        }
        var result = '';
        if (!insertSpaces) {
            var tabsCnt = Math.floor(spacesCnt / indentSize);
            spacesCnt = spacesCnt % indentSize;
            for (var i = 0; i < tabsCnt; i++) {
                result += '\t';
            }
        }
        for (var i = 0; i < spacesCnt; i++) {
            result += ' ';
        }
        return result;
    };
    TextModel.normalizeIndentation = function (str, indentSize, insertSpaces) {
        var firstNonWhitespaceIndex = __WEBPACK_IMPORTED_MODULE_3__base_common_strings_js__["q" /* firstNonWhitespaceIndex */](str);
        if (firstNonWhitespaceIndex === -1) {
            firstNonWhitespaceIndex = str.length;
        }
        return TextModel._normalizeIndentationFromWhitespace(str.substring(0, firstNonWhitespaceIndex), indentSize, insertSpaces) + str.substring(firstNonWhitespaceIndex);
    };
    TextModel.prototype.normalizeIndentation = function (str) {
        this._assertNotDisposed();
        return TextModel.normalizeIndentation(str, this._options.indentSize, this._options.insertSpaces);
    };
    //#endregion
    //#region Reading
    TextModel.prototype.getVersionId = function () {
        this._assertNotDisposed();
        return this._versionId;
    };
    TextModel.prototype.mightContainRTL = function () {
        return this._buffer.mightContainRTL();
    };
    TextModel.prototype.mightContainNonBasicASCII = function () {
        return this._buffer.mightContainNonBasicASCII();
    };
    TextModel.prototype.getAlternativeVersionId = function () {
        this._assertNotDisposed();
        return this._alternativeVersionId;
    };
    TextModel.prototype.getOffsetAt = function (rawPosition) {
        this._assertNotDisposed();
        var position = this._validatePosition(rawPosition.lineNumber, rawPosition.column, 0 /* Relaxed */);
        return this._buffer.getOffsetAt(position.lineNumber, position.column);
    };
    TextModel.prototype.getPositionAt = function (rawOffset) {
        this._assertNotDisposed();
        var offset = (Math.min(this._buffer.getLength(), Math.max(0, rawOffset)));
        return this._buffer.getPositionAt(offset);
    };
    TextModel.prototype._increaseVersionId = function () {
        this._versionId = this._versionId + 1;
        this._alternativeVersionId = this._versionId;
    };
    TextModel.prototype._overwriteAlternativeVersionId = function (newAlternativeVersionId) {
        this._alternativeVersionId = newAlternativeVersionId;
    };
    TextModel.prototype.getValue = function (eol, preserveBOM) {
        if (preserveBOM === void 0) { preserveBOM = false; }
        this._assertNotDisposed();
        var fullModelRange = this.getFullModelRange();
        var fullModelValue = this.getValueInRange(fullModelRange, eol);
        if (preserveBOM) {
            return this._buffer.getBOM() + fullModelValue;
        }
        return fullModelValue;
    };
    TextModel.prototype.getValueLength = function (eol, preserveBOM) {
        if (preserveBOM === void 0) { preserveBOM = false; }
        this._assertNotDisposed();
        var fullModelRange = this.getFullModelRange();
        var fullModelValue = this.getValueLengthInRange(fullModelRange, eol);
        if (preserveBOM) {
            return this._buffer.getBOM().length + fullModelValue;
        }
        return fullModelValue;
    };
    TextModel.prototype.getValueInRange = function (rawRange, eol) {
        if (eol === void 0) { eol = 0 /* TextDefined */; }
        this._assertNotDisposed();
        return this._buffer.getValueInRange(this.validateRange(rawRange), eol);
    };
    TextModel.prototype.getValueLengthInRange = function (rawRange, eol) {
        if (eol === void 0) { eol = 0 /* TextDefined */; }
        this._assertNotDisposed();
        return this._buffer.getValueLengthInRange(this.validateRange(rawRange), eol);
    };
    TextModel.prototype.getCharacterCountInRange = function (rawRange, eol) {
        if (eol === void 0) { eol = 0 /* TextDefined */; }
        this._assertNotDisposed();
        return this._buffer.getCharacterCountInRange(this.validateRange(rawRange), eol);
    };
    TextModel.prototype.getLineCount = function () {
        this._assertNotDisposed();
        return this._buffer.getLineCount();
    };
    TextModel.prototype.getLineContent = function (lineNumber) {
        this._assertNotDisposed();
        if (lineNumber < 1 || lineNumber > this.getLineCount()) {
            throw new Error('Illegal value for lineNumber');
        }
        return this._buffer.getLineContent(lineNumber);
    };
    TextModel.prototype.getLineLength = function (lineNumber) {
        this._assertNotDisposed();
        if (lineNumber < 1 || lineNumber > this.getLineCount()) {
            throw new Error('Illegal value for lineNumber');
        }
        return this._buffer.getLineLength(lineNumber);
    };
    TextModel.prototype.getLinesContent = function () {
        this._assertNotDisposed();
        return this._buffer.getLinesContent();
    };
    TextModel.prototype.getEOL = function () {
        this._assertNotDisposed();
        return this._buffer.getEOL();
    };
    TextModel.prototype.getLineMinColumn = function (lineNumber) {
        this._assertNotDisposed();
        return 1;
    };
    TextModel.prototype.getLineMaxColumn = function (lineNumber) {
        this._assertNotDisposed();
        if (lineNumber < 1 || lineNumber > this.getLineCount()) {
            throw new Error('Illegal value for lineNumber');
        }
        return this._buffer.getLineLength(lineNumber) + 1;
    };
    TextModel.prototype.getLineFirstNonWhitespaceColumn = function (lineNumber) {
        this._assertNotDisposed();
        if (lineNumber < 1 || lineNumber > this.getLineCount()) {
            throw new Error('Illegal value for lineNumber');
        }
        return this._buffer.getLineFirstNonWhitespaceColumn(lineNumber);
    };
    TextModel.prototype.getLineLastNonWhitespaceColumn = function (lineNumber) {
        this._assertNotDisposed();
        if (lineNumber < 1 || lineNumber > this.getLineCount()) {
            throw new Error('Illegal value for lineNumber');
        }
        return this._buffer.getLineLastNonWhitespaceColumn(lineNumber);
    };
    /**
     * Validates `range` is within buffer bounds, but allows it to sit in between surrogate pairs, etc.
     * Will try to not allocate if possible.
     */
    TextModel.prototype._validateRangeRelaxedNoAllocations = function (range) {
        var linesCount = this._buffer.getLineCount();
        var initialStartLineNumber = range.startLineNumber;
        var initialStartColumn = range.startColumn;
        var startLineNumber;
        var startColumn;
        if (initialStartLineNumber < 1) {
            startLineNumber = 1;
            startColumn = 1;
        }
        else if (initialStartLineNumber > linesCount) {
            startLineNumber = linesCount;
            startColumn = this.getLineMaxColumn(startLineNumber);
        }
        else {
            startLineNumber = initialStartLineNumber | 0;
            if (initialStartColumn <= 1) {
                startColumn = 1;
            }
            else {
                var maxColumn = this.getLineMaxColumn(startLineNumber);
                if (initialStartColumn >= maxColumn) {
                    startColumn = maxColumn;
                }
                else {
                    startColumn = initialStartColumn | 0;
                }
            }
        }
        var initialEndLineNumber = range.endLineNumber;
        var initialEndColumn = range.endColumn;
        var endLineNumber;
        var endColumn;
        if (initialEndLineNumber < 1) {
            endLineNumber = 1;
            endColumn = 1;
        }
        else if (initialEndLineNumber > linesCount) {
            endLineNumber = linesCount;
            endColumn = this.getLineMaxColumn(endLineNumber);
        }
        else {
            endLineNumber = initialEndLineNumber | 0;
            if (initialEndColumn <= 1) {
                endColumn = 1;
            }
            else {
                var maxColumn = this.getLineMaxColumn(endLineNumber);
                if (initialEndColumn >= maxColumn) {
                    endColumn = maxColumn;
                }
                else {
                    endColumn = initialEndColumn | 0;
                }
            }
        }
        if (initialStartLineNumber === startLineNumber
            && initialStartColumn === startColumn
            && initialEndLineNumber === endLineNumber
            && initialEndColumn === endColumn
            && range instanceof __WEBPACK_IMPORTED_MODULE_7__core_range_js__["a" /* Range */]
            && !(range instanceof __WEBPACK_IMPORTED_MODULE_8__core_selection_js__["a" /* Selection */])) {
            return range;
        }
        return new __WEBPACK_IMPORTED_MODULE_7__core_range_js__["a" /* Range */](startLineNumber, startColumn, endLineNumber, endColumn);
    };
    TextModel.prototype._isValidPosition = function (lineNumber, column, validationType) {
        if (typeof lineNumber !== 'number' || typeof column !== 'number') {
            return false;
        }
        if (isNaN(lineNumber) || isNaN(column)) {
            return false;
        }
        if (lineNumber < 1 || column < 1) {
            return false;
        }
        if ((lineNumber | 0) !== lineNumber || (column | 0) !== column) {
            return false;
        }
        var lineCount = this._buffer.getLineCount();
        if (lineNumber > lineCount) {
            return false;
        }
        if (column === 1) {
            return true;
        }
        var maxColumn = this.getLineMaxColumn(lineNumber);
        if (column > maxColumn) {
            return false;
        }
        if (validationType === 1 /* SurrogatePairs */) {
            // !!At this point, column > 1
            var charCodeBefore = this._buffer.getLineCharCode(lineNumber, column - 2);
            if (__WEBPACK_IMPORTED_MODULE_3__base_common_strings_js__["z" /* isHighSurrogate */](charCodeBefore)) {
                return false;
            }
        }
        return true;
    };
    TextModel.prototype._validatePosition = function (_lineNumber, _column, validationType) {
        var lineNumber = Math.floor((typeof _lineNumber === 'number' && !isNaN(_lineNumber)) ? _lineNumber : 1);
        var column = Math.floor((typeof _column === 'number' && !isNaN(_column)) ? _column : 1);
        var lineCount = this._buffer.getLineCount();
        if (lineNumber < 1) {
            return new __WEBPACK_IMPORTED_MODULE_6__core_position_js__["a" /* Position */](1, 1);
        }
        if (lineNumber > lineCount) {
            return new __WEBPACK_IMPORTED_MODULE_6__core_position_js__["a" /* Position */](lineCount, this.getLineMaxColumn(lineCount));
        }
        if (column <= 1) {
            return new __WEBPACK_IMPORTED_MODULE_6__core_position_js__["a" /* Position */](lineNumber, 1);
        }
        var maxColumn = this.getLineMaxColumn(lineNumber);
        if (column >= maxColumn) {
            return new __WEBPACK_IMPORTED_MODULE_6__core_position_js__["a" /* Position */](lineNumber, maxColumn);
        }
        if (validationType === 1 /* SurrogatePairs */) {
            // If the position would end up in the middle of a high-low surrogate pair,
            // we move it to before the pair
            // !!At this point, column > 1
            var charCodeBefore = this._buffer.getLineCharCode(lineNumber, column - 2);
            if (__WEBPACK_IMPORTED_MODULE_3__base_common_strings_js__["z" /* isHighSurrogate */](charCodeBefore)) {
                return new __WEBPACK_IMPORTED_MODULE_6__core_position_js__["a" /* Position */](lineNumber, column - 1);
            }
        }
        return new __WEBPACK_IMPORTED_MODULE_6__core_position_js__["a" /* Position */](lineNumber, column);
    };
    TextModel.prototype.validatePosition = function (position) {
        var validationType = 1 /* SurrogatePairs */;
        this._assertNotDisposed();
        // Avoid object allocation and cover most likely case
        if (position instanceof __WEBPACK_IMPORTED_MODULE_6__core_position_js__["a" /* Position */]) {
            if (this._isValidPosition(position.lineNumber, position.column, validationType)) {
                return position;
            }
        }
        return this._validatePosition(position.lineNumber, position.column, validationType);
    };
    TextModel.prototype._isValidRange = function (range, validationType) {
        var startLineNumber = range.startLineNumber;
        var startColumn = range.startColumn;
        var endLineNumber = range.endLineNumber;
        var endColumn = range.endColumn;
        if (!this._isValidPosition(startLineNumber, startColumn, 0 /* Relaxed */)) {
            return false;
        }
        if (!this._isValidPosition(endLineNumber, endColumn, 0 /* Relaxed */)) {
            return false;
        }
        if (validationType === 1 /* SurrogatePairs */) {
            var charCodeBeforeStart = (startColumn > 1 ? this._buffer.getLineCharCode(startLineNumber, startColumn - 2) : 0);
            var charCodeBeforeEnd = (endColumn > 1 && endColumn <= this._buffer.getLineLength(endLineNumber) ? this._buffer.getLineCharCode(endLineNumber, endColumn - 2) : 0);
            var startInsideSurrogatePair = __WEBPACK_IMPORTED_MODULE_3__base_common_strings_js__["z" /* isHighSurrogate */](charCodeBeforeStart);
            var endInsideSurrogatePair = __WEBPACK_IMPORTED_MODULE_3__base_common_strings_js__["z" /* isHighSurrogate */](charCodeBeforeEnd);
            if (!startInsideSurrogatePair && !endInsideSurrogatePair) {
                return true;
            }
            return false;
        }
        return true;
    };
    TextModel.prototype.validateRange = function (_range) {
        var validationType = 1 /* SurrogatePairs */;
        this._assertNotDisposed();
        // Avoid object allocation and cover most likely case
        if ((_range instanceof __WEBPACK_IMPORTED_MODULE_7__core_range_js__["a" /* Range */]) && !(_range instanceof __WEBPACK_IMPORTED_MODULE_8__core_selection_js__["a" /* Selection */])) {
            if (this._isValidRange(_range, validationType)) {
                return _range;
            }
        }
        var start = this._validatePosition(_range.startLineNumber, _range.startColumn, 0 /* Relaxed */);
        var end = this._validatePosition(_range.endLineNumber, _range.endColumn, 0 /* Relaxed */);
        var startLineNumber = start.lineNumber;
        var startColumn = start.column;
        var endLineNumber = end.lineNumber;
        var endColumn = end.column;
        if (validationType === 1 /* SurrogatePairs */) {
            var charCodeBeforeStart = (startColumn > 1 ? this._buffer.getLineCharCode(startLineNumber, startColumn - 2) : 0);
            var charCodeBeforeEnd = (endColumn > 1 && endColumn <= this._buffer.getLineLength(endLineNumber) ? this._buffer.getLineCharCode(endLineNumber, endColumn - 2) : 0);
            var startInsideSurrogatePair = __WEBPACK_IMPORTED_MODULE_3__base_common_strings_js__["z" /* isHighSurrogate */](charCodeBeforeStart);
            var endInsideSurrogatePair = __WEBPACK_IMPORTED_MODULE_3__base_common_strings_js__["z" /* isHighSurrogate */](charCodeBeforeEnd);
            if (!startInsideSurrogatePair && !endInsideSurrogatePair) {
                return new __WEBPACK_IMPORTED_MODULE_7__core_range_js__["a" /* Range */](startLineNumber, startColumn, endLineNumber, endColumn);
            }
            if (startLineNumber === endLineNumber && startColumn === endColumn) {
                // do not expand a collapsed range, simply move it to a valid location
                return new __WEBPACK_IMPORTED_MODULE_7__core_range_js__["a" /* Range */](startLineNumber, startColumn - 1, endLineNumber, endColumn - 1);
            }
            if (startInsideSurrogatePair && endInsideSurrogatePair) {
                // expand range at both ends
                return new __WEBPACK_IMPORTED_MODULE_7__core_range_js__["a" /* Range */](startLineNumber, startColumn - 1, endLineNumber, endColumn + 1);
            }
            if (startInsideSurrogatePair) {
                // only expand range at the start
                return new __WEBPACK_IMPORTED_MODULE_7__core_range_js__["a" /* Range */](startLineNumber, startColumn - 1, endLineNumber, endColumn);
            }
            // only expand range at the end
            return new __WEBPACK_IMPORTED_MODULE_7__core_range_js__["a" /* Range */](startLineNumber, startColumn, endLineNumber, endColumn + 1);
        }
        return new __WEBPACK_IMPORTED_MODULE_7__core_range_js__["a" /* Range */](startLineNumber, startColumn, endLineNumber, endColumn);
    };
    TextModel.prototype.modifyPosition = function (rawPosition, offset) {
        this._assertNotDisposed();
        var candidate = this.getOffsetAt(rawPosition) + offset;
        return this.getPositionAt(Math.min(this._buffer.getLength(), Math.max(0, candidate)));
    };
    TextModel.prototype.getFullModelRange = function () {
        this._assertNotDisposed();
        var lineCount = this.getLineCount();
        return new __WEBPACK_IMPORTED_MODULE_7__core_range_js__["a" /* Range */](1, 1, lineCount, this.getLineMaxColumn(lineCount));
    };
    TextModel.prototype.findMatchesLineByLine = function (searchRange, searchData, captureMatches, limitResultCount) {
        return this._buffer.findMatchesLineByLine(searchRange, searchData, captureMatches, limitResultCount);
    };
    TextModel.prototype.findMatches = function (searchString, rawSearchScope, isRegex, matchCase, wordSeparators, captureMatches, limitResultCount) {
        if (limitResultCount === void 0) { limitResultCount = LIMIT_FIND_COUNT; }
        this._assertNotDisposed();
        var searchRange;
        if (__WEBPACK_IMPORTED_MODULE_7__core_range_js__["a" /* Range */].isIRange(rawSearchScope)) {
            searchRange = this.validateRange(rawSearchScope);
        }
        else {
            searchRange = this.getFullModelRange();
        }
        if (!isRegex && searchString.indexOf('\n') < 0) {
            // not regex, not multi line
            var searchParams = new __WEBPACK_IMPORTED_MODULE_15__textModelSearch_js__["a" /* SearchParams */](searchString, isRegex, matchCase, wordSeparators);
            var searchData = searchParams.parseSearchRequest();
            if (!searchData) {
                return [];
            }
            return this.findMatchesLineByLine(searchRange, searchData, captureMatches, limitResultCount);
        }
        return __WEBPACK_IMPORTED_MODULE_15__textModelSearch_js__["c" /* TextModelSearch */].findMatches(this, new __WEBPACK_IMPORTED_MODULE_15__textModelSearch_js__["a" /* SearchParams */](searchString, isRegex, matchCase, wordSeparators), searchRange, captureMatches, limitResultCount);
    };
    TextModel.prototype.findNextMatch = function (searchString, rawSearchStart, isRegex, matchCase, wordSeparators, captureMatches) {
        this._assertNotDisposed();
        var searchStart = this.validatePosition(rawSearchStart);
        if (!isRegex && searchString.indexOf('\n') < 0) {
            var searchParams = new __WEBPACK_IMPORTED_MODULE_15__textModelSearch_js__["a" /* SearchParams */](searchString, isRegex, matchCase, wordSeparators);
            var searchData = searchParams.parseSearchRequest();
            if (!searchData) {
                return null;
            }
            var lineCount = this.getLineCount();
            var searchRange = new __WEBPACK_IMPORTED_MODULE_7__core_range_js__["a" /* Range */](searchStart.lineNumber, searchStart.column, lineCount, this.getLineMaxColumn(lineCount));
            var ret = this.findMatchesLineByLine(searchRange, searchData, captureMatches, 1);
            __WEBPACK_IMPORTED_MODULE_15__textModelSearch_js__["c" /* TextModelSearch */].findNextMatch(this, new __WEBPACK_IMPORTED_MODULE_15__textModelSearch_js__["a" /* SearchParams */](searchString, isRegex, matchCase, wordSeparators), searchStart, captureMatches);
            if (ret.length > 0) {
                return ret[0];
            }
            searchRange = new __WEBPACK_IMPORTED_MODULE_7__core_range_js__["a" /* Range */](1, 1, searchStart.lineNumber, this.getLineMaxColumn(searchStart.lineNumber));
            ret = this.findMatchesLineByLine(searchRange, searchData, captureMatches, 1);
            if (ret.length > 0) {
                return ret[0];
            }
            return null;
        }
        return __WEBPACK_IMPORTED_MODULE_15__textModelSearch_js__["c" /* TextModelSearch */].findNextMatch(this, new __WEBPACK_IMPORTED_MODULE_15__textModelSearch_js__["a" /* SearchParams */](searchString, isRegex, matchCase, wordSeparators), searchStart, captureMatches);
    };
    TextModel.prototype.findPreviousMatch = function (searchString, rawSearchStart, isRegex, matchCase, wordSeparators, captureMatches) {
        this._assertNotDisposed();
        var searchStart = this.validatePosition(rawSearchStart);
        return __WEBPACK_IMPORTED_MODULE_15__textModelSearch_js__["c" /* TextModelSearch */].findPreviousMatch(this, new __WEBPACK_IMPORTED_MODULE_15__textModelSearch_js__["a" /* SearchParams */](searchString, isRegex, matchCase, wordSeparators), searchStart, captureMatches);
    };
    //#endregion
    //#region Editing
    TextModel.prototype.pushStackElement = function () {
        this._commandManager.pushStackElement();
    };
    TextModel.prototype.pushEOL = function (eol) {
        var currentEOL = (this.getEOL() === '\n' ? 0 /* LF */ : 1 /* CRLF */);
        if (currentEOL === eol) {
            return;
        }
        try {
            this._onDidChangeDecorations.beginDeferredEmit();
            this._eventEmitter.beginDeferredEmit();
            this._commandManager.pushEOL(eol);
        }
        finally {
            this._eventEmitter.endDeferredEmit();
            this._onDidChangeDecorations.endDeferredEmit();
        }
    };
    TextModel.prototype.pushEditOperations = function (beforeCursorState, editOperations, cursorStateComputer) {
        try {
            this._onDidChangeDecorations.beginDeferredEmit();
            this._eventEmitter.beginDeferredEmit();
            return this._pushEditOperations(beforeCursorState, editOperations, cursorStateComputer);
        }
        finally {
            this._eventEmitter.endDeferredEmit();
            this._onDidChangeDecorations.endDeferredEmit();
        }
    };
    TextModel.prototype._pushEditOperations = function (beforeCursorState, editOperations, cursorStateComputer) {
        var _this = this;
        if (this._options.trimAutoWhitespace && this._trimAutoWhitespaceLines) {
            // Go through each saved line number and insert a trim whitespace edit
            // if it is safe to do so (no conflicts with other edits).
            var incomingEdits = editOperations.map(function (op) {
                return {
                    range: _this.validateRange(op.range),
                    text: op.text
                };
            });
            // Sometimes, auto-formatters change ranges automatically which can cause undesired auto whitespace trimming near the cursor
            // We'll use the following heuristic: if the edits occur near the cursor, then it's ok to trim auto whitespace
            var editsAreNearCursors = true;
            for (var i = 0, len = beforeCursorState.length; i < len; i++) {
                var sel = beforeCursorState[i];
                var foundEditNearSel = false;
                for (var j = 0, lenJ = incomingEdits.length; j < lenJ; j++) {
                    var editRange = incomingEdits[j].range;
                    var selIsAbove = editRange.startLineNumber > sel.endLineNumber;
                    var selIsBelow = sel.startLineNumber > editRange.endLineNumber;
                    if (!selIsAbove && !selIsBelow) {
                        foundEditNearSel = true;
                        break;
                    }
                }
                if (!foundEditNearSel) {
                    editsAreNearCursors = false;
                    break;
                }
            }
            if (editsAreNearCursors) {
                for (var i = 0, len = this._trimAutoWhitespaceLines.length; i < len; i++) {
                    var trimLineNumber = this._trimAutoWhitespaceLines[i];
                    var maxLineColumn = this.getLineMaxColumn(trimLineNumber);
                    var allowTrimLine = true;
                    for (var j = 0, lenJ = incomingEdits.length; j < lenJ; j++) {
                        var editRange = incomingEdits[j].range;
                        var editText = incomingEdits[j].text;
                        if (trimLineNumber < editRange.startLineNumber || trimLineNumber > editRange.endLineNumber) {
                            // `trimLine` is completely outside this edit
                            continue;
                        }
                        // At this point:
                        //   editRange.startLineNumber <= trimLine <= editRange.endLineNumber
                        if (trimLineNumber === editRange.startLineNumber && editRange.startColumn === maxLineColumn
                            && editRange.isEmpty() && editText && editText.length > 0 && editText.charAt(0) === '\n') {
                            // This edit inserts a new line (and maybe other text) after `trimLine`
                            continue;
                        }
                        if (trimLineNumber === editRange.startLineNumber && editRange.startColumn === 1
                            && editRange.isEmpty() && editText && editText.length > 0 && editText.charAt(editText.length - 1) === '\n') {
                            // This edit inserts a new line (and maybe other text) before `trimLine`
                            continue;
                        }
                        // Looks like we can't trim this line as it would interfere with an incoming edit
                        allowTrimLine = false;
                        break;
                    }
                    if (allowTrimLine) {
                        editOperations.push({
                            range: new __WEBPACK_IMPORTED_MODULE_7__core_range_js__["a" /* Range */](trimLineNumber, 1, trimLineNumber, maxLineColumn),
                            text: null
                        });
                    }
                }
            }
            this._trimAutoWhitespaceLines = null;
        }
        return this._commandManager.pushEditOperation(beforeCursorState, editOperations, cursorStateComputer);
    };
    TextModel.prototype.applyEdits = function (rawOperations) {
        try {
            this._onDidChangeDecorations.beginDeferredEmit();
            this._eventEmitter.beginDeferredEmit();
            return this._applyEdits(rawOperations);
        }
        finally {
            this._eventEmitter.endDeferredEmit();
            this._onDidChangeDecorations.endDeferredEmit();
        }
    };
    TextModel.prototype._applyEdits = function (rawOperations) {
        for (var i = 0, len = rawOperations.length; i < len; i++) {
            rawOperations[i].range = this.validateRange(rawOperations[i].range);
        }
        var oldLineCount = this._buffer.getLineCount();
        var result = this._buffer.applyEdits(rawOperations, this._options.trimAutoWhitespace);
        var newLineCount = this._buffer.getLineCount();
        var contentChanges = result.changes;
        this._trimAutoWhitespaceLines = result.trimAutoWhitespaceLineNumbers;
        if (contentChanges.length !== 0) {
            var rawContentChanges = [];
            var lineCount = oldLineCount;
            for (var i = 0, len = contentChanges.length; i < len; i++) {
                var change = contentChanges[i];
                var _a = Object(__WEBPACK_IMPORTED_MODULE_23__tokensStore_js__["f" /* countEOL */])(change.text), eolCount = _a[0], firstLineLength = _a[1], lastLineLength = _a[2];
                this._tokens.acceptEdit(change.range, eolCount, firstLineLength);
                this._tokens2.acceptEdit(change.range, eolCount, firstLineLength, lastLineLength, change.text.length > 0 ? change.text.charCodeAt(0) : 0 /* Null */);
                this._onDidChangeDecorations.fire();
                this._decorationsTree.acceptReplace(change.rangeOffset, change.rangeLength, change.text.length, change.forceMoveMarkers);
                var startLineNumber = change.range.startLineNumber;
                var endLineNumber = change.range.endLineNumber;
                var deletingLinesCnt = endLineNumber - startLineNumber;
                var insertingLinesCnt = eolCount;
                var editingLinesCnt = Math.min(deletingLinesCnt, insertingLinesCnt);
                var changeLineCountDelta = (insertingLinesCnt - deletingLinesCnt);
                for (var j = editingLinesCnt; j >= 0; j--) {
                    var editLineNumber = startLineNumber + j;
                    var currentEditLineNumber = newLineCount - lineCount - changeLineCountDelta + editLineNumber;
                    rawContentChanges.push(new __WEBPACK_IMPORTED_MODULE_14__textModelEvents_js__["e" /* ModelRawLineChanged */](editLineNumber, this.getLineContent(currentEditLineNumber)));
                }
                if (editingLinesCnt < deletingLinesCnt) {
                    // Must delete some lines
                    var spliceStartLineNumber = startLineNumber + editingLinesCnt;
                    rawContentChanges.push(new __WEBPACK_IMPORTED_MODULE_14__textModelEvents_js__["f" /* ModelRawLinesDeleted */](spliceStartLineNumber + 1, endLineNumber));
                }
                if (editingLinesCnt < insertingLinesCnt) {
                    // Must insert some lines
                    var spliceLineNumber = startLineNumber + editingLinesCnt;
                    var cnt = insertingLinesCnt - editingLinesCnt;
                    var fromLineNumber = newLineCount - lineCount - cnt + spliceLineNumber + 1;
                    var newLines = [];
                    for (var i_1 = 0; i_1 < cnt; i_1++) {
                        var lineNumber = fromLineNumber + i_1;
                        newLines[lineNumber - fromLineNumber] = this.getLineContent(lineNumber);
                    }
                    rawContentChanges.push(new __WEBPACK_IMPORTED_MODULE_14__textModelEvents_js__["g" /* ModelRawLinesInserted */](spliceLineNumber + 1, startLineNumber + insertingLinesCnt, newLines));
                }
                lineCount += changeLineCountDelta;
            }
            this._increaseVersionId();
            this._emitContentChangedEvent(new __WEBPACK_IMPORTED_MODULE_14__textModelEvents_js__["b" /* ModelRawContentChangedEvent */](rawContentChanges, this.getVersionId(), this._isUndoing, this._isRedoing), {
                changes: contentChanges,
                eol: this._buffer.getEOL(),
                versionId: this.getVersionId(),
                isUndoing: this._isUndoing,
                isRedoing: this._isRedoing,
                isFlush: false
            });
        }
        return result.reverseEdits;
    };
    TextModel.prototype._undo = function () {
        this._isUndoing = true;
        var r = this._commandManager.undo();
        this._isUndoing = false;
        if (!r) {
            return null;
        }
        this._overwriteAlternativeVersionId(r.recordedVersionId);
        return r.selections;
    };
    TextModel.prototype.undo = function () {
        try {
            this._onDidChangeDecorations.beginDeferredEmit();
            this._eventEmitter.beginDeferredEmit();
            return this._undo();
        }
        finally {
            this._eventEmitter.endDeferredEmit();
            this._onDidChangeDecorations.endDeferredEmit();
        }
    };
    TextModel.prototype.canUndo = function () {
        return this._commandManager.canUndo();
    };
    TextModel.prototype._redo = function () {
        this._isRedoing = true;
        var r = this._commandManager.redo();
        this._isRedoing = false;
        if (!r) {
            return null;
        }
        this._overwriteAlternativeVersionId(r.recordedVersionId);
        return r.selections;
    };
    TextModel.prototype.redo = function () {
        try {
            this._onDidChangeDecorations.beginDeferredEmit();
            this._eventEmitter.beginDeferredEmit();
            return this._redo();
        }
        finally {
            this._eventEmitter.endDeferredEmit();
            this._onDidChangeDecorations.endDeferredEmit();
        }
    };
    TextModel.prototype.canRedo = function () {
        return this._commandManager.canRedo();
    };
    //#endregion
    //#region Decorations
    TextModel.prototype.changeDecorations = function (callback, ownerId) {
        if (ownerId === void 0) { ownerId = 0; }
        this._assertNotDisposed();
        try {
            this._onDidChangeDecorations.beginDeferredEmit();
            return this._changeDecorations(ownerId, callback);
        }
        finally {
            this._onDidChangeDecorations.endDeferredEmit();
        }
    };
    TextModel.prototype._changeDecorations = function (ownerId, callback) {
        var _this = this;
        var changeAccessor = {
            addDecoration: function (range, options) {
                _this._onDidChangeDecorations.fire();
                return _this._deltaDecorationsImpl(ownerId, [], [{ range: range, options: options }])[0];
            },
            changeDecoration: function (id, newRange) {
                _this._onDidChangeDecorations.fire();
                _this._changeDecorationImpl(id, newRange);
            },
            changeDecorationOptions: function (id, options) {
                _this._onDidChangeDecorations.fire();
                _this._changeDecorationOptionsImpl(id, _normalizeOptions(options));
            },
            removeDecoration: function (id) {
                _this._onDidChangeDecorations.fire();
                _this._deltaDecorationsImpl(ownerId, [id], []);
            },
            deltaDecorations: function (oldDecorations, newDecorations) {
                if (oldDecorations.length === 0 && newDecorations.length === 0) {
                    // nothing to do
                    return [];
                }
                _this._onDidChangeDecorations.fire();
                return _this._deltaDecorationsImpl(ownerId, oldDecorations, newDecorations);
            }
        };
        var result = null;
        try {
            result = callback(changeAccessor);
        }
        catch (e) {
            Object(__WEBPACK_IMPORTED_MODULE_0__base_common_errors_js__["e" /* onUnexpectedError */])(e);
        }
        // Invalidate change accessor
        changeAccessor.addDecoration = invalidFunc;
        changeAccessor.changeDecoration = invalidFunc;
        changeAccessor.changeDecorationOptions = invalidFunc;
        changeAccessor.removeDecoration = invalidFunc;
        changeAccessor.deltaDecorations = invalidFunc;
        return result;
    };
    TextModel.prototype.deltaDecorations = function (oldDecorations, newDecorations, ownerId) {
        if (ownerId === void 0) { ownerId = 0; }
        this._assertNotDisposed();
        if (!oldDecorations) {
            oldDecorations = [];
        }
        if (oldDecorations.length === 0 && newDecorations.length === 0) {
            // nothing to do
            return [];
        }
        try {
            this._onDidChangeDecorations.beginDeferredEmit();
            this._onDidChangeDecorations.fire();
            return this._deltaDecorationsImpl(ownerId, oldDecorations, newDecorations);
        }
        finally {
            this._onDidChangeDecorations.endDeferredEmit();
        }
    };
    TextModel.prototype._getTrackedRange = function (id) {
        return this.getDecorationRange(id);
    };
    TextModel.prototype._setTrackedRange = function (id, newRange, newStickiness) {
        var node = (id ? this._decorations[id] : null);
        if (!node) {
            if (!newRange) {
                // node doesn't exist, the request is to delete => nothing to do
                return null;
            }
            // node doesn't exist, the request is to set => add the tracked range
            return this._deltaDecorationsImpl(0, [], [{ range: newRange, options: TRACKED_RANGE_OPTIONS[newStickiness] }])[0];
        }
        if (!newRange) {
            // node exists, the request is to delete => delete node
            this._decorationsTree.delete(node);
            delete this._decorations[node.id];
            return null;
        }
        // node exists, the request is to set => change the tracked range and its options
        var range = this._validateRangeRelaxedNoAllocations(newRange);
        var startOffset = this._buffer.getOffsetAt(range.startLineNumber, range.startColumn);
        var endOffset = this._buffer.getOffsetAt(range.endLineNumber, range.endColumn);
        this._decorationsTree.delete(node);
        node.reset(this.getVersionId(), startOffset, endOffset, range);
        node.setOptions(TRACKED_RANGE_OPTIONS[newStickiness]);
        this._decorationsTree.insert(node);
        return node.id;
    };
    TextModel.prototype.removeAllDecorationsWithOwnerId = function (ownerId) {
        if (this._isDisposed) {
            return;
        }
        var nodes = this._decorationsTree.collectNodesFromOwner(ownerId);
        for (var i = 0, len = nodes.length; i < len; i++) {
            var node = nodes[i];
            this._decorationsTree.delete(node);
            delete this._decorations[node.id];
        }
    };
    TextModel.prototype.getDecorationOptions = function (decorationId) {
        var node = this._decorations[decorationId];
        if (!node) {
            return null;
        }
        return node.options;
    };
    TextModel.prototype.getDecorationRange = function (decorationId) {
        var node = this._decorations[decorationId];
        if (!node) {
            return null;
        }
        var versionId = this.getVersionId();
        if (node.cachedVersionId !== versionId) {
            this._decorationsTree.resolveNode(node, versionId);
        }
        if (node.range === null) {
            node.range = this._getRangeAt(node.cachedAbsoluteStart, node.cachedAbsoluteEnd);
        }
        return node.range;
    };
    TextModel.prototype.getLineDecorations = function (lineNumber, ownerId, filterOutValidation) {
        if (ownerId === void 0) { ownerId = 0; }
        if (filterOutValidation === void 0) { filterOutValidation = false; }
        if (lineNumber < 1 || lineNumber > this.getLineCount()) {
            return [];
        }
        return this.getLinesDecorations(lineNumber, lineNumber, ownerId, filterOutValidation);
    };
    TextModel.prototype.getLinesDecorations = function (_startLineNumber, _endLineNumber, ownerId, filterOutValidation) {
        if (ownerId === void 0) { ownerId = 0; }
        if (filterOutValidation === void 0) { filterOutValidation = false; }
        var lineCount = this.getLineCount();
        var startLineNumber = Math.min(lineCount, Math.max(1, _startLineNumber));
        var endLineNumber = Math.min(lineCount, Math.max(1, _endLineNumber));
        var endColumn = this.getLineMaxColumn(endLineNumber);
        return this._getDecorationsInRange(new __WEBPACK_IMPORTED_MODULE_7__core_range_js__["a" /* Range */](startLineNumber, 1, endLineNumber, endColumn), ownerId, filterOutValidation);
    };
    TextModel.prototype.getDecorationsInRange = function (range, ownerId, filterOutValidation) {
        if (ownerId === void 0) { ownerId = 0; }
        if (filterOutValidation === void 0) { filterOutValidation = false; }
        var validatedRange = this.validateRange(range);
        return this._getDecorationsInRange(validatedRange, ownerId, filterOutValidation);
    };
    TextModel.prototype.getOverviewRulerDecorations = function (ownerId, filterOutValidation) {
        if (ownerId === void 0) { ownerId = 0; }
        if (filterOutValidation === void 0) { filterOutValidation = false; }
        var versionId = this.getVersionId();
        var result = this._decorationsTree.search(ownerId, filterOutValidation, true, versionId);
        return this._ensureNodesHaveRanges(result);
    };
    TextModel.prototype.getAllDecorations = function (ownerId, filterOutValidation) {
        if (ownerId === void 0) { ownerId = 0; }
        if (filterOutValidation === void 0) { filterOutValidation = false; }
        var versionId = this.getVersionId();
        var result = this._decorationsTree.search(ownerId, filterOutValidation, false, versionId);
        return this._ensureNodesHaveRanges(result);
    };
    TextModel.prototype._getDecorationsInRange = function (filterRange, filterOwnerId, filterOutValidation) {
        var startOffset = this._buffer.getOffsetAt(filterRange.startLineNumber, filterRange.startColumn);
        var endOffset = this._buffer.getOffsetAt(filterRange.endLineNumber, filterRange.endColumn);
        var versionId = this.getVersionId();
        var result = this._decorationsTree.intervalSearch(startOffset, endOffset, filterOwnerId, filterOutValidation, versionId);
        return this._ensureNodesHaveRanges(result);
    };
    TextModel.prototype._ensureNodesHaveRanges = function (nodes) {
        for (var i = 0, len = nodes.length; i < len; i++) {
            var node = nodes[i];
            if (node.range === null) {
                node.range = this._getRangeAt(node.cachedAbsoluteStart, node.cachedAbsoluteEnd);
            }
        }
        return nodes;
    };
    TextModel.prototype._getRangeAt = function (start, end) {
        return this._buffer.getRangeAt(start, end - start);
    };
    TextModel.prototype._changeDecorationImpl = function (decorationId, _range) {
        var node = this._decorations[decorationId];
        if (!node) {
            return;
        }
        var range = this._validateRangeRelaxedNoAllocations(_range);
        var startOffset = this._buffer.getOffsetAt(range.startLineNumber, range.startColumn);
        var endOffset = this._buffer.getOffsetAt(range.endLineNumber, range.endColumn);
        this._decorationsTree.delete(node);
        node.reset(this.getVersionId(), startOffset, endOffset, range);
        this._decorationsTree.insert(node);
    };
    TextModel.prototype._changeDecorationOptionsImpl = function (decorationId, options) {
        var node = this._decorations[decorationId];
        if (!node) {
            return;
        }
        var nodeWasInOverviewRuler = (node.options.overviewRuler && node.options.overviewRuler.color ? true : false);
        var nodeIsInOverviewRuler = (options.overviewRuler && options.overviewRuler.color ? true : false);
        if (nodeWasInOverviewRuler !== nodeIsInOverviewRuler) {
            // Delete + Insert due to an overview ruler status change
            this._decorationsTree.delete(node);
            node.setOptions(options);
            this._decorationsTree.insert(node);
        }
        else {
            node.setOptions(options);
        }
    };
    TextModel.prototype._deltaDecorationsImpl = function (ownerId, oldDecorationsIds, newDecorations) {
        var versionId = this.getVersionId();
        var oldDecorationsLen = oldDecorationsIds.length;
        var oldDecorationIndex = 0;
        var newDecorationsLen = newDecorations.length;
        var newDecorationIndex = 0;
        var result = new Array(newDecorationsLen);
        while (oldDecorationIndex < oldDecorationsLen || newDecorationIndex < newDecorationsLen) {
            var node = null;
            if (oldDecorationIndex < oldDecorationsLen) {
                // (1) get ourselves an old node
                do {
                    node = this._decorations[oldDecorationsIds[oldDecorationIndex++]];
                } while (!node && oldDecorationIndex < oldDecorationsLen);
                // (2) remove the node from the tree (if it exists)
                if (node) {
                    this._decorationsTree.delete(node);
                }
            }
            if (newDecorationIndex < newDecorationsLen) {
                // (3) create a new node if necessary
                if (!node) {
                    var internalDecorationId = (++this._lastDecorationId);
                    var decorationId = this._instanceId + ";" + internalDecorationId;
                    node = new __WEBPACK_IMPORTED_MODULE_12__intervalTree_js__["a" /* IntervalNode */](decorationId, 0, 0);
                    this._decorations[decorationId] = node;
                }
                // (4) initialize node
                var newDecoration = newDecorations[newDecorationIndex];
                var range = this._validateRangeRelaxedNoAllocations(newDecoration.range);
                var options = _normalizeOptions(newDecoration.options);
                var startOffset = this._buffer.getOffsetAt(range.startLineNumber, range.startColumn);
                var endOffset = this._buffer.getOffsetAt(range.endLineNumber, range.endColumn);
                node.ownerId = ownerId;
                node.reset(versionId, startOffset, endOffset, range);
                node.setOptions(options);
                this._decorationsTree.insert(node);
                result[newDecorationIndex] = node.id;
                newDecorationIndex++;
            }
            else {
                if (node) {
                    delete this._decorations[node.id];
                }
            }
        }
        return result;
    };
    //#endregion
    //#region Tokenization
    TextModel.prototype.setLineTokens = function (lineNumber, tokens) {
        if (lineNumber < 1 || lineNumber > this.getLineCount()) {
            throw new Error('Illegal value for lineNumber');
        }
        this._tokens.setTokens(this._languageIdentifier.id, lineNumber - 1, this._buffer.getLineLength(lineNumber), tokens);
    };
    TextModel.prototype.setTokens = function (tokens) {
        if (tokens.length === 0) {
            return;
        }
        var ranges = [];
        for (var i = 0, len = tokens.length; i < len; i++) {
            var element = tokens[i];
            ranges.push({ fromLineNumber: element.startLineNumber, toLineNumber: element.startLineNumber + element.tokens.length - 1 });
            for (var j = 0, lenJ = element.tokens.length; j < lenJ; j++) {
                this.setLineTokens(element.startLineNumber + j, element.tokens[j]);
            }
        }
        this._emitModelTokensChangedEvent({
            tokenizationSupportChanged: false,
            ranges: ranges
        });
    };
    TextModel.prototype.setSemanticTokens = function (tokens) {
        this._tokens2.set(tokens);
        this._emitModelTokensChangedEvent({
            tokenizationSupportChanged: false,
            ranges: [{ fromLineNumber: 1, toLineNumber: this.getLineCount() }]
        });
    };
    TextModel.prototype.tokenizeViewport = function (startLineNumber, endLineNumber) {
        startLineNumber = Math.max(1, startLineNumber);
        endLineNumber = Math.min(this._buffer.getLineCount(), endLineNumber);
        this._tokenization.tokenizeViewport(startLineNumber, endLineNumber);
    };
    TextModel.prototype.clearTokens = function () {
        this._tokens.flush();
        this._emitModelTokensChangedEvent({
            tokenizationSupportChanged: true,
            ranges: [{
                    fromLineNumber: 1,
                    toLineNumber: this._buffer.getLineCount()
                }]
        });
    };
    TextModel.prototype._emitModelTokensChangedEvent = function (e) {
        if (!this._isDisposing) {
            this._onDidChangeTokens.fire(e);
        }
    };
    TextModel.prototype.resetTokenization = function () {
        this._tokenization.reset();
    };
    TextModel.prototype.forceTokenization = function (lineNumber) {
        if (lineNumber < 1 || lineNumber > this.getLineCount()) {
            throw new Error('Illegal value for lineNumber');
        }
        this._tokenization.forceTokenization(lineNumber);
    };
    TextModel.prototype.isCheapToTokenize = function (lineNumber) {
        return this._tokenization.isCheapToTokenize(lineNumber);
    };
    TextModel.prototype.tokenizeIfCheap = function (lineNumber) {
        if (this.isCheapToTokenize(lineNumber)) {
            this.forceTokenization(lineNumber);
        }
    };
    TextModel.prototype.getLineTokens = function (lineNumber) {
        if (lineNumber < 1 || lineNumber > this.getLineCount()) {
            throw new Error('Illegal value for lineNumber');
        }
        return this._getLineTokens(lineNumber);
    };
    TextModel.prototype._getLineTokens = function (lineNumber) {
        var lineText = this.getLineContent(lineNumber);
        var syntacticTokens = this._tokens.getTokens(this._languageIdentifier.id, lineNumber - 1, lineText);
        return this._tokens2.addSemanticTokens(lineNumber, syntacticTokens);
    };
    TextModel.prototype.getLanguageIdentifier = function () {
        return this._languageIdentifier;
    };
    TextModel.prototype.getModeId = function () {
        return this._languageIdentifier.language;
    };
    TextModel.prototype.setMode = function (languageIdentifier) {
        if (this._languageIdentifier.id === languageIdentifier.id) {
            // There's nothing to do
            return;
        }
        var e = {
            oldLanguage: this._languageIdentifier.language,
            newLanguage: languageIdentifier.language
        };
        this._languageIdentifier = languageIdentifier;
        this._onDidChangeLanguage.fire(e);
        this._onDidChangeLanguageConfiguration.fire({});
    };
    TextModel.prototype.getLanguageIdAtPosition = function (lineNumber, column) {
        var position = this.validatePosition(new __WEBPACK_IMPORTED_MODULE_6__core_position_js__["a" /* Position */](lineNumber, column));
        var lineTokens = this.getLineTokens(position.lineNumber);
        return lineTokens.getLanguageId(lineTokens.findTokenIndexAtOffset(position.column - 1));
    };
    // Having tokens allows implementing additional helper methods
    TextModel.prototype.getWordAtPosition = function (_position) {
        this._assertNotDisposed();
        var position = this.validatePosition(_position);
        var lineContent = this.getLineContent(position.lineNumber);
        var lineTokens = this._getLineTokens(position.lineNumber);
        var tokenIndex = lineTokens.findTokenIndexAtOffset(position.column - 1);
        // (1). First try checking right biased word
        var _a = TextModel._findLanguageBoundaries(lineTokens, tokenIndex), rbStartOffset = _a[0], rbEndOffset = _a[1];
        var rightBiasedWord = Object(__WEBPACK_IMPORTED_MODULE_17__wordHelper_js__["d" /* getWordAtText */])(position.column, __WEBPACK_IMPORTED_MODULE_18__modes_languageConfigurationRegistry_js__["a" /* LanguageConfigurationRegistry */].getWordDefinition(lineTokens.getLanguageId(tokenIndex)), lineContent.substring(rbStartOffset, rbEndOffset), rbStartOffset);
        // Make sure the result touches the original passed in position
        if (rightBiasedWord && rightBiasedWord.startColumn <= _position.column && _position.column <= rightBiasedWord.endColumn) {
            return rightBiasedWord;
        }
        // (2). Else, if we were at a language boundary, check the left biased word
        if (tokenIndex > 0 && rbStartOffset === position.column - 1) {
            // edge case, where `position` sits between two tokens belonging to two different languages
            var _b = TextModel._findLanguageBoundaries(lineTokens, tokenIndex - 1), lbStartOffset = _b[0], lbEndOffset = _b[1];
            var leftBiasedWord = Object(__WEBPACK_IMPORTED_MODULE_17__wordHelper_js__["d" /* getWordAtText */])(position.column, __WEBPACK_IMPORTED_MODULE_18__modes_languageConfigurationRegistry_js__["a" /* LanguageConfigurationRegistry */].getWordDefinition(lineTokens.getLanguageId(tokenIndex - 1)), lineContent.substring(lbStartOffset, lbEndOffset), lbStartOffset);
            // Make sure the result touches the original passed in position
            if (leftBiasedWord && leftBiasedWord.startColumn <= _position.column && _position.column <= leftBiasedWord.endColumn) {
                return leftBiasedWord;
            }
        }
        return null;
    };
    TextModel._findLanguageBoundaries = function (lineTokens, tokenIndex) {
        var languageId = lineTokens.getLanguageId(tokenIndex);
        // go left until a different language is hit
        var startOffset = 0;
        for (var i = tokenIndex; i >= 0 && lineTokens.getLanguageId(i) === languageId; i--) {
            startOffset = lineTokens.getStartOffset(i);
        }
        // go right until a different language is hit
        var endOffset = lineTokens.getLineContent().length;
        for (var i = tokenIndex, tokenCount = lineTokens.getCount(); i < tokenCount && lineTokens.getLanguageId(i) === languageId; i++) {
            endOffset = lineTokens.getEndOffset(i);
        }
        return [startOffset, endOffset];
    };
    TextModel.prototype.getWordUntilPosition = function (position) {
        var wordAtPosition = this.getWordAtPosition(position);
        if (!wordAtPosition) {
            return {
                word: '',
                startColumn: position.column,
                endColumn: position.column
            };
        }
        return {
            word: wordAtPosition.word.substr(0, position.column - wordAtPosition.startColumn),
            startColumn: wordAtPosition.startColumn,
            endColumn: position.column
        };
    };
    TextModel.prototype.findMatchingBracketUp = function (_bracket, _position) {
        var bracket = _bracket.toLowerCase();
        var position = this.validatePosition(_position);
        var lineTokens = this._getLineTokens(position.lineNumber);
        var languageId = lineTokens.getLanguageId(lineTokens.findTokenIndexAtOffset(position.column - 1));
        var bracketsSupport = __WEBPACK_IMPORTED_MODULE_18__modes_languageConfigurationRegistry_js__["a" /* LanguageConfigurationRegistry */].getBracketsSupport(languageId);
        if (!bracketsSupport) {
            return null;
        }
        var data = bracketsSupport.textIsBracket[bracket];
        if (!data) {
            return null;
        }
        return this._findMatchingBracketUp(data, position);
    };
    TextModel.prototype.matchBracket = function (position) {
        return this._matchBracket(this.validatePosition(position));
    };
    TextModel.prototype._matchBracket = function (position) {
        var lineNumber = position.lineNumber;
        var lineTokens = this._getLineTokens(lineNumber);
        var tokenCount = lineTokens.getCount();
        var lineText = this._buffer.getLineContent(lineNumber);
        var tokenIndex = lineTokens.findTokenIndexAtOffset(position.column - 1);
        if (tokenIndex < 0) {
            return null;
        }
        var currentModeBrackets = __WEBPACK_IMPORTED_MODULE_18__modes_languageConfigurationRegistry_js__["a" /* LanguageConfigurationRegistry */].getBracketsSupport(lineTokens.getLanguageId(tokenIndex));
        // check that the token is not to be ignored
        if (currentModeBrackets && !Object(__WEBPACK_IMPORTED_MODULE_20__modes_supports_js__["b" /* ignoreBracketsInToken */])(lineTokens.getStandardTokenType(tokenIndex))) {
            // limit search to not go before `maxBracketLength`
            var searchStartOffset = Math.max(0, position.column - 1 - currentModeBrackets.maxBracketLength);
            for (var i = tokenIndex - 1; i >= 0; i--) {
                var tokenEndOffset = lineTokens.getEndOffset(i);
                if (tokenEndOffset <= searchStartOffset) {
                    break;
                }
                if (Object(__WEBPACK_IMPORTED_MODULE_20__modes_supports_js__["b" /* ignoreBracketsInToken */])(lineTokens.getStandardTokenType(i))) {
                    searchStartOffset = tokenEndOffset;
                }
            }
            // limit search to not go after `maxBracketLength`
            var searchEndOffset = Math.min(lineText.length, position.column - 1 + currentModeBrackets.maxBracketLength);
            // it might be the case that [currentTokenStart -> currentTokenEnd] contains multiple brackets
            // `bestResult` will contain the most right-side result
            var bestResult = null;
            while (true) {
                var foundBracket = __WEBPACK_IMPORTED_MODULE_21__modes_supports_richEditBrackets_js__["a" /* BracketsUtils */].findNextBracketInRange(currentModeBrackets.forwardRegex, lineNumber, lineText, searchStartOffset, searchEndOffset);
                if (!foundBracket) {
                    // there are no more brackets in this text
                    break;
                }
                // check that we didn't hit a bracket too far away from position
                if (foundBracket.startColumn <= position.column && position.column <= foundBracket.endColumn) {
                    var foundBracketText = lineText.substring(foundBracket.startColumn - 1, foundBracket.endColumn - 1).toLowerCase();
                    var r = this._matchFoundBracket(foundBracket, currentModeBrackets.textIsBracket[foundBracketText], currentModeBrackets.textIsOpenBracket[foundBracketText]);
                    if (r) {
                        bestResult = r;
                    }
                }
                searchStartOffset = foundBracket.endColumn - 1;
            }
            if (bestResult) {
                return bestResult;
            }
        }
        // If position is in between two tokens, try also looking in the previous token
        if (tokenIndex > 0 && lineTokens.getStartOffset(tokenIndex) === position.column - 1) {
            var prevTokenIndex = tokenIndex - 1;
            var prevModeBrackets = __WEBPACK_IMPORTED_MODULE_18__modes_languageConfigurationRegistry_js__["a" /* LanguageConfigurationRegistry */].getBracketsSupport(lineTokens.getLanguageId(prevTokenIndex));
            // check that previous token is not to be ignored
            if (prevModeBrackets && !Object(__WEBPACK_IMPORTED_MODULE_20__modes_supports_js__["b" /* ignoreBracketsInToken */])(lineTokens.getStandardTokenType(prevTokenIndex))) {
                // limit search in case previous token is very large, there's no need to go beyond `maxBracketLength`
                var searchStartOffset = Math.max(0, position.column - 1 - prevModeBrackets.maxBracketLength);
                var searchEndOffset = Math.min(lineText.length, position.column - 1 + prevModeBrackets.maxBracketLength);
                for (var i = prevTokenIndex + 1; i < tokenCount; i++) {
                    var tokenStartOffset = lineTokens.getStartOffset(i);
                    if (tokenStartOffset >= searchEndOffset) {
                        break;
                    }
                    if (Object(__WEBPACK_IMPORTED_MODULE_20__modes_supports_js__["b" /* ignoreBracketsInToken */])(lineTokens.getStandardTokenType(i))) {
                        searchEndOffset = tokenStartOffset;
                    }
                }
                var foundBracket = __WEBPACK_IMPORTED_MODULE_21__modes_supports_richEditBrackets_js__["a" /* BracketsUtils */].findPrevBracketInRange(prevModeBrackets.reversedRegex, lineNumber, lineText, searchStartOffset, searchEndOffset);
                // check that we didn't hit a bracket too far away from position
                if (foundBracket && foundBracket.startColumn <= position.column && position.column <= foundBracket.endColumn) {
                    var foundBracketText = lineText.substring(foundBracket.startColumn - 1, foundBracket.endColumn - 1).toLowerCase();
                    var r = this._matchFoundBracket(foundBracket, prevModeBrackets.textIsBracket[foundBracketText], prevModeBrackets.textIsOpenBracket[foundBracketText]);
                    if (r) {
                        return r;
                    }
                }
            }
        }
        return null;
    };
    TextModel.prototype._matchFoundBracket = function (foundBracket, data, isOpen) {
        if (!data) {
            return null;
        }
        if (isOpen) {
            var matched = this._findMatchingBracketDown(data, foundBracket.getEndPosition());
            if (matched) {
                return [foundBracket, matched];
            }
        }
        else {
            var matched = this._findMatchingBracketUp(data, foundBracket.getStartPosition());
            if (matched) {
                return [foundBracket, matched];
            }
        }
        return null;
    };
    TextModel.prototype._findMatchingBracketUp = function (bracket, position) {
        // console.log('_findMatchingBracketUp: ', 'bracket: ', JSON.stringify(bracket), 'startPosition: ', String(position));
        var languageId = bracket.languageIdentifier.id;
        var reversedBracketRegex = bracket.reversedRegex;
        var count = -1;
        var searchPrevMatchingBracketInRange = function (lineNumber, lineText, searchStartOffset, searchEndOffset) {
            while (true) {
                var r = __WEBPACK_IMPORTED_MODULE_21__modes_supports_richEditBrackets_js__["a" /* BracketsUtils */].findPrevBracketInRange(reversedBracketRegex, lineNumber, lineText, searchStartOffset, searchEndOffset);
                if (!r) {
                    break;
                }
                var hitText = lineText.substring(r.startColumn - 1, r.endColumn - 1).toLowerCase();
                if (bracket.isOpen(hitText)) {
                    count++;
                }
                else if (bracket.isClose(hitText)) {
                    count--;
                }
                if (count === 0) {
                    return r;
                }
                searchEndOffset = r.startColumn - 1;
            }
            return null;
        };
        for (var lineNumber = position.lineNumber; lineNumber >= 1; lineNumber--) {
            var lineTokens = this._getLineTokens(lineNumber);
            var tokenCount = lineTokens.getCount();
            var lineText = this._buffer.getLineContent(lineNumber);
            var tokenIndex = tokenCount - 1;
            var searchStartOffset = lineText.length;
            var searchEndOffset = lineText.length;
            if (lineNumber === position.lineNumber) {
                tokenIndex = lineTokens.findTokenIndexAtOffset(position.column - 1);
                searchStartOffset = position.column - 1;
                searchEndOffset = position.column - 1;
            }
            var prevSearchInToken = true;
            for (; tokenIndex >= 0; tokenIndex--) {
                var searchInToken = (lineTokens.getLanguageId(tokenIndex) === languageId && !Object(__WEBPACK_IMPORTED_MODULE_20__modes_supports_js__["b" /* ignoreBracketsInToken */])(lineTokens.getStandardTokenType(tokenIndex)));
                if (searchInToken) {
                    // this token should be searched
                    if (prevSearchInToken) {
                        // the previous token should be searched, simply extend searchStartOffset
                        searchStartOffset = lineTokens.getStartOffset(tokenIndex);
                    }
                    else {
                        // the previous token should not be searched
                        searchStartOffset = lineTokens.getStartOffset(tokenIndex);
                        searchEndOffset = lineTokens.getEndOffset(tokenIndex);
                    }
                }
                else {
                    // this token should not be searched
                    if (prevSearchInToken && searchStartOffset !== searchEndOffset) {
                        var r = searchPrevMatchingBracketInRange(lineNumber, lineText, searchStartOffset, searchEndOffset);
                        if (r) {
                            return r;
                        }
                    }
                }
                prevSearchInToken = searchInToken;
            }
            if (prevSearchInToken && searchStartOffset !== searchEndOffset) {
                var r = searchPrevMatchingBracketInRange(lineNumber, lineText, searchStartOffset, searchEndOffset);
                if (r) {
                    return r;
                }
            }
        }
        return null;
    };
    TextModel.prototype._findMatchingBracketDown = function (bracket, position) {
        // console.log('_findMatchingBracketDown: ', 'bracket: ', JSON.stringify(bracket), 'startPosition: ', String(position));
        var languageId = bracket.languageIdentifier.id;
        var bracketRegex = bracket.forwardRegex;
        var count = 1;
        var searchNextMatchingBracketInRange = function (lineNumber, lineText, searchStartOffset, searchEndOffset) {
            while (true) {
                var r = __WEBPACK_IMPORTED_MODULE_21__modes_supports_richEditBrackets_js__["a" /* BracketsUtils */].findNextBracketInRange(bracketRegex, lineNumber, lineText, searchStartOffset, searchEndOffset);
                if (!r) {
                    break;
                }
                var hitText = lineText.substring(r.startColumn - 1, r.endColumn - 1).toLowerCase();
                if (bracket.isOpen(hitText)) {
                    count++;
                }
                else if (bracket.isClose(hitText)) {
                    count--;
                }
                if (count === 0) {
                    return r;
                }
                searchStartOffset = r.endColumn - 1;
            }
            return null;
        };
        var lineCount = this.getLineCount();
        for (var lineNumber = position.lineNumber; lineNumber <= lineCount; lineNumber++) {
            var lineTokens = this._getLineTokens(lineNumber);
            var tokenCount = lineTokens.getCount();
            var lineText = this._buffer.getLineContent(lineNumber);
            var tokenIndex = 0;
            var searchStartOffset = 0;
            var searchEndOffset = 0;
            if (lineNumber === position.lineNumber) {
                tokenIndex = lineTokens.findTokenIndexAtOffset(position.column - 1);
                searchStartOffset = position.column - 1;
                searchEndOffset = position.column - 1;
            }
            var prevSearchInToken = true;
            for (; tokenIndex < tokenCount; tokenIndex++) {
                var searchInToken = (lineTokens.getLanguageId(tokenIndex) === languageId && !Object(__WEBPACK_IMPORTED_MODULE_20__modes_supports_js__["b" /* ignoreBracketsInToken */])(lineTokens.getStandardTokenType(tokenIndex)));
                if (searchInToken) {
                    // this token should be searched
                    if (prevSearchInToken) {
                        // the previous token should be searched, simply extend searchEndOffset
                        searchEndOffset = lineTokens.getEndOffset(tokenIndex);
                    }
                    else {
                        // the previous token should not be searched
                        searchStartOffset = lineTokens.getStartOffset(tokenIndex);
                        searchEndOffset = lineTokens.getEndOffset(tokenIndex);
                    }
                }
                else {
                    // this token should not be searched
                    if (prevSearchInToken && searchStartOffset !== searchEndOffset) {
                        var r = searchNextMatchingBracketInRange(lineNumber, lineText, searchStartOffset, searchEndOffset);
                        if (r) {
                            return r;
                        }
                    }
                }
                prevSearchInToken = searchInToken;
            }
            if (prevSearchInToken && searchStartOffset !== searchEndOffset) {
                var r = searchNextMatchingBracketInRange(lineNumber, lineText, searchStartOffset, searchEndOffset);
                if (r) {
                    return r;
                }
            }
        }
        return null;
    };
    TextModel.prototype.findPrevBracket = function (_position) {
        var position = this.validatePosition(_position);
        var languageId = -1;
        var modeBrackets = null;
        for (var lineNumber = position.lineNumber; lineNumber >= 1; lineNumber--) {
            var lineTokens = this._getLineTokens(lineNumber);
            var tokenCount = lineTokens.getCount();
            var lineText = this._buffer.getLineContent(lineNumber);
            var tokenIndex = tokenCount - 1;
            var searchStartOffset = lineText.length;
            var searchEndOffset = lineText.length;
            if (lineNumber === position.lineNumber) {
                tokenIndex = lineTokens.findTokenIndexAtOffset(position.column - 1);
                searchStartOffset = position.column - 1;
                searchEndOffset = position.column - 1;
                var tokenLanguageId = lineTokens.getLanguageId(tokenIndex);
                if (languageId !== tokenLanguageId) {
                    languageId = tokenLanguageId;
                    modeBrackets = __WEBPACK_IMPORTED_MODULE_18__modes_languageConfigurationRegistry_js__["a" /* LanguageConfigurationRegistry */].getBracketsSupport(languageId);
                }
            }
            var prevSearchInToken = true;
            for (; tokenIndex >= 0; tokenIndex--) {
                var tokenLanguageId = lineTokens.getLanguageId(tokenIndex);
                if (languageId !== tokenLanguageId) {
                    // language id change!
                    if (modeBrackets && prevSearchInToken && searchStartOffset !== searchEndOffset) {
                        var r = __WEBPACK_IMPORTED_MODULE_21__modes_supports_richEditBrackets_js__["a" /* BracketsUtils */].findPrevBracketInRange(modeBrackets.reversedRegex, lineNumber, lineText, searchStartOffset, searchEndOffset);
                        if (r) {
                            return this._toFoundBracket(modeBrackets, r);
                        }
                        prevSearchInToken = false;
                    }
                    languageId = tokenLanguageId;
                    modeBrackets = __WEBPACK_IMPORTED_MODULE_18__modes_languageConfigurationRegistry_js__["a" /* LanguageConfigurationRegistry */].getBracketsSupport(languageId);
                }
                var searchInToken = (!!modeBrackets && !Object(__WEBPACK_IMPORTED_MODULE_20__modes_supports_js__["b" /* ignoreBracketsInToken */])(lineTokens.getStandardTokenType(tokenIndex)));
                if (searchInToken) {
                    // this token should be searched
                    if (prevSearchInToken) {
                        // the previous token should be searched, simply extend searchStartOffset
                        searchStartOffset = lineTokens.getStartOffset(tokenIndex);
                    }
                    else {
                        // the previous token should not be searched
                        searchStartOffset = lineTokens.getStartOffset(tokenIndex);
                        searchEndOffset = lineTokens.getEndOffset(tokenIndex);
                    }
                }
                else {
                    // this token should not be searched
                    if (modeBrackets && prevSearchInToken && searchStartOffset !== searchEndOffset) {
                        var r = __WEBPACK_IMPORTED_MODULE_21__modes_supports_richEditBrackets_js__["a" /* BracketsUtils */].findPrevBracketInRange(modeBrackets.reversedRegex, lineNumber, lineText, searchStartOffset, searchEndOffset);
                        if (r) {
                            return this._toFoundBracket(modeBrackets, r);
                        }
                    }
                }
                prevSearchInToken = searchInToken;
            }
            if (modeBrackets && prevSearchInToken && searchStartOffset !== searchEndOffset) {
                var r = __WEBPACK_IMPORTED_MODULE_21__modes_supports_richEditBrackets_js__["a" /* BracketsUtils */].findPrevBracketInRange(modeBrackets.reversedRegex, lineNumber, lineText, searchStartOffset, searchEndOffset);
                if (r) {
                    return this._toFoundBracket(modeBrackets, r);
                }
            }
        }
        return null;
    };
    TextModel.prototype.findNextBracket = function (_position) {
        var position = this.validatePosition(_position);
        var lineCount = this.getLineCount();
        var languageId = -1;
        var modeBrackets = null;
        for (var lineNumber = position.lineNumber; lineNumber <= lineCount; lineNumber++) {
            var lineTokens = this._getLineTokens(lineNumber);
            var tokenCount = lineTokens.getCount();
            var lineText = this._buffer.getLineContent(lineNumber);
            var tokenIndex = 0;
            var searchStartOffset = 0;
            var searchEndOffset = 0;
            if (lineNumber === position.lineNumber) {
                tokenIndex = lineTokens.findTokenIndexAtOffset(position.column - 1);
                searchStartOffset = position.column - 1;
                searchEndOffset = position.column - 1;
                var tokenLanguageId = lineTokens.getLanguageId(tokenIndex);
                if (languageId !== tokenLanguageId) {
                    languageId = tokenLanguageId;
                    modeBrackets = __WEBPACK_IMPORTED_MODULE_18__modes_languageConfigurationRegistry_js__["a" /* LanguageConfigurationRegistry */].getBracketsSupport(languageId);
                }
            }
            var prevSearchInToken = true;
            for (; tokenIndex < tokenCount; tokenIndex++) {
                var tokenLanguageId = lineTokens.getLanguageId(tokenIndex);
                if (languageId !== tokenLanguageId) {
                    // language id change!
                    if (modeBrackets && prevSearchInToken && searchStartOffset !== searchEndOffset) {
                        var r = __WEBPACK_IMPORTED_MODULE_21__modes_supports_richEditBrackets_js__["a" /* BracketsUtils */].findNextBracketInRange(modeBrackets.forwardRegex, lineNumber, lineText, searchStartOffset, searchEndOffset);
                        if (r) {
                            return this._toFoundBracket(modeBrackets, r);
                        }
                        prevSearchInToken = false;
                    }
                    languageId = tokenLanguageId;
                    modeBrackets = __WEBPACK_IMPORTED_MODULE_18__modes_languageConfigurationRegistry_js__["a" /* LanguageConfigurationRegistry */].getBracketsSupport(languageId);
                }
                var searchInToken = (!!modeBrackets && !Object(__WEBPACK_IMPORTED_MODULE_20__modes_supports_js__["b" /* ignoreBracketsInToken */])(lineTokens.getStandardTokenType(tokenIndex)));
                if (searchInToken) {
                    // this token should be searched
                    if (prevSearchInToken) {
                        // the previous token should be searched, simply extend searchEndOffset
                        searchEndOffset = lineTokens.getEndOffset(tokenIndex);
                    }
                    else {
                        // the previous token should not be searched
                        searchStartOffset = lineTokens.getStartOffset(tokenIndex);
                        searchEndOffset = lineTokens.getEndOffset(tokenIndex);
                    }
                }
                else {
                    // this token should not be searched
                    if (modeBrackets && prevSearchInToken && searchStartOffset !== searchEndOffset) {
                        var r = __WEBPACK_IMPORTED_MODULE_21__modes_supports_richEditBrackets_js__["a" /* BracketsUtils */].findNextBracketInRange(modeBrackets.forwardRegex, lineNumber, lineText, searchStartOffset, searchEndOffset);
                        if (r) {
                            return this._toFoundBracket(modeBrackets, r);
                        }
                    }
                }
                prevSearchInToken = searchInToken;
            }
            if (modeBrackets && prevSearchInToken && searchStartOffset !== searchEndOffset) {
                var r = __WEBPACK_IMPORTED_MODULE_21__modes_supports_richEditBrackets_js__["a" /* BracketsUtils */].findNextBracketInRange(modeBrackets.forwardRegex, lineNumber, lineText, searchStartOffset, searchEndOffset);
                if (r) {
                    return this._toFoundBracket(modeBrackets, r);
                }
            }
        }
        return null;
    };
    TextModel.prototype.findEnclosingBrackets = function (_position, maxDuration) {
        var _this = this;
        if (maxDuration === void 0) { maxDuration = 1073741824 /* MAX_SAFE_SMALL_INTEGER */; }
        var position = this.validatePosition(_position);
        var lineCount = this.getLineCount();
        var savedCounts = new Map();
        var counts = [];
        var resetCounts = function (languageId, modeBrackets) {
            if (!savedCounts.has(languageId)) {
                var tmp = [];
                for (var i = 0, len = modeBrackets ? modeBrackets.brackets.length : 0; i < len; i++) {
                    tmp[i] = 0;
                }
                savedCounts.set(languageId, tmp);
            }
            counts = savedCounts.get(languageId);
        };
        var searchInRange = function (modeBrackets, lineNumber, lineText, searchStartOffset, searchEndOffset) {
            while (true) {
                var r = __WEBPACK_IMPORTED_MODULE_21__modes_supports_richEditBrackets_js__["a" /* BracketsUtils */].findNextBracketInRange(modeBrackets.forwardRegex, lineNumber, lineText, searchStartOffset, searchEndOffset);
                if (!r) {
                    break;
                }
                var hitText = lineText.substring(r.startColumn - 1, r.endColumn - 1).toLowerCase();
                var bracket = modeBrackets.textIsBracket[hitText];
                if (bracket) {
                    if (bracket.isOpen(hitText)) {
                        counts[bracket.index]++;
                    }
                    else if (bracket.isClose(hitText)) {
                        counts[bracket.index]--;
                    }
                    if (counts[bracket.index] === -1) {
                        return _this._matchFoundBracket(r, bracket, false);
                    }
                }
                searchStartOffset = r.endColumn - 1;
            }
            return null;
        };
        var languageId = -1;
        var modeBrackets = null;
        var startTime = Date.now();
        for (var lineNumber = position.lineNumber; lineNumber <= lineCount; lineNumber++) {
            var elapsedTime = Date.now() - startTime;
            if (elapsedTime > maxDuration) {
                return null;
            }
            var lineTokens = this._getLineTokens(lineNumber);
            var tokenCount = lineTokens.getCount();
            var lineText = this._buffer.getLineContent(lineNumber);
            var tokenIndex = 0;
            var searchStartOffset = 0;
            var searchEndOffset = 0;
            if (lineNumber === position.lineNumber) {
                tokenIndex = lineTokens.findTokenIndexAtOffset(position.column - 1);
                searchStartOffset = position.column - 1;
                searchEndOffset = position.column - 1;
                var tokenLanguageId = lineTokens.getLanguageId(tokenIndex);
                if (languageId !== tokenLanguageId) {
                    languageId = tokenLanguageId;
                    modeBrackets = __WEBPACK_IMPORTED_MODULE_18__modes_languageConfigurationRegistry_js__["a" /* LanguageConfigurationRegistry */].getBracketsSupport(languageId);
                    resetCounts(languageId, modeBrackets);
                }
            }
            var prevSearchInToken = true;
            for (; tokenIndex < tokenCount; tokenIndex++) {
                var tokenLanguageId = lineTokens.getLanguageId(tokenIndex);
                if (languageId !== tokenLanguageId) {
                    // language id change!
                    if (modeBrackets && prevSearchInToken && searchStartOffset !== searchEndOffset) {
                        var r = searchInRange(modeBrackets, lineNumber, lineText, searchStartOffset, searchEndOffset);
                        if (r) {
                            return r;
                        }
                        prevSearchInToken = false;
                    }
                    languageId = tokenLanguageId;
                    modeBrackets = __WEBPACK_IMPORTED_MODULE_18__modes_languageConfigurationRegistry_js__["a" /* LanguageConfigurationRegistry */].getBracketsSupport(languageId);
                    resetCounts(languageId, modeBrackets);
                }
                var searchInToken = (!!modeBrackets && !Object(__WEBPACK_IMPORTED_MODULE_20__modes_supports_js__["b" /* ignoreBracketsInToken */])(lineTokens.getStandardTokenType(tokenIndex)));
                if (searchInToken) {
                    // this token should be searched
                    if (prevSearchInToken) {
                        // the previous token should be searched, simply extend searchEndOffset
                        searchEndOffset = lineTokens.getEndOffset(tokenIndex);
                    }
                    else {
                        // the previous token should not be searched
                        searchStartOffset = lineTokens.getStartOffset(tokenIndex);
                        searchEndOffset = lineTokens.getEndOffset(tokenIndex);
                    }
                }
                else {
                    // this token should not be searched
                    if (modeBrackets && prevSearchInToken && searchStartOffset !== searchEndOffset) {
                        var r = searchInRange(modeBrackets, lineNumber, lineText, searchStartOffset, searchEndOffset);
                        if (r) {
                            return r;
                        }
                    }
                }
                prevSearchInToken = searchInToken;
            }
            if (modeBrackets && prevSearchInToken && searchStartOffset !== searchEndOffset) {
                var r = searchInRange(modeBrackets, lineNumber, lineText, searchStartOffset, searchEndOffset);
                if (r) {
                    return r;
                }
            }
        }
        return null;
    };
    TextModel.prototype._toFoundBracket = function (modeBrackets, r) {
        if (!r) {
            return null;
        }
        var text = this.getValueInRange(r);
        text = text.toLowerCase();
        var data = modeBrackets.textIsBracket[text];
        if (!data) {
            return null;
        }
        return {
            range: r,
            open: data.open,
            close: data.close,
            isOpen: modeBrackets.textIsOpenBracket[text]
        };
    };
    /**
     * Returns:
     *  - -1 => the line consists of whitespace
     *  - otherwise => the indent level is returned value
     */
    TextModel.computeIndentLevel = function (line, tabSize) {
        var indent = 0;
        var i = 0;
        var len = line.length;
        while (i < len) {
            var chCode = line.charCodeAt(i);
            if (chCode === 32 /* Space */) {
                indent++;
            }
            else if (chCode === 9 /* Tab */) {
                indent = indent - indent % tabSize + tabSize;
            }
            else {
                break;
            }
            i++;
        }
        if (i === len) {
            return -1; // line only consists of whitespace
        }
        return indent;
    };
    TextModel.prototype._computeIndentLevel = function (lineIndex) {
        return TextModel.computeIndentLevel(this._buffer.getLineContent(lineIndex + 1), this._options.tabSize);
    };
    TextModel.prototype.getActiveIndentGuide = function (lineNumber, minLineNumber, maxLineNumber) {
        var _this = this;
        this._assertNotDisposed();
        var lineCount = this.getLineCount();
        if (lineNumber < 1 || lineNumber > lineCount) {
            throw new Error('Illegal value for lineNumber');
        }
        var foldingRules = __WEBPACK_IMPORTED_MODULE_18__modes_languageConfigurationRegistry_js__["a" /* LanguageConfigurationRegistry */].getFoldingRules(this._languageIdentifier.id);
        var offSide = Boolean(foldingRules && foldingRules.offSide);
        var up_aboveContentLineIndex = -2; /* -2 is a marker for not having computed it */
        var up_aboveContentLineIndent = -1;
        var up_belowContentLineIndex = -2; /* -2 is a marker for not having computed it */
        var up_belowContentLineIndent = -1;
        var up_resolveIndents = function (lineNumber) {
            if (up_aboveContentLineIndex !== -1 && (up_aboveContentLineIndex === -2 || up_aboveContentLineIndex > lineNumber - 1)) {
                up_aboveContentLineIndex = -1;
                up_aboveContentLineIndent = -1;
                // must find previous line with content
                for (var lineIndex = lineNumber - 2; lineIndex >= 0; lineIndex--) {
                    var indent_1 = _this._computeIndentLevel(lineIndex);
                    if (indent_1 >= 0) {
                        up_aboveContentLineIndex = lineIndex;
                        up_aboveContentLineIndent = indent_1;
                        break;
                    }
                }
            }
            if (up_belowContentLineIndex === -2) {
                up_belowContentLineIndex = -1;
                up_belowContentLineIndent = -1;
                // must find next line with content
                for (var lineIndex = lineNumber; lineIndex < lineCount; lineIndex++) {
                    var indent_2 = _this._computeIndentLevel(lineIndex);
                    if (indent_2 >= 0) {
                        up_belowContentLineIndex = lineIndex;
                        up_belowContentLineIndent = indent_2;
                        break;
                    }
                }
            }
        };
        var down_aboveContentLineIndex = -2; /* -2 is a marker for not having computed it */
        var down_aboveContentLineIndent = -1;
        var down_belowContentLineIndex = -2; /* -2 is a marker for not having computed it */
        var down_belowContentLineIndent = -1;
        var down_resolveIndents = function (lineNumber) {
            if (down_aboveContentLineIndex === -2) {
                down_aboveContentLineIndex = -1;
                down_aboveContentLineIndent = -1;
                // must find previous line with content
                for (var lineIndex = lineNumber - 2; lineIndex >= 0; lineIndex--) {
                    var indent_3 = _this._computeIndentLevel(lineIndex);
                    if (indent_3 >= 0) {
                        down_aboveContentLineIndex = lineIndex;
                        down_aboveContentLineIndent = indent_3;
                        break;
                    }
                }
            }
            if (down_belowContentLineIndex !== -1 && (down_belowContentLineIndex === -2 || down_belowContentLineIndex < lineNumber - 1)) {
                down_belowContentLineIndex = -1;
                down_belowContentLineIndent = -1;
                // must find next line with content
                for (var lineIndex = lineNumber; lineIndex < lineCount; lineIndex++) {
                    var indent_4 = _this._computeIndentLevel(lineIndex);
                    if (indent_4 >= 0) {
                        down_belowContentLineIndex = lineIndex;
                        down_belowContentLineIndent = indent_4;
                        break;
                    }
                }
            }
        };
        var startLineNumber = 0;
        var goUp = true;
        var endLineNumber = 0;
        var goDown = true;
        var indent = 0;
        for (var distance = 0; goUp || goDown; distance++) {
            var upLineNumber = lineNumber - distance;
            var downLineNumber = lineNumber + distance;
            if (distance !== 0 && (upLineNumber < 1 || upLineNumber < minLineNumber)) {
                goUp = false;
            }
            if (distance !== 0 && (downLineNumber > lineCount || downLineNumber > maxLineNumber)) {
                goDown = false;
            }
            if (distance > 50000) {
                // stop processing
                goUp = false;
                goDown = false;
            }
            if (goUp) {
                // compute indent level going up
                var upLineIndentLevel = void 0;
                var currentIndent = this._computeIndentLevel(upLineNumber - 1);
                if (currentIndent >= 0) {
                    // This line has content (besides whitespace)
                    // Use the line's indent
                    up_belowContentLineIndex = upLineNumber - 1;
                    up_belowContentLineIndent = currentIndent;
                    upLineIndentLevel = Math.ceil(currentIndent / this._options.indentSize);
                }
                else {
                    up_resolveIndents(upLineNumber);
                    upLineIndentLevel = this._getIndentLevelForWhitespaceLine(offSide, up_aboveContentLineIndent, up_belowContentLineIndent);
                }
                if (distance === 0) {
                    // This is the initial line number
                    startLineNumber = upLineNumber;
                    endLineNumber = downLineNumber;
                    indent = upLineIndentLevel;
                    if (indent === 0) {
                        // No need to continue
                        return { startLineNumber: startLineNumber, endLineNumber: endLineNumber, indent: indent };
                    }
                    continue;
                }
                if (upLineIndentLevel >= indent) {
                    startLineNumber = upLineNumber;
                }
                else {
                    goUp = false;
                }
            }
            if (goDown) {
                // compute indent level going down
                var downLineIndentLevel = void 0;
                var currentIndent = this._computeIndentLevel(downLineNumber - 1);
                if (currentIndent >= 0) {
                    // This line has content (besides whitespace)
                    // Use the line's indent
                    down_aboveContentLineIndex = downLineNumber - 1;
                    down_aboveContentLineIndent = currentIndent;
                    downLineIndentLevel = Math.ceil(currentIndent / this._options.indentSize);
                }
                else {
                    down_resolveIndents(downLineNumber);
                    downLineIndentLevel = this._getIndentLevelForWhitespaceLine(offSide, down_aboveContentLineIndent, down_belowContentLineIndent);
                }
                if (downLineIndentLevel >= indent) {
                    endLineNumber = downLineNumber;
                }
                else {
                    goDown = false;
                }
            }
        }
        return { startLineNumber: startLineNumber, endLineNumber: endLineNumber, indent: indent };
    };
    TextModel.prototype.getLinesIndentGuides = function (startLineNumber, endLineNumber) {
        this._assertNotDisposed();
        var lineCount = this.getLineCount();
        if (startLineNumber < 1 || startLineNumber > lineCount) {
            throw new Error('Illegal value for startLineNumber');
        }
        if (endLineNumber < 1 || endLineNumber > lineCount) {
            throw new Error('Illegal value for endLineNumber');
        }
        var foldingRules = __WEBPACK_IMPORTED_MODULE_18__modes_languageConfigurationRegistry_js__["a" /* LanguageConfigurationRegistry */].getFoldingRules(this._languageIdentifier.id);
        var offSide = Boolean(foldingRules && foldingRules.offSide);
        var result = new Array(endLineNumber - startLineNumber + 1);
        var aboveContentLineIndex = -2; /* -2 is a marker for not having computed it */
        var aboveContentLineIndent = -1;
        var belowContentLineIndex = -2; /* -2 is a marker for not having computed it */
        var belowContentLineIndent = -1;
        for (var lineNumber = startLineNumber; lineNumber <= endLineNumber; lineNumber++) {
            var resultIndex = lineNumber - startLineNumber;
            var currentIndent = this._computeIndentLevel(lineNumber - 1);
            if (currentIndent >= 0) {
                // This line has content (besides whitespace)
                // Use the line's indent
                aboveContentLineIndex = lineNumber - 1;
                aboveContentLineIndent = currentIndent;
                result[resultIndex] = Math.ceil(currentIndent / this._options.indentSize);
                continue;
            }
            if (aboveContentLineIndex === -2) {
                aboveContentLineIndex = -1;
                aboveContentLineIndent = -1;
                // must find previous line with content
                for (var lineIndex = lineNumber - 2; lineIndex >= 0; lineIndex--) {
                    var indent = this._computeIndentLevel(lineIndex);
                    if (indent >= 0) {
                        aboveContentLineIndex = lineIndex;
                        aboveContentLineIndent = indent;
                        break;
                    }
                }
            }
            if (belowContentLineIndex !== -1 && (belowContentLineIndex === -2 || belowContentLineIndex < lineNumber - 1)) {
                belowContentLineIndex = -1;
                belowContentLineIndent = -1;
                // must find next line with content
                for (var lineIndex = lineNumber; lineIndex < lineCount; lineIndex++) {
                    var indent = this._computeIndentLevel(lineIndex);
                    if (indent >= 0) {
                        belowContentLineIndex = lineIndex;
                        belowContentLineIndent = indent;
                        break;
                    }
                }
            }
            result[resultIndex] = this._getIndentLevelForWhitespaceLine(offSide, aboveContentLineIndent, belowContentLineIndent);
        }
        return result;
    };
    TextModel.prototype._getIndentLevelForWhitespaceLine = function (offSide, aboveContentLineIndent, belowContentLineIndent) {
        if (aboveContentLineIndent === -1 || belowContentLineIndent === -1) {
            // At the top or bottom of the file
            return 0;
        }
        else if (aboveContentLineIndent < belowContentLineIndent) {
            // we are inside the region above
            return (1 + Math.floor(aboveContentLineIndent / this._options.indentSize));
        }
        else if (aboveContentLineIndent === belowContentLineIndent) {
            // we are in between two regions
            return Math.ceil(belowContentLineIndent / this._options.indentSize);
        }
        else {
            if (offSide) {
                // same level as region below
                return Math.ceil(belowContentLineIndent / this._options.indentSize);
            }
            else {
                // we are inside the region that ends below
                return (1 + Math.floor(belowContentLineIndent / this._options.indentSize));
            }
        }
    };
    TextModel.MODEL_SYNC_LIMIT = 50 * 1024 * 1024; // 50 MB
    TextModel.LARGE_FILE_SIZE_THRESHOLD = 20 * 1024 * 1024; // 20 MB;
    TextModel.LARGE_FILE_LINE_COUNT_THRESHOLD = 300 * 1000; // 300K lines
    TextModel.DEFAULT_CREATION_OPTIONS = {
        isForSimpleWidget: false,
        tabSize: __WEBPACK_IMPORTED_MODULE_5__config_editorOptions_js__["c" /* EDITOR_MODEL_DEFAULTS */].tabSize,
        indentSize: __WEBPACK_IMPORTED_MODULE_5__config_editorOptions_js__["c" /* EDITOR_MODEL_DEFAULTS */].indentSize,
        insertSpaces: __WEBPACK_IMPORTED_MODULE_5__config_editorOptions_js__["c" /* EDITOR_MODEL_DEFAULTS */].insertSpaces,
        detectIndentation: false,
        defaultEOL: 1 /* LF */,
        trimAutoWhitespace: __WEBPACK_IMPORTED_MODULE_5__config_editorOptions_js__["c" /* EDITOR_MODEL_DEFAULTS */].trimAutoWhitespace,
        largeFileOptimizations: __WEBPACK_IMPORTED_MODULE_5__config_editorOptions_js__["c" /* EDITOR_MODEL_DEFAULTS */].largeFileOptimizations,
    };
    return TextModel;
}(__WEBPACK_IMPORTED_MODULE_2__base_common_lifecycle_js__["a" /* Disposable */]));

//#region Decorations
var DecorationsTrees = /** @class */ (function () {
    function DecorationsTrees() {
        this._decorationsTree0 = new __WEBPACK_IMPORTED_MODULE_12__intervalTree_js__["b" /* IntervalTree */]();
        this._decorationsTree1 = new __WEBPACK_IMPORTED_MODULE_12__intervalTree_js__["b" /* IntervalTree */]();
    }
    DecorationsTrees.prototype.intervalSearch = function (start, end, filterOwnerId, filterOutValidation, cachedVersionId) {
        var r0 = this._decorationsTree0.intervalSearch(start, end, filterOwnerId, filterOutValidation, cachedVersionId);
        var r1 = this._decorationsTree1.intervalSearch(start, end, filterOwnerId, filterOutValidation, cachedVersionId);
        return r0.concat(r1);
    };
    DecorationsTrees.prototype.search = function (filterOwnerId, filterOutValidation, overviewRulerOnly, cachedVersionId) {
        if (overviewRulerOnly) {
            return this._decorationsTree1.search(filterOwnerId, filterOutValidation, cachedVersionId);
        }
        else {
            var r0 = this._decorationsTree0.search(filterOwnerId, filterOutValidation, cachedVersionId);
            var r1 = this._decorationsTree1.search(filterOwnerId, filterOutValidation, cachedVersionId);
            return r0.concat(r1);
        }
    };
    DecorationsTrees.prototype.collectNodesFromOwner = function (ownerId) {
        var r0 = this._decorationsTree0.collectNodesFromOwner(ownerId);
        var r1 = this._decorationsTree1.collectNodesFromOwner(ownerId);
        return r0.concat(r1);
    };
    DecorationsTrees.prototype.collectNodesPostOrder = function () {
        var r0 = this._decorationsTree0.collectNodesPostOrder();
        var r1 = this._decorationsTree1.collectNodesPostOrder();
        return r0.concat(r1);
    };
    DecorationsTrees.prototype.insert = function (node) {
        if (Object(__WEBPACK_IMPORTED_MODULE_12__intervalTree_js__["c" /* getNodeIsInOverviewRuler */])(node)) {
            this._decorationsTree1.insert(node);
        }
        else {
            this._decorationsTree0.insert(node);
        }
    };
    DecorationsTrees.prototype.delete = function (node) {
        if (Object(__WEBPACK_IMPORTED_MODULE_12__intervalTree_js__["c" /* getNodeIsInOverviewRuler */])(node)) {
            this._decorationsTree1.delete(node);
        }
        else {
            this._decorationsTree0.delete(node);
        }
    };
    DecorationsTrees.prototype.resolveNode = function (node, cachedVersionId) {
        if (Object(__WEBPACK_IMPORTED_MODULE_12__intervalTree_js__["c" /* getNodeIsInOverviewRuler */])(node)) {
            this._decorationsTree1.resolveNode(node, cachedVersionId);
        }
        else {
            this._decorationsTree0.resolveNode(node, cachedVersionId);
        }
    };
    DecorationsTrees.prototype.acceptReplace = function (offset, length, textLength, forceMoveMarkers) {
        this._decorationsTree0.acceptReplace(offset, length, textLength, forceMoveMarkers);
        this._decorationsTree1.acceptReplace(offset, length, textLength, forceMoveMarkers);
    };
    return DecorationsTrees;
}());
function cleanClassName(className) {
    return className.replace(/[^a-z0-9\-_]/gi, ' ');
}
var DecorationOptions = /** @class */ (function () {
    function DecorationOptions(options) {
        this.color = options.color || '';
        this.darkColor = options.darkColor || '';
    }
    return DecorationOptions;
}());
var ModelDecorationOverviewRulerOptions = /** @class */ (function (_super) {
    __extends(ModelDecorationOverviewRulerOptions, _super);
    function ModelDecorationOverviewRulerOptions(options) {
        var _this = _super.call(this, options) || this;
        _this._resolvedColor = null;
        _this.position = (typeof options.position === 'number' ? options.position : __WEBPACK_IMPORTED_MODULE_9__model_js__["d" /* OverviewRulerLane */].Center);
        return _this;
    }
    ModelDecorationOverviewRulerOptions.prototype.getColor = function (theme) {
        if (!this._resolvedColor) {
            if (theme.type !== 'light' && this.darkColor) {
                this._resolvedColor = this._resolveColor(this.darkColor, theme);
            }
            else {
                this._resolvedColor = this._resolveColor(this.color, theme);
            }
        }
        return this._resolvedColor;
    };
    ModelDecorationOverviewRulerOptions.prototype.invalidateCachedColor = function () {
        this._resolvedColor = null;
    };
    ModelDecorationOverviewRulerOptions.prototype._resolveColor = function (color, theme) {
        if (typeof color === 'string') {
            return color;
        }
        var c = color ? theme.getColor(color.id) : null;
        if (!c) {
            return '';
        }
        return c.toString();
    };
    return ModelDecorationOverviewRulerOptions;
}(DecorationOptions));

var ModelDecorationMinimapOptions = /** @class */ (function (_super) {
    __extends(ModelDecorationMinimapOptions, _super);
    function ModelDecorationMinimapOptions(options) {
        var _this = _super.call(this, options) || this;
        _this.position = options.position;
        return _this;
    }
    ModelDecorationMinimapOptions.prototype.getColor = function (theme) {
        if (!this._resolvedColor) {
            if (theme.type !== 'light' && this.darkColor) {
                this._resolvedColor = this._resolveColor(this.darkColor, theme);
            }
            else {
                this._resolvedColor = this._resolveColor(this.color, theme);
            }
        }
        return this._resolvedColor;
    };
    ModelDecorationMinimapOptions.prototype.invalidateCachedColor = function () {
        this._resolvedColor = undefined;
    };
    ModelDecorationMinimapOptions.prototype._resolveColor = function (color, theme) {
        if (typeof color === 'string') {
            return __WEBPACK_IMPORTED_MODULE_24__base_common_color_js__["a" /* Color */].fromHex(color);
        }
        return theme.getColor(color.id);
    };
    return ModelDecorationMinimapOptions;
}(DecorationOptions));

var ModelDecorationOptions = /** @class */ (function () {
    function ModelDecorationOptions(options) {
        this.stickiness = options.stickiness || 0 /* AlwaysGrowsWhenTypingAtEdges */;
        this.zIndex = options.zIndex || 0;
        this.className = options.className ? cleanClassName(options.className) : null;
        this.hoverMessage = Object(__WEBPACK_IMPORTED_MODULE_22__base_common_types_js__["o" /* withUndefinedAsNull */])(options.hoverMessage);
        this.glyphMarginHoverMessage = Object(__WEBPACK_IMPORTED_MODULE_22__base_common_types_js__["o" /* withUndefinedAsNull */])(options.glyphMarginHoverMessage);
        this.isWholeLine = options.isWholeLine || false;
        this.showIfCollapsed = options.showIfCollapsed || false;
        this.collapseOnReplaceEdit = options.collapseOnReplaceEdit || false;
        this.overviewRuler = options.overviewRuler ? new ModelDecorationOverviewRulerOptions(options.overviewRuler) : null;
        this.minimap = options.minimap ? new ModelDecorationMinimapOptions(options.minimap) : null;
        this.glyphMarginClassName = options.glyphMarginClassName ? cleanClassName(options.glyphMarginClassName) : null;
        this.linesDecorationsClassName = options.linesDecorationsClassName ? cleanClassName(options.linesDecorationsClassName) : null;
        this.marginClassName = options.marginClassName ? cleanClassName(options.marginClassName) : null;
        this.inlineClassName = options.inlineClassName ? cleanClassName(options.inlineClassName) : null;
        this.inlineClassNameAffectsLetterSpacing = options.inlineClassNameAffectsLetterSpacing || false;
        this.beforeContentClassName = options.beforeContentClassName ? cleanClassName(options.beforeContentClassName) : null;
        this.afterContentClassName = options.afterContentClassName ? cleanClassName(options.afterContentClassName) : null;
    }
    ModelDecorationOptions.register = function (options) {
        return new ModelDecorationOptions(options);
    };
    ModelDecorationOptions.createDynamic = function (options) {
        return new ModelDecorationOptions(options);
    };
    return ModelDecorationOptions;
}());

ModelDecorationOptions.EMPTY = ModelDecorationOptions.register({});
/**
 * The order carefully matches the values of the enum.
 */
var TRACKED_RANGE_OPTIONS = [
    ModelDecorationOptions.register({ stickiness: 0 /* AlwaysGrowsWhenTypingAtEdges */ }),
    ModelDecorationOptions.register({ stickiness: 1 /* NeverGrowsWhenTypingAtEdges */ }),
    ModelDecorationOptions.register({ stickiness: 2 /* GrowsOnlyWhenTypingBefore */ }),
    ModelDecorationOptions.register({ stickiness: 3 /* GrowsOnlyWhenTypingAfter */ }),
];
function _normalizeOptions(options) {
    if (options instanceof ModelDecorationOptions) {
        return options;
    }
    return ModelDecorationOptions.createDynamic(options);
}
var DidChangeDecorationsEmitter = /** @class */ (function (_super) {
    __extends(DidChangeDecorationsEmitter, _super);
    function DidChangeDecorationsEmitter() {
        var _this = _super.call(this) || this;
        _this._actual = _this._register(new __WEBPACK_IMPORTED_MODULE_1__base_common_event_js__["a" /* Emitter */]());
        _this.event = _this._actual.event;
        _this._deferredCnt = 0;
        _this._shouldFire = false;
        return _this;
    }
    DidChangeDecorationsEmitter.prototype.beginDeferredEmit = function () {
        this._deferredCnt++;
    };
    DidChangeDecorationsEmitter.prototype.endDeferredEmit = function () {
        this._deferredCnt--;
        if (this._deferredCnt === 0) {
            if (this._shouldFire) {
                this._shouldFire = false;
                this._actual.fire({});
            }
        }
    };
    DidChangeDecorationsEmitter.prototype.fire = function () {
        this._shouldFire = true;
    };
    return DidChangeDecorationsEmitter;
}(__WEBPACK_IMPORTED_MODULE_2__base_common_lifecycle_js__["a" /* Disposable */]));

//#endregion
var DidChangeContentEmitter = /** @class */ (function (_super) {
    __extends(DidChangeContentEmitter, _super);
    function DidChangeContentEmitter() {
        var _this = _super.call(this) || this;
        /**
         * Both `fastEvent` and `slowEvent` work the same way and contain the same events, but first we invoke `fastEvent` and then `slowEvent`.
         */
        _this._fastEmitter = _this._register(new __WEBPACK_IMPORTED_MODULE_1__base_common_event_js__["a" /* Emitter */]());
        _this.fastEvent = _this._fastEmitter.event;
        _this._slowEmitter = _this._register(new __WEBPACK_IMPORTED_MODULE_1__base_common_event_js__["a" /* Emitter */]());
        _this.slowEvent = _this._slowEmitter.event;
        _this._deferredCnt = 0;
        _this._deferredEvent = null;
        return _this;
    }
    DidChangeContentEmitter.prototype.beginDeferredEmit = function () {
        this._deferredCnt++;
    };
    DidChangeContentEmitter.prototype.endDeferredEmit = function () {
        this._deferredCnt--;
        if (this._deferredCnt === 0) {
            if (this._deferredEvent !== null) {
                var e = this._deferredEvent;
                this._deferredEvent = null;
                this._fastEmitter.fire(e);
                this._slowEmitter.fire(e);
            }
        }
    };
    DidChangeContentEmitter.prototype.fire = function (e) {
        if (this._deferredCnt > 0) {
            if (this._deferredEvent) {
                this._deferredEvent = this._deferredEvent.merge(e);
            }
            else {
                this._deferredEvent = e;
            }
            return;
        }
        this._fastEmitter.fire(e);
        this._slowEmitter.fire(e);
    };
    return DidChangeContentEmitter;
}(__WEBPACK_IMPORTED_MODULE_2__base_common_lifecycle_js__["a" /* Disposable */]));



/***/ }),
/* 30 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return ICodeEditorService; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__platform_instantiation_common_instantiation_js__ = __webpack_require__(10);
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/

var ICodeEditorService = Object(__WEBPACK_IMPORTED_MODULE_0__platform_instantiation_common_instantiation_js__["c" /* createDecorator */])('codeEditorService');


/***/ }),
/* 31 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (immutable) */ __webpack_exports__["c"] = deepClone;
/* harmony export (immutable) */ __webpack_exports__["d"] = deepFreeze;
/* harmony export (immutable) */ __webpack_exports__["b"] = cloneAndChange;
/* harmony export (immutable) */ __webpack_exports__["g"] = mixin;
/* harmony export (immutable) */ __webpack_exports__["a"] = assign;
/* harmony export (immutable) */ __webpack_exports__["e"] = equals;
/* harmony export (immutable) */ __webpack_exports__["f"] = getOrDefault;
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__types_js__ = __webpack_require__(20);
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/

function deepClone(obj) {
    if (!obj || typeof obj !== 'object') {
        return obj;
    }
    if (obj instanceof RegExp) {
        // See https://github.com/Microsoft/TypeScript/issues/10990
        return obj;
    }
    var result = Array.isArray(obj) ? [] : {};
    Object.keys(obj).forEach(function (key) {
        if (obj[key] && typeof obj[key] === 'object') {
            result[key] = deepClone(obj[key]);
        }
        else {
            result[key] = obj[key];
        }
    });
    return result;
}
function deepFreeze(obj) {
    if (!obj || typeof obj !== 'object') {
        return obj;
    }
    var stack = [obj];
    while (stack.length > 0) {
        var obj_1 = stack.shift();
        Object.freeze(obj_1);
        for (var key in obj_1) {
            if (_hasOwnProperty.call(obj_1, key)) {
                var prop = obj_1[key];
                if (typeof prop === 'object' && !Object.isFrozen(prop)) {
                    stack.push(prop);
                }
            }
        }
    }
    return obj;
}
var _hasOwnProperty = Object.prototype.hasOwnProperty;
function cloneAndChange(obj, changer) {
    return _cloneAndChange(obj, changer, new Set());
}
function _cloneAndChange(obj, changer, seen) {
    if (Object(__WEBPACK_IMPORTED_MODULE_0__types_js__["l" /* isUndefinedOrNull */])(obj)) {
        return obj;
    }
    var changed = changer(obj);
    if (typeof changed !== 'undefined') {
        return changed;
    }
    if (Object(__WEBPACK_IMPORTED_MODULE_0__types_js__["d" /* isArray */])(obj)) {
        var r1 = [];
        for (var _i = 0, obj_2 = obj; _i < obj_2.length; _i++) {
            var e = obj_2[_i];
            r1.push(_cloneAndChange(e, changer, seen));
        }
        return r1;
    }
    if (Object(__WEBPACK_IMPORTED_MODULE_0__types_js__["i" /* isObject */])(obj)) {
        if (seen.has(obj)) {
            throw new Error('Cannot clone recursive data-structure');
        }
        seen.add(obj);
        var r2 = {};
        for (var i2 in obj) {
            if (_hasOwnProperty.call(obj, i2)) {
                r2[i2] = _cloneAndChange(obj[i2], changer, seen);
            }
        }
        seen.delete(obj);
        return r2;
    }
    return obj;
}
/**
 * Copies all properties of source into destination. The optional parameter "overwrite" allows to control
 * if existing properties on the destination should be overwritten or not. Defaults to true (overwrite).
 */
function mixin(destination, source, overwrite) {
    if (overwrite === void 0) { overwrite = true; }
    if (!Object(__WEBPACK_IMPORTED_MODULE_0__types_js__["i" /* isObject */])(destination)) {
        return source;
    }
    if (Object(__WEBPACK_IMPORTED_MODULE_0__types_js__["i" /* isObject */])(source)) {
        Object.keys(source).forEach(function (key) {
            if (key in destination) {
                if (overwrite) {
                    if (Object(__WEBPACK_IMPORTED_MODULE_0__types_js__["i" /* isObject */])(destination[key]) && Object(__WEBPACK_IMPORTED_MODULE_0__types_js__["i" /* isObject */])(source[key])) {
                        mixin(destination[key], source[key], overwrite);
                    }
                    else {
                        destination[key] = source[key];
                    }
                }
            }
            else {
                destination[key] = source[key];
            }
        });
    }
    return destination;
}
function assign(destination) {
    var sources = [];
    for (var _i = 1; _i < arguments.length; _i++) {
        sources[_i - 1] = arguments[_i];
    }
    sources.forEach(function (source) { return Object.keys(source).forEach(function (key) { return destination[key] = source[key]; }); });
    return destination;
}
function equals(one, other) {
    if (one === other) {
        return true;
    }
    if (one === null || one === undefined || other === null || other === undefined) {
        return false;
    }
    if (typeof one !== typeof other) {
        return false;
    }
    if (typeof one !== 'object') {
        return false;
    }
    if ((Array.isArray(one)) !== (Array.isArray(other))) {
        return false;
    }
    var i;
    var key;
    if (Array.isArray(one)) {
        if (one.length !== other.length) {
            return false;
        }
        for (i = 0; i < one.length; i++) {
            if (!equals(one[i], other[i])) {
                return false;
            }
        }
    }
    else {
        var oneKeys = [];
        for (key in one) {
            oneKeys.push(key);
        }
        oneKeys.sort();
        var otherKeys = [];
        for (key in other) {
            otherKeys.push(key);
        }
        otherKeys.sort();
        if (!equals(oneKeys, otherKeys)) {
            return false;
        }
        for (i = 0; i < oneKeys.length; i++) {
            if (!equals(one[oneKeys[i]], other[oneKeys[i]])) {
                return false;
            }
        }
    }
    return true;
}
function getOrDefault(obj, fn, defaultValue) {
    var result = fn(obj);
    return typeof result === 'undefined' ? defaultValue : result;
}


/***/ }),
/* 32 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "f", function() { return MINIMAP_GUTTER_WIDTH; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return ConfigurationChangedEvent; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "h", function() { return ValidatedEditorOptions; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "g", function() { return TextEditorCursorStyle; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "d", function() { return EditorFontLigatures; });
/* unused harmony export EditorLayoutInfoComputer */
/* harmony export (immutable) */ __webpack_exports__["j"] = filterValidationDecorations;
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "b", function() { return EDITOR_FONT_DEFAULTS; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "c", function() { return EDITOR_MODEL_DEFAULTS; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "i", function() { return editorOptionsRegistry; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "e", function() { return EditorOptions; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__nls_js__ = __webpack_require__(5);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__base_common_platform_js__ = __webpack_require__(14);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2__model_wordHelper_js__ = __webpack_require__(117);
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};



/**
 * @internal
 * The width of the minimap gutter, in pixels.
 */
var MINIMAP_GUTTER_WIDTH = 8;
//#endregion
/**
 * An event describing that the configuration of the editor has changed.
 */
var ConfigurationChangedEvent = /** @class */ (function () {
    /**
     * @internal
     */
    function ConfigurationChangedEvent(values) {
        this._values = values;
    }
    ConfigurationChangedEvent.prototype.hasChanged = function (id) {
        return this._values[id];
    };
    return ConfigurationChangedEvent;
}());

/**
 * @internal
 */
var ValidatedEditorOptions = /** @class */ (function () {
    function ValidatedEditorOptions() {
        this._values = [];
    }
    ValidatedEditorOptions.prototype._read = function (option) {
        return this._values[option];
    };
    ValidatedEditorOptions.prototype.get = function (id) {
        return this._values[id];
    };
    ValidatedEditorOptions.prototype._write = function (option, value) {
        this._values[option] = value;
    };
    return ValidatedEditorOptions;
}());

/**
 * @internal
 */
var BaseEditorOption = /** @class */ (function () {
    function BaseEditorOption(id, name, defaultValue, schema) {
        this.id = id;
        this.name = name;
        this.defaultValue = defaultValue;
        this.schema = schema;
    }
    BaseEditorOption.prototype.compute = function (env, options, value) {
        return value;
    };
    return BaseEditorOption;
}());
/**
 * @internal
 */
var ComputedEditorOption = /** @class */ (function () {
    function ComputedEditorOption(id, deps) {
        if (deps === void 0) { deps = null; }
        this.schema = undefined;
        this.id = id;
        this.name = '_never_';
        this.defaultValue = undefined;
        this.deps = deps;
    }
    ComputedEditorOption.prototype.validate = function (input) {
        return this.defaultValue;
    };
    return ComputedEditorOption;
}());
var SimpleEditorOption = /** @class */ (function () {
    function SimpleEditorOption(id, name, defaultValue, schema) {
        this.id = id;
        this.name = name;
        this.defaultValue = defaultValue;
        this.schema = schema;
    }
    SimpleEditorOption.prototype.validate = function (input) {
        if (typeof input === 'undefined') {
            return this.defaultValue;
        }
        return input;
    };
    SimpleEditorOption.prototype.compute = function (env, options, value) {
        return value;
    };
    return SimpleEditorOption;
}());
var EditorBooleanOption = /** @class */ (function (_super) {
    __extends(EditorBooleanOption, _super);
    function EditorBooleanOption(id, name, defaultValue, schema) {
        if (schema === void 0) { schema = undefined; }
        var _this = this;
        if (typeof schema !== 'undefined') {
            schema.type = 'boolean';
            schema.default = defaultValue;
        }
        _this = _super.call(this, id, name, defaultValue, schema) || this;
        return _this;
    }
    EditorBooleanOption.boolean = function (value, defaultValue) {
        if (typeof value === 'undefined') {
            return defaultValue;
        }
        if (value === 'false') {
            // treat the string 'false' as false
            return false;
        }
        return Boolean(value);
    };
    EditorBooleanOption.prototype.validate = function (input) {
        return EditorBooleanOption.boolean(input, this.defaultValue);
    };
    return EditorBooleanOption;
}(SimpleEditorOption));
var EditorIntOption = /** @class */ (function (_super) {
    __extends(EditorIntOption, _super);
    function EditorIntOption(id, name, defaultValue, minimum, maximum, schema) {
        if (schema === void 0) { schema = undefined; }
        var _this = this;
        if (typeof schema !== 'undefined') {
            schema.type = 'integer';
            schema.default = defaultValue;
            schema.minimum = minimum;
            schema.maximum = maximum;
        }
        _this = _super.call(this, id, name, defaultValue, schema) || this;
        _this.minimum = minimum;
        _this.maximum = maximum;
        return _this;
    }
    EditorIntOption.clampedInt = function (value, defaultValue, minimum, maximum) {
        var r;
        if (typeof value === 'undefined') {
            r = defaultValue;
        }
        else {
            r = parseInt(value, 10);
            if (isNaN(r)) {
                r = defaultValue;
            }
        }
        r = Math.max(minimum, r);
        r = Math.min(maximum, r);
        return r | 0;
    };
    EditorIntOption.prototype.validate = function (input) {
        return EditorIntOption.clampedInt(input, this.defaultValue, this.minimum, this.maximum);
    };
    return EditorIntOption;
}(SimpleEditorOption));
var EditorFloatOption = /** @class */ (function (_super) {
    __extends(EditorFloatOption, _super);
    function EditorFloatOption(id, name, defaultValue, validationFn, schema) {
        var _this = this;
        if (typeof schema !== 'undefined') {
            schema.type = 'number';
            schema.default = defaultValue;
        }
        _this = _super.call(this, id, name, defaultValue, schema) || this;
        _this.validationFn = validationFn;
        return _this;
    }
    EditorFloatOption.clamp = function (n, min, max) {
        if (n < min) {
            return min;
        }
        if (n > max) {
            return max;
        }
        return n;
    };
    EditorFloatOption.float = function (value, defaultValue) {
        if (typeof value === 'number') {
            return value;
        }
        if (typeof value === 'undefined') {
            return defaultValue;
        }
        var r = parseFloat(value);
        return (isNaN(r) ? defaultValue : r);
    };
    EditorFloatOption.prototype.validate = function (input) {
        return this.validationFn(EditorFloatOption.float(input, this.defaultValue));
    };
    return EditorFloatOption;
}(SimpleEditorOption));
var EditorStringOption = /** @class */ (function (_super) {
    __extends(EditorStringOption, _super);
    function EditorStringOption(id, name, defaultValue, schema) {
        if (schema === void 0) { schema = undefined; }
        var _this = this;
        if (typeof schema !== 'undefined') {
            schema.type = 'string';
            schema.default = defaultValue;
        }
        _this = _super.call(this, id, name, defaultValue, schema) || this;
        return _this;
    }
    EditorStringOption.string = function (value, defaultValue) {
        if (typeof value !== 'string') {
            return defaultValue;
        }
        return value;
    };
    EditorStringOption.prototype.validate = function (input) {
        return EditorStringOption.string(input, this.defaultValue);
    };
    return EditorStringOption;
}(SimpleEditorOption));
var EditorStringEnumOption = /** @class */ (function (_super) {
    __extends(EditorStringEnumOption, _super);
    function EditorStringEnumOption(id, name, defaultValue, allowedValues, schema) {
        if (schema === void 0) { schema = undefined; }
        var _this = this;
        if (typeof schema !== 'undefined') {
            schema.type = 'string';
            schema.enum = allowedValues;
            schema.default = defaultValue;
        }
        _this = _super.call(this, id, name, defaultValue, schema) || this;
        _this._allowedValues = allowedValues;
        return _this;
    }
    EditorStringEnumOption.stringSet = function (value, defaultValue, allowedValues) {
        if (typeof value !== 'string') {
            return defaultValue;
        }
        if (allowedValues.indexOf(value) === -1) {
            return defaultValue;
        }
        return value;
    };
    EditorStringEnumOption.prototype.validate = function (input) {
        return EditorStringEnumOption.stringSet(input, this.defaultValue, this._allowedValues);
    };
    return EditorStringEnumOption;
}(SimpleEditorOption));
var EditorEnumOption = /** @class */ (function (_super) {
    __extends(EditorEnumOption, _super);
    function EditorEnumOption(id, name, defaultValue, defaultStringValue, allowedValues, convert, schema) {
        if (schema === void 0) { schema = undefined; }
        var _this = this;
        if (typeof schema !== 'undefined') {
            schema.type = 'string';
            schema.enum = allowedValues;
            schema.default = defaultStringValue;
        }
        _this = _super.call(this, id, name, defaultValue, schema) || this;
        _this._allowedValues = allowedValues;
        _this._convert = convert;
        return _this;
    }
    EditorEnumOption.prototype.validate = function (input) {
        if (typeof input !== 'string') {
            return this.defaultValue;
        }
        if (this._allowedValues.indexOf(input) === -1) {
            return this.defaultValue;
        }
        return this._convert(input);
    };
    return EditorEnumOption;
}(BaseEditorOption));
//#endregion
//#region autoIndent
function _autoIndentFromString(autoIndent) {
    switch (autoIndent) {
        case 'none': return 0 /* None */;
        case 'keep': return 1 /* Keep */;
        case 'brackets': return 2 /* Brackets */;
        case 'advanced': return 3 /* Advanced */;
        case 'full': return 4 /* Full */;
    }
}
//#endregion
//#region accessibilitySupport
var EditorAccessibilitySupport = /** @class */ (function (_super) {
    __extends(EditorAccessibilitySupport, _super);
    function EditorAccessibilitySupport() {
        return _super.call(this, 2 /* accessibilitySupport */, 'accessibilitySupport', 0 /* Unknown */, {
            type: 'string',
            enum: ['auto', 'on', 'off'],
            enumDescriptions: [
                __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('accessibilitySupport.auto', "The editor will use platform APIs to detect when a Screen Reader is attached."),
                __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('accessibilitySupport.on', "The editor will be permanently optimized for usage with a Screen Reader."),
                __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('accessibilitySupport.off', "The editor will never be optimized for usage with a Screen Reader."),
            ],
            default: 'auto',
            description: __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('accessibilitySupport', "Controls whether the editor should run in a mode where it is optimized for screen readers.")
        }) || this;
    }
    EditorAccessibilitySupport.prototype.validate = function (input) {
        switch (input) {
            case 'auto': return 0 /* Unknown */;
            case 'off': return 1 /* Disabled */;
            case 'on': return 2 /* Enabled */;
        }
        return this.defaultValue;
    };
    EditorAccessibilitySupport.prototype.compute = function (env, options, value) {
        if (value === 0 /* Unknown */) {
            // The editor reads the `accessibilitySupport` from the environment
            return env.accessibilitySupport;
        }
        return value;
    };
    return EditorAccessibilitySupport;
}(BaseEditorOption));
var EditorComments = /** @class */ (function (_super) {
    __extends(EditorComments, _super);
    function EditorComments() {
        var _this = this;
        var defaults = {
            insertSpace: true,
        };
        _this = _super.call(this, 13 /* comments */, 'comments', defaults, {
            'editor.comments.insertSpace': {
                type: 'boolean',
                default: defaults.insertSpace,
                description: __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('comments.insertSpace', "Controls whether a space character is inserted when commenting.")
            },
        }) || this;
        return _this;
    }
    EditorComments.prototype.validate = function (_input) {
        if (typeof _input !== 'object') {
            return this.defaultValue;
        }
        var input = _input;
        return {
            insertSpace: EditorBooleanOption.boolean(input.insertSpace, this.defaultValue.insertSpace),
        };
    };
    return EditorComments;
}(BaseEditorOption));
function _cursorBlinkingStyleFromString(cursorBlinkingStyle) {
    switch (cursorBlinkingStyle) {
        case 'blink': return 1 /* Blink */;
        case 'smooth': return 2 /* Smooth */;
        case 'phase': return 3 /* Phase */;
        case 'expand': return 4 /* Expand */;
        case 'solid': return 5 /* Solid */;
    }
}
//#endregion
//#region cursorStyle
/**
 * The style in which the editor's cursor should be rendered.
 */
var TextEditorCursorStyle;
(function (TextEditorCursorStyle) {
    /**
     * As a vertical line (sitting between two characters).
     */
    TextEditorCursorStyle[TextEditorCursorStyle["Line"] = 1] = "Line";
    /**
     * As a block (sitting on top of a character).
     */
    TextEditorCursorStyle[TextEditorCursorStyle["Block"] = 2] = "Block";
    /**
     * As a horizontal line (sitting under a character).
     */
    TextEditorCursorStyle[TextEditorCursorStyle["Underline"] = 3] = "Underline";
    /**
     * As a thin vertical line (sitting between two characters).
     */
    TextEditorCursorStyle[TextEditorCursorStyle["LineThin"] = 4] = "LineThin";
    /**
     * As an outlined block (sitting on top of a character).
     */
    TextEditorCursorStyle[TextEditorCursorStyle["BlockOutline"] = 5] = "BlockOutline";
    /**
     * As a thin horizontal line (sitting under a character).
     */
    TextEditorCursorStyle[TextEditorCursorStyle["UnderlineThin"] = 6] = "UnderlineThin";
})(TextEditorCursorStyle || (TextEditorCursorStyle = {}));
function _cursorStyleFromString(cursorStyle) {
    switch (cursorStyle) {
        case 'line': return TextEditorCursorStyle.Line;
        case 'block': return TextEditorCursorStyle.Block;
        case 'underline': return TextEditorCursorStyle.Underline;
        case 'line-thin': return TextEditorCursorStyle.LineThin;
        case 'block-outline': return TextEditorCursorStyle.BlockOutline;
        case 'underline-thin': return TextEditorCursorStyle.UnderlineThin;
    }
}
//#endregion
//#region editorClassName
var EditorClassName = /** @class */ (function (_super) {
    __extends(EditorClassName, _super);
    function EditorClassName() {
        return _super.call(this, 104 /* editorClassName */, [55 /* mouseStyle */, 26 /* extraEditorClassName */]) || this;
    }
    EditorClassName.prototype.compute = function (env, options, _) {
        var className = 'monaco-editor';
        if (options.get(26 /* extraEditorClassName */)) {
            className += ' ' + options.get(26 /* extraEditorClassName */);
        }
        if (env.extraEditorClassName) {
            className += ' ' + env.extraEditorClassName;
        }
        if (options.get(55 /* mouseStyle */) === 'default') {
            className += ' mouse-default';
        }
        else if (options.get(55 /* mouseStyle */) === 'copy') {
            className += ' mouse-copy';
        }
        if (options.get(85 /* showUnused */)) {
            className += ' showUnused';
        }
        return className;
    };
    return EditorClassName;
}(ComputedEditorOption));
//#endregion
//#region emptySelectionClipboard
var EditorEmptySelectionClipboard = /** @class */ (function (_super) {
    __extends(EditorEmptySelectionClipboard, _super);
    function EditorEmptySelectionClipboard() {
        return _super.call(this, 25 /* emptySelectionClipboard */, 'emptySelectionClipboard', true, { description: __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('emptySelectionClipboard', "Controls whether copying without a selection copies the current line.") }) || this;
    }
    EditorEmptySelectionClipboard.prototype.compute = function (env, options, value) {
        return value && env.emptySelectionClipboard;
    };
    return EditorEmptySelectionClipboard;
}(EditorBooleanOption));
var EditorFind = /** @class */ (function (_super) {
    __extends(EditorFind, _super);
    function EditorFind() {
        var _this = this;
        var defaults = {
            seedSearchStringFromSelection: true,
            autoFindInSelection: 'never',
            globalFindClipboard: false,
            addExtraSpaceOnTop: true
        };
        _this = _super.call(this, 28 /* find */, 'find', defaults, {
            'editor.find.seedSearchStringFromSelection': {
                type: 'boolean',
                default: defaults.seedSearchStringFromSelection,
                description: __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('find.seedSearchStringFromSelection', "Controls whether the search string in the Find Widget is seeded from the editor selection.")
            },
            'editor.find.autoFindInSelection': {
                type: 'string',
                enum: ['never', 'always', 'multiline'],
                default: defaults.autoFindInSelection,
                enumDescriptions: [
                    __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('editor.find.autoFindInSelection.never', 'Never turn on Find in selection automatically (default)'),
                    __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('editor.find.autoFindInSelection.always', 'Always turn on Find in selection automatically'),
                    __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('editor.find.autoFindInSelection.multiline', 'Turn on Find in selection automatically when multiple lines of content are selected.')
                ],
                description: __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('find.autoFindInSelection', "Controls whether the find operation is carried out on selected text or the entire file in the editor.")
            },
            'editor.find.globalFindClipboard': {
                type: 'boolean',
                default: defaults.globalFindClipboard,
                description: __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('find.globalFindClipboard', "Controls whether the Find Widget should read or modify the shared find clipboard on macOS."),
                included: __WEBPACK_IMPORTED_MODULE_1__base_common_platform_js__["e" /* isMacintosh */]
            },
            'editor.find.addExtraSpaceOnTop': {
                type: 'boolean',
                default: defaults.addExtraSpaceOnTop,
                description: __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('find.addExtraSpaceOnTop', "Controls whether the Find Widget should add extra lines on top of the editor. When true, you can scroll beyond the first line when the Find Widget is visible.")
            }
        }) || this;
        return _this;
    }
    EditorFind.prototype.validate = function (_input) {
        if (typeof _input !== 'object') {
            return this.defaultValue;
        }
        var input = _input;
        return {
            seedSearchStringFromSelection: EditorBooleanOption.boolean(input.seedSearchStringFromSelection, this.defaultValue.seedSearchStringFromSelection),
            autoFindInSelection: typeof _input.autoFindInSelection === 'boolean'
                ? (_input.autoFindInSelection ? 'always' : 'never')
                : EditorStringEnumOption.stringSet(input.autoFindInSelection, this.defaultValue.autoFindInSelection, ['never', 'always', 'multiline']),
            globalFindClipboard: EditorBooleanOption.boolean(input.globalFindClipboard, this.defaultValue.globalFindClipboard),
            addExtraSpaceOnTop: EditorBooleanOption.boolean(input.addExtraSpaceOnTop, this.defaultValue.addExtraSpaceOnTop)
        };
    };
    return EditorFind;
}(BaseEditorOption));
//#endregion
//#region fontLigatures
/**
 * @internal
 */
var EditorFontLigatures = /** @class */ (function (_super) {
    __extends(EditorFontLigatures, _super);
    function EditorFontLigatures() {
        return _super.call(this, 35 /* fontLigatures */, 'fontLigatures', EditorFontLigatures.OFF, {
            anyOf: [
                {
                    type: 'boolean',
                    description: __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('fontLigatures', "Enables/Disables font ligatures."),
                },
                {
                    type: 'string',
                    description: __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('fontFeatureSettings', "Explicit font-feature-settings.")
                }
            ],
            description: __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('fontLigaturesGeneral', "Configures font ligatures."),
            default: false
        }) || this;
    }
    EditorFontLigatures.prototype.validate = function (input) {
        if (typeof input === 'undefined') {
            return this.defaultValue;
        }
        if (typeof input === 'string') {
            if (input === 'false') {
                return EditorFontLigatures.OFF;
            }
            if (input === 'true') {
                return EditorFontLigatures.ON;
            }
            return input;
        }
        if (Boolean(input)) {
            return EditorFontLigatures.ON;
        }
        return EditorFontLigatures.OFF;
    };
    EditorFontLigatures.OFF = '"liga" off, "calt" off';
    EditorFontLigatures.ON = '"liga" on, "calt" on';
    return EditorFontLigatures;
}(BaseEditorOption));

//#endregion
//#region fontInfo
var EditorFontInfo = /** @class */ (function (_super) {
    __extends(EditorFontInfo, _super);
    function EditorFontInfo() {
        return _super.call(this, 34 /* fontInfo */) || this;
    }
    EditorFontInfo.prototype.compute = function (env, options, _) {
        return env.fontInfo;
    };
    return EditorFontInfo;
}(ComputedEditorOption));
//#endregion
//#region fontSize
var EditorFontSize = /** @class */ (function (_super) {
    __extends(EditorFontSize, _super);
    function EditorFontSize() {
        return _super.call(this, 36 /* fontSize */, 'fontSize', EDITOR_FONT_DEFAULTS.fontSize, {
            type: 'number',
            minimum: 6,
            maximum: 100,
            default: EDITOR_FONT_DEFAULTS.fontSize,
            description: __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('fontSize', "Controls the font size in pixels.")
        }) || this;
    }
    EditorFontSize.prototype.validate = function (input) {
        var r = EditorFloatOption.float(input, this.defaultValue);
        if (r === 0) {
            return EDITOR_FONT_DEFAULTS.fontSize;
        }
        return EditorFloatOption.clamp(r, 6, 100);
    };
    EditorFontSize.prototype.compute = function (env, options, value) {
        // The final fontSize respects the editor zoom level.
        // So take the result from env.fontInfo
        return env.fontInfo.fontSize;
    };
    return EditorFontSize;
}(SimpleEditorOption));
var EditorGoToLocation = /** @class */ (function (_super) {
    __extends(EditorGoToLocation, _super);
    function EditorGoToLocation() {
        var _this = this;
        var defaults = {
            multiple: 'peek',
            multipleDefinitions: 'peek',
            multipleTypeDefinitions: 'peek',
            multipleDeclarations: 'peek',
            multipleImplementations: 'peek',
            multipleReferences: 'peek',
            alternativeDefinitionCommand: 'editor.action.goToReferences',
            alternativeTypeDefinitionCommand: 'editor.action.goToReferences',
            alternativeDeclarationCommand: 'editor.action.goToReferences',
            alternativeImplementationCommand: '',
            alternativeReferenceCommand: '',
        };
        var jsonSubset = {
            type: 'string',
            enum: ['peek', 'gotoAndPeek', 'goto'],
            default: defaults.multiple,
            enumDescriptions: [
                __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('editor.gotoLocation.multiple.peek', 'Show peek view of the results (default)'),
                __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('editor.gotoLocation.multiple.gotoAndPeek', 'Go to the primary result and show a peek view'),
                __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('editor.gotoLocation.multiple.goto', 'Go to the primary result and enable peek-less navigation to others')
            ]
        };
        _this = _super.call(this, 41 /* gotoLocation */, 'gotoLocation', defaults, {
            'editor.gotoLocation.multiple': {
                deprecationMessage: __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('editor.gotoLocation.multiple.deprecated', "This setting is deprecated, please use separate settings like 'editor.editor.gotoLocation.multipleDefinitions' or 'editor.editor.gotoLocation.multipleImplementations' instead."),
            },
            'editor.gotoLocation.multipleDefinitions': __assign({ description: __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('editor.editor.gotoLocation.multipleDefinitions', "Controls the behavior the 'Go to Definition'-command when multiple target locations exist.") }, jsonSubset),
            'editor.gotoLocation.multipleTypeDefinitions': __assign({ description: __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('editor.editor.gotoLocation.multipleTypeDefinitions', "Controls the behavior the 'Go to Type Definition'-command when multiple target locations exist.") }, jsonSubset),
            'editor.gotoLocation.multipleDeclarations': __assign({ description: __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('editor.editor.gotoLocation.multipleDeclarations', "Controls the behavior the 'Go to Declaration'-command when multiple target locations exist.") }, jsonSubset),
            'editor.gotoLocation.multipleImplementations': __assign({ description: __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('editor.editor.gotoLocation.multipleImplemenattions', "Controls the behavior the 'Go to Implementations'-command when multiple target locations exist.") }, jsonSubset),
            'editor.gotoLocation.multipleReferences': __assign({ description: __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('editor.editor.gotoLocation.multipleReferences', "Controls the behavior the 'Go to References'-command when multiple target locations exist.") }, jsonSubset),
            'editor.gotoLocation.alternativeDefinitionCommand': {
                type: 'string',
                default: defaults.alternativeDefinitionCommand,
                description: __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('alternativeDefinitionCommand', "Alternative command id that is being executed when the result of 'Go to Definition' is the current location.")
            },
            'editor.gotoLocation.alternativeTypeDefinitionCommand': {
                type: 'string',
                default: defaults.alternativeTypeDefinitionCommand,
                description: __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('alternativeTypeDefinitionCommand', "Alternative command id that is being executed when the result of 'Go to Type Definition' is the current location.")
            },
            'editor.gotoLocation.alternativeDeclarationCommand': {
                type: 'string',
                default: defaults.alternativeDeclarationCommand,
                description: __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('alternativeDeclarationCommand', "Alternative command id that is being executed when the result of 'Go to Declaration' is the current location.")
            },
            'editor.gotoLocation.alternativeImplementationCommand': {
                type: 'string',
                default: defaults.alternativeImplementationCommand,
                description: __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('alternativeImplementationCommand', "Alternative command id that is being executed when the result of 'Go to Implementation' is the current location.")
            },
            'editor.gotoLocation.alternativeReferenceCommand': {
                type: 'string',
                default: defaults.alternativeReferenceCommand,
                description: __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('alternativeReferenceCommand', "Alternative command id that is being executed when the result of 'Go to Reference' is the current location.")
            },
        }) || this;
        return _this;
    }
    EditorGoToLocation.prototype.validate = function (_input) {
        var _a, _b, _c, _d, _e;
        if (typeof _input !== 'object') {
            return this.defaultValue;
        }
        var input = _input;
        return {
            multiple: EditorStringEnumOption.stringSet(input.multiple, this.defaultValue.multiple, ['peek', 'gotoAndPeek', 'goto']),
            multipleDefinitions: (_a = input.multipleDefinitions) !== null && _a !== void 0 ? _a : EditorStringEnumOption.stringSet(input.multipleDefinitions, 'peek', ['peek', 'gotoAndPeek', 'goto']),
            multipleTypeDefinitions: (_b = input.multipleTypeDefinitions) !== null && _b !== void 0 ? _b : EditorStringEnumOption.stringSet(input.multipleTypeDefinitions, 'peek', ['peek', 'gotoAndPeek', 'goto']),
            multipleDeclarations: (_c = input.multipleDeclarations) !== null && _c !== void 0 ? _c : EditorStringEnumOption.stringSet(input.multipleDeclarations, 'peek', ['peek', 'gotoAndPeek', 'goto']),
            multipleImplementations: (_d = input.multipleImplementations) !== null && _d !== void 0 ? _d : EditorStringEnumOption.stringSet(input.multipleImplementations, 'peek', ['peek', 'gotoAndPeek', 'goto']),
            multipleReferences: (_e = input.multipleReferences) !== null && _e !== void 0 ? _e : EditorStringEnumOption.stringSet(input.multipleReferences, 'peek', ['peek', 'gotoAndPeek', 'goto']),
            alternativeDefinitionCommand: EditorStringOption.string(input.alternativeDefinitionCommand, this.defaultValue.alternativeDefinitionCommand),
            alternativeTypeDefinitionCommand: EditorStringOption.string(input.alternativeTypeDefinitionCommand, this.defaultValue.alternativeTypeDefinitionCommand),
            alternativeDeclarationCommand: EditorStringOption.string(input.alternativeDeclarationCommand, this.defaultValue.alternativeDeclarationCommand),
            alternativeImplementationCommand: EditorStringOption.string(input.alternativeImplementationCommand, this.defaultValue.alternativeImplementationCommand),
            alternativeReferenceCommand: EditorStringOption.string(input.alternativeReferenceCommand, this.defaultValue.alternativeReferenceCommand),
        };
    };
    return EditorGoToLocation;
}(BaseEditorOption));
var EditorHover = /** @class */ (function (_super) {
    __extends(EditorHover, _super);
    function EditorHover() {
        var _this = this;
        var defaults = {
            enabled: true,
            delay: 300,
            sticky: true
        };
        _this = _super.call(this, 44 /* hover */, 'hover', defaults, {
            'editor.hover.enabled': {
                type: 'boolean',
                default: defaults.enabled,
                description: __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('hover.enabled', "Controls whether the hover is shown.")
            },
            'editor.hover.delay': {
                type: 'number',
                default: defaults.delay,
                description: __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('hover.delay', "Controls the delay in milliseconds after which the hover is shown.")
            },
            'editor.hover.sticky': {
                type: 'boolean',
                default: defaults.sticky,
                description: __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('hover.sticky', "Controls whether the hover should remain visible when mouse is moved over it.")
            },
        }) || this;
        return _this;
    }
    EditorHover.prototype.validate = function (_input) {
        if (typeof _input !== 'object') {
            return this.defaultValue;
        }
        var input = _input;
        return {
            enabled: EditorBooleanOption.boolean(input.enabled, this.defaultValue.enabled),
            delay: EditorIntOption.clampedInt(input.delay, this.defaultValue.delay, 0, 10000),
            sticky: EditorBooleanOption.boolean(input.sticky, this.defaultValue.sticky)
        };
    };
    return EditorHover;
}(BaseEditorOption));
/**
 * @internal
 */
var EditorLayoutInfoComputer = /** @class */ (function (_super) {
    __extends(EditorLayoutInfoComputer, _super);
    function EditorLayoutInfoComputer() {
        return _super.call(this, 107 /* layoutInfo */, [40 /* glyphMargin */, 48 /* lineDecorationsWidth */, 30 /* folding */, 54 /* minimap */, 78 /* scrollbar */, 50 /* lineNumbers */]) || this;
    }
    EditorLayoutInfoComputer.prototype.compute = function (env, options, _) {
        return EditorLayoutInfoComputer.computeLayout(options, {
            outerWidth: env.outerWidth,
            outerHeight: env.outerHeight,
            lineHeight: env.fontInfo.lineHeight,
            lineNumbersDigitCount: env.lineNumbersDigitCount,
            typicalHalfwidthCharacterWidth: env.fontInfo.typicalHalfwidthCharacterWidth,
            maxDigitWidth: env.fontInfo.maxDigitWidth,
            pixelRatio: env.pixelRatio
        });
    };
    EditorLayoutInfoComputer.computeLayout = function (options, env) {
        var outerWidth = env.outerWidth | 0;
        var outerHeight = env.outerHeight | 0;
        var lineHeight = env.lineHeight | 0;
        var lineNumbersDigitCount = env.lineNumbersDigitCount | 0;
        var typicalHalfwidthCharacterWidth = env.typicalHalfwidthCharacterWidth;
        var maxDigitWidth = env.maxDigitWidth;
        var pixelRatio = env.pixelRatio;
        var showGlyphMargin = options.get(40 /* glyphMargin */);
        var showLineNumbers = (options.get(50 /* lineNumbers */).renderType !== 0 /* Off */);
        var lineNumbersMinChars = options.get(51 /* lineNumbersMinChars */) | 0;
        var minimap = options.get(54 /* minimap */);
        var minimapEnabled = minimap.enabled;
        var minimapSide = minimap.side;
        var minimapRenderCharacters = minimap.renderCharacters;
        var minimapScale = (pixelRatio >= 2 ? Math.round(minimap.scale * 2) : minimap.scale);
        var minimapMaxColumn = minimap.maxColumn | 0;
        var scrollbar = options.get(78 /* scrollbar */);
        var verticalScrollbarWidth = scrollbar.verticalScrollbarSize | 0;
        var verticalScrollbarHasArrows = scrollbar.verticalHasArrows;
        var scrollbarArrowSize = scrollbar.arrowSize | 0;
        var horizontalScrollbarHeight = scrollbar.horizontalScrollbarSize | 0;
        var rawLineDecorationsWidth = options.get(48 /* lineDecorationsWidth */);
        var folding = options.get(30 /* folding */);
        var lineDecorationsWidth;
        if (typeof rawLineDecorationsWidth === 'string' && /^\d+(\.\d+)?ch$/.test(rawLineDecorationsWidth)) {
            var multiple = parseFloat(rawLineDecorationsWidth.substr(0, rawLineDecorationsWidth.length - 2));
            lineDecorationsWidth = EditorIntOption.clampedInt(multiple * typicalHalfwidthCharacterWidth, 0, 0, 1000);
        }
        else {
            lineDecorationsWidth = EditorIntOption.clampedInt(rawLineDecorationsWidth, 0, 0, 1000);
        }
        if (folding) {
            lineDecorationsWidth += 16;
        }
        var lineNumbersWidth = 0;
        if (showLineNumbers) {
            var digitCount = Math.max(lineNumbersDigitCount, lineNumbersMinChars);
            lineNumbersWidth = Math.round(digitCount * maxDigitWidth);
        }
        var glyphMarginWidth = 0;
        if (showGlyphMargin) {
            glyphMarginWidth = lineHeight;
        }
        var glyphMarginLeft = 0;
        var lineNumbersLeft = glyphMarginLeft + glyphMarginWidth;
        var decorationsLeft = lineNumbersLeft + lineNumbersWidth;
        var contentLeft = decorationsLeft + lineDecorationsWidth;
        var remainingWidth = outerWidth - glyphMarginWidth - lineNumbersWidth - lineDecorationsWidth;
        var renderMinimap;
        var minimapLeft;
        var minimapWidth;
        var contentWidth;
        if (!minimapEnabled) {
            minimapLeft = 0;
            minimapWidth = 0;
            renderMinimap = 0 /* None */;
            contentWidth = remainingWidth;
        }
        else {
            // The minimapScale is also the pixel width of each character. Adjust
            // for the pixel ratio of the screen.
            var minimapCharWidth = minimapScale / pixelRatio;
            renderMinimap = minimapRenderCharacters ? 1 /* Text */ : 2 /* Blocks */;
            // Given:
            // (leaving 2px for the cursor to have space after the last character)
            // viewportColumn = (contentWidth - verticalScrollbarWidth - 2) / typicalHalfwidthCharacterWidth
            // minimapWidth = viewportColumn * minimapCharWidth
            // contentWidth = remainingWidth - minimapWidth
            // What are good values for contentWidth and minimapWidth ?
            // minimapWidth = ((contentWidth - verticalScrollbarWidth - 2) / typicalHalfwidthCharacterWidth) * minimapCharWidth
            // typicalHalfwidthCharacterWidth * minimapWidth = (contentWidth - verticalScrollbarWidth - 2) * minimapCharWidth
            // typicalHalfwidthCharacterWidth * minimapWidth = (remainingWidth - minimapWidth - verticalScrollbarWidth - 2) * minimapCharWidth
            // (typicalHalfwidthCharacterWidth + minimapCharWidth) * minimapWidth = (remainingWidth - verticalScrollbarWidth - 2) * minimapCharWidth
            // minimapWidth = ((remainingWidth - verticalScrollbarWidth - 2) * minimapCharWidth) / (typicalHalfwidthCharacterWidth + minimapCharWidth)
            minimapWidth = Math.max(0, Math.floor(((remainingWidth - verticalScrollbarWidth - 2) * minimapCharWidth) / (typicalHalfwidthCharacterWidth + minimapCharWidth))) + MINIMAP_GUTTER_WIDTH;
            var minimapColumns = minimapWidth / minimapCharWidth;
            if (minimapColumns > minimapMaxColumn) {
                minimapWidth = Math.floor(minimapMaxColumn * minimapCharWidth);
            }
            contentWidth = remainingWidth - minimapWidth;
            if (minimapSide === 'left') {
                minimapLeft = 0;
                glyphMarginLeft += minimapWidth;
                lineNumbersLeft += minimapWidth;
                decorationsLeft += minimapWidth;
                contentLeft += minimapWidth;
            }
            else {
                minimapLeft = outerWidth - minimapWidth - verticalScrollbarWidth;
            }
        }
        // (leaving 2px for the cursor to have space after the last character)
        var viewportColumn = Math.max(1, Math.floor((contentWidth - verticalScrollbarWidth - 2) / typicalHalfwidthCharacterWidth));
        var verticalArrowSize = (verticalScrollbarHasArrows ? scrollbarArrowSize : 0);
        return {
            width: outerWidth,
            height: outerHeight,
            glyphMarginLeft: glyphMarginLeft,
            glyphMarginWidth: glyphMarginWidth,
            lineNumbersLeft: lineNumbersLeft,
            lineNumbersWidth: lineNumbersWidth,
            decorationsLeft: decorationsLeft,
            decorationsWidth: lineDecorationsWidth,
            contentLeft: contentLeft,
            contentWidth: contentWidth,
            renderMinimap: renderMinimap,
            minimapLeft: minimapLeft,
            minimapWidth: minimapWidth,
            viewportColumn: viewportColumn,
            verticalScrollbarWidth: verticalScrollbarWidth,
            horizontalScrollbarHeight: horizontalScrollbarHeight,
            overviewRuler: {
                top: verticalArrowSize,
                width: verticalScrollbarWidth,
                height: (outerHeight - 2 * verticalArrowSize),
                right: 0
            }
        };
    };
    return EditorLayoutInfoComputer;
}(ComputedEditorOption));

var EditorLightbulb = /** @class */ (function (_super) {
    __extends(EditorLightbulb, _super);
    function EditorLightbulb() {
        var _this = this;
        var defaults = { enabled: true };
        _this = _super.call(this, 47 /* lightbulb */, 'lightbulb', defaults, {
            'editor.lightbulb.enabled': {
                type: 'boolean',
                default: defaults.enabled,
                description: __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('codeActions', "Enables the code action lightbulb in the editor.")
            },
        }) || this;
        return _this;
    }
    EditorLightbulb.prototype.validate = function (_input) {
        if (typeof _input !== 'object') {
            return this.defaultValue;
        }
        var input = _input;
        return {
            enabled: EditorBooleanOption.boolean(input.enabled, this.defaultValue.enabled)
        };
    };
    return EditorLightbulb;
}(BaseEditorOption));
//#endregion
//#region lineHeight
var EditorLineHeight = /** @class */ (function (_super) {
    __extends(EditorLineHeight, _super);
    function EditorLineHeight() {
        return _super.call(this, 49 /* lineHeight */, 'lineHeight', EDITOR_FONT_DEFAULTS.lineHeight, 0, 150, { description: __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('lineHeight', "Controls the line height. Use 0 to compute the line height from the font size.") }) || this;
    }
    EditorLineHeight.prototype.compute = function (env, options, value) {
        // The lineHeight is computed from the fontSize if it is 0.
        // Moreover, the final lineHeight respects the editor zoom level.
        // So take the result from env.fontInfo
        return env.fontInfo.lineHeight;
    };
    return EditorLineHeight;
}(EditorIntOption));
var EditorMinimap = /** @class */ (function (_super) {
    __extends(EditorMinimap, _super);
    function EditorMinimap() {
        var _this = this;
        var defaults = {
            enabled: true,
            side: 'right',
            showSlider: 'mouseover',
            renderCharacters: true,
            maxColumn: 120,
            scale: 1,
        };
        _this = _super.call(this, 54 /* minimap */, 'minimap', defaults, {
            'editor.minimap.enabled': {
                type: 'boolean',
                default: defaults.enabled,
                description: __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('minimap.enabled', "Controls whether the minimap is shown.")
            },
            'editor.minimap.side': {
                type: 'string',
                enum: ['left', 'right'],
                default: defaults.side,
                description: __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('minimap.side', "Controls the side where to render the minimap.")
            },
            'editor.minimap.showSlider': {
                type: 'string',
                enum: ['always', 'mouseover'],
                default: defaults.showSlider,
                description: __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('minimap.showSlider', "Controls when the minimap slider is shown.")
            },
            'editor.minimap.scale': {
                type: 'number',
                default: defaults.scale,
                minimum: 1,
                maximum: 3,
                description: __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('minimap.scale', "Scale of content drawn in the minimap.")
            },
            'editor.minimap.renderCharacters': {
                type: 'boolean',
                default: defaults.renderCharacters,
                description: __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('minimap.renderCharacters', "Render the actual characters on a line as opposed to color blocks.")
            },
            'editor.minimap.maxColumn': {
                type: 'number',
                default: defaults.maxColumn,
                description: __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('minimap.maxColumn', "Limit the width of the minimap to render at most a certain number of columns.")
            },
        }) || this;
        return _this;
    }
    EditorMinimap.prototype.validate = function (_input) {
        if (typeof _input !== 'object') {
            return this.defaultValue;
        }
        var input = _input;
        return {
            enabled: EditorBooleanOption.boolean(input.enabled, this.defaultValue.enabled),
            side: EditorStringEnumOption.stringSet(input.side, this.defaultValue.side, ['right', 'left']),
            showSlider: EditorStringEnumOption.stringSet(input.showSlider, this.defaultValue.showSlider, ['always', 'mouseover']),
            renderCharacters: EditorBooleanOption.boolean(input.renderCharacters, this.defaultValue.renderCharacters),
            scale: EditorIntOption.clampedInt(input.scale, 1, 1, 3),
            maxColumn: EditorIntOption.clampedInt(input.maxColumn, this.defaultValue.maxColumn, 1, 10000),
        };
    };
    return EditorMinimap;
}(BaseEditorOption));
//#endregion
//#region multiCursorModifier
function _multiCursorModifierFromString(multiCursorModifier) {
    if (multiCursorModifier === 'ctrlCmd') {
        return (__WEBPACK_IMPORTED_MODULE_1__base_common_platform_js__["e" /* isMacintosh */] ? 'metaKey' : 'ctrlKey');
    }
    return 'altKey';
}
var EditorParameterHints = /** @class */ (function (_super) {
    __extends(EditorParameterHints, _super);
    function EditorParameterHints() {
        var _this = this;
        var defaults = {
            enabled: true,
            cycle: false
        };
        _this = _super.call(this, 64 /* parameterHints */, 'parameterHints', defaults, {
            'editor.parameterHints.enabled': {
                type: 'boolean',
                default: defaults.enabled,
                description: __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('parameterHints.enabled', "Enables a pop-up that shows parameter documentation and type information as you type.")
            },
            'editor.parameterHints.cycle': {
                type: 'boolean',
                default: defaults.cycle,
                description: __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('parameterHints.cycle', "Controls whether the parameter hints menu cycles or closes when reaching the end of the list.")
            },
        }) || this;
        return _this;
    }
    EditorParameterHints.prototype.validate = function (_input) {
        if (typeof _input !== 'object') {
            return this.defaultValue;
        }
        var input = _input;
        return {
            enabled: EditorBooleanOption.boolean(input.enabled, this.defaultValue.enabled),
            cycle: EditorBooleanOption.boolean(input.cycle, this.defaultValue.cycle)
        };
    };
    return EditorParameterHints;
}(BaseEditorOption));
//#endregion
//#region pixelRatio
var EditorPixelRatio = /** @class */ (function (_super) {
    __extends(EditorPixelRatio, _super);
    function EditorPixelRatio() {
        return _super.call(this, 105 /* pixelRatio */) || this;
    }
    EditorPixelRatio.prototype.compute = function (env, options, _) {
        return env.pixelRatio;
    };
    return EditorPixelRatio;
}(ComputedEditorOption));
var EditorQuickSuggestions = /** @class */ (function (_super) {
    __extends(EditorQuickSuggestions, _super);
    function EditorQuickSuggestions() {
        var _this = this;
        var defaults = {
            other: true,
            comments: false,
            strings: false
        };
        _this = _super.call(this, 66 /* quickSuggestions */, 'quickSuggestions', defaults, {
            anyOf: [
                {
                    type: 'boolean',
                },
                {
                    type: 'object',
                    properties: {
                        strings: {
                            type: 'boolean',
                            default: defaults.strings,
                            description: __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('quickSuggestions.strings', "Enable quick suggestions inside strings.")
                        },
                        comments: {
                            type: 'boolean',
                            default: defaults.comments,
                            description: __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('quickSuggestions.comments', "Enable quick suggestions inside comments.")
                        },
                        other: {
                            type: 'boolean',
                            default: defaults.other,
                            description: __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('quickSuggestions.other', "Enable quick suggestions outside of strings and comments.")
                        },
                    }
                }
            ],
            default: defaults,
            description: __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('quickSuggestions', "Controls whether suggestions should automatically show up while typing.")
        }) || this;
        _this.defaultValue = defaults;
        return _this;
    }
    EditorQuickSuggestions.prototype.validate = function (_input) {
        if (typeof _input === 'boolean') {
            return _input;
        }
        if (typeof _input === 'object') {
            var input = _input;
            var opts = {
                other: EditorBooleanOption.boolean(input.other, this.defaultValue.other),
                comments: EditorBooleanOption.boolean(input.comments, this.defaultValue.comments),
                strings: EditorBooleanOption.boolean(input.strings, this.defaultValue.strings),
            };
            if (opts.other && opts.comments && opts.strings) {
                return true; // all on
            }
            else if (!opts.other && !opts.comments && !opts.strings) {
                return false; // all off
            }
            else {
                return opts;
            }
        }
        return this.defaultValue;
    };
    return EditorQuickSuggestions;
}(BaseEditorOption));
var EditorRenderLineNumbersOption = /** @class */ (function (_super) {
    __extends(EditorRenderLineNumbersOption, _super);
    function EditorRenderLineNumbersOption() {
        return _super.call(this, 50 /* lineNumbers */, 'lineNumbers', { renderType: 1 /* On */, renderFn: null }, {
            type: 'string',
            enum: ['off', 'on', 'relative', 'interval'],
            enumDescriptions: [
                __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('lineNumbers.off', "Line numbers are not rendered."),
                __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('lineNumbers.on', "Line numbers are rendered as absolute number."),
                __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('lineNumbers.relative', "Line numbers are rendered as distance in lines to cursor position."),
                __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('lineNumbers.interval', "Line numbers are rendered every 10 lines.")
            ],
            default: 'on',
            description: __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('lineNumbers', "Controls the display of line numbers.")
        }) || this;
    }
    EditorRenderLineNumbersOption.prototype.validate = function (lineNumbers) {
        var renderType = this.defaultValue.renderType;
        var renderFn = this.defaultValue.renderFn;
        if (typeof lineNumbers !== 'undefined') {
            if (typeof lineNumbers === 'function') {
                renderType = 4 /* Custom */;
                renderFn = lineNumbers;
            }
            else if (lineNumbers === 'interval') {
                renderType = 3 /* Interval */;
            }
            else if (lineNumbers === 'relative') {
                renderType = 2 /* Relative */;
            }
            else if (lineNumbers === 'on') {
                renderType = 1 /* On */;
            }
            else {
                renderType = 0 /* Off */;
            }
        }
        return {
            renderType: renderType,
            renderFn: renderFn
        };
    };
    return EditorRenderLineNumbersOption;
}(BaseEditorOption));
//#endregion
//#region renderValidationDecorations
/**
 * @internal
 */
function filterValidationDecorations(options) {
    var renderValidationDecorations = options.get(73 /* renderValidationDecorations */);
    if (renderValidationDecorations === 'editable') {
        return options.get(68 /* readOnly */);
    }
    return renderValidationDecorations === 'on' ? false : true;
}
//#endregion
//#region rulers
var EditorRulers = /** @class */ (function (_super) {
    __extends(EditorRulers, _super);
    function EditorRulers() {
        var _this = this;
        var defaults = [];
        _this = _super.call(this, 77 /* rulers */, 'rulers', defaults, {
            type: 'array',
            items: {
                type: 'number'
            },
            default: defaults,
            description: __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('rulers', "Render vertical rulers after a certain number of monospace characters. Use multiple values for multiple rulers. No rulers are drawn if array is empty.")
        }) || this;
        return _this;
    }
    EditorRulers.prototype.validate = function (input) {
        if (Array.isArray(input)) {
            var rulers = [];
            for (var _i = 0, input_1 = input; _i < input_1.length; _i++) {
                var value = input_1[_i];
                rulers.push(EditorIntOption.clampedInt(value, 0, 0, 10000));
            }
            rulers.sort(function (a, b) { return a - b; });
            return rulers;
        }
        return this.defaultValue;
    };
    return EditorRulers;
}(SimpleEditorOption));
function _scrollbarVisibilityFromString(visibility, defaultValue) {
    if (typeof visibility !== 'string') {
        return defaultValue;
    }
    switch (visibility) {
        case 'hidden': return 2 /* Hidden */;
        case 'visible': return 3 /* Visible */;
        default: return 1 /* Auto */;
    }
}
var EditorScrollbar = /** @class */ (function (_super) {
    __extends(EditorScrollbar, _super);
    function EditorScrollbar() {
        return _super.call(this, 78 /* scrollbar */, 'scrollbar', {
            vertical: 1 /* Auto */,
            horizontal: 1 /* Auto */,
            arrowSize: 11,
            useShadows: true,
            verticalHasArrows: false,
            horizontalHasArrows: false,
            horizontalScrollbarSize: 10,
            horizontalSliderSize: 10,
            verticalScrollbarSize: 14,
            verticalSliderSize: 14,
            handleMouseWheel: true,
            alwaysConsumeMouseWheel: true
        }) || this;
    }
    EditorScrollbar.prototype.validate = function (_input) {
        if (typeof _input !== 'object') {
            return this.defaultValue;
        }
        var input = _input;
        var horizontalScrollbarSize = EditorIntOption.clampedInt(input.horizontalScrollbarSize, this.defaultValue.horizontalScrollbarSize, 0, 1000);
        var verticalScrollbarSize = EditorIntOption.clampedInt(input.verticalScrollbarSize, this.defaultValue.verticalScrollbarSize, 0, 1000);
        return {
            arrowSize: EditorIntOption.clampedInt(input.arrowSize, this.defaultValue.arrowSize, 0, 1000),
            vertical: _scrollbarVisibilityFromString(input.vertical, this.defaultValue.vertical),
            horizontal: _scrollbarVisibilityFromString(input.horizontal, this.defaultValue.horizontal),
            useShadows: EditorBooleanOption.boolean(input.useShadows, this.defaultValue.useShadows),
            verticalHasArrows: EditorBooleanOption.boolean(input.verticalHasArrows, this.defaultValue.verticalHasArrows),
            horizontalHasArrows: EditorBooleanOption.boolean(input.horizontalHasArrows, this.defaultValue.horizontalHasArrows),
            handleMouseWheel: EditorBooleanOption.boolean(input.handleMouseWheel, this.defaultValue.handleMouseWheel),
            alwaysConsumeMouseWheel: EditorBooleanOption.boolean(input.alwaysConsumeMouseWheel, this.defaultValue.alwaysConsumeMouseWheel),
            horizontalScrollbarSize: horizontalScrollbarSize,
            horizontalSliderSize: EditorIntOption.clampedInt(input.horizontalSliderSize, horizontalScrollbarSize, 0, 1000),
            verticalScrollbarSize: verticalScrollbarSize,
            verticalSliderSize: EditorIntOption.clampedInt(input.verticalSliderSize, verticalScrollbarSize, 0, 1000),
        };
    };
    return EditorScrollbar;
}(BaseEditorOption));
var EditorSuggest = /** @class */ (function (_super) {
    __extends(EditorSuggest, _super);
    function EditorSuggest() {
        var _this = this;
        var defaults = {
            insertMode: 'insert',
            insertHighlight: false,
            filterGraceful: true,
            snippetsPreventQuickSuggestions: true,
            localityBonus: false,
            shareSuggestSelections: false,
            showIcons: true,
            maxVisibleSuggestions: 12,
            showMethods: true,
            showFunctions: true,
            showConstructors: true,
            showFields: true,
            showVariables: true,
            showClasses: true,
            showStructs: true,
            showInterfaces: true,
            showModules: true,
            showProperties: true,
            showEvents: true,
            showOperators: true,
            showUnits: true,
            showValues: true,
            showConstants: true,
            showEnums: true,
            showEnumMembers: true,
            showKeywords: true,
            showWords: true,
            showColors: true,
            showFiles: true,
            showReferences: true,
            showFolders: true,
            showTypeParameters: true,
            showSnippets: true,
            hideStatusBar: true
        };
        _this = _super.call(this, 89 /* suggest */, 'suggest', defaults, {
            'editor.suggest.insertMode': {
                type: 'string',
                enum: ['insert', 'replace'],
                enumDescriptions: [
                    __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('suggest.insertMode.insert', "Insert suggestion without overwriting text right of the cursor."),
                    __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('suggest.insertMode.replace', "Insert suggestion and overwrite text right of the cursor."),
                ],
                default: defaults.insertMode,
                description: __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('suggest.insertMode', "Controls whether words are overwritten when accepting completions. Note that this depends on extensions opting into this feature.")
            },
            'editor.suggest.insertHighlight': {
                type: 'boolean',
                default: defaults.insertHighlight,
                description: __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('suggest.insertHighlight', "Controls whether unexpected text modifications while accepting completions should be highlighted, e.g `insertMode` is `replace` but the completion only supports `insert`.")
            },
            'editor.suggest.filterGraceful': {
                type: 'boolean',
                default: defaults.filterGraceful,
                description: __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('suggest.filterGraceful', "Controls whether filtering and sorting suggestions accounts for small typos.")
            },
            'editor.suggest.localityBonus': {
                type: 'boolean',
                default: defaults.localityBonus,
                description: __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('suggest.localityBonus', "Controls whether sorting favours words that appear close to the cursor.")
            },
            'editor.suggest.shareSuggestSelections': {
                type: 'boolean',
                default: defaults.shareSuggestSelections,
                markdownDescription: __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('suggest.shareSuggestSelections', "Controls whether remembered suggestion selections are shared between multiple workspaces and windows (needs `#editor.suggestSelection#`).")
            },
            'editor.suggest.snippetsPreventQuickSuggestions': {
                type: 'boolean',
                default: defaults.snippetsPreventQuickSuggestions,
                description: __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('suggest.snippetsPreventQuickSuggestions', "Controls whether an active snippet prevents quick suggestions.")
            },
            'editor.suggest.showIcons': {
                type: 'boolean',
                default: defaults.showIcons,
                description: __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('suggest.showIcons', "Controls whether to show or hide icons in suggestions.")
            },
            'editor.suggest.maxVisibleSuggestions': {
                type: 'number',
                default: defaults.maxVisibleSuggestions,
                minimum: 1,
                maximum: 15,
                description: __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('suggest.maxVisibleSuggestions', "Controls how many suggestions IntelliSense will show before showing a scrollbar (maximum 15).")
            },
            'editor.suggest.filteredTypes': {
                type: 'object',
                deprecationMessage: __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('deprecated', "This setting is deprecated, please use separate settings like 'editor.suggest.showKeywords' or 'editor.suggest.showSnippets' instead.")
            },
            'editor.suggest.showMethods': {
                type: 'boolean',
                default: true,
                markdownDescription: __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('editor.suggest.showMethods', "When enabled IntelliSense shows `method`-suggestions.")
            },
            'editor.suggest.showFunctions': {
                type: 'boolean',
                default: true,
                markdownDescription: __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('editor.suggest.showFunctions', "When enabled IntelliSense shows `function`-suggestions.")
            },
            'editor.suggest.showConstructors': {
                type: 'boolean',
                default: true,
                markdownDescription: __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('editor.suggest.showConstructors', "When enabled IntelliSense shows `constructor`-suggestions.")
            },
            'editor.suggest.showFields': {
                type: 'boolean',
                default: true,
                markdownDescription: __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('editor.suggest.showFields', "When enabled IntelliSense shows `field`-suggestions.")
            },
            'editor.suggest.showVariables': {
                type: 'boolean',
                default: true,
                markdownDescription: __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('editor.suggest.showVariables', "When enabled IntelliSense shows `variable`-suggestions.")
            },
            'editor.suggest.showClasses': {
                type: 'boolean',
                default: true,
                markdownDescription: __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('editor.suggest.showClasss', "When enabled IntelliSense shows `class`-suggestions.")
            },
            'editor.suggest.showStructs': {
                type: 'boolean',
                default: true,
                markdownDescription: __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('editor.suggest.showStructs', "When enabled IntelliSense shows `struct`-suggestions.")
            },
            'editor.suggest.showInterfaces': {
                type: 'boolean',
                default: true,
                markdownDescription: __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('editor.suggest.showInterfaces', "When enabled IntelliSense shows `interface`-suggestions.")
            },
            'editor.suggest.showModules': {
                type: 'boolean',
                default: true,
                markdownDescription: __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('editor.suggest.showModules', "When enabled IntelliSense shows `module`-suggestions.")
            },
            'editor.suggest.showProperties': {
                type: 'boolean',
                default: true,
                markdownDescription: __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('editor.suggest.showPropertys', "When enabled IntelliSense shows `property`-suggestions.")
            },
            'editor.suggest.showEvents': {
                type: 'boolean',
                default: true,
                markdownDescription: __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('editor.suggest.showEvents', "When enabled IntelliSense shows `event`-suggestions.")
            },
            'editor.suggest.showOperators': {
                type: 'boolean',
                default: true,
                markdownDescription: __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('editor.suggest.showOperators', "When enabled IntelliSense shows `operator`-suggestions.")
            },
            'editor.suggest.showUnits': {
                type: 'boolean',
                default: true,
                markdownDescription: __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('editor.suggest.showUnits', "When enabled IntelliSense shows `unit`-suggestions.")
            },
            'editor.suggest.showValues': {
                type: 'boolean',
                default: true,
                markdownDescription: __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('editor.suggest.showValues', "When enabled IntelliSense shows `value`-suggestions.")
            },
            'editor.suggest.showConstants': {
                type: 'boolean',
                default: true,
                markdownDescription: __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('editor.suggest.showConstants', "When enabled IntelliSense shows `constant`-suggestions.")
            },
            'editor.suggest.showEnums': {
                type: 'boolean',
                default: true,
                markdownDescription: __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('editor.suggest.showEnums', "When enabled IntelliSense shows `enum`-suggestions.")
            },
            'editor.suggest.showEnumMembers': {
                type: 'boolean',
                default: true,
                markdownDescription: __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('editor.suggest.showEnumMembers', "When enabled IntelliSense shows `enumMember`-suggestions.")
            },
            'editor.suggest.showKeywords': {
                type: 'boolean',
                default: true,
                markdownDescription: __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('editor.suggest.showKeywords', "When enabled IntelliSense shows `keyword`-suggestions.")
            },
            'editor.suggest.showWords': {
                type: 'boolean',
                default: true,
                markdownDescription: __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('editor.suggest.showTexts', "When enabled IntelliSense shows `text`-suggestions.")
            },
            'editor.suggest.showColors': {
                type: 'boolean',
                default: true,
                markdownDescription: __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('editor.suggest.showColors', "When enabled IntelliSense shows `color`-suggestions.")
            },
            'editor.suggest.showFiles': {
                type: 'boolean',
                default: true,
                markdownDescription: __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('editor.suggest.showFiles', "When enabled IntelliSense shows `file`-suggestions.")
            },
            'editor.suggest.showReferences': {
                type: 'boolean',
                default: true,
                markdownDescription: __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('editor.suggest.showReferences', "When enabled IntelliSense shows `reference`-suggestions.")
            },
            'editor.suggest.showCustomcolors': {
                type: 'boolean',
                default: true,
                markdownDescription: __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('editor.suggest.showCustomcolors', "When enabled IntelliSense shows `customcolor`-suggestions.")
            },
            'editor.suggest.showFolders': {
                type: 'boolean',
                default: true,
                markdownDescription: __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('editor.suggest.showFolders', "When enabled IntelliSense shows `folder`-suggestions.")
            },
            'editor.suggest.showTypeParameters': {
                type: 'boolean',
                default: true,
                markdownDescription: __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('editor.suggest.showTypeParameters', "When enabled IntelliSense shows `typeParameter`-suggestions.")
            },
            'editor.suggest.showSnippets': {
                type: 'boolean',
                default: true,
                markdownDescription: __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('editor.suggest.showSnippets', "When enabled IntelliSense shows `snippet`-suggestions.")
            },
            'editor.suggest.hideStatusBar': {
                type: 'boolean',
                default: true,
                markdownDescription: __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('editor.suggest.hideStatusBar', "Controls the visibility of the status bar at the bottom of the suggest widget.")
            }
        }) || this;
        return _this;
    }
    EditorSuggest.prototype.validate = function (_input) {
        if (typeof _input !== 'object') {
            return this.defaultValue;
        }
        var input = _input;
        return {
            insertMode: EditorStringEnumOption.stringSet(input.insertMode, this.defaultValue.insertMode, ['insert', 'replace']),
            insertHighlight: EditorBooleanOption.boolean(input.insertHighlight, this.defaultValue.insertHighlight),
            filterGraceful: EditorBooleanOption.boolean(input.filterGraceful, this.defaultValue.filterGraceful),
            snippetsPreventQuickSuggestions: EditorBooleanOption.boolean(input.snippetsPreventQuickSuggestions, this.defaultValue.filterGraceful),
            localityBonus: EditorBooleanOption.boolean(input.localityBonus, this.defaultValue.localityBonus),
            shareSuggestSelections: EditorBooleanOption.boolean(input.shareSuggestSelections, this.defaultValue.shareSuggestSelections),
            showIcons: EditorBooleanOption.boolean(input.showIcons, this.defaultValue.showIcons),
            maxVisibleSuggestions: EditorIntOption.clampedInt(input.maxVisibleSuggestions, this.defaultValue.maxVisibleSuggestions, 1, 15),
            showMethods: EditorBooleanOption.boolean(input.showMethods, this.defaultValue.showMethods),
            showFunctions: EditorBooleanOption.boolean(input.showFunctions, this.defaultValue.showFunctions),
            showConstructors: EditorBooleanOption.boolean(input.showConstructors, this.defaultValue.showConstructors),
            showFields: EditorBooleanOption.boolean(input.showFields, this.defaultValue.showFields),
            showVariables: EditorBooleanOption.boolean(input.showVariables, this.defaultValue.showVariables),
            showClasses: EditorBooleanOption.boolean(input.showClasses, this.defaultValue.showClasses),
            showStructs: EditorBooleanOption.boolean(input.showStructs, this.defaultValue.showStructs),
            showInterfaces: EditorBooleanOption.boolean(input.showInterfaces, this.defaultValue.showInterfaces),
            showModules: EditorBooleanOption.boolean(input.showModules, this.defaultValue.showModules),
            showProperties: EditorBooleanOption.boolean(input.showProperties, this.defaultValue.showProperties),
            showEvents: EditorBooleanOption.boolean(input.showEvents, this.defaultValue.showEvents),
            showOperators: EditorBooleanOption.boolean(input.showOperators, this.defaultValue.showOperators),
            showUnits: EditorBooleanOption.boolean(input.showUnits, this.defaultValue.showUnits),
            showValues: EditorBooleanOption.boolean(input.showValues, this.defaultValue.showValues),
            showConstants: EditorBooleanOption.boolean(input.showConstants, this.defaultValue.showConstants),
            showEnums: EditorBooleanOption.boolean(input.showEnums, this.defaultValue.showEnums),
            showEnumMembers: EditorBooleanOption.boolean(input.showEnumMembers, this.defaultValue.showEnumMembers),
            showKeywords: EditorBooleanOption.boolean(input.showKeywords, this.defaultValue.showKeywords),
            showWords: EditorBooleanOption.boolean(input.showWords, this.defaultValue.showWords),
            showColors: EditorBooleanOption.boolean(input.showColors, this.defaultValue.showColors),
            showFiles: EditorBooleanOption.boolean(input.showFiles, this.defaultValue.showFiles),
            showReferences: EditorBooleanOption.boolean(input.showReferences, this.defaultValue.showReferences),
            showFolders: EditorBooleanOption.boolean(input.showFolders, this.defaultValue.showFolders),
            showTypeParameters: EditorBooleanOption.boolean(input.showTypeParameters, this.defaultValue.showTypeParameters),
            showSnippets: EditorBooleanOption.boolean(input.showSnippets, this.defaultValue.showSnippets),
            hideStatusBar: EditorBooleanOption.boolean(input.hideStatusBar, this.defaultValue.hideStatusBar),
        };
    };
    return EditorSuggest;
}(BaseEditorOption));
//#endregion
//#region tabFocusMode
var EditorTabFocusMode = /** @class */ (function (_super) {
    __extends(EditorTabFocusMode, _super);
    function EditorTabFocusMode() {
        return _super.call(this, 106 /* tabFocusMode */, [68 /* readOnly */]) || this;
    }
    EditorTabFocusMode.prototype.compute = function (env, options, _) {
        var readOnly = options.get(68 /* readOnly */);
        return (readOnly ? true : env.tabFocusMode);
    };
    return EditorTabFocusMode;
}(ComputedEditorOption));
function _wrappingIndentFromString(wrappingIndent) {
    switch (wrappingIndent) {
        case 'none': return 0 /* None */;
        case 'same': return 1 /* Same */;
        case 'indent': return 2 /* Indent */;
        case 'deepIndent': return 3 /* DeepIndent */;
    }
}
var EditorWrappingInfoComputer = /** @class */ (function (_super) {
    __extends(EditorWrappingInfoComputer, _super);
    function EditorWrappingInfoComputer() {
        return _super.call(this, 108 /* wrappingInfo */, [97 /* wordWrap */, 100 /* wordWrapColumn */, 101 /* wordWrapMinified */, 107 /* layoutInfo */, 2 /* accessibilitySupport */]) || this;
    }
    EditorWrappingInfoComputer.prototype.compute = function (env, options, _) {
        var wordWrap = options.get(97 /* wordWrap */);
        var wordWrapColumn = options.get(100 /* wordWrapColumn */);
        var wordWrapMinified = options.get(101 /* wordWrapMinified */);
        var layoutInfo = options.get(107 /* layoutInfo */);
        var accessibilitySupport = options.get(2 /* accessibilitySupport */);
        var bareWrappingInfo = null;
        {
            if (accessibilitySupport === 2 /* Enabled */) {
                // See https://github.com/Microsoft/vscode/issues/27766
                // Never enable wrapping when a screen reader is attached
                // because arrow down etc. will not move the cursor in the way
                // a screen reader expects.
                bareWrappingInfo = {
                    isWordWrapMinified: false,
                    isViewportWrapping: false,
                    wrappingColumn: -1
                };
            }
            else if (wordWrapMinified && env.isDominatedByLongLines) {
                // Force viewport width wrapping if model is dominated by long lines
                bareWrappingInfo = {
                    isWordWrapMinified: true,
                    isViewportWrapping: true,
                    wrappingColumn: Math.max(1, layoutInfo.viewportColumn)
                };
            }
            else if (wordWrap === 'on') {
                bareWrappingInfo = {
                    isWordWrapMinified: false,
                    isViewportWrapping: true,
                    wrappingColumn: Math.max(1, layoutInfo.viewportColumn)
                };
            }
            else if (wordWrap === 'bounded') {
                bareWrappingInfo = {
                    isWordWrapMinified: false,
                    isViewportWrapping: true,
                    wrappingColumn: Math.min(Math.max(1, layoutInfo.viewportColumn), wordWrapColumn)
                };
            }
            else if (wordWrap === 'wordWrapColumn') {
                bareWrappingInfo = {
                    isWordWrapMinified: false,
                    isViewportWrapping: false,
                    wrappingColumn: wordWrapColumn
                };
            }
            else {
                bareWrappingInfo = {
                    isWordWrapMinified: false,
                    isViewportWrapping: false,
                    wrappingColumn: -1
                };
            }
        }
        return {
            isDominatedByLongLines: env.isDominatedByLongLines,
            isWordWrapMinified: bareWrappingInfo.isWordWrapMinified,
            isViewportWrapping: bareWrappingInfo.isViewportWrapping,
            wrappingColumn: bareWrappingInfo.wrappingColumn,
        };
    };
    return EditorWrappingInfoComputer;
}(ComputedEditorOption));
//#endregion
var DEFAULT_WINDOWS_FONT_FAMILY = 'Consolas, \'Courier New\', monospace';
var DEFAULT_MAC_FONT_FAMILY = 'Menlo, Monaco, \'Courier New\', monospace';
var DEFAULT_LINUX_FONT_FAMILY = '\'Droid Sans Mono\', \'monospace\', monospace, \'Droid Sans Fallback\'';
/**
 * @internal
 */
var EDITOR_FONT_DEFAULTS = {
    fontFamily: (__WEBPACK_IMPORTED_MODULE_1__base_common_platform_js__["e" /* isMacintosh */] ? DEFAULT_MAC_FONT_FAMILY : (__WEBPACK_IMPORTED_MODULE_1__base_common_platform_js__["d" /* isLinux */] ? DEFAULT_LINUX_FONT_FAMILY : DEFAULT_WINDOWS_FONT_FAMILY)),
    fontWeight: 'normal',
    fontSize: (__WEBPACK_IMPORTED_MODULE_1__base_common_platform_js__["e" /* isMacintosh */] ? 12 : 14),
    lineHeight: 0,
    letterSpacing: 0,
};
/**
 * @internal
 */
var EDITOR_MODEL_DEFAULTS = {
    tabSize: 4,
    indentSize: 4,
    insertSpaces: true,
    detectIndentation: true,
    trimAutoWhitespace: true,
    largeFileOptimizations: true
};
/**
 * @internal
 */
var editorOptionsRegistry = [];
function register(option) {
    editorOptionsRegistry[option.id] = option;
    return option;
}
/**
 * WORKAROUND: TS emits "any" for complex editor options values (anything except string, bool, enum, etc. ends up being "any")
 * @monacodtsreplace
 * /accessibilitySupport, any/accessibilitySupport, AccessibilitySupport/
 * /comments, any/comments, EditorCommentsOptions/
 * /find, any/find, EditorFindOptions/
 * /fontInfo, any/fontInfo, FontInfo/
 * /gotoLocation, any/gotoLocation, GoToLocationOptions/
 * /hover, any/hover, EditorHoverOptions/
 * /lightbulb, any/lightbulb, EditorLightbulbOptions/
 * /minimap, any/minimap, EditorMinimapOptions/
 * /parameterHints, any/parameterHints, InternalParameterHintOptions/
 * /quickSuggestions, any/quickSuggestions, ValidQuickSuggestionsOptions/
 * /suggest, any/suggest, InternalSuggestOptions/
 */
var EditorOptions = {
    acceptSuggestionOnCommitCharacter: register(new EditorBooleanOption(0 /* acceptSuggestionOnCommitCharacter */, 'acceptSuggestionOnCommitCharacter', true, { markdownDescription: __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('acceptSuggestionOnCommitCharacter', "Controls whether suggestions should be accepted on commit characters. For example, in JavaScript, the semi-colon (`;`) can be a commit character that accepts a suggestion and types that character.") })),
    acceptSuggestionOnEnter: register(new EditorStringEnumOption(1 /* acceptSuggestionOnEnter */, 'acceptSuggestionOnEnter', 'on', ['on', 'smart', 'off'], {
        markdownEnumDescriptions: [
            '',
            __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('acceptSuggestionOnEnterSmart', "Only accept a suggestion with `Enter` when it makes a textual change."),
            ''
        ],
        markdownDescription: __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('acceptSuggestionOnEnter', "Controls whether suggestions should be accepted on `Enter`, in addition to `Tab`. Helps to avoid ambiguity between inserting new lines or accepting suggestions.")
    })),
    accessibilitySupport: register(new EditorAccessibilitySupport()),
    accessibilityPageSize: register(new EditorIntOption(3 /* accessibilityPageSize */, 'accessibilityPageSize', 10, 1, 1073741824 /* MAX_SAFE_SMALL_INTEGER */, { description: __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('accessibilityPageSize', "Controls the number of lines in the editor that can be read out by a screen reader. Warning: this has a performance implication for numbers larger than the default.") })),
    ariaLabel: register(new EditorStringOption(4 /* ariaLabel */, 'ariaLabel', __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('editorViewAccessibleLabel', "Editor content"))),
    autoClosingBrackets: register(new EditorStringEnumOption(5 /* autoClosingBrackets */, 'autoClosingBrackets', 'languageDefined', ['always', 'languageDefined', 'beforeWhitespace', 'never'], {
        enumDescriptions: [
            '',
            __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('editor.autoClosingBrackets.languageDefined', "Use language configurations to determine when to autoclose brackets."),
            __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('editor.autoClosingBrackets.beforeWhitespace', "Autoclose brackets only when the cursor is to the left of whitespace."),
            '',
        ],
        description: __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('autoClosingBrackets', "Controls whether the editor should automatically close brackets after the user adds an opening bracket.")
    })),
    autoClosingOvertype: register(new EditorStringEnumOption(6 /* autoClosingOvertype */, 'autoClosingOvertype', 'auto', ['always', 'auto', 'never'], {
        enumDescriptions: [
            '',
            __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('editor.autoClosingOvertype.auto', "Type over closing quotes or brackets only if they were automatically inserted."),
            '',
        ],
        description: __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('autoClosingOvertype', "Controls whether the editor should type over closing quotes or brackets.")
    })),
    autoClosingQuotes: register(new EditorStringEnumOption(7 /* autoClosingQuotes */, 'autoClosingQuotes', 'languageDefined', ['always', 'languageDefined', 'beforeWhitespace', 'never'], {
        enumDescriptions: [
            '',
            __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('editor.autoClosingQuotes.languageDefined', "Use language configurations to determine when to autoclose quotes."),
            __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('editor.autoClosingQuotes.beforeWhitespace', "Autoclose quotes only when the cursor is to the left of whitespace."),
            '',
        ],
        description: __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('autoClosingQuotes', "Controls whether the editor should automatically close quotes after the user adds an opening quote.")
    })),
    autoIndent: register(new EditorEnumOption(8 /* autoIndent */, 'autoIndent', 4 /* Full */, 'full', ['none', 'keep', 'brackets', 'advanced', 'full'], _autoIndentFromString, {
        enumDescriptions: [
            __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('editor.autoIndent.none', "The editor will not insert indentation automatically."),
            __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('editor.autoIndent.keep', "The editor will keep the current line's indentation."),
            __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('editor.autoIndent.brackets', "The editor will keep the current line's indentation and honor language defined brackets."),
            __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('editor.autoIndent.advanced', "The editor will keep the current line's indentation, honor language defined brackets and invoke special onEnterRules defined by languages."),
            __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('editor.autoIndent.full', "The editor will keep the current line's indentation, honor language defined brackets, invoke special onEnterRules defined by languages, and honor indentationRules defined by languages."),
        ],
        description: __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('autoIndent', "Controls whether the editor should automatically adjust the indentation when users type, paste, move or indent lines.")
    })),
    automaticLayout: register(new EditorBooleanOption(9 /* automaticLayout */, 'automaticLayout', false)),
    autoSurround: register(new EditorStringEnumOption(10 /* autoSurround */, 'autoSurround', 'languageDefined', ['languageDefined', 'quotes', 'brackets', 'never'], {
        enumDescriptions: [
            __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('editor.autoSurround.languageDefined', "Use language configurations to determine when to automatically surround selections."),
            __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('editor.autoSurround.quotes', "Surround with quotes but not brackets."),
            __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('editor.autoSurround.brackets', "Surround with brackets but not quotes."),
            ''
        ],
        description: __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('autoSurround', "Controls whether the editor should automatically surround selections.")
    })),
    codeLens: register(new EditorBooleanOption(11 /* codeLens */, 'codeLens', true, { description: __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('codeLens', "Controls whether the editor shows CodeLens.") })),
    colorDecorators: register(new EditorBooleanOption(12 /* colorDecorators */, 'colorDecorators', true, { description: __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('colorDecorators', "Controls whether the editor should render the inline color decorators and color picker.") })),
    comments: register(new EditorComments()),
    contextmenu: register(new EditorBooleanOption(14 /* contextmenu */, 'contextmenu', true)),
    copyWithSyntaxHighlighting: register(new EditorBooleanOption(15 /* copyWithSyntaxHighlighting */, 'copyWithSyntaxHighlighting', true, { description: __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('copyWithSyntaxHighlighting', "Controls whether syntax highlighting should be copied into the clipboard.") })),
    cursorBlinking: register(new EditorEnumOption(16 /* cursorBlinking */, 'cursorBlinking', 1 /* Blink */, 'blink', ['blink', 'smooth', 'phase', 'expand', 'solid'], _cursorBlinkingStyleFromString, { description: __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('cursorBlinking', "Control the cursor animation style.") })),
    cursorSmoothCaretAnimation: register(new EditorBooleanOption(17 /* cursorSmoothCaretAnimation */, 'cursorSmoothCaretAnimation', false, { description: __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('cursorSmoothCaretAnimation', "Controls whether the smooth caret animation should be enabled.") })),
    cursorStyle: register(new EditorEnumOption(18 /* cursorStyle */, 'cursorStyle', TextEditorCursorStyle.Line, 'line', ['line', 'block', 'underline', 'line-thin', 'block-outline', 'underline-thin'], _cursorStyleFromString, { description: __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('cursorStyle', "Controls the cursor style.") })),
    cursorSurroundingLines: register(new EditorIntOption(19 /* cursorSurroundingLines */, 'cursorSurroundingLines', 0, 0, 1073741824 /* MAX_SAFE_SMALL_INTEGER */, { description: __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('cursorSurroundingLines', "Controls the minimal number of visible leading and trailing lines surrounding the cursor. Known as 'scrollOff' or `scrollOffset` in some other editors.") })),
    cursorSurroundingLinesStyle: register(new EditorStringEnumOption(20 /* cursorSurroundingLinesStyle */, 'cursorSurroundingLinesStyle', 'default', ['default', 'all'], {
        enumDescriptions: [
            __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('cursorSurroundingLinesStyle.default', "`cursorSurroundingLines` is enforced only when triggered via the keyboard or API."),
            __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('cursorSurroundingLinesStyle.all', "`cursorSurroundingLines` is enforced always.")
        ],
        description: __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('cursorSurroundingLinesStyle', "Controls when `cursorSurroundingLines` should be enforced.")
    })),
    cursorWidth: register(new EditorIntOption(21 /* cursorWidth */, 'cursorWidth', 0, 0, 1073741824 /* MAX_SAFE_SMALL_INTEGER */, { markdownDescription: __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('cursorWidth', "Controls the width of the cursor when `#editor.cursorStyle#` is set to `line`.") })),
    disableLayerHinting: register(new EditorBooleanOption(22 /* disableLayerHinting */, 'disableLayerHinting', false)),
    disableMonospaceOptimizations: register(new EditorBooleanOption(23 /* disableMonospaceOptimizations */, 'disableMonospaceOptimizations', false)),
    dragAndDrop: register(new EditorBooleanOption(24 /* dragAndDrop */, 'dragAndDrop', true, { description: __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('dragAndDrop', "Controls whether the editor should allow moving selections via drag and drop.") })),
    emptySelectionClipboard: register(new EditorEmptySelectionClipboard()),
    extraEditorClassName: register(new EditorStringOption(26 /* extraEditorClassName */, 'extraEditorClassName', '')),
    fastScrollSensitivity: register(new EditorFloatOption(27 /* fastScrollSensitivity */, 'fastScrollSensitivity', 5, function (x) { return (x <= 0 ? 5 : x); }, { markdownDescription: __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('fastScrollSensitivity', "Scrolling speed multiplier when pressing `Alt`.") })),
    find: register(new EditorFind()),
    fixedOverflowWidgets: register(new EditorBooleanOption(29 /* fixedOverflowWidgets */, 'fixedOverflowWidgets', false)),
    folding: register(new EditorBooleanOption(30 /* folding */, 'folding', true, { description: __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('folding', "Controls whether the editor has code folding enabled.") })),
    foldingStrategy: register(new EditorStringEnumOption(31 /* foldingStrategy */, 'foldingStrategy', 'auto', ['auto', 'indentation'], { markdownDescription: __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('foldingStrategy', "Controls the strategy for computing folding ranges. `auto` uses a language specific folding strategy, if available. `indentation` uses the indentation based folding strategy.") })),
    foldingHighlight: register(new EditorBooleanOption(32 /* foldingHighlight */, 'foldingHighlight', true, { description: __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('foldingHighlight', "Controls whether the editor should highlight folded ranges.") })),
    fontFamily: register(new EditorStringOption(33 /* fontFamily */, 'fontFamily', EDITOR_FONT_DEFAULTS.fontFamily, { description: __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('fontFamily', "Controls the font family.") })),
    fontInfo: register(new EditorFontInfo()),
    fontLigatures2: register(new EditorFontLigatures()),
    fontSize: register(new EditorFontSize()),
    fontWeight: register(new EditorStringOption(37 /* fontWeight */, 'fontWeight', EDITOR_FONT_DEFAULTS.fontWeight, {
        enum: ['normal', 'bold', '100', '200', '300', '400', '500', '600', '700', '800', '900'],
        description: __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('fontWeight', "Controls the font weight.")
    })),
    formatOnPaste: register(new EditorBooleanOption(38 /* formatOnPaste */, 'formatOnPaste', false, { description: __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('formatOnPaste', "Controls whether the editor should automatically format the pasted content. A formatter must be available and the formatter should be able to format a range in a document.") })),
    formatOnType: register(new EditorBooleanOption(39 /* formatOnType */, 'formatOnType', false, { description: __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('formatOnType', "Controls whether the editor should automatically format the line after typing.") })),
    glyphMargin: register(new EditorBooleanOption(40 /* glyphMargin */, 'glyphMargin', true, { description: __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('glyphMargin', "Controls whether the editor should render the vertical glyph margin. Glyph margin is mostly used for debugging.") })),
    gotoLocation: register(new EditorGoToLocation()),
    hideCursorInOverviewRuler: register(new EditorBooleanOption(42 /* hideCursorInOverviewRuler */, 'hideCursorInOverviewRuler', false, { description: __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('hideCursorInOverviewRuler', "Controls whether the cursor should be hidden in the overview ruler.") })),
    highlightActiveIndentGuide: register(new EditorBooleanOption(43 /* highlightActiveIndentGuide */, 'highlightActiveIndentGuide', true, { description: __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('highlightActiveIndentGuide', "Controls whether the editor should highlight the active indent guide.") })),
    hover: register(new EditorHover()),
    inDiffEditor: register(new EditorBooleanOption(45 /* inDiffEditor */, 'inDiffEditor', false)),
    letterSpacing: register(new EditorFloatOption(46 /* letterSpacing */, 'letterSpacing', EDITOR_FONT_DEFAULTS.letterSpacing, function (x) { return EditorFloatOption.clamp(x, -5, 20); }, { description: __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('letterSpacing', "Controls the letter spacing in pixels.") })),
    lightbulb: register(new EditorLightbulb()),
    lineDecorationsWidth: register(new SimpleEditorOption(48 /* lineDecorationsWidth */, 'lineDecorationsWidth', 10)),
    lineHeight: register(new EditorLineHeight()),
    lineNumbers: register(new EditorRenderLineNumbersOption()),
    lineNumbersMinChars: register(new EditorIntOption(51 /* lineNumbersMinChars */, 'lineNumbersMinChars', 5, 1, 300)),
    links: register(new EditorBooleanOption(52 /* links */, 'links', true, { description: __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('links', "Controls whether the editor should detect links and make them clickable.") })),
    matchBrackets: register(new EditorStringEnumOption(53 /* matchBrackets */, 'matchBrackets', 'always', ['always', 'near', 'never'], { description: __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('matchBrackets', "Highlight matching brackets.") })),
    minimap: register(new EditorMinimap()),
    mouseStyle: register(new EditorStringEnumOption(55 /* mouseStyle */, 'mouseStyle', 'text', ['text', 'default', 'copy'])),
    mouseWheelScrollSensitivity: register(new EditorFloatOption(56 /* mouseWheelScrollSensitivity */, 'mouseWheelScrollSensitivity', 1, function (x) { return (x === 0 ? 1 : x); }, { markdownDescription: __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('mouseWheelScrollSensitivity', "A multiplier to be used on the `deltaX` and `deltaY` of mouse wheel scroll events.") })),
    mouseWheelZoom: register(new EditorBooleanOption(57 /* mouseWheelZoom */, 'mouseWheelZoom', false, { markdownDescription: __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('mouseWheelZoom', "Zoom the font of the editor when using mouse wheel and holding `Ctrl`.") })),
    multiCursorMergeOverlapping: register(new EditorBooleanOption(58 /* multiCursorMergeOverlapping */, 'multiCursorMergeOverlapping', true, { description: __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('multiCursorMergeOverlapping', "Merge multiple cursors when they are overlapping.") })),
    multiCursorModifier: register(new EditorEnumOption(59 /* multiCursorModifier */, 'multiCursorModifier', 'altKey', 'alt', ['ctrlCmd', 'alt'], _multiCursorModifierFromString, {
        markdownEnumDescriptions: [
            __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('multiCursorModifier.ctrlCmd', "Maps to `Control` on Windows and Linux and to `Command` on macOS."),
            __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('multiCursorModifier.alt', "Maps to `Alt` on Windows and Linux and to `Option` on macOS.")
        ],
        markdownDescription: __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]({
            key: 'multiCursorModifier',
            comment: [
                '- `ctrlCmd` refers to a value the setting can take and should not be localized.',
                '- `Control` and `Command` refer to the modifier keys Ctrl or Cmd on the keyboard and can be localized.'
            ]
        }, "The modifier to be used to add multiple cursors with the mouse. The Go To Definition and Open Link mouse gestures will adapt such that they do not conflict with the multicursor modifier. [Read more](https://code.visualstudio.com/docs/editor/codebasics#_multicursor-modifier).")
    })),
    multiCursorPaste: register(new EditorStringEnumOption(60 /* multiCursorPaste */, 'multiCursorPaste', 'spread', ['spread', 'full'], {
        markdownEnumDescriptions: [
            __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('multiCursorPaste.spread', "Each cursor pastes a single line of the text."),
            __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('multiCursorPaste.full', "Each cursor pastes the full text.")
        ],
        markdownDescription: __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('multiCursorPaste', "Controls pasting when the line count of the pasted text matches the cursor count.")
    })),
    occurrencesHighlight: register(new EditorBooleanOption(61 /* occurrencesHighlight */, 'occurrencesHighlight', true, { description: __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('occurrencesHighlight', "Controls whether the editor should highlight semantic symbol occurrences.") })),
    overviewRulerBorder: register(new EditorBooleanOption(62 /* overviewRulerBorder */, 'overviewRulerBorder', true, { description: __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('overviewRulerBorder', "Controls whether a border should be drawn around the overview ruler.") })),
    overviewRulerLanes: register(new EditorIntOption(63 /* overviewRulerLanes */, 'overviewRulerLanes', 3, 0, 3)),
    parameterHints: register(new EditorParameterHints()),
    peekWidgetDefaultFocus: register(new EditorStringEnumOption(65 /* peekWidgetDefaultFocus */, 'peekWidgetDefaultFocus', 'tree', ['tree', 'editor'], {
        enumDescriptions: [
            __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('peekWidgetDefaultFocus.tree', "Focus the tree when opening peek"),
            __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('peekWidgetDefaultFocus.editor', "Focus the editor when opening peek")
        ],
        description: __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('peekWidgetDefaultFocus', "Controls whether to focus the inline editor or the tree in the peek widget.")
    })),
    quickSuggestions: register(new EditorQuickSuggestions()),
    quickSuggestionsDelay: register(new EditorIntOption(67 /* quickSuggestionsDelay */, 'quickSuggestionsDelay', 10, 0, 1073741824 /* MAX_SAFE_SMALL_INTEGER */, { description: __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('quickSuggestionsDelay', "Controls the delay in milliseconds after which quick suggestions will show up.") })),
    readOnly: register(new EditorBooleanOption(68 /* readOnly */, 'readOnly', false)),
    renderControlCharacters: register(new EditorBooleanOption(69 /* renderControlCharacters */, 'renderControlCharacters', false, { description: __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('renderControlCharacters', "Controls whether the editor should render control characters.") })),
    renderIndentGuides: register(new EditorBooleanOption(70 /* renderIndentGuides */, 'renderIndentGuides', true, { description: __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('renderIndentGuides', "Controls whether the editor should render indent guides.") })),
    renderFinalNewline: register(new EditorBooleanOption(71 /* renderFinalNewline */, 'renderFinalNewline', true, { description: __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('renderFinalNewline', "Render last line number when the file ends with a newline.") })),
    renderLineHighlight: register(new EditorStringEnumOption(72 /* renderLineHighlight */, 'renderLineHighlight', 'line', ['none', 'gutter', 'line', 'all'], {
        enumDescriptions: [
            '',
            '',
            '',
            __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('renderLineHighlight.all', "Highlights both the gutter and the current line."),
        ],
        description: __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('renderLineHighlight', "Controls how the editor should render the current line highlight.")
    })),
    renderValidationDecorations: register(new EditorStringEnumOption(73 /* renderValidationDecorations */, 'renderValidationDecorations', 'editable', ['editable', 'on', 'off'])),
    renderWhitespace: register(new EditorStringEnumOption(74 /* renderWhitespace */, 'renderWhitespace', 'none', ['none', 'boundary', 'selection', 'all'], {
        enumDescriptions: [
            '',
            __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('renderWhitespace.boundary', "Render whitespace characters except for single spaces between words."),
            __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('renderWhitespace.selection', "Render whitespace characters only on selected text."),
            ''
        ],
        description: __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('renderWhitespace', "Controls how the editor should render whitespace characters.")
    })),
    revealHorizontalRightPadding: register(new EditorIntOption(75 /* revealHorizontalRightPadding */, 'revealHorizontalRightPadding', 30, 0, 1000)),
    roundedSelection: register(new EditorBooleanOption(76 /* roundedSelection */, 'roundedSelection', true, { description: __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('roundedSelection', "Controls whether selections should have rounded corners.") })),
    rulers: register(new EditorRulers()),
    scrollbar: register(new EditorScrollbar()),
    scrollBeyondLastColumn: register(new EditorIntOption(79 /* scrollBeyondLastColumn */, 'scrollBeyondLastColumn', 5, 0, 1073741824 /* MAX_SAFE_SMALL_INTEGER */, { description: __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('scrollBeyondLastColumn', "Controls the number of extra characters beyond which the editor will scroll horizontally.") })),
    scrollBeyondLastLine: register(new EditorBooleanOption(80 /* scrollBeyondLastLine */, 'scrollBeyondLastLine', true, { description: __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('scrollBeyondLastLine', "Controls whether the editor will scroll beyond the last line.") })),
    selectionClipboard: register(new EditorBooleanOption(81 /* selectionClipboard */, 'selectionClipboard', true, {
        description: __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('selectionClipboard', "Controls whether the Linux primary clipboard should be supported."),
        included: __WEBPACK_IMPORTED_MODULE_1__base_common_platform_js__["d" /* isLinux */]
    })),
    selectionHighlight: register(new EditorBooleanOption(82 /* selectionHighlight */, 'selectionHighlight', true, { description: __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('selectionHighlight', "Controls whether the editor should highlight matches similar to the selection.") })),
    selectOnLineNumbers: register(new EditorBooleanOption(83 /* selectOnLineNumbers */, 'selectOnLineNumbers', true)),
    showFoldingControls: register(new EditorStringEnumOption(84 /* showFoldingControls */, 'showFoldingControls', 'mouseover', ['always', 'mouseover'], { description: __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('showFoldingControls', "Controls whether the fold controls on the gutter are automatically hidden.") })),
    showUnused: register(new EditorBooleanOption(85 /* showUnused */, 'showUnused', true, { description: __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('showUnused', "Controls fading out of unused code.") })),
    snippetSuggestions: register(new EditorStringEnumOption(86 /* snippetSuggestions */, 'snippetSuggestions', 'inline', ['top', 'bottom', 'inline', 'none'], {
        enumDescriptions: [
            __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('snippetSuggestions.top', "Show snippet suggestions on top of other suggestions."),
            __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('snippetSuggestions.bottom', "Show snippet suggestions below other suggestions."),
            __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('snippetSuggestions.inline', "Show snippets suggestions with other suggestions."),
            __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('snippetSuggestions.none', "Do not show snippet suggestions."),
        ],
        description: __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('snippetSuggestions', "Controls whether snippets are shown with other suggestions and how they are sorted.")
    })),
    smoothScrolling: register(new EditorBooleanOption(87 /* smoothScrolling */, 'smoothScrolling', false, { description: __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('smoothScrolling', "Controls whether the editor will scroll using an animation.") })),
    stopRenderingLineAfter: register(new EditorIntOption(88 /* stopRenderingLineAfter */, 'stopRenderingLineAfter', 10000, -1, 1073741824 /* MAX_SAFE_SMALL_INTEGER */)),
    suggest: register(new EditorSuggest()),
    suggestFontSize: register(new EditorIntOption(90 /* suggestFontSize */, 'suggestFontSize', 0, 0, 1000, { markdownDescription: __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('suggestFontSize', "Font size for the suggest widget. When set to `0`, the value of `#editor.fontSize#` is used.") })),
    suggestLineHeight: register(new EditorIntOption(91 /* suggestLineHeight */, 'suggestLineHeight', 0, 0, 1000, { markdownDescription: __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('suggestLineHeight', "Line height for the suggest widget. When set to `0`, the value of `#editor.lineHeight#` is used.") })),
    suggestOnTriggerCharacters: register(new EditorBooleanOption(92 /* suggestOnTriggerCharacters */, 'suggestOnTriggerCharacters', true, { description: __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('suggestOnTriggerCharacters', "Controls whether suggestions should automatically show up when typing trigger characters.") })),
    suggestSelection: register(new EditorStringEnumOption(93 /* suggestSelection */, 'suggestSelection', 'recentlyUsed', ['first', 'recentlyUsed', 'recentlyUsedByPrefix'], {
        markdownEnumDescriptions: [
            __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('suggestSelection.first', "Always select the first suggestion."),
            __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('suggestSelection.recentlyUsed', "Select recent suggestions unless further typing selects one, e.g. `console.| -> console.log` because `log` has been completed recently."),
            __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('suggestSelection.recentlyUsedByPrefix', "Select suggestions based on previous prefixes that have completed those suggestions, e.g. `co -> console` and `con -> const`."),
        ],
        description: __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('suggestSelection', "Controls how suggestions are pre-selected when showing the suggest list.")
    })),
    tabCompletion: register(new EditorStringEnumOption(94 /* tabCompletion */, 'tabCompletion', 'off', ['on', 'off', 'onlySnippets'], {
        enumDescriptions: [
            __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('tabCompletion.on', "Tab complete will insert the best matching suggestion when pressing tab."),
            __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('tabCompletion.off', "Disable tab completions."),
            __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('tabCompletion.onlySnippets', "Tab complete snippets when their prefix match. Works best when 'quickSuggestions' aren't enabled."),
        ],
        description: __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('tabCompletion', "Enables tab completions.")
    })),
    useTabStops: register(new EditorBooleanOption(95 /* useTabStops */, 'useTabStops', true, { description: __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('useTabStops', "Inserting and deleting whitespace follows tab stops.") })),
    wordSeparators: register(new EditorStringOption(96 /* wordSeparators */, 'wordSeparators', __WEBPACK_IMPORTED_MODULE_2__model_wordHelper_js__["b" /* USUAL_WORD_SEPARATORS */], { description: __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('wordSeparators', "Characters that will be used as word separators when doing word related navigations or operations.") })),
    wordWrap: register(new EditorStringEnumOption(97 /* wordWrap */, 'wordWrap', 'off', ['off', 'on', 'wordWrapColumn', 'bounded'], {
        markdownEnumDescriptions: [
            __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('wordWrap.off', "Lines will never wrap."),
            __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('wordWrap.on', "Lines will wrap at the viewport width."),
            __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]({
                key: 'wordWrap.wordWrapColumn',
                comment: [
                    '- `editor.wordWrapColumn` refers to a different setting and should not be localized.'
                ]
            }, "Lines will wrap at `#editor.wordWrapColumn#`."),
            __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]({
                key: 'wordWrap.bounded',
                comment: [
                    '- viewport means the edge of the visible window size.',
                    '- `editor.wordWrapColumn` refers to a different setting and should not be localized.'
                ]
            }, "Lines will wrap at the minimum of viewport and `#editor.wordWrapColumn#`."),
        ],
        description: __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]({
            key: 'wordWrap',
            comment: [
                '- \'off\', \'on\', \'wordWrapColumn\' and \'bounded\' refer to values the setting can take and should not be localized.',
                '- `editor.wordWrapColumn` refers to a different setting and should not be localized.'
            ]
        }, "Controls how lines should wrap.")
    })),
    wordWrapBreakAfterCharacters: register(new EditorStringOption(98 /* wordWrapBreakAfterCharacters */, 'wordWrapBreakAfterCharacters', ' \t})]?|/&.,;¢°′″‰℃、。｡､￠，．：；？！％・･ゝゞヽヾーァィゥェォッャュョヮヵヶぁぃぅぇぉっゃゅょゎゕゖㇰㇱㇲㇳㇴㇵㇶㇷㇸㇹㇺㇻㇼㇽㇾㇿ々〻ｧｨｩｪｫｬｭｮｯｰ”〉》」』】〕）］｝｣')),
    wordWrapBreakBeforeCharacters: register(new EditorStringOption(99 /* wordWrapBreakBeforeCharacters */, 'wordWrapBreakBeforeCharacters', '([{‘“〈《「『【〔（［｛｢£¥＄￡￥+＋')),
    wordWrapColumn: register(new EditorIntOption(100 /* wordWrapColumn */, 'wordWrapColumn', 80, 1, 1073741824 /* MAX_SAFE_SMALL_INTEGER */, {
        markdownDescription: __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]({
            key: 'wordWrapColumn',
            comment: [
                '- `editor.wordWrap` refers to a different setting and should not be localized.',
                '- \'wordWrapColumn\' and \'bounded\' refer to values the different setting can take and should not be localized.'
            ]
        }, "Controls the wrapping column of the editor when `#editor.wordWrap#` is `wordWrapColumn` or `bounded`.")
    })),
    wordWrapMinified: register(new EditorBooleanOption(101 /* wordWrapMinified */, 'wordWrapMinified', true)),
    wrappingIndent: register(new EditorEnumOption(102 /* wrappingIndent */, 'wrappingIndent', 1 /* Same */, 'same', ['none', 'same', 'indent', 'deepIndent'], _wrappingIndentFromString, {
        enumDescriptions: [
            __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('wrappingIndent.none', "No indentation. Wrapped lines begin at column 1."),
            __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('wrappingIndent.same', "Wrapped lines get the same indentation as the parent."),
            __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('wrappingIndent.indent', "Wrapped lines get +1 indentation toward the parent."),
            __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('wrappingIndent.deepIndent', "Wrapped lines get +2 indentation toward the parent."),
        ],
        description: __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('wrappingIndent', "Controls the indentation of wrapped lines."),
    })),
    wrappingStrategy: register(new EditorStringEnumOption(103 /* wrappingStrategy */, 'wrappingStrategy', 'simple', ['simple', 'advanced'], {
        enumDescriptions: [
            __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('wrappingStrategy.simple', "Assumes that all characters are of the same width. This is a fast algorithm that works correctly for monospace fonts and certain scripts (like Latin characters) where glyphs are of equal width."),
            __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('wrappingStrategy.advanced', "Delegates wrapping points computation to the browser. This is a slow algorithm, that might cause freezes for large files, but it works correctly in all cases.")
        ],
        description: __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('wrappingStrategy', "Controls the algorithm that computes wrapping points.")
    })),
    // Leave these at the end (because they have dependencies!)
    editorClassName: register(new EditorClassName()),
    pixelRatio: register(new EditorPixelRatio()),
    tabFocusMode: register(new EditorTabFocusMode()),
    layoutInfo: register(new EditorLayoutInfoComputer()),
    wrappingInfo: register(new EditorWrappingInfoComputer())
};


/***/ }),
/* 33 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return IKeybindingService; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__instantiation_common_instantiation_js__ = __webpack_require__(10);
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/

var IKeybindingService = Object(__WEBPACK_IMPORTED_MODULE_0__instantiation_common_instantiation_js__["c" /* createDecorator */])('keybindingService');


/***/ }),
/* 34 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* unused harmony export Severity */
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return INotificationService; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "b", function() { return NoOpNotification; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__base_common_severity_js__ = __webpack_require__(124);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__instantiation_common_instantiation_js__ = __webpack_require__(10);
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/


var Severity = __WEBPACK_IMPORTED_MODULE_0__base_common_severity_js__["a" /* default */];
var INotificationService = Object(__WEBPACK_IMPORTED_MODULE_1__instantiation_common_instantiation_js__["c" /* createDecorator */])('notificationService');
var NoOpNotification = /** @class */ (function () {
    function NoOpNotification() {
    }
    return NoOpNotification;
}());



/***/ }),
/* 35 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "b", function() { return KeyCodeUtils; });
/* harmony export (immutable) */ __webpack_exports__["a"] = KeyChord;
/* harmony export (immutable) */ __webpack_exports__["f"] = createKeybinding;
/* unused harmony export createSimpleKeybinding */
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "e", function() { return SimpleKeybinding; });
/* unused harmony export ChordKeybinding */
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "d", function() { return ResolvedKeybindingPart; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "c", function() { return ResolvedKeybinding; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__errors_js__ = __webpack_require__(8);
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/

var KeyCodeStrMap = /** @class */ (function () {
    function KeyCodeStrMap() {
        this._keyCodeToStr = [];
        this._strToKeyCode = Object.create(null);
    }
    KeyCodeStrMap.prototype.define = function (keyCode, str) {
        this._keyCodeToStr[keyCode] = str;
        this._strToKeyCode[str.toLowerCase()] = keyCode;
    };
    KeyCodeStrMap.prototype.keyCodeToStr = function (keyCode) {
        return this._keyCodeToStr[keyCode];
    };
    KeyCodeStrMap.prototype.strToKeyCode = function (str) {
        return this._strToKeyCode[str.toLowerCase()] || 0 /* Unknown */;
    };
    return KeyCodeStrMap;
}());
var uiMap = new KeyCodeStrMap();
var userSettingsUSMap = new KeyCodeStrMap();
var userSettingsGeneralMap = new KeyCodeStrMap();
(function () {
    function define(keyCode, uiLabel, usUserSettingsLabel, generalUserSettingsLabel) {
        if (usUserSettingsLabel === void 0) { usUserSettingsLabel = uiLabel; }
        if (generalUserSettingsLabel === void 0) { generalUserSettingsLabel = usUserSettingsLabel; }
        uiMap.define(keyCode, uiLabel);
        userSettingsUSMap.define(keyCode, usUserSettingsLabel);
        userSettingsGeneralMap.define(keyCode, generalUserSettingsLabel);
    }
    define(0 /* Unknown */, 'unknown');
    define(1 /* Backspace */, 'Backspace');
    define(2 /* Tab */, 'Tab');
    define(3 /* Enter */, 'Enter');
    define(4 /* Shift */, 'Shift');
    define(5 /* Ctrl */, 'Ctrl');
    define(6 /* Alt */, 'Alt');
    define(7 /* PauseBreak */, 'PauseBreak');
    define(8 /* CapsLock */, 'CapsLock');
    define(9 /* Escape */, 'Escape');
    define(10 /* Space */, 'Space');
    define(11 /* PageUp */, 'PageUp');
    define(12 /* PageDown */, 'PageDown');
    define(13 /* End */, 'End');
    define(14 /* Home */, 'Home');
    define(15 /* LeftArrow */, 'LeftArrow', 'Left');
    define(16 /* UpArrow */, 'UpArrow', 'Up');
    define(17 /* RightArrow */, 'RightArrow', 'Right');
    define(18 /* DownArrow */, 'DownArrow', 'Down');
    define(19 /* Insert */, 'Insert');
    define(20 /* Delete */, 'Delete');
    define(21 /* KEY_0 */, '0');
    define(22 /* KEY_1 */, '1');
    define(23 /* KEY_2 */, '2');
    define(24 /* KEY_3 */, '3');
    define(25 /* KEY_4 */, '4');
    define(26 /* KEY_5 */, '5');
    define(27 /* KEY_6 */, '6');
    define(28 /* KEY_7 */, '7');
    define(29 /* KEY_8 */, '8');
    define(30 /* KEY_9 */, '9');
    define(31 /* KEY_A */, 'A');
    define(32 /* KEY_B */, 'B');
    define(33 /* KEY_C */, 'C');
    define(34 /* KEY_D */, 'D');
    define(35 /* KEY_E */, 'E');
    define(36 /* KEY_F */, 'F');
    define(37 /* KEY_G */, 'G');
    define(38 /* KEY_H */, 'H');
    define(39 /* KEY_I */, 'I');
    define(40 /* KEY_J */, 'J');
    define(41 /* KEY_K */, 'K');
    define(42 /* KEY_L */, 'L');
    define(43 /* KEY_M */, 'M');
    define(44 /* KEY_N */, 'N');
    define(45 /* KEY_O */, 'O');
    define(46 /* KEY_P */, 'P');
    define(47 /* KEY_Q */, 'Q');
    define(48 /* KEY_R */, 'R');
    define(49 /* KEY_S */, 'S');
    define(50 /* KEY_T */, 'T');
    define(51 /* KEY_U */, 'U');
    define(52 /* KEY_V */, 'V');
    define(53 /* KEY_W */, 'W');
    define(54 /* KEY_X */, 'X');
    define(55 /* KEY_Y */, 'Y');
    define(56 /* KEY_Z */, 'Z');
    define(57 /* Meta */, 'Meta');
    define(58 /* ContextMenu */, 'ContextMenu');
    define(59 /* F1 */, 'F1');
    define(60 /* F2 */, 'F2');
    define(61 /* F3 */, 'F3');
    define(62 /* F4 */, 'F4');
    define(63 /* F5 */, 'F5');
    define(64 /* F6 */, 'F6');
    define(65 /* F7 */, 'F7');
    define(66 /* F8 */, 'F8');
    define(67 /* F9 */, 'F9');
    define(68 /* F10 */, 'F10');
    define(69 /* F11 */, 'F11');
    define(70 /* F12 */, 'F12');
    define(71 /* F13 */, 'F13');
    define(72 /* F14 */, 'F14');
    define(73 /* F15 */, 'F15');
    define(74 /* F16 */, 'F16');
    define(75 /* F17 */, 'F17');
    define(76 /* F18 */, 'F18');
    define(77 /* F19 */, 'F19');
    define(78 /* NumLock */, 'NumLock');
    define(79 /* ScrollLock */, 'ScrollLock');
    define(80 /* US_SEMICOLON */, ';', ';', 'OEM_1');
    define(81 /* US_EQUAL */, '=', '=', 'OEM_PLUS');
    define(82 /* US_COMMA */, ',', ',', 'OEM_COMMA');
    define(83 /* US_MINUS */, '-', '-', 'OEM_MINUS');
    define(84 /* US_DOT */, '.', '.', 'OEM_PERIOD');
    define(85 /* US_SLASH */, '/', '/', 'OEM_2');
    define(86 /* US_BACKTICK */, '`', '`', 'OEM_3');
    define(110 /* ABNT_C1 */, 'ABNT_C1');
    define(111 /* ABNT_C2 */, 'ABNT_C2');
    define(87 /* US_OPEN_SQUARE_BRACKET */, '[', '[', 'OEM_4');
    define(88 /* US_BACKSLASH */, '\\', '\\', 'OEM_5');
    define(89 /* US_CLOSE_SQUARE_BRACKET */, ']', ']', 'OEM_6');
    define(90 /* US_QUOTE */, '\'', '\'', 'OEM_7');
    define(91 /* OEM_8 */, 'OEM_8');
    define(92 /* OEM_102 */, 'OEM_102');
    define(93 /* NUMPAD_0 */, 'NumPad0');
    define(94 /* NUMPAD_1 */, 'NumPad1');
    define(95 /* NUMPAD_2 */, 'NumPad2');
    define(96 /* NUMPAD_3 */, 'NumPad3');
    define(97 /* NUMPAD_4 */, 'NumPad4');
    define(98 /* NUMPAD_5 */, 'NumPad5');
    define(99 /* NUMPAD_6 */, 'NumPad6');
    define(100 /* NUMPAD_7 */, 'NumPad7');
    define(101 /* NUMPAD_8 */, 'NumPad8');
    define(102 /* NUMPAD_9 */, 'NumPad9');
    define(103 /* NUMPAD_MULTIPLY */, 'NumPad_Multiply');
    define(104 /* NUMPAD_ADD */, 'NumPad_Add');
    define(105 /* NUMPAD_SEPARATOR */, 'NumPad_Separator');
    define(106 /* NUMPAD_SUBTRACT */, 'NumPad_Subtract');
    define(107 /* NUMPAD_DECIMAL */, 'NumPad_Decimal');
    define(108 /* NUMPAD_DIVIDE */, 'NumPad_Divide');
})();
var KeyCodeUtils;
(function (KeyCodeUtils) {
    function toString(keyCode) {
        return uiMap.keyCodeToStr(keyCode);
    }
    KeyCodeUtils.toString = toString;
    function fromString(key) {
        return uiMap.strToKeyCode(key);
    }
    KeyCodeUtils.fromString = fromString;
    function toUserSettingsUS(keyCode) {
        return userSettingsUSMap.keyCodeToStr(keyCode);
    }
    KeyCodeUtils.toUserSettingsUS = toUserSettingsUS;
    function toUserSettingsGeneral(keyCode) {
        return userSettingsGeneralMap.keyCodeToStr(keyCode);
    }
    KeyCodeUtils.toUserSettingsGeneral = toUserSettingsGeneral;
    function fromUserSettings(key) {
        return userSettingsUSMap.strToKeyCode(key) || userSettingsGeneralMap.strToKeyCode(key);
    }
    KeyCodeUtils.fromUserSettings = fromUserSettings;
})(KeyCodeUtils || (KeyCodeUtils = {}));
function KeyChord(firstPart, secondPart) {
    var chordPart = ((secondPart & 0x0000FFFF) << 16) >>> 0;
    return (firstPart | chordPart) >>> 0;
}
function createKeybinding(keybinding, OS) {
    if (keybinding === 0) {
        return null;
    }
    var firstPart = (keybinding & 0x0000FFFF) >>> 0;
    var chordPart = (keybinding & 0xFFFF0000) >>> 16;
    if (chordPart !== 0) {
        return new ChordKeybinding([
            createSimpleKeybinding(firstPart, OS),
            createSimpleKeybinding(chordPart, OS)
        ]);
    }
    return new ChordKeybinding([createSimpleKeybinding(firstPart, OS)]);
}
function createSimpleKeybinding(keybinding, OS) {
    var ctrlCmd = (keybinding & 2048 /* CtrlCmd */ ? true : false);
    var winCtrl = (keybinding & 256 /* WinCtrl */ ? true : false);
    var ctrlKey = (OS === 2 /* Macintosh */ ? winCtrl : ctrlCmd);
    var shiftKey = (keybinding & 1024 /* Shift */ ? true : false);
    var altKey = (keybinding & 512 /* Alt */ ? true : false);
    var metaKey = (OS === 2 /* Macintosh */ ? ctrlCmd : winCtrl);
    var keyCode = (keybinding & 255 /* KeyCode */);
    return new SimpleKeybinding(ctrlKey, shiftKey, altKey, metaKey, keyCode);
}
var SimpleKeybinding = /** @class */ (function () {
    function SimpleKeybinding(ctrlKey, shiftKey, altKey, metaKey, keyCode) {
        this.ctrlKey = ctrlKey;
        this.shiftKey = shiftKey;
        this.altKey = altKey;
        this.metaKey = metaKey;
        this.keyCode = keyCode;
    }
    SimpleKeybinding.prototype.equals = function (other) {
        return (this.ctrlKey === other.ctrlKey
            && this.shiftKey === other.shiftKey
            && this.altKey === other.altKey
            && this.metaKey === other.metaKey
            && this.keyCode === other.keyCode);
    };
    SimpleKeybinding.prototype.isModifierKey = function () {
        return (this.keyCode === 0 /* Unknown */
            || this.keyCode === 5 /* Ctrl */
            || this.keyCode === 57 /* Meta */
            || this.keyCode === 6 /* Alt */
            || this.keyCode === 4 /* Shift */);
    };
    SimpleKeybinding.prototype.toChord = function () {
        return new ChordKeybinding([this]);
    };
    /**
     * Does this keybinding refer to the key code of a modifier and it also has the modifier flag?
     */
    SimpleKeybinding.prototype.isDuplicateModifierCase = function () {
        return ((this.ctrlKey && this.keyCode === 5 /* Ctrl */)
            || (this.shiftKey && this.keyCode === 4 /* Shift */)
            || (this.altKey && this.keyCode === 6 /* Alt */)
            || (this.metaKey && this.keyCode === 57 /* Meta */));
    };
    return SimpleKeybinding;
}());

var ChordKeybinding = /** @class */ (function () {
    function ChordKeybinding(parts) {
        if (parts.length === 0) {
            throw Object(__WEBPACK_IMPORTED_MODULE_0__errors_js__["b" /* illegalArgument */])("parts");
        }
        this.parts = parts;
    }
    ChordKeybinding.prototype.equals = function (other) {
        if (other === null) {
            return false;
        }
        if (this.parts.length !== other.parts.length) {
            return false;
        }
        for (var i = 0; i < this.parts.length; i++) {
            if (!this.parts[i].equals(other.parts[i])) {
                return false;
            }
        }
        return true;
    };
    return ChordKeybinding;
}());

var ResolvedKeybindingPart = /** @class */ (function () {
    function ResolvedKeybindingPart(ctrlKey, shiftKey, altKey, metaKey, kbLabel, kbAriaLabel) {
        this.ctrlKey = ctrlKey;
        this.shiftKey = shiftKey;
        this.altKey = altKey;
        this.metaKey = metaKey;
        this.keyLabel = kbLabel;
        this.keyAriaLabel = kbAriaLabel;
    }
    return ResolvedKeybindingPart;
}());

/**
 * A resolved keybinding. Can be a simple keybinding or a chord keybinding.
 */
var ResolvedKeybinding = /** @class */ (function () {
    function ResolvedKeybinding() {
    }
    return ResolvedKeybinding;
}());



/***/ }),
/* 36 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "S", function() { return NodeType; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Z", function() { return ReferenceType; });
/* harmony export (immutable) */ __webpack_exports__["_13"] = getNodeAtOffset;
/* harmony export (immutable) */ __webpack_exports__["_14"] = getNodePath;
/* harmony export (immutable) */ __webpack_exports__["_15"] = getParentDeclaration;
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "R", function() { return Node; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "T", function() { return Nodelist; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "y", function() { return Identifier; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "_3", function() { return Stylesheet; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "i", function() { return Declarations; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "e", function() { return BodyDeclaration; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "_0", function() { return RuleSet; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "_1", function() { return Selector; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "_2", function() { return SimpleSelector; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "b", function() { return AtApplyRule; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return AbstractDeclaration; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "f", function() { return CustomPropertyDeclaration; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "g", function() { return CustomPropertySet; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "h", function() { return Declaration; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Y", function() { return Property; });
/* unused harmony export Invocation */
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "s", function() { return Function; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "v", function() { return FunctionParameter; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "t", function() { return FunctionArgument; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "z", function() { return IfStatement; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "p", function() { return ForStatement; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "k", function() { return EachStatement; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "_12", function() { return WhileStatement; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "l", function() { return ElseStatement; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "u", function() { return FunctionDeclaration; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "_11", function() { return ViewPort; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "o", function() { return FontFace; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Q", function() { return NestedProperties; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "C", function() { return Keyframe; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "D", function() { return KeyframeSelector; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "A", function() { return Import; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "_8", function() { return Use; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "O", function() { return ModuleConfiguration; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "q", function() { return Forward; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "r", function() { return ForwardVisibility; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "P", function() { return Namespace; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "I", function() { return Media; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "_4", function() { return Supports; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "j", function() { return Document; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "K", function() { return Medialist; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "J", function() { return MediaQuery; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "_5", function() { return SupportsCondition; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "V", function() { return Page; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "W", function() { return PageBoxMarginBox; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "m", function() { return Expression; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "d", function() { return BinaryExpression; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "_6", function() { return Term; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "c", function() { return AttributeSelector; });
/* unused harmony export Operator */
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "x", function() { return HexColorValue; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "U", function() { return NumericValue; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "_10", function() { return VariableDeclaration; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "B", function() { return Interpolation; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "_9", function() { return Variable; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "n", function() { return ExtendsReference; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "M", function() { return MixinReference; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "L", function() { return MixinDeclaration; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "_7", function() { return UnknownAtRule; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "G", function() { return ListEntry; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "E", function() { return LessGuard; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "w", function() { return GuardCondition; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "N", function() { return Module; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "F", function() { return Level; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "H", function() { return Marker; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "X", function() { return ParseErrorCollector; });
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/

var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
/// <summary>
/// Nodes for the css 2.1 specification. See for reference:
/// http://www.w3.org/TR/CSS21/grammar.html#grammar
/// </summary>
var NodeType;
(function (NodeType) {
    NodeType[NodeType["Undefined"] = 0] = "Undefined";
    NodeType[NodeType["Identifier"] = 1] = "Identifier";
    NodeType[NodeType["Stylesheet"] = 2] = "Stylesheet";
    NodeType[NodeType["Ruleset"] = 3] = "Ruleset";
    NodeType[NodeType["Selector"] = 4] = "Selector";
    NodeType[NodeType["SimpleSelector"] = 5] = "SimpleSelector";
    NodeType[NodeType["SelectorInterpolation"] = 6] = "SelectorInterpolation";
    NodeType[NodeType["SelectorCombinator"] = 7] = "SelectorCombinator";
    NodeType[NodeType["SelectorCombinatorParent"] = 8] = "SelectorCombinatorParent";
    NodeType[NodeType["SelectorCombinatorSibling"] = 9] = "SelectorCombinatorSibling";
    NodeType[NodeType["SelectorCombinatorAllSiblings"] = 10] = "SelectorCombinatorAllSiblings";
    NodeType[NodeType["SelectorCombinatorShadowPiercingDescendant"] = 11] = "SelectorCombinatorShadowPiercingDescendant";
    NodeType[NodeType["Page"] = 12] = "Page";
    NodeType[NodeType["PageBoxMarginBox"] = 13] = "PageBoxMarginBox";
    NodeType[NodeType["ClassSelector"] = 14] = "ClassSelector";
    NodeType[NodeType["IdentifierSelector"] = 15] = "IdentifierSelector";
    NodeType[NodeType["ElementNameSelector"] = 16] = "ElementNameSelector";
    NodeType[NodeType["PseudoSelector"] = 17] = "PseudoSelector";
    NodeType[NodeType["AttributeSelector"] = 18] = "AttributeSelector";
    NodeType[NodeType["Declaration"] = 19] = "Declaration";
    NodeType[NodeType["Declarations"] = 20] = "Declarations";
    NodeType[NodeType["Property"] = 21] = "Property";
    NodeType[NodeType["Expression"] = 22] = "Expression";
    NodeType[NodeType["BinaryExpression"] = 23] = "BinaryExpression";
    NodeType[NodeType["Term"] = 24] = "Term";
    NodeType[NodeType["Operator"] = 25] = "Operator";
    NodeType[NodeType["Value"] = 26] = "Value";
    NodeType[NodeType["StringLiteral"] = 27] = "StringLiteral";
    NodeType[NodeType["URILiteral"] = 28] = "URILiteral";
    NodeType[NodeType["EscapedValue"] = 29] = "EscapedValue";
    NodeType[NodeType["Function"] = 30] = "Function";
    NodeType[NodeType["NumericValue"] = 31] = "NumericValue";
    NodeType[NodeType["HexColorValue"] = 32] = "HexColorValue";
    NodeType[NodeType["MixinDeclaration"] = 33] = "MixinDeclaration";
    NodeType[NodeType["MixinReference"] = 34] = "MixinReference";
    NodeType[NodeType["VariableName"] = 35] = "VariableName";
    NodeType[NodeType["VariableDeclaration"] = 36] = "VariableDeclaration";
    NodeType[NodeType["Prio"] = 37] = "Prio";
    NodeType[NodeType["Interpolation"] = 38] = "Interpolation";
    NodeType[NodeType["NestedProperties"] = 39] = "NestedProperties";
    NodeType[NodeType["ExtendsReference"] = 40] = "ExtendsReference";
    NodeType[NodeType["SelectorPlaceholder"] = 41] = "SelectorPlaceholder";
    NodeType[NodeType["Debug"] = 42] = "Debug";
    NodeType[NodeType["If"] = 43] = "If";
    NodeType[NodeType["Else"] = 44] = "Else";
    NodeType[NodeType["For"] = 45] = "For";
    NodeType[NodeType["Each"] = 46] = "Each";
    NodeType[NodeType["While"] = 47] = "While";
    NodeType[NodeType["MixinContent"] = 48] = "MixinContent";
    NodeType[NodeType["Media"] = 49] = "Media";
    NodeType[NodeType["Keyframe"] = 50] = "Keyframe";
    NodeType[NodeType["FontFace"] = 51] = "FontFace";
    NodeType[NodeType["Import"] = 52] = "Import";
    NodeType[NodeType["Namespace"] = 53] = "Namespace";
    NodeType[NodeType["Invocation"] = 54] = "Invocation";
    NodeType[NodeType["FunctionDeclaration"] = 55] = "FunctionDeclaration";
    NodeType[NodeType["ReturnStatement"] = 56] = "ReturnStatement";
    NodeType[NodeType["MediaQuery"] = 57] = "MediaQuery";
    NodeType[NodeType["FunctionParameter"] = 58] = "FunctionParameter";
    NodeType[NodeType["FunctionArgument"] = 59] = "FunctionArgument";
    NodeType[NodeType["KeyframeSelector"] = 60] = "KeyframeSelector";
    NodeType[NodeType["ViewPort"] = 61] = "ViewPort";
    NodeType[NodeType["Document"] = 62] = "Document";
    NodeType[NodeType["AtApplyRule"] = 63] = "AtApplyRule";
    NodeType[NodeType["CustomPropertyDeclaration"] = 64] = "CustomPropertyDeclaration";
    NodeType[NodeType["CustomPropertySet"] = 65] = "CustomPropertySet";
    NodeType[NodeType["ListEntry"] = 66] = "ListEntry";
    NodeType[NodeType["Supports"] = 67] = "Supports";
    NodeType[NodeType["SupportsCondition"] = 68] = "SupportsCondition";
    NodeType[NodeType["NamespacePrefix"] = 69] = "NamespacePrefix";
    NodeType[NodeType["GridLine"] = 70] = "GridLine";
    NodeType[NodeType["Plugin"] = 71] = "Plugin";
    NodeType[NodeType["UnknownAtRule"] = 72] = "UnknownAtRule";
    NodeType[NodeType["Use"] = 73] = "Use";
    NodeType[NodeType["ModuleConfiguration"] = 74] = "ModuleConfiguration";
    NodeType[NodeType["Forward"] = 75] = "Forward";
    NodeType[NodeType["ForwardVisibility"] = 76] = "ForwardVisibility";
    NodeType[NodeType["Module"] = 77] = "Module";
})(NodeType || (NodeType = {}));
var ReferenceType;
(function (ReferenceType) {
    ReferenceType[ReferenceType["Mixin"] = 0] = "Mixin";
    ReferenceType[ReferenceType["Rule"] = 1] = "Rule";
    ReferenceType[ReferenceType["Variable"] = 2] = "Variable";
    ReferenceType[ReferenceType["Function"] = 3] = "Function";
    ReferenceType[ReferenceType["Keyframe"] = 4] = "Keyframe";
    ReferenceType[ReferenceType["Unknown"] = 5] = "Unknown";
    ReferenceType[ReferenceType["Module"] = 6] = "Module";
    ReferenceType[ReferenceType["Forward"] = 7] = "Forward";
    ReferenceType[ReferenceType["ForwardVisibility"] = 8] = "ForwardVisibility";
})(ReferenceType || (ReferenceType = {}));
function getNodeAtOffset(node, offset) {
    var candidate = null;
    if (!node || offset < node.offset || offset > node.end) {
        return null;
    }
    // Find the shortest node at the position
    node.accept(function (node) {
        if (node.offset === -1 && node.length === -1) {
            return true;
        }
        if (node.offset <= offset && node.end >= offset) {
            if (!candidate) {
                candidate = node;
            }
            else if (node.length <= candidate.length) {
                candidate = node;
            }
            return true;
        }
        return false;
    });
    return candidate;
}
function getNodePath(node, offset) {
    var candidate = getNodeAtOffset(node, offset);
    var path = [];
    while (candidate) {
        path.unshift(candidate);
        candidate = candidate.parent;
    }
    return path;
}
function getParentDeclaration(node) {
    var decl = node.findParent(NodeType.Declaration);
    var value = decl && decl.getValue();
    if (value && value.encloses(node)) {
        return decl;
    }
    return null;
}
var Node = /** @class */ (function () {
    function Node(offset, len, nodeType) {
        if (offset === void 0) { offset = -1; }
        if (len === void 0) { len = -1; }
        this.parent = null;
        this.offset = offset;
        this.length = len;
        if (nodeType) {
            this.nodeType = nodeType;
        }
    }
    Object.defineProperty(Node.prototype, "end", {
        get: function () { return this.offset + this.length; },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(Node.prototype, "type", {
        get: function () {
            return this.nodeType || NodeType.Undefined;
        },
        set: function (type) {
            this.nodeType = type;
        },
        enumerable: true,
        configurable: true
    });
    Node.prototype.getTextProvider = function () {
        var node = this;
        while (node && !node.textProvider) {
            node = node.parent;
        }
        if (node) {
            return node.textProvider;
        }
        return function () { return 'unknown'; };
    };
    Node.prototype.getText = function () {
        return this.getTextProvider()(this.offset, this.length);
    };
    Node.prototype.matches = function (str) {
        return this.length === str.length && this.getTextProvider()(this.offset, this.length) === str;
    };
    Node.prototype.startsWith = function (str) {
        return this.length >= str.length && this.getTextProvider()(this.offset, str.length) === str;
    };
    Node.prototype.endsWith = function (str) {
        return this.length >= str.length && this.getTextProvider()(this.end - str.length, str.length) === str;
    };
    Node.prototype.accept = function (visitor) {
        if (visitor(this) && this.children) {
            for (var _i = 0, _a = this.children; _i < _a.length; _i++) {
                var child = _a[_i];
                child.accept(visitor);
            }
        }
    };
    Node.prototype.acceptVisitor = function (visitor) {
        this.accept(visitor.visitNode.bind(visitor));
    };
    Node.prototype.adoptChild = function (node, index) {
        if (index === void 0) { index = -1; }
        if (node.parent && node.parent.children) {
            var idx = node.parent.children.indexOf(node);
            if (idx >= 0) {
                node.parent.children.splice(idx, 1);
            }
        }
        node.parent = this;
        var children = this.children;
        if (!children) {
            children = this.children = [];
        }
        if (index !== -1) {
            children.splice(index, 0, node);
        }
        else {
            children.push(node);
        }
        return node;
    };
    Node.prototype.attachTo = function (parent, index) {
        if (index === void 0) { index = -1; }
        if (parent) {
            parent.adoptChild(this, index);
        }
        return this;
    };
    Node.prototype.collectIssues = function (results) {
        if (this.issues) {
            results.push.apply(results, this.issues);
        }
    };
    Node.prototype.addIssue = function (issue) {
        if (!this.issues) {
            this.issues = [];
        }
        this.issues.push(issue);
    };
    Node.prototype.hasIssue = function (rule) {
        return Array.isArray(this.issues) && this.issues.some(function (i) { return i.getRule() === rule; });
    };
    Node.prototype.isErroneous = function (recursive) {
        if (recursive === void 0) { recursive = false; }
        if (this.issues && this.issues.length > 0) {
            return true;
        }
        return recursive && Array.isArray(this.children) && this.children.some(function (c) { return c.isErroneous(true); });
    };
    Node.prototype.setNode = function (field, node, index) {
        if (index === void 0) { index = -1; }
        if (node) {
            node.attachTo(this, index);
            this[field] = node;
            return true;
        }
        return false;
    };
    Node.prototype.addChild = function (node) {
        if (node) {
            if (!this.children) {
                this.children = [];
            }
            node.attachTo(this);
            this.updateOffsetAndLength(node);
            return true;
        }
        return false;
    };
    Node.prototype.updateOffsetAndLength = function (node) {
        if (node.offset < this.offset || this.offset === -1) {
            this.offset = node.offset;
        }
        var nodeEnd = node.end;
        if ((nodeEnd > this.end) || this.length === -1) {
            this.length = nodeEnd - this.offset;
        }
    };
    Node.prototype.hasChildren = function () {
        return !!this.children && this.children.length > 0;
    };
    Node.prototype.getChildren = function () {
        return this.children ? this.children.slice(0) : [];
    };
    Node.prototype.getChild = function (index) {
        if (this.children && index < this.children.length) {
            return this.children[index];
        }
        return null;
    };
    Node.prototype.addChildren = function (nodes) {
        for (var _i = 0, nodes_1 = nodes; _i < nodes_1.length; _i++) {
            var node = nodes_1[_i];
            this.addChild(node);
        }
    };
    Node.prototype.findFirstChildBeforeOffset = function (offset) {
        if (this.children) {
            var current = null;
            for (var i = this.children.length - 1; i >= 0; i--) {
                // iterate until we find a child that has a start offset smaller than the input offset
                current = this.children[i];
                if (current.offset <= offset) {
                    return current;
                }
            }
        }
        return null;
    };
    Node.prototype.findChildAtOffset = function (offset, goDeep) {
        var current = this.findFirstChildBeforeOffset(offset);
        if (current && current.end >= offset) {
            if (goDeep) {
                return current.findChildAtOffset(offset, true) || current;
            }
            return current;
        }
        return null;
    };
    Node.prototype.encloses = function (candidate) {
        return this.offset <= candidate.offset && this.offset + this.length >= candidate.offset + candidate.length;
    };
    Node.prototype.getParent = function () {
        var result = this.parent;
        while (result instanceof Nodelist) {
            result = result.parent;
        }
        return result;
    };
    Node.prototype.findParent = function (type) {
        var result = this;
        while (result && result.type !== type) {
            result = result.parent;
        }
        return result;
    };
    Node.prototype.findAParent = function () {
        var types = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            types[_i] = arguments[_i];
        }
        var result = this;
        while (result && !types.some(function (t) { return result.type === t; })) {
            result = result.parent;
        }
        return result;
    };
    Node.prototype.setData = function (key, value) {
        if (!this.options) {
            this.options = {};
        }
        this.options[key] = value;
    };
    Node.prototype.getData = function (key) {
        if (!this.options || !this.options.hasOwnProperty(key)) {
            return null;
        }
        return this.options[key];
    };
    return Node;
}());

var Nodelist = /** @class */ (function (_super) {
    __extends(Nodelist, _super);
    function Nodelist(parent, index) {
        if (index === void 0) { index = -1; }
        var _this = _super.call(this, -1, -1) || this;
        _this.attachTo(parent, index);
        _this.offset = -1;
        _this.length = -1;
        return _this;
    }
    return Nodelist;
}(Node));

var Identifier = /** @class */ (function (_super) {
    __extends(Identifier, _super);
    function Identifier(offset, length) {
        var _this = _super.call(this, offset, length) || this;
        _this.isCustomProperty = false;
        return _this;
    }
    Object.defineProperty(Identifier.prototype, "type", {
        get: function () {
            return NodeType.Identifier;
        },
        enumerable: true,
        configurable: true
    });
    Identifier.prototype.containsInterpolation = function () {
        return this.hasChildren();
    };
    return Identifier;
}(Node));

var Stylesheet = /** @class */ (function (_super) {
    __extends(Stylesheet, _super);
    function Stylesheet(offset, length) {
        return _super.call(this, offset, length) || this;
    }
    Object.defineProperty(Stylesheet.prototype, "type", {
        get: function () {
            return NodeType.Stylesheet;
        },
        enumerable: true,
        configurable: true
    });
    return Stylesheet;
}(Node));

var Declarations = /** @class */ (function (_super) {
    __extends(Declarations, _super);
    function Declarations(offset, length) {
        return _super.call(this, offset, length) || this;
    }
    Object.defineProperty(Declarations.prototype, "type", {
        get: function () {
            return NodeType.Declarations;
        },
        enumerable: true,
        configurable: true
    });
    return Declarations;
}(Node));

var BodyDeclaration = /** @class */ (function (_super) {
    __extends(BodyDeclaration, _super);
    function BodyDeclaration(offset, length) {
        return _super.call(this, offset, length) || this;
    }
    BodyDeclaration.prototype.getDeclarations = function () {
        return this.declarations;
    };
    BodyDeclaration.prototype.setDeclarations = function (decls) {
        return this.setNode('declarations', decls);
    };
    return BodyDeclaration;
}(Node));

var RuleSet = /** @class */ (function (_super) {
    __extends(RuleSet, _super);
    function RuleSet(offset, length) {
        return _super.call(this, offset, length) || this;
    }
    Object.defineProperty(RuleSet.prototype, "type", {
        get: function () {
            return NodeType.Ruleset;
        },
        enumerable: true,
        configurable: true
    });
    RuleSet.prototype.getSelectors = function () {
        if (!this.selectors) {
            this.selectors = new Nodelist(this);
        }
        return this.selectors;
    };
    RuleSet.prototype.isNested = function () {
        return !!this.parent && this.parent.findParent(NodeType.Declarations) !== null;
    };
    return RuleSet;
}(BodyDeclaration));

var Selector = /** @class */ (function (_super) {
    __extends(Selector, _super);
    function Selector(offset, length) {
        return _super.call(this, offset, length) || this;
    }
    Object.defineProperty(Selector.prototype, "type", {
        get: function () {
            return NodeType.Selector;
        },
        enumerable: true,
        configurable: true
    });
    return Selector;
}(Node));

var SimpleSelector = /** @class */ (function (_super) {
    __extends(SimpleSelector, _super);
    function SimpleSelector(offset, length) {
        return _super.call(this, offset, length) || this;
    }
    Object.defineProperty(SimpleSelector.prototype, "type", {
        get: function () {
            return NodeType.SimpleSelector;
        },
        enumerable: true,
        configurable: true
    });
    return SimpleSelector;
}(Node));

var AtApplyRule = /** @class */ (function (_super) {
    __extends(AtApplyRule, _super);
    function AtApplyRule(offset, length) {
        return _super.call(this, offset, length) || this;
    }
    Object.defineProperty(AtApplyRule.prototype, "type", {
        get: function () {
            return NodeType.AtApplyRule;
        },
        enumerable: true,
        configurable: true
    });
    AtApplyRule.prototype.setIdentifier = function (node) {
        return this.setNode('identifier', node, 0);
    };
    AtApplyRule.prototype.getIdentifier = function () {
        return this.identifier;
    };
    AtApplyRule.prototype.getName = function () {
        return this.identifier ? this.identifier.getText() : '';
    };
    return AtApplyRule;
}(Node));

var AbstractDeclaration = /** @class */ (function (_super) {
    __extends(AbstractDeclaration, _super);
    function AbstractDeclaration(offset, length) {
        return _super.call(this, offset, length) || this;
    }
    return AbstractDeclaration;
}(Node));

var CustomPropertyDeclaration = /** @class */ (function (_super) {
    __extends(CustomPropertyDeclaration, _super);
    function CustomPropertyDeclaration(offset, length) {
        return _super.call(this, offset, length) || this;
    }
    Object.defineProperty(CustomPropertyDeclaration.prototype, "type", {
        get: function () {
            return NodeType.CustomPropertyDeclaration;
        },
        enumerable: true,
        configurable: true
    });
    CustomPropertyDeclaration.prototype.setProperty = function (node) {
        return this.setNode('property', node);
    };
    CustomPropertyDeclaration.prototype.getProperty = function () {
        return this.property;
    };
    CustomPropertyDeclaration.prototype.setValue = function (value) {
        return this.setNode('value', value);
    };
    CustomPropertyDeclaration.prototype.getValue = function () {
        return this.value;
    };
    CustomPropertyDeclaration.prototype.setPropertySet = function (value) {
        return this.setNode('propertySet', value);
    };
    CustomPropertyDeclaration.prototype.getPropertySet = function () {
        return this.propertySet;
    };
    return CustomPropertyDeclaration;
}(AbstractDeclaration));

var CustomPropertySet = /** @class */ (function (_super) {
    __extends(CustomPropertySet, _super);
    function CustomPropertySet(offset, length) {
        return _super.call(this, offset, length) || this;
    }
    Object.defineProperty(CustomPropertySet.prototype, "type", {
        get: function () {
            return NodeType.CustomPropertySet;
        },
        enumerable: true,
        configurable: true
    });
    return CustomPropertySet;
}(BodyDeclaration));

var Declaration = /** @class */ (function (_super) {
    __extends(Declaration, _super);
    function Declaration(offset, length) {
        var _this = _super.call(this, offset, length) || this;
        _this.property = null;
        return _this;
    }
    Object.defineProperty(Declaration.prototype, "type", {
        get: function () {
            return NodeType.Declaration;
        },
        enumerable: true,
        configurable: true
    });
    Declaration.prototype.setProperty = function (node) {
        return this.setNode('property', node);
    };
    Declaration.prototype.getProperty = function () {
        return this.property;
    };
    Declaration.prototype.getFullPropertyName = function () {
        var propertyName = this.property ? this.property.getName() : 'unknown';
        if (this.parent instanceof Declarations && this.parent.getParent() instanceof NestedProperties) {
            var parentDecl = this.parent.getParent().getParent();
            if (parentDecl instanceof Declaration) {
                return parentDecl.getFullPropertyName() + propertyName;
            }
        }
        return propertyName;
    };
    Declaration.prototype.getNonPrefixedPropertyName = function () {
        var propertyName = this.getFullPropertyName();
        if (propertyName && propertyName.charAt(0) === '-') {
            var vendorPrefixEnd = propertyName.indexOf('-', 1);
            if (vendorPrefixEnd !== -1) {
                return propertyName.substring(vendorPrefixEnd + 1);
            }
        }
        return propertyName;
    };
    Declaration.prototype.setValue = function (value) {
        return this.setNode('value', value);
    };
    Declaration.prototype.getValue = function () {
        return this.value;
    };
    Declaration.prototype.setNestedProperties = function (value) {
        return this.setNode('nestedProperties', value);
    };
    Declaration.prototype.getNestedProperties = function () {
        return this.nestedProperties;
    };
    return Declaration;
}(AbstractDeclaration));

var Property = /** @class */ (function (_super) {
    __extends(Property, _super);
    function Property(offset, length) {
        return _super.call(this, offset, length) || this;
    }
    Object.defineProperty(Property.prototype, "type", {
        get: function () {
            return NodeType.Property;
        },
        enumerable: true,
        configurable: true
    });
    Property.prototype.setIdentifier = function (value) {
        return this.setNode('identifier', value);
    };
    Property.prototype.getIdentifier = function () {
        return this.identifier;
    };
    Property.prototype.getName = function () {
        return this.getText();
    };
    Property.prototype.isCustomProperty = function () {
        return !!this.identifier && this.identifier.isCustomProperty;
    };
    return Property;
}(Node));

var Invocation = /** @class */ (function (_super) {
    __extends(Invocation, _super);
    function Invocation(offset, length) {
        return _super.call(this, offset, length) || this;
    }
    Object.defineProperty(Invocation.prototype, "type", {
        get: function () {
            return NodeType.Invocation;
        },
        enumerable: true,
        configurable: true
    });
    Invocation.prototype.getArguments = function () {
        if (!this.arguments) {
            this.arguments = new Nodelist(this);
        }
        return this.arguments;
    };
    return Invocation;
}(Node));

var Function = /** @class */ (function (_super) {
    __extends(Function, _super);
    function Function(offset, length) {
        return _super.call(this, offset, length) || this;
    }
    Object.defineProperty(Function.prototype, "type", {
        get: function () {
            return NodeType.Function;
        },
        enumerable: true,
        configurable: true
    });
    Function.prototype.setIdentifier = function (node) {
        return this.setNode('identifier', node, 0);
    };
    Function.prototype.getIdentifier = function () {
        return this.identifier;
    };
    Function.prototype.getName = function () {
        return this.identifier ? this.identifier.getText() : '';
    };
    return Function;
}(Invocation));

var FunctionParameter = /** @class */ (function (_super) {
    __extends(FunctionParameter, _super);
    function FunctionParameter(offset, length) {
        return _super.call(this, offset, length) || this;
    }
    Object.defineProperty(FunctionParameter.prototype, "type", {
        get: function () {
            return NodeType.FunctionParameter;
        },
        enumerable: true,
        configurable: true
    });
    FunctionParameter.prototype.setIdentifier = function (node) {
        return this.setNode('identifier', node, 0);
    };
    FunctionParameter.prototype.getIdentifier = function () {
        return this.identifier;
    };
    FunctionParameter.prototype.getName = function () {
        return this.identifier ? this.identifier.getText() : '';
    };
    FunctionParameter.prototype.setDefaultValue = function (node) {
        return this.setNode('defaultValue', node, 0);
    };
    FunctionParameter.prototype.getDefaultValue = function () {
        return this.defaultValue;
    };
    return FunctionParameter;
}(Node));

var FunctionArgument = /** @class */ (function (_super) {
    __extends(FunctionArgument, _super);
    function FunctionArgument(offset, length) {
        return _super.call(this, offset, length) || this;
    }
    Object.defineProperty(FunctionArgument.prototype, "type", {
        get: function () {
            return NodeType.FunctionArgument;
        },
        enumerable: true,
        configurable: true
    });
    FunctionArgument.prototype.setIdentifier = function (node) {
        return this.setNode('identifier', node, 0);
    };
    FunctionArgument.prototype.getIdentifier = function () {
        return this.identifier;
    };
    FunctionArgument.prototype.getName = function () {
        return this.identifier ? this.identifier.getText() : '';
    };
    FunctionArgument.prototype.setValue = function (node) {
        return this.setNode('value', node, 0);
    };
    FunctionArgument.prototype.getValue = function () {
        return this.value;
    };
    return FunctionArgument;
}(Node));

var IfStatement = /** @class */ (function (_super) {
    __extends(IfStatement, _super);
    function IfStatement(offset, length) {
        return _super.call(this, offset, length) || this;
    }
    Object.defineProperty(IfStatement.prototype, "type", {
        get: function () {
            return NodeType.If;
        },
        enumerable: true,
        configurable: true
    });
    IfStatement.prototype.setExpression = function (node) {
        return this.setNode('expression', node, 0);
    };
    IfStatement.prototype.setElseClause = function (elseClause) {
        return this.setNode('elseClause', elseClause);
    };
    return IfStatement;
}(BodyDeclaration));

var ForStatement = /** @class */ (function (_super) {
    __extends(ForStatement, _super);
    function ForStatement(offset, length) {
        return _super.call(this, offset, length) || this;
    }
    Object.defineProperty(ForStatement.prototype, "type", {
        get: function () {
            return NodeType.For;
        },
        enumerable: true,
        configurable: true
    });
    ForStatement.prototype.setVariable = function (node) {
        return this.setNode('variable', node, 0);
    };
    return ForStatement;
}(BodyDeclaration));

var EachStatement = /** @class */ (function (_super) {
    __extends(EachStatement, _super);
    function EachStatement(offset, length) {
        return _super.call(this, offset, length) || this;
    }
    Object.defineProperty(EachStatement.prototype, "type", {
        get: function () {
            return NodeType.Each;
        },
        enumerable: true,
        configurable: true
    });
    EachStatement.prototype.getVariables = function () {
        if (!this.variables) {
            this.variables = new Nodelist(this);
        }
        return this.variables;
    };
    return EachStatement;
}(BodyDeclaration));

var WhileStatement = /** @class */ (function (_super) {
    __extends(WhileStatement, _super);
    function WhileStatement(offset, length) {
        return _super.call(this, offset, length) || this;
    }
    Object.defineProperty(WhileStatement.prototype, "type", {
        get: function () {
            return NodeType.While;
        },
        enumerable: true,
        configurable: true
    });
    return WhileStatement;
}(BodyDeclaration));

var ElseStatement = /** @class */ (function (_super) {
    __extends(ElseStatement, _super);
    function ElseStatement(offset, length) {
        return _super.call(this, offset, length) || this;
    }
    Object.defineProperty(ElseStatement.prototype, "type", {
        get: function () {
            return NodeType.Else;
        },
        enumerable: true,
        configurable: true
    });
    return ElseStatement;
}(BodyDeclaration));

var FunctionDeclaration = /** @class */ (function (_super) {
    __extends(FunctionDeclaration, _super);
    function FunctionDeclaration(offset, length) {
        return _super.call(this, offset, length) || this;
    }
    Object.defineProperty(FunctionDeclaration.prototype, "type", {
        get: function () {
            return NodeType.FunctionDeclaration;
        },
        enumerable: true,
        configurable: true
    });
    FunctionDeclaration.prototype.setIdentifier = function (node) {
        return this.setNode('identifier', node, 0);
    };
    FunctionDeclaration.prototype.getIdentifier = function () {
        return this.identifier;
    };
    FunctionDeclaration.prototype.getName = function () {
        return this.identifier ? this.identifier.getText() : '';
    };
    FunctionDeclaration.prototype.getParameters = function () {
        if (!this.parameters) {
            this.parameters = new Nodelist(this);
        }
        return this.parameters;
    };
    return FunctionDeclaration;
}(BodyDeclaration));

var ViewPort = /** @class */ (function (_super) {
    __extends(ViewPort, _super);
    function ViewPort(offset, length) {
        return _super.call(this, offset, length) || this;
    }
    Object.defineProperty(ViewPort.prototype, "type", {
        get: function () {
            return NodeType.ViewPort;
        },
        enumerable: true,
        configurable: true
    });
    return ViewPort;
}(BodyDeclaration));

var FontFace = /** @class */ (function (_super) {
    __extends(FontFace, _super);
    function FontFace(offset, length) {
        return _super.call(this, offset, length) || this;
    }
    Object.defineProperty(FontFace.prototype, "type", {
        get: function () {
            return NodeType.FontFace;
        },
        enumerable: true,
        configurable: true
    });
    return FontFace;
}(BodyDeclaration));

var NestedProperties = /** @class */ (function (_super) {
    __extends(NestedProperties, _super);
    function NestedProperties(offset, length) {
        return _super.call(this, offset, length) || this;
    }
    Object.defineProperty(NestedProperties.prototype, "type", {
        get: function () {
            return NodeType.NestedProperties;
        },
        enumerable: true,
        configurable: true
    });
    return NestedProperties;
}(BodyDeclaration));

var Keyframe = /** @class */ (function (_super) {
    __extends(Keyframe, _super);
    function Keyframe(offset, length) {
        return _super.call(this, offset, length) || this;
    }
    Object.defineProperty(Keyframe.prototype, "type", {
        get: function () {
            return NodeType.Keyframe;
        },
        enumerable: true,
        configurable: true
    });
    Keyframe.prototype.setKeyword = function (keyword) {
        return this.setNode('keyword', keyword, 0);
    };
    Keyframe.prototype.getKeyword = function () {
        return this.keyword;
    };
    Keyframe.prototype.setIdentifier = function (node) {
        return this.setNode('identifier', node, 0);
    };
    Keyframe.prototype.getIdentifier = function () {
        return this.identifier;
    };
    Keyframe.prototype.getName = function () {
        return this.identifier ? this.identifier.getText() : '';
    };
    return Keyframe;
}(BodyDeclaration));

var KeyframeSelector = /** @class */ (function (_super) {
    __extends(KeyframeSelector, _super);
    function KeyframeSelector(offset, length) {
        return _super.call(this, offset, length) || this;
    }
    Object.defineProperty(KeyframeSelector.prototype, "type", {
        get: function () {
            return NodeType.KeyframeSelector;
        },
        enumerable: true,
        configurable: true
    });
    return KeyframeSelector;
}(BodyDeclaration));

var Import = /** @class */ (function (_super) {
    __extends(Import, _super);
    function Import(offset, length) {
        return _super.call(this, offset, length) || this;
    }
    Object.defineProperty(Import.prototype, "type", {
        get: function () {
            return NodeType.Import;
        },
        enumerable: true,
        configurable: true
    });
    Import.prototype.setMedialist = function (node) {
        if (node) {
            node.attachTo(this);
            return true;
        }
        return false;
    };
    return Import;
}(Node));

var Use = /** @class */ (function (_super) {
    __extends(Use, _super);
    function Use() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Object.defineProperty(Use.prototype, "type", {
        get: function () {
            return NodeType.Use;
        },
        enumerable: true,
        configurable: true
    });
    Use.prototype.getParameters = function () {
        if (!this.parameters) {
            this.parameters = new Nodelist(this);
        }
        return this.parameters;
    };
    Use.prototype.setIdentifier = function (node) {
        return this.setNode('identifier', node, 0);
    };
    Use.prototype.getIdentifier = function () {
        return this.identifier;
    };
    return Use;
}(Node));

var ModuleConfiguration = /** @class */ (function (_super) {
    __extends(ModuleConfiguration, _super);
    function ModuleConfiguration() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Object.defineProperty(ModuleConfiguration.prototype, "type", {
        get: function () {
            return NodeType.ModuleConfiguration;
        },
        enumerable: true,
        configurable: true
    });
    ModuleConfiguration.prototype.setIdentifier = function (node) {
        return this.setNode('identifier', node, 0);
    };
    ModuleConfiguration.prototype.getIdentifier = function () {
        return this.identifier;
    };
    ModuleConfiguration.prototype.getName = function () {
        return this.identifier ? this.identifier.getText() : '';
    };
    ModuleConfiguration.prototype.setValue = function (node) {
        return this.setNode('value', node, 0);
    };
    ModuleConfiguration.prototype.getValue = function () {
        return this.value;
    };
    return ModuleConfiguration;
}(Node));

var Forward = /** @class */ (function (_super) {
    __extends(Forward, _super);
    function Forward() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Object.defineProperty(Forward.prototype, "type", {
        get: function () {
            return NodeType.Forward;
        },
        enumerable: true,
        configurable: true
    });
    Forward.prototype.setIdentifier = function (node) {
        return this.setNode('identifier', node, 0);
    };
    Forward.prototype.getIdentifier = function () {
        return this.identifier;
    };
    return Forward;
}(Node));

var ForwardVisibility = /** @class */ (function (_super) {
    __extends(ForwardVisibility, _super);
    function ForwardVisibility() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Object.defineProperty(ForwardVisibility.prototype, "type", {
        get: function () {
            return NodeType.ForwardVisibility;
        },
        enumerable: true,
        configurable: true
    });
    ForwardVisibility.prototype.setIdentifier = function (node) {
        return this.setNode('identifier', node, 0);
    };
    ForwardVisibility.prototype.getIdentifier = function () {
        return this.identifier;
    };
    return ForwardVisibility;
}(Node));

var Namespace = /** @class */ (function (_super) {
    __extends(Namespace, _super);
    function Namespace(offset, length) {
        return _super.call(this, offset, length) || this;
    }
    Object.defineProperty(Namespace.prototype, "type", {
        get: function () {
            return NodeType.Namespace;
        },
        enumerable: true,
        configurable: true
    });
    return Namespace;
}(Node));

var Media = /** @class */ (function (_super) {
    __extends(Media, _super);
    function Media(offset, length) {
        return _super.call(this, offset, length) || this;
    }
    Object.defineProperty(Media.prototype, "type", {
        get: function () {
            return NodeType.Media;
        },
        enumerable: true,
        configurable: true
    });
    return Media;
}(BodyDeclaration));

var Supports = /** @class */ (function (_super) {
    __extends(Supports, _super);
    function Supports(offset, length) {
        return _super.call(this, offset, length) || this;
    }
    Object.defineProperty(Supports.prototype, "type", {
        get: function () {
            return NodeType.Supports;
        },
        enumerable: true,
        configurable: true
    });
    return Supports;
}(BodyDeclaration));

var Document = /** @class */ (function (_super) {
    __extends(Document, _super);
    function Document(offset, length) {
        return _super.call(this, offset, length) || this;
    }
    Object.defineProperty(Document.prototype, "type", {
        get: function () {
            return NodeType.Document;
        },
        enumerable: true,
        configurable: true
    });
    return Document;
}(BodyDeclaration));

var Medialist = /** @class */ (function (_super) {
    __extends(Medialist, _super);
    function Medialist(offset, length) {
        return _super.call(this, offset, length) || this;
    }
    Medialist.prototype.getMediums = function () {
        if (!this.mediums) {
            this.mediums = new Nodelist(this);
        }
        return this.mediums;
    };
    return Medialist;
}(Node));

var MediaQuery = /** @class */ (function (_super) {
    __extends(MediaQuery, _super);
    function MediaQuery(offset, length) {
        return _super.call(this, offset, length) || this;
    }
    Object.defineProperty(MediaQuery.prototype, "type", {
        get: function () {
            return NodeType.MediaQuery;
        },
        enumerable: true,
        configurable: true
    });
    return MediaQuery;
}(Node));

var SupportsCondition = /** @class */ (function (_super) {
    __extends(SupportsCondition, _super);
    function SupportsCondition(offset, length) {
        return _super.call(this, offset, length) || this;
    }
    Object.defineProperty(SupportsCondition.prototype, "type", {
        get: function () {
            return NodeType.SupportsCondition;
        },
        enumerable: true,
        configurable: true
    });
    return SupportsCondition;
}(Node));

var Page = /** @class */ (function (_super) {
    __extends(Page, _super);
    function Page(offset, length) {
        return _super.call(this, offset, length) || this;
    }
    Object.defineProperty(Page.prototype, "type", {
        get: function () {
            return NodeType.Page;
        },
        enumerable: true,
        configurable: true
    });
    return Page;
}(BodyDeclaration));

var PageBoxMarginBox = /** @class */ (function (_super) {
    __extends(PageBoxMarginBox, _super);
    function PageBoxMarginBox(offset, length) {
        return _super.call(this, offset, length) || this;
    }
    Object.defineProperty(PageBoxMarginBox.prototype, "type", {
        get: function () {
            return NodeType.PageBoxMarginBox;
        },
        enumerable: true,
        configurable: true
    });
    return PageBoxMarginBox;
}(BodyDeclaration));

var Expression = /** @class */ (function (_super) {
    __extends(Expression, _super);
    function Expression(offset, length) {
        return _super.call(this, offset, length) || this;
    }
    Object.defineProperty(Expression.prototype, "type", {
        get: function () {
            return NodeType.Expression;
        },
        enumerable: true,
        configurable: true
    });
    return Expression;
}(Node));

var BinaryExpression = /** @class */ (function (_super) {
    __extends(BinaryExpression, _super);
    function BinaryExpression(offset, length) {
        return _super.call(this, offset, length) || this;
    }
    Object.defineProperty(BinaryExpression.prototype, "type", {
        get: function () {
            return NodeType.BinaryExpression;
        },
        enumerable: true,
        configurable: true
    });
    BinaryExpression.prototype.setLeft = function (left) {
        return this.setNode('left', left);
    };
    BinaryExpression.prototype.getLeft = function () {
        return this.left;
    };
    BinaryExpression.prototype.setRight = function (right) {
        return this.setNode('right', right);
    };
    BinaryExpression.prototype.getRight = function () {
        return this.right;
    };
    BinaryExpression.prototype.setOperator = function (value) {
        return this.setNode('operator', value);
    };
    BinaryExpression.prototype.getOperator = function () {
        return this.operator;
    };
    return BinaryExpression;
}(Node));

var Term = /** @class */ (function (_super) {
    __extends(Term, _super);
    function Term(offset, length) {
        return _super.call(this, offset, length) || this;
    }
    Object.defineProperty(Term.prototype, "type", {
        get: function () {
            return NodeType.Term;
        },
        enumerable: true,
        configurable: true
    });
    Term.prototype.setOperator = function (value) {
        return this.setNode('operator', value);
    };
    Term.prototype.getOperator = function () {
        return this.operator;
    };
    Term.prototype.setExpression = function (value) {
        return this.setNode('expression', value);
    };
    Term.prototype.getExpression = function () {
        return this.expression;
    };
    return Term;
}(Node));

var AttributeSelector = /** @class */ (function (_super) {
    __extends(AttributeSelector, _super);
    function AttributeSelector(offset, length) {
        return _super.call(this, offset, length) || this;
    }
    Object.defineProperty(AttributeSelector.prototype, "type", {
        get: function () {
            return NodeType.AttributeSelector;
        },
        enumerable: true,
        configurable: true
    });
    AttributeSelector.prototype.setNamespacePrefix = function (value) {
        return this.setNode('namespacePrefix', value);
    };
    AttributeSelector.prototype.getNamespacePrefix = function () {
        return this.namespacePrefix;
    };
    AttributeSelector.prototype.setIdentifier = function (value) {
        return this.setNode('identifier', value);
    };
    AttributeSelector.prototype.getIdentifier = function () {
        return this.identifier;
    };
    AttributeSelector.prototype.setOperator = function (operator) {
        return this.setNode('operator', operator);
    };
    AttributeSelector.prototype.getOperator = function () {
        return this.operator;
    };
    AttributeSelector.prototype.setValue = function (value) {
        return this.setNode('value', value);
    };
    AttributeSelector.prototype.getValue = function () {
        return this.value;
    };
    return AttributeSelector;
}(Node));

var Operator = /** @class */ (function (_super) {
    __extends(Operator, _super);
    function Operator(offset, length) {
        return _super.call(this, offset, length) || this;
    }
    Object.defineProperty(Operator.prototype, "type", {
        get: function () {
            return NodeType.Operator;
        },
        enumerable: true,
        configurable: true
    });
    return Operator;
}(Node));

var HexColorValue = /** @class */ (function (_super) {
    __extends(HexColorValue, _super);
    function HexColorValue(offset, length) {
        return _super.call(this, offset, length) || this;
    }
    Object.defineProperty(HexColorValue.prototype, "type", {
        get: function () {
            return NodeType.HexColorValue;
        },
        enumerable: true,
        configurable: true
    });
    return HexColorValue;
}(Node));

var _dot = '.'.charCodeAt(0), _0 = '0'.charCodeAt(0), _9 = '9'.charCodeAt(0);
var NumericValue = /** @class */ (function (_super) {
    __extends(NumericValue, _super);
    function NumericValue(offset, length) {
        return _super.call(this, offset, length) || this;
    }
    Object.defineProperty(NumericValue.prototype, "type", {
        get: function () {
            return NodeType.NumericValue;
        },
        enumerable: true,
        configurable: true
    });
    NumericValue.prototype.getValue = function () {
        var raw = this.getText();
        var unitIdx = 0;
        var code;
        for (var i = 0, len = raw.length; i < len; i++) {
            code = raw.charCodeAt(i);
            if (!(_0 <= code && code <= _9 || code === _dot)) {
                break;
            }
            unitIdx += 1;
        }
        return {
            value: raw.substring(0, unitIdx),
            unit: unitIdx < raw.length ? raw.substring(unitIdx) : undefined
        };
    };
    return NumericValue;
}(Node));

var VariableDeclaration = /** @class */ (function (_super) {
    __extends(VariableDeclaration, _super);
    function VariableDeclaration(offset, length) {
        var _this = _super.call(this, offset, length) || this;
        _this.variable = null;
        _this.value = null;
        _this.needsSemicolon = true;
        return _this;
    }
    Object.defineProperty(VariableDeclaration.prototype, "type", {
        get: function () {
            return NodeType.VariableDeclaration;
        },
        enumerable: true,
        configurable: true
    });
    VariableDeclaration.prototype.setVariable = function (node) {
        if (node) {
            node.attachTo(this);
            this.variable = node;
            return true;
        }
        return false;
    };
    VariableDeclaration.prototype.getVariable = function () {
        return this.variable;
    };
    VariableDeclaration.prototype.getName = function () {
        return this.variable ? this.variable.getName() : '';
    };
    VariableDeclaration.prototype.setValue = function (node) {
        if (node) {
            node.attachTo(this);
            this.value = node;
            return true;
        }
        return false;
    };
    VariableDeclaration.prototype.getValue = function () {
        return this.value;
    };
    return VariableDeclaration;
}(AbstractDeclaration));

var Interpolation = /** @class */ (function (_super) {
    __extends(Interpolation, _super);
    // private _interpolations: void; // workaround for https://github.com/Microsoft/TypeScript/issues/18276
    function Interpolation(offset, length) {
        return _super.call(this, offset, length) || this;
    }
    Object.defineProperty(Interpolation.prototype, "type", {
        get: function () {
            return NodeType.Interpolation;
        },
        enumerable: true,
        configurable: true
    });
    return Interpolation;
}(Node));

var Variable = /** @class */ (function (_super) {
    __extends(Variable, _super);
    function Variable(offset, length) {
        return _super.call(this, offset, length) || this;
    }
    Object.defineProperty(Variable.prototype, "type", {
        get: function () {
            return NodeType.VariableName;
        },
        enumerable: true,
        configurable: true
    });
    Variable.prototype.getName = function () {
        return this.getText();
    };
    return Variable;
}(Node));

var ExtendsReference = /** @class */ (function (_super) {
    __extends(ExtendsReference, _super);
    function ExtendsReference(offset, length) {
        return _super.call(this, offset, length) || this;
    }
    Object.defineProperty(ExtendsReference.prototype, "type", {
        get: function () {
            return NodeType.ExtendsReference;
        },
        enumerable: true,
        configurable: true
    });
    ExtendsReference.prototype.getSelectors = function () {
        if (!this.selectors) {
            this.selectors = new Nodelist(this);
        }
        return this.selectors;
    };
    return ExtendsReference;
}(Node));

var MixinReference = /** @class */ (function (_super) {
    __extends(MixinReference, _super);
    function MixinReference(offset, length) {
        return _super.call(this, offset, length) || this;
    }
    Object.defineProperty(MixinReference.prototype, "type", {
        get: function () {
            return NodeType.MixinReference;
        },
        enumerable: true,
        configurable: true
    });
    MixinReference.prototype.getNamespaces = function () {
        if (!this.namespaces) {
            this.namespaces = new Nodelist(this);
        }
        return this.namespaces;
    };
    MixinReference.prototype.setIdentifier = function (node) {
        return this.setNode('identifier', node, 0);
    };
    MixinReference.prototype.getIdentifier = function () {
        return this.identifier;
    };
    MixinReference.prototype.getName = function () {
        return this.identifier ? this.identifier.getText() : '';
    };
    MixinReference.prototype.getArguments = function () {
        if (!this.arguments) {
            this.arguments = new Nodelist(this);
        }
        return this.arguments;
    };
    MixinReference.prototype.setContent = function (node) {
        return this.setNode('content', node);
    };
    MixinReference.prototype.getContent = function () {
        return this.content;
    };
    return MixinReference;
}(Node));

var MixinDeclaration = /** @class */ (function (_super) {
    __extends(MixinDeclaration, _super);
    function MixinDeclaration(offset, length) {
        return _super.call(this, offset, length) || this;
    }
    Object.defineProperty(MixinDeclaration.prototype, "type", {
        get: function () {
            return NodeType.MixinDeclaration;
        },
        enumerable: true,
        configurable: true
    });
    MixinDeclaration.prototype.setIdentifier = function (node) {
        return this.setNode('identifier', node, 0);
    };
    MixinDeclaration.prototype.getIdentifier = function () {
        return this.identifier;
    };
    MixinDeclaration.prototype.getName = function () {
        return this.identifier ? this.identifier.getText() : '';
    };
    MixinDeclaration.prototype.getParameters = function () {
        if (!this.parameters) {
            this.parameters = new Nodelist(this);
        }
        return this.parameters;
    };
    MixinDeclaration.prototype.setGuard = function (node) {
        if (node) {
            node.attachTo(this);
            this.guard = node;
        }
        return false;
    };
    return MixinDeclaration;
}(BodyDeclaration));

var UnknownAtRule = /** @class */ (function (_super) {
    __extends(UnknownAtRule, _super);
    function UnknownAtRule(offset, length) {
        return _super.call(this, offset, length) || this;
    }
    Object.defineProperty(UnknownAtRule.prototype, "type", {
        get: function () {
            return NodeType.UnknownAtRule;
        },
        enumerable: true,
        configurable: true
    });
    UnknownAtRule.prototype.setAtRuleName = function (atRuleName) {
        this.atRuleName = atRuleName;
    };
    UnknownAtRule.prototype.getAtRuleName = function () {
        return this.atRuleName;
    };
    return UnknownAtRule;
}(BodyDeclaration));

var ListEntry = /** @class */ (function (_super) {
    __extends(ListEntry, _super);
    function ListEntry() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Object.defineProperty(ListEntry.prototype, "type", {
        get: function () {
            return NodeType.ListEntry;
        },
        enumerable: true,
        configurable: true
    });
    ListEntry.prototype.setKey = function (node) {
        return this.setNode('key', node, 0);
    };
    ListEntry.prototype.setValue = function (node) {
        return this.setNode('value', node, 1);
    };
    return ListEntry;
}(Node));

var LessGuard = /** @class */ (function (_super) {
    __extends(LessGuard, _super);
    function LessGuard() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    LessGuard.prototype.getConditions = function () {
        if (!this.conditions) {
            this.conditions = new Nodelist(this);
        }
        return this.conditions;
    };
    return LessGuard;
}(Node));

var GuardCondition = /** @class */ (function (_super) {
    __extends(GuardCondition, _super);
    function GuardCondition() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    GuardCondition.prototype.setVariable = function (node) {
        return this.setNode('variable', node);
    };
    return GuardCondition;
}(Node));

var Module = /** @class */ (function (_super) {
    __extends(Module, _super);
    function Module() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Object.defineProperty(Module.prototype, "type", {
        get: function () {
            return NodeType.Module;
        },
        enumerable: true,
        configurable: true
    });
    Module.prototype.setIdentifier = function (node) {
        return this.setNode('identifier', node, 0);
    };
    Module.prototype.getIdentifier = function () {
        return this.identifier;
    };
    return Module;
}(Node));

var Level;
(function (Level) {
    Level[Level["Ignore"] = 1] = "Ignore";
    Level[Level["Warning"] = 2] = "Warning";
    Level[Level["Error"] = 4] = "Error";
})(Level || (Level = {}));
var Marker = /** @class */ (function () {
    function Marker(node, rule, level, message, offset, length) {
        if (offset === void 0) { offset = node.offset; }
        if (length === void 0) { length = node.length; }
        this.node = node;
        this.rule = rule;
        this.level = level;
        this.message = message || rule.message;
        this.offset = offset;
        this.length = length;
    }
    Marker.prototype.getRule = function () {
        return this.rule;
    };
    Marker.prototype.getLevel = function () {
        return this.level;
    };
    Marker.prototype.getOffset = function () {
        return this.offset;
    };
    Marker.prototype.getLength = function () {
        return this.length;
    };
    Marker.prototype.getNode = function () {
        return this.node;
    };
    Marker.prototype.getMessage = function () {
        return this.message;
    };
    return Marker;
}());

/*
export class DefaultVisitor implements IVisitor {

    public visitNode(node:Node):boolean {
        switch (node.type) {
            case NodeType.Stylesheet:
                return this.visitStylesheet(<Stylesheet> node);
            case NodeType.FontFace:
                return this.visitFontFace(<FontFace> node);
            case NodeType.Ruleset:
                return this.visitRuleSet(<RuleSet> node);
            case NodeType.Selector:
                return this.visitSelector(<Selector> node);
            case NodeType.SimpleSelector:
                return this.visitSimpleSelector(<SimpleSelector> node);
            case NodeType.Declaration:
                return this.visitDeclaration(<Declaration> node);
            case NodeType.Function:
                return this.visitFunction(<Function> node);
            case NodeType.FunctionDeclaration:
                return this.visitFunctionDeclaration(<FunctionDeclaration> node);
            case NodeType.FunctionParameter:
                return this.visitFunctionParameter(<FunctionParameter> node);
            case NodeType.FunctionArgument:
                return this.visitFunctionArgument(<FunctionArgument> node);
            case NodeType.Term:
                return this.visitTerm(<Term> node);
            case NodeType.Declaration:
                return this.visitExpression(<Expression> node);
            case NodeType.NumericValue:
                return this.visitNumericValue(<NumericValue> node);
            case NodeType.Page:
                return this.visitPage(<Page> node);
            case NodeType.PageBoxMarginBox:
                return this.visitPageBoxMarginBox(<PageBoxMarginBox> node);
            case NodeType.Property:
                return this.visitProperty(<Property> node);
            case NodeType.NumericValue:
                return this.visitNodelist(<Nodelist> node);
            case NodeType.Import:
                return this.visitImport(<Import> node);
            case NodeType.Namespace:
                return this.visitNamespace(<Namespace> node);
            case NodeType.Keyframe:
                return this.visitKeyframe(<Keyframe> node);
            case NodeType.KeyframeSelector:
                return this.visitKeyframeSelector(<KeyframeSelector> node);
            case NodeType.MixinDeclaration:
                return this.visitMixinDeclaration(<MixinDeclaration> node);
            case NodeType.MixinReference:
                return this.visitMixinReference(<MixinReference> node);
            case NodeType.Variable:
                return this.visitVariable(<Variable> node);
            case NodeType.VariableDeclaration:
                return this.visitVariableDeclaration(<VariableDeclaration> node);
        }
        return this.visitUnknownNode(node);
    }

    public visitFontFace(node:FontFace):boolean {
        return true;
    }

    public visitKeyframe(node:Keyframe):boolean {
        return true;
    }

    public visitKeyframeSelector(node:KeyframeSelector):boolean {
        return true;
    }

    public visitStylesheet(node:Stylesheet):boolean {
        return true;
    }

    public visitProperty(Node:Property):boolean {
        return true;
    }

    public visitRuleSet(node:RuleSet):boolean {
        return true;
    }

    public visitSelector(node:Selector):boolean {
        return true;
    }

    public visitSimpleSelector(node:SimpleSelector):boolean {
        return true;
    }

    public visitDeclaration(node:Declaration):boolean {
        return true;
    }

    public visitFunction(node:Function):boolean {
        return true;
    }

    public visitFunctionDeclaration(node:FunctionDeclaration):boolean {
        return true;
    }

    public visitInvocation(node:Invocation):boolean {
        return true;
    }

    public visitTerm(node:Term):boolean {
        return true;
    }

    public visitImport(node:Import):boolean {
        return true;
    }

    public visitNamespace(node:Namespace):boolean {
        return true;
    }

    public visitExpression(node:Expression):boolean {
        return true;
    }

    public visitNumericValue(node:NumericValue):boolean {
        return true;
    }

    public visitPage(node:Page):boolean {
        return true;
    }

    public visitPageBoxMarginBox(node:PageBoxMarginBox):boolean {
        return true;
    }

    public visitNodelist(node:Nodelist):boolean {
        return true;
    }

    public visitVariableDeclaration(node:VariableDeclaration):boolean {
        return true;
    }

    public visitVariable(node:Variable):boolean {
        return true;
    }

    public visitMixinDeclaration(node:MixinDeclaration):boolean {
        return true;
    }

    public visitMixinReference(node:MixinReference):boolean {
        return true;
    }

    public visitUnknownNode(node:Node):boolean {
        return true;
    }
}
*/
var ParseErrorCollector = /** @class */ (function () {
    function ParseErrorCollector() {
        this.entries = [];
    }
    ParseErrorCollector.entries = function (node) {
        var visitor = new ParseErrorCollector();
        node.acceptVisitor(visitor);
        return visitor.entries;
    };
    ParseErrorCollector.prototype.visitNode = function (node) {
        if (node.isErroneous()) {
            node.collectIssues(this.entries);
        }
        return true;
    };
    return ParseErrorCollector;
}());



/***/ }),
/* 37 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "b", function() { return ViewPart; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return PartFingerprints; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__base_browser_fastDomNode_js__ = __webpack_require__(26);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__common_viewModel_viewEventHandler_js__ = __webpack_require__(106);
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();


var ViewPart = /** @class */ (function (_super) {
    __extends(ViewPart, _super);
    function ViewPart(context) {
        var _this = _super.call(this) || this;
        _this._context = context;
        _this._context.addEventHandler(_this);
        return _this;
    }
    ViewPart.prototype.dispose = function () {
        this._context.removeEventHandler(this);
        _super.prototype.dispose.call(this);
    };
    return ViewPart;
}(__WEBPACK_IMPORTED_MODULE_1__common_viewModel_viewEventHandler_js__["a" /* ViewEventHandler */]));

var PartFingerprints = /** @class */ (function () {
    function PartFingerprints() {
    }
    PartFingerprints.write = function (target, partId) {
        if (target instanceof __WEBPACK_IMPORTED_MODULE_0__base_browser_fastDomNode_js__["a" /* FastDomNode */]) {
            target.setAttribute('data-mprt', String(partId));
        }
        else {
            target.setAttribute('data-mprt', String(partId));
        }
    };
    PartFingerprints.read = function (target) {
        var r = target.getAttribute('data-mprt');
        if (r === null) {
            return 0 /* None */;
        }
        return parseInt(r, 10);
    };
    PartFingerprints.collect = function (child, stopAt) {
        var result = [], resultLen = 0;
        while (child && child !== document.body) {
            if (child === stopAt) {
                break;
            }
            if (child.nodeType === child.ELEMENT_NODE) {
                result[resultLen++] = this.read(child);
            }
            child = child.parentElement;
        }
        var r = new Uint8Array(resultLen);
        for (var i = 0; i < resultLen; i++) {
            r[i] = result[resultLen - i - 1];
        }
        return r;
    };
    return PartFingerprints;
}());



/***/ }),
/* 38 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (immutable) */ __webpack_exports__["e"] = values;
/* harmony export (immutable) */ __webpack_exports__["d"] = keys;
/* unused harmony export StringIterator */
/* unused harmony export PathIterator */
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "c", function() { return TernarySearchTree; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "b", function() { return ResourceMap; });
/* unused harmony export LinkedMap */
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return LRUCache; });
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
function values(forEachable) {
    var result = [];
    forEachable.forEach(function (value) { return result.push(value); });
    return result;
}
function keys(map) {
    var result = [];
    map.forEach(function (_value, key) { return result.push(key); });
    return result;
}
var StringIterator = /** @class */ (function () {
    function StringIterator() {
        this._value = '';
        this._pos = 0;
    }
    StringIterator.prototype.reset = function (key) {
        this._value = key;
        this._pos = 0;
        return this;
    };
    StringIterator.prototype.next = function () {
        this._pos += 1;
        return this;
    };
    StringIterator.prototype.hasNext = function () {
        return this._pos < this._value.length - 1;
    };
    StringIterator.prototype.cmp = function (a) {
        var aCode = a.charCodeAt(0);
        var thisCode = this._value.charCodeAt(this._pos);
        return aCode - thisCode;
    };
    StringIterator.prototype.value = function () {
        return this._value[this._pos];
    };
    return StringIterator;
}());

var PathIterator = /** @class */ (function () {
    function PathIterator(_splitOnBackslash) {
        if (_splitOnBackslash === void 0) { _splitOnBackslash = true; }
        this._splitOnBackslash = _splitOnBackslash;
    }
    PathIterator.prototype.reset = function (key) {
        this._value = key.replace(/\\$|\/$/, '');
        this._from = 0;
        this._to = 0;
        return this.next();
    };
    PathIterator.prototype.hasNext = function () {
        return this._to < this._value.length;
    };
    PathIterator.prototype.next = function () {
        // this._data = key.split(/[\\/]/).filter(s => !!s);
        this._from = this._to;
        var justSeps = true;
        for (; this._to < this._value.length; this._to++) {
            var ch = this._value.charCodeAt(this._to);
            if (ch === 47 /* Slash */ || this._splitOnBackslash && ch === 92 /* Backslash */) {
                if (justSeps) {
                    this._from++;
                }
                else {
                    break;
                }
            }
            else {
                justSeps = false;
            }
        }
        return this;
    };
    PathIterator.prototype.cmp = function (a) {
        var aPos = 0;
        var aLen = a.length;
        var thisPos = this._from;
        while (aPos < aLen && thisPos < this._to) {
            var cmp = a.charCodeAt(aPos) - this._value.charCodeAt(thisPos);
            if (cmp !== 0) {
                return cmp;
            }
            aPos += 1;
            thisPos += 1;
        }
        if (aLen === this._to - this._from) {
            return 0;
        }
        else if (aPos < aLen) {
            return -1;
        }
        else {
            return 1;
        }
    };
    PathIterator.prototype.value = function () {
        return this._value.substring(this._from, this._to);
    };
    return PathIterator;
}());

var TernarySearchTreeNode = /** @class */ (function () {
    function TernarySearchTreeNode() {
    }
    return TernarySearchTreeNode;
}());
var TernarySearchTree = /** @class */ (function () {
    function TernarySearchTree(segments) {
        this._iter = segments;
    }
    TernarySearchTree.forPaths = function () {
        return new TernarySearchTree(new PathIterator());
    };
    TernarySearchTree.forStrings = function () {
        return new TernarySearchTree(new StringIterator());
    };
    TernarySearchTree.prototype.clear = function () {
        this._root = undefined;
    };
    TernarySearchTree.prototype.set = function (key, element) {
        var iter = this._iter.reset(key);
        var node;
        if (!this._root) {
            this._root = new TernarySearchTreeNode();
            this._root.segment = iter.value();
        }
        node = this._root;
        while (true) {
            var val = iter.cmp(node.segment);
            if (val > 0) {
                // left
                if (!node.left) {
                    node.left = new TernarySearchTreeNode();
                    node.left.segment = iter.value();
                }
                node = node.left;
            }
            else if (val < 0) {
                // right
                if (!node.right) {
                    node.right = new TernarySearchTreeNode();
                    node.right.segment = iter.value();
                }
                node = node.right;
            }
            else if (iter.hasNext()) {
                // mid
                iter.next();
                if (!node.mid) {
                    node.mid = new TernarySearchTreeNode();
                    node.mid.segment = iter.value();
                }
                node = node.mid;
            }
            else {
                break;
            }
        }
        var oldElement = node.value;
        node.value = element;
        node.key = key;
        return oldElement;
    };
    TernarySearchTree.prototype.get = function (key) {
        var iter = this._iter.reset(key);
        var node = this._root;
        while (node) {
            var val = iter.cmp(node.segment);
            if (val > 0) {
                // left
                node = node.left;
            }
            else if (val < 0) {
                // right
                node = node.right;
            }
            else if (iter.hasNext()) {
                // mid
                iter.next();
                node = node.mid;
            }
            else {
                break;
            }
        }
        return node ? node.value : undefined;
    };
    TernarySearchTree.prototype.findSubstr = function (key) {
        var iter = this._iter.reset(key);
        var node = this._root;
        var candidate = undefined;
        while (node) {
            var val = iter.cmp(node.segment);
            if (val > 0) {
                // left
                node = node.left;
            }
            else if (val < 0) {
                // right
                node = node.right;
            }
            else if (iter.hasNext()) {
                // mid
                iter.next();
                candidate = node.value || candidate;
                node = node.mid;
            }
            else {
                break;
            }
        }
        return node && node.value || candidate;
    };
    TernarySearchTree.prototype.forEach = function (callback) {
        this._forEach(this._root, callback);
    };
    TernarySearchTree.prototype._forEach = function (node, callback) {
        if (node) {
            // left
            this._forEach(node.left, callback);
            // node
            if (node.value) {
                // callback(node.value, this._iter.join(parts));
                callback(node.value, node.key);
            }
            // mid
            this._forEach(node.mid, callback);
            // right
            this._forEach(node.right, callback);
        }
    };
    return TernarySearchTree;
}());

var ResourceMap = /** @class */ (function () {
    function ResourceMap() {
        this.map = new Map();
        this.ignoreCase = false; // in the future this should be an uri-comparator
    }
    ResourceMap.prototype.set = function (resource, value) {
        this.map.set(this.toKey(resource), value);
    };
    ResourceMap.prototype.get = function (resource) {
        return this.map.get(this.toKey(resource));
    };
    ResourceMap.prototype.toKey = function (resource) {
        var key = resource.toString();
        if (this.ignoreCase) {
            key = key.toLowerCase();
        }
        return key;
    };
    return ResourceMap;
}());

var LinkedMap = /** @class */ (function () {
    function LinkedMap() {
        this._map = new Map();
        this._head = undefined;
        this._tail = undefined;
        this._size = 0;
    }
    LinkedMap.prototype.clear = function () {
        this._map.clear();
        this._head = undefined;
        this._tail = undefined;
        this._size = 0;
    };
    Object.defineProperty(LinkedMap.prototype, "size", {
        get: function () {
            return this._size;
        },
        enumerable: true,
        configurable: true
    });
    LinkedMap.prototype.get = function (key, touch) {
        if (touch === void 0) { touch = 0 /* None */; }
        var item = this._map.get(key);
        if (!item) {
            return undefined;
        }
        if (touch !== 0 /* None */) {
            this.touch(item, touch);
        }
        return item.value;
    };
    LinkedMap.prototype.set = function (key, value, touch) {
        if (touch === void 0) { touch = 0 /* None */; }
        var item = this._map.get(key);
        if (item) {
            item.value = value;
            if (touch !== 0 /* None */) {
                this.touch(item, touch);
            }
        }
        else {
            item = { key: key, value: value, next: undefined, previous: undefined };
            switch (touch) {
                case 0 /* None */:
                    this.addItemLast(item);
                    break;
                case 1 /* AsOld */:
                    this.addItemFirst(item);
                    break;
                case 2 /* AsNew */:
                    this.addItemLast(item);
                    break;
                default:
                    this.addItemLast(item);
                    break;
            }
            this._map.set(key, item);
            this._size++;
        }
    };
    LinkedMap.prototype.delete = function (key) {
        return !!this.remove(key);
    };
    LinkedMap.prototype.remove = function (key) {
        var item = this._map.get(key);
        if (!item) {
            return undefined;
        }
        this._map.delete(key);
        this.removeItem(item);
        this._size--;
        return item.value;
    };
    LinkedMap.prototype.forEach = function (callbackfn, thisArg) {
        var current = this._head;
        while (current) {
            if (thisArg) {
                callbackfn.bind(thisArg)(current.value, current.key, this);
            }
            else {
                callbackfn(current.value, current.key, this);
            }
            current = current.next;
        }
    };
    /* VS Code / Monaco editor runs on es5 which has no Symbol.iterator
    keys(): IterableIterator<K> {
        const current = this._head;
        const iterator: IterableIterator<K> = {
            [Symbol.iterator]() {
                return iterator;
            },
            next():IteratorResult<K> {
                if (current) {
                    const result = { value: current.key, done: false };
                    current = current.next;
                    return result;
                } else {
                    return { value: undefined, done: true };
                }
            }
        };
        return iterator;
    }

    values(): IterableIterator<V> {
        const current = this._head;
        const iterator: IterableIterator<V> = {
            [Symbol.iterator]() {
                return iterator;
            },
            next():IteratorResult<V> {
                if (current) {
                    const result = { value: current.value, done: false };
                    current = current.next;
                    return result;
                } else {
                    return { value: undefined, done: true };
                }
            }
        };
        return iterator;
    }
    */
    LinkedMap.prototype.trimOld = function (newSize) {
        if (newSize >= this.size) {
            return;
        }
        if (newSize === 0) {
            this.clear();
            return;
        }
        var current = this._head;
        var currentSize = this.size;
        while (current && currentSize > newSize) {
            this._map.delete(current.key);
            current = current.next;
            currentSize--;
        }
        this._head = current;
        this._size = currentSize;
        if (current) {
            current.previous = undefined;
        }
    };
    LinkedMap.prototype.addItemFirst = function (item) {
        // First time Insert
        if (!this._head && !this._tail) {
            this._tail = item;
        }
        else if (!this._head) {
            throw new Error('Invalid list');
        }
        else {
            item.next = this._head;
            this._head.previous = item;
        }
        this._head = item;
    };
    LinkedMap.prototype.addItemLast = function (item) {
        // First time Insert
        if (!this._head && !this._tail) {
            this._head = item;
        }
        else if (!this._tail) {
            throw new Error('Invalid list');
        }
        else {
            item.previous = this._tail;
            this._tail.next = item;
        }
        this._tail = item;
    };
    LinkedMap.prototype.removeItem = function (item) {
        if (item === this._head && item === this._tail) {
            this._head = undefined;
            this._tail = undefined;
        }
        else if (item === this._head) {
            // This can only happend if size === 1 which is handle
            // by the case above.
            if (!item.next) {
                throw new Error('Invalid list');
            }
            item.next.previous = undefined;
            this._head = item.next;
        }
        else if (item === this._tail) {
            // This can only happend if size === 1 which is handle
            // by the case above.
            if (!item.previous) {
                throw new Error('Invalid list');
            }
            item.previous.next = undefined;
            this._tail = item.previous;
        }
        else {
            var next = item.next;
            var previous = item.previous;
            if (!next || !previous) {
                throw new Error('Invalid list');
            }
            next.previous = previous;
            previous.next = next;
        }
        item.next = undefined;
        item.previous = undefined;
    };
    LinkedMap.prototype.touch = function (item, touch) {
        if (!this._head || !this._tail) {
            throw new Error('Invalid list');
        }
        if ((touch !== 1 /* AsOld */ && touch !== 2 /* AsNew */)) {
            return;
        }
        if (touch === 1 /* AsOld */) {
            if (item === this._head) {
                return;
            }
            var next = item.next;
            var previous = item.previous;
            // Unlink the item
            if (item === this._tail) {
                // previous must be defined since item was not head but is tail
                // So there are more than on item in the map
                previous.next = undefined;
                this._tail = previous;
            }
            else {
                // Both next and previous are not undefined since item was neither head nor tail.
                next.previous = previous;
                previous.next = next;
            }
            // Insert the node at head
            item.previous = undefined;
            item.next = this._head;
            this._head.previous = item;
            this._head = item;
        }
        else if (touch === 2 /* AsNew */) {
            if (item === this._tail) {
                return;
            }
            var next = item.next;
            var previous = item.previous;
            // Unlink the item.
            if (item === this._head) {
                // next must be defined since item was not tail but is head
                // So there are more than on item in the map
                next.previous = undefined;
                this._head = next;
            }
            else {
                // Both next and previous are not undefined since item was neither head nor tail.
                next.previous = previous;
                previous.next = next;
            }
            item.next = undefined;
            item.previous = this._tail;
            this._tail.next = item;
            this._tail = item;
        }
    };
    LinkedMap.prototype.toJSON = function () {
        var data = [];
        this.forEach(function (value, key) {
            data.push([key, value]);
        });
        return data;
    };
    return LinkedMap;
}());

var LRUCache = /** @class */ (function (_super) {
    __extends(LRUCache, _super);
    function LRUCache(limit, ratio) {
        if (ratio === void 0) { ratio = 1; }
        var _this = _super.call(this) || this;
        _this._limit = limit;
        _this._ratio = Math.min(Math.max(0, ratio), 1);
        return _this;
    }
    LRUCache.prototype.get = function (key) {
        return _super.prototype.get.call(this, key, 2 /* AsNew */);
    };
    LRUCache.prototype.peek = function (key) {
        return _super.prototype.get.call(this, key, 0 /* None */);
    };
    LRUCache.prototype.set = function (key, value) {
        _super.prototype.set.call(this, key, value, 2 /* AsNew */);
        this.checkTrim();
    };
    LRUCache.prototype.checkTrim = function () {
        if (this.size > this._limit) {
            this.trimOld(Math.round(this._limit * this._ratio));
        }
    };
    return LRUCache;
}(LinkedMap));



/***/ }),
/* 39 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* unused harmony export hasToIgnoreCase */
/* harmony export (immutable) */ __webpack_exports__["c"] = basenameOrAuthority;
/* unused harmony export isEqualAuthority */
/* harmony export (immutable) */ __webpack_exports__["e"] = isEqual;
/* harmony export (immutable) */ __webpack_exports__["b"] = basename;
/* harmony export (immutable) */ __webpack_exports__["d"] = dirname;
/* harmony export (immutable) */ __webpack_exports__["f"] = joinPath;
/* harmony export (immutable) */ __webpack_exports__["g"] = normalizePath;
/* unused harmony export originalFSPath */
/* harmony export (immutable) */ __webpack_exports__["h"] = relativePath;
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return DataUri; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__extpath_js__ = __webpack_require__(310);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__path_js__ = __webpack_require__(90);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2__uri_js__ = __webpack_require__(24);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3__strings_js__ = __webpack_require__(4);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4__network_js__ = __webpack_require__(46);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5__platform_js__ = __webpack_require__(14);
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var __spreadArrays = (this && this.__spreadArrays) || function () {
    for (var s = 0, i = 0, il = arguments.length; i < il; i++) s += arguments[i].length;
    for (var r = Array(s), k = 0, i = 0; i < il; i++)
        for (var a = arguments[i], j = 0, jl = a.length; j < jl; j++, k++)
            r[k] = a[j];
    return r;
};






function hasToIgnoreCase(resource) {
    // A file scheme resource is in the same platform as code, so ignore case for non linux platforms
    // Resource can be from another platform. Lowering the case as an hack. Should come from File system provider
    return resource && resource.scheme === __WEBPACK_IMPORTED_MODULE_4__network_js__["b" /* Schemas */].file ? !__WEBPACK_IMPORTED_MODULE_5__platform_js__["d" /* isLinux */] : true;
}
function basenameOrAuthority(resource) {
    return basename(resource) || resource.authority;
}
/**
 * Tests wheter the two authorities are the same
 */
function isEqualAuthority(a1, a2) {
    return a1 === a2 || Object(__WEBPACK_IMPORTED_MODULE_3__strings_js__["n" /* equalsIgnoreCase */])(a1, a2);
}
function isEqual(first, second, ignoreCase) {
    if (ignoreCase === void 0) { ignoreCase = hasToIgnoreCase(first); }
    if (first === second) {
        return true;
    }
    if (!first || !second) {
        return false;
    }
    if (first.scheme !== second.scheme || !isEqualAuthority(first.authority, second.authority)) {
        return false;
    }
    var p1 = first.path || '/', p2 = second.path || '/';
    return p1 === p2 || ignoreCase && Object(__WEBPACK_IMPORTED_MODULE_3__strings_js__["n" /* equalsIgnoreCase */])(p1 || '/', p2 || '/');
}
function basename(resource) {
    return __WEBPACK_IMPORTED_MODULE_1__path_js__["posix"].basename(resource.path);
}
/**
 * Return a URI representing the directory of a URI path.
 *
 * @param resource The input URI.
 * @returns The URI representing the directory of the input URI.
 */
function dirname(resource) {
    if (resource.path.length === 0) {
        return resource;
    }
    if (resource.scheme === __WEBPACK_IMPORTED_MODULE_4__network_js__["b" /* Schemas */].file) {
        return __WEBPACK_IMPORTED_MODULE_2__uri_js__["a" /* URI */].file(__WEBPACK_IMPORTED_MODULE_1__path_js__["dirname"](originalFSPath(resource)));
    }
    var dirname = __WEBPACK_IMPORTED_MODULE_1__path_js__["posix"].dirname(resource.path);
    if (resource.authority && dirname.length && dirname.charCodeAt(0) !== 47 /* Slash */) {
        console.error("dirname(\"" + resource.toString + ")) resulted in a relative path");
        dirname = '/'; // If a URI contains an authority component, then the path component must either be empty or begin with a CharCode.Slash ("/") character
    }
    return resource.with({
        path: dirname
    });
}
/**
 * Join a URI path with path fragments and normalizes the resulting path.
 *
 * @param resource The input URI.
 * @param pathFragment The path fragment to add to the URI path.
 * @returns The resulting URI.
 */
function joinPath(resource) {
    var _a;
    var pathFragment = [];
    for (var _i = 1; _i < arguments.length; _i++) {
        pathFragment[_i - 1] = arguments[_i];
    }
    var joinedPath;
    if (resource.scheme === __WEBPACK_IMPORTED_MODULE_4__network_js__["b" /* Schemas */].file) {
        joinedPath = __WEBPACK_IMPORTED_MODULE_2__uri_js__["a" /* URI */].file(__WEBPACK_IMPORTED_MODULE_1__path_js__["join"].apply(__WEBPACK_IMPORTED_MODULE_1__path_js__, __spreadArrays([originalFSPath(resource)], pathFragment))).path;
    }
    else {
        joinedPath = (_a = __WEBPACK_IMPORTED_MODULE_1__path_js__["posix"]).join.apply(_a, __spreadArrays([resource.path || '/'], pathFragment));
    }
    return resource.with({
        path: joinedPath
    });
}
/**
 * Normalizes the path part of a URI: Resolves `.` and `..` elements with directory names.
 *
 * @param resource The URI to normalize the path.
 * @returns The URI with the normalized path.
 */
function normalizePath(resource) {
    if (!resource.path.length) {
        return resource;
    }
    var normalizedPath;
    if (resource.scheme === __WEBPACK_IMPORTED_MODULE_4__network_js__["b" /* Schemas */].file) {
        normalizedPath = __WEBPACK_IMPORTED_MODULE_2__uri_js__["a" /* URI */].file(__WEBPACK_IMPORTED_MODULE_1__path_js__["normalize"](originalFSPath(resource))).path;
    }
    else {
        normalizedPath = __WEBPACK_IMPORTED_MODULE_1__path_js__["posix"].normalize(resource.path);
    }
    return resource.with({
        path: normalizedPath
    });
}
/**
 * Returns the fsPath of an URI where the drive letter is not normalized.
 * See #56403.
 */
function originalFSPath(uri) {
    var value;
    var uriPath = uri.path;
    if (uri.authority && uriPath.length > 1 && uri.scheme === __WEBPACK_IMPORTED_MODULE_4__network_js__["b" /* Schemas */].file) {
        // unc path: file://shares/c$/far/boo
        value = "//" + uri.authority + uriPath;
    }
    else if (__WEBPACK_IMPORTED_MODULE_5__platform_js__["h" /* isWindows */]
        && uriPath.charCodeAt(0) === 47 /* Slash */
        && __WEBPACK_IMPORTED_MODULE_0__extpath_js__["b" /* isWindowsDriveLetter */](uriPath.charCodeAt(1))
        && uriPath.charCodeAt(2) === 58 /* Colon */) {
        value = uriPath.substr(1);
    }
    else {
        // other path
        value = uriPath;
    }
    if (__WEBPACK_IMPORTED_MODULE_5__platform_js__["h" /* isWindows */]) {
        value = value.replace(/\//g, '\\');
    }
    return value;
}
/**
 * Returns a relative path between two URIs. If the URIs don't have the same schema or authority, `undefined` is returned.
 * The returned relative path always uses forward slashes.
 */
function relativePath(from, to, ignoreCase) {
    if (ignoreCase === void 0) { ignoreCase = hasToIgnoreCase(from); }
    if (from.scheme !== to.scheme || !isEqualAuthority(from.authority, to.authority)) {
        return undefined;
    }
    if (from.scheme === __WEBPACK_IMPORTED_MODULE_4__network_js__["b" /* Schemas */].file) {
        var relativePath_1 = __WEBPACK_IMPORTED_MODULE_1__path_js__["relative"](from.path, to.path);
        return __WEBPACK_IMPORTED_MODULE_5__platform_js__["h" /* isWindows */] ? __WEBPACK_IMPORTED_MODULE_0__extpath_js__["c" /* toSlashes */](relativePath_1) : relativePath_1;
    }
    var fromPath = from.path || '/', toPath = to.path || '/';
    if (ignoreCase) {
        // make casing of fromPath match toPath
        var i = 0;
        for (var len = Math.min(fromPath.length, toPath.length); i < len; i++) {
            if (fromPath.charCodeAt(i) !== toPath.charCodeAt(i)) {
                if (fromPath.charAt(i).toLowerCase() !== toPath.charAt(i).toLowerCase()) {
                    break;
                }
            }
        }
        fromPath = toPath.substr(0, i) + fromPath.substr(i);
    }
    return __WEBPACK_IMPORTED_MODULE_1__path_js__["posix"].relative(fromPath, toPath);
}
/**
 * Data URI related helpers.
 */
var DataUri;
(function (DataUri) {
    DataUri.META_DATA_LABEL = 'label';
    DataUri.META_DATA_DESCRIPTION = 'description';
    DataUri.META_DATA_SIZE = 'size';
    DataUri.META_DATA_MIME = 'mime';
    function parseMetaData(dataUri) {
        var metadata = new Map();
        // Given a URI of:  data:image/png;size:2313;label:SomeLabel;description:SomeDescription;base64,77+9UE5...
        // the metadata is: size:2313;label:SomeLabel;description:SomeDescription
        var meta = dataUri.path.substring(dataUri.path.indexOf(';') + 1, dataUri.path.lastIndexOf(';'));
        meta.split(';').forEach(function (property) {
            var _a = property.split(':'), key = _a[0], value = _a[1];
            if (key && value) {
                metadata.set(key, value);
            }
        });
        // Given a URI of:  data:image/png;size:2313;label:SomeLabel;description:SomeDescription;base64,77+9UE5...
        // the mime is: image/png
        var mime = dataUri.path.substring(0, dataUri.path.indexOf(';'));
        if (mime) {
            metadata.set(DataUri.META_DATA_MIME, mime);
        }
        return metadata;
    }
    DataUri.parseMetaData = parseMetaData;
})(DataUri || (DataUri = {}));


/***/ }),
/* 40 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "b", function() { return CursorConfiguration; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "f", function() { return SingleCursorState; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "c", function() { return CursorContext; });
/* unused harmony export PartialModelCursorState */
/* unused harmony export PartialViewCursorState */
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "d", function() { return CursorState; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "e", function() { return EditOperationResult; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return CursorColumns; });
/* harmony export (immutable) */ __webpack_exports__["g"] = isQuote;
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__base_common_errors_js__ = __webpack_require__(8);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__base_common_strings_js__ = __webpack_require__(4);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2__core_position_js__ = __webpack_require__(12);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3__core_range_js__ = __webpack_require__(1);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4__core_selection_js__ = __webpack_require__(21);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5__model_textModel_js__ = __webpack_require__(29);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6__modes_languageConfigurationRegistry_js__ = __webpack_require__(42);
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/







var autoCloseAlways = function () { return true; };
var autoCloseNever = function () { return false; };
var autoCloseBeforeWhitespace = function (chr) { return (chr === ' ' || chr === '\t'); };
function appendEntry(target, key, value) {
    if (target.has(key)) {
        target.get(key).push(value);
    }
    else {
        target.set(key, [value]);
    }
}
var CursorConfiguration = /** @class */ (function () {
    function CursorConfiguration(languageIdentifier, modelOptions, configuration) {
        this._languageIdentifier = languageIdentifier;
        var options = configuration.options;
        var layoutInfo = options.get(107 /* layoutInfo */);
        this.readOnly = options.get(68 /* readOnly */);
        this.tabSize = modelOptions.tabSize;
        this.indentSize = modelOptions.indentSize;
        this.insertSpaces = modelOptions.insertSpaces;
        this.lineHeight = options.get(49 /* lineHeight */);
        this.pageSize = Math.max(1, Math.floor(layoutInfo.height / this.lineHeight) - 2);
        this.useTabStops = options.get(95 /* useTabStops */);
        this.wordSeparators = options.get(96 /* wordSeparators */);
        this.emptySelectionClipboard = options.get(25 /* emptySelectionClipboard */);
        this.copyWithSyntaxHighlighting = options.get(15 /* copyWithSyntaxHighlighting */);
        this.multiCursorMergeOverlapping = options.get(58 /* multiCursorMergeOverlapping */);
        this.multiCursorPaste = options.get(60 /* multiCursorPaste */);
        this.autoClosingBrackets = options.get(5 /* autoClosingBrackets */);
        this.autoClosingQuotes = options.get(7 /* autoClosingQuotes */);
        this.autoClosingOvertype = options.get(6 /* autoClosingOvertype */);
        this.autoSurround = options.get(10 /* autoSurround */);
        this.autoIndent = options.get(8 /* autoIndent */);
        this.autoClosingPairsOpen2 = new Map();
        this.autoClosingPairsClose2 = new Map();
        this.surroundingPairs = {};
        this._electricChars = null;
        this.shouldAutoCloseBefore = {
            quote: CursorConfiguration._getShouldAutoClose(languageIdentifier, this.autoClosingQuotes),
            bracket: CursorConfiguration._getShouldAutoClose(languageIdentifier, this.autoClosingBrackets)
        };
        var autoClosingPairs = CursorConfiguration._getAutoClosingPairs(languageIdentifier);
        if (autoClosingPairs) {
            for (var _i = 0, autoClosingPairs_1 = autoClosingPairs; _i < autoClosingPairs_1.length; _i++) {
                var pair = autoClosingPairs_1[_i];
                appendEntry(this.autoClosingPairsOpen2, pair.open.charAt(pair.open.length - 1), pair);
                if (pair.close.length === 1) {
                    appendEntry(this.autoClosingPairsClose2, pair.close, pair);
                }
            }
        }
        var surroundingPairs = CursorConfiguration._getSurroundingPairs(languageIdentifier);
        if (surroundingPairs) {
            for (var _a = 0, surroundingPairs_1 = surroundingPairs; _a < surroundingPairs_1.length; _a++) {
                var pair = surroundingPairs_1[_a];
                this.surroundingPairs[pair.open] = pair.close;
            }
        }
    }
    CursorConfiguration.shouldRecreate = function (e) {
        return (e.hasChanged(107 /* layoutInfo */)
            || e.hasChanged(96 /* wordSeparators */)
            || e.hasChanged(25 /* emptySelectionClipboard */)
            || e.hasChanged(58 /* multiCursorMergeOverlapping */)
            || e.hasChanged(60 /* multiCursorPaste */)
            || e.hasChanged(5 /* autoClosingBrackets */)
            || e.hasChanged(7 /* autoClosingQuotes */)
            || e.hasChanged(6 /* autoClosingOvertype */)
            || e.hasChanged(10 /* autoSurround */)
            || e.hasChanged(95 /* useTabStops */)
            || e.hasChanged(49 /* lineHeight */)
            || e.hasChanged(68 /* readOnly */));
    };
    Object.defineProperty(CursorConfiguration.prototype, "electricChars", {
        get: function () {
            if (!this._electricChars) {
                this._electricChars = {};
                var electricChars = CursorConfiguration._getElectricCharacters(this._languageIdentifier);
                if (electricChars) {
                    for (var _i = 0, electricChars_1 = electricChars; _i < electricChars_1.length; _i++) {
                        var char = electricChars_1[_i];
                        this._electricChars[char] = true;
                    }
                }
            }
            return this._electricChars;
        },
        enumerable: true,
        configurable: true
    });
    CursorConfiguration.prototype.normalizeIndentation = function (str) {
        return __WEBPACK_IMPORTED_MODULE_5__model_textModel_js__["b" /* TextModel */].normalizeIndentation(str, this.indentSize, this.insertSpaces);
    };
    CursorConfiguration._getElectricCharacters = function (languageIdentifier) {
        try {
            return __WEBPACK_IMPORTED_MODULE_6__modes_languageConfigurationRegistry_js__["a" /* LanguageConfigurationRegistry */].getElectricCharacters(languageIdentifier.id);
        }
        catch (e) {
            Object(__WEBPACK_IMPORTED_MODULE_0__base_common_errors_js__["e" /* onUnexpectedError */])(e);
            return null;
        }
    };
    CursorConfiguration._getAutoClosingPairs = function (languageIdentifier) {
        try {
            return __WEBPACK_IMPORTED_MODULE_6__modes_languageConfigurationRegistry_js__["a" /* LanguageConfigurationRegistry */].getAutoClosingPairs(languageIdentifier.id);
        }
        catch (e) {
            Object(__WEBPACK_IMPORTED_MODULE_0__base_common_errors_js__["e" /* onUnexpectedError */])(e);
            return null;
        }
    };
    CursorConfiguration._getShouldAutoClose = function (languageIdentifier, autoCloseConfig) {
        switch (autoCloseConfig) {
            case 'beforeWhitespace':
                return autoCloseBeforeWhitespace;
            case 'languageDefined':
                return CursorConfiguration._getLanguageDefinedShouldAutoClose(languageIdentifier);
            case 'always':
                return autoCloseAlways;
            case 'never':
                return autoCloseNever;
        }
    };
    CursorConfiguration._getLanguageDefinedShouldAutoClose = function (languageIdentifier) {
        try {
            var autoCloseBeforeSet_1 = __WEBPACK_IMPORTED_MODULE_6__modes_languageConfigurationRegistry_js__["a" /* LanguageConfigurationRegistry */].getAutoCloseBeforeSet(languageIdentifier.id);
            return function (c) { return autoCloseBeforeSet_1.indexOf(c) !== -1; };
        }
        catch (e) {
            Object(__WEBPACK_IMPORTED_MODULE_0__base_common_errors_js__["e" /* onUnexpectedError */])(e);
            return autoCloseNever;
        }
    };
    CursorConfiguration._getSurroundingPairs = function (languageIdentifier) {
        try {
            return __WEBPACK_IMPORTED_MODULE_6__modes_languageConfigurationRegistry_js__["a" /* LanguageConfigurationRegistry */].getSurroundingPairs(languageIdentifier.id);
        }
        catch (e) {
            Object(__WEBPACK_IMPORTED_MODULE_0__base_common_errors_js__["e" /* onUnexpectedError */])(e);
            return null;
        }
    };
    return CursorConfiguration;
}());

/**
 * Represents the cursor state on either the model or on the view model.
 */
var SingleCursorState = /** @class */ (function () {
    function SingleCursorState(selectionStart, selectionStartLeftoverVisibleColumns, position, leftoverVisibleColumns) {
        this.selectionStart = selectionStart;
        this.selectionStartLeftoverVisibleColumns = selectionStartLeftoverVisibleColumns;
        this.position = position;
        this.leftoverVisibleColumns = leftoverVisibleColumns;
        this.selection = SingleCursorState._computeSelection(this.selectionStart, this.position);
    }
    SingleCursorState.prototype.equals = function (other) {
        return (this.selectionStartLeftoverVisibleColumns === other.selectionStartLeftoverVisibleColumns
            && this.leftoverVisibleColumns === other.leftoverVisibleColumns
            && this.position.equals(other.position)
            && this.selectionStart.equalsRange(other.selectionStart));
    };
    SingleCursorState.prototype.hasSelection = function () {
        return (!this.selection.isEmpty() || !this.selectionStart.isEmpty());
    };
    SingleCursorState.prototype.move = function (inSelectionMode, lineNumber, column, leftoverVisibleColumns) {
        if (inSelectionMode) {
            // move just position
            return new SingleCursorState(this.selectionStart, this.selectionStartLeftoverVisibleColumns, new __WEBPACK_IMPORTED_MODULE_2__core_position_js__["a" /* Position */](lineNumber, column), leftoverVisibleColumns);
        }
        else {
            // move everything
            return new SingleCursorState(new __WEBPACK_IMPORTED_MODULE_3__core_range_js__["a" /* Range */](lineNumber, column, lineNumber, column), leftoverVisibleColumns, new __WEBPACK_IMPORTED_MODULE_2__core_position_js__["a" /* Position */](lineNumber, column), leftoverVisibleColumns);
        }
    };
    SingleCursorState._computeSelection = function (selectionStart, position) {
        var startLineNumber, startColumn, endLineNumber, endColumn;
        if (selectionStart.isEmpty()) {
            startLineNumber = selectionStart.startLineNumber;
            startColumn = selectionStart.startColumn;
            endLineNumber = position.lineNumber;
            endColumn = position.column;
        }
        else {
            if (position.isBeforeOrEqual(selectionStart.getStartPosition())) {
                startLineNumber = selectionStart.endLineNumber;
                startColumn = selectionStart.endColumn;
                endLineNumber = position.lineNumber;
                endColumn = position.column;
            }
            else {
                startLineNumber = selectionStart.startLineNumber;
                startColumn = selectionStart.startColumn;
                endLineNumber = position.lineNumber;
                endColumn = position.column;
            }
        }
        return new __WEBPACK_IMPORTED_MODULE_4__core_selection_js__["a" /* Selection */](startLineNumber, startColumn, endLineNumber, endColumn);
    };
    return SingleCursorState;
}());

var CursorContext = /** @class */ (function () {
    function CursorContext(configuration, model, viewModel) {
        this.model = model;
        this.viewModel = viewModel;
        this.config = new CursorConfiguration(this.model.getLanguageIdentifier(), this.model.getOptions(), configuration);
    }
    CursorContext.prototype.validateViewPosition = function (viewPosition, modelPosition) {
        return this.viewModel.coordinatesConverter.validateViewPosition(viewPosition, modelPosition);
    };
    CursorContext.prototype.validateViewRange = function (viewRange, expectedModelRange) {
        return this.viewModel.coordinatesConverter.validateViewRange(viewRange, expectedModelRange);
    };
    CursorContext.prototype.convertViewRangeToModelRange = function (viewRange) {
        return this.viewModel.coordinatesConverter.convertViewRangeToModelRange(viewRange);
    };
    CursorContext.prototype.convertViewPositionToModelPosition = function (lineNumber, column) {
        return this.viewModel.coordinatesConverter.convertViewPositionToModelPosition(new __WEBPACK_IMPORTED_MODULE_2__core_position_js__["a" /* Position */](lineNumber, column));
    };
    CursorContext.prototype.convertModelPositionToViewPosition = function (modelPosition) {
        return this.viewModel.coordinatesConverter.convertModelPositionToViewPosition(modelPosition);
    };
    CursorContext.prototype.convertModelRangeToViewRange = function (modelRange) {
        return this.viewModel.coordinatesConverter.convertModelRangeToViewRange(modelRange);
    };
    CursorContext.prototype.getCurrentScrollTop = function () {
        return this.viewModel.viewLayout.getCurrentScrollTop();
    };
    CursorContext.prototype.getCompletelyVisibleViewRange = function () {
        return this.viewModel.getCompletelyVisibleViewRange();
    };
    CursorContext.prototype.getCompletelyVisibleModelRange = function () {
        var viewRange = this.viewModel.getCompletelyVisibleViewRange();
        return this.viewModel.coordinatesConverter.convertViewRangeToModelRange(viewRange);
    };
    CursorContext.prototype.getCompletelyVisibleViewRangeAtScrollTop = function (scrollTop) {
        return this.viewModel.getCompletelyVisibleViewRangeAtScrollTop(scrollTop);
    };
    CursorContext.prototype.getVerticalOffsetForViewLine = function (viewLineNumber) {
        return this.viewModel.viewLayout.getVerticalOffsetForLineNumber(viewLineNumber);
    };
    return CursorContext;
}());

var PartialModelCursorState = /** @class */ (function () {
    function PartialModelCursorState(modelState) {
        this.modelState = modelState;
        this.viewState = null;
    }
    return PartialModelCursorState;
}());

var PartialViewCursorState = /** @class */ (function () {
    function PartialViewCursorState(viewState) {
        this.modelState = null;
        this.viewState = viewState;
    }
    return PartialViewCursorState;
}());

var CursorState = /** @class */ (function () {
    function CursorState(modelState, viewState) {
        this.modelState = modelState;
        this.viewState = viewState;
    }
    CursorState.fromModelState = function (modelState) {
        return new PartialModelCursorState(modelState);
    };
    CursorState.fromViewState = function (viewState) {
        return new PartialViewCursorState(viewState);
    };
    CursorState.fromModelSelection = function (modelSelection) {
        var selectionStartLineNumber = modelSelection.selectionStartLineNumber;
        var selectionStartColumn = modelSelection.selectionStartColumn;
        var positionLineNumber = modelSelection.positionLineNumber;
        var positionColumn = modelSelection.positionColumn;
        var modelState = new SingleCursorState(new __WEBPACK_IMPORTED_MODULE_3__core_range_js__["a" /* Range */](selectionStartLineNumber, selectionStartColumn, selectionStartLineNumber, selectionStartColumn), 0, new __WEBPACK_IMPORTED_MODULE_2__core_position_js__["a" /* Position */](positionLineNumber, positionColumn), 0);
        return CursorState.fromModelState(modelState);
    };
    CursorState.fromModelSelections = function (modelSelections) {
        var states = [];
        for (var i = 0, len = modelSelections.length; i < len; i++) {
            states[i] = this.fromModelSelection(modelSelections[i]);
        }
        return states;
    };
    CursorState.prototype.equals = function (other) {
        return (this.viewState.equals(other.viewState) && this.modelState.equals(other.modelState));
    };
    return CursorState;
}());

var EditOperationResult = /** @class */ (function () {
    function EditOperationResult(type, commands, opts) {
        this.type = type;
        this.commands = commands;
        this.shouldPushStackElementBefore = opts.shouldPushStackElementBefore;
        this.shouldPushStackElementAfter = opts.shouldPushStackElementAfter;
    }
    return EditOperationResult;
}());

/**
 * Common operations that work and make sense both on the model and on the view model.
 */
var CursorColumns = /** @class */ (function () {
    function CursorColumns() {
    }
    CursorColumns.visibleColumnFromColumn = function (lineContent, column, tabSize) {
        var lineContentLength = lineContent.length;
        var endOffset = column - 1 < lineContentLength ? column - 1 : lineContentLength;
        var result = 0;
        var i = 0;
        while (i < endOffset) {
            var codePoint = __WEBPACK_IMPORTED_MODULE_1__base_common_strings_js__["u" /* getNextCodePoint */](lineContent, endOffset, i);
            i += (codePoint >= 65536 /* UNICODE_SUPPLEMENTARY_PLANE_BEGIN */ ? 2 : 1);
            if (codePoint === 9 /* Tab */) {
                result = CursorColumns.nextRenderTabStop(result, tabSize);
            }
            else {
                var graphemeBreakType = __WEBPACK_IMPORTED_MODULE_1__base_common_strings_js__["s" /* getGraphemeBreakType */](codePoint);
                while (i < endOffset) {
                    var nextCodePoint = __WEBPACK_IMPORTED_MODULE_1__base_common_strings_js__["u" /* getNextCodePoint */](lineContent, endOffset, i);
                    var nextGraphemeBreakType = __WEBPACK_IMPORTED_MODULE_1__base_common_strings_js__["s" /* getGraphemeBreakType */](nextCodePoint);
                    if (__WEBPACK_IMPORTED_MODULE_1__base_common_strings_js__["b" /* breakBetweenGraphemeBreakType */](graphemeBreakType, nextGraphemeBreakType)) {
                        break;
                    }
                    i += (nextCodePoint >= 65536 /* UNICODE_SUPPLEMENTARY_PLANE_BEGIN */ ? 2 : 1);
                    graphemeBreakType = nextGraphemeBreakType;
                }
                if (__WEBPACK_IMPORTED_MODULE_1__base_common_strings_js__["y" /* isFullWidthCharacter */](codePoint) || __WEBPACK_IMPORTED_MODULE_1__base_common_strings_js__["w" /* isEmojiImprecise */](codePoint)) {
                    result = result + 2;
                }
                else {
                    result = result + 1;
                }
            }
        }
        return result;
    };
    CursorColumns.visibleColumnFromColumn2 = function (config, model, position) {
        return this.visibleColumnFromColumn(model.getLineContent(position.lineNumber), position.column, config.tabSize);
    };
    CursorColumns.columnFromVisibleColumn = function (lineContent, visibleColumn, tabSize) {
        if (visibleColumn <= 0) {
            return 1;
        }
        var lineLength = lineContent.length;
        var beforeVisibleColumn = 0;
        var beforeColumn = 1;
        var i = 0;
        while (i < lineLength) {
            var codePoint = __WEBPACK_IMPORTED_MODULE_1__base_common_strings_js__["u" /* getNextCodePoint */](lineContent, lineLength, i);
            i += (codePoint >= 65536 /* UNICODE_SUPPLEMENTARY_PLANE_BEGIN */ ? 2 : 1);
            var afterVisibleColumn = void 0;
            if (codePoint === 9 /* Tab */) {
                afterVisibleColumn = CursorColumns.nextRenderTabStop(beforeVisibleColumn, tabSize);
            }
            else {
                var graphemeBreakType = __WEBPACK_IMPORTED_MODULE_1__base_common_strings_js__["s" /* getGraphemeBreakType */](codePoint);
                while (i < lineLength) {
                    var nextCodePoint = __WEBPACK_IMPORTED_MODULE_1__base_common_strings_js__["u" /* getNextCodePoint */](lineContent, lineLength, i);
                    var nextGraphemeBreakType = __WEBPACK_IMPORTED_MODULE_1__base_common_strings_js__["s" /* getGraphemeBreakType */](nextCodePoint);
                    if (__WEBPACK_IMPORTED_MODULE_1__base_common_strings_js__["b" /* breakBetweenGraphemeBreakType */](graphemeBreakType, nextGraphemeBreakType)) {
                        break;
                    }
                    i += (nextCodePoint >= 65536 /* UNICODE_SUPPLEMENTARY_PLANE_BEGIN */ ? 2 : 1);
                    graphemeBreakType = nextGraphemeBreakType;
                }
                if (__WEBPACK_IMPORTED_MODULE_1__base_common_strings_js__["y" /* isFullWidthCharacter */](codePoint) || __WEBPACK_IMPORTED_MODULE_1__base_common_strings_js__["w" /* isEmojiImprecise */](codePoint)) {
                    afterVisibleColumn = beforeVisibleColumn + 2;
                }
                else {
                    afterVisibleColumn = beforeVisibleColumn + 1;
                }
            }
            var afterColumn = i + 1;
            if (afterVisibleColumn >= visibleColumn) {
                var beforeDelta = visibleColumn - beforeVisibleColumn;
                var afterDelta = afterVisibleColumn - visibleColumn;
                if (afterDelta < beforeDelta) {
                    return afterColumn;
                }
                else {
                    return beforeColumn;
                }
            }
            beforeVisibleColumn = afterVisibleColumn;
            beforeColumn = afterColumn;
        }
        // walked the entire string
        return lineLength + 1;
    };
    CursorColumns.columnFromVisibleColumn2 = function (config, model, lineNumber, visibleColumn) {
        var result = this.columnFromVisibleColumn(model.getLineContent(lineNumber), visibleColumn, config.tabSize);
        var minColumn = model.getLineMinColumn(lineNumber);
        if (result < minColumn) {
            return minColumn;
        }
        var maxColumn = model.getLineMaxColumn(lineNumber);
        if (result > maxColumn) {
            return maxColumn;
        }
        return result;
    };
    /**
     * ATTENTION: This works with 0-based columns (as oposed to the regular 1-based columns)
     */
    CursorColumns.nextRenderTabStop = function (visibleColumn, tabSize) {
        return visibleColumn + tabSize - visibleColumn % tabSize;
    };
    /**
     * ATTENTION: This works with 0-based columns (as oposed to the regular 1-based columns)
     */
    CursorColumns.nextIndentTabStop = function (visibleColumn, indentSize) {
        return visibleColumn + indentSize - visibleColumn % indentSize;
    };
    /**
     * ATTENTION: This works with 0-based columns (as oposed to the regular 1-based columns)
     */
    CursorColumns.prevRenderTabStop = function (column, tabSize) {
        return column - 1 - (column - 1) % tabSize;
    };
    /**
     * ATTENTION: This works with 0-based columns (as oposed to the regular 1-based columns)
     */
    CursorColumns.prevIndentTabStop = function (column, indentSize) {
        return column - 1 - (column - 1) % indentSize;
    };
    return CursorColumns;
}());

function isQuote(ch) {
    return (ch === '\'' || ch === '"' || ch === '`');
}


/***/ }),
/* 41 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return Registry; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__base_common_types_js__ = __webpack_require__(20);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__base_common_assert_js__ = __webpack_require__(152);
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/


var RegistryImpl = /** @class */ (function () {
    function RegistryImpl() {
        this.data = new Map();
    }
    RegistryImpl.prototype.add = function (id, data) {
        __WEBPACK_IMPORTED_MODULE_1__base_common_assert_js__["a" /* ok */](__WEBPACK_IMPORTED_MODULE_0__base_common_types_js__["j" /* isString */](id));
        __WEBPACK_IMPORTED_MODULE_1__base_common_assert_js__["a" /* ok */](__WEBPACK_IMPORTED_MODULE_0__base_common_types_js__["i" /* isObject */](data));
        __WEBPACK_IMPORTED_MODULE_1__base_common_assert_js__["a" /* ok */](!this.data.has(id), 'There is already an extension with this id');
        this.data.set(id, data);
    };
    RegistryImpl.prototype.as = function (id) {
        return this.data.get(id) || null;
    };
    return RegistryImpl;
}());
var Registry = new RegistryImpl();


/***/ }),
/* 42 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* unused harmony export RichEditSupport */
/* unused harmony export LanguageConfigurationChangeEvent */
/* unused harmony export LanguageConfigurationRegistryImpl */
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return LanguageConfigurationRegistry; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__base_common_event_js__ = __webpack_require__(2);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__base_common_lifecycle_js__ = __webpack_require__(0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2__base_common_strings_js__ = __webpack_require__(4);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3__model_wordHelper_js__ = __webpack_require__(117);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4__languageConfiguration_js__ = __webpack_require__(104);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5__supports_js__ = __webpack_require__(159);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6__supports_characterPair_js__ = __webpack_require__(401);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_7__supports_electricCharacter_js__ = __webpack_require__(402);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_8__supports_indentRules_js__ = __webpack_require__(403);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_9__supports_onEnter_js__ = __webpack_require__(404);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_10__supports_richEditBrackets_js__ = __webpack_require__(160);
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/











var RichEditSupport = /** @class */ (function () {
    function RichEditSupport(languageIdentifier, previous, rawConf) {
        this._languageIdentifier = languageIdentifier;
        this._brackets = null;
        this._electricCharacter = null;
        var prev = null;
        if (previous) {
            prev = previous._conf;
        }
        this._conf = RichEditSupport._mergeConf(prev, rawConf);
        this._onEnterSupport = (this._conf.brackets || this._conf.indentationRules || this._conf.onEnterRules ? new __WEBPACK_IMPORTED_MODULE_9__supports_onEnter_js__["a" /* OnEnterSupport */](this._conf) : null);
        this.comments = RichEditSupport._handleComments(this._conf);
        this.characterPair = new __WEBPACK_IMPORTED_MODULE_6__supports_characterPair_js__["a" /* CharacterPairSupport */](this._conf);
        this.wordDefinition = this._conf.wordPattern || __WEBPACK_IMPORTED_MODULE_3__model_wordHelper_js__["a" /* DEFAULT_WORD_REGEXP */];
        this.indentationRules = this._conf.indentationRules;
        if (this._conf.indentationRules) {
            this.indentRulesSupport = new __WEBPACK_IMPORTED_MODULE_8__supports_indentRules_js__["a" /* IndentRulesSupport */](this._conf.indentationRules);
        }
        else {
            this.indentRulesSupport = null;
        }
        this.foldingRules = this._conf.folding || {};
    }
    Object.defineProperty(RichEditSupport.prototype, "brackets", {
        get: function () {
            if (!this._brackets && this._conf.brackets) {
                this._brackets = new __WEBPACK_IMPORTED_MODULE_10__supports_richEditBrackets_js__["b" /* RichEditBrackets */](this._languageIdentifier, this._conf.brackets);
            }
            return this._brackets;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(RichEditSupport.prototype, "electricCharacter", {
        get: function () {
            if (!this._electricCharacter) {
                this._electricCharacter = new __WEBPACK_IMPORTED_MODULE_7__supports_electricCharacter_js__["a" /* BracketElectricCharacterSupport */](this.brackets);
            }
            return this._electricCharacter;
        },
        enumerable: true,
        configurable: true
    });
    RichEditSupport.prototype.onEnter = function (autoIndent, oneLineAboveText, beforeEnterText, afterEnterText) {
        if (!this._onEnterSupport) {
            return null;
        }
        return this._onEnterSupport.onEnter(autoIndent, oneLineAboveText, beforeEnterText, afterEnterText);
    };
    RichEditSupport._mergeConf = function (prev, current) {
        return {
            comments: (prev ? current.comments || prev.comments : current.comments),
            brackets: (prev ? current.brackets || prev.brackets : current.brackets),
            wordPattern: (prev ? current.wordPattern || prev.wordPattern : current.wordPattern),
            indentationRules: (prev ? current.indentationRules || prev.indentationRules : current.indentationRules),
            onEnterRules: (prev ? current.onEnterRules || prev.onEnterRules : current.onEnterRules),
            autoClosingPairs: (prev ? current.autoClosingPairs || prev.autoClosingPairs : current.autoClosingPairs),
            surroundingPairs: (prev ? current.surroundingPairs || prev.surroundingPairs : current.surroundingPairs),
            autoCloseBefore: (prev ? current.autoCloseBefore || prev.autoCloseBefore : current.autoCloseBefore),
            folding: (prev ? current.folding || prev.folding : current.folding),
            __electricCharacterSupport: (prev ? current.__electricCharacterSupport || prev.__electricCharacterSupport : current.__electricCharacterSupport),
        };
    };
    RichEditSupport._handleComments = function (conf) {
        var commentRule = conf.comments;
        if (!commentRule) {
            return null;
        }
        // comment configuration
        var comments = {};
        if (commentRule.lineComment) {
            comments.lineCommentToken = commentRule.lineComment;
        }
        if (commentRule.blockComment) {
            var _a = commentRule.blockComment, blockStart = _a[0], blockEnd = _a[1];
            comments.blockCommentStartToken = blockStart;
            comments.blockCommentEndToken = blockEnd;
        }
        return comments;
    };
    return RichEditSupport;
}());

var LanguageConfigurationChangeEvent = /** @class */ (function () {
    function LanguageConfigurationChangeEvent(languageIdentifier) {
        this.languageIdentifier = languageIdentifier;
    }
    return LanguageConfigurationChangeEvent;
}());

var LanguageConfigurationRegistryImpl = /** @class */ (function () {
    function LanguageConfigurationRegistryImpl() {
        this._entries = new Map();
        this._onDidChange = new __WEBPACK_IMPORTED_MODULE_0__base_common_event_js__["a" /* Emitter */]();
        this.onDidChange = this._onDidChange.event;
    }
    LanguageConfigurationRegistryImpl.prototype.register = function (languageIdentifier, configuration) {
        var _this = this;
        var previous = this._getRichEditSupport(languageIdentifier.id);
        var current = new RichEditSupport(languageIdentifier, previous, configuration);
        this._entries.set(languageIdentifier.id, current);
        this._onDidChange.fire(new LanguageConfigurationChangeEvent(languageIdentifier));
        return Object(__WEBPACK_IMPORTED_MODULE_1__base_common_lifecycle_js__["h" /* toDisposable */])(function () {
            if (_this._entries.get(languageIdentifier.id) === current) {
                _this._entries.set(languageIdentifier.id, previous);
                _this._onDidChange.fire(new LanguageConfigurationChangeEvent(languageIdentifier));
            }
        });
    };
    LanguageConfigurationRegistryImpl.prototype._getRichEditSupport = function (languageId) {
        return this._entries.get(languageId);
    };
    // begin electricCharacter
    LanguageConfigurationRegistryImpl.prototype._getElectricCharacterSupport = function (languageId) {
        var value = this._getRichEditSupport(languageId);
        if (!value) {
            return null;
        }
        return value.electricCharacter || null;
    };
    LanguageConfigurationRegistryImpl.prototype.getElectricCharacters = function (languageId) {
        var electricCharacterSupport = this._getElectricCharacterSupport(languageId);
        if (!electricCharacterSupport) {
            return [];
        }
        return electricCharacterSupport.getElectricCharacters();
    };
    /**
     * Should return opening bracket type to match indentation with
     */
    LanguageConfigurationRegistryImpl.prototype.onElectricCharacter = function (character, context, column) {
        var scopedLineTokens = Object(__WEBPACK_IMPORTED_MODULE_5__supports_js__["a" /* createScopedLineTokens */])(context, column - 1);
        var electricCharacterSupport = this._getElectricCharacterSupport(scopedLineTokens.languageId);
        if (!electricCharacterSupport) {
            return null;
        }
        return electricCharacterSupport.onElectricCharacter(character, scopedLineTokens, column - scopedLineTokens.firstCharOffset);
    };
    // end electricCharacter
    LanguageConfigurationRegistryImpl.prototype.getComments = function (languageId) {
        var value = this._getRichEditSupport(languageId);
        if (!value) {
            return null;
        }
        return value.comments || null;
    };
    // begin characterPair
    LanguageConfigurationRegistryImpl.prototype._getCharacterPairSupport = function (languageId) {
        var value = this._getRichEditSupport(languageId);
        if (!value) {
            return null;
        }
        return value.characterPair || null;
    };
    LanguageConfigurationRegistryImpl.prototype.getAutoClosingPairs = function (languageId) {
        var characterPairSupport = this._getCharacterPairSupport(languageId);
        if (!characterPairSupport) {
            return [];
        }
        return characterPairSupport.getAutoClosingPairs();
    };
    LanguageConfigurationRegistryImpl.prototype.getAutoCloseBeforeSet = function (languageId) {
        var characterPairSupport = this._getCharacterPairSupport(languageId);
        if (!characterPairSupport) {
            return __WEBPACK_IMPORTED_MODULE_6__supports_characterPair_js__["a" /* CharacterPairSupport */].DEFAULT_AUTOCLOSE_BEFORE_LANGUAGE_DEFINED;
        }
        return characterPairSupport.getAutoCloseBeforeSet();
    };
    LanguageConfigurationRegistryImpl.prototype.getSurroundingPairs = function (languageId) {
        var characterPairSupport = this._getCharacterPairSupport(languageId);
        if (!characterPairSupport) {
            return [];
        }
        return characterPairSupport.getSurroundingPairs();
    };
    LanguageConfigurationRegistryImpl.prototype.shouldAutoClosePair = function (autoClosingPair, context, column) {
        var scopedLineTokens = Object(__WEBPACK_IMPORTED_MODULE_5__supports_js__["a" /* createScopedLineTokens */])(context, column - 1);
        return __WEBPACK_IMPORTED_MODULE_6__supports_characterPair_js__["a" /* CharacterPairSupport */].shouldAutoClosePair(autoClosingPair, scopedLineTokens, column - scopedLineTokens.firstCharOffset);
    };
    // end characterPair
    LanguageConfigurationRegistryImpl.prototype.getWordDefinition = function (languageId) {
        var value = this._getRichEditSupport(languageId);
        if (!value) {
            return Object(__WEBPACK_IMPORTED_MODULE_3__model_wordHelper_js__["c" /* ensureValidWordDefinition */])(null);
        }
        return Object(__WEBPACK_IMPORTED_MODULE_3__model_wordHelper_js__["c" /* ensureValidWordDefinition */])(value.wordDefinition || null);
    };
    LanguageConfigurationRegistryImpl.prototype.getFoldingRules = function (languageId) {
        var value = this._getRichEditSupport(languageId);
        if (!value) {
            return {};
        }
        return value.foldingRules;
    };
    // begin Indent Rules
    LanguageConfigurationRegistryImpl.prototype.getIndentRulesSupport = function (languageId) {
        var value = this._getRichEditSupport(languageId);
        if (!value) {
            return null;
        }
        return value.indentRulesSupport || null;
    };
    /**
     * Get nearest preceiding line which doesn't match unIndentPattern or contains all whitespace.
     * Result:
     * -1: run into the boundary of embedded languages
     * 0: every line above are invalid
     * else: nearest preceding line of the same language
     */
    LanguageConfigurationRegistryImpl.prototype.getPrecedingValidLine = function (model, lineNumber, indentRulesSupport) {
        var languageID = model.getLanguageIdAtPosition(lineNumber, 0);
        if (lineNumber > 1) {
            var lastLineNumber = void 0;
            var resultLineNumber = -1;
            for (lastLineNumber = lineNumber - 1; lastLineNumber >= 1; lastLineNumber--) {
                if (model.getLanguageIdAtPosition(lastLineNumber, 0) !== languageID) {
                    return resultLineNumber;
                }
                var text = model.getLineContent(lastLineNumber);
                if (indentRulesSupport.shouldIgnore(text) || /^\s+$/.test(text) || text === '') {
                    resultLineNumber = lastLineNumber;
                    continue;
                }
                return lastLineNumber;
            }
        }
        return -1;
    };
    /**
     * Get inherited indentation from above lines.
     * 1. Find the nearest preceding line which doesn't match unIndentedLinePattern.
     * 2. If this line matches indentNextLinePattern or increaseIndentPattern, it means that the indent level of `lineNumber` should be 1 greater than this line.
     * 3. If this line doesn't match any indent rules
     *   a. check whether the line above it matches indentNextLinePattern
     *   b. If not, the indent level of this line is the result
     *   c. If so, it means the indent of this line is *temporary*, go upward utill we find a line whose indent is not temporary (the same workflow a -> b -> c).
     * 4. Otherwise, we fail to get an inherited indent from aboves. Return null and we should not touch the indent of `lineNumber`
     *
     * This function only return the inherited indent based on above lines, it doesn't check whether current line should decrease or not.
     */
    LanguageConfigurationRegistryImpl.prototype.getInheritIndentForLine = function (autoIndent, model, lineNumber, honorIntentialIndent) {
        if (honorIntentialIndent === void 0) { honorIntentialIndent = true; }
        if (autoIndent < 4 /* Full */) {
            return null;
        }
        var indentRulesSupport = this.getIndentRulesSupport(model.getLanguageIdentifier().id);
        if (!indentRulesSupport) {
            return null;
        }
        if (lineNumber <= 1) {
            return {
                indentation: '',
                action: null
            };
        }
        var precedingUnIgnoredLine = this.getPrecedingValidLine(model, lineNumber, indentRulesSupport);
        if (precedingUnIgnoredLine < 0) {
            return null;
        }
        else if (precedingUnIgnoredLine < 1) {
            return {
                indentation: '',
                action: null
            };
        }
        var precedingUnIgnoredLineContent = model.getLineContent(precedingUnIgnoredLine);
        if (indentRulesSupport.shouldIncrease(precedingUnIgnoredLineContent) || indentRulesSupport.shouldIndentNextLine(precedingUnIgnoredLineContent)) {
            return {
                indentation: __WEBPACK_IMPORTED_MODULE_2__base_common_strings_js__["t" /* getLeadingWhitespace */](precedingUnIgnoredLineContent),
                action: __WEBPACK_IMPORTED_MODULE_4__languageConfiguration_js__["a" /* IndentAction */].Indent,
                line: precedingUnIgnoredLine
            };
        }
        else if (indentRulesSupport.shouldDecrease(precedingUnIgnoredLineContent)) {
            return {
                indentation: __WEBPACK_IMPORTED_MODULE_2__base_common_strings_js__["t" /* getLeadingWhitespace */](precedingUnIgnoredLineContent),
                action: null,
                line: precedingUnIgnoredLine
            };
        }
        else {
            // precedingUnIgnoredLine can not be ignored.
            // it doesn't increase indent of following lines
            // it doesn't increase just next line
            // so current line is not affect by precedingUnIgnoredLine
            // and then we should get a correct inheritted indentation from above lines
            if (precedingUnIgnoredLine === 1) {
                return {
                    indentation: __WEBPACK_IMPORTED_MODULE_2__base_common_strings_js__["t" /* getLeadingWhitespace */](model.getLineContent(precedingUnIgnoredLine)),
                    action: null,
                    line: precedingUnIgnoredLine
                };
            }
            var previousLine = precedingUnIgnoredLine - 1;
            var previousLineIndentMetadata = indentRulesSupport.getIndentMetadata(model.getLineContent(previousLine));
            if (!(previousLineIndentMetadata & (1 /* INCREASE_MASK */ | 2 /* DECREASE_MASK */)) &&
                (previousLineIndentMetadata & 4 /* INDENT_NEXTLINE_MASK */)) {
                var stopLine = 0;
                for (var i = previousLine - 1; i > 0; i--) {
                    if (indentRulesSupport.shouldIndentNextLine(model.getLineContent(i))) {
                        continue;
                    }
                    stopLine = i;
                    break;
                }
                return {
                    indentation: __WEBPACK_IMPORTED_MODULE_2__base_common_strings_js__["t" /* getLeadingWhitespace */](model.getLineContent(stopLine + 1)),
                    action: null,
                    line: stopLine + 1
                };
            }
            if (honorIntentialIndent) {
                return {
                    indentation: __WEBPACK_IMPORTED_MODULE_2__base_common_strings_js__["t" /* getLeadingWhitespace */](model.getLineContent(precedingUnIgnoredLine)),
                    action: null,
                    line: precedingUnIgnoredLine
                };
            }
            else {
                // search from precedingUnIgnoredLine until we find one whose indent is not temporary
                for (var i = precedingUnIgnoredLine; i > 0; i--) {
                    var lineContent = model.getLineContent(i);
                    if (indentRulesSupport.shouldIncrease(lineContent)) {
                        return {
                            indentation: __WEBPACK_IMPORTED_MODULE_2__base_common_strings_js__["t" /* getLeadingWhitespace */](lineContent),
                            action: __WEBPACK_IMPORTED_MODULE_4__languageConfiguration_js__["a" /* IndentAction */].Indent,
                            line: i
                        };
                    }
                    else if (indentRulesSupport.shouldIndentNextLine(lineContent)) {
                        var stopLine = 0;
                        for (var j = i - 1; j > 0; j--) {
                            if (indentRulesSupport.shouldIndentNextLine(model.getLineContent(i))) {
                                continue;
                            }
                            stopLine = j;
                            break;
                        }
                        return {
                            indentation: __WEBPACK_IMPORTED_MODULE_2__base_common_strings_js__["t" /* getLeadingWhitespace */](model.getLineContent(stopLine + 1)),
                            action: null,
                            line: stopLine + 1
                        };
                    }
                    else if (indentRulesSupport.shouldDecrease(lineContent)) {
                        return {
                            indentation: __WEBPACK_IMPORTED_MODULE_2__base_common_strings_js__["t" /* getLeadingWhitespace */](lineContent),
                            action: null,
                            line: i
                        };
                    }
                }
                return {
                    indentation: __WEBPACK_IMPORTED_MODULE_2__base_common_strings_js__["t" /* getLeadingWhitespace */](model.getLineContent(1)),
                    action: null,
                    line: 1
                };
            }
        }
    };
    LanguageConfigurationRegistryImpl.prototype.getGoodIndentForLine = function (autoIndent, virtualModel, languageId, lineNumber, indentConverter) {
        if (autoIndent < 4 /* Full */) {
            return null;
        }
        var richEditSupport = this._getRichEditSupport(languageId);
        if (!richEditSupport) {
            return null;
        }
        var indentRulesSupport = this.getIndentRulesSupport(languageId);
        if (!indentRulesSupport) {
            return null;
        }
        var indent = this.getInheritIndentForLine(autoIndent, virtualModel, lineNumber);
        var lineContent = virtualModel.getLineContent(lineNumber);
        if (indent) {
            var inheritLine = indent.line;
            if (inheritLine !== undefined) {
                var enterResult = richEditSupport.onEnter(autoIndent, '', virtualModel.getLineContent(inheritLine), '');
                if (enterResult) {
                    var indentation = __WEBPACK_IMPORTED_MODULE_2__base_common_strings_js__["t" /* getLeadingWhitespace */](virtualModel.getLineContent(inheritLine));
                    if (enterResult.removeText) {
                        indentation = indentation.substring(0, indentation.length - enterResult.removeText);
                    }
                    if ((enterResult.indentAction === __WEBPACK_IMPORTED_MODULE_4__languageConfiguration_js__["a" /* IndentAction */].Indent) ||
                        (enterResult.indentAction === __WEBPACK_IMPORTED_MODULE_4__languageConfiguration_js__["a" /* IndentAction */].IndentOutdent)) {
                        indentation = indentConverter.shiftIndent(indentation);
                    }
                    else if (enterResult.indentAction === __WEBPACK_IMPORTED_MODULE_4__languageConfiguration_js__["a" /* IndentAction */].Outdent) {
                        indentation = indentConverter.unshiftIndent(indentation);
                    }
                    if (indentRulesSupport.shouldDecrease(lineContent)) {
                        indentation = indentConverter.unshiftIndent(indentation);
                    }
                    if (enterResult.appendText) {
                        indentation += enterResult.appendText;
                    }
                    return __WEBPACK_IMPORTED_MODULE_2__base_common_strings_js__["t" /* getLeadingWhitespace */](indentation);
                }
            }
            if (indentRulesSupport.shouldDecrease(lineContent)) {
                if (indent.action === __WEBPACK_IMPORTED_MODULE_4__languageConfiguration_js__["a" /* IndentAction */].Indent) {
                    return indent.indentation;
                }
                else {
                    return indentConverter.unshiftIndent(indent.indentation);
                }
            }
            else {
                if (indent.action === __WEBPACK_IMPORTED_MODULE_4__languageConfiguration_js__["a" /* IndentAction */].Indent) {
                    return indentConverter.shiftIndent(indent.indentation);
                }
                else {
                    return indent.indentation;
                }
            }
        }
        return null;
    };
    LanguageConfigurationRegistryImpl.prototype.getIndentForEnter = function (autoIndent, model, range, indentConverter) {
        if (autoIndent < 4 /* Full */) {
            return null;
        }
        model.forceTokenization(range.startLineNumber);
        var lineTokens = model.getLineTokens(range.startLineNumber);
        var scopedLineTokens = Object(__WEBPACK_IMPORTED_MODULE_5__supports_js__["a" /* createScopedLineTokens */])(lineTokens, range.startColumn - 1);
        var scopedLineText = scopedLineTokens.getLineContent();
        var embeddedLanguage = false;
        var beforeEnterText;
        if (scopedLineTokens.firstCharOffset > 0 && lineTokens.getLanguageId(0) !== scopedLineTokens.languageId) {
            // we are in the embeded language content
            embeddedLanguage = true; // if embeddedLanguage is true, then we don't touch the indentation of current line
            beforeEnterText = scopedLineText.substr(0, range.startColumn - 1 - scopedLineTokens.firstCharOffset);
        }
        else {
            beforeEnterText = lineTokens.getLineContent().substring(0, range.startColumn - 1);
        }
        var afterEnterText;
        if (range.isEmpty()) {
            afterEnterText = scopedLineText.substr(range.startColumn - 1 - scopedLineTokens.firstCharOffset);
        }
        else {
            var endScopedLineTokens = this.getScopedLineTokens(model, range.endLineNumber, range.endColumn);
            afterEnterText = endScopedLineTokens.getLineContent().substr(range.endColumn - 1 - scopedLineTokens.firstCharOffset);
        }
        var indentRulesSupport = this.getIndentRulesSupport(scopedLineTokens.languageId);
        if (!indentRulesSupport) {
            return null;
        }
        var beforeEnterResult = beforeEnterText;
        var beforeEnterIndent = __WEBPACK_IMPORTED_MODULE_2__base_common_strings_js__["t" /* getLeadingWhitespace */](beforeEnterText);
        var virtualModel = {
            getLineTokens: function (lineNumber) {
                return model.getLineTokens(lineNumber);
            },
            getLanguageIdentifier: function () {
                return model.getLanguageIdentifier();
            },
            getLanguageIdAtPosition: function (lineNumber, column) {
                return model.getLanguageIdAtPosition(lineNumber, column);
            },
            getLineContent: function (lineNumber) {
                if (lineNumber === range.startLineNumber) {
                    return beforeEnterResult;
                }
                else {
                    return model.getLineContent(lineNumber);
                }
            }
        };
        var currentLineIndent = __WEBPACK_IMPORTED_MODULE_2__base_common_strings_js__["t" /* getLeadingWhitespace */](lineTokens.getLineContent());
        var afterEnterAction = this.getInheritIndentForLine(autoIndent, virtualModel, range.startLineNumber + 1);
        if (!afterEnterAction) {
            var beforeEnter = embeddedLanguage ? currentLineIndent : beforeEnterIndent;
            return {
                beforeEnter: beforeEnter,
                afterEnter: beforeEnter
            };
        }
        var afterEnterIndent = embeddedLanguage ? currentLineIndent : afterEnterAction.indentation;
        if (afterEnterAction.action === __WEBPACK_IMPORTED_MODULE_4__languageConfiguration_js__["a" /* IndentAction */].Indent) {
            afterEnterIndent = indentConverter.shiftIndent(afterEnterIndent);
        }
        if (indentRulesSupport.shouldDecrease(afterEnterText)) {
            afterEnterIndent = indentConverter.unshiftIndent(afterEnterIndent);
        }
        return {
            beforeEnter: embeddedLanguage ? currentLineIndent : beforeEnterIndent,
            afterEnter: afterEnterIndent
        };
    };
    /**
     * We should always allow intentional indentation. It means, if users change the indentation of `lineNumber` and the content of
     * this line doesn't match decreaseIndentPattern, we should not adjust the indentation.
     */
    LanguageConfigurationRegistryImpl.prototype.getIndentActionForType = function (autoIndent, model, range, ch, indentConverter) {
        if (autoIndent < 4 /* Full */) {
            return null;
        }
        var scopedLineTokens = this.getScopedLineTokens(model, range.startLineNumber, range.startColumn);
        var indentRulesSupport = this.getIndentRulesSupport(scopedLineTokens.languageId);
        if (!indentRulesSupport) {
            return null;
        }
        var scopedLineText = scopedLineTokens.getLineContent();
        var beforeTypeText = scopedLineText.substr(0, range.startColumn - 1 - scopedLineTokens.firstCharOffset);
        // selection support
        var afterTypeText;
        if (range.isEmpty()) {
            afterTypeText = scopedLineText.substr(range.startColumn - 1 - scopedLineTokens.firstCharOffset);
        }
        else {
            var endScopedLineTokens = this.getScopedLineTokens(model, range.endLineNumber, range.endColumn);
            afterTypeText = endScopedLineTokens.getLineContent().substr(range.endColumn - 1 - scopedLineTokens.firstCharOffset);
        }
        // If previous content already matches decreaseIndentPattern, it means indentation of this line should already be adjusted
        // Users might change the indentation by purpose and we should honor that instead of readjusting.
        if (!indentRulesSupport.shouldDecrease(beforeTypeText + afterTypeText) && indentRulesSupport.shouldDecrease(beforeTypeText + ch + afterTypeText)) {
            // after typing `ch`, the content matches decreaseIndentPattern, we should adjust the indent to a good manner.
            // 1. Get inherited indent action
            var r = this.getInheritIndentForLine(autoIndent, model, range.startLineNumber, false);
            if (!r) {
                return null;
            }
            var indentation = r.indentation;
            if (r.action !== __WEBPACK_IMPORTED_MODULE_4__languageConfiguration_js__["a" /* IndentAction */].Indent) {
                indentation = indentConverter.unshiftIndent(indentation);
            }
            return indentation;
        }
        return null;
    };
    LanguageConfigurationRegistryImpl.prototype.getIndentMetadata = function (model, lineNumber) {
        var indentRulesSupport = this.getIndentRulesSupport(model.getLanguageIdentifier().id);
        if (!indentRulesSupport) {
            return null;
        }
        if (lineNumber < 1 || lineNumber > model.getLineCount()) {
            return null;
        }
        return indentRulesSupport.getIndentMetadata(model.getLineContent(lineNumber));
    };
    // end Indent Rules
    // begin onEnter
    LanguageConfigurationRegistryImpl.prototype.getEnterAction = function (autoIndent, model, range) {
        var scopedLineTokens = this.getScopedLineTokens(model, range.startLineNumber, range.startColumn);
        var richEditSupport = this._getRichEditSupport(scopedLineTokens.languageId);
        if (!richEditSupport) {
            return null;
        }
        var scopedLineText = scopedLineTokens.getLineContent();
        var beforeEnterText = scopedLineText.substr(0, range.startColumn - 1 - scopedLineTokens.firstCharOffset);
        // selection support
        var afterEnterText;
        if (range.isEmpty()) {
            afterEnterText = scopedLineText.substr(range.startColumn - 1 - scopedLineTokens.firstCharOffset);
        }
        else {
            var endScopedLineTokens = this.getScopedLineTokens(model, range.endLineNumber, range.endColumn);
            afterEnterText = endScopedLineTokens.getLineContent().substr(range.endColumn - 1 - scopedLineTokens.firstCharOffset);
        }
        var oneLineAboveText = '';
        if (range.startLineNumber > 1 && scopedLineTokens.firstCharOffset === 0) {
            // This is not the first line and the entire line belongs to this mode
            var oneLineAboveScopedLineTokens = this.getScopedLineTokens(model, range.startLineNumber - 1);
            if (oneLineAboveScopedLineTokens.languageId === scopedLineTokens.languageId) {
                // The line above ends with text belonging to the same mode
                oneLineAboveText = oneLineAboveScopedLineTokens.getLineContent();
            }
        }
        var enterResult = richEditSupport.onEnter(autoIndent, oneLineAboveText, beforeEnterText, afterEnterText);
        if (!enterResult) {
            return null;
        }
        var indentAction = enterResult.indentAction;
        var appendText = enterResult.appendText;
        var removeText = enterResult.removeText || 0;
        // Here we add `\t` to appendText first because enterAction is leveraging appendText and removeText to change indentation.
        if (!appendText) {
            if ((indentAction === __WEBPACK_IMPORTED_MODULE_4__languageConfiguration_js__["a" /* IndentAction */].Indent) ||
                (indentAction === __WEBPACK_IMPORTED_MODULE_4__languageConfiguration_js__["a" /* IndentAction */].IndentOutdent)) {
                appendText = '\t';
            }
            else {
                appendText = '';
            }
        }
        var indentation = this.getIndentationAtPosition(model, range.startLineNumber, range.startColumn);
        if (removeText) {
            indentation = indentation.substring(0, indentation.length - removeText);
        }
        return {
            indentAction: indentAction,
            appendText: appendText,
            removeText: removeText,
            indentation: indentation
        };
    };
    LanguageConfigurationRegistryImpl.prototype.getIndentationAtPosition = function (model, lineNumber, column) {
        var lineText = model.getLineContent(lineNumber);
        var indentation = __WEBPACK_IMPORTED_MODULE_2__base_common_strings_js__["t" /* getLeadingWhitespace */](lineText);
        if (indentation.length > column - 1) {
            indentation = indentation.substring(0, column - 1);
        }
        return indentation;
    };
    LanguageConfigurationRegistryImpl.prototype.getScopedLineTokens = function (model, lineNumber, columnNumber) {
        model.forceTokenization(lineNumber);
        var lineTokens = model.getLineTokens(lineNumber);
        var column = (typeof columnNumber === 'undefined' ? model.getLineMaxColumn(lineNumber) - 1 : columnNumber - 1);
        return Object(__WEBPACK_IMPORTED_MODULE_5__supports_js__["a" /* createScopedLineTokens */])(lineTokens, column);
    };
    // end onEnter
    LanguageConfigurationRegistryImpl.prototype.getBracketsSupport = function (languageId) {
        var value = this._getRichEditSupport(languageId);
        if (!value) {
            return null;
        }
        return value.brackets || null;
    };
    return LanguageConfigurationRegistryImpl;
}());

var LanguageConfigurationRegistry = new LanguageConfigurationRegistryImpl();


/***/ }),
/* 43 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "i", function() { return editorLineHighlight; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "j", function() { return editorLineHighlightBorder; });
/* unused harmony export editorRangeHighlight */
/* unused harmony export editorRangeHighlightBorder */
/* unused harmony export editorSymbolHighlight */
/* unused harmony export editorSymbolHighlightBorder */
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "g", function() { return editorCursorForeground; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "f", function() { return editorCursorBackground; });
/* unused harmony export editorWhitespaces */
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "h", function() { return editorIndentGuides; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return editorActiveIndentGuides; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "k", function() { return editorLineNumbers; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "b", function() { return editorActiveLineNumber; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "m", function() { return editorRuler; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "e", function() { return editorCodeLensForeground; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "c", function() { return editorBracketMatchBackground; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "d", function() { return editorBracketMatchBorder; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "l", function() { return editorOverviewRulerBorder; });
/* unused harmony export editorGutter */
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "n", function() { return editorUnnecessaryCodeBorder; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "o", function() { return editorUnnecessaryCodeOpacity; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "p", function() { return overviewRulerError; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "r", function() { return overviewRulerWarning; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "q", function() { return overviewRulerInfo; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__nls_js__ = __webpack_require__(5);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__base_common_color_js__ = __webpack_require__(28);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2__platform_theme_common_colorRegistry_js__ = __webpack_require__(19);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3__platform_theme_common_themeService_js__ = __webpack_require__(13);
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/




/**
 * Definition of the editor colors
 */
var editorLineHighlight = Object(__WEBPACK_IMPORTED_MODULE_2__platform_theme_common_colorRegistry_js__["_45" /* registerColor */])('editor.lineHighlightBackground', { dark: null, light: null, hc: null }, __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('lineHighlight', 'Background color for the highlight of line at the cursor position.'));
var editorLineHighlightBorder = Object(__WEBPACK_IMPORTED_MODULE_2__platform_theme_common_colorRegistry_js__["_45" /* registerColor */])('editor.lineHighlightBorder', { dark: '#282828', light: '#eeeeee', hc: '#f38518' }, __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('lineHighlightBorderBox', 'Background color for the border around the line at the cursor position.'));
var editorRangeHighlight = Object(__WEBPACK_IMPORTED_MODULE_2__platform_theme_common_colorRegistry_js__["_45" /* registerColor */])('editor.rangeHighlightBackground', { dark: '#ffffff0b', light: '#fdff0033', hc: null }, __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('rangeHighlight', 'Background color of highlighted ranges, like by quick open and find features. The color must not be opaque so as not to hide underlying decorations.'), true);
var editorRangeHighlightBorder = Object(__WEBPACK_IMPORTED_MODULE_2__platform_theme_common_colorRegistry_js__["_45" /* registerColor */])('editor.rangeHighlightBorder', { dark: null, light: null, hc: __WEBPACK_IMPORTED_MODULE_2__platform_theme_common_colorRegistry_js__["b" /* activeContrastBorder */] }, __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('rangeHighlightBorder', 'Background color of the border around highlighted ranges.'), true);
var editorSymbolHighlight = Object(__WEBPACK_IMPORTED_MODULE_2__platform_theme_common_colorRegistry_js__["_45" /* registerColor */])('editor.symbolHighlightBackground', { dark: __WEBPACK_IMPORTED_MODULE_2__platform_theme_common_colorRegistry_js__["t" /* editorFindMatchHighlight */], light: __WEBPACK_IMPORTED_MODULE_2__platform_theme_common_colorRegistry_js__["t" /* editorFindMatchHighlight */], hc: null }, __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('symbolHighlight', 'Background color of highlighted symbol, like for go to definition or go next/previous symbol. The color must not be opaque so as not to hide underlying decorations.'), true);
var editorSymbolHighlightBorder = Object(__WEBPACK_IMPORTED_MODULE_2__platform_theme_common_colorRegistry_js__["_45" /* registerColor */])('editor.symbolHighlightBorder', { dark: null, light: null, hc: __WEBPACK_IMPORTED_MODULE_2__platform_theme_common_colorRegistry_js__["b" /* activeContrastBorder */] }, __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('symbolHighlightBorder', 'Background color of the border around highlighted symbols.'), true);
var editorCursorForeground = Object(__WEBPACK_IMPORTED_MODULE_2__platform_theme_common_colorRegistry_js__["_45" /* registerColor */])('editorCursor.foreground', { dark: '#AEAFAD', light: __WEBPACK_IMPORTED_MODULE_1__base_common_color_js__["a" /* Color */].black, hc: __WEBPACK_IMPORTED_MODULE_1__base_common_color_js__["a" /* Color */].white }, __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('caret', 'Color of the editor cursor.'));
var editorCursorBackground = Object(__WEBPACK_IMPORTED_MODULE_2__platform_theme_common_colorRegistry_js__["_45" /* registerColor */])('editorCursor.background', null, __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('editorCursorBackground', 'The background color of the editor cursor. Allows customizing the color of a character overlapped by a block cursor.'));
var editorWhitespaces = Object(__WEBPACK_IMPORTED_MODULE_2__platform_theme_common_colorRegistry_js__["_45" /* registerColor */])('editorWhitespace.foreground', { dark: '#e3e4e229', light: '#33333333', hc: '#e3e4e229' }, __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('editorWhitespaces', 'Color of whitespace characters in the editor.'));
var editorIndentGuides = Object(__WEBPACK_IMPORTED_MODULE_2__platform_theme_common_colorRegistry_js__["_45" /* registerColor */])('editorIndentGuide.background', { dark: editorWhitespaces, light: editorWhitespaces, hc: editorWhitespaces }, __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('editorIndentGuides', 'Color of the editor indentation guides.'));
var editorActiveIndentGuides = Object(__WEBPACK_IMPORTED_MODULE_2__platform_theme_common_colorRegistry_js__["_45" /* registerColor */])('editorIndentGuide.activeBackground', { dark: editorWhitespaces, light: editorWhitespaces, hc: editorWhitespaces }, __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('editorActiveIndentGuide', 'Color of the active editor indentation guides.'));
var editorLineNumbers = Object(__WEBPACK_IMPORTED_MODULE_2__platform_theme_common_colorRegistry_js__["_45" /* registerColor */])('editorLineNumber.foreground', { dark: '#858585', light: '#237893', hc: __WEBPACK_IMPORTED_MODULE_1__base_common_color_js__["a" /* Color */].white }, __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('editorLineNumbers', 'Color of editor line numbers.'));
var deprecatedEditorActiveLineNumber = Object(__WEBPACK_IMPORTED_MODULE_2__platform_theme_common_colorRegistry_js__["_45" /* registerColor */])('editorActiveLineNumber.foreground', { dark: '#c6c6c6', light: '#0B216F', hc: __WEBPACK_IMPORTED_MODULE_2__platform_theme_common_colorRegistry_js__["b" /* activeContrastBorder */] }, __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('editorActiveLineNumber', 'Color of editor active line number'), false, __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('deprecatedEditorActiveLineNumber', 'Id is deprecated. Use \'editorLineNumber.activeForeground\' instead.'));
var editorActiveLineNumber = Object(__WEBPACK_IMPORTED_MODULE_2__platform_theme_common_colorRegistry_js__["_45" /* registerColor */])('editorLineNumber.activeForeground', { dark: deprecatedEditorActiveLineNumber, light: deprecatedEditorActiveLineNumber, hc: deprecatedEditorActiveLineNumber }, __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('editorActiveLineNumber', 'Color of editor active line number'));
var editorRuler = Object(__WEBPACK_IMPORTED_MODULE_2__platform_theme_common_colorRegistry_js__["_45" /* registerColor */])('editorRuler.foreground', { dark: '#5A5A5A', light: __WEBPACK_IMPORTED_MODULE_1__base_common_color_js__["a" /* Color */].lightgrey, hc: __WEBPACK_IMPORTED_MODULE_1__base_common_color_js__["a" /* Color */].white }, __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('editorRuler', 'Color of the editor rulers.'));
var editorCodeLensForeground = Object(__WEBPACK_IMPORTED_MODULE_2__platform_theme_common_colorRegistry_js__["_45" /* registerColor */])('editorCodeLens.foreground', { dark: '#999999', light: '#999999', hc: '#999999' }, __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('editorCodeLensForeground', 'Foreground color of editor code lenses'));
var editorBracketMatchBackground = Object(__WEBPACK_IMPORTED_MODULE_2__platform_theme_common_colorRegistry_js__["_45" /* registerColor */])('editorBracketMatch.background', { dark: '#0064001a', light: '#0064001a', hc: '#0064001a' }, __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('editorBracketMatchBackground', 'Background color behind matching brackets'));
var editorBracketMatchBorder = Object(__WEBPACK_IMPORTED_MODULE_2__platform_theme_common_colorRegistry_js__["_45" /* registerColor */])('editorBracketMatch.border', { dark: '#888', light: '#B9B9B9', hc: __WEBPACK_IMPORTED_MODULE_2__platform_theme_common_colorRegistry_js__["e" /* contrastBorder */] }, __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('editorBracketMatchBorder', 'Color for matching brackets boxes'));
var editorOverviewRulerBorder = Object(__WEBPACK_IMPORTED_MODULE_2__platform_theme_common_colorRegistry_js__["_45" /* registerColor */])('editorOverviewRuler.border', { dark: '#7f7f7f4d', light: '#7f7f7f4d', hc: '#7f7f7f4d' }, __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('editorOverviewRulerBorder', 'Color of the overview ruler border.'));
var editorGutter = Object(__WEBPACK_IMPORTED_MODULE_2__platform_theme_common_colorRegistry_js__["_45" /* registerColor */])('editorGutter.background', { dark: __WEBPACK_IMPORTED_MODULE_2__platform_theme_common_colorRegistry_js__["o" /* editorBackground */], light: __WEBPACK_IMPORTED_MODULE_2__platform_theme_common_colorRegistry_js__["o" /* editorBackground */], hc: __WEBPACK_IMPORTED_MODULE_2__platform_theme_common_colorRegistry_js__["o" /* editorBackground */] }, __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('editorGutter', 'Background color of the editor gutter. The gutter contains the glyph margins and the line numbers.'));
var editorUnnecessaryCodeBorder = Object(__WEBPACK_IMPORTED_MODULE_2__platform_theme_common_colorRegistry_js__["_45" /* registerColor */])('editorUnnecessaryCode.border', { dark: null, light: null, hc: __WEBPACK_IMPORTED_MODULE_1__base_common_color_js__["a" /* Color */].fromHex('#fff').transparent(0.8) }, __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('unnecessaryCodeBorder', 'Border color of unnecessary (unused) source code in the editor.'));
var editorUnnecessaryCodeOpacity = Object(__WEBPACK_IMPORTED_MODULE_2__platform_theme_common_colorRegistry_js__["_45" /* registerColor */])('editorUnnecessaryCode.opacity', { dark: __WEBPACK_IMPORTED_MODULE_1__base_common_color_js__["a" /* Color */].fromHex('#000a'), light: __WEBPACK_IMPORTED_MODULE_1__base_common_color_js__["a" /* Color */].fromHex('#0007'), hc: null }, __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('unnecessaryCodeOpacity', 'Opacity of unnecessary (unused) source code in the editor. For example, "#000000c0" will render the code with 75% opacity. For high contrast themes, use the  \'editorUnnecessaryCode.border\' theme color to underline unnecessary code instead of fading it out.'));
var overviewRulerError = Object(__WEBPACK_IMPORTED_MODULE_2__platform_theme_common_colorRegistry_js__["_45" /* registerColor */])('editorOverviewRuler.errorForeground', { dark: new __WEBPACK_IMPORTED_MODULE_1__base_common_color_js__["a" /* Color */](new __WEBPACK_IMPORTED_MODULE_1__base_common_color_js__["c" /* RGBA */](255, 18, 18, 0.7)), light: new __WEBPACK_IMPORTED_MODULE_1__base_common_color_js__["a" /* Color */](new __WEBPACK_IMPORTED_MODULE_1__base_common_color_js__["c" /* RGBA */](255, 18, 18, 0.7)), hc: new __WEBPACK_IMPORTED_MODULE_1__base_common_color_js__["a" /* Color */](new __WEBPACK_IMPORTED_MODULE_1__base_common_color_js__["c" /* RGBA */](255, 50, 50, 1)) }, __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('overviewRuleError', 'Overview ruler marker color for errors.'));
var overviewRulerWarning = Object(__WEBPACK_IMPORTED_MODULE_2__platform_theme_common_colorRegistry_js__["_45" /* registerColor */])('editorOverviewRuler.warningForeground', { dark: __WEBPACK_IMPORTED_MODULE_2__platform_theme_common_colorRegistry_js__["P" /* editorWarningForeground */], light: __WEBPACK_IMPORTED_MODULE_2__platform_theme_common_colorRegistry_js__["P" /* editorWarningForeground */], hc: __WEBPACK_IMPORTED_MODULE_2__platform_theme_common_colorRegistry_js__["O" /* editorWarningBorder */] }, __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('overviewRuleWarning', 'Overview ruler marker color for warnings.'));
var overviewRulerInfo = Object(__WEBPACK_IMPORTED_MODULE_2__platform_theme_common_colorRegistry_js__["_45" /* registerColor */])('editorOverviewRuler.infoForeground', { dark: __WEBPACK_IMPORTED_MODULE_2__platform_theme_common_colorRegistry_js__["H" /* editorInfoForeground */], light: __WEBPACK_IMPORTED_MODULE_2__platform_theme_common_colorRegistry_js__["H" /* editorInfoForeground */], hc: __WEBPACK_IMPORTED_MODULE_2__platform_theme_common_colorRegistry_js__["G" /* editorInfoBorder */] }, __WEBPACK_IMPORTED_MODULE_0__nls_js__["a" /* localize */]('overviewRuleInfo', 'Overview ruler marker color for infos.'));
// contains all color rules that used to defined in editor/browser/widget/editor.css
Object(__WEBPACK_IMPORTED_MODULE_3__platform_theme_common_themeService_js__["e" /* registerThemingParticipant */])(function (theme, collector) {
    var background = theme.getColor(__WEBPACK_IMPORTED_MODULE_2__platform_theme_common_colorRegistry_js__["o" /* editorBackground */]);
    if (background) {
        collector.addRule(".monaco-editor, .monaco-editor-background, .monaco-editor .inputarea.ime-input { background-color: " + background + "; }");
    }
    var foreground = theme.getColor(__WEBPACK_IMPORTED_MODULE_2__platform_theme_common_colorRegistry_js__["x" /* editorForeground */]);
    if (foreground) {
        collector.addRule(".monaco-editor, .monaco-editor .inputarea.ime-input { color: " + foreground + "; }");
    }
    var gutter = theme.getColor(editorGutter);
    if (gutter) {
        collector.addRule(".monaco-editor .margin { background-color: " + gutter + "; }");
    }
    var rangeHighlight = theme.getColor(editorRangeHighlight);
    if (rangeHighlight) {
        collector.addRule(".monaco-editor .rangeHighlight { background-color: " + rangeHighlight + "; }");
    }
    var rangeHighlightBorder = theme.getColor(editorRangeHighlightBorder);
    if (rangeHighlightBorder) {
        collector.addRule(".monaco-editor .rangeHighlight { border: 1px " + (theme.type === 'hc' ? 'dotted' : 'solid') + " " + rangeHighlightBorder + "; }");
    }
    var symbolHighlight = theme.getColor(editorSymbolHighlight);
    if (symbolHighlight) {
        collector.addRule(".monaco-editor .symbolHighlight { background-color: " + symbolHighlight + "; }");
    }
    var symbolHighlightBorder = theme.getColor(editorSymbolHighlightBorder);
    if (symbolHighlightBorder) {
        collector.addRule(".monaco-editor .symbolHighlight { border: 1px " + (theme.type === 'hc' ? 'dotted' : 'solid') + " " + symbolHighlightBorder + "; }");
    }
    var invisibles = theme.getColor(editorWhitespaces);
    if (invisibles) {
        collector.addRule(".vs-whitespace { color: " + invisibles + " !important; }");
    }
});


/***/ }),
/* 44 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return IConfigurationService; });
/* harmony export (immutable) */ __webpack_exports__["i"] = toValuesTree;
/* harmony export (immutable) */ __webpack_exports__["b"] = addToValueTree;
/* harmony export (immutable) */ __webpack_exports__["h"] = removeFromValueTree;
/* harmony export (immutable) */ __webpack_exports__["d"] = getConfigurationValue;
/* harmony export (immutable) */ __webpack_exports__["c"] = getConfigurationKeys;
/* harmony export (immutable) */ __webpack_exports__["e"] = getDefaultValues;
/* harmony export (immutable) */ __webpack_exports__["g"] = overrideIdentifierFromKey;
/* harmony export (immutable) */ __webpack_exports__["f"] = getMigratedSettingValue;
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__registry_common_platform_js__ = __webpack_require__(41);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__instantiation_common_instantiation_js__ = __webpack_require__(10);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2__configurationRegistry_js__ = __webpack_require__(88);



var IConfigurationService = Object(__WEBPACK_IMPORTED_MODULE_1__instantiation_common_instantiation_js__["c" /* createDecorator */])('configurationService');
function toValuesTree(properties, conflictReporter) {
    var root = Object.create(null);
    for (var key in properties) {
        addToValueTree(root, key, properties[key], conflictReporter);
    }
    return root;
}
function addToValueTree(settingsTreeRoot, key, value, conflictReporter) {
    var segments = key.split('.');
    var last = segments.pop();
    var curr = settingsTreeRoot;
    for (var i = 0; i < segments.length; i++) {
        var s = segments[i];
        var obj = curr[s];
        switch (typeof obj) {
            case 'undefined':
                obj = curr[s] = Object.create(null);
                break;
            case 'object':
                break;
            default:
                conflictReporter("Ignoring " + key + " as " + segments.slice(0, i + 1).join('.') + " is " + JSON.stringify(obj));
                return;
        }
        curr = obj;
    }
    if (typeof curr === 'object') {
        curr[last] = value; // workaround https://github.com/Microsoft/vscode/issues/13606
    }
    else {
        conflictReporter("Ignoring " + key + " as " + segments.join('.') + " is " + JSON.stringify(curr));
    }
}
function removeFromValueTree(valueTree, key) {
    var segments = key.split('.');
    doRemoveFromValueTree(valueTree, segments);
}
function doRemoveFromValueTree(valueTree, segments) {
    var first = segments.shift();
    if (segments.length === 0) {
        // Reached last segment
        delete valueTree[first];
        return;
    }
    if (Object.keys(valueTree).indexOf(first) !== -1) {
        var value = valueTree[first];
        if (typeof value === 'object' && !Array.isArray(value)) {
            doRemoveFromValueTree(value, segments);
            if (Object.keys(value).length === 0) {
                delete valueTree[first];
            }
        }
    }
}
/**
 * A helper function to get the configuration value with a specific settings path (e.g. config.some.setting)
 */
function getConfigurationValue(config, settingPath, defaultValue) {
    function accessSetting(config, path) {
        var current = config;
        for (var _i = 0, path_1 = path; _i < path_1.length; _i++) {
            var component = path_1[_i];
            if (typeof current !== 'object' || current === null) {
                return undefined;
            }
            current = current[component];
        }
        return current;
    }
    var path = settingPath.split('.');
    var result = accessSetting(config, path);
    return typeof result === 'undefined' ? defaultValue : result;
}
function getConfigurationKeys() {
    var properties = __WEBPACK_IMPORTED_MODULE_0__registry_common_platform_js__["a" /* Registry */].as(__WEBPACK_IMPORTED_MODULE_2__configurationRegistry_js__["a" /* Extensions */].Configuration).getConfigurationProperties();
    return Object.keys(properties);
}
function getDefaultValues() {
    var valueTreeRoot = Object.create(null);
    var properties = __WEBPACK_IMPORTED_MODULE_0__registry_common_platform_js__["a" /* Registry */].as(__WEBPACK_IMPORTED_MODULE_2__configurationRegistry_js__["a" /* Extensions */].Configuration).getConfigurationProperties();
    for (var key in properties) {
        var value = properties[key].default;
        addToValueTree(valueTreeRoot, key, value, function (message) { return console.error("Conflict in default settings: " + message); });
    }
    return valueTreeRoot;
}
function overrideIdentifierFromKey(key) {
    return key.substring(1, key.length - 1);
}
function getMigratedSettingValue(configurationService, currentSettingName, legacySettingName) {
    var setting = configurationService.inspect(currentSettingName);
    var legacySetting = configurationService.inspect(legacySettingName);
    if (typeof setting.userValue !== 'undefined' || typeof setting.workspaceValue !== 'undefined' || typeof setting.workspaceFolderValue !== 'undefined') {
        return setting.value;
    }
    else if (typeof legacySetting.userValue !== 'undefined' || typeof legacySetting.workspaceValue !== 'undefined' || typeof legacySetting.workspaceFolderValue !== 'undefined') {
        return legacySetting.value;
    }
    else {
        return setting.defaultValue;
    }
}


/***/ }),
/* 45 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "b", function() { return StandardMouseEvent; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return DragMouseEvent; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "c", function() { return StandardWheelEvent; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__browser_js__ = __webpack_require__(23);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__iframe_js__ = __webpack_require__(305);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2__common_platform_js__ = __webpack_require__(14);
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();



var StandardMouseEvent = /** @class */ (function () {
    function StandardMouseEvent(e) {
        this.timestamp = Date.now();
        this.browserEvent = e;
        this.leftButton = e.button === 0;
        this.middleButton = e.button === 1;
        this.rightButton = e.button === 2;
        this.buttons = e.buttons;
        this.target = e.target;
        this.detail = e.detail || 1;
        if (e.type === 'dblclick') {
            this.detail = 2;
        }
        this.ctrlKey = e.ctrlKey;
        this.shiftKey = e.shiftKey;
        this.altKey = e.altKey;
        this.metaKey = e.metaKey;
        if (typeof e.pageX === 'number') {
            this.posx = e.pageX;
            this.posy = e.pageY;
        }
        else {
            // Probably hit by MSGestureEvent
            this.posx = e.clientX + document.body.scrollLeft + document.documentElement.scrollLeft;
            this.posy = e.clientY + document.body.scrollTop + document.documentElement.scrollTop;
        }
        // Find the position of the iframe this code is executing in relative to the iframe where the event was captured.
        var iframeOffsets = __WEBPACK_IMPORTED_MODULE_1__iframe_js__["a" /* IframeUtils */].getPositionOfChildWindowRelativeToAncestorWindow(self, e.view);
        this.posx -= iframeOffsets.left;
        this.posy -= iframeOffsets.top;
    }
    StandardMouseEvent.prototype.preventDefault = function () {
        if (this.browserEvent.preventDefault) {
            this.browserEvent.preventDefault();
        }
    };
    StandardMouseEvent.prototype.stopPropagation = function () {
        if (this.browserEvent.stopPropagation) {
            this.browserEvent.stopPropagation();
        }
    };
    return StandardMouseEvent;
}());

var DragMouseEvent = /** @class */ (function (_super) {
    __extends(DragMouseEvent, _super);
    function DragMouseEvent(e) {
        var _this = _super.call(this, e) || this;
        _this.dataTransfer = e.dataTransfer;
        return _this;
    }
    return DragMouseEvent;
}(StandardMouseEvent));

var StandardWheelEvent = /** @class */ (function () {
    function StandardWheelEvent(e, deltaX, deltaY) {
        if (deltaX === void 0) { deltaX = 0; }
        if (deltaY === void 0) { deltaY = 0; }
        this.browserEvent = e || null;
        this.target = e ? (e.target || e.targetNode || e.srcElement) : null;
        this.deltaY = deltaY;
        this.deltaX = deltaX;
        if (e) {
            // Old (deprecated) wheel events
            var e1 = e;
            var e2 = e;
            // vertical delta scroll
            if (typeof e1.wheelDeltaY !== 'undefined') {
                this.deltaY = e1.wheelDeltaY / 120;
            }
            else if (typeof e2.VERTICAL_AXIS !== 'undefined' && e2.axis === e2.VERTICAL_AXIS) {
                this.deltaY = -e2.detail / 3;
            }
            else if (e.type === 'wheel') {
                // Modern wheel event
                // https://developer.mozilla.org/en-US/docs/Web/API/WheelEvent
                var ev = e;
                if (ev.deltaMode === ev.DOM_DELTA_LINE) {
                    // the deltas are expressed in lines
                    this.deltaY = -e.deltaY;
                }
                else {
                    this.deltaY = -e.deltaY / 40;
                }
            }
            // horizontal delta scroll
            if (typeof e1.wheelDeltaX !== 'undefined') {
                if (__WEBPACK_IMPORTED_MODULE_0__browser_js__["k" /* isSafari */] && __WEBPACK_IMPORTED_MODULE_2__common_platform_js__["h" /* isWindows */]) {
                    this.deltaX = -(e1.wheelDeltaX / 120);
                }
                else {
                    this.deltaX = e1.wheelDeltaX / 120;
                }
            }
            else if (typeof e2.HORIZONTAL_AXIS !== 'undefined' && e2.axis === e2.HORIZONTAL_AXIS) {
                this.deltaX = -e.detail / 3;
            }
            else if (e.type === 'wheel') {
                // Modern wheel event
                // https://developer.mozilla.org/en-US/docs/Web/API/WheelEvent
                var ev = e;
                if (ev.deltaMode === ev.DOM_DELTA_LINE) {
                    // the deltas are expressed in lines
                    this.deltaX = -e.deltaX;
                }
                else {
                    this.deltaX = -e.deltaX / 40;
                }
            }
            // Assume a vertical scroll if nothing else worked
            if (this.deltaY === 0 && this.deltaX === 0 && e.wheelDelta) {
                this.deltaY = e.wheelDelta / 120;
            }
        }
    }
    StandardWheelEvent.prototype.preventDefault = function () {
        if (this.browserEvent) {
            if (this.browserEvent.preventDefault) {
                this.browserEvent.preventDefault();
            }
        }
    };
    StandardWheelEvent.prototype.stopPropagation = function () {
        if (this.browserEvent) {
            if (this.browserEvent.stopPropagation) {
                this.browserEvent.stopPropagation();
            }
        }
    };
    return StandardWheelEvent;
}());



/***/ }),
/* 46 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "b", function() { return Schemas; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return RemoteAuthorities; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__uri_js__ = __webpack_require__(24);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__platform_js__ = __webpack_require__(14);
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/


var Schemas;
(function (Schemas) {
    /**
     * A schema that is used for models that exist in memory
     * only and that have no correspondence on a server or such.
     */
    Schemas.inMemory = 'inmemory';
    /**
     * A schema that is used for setting files
     */
    Schemas.vscode = 'vscode';
    /**
     * A schema that is used for internal private files
     */
    Schemas.internal = 'private';
    /**
     * A walk-through document.
     */
    Schemas.walkThrough = 'walkThrough';
    /**
     * An embedded code snippet.
     */
    Schemas.walkThroughSnippet = 'walkThroughSnippet';
    Schemas.http = 'http';
    Schemas.https = 'https';
    Schemas.file = 'file';
    Schemas.mailto = 'mailto';
    Schemas.untitled = 'untitled';
    Schemas.data = 'data';
    Schemas.command = 'command';
    Schemas.vscodeRemote = 'vscode-remote';
    Schemas.vscodeRemoteResource = 'vscode-remote-resource';
    Schemas.userData = 'vscode-userdata';
})(Schemas || (Schemas = {}));
var RemoteAuthoritiesImpl = /** @class */ (function () {
    function RemoteAuthoritiesImpl() {
        this._hosts = Object.create(null);
        this._ports = Object.create(null);
        this._connectionTokens = Object.create(null);
        this._preferredWebSchema = 'http';
        this._delegate = null;
    }
    RemoteAuthoritiesImpl.prototype.setPreferredWebSchema = function (schema) {
        this._preferredWebSchema = schema;
    };
    RemoteAuthoritiesImpl.prototype.rewrite = function (uri) {
        if (this._delegate) {
            return this._delegate(uri);
        }
        var authority = uri.authority;
        var host = this._hosts[authority];
        if (host && host.indexOf(':') !== -1) {
            host = "[" + host + "]";
        }
        var port = this._ports[authority];
        var connectionToken = this._connectionTokens[authority];
        var query = "path=" + encodeURIComponent(uri.path);
        if (typeof connectionToken === 'string') {
            query += "&tkn=" + encodeURIComponent(connectionToken);
        }
        return __WEBPACK_IMPORTED_MODULE_0__uri_js__["a" /* URI */].from({
            scheme: __WEBPACK_IMPORTED_MODULE_1__platform_js__["g" /* isWeb */] ? this._preferredWebSchema : Schemas.vscodeRemoteResource,
            authority: host + ":" + port,
            path: "/vscode-remote-resource",
            query: query
        });
    };
    return RemoteAuthoritiesImpl;
}());
var RemoteAuthorities = new RemoteAuthoritiesImpl();


/***/ }),
/* 47 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return Widget; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__dom_js__ = __webpack_require__(3);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__keyboardEvent_js__ = __webpack_require__(58);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2__mouseEvent_js__ = __webpack_require__(45);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3__common_lifecycle_js__ = __webpack_require__(0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4__touch_js__ = __webpack_require__(59);
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();





var Widget = /** @class */ (function (_super) {
    __extends(Widget, _super);
    function Widget() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Widget.prototype.onclick = function (domNode, listener) {
        this._register(__WEBPACK_IMPORTED_MODULE_0__dom_js__["j" /* addDisposableListener */](domNode, __WEBPACK_IMPORTED_MODULE_0__dom_js__["d" /* EventType */].CLICK, function (e) { return listener(new __WEBPACK_IMPORTED_MODULE_2__mouseEvent_js__["b" /* StandardMouseEvent */](e)); }));
    };
    Widget.prototype.onmousedown = function (domNode, listener) {
        this._register(__WEBPACK_IMPORTED_MODULE_0__dom_js__["j" /* addDisposableListener */](domNode, __WEBPACK_IMPORTED_MODULE_0__dom_js__["d" /* EventType */].MOUSE_DOWN, function (e) { return listener(new __WEBPACK_IMPORTED_MODULE_2__mouseEvent_js__["b" /* StandardMouseEvent */](e)); }));
    };
    Widget.prototype.onmouseover = function (domNode, listener) {
        this._register(__WEBPACK_IMPORTED_MODULE_0__dom_js__["j" /* addDisposableListener */](domNode, __WEBPACK_IMPORTED_MODULE_0__dom_js__["d" /* EventType */].MOUSE_OVER, function (e) { return listener(new __WEBPACK_IMPORTED_MODULE_2__mouseEvent_js__["b" /* StandardMouseEvent */](e)); }));
    };
    Widget.prototype.onnonbubblingmouseout = function (domNode, listener) {
        this._register(__WEBPACK_IMPORTED_MODULE_0__dom_js__["k" /* addDisposableNonBubblingMouseOutListener */](domNode, function (e) { return listener(new __WEBPACK_IMPORTED_MODULE_2__mouseEvent_js__["b" /* StandardMouseEvent */](e)); }));
    };
    Widget.prototype.onkeydown = function (domNode, listener) {
        this._register(__WEBPACK_IMPORTED_MODULE_0__dom_js__["j" /* addDisposableListener */](domNode, __WEBPACK_IMPORTED_MODULE_0__dom_js__["d" /* EventType */].KEY_DOWN, function (e) { return listener(new __WEBPACK_IMPORTED_MODULE_1__keyboardEvent_js__["a" /* StandardKeyboardEvent */](e)); }));
    };
    Widget.prototype.onkeyup = function (domNode, listener) {
        this._register(__WEBPACK_IMPORTED_MODULE_0__dom_js__["j" /* addDisposableListener */](domNode, __WEBPACK_IMPORTED_MODULE_0__dom_js__["d" /* EventType */].KEY_UP, function (e) { return listener(new __WEBPACK_IMPORTED_MODULE_1__keyboardEvent_js__["a" /* StandardKeyboardEvent */](e)); }));
    };
    Widget.prototype.oninput = function (domNode, listener) {
        this._register(__WEBPACK_IMPORTED_MODULE_0__dom_js__["j" /* addDisposableListener */](domNode, __WEBPACK_IMPORTED_MODULE_0__dom_js__["d" /* EventType */].INPUT, listener));
    };
    Widget.prototype.onblur = function (domNode, listener) {
        this._register(__WEBPACK_IMPORTED_MODULE_0__dom_js__["j" /* addDisposableListener */](domNode, __WEBPACK_IMPORTED_MODULE_0__dom_js__["d" /* EventType */].BLUR, listener));
    };
    Widget.prototype.onfocus = function (domNode, listener) {
        this._register(__WEBPACK_IMPORTED_MODULE_0__dom_js__["j" /* addDisposableListener */](domNode, __WEBPACK_IMPORTED_MODULE_0__dom_js__["d" /* EventType */].FOCUS, listener));
    };
    Widget.prototype.ignoreGesture = function (domNode) {
        __WEBPACK_IMPORTED_MODULE_4__touch_js__["b" /* Gesture */].ignoreTarget(domNode);
    };
    return Widget;
}(__WEBPACK_IMPORTED_MODULE_3__common_lifecycle_js__["a" /* Disposable */]));



/***/ }),
/* 48 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return IModelService; });
/* harmony export (immutable) */ __webpack_exports__["b"] = shouldSynchronizeModel;
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__platform_instantiation_common_instantiation_js__ = __webpack_require__(10);
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/

var IModelService = Object(__WEBPACK_IMPORTED_MODULE_0__platform_instantiation_common_instantiation_js__["c" /* createDecorator */])('modelService');
function shouldSynchronizeModel(model) {
    return (!model.isTooLargeForSyncing() && !model.isForSimpleWidget);
}


/***/ }),
/* 49 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "d", function() { return OverviewRulerLane; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "c", function() { return MinimapPosition; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "e", function() { return TextModelResolvedOptions; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "b", function() { return FindMatch; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return ApplyEditsResult; });
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
/**
 * Vertical Lane in the overview ruler of the editor.
 */
var OverviewRulerLane;
(function (OverviewRulerLane) {
    OverviewRulerLane[OverviewRulerLane["Left"] = 1] = "Left";
    OverviewRulerLane[OverviewRulerLane["Center"] = 2] = "Center";
    OverviewRulerLane[OverviewRulerLane["Right"] = 4] = "Right";
    OverviewRulerLane[OverviewRulerLane["Full"] = 7] = "Full";
})(OverviewRulerLane || (OverviewRulerLane = {}));
/**
 * Position in the minimap to render the decoration.
 */
var MinimapPosition;
(function (MinimapPosition) {
    MinimapPosition[MinimapPosition["Inline"] = 1] = "Inline";
    MinimapPosition[MinimapPosition["Gutter"] = 2] = "Gutter";
})(MinimapPosition || (MinimapPosition = {}));
var TextModelResolvedOptions = /** @class */ (function () {
    /**
     * @internal
     */
    function TextModelResolvedOptions(src) {
        this.tabSize = Math.max(1, src.tabSize | 0);
        this.indentSize = src.tabSize | 0;
        this.insertSpaces = Boolean(src.insertSpaces);
        this.defaultEOL = src.defaultEOL | 0;
        this.trimAutoWhitespace = Boolean(src.trimAutoWhitespace);
    }
    /**
     * @internal
     */
    TextModelResolvedOptions.prototype.equals = function (other) {
        return (this.tabSize === other.tabSize
            && this.indentSize === other.indentSize
            && this.insertSpaces === other.insertSpaces
            && this.defaultEOL === other.defaultEOL
            && this.trimAutoWhitespace === other.trimAutoWhitespace);
    };
    /**
     * @internal
     */
    TextModelResolvedOptions.prototype.createChangeEvent = function (newOpts) {
        return {
            tabSize: this.tabSize !== newOpts.tabSize,
            indentSize: this.indentSize !== newOpts.indentSize,
            insertSpaces: this.insertSpaces !== newOpts.insertSpaces,
            trimAutoWhitespace: this.trimAutoWhitespace !== newOpts.trimAutoWhitespace,
        };
    };
    return TextModelResolvedOptions;
}());

var FindMatch = /** @class */ (function () {
    /**
     * @internal
     */
    function FindMatch(range, matches) {
        this.range = range;
        this.matches = matches;
    }
    return FindMatch;
}());

/**
 * @internal
 */
var ApplyEditsResult = /** @class */ (function () {
    function ApplyEditsResult(reverseEdits, changes, trimAutoWhitespaceLineNumbers) {
        this.reverseEdits = reverseEdits;
        this.changes = changes;
        this.trimAutoWhitespaceLineNumbers = trimAutoWhitespaceLineNumbers;
    }
    return ApplyEditsResult;
}());



/***/ }),
/* 50 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (immutable) */ __webpack_exports__["b"] = setARIAContainer;
/* harmony export (immutable) */ __webpack_exports__["a"] = alert;
/* harmony export (immutable) */ __webpack_exports__["c"] = status;
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__aria_css__ = __webpack_require__(385);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__aria_css___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0__aria_css__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__nls_js__ = __webpack_require__(5);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2__common_platform_js__ = __webpack_require__(14);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3__dom_js__ = __webpack_require__(3);
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/




var ariaContainer;
var alertContainer;
var statusContainer;
function setARIAContainer(parent) {
    ariaContainer = document.createElement('div');
    ariaContainer.className = 'monaco-aria-container';
    alertContainer = document.createElement('div');
    alertContainer.className = 'monaco-alert';
    alertContainer.setAttribute('role', 'alert');
    alertContainer.setAttribute('aria-atomic', 'true');
    ariaContainer.appendChild(alertContainer);
    statusContainer = document.createElement('div');
    statusContainer.className = 'monaco-status';
    statusContainer.setAttribute('role', 'status');
    statusContainer.setAttribute('aria-atomic', 'true');
    ariaContainer.appendChild(statusContainer);
    parent.appendChild(ariaContainer);
}
/**
 * Given the provided message, will make sure that it is read as alert to screen readers.
 */
function alert(msg, disableRepeat) {
    insertMessage(alertContainer, msg, disableRepeat);
}
/**
 * Given the provided message, will make sure that it is read as status to screen readers.
 */
function status(msg, disableRepeat) {
    if (__WEBPACK_IMPORTED_MODULE_2__common_platform_js__["e" /* isMacintosh */]) {
        alert(msg, disableRepeat); // VoiceOver does not seem to support status role
    }
    else {
        insertMessage(statusContainer, msg, disableRepeat);
    }
}
var repeatedTimes = 0;
var prevText = undefined;
function insertMessage(target, msg, disableRepeat) {
    if (!ariaContainer) {
        return;
    }
    // If the same message should be inserted that is already present, a screen reader would
    // not announce this message because it matches the previous one. As a workaround, we
    // alter the message with the number of occurences unless this is explicitly disabled
    // via the disableRepeat flag.
    if (!disableRepeat) {
        if (prevText === msg) {
            repeatedTimes++;
        }
        else {
            prevText = msg;
            repeatedTimes = 0;
        }
        switch (repeatedTimes) {
            case 0: break;
            case 1:
                msg = __WEBPACK_IMPORTED_MODULE_1__nls_js__["a" /* localize */]('repeated', "{0} (occurred again)", msg);
                break;
            default:
                msg = __WEBPACK_IMPORTED_MODULE_1__nls_js__["a" /* localize */]('repeatedNtimes', "{0} (occurred {1} times)", msg, repeatedTimes);
                break;
        }
    }
    __WEBPACK_IMPORTED_MODULE_3__dom_js__["t" /* clearNode */](target);
    target.textContent = msg;
    // See https://www.paciellogroup.com/blog/2012/06/html5-accessibility-chops-aria-rolealert-browser-support/
    target.style.visibility = 'hidden';
    target.style.visibility = 'visible';
}


/***/ }),
/* 51 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return IOpenerService; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "b", function() { return NullOpenerService; });
/* harmony export (immutable) */ __webpack_exports__["c"] = matchesScheme;
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__base_common_uri_js__ = __webpack_require__(24);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__instantiation_common_instantiation_js__ = __webpack_require__(10);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2__base_common_lifecycle_js__ = __webpack_require__(0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3__base_common_strings_js__ = __webpack_require__(4);
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __generator = (this && this.__generator) || function (thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
};




var IOpenerService = Object(__WEBPACK_IMPORTED_MODULE_1__instantiation_common_instantiation_js__["c" /* createDecorator */])('openerService');
var NullOpenerService = Object.freeze({
    _serviceBrand: undefined,
    registerOpener: function () { return __WEBPACK_IMPORTED_MODULE_2__base_common_lifecycle_js__["a" /* Disposable */].None; },
    registerValidator: function () { return __WEBPACK_IMPORTED_MODULE_2__base_common_lifecycle_js__["a" /* Disposable */].None; },
    registerExternalUriResolver: function () { return __WEBPACK_IMPORTED_MODULE_2__base_common_lifecycle_js__["a" /* Disposable */].None; },
    setExternalOpener: function () { },
    open: function () {
        return __awaiter(this, void 0, void 0, function () { return __generator(this, function (_a) {
            return [2 /*return*/, false];
        }); });
    },
    resolveExternalUri: function (uri) {
        return __awaiter(this, void 0, void 0, function () { return __generator(this, function (_a) {
            return [2 /*return*/, { resolved: uri, dispose: function () { } }];
        }); });
    },
});
function matchesScheme(target, scheme) {
    if (__WEBPACK_IMPORTED_MODULE_0__base_common_uri_js__["a" /* URI */].isUri(target)) {
        return Object(__WEBPACK_IMPORTED_MODULE_3__base_common_strings_js__["n" /* equalsIgnoreCase */])(target.scheme, scheme);
    }
    else {
        return Object(__WEBPACK_IMPORTED_MODULE_3__base_common_strings_js__["O" /* startsWithIgnoreCase */])(target, scheme + ':');
    }
}


/***/ }),
/* 52 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (immutable) */ __webpack_exports__["a"] = loadMessageBundle;
/* unused harmony export config */
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
function format(message, args) {
    var result;
    if (args.length === 0) {
        result = message;
    }
    else {
        result = message.replace(/\{(\d+)\}/g, function (match, rest) {
            var index = rest[0];
            return typeof args[index] !== 'undefined' ? args[index] : match;
        });
    }
    return result;
}
function localize(key, message) {
    var args = [];
    for (var _i = 2; _i < arguments.length; _i++) {
        args[_i - 2] = arguments[_i];
    }
    return format(message, args);
}
function loadMessageBundle(file) {
    return localize;
}
function config(opt) {
    return loadMessageBundle;
}


/***/ }),
/* 53 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return domEvent; });
/* harmony export (immutable) */ __webpack_exports__["b"] = stop;
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__common_event_js__ = __webpack_require__(2);
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/

var domEvent = function (element, type, useCapture) {
    var fn = function (e) { return emitter.fire(e); };
    var emitter = new __WEBPACK_IMPORTED_MODULE_0__common_event_js__["a" /* Emitter */]({
        onFirstListenerAdd: function () {
            element.addEventListener(type, fn, useCapture);
        },
        onLastListenerRemove: function () {
            element.removeEventListener(type, fn, useCapture);
        }
    });
    return emitter.event;
};
function stop(event) {
    return __WEBPACK_IMPORTED_MODULE_0__common_event_js__["b" /* Event */].map(event, function (e) {
        e.preventDefault();
        e.stopPropagation();
        return e;
    });
}


/***/ }),
/* 54 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* unused harmony export MouseWheelClassifier */
/* unused harmony export AbstractScrollableElement */
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "b", function() { return ScrollableElement; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "c", function() { return SmoothScrollableElement; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return DomScrollableElement; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__media_scrollbars_css__ = __webpack_require__(427);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__media_scrollbars_css___default = __webpack_require__.n(__WEBPACK_IMPORTED_MODULE_0__media_scrollbars_css__);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__browser_js__ = __webpack_require__(23);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2__dom_js__ = __webpack_require__(3);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3__fastDomNode_js__ = __webpack_require__(26);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_4__mouseEvent_js__ = __webpack_require__(45);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_5__horizontalScrollbar_js__ = __webpack_require__(429);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_6__verticalScrollbar_js__ = __webpack_require__(431);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_7__widget_js__ = __webpack_require__(47);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_8__common_async_js__ = __webpack_require__(15);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_9__common_event_js__ = __webpack_require__(2);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_10__common_lifecycle_js__ = __webpack_require__(0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_11__common_platform_js__ = __webpack_require__(14);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_12__common_scrollable_js__ = __webpack_require__(321);
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();













var HIDE_TIMEOUT = 500;
var SCROLL_WHEEL_SENSITIVITY = 50;
var SCROLL_WHEEL_SMOOTH_SCROLL_ENABLED = true;
var MouseWheelClassifierItem = /** @class */ (function () {
    function MouseWheelClassifierItem(timestamp, deltaX, deltaY) {
        this.timestamp = timestamp;
        this.deltaX = deltaX;
        this.deltaY = deltaY;
        this.score = 0;
    }
    return MouseWheelClassifierItem;
}());
var MouseWheelClassifier = /** @class */ (function () {
    function MouseWheelClassifier() {
        this._capacity = 5;
        this._memory = [];
        this._front = -1;
        this._rear = -1;
    }
    MouseWheelClassifier.prototype.isPhysicalMouseWheel = function () {
        if (this._front === -1 && this._rear === -1) {
            // no elements
            return false;
        }
        // 0.5 * last + 0.25 * 2nd last + 0.125 * 3rd last + ...
        var remainingInfluence = 1;
        var score = 0;
        var iteration = 1;
        var index = this._rear;
        do {
            var influence = (index === this._front ? remainingInfluence : Math.pow(2, -iteration));
            remainingInfluence -= influence;
            score += this._memory[index].score * influence;
            if (index === this._front) {
                break;
            }
            index = (this._capacity + index - 1) % this._capacity;
            iteration++;
        } while (true);
        return (score <= 0.5);
    };
    MouseWheelClassifier.prototype.accept = function (timestamp, deltaX, deltaY) {
        var item = new MouseWheelClassifierItem(timestamp, deltaX, deltaY);
        item.score = this._computeScore(item);
        if (this._front === -1 && this._rear === -1) {
            this._memory[0] = item;
            this._front = 0;
            this._rear = 0;
        }
        else {
            this._rear = (this._rear + 1) % this._capacity;
            if (this._rear === this._front) {
                // Drop oldest
                this._front = (this._front + 1) % this._capacity;
            }
            this._memory[this._rear] = item;
        }
    };
    /**
     * A score between 0 and 1 for `item`.
     *  - a score towards 0 indicates that the source appears to be a physical mouse wheel
     *  - a score towards 1 indicates that the source appears to be a touchpad or magic mouse, etc.
     */
    MouseWheelClassifier.prototype._computeScore = function (item) {
        if (Math.abs(item.deltaX) > 0 && Math.abs(item.deltaY) > 0) {
            // both axes exercised => definitely not a physical mouse wheel
            return 1;
        }
        var score = 0.5;
        var prev = (this._front === -1 && this._rear === -1 ? null : this._memory[this._rear]);
        if (prev) {
            // const deltaT = item.timestamp - prev.timestamp;
            // if (deltaT < 1000 / 30) {
            // 	// sooner than X times per second => indicator that this is not a physical mouse wheel
            // 	score += 0.25;
            // }
            // if (item.deltaX === prev.deltaX && item.deltaY === prev.deltaY) {
            // 	// equal amplitude => indicator that this is a physical mouse wheel
            // 	score -= 0.25;
            // }
        }
        if (Math.abs(item.deltaX - Math.round(item.deltaX)) > 0 || Math.abs(item.deltaY - Math.round(item.deltaY)) > 0) {
            // non-integer deltas => indicator that this is not a physical mouse wheel
            score += 0.25;
        }
        return Math.min(Math.max(score, 0), 1);
    };
    MouseWheelClassifier.INSTANCE = new MouseWheelClassifier();
    return MouseWheelClassifier;
}());

var AbstractScrollableElement = /** @class */ (function (_super) {
    __extends(AbstractScrollableElement, _super);
    function AbstractScrollableElement(element, options, scrollable) {
        var _this = _super.call(this) || this;
        _this._onScroll = _this._register(new __WEBPACK_IMPORTED_MODULE_9__common_event_js__["a" /* Emitter */]());
        _this.onScroll = _this._onScroll.event;
        element.style.overflow = 'hidden';
        _this._options = resolveOptions(options);
        _this._scrollable = scrollable;
        _this._register(_this._scrollable.onScroll(function (e) {
            _this._onDidScroll(e);
            _this._onScroll.fire(e);
        }));
        var scrollbarHost = {
            onMouseWheel: function (mouseWheelEvent) { return _this._onMouseWheel(mouseWheelEvent); },
            onDragStart: function () { return _this._onDragStart(); },
            onDragEnd: function () { return _this._onDragEnd(); },
        };
        _this._verticalScrollbar = _this._register(new __WEBPACK_IMPORTED_MODULE_6__verticalScrollbar_js__["a" /* VerticalScrollbar */](_this._scrollable, _this._options, scrollbarHost));
        _this._horizontalScrollbar = _this._register(new __WEBPACK_IMPORTED_MODULE_5__horizontalScrollbar_js__["a" /* HorizontalScrollbar */](_this._scrollable, _this._options, scrollbarHost));
        _this._domNode = document.createElement('div');
        _this._domNode.className = 'monaco-scrollable-element ' + _this._options.className;
        _this._domNode.setAttribute('role', 'presentation');
        _this._domNode.style.position = 'relative';
        _this._domNode.style.overflow = 'hidden';
        _this._domNode.appendChild(element);
        _this._domNode.appendChild(_this._horizontalScrollbar.domNode.domNode);
        _this._domNode.appendChild(_this._verticalScrollbar.domNode.domNode);
        if (_this._options.useShadows) {
            _this._leftShadowDomNode = Object(__WEBPACK_IMPORTED_MODULE_3__fastDomNode_js__["b" /* createFastDomNode */])(document.createElement('div'));
            _this._leftShadowDomNode.setClassName('shadow');
            _this._domNode.appendChild(_this._leftShadowDomNode.domNode);
            _this._topShadowDomNode = Object(__WEBPACK_IMPORTED_MODULE_3__fastDomNode_js__["b" /* createFastDomNode */])(document.createElement('div'));
            _this._topShadowDomNode.setClassName('shadow');
            _this._domNode.appendChild(_this._topShadowDomNode.domNode);
            _this._topLeftShadowDomNode = Object(__WEBPACK_IMPORTED_MODULE_3__fastDomNode_js__["b" /* createFastDomNode */])(document.createElement('div'));
            _this._topLeftShadowDomNode.setClassName('shadow top-left-corner');
            _this._domNode.appendChild(_this._topLeftShadowDomNode.domNode);
        }
        else {
            _this._leftShadowDomNode = null;
            _this._topShadowDomNode = null;
            _this._topLeftShadowDomNode = null;
        }
        _this._listenOnDomNode = _this._options.listenOnDomNode || _this._domNode;
        _this._mouseWheelToDispose = [];
        _this._setListeningToMouseWheel(_this._options.handleMouseWheel);
        _this.onmouseover(_this._listenOnDomNode, function (e) { return _this._onMouseOver(e); });
        _this.onnonbubblingmouseout(_this._listenOnDomNode, function (e) { return _this._onMouseOut(e); });
        _this._hideTimeout = _this._register(new __WEBPACK_IMPORTED_MODULE_8__common_async_js__["e" /* TimeoutTimer */]());
        _this._isDragging = false;
        _this._mouseIsOver = false;
        _this._shouldRender = true;
        _this._revealOnScroll = true;
        return _this;
    }
    AbstractScrollableElement.prototype.dispose = function () {
        this._mouseWheelToDispose = Object(__WEBPACK_IMPORTED_MODULE_10__common_lifecycle_js__["f" /* dispose */])(this._mouseWheelToDispose);
        _super.prototype.dispose.call(this);
    };
    /**
     * Get the generated 'scrollable' dom node
     */
    AbstractScrollableElement.prototype.getDomNode = function () {
        return this._domNode;
    };
    AbstractScrollableElement.prototype.getOverviewRulerLayoutInfo = function () {
        return {
            parent: this._domNode,
            insertBefore: this._verticalScrollbar.domNode.domNode,
        };
    };
    /**
     * Delegate a mouse down event to the vertical scrollbar.
     * This is to help with clicking somewhere else and having the scrollbar react.
     */
    AbstractScrollableElement.prototype.delegateVerticalScrollbarMouseDown = function (browserEvent) {
        this._verticalScrollbar.delegateMouseDown(browserEvent);
    };
    AbstractScrollableElement.prototype.getScrollDimensions = function () {
        return this._scrollable.getScrollDimensions();
    };
    AbstractScrollableElement.prototype.setScrollDimensions = function (dimensions) {
        this._scrollable.setScrollDimensions(dimensions);
    };
    /**
     * Update the class name of the scrollable element.
     */
    AbstractScrollableElement.prototype.updateClassName = function (newClassName) {
        this._options.className = newClassName;
        // Defaults are different on Macs
        if (__WEBPACK_IMPORTED_MODULE_11__common_platform_js__["e" /* isMacintosh */]) {
            this._options.className += ' mac';
        }
        this._domNode.className = 'monaco-scrollable-element ' + this._options.className;
    };
    /**
     * Update configuration options for the scrollbar.
     * Really this is Editor.IEditorScrollbarOptions, but base shouldn't
     * depend on Editor.
     */
    AbstractScrollableElement.prototype.updateOptions = function (newOptions) {
        var massagedOptions = resolveOptions(newOptions);
        this._options.handleMouseWheel = massagedOptions.handleMouseWheel;
        this._options.mouseWheelScrollSensitivity = massagedOptions.mouseWheelScrollSensitivity;
        this._options.fastScrollSensitivity = massagedOptions.fastScrollSensitivity;
        this._setListeningToMouseWheel(this._options.handleMouseWheel);
        if (!this._options.lazyRender) {
            this._render();
        }
    };
    // -------------------- mouse wheel scrolling --------------------
    AbstractScrollableElement.prototype._setListeningToMouseWheel = function (shouldListen) {
        var _this = this;
        var isListening = (this._mouseWheelToDispose.length > 0);
        if (isListening === shouldListen) {
            // No change
            return;
        }
        // Stop listening (if necessary)
        this._mouseWheelToDispose = Object(__WEBPACK_IMPORTED_MODULE_10__common_lifecycle_js__["f" /* dispose */])(this._mouseWheelToDispose);
        // Start listening (if necessary)
        if (shouldListen) {
            var onMouseWheel = function (browserEvent) {
                _this._onMouseWheel(new __WEBPACK_IMPORTED_MODULE_4__mouseEvent_js__["c" /* StandardWheelEvent */](browserEvent));
            };
            this._mouseWheelToDispose.push(__WEBPACK_IMPORTED_MODULE_2__dom_js__["j" /* addDisposableListener */](this._listenOnDomNode, __WEBPACK_IMPORTED_MODULE_1__browser_js__["f" /* isEdgeOrIE */] ? 'mousewheel' : 'wheel', onMouseWheel, { passive: false }));
        }
    };
    AbstractScrollableElement.prototype._onMouseWheel = function (e) {
        var _a;
        var classifier = MouseWheelClassifier.INSTANCE;
        if (SCROLL_WHEEL_SMOOTH_SCROLL_ENABLED) {
            classifier.accept(Date.now(), e.deltaX, e.deltaY);
        }
        // console.log(`${Date.now()}, ${e.deltaY}, ${e.deltaX}`);
        if (e.deltaY || e.deltaX) {
            var deltaY = e.deltaY * this._options.mouseWheelScrollSensitivity;
            var deltaX = e.deltaX * this._options.mouseWheelScrollSensitivity;
            if (this._options.flipAxes) {
                _a = [deltaX, deltaY], deltaY = _a[0], deltaX = _a[1];
            }
            // Convert vertical scrolling to horizontal if shift is held, this
            // is handled at a higher level on Mac
            var shiftConvert = !__WEBPACK_IMPORTED_MODULE_11__common_platform_js__["e" /* isMacintosh */] && e.browserEvent && e.browserEvent.shiftKey;
            if ((this._options.scrollYToX || shiftConvert) && !deltaX) {
                deltaX = deltaY;
                deltaY = 0;
            }
            if (e.browserEvent && e.browserEvent.altKey) {
                // fastScrolling
                deltaX = deltaX * this._options.fastScrollSensitivity;
                deltaY = deltaY * this._options.fastScrollSensitivity;
            }
            var futureScrollPosition = this._scrollable.getFutureScrollPosition();
            var desiredScrollPosition = {};
            if (deltaY) {
                var desiredScrollTop = futureScrollPosition.scrollTop - SCROLL_WHEEL_SENSITIVITY * deltaY;
                this._verticalScrollbar.writeScrollPosition(desiredScrollPosition, desiredScrollTop);
            }
            if (deltaX) {
                var desiredScrollLeft = futureScrollPosition.scrollLeft - SCROLL_WHEEL_SENSITIVITY * deltaX;
                this._horizontalScrollbar.writeScrollPosition(desiredScrollPosition, desiredScrollLeft);
            }
            // Check that we are scrolling towards a location which is valid
            desiredScrollPosition = this._scrollable.validateScrollPosition(desiredScrollPosition);
            if (futureScrollPosition.scrollLeft !== desiredScrollPosition.scrollLeft || futureScrollPosition.scrollTop !== desiredScrollPosition.scrollTop) {
                var canPerformSmoothScroll = (SCROLL_WHEEL_SMOOTH_SCROLL_ENABLED
                    && this._options.mouseWheelSmoothScroll
                    && classifier.isPhysicalMouseWheel());
                if (canPerformSmoothScroll) {
                    this._scrollable.setScrollPositionSmooth(desiredScrollPosition);
                }
                else {
                    this._scrollable.setScrollPositionNow(desiredScrollPosition);
                }
                this._shouldRender = true;
            }
        }
        if (this._options.alwaysConsumeMouseWheel || this._shouldRender) {
            e.preventDefault();
            e.stopPropagation();
        }
    };
    AbstractScrollableElement.prototype._onDidScroll = function (e) {
        this._shouldRender = this._horizontalScrollbar.onDidScroll(e) || this._shouldRender;
        this._shouldRender = this._verticalScrollbar.onDidScroll(e) || this._shouldRender;
        if (this._options.useShadows) {
            this._shouldRender = true;
        }
        if (this._revealOnScroll) {
            this._reveal();
        }
        if (!this._options.lazyRender) {
            this._render();
        }
    };
    /**
     * Render / mutate the DOM now.
     * Should be used together with the ctor option `lazyRender`.
     */
    AbstractScrollableElement.prototype.renderNow = function () {
        if (!this._options.lazyRender) {
            throw new Error('Please use `lazyRender` together with `renderNow`!');
        }
        this._render();
    };
    AbstractScrollableElement.prototype._render = function () {
        if (!this._shouldRender) {
            return;
        }
        this._shouldRender = false;
        this._horizontalScrollbar.render();
        this._verticalScrollbar.render();
        if (this._options.useShadows) {
            var scrollState = this._scrollable.getCurrentScrollPosition();
            var enableTop = scrollState.scrollTop > 0;
            var enableLeft = scrollState.scrollLeft > 0;
            this._leftShadowDomNode.setClassName('shadow' + (enableLeft ? ' left' : ''));
            this._topShadowDomNode.setClassName('shadow' + (enableTop ? ' top' : ''));
            this._topLeftShadowDomNode.setClassName('shadow top-left-corner' + (enableTop ? ' top' : '') + (enableLeft ? ' left' : ''));
        }
    };
    // -------------------- fade in / fade out --------------------
    AbstractScrollableElement.prototype._onDragStart = function () {
        this._isDragging = true;
        this._reveal();
    };
    AbstractScrollableElement.prototype._onDragEnd = function () {
        this._isDragging = false;
        this._hide();
    };
    AbstractScrollableElement.prototype._onMouseOut = function (e) {
        this._mouseIsOver = false;
        this._hide();
    };
    AbstractScrollableElement.prototype._onMouseOver = function (e) {
        this._mouseIsOver = true;
        this._reveal();
    };
    AbstractScrollableElement.prototype._reveal = function () {
        this._verticalScrollbar.beginReveal();
        this._horizontalScrollbar.beginReveal();
        this._scheduleHide();
    };
    AbstractScrollableElement.prototype._hide = function () {
        if (!this._mouseIsOver && !this._isDragging) {
            this._verticalScrollbar.beginHide();
            this._horizontalScrollbar.beginHide();
        }
    };
    AbstractScrollableElement.prototype._scheduleHide = function () {
        var _this = this;
        if (!this._mouseIsOver && !this._isDragging) {
            this._hideTimeout.cancelAndSet(function () { return _this._hide(); }, HIDE_TIMEOUT);
        }
    };
    return AbstractScrollableElement;
}(__WEBPACK_IMPORTED_MODULE_7__widget_js__["a" /* Widget */]));

var ScrollableElement = /** @class */ (function (_super) {
    __extends(ScrollableElement, _super);
    function ScrollableElement(element, options) {
        var _this = this;
        options = options || {};
        options.mouseWheelSmoothScroll = false;
        var scrollable = new __WEBPACK_IMPORTED_MODULE_12__common_scrollable_js__["a" /* Scrollable */](0, function (callback) { return __WEBPACK_IMPORTED_MODULE_2__dom_js__["W" /* scheduleAtNextAnimationFrame */](callback); });
        _this = _super.call(this, element, options, scrollable) || this;
        _this._register(scrollable);
        return _this;
    }
    ScrollableElement.prototype.setScrollPosition = function (update) {
        this._scrollable.setScrollPositionNow(update);
    };
    ScrollableElement.prototype.getScrollPosition = function () {
        return this._scrollable.getCurrentScrollPosition();
    };
    return ScrollableElement;
}(AbstractScrollableElement));

var SmoothScrollableElement = /** @class */ (function (_super) {
    __extends(SmoothScrollableElement, _super);
    function SmoothScrollableElement(element, options, scrollable) {
        return _super.call(this, element, options, scrollable) || this;
    }
    return SmoothScrollableElement;
}(AbstractScrollableElement));

var DomScrollableElement = /** @class */ (function (_super) {
    __extends(DomScrollableElement, _super);
    function DomScrollableElement(element, options) {
        var _this = _super.call(this, element, options) || this;
        _this._element = element;
        _this.onScroll(function (e) {
            if (e.scrollTopChanged) {
                _this._element.scrollTop = e.scrollTop;
            }
            if (e.scrollLeftChanged) {
                _this._element.scrollLeft = e.scrollLeft;
            }
        });
        _this.scanDomNode();
        return _this;
    }
    DomScrollableElement.prototype.scanDomNode = function () {
        // width, scrollLeft, scrollWidth, height, scrollTop, scrollHeight
        this.setScrollDimensions({
            width: this._element.clientWidth,
            scrollWidth: this._element.scrollWidth,
            height: this._element.clientHeight,
            scrollHeight: this._element.scrollHeight
        });
        this.setScrollPosition({
            scrollLeft: this._element.scrollLeft,
            scrollTop: this._element.scrollTop,
        });
    };
    return DomScrollableElement;
}(ScrollableElement));

function resolveOptions(opts) {
    var result = {
        lazyRender: (typeof opts.lazyRender !== 'undefined' ? opts.lazyRender : false),
        className: (typeof opts.className !== 'undefined' ? opts.className : ''),
        useShadows: (typeof opts.useShadows !== 'undefined' ? opts.useShadows : true),
        handleMouseWheel: (typeof opts.handleMouseWheel !== 'undefined' ? opts.handleMouseWheel : true),
        flipAxes: (typeof opts.flipAxes !== 'undefined' ? opts.flipAxes : false),
        alwaysConsumeMouseWheel: (typeof opts.alwaysConsumeMouseWheel !== 'undefined' ? opts.alwaysConsumeMouseWheel : false),
        scrollYToX: (typeof opts.scrollYToX !== 'undefined' ? opts.scrollYToX : false),
        mouseWheelScrollSensitivity: (typeof opts.mouseWheelScrollSensitivity !== 'undefined' ? opts.mouseWheelScrollSensitivity : 1),
        fastScrollSensitivity: (typeof opts.fastScrollSensitivity !== 'undefined' ? opts.fastScrollSensitivity : 5),
        mouseWheelSmoothScroll: (typeof opts.mouseWheelSmoothScroll !== 'undefined' ? opts.mouseWheelSmoothScroll : true),
        arrowSize: (typeof opts.arrowSize !== 'undefined' ? opts.arrowSize : 11),
        listenOnDomNode: (typeof opts.listenOnDomNode !== 'undefined' ? opts.listenOnDomNode : null),
        horizontal: (typeof opts.horizontal !== 'undefined' ? opts.horizontal : 1 /* Auto */),
        horizontalScrollbarSize: (typeof opts.horizontalScrollbarSize !== 'undefined' ? opts.horizontalScrollbarSize : 10),
        horizontalSliderSize: (typeof opts.horizontalSliderSize !== 'undefined' ? opts.horizontalSliderSize : 0),
        horizontalHasArrows: (typeof opts.horizontalHasArrows !== 'undefined' ? opts.horizontalHasArrows : false),
        vertical: (typeof opts.vertical !== 'undefined' ? opts.vertical : 1 /* Auto */),
        verticalScrollbarSize: (typeof opts.verticalScrollbarSize !== 'undefined' ? opts.verticalScrollbarSize : 10),
        verticalHasArrows: (typeof opts.verticalHasArrows !== 'undefined' ? opts.verticalHasArrows : false),
        verticalSliderSize: (typeof opts.verticalSliderSize !== 'undefined' ? opts.verticalSliderSize : 0)
    };
    result.horizontalSliderSize = (typeof opts.horizontalSliderSize !== 'undefined' ? opts.horizontalSliderSize : result.horizontalScrollbarSize);
    result.verticalSliderSize = (typeof opts.verticalSliderSize !== 'undefined' ? opts.verticalSliderSize : result.verticalScrollbarSize);
    // Defaults are different on Macs
    if (__WEBPACK_IMPORTED_MODULE_11__common_platform_js__["e" /* isMacintosh */]) {
        result.className += ' mac';
    }
    return result;
}


/***/ }),
/* 55 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* unused harmony export ClientCapabilities */
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "h", function() { return FileType; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__vscode_languageserver_types_main_js__ = __webpack_require__(367);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__deps_vscode_languageserver_textdocument_lib_esm_main_js__ = __webpack_require__(743);
/* unused harmony reexport TextDocument */
/* harmony namespace reexport (by used) */ __webpack_require__.d(__webpack_exports__, "a", function() { return __WEBPACK_IMPORTED_MODULE_0__vscode_languageserver_types_main_js__["a"]; });
/* harmony namespace reexport (by used) */ __webpack_require__.d(__webpack_exports__, "b", function() { return __WEBPACK_IMPORTED_MODULE_0__vscode_languageserver_types_main_js__["b"]; });
/* harmony namespace reexport (by used) */ __webpack_require__.d(__webpack_exports__, "c", function() { return __WEBPACK_IMPORTED_MODULE_0__vscode_languageserver_types_main_js__["c"]; });
/* harmony namespace reexport (by used) */ __webpack_require__.d(__webpack_exports__, "d", function() { return __WEBPACK_IMPORTED_MODULE_0__vscode_languageserver_types_main_js__["d"]; });
/* harmony namespace reexport (by used) */ __webpack_require__.d(__webpack_exports__, "e", function() { return __WEBPACK_IMPORTED_MODULE_0__vscode_languageserver_types_main_js__["e"]; });
/* harmony namespace reexport (by used) */ __webpack_require__.d(__webpack_exports__, "f", function() { return __WEBPACK_IMPORTED_MODULE_0__vscode_languageserver_types_main_js__["f"]; });
/* harmony namespace reexport (by used) */ __webpack_require__.d(__webpack_exports__, "g", function() { return __WEBPACK_IMPORTED_MODULE_0__vscode_languageserver_types_main_js__["g"]; });
/* harmony namespace reexport (by used) */ __webpack_require__.d(__webpack_exports__, "i", function() { return __WEBPACK_IMPORTED_MODULE_0__vscode_languageserver_types_main_js__["h"]; });
/* harmony namespace reexport (by used) */ __webpack_require__.d(__webpack_exports__, "j", function() { return __WEBPACK_IMPORTED_MODULE_0__vscode_languageserver_types_main_js__["i"]; });
/* harmony namespace reexport (by used) */ __webpack_require__.d(__webpack_exports__, "k", function() { return __WEBPACK_IMPORTED_MODULE_0__vscode_languageserver_types_main_js__["j"]; });
/* harmony namespace reexport (by used) */ __webpack_require__.d(__webpack_exports__, "l", function() { return __WEBPACK_IMPORTED_MODULE_0__vscode_languageserver_types_main_js__["k"]; });
/* harmony namespace reexport (by used) */ __webpack_require__.d(__webpack_exports__, "m", function() { return __WEBPACK_IMPORTED_MODULE_0__vscode_languageserver_types_main_js__["l"]; });
/* harmony namespace reexport (by used) */ __webpack_require__.d(__webpack_exports__, "n", function() { return __WEBPACK_IMPORTED_MODULE_0__vscode_languageserver_types_main_js__["m"]; });
/* harmony namespace reexport (by used) */ __webpack_require__.d(__webpack_exports__, "o", function() { return __WEBPACK_IMPORTED_MODULE_0__vscode_languageserver_types_main_js__["n"]; });
/* harmony namespace reexport (by used) */ __webpack_require__.d(__webpack_exports__, "p", function() { return __WEBPACK_IMPORTED_MODULE_0__vscode_languageserver_types_main_js__["o"]; });
/* harmony namespace reexport (by used) */ __webpack_require__.d(__webpack_exports__, "q", function() { return __WEBPACK_IMPORTED_MODULE_0__vscode_languageserver_types_main_js__["p"]; });
/* harmony namespace reexport (by used) */ __webpack_require__.d(__webpack_exports__, "r", function() { return __WEBPACK_IMPORTED_MODULE_0__vscode_languageserver_types_main_js__["q"]; });
/* harmony namespace reexport (by used) */ __webpack_require__.d(__webpack_exports__, "s", function() { return __WEBPACK_IMPORTED_MODULE_0__vscode_languageserver_types_main_js__["r"]; });
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/




var ClientCapabilities;
(function (ClientCapabilities) {
    ClientCapabilities.LATEST = {
        textDocument: {
            completion: {
                completionItem: {
                    documentationFormat: [__WEBPACK_IMPORTED_MODULE_0__vscode_languageserver_types_main_js__["k" /* MarkupKind */].Markdown, __WEBPACK_IMPORTED_MODULE_0__vscode_languageserver_types_main_js__["k" /* MarkupKind */].PlainText]
                }
            },
            hover: {
                contentFormat: [__WEBPACK_IMPORTED_MODULE_0__vscode_languageserver_types_main_js__["k" /* MarkupKind */].Markdown, __WEBPACK_IMPORTED_MODULE_0__vscode_languageserver_types_main_js__["k" /* MarkupKind */].PlainText]
            }
        }
    };
})(ClientCapabilities || (ClientCapabilities = {}));
var FileType;
(function (FileType) {
    /**
     * The file type is unknown.
     */
    FileType[FileType["Unknown"] = 0] = "Unknown";
    /**
     * A regular file.
     */
    FileType[FileType["File"] = 1] = "File";
    /**
     * A directory.
     */
    FileType[FileType["Directory"] = 2] = "Directory";
    /**
     * A symbolic link to a file.
     */
    FileType[FileType["SymbolicLink"] = 64] = "SymbolicLink";
})(FileType || (FileType = {}));


/***/ }),
/* 56 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "h", function() { return Position; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "i", function() { return Range; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "f", function() { return Location; });
/* unused harmony export LocationLink */
/* unused harmony export Color */
/* unused harmony export ColorInformation */
/* unused harmony export ColorPresentation */
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "d", function() { return FoldingRangeKind; });
/* unused harmony export FoldingRange */
/* unused harmony export DiagnosticRelatedInformation */
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "b", function() { return DiagnosticSeverity; });
/* unused harmony export DiagnosticTag */
/* unused harmony export Diagnostic */
/* unused harmony export Command */
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "l", function() { return TextEdit; });
/* unused harmony export TextDocumentEdit */
/* unused harmony export CreateFile */
/* unused harmony export RenameFile */
/* unused harmony export DeleteFile */
/* unused harmony export WorkspaceEdit */
/* unused harmony export WorkspaceChange */
/* unused harmony export TextDocumentIdentifier */
/* unused harmony export VersionedTextDocumentIdentifier */
/* unused harmony export TextDocumentItem */
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "g", function() { return MarkupKind; });
/* unused harmony export MarkupContent */
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return CompletionItemKind; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "e", function() { return InsertTextFormat; });
/* unused harmony export CompletionItemTag */
/* unused harmony export CompletionItem */
/* unused harmony export CompletionList */
/* unused harmony export MarkedString */
/* unused harmony export Hover */
/* unused harmony export ParameterInformation */
/* unused harmony export SignatureInformation */
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "c", function() { return DocumentHighlightKind; });
/* unused harmony export DocumentHighlight */
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "k", function() { return SymbolKind; });
/* unused harmony export SymbolTag */
/* unused harmony export SymbolInformation */
/* unused harmony export DocumentSymbol */
/* unused harmony export CodeActionKind */
/* unused harmony export CodeActionContext */
/* unused harmony export CodeAction */
/* unused harmony export CodeLens */
/* unused harmony export FormattingOptions */
/* unused harmony export DocumentLink */
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "j", function() { return SelectionRange; });
/* unused harmony export EOL */
/* unused harmony export TextDocument */
/* --------------------------------------------------------------------------------------------
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License. See License.txt in the project root for license information.
 * ------------------------------------------------------------------------------------------ */

/**
 * The Position namespace provides helper functions to work with
 * [Position](#Position) literals.
 */
var Position;
(function (Position) {
    /**
     * Creates a new Position literal from the given line and character.
     * @param line The position's line.
     * @param character The position's character.
     */
    function create(line, character) {
        return { line: line, character: character };
    }
    Position.create = create;
    /**
     * Checks whether the given liternal conforms to the [Position](#Position) interface.
     */
    function is(value) {
        var candidate = value;
        return Is.objectLiteral(candidate) && Is.number(candidate.line) && Is.number(candidate.character);
    }
    Position.is = is;
})(Position || (Position = {}));
/**
 * The Range namespace provides helper functions to work with
 * [Range](#Range) literals.
 */
var Range;
(function (Range) {
    function create(one, two, three, four) {
        if (Is.number(one) && Is.number(two) && Is.number(three) && Is.number(four)) {
            return { start: Position.create(one, two), end: Position.create(three, four) };
        }
        else if (Position.is(one) && Position.is(two)) {
            return { start: one, end: two };
        }
        else {
            throw new Error("Range#create called with invalid arguments[" + one + ", " + two + ", " + three + ", " + four + "]");
        }
    }
    Range.create = create;
    /**
     * Checks whether the given literal conforms to the [Range](#Range) interface.
     */
    function is(value) {
        var candidate = value;
        return Is.objectLiteral(candidate) && Position.is(candidate.start) && Position.is(candidate.end);
    }
    Range.is = is;
})(Range || (Range = {}));
/**
 * The Location namespace provides helper functions to work with
 * [Location](#Location) literals.
 */
var Location;
(function (Location) {
    /**
     * Creates a Location literal.
     * @param uri The location's uri.
     * @param range The location's range.
     */
    function create(uri, range) {
        return { uri: uri, range: range };
    }
    Location.create = create;
    /**
     * Checks whether the given literal conforms to the [Location](#Location) interface.
     */
    function is(value) {
        var candidate = value;
        return Is.defined(candidate) && Range.is(candidate.range) && (Is.string(candidate.uri) || Is.undefined(candidate.uri));
    }
    Location.is = is;
})(Location || (Location = {}));
/**
 * The LocationLink namespace provides helper functions to work with
 * [LocationLink](#LocationLink) literals.
 */
var LocationLink;
(function (LocationLink) {
    /**
     * Creates a LocationLink literal.
     * @param targetUri The definition's uri.
     * @param targetRange The full range of the definition.
     * @param targetSelectionRange The span of the symbol definition at the target.
     * @param originSelectionRange The span of the symbol being defined in the originating source file.
     */
    function create(targetUri, targetRange, targetSelectionRange, originSelectionRange) {
        return { targetUri: targetUri, targetRange: targetRange, targetSelectionRange: targetSelectionRange, originSelectionRange: originSelectionRange };
    }
    LocationLink.create = create;
    /**
     * Checks whether the given literal conforms to the [LocationLink](#LocationLink) interface.
     */
    function is(value) {
        var candidate = value;
        return Is.defined(candidate) && Range.is(candidate.targetRange) && Is.string(candidate.targetUri)
            && (Range.is(candidate.targetSelectionRange) || Is.undefined(candidate.targetSelectionRange))
            && (Range.is(candidate.originSelectionRange) || Is.undefined(candidate.originSelectionRange));
    }
    LocationLink.is = is;
})(LocationLink || (LocationLink = {}));
/**
 * The Color namespace provides helper functions to work with
 * [Color](#Color) literals.
 */
var Color;
(function (Color) {
    /**
     * Creates a new Color literal.
     */
    function create(red, green, blue, alpha) {
        return {
            red: red,
            green: green,
            blue: blue,
            alpha: alpha,
        };
    }
    Color.create = create;
    /**
     * Checks whether the given literal conforms to the [Color](#Color) interface.
     */
    function is(value) {
        var candidate = value;
        return Is.number(candidate.red)
            && Is.number(candidate.green)
            && Is.number(candidate.blue)
            && Is.number(candidate.alpha);
    }
    Color.is = is;
})(Color || (Color = {}));
/**
 * The ColorInformation namespace provides helper functions to work with
 * [ColorInformation](#ColorInformation) literals.
 */
var ColorInformation;
(function (ColorInformation) {
    /**
     * Creates a new ColorInformation literal.
     */
    function create(range, color) {
        return {
            range: range,
            color: color,
        };
    }
    ColorInformation.create = create;
    /**
     * Checks whether the given literal conforms to the [ColorInformation](#ColorInformation) interface.
     */
    function is(value) {
        var candidate = value;
        return Range.is(candidate.range) && Color.is(candidate.color);
    }
    ColorInformation.is = is;
})(ColorInformation || (ColorInformation = {}));
/**
 * The Color namespace provides helper functions to work with
 * [ColorPresentation](#ColorPresentation) literals.
 */
var ColorPresentation;
(function (ColorPresentation) {
    /**
     * Creates a new ColorInformation literal.
     */
    function create(label, textEdit, additionalTextEdits) {
        return {
            label: label,
            textEdit: textEdit,
            additionalTextEdits: additionalTextEdits,
        };
    }
    ColorPresentation.create = create;
    /**
     * Checks whether the given literal conforms to the [ColorInformation](#ColorInformation) interface.
     */
    function is(value) {
        var candidate = value;
        return Is.string(candidate.label)
            && (Is.undefined(candidate.textEdit) || TextEdit.is(candidate))
            && (Is.undefined(candidate.additionalTextEdits) || Is.typedArray(candidate.additionalTextEdits, TextEdit.is));
    }
    ColorPresentation.is = is;
})(ColorPresentation || (ColorPresentation = {}));
/**
 * Enum of known range kinds
 */
var FoldingRangeKind;
(function (FoldingRangeKind) {
    /**
     * Folding range for a comment
     */
    FoldingRangeKind["Comment"] = "comment";
    /**
     * Folding range for a imports or includes
     */
    FoldingRangeKind["Imports"] = "imports";
    /**
     * Folding range for a region (e.g. `#region`)
     */
    FoldingRangeKind["Region"] = "region";
})(FoldingRangeKind || (FoldingRangeKind = {}));
/**
 * The folding range namespace provides helper functions to work with
 * [FoldingRange](#FoldingRange) literals.
 */
var FoldingRange;
(function (FoldingRange) {
    /**
     * Creates a new FoldingRange literal.
     */
    function create(startLine, endLine, startCharacter, endCharacter, kind) {
        var result = {
            startLine: startLine,
            endLine: endLine
        };
        if (Is.defined(startCharacter)) {
            result.startCharacter = startCharacter;
        }
        if (Is.defined(endCharacter)) {
            result.endCharacter = endCharacter;
        }
        if (Is.defined(kind)) {
            result.kind = kind;
        }
        return result;
    }
    FoldingRange.create = create;
    /**
     * Checks whether the given literal conforms to the [FoldingRange](#FoldingRange) interface.
     */
    function is(value) {
        var candidate = value;
        return Is.number(candidate.startLine) && Is.number(candidate.startLine)
            && (Is.undefined(candidate.startCharacter) || Is.number(candidate.startCharacter))
            && (Is.undefined(candidate.endCharacter) || Is.number(candidate.endCharacter))
            && (Is.undefined(candidate.kind) || Is.string(candidate.kind));
    }
    FoldingRange.is = is;
})(FoldingRange || (FoldingRange = {}));
/**
 * The DiagnosticRelatedInformation namespace provides helper functions to work with
 * [DiagnosticRelatedInformation](#DiagnosticRelatedInformation) literals.
 */
var DiagnosticRelatedInformation;
(function (DiagnosticRelatedInformation) {
    /**
     * Creates a new DiagnosticRelatedInformation literal.
     */
    function create(location, message) {
        return {
            location: location,
            message: message
        };
    }
    DiagnosticRelatedInformation.create = create;
    /**
     * Checks whether the given literal conforms to the [DiagnosticRelatedInformation](#DiagnosticRelatedInformation) interface.
     */
    function is(value) {
        var candidate = value;
        return Is.defined(candidate) && Location.is(candidate.location) && Is.string(candidate.message);
    }
    DiagnosticRelatedInformation.is = is;
})(DiagnosticRelatedInformation || (DiagnosticRelatedInformation = {}));
/**
 * The diagnostic's severity.
 */
var DiagnosticSeverity;
(function (DiagnosticSeverity) {
    /**
     * Reports an error.
     */
    DiagnosticSeverity.Error = 1;
    /**
     * Reports a warning.
     */
    DiagnosticSeverity.Warning = 2;
    /**
     * Reports an information.
     */
    DiagnosticSeverity.Information = 3;
    /**
     * Reports a hint.
     */
    DiagnosticSeverity.Hint = 4;
})(DiagnosticSeverity || (DiagnosticSeverity = {}));
/**
 * The diagnostic tags.
 *
 * @since 3.15.0
 */
var DiagnosticTag;
(function (DiagnosticTag) {
    /**
     * Unused or unnecessary code.
     *
     * Clients are allowed to render diagnostics with this tag faded out instead of having
     * an error squiggle.
     */
    DiagnosticTag.Unnecessary = 1;
    /**
     * Deprecated or obsolete code.
     *
     * Clients are allowed to rendered diagnostics with this tag strike through.
     */
    DiagnosticTag.Deprecated = 2;
})(DiagnosticTag || (DiagnosticTag = {}));
/**
 * The Diagnostic namespace provides helper functions to work with
 * [Diagnostic](#Diagnostic) literals.
 */
var Diagnostic;
(function (Diagnostic) {
    /**
     * Creates a new Diagnostic literal.
     */
    function create(range, message, severity, code, source, relatedInformation) {
        var result = { range: range, message: message };
        if (Is.defined(severity)) {
            result.severity = severity;
        }
        if (Is.defined(code)) {
            result.code = code;
        }
        if (Is.defined(source)) {
            result.source = source;
        }
        if (Is.defined(relatedInformation)) {
            result.relatedInformation = relatedInformation;
        }
        return result;
    }
    Diagnostic.create = create;
    /**
     * Checks whether the given literal conforms to the [Diagnostic](#Diagnostic) interface.
     */
    function is(value) {
        var candidate = value;
        return Is.defined(candidate)
            && Range.is(candidate.range)
            && Is.string(candidate.message)
            && (Is.number(candidate.severity) || Is.undefined(candidate.severity))
            && (Is.number(candidate.code) || Is.string(candidate.code) || Is.undefined(candidate.code))
            && (Is.string(candidate.source) || Is.undefined(candidate.source))
            && (Is.undefined(candidate.relatedInformation) || Is.typedArray(candidate.relatedInformation, DiagnosticRelatedInformation.is));
    }
    Diagnostic.is = is;
})(Diagnostic || (Diagnostic = {}));
/**
 * The Command namespace provides helper functions to work with
 * [Command](#Command) literals.
 */
var Command;
(function (Command) {
    /**
     * Creates a new Command literal.
     */
    function create(title, command) {
        var args = [];
        for (var _i = 2; _i < arguments.length; _i++) {
            args[_i - 2] = arguments[_i];
        }
        var result = { title: title, command: command };
        if (Is.defined(args) && args.length > 0) {
            result.arguments = args;
        }
        return result;
    }
    Command.create = create;
    /**
     * Checks whether the given literal conforms to the [Command](#Command) interface.
     */
    function is(value) {
        var candidate = value;
        return Is.defined(candidate) && Is.string(candidate.title) && Is.string(candidate.command);
    }
    Command.is = is;
})(Command || (Command = {}));
/**
 * The TextEdit namespace provides helper function to create replace,
 * insert and delete edits more easily.
 */
var TextEdit;
(function (TextEdit) {
    /**
     * Creates a replace text edit.
     * @param range The range of text to be replaced.
     * @param newText The new text.
     */
    function replace(range, newText) {
        return { range: range, newText: newText };
    }
    TextEdit.replace = replace;
    /**
     * Creates a insert text edit.
     * @param position The position to insert the text at.
     * @param newText The text to be inserted.
     */
    function insert(position, newText) {
        return { range: { start: position, end: position }, newText: newText };
    }
    TextEdit.insert = insert;
    /**
     * Creates a delete text edit.
     * @param range The range of text to be deleted.
     */
    function del(range) {
        return { range: range, newText: '' };
    }
    TextEdit.del = del;
    function is(value) {
        var candidate = value;
        return Is.objectLiteral(candidate)
            && Is.string(candidate.newText)
            && Range.is(candidate.range);
    }
    TextEdit.is = is;
})(TextEdit || (TextEdit = {}));
/**
 * The TextDocumentEdit namespace provides helper function to create
 * an edit that manipulates a text document.
 */
var TextDocumentEdit;
(function (TextDocumentEdit) {
    /**
     * Creates a new `TextDocumentEdit`
     */
    function create(textDocument, edits) {
        return { textDocument: textDocument, edits: edits };
    }
    TextDocumentEdit.create = create;
    function is(value) {
        var candidate = value;
        return Is.defined(candidate)
            && VersionedTextDocumentIdentifier.is(candidate.textDocument)
            && Array.isArray(candidate.edits);
    }
    TextDocumentEdit.is = is;
})(TextDocumentEdit || (TextDocumentEdit = {}));
var CreateFile;
(function (CreateFile) {
    function create(uri, options) {
        var result = {
            kind: 'create',
            uri: uri
        };
        if (options !== void 0 && (options.overwrite !== void 0 || options.ignoreIfExists !== void 0)) {
            result.options = options;
        }
        return result;
    }
    CreateFile.create = create;
    function is(value) {
        var candidate = value;
        return candidate && candidate.kind === 'create' && Is.string(candidate.uri) &&
            (candidate.options === void 0 ||
                ((candidate.options.overwrite === void 0 || Is.boolean(candidate.options.overwrite)) && (candidate.options.ignoreIfExists === void 0 || Is.boolean(candidate.options.ignoreIfExists))));
    }
    CreateFile.is = is;
})(CreateFile || (CreateFile = {}));
var RenameFile;
(function (RenameFile) {
    function create(oldUri, newUri, options) {
        var result = {
            kind: 'rename',
            oldUri: oldUri,
            newUri: newUri
        };
        if (options !== void 0 && (options.overwrite !== void 0 || options.ignoreIfExists !== void 0)) {
            result.options = options;
        }
        return result;
    }
    RenameFile.create = create;
    function is(value) {
        var candidate = value;
        return candidate && candidate.kind === 'rename' && Is.string(candidate.oldUri) && Is.string(candidate.newUri) &&
            (candidate.options === void 0 ||
                ((candidate.options.overwrite === void 0 || Is.boolean(candidate.options.overwrite)) && (candidate.options.ignoreIfExists === void 0 || Is.boolean(candidate.options.ignoreIfExists))));
    }
    RenameFile.is = is;
})(RenameFile || (RenameFile = {}));
var DeleteFile;
(function (DeleteFile) {
    function create(uri, options) {
        var result = {
            kind: 'delete',
            uri: uri
        };
        if (options !== void 0 && (options.recursive !== void 0 || options.ignoreIfNotExists !== void 0)) {
            result.options = options;
        }
        return result;
    }
    DeleteFile.create = create;
    function is(value) {
        var candidate = value;
        return candidate && candidate.kind === 'delete' && Is.string(candidate.uri) &&
            (candidate.options === void 0 ||
                ((candidate.options.recursive === void 0 || Is.boolean(candidate.options.recursive)) && (candidate.options.ignoreIfNotExists === void 0 || Is.boolean(candidate.options.ignoreIfNotExists))));
    }
    DeleteFile.is = is;
})(DeleteFile || (DeleteFile = {}));
var WorkspaceEdit;
(function (WorkspaceEdit) {
    function is(value) {
        var candidate = value;
        return candidate &&
            (candidate.changes !== void 0 || candidate.documentChanges !== void 0) &&
            (candidate.documentChanges === void 0 || candidate.documentChanges.every(function (change) {
                if (Is.string(change.kind)) {
                    return CreateFile.is(change) || RenameFile.is(change) || DeleteFile.is(change);
                }
                else {
                    return TextDocumentEdit.is(change);
                }
            }));
    }
    WorkspaceEdit.is = is;
})(WorkspaceEdit || (WorkspaceEdit = {}));
var TextEditChangeImpl = /** @class */ (function () {
    function TextEditChangeImpl(edits) {
        this.edits = edits;
    }
    TextEditChangeImpl.prototype.insert = function (position, newText) {
        this.edits.push(TextEdit.insert(position, newText));
    };
    TextEditChangeImpl.prototype.replace = function (range, newText) {
        this.edits.push(TextEdit.replace(range, newText));
    };
    TextEditChangeImpl.prototype.delete = function (range) {
        this.edits.push(TextEdit.del(range));
    };
    TextEditChangeImpl.prototype.add = function (edit) {
        this.edits.push(edit);
    };
    TextEditChangeImpl.prototype.all = function () {
        return this.edits;
    };
    TextEditChangeImpl.prototype.clear = function () {
        this.edits.splice(0, this.edits.length);
    };
    return TextEditChangeImpl;
}());
/**
 * A workspace change helps constructing changes to a workspace.
 */
var WorkspaceChange = /** @class */ (function () {
    function WorkspaceChange(workspaceEdit) {
        var _this = this;
        this._textEditChanges = Object.create(null);
        if (workspaceEdit) {
            this._workspaceEdit = workspaceEdit;
            if (workspaceEdit.documentChanges) {
                workspaceEdit.documentChanges.forEach(function (change) {
                    if (TextDocumentEdit.is(change)) {
                        var textEditChange = new TextEditChangeImpl(change.edits);
                        _this._textEditChanges[change.textDocument.uri] = textEditChange;
                    }
                });
            }
            else if (workspaceEdit.changes) {
                Object.keys(workspaceEdit.changes).forEach(function (key) {
                    var textEditChange = new TextEditChangeImpl(workspaceEdit.changes[key]);
                    _this._textEditChanges[key] = textEditChange;
                });
            }
        }
    }
    Object.defineProperty(WorkspaceChange.prototype, "edit", {
        /**
         * Returns the underlying [WorkspaceEdit](#WorkspaceEdit) literal
         * use to be returned from a workspace edit operation like rename.
         */
        get: function () {
            return this._workspaceEdit;
        },
        enumerable: true,
        configurable: true
    });
    WorkspaceChange.prototype.getTextEditChange = function (key) {
        if (VersionedTextDocumentIdentifier.is(key)) {
            if (!this._workspaceEdit) {
                this._workspaceEdit = {
                    documentChanges: []
                };
            }
            if (!this._workspaceEdit.documentChanges) {
                throw new Error('Workspace edit is not configured for document changes.');
            }
            var textDocument = key;
            var result = this._textEditChanges[textDocument.uri];
            if (!result) {
                var edits = [];
                var textDocumentEdit = {
                    textDocument: textDocument,
                    edits: edits
                };
                this._workspaceEdit.documentChanges.push(textDocumentEdit);
                result = new TextEditChangeImpl(edits);
                this._textEditChanges[textDocument.uri] = result;
            }
            return result;
        }
        else {
            if (!this._workspaceEdit) {
                this._workspaceEdit = {
                    changes: Object.create(null)
                };
            }
            if (!this._workspaceEdit.changes) {
                throw new Error('Workspace edit is not configured for normal text edit changes.');
            }
            var result = this._textEditChanges[key];
            if (!result) {
                var edits = [];
                this._workspaceEdit.changes[key] = edits;
                result = new TextEditChangeImpl(edits);
                this._textEditChanges[key] = result;
            }
            return result;
        }
    };
    WorkspaceChange.prototype.createFile = function (uri, options) {
        this.checkDocumentChanges();
        this._workspaceEdit.documentChanges.push(CreateFile.create(uri, options));
    };
    WorkspaceChange.prototype.renameFile = function (oldUri, newUri, options) {
        this.checkDocumentChanges();
        this._workspaceEdit.documentChanges.push(RenameFile.create(oldUri, newUri, options));
    };
    WorkspaceChange.prototype.deleteFile = function (uri, options) {
        this.checkDocumentChanges();
        this._workspaceEdit.documentChanges.push(DeleteFile.create(uri, options));
    };
    WorkspaceChange.prototype.checkDocumentChanges = function () {
        if (!this._workspaceEdit || !this._workspaceEdit.documentChanges) {
            throw new Error('Workspace edit is not configured for document changes.');
        }
    };
    return WorkspaceChange;
}());

/**
 * The TextDocumentIdentifier namespace provides helper functions to work with
 * [TextDocumentIdentifier](#TextDocumentIdentifier) literals.
 */
var TextDocumentIdentifier;
(function (TextDocumentIdentifier) {
    /**
     * Creates a new TextDocumentIdentifier literal.
     * @param uri The document's uri.
     */
    function create(uri) {
        return { uri: uri };
    }
    TextDocumentIdentifier.create = create;
    /**
     * Checks whether the given literal conforms to the [TextDocumentIdentifier](#TextDocumentIdentifier) interface.
     */
    function is(value) {
        var candidate = value;
        return Is.defined(candidate) && Is.string(candidate.uri);
    }
    TextDocumentIdentifier.is = is;
})(TextDocumentIdentifier || (TextDocumentIdentifier = {}));
/**
 * The VersionedTextDocumentIdentifier namespace provides helper functions to work with
 * [VersionedTextDocumentIdentifier](#VersionedTextDocumentIdentifier) literals.
 */
var VersionedTextDocumentIdentifier;
(function (VersionedTextDocumentIdentifier) {
    /**
     * Creates a new VersionedTextDocumentIdentifier literal.
     * @param uri The document's uri.
     * @param uri The document's text.
     */
    function create(uri, version) {
        return { uri: uri, version: version };
    }
    VersionedTextDocumentIdentifier.create = create;
    /**
     * Checks whether the given literal conforms to the [VersionedTextDocumentIdentifier](#VersionedTextDocumentIdentifier) interface.
     */
    function is(value) {
        var candidate = value;
        return Is.defined(candidate) && Is.string(candidate.uri) && (candidate.version === null || Is.number(candidate.version));
    }
    VersionedTextDocumentIdentifier.is = is;
})(VersionedTextDocumentIdentifier || (VersionedTextDocumentIdentifier = {}));
/**
 * The TextDocumentItem namespace provides helper functions to work with
 * [TextDocumentItem](#TextDocumentItem) literals.
 */
var TextDocumentItem;
(function (TextDocumentItem) {
    /**
     * Creates a new TextDocumentItem literal.
     * @param uri The document's uri.
     * @param languageId The document's language identifier.
     * @param version The document's version number.
     * @param text The document's text.
     */
    function create(uri, languageId, version, text) {
        return { uri: uri, languageId: languageId, version: version, text: text };
    }
    TextDocumentItem.create = create;
    /**
     * Checks whether the given literal conforms to the [TextDocumentItem](#TextDocumentItem) interface.
     */
    function is(value) {
        var candidate = value;
        return Is.defined(candidate) && Is.string(candidate.uri) && Is.string(candidate.languageId) && Is.number(candidate.version) && Is.string(candidate.text);
    }
    TextDocumentItem.is = is;
})(TextDocumentItem || (TextDocumentItem = {}));
/**
 * Describes the content type that a client supports in various
 * result literals like `Hover`, `ParameterInfo` or `CompletionItem`.
 *
 * Please note that `MarkupKinds` must not start with a `$`. This kinds
 * are reserved for internal usage.
 */
var MarkupKind;
(function (MarkupKind) {
    /**
     * Plain text is supported as a content format
     */
    MarkupKind.PlainText = 'plaintext';
    /**
     * Markdown is supported as a content format
     */
    MarkupKind.Markdown = 'markdown';
})(MarkupKind || (MarkupKind = {}));
(function (MarkupKind) {
    /**
     * Checks whether the given value is a value of the [MarkupKind](#MarkupKind) type.
     */
    function is(value) {
        var candidate = value;
        return candidate === MarkupKind.PlainText || candidate === MarkupKind.Markdown;
    }
    MarkupKind.is = is;
})(MarkupKind || (MarkupKind = {}));
var MarkupContent;
(function (MarkupContent) {
    /**
     * Checks whether the given value conforms to the [MarkupContent](#MarkupContent) interface.
     */
    function is(value) {
        var candidate = value;
        return Is.objectLiteral(value) && MarkupKind.is(candidate.kind) && Is.string(candidate.value);
    }
    MarkupContent.is = is;
})(MarkupContent || (MarkupContent = {}));
/**
 * The kind of a completion entry.
 */
var CompletionItemKind;
(function (CompletionItemKind) {
    CompletionItemKind.Text = 1;
    CompletionItemKind.Method = 2;
    CompletionItemKind.Function = 3;
    CompletionItemKind.Constructor = 4;
    CompletionItemKind.Field = 5;
    CompletionItemKind.Variable = 6;
    CompletionItemKind.Class = 7;
    CompletionItemKind.Interface = 8;
    CompletionItemKind.Module = 9;
    CompletionItemKind.Property = 10;
    CompletionItemKind.Unit = 11;
    CompletionItemKind.Value = 12;
    CompletionItemKind.Enum = 13;
    CompletionItemKind.Keyword = 14;
    CompletionItemKind.Snippet = 15;
    CompletionItemKind.Color = 16;
    CompletionItemKind.File = 17;
    CompletionItemKind.Reference = 18;
    CompletionItemKind.Folder = 19;
    CompletionItemKind.EnumMember = 20;
    CompletionItemKind.Constant = 21;
    CompletionItemKind.Struct = 22;
    CompletionItemKind.Event = 23;
    CompletionItemKind.Operator = 24;
    CompletionItemKind.TypeParameter = 25;
})(CompletionItemKind || (CompletionItemKind = {}));
/**
 * Defines whether the insert text in a completion item should be interpreted as
 * plain text or a snippet.
 */
var InsertTextFormat;
(function (InsertTextFormat) {
    /**
     * The primary text to be inserted is treated as a plain string.
     */
    InsertTextFormat.PlainText = 1;
    /**
     * The primary text to be inserted is treated as a snippet.
     *
     * A snippet can define tab stops and placeholders with `$1`, `$2`
     * and `${3:foo}`. `$0` defines the final tab stop, it defaults to
     * the end of the snippet. Placeholders with equal identifiers are linked,
     * that is typing in one will update others too.
     *
     * See also: https://github.com/Microsoft/vscode/blob/master/src/vs/editor/contrib/snippet/common/snippet.md
     */
    InsertTextFormat.Snippet = 2;
})(InsertTextFormat || (InsertTextFormat = {}));
/**
 * Completion item tags are extra annotations that tweak the rendering of a completion
 * item.
 *
 * @since 3.15.0
 */
var CompletionItemTag;
(function (CompletionItemTag) {
    /**
     * Render a completion as obsolete, usually using a strike-out.
     */
    CompletionItemTag.Deprecated = 1;
})(CompletionItemTag || (CompletionItemTag = {}));
/**
 * The CompletionItem namespace provides functions to deal with
 * completion items.
 */
var CompletionItem;
(function (CompletionItem) {
    /**
     * Create a completion item and seed it with a label.
     * @param label The completion item's label
     */
    function create(label) {
        return { label: label };
    }
    CompletionItem.create = create;
})(CompletionItem || (CompletionItem = {}));
/**
 * The CompletionList namespace provides functions to deal with
 * completion lists.
 */
var CompletionList;
(function (CompletionList) {
    /**
     * Creates a new completion list.
     *
     * @param items The completion items.
     * @param isIncomplete The list is not complete.
     */
    function create(items, isIncomplete) {
        return { items: items ? items : [], isIncomplete: !!isIncomplete };
    }
    CompletionList.create = create;
})(CompletionList || (CompletionList = {}));
var MarkedString;
(function (MarkedString) {
    /**
     * Creates a marked string from plain text.
     *
     * @param plainText The plain text.
     */
    function fromPlainText(plainText) {
        return plainText.replace(/[\\`*_{}[\]()#+\-.!]/g, '\\$&'); // escape markdown syntax tokens: http://daringfireball.net/projects/markdown/syntax#backslash
    }
    MarkedString.fromPlainText = fromPlainText;
    /**
     * Checks whether the given value conforms to the [MarkedString](#MarkedString) type.
     */
    function is(value) {
        var candidate = value;
        return Is.string(candidate) || (Is.objectLiteral(candidate) && Is.string(candidate.language) && Is.string(candidate.value));
    }
    MarkedString.is = is;
})(MarkedString || (MarkedString = {}));
var Hover;
(function (Hover) {
    /**
     * Checks whether the given value conforms to the [Hover](#Hover) interface.
     */
    function is(value) {
        var candidate = value;
        return !!candidate && Is.objectLiteral(candidate) && (MarkupContent.is(candidate.contents) ||
            MarkedString.is(candidate.contents) ||
            Is.typedArray(candidate.contents, MarkedString.is)) && (value.range === void 0 || Range.is(value.range));
    }
    Hover.is = is;
})(Hover || (Hover = {}));
/**
 * The ParameterInformation namespace provides helper functions to work with
 * [ParameterInformation](#ParameterInformation) literals.
 */
var ParameterInformation;
(function (ParameterInformation) {
    /**
     * Creates a new parameter information literal.
     *
     * @param label A label string.
     * @param documentation A doc string.
     */
    function create(label, documentation) {
        return documentation ? { label: label, documentation: documentation } : { label: label };
    }
    ParameterInformation.create = create;
})(ParameterInformation || (ParameterInformation = {}));
/**
 * The SignatureInformation namespace provides helper functions to work with
 * [SignatureInformation](#SignatureInformation) literals.
 */
var SignatureInformation;
(function (SignatureInformation) {
    function create(label, documentation) {
        var parameters = [];
        for (var _i = 2; _i < arguments.length; _i++) {
            parameters[_i - 2] = arguments[_i];
        }
        var result = { label: label };
        if (Is.defined(documentation)) {
            result.documentation = documentation;
        }
        if (Is.defined(parameters)) {
            result.parameters = parameters;
        }
        else {
            result.parameters = [];
        }
        return result;
    }
    SignatureInformation.create = create;
})(SignatureInformation || (SignatureInformation = {}));
/**
 * A document highlight kind.
 */
var DocumentHighlightKind;
(function (DocumentHighlightKind) {
    /**
     * A textual occurrence.
     */
    DocumentHighlightKind.Text = 1;
    /**
     * Read-access of a symbol, like reading a variable.
     */
    DocumentHighlightKind.Read = 2;
    /**
     * Write-access of a symbol, like writing to a variable.
     */
    DocumentHighlightKind.Write = 3;
})(DocumentHighlightKind || (DocumentHighlightKind = {}));
/**
 * DocumentHighlight namespace to provide helper functions to work with
 * [DocumentHighlight](#DocumentHighlight) literals.
 */
var DocumentHighlight;
(function (DocumentHighlight) {
    /**
     * Create a DocumentHighlight object.
     * @param range The range the highlight applies to.
     */
    function create(range, kind) {
        var result = { range: range };
        if (Is.number(kind)) {
            result.kind = kind;
        }
        return result;
    }
    DocumentHighlight.create = create;
})(DocumentHighlight || (DocumentHighlight = {}));
/**
 * A symbol kind.
 */
var SymbolKind;
(function (SymbolKind) {
    SymbolKind.File = 1;
    SymbolKind.Module = 2;
    SymbolKind.Namespace = 3;
    SymbolKind.Package = 4;
    SymbolKind.Class = 5;
    SymbolKind.Method = 6;
    SymbolKind.Property = 7;
    SymbolKind.Field = 8;
    SymbolKind.Constructor = 9;
    SymbolKind.Enum = 10;
    SymbolKind.Interface = 11;
    SymbolKind.Function = 12;
    SymbolKind.Variable = 13;
    SymbolKind.Constant = 14;
    SymbolKind.String = 15;
    SymbolKind.Number = 16;
    SymbolKind.Boolean = 17;
    SymbolKind.Array = 18;
    SymbolKind.Object = 19;
    SymbolKind.Key = 20;
    SymbolKind.Null = 21;
    SymbolKind.EnumMember = 22;
    SymbolKind.Struct = 23;
    SymbolKind.Event = 24;
    SymbolKind.Operator = 25;
    SymbolKind.TypeParameter = 26;
})(SymbolKind || (SymbolKind = {}));
/**
 * Symbol tags are extra annotations that tweak the rendering of a symbol.
 * @since 3.15
 */
var SymbolTag;
(function (SymbolTag) {
    /**
     * Render a symbol as obsolete, usually using a strike-out.
     */
    SymbolTag.Deprecated = 1;
})(SymbolTag || (SymbolTag = {}));
var SymbolInformation;
(function (SymbolInformation) {
    /**
     * Creates a new symbol information literal.
     *
     * @param name The name of the symbol.
     * @param kind The kind of the symbol.
     * @param range The range of the location of the symbol.
     * @param uri The resource of the location of symbol, defaults to the current document.
     * @param containerName The name of the symbol containing the symbol.
     */
    function create(name, kind, range, uri, containerName) {
        var result = {
            name: name,
            kind: kind,
            location: { uri: uri, range: range }
        };
        if (containerName) {
            result.containerName = containerName;
        }
        return result;
    }
    SymbolInformation.create = create;
})(SymbolInformation || (SymbolInformation = {}));
var DocumentSymbol;
(function (DocumentSymbol) {
    /**
     * Creates a new symbol information literal.
     *
     * @param name The name of the symbol.
     * @param detail The detail of the symbol.
     * @param kind The kind of the symbol.
     * @param range The range of the symbol.
     * @param selectionRange The selectionRange of the symbol.
     * @param children Children of the symbol.
     */
    function create(name, detail, kind, range, selectionRange, children) {
        var result = {
            name: name,
            detail: detail,
            kind: kind,
            range: range,
            selectionRange: selectionRange
        };
        if (children !== void 0) {
            result.children = children;
        }
        return result;
    }
    DocumentSymbol.create = create;
    /**
     * Checks whether the given literal conforms to the [DocumentSymbol](#DocumentSymbol) interface.
     */
    function is(value) {
        var candidate = value;
        return candidate &&
            Is.string(candidate.name) && Is.number(candidate.kind) &&
            Range.is(candidate.range) && Range.is(candidate.selectionRange) &&
            (candidate.detail === void 0 || Is.string(candidate.detail)) &&
            (candidate.deprecated === void 0 || Is.boolean(candidate.deprecated)) &&
            (candidate.children === void 0 || Array.isArray(candidate.children));
    }
    DocumentSymbol.is = is;
})(DocumentSymbol || (DocumentSymbol = {}));
/**
 * A set of predefined code action kinds
 */
var CodeActionKind;
(function (CodeActionKind) {
    /**
     * Empty kind.
     */
    CodeActionKind.Empty = '';
    /**
     * Base kind for quickfix actions: 'quickfix'
     */
    CodeActionKind.QuickFix = 'quickfix';
    /**
     * Base kind for refactoring actions: 'refactor'
     */
    CodeActionKind.Refactor = 'refactor';
    /**
     * Base kind for refactoring extraction actions: 'refactor.extract'
     *
     * Example extract actions:
     *
     * - Extract method
     * - Extract function
     * - Extract variable
     * - Extract interface from class
     * - ...
     */
    CodeActionKind.RefactorExtract = 'refactor.extract';
    /**
     * Base kind for refactoring inline actions: 'refactor.inline'
     *
     * Example inline actions:
     *
     * - Inline function
     * - Inline variable
     * - Inline constant
     * - ...
     */
    CodeActionKind.RefactorInline = 'refactor.inline';
    /**
     * Base kind for refactoring rewrite actions: 'refactor.rewrite'
     *
     * Example rewrite actions:
     *
     * - Convert JavaScript function to class
     * - Add or remove parameter
     * - Encapsulate field
     * - Make method static
     * - Move method to base class
     * - ...
     */
    CodeActionKind.RefactorRewrite = 'refactor.rewrite';
    /**
     * Base kind for source actions: `source`
     *
     * Source code actions apply to the entire file.
     */
    CodeActionKind.Source = 'source';
    /**
     * Base kind for an organize imports source action: `source.organizeImports`
     */
    CodeActionKind.SourceOrganizeImports = 'source.organizeImports';
    /**
     * Base kind for auto-fix source actions: `source.fixAll`.
     *
     * Fix all actions automatically fix errors that have a clear fix that do not require user input.
     * They should not suppress errors or perform unsafe fixes such as generating new types or classes.
     *
     * @since 3.15.0
     */
    CodeActionKind.SourceFixAll = 'source.fixAll';
})(CodeActionKind || (CodeActionKind = {}));
/**
 * The CodeActionContext namespace provides helper functions to work with
 * [CodeActionContext](#CodeActionContext) literals.
 */
var CodeActionContext;
(function (CodeActionContext) {
    /**
     * Creates a new CodeActionContext literal.
     */
    function create(diagnostics, only) {
        var result = { diagnostics: diagnostics };
        if (only !== void 0 && only !== null) {
            result.only = only;
        }
        return result;
    }
    CodeActionContext.create = create;
    /**
     * Checks whether the given literal conforms to the [CodeActionContext](#CodeActionContext) interface.
     */
    function is(value) {
        var candidate = value;
        return Is.defined(candidate) && Is.typedArray(candidate.diagnostics, Diagnostic.is) && (candidate.only === void 0 || Is.typedArray(candidate.only, Is.string));
    }
    CodeActionContext.is = is;
})(CodeActionContext || (CodeActionContext = {}));
var CodeAction;
(function (CodeAction) {
    function create(title, commandOrEdit, kind) {
        var result = { title: title };
        if (Command.is(commandOrEdit)) {
            result.command = commandOrEdit;
        }
        else {
            result.edit = commandOrEdit;
        }
        if (kind !== void 0) {
            result.kind = kind;
        }
        return result;
    }
    CodeAction.create = create;
    function is(value) {
        var candidate = value;
        return candidate && Is.string(candidate.title) &&
            (candidate.diagnostics === void 0 || Is.typedArray(candidate.diagnostics, Diagnostic.is)) &&
            (candidate.kind === void 0 || Is.string(candidate.kind)) &&
            (candidate.edit !== void 0 || candidate.command !== void 0) &&
            (candidate.command === void 0 || Command.is(candidate.command)) &&
            (candidate.isPreferred === void 0 || Is.boolean(candidate.isPreferred)) &&
            (candidate.edit === void 0 || WorkspaceEdit.is(candidate.edit));
    }
    CodeAction.is = is;
})(CodeAction || (CodeAction = {}));
/**
 * The CodeLens namespace provides helper functions to work with
 * [CodeLens](#CodeLens) literals.
 */
var CodeLens;
(function (CodeLens) {
    /**
     * Creates a new CodeLens literal.
     */
    function create(range, data) {
        var result = { range: range };
        if (Is.defined(data)) {
            result.data = data;
        }
        return result;
    }
    CodeLens.create = create;
    /**
     * Checks whether the given literal conforms to the [CodeLens](#CodeLens) interface.
     */
    function is(value) {
        var candidate = value;
        return Is.defined(candidate) && Range.is(candidate.range) && (Is.undefined(candidate.command) || Command.is(candidate.command));
    }
    CodeLens.is = is;
})(CodeLens || (CodeLens = {}));
/**
 * The FormattingOptions namespace provides helper functions to work with
 * [FormattingOptions](#FormattingOptions) literals.
 */
var FormattingOptions;
(function (FormattingOptions) {
    /**
     * Creates a new FormattingOptions literal.
     */
    function create(tabSize, insertSpaces) {
        return { tabSize: tabSize, insertSpaces: insertSpaces };
    }
    FormattingOptions.create = create;
    /**
     * Checks whether the given literal conforms to the [FormattingOptions](#FormattingOptions) interface.
     */
    function is(value) {
        var candidate = value;
        return Is.defined(candidate) && Is.number(candidate.tabSize) && Is.boolean(candidate.insertSpaces);
    }
    FormattingOptions.is = is;
})(FormattingOptions || (FormattingOptions = {}));
/**
 * The DocumentLink namespace provides helper functions to work with
 * [DocumentLink](#DocumentLink) literals.
 */
var DocumentLink;
(function (DocumentLink) {
    /**
     * Creates a new DocumentLink literal.
     */
    function create(range, target, data) {
        return { range: range, target: target, data: data };
    }
    DocumentLink.create = create;
    /**
     * Checks whether the given literal conforms to the [DocumentLink](#DocumentLink) interface.
     */
    function is(value) {
        var candidate = value;
        return Is.defined(candidate) && Range.is(candidate.range) && (Is.undefined(candidate.target) || Is.string(candidate.target));
    }
    DocumentLink.is = is;
})(DocumentLink || (DocumentLink = {}));
/**
 * The SelectionRange namespace provides helper function to work with
 * SelectionRange literals.
 */
var SelectionRange;
(function (SelectionRange) {
    /**
     * Creates a new SelectionRange
     * @param range the range.
     * @param parent an optional parent.
     */
    function create(range, parent) {
        return { range: range, parent: parent };
    }
    SelectionRange.create = create;
    function is(value) {
        var candidate = value;
        return candidate !== undefined && Range.is(candidate.range) && (candidate.parent === undefined || SelectionRange.is(candidate.parent));
    }
    SelectionRange.is = is;
})(SelectionRange || (SelectionRange = {}));
var EOL = ['\n', '\r\n', '\r'];
/**
 * @deprecated Use the text document from the new vscode-languageserver-textdocument package.
 */
var TextDocument;
(function (TextDocument) {
    /**
     * Creates a new ITextDocument literal from the given uri and content.
     * @param uri The document's uri.
     * @param languageId  The document's language Id.
     * @param content The document's content.
     */
    function create(uri, languageId, version, content) {
        return new FullTextDocument(uri, languageId, version, content);
    }
    TextDocument.create = create;
    /**
     * Checks whether the given literal conforms to the [ITextDocument](#ITextDocument) interface.
     */
    function is(value) {
        var candidate = value;
        return Is.defined(candidate) && Is.string(candidate.uri) && (Is.undefined(candidate.languageId) || Is.string(candidate.languageId)) && Is.number(candidate.lineCount)
            && Is.func(candidate.getText) && Is.func(candidate.positionAt) && Is.func(candidate.offsetAt) ? true : false;
    }
    TextDocument.is = is;
    function applyEdits(document, edits) {
        var text = document.getText();
        var sortedEdits = mergeSort(edits, function (a, b) {
            var diff = a.range.start.line - b.range.start.line;
            if (diff === 0) {
                return a.range.start.character - b.range.start.character;
            }
            return diff;
        });
        var lastModifiedOffset = text.length;
        for (var i = sortedEdits.length - 1; i >= 0; i--) {
            var e = sortedEdits[i];
            var startOffset = document.offsetAt(e.range.start);
            var endOffset = document.offsetAt(e.range.end);
            if (endOffset <= lastModifiedOffset) {
                text = text.substring(0, startOffset) + e.newText + text.substring(endOffset, text.length);
            }
            else {
                throw new Error('Overlapping edit');
            }
            lastModifiedOffset = startOffset;
        }
        return text;
    }
    TextDocument.applyEdits = applyEdits;
    function mergeSort(data, compare) {
        if (data.length <= 1) {
            // sorted
            return data;
        }
        var p = (data.length / 2) | 0;
        var left = data.slice(0, p);
        var right = data.slice(p);
        mergeSort(left, compare);
        mergeSort(right, compare);
        var leftIdx = 0;
        var rightIdx = 0;
        var i = 0;
        while (leftIdx < left.length && rightIdx < right.length) {
            var ret = compare(left[leftIdx], right[rightIdx]);
            if (ret <= 0) {
                // smaller_equal -> take left to preserve order
                data[i++] = left[leftIdx++];
            }
            else {
                // greater -> take right
                data[i++] = right[rightIdx++];
            }
        }
        while (leftIdx < left.length) {
            data[i++] = left[leftIdx++];
        }
        while (rightIdx < right.length) {
            data[i++] = right[rightIdx++];
        }
        return data;
    }
})(TextDocument || (TextDocument = {}));
var FullTextDocument = /** @class */ (function () {
    function FullTextDocument(uri, languageId, version, content) {
        this._uri = uri;
        this._languageId = languageId;
        this._version = version;
        this._content = content;
        this._lineOffsets = undefined;
    }
    Object.defineProperty(FullTextDocument.prototype, "uri", {
        get: function () {
            return this._uri;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(FullTextDocument.prototype, "languageId", {
        get: function () {
            return this._languageId;
        },
        enumerable: true,
        configurable: true
    });
    Object.defineProperty(FullTextDocument.prototype, "version", {
        get: function () {
            return this._version;
        },
        enumerable: true,
        configurable: true
    });
    FullTextDocument.prototype.getText = function (range) {
        if (range) {
            var start = this.offsetAt(range.start);
            var end = this.offsetAt(range.end);
            return this._content.substring(start, end);
        }
        return this._content;
    };
    FullTextDocument.prototype.update = function (event, version) {
        this._content = event.text;
        this._version = version;
        this._lineOffsets = undefined;
    };
    FullTextDocument.prototype.getLineOffsets = function () {
        if (this._lineOffsets === undefined) {
            var lineOffsets = [];
            var text = this._content;
            var isLineStart = true;
            for (var i = 0; i < text.length; i++) {
                if (isLineStart) {
                    lineOffsets.push(i);
                    isLineStart = false;
                }
                var ch = text.charAt(i);
                isLineStart = (ch === '\r' || ch === '\n');
                if (ch === '\r' && i + 1 < text.length && text.charAt(i + 1) === '\n') {
                    i++;
                }
            }
            if (isLineStart && text.length > 0) {
                lineOffsets.push(text.length);
            }
            this._lineOffsets = lineOffsets;
        }
        return this._lineOffsets;
    };
    FullTextDocument.prototype.positionAt = function (offset) {
        offset = Math.max(Math.min(offset, this._content.length), 0);
        var lineOffsets = this.getLineOffsets();
        var low = 0, high = lineOffsets.length;
        if (high === 0) {
            return Position.create(0, offset);
        }
        while (low < high) {
            var mid = Math.floor((low + high) / 2);
            if (lineOffsets[mid] > offset) {
                high = mid;
            }
            else {
                low = mid + 1;
            }
        }
        // low is the least x for which the line offset is larger than the current offset
        // or array.length if no line offset is larger than the current offset
        var line = low - 1;
        return Position.create(line, offset - lineOffsets[line]);
    };
    FullTextDocument.prototype.offsetAt = function (position) {
        var lineOffsets = this.getLineOffsets();
        if (position.line >= lineOffsets.length) {
            return this._content.length;
        }
        else if (position.line < 0) {
            return 0;
        }
        var lineOffset = lineOffsets[position.line];
        var nextLineOffset = (position.line + 1 < lineOffsets.length) ? lineOffsets[position.line + 1] : this._content.length;
        return Math.max(Math.min(lineOffset + position.character, nextLineOffset), lineOffset);
    };
    Object.defineProperty(FullTextDocument.prototype, "lineCount", {
        get: function () {
            return this.getLineOffsets().length;
        },
        enumerable: true,
        configurable: true
    });
    return FullTextDocument;
}());
var Is;
(function (Is) {
    var toString = Object.prototype.toString;
    function defined(value) {
        return typeof value !== 'undefined';
    }
    Is.defined = defined;
    function undefined(value) {
        return typeof value === 'undefined';
    }
    Is.undefined = undefined;
    function boolean(value) {
        return value === true || value === false;
    }
    Is.boolean = boolean;
    function string(value) {
        return toString.call(value) === '[object String]';
    }
    Is.string = string;
    function number(value) {
        return toString.call(value) === '[object Number]';
    }
    Is.number = number;
    function func(value) {
        return toString.call(value) === '[object Function]';
    }
    Is.func = func;
    function objectLiteral(value) {
        // Strictly speaking class instances pass this check as well. Since the LSP
        // doesn't use classes we ignore this for now. If we do we need to add something
        // like this: `Object.getPrototypeOf(Object.getPrototypeOf(x)) === null`
        return value !== null && typeof value === 'object';
    }
    Is.objectLiteral = objectLiteral;
    function typedArray(value, check) {
        return Array.isArray(value) && value.every(check);
    }
    Is.typedArray = typedArray;
})(Is || (Is = {}));


/***/ }),
/* 57 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "c", function() { return FIN; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "d", function() { return Iterator; });
/* unused harmony export ChainableIterator */
/* harmony export (immutable) */ __webpack_exports__["f"] = getSequenceIterator;
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return ArrayIterator; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "b", function() { return ArrayNavigator; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "e", function() { return MappedIterator; });
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var FIN = { done: true, value: undefined };
var Iterator;
(function (Iterator) {
    var _empty = {
        next: function () {
            return FIN;
        }
    };
    function empty() {
        return _empty;
    }
    Iterator.empty = empty;
    function single(value) {
        var done = false;
        return {
            next: function () {
                if (done) {
                    return FIN;
                }
                done = true;
                return { done: false, value: value };
            }
        };
    }
    Iterator.single = single;
    function fromArray(array, index, length) {
        if (index === void 0) { index = 0; }
        if (length === void 0) { length = array.length; }
        return {
            next: function () {
                if (index >= length) {
                    return FIN;
                }
                return { done: false, value: array[index++] };
            }
        };
    }
    Iterator.fromArray = fromArray;
    function fromNativeIterator(it) {
        return {
            next: function () {
                var result = it.next();
                if (result.done) {
                    return FIN;
                }
                return { done: false, value: result.value };
            }
        };
    }
    Iterator.fromNativeIterator = fromNativeIterator;
    function from(elements) {
        if (!elements) {
            return Iterator.empty();
        }
        else if (Array.isArray(elements)) {
            return Iterator.fromArray(elements);
        }
        else {
            return elements;
        }
    }
    Iterator.from = from;
    function map(iterator, fn) {
        return {
            next: function () {
                var element = iterator.next();
                if (element.done) {
                    return FIN;
                }
                else {
                    return { done: false, value: fn(element.value) };
                }
            }
        };
    }
    Iterator.map = map;
    function filter(iterator, fn) {
        return {
            next: function () {
                while (true) {
                    var element = iterator.next();
                    if (element.done) {
                        return FIN;
                    }
                    if (fn(element.value)) {
                        return { done: false, value: element.value };
                    }
                }
            }
        };
    }
    Iterator.filter = filter;
    function forEach(iterator, fn) {
        for (var next = iterator.next(); !next.done; next = iterator.next()) {
            fn(next.value);
        }
    }
    Iterator.forEach = forEach;
    function collect(iterator, atMost) {
        if (atMost === void 0) { atMost = Number.POSITIVE_INFINITY; }
        var result = [];
        if (atMost === 0) {
            return result;
        }
        var i = 0;
        for (var next = iterator.next(); !next.done; next = iterator.next()) {
            result.push(next.value);
            if (++i >= atMost) {
                break;
            }
        }
        return result;
    }
    Iterator.collect = collect;
    function concat() {
        var iterators = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            iterators[_i] = arguments[_i];
        }
        var i = 0;
        return {
            next: function () {
                if (i >= iterators.length) {
                    return FIN;
                }
                var iterator = iterators[i];
                var result = iterator.next();
                if (result.done) {
                    i++;
                    return this.next();
                }
                return result;
            }
        };
    }
    Iterator.concat = concat;
    function chain(iterator) {
        return new ChainableIterator(iterator);
    }
    Iterator.chain = chain;
})(Iterator || (Iterator = {}));
var ChainableIterator = /** @class */ (function () {
    function ChainableIterator(it) {
        this.it = it;
    }
    ChainableIterator.prototype.next = function () { return this.it.next(); };
    return ChainableIterator;
}());

function getSequenceIterator(arg) {
    if (Array.isArray(arg)) {
        return Iterator.fromArray(arg);
    }
    else if (!arg) {
        return Iterator.empty();
    }
    else {
        return arg;
    }
}
var ArrayIterator = /** @class */ (function () {
    function ArrayIterator(items, start, end, index) {
        if (start === void 0) { start = 0; }
        if (end === void 0) { end = items.length; }
        if (index === void 0) { index = start - 1; }
        this.items = items;
        this.start = start;
        this.end = end;
        this.index = index;
    }
    ArrayIterator.prototype.first = function () {
        this.index = this.start;
        return this.current();
    };
    ArrayIterator.prototype.next = function () {
        this.index = Math.min(this.index + 1, this.end);
        return this.current();
    };
    ArrayIterator.prototype.current = function () {
        if (this.index === this.start - 1 || this.index === this.end) {
            return null;
        }
        return this.items[this.index];
    };
    return ArrayIterator;
}());

var ArrayNavigator = /** @class */ (function (_super) {
    __extends(ArrayNavigator, _super);
    function ArrayNavigator(items, start, end, index) {
        if (start === void 0) { start = 0; }
        if (end === void 0) { end = items.length; }
        if (index === void 0) { index = start - 1; }
        return _super.call(this, items, start, end, index) || this;
    }
    ArrayNavigator.prototype.current = function () {
        return _super.prototype.current.call(this);
    };
    ArrayNavigator.prototype.previous = function () {
        this.index = Math.max(this.index - 1, this.start - 1);
        return this.current();
    };
    ArrayNavigator.prototype.first = function () {
        this.index = this.start;
        return this.current();
    };
    ArrayNavigator.prototype.last = function () {
        this.index = this.end - 1;
        return this.current();
    };
    ArrayNavigator.prototype.parent = function () {
        return null;
    };
    return ArrayNavigator;
}(ArrayIterator));

var MappedIterator = /** @class */ (function () {
    function MappedIterator(iterator, fn) {
        this.iterator = iterator;
        this.fn = fn;
        // noop
    }
    MappedIterator.prototype.next = function () { return this.fn(this.iterator.next()); };
    return MappedIterator;
}());



/***/ }),
/* 58 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return StandardKeyboardEvent; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__browser_js__ = __webpack_require__(23);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__common_keyCodes_js__ = __webpack_require__(35);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2__common_platform_js__ = __webpack_require__(14);
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/



var KEY_CODE_MAP = new Array(230);
var INVERSE_KEY_CODE_MAP = new Array(112 /* MAX_VALUE */);
(function () {
    for (var i = 0; i < INVERSE_KEY_CODE_MAP.length; i++) {
        INVERSE_KEY_CODE_MAP[i] = -1;
    }
    function define(code, keyCode) {
        KEY_CODE_MAP[code] = keyCode;
        INVERSE_KEY_CODE_MAP[keyCode] = code;
    }
    define(3, 7 /* PauseBreak */); // VK_CANCEL 0x03 Control-break processing
    define(8, 1 /* Backspace */);
    define(9, 2 /* Tab */);
    define(13, 3 /* Enter */);
    define(16, 4 /* Shift */);
    define(17, 5 /* Ctrl */);
    define(18, 6 /* Alt */);
    define(19, 7 /* PauseBreak */);
    define(20, 8 /* CapsLock */);
    define(27, 9 /* Escape */);
    define(32, 10 /* Space */);
    define(33, 11 /* PageUp */);
    define(34, 12 /* PageDown */);
    define(35, 13 /* End */);
    define(36, 14 /* Home */);
    define(37, 15 /* LeftArrow */);
    define(38, 16 /* UpArrow */);
    define(39, 17 /* RightArrow */);
    define(40, 18 /* DownArrow */);
    define(45, 19 /* Insert */);
    define(46, 20 /* Delete */);
    define(48, 21 /* KEY_0 */);
    define(49, 22 /* KEY_1 */);
    define(50, 23 /* KEY_2 */);
    define(51, 24 /* KEY_3 */);
    define(52, 25 /* KEY_4 */);
    define(53, 26 /* KEY_5 */);
    define(54, 27 /* KEY_6 */);
    define(55, 28 /* KEY_7 */);
    define(56, 29 /* KEY_8 */);
    define(57, 30 /* KEY_9 */);
    define(65, 31 /* KEY_A */);
    define(66, 32 /* KEY_B */);
    define(67, 33 /* KEY_C */);
    define(68, 34 /* KEY_D */);
    define(69, 35 /* KEY_E */);
    define(70, 36 /* KEY_F */);
    define(71, 37 /* KEY_G */);
    define(72, 38 /* KEY_H */);
    define(73, 39 /* KEY_I */);
    define(74, 40 /* KEY_J */);
    define(75, 41 /* KEY_K */);
    define(76, 42 /* KEY_L */);
    define(77, 43 /* KEY_M */);
    define(78, 44 /* KEY_N */);
    define(79, 45 /* KEY_O */);
    define(80, 46 /* KEY_P */);
    define(81, 47 /* KEY_Q */);
    define(82, 48 /* KEY_R */);
    define(83, 49 /* KEY_S */);
    define(84, 50 /* KEY_T */);
    define(85, 51 /* KEY_U */);
    define(86, 52 /* KEY_V */);
    define(87, 53 /* KEY_W */);
    define(88, 54 /* KEY_X */);
    define(89, 55 /* KEY_Y */);
    define(90, 56 /* KEY_Z */);
    define(93, 58 /* ContextMenu */);
    define(96, 93 /* NUMPAD_0 */);
    define(97, 94 /* NUMPAD_1 */);
    define(98, 95 /* NUMPAD_2 */);
    define(99, 96 /* NUMPAD_3 */);
    define(100, 97 /* NUMPAD_4 */);
    define(101, 98 /* NUMPAD_5 */);
    define(102, 99 /* NUMPAD_6 */);
    define(103, 100 /* NUMPAD_7 */);
    define(104, 101 /* NUMPAD_8 */);
    define(105, 102 /* NUMPAD_9 */);
    define(106, 103 /* NUMPAD_MULTIPLY */);
    define(107, 104 /* NUMPAD_ADD */);
    define(108, 105 /* NUMPAD_SEPARATOR */);
    define(109, 106 /* NUMPAD_SUBTRACT */);
    define(110, 107 /* NUMPAD_DECIMAL */);
    define(111, 108 /* NUMPAD_DIVIDE */);
    define(112, 59 /* F1 */);
    define(113, 60 /* F2 */);
    define(114, 61 /* F3 */);
    define(115, 62 /* F4 */);
    define(116, 63 /* F5 */);
    define(117, 64 /* F6 */);
    define(118, 65 /* F7 */);
    define(119, 66 /* F8 */);
    define(120, 67 /* F9 */);
    define(121, 68 /* F10 */);
    define(122, 69 /* F11 */);
    define(123, 70 /* F12 */);
    define(124, 71 /* F13 */);
    define(125, 72 /* F14 */);
    define(126, 73 /* F15 */);
    define(127, 74 /* F16 */);
    define(128, 75 /* F17 */);
    define(129, 76 /* F18 */);
    define(130, 77 /* F19 */);
    define(144, 78 /* NumLock */);
    define(145, 79 /* ScrollLock */);
    define(186, 80 /* US_SEMICOLON */);
    define(187, 81 /* US_EQUAL */);
    define(188, 82 /* US_COMMA */);
    define(189, 83 /* US_MINUS */);
    define(190, 84 /* US_DOT */);
    define(191, 85 /* US_SLASH */);
    define(192, 86 /* US_BACKTICK */);
    define(193, 110 /* ABNT_C1 */);
    define(194, 111 /* ABNT_C2 */);
    define(219, 87 /* US_OPEN_SQUARE_BRACKET */);
    define(220, 88 /* US_BACKSLASH */);
    define(221, 89 /* US_CLOSE_SQUARE_BRACKET */);
    define(222, 90 /* US_QUOTE */);
    define(223, 91 /* OEM_8 */);
    define(226, 92 /* OEM_102 */);
    /**
     * https://lists.w3.org/Archives/Public/www-dom/2010JulSep/att-0182/keyCode-spec.html
     * If an Input Method Editor is processing key input and the event is keydown, return 229.
     */
    define(229, 109 /* KEY_IN_COMPOSITION */);
    if (__WEBPACK_IMPORTED_MODULE_0__browser_js__["i" /* isIE */]) {
        define(91, 57 /* Meta */);
    }
    else if (__WEBPACK_IMPORTED_MODULE_0__browser_js__["h" /* isFirefox */]) {
        define(59, 80 /* US_SEMICOLON */);
        define(107, 81 /* US_EQUAL */);
        define(109, 83 /* US_MINUS */);
        if (__WEBPACK_IMPORTED_MODULE_2__common_platform_js__["e" /* isMacintosh */]) {
            define(224, 57 /* Meta */);
        }
    }
    else if (__WEBPACK_IMPORTED_MODULE_0__browser_js__["m" /* isWebKit */]) {
        define(91, 57 /* Meta */);
        if (__WEBPACK_IMPORTED_MODULE_2__common_platform_js__["e" /* isMacintosh */]) {
            // the two meta keys in the Mac have different key codes (91 and 93)
            define(93, 57 /* Meta */);
        }
        else {
            define(92, 57 /* Meta */);
        }
    }
})();
function extractKeyCode(e) {
    if (e.charCode) {
        // "keypress" events mostly
        var char = String.fromCharCode(e.charCode).toUpperCase();
        return __WEBPACK_IMPORTED_MODULE_1__common_keyCodes_js__["b" /* KeyCodeUtils */].fromString(char);
    }
    return KEY_CODE_MAP[e.keyCode] || 0 /* Unknown */;
}
var ctrlKeyMod = (__WEBPACK_IMPORTED_MODULE_2__common_platform_js__["e" /* isMacintosh */] ? 256 /* WinCtrl */ : 2048 /* CtrlCmd */);
var altKeyMod = 512 /* Alt */;
var shiftKeyMod = 1024 /* Shift */;
var metaKeyMod = (__WEBPACK_IMPORTED_MODULE_2__common_platform_js__["e" /* isMacintosh */] ? 2048 /* CtrlCmd */ : 256 /* WinCtrl */);
var StandardKeyboardEvent = /** @class */ (function () {
    function StandardKeyboardEvent(source) {
        this._standardKeyboardEventBrand = true;
        var e = source;
        this.browserEvent = e;
        this.target = e.target;
        this.ctrlKey = e.ctrlKey;
        this.shiftKey = e.shiftKey;
        this.altKey = e.altKey;
        this.metaKey = e.metaKey;
        this.keyCode = extractKeyCode(e);
        this.code = e.code;
        // console.info(e.type + ": keyCode: " + e.keyCode + ", which: " + e.which + ", charCode: " + e.charCode + ", detail: " + e.detail + " ====> " + this.keyCode + ' -- ' + KeyCode[this.keyCode]);
        this.ctrlKey = this.ctrlKey || this.keyCode === 5 /* Ctrl */;
        this.altKey = this.altKey || this.keyCode === 6 /* Alt */;
        this.shiftKey = this.shiftKey || this.keyCode === 4 /* Shift */;
        this.metaKey = this.metaKey || this.keyCode === 57 /* Meta */;
        this._asKeybinding = this._computeKeybinding();
        this._asRuntimeKeybinding = this._computeRuntimeKeybinding();
        // console.log(`code: ${e.code}, keyCode: ${e.keyCode}, key: ${e.key}`);
    }
    StandardKeyboardEvent.prototype.preventDefault = function () {
        if (this.browserEvent && this.browserEvent.preventDefault) {
            this.browserEvent.preventDefault();
        }
    };
    StandardKeyboardEvent.prototype.stopPropagation = function () {
        if (this.browserEvent && this.browserEvent.stopPropagation) {
            this.browserEvent.stopPropagation();
        }
    };
    StandardKeyboardEvent.prototype.toKeybinding = function () {
        return this._asRuntimeKeybinding;
    };
    StandardKeyboardEvent.prototype.equals = function (other) {
        return this._asKeybinding === other;
    };
    StandardKeyboardEvent.prototype._computeKeybinding = function () {
        var key = 0 /* Unknown */;
        if (this.keyCode !== 5 /* Ctrl */ && this.keyCode !== 4 /* Shift */ && this.keyCode !== 6 /* Alt */ && this.keyCode !== 57 /* Meta */) {
            key = this.keyCode;
        }
        var result = 0;
        if (this.ctrlKey) {
            result |= ctrlKeyMod;
        }
        if (this.altKey) {
            result |= altKeyMod;
        }
        if (this.shiftKey) {
            result |= shiftKeyMod;
        }
        if (this.metaKey) {
            result |= metaKeyMod;
        }
        result |= key;
        return result;
    };
    StandardKeyboardEvent.prototype._computeRuntimeKeybinding = function () {
        var key = 0 /* Unknown */;
        if (this.keyCode !== 5 /* Ctrl */ && this.keyCode !== 4 /* Shift */ && this.keyCode !== 6 /* Alt */ && this.keyCode !== 57 /* Meta */) {
            key = this.keyCode;
        }
        return new __WEBPACK_IMPORTED_MODULE_1__common_keyCodes_js__["e" /* SimpleKeybinding */](this.ctrlKey, this.shiftKey, this.altKey, this.metaKey, key);
    };
    return StandardKeyboardEvent;
}());



/***/ }),
/* 59 */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "a", function() { return EventType; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "b", function() { return Gesture; });
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_0__common_arrays_js__ = __webpack_require__(18);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_1__common_lifecycle_js__ = __webpack_require__(0);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_2__dom_js__ = __webpack_require__(3);
/* harmony import */ var __WEBPACK_IMPORTED_MODULE_3__common_decorators_js__ = __webpack_require__(115);
/*---------------------------------------------------------------------------------------------
 *  Copyright (c) Microsoft Corporation. All rights reserved.
 *  Licensed under the MIT License. See License.txt in the project root for license information.
 *--------------------------------------------------------------------------------------------*/
var __extends = (this && this.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];