# ПРИМЕР ОСТАНАВЛИВАЕТ МОТОР С БЛОКИРОВКОЙ И БЕЗ

from time import sleep

#   Подключаем библиотеку для работы с мотором I2C-flash.
from pyiArduinoI2Cmotor import *
mot = pyiArduinoI2Cmotor(0x09)                    #   Объявляем объект mot для работы с функциями и методами библиотеки pyiArduinoI2Cmotor, указывая адрес модуля на шине I2C.
                                                  #   Если объявить объект без указания адреса (mot = pyiArduinoI2Cmotor ), то адрес будет найден автоматически.
while True:
    #   Запускаем и плавно останавливаем мотор:
    #   Запускаем мотор на максимальной скорости, указав максимальное значение ШИМ = 100%.
    mot.setSpeed(100.0, MOT_PWM)
    sleep(5)

    #   Указываем освободить мотор при его остановке. Ротор остановленного мотора можно вращать.
    mot.setStopNeutral(True)

    #   Останавливаем мотор. Обратите внимание на то, что ротор мотора останавливается плавно.
    mot.setStop()
    sleep(1)

    #   Запускаем и резко останавливаем мотор:
    #   Запускаем мотор на максимальной скорости, указав максимальное значение ШИМ = 100%.
    mot.setSpeed(100.0, MOT_PWM)
    sleep(5)

    #   Указываем не освобождать мотор при его остановке. Ротор остановленного мотора будет застопорен.
    mot.setStopNeutral(False)

    #   Останавливаем мотор. Обратите внимание на то, что ротор мотора останавливается резко.
    mot.setStop()
    sleep(1)
#                                                #
#  Функция setStopNeutral() не останавливает     #
#  мотор, а указывает как он будет себя вести    #
#  при остановке.                                #
#  Останавливается мотор функцией setStop().     #
