# ПРИМЕР УПРАВЛЕНИЯ ДВИГАТЕЛЯМИ АВТОМОБИЛЯ:         #
# Максимальную скорость вращения моторов можно      #
# узнать запустив пример библиотеки FindMaxSpeed    #
                                                    #
from pyiArduinoI2Cmotor import *                    #   Подключаем библиотеку для работы с мотором I2C-flash.
mot = pyiArduinoI2Cmotor_L(0x09)                    #   Объявляем объект mot_L для работы с функциями и методами библиотеки pyiArduinoI2Cmotor, указывая адрес модуля на шине I2C.
mot = pyiArduinoI2Cmotor_R(0x0A)                    #   Объявляем объект mot_R для работы с функциями и методами библиотеки pyiArduinoI2Cmotor, указывая адрес модуля на шине I2C.
                                                    #   При наличии нескольких моторов на шине I2C нельзя объявлять объект без указания адреса.
mot_L.setDirection(False)                           #   Задаём направление вращения для левого  мотора: против часовой стрелки при положительных скоростях и по при отрицательных.
mot_R.setDirection(True)                            #   Задаём направление вращения для правого мотора: по часовой стрелке при положительных скоростях и против при отрицательных.
mot_L.radius = 12.2                                 #   Указываем радиус левого  колеса в мм (значение используется для движения на заданное растояние).
mot_R.radius = 12.2                                 #   Указываем радиус правого колеса в мм (значение используется для движения на заданное растояние).
                                                    #
while True:                                         #
#  Движение вперёд:                                 #
    mot_L.setSpeed( 120, MOT_RPM)                   #   Указываем левому  мотору работать на скорости  120 об/мин, что соответствует 2 об/сек.
    mot_R.setSpeed( 120, MOT_RPM)                   #   Указываем правому мотору работать на скорости  120 об/мин, что соответствует 2 об/сек.
    sleep(5)                                        #   Приостанавливаем выполнение скетча на 5 секунд. При этом моторы будут вращаться.
#  Движение вперёд с доворотом влево:               #
    mot_L.setSpeed(  60, MOT_RPM)                   #   Указываем левому  мотору работать на скорости   60 об/мин, что соответствует 1 об/сек.
    mot_R.setSpeed( 120, MOT_RPM)                   #   Указываем правому мотору работать на скорости  120 об/мин, что соответствует 2 об/сек.
    sleep(5)                                        #   Приостанавливаем выполнение скетча на 5 секунд. При этом моторы будут вращаться.
#  Движение назад:                                  #
    mot_L.setSpeed(-120, MOT_RPM)                   #   Указываем левому  мотору работать на скорости -120 об/мин, что соответствует 2 об/сек в обратную сторону.
    mot_R.setSpeed(-120, MOT_RPM)                   #   Указываем правому мотору работать на скорости -120 об/мин, что соответствует 2 об/сек в обратную сторону.
    sleep(5)                                        #   Приостанавливаем выполнение скетча на 5 секунд. При этом моторы будут вращаться.
#  Разворот на месте вправо:                        #
    mot_L.setSpeed( 120, MOT_RPM)                   #   Указываем левому  мотору работать на скорости  120 об/мин, что соответствует 2 об/сек.
    mot_R.setSpeed(-120, MOT_RPM)                   #   Указываем правому мотору работать на скорости -120 об/мин, что соответствует 2 об/сек в обратную сторону.
    sleep(5)                                        #   Приостанавливаем выполнение скетча на 5 секунд. При этом моторы будут вращаться.
#  Движение вперёд на заданное растояние:           #
    mot_L.setSpeed( 200, MOT_RPM, 1.5, MOT_MET )    #   Указываем левому  мотору работать на скорости 200 об/мин с остановкой мотора через 1.5 м пройденого пути.
    mot_R.setSpeed( 200, MOT_RPM, 1.5, MOT_MET )    #   Указываем правому мотору работать на скорости 200 об/мин с остановкой мотора через 1.5 м пройденого пути.
    sleep(20)                                       #   Приостанавливаем выполнение скетча на 20 секунд. За это время автомобиль точно успеет проехать 1.5 м (полтора метра) и остановиться.
