// ПРИМЕР ЗАДАЁТ ЧУВСТВИТЕЛЬНОСТЬ ОШИБКИ СКОРОСТИ //
                                                  //
#include "Serial.h"
#include "../iarduino_I2C_Motor.h"                //   Подключаем библиотеку для работы с мотором I2C-flash.
iarduino_I2C_Motor mot(0x09);                     //   Объявляем объект mot для работы с функциями и методами библиотеки iarduino_I2C_Motor, указывая адрес модуля на шине I2C.
                                                  //   Если объявить объект без указания адреса (iarduino_I2C_Motor mot;), то адрес будет найден автоматически.
int main(){                                       //
    mot.begin();                                  //   Инициируем работу с мотором.
    mot.setError(10);                             //   Задаём максимально допустимый процент отклонения заданной скорости от реальной, превышение которого приведёт к появлению ошибки.
    loop();                                       //
}                                                 //   Теперь функция getError() будет возвращать значение MOT_ERR_SPD если текущая скорость отличается от заданной более чем на 10%.
                                                  //   При том же значении будет включаться красный светодиод на плате модуля.
void loop(){                                      //
    mot.setSpeed(100, MOT_RPM);                   //   Запускаем мотор на скорости 100 об/мин.
    delay(1000);                                  //   Приостанавливаем выполнение скетча на 1 секунду.
    mot.setStop();                                //   Останавливаем мотор.
    delay(500);                                   //   Приостанавливаем выполнение скетча на 500 миллисекунд.
}                                                 //
                                                  //
//  По умолчанию, ошибка скорости возникает при   //   Значение заданное функцией mot.setError();
//  отличии заданной скорости от реальной более   //   сохраняется в энергонезависимой памяти модуля.
//  чем на 10 процентов. Измените данное значение //
//  обратившись к функции mot.setError(); и       //
//  обратите внимание на то как изменится         //
//  длительность свечения красного светодиода     //   Для большей нагладности предлагаем изменить
//  установленного на плате модуля.               //   параметр функции mot.setError(); с 10 на 1.
