// ПРИМЕР ВЫВОДИТ КОЛИЧЕСТВО СОВЕРШЁННЫХ ОБОРОТОВ //
                                                  //
#include "Serial.h"
#include "../iarduino_I2C_Motor.h"                //   Подключаем библиотеку для работы с мотором I2C-flash.
iarduino_I2C_Motor mot(0x09);                     //   Объявляем объект mot для работы с функциями и методами библиотеки iarduino_I2C_Motor, указывая адрес модуля на шине I2C.
                                                  //   Если объявить объект без указания адреса (iarduino_I2C_Motor mot;), то адрес будет найден автоматически.
int main(){                                       //
    mot.begin();                                  //   Инициируем работу с мотором.
    mot.radius = 12.2;                            //   Указываем радиус колеса в мм.
    mot.setSpeed(60, MOT_RPM);                    //   Запускаем мотор на скорости 60 об/мин.
    loop();                                       //
}                                                 //
                                                  //
void loop(){                                      //
    uint32_t i = millis()/1000;                   //   Получаем количество пройденных сеунд.
    Serial.print("Совершено ");                   //
    Serial.print( mot.getSum(MOT_REV) );          //   Выводим количество совершённых оборотов.
    Serial.print(" полных оборотов, пройдено ");  //
    Serial.print( mot.getSum(MOT_MET) );          //   Выводим количество метров пройденного пути.
    Serial.print(" м пути, за ");                 //
    Serial.print( i % 60 );                       //   Выводим количество секунд в минуте.
    Serial.print(" секунд");                      //
    if(i<10 || i>20){                             //   Добавляем окончание к слову секунд...
        if(i % 10 == 1     ){Serial.print("у");}  //   за 1   секундУ.
        if(i%10>1 && i%10<5){Serial.print("ы");}  //   за 2-4 секундЫ.
    }                                             //
    Serial.println(".");                          //
    delay(100);                                   //
//  Сбрасываем количество оборотов 1 раз в минуту //
    if( i%60 == 0 ){                              //   Условие выполняется каждые 60 сек.
        mot.delSum();                             //   Сбрасываем количество совершённых оборотов.
        Serial.println("======================"); //
        delay(1000);                              //
    }                                             //
}                                                 //
                                                  //
// ПРИМЕЧАНИЕ:                                    //
// Количество совершённых оборотов сбрасывается   //   Функция getSum() работает даже если остановить
// - при достижении 167'772,16 оборотов;          //   мотор функцией setStop() и вращать ротор вручную.
// - при обращении к функции delSum();            //
// - при обращении к любой функции кроме getSum() //
//   с параметром MOT_REV или MOT_MET.            //
