"""Sub-package __init__."""


from .decorators import (
    authenticated,
    catch_error,
    role_authorization,
    scope_role_auth,
    keycloak_role_auth,
)
from .handler import (
    RestHandler,
    RestHandlerSetup,
    OpenIDLoginHandler,
)
from .server import RestServer

__all__ = [
    "RestServer",
    "RestHandlerSetup",
    "RestHandler",
    "OpenIDLoginHandler",
    "authenticated",
    "catch_error",
    "role_authorization",
    "scope_role_auth",
    "keycloak_role_auth",
]
