import struct

from pingboard.util import checksum


def test_checksum():
    # This buf comes from a wireshark session where I captured an IPv4 icmp
    # echo request, and zero'd out the icmp checksum field.
    buf = \
        b'\x08\x00\x00\x00\x0e\xf7\x00\x0e\x5a\x06\x6b\x7e\x00\x01\x0f\xbd' +\
        b'\x08\x09\x0a\x0b\x0c\x0d\x0e\x0f\x10\x11\x12\x13\x14\x15\x16\x17' +\
        b'\x18\x19\x1a\x1b\x1c\x1d\x1e\x1f\x20\x21\x22\x23\x24\x25\x26\x27' +\
        b'\x28\x29\x2a\x2b\x2c\x2d\x2e\x2f\x30\x31\x32\x33\x34\x35\x36\x37'

    cksum = checksum(buf)
    assert cksum == struct.unpack('!H', b'\x28\xb5')[0]
