<h1 align="center">Sphinx awesome theme</h1>

<p align="center">
   <img src="https://img.shields.io/github/license/kai687/sphinxawesome-theme?color=blue&style=for-the-badge" alt="MIT license">
   <img src="https://img.shields.io/pypi/v/sphinxawesome-theme?color=eb5&style=for-the-badge&logo=pypi" alt="PyPI version">
   <img src="https://img.shields.io/netlify/e6d20a5c-b49e-4ebc-80f6-59fde8f24e22?logo=netlify&style=for-the-badge" alt="Netlify Deploy">
   <img alt="GitHub Workflow Status" src="https://img.shields.io/github/actions/workflow/status/kai687/sphinxawesome-theme/lint.yml?label=Linted&style=for-the-badge">
</p>

<p align="center">
   Create beautiful and awesome documentation websites with <a href="https://www.sphinx-doc.org/en/master/">Sphinx</a>.
   See how the theme looks like on <a href="https://sphinxawesome.xyz">sphinxawesome.xyz</a>.
</p>

## Get started

To use this theme in your project,
install it via `pip` and add it to your Sphinx configuration.

1. Install the theme as a Python package:

   ```console
   pip install sphinxawesome-theme
   ```

   For more information, see [How to install the theme](https://sphinxawesome.xyz/how-to/install/).

1. Add `sphinxawesome_theme` as an extension and HTML theme in your Sphinx configuration file `conf.py`:

   ```python
   html_theme = "sphinxawesome_theme"
   extensions = ["sphinxawesome_theme"]
   ```

   For more information, see [How to load the theme](https://sphinxawesome.xyz/how-to/load/) for more information.

## Features

With the Awesome Theme, you can build readable, functional, and beautiful documentation websites.
These features make your documentation awesome:

### Awesome code blocks

Code blocks show the language of the code in a header.
Each code block has a **Copy** button for easy copying.
This theme enhances Sphinx's `code-block` directive with these options:

- `emphasize-added`. Highlight lines that should be added to code
- `emphasize-removed`. Highlight lines that should be removed from the code
- `emphasize-text: TEXT`. Highlight `TEXT` in the code block to emphasize placeholder text the user should replace.

### Collapsible elements

Nested navigation links allow you to reach all pages from all other pages.
You can make code object definitions like methods, classes, or modules collapsible as well.

### Better headerlinks

Clicking the link icon after headers or captions automatically copies the URL to the clipboard.

### DocSearch

If you have an Algolia DocSearch account for your documentation,
you can use DocSearch for a search-as-you-type experience with autocomplete.
Algolia DocSearch is free for open source documentation projects.

### Better keyboard navigation

Use the `Tab` key to skip through all sections on the page.
Use the `Space` key to expand or collapse items in the navigation menu or in code definitions.
