# -*- coding: utf-8 -*-
# This file is auto-generated, don't edit it. Thanks.
from Tea.model import TeaModel
from typing import List, Dict, Any


class QueryIncidentTracingSubNodesCountRequest(TeaModel):
    def __init__(
        self,
        vertex_id_and_type_list: List[List[str]] = None,
    ):
        self.vertex_id_and_type_list = vertex_id_and_type_list

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.vertex_id_and_type_list is not None:
            result['VertexIdAndTypeList'] = self.vertex_id_and_type_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('VertexIdAndTypeList') is not None:
            self.vertex_id_and_type_list = m.get('VertexIdAndTypeList')
        return self


class AddCheckInstanceResultWhiteListRequest(TeaModel):
    def __init__(
        self,
        check_group_id: str = None,
        check_id: int = None,
        instance_ids: List[str] = None,
    ):
        self.check_group_id = check_group_id
        self.check_id = check_id
        self.instance_ids = instance_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.check_group_id is not None:
            result['CheckGroupId'] = self.check_group_id
        if self.check_id is not None:
            result['CheckId'] = self.check_id
        if self.instance_ids is not None:
            result['InstanceIds'] = self.instance_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CheckGroupId') is not None:
            self.check_group_id = m.get('CheckGroupId')
        if m.get('CheckId') is not None:
            self.check_id = m.get('CheckId')
        if m.get('InstanceIds') is not None:
            self.instance_ids = m.get('InstanceIds')
        return self


class AddCheckInstanceResultWhiteListResponseBody(TeaModel):
    def __init__(
        self,
        data: Dict[str, Any] = None,
        request_id: str = None,
    ):
        self.data = data
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddCheckInstanceResultWhiteListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AddCheckInstanceResultWhiteListResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddCheckInstanceResultWhiteListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddCheckResultWhiteListRequest(TeaModel):
    def __init__(
        self,
        check_ids: List[int] = None,
    ):
        self.check_ids = check_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.check_ids is not None:
            result['CheckIds'] = self.check_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CheckIds') is not None:
            self.check_ids = m.get('CheckIds')
        return self


class AddCheckResultWhiteListResponseBody(TeaModel):
    def __init__(
        self,
        data: Dict[str, Any] = None,
        request_id: str = None,
    ):
        self.data = data
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddCheckResultWhiteListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AddCheckResultWhiteListResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddCheckResultWhiteListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddClientUserDefineRuleRequest(TeaModel):
    def __init__(
        self,
        action_type: int = None,
        cmdline: str = None,
        file_path: str = None,
        ip: str = None,
        md_5list: str = None,
        name: str = None,
        new_file_path: str = None,
        parent_cmdline: str = None,
        parent_proc_path: str = None,
        platform: str = None,
        port: int = None,
        port_str: str = None,
        proc_path: str = None,
        registry_content: str = None,
        registry_key: str = None,
        type: int = None,
    ):
        self.action_type = action_type
        self.cmdline = cmdline
        self.file_path = file_path
        self.ip = ip
        self.md_5list = md_5list
        self.name = name
        self.new_file_path = new_file_path
        self.parent_cmdline = parent_cmdline
        self.parent_proc_path = parent_proc_path
        self.platform = platform
        self.port = port
        self.port_str = port_str
        self.proc_path = proc_path
        self.registry_content = registry_content
        self.registry_key = registry_key
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.action_type is not None:
            result['ActionType'] = self.action_type
        if self.cmdline is not None:
            result['Cmdline'] = self.cmdline
        if self.file_path is not None:
            result['FilePath'] = self.file_path
        if self.ip is not None:
            result['IP'] = self.ip
        if self.md_5list is not None:
            result['Md5List'] = self.md_5list
        if self.name is not None:
            result['Name'] = self.name
        if self.new_file_path is not None:
            result['NewFilePath'] = self.new_file_path
        if self.parent_cmdline is not None:
            result['ParentCmdline'] = self.parent_cmdline
        if self.parent_proc_path is not None:
            result['ParentProcPath'] = self.parent_proc_path
        if self.platform is not None:
            result['Platform'] = self.platform
        if self.port is not None:
            result['Port'] = self.port
        if self.port_str is not None:
            result['PortStr'] = self.port_str
        if self.proc_path is not None:
            result['ProcPath'] = self.proc_path
        if self.registry_content is not None:
            result['RegistryContent'] = self.registry_content
        if self.registry_key is not None:
            result['RegistryKey'] = self.registry_key
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ActionType') is not None:
            self.action_type = m.get('ActionType')
        if m.get('Cmdline') is not None:
            self.cmdline = m.get('Cmdline')
        if m.get('FilePath') is not None:
            self.file_path = m.get('FilePath')
        if m.get('IP') is not None:
            self.ip = m.get('IP')
        if m.get('Md5List') is not None:
            self.md_5list = m.get('Md5List')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('NewFilePath') is not None:
            self.new_file_path = m.get('NewFilePath')
        if m.get('ParentCmdline') is not None:
            self.parent_cmdline = m.get('ParentCmdline')
        if m.get('ParentProcPath') is not None:
            self.parent_proc_path = m.get('ParentProcPath')
        if m.get('Platform') is not None:
            self.platform = m.get('Platform')
        if m.get('Port') is not None:
            self.port = m.get('Port')
        if m.get('PortStr') is not None:
            self.port_str = m.get('PortStr')
        if m.get('ProcPath') is not None:
            self.proc_path = m.get('ProcPath')
        if m.get('RegistryContent') is not None:
            self.registry_content = m.get('RegistryContent')
        if m.get('RegistryKey') is not None:
            self.registry_key = m.get('RegistryKey')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class AddClientUserDefineRuleResponseBodyUserDefineRuleAddResult(TeaModel):
    def __init__(
        self,
        id: int = None,
        platform: str = None,
        switch_id: str = None,
    ):
        self.id = id
        self.platform = platform
        self.switch_id = switch_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.platform is not None:
            result['Platform'] = self.platform
        if self.switch_id is not None:
            result['SwitchId'] = self.switch_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Platform') is not None:
            self.platform = m.get('Platform')
        if m.get('SwitchId') is not None:
            self.switch_id = m.get('SwitchId')
        return self


class AddClientUserDefineRuleResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        user_define_rule_add_result: AddClientUserDefineRuleResponseBodyUserDefineRuleAddResult = None,
    ):
        self.request_id = request_id
        self.user_define_rule_add_result = user_define_rule_add_result

    def validate(self):
        if self.user_define_rule_add_result:
            self.user_define_rule_add_result.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.user_define_rule_add_result is not None:
            result['UserDefineRuleAddResult'] = self.user_define_rule_add_result.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('UserDefineRuleAddResult') is not None:
            temp_model = AddClientUserDefineRuleResponseBodyUserDefineRuleAddResult()
            self.user_define_rule_add_result = temp_model.from_map(m['UserDefineRuleAddResult'])
        return self


class AddClientUserDefineRuleResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AddClientUserDefineRuleResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddClientUserDefineRuleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddInstallCodeRequest(TeaModel):
    def __init__(
        self,
        expired_date: int = None,
        group_id: int = None,
        only_image: bool = None,
        os: str = None,
        vendor_name: str = None,
    ):
        # The validity period of the installation command. The value is a 13-digit timestamp.
        # 
        # >  The installation command is valid only within the validity period. An expired installation command cannot be used to install the Security Center agent.
        self.expired_date = expired_date
        # The ID of the asset group to which the you want to add the asset.
        # 
        # >  You can call the [DescribeAllGroups](~~describeallgroups~~) operation to query the IDs of asset groups.
        self.group_id = group_id
        # Specifies whether to create an image. Default value: **false**. Valid values:
        # 
        # *   **false**: does not create an image.
        # *   **true**: creates an image.
        self.only_image = only_image
        # The operating system of the instance. Default value: **linux**. Valid values:
        # 
        # *   **linux**\
        # *   **windows**\
        # *   **windows-2003**\
        self.os = os
        # The name of the service provider for the asset. Default value: **ALIYUN**.
        # 
        # >  You can call the [DescribeVendorList](~~DescribeVendorList~~) operation to query the names of service providers.
        self.vendor_name = vendor_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.expired_date is not None:
            result['ExpiredDate'] = self.expired_date
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.only_image is not None:
            result['OnlyImage'] = self.only_image
        if self.os is not None:
            result['Os'] = self.os
        if self.vendor_name is not None:
            result['VendorName'] = self.vendor_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ExpiredDate') is not None:
            self.expired_date = m.get('ExpiredDate')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('OnlyImage') is not None:
            self.only_image = m.get('OnlyImage')
        if m.get('Os') is not None:
            self.os = m.get('Os')
        if m.get('VendorName') is not None:
            self.vendor_name = m.get('VendorName')
        return self


class AddInstallCodeResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddInstallCodeResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AddInstallCodeResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddInstallCodeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddTagWithUuidRequest(TeaModel):
    def __init__(
        self,
        tag_name: str = None,
        uuid_list: str = None,
    ):
        self.tag_name = tag_name
        self.uuid_list = uuid_list

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tag_name is not None:
            result['TagName'] = self.tag_name
        if self.uuid_list is not None:
            result['UuidList'] = self.uuid_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TagName') is not None:
            self.tag_name = m.get('TagName')
        if m.get('UuidList') is not None:
            self.uuid_list = m.get('UuidList')
        return self


class AddTagWithUuidResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddTagWithUuidResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AddTagWithUuidResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddTagWithUuidResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddUninstallClientsByUuidsRequest(TeaModel):
    def __init__(
        self,
        call_method: str = None,
        feedback: str = None,
        region: str = None,
        source_ip: str = None,
        uuids: str = None,
    ):
        self.call_method = call_method
        self.feedback = feedback
        self.region = region
        self.source_ip = source_ip
        self.uuids = uuids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.call_method is not None:
            result['CallMethod'] = self.call_method
        if self.feedback is not None:
            result['Feedback'] = self.feedback
        if self.region is not None:
            result['Region'] = self.region
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.uuids is not None:
            result['Uuids'] = self.uuids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CallMethod') is not None:
            self.call_method = m.get('CallMethod')
        if m.get('Feedback') is not None:
            self.feedback = m.get('Feedback')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('Uuids') is not None:
            self.uuids = m.get('Uuids')
        return self


class AddUninstallClientsByUuidsResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddUninstallClientsByUuidsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AddUninstallClientsByUuidsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddUninstallClientsByUuidsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AddVpcHoneyPotRequest(TeaModel):
    def __init__(
        self,
        vpc_id: str = None,
    ):
        # The ID of the virtual private cloud (VPC) in which you want to create a honeypot.
        # 
        # >  You can call the [DescribeVpcList](~~DescribeVpcList~~) operation to obtain the VPC ID. The VPC ID is the value of the InstanceId parameter.
        self.vpc_id = vpc_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        return self


class AddVpcHoneyPotResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class AddVpcHoneyPotResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AddVpcHoneyPotResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AddVpcHoneyPotResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class AdvanceSecurityEventOperationsRequest(TeaModel):
    def __init__(
        self,
        event_name: str = None,
        event_type: str = None,
        resource_owner_id: int = None,
        rule_id: int = None,
    ):
        self.event_name = event_name
        self.event_type = event_type
        self.resource_owner_id = resource_owner_id
        self.rule_id = rule_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.event_name is not None:
            result['EventName'] = self.event_name
        if self.event_type is not None:
            result['EventType'] = self.event_type
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EventName') is not None:
            self.event_name = m.get('EventName')
        if m.get('EventType') is not None:
            self.event_type = m.get('EventType')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        return self


class AdvanceSecurityEventOperationsResponseBodySecurityEventOperationsResponseMarkField(TeaModel):
    def __init__(
        self,
        filed_alias_name: str = None,
        filed_name: str = None,
        mark_mis_type: str = None,
        mark_mis_value: str = None,
        supported_mis_type: List[str] = None,
    ):
        self.filed_alias_name = filed_alias_name
        self.filed_name = filed_name
        self.mark_mis_type = mark_mis_type
        self.mark_mis_value = mark_mis_value
        self.supported_mis_type = supported_mis_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.filed_alias_name is not None:
            result['FiledAliasName'] = self.filed_alias_name
        if self.filed_name is not None:
            result['FiledName'] = self.filed_name
        if self.mark_mis_type is not None:
            result['MarkMisType'] = self.mark_mis_type
        if self.mark_mis_value is not None:
            result['MarkMisValue'] = self.mark_mis_value
        if self.supported_mis_type is not None:
            result['SupportedMisType'] = self.supported_mis_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FiledAliasName') is not None:
            self.filed_alias_name = m.get('FiledAliasName')
        if m.get('FiledName') is not None:
            self.filed_name = m.get('FiledName')
        if m.get('MarkMisType') is not None:
            self.mark_mis_type = m.get('MarkMisType')
        if m.get('MarkMisValue') is not None:
            self.mark_mis_value = m.get('MarkMisValue')
        if m.get('SupportedMisType') is not None:
            self.supported_mis_type = m.get('SupportedMisType')
        return self


class AdvanceSecurityEventOperationsResponseBodySecurityEventOperationsResponseMarkFieldsSource(TeaModel):
    def __init__(
        self,
        filed_alias_name: str = None,
        filed_name: str = None,
        mark_mis_value: str = None,
        supported_mis_type: List[str] = None,
    ):
        self.filed_alias_name = filed_alias_name
        self.filed_name = filed_name
        self.mark_mis_value = mark_mis_value
        self.supported_mis_type = supported_mis_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.filed_alias_name is not None:
            result['FiledAliasName'] = self.filed_alias_name
        if self.filed_name is not None:
            result['FiledName'] = self.filed_name
        if self.mark_mis_value is not None:
            result['MarkMisValue'] = self.mark_mis_value
        if self.supported_mis_type is not None:
            result['SupportedMisType'] = self.supported_mis_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FiledAliasName') is not None:
            self.filed_alias_name = m.get('FiledAliasName')
        if m.get('FiledName') is not None:
            self.filed_name = m.get('FiledName')
        if m.get('MarkMisValue') is not None:
            self.mark_mis_value = m.get('MarkMisValue')
        if m.get('SupportedMisType') is not None:
            self.supported_mis_type = m.get('SupportedMisType')
        return self


class AdvanceSecurityEventOperationsResponseBodySecurityEventOperationsResponse(TeaModel):
    def __init__(
        self,
        mark_field: List[AdvanceSecurityEventOperationsResponseBodySecurityEventOperationsResponseMarkField] = None,
        mark_fields_source: List[AdvanceSecurityEventOperationsResponseBodySecurityEventOperationsResponseMarkFieldsSource] = None,
        operation_code: str = None,
        operation_params: str = None,
        user_can_operate: bool = None,
    ):
        self.mark_field = mark_field
        self.mark_fields_source = mark_fields_source
        self.operation_code = operation_code
        self.operation_params = operation_params
        self.user_can_operate = user_can_operate

    def validate(self):
        if self.mark_field:
            for k in self.mark_field:
                if k:
                    k.validate()
        if self.mark_fields_source:
            for k in self.mark_fields_source:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['MarkField'] = []
        if self.mark_field is not None:
            for k in self.mark_field:
                result['MarkField'].append(k.to_map() if k else None)
        result['MarkFieldsSource'] = []
        if self.mark_fields_source is not None:
            for k in self.mark_fields_source:
                result['MarkFieldsSource'].append(k.to_map() if k else None)
        if self.operation_code is not None:
            result['OperationCode'] = self.operation_code
        if self.operation_params is not None:
            result['OperationParams'] = self.operation_params
        if self.user_can_operate is not None:
            result['UserCanOperate'] = self.user_can_operate
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.mark_field = []
        if m.get('MarkField') is not None:
            for k in m.get('MarkField'):
                temp_model = AdvanceSecurityEventOperationsResponseBodySecurityEventOperationsResponseMarkField()
                self.mark_field.append(temp_model.from_map(k))
        self.mark_fields_source = []
        if m.get('MarkFieldsSource') is not None:
            for k in m.get('MarkFieldsSource'):
                temp_model = AdvanceSecurityEventOperationsResponseBodySecurityEventOperationsResponseMarkFieldsSource()
                self.mark_fields_source.append(temp_model.from_map(k))
        if m.get('OperationCode') is not None:
            self.operation_code = m.get('OperationCode')
        if m.get('OperationParams') is not None:
            self.operation_params = m.get('OperationParams')
        if m.get('UserCanOperate') is not None:
            self.user_can_operate = m.get('UserCanOperate')
        return self


class AdvanceSecurityEventOperationsResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        security_event_operations_response: List[AdvanceSecurityEventOperationsResponseBodySecurityEventOperationsResponse] = None,
    ):
        self.request_id = request_id
        self.security_event_operations_response = security_event_operations_response

    def validate(self):
        if self.security_event_operations_response:
            for k in self.security_event_operations_response:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['SecurityEventOperationsResponse'] = []
        if self.security_event_operations_response is not None:
            for k in self.security_event_operations_response:
                result['SecurityEventOperationsResponse'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.security_event_operations_response = []
        if m.get('SecurityEventOperationsResponse') is not None:
            for k in m.get('SecurityEventOperationsResponse'):
                temp_model = AdvanceSecurityEventOperationsResponseBodySecurityEventOperationsResponse()
                self.security_event_operations_response.append(temp_model.from_map(k))
        return self


class AdvanceSecurityEventOperationsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: AdvanceSecurityEventOperationsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = AdvanceSecurityEventOperationsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BatchOperateCommonOverallConfigRequest(TeaModel):
    def __init__(
        self,
        config: str = None,
        type_list: List[str] = None,
    ):
        self.config = config
        self.type_list = type_list

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config is not None:
            result['Config'] = self.config
        if self.type_list is not None:
            result['TypeList'] = self.type_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Config') is not None:
            self.config = m.get('Config')
        if m.get('TypeList') is not None:
            self.type_list = m.get('TypeList')
        return self


class BatchOperateCommonOverallConfigResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class BatchOperateCommonOverallConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: BatchOperateCommonOverallConfigResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = BatchOperateCommonOverallConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class BindAuthToMachineRequest(TeaModel):
    def __init__(
        self,
        auth_version: int = None,
        auto_bind: int = None,
        bind: List[str] = None,
        bind_all: bool = None,
        criteria: str = None,
        logical_exp: str = None,
        un_bind: List[str] = None,
    ):
        # The edition of Security Center. Valid values:
        # 
        # *   **6**: Anti-virus edition
        # *   **5**: Advanced edition
        # *   **3**: Enterprise edition
        # *   **7**: Ultimate edition
        # *   **10**: Value-added Plan edition
        self.auth_version = auth_version
        # Specifies whether to automatically bind servers to Security Center. Valid values:
        # 
        # *   **0**: no
        # *   **1**: yes
        self.auto_bind = auto_bind
        # The UUIDs of the servers that you want to bind to Security Center.
        # 
        # >  You must specify at least one of the **Bind** and **UnBind** parameters.
        self.bind = bind
        # Specifies whether to bind all servers to Security Center. Default value: **false**. Valid values:
        # 
        # *   **true**: yes
        # *   **false**: no
        self.bind_all = bind_all
        # The search conditions that are used to filter servers. The value of this parameter is in the JSON format and is case-sensitive.
        # 
        # >  A search condition can be an instance ID, instance name, virtual private cloud (VPC) ID, region, or public IP address. You can call the [DescribeCriteria](~~DescribeCriteria~~) operation to query the supported search conditions.
        self.criteria = criteria
        # The logical relationship among multiple search conditions. Valid values:
        # 
        # *   **OR**: Search conditions are evaluated by using a logical **OR**.
        # *   **AND**: Search conditions are evaluated by using a logical **AND**.
        self.logical_exp = logical_exp
        # The UUIDs of the servers that you want to unbind from Security Center.
        # 
        # >  You must specify at least one of the **Bind** and **UnBind** parameters.
        self.un_bind = un_bind

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth_version is not None:
            result['AuthVersion'] = self.auth_version
        if self.auto_bind is not None:
            result['AutoBind'] = self.auto_bind
        if self.bind is not None:
            result['Bind'] = self.bind
        if self.bind_all is not None:
            result['BindAll'] = self.bind_all
        if self.criteria is not None:
            result['Criteria'] = self.criteria
        if self.logical_exp is not None:
            result['LogicalExp'] = self.logical_exp
        if self.un_bind is not None:
            result['UnBind'] = self.un_bind
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AuthVersion') is not None:
            self.auth_version = m.get('AuthVersion')
        if m.get('AutoBind') is not None:
            self.auto_bind = m.get('AutoBind')
        if m.get('Bind') is not None:
            self.bind = m.get('Bind')
        if m.get('BindAll') is not None:
            self.bind_all = m.get('BindAll')
        if m.get('Criteria') is not None:
            self.criteria = m.get('Criteria')
        if m.get('LogicalExp') is not None:
            self.logical_exp = m.get('LogicalExp')
        if m.get('UnBind') is not None:
            self.un_bind = m.get('UnBind')
        return self


class BindAuthToMachineResponseBody(TeaModel):
    def __init__(
        self,
        bind_count: int = None,
        insufficient_core_count: int = None,
        insufficient_ecs_count: int = None,
        request_id: str = None,
        result_code: int = None,
        un_bind_count: int = None,
    ):
        # The number of bound servers.
        self.bind_count = bind_count
        # The shortage in the quota for cores of servers that can be protected.
        self.insufficient_core_count = insufficient_core_count
        # The shortage in the quota for servers that can be protected.
        self.insufficient_ecs_count = insufficient_ecs_count
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id
        # The status code that indicates the result. Valid values:
        # 
        # *   **0**: The servers are bound to or unbound from Security Center.
        # *   **1**: The values that you specified for the parameters are invalid.
        # *   **2**: The quota for servers that can be protected is insufficient.
        # *   **3**: The quota for cores of servers that can be protected is insufficient.
        self.result_code = result_code
        # The number of unbound servers.
        self.un_bind_count = un_bind_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bind_count is not None:
            result['BindCount'] = self.bind_count
        if self.insufficient_core_count is not None:
            result['InsufficientCoreCount'] = self.insufficient_core_count
        if self.insufficient_ecs_count is not None:
            result['InsufficientEcsCount'] = self.insufficient_ecs_count
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.result_code is not None:
            result['ResultCode'] = self.result_code
        if self.un_bind_count is not None:
            result['UnBindCount'] = self.un_bind_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BindCount') is not None:
            self.bind_count = m.get('BindCount')
        if m.get('InsufficientCoreCount') is not None:
            self.insufficient_core_count = m.get('InsufficientCoreCount')
        if m.get('InsufficientEcsCount') is not None:
            self.insufficient_ecs_count = m.get('InsufficientEcsCount')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ResultCode') is not None:
            self.result_code = m.get('ResultCode')
        if m.get('UnBindCount') is not None:
            self.un_bind_count = m.get('UnBindCount')
        return self


class BindAuthToMachineResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: BindAuthToMachineResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = BindAuthToMachineResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CancelOnceTaskRequest(TeaModel):
    def __init__(
        self,
        task_id: str = None,
    ):
        self.task_id = task_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class CancelOnceTaskResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CancelOnceTaskResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CancelOnceTaskResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CancelOnceTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ChangeCheckConfigRequest(TeaModel):
    def __init__(
        self,
        cycle_days: List[int] = None,
        end_time: int = None,
        standard_ids: List[int] = None,
        start_time: int = None,
    ):
        self.cycle_days = cycle_days
        self.end_time = end_time
        self.standard_ids = standard_ids
        self.start_time = start_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cycle_days is not None:
            result['CycleDays'] = self.cycle_days
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.standard_ids is not None:
            result['StandardIds'] = self.standard_ids
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CycleDays') is not None:
            self.cycle_days = m.get('CycleDays')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('StandardIds') is not None:
            self.standard_ids = m.get('StandardIds')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class ChangeCheckConfigResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class ChangeCheckConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ChangeCheckConfigResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ChangeCheckConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CheckQuaraFileIdRequest(TeaModel):
    def __init__(
        self,
        quara_file_ids: List[str] = None,
        uuid: str = None,
    ):
        # The IDs of quarantined files that you want to check.
        # 
        # >  You can call the [DescribeSuspEventQuaraFiles](~~DescribeSuspEventQuaraFiles~~) operation to query the IDs of quarantined files.
        self.quara_file_ids = quara_file_ids
        # The UUID of the server on which you want to check quarantined files.
        # 
        # >  You can call the [DescribeCloudCenterInstances](~~DescribeCloudCenterInstances~~) operation to query the UUIDs of servers.
        self.uuid = uuid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.quara_file_ids is not None:
            result['QuaraFileIds'] = self.quara_file_ids
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('QuaraFileIds') is not None:
            self.quara_file_ids = m.get('QuaraFileIds')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class CheckQuaraFileIdResponseBody(TeaModel):
    def __init__(
        self,
        data: bool = None,
        request_id: str = None,
    ):
        # Indicates whether the ID of the quarantined file is valid. Valid values:
        # 
        # *   **true**: The ID of the quarantined file is valid.
        # *   **false**: The ID of the quarantined file is invalid.
        self.data = data
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CheckQuaraFileIdResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CheckQuaraFileIdResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CheckQuaraFileIdResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CheckSecurityEventIdRequest(TeaModel):
    def __init__(
        self,
        security_event_ids: List[str] = None,
        uuid: str = None,
    ):
        # The IDs of alert events. You can specify up to 100 IDs. If you do not specify this parameter, the value of the response parameter **Data** is **false**. The value false indicates that no alert events are generated on the server.
        # 
        # >  You can call the [DescribeAlarmEventList](~~DescribeAlarmEventList~~) operation to query the IDs of alert events.
        self.security_event_ids = security_event_ids
        # The UUID of the server.
        # 
        # >  You can call the [DescribeCloudCenterInstances](~~DescribeCloudCenterInstances~~) operation to query the UUIDs of servers.
        self.uuid = uuid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.security_event_ids is not None:
            result['SecurityEventIds'] = self.security_event_ids
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SecurityEventIds') is not None:
            self.security_event_ids = m.get('SecurityEventIds')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class CheckSecurityEventIdResponseBody(TeaModel):
    def __init__(
        self,
        data: bool = None,
        request_id: str = None,
    ):
        # Indicates whether the alert events are generated on the server. Valid values:
        # 
        # *   **true**: yes
        # *   **false**: no
        self.data = data
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CheckSecurityEventIdResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CheckSecurityEventIdResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CheckSecurityEventIdResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CheckUserHasEcsRequest(TeaModel):
    def __init__(
        self,
        lang: str = None,
    ):
        # The language of the content within the request and response. Default value: **zh**. Valid values:
        # 
        # *   **zh**: Chinese
        # *   **en**: English
        self.lang = lang

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.lang is not None:
            result['Lang'] = self.lang
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        return self


class CheckUserHasEcsResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: bool = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The status code returned. The status code **200** indicates that the request is successful. Other status codes indicate that the request fails. You can identify the cause of the failure based on the status code.
        self.code = code
        # Indicates whether ECS instances exist. Valid values:
        # 
        # *   **true**: yes
        # *   **false**: no
        self.data = data
        # The error message returned.
        self.message = message
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id
        # The status of the request. Valid values:
        # 
        # *   **true**: The request is successful.
        # *   **false**: The request fails.
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CheckUserHasEcsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CheckUserHasEcsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CheckUserHasEcsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class ConfirmVirusEventsRequest(TeaModel):
    def __init__(
        self,
        operation_all: int = None,
        operation_code: str = None,
        operation_range: str = None,
    ):
        self.operation_all = operation_all
        self.operation_code = operation_code
        self.operation_range = operation_range

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.operation_all is not None:
            result['OperationAll'] = self.operation_all
        if self.operation_code is not None:
            result['OperationCode'] = self.operation_code
        if self.operation_range is not None:
            result['OperationRange'] = self.operation_range
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OperationAll') is not None:
            self.operation_all = m.get('OperationAll')
        if m.get('OperationCode') is not None:
            self.operation_code = m.get('OperationCode')
        if m.get('OperationRange') is not None:
            self.operation_range = m.get('OperationRange')
        return self


class ConfirmVirusEventsResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        result: bool = None,
    ):
        self.request_id = request_id
        self.result = result

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.result is not None:
            result['Result'] = self.result
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Result') is not None:
            self.result = m.get('Result')
        return self


class ConfirmVirusEventsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: ConfirmVirusEventsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = ConfirmVirusEventsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateAntiBruteForceRuleRequest(TeaModel):
    def __init__(
        self,
        default_rule: bool = None,
        fail_count: int = None,
        forbidden_time: int = None,
        name: str = None,
        resource_owner_id: int = None,
        source_ip: str = None,
        span: int = None,
        uuid_list: List[str] = None,
    ):
        # Specifies whether to set the defense rule as the default rule. Valid values:
        # 
        # *   **true**: yes
        # *   **false**: no
        # 
        # >  If no defense rule is created for a server, the default rule is applied to the server.
        self.default_rule = default_rule
        # The maximum number of failed logon attempts from an account. Valid values: 2, 3, 4, 5, 10, 50, 80, and 100.
        self.fail_count = fail_count
        # The period of time during which logons from an account are not allowed. Unit: minutes. Valid values:
        # 
        # *   **5**: 5 minutes
        # *   **15**: 15 minutes
        # *   **30**: 30 minutes
        # *   **60**: 1 hour
        # *   **120**: 2 hours
        # *   **360**: 6 hours
        # *   **720**: 12 hours
        # *   **1440**: 24 hours
        # *   **10080**: 7 days
        # *   **52560000**: permanent
        self.forbidden_time = forbidden_time
        # The name of the defense rule.
        self.name = name
        self.resource_owner_id = resource_owner_id
        # The source IP address of the request.
        self.source_ip = source_ip
        # The maximum period of time during which failed logon attempts from an account can occur. Unit: minutes. Valid values:
        # 
        # *   **1**\
        # *   **2**\
        # *   **5**\
        # *   **10**\
        # *   **15**\
        # 
        # >  To configure a defense rule, you must specify the Span, FailCount, and ForbiddenTime parameters. If the number of failed logon attempts from an account within the minutes specified by Span exceeds the value specified by FailCount, the account cannot be used for logons within the minutes specified by ForbiddenTime.
        self.span = span
        # The UUIDs of the servers to which you want to apply the defense rule.
        self.uuid_list = uuid_list

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.default_rule is not None:
            result['DefaultRule'] = self.default_rule
        if self.fail_count is not None:
            result['FailCount'] = self.fail_count
        if self.forbidden_time is not None:
            result['ForbiddenTime'] = self.forbidden_time
        if self.name is not None:
            result['Name'] = self.name
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.span is not None:
            result['Span'] = self.span
        if self.uuid_list is not None:
            result['UuidList'] = self.uuid_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DefaultRule') is not None:
            self.default_rule = m.get('DefaultRule')
        if m.get('FailCount') is not None:
            self.fail_count = m.get('FailCount')
        if m.get('ForbiddenTime') is not None:
            self.forbidden_time = m.get('ForbiddenTime')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('Span') is not None:
            self.span = m.get('Span')
        if m.get('UuidList') is not None:
            self.uuid_list = m.get('UuidList')
        return self


class CreateAntiBruteForceRuleResponseBodyCreateAntiBruteForceRule(TeaModel):
    def __init__(
        self,
        rule_id: int = None,
    ):
        # The ID of the defense rule.
        self.rule_id = rule_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        return self


class CreateAntiBruteForceRuleResponseBody(TeaModel):
    def __init__(
        self,
        create_anti_brute_force_rule: CreateAntiBruteForceRuleResponseBodyCreateAntiBruteForceRule = None,
        request_id: str = None,
    ):
        # The information about the defense rule.
        self.create_anti_brute_force_rule = create_anti_brute_force_rule
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id

    def validate(self):
        if self.create_anti_brute_force_rule:
            self.create_anti_brute_force_rule.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_anti_brute_force_rule is not None:
            result['CreateAntiBruteForceRule'] = self.create_anti_brute_force_rule.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateAntiBruteForceRule') is not None:
            temp_model = CreateAntiBruteForceRuleResponseBodyCreateAntiBruteForceRule()
            self.create_anti_brute_force_rule = temp_model.from_map(m['CreateAntiBruteForceRule'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateAntiBruteForceRuleResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateAntiBruteForceRuleResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateAntiBruteForceRuleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateBackupPolicyRequest(TeaModel):
    def __init__(
        self,
        name: str = None,
        policy: Dict[str, Any] = None,
        policy_region_id: str = None,
        policy_version: str = None,
        uuid_list: List[str] = None,
    ):
        # The name of the anti-ransomware policy.
        self.name = name
        # *   **IsDefault**: the type of the anti-ransomware policy. Valid values:
        # 
        #     *   **1**: recommended policy
        #     *   **0**: custom policy
        # 
        # *   **Include**: the format of the files that you want to protect. If you want to protect the files in all formats, set this field to \[].
        # 
        # *   **Source**: the directory that you want to protect. If you want to protect all directories, set this field to \[].
        # 
        # *   **ExcludeSystemPath**: specifies whether to exclude a specific directory from the anti-ransomware policy. If you want to exclude a directory, set this field to **true**. If you do not want to exclude a directory, leave this field empty.
        # 
        # *   **Exclude**: the directory that you want to exclude from the anti-ransomware policy. If you do not want to exclude a directory, set this field to \[].
        # 
        # *   **Schedule**: the start time and interval of a data backup task. We recommend that you specify a start time that begins during off-peak hours but does not start on the hour. Examples:
        # 
        #     *   If you set this field to I|1583216092|P21D, the data backup task starts from 2020-03-03 14:14:52, and the task is run at an interval of three weeks.
        #     *   If you set this field to I|1583216092|PT24H, the data backup task starts from 2020-03-03 14:14:52, and the task is run at an interval of 24 hours.
        # 
        # *   **Retention**: the period during which backup data is retained. Unit: days. If you set this field to 7, backup data is retained for a week. If you set this field to 365, backup data is retained for a year. If you set this field to -1, backup data is permanently retained.
        # 
        # *   **SpeedLimiter**: the limit on the network bandwidth for data backup tasks. If you set this field to 0:24:30720, the maximum bandwidth for a data backup task is 30 MB/s from 00:00 to 24:00.
        # 
        # *   **UseVss**: specifies whether to enable the VSS feature. The feature is available only for Windows servers. Valid values:
        # 
        #     *   **true**: yes
        #     *   **false**: no
        # 
        # >  The VSS feature is available only if you create the anti-ransomware policy for Windows servers. After you enable the feature, the number of backup failures due to running processes is significantly reduced. We recommend that you enable the VSS feature. After you enable the feature, the data of disks that are in the exFAT and FAT32 formats cannot be backed up.
        self.policy = policy
        # The region ID of the server that is not deployed on Alibaba Cloud.
        # 
        # >  We recommend that you specify the ID of the supported region that is the nearest to the location of the server. You can call the [DescribeSupportRegion](~~DescribeSupportRegion~~) operation to query the supported regions of the anti-ransomware feature.
        self.policy_region_id = policy_region_id
        # The version of the anti-ransomware policy. Set the value to **2.0.0**.
        self.policy_version = policy_version
        # The UUIDs of the servers that you want to protect.
        self.uuid_list = uuid_list

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.policy is not None:
            result['Policy'] = self.policy
        if self.policy_region_id is not None:
            result['PolicyRegionId'] = self.policy_region_id
        if self.policy_version is not None:
            result['PolicyVersion'] = self.policy_version
        if self.uuid_list is not None:
            result['UuidList'] = self.uuid_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Policy') is not None:
            self.policy = m.get('Policy')
        if m.get('PolicyRegionId') is not None:
            self.policy_region_id = m.get('PolicyRegionId')
        if m.get('PolicyVersion') is not None:
            self.policy_version = m.get('PolicyVersion')
        if m.get('UuidList') is not None:
            self.uuid_list = m.get('UuidList')
        return self


class CreateBackupPolicyShrinkRequest(TeaModel):
    def __init__(
        self,
        name: str = None,
        policy_shrink: str = None,
        policy_region_id: str = None,
        policy_version: str = None,
        uuid_list: List[str] = None,
    ):
        # The name of the anti-ransomware policy.
        self.name = name
        # *   **IsDefault**: the type of the anti-ransomware policy. Valid values:
        # 
        #     *   **1**: recommended policy
        #     *   **0**: custom policy
        # 
        # *   **Include**: the format of the files that you want to protect. If you want to protect the files in all formats, set this field to \[].
        # 
        # *   **Source**: the directory that you want to protect. If you want to protect all directories, set this field to \[].
        # 
        # *   **ExcludeSystemPath**: specifies whether to exclude a specific directory from the anti-ransomware policy. If you want to exclude a directory, set this field to **true**. If you do not want to exclude a directory, leave this field empty.
        # 
        # *   **Exclude**: the directory that you want to exclude from the anti-ransomware policy. If you do not want to exclude a directory, set this field to \[].
        # 
        # *   **Schedule**: the start time and interval of a data backup task. We recommend that you specify a start time that begins during off-peak hours but does not start on the hour. Examples:
        # 
        #     *   If you set this field to I|1583216092|P21D, the data backup task starts from 2020-03-03 14:14:52, and the task is run at an interval of three weeks.
        #     *   If you set this field to I|1583216092|PT24H, the data backup task starts from 2020-03-03 14:14:52, and the task is run at an interval of 24 hours.
        # 
        # *   **Retention**: the period during which backup data is retained. Unit: days. If you set this field to 7, backup data is retained for a week. If you set this field to 365, backup data is retained for a year. If you set this field to -1, backup data is permanently retained.
        # 
        # *   **SpeedLimiter**: the limit on the network bandwidth for data backup tasks. If you set this field to 0:24:30720, the maximum bandwidth for a data backup task is 30 MB/s from 00:00 to 24:00.
        # 
        # *   **UseVss**: specifies whether to enable the VSS feature. The feature is available only for Windows servers. Valid values:
        # 
        #     *   **true**: yes
        #     *   **false**: no
        # 
        # >  The VSS feature is available only if you create the anti-ransomware policy for Windows servers. After you enable the feature, the number of backup failures due to running processes is significantly reduced. We recommend that you enable the VSS feature. After you enable the feature, the data of disks that are in the exFAT and FAT32 formats cannot be backed up.
        self.policy_shrink = policy_shrink
        # The region ID of the server that is not deployed on Alibaba Cloud.
        # 
        # >  We recommend that you specify the ID of the supported region that is the nearest to the location of the server. You can call the [DescribeSupportRegion](~~DescribeSupportRegion~~) operation to query the supported regions of the anti-ransomware feature.
        self.policy_region_id = policy_region_id
        # The version of the anti-ransomware policy. Set the value to **2.0.0**.
        self.policy_version = policy_version
        # The UUIDs of the servers that you want to protect.
        self.uuid_list = uuid_list

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.policy_shrink is not None:
            result['Policy'] = self.policy_shrink
        if self.policy_region_id is not None:
            result['PolicyRegionId'] = self.policy_region_id
        if self.policy_version is not None:
            result['PolicyVersion'] = self.policy_version
        if self.uuid_list is not None:
            result['UuidList'] = self.uuid_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Policy') is not None:
            self.policy_shrink = m.get('Policy')
        if m.get('PolicyRegionId') is not None:
            self.policy_region_id = m.get('PolicyRegionId')
        if m.get('PolicyVersion') is not None:
            self.policy_version = m.get('PolicyVersion')
        if m.get('UuidList') is not None:
            self.uuid_list = m.get('UuidList')
        return self


class CreateBackupPolicyResponseBodyBackupPolicy(TeaModel):
    def __init__(
        self,
        id: str = None,
        status: str = None,
    ):
        # The ID of the anti-ransomware policy.
        self.id = id
        # The status of the anti-ransomware policy. Valid values:
        # 
        # *   **enabled**\
        # *   **disabled**\
        # 
        # >  After you create an anti-ransomware policy, the policy is enabled by default.
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class CreateBackupPolicyResponseBody(TeaModel):
    def __init__(
        self,
        backup_policy: CreateBackupPolicyResponseBodyBackupPolicy = None,
        request_id: str = None,
    ):
        # The information about the anti-ransomware policy.
        self.backup_policy = backup_policy
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id

    def validate(self):
        if self.backup_policy:
            self.backup_policy.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.backup_policy is not None:
            result['BackupPolicy'] = self.backup_policy.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BackupPolicy') is not None:
            temp_model = CreateBackupPolicyResponseBodyBackupPolicy()
            self.backup_policy = temp_model.from_map(m['BackupPolicy'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateBackupPolicyResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateBackupPolicyResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateBackupPolicyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateContainerScanTaskRequest(TeaModel):
    def __init__(
        self,
        cluster_id: str = None,
        container_ids: str = None,
        lang: str = None,
    ):
        self.cluster_id = cluster_id
        self.container_ids = container_ids
        self.lang = lang

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.container_ids is not None:
            result['ContainerIds'] = self.container_ids
        if self.lang is not None:
            result['Lang'] = self.lang
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('ContainerIds') is not None:
            self.container_ids = m.get('ContainerIds')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        return self


class CreateContainerScanTaskResponseBodyData(TeaModel):
    def __init__(
        self,
        can_create: bool = None,
        collect_time: int = None,
        exec_time: int = None,
        finish_count: int = None,
        progress: int = None,
        result: str = None,
        status: str = None,
        task_id: str = None,
        total_count: int = None,
    ):
        self.can_create = can_create
        self.collect_time = collect_time
        self.exec_time = exec_time
        self.finish_count = finish_count
        self.progress = progress
        self.result = result
        self.status = status
        self.task_id = task_id
        self.total_count = total_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.can_create is not None:
            result['CanCreate'] = self.can_create
        if self.collect_time is not None:
            result['CollectTime'] = self.collect_time
        if self.exec_time is not None:
            result['ExecTime'] = self.exec_time
        if self.finish_count is not None:
            result['FinishCount'] = self.finish_count
        if self.progress is not None:
            result['Progress'] = self.progress
        if self.result is not None:
            result['Result'] = self.result
        if self.status is not None:
            result['Status'] = self.status
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CanCreate') is not None:
            self.can_create = m.get('CanCreate')
        if m.get('CollectTime') is not None:
            self.collect_time = m.get('CollectTime')
        if m.get('ExecTime') is not None:
            self.exec_time = m.get('ExecTime')
        if m.get('FinishCount') is not None:
            self.finish_count = m.get('FinishCount')
        if m.get('Progress') is not None:
            self.progress = m.get('Progress')
        if m.get('Result') is not None:
            self.result = m.get('Result')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class CreateContainerScanTaskResponseBody(TeaModel):
    def __init__(
        self,
        data: CreateContainerScanTaskResponseBodyData = None,
        http_status_code: int = None,
        request_id: str = None,
    ):
        self.data = data
        self.http_status_code = http_status_code
        self.request_id = request_id

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = CreateContainerScanTaskResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateContainerScanTaskResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateContainerScanTaskResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateContainerScanTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateCustomBlockRecordRequest(TeaModel):
    def __init__(
        self,
        block_ip: str = None,
        bound: str = None,
        expire_time: int = None,
        resource_owner_id: int = None,
        uuids: str = None,
    ):
        self.block_ip = block_ip
        self.bound = bound
        self.expire_time = expire_time
        self.resource_owner_id = resource_owner_id
        self.uuids = uuids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.block_ip is not None:
            result['BlockIp'] = self.block_ip
        if self.bound is not None:
            result['Bound'] = self.bound
        if self.expire_time is not None:
            result['ExpireTime'] = self.expire_time
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.uuids is not None:
            result['Uuids'] = self.uuids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BlockIp') is not None:
            self.block_ip = m.get('BlockIp')
        if m.get('Bound') is not None:
            self.bound = m.get('Bound')
        if m.get('ExpireTime') is not None:
            self.expire_time = m.get('ExpireTime')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('Uuids') is not None:
            self.uuids = m.get('Uuids')
        return self


class CreateCustomBlockRecordResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateCustomBlockRecordResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateCustomBlockRecordResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateCustomBlockRecordResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateCycleTaskRequest(TeaModel):
    def __init__(
        self,
        enable: int = None,
        first_date_str: int = None,
        interval_period: int = None,
        param: str = None,
        period_unit: str = None,
        source: str = None,
        target_end_time: int = None,
        target_start_time: int = None,
        task_name: str = None,
        task_type: str = None,
    ):
        self.enable = enable
        self.first_date_str = first_date_str
        self.interval_period = interval_period
        self.param = param
        self.period_unit = period_unit
        self.source = source
        self.target_end_time = target_end_time
        self.target_start_time = target_start_time
        self.task_name = task_name
        self.task_type = task_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.enable is not None:
            result['Enable'] = self.enable
        if self.first_date_str is not None:
            result['FirstDateStr'] = self.first_date_str
        if self.interval_period is not None:
            result['IntervalPeriod'] = self.interval_period
        if self.param is not None:
            result['Param'] = self.param
        if self.period_unit is not None:
            result['PeriodUnit'] = self.period_unit
        if self.source is not None:
            result['Source'] = self.source
        if self.target_end_time is not None:
            result['TargetEndTime'] = self.target_end_time
        if self.target_start_time is not None:
            result['TargetStartTime'] = self.target_start_time
        if self.task_name is not None:
            result['TaskName'] = self.task_name
        if self.task_type is not None:
            result['TaskType'] = self.task_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Enable') is not None:
            self.enable = m.get('Enable')
        if m.get('FirstDateStr') is not None:
            self.first_date_str = m.get('FirstDateStr')
        if m.get('IntervalPeriod') is not None:
            self.interval_period = m.get('IntervalPeriod')
        if m.get('Param') is not None:
            self.param = m.get('Param')
        if m.get('PeriodUnit') is not None:
            self.period_unit = m.get('PeriodUnit')
        if m.get('Source') is not None:
            self.source = m.get('Source')
        if m.get('TargetEndTime') is not None:
            self.target_end_time = m.get('TargetEndTime')
        if m.get('TargetStartTime') is not None:
            self.target_start_time = m.get('TargetStartTime')
        if m.get('TaskName') is not None:
            self.task_name = m.get('TaskName')
        if m.get('TaskType') is not None:
            self.task_type = m.get('TaskType')
        return self


class CreateCycleTaskResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateCycleTaskResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateCycleTaskResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateCycleTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateFileDetectRequest(TeaModel):
    def __init__(
        self,
        hash_key: str = None,
        oss_key: str = None,
        source_ip: str = None,
        type: int = None,
    ):
        # The identifier of the file. Only MD5 hash values are supported.
        self.hash_key = hash_key
        # The key of the file that is stored in the Object Storage Service (OSS) bucket. You can call the [CreateFileDetectUploadUrl](~~CreateFileDetectUploadUrl~~) operation to query the keys of files.
        self.oss_key = oss_key
        # The source IP address of the request.
        self.source_ip = source_ip
        # The type of the file. Valid values:
        # 
        # *   **0**: unknown files
        # *   **1**: binary files
        # *   **2**: webshell files
        # *   **4**: script files
        # 
        # >  If you do not know the type of the file, set this parameter to 0.
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.hash_key is not None:
            result['HashKey'] = self.hash_key
        if self.oss_key is not None:
            result['OssKey'] = self.oss_key
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HashKey') is not None:
            self.hash_key = m.get('HashKey')
        if m.get('OssKey') is not None:
            self.oss_key = m.get('OssKey')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class CreateFileDetectResponseBody(TeaModel):
    def __init__(
        self,
        hash_key: str = None,
        request_id: str = None,
    ):
        # The identifier of the file.
        self.hash_key = hash_key
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.hash_key is not None:
            result['HashKey'] = self.hash_key
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HashKey') is not None:
            self.hash_key = m.get('HashKey')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateFileDetectResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateFileDetectResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateFileDetectResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateFileDetectUploadUrlRequestHashKeyContextList(TeaModel):
    def __init__(
        self,
        file_size: int = None,
        hash_key: str = None,
    ):
        # The size of the file. Unit: bytes.
        self.file_size = file_size
        # The hash value of the file.
        self.hash_key = hash_key

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.file_size is not None:
            result['FileSize'] = self.file_size
        if self.hash_key is not None:
            result['HashKey'] = self.hash_key
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FileSize') is not None:
            self.file_size = m.get('FileSize')
        if m.get('HashKey') is not None:
            self.hash_key = m.get('HashKey')
        return self


class CreateFileDetectUploadUrlRequest(TeaModel):
    def __init__(
        self,
        hash_key_context_list: List[CreateFileDetectUploadUrlRequestHashKeyContextList] = None,
        hash_key_list: List[str] = None,
        type: int = None,
    ):
        # The hash values of files.
        # 
        # >  You must specify at least one of the **HashKeyList** and **HashKeyContextList** parameters.
        self.hash_key_context_list = hash_key_context_list
        # The identifier of the file. Only MD5 hash values are supported.
        # 
        # >  You must specify at least one of the **HashKeyList** and **HashKeyContextList** parameters.
        self.hash_key_list = hash_key_list
        # The type of the file. Valid values:
        # 
        # *   **0**: unknown files
        # *   **1**: binary files
        # *   **2**: webshell files
        # *   **4**: script files
        # 
        # >  If you do not know the type of the file, set this parameter to **0**.
        self.type = type

    def validate(self):
        if self.hash_key_context_list:
            for k in self.hash_key_context_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['HashKeyContextList'] = []
        if self.hash_key_context_list is not None:
            for k in self.hash_key_context_list:
                result['HashKeyContextList'].append(k.to_map() if k else None)
        if self.hash_key_list is not None:
            result['HashKeyList'] = self.hash_key_list
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.hash_key_context_list = []
        if m.get('HashKeyContextList') is not None:
            for k in m.get('HashKeyContextList'):
                temp_model = CreateFileDetectUploadUrlRequestHashKeyContextList()
                self.hash_key_context_list.append(temp_model.from_map(k))
        if m.get('HashKeyList') is not None:
            self.hash_key_list = m.get('HashKeyList')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class CreateFileDetectUploadUrlResponseBodyUploadUrlListContext(TeaModel):
    def __init__(
        self,
        access_id: str = None,
        oss_key: str = None,
        policy: str = None,
        signature: str = None,
    ):
        # The AccessKey ID that is used to access the OSS bucket.
        self.access_id = access_id
        # The key of the file that is used after the file is uploaded to the OSS bucket.
        self.oss_key = oss_key
        # The policy that poses limits on file upload. For example, the policy limits the size of the file.
        self.policy = policy
        # The signature that is used to upload the file.
        self.signature = signature

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.access_id is not None:
            result['AccessId'] = self.access_id
        if self.oss_key is not None:
            result['OssKey'] = self.oss_key
        if self.policy is not None:
            result['Policy'] = self.policy
        if self.signature is not None:
            result['Signature'] = self.signature
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccessId') is not None:
            self.access_id = m.get('AccessId')
        if m.get('OssKey') is not None:
            self.oss_key = m.get('OssKey')
        if m.get('Policy') is not None:
            self.policy = m.get('Policy')
        if m.get('Signature') is not None:
            self.signature = m.get('Signature')
        return self


class CreateFileDetectUploadUrlResponseBodyUploadUrlList(TeaModel):
    def __init__(
        self,
        code: str = None,
        context: CreateFileDetectUploadUrlResponseBodyUploadUrlListContext = None,
        expire: str = None,
        file_exist: bool = None,
        hash_key: str = None,
        internal_url: str = None,
        message: str = None,
        public_url: str = None,
    ):
        # The status code returned. The status code **200** indicates that the request was successful. Other status codes indicate that the request failed. You can identify the cause of the failure based on the status code.
        self.code = code
        # The signature information.
        self.context = context
        # The timestamp when the values of the parameters expire. Unit: milliseconds.
        self.expire = expire
        # Indicates whether the file exists in the cloud. Valid values:
        # 
        # *   **true**: The file exists in the cloud. You do not need to upload the file.
        # *   **false**: The file does not exist in the cloud. You must upload the file.
        self.file_exist = file_exist
        # The identifier of the file.
        self.hash_key = hash_key
        # The internal endpoint of the URL to which the file is uploaded.
        self.internal_url = internal_url
        # The error message returned.
        self.message = message
        # The public endpoint of the URL to which the file is uploaded.
        self.public_url = public_url

    def validate(self):
        if self.context:
            self.context.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.context is not None:
            result['Context'] = self.context.to_map()
        if self.expire is not None:
            result['Expire'] = self.expire
        if self.file_exist is not None:
            result['FileExist'] = self.file_exist
        if self.hash_key is not None:
            result['HashKey'] = self.hash_key
        if self.internal_url is not None:
            result['InternalUrl'] = self.internal_url
        if self.message is not None:
            result['Message'] = self.message
        if self.public_url is not None:
            result['PublicUrl'] = self.public_url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Context') is not None:
            temp_model = CreateFileDetectUploadUrlResponseBodyUploadUrlListContext()
            self.context = temp_model.from_map(m['Context'])
        if m.get('Expire') is not None:
            self.expire = m.get('Expire')
        if m.get('FileExist') is not None:
            self.file_exist = m.get('FileExist')
        if m.get('HashKey') is not None:
            self.hash_key = m.get('HashKey')
        if m.get('InternalUrl') is not None:
            self.internal_url = m.get('InternalUrl')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('PublicUrl') is not None:
            self.public_url = m.get('PublicUrl')
        return self


class CreateFileDetectUploadUrlResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        upload_url_list: List[CreateFileDetectUploadUrlResponseBodyUploadUrlList] = None,
    ):
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id
        # An array consisting of the parameters that are required to upload a file.
        self.upload_url_list = upload_url_list

    def validate(self):
        if self.upload_url_list:
            for k in self.upload_url_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['UploadUrlList'] = []
        if self.upload_url_list is not None:
            for k in self.upload_url_list:
                result['UploadUrlList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.upload_url_list = []
        if m.get('UploadUrlList') is not None:
            for k in m.get('UploadUrlList'):
                temp_model = CreateFileDetectUploadUrlResponseBodyUploadUrlList()
                self.upload_url_list.append(temp_model.from_map(k))
        return self


class CreateFileDetectUploadUrlResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateFileDetectUploadUrlResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateFileDetectUploadUrlResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateHoneypotRequest(TeaModel):
    def __init__(
        self,
        honeypot_image_id: str = None,
        honeypot_image_name: str = None,
        honeypot_name: str = None,
        meta: str = None,
        node_id: str = None,
    ):
        # The ID of the image that is used for the honeypot.
        # 
        # >  You can call the [ListAvailableHoneypot](~~ListAvailableHoneypot~~) operation to obtain the IDs of images from the **HoneypotImageId** response parameter.
        self.honeypot_image_id = honeypot_image_id
        # The name of the image that is used for the honeypot.
        # 
        # >  You can call the [ListAvailableHoneypot](~~ListAvailableHoneypot~~) operation to obtain the names of images from the **HoneypotImageName** response parameter.
        self.honeypot_image_name = honeypot_image_name
        # The custom name of the honeypot.
        self.honeypot_name = honeypot_name
        # The custom configuration of the honeypot in the JSON format. The value contains the following fields:
        # 
        # *   **trojan_git**: Git-specific Defense. Valid values:
        # 
        #     *   **zip**: Git Source Code Package
        #     *   **web**: Git Directory Leak
        #     *   **close**: Disabled
        # 
        # *   **trojan\_git_addr**: Git Trojan Address.
        # 
        # *   **trojan_git.zip**: Git Trojan.
        # 
        # *   **burp**: Burp-specific Defense. Valid values:
        # 
        #     *   **open**: Enabled
        #     *   **close**: Disabled
        # 
        # *   **portrait_option**: Source Tracing Configuration. Valid values:
        # 
        #     *   **false**: Disable
        #     *   **true**: Enable
        self.meta = meta
        # The ID of the management node to which you want to deploy the honeypot.
        # 
        # >  You can call the [ListHoneypotNode](~~ListHoneypotNode~~) operation to obtain the IDs of management nodes.
        self.node_id = node_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.honeypot_image_id is not None:
            result['HoneypotImageId'] = self.honeypot_image_id
        if self.honeypot_image_name is not None:
            result['HoneypotImageName'] = self.honeypot_image_name
        if self.honeypot_name is not None:
            result['HoneypotName'] = self.honeypot_name
        if self.meta is not None:
            result['Meta'] = self.meta
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HoneypotImageId') is not None:
            self.honeypot_image_id = m.get('HoneypotImageId')
        if m.get('HoneypotImageName') is not None:
            self.honeypot_image_name = m.get('HoneypotImageName')
        if m.get('HoneypotName') is not None:
            self.honeypot_name = m.get('HoneypotName')
        if m.get('Meta') is not None:
            self.meta = m.get('Meta')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        return self


class CreateHoneypotResponseBodyData(TeaModel):
    def __init__(
        self,
        control_node_name: str = None,
        honeypot_id: str = None,
        honeypot_image_display_name: str = None,
        honeypot_image_name: str = None,
        honeypot_name: str = None,
        node_id: str = None,
        preset_id: str = None,
        state: List[str] = None,
    ):
        # The name of the management node to which the honeypot is deployed.
        self.control_node_name = control_node_name
        # The ID of the honeypot.
        self.honeypot_id = honeypot_id
        # The display name of the image that is used for the honeypot.
        self.honeypot_image_display_name = honeypot_image_display_name
        # The name of the image that is used for the honeypot.
        self.honeypot_image_name = honeypot_image_name
        # The custom name of the honeypot.
        self.honeypot_name = honeypot_name
        # The ID of the management node.
        self.node_id = node_id
        # The ID of the custom configuration for the honeypot.
        self.preset_id = preset_id
        # The status of the honeypot.
        self.state = state

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.control_node_name is not None:
            result['ControlNodeName'] = self.control_node_name
        if self.honeypot_id is not None:
            result['HoneypotId'] = self.honeypot_id
        if self.honeypot_image_display_name is not None:
            result['HoneypotImageDisplayName'] = self.honeypot_image_display_name
        if self.honeypot_image_name is not None:
            result['HoneypotImageName'] = self.honeypot_image_name
        if self.honeypot_name is not None:
            result['HoneypotName'] = self.honeypot_name
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.preset_id is not None:
            result['PresetId'] = self.preset_id
        if self.state is not None:
            result['State'] = self.state
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ControlNodeName') is not None:
            self.control_node_name = m.get('ControlNodeName')
        if m.get('HoneypotId') is not None:
            self.honeypot_id = m.get('HoneypotId')
        if m.get('HoneypotImageDisplayName') is not None:
            self.honeypot_image_display_name = m.get('HoneypotImageDisplayName')
        if m.get('HoneypotImageName') is not None:
            self.honeypot_image_name = m.get('HoneypotImageName')
        if m.get('HoneypotName') is not None:
            self.honeypot_name = m.get('HoneypotName')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('PresetId') is not None:
            self.preset_id = m.get('PresetId')
        if m.get('State') is not None:
            self.state = m.get('State')
        return self


class CreateHoneypotResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        data: CreateHoneypotResponseBodyData = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The status code returned. The status code **200** indicates that the request was is successful. Other status codes indicate that the request failed. You can identify the cause of the failure based on the status code.
        self.code = code
        # The information about the honeypot.
        self.data = data
        # The HTTP status code returned.
        self.http_status_code = http_status_code
        # The error message returned.
        self.message = message
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   **true**: The request was successful.
        # *   **false**: The request failed.
        self.success = success

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Data') is not None:
            temp_model = CreateHoneypotResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateHoneypotResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateHoneypotResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateHoneypotResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateHoneypotNodeRequest(TeaModel):
    def __init__(
        self,
        allow_honeypot_access_internet: bool = None,
        available_probe_num: int = None,
        node_name: str = None,
        security_group_probe_ip_list: List[str] = None,
    ):
        # Specifies whether to allow the honeypots to access the Internet. Valid values:
        # 
        # *   **true**: allows the honeypots to access the Internet.
        # *   **false**: does not allow the honeypots to access the Internet.
        self.allow_honeypot_access_internet = allow_honeypot_access_internet
        # The number of probes that you want to allocate for the management node.
        self.available_probe_num = available_probe_num
        # The name of the management node.
        self.node_name = node_name
        # The CIDR blocks that are allowed to access the management node.
        self.security_group_probe_ip_list = security_group_probe_ip_list

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.allow_honeypot_access_internet is not None:
            result['AllowHoneypotAccessInternet'] = self.allow_honeypot_access_internet
        if self.available_probe_num is not None:
            result['AvailableProbeNum'] = self.available_probe_num
        if self.node_name is not None:
            result['NodeName'] = self.node_name
        if self.security_group_probe_ip_list is not None:
            result['SecurityGroupProbeIpList'] = self.security_group_probe_ip_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AllowHoneypotAccessInternet') is not None:
            self.allow_honeypot_access_internet = m.get('AllowHoneypotAccessInternet')
        if m.get('AvailableProbeNum') is not None:
            self.available_probe_num = m.get('AvailableProbeNum')
        if m.get('NodeName') is not None:
            self.node_name = m.get('NodeName')
        if m.get('SecurityGroupProbeIpList') is not None:
            self.security_group_probe_ip_list = m.get('SecurityGroupProbeIpList')
        return self


class CreateHoneypotNodeResponseBodyHoneypotNode(TeaModel):
    def __init__(
        self,
        node_id: str = None,
    ):
        self.node_id = node_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        return self


class CreateHoneypotNodeResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        honeypot_node: CreateHoneypotNodeResponseBodyHoneypotNode = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The status code returned. The status code **200** indicates that the request was successful. Other status codes indicate that the request failed. You can identify the cause of the failure based on the status code.
        self.code = code
        self.honeypot_node = honeypot_node
        # The HTTP status code returned.
        self.http_status_code = http_status_code
        # The error message returned.
        self.message = message
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   **true**: The request was successful.
        # *   **false**: The request failed.
        self.success = success

    def validate(self):
        if self.honeypot_node:
            self.honeypot_node.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.honeypot_node is not None:
            result['HoneypotNode'] = self.honeypot_node.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HoneypotNode') is not None:
            temp_model = CreateHoneypotNodeResponseBodyHoneypotNode()
            self.honeypot_node = temp_model.from_map(m['HoneypotNode'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateHoneypotNodeResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateHoneypotNodeResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateHoneypotNodeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateHoneypotPresetRequest(TeaModel):
    def __init__(
        self,
        honeypot_image_name: str = None,
        meta: str = None,
        node_id: str = None,
        preset_name: str = None,
    ):
        self.honeypot_image_name = honeypot_image_name
        self.meta = meta
        self.node_id = node_id
        self.preset_name = preset_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.honeypot_image_name is not None:
            result['HoneypotImageName'] = self.honeypot_image_name
        if self.meta is not None:
            result['Meta'] = self.meta
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        if self.preset_name is not None:
            result['PresetName'] = self.preset_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HoneypotImageName') is not None:
            self.honeypot_image_name = m.get('HoneypotImageName')
        if m.get('Meta') is not None:
            self.meta = m.get('Meta')
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        if m.get('PresetName') is not None:
            self.preset_name = m.get('PresetName')
        return self


class CreateHoneypotPresetResponseBodyHoneypotPreset(TeaModel):
    def __init__(
        self,
        honeypot_preset_id: str = None,
    ):
        self.honeypot_preset_id = honeypot_preset_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.honeypot_preset_id is not None:
            result['HoneypotPresetId'] = self.honeypot_preset_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HoneypotPresetId') is not None:
            self.honeypot_preset_id = m.get('HoneypotPresetId')
        return self


class CreateHoneypotPresetResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        honeypot_preset: CreateHoneypotPresetResponseBodyHoneypotPreset = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.honeypot_preset = honeypot_preset
        self.http_status_code = http_status_code
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.honeypot_preset:
            self.honeypot_preset.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.honeypot_preset is not None:
            result['HoneypotPreset'] = self.honeypot_preset.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HoneypotPreset') is not None:
            temp_model = CreateHoneypotPresetResponseBodyHoneypotPreset()
            self.honeypot_preset = temp_model.from_map(m['HoneypotPreset'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateHoneypotPresetResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateHoneypotPresetResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateHoneypotPresetResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateHoneypotProbeRequestHoneypotBindListBindPortList(TeaModel):
    def __init__(
        self,
        bind_port: bool = None,
        end_port: int = None,
        fixed: bool = None,
        start_port: int = None,
        target_port: int = None,
    ):
        # Specifies whether to bind a port. Valid values:
        # 
        # *   **true**: yes
        # *   **false**: no
        self.bind_port = bind_port
        # The end of the port range.
        self.end_port = end_port
        # Specifies whether the port is fixed. Valid values:
        # 
        # *   **0**: no
        # *   **1**: yes
        self.fixed = fixed
        # The start of the port range.
        self.start_port = start_port
        # The destination port.
        # 
        # >  If **HoneypotId** is specified, this parameter is required.
        self.target_port = target_port

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bind_port is not None:
            result['BindPort'] = self.bind_port
        if self.end_port is not None:
            result['EndPort'] = self.end_port
        if self.fixed is not None:
            result['Fixed'] = self.fixed
        if self.start_port is not None:
            result['StartPort'] = self.start_port
        if self.target_port is not None:
            result['TargetPort'] = self.target_port
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BindPort') is not None:
            self.bind_port = m.get('BindPort')
        if m.get('EndPort') is not None:
            self.end_port = m.get('EndPort')
        if m.get('Fixed') is not None:
            self.fixed = m.get('Fixed')
        if m.get('StartPort') is not None:
            self.start_port = m.get('StartPort')
        if m.get('TargetPort') is not None:
            self.target_port = m.get('TargetPort')
        return self


class CreateHoneypotProbeRequestHoneypotBindList(TeaModel):
    def __init__(
        self,
        bind_port_list: List[CreateHoneypotProbeRequestHoneypotBindListBindPortList] = None,
        honeypot_id: str = None,
    ):
        # The listener ports.
        self.bind_port_list = bind_port_list
        # The ID of the honeypot.
        # 
        # >  You can call the [ListHoneypot](~~ListHoneypot~~) operation to query the IDs of honeypots.
        self.honeypot_id = honeypot_id

    def validate(self):
        if self.bind_port_list:
            for k in self.bind_port_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['BindPortList'] = []
        if self.bind_port_list is not None:
            for k in self.bind_port_list:
                result['BindPortList'].append(k.to_map() if k else None)
        if self.honeypot_id is not None:
            result['HoneypotId'] = self.honeypot_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.bind_port_list = []
        if m.get('BindPortList') is not None:
            for k in m.get('BindPortList'):
                temp_model = CreateHoneypotProbeRequestHoneypotBindListBindPortList()
                self.bind_port_list.append(temp_model.from_map(k))
        if m.get('HoneypotId') is not None:
            self.honeypot_id = m.get('HoneypotId')
        return self


class CreateHoneypotProbeRequest(TeaModel):
    def __init__(
        self,
        arp: bool = None,
        business_group_id: str = None,
        control_node_id: str = None,
        display_name: str = None,
        honeypot_bind_list: List[CreateHoneypotProbeRequestHoneypotBindList] = None,
        ping: bool = None,
        probe_type: str = None,
        probe_version: str = None,
        proxy_ip: str = None,
        uuid: str = None,
        vpc_id: str = None,
    ):
        # Specifies whether to enable Address Resolution Protocol (ARP) spoofing. Valid values:
        # 
        # *   **true**: yes
        # *   **false**: no
        self.arp = arp
        # The ID of the business group.
        self.business_group_id = business_group_id
        # The ID of the management node.
        # 
        # >  You can call the [ListHoneypotNode](~~ListHoneypotNode~~) operation to query the IDs of management nodes.
        self.control_node_id = control_node_id
        # The name of the probe.
        self.display_name = display_name
        # The honeypot configurations.
        self.honeypot_bind_list = honeypot_bind_list
        # Specifies whether to enable ping scan. Valid values:
        # 
        # *   **false**: yes
        # *   **false**: no
        self.ping = ping
        # The type of the probe. Valid values:
        # 
        # *   **host_probe**: host probe
        # *   **vpc_black_hole_probe**: virtual private cloud (VPC) probe
        self.probe_type = probe_type
        # The version of the probe.
        self.probe_version = probe_version
        # The IP address of the proxy.
        self.proxy_ip = proxy_ip
        # The UUID of the instance.
        # 
        # >  If **ProbeType** is set to **host_probe**, this parameter is required.
        self.uuid = uuid
        # The ID of the VPC.
        # 
        # >  If **ProbeType** is set to **vpc_black_hole_probe**, this parameter is required. You can call the DescribeVpcHoneyPotList operation to query the IDs of VPCs.
        self.vpc_id = vpc_id

    def validate(self):
        if self.honeypot_bind_list:
            for k in self.honeypot_bind_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.arp is not None:
            result['Arp'] = self.arp
        if self.business_group_id is not None:
            result['BusinessGroupId'] = self.business_group_id
        if self.control_node_id is not None:
            result['ControlNodeId'] = self.control_node_id
        if self.display_name is not None:
            result['DisplayName'] = self.display_name
        result['HoneypotBindList'] = []
        if self.honeypot_bind_list is not None:
            for k in self.honeypot_bind_list:
                result['HoneypotBindList'].append(k.to_map() if k else None)
        if self.ping is not None:
            result['Ping'] = self.ping
        if self.probe_type is not None:
            result['ProbeType'] = self.probe_type
        if self.probe_version is not None:
            result['ProbeVersion'] = self.probe_version
        if self.proxy_ip is not None:
            result['ProxyIp'] = self.proxy_ip
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Arp') is not None:
            self.arp = m.get('Arp')
        if m.get('BusinessGroupId') is not None:
            self.business_group_id = m.get('BusinessGroupId')
        if m.get('ControlNodeId') is not None:
            self.control_node_id = m.get('ControlNodeId')
        if m.get('DisplayName') is not None:
            self.display_name = m.get('DisplayName')
        self.honeypot_bind_list = []
        if m.get('HoneypotBindList') is not None:
            for k in m.get('HoneypotBindList'):
                temp_model = CreateHoneypotProbeRequestHoneypotBindList()
                self.honeypot_bind_list.append(temp_model.from_map(k))
        if m.get('Ping') is not None:
            self.ping = m.get('Ping')
        if m.get('ProbeType') is not None:
            self.probe_type = m.get('ProbeType')
        if m.get('ProbeVersion') is not None:
            self.probe_version = m.get('ProbeVersion')
        if m.get('ProxyIp') is not None:
            self.proxy_ip = m.get('ProxyIp')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        return self


class CreateHoneypotProbeResponseBodyHoneypotProbe(TeaModel):
    def __init__(
        self,
        probe_id: str = None,
    ):
        self.probe_id = probe_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.probe_id is not None:
            result['ProbeId'] = self.probe_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProbeId') is not None:
            self.probe_id = m.get('ProbeId')
        return self


class CreateHoneypotProbeResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        honeypot_probe: CreateHoneypotProbeResponseBodyHoneypotProbe = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The status code returned. The status code **200** indicates that the request was successful. Other status codes indicate that the request failed. You can identify the cause of the failure based on the status code.
        self.code = code
        self.honeypot_probe = honeypot_probe
        # The HTTP status code returned.
        self.http_status_code = http_status_code
        # The error message returned.
        self.message = message
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   **true**: The request was successful.
        # *   **false**: The request failed.
        self.success = success

    def validate(self):
        if self.honeypot_probe:
            self.honeypot_probe.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.honeypot_probe is not None:
            result['HoneypotProbe'] = self.honeypot_probe.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HoneypotProbe') is not None:
            temp_model = CreateHoneypotProbeResponseBodyHoneypotProbe()
            self.honeypot_probe = temp_model.from_map(m['HoneypotProbe'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateHoneypotProbeResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateHoneypotProbeResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateHoneypotProbeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateJenkinsImageRegistryRequest(TeaModel):
    def __init__(
        self,
        domain_name: str = None,
        extra_param: str = None,
        net_type: int = None,
        password: str = None,
        persistence_day: int = None,
        protocol_type: int = None,
        region_id: str = None,
        registry_host_ip: str = None,
        registry_name: str = None,
        registry_type: str = None,
        registry_version: str = None,
        source_ip: str = None,
        trans_per_hour: int = None,
        user_name: str = None,
        vpc_id: str = None,
        white_list: str = None,
    ):
        self.domain_name = domain_name
        self.extra_param = extra_param
        self.net_type = net_type
        self.password = password
        self.persistence_day = persistence_day
        self.protocol_type = protocol_type
        self.region_id = region_id
        self.registry_host_ip = registry_host_ip
        self.registry_name = registry_name
        self.registry_type = registry_type
        self.registry_version = registry_version
        self.source_ip = source_ip
        self.trans_per_hour = trans_per_hour
        self.user_name = user_name
        self.vpc_id = vpc_id
        self.white_list = white_list

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.extra_param is not None:
            result['ExtraParam'] = self.extra_param
        if self.net_type is not None:
            result['NetType'] = self.net_type
        if self.password is not None:
            result['Password'] = self.password
        if self.persistence_day is not None:
            result['PersistenceDay'] = self.persistence_day
        if self.protocol_type is not None:
            result['ProtocolType'] = self.protocol_type
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.registry_host_ip is not None:
            result['RegistryHostIp'] = self.registry_host_ip
        if self.registry_name is not None:
            result['RegistryName'] = self.registry_name
        if self.registry_type is not None:
            result['RegistryType'] = self.registry_type
        if self.registry_version is not None:
            result['RegistryVersion'] = self.registry_version
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.trans_per_hour is not None:
            result['TransPerHour'] = self.trans_per_hour
        if self.user_name is not None:
            result['UserName'] = self.user_name
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        if self.white_list is not None:
            result['WhiteList'] = self.white_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('ExtraParam') is not None:
            self.extra_param = m.get('ExtraParam')
        if m.get('NetType') is not None:
            self.net_type = m.get('NetType')
        if m.get('Password') is not None:
            self.password = m.get('Password')
        if m.get('PersistenceDay') is not None:
            self.persistence_day = m.get('PersistenceDay')
        if m.get('ProtocolType') is not None:
            self.protocol_type = m.get('ProtocolType')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('RegistryHostIp') is not None:
            self.registry_host_ip = m.get('RegistryHostIp')
        if m.get('RegistryName') is not None:
            self.registry_name = m.get('RegistryName')
        if m.get('RegistryType') is not None:
            self.registry_type = m.get('RegistryType')
        if m.get('RegistryVersion') is not None:
            self.registry_version = m.get('RegistryVersion')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('TransPerHour') is not None:
            self.trans_per_hour = m.get('TransPerHour')
        if m.get('UserName') is not None:
            self.user_name = m.get('UserName')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        if m.get('WhiteList') is not None:
            self.white_list = m.get('WhiteList')
        return self


class CreateJenkinsImageRegistryResponseBodyData(TeaModel):
    def __init__(
        self,
        black_list: str = None,
        domain_name: str = None,
        gmt_create: str = None,
        gmt_modified: str = None,
        id: int = None,
        net_type: int = None,
        password: str = None,
        persistence_day: int = None,
        protocol_type: int = None,
        region_id: str = None,
        registry_host_ip: str = None,
        registry_name: str = None,
        registry_type: str = None,
        token: str = None,
        trans_per_hour: int = None,
        user_name: str = None,
        vpc_id: str = None,
        white_list: str = None,
    ):
        self.black_list = black_list
        self.domain_name = domain_name
        self.gmt_create = gmt_create
        self.gmt_modified = gmt_modified
        self.id = id
        self.net_type = net_type
        self.password = password
        self.persistence_day = persistence_day
        self.protocol_type = protocol_type
        self.region_id = region_id
        self.registry_host_ip = registry_host_ip
        self.registry_name = registry_name
        self.registry_type = registry_type
        self.token = token
        self.trans_per_hour = trans_per_hour
        self.user_name = user_name
        self.vpc_id = vpc_id
        self.white_list = white_list

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.black_list is not None:
            result['BlackList'] = self.black_list
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.id is not None:
            result['Id'] = self.id
        if self.net_type is not None:
            result['NetType'] = self.net_type
        if self.password is not None:
            result['Password'] = self.password
        if self.persistence_day is not None:
            result['PersistenceDay'] = self.persistence_day
        if self.protocol_type is not None:
            result['ProtocolType'] = self.protocol_type
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.registry_host_ip is not None:
            result['RegistryHostIp'] = self.registry_host_ip
        if self.registry_name is not None:
            result['RegistryName'] = self.registry_name
        if self.registry_type is not None:
            result['RegistryType'] = self.registry_type
        if self.token is not None:
            result['Token'] = self.token
        if self.trans_per_hour is not None:
            result['TransPerHour'] = self.trans_per_hour
        if self.user_name is not None:
            result['UserName'] = self.user_name
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        if self.white_list is not None:
            result['WhiteList'] = self.white_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BlackList') is not None:
            self.black_list = m.get('BlackList')
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('NetType') is not None:
            self.net_type = m.get('NetType')
        if m.get('Password') is not None:
            self.password = m.get('Password')
        if m.get('PersistenceDay') is not None:
            self.persistence_day = m.get('PersistenceDay')
        if m.get('ProtocolType') is not None:
            self.protocol_type = m.get('ProtocolType')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('RegistryHostIp') is not None:
            self.registry_host_ip = m.get('RegistryHostIp')
        if m.get('RegistryName') is not None:
            self.registry_name = m.get('RegistryName')
        if m.get('RegistryType') is not None:
            self.registry_type = m.get('RegistryType')
        if m.get('Token') is not None:
            self.token = m.get('Token')
        if m.get('TransPerHour') is not None:
            self.trans_per_hour = m.get('TransPerHour')
        if m.get('UserName') is not None:
            self.user_name = m.get('UserName')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        if m.get('WhiteList') is not None:
            self.white_list = m.get('WhiteList')
        return self


class CreateJenkinsImageRegistryResponseBody(TeaModel):
    def __init__(
        self,
        data: CreateJenkinsImageRegistryResponseBodyData = None,
        http_status_code: int = None,
        request_id: str = None,
        time_cost: int = None,
    ):
        self.data = data
        self.http_status_code = http_status_code
        self.request_id = request_id
        self.time_cost = time_cost

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.time_cost is not None:
            result['TimeCost'] = self.time_cost
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = CreateJenkinsImageRegistryResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TimeCost') is not None:
            self.time_cost = m.get('TimeCost')
        return self


class CreateJenkinsImageRegistryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateJenkinsImageRegistryResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateJenkinsImageRegistryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateOrUpdateAssetGroupRequest(TeaModel):
    def __init__(
        self,
        group_id: int = None,
        group_name: str = None,
        uuids: str = None,
    ):
        # The ID of the server group for which you want to add to or remove servers.
        # 
        # >  To modify the mapping between an asset and an asset group, you must provide the ID of the asset group. You can call the [DescribeAllGroups](~~DescribeAllGroups~~) to query the IDs of asset groups. If you do not configure this parameter when you call this operation, an asset group is created.
        self.group_id = group_id
        # The name of the server group that you want to create or the server group for which you want to add or remove a server.
        # 
        # >  To modify the mapping between a server and a server group, you must provide the name of the server group. You can call the [DescribeAllGroups](~~DescribeAllGroups~~) operation to query the names of server groups. If you do not configure GroupID when you call this operation, a server group is created. In this case, you must configure GroupName.
        self.group_name = group_name
        # The UUID of the server in the server group that you want to create or the server group for which you want to add or remove servers. Separate multiple UUIDs with commas (,).
        # 
        # >  You can call the [DescribeCloudCenterInstances](~~DescribeCloudCenterInstances~~) operation to query the UUIDs of servers.
        self.uuids = uuids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.uuids is not None:
            result['Uuids'] = self.uuids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('Uuids') is not None:
            self.uuids = m.get('Uuids')
        return self


class CreateOrUpdateAssetGroupResponseBody(TeaModel):
    def __init__(
        self,
        group_id: int = None,
        request_id: str = None,
    ):
        # The ID of the server group.
        self.group_id = group_id
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateOrUpdateAssetGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateOrUpdateAssetGroupResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateOrUpdateAssetGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateRestoreJobRequest(TeaModel):
    def __init__(
        self,
        includes: str = None,
        snapshot_hash: str = None,
        snapshot_id: str = None,
        snapshot_version: str = None,
        source_type: str = None,
        target: str = None,
        uuid: str = None,
        vault_id: str = None,
    ):
        self.includes = includes
        self.snapshot_hash = snapshot_hash
        self.snapshot_id = snapshot_id
        self.snapshot_version = snapshot_version
        self.source_type = source_type
        self.target = target
        self.uuid = uuid
        self.vault_id = vault_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.includes is not None:
            result['Includes'] = self.includes
        if self.snapshot_hash is not None:
            result['SnapshotHash'] = self.snapshot_hash
        if self.snapshot_id is not None:
            result['SnapshotId'] = self.snapshot_id
        if self.snapshot_version is not None:
            result['SnapshotVersion'] = self.snapshot_version
        if self.source_type is not None:
            result['SourceType'] = self.source_type
        if self.target is not None:
            result['Target'] = self.target
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        if self.vault_id is not None:
            result['VaultId'] = self.vault_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Includes') is not None:
            self.includes = m.get('Includes')
        if m.get('SnapshotHash') is not None:
            self.snapshot_hash = m.get('SnapshotHash')
        if m.get('SnapshotId') is not None:
            self.snapshot_id = m.get('SnapshotId')
        if m.get('SnapshotVersion') is not None:
            self.snapshot_version = m.get('SnapshotVersion')
        if m.get('SourceType') is not None:
            self.source_type = m.get('SourceType')
        if m.get('Target') is not None:
            self.target = m.get('Target')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        if m.get('VaultId') is not None:
            self.vault_id = m.get('VaultId')
        return self


class CreateRestoreJobResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateRestoreJobResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateRestoreJobResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateRestoreJobResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateServiceLinkedRoleRequest(TeaModel):
    def __init__(
        self,
        service_linked_role: str = None,
    ):
        # The service-linked role. Default value: **AliyunServiceRoleForSas**. Valid values:
        # 
        # *   **AliyunServiceRoleForSas**: the service-linked role of Security Center. Security Center assumes this role to access the resources of other cloud services within your account.
        # *   **AliyunServiceRoleForSasCspm**: the service-linked role of Security Center-CSPM. Security Center-CSPM assumes this role to access the resources of other cloud services within your account.
        self.service_linked_role = service_linked_role

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.service_linked_role is not None:
            result['ServiceLinkedRole'] = self.service_linked_role
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ServiceLinkedRole') is not None:
            self.service_linked_role = m.get('ServiceLinkedRole')
        return self


class CreateServiceLinkedRoleResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateServiceLinkedRoleResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateServiceLinkedRoleResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateServiceLinkedRoleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateSimilarSecurityEventsQueryTaskRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        security_event_id: int = None,
        similar_event_scenario_code: str = None,
        source_ip: str = None,
    ):
        self.resource_owner_id = resource_owner_id
        # The ID of the alert event.
        # 
        # >  You must specify at least one of the SecurityEventId and SimilarEventScenarioCode parameters.
        self.security_event_id = security_event_id
        # The codes of alert events that are triggered by the same rule or of the same alert type.
        # 
        # >  You must specify at least one of the SecurityEventId and SimilarEventScenarioCode parameters.
        self.similar_event_scenario_code = similar_event_scenario_code
        # The source IP address of the request.
        self.source_ip = source_ip

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.security_event_id is not None:
            result['SecurityEventId'] = self.security_event_id
        if self.similar_event_scenario_code is not None:
            result['SimilarEventScenarioCode'] = self.similar_event_scenario_code
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SecurityEventId') is not None:
            self.security_event_id = m.get('SecurityEventId')
        if m.get('SimilarEventScenarioCode') is not None:
            self.similar_event_scenario_code = m.get('SimilarEventScenarioCode')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        return self


class CreateSimilarSecurityEventsQueryTaskResponseBodyCreateSimilarSecurityEventsQueryTaskResponse(TeaModel):
    def __init__(
        self,
        status: str = None,
        task_id: int = None,
    ):
        # The status of the task. Valid values:
        # 
        # *   **New**: The task is created.
        # *   **RetrievingData**: Data is being retrieved.
        # *   **DataRetrieved**: Data is retrieved.
        # *   **Processing**: The task is running.
        # *   **Success**: The task is successful.
        # *   **Failed**: The task failed.
        # *   **PartialFailed**: The task partially failed.
        self.status = status
        # The ID of the task.
        self.task_id = task_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.status is not None:
            result['Status'] = self.status
        if self.task_id is not None:
            result['TaskId'] = self.task_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TaskId') is not None:
            self.task_id = m.get('TaskId')
        return self


class CreateSimilarSecurityEventsQueryTaskResponseBody(TeaModel):
    def __init__(
        self,
        create_similar_security_events_query_task_response: CreateSimilarSecurityEventsQueryTaskResponseBodyCreateSimilarSecurityEventsQueryTaskResponse = None,
        request_id: str = None,
    ):
        # The information about the task that queries alert events of the same alert type.
        self.create_similar_security_events_query_task_response = create_similar_security_events_query_task_response
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id

    def validate(self):
        if self.create_similar_security_events_query_task_response:
            self.create_similar_security_events_query_task_response.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.create_similar_security_events_query_task_response is not None:
            result['CreateSimilarSecurityEventsQueryTaskResponse'] = self.create_similar_security_events_query_task_response.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CreateSimilarSecurityEventsQueryTaskResponse') is not None:
            temp_model = CreateSimilarSecurityEventsQueryTaskResponseBodyCreateSimilarSecurityEventsQueryTaskResponse()
            self.create_similar_security_events_query_task_response = temp_model.from_map(m['CreateSimilarSecurityEventsQueryTaskResponse'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateSimilarSecurityEventsQueryTaskResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateSimilarSecurityEventsQueryTaskResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateSimilarSecurityEventsQueryTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateSuspEventNoteRequest(TeaModel):
    def __init__(
        self,
        event_id: int = None,
        note: str = None,
    ):
        # The ID of the alert event to which you want to add remarks. You can call the [DescribeSuspEvents](~~251497~~) operation to query the IDs of alert events.
        self.event_id = event_id
        # The remarks that you want to add.
        self.note = note

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.event_id is not None:
            result['EventId'] = self.event_id
        if self.note is not None:
            result['Note'] = self.note
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EventId') is not None:
            self.event_id = m.get('EventId')
        if m.get('Note') is not None:
            self.note = m.get('Note')
        return self


class CreateSuspEventNoteResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The status code returned. The status code **200** indicates that the request was successful. Other status codes indicate that the request failed. You can identify the cause of the failure based on the status code.
        self.code = code
        # The HTTP status code returned.
        self.http_status_code = http_status_code
        # The error message returned.
        self.message = message
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id
        # Indicates whether exceptions are handled. Valid values:
        # 
        # *   **true**: yes
        # *   **false**: no
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateSuspEventNoteResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateSuspEventNoteResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateSuspEventNoteResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateUniBackupPolicyRequest(TeaModel):
    def __init__(
        self,
        account_name: str = None,
        account_password: str = None,
        database_add_by_user: str = None,
        database_type: str = None,
        full_plan: Dict[str, Any] = None,
        inc_plan: Dict[str, Any] = None,
        instance_id: str = None,
        policy_name: str = None,
        retention: int = None,
        speed_limiter: int = None,
        uni_region_id: str = None,
        uuid: str = None,
    ):
        self.account_name = account_name
        self.account_password = account_password
        self.database_add_by_user = database_add_by_user
        self.database_type = database_type
        self.full_plan = full_plan
        self.inc_plan = inc_plan
        self.instance_id = instance_id
        self.policy_name = policy_name
        self.retention = retention
        self.speed_limiter = speed_limiter
        self.uni_region_id = uni_region_id
        self.uuid = uuid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_name is not None:
            result['AccountName'] = self.account_name
        if self.account_password is not None:
            result['AccountPassword'] = self.account_password
        if self.database_add_by_user is not None:
            result['DatabaseAddByUser'] = self.database_add_by_user
        if self.database_type is not None:
            result['DatabaseType'] = self.database_type
        if self.full_plan is not None:
            result['FullPlan'] = self.full_plan
        if self.inc_plan is not None:
            result['IncPlan'] = self.inc_plan
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.policy_name is not None:
            result['PolicyName'] = self.policy_name
        if self.retention is not None:
            result['Retention'] = self.retention
        if self.speed_limiter is not None:
            result['SpeedLimiter'] = self.speed_limiter
        if self.uni_region_id is not None:
            result['UniRegionId'] = self.uni_region_id
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccountName') is not None:
            self.account_name = m.get('AccountName')
        if m.get('AccountPassword') is not None:
            self.account_password = m.get('AccountPassword')
        if m.get('DatabaseAddByUser') is not None:
            self.database_add_by_user = m.get('DatabaseAddByUser')
        if m.get('DatabaseType') is not None:
            self.database_type = m.get('DatabaseType')
        if m.get('FullPlan') is not None:
            self.full_plan = m.get('FullPlan')
        if m.get('IncPlan') is not None:
            self.inc_plan = m.get('IncPlan')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PolicyName') is not None:
            self.policy_name = m.get('PolicyName')
        if m.get('Retention') is not None:
            self.retention = m.get('Retention')
        if m.get('SpeedLimiter') is not None:
            self.speed_limiter = m.get('SpeedLimiter')
        if m.get('UniRegionId') is not None:
            self.uni_region_id = m.get('UniRegionId')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class CreateUniBackupPolicyShrinkRequest(TeaModel):
    def __init__(
        self,
        account_name: str = None,
        account_password: str = None,
        database_add_by_user: str = None,
        database_type: str = None,
        full_plan_shrink: str = None,
        inc_plan_shrink: str = None,
        instance_id: str = None,
        policy_name: str = None,
        retention: int = None,
        speed_limiter: int = None,
        uni_region_id: str = None,
        uuid: str = None,
    ):
        self.account_name = account_name
        self.account_password = account_password
        self.database_add_by_user = database_add_by_user
        self.database_type = database_type
        self.full_plan_shrink = full_plan_shrink
        self.inc_plan_shrink = inc_plan_shrink
        self.instance_id = instance_id
        self.policy_name = policy_name
        self.retention = retention
        self.speed_limiter = speed_limiter
        self.uni_region_id = uni_region_id
        self.uuid = uuid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.account_name is not None:
            result['AccountName'] = self.account_name
        if self.account_password is not None:
            result['AccountPassword'] = self.account_password
        if self.database_add_by_user is not None:
            result['DatabaseAddByUser'] = self.database_add_by_user
        if self.database_type is not None:
            result['DatabaseType'] = self.database_type
        if self.full_plan_shrink is not None:
            result['FullPlan'] = self.full_plan_shrink
        if self.inc_plan_shrink is not None:
            result['IncPlan'] = self.inc_plan_shrink
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.policy_name is not None:
            result['PolicyName'] = self.policy_name
        if self.retention is not None:
            result['Retention'] = self.retention
        if self.speed_limiter is not None:
            result['SpeedLimiter'] = self.speed_limiter
        if self.uni_region_id is not None:
            result['UniRegionId'] = self.uni_region_id
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccountName') is not None:
            self.account_name = m.get('AccountName')
        if m.get('AccountPassword') is not None:
            self.account_password = m.get('AccountPassword')
        if m.get('DatabaseAddByUser') is not None:
            self.database_add_by_user = m.get('DatabaseAddByUser')
        if m.get('DatabaseType') is not None:
            self.database_type = m.get('DatabaseType')
        if m.get('FullPlan') is not None:
            self.full_plan_shrink = m.get('FullPlan')
        if m.get('IncPlan') is not None:
            self.inc_plan_shrink = m.get('IncPlan')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('PolicyName') is not None:
            self.policy_name = m.get('PolicyName')
        if m.get('Retention') is not None:
            self.retention = m.get('Retention')
        if m.get('SpeedLimiter') is not None:
            self.speed_limiter = m.get('SpeedLimiter')
        if m.get('UniRegionId') is not None:
            self.uni_region_id = m.get('UniRegionId')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class CreateUniBackupPolicyResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateUniBackupPolicyResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateUniBackupPolicyResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateUniBackupPolicyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateUniRestorePlanRequest(TeaModel):
    def __init__(
        self,
        database: str = None,
        instance_uuid: str = None,
        policy_id: int = None,
        reset_scn: str = None,
        reset_time: str = None,
        restore_info: str = None,
        time_point: int = None,
    ):
        self.database = database
        self.instance_uuid = instance_uuid
        self.policy_id = policy_id
        self.reset_scn = reset_scn
        self.reset_time = reset_time
        self.restore_info = restore_info
        self.time_point = time_point

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.database is not None:
            result['Database'] = self.database
        if self.instance_uuid is not None:
            result['InstanceUuid'] = self.instance_uuid
        if self.policy_id is not None:
            result['PolicyId'] = self.policy_id
        if self.reset_scn is not None:
            result['ResetScn'] = self.reset_scn
        if self.reset_time is not None:
            result['ResetTime'] = self.reset_time
        if self.restore_info is not None:
            result['RestoreInfo'] = self.restore_info
        if self.time_point is not None:
            result['TimePoint'] = self.time_point
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Database') is not None:
            self.database = m.get('Database')
        if m.get('InstanceUuid') is not None:
            self.instance_uuid = m.get('InstanceUuid')
        if m.get('PolicyId') is not None:
            self.policy_id = m.get('PolicyId')
        if m.get('ResetScn') is not None:
            self.reset_scn = m.get('ResetScn')
        if m.get('ResetTime') is not None:
            self.reset_time = m.get('ResetTime')
        if m.get('RestoreInfo') is not None:
            self.restore_info = m.get('RestoreInfo')
        if m.get('TimePoint') is not None:
            self.time_point = m.get('TimePoint')
        return self


class CreateUniRestorePlanResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class CreateUniRestorePlanResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateUniRestorePlanResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateUniRestorePlanResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class CreateVulAutoRepairConfigRequestVulAutoRepairConfigList(TeaModel):
    def __init__(
        self,
        alias_name: str = None,
        name: str = None,
    ):
        # The alias of the vulnerability.
        self.alias_name = alias_name
        # The name of the vulnerability.
        self.name = name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alias_name is not None:
            result['AliasName'] = self.alias_name
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AliasName') is not None:
            self.alias_name = m.get('AliasName')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class CreateVulAutoRepairConfigRequest(TeaModel):
    def __init__(
        self,
        reason: str = None,
        type: str = None,
        vul_auto_repair_config_list: List[CreateVulAutoRepairConfigRequestVulAutoRepairConfigList] = None,
    ):
        # The reason why the vulnerability can be automatically fixed.
        self.reason = reason
        # The type of the vulnerability. Valid values: 
        # - **cve**: Linux software vulnerability. 
        # - **sys**: Windows system vulnerability.
        self.type = type
        # The vulnerabilities that can be automatically fixed.
        self.vul_auto_repair_config_list = vul_auto_repair_config_list

    def validate(self):
        if self.vul_auto_repair_config_list:
            for k in self.vul_auto_repair_config_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.reason is not None:
            result['Reason'] = self.reason
        if self.type is not None:
            result['Type'] = self.type
        result['VulAutoRepairConfigList'] = []
        if self.vul_auto_repair_config_list is not None:
            for k in self.vul_auto_repair_config_list:
                result['VulAutoRepairConfigList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Reason') is not None:
            self.reason = m.get('Reason')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        self.vul_auto_repair_config_list = []
        if m.get('VulAutoRepairConfigList') is not None:
            for k in m.get('VulAutoRepairConfigList'):
                temp_model = CreateVulAutoRepairConfigRequestVulAutoRepairConfigList()
                self.vul_auto_repair_config_list.append(temp_model.from_map(k))
        return self


class CreateVulAutoRepairConfigResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        # The status code returned. The status code **200** indicates that the request was is successful. Other status codes indicate that the request fails. You can identify the cause of the failure based on the status code.
        self.code = code
        # The HTTP status code returned.
        self.http_status_code = http_status_code
        # The error message returned.
        self.message = message
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id
        # Indicates whether the request is successful. Valid values:
        # 
        # *   **true**: yes
        # *   **false**: no
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class CreateVulAutoRepairConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: CreateVulAutoRepairConfigResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = CreateVulAutoRepairConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteAntiBruteForceRuleRequest(TeaModel):
    def __init__(
        self,
        ids: List[int] = None,
    ):
        # An array that consists of the IDs of the defense rules against brute-force attacks to delete.
        self.ids = ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ids is not None:
            result['Ids'] = self.ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Ids') is not None:
            self.ids = m.get('Ids')
        return self


class DeleteAntiBruteForceRuleResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteAntiBruteForceRuleResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteAntiBruteForceRuleResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteAntiBruteForceRuleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteBackupPolicyRequest(TeaModel):
    def __init__(
        self,
        id: int = None,
        policy_version: str = None,
    ):
        # The ID of the anti-ransomware policy that you want to delete.
        self.id = id
        # The version of the anti-ransomware policy that you want to delete. You can call the [DescribeBackupPolicies](~~322795~~) operation to query the versions of anti-ransomware policies. Valid values:
        # 
        # *   **1.0.0**\
        # *   **2.0.0**\
        self.policy_version = policy_version

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.policy_version is not None:
            result['PolicyVersion'] = self.policy_version
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('PolicyVersion') is not None:
            self.policy_version = m.get('PolicyVersion')
        return self


class DeleteBackupPolicyResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteBackupPolicyResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteBackupPolicyResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteBackupPolicyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteBackupPolicyMachineRequest(TeaModel):
    def __init__(
        self,
        policy_id: int = None,
        policy_version: str = None,
        uuid: str = None,
        uuid_list: List[str] = None,
    ):
        # The ID of the anti-ransomware policy.
        # >  You can call the [DescribeBackupPolicies](~~DescribeBackupPolicies~~) operation to query the **Id** of anti-ransomware policies.
        self.policy_id = policy_id
        # The version of the anti-ransomware policy. Valid values:
        # 
        # *   **1.0.0**\
        # *   **2.0.0**\
        # 
        # >  You can call the [DescribeBackupPolicies](~~DescribeBackupPolicies~~) operation to query the versions of anti-ransomware policies.
        self.policy_version = policy_version
        # The UUID of the server to which the anti-ransomware policy is applied.
        # 
        # >  You must specify at least one of the `UuidList` and `Uuid` parameters.
        self.uuid = uuid
        # The UUIDs of the servers to which the anti-ransomware policy is applied.
        # 
        # >  You must specify at least one of the `UuidList` and `Uuid` parameters.
        self.uuid_list = uuid_list

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.policy_id is not None:
            result['PolicyId'] = self.policy_id
        if self.policy_version is not None:
            result['PolicyVersion'] = self.policy_version
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        if self.uuid_list is not None:
            result['UuidList'] = self.uuid_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PolicyId') is not None:
            self.policy_id = m.get('PolicyId')
        if m.get('PolicyVersion') is not None:
            self.policy_version = m.get('PolicyVersion')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        if m.get('UuidList') is not None:
            self.uuid_list = m.get('UuidList')
        return self


class DeleteBackupPolicyMachineResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteBackupPolicyMachineResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteBackupPolicyMachineResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteBackupPolicyMachineResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteClientUserDefineRuleRequest(TeaModel):
    def __init__(
        self,
        id_list: List[int] = None,
    ):
        self.id_list = id_list

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id_list is not None:
            result['IdList'] = self.id_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('IdList') is not None:
            self.id_list = m.get('IdList')
        return self


class DeleteClientUserDefineRuleResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteClientUserDefineRuleResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteClientUserDefineRuleResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteClientUserDefineRuleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteCustomBlockRecordRequest(TeaModel):
    def __init__(
        self,
        id: int = None,
        resource_owner_id: int = None,
    ):
        self.id = id
        self.resource_owner_id = resource_owner_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class DeleteCustomBlockRecordResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteCustomBlockRecordResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteCustomBlockRecordResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteCustomBlockRecordResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteCycleTaskRequest(TeaModel):
    def __init__(
        self,
        config_id: str = None,
    ):
        self.config_id = config_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config_id is not None:
            result['ConfigId'] = self.config_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConfigId') is not None:
            self.config_id = m.get('ConfigId')
        return self


class DeleteCycleTaskResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteCycleTaskResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteCycleTaskResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteCycleTaskResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteGroupRequest(TeaModel):
    def __init__(
        self,
        group_id: int = None,
        source_ip: str = None,
    ):
        # The ID of the server group that you want to delete.
        # 
        # >  To delete a server group, you must provide the ID of the server group. You can call the [DescribeAllGroups](~~DescribeAllGroups~~) operation to query the ID.
        self.group_id = group_id
        # The source IP address of the request.
        self.source_ip = source_ip

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        return self


class DeleteGroupResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        request_id: str = None,
    ):
        # The status code returned. The status code **200** indicates that the request was successful. Other status codes indicate that the request failed. You can identify the cause of the failure based on the status code.
        self.code = code
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteGroupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteGroupResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteGroupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteHoneypotRequest(TeaModel):
    def __init__(
        self,
        honeypot_id: str = None,
    ):
        self.honeypot_id = honeypot_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.honeypot_id is not None:
            result['HoneypotId'] = self.honeypot_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HoneypotId') is not None:
            self.honeypot_id = m.get('HoneypotId')
        return self


class DeleteHoneypotResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.http_status_code = http_status_code
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteHoneypotResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteHoneypotResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteHoneypotResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteHoneypotNodeRequest(TeaModel):
    def __init__(
        self,
        node_id: str = None,
    ):
        self.node_id = node_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.node_id is not None:
            result['NodeId'] = self.node_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NodeId') is not None:
            self.node_id = m.get('NodeId')
        return self


class DeleteHoneypotNodeResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.http_status_code = http_status_code
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteHoneypotNodeResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteHoneypotNodeResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteHoneypotNodeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteHoneypotPresetRequest(TeaModel):
    def __init__(
        self,
        honeypot_preset_id: str = None,
    ):
        self.honeypot_preset_id = honeypot_preset_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.honeypot_preset_id is not None:
            result['HoneypotPresetId'] = self.honeypot_preset_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HoneypotPresetId') is not None:
            self.honeypot_preset_id = m.get('HoneypotPresetId')
        return self


class DeleteHoneypotPresetResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.http_status_code = http_status_code
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteHoneypotPresetResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteHoneypotPresetResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteHoneypotPresetResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteHoneypotProbeRequest(TeaModel):
    def __init__(
        self,
        probe_id: str = None,
    ):
        self.probe_id = probe_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.probe_id is not None:
            result['ProbeId'] = self.probe_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ProbeId') is not None:
            self.probe_id = m.get('ProbeId')
        return self


class DeleteHoneypotProbeResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        http_status_code: int = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.http_status_code = http_status_code
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteHoneypotProbeResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteHoneypotProbeResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteHoneypotProbeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteInstallCodeRequest(TeaModel):
    def __init__(
        self,
        captcha_code: str = None,
    ):
        self.captcha_code = captcha_code

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.captcha_code is not None:
            result['CaptchaCode'] = self.captcha_code
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CaptchaCode') is not None:
            self.captcha_code = m.get('CaptchaCode')
        return self


class DeleteInstallCodeResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteInstallCodeResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteInstallCodeResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteInstallCodeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteInterceptionRuleRequest(TeaModel):
    def __init__(
        self,
        cluster_id: str = None,
        rule_ids: List[int] = None,
    ):
        self.cluster_id = cluster_id
        self.rule_ids = rule_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.rule_ids is not None:
            result['RuleIds'] = self.rule_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('RuleIds') is not None:
            self.rule_ids = m.get('RuleIds')
        return self


class DeleteInterceptionRuleResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteInterceptionRuleResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteInterceptionRuleResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteInterceptionRuleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteInterceptionTargetRequest(TeaModel):
    def __init__(
        self,
        target_ids: str = None,
    ):
        self.target_ids = target_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.target_ids is not None:
            result['TargetIds'] = self.target_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TargetIds') is not None:
            self.target_ids = m.get('TargetIds')
        return self


class DeleteInterceptionTargetResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        result: bool = None,
    ):
        self.request_id = request_id
        self.result = result

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.result is not None:
            result['Result'] = self.result
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Result') is not None:
            self.result = m.get('Result')
        return self


class DeleteInterceptionTargetResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteInterceptionTargetResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteInterceptionTargetResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteLoginBaseConfigRequest(TeaModel):
    def __init__(
        self,
        config: str = None,
        target: str = None,
        type: str = None,
    ):
        # The configuration item that you want to delete. The items vary based on the type of logon configurations. Valid values:
        # 
        # *   **login\_common_ip**: approved logon IP addresses
        # 
        # Example: {"ip":"10.23.23.23"}.
        # 
        # *   **login\_common_time**: approved logon time ranges
        # 
        # Example: {"startTime":"06:00:00","endTime":"16:00:00"}.
        # 
        # *   **login\_common_account**: approved logon accounts
        # 
        # Example: {"account":"test_account\_001"}.
        # 
        # *   **login\_common_location**: approved logon locations
        # 
        # Example: {"location":"Shanghai"}.
        self.config = config
        # The UUID of the server whose logon configurations you want to delete.
        # 
        # > You can call the [DescribeCloudCenterInstances](~~DescribeCloudCenterInstances~~) operation to query the UUIDs of servers.
        self.target = target
        # The type of logon configurations to delete. Valid values:
        # 
        # *   **login\_common_ip**: approved logon IP addresses
        # *   **login\_common_time**: approved logon time ranges
        # *   **login\_common_account**: approved logon accounts
        # *   **login\_common_location**: approved logon locations
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config is not None:
            result['Config'] = self.config
        if self.target is not None:
            result['Target'] = self.target
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Config') is not None:
            self.config = m.get('Config')
        if m.get('Target') is not None:
            self.target = m.get('Target')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DeleteLoginBaseConfigResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteLoginBaseConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteLoginBaseConfigResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteLoginBaseConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteSecurityEventMarkMissListRequest(TeaModel):
    def __init__(
        self,
        ids: List[int] = None,
        resource_owner_id: int = None,
    ):
        self.ids = ids
        self.resource_owner_id = resource_owner_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ids is not None:
            result['Ids'] = self.ids
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Ids') is not None:
            self.ids = m.get('Ids')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        return self


class DeleteSecurityEventMarkMissListResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteSecurityEventMarkMissListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteSecurityEventMarkMissListResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteSecurityEventMarkMissListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteStrategyRequest(TeaModel):
    def __init__(
        self,
        id: str = None,
        lang: str = None,
        source_ip: str = None,
    ):
        # The ID of the baseline check policy that you want to delete.
        self.id = id
        # The language of the content within the request and response. Default value: **zh**. Valid values:
        # 
        # *   **zh**: Chinese
        # *   **en**: English
        self.lang = lang
        # The source IP address of the request.
        self.source_ip = source_ip

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        return self


class DeleteStrategyResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteStrategyResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteStrategyResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteStrategyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteSuspEventNodeRequest(TeaModel):
    def __init__(
        self,
        note_id: int = None,
    ):
        self.note_id = note_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.note_id is not None:
            result['NoteId'] = self.note_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NoteId') is not None:
            self.note_id = m.get('NoteId')
        return self


class DeleteSuspEventNodeResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DeleteSuspEventNodeResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteSuspEventNodeResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteSuspEventNodeResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteTagWithUuidRequest(TeaModel):
    def __init__(
        self,
        tag_name: str = None,
        uuid_list: str = None,
    ):
        # The name of the tag.
        self.tag_name = tag_name
        # The list of server UUIDs.
        # 
        # >  If the UuidList parameter is configured, Security Center removes the tag only from the servers whose UUIDs are specified by UuidList. If the UuidList parameter is not configured, Security Center removes the tag from all servers.
        self.uuid_list = uuid_list

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tag_name is not None:
            result['TagName'] = self.tag_name
        if self.uuid_list is not None:
            result['UuidList'] = self.uuid_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TagName') is not None:
            self.tag_name = m.get('TagName')
        if m.get('UuidList') is not None:
            self.uuid_list = m.get('UuidList')
        return self


class DeleteTagWithUuidResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteTagWithUuidResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteTagWithUuidResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteTagWithUuidResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteUniBackupPolicyRequest(TeaModel):
    def __init__(
        self,
        policy_id: int = None,
        policy_ids: str = None,
    ):
        self.policy_id = policy_id
        self.policy_ids = policy_ids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.policy_id is not None:
            result['PolicyId'] = self.policy_id
        if self.policy_ids is not None:
            result['PolicyIds'] = self.policy_ids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PolicyId') is not None:
            self.policy_id = m.get('PolicyId')
        if m.get('PolicyIds') is not None:
            self.policy_ids = m.get('PolicyIds')
        return self


class DeleteUniBackupPolicyResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteUniBackupPolicyResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteUniBackupPolicyResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteUniBackupPolicyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteVpcHoneyPotRequest(TeaModel):
    def __init__(
        self,
        vpc_id: str = None,
    ):
        # The ID of the virtual private cloud (VPC) on which the honeypot is deployed.
        # 
        # >  You can call the [DescribeVpcHoneyPotList](~~DescribeVpcHoneyPotList~~) operation to query the IDs of VPCs.
        self.vpc_id = vpc_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        return self


class DeleteVpcHoneyPotResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteVpcHoneyPotResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteVpcHoneyPotResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteVpcHoneyPotResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DeleteVulWhitelistRequest(TeaModel):
    def __init__(
        self,
        id: str = None,
        whitelist: str = None,
    ):
        # The ID of the whitelist.
        # 
        # >  To delete a vulnerability whitelist, you must provide the ID of the whitelist. You can call the [DescribeVulWhitelist](~~DescribeVulWhitelist~~) operation to query the IDs of whitelists.
        self.id = id
        # The information about the whitelist. The value is a JSON string that contains the following fields:
        # 
        # *   **Name**: the name of the vulnerability.
        # 
        # *   **Type**: the type of the vulnerability. Valid values:
        # 
        #     *   **cve**: Linux software vulnerability
        #     *   **sys**: Windows system vulnerability
        #     *   **cms**: Web-CMS vulnerability
        #     *   **app**: application vulnerability
        #     *   **emg**: urgent vulnerability
        # 
        # *   **AliasName**: the alias of the vulnerability.
        self.whitelist = whitelist

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.whitelist is not None:
            result['Whitelist'] = self.whitelist
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Whitelist') is not None:
            self.whitelist = m.get('Whitelist')
        return self


class DeleteVulWhitelistResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
    ):
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DeleteVulWhitelistResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DeleteVulWhitelistResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DeleteVulWhitelistResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAccessKeyLeakDetailRequest(TeaModel):
    def __init__(
        self,
        id: int = None,
    ):
        # The ID of the AccessKey pair leak.
        self.id = id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        return self


class DescribeAccessKeyLeakDetailResponseBody(TeaModel):
    def __init__(
        self,
        accesskey_id: str = None,
        asset: str = None,
        code: str = None,
        deal_time: str = None,
        deal_type: str = None,
        github_file_name: str = None,
        github_file_type: str = None,
        github_file_update_time: str = None,
        github_file_url: str = None,
        github_repo_name: str = None,
        github_repo_url: str = None,
        github_user: str = None,
        github_user_pic_url: str = None,
        gmt_create: str = None,
        gmt_modified: str = None,
        remark: str = None,
        request_id: str = None,
        source: str = None,
        type: str = None,
        whitelist_status: str = None,
    ):
        # The ID of the AccessKey pair that is leaked.
        self.accesskey_id = accesskey_id
        # The platform to which the asset belongs. The value is fixed as **Cloud platform**.
        self.asset = asset
        # The code snippet that is leaked.
        self.code = code
        # The time when the AccessKey pair leak was handled.
        self.deal_time = deal_time
        # The solution to the AccessKey pair leak. Valid values:
        # 
        # *   **manual**: manually deleted
        # *   **disable**: manually disabled
        # *   **add-whitelist**: added to the whitelist
        # *   **pending**: unhandled
        self.deal_type = deal_type
        # The name of the GitHub file.
        self.github_file_name = github_file_name
        # The type of the GitHub file. Valid values:
        # 
        # *   Python
        # *   XML
        # *   GO
        # *   Javascript
        # *   INI
        # *   JSON
        # *   C++\
        self.github_file_type = github_file_type
        # The time when the GitHub file was updated.
        self.github_file_update_time = github_file_update_time
        # The URL of the GitHub file.
        self.github_file_url = github_file_url
        # The name of the GitHub repository.
        self.github_repo_name = github_repo_name
        # The URL of the GitHub repository.
        self.github_repo_url = github_repo_url
        # The username of the GitHub user.
        self.github_user = github_user
        # The URL of the profile picture for the GitHub user.
        self.github_user_pic_url = github_user_pic_url
        # The first time when the AccessKey pair leak was detected.
        self.gmt_create = gmt_create
        # The last time when the AccessKey pair leak was detected.
        self.gmt_modified = gmt_modified
        # The remarks of the AccessKey pair leak.
        self.remark = remark
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id
        # The platform on which the AccessKey pair leak is detected.
        self.source = source
        # The type of the leak. The value is fixed as **AccessKey**.
        self.type = type
        # Indicates whether the AccessKey pair leak is added to the whitelist. Valid values:
        # 
        # *   **no**: The AccessKey pair leak is not added to the whitelist.
        # *   **yes**: The AccessKey pair leak is added to the whitelist.
        self.whitelist_status = whitelist_status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.accesskey_id is not None:
            result['AccesskeyId'] = self.accesskey_id
        if self.asset is not None:
            result['Asset'] = self.asset
        if self.code is not None:
            result['Code'] = self.code
        if self.deal_time is not None:
            result['DealTime'] = self.deal_time
        if self.deal_type is not None:
            result['DealType'] = self.deal_type
        if self.github_file_name is not None:
            result['GithubFileName'] = self.github_file_name
        if self.github_file_type is not None:
            result['GithubFileType'] = self.github_file_type
        if self.github_file_update_time is not None:
            result['GithubFileUpdateTime'] = self.github_file_update_time
        if self.github_file_url is not None:
            result['GithubFileUrl'] = self.github_file_url
        if self.github_repo_name is not None:
            result['GithubRepoName'] = self.github_repo_name
        if self.github_repo_url is not None:
            result['GithubRepoUrl'] = self.github_repo_url
        if self.github_user is not None:
            result['GithubUser'] = self.github_user
        if self.github_user_pic_url is not None:
            result['GithubUserPicUrl'] = self.github_user_pic_url
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.remark is not None:
            result['Remark'] = self.remark
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.source is not None:
            result['Source'] = self.source
        if self.type is not None:
            result['Type'] = self.type
        if self.whitelist_status is not None:
            result['WhitelistStatus'] = self.whitelist_status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccesskeyId') is not None:
            self.accesskey_id = m.get('AccesskeyId')
        if m.get('Asset') is not None:
            self.asset = m.get('Asset')
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('DealTime') is not None:
            self.deal_time = m.get('DealTime')
        if m.get('DealType') is not None:
            self.deal_type = m.get('DealType')
        if m.get('GithubFileName') is not None:
            self.github_file_name = m.get('GithubFileName')
        if m.get('GithubFileType') is not None:
            self.github_file_type = m.get('GithubFileType')
        if m.get('GithubFileUpdateTime') is not None:
            self.github_file_update_time = m.get('GithubFileUpdateTime')
        if m.get('GithubFileUrl') is not None:
            self.github_file_url = m.get('GithubFileUrl')
        if m.get('GithubRepoName') is not None:
            self.github_repo_name = m.get('GithubRepoName')
        if m.get('GithubRepoUrl') is not None:
            self.github_repo_url = m.get('GithubRepoUrl')
        if m.get('GithubUser') is not None:
            self.github_user = m.get('GithubUser')
        if m.get('GithubUserPicUrl') is not None:
            self.github_user_pic_url = m.get('GithubUserPicUrl')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('Remark') is not None:
            self.remark = m.get('Remark')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Source') is not None:
            self.source = m.get('Source')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('WhitelistStatus') is not None:
            self.whitelist_status = m.get('WhitelistStatus')
        return self


class DescribeAccessKeyLeakDetailResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeAccessKeyLeakDetailResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeAccessKeyLeakDetailResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAccesskeyLeakListRequest(TeaModel):
    def __init__(
        self,
        current_page: int = None,
        page_size: int = None,
        query: str = None,
        start_ts: int = None,
        status: str = None,
    ):
        # The number of the page to return. Default value: **1**.
        self.current_page = current_page
        # The number of entries to return on each page.\
        # Maximum value: 100. Default value: 20. If you leave this parameter empty, 20 entries are returned on each page.
        # 
        # > : We recommend that you do not leave this parameter empty.
        self.page_size = page_size
        # The AccessKey ID that you want to query. Only exact match is supported.
        self.query = query
        # The beginning of the time range to query. You can query all AccessKey pair leaks that are detected later than this time point. The value of this parameter is a UNIX timestamp. Unit: milliseconds.
        self.start_ts = start_ts
        # Specifies whether an AccessKey pair leak is handled. Valid values:
        # 
        # *   **pending**: unhandled
        # *   **dealed**: handled
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.query is not None:
            result['Query'] = self.query
        if self.start_ts is not None:
            result['StartTs'] = self.start_ts
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Query') is not None:
            self.query = m.get('Query')
        if m.get('StartTs') is not None:
            self.start_ts = m.get('StartTs')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DescribeAccesskeyLeakListResponseBodyAccessKeyLeakList(TeaModel):
    def __init__(
        self,
        accesskey_id: str = None,
        ali_user_name: str = None,
        asset: str = None,
        deal_time: str = None,
        deal_type: str = None,
        gmt_modified: int = None,
        id: int = None,
        status: str = None,
        type: str = None,
        url: str = None,
        user_type: str = None,
    ):
        # The ID of the AccessKey pair that is leaked.
        self.accesskey_id = accesskey_id
        # The name of the Alibaba Cloud account that is affected.
        self.ali_user_name = ali_user_name
        # The platform to which the asset belongs. The value is fixed as **Cloud platform**.
        self.asset = asset
        # The time when the AccessKey pair leak is handled.
        self.deal_time = deal_time
        # The method to handle the AccessKey pair leak. Valid values:
        # 
        # *   **pending**: The AccessKey pair leak is unhandled.
        # *   **manual**: The AccessKey pair leak is manually handled.
        # *   **disable**: The AccessKey pair leak is disabled.
        # *   **add-whitelist**: The AccessKey pair leak is added to the whitelist.
        self.deal_type = deal_type
        # The time when the AccessKey pair leak is first detected. The value of this parameter is a UNIX timestamp. Unit: milliseconds.
        self.gmt_modified = gmt_modified
        # The primary key ID of the database.
        self.id = id
        # Indicates whether the AccessKey pair leak is handled. Valid values:
        # 
        # *   **pending**: unhandled
        # *   **dealed**: handled
        self.status = status
        # The type of the leak. The value is fixed as **AccessKey**.
        self.type = type
        # The URL of the platform on which the AccessKey pair leak is detected.
        self.url = url
        # The type of the account to which the leaked AccessKey pair belongs. Valid values:
        # 
        # *   **master**: Alibaba Cloud account
        # *   **ram**: RAM user
        self.user_type = user_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.accesskey_id is not None:
            result['AccesskeyId'] = self.accesskey_id
        if self.ali_user_name is not None:
            result['AliUserName'] = self.ali_user_name
        if self.asset is not None:
            result['Asset'] = self.asset
        if self.deal_time is not None:
            result['DealTime'] = self.deal_time
        if self.deal_type is not None:
            result['DealType'] = self.deal_type
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.id is not None:
            result['Id'] = self.id
        if self.status is not None:
            result['Status'] = self.status
        if self.type is not None:
            result['Type'] = self.type
        if self.url is not None:
            result['Url'] = self.url
        if self.user_type is not None:
            result['UserType'] = self.user_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AccesskeyId') is not None:
            self.accesskey_id = m.get('AccesskeyId')
        if m.get('AliUserName') is not None:
            self.ali_user_name = m.get('AliUserName')
        if m.get('Asset') is not None:
            self.asset = m.get('Asset')
        if m.get('DealTime') is not None:
            self.deal_time = m.get('DealTime')
        if m.get('DealType') is not None:
            self.deal_type = m.get('DealType')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Url') is not None:
            self.url = m.get('Url')
        if m.get('UserType') is not None:
            self.user_type = m.get('UserType')
        return self


class DescribeAccesskeyLeakListResponseBody(TeaModel):
    def __init__(
        self,
        access_key_leak_list: List[DescribeAccesskeyLeakListResponseBodyAccessKeyLeakList] = None,
        ak_leak_count: int = None,
        current_page: int = None,
        gmt_last: int = None,
        page_size: int = None,
        request_id: str = None,
        total_count: int = None,
    ):
        # An array that consists of the details about AccessKey pair leaks.
        self.access_key_leak_list = access_key_leak_list
        # The number of AccessKey pair leaks that are unhandled.
        self.ak_leak_count = ak_leak_count
        # The page number of the returned page.
        self.current_page = current_page
        # This parameter is deprecated.
        self.gmt_last = gmt_last
        # The number of entries returned on each page.
        self.page_size = page_size
        # The ID of the request.
        self.request_id = request_id
        # The total number of AccessKey pair leaks.
        self.total_count = total_count

    def validate(self):
        if self.access_key_leak_list:
            for k in self.access_key_leak_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AccessKeyLeakList'] = []
        if self.access_key_leak_list is not None:
            for k in self.access_key_leak_list:
                result['AccessKeyLeakList'].append(k.to_map() if k else None)
        if self.ak_leak_count is not None:
            result['AkLeakCount'] = self.ak_leak_count
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.gmt_last is not None:
            result['GmtLast'] = self.gmt_last
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.access_key_leak_list = []
        if m.get('AccessKeyLeakList') is not None:
            for k in m.get('AccessKeyLeakList'):
                temp_model = DescribeAccesskeyLeakListResponseBodyAccessKeyLeakList()
                self.access_key_leak_list.append(temp_model.from_map(k))
        if m.get('AkLeakCount') is not None:
            self.ak_leak_count = m.get('AkLeakCount')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('GmtLast') is not None:
            self.gmt_last = m.get('GmtLast')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeAccesskeyLeakListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeAccesskeyLeakListResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeAccesskeyLeakListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAffectedAssetsRequest(TeaModel):
    def __init__(
        self,
        current: str = None,
        levels: str = None,
        page_size: str = None,
    ):
        self.current = current
        self.levels = levels
        self.page_size = page_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current is not None:
            result['Current'] = self.current
        if self.levels is not None:
            result['Levels'] = self.levels
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Current') is not None:
            self.current = m.get('Current')
        if m.get('Levels') is not None:
            self.levels = m.get('Levels')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class DescribeAffectedAssetsResponseBodyAssetList(TeaModel):
    def __init__(
        self,
        instance_id: str = None,
        instance_name: str = None,
        internet_ip: str = None,
        intranet_ip: str = None,
        risk_num: int = None,
        uuid: str = None,
    ):
        self.instance_id = instance_id
        self.instance_name = instance_name
        self.internet_ip = internet_ip
        self.intranet_ip = intranet_ip
        self.risk_num = risk_num
        self.uuid = uuid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.internet_ip is not None:
            result['InternetIp'] = self.internet_ip
        if self.intranet_ip is not None:
            result['IntranetIp'] = self.intranet_ip
        if self.risk_num is not None:
            result['RiskNum'] = self.risk_num
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('InternetIp') is not None:
            self.internet_ip = m.get('InternetIp')
        if m.get('IntranetIp') is not None:
            self.intranet_ip = m.get('IntranetIp')
        if m.get('RiskNum') is not None:
            self.risk_num = m.get('RiskNum')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class DescribeAffectedAssetsResponseBodyPageInfo(TeaModel):
    def __init__(
        self,
        count: int = None,
        current_page: int = None,
        page_size: int = None,
        total_count: int = None,
    ):
        self.count = count
        self.current_page = current_page
        self.page_size = page_size
        self.total_count = total_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeAffectedAssetsResponseBody(TeaModel):
    def __init__(
        self,
        asset_list: List[DescribeAffectedAssetsResponseBodyAssetList] = None,
        page_info: DescribeAffectedAssetsResponseBodyPageInfo = None,
        request_id: str = None,
    ):
        self.asset_list = asset_list
        self.page_info = page_info
        self.request_id = request_id

    def validate(self):
        if self.asset_list:
            for k in self.asset_list:
                if k:
                    k.validate()
        if self.page_info:
            self.page_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AssetList'] = []
        if self.asset_list is not None:
            for k in self.asset_list:
                result['AssetList'].append(k.to_map() if k else None)
        if self.page_info is not None:
            result['PageInfo'] = self.page_info.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.asset_list = []
        if m.get('AssetList') is not None:
            for k in m.get('AssetList'):
                temp_model = DescribeAffectedAssetsResponseBodyAssetList()
                self.asset_list.append(temp_model.from_map(k))
        if m.get('PageInfo') is not None:
            temp_model = DescribeAffectedAssetsResponseBodyPageInfo()
            self.page_info = temp_model.from_map(m['PageInfo'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeAffectedAssetsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeAffectedAssetsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeAffectedAssetsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAffectedMaliciousFileImagesRequest(TeaModel):
    def __init__(
        self,
        cluster_id: str = None,
        cluster_name: str = None,
        container_id: str = None,
        current_page: int = None,
        image: str = None,
        image_digest: str = None,
        image_layer: str = None,
        image_tag: str = None,
        lang: str = None,
        levels: str = None,
        malicious_md_5: str = None,
        namespace: str = None,
        page_size: str = None,
        pod: str = None,
        repo_id: str = None,
        repo_instance_id: str = None,
        repo_name: str = None,
        repo_namespace: str = None,
        repo_region_id: str = None,
        scan_range: List[str] = None,
    ):
        # The ID of the container cluster.
        # 
        # >  You can call the [DescribeGroupedContainerInstances](~~DescribeGroupedContainerInstances~~) operation to query the IDs of container clusters.
        self.cluster_id = cluster_id
        # The name of the cluster.
        self.cluster_name = cluster_name
        # The ID of the container.
        self.container_id = container_id
        # The number of the page to return. Pages start from page **1**. Default value: **1**.
        self.current_page = current_page
        # The name of the container image.
        self.image = image
        # The image digest.
        self.image_digest = image_digest
        # The image layer.
        self.image_layer = image_layer
        # The tag that is added to the image.
        self.image_tag = image_tag
        # The language of the content within the request and the response. Valid values:
        # 
        # *   **zh**: Chinese
        # *   **en**: English
        self.lang = lang
        # The severity of the malicious image sample. Separate multiple severities with commas (,). Valid values: serious suspicious remind
        self.levels = levels
        # The MD5 hash value of the malicious image sample.
        # 
        # >  You can call the [DescribeGroupedMaliciousFiles](~~DescribeGroupedMaliciousFiles~~) operation to query the MD5 hash values of malicious image samples.
        self.malicious_md_5 = malicious_md_5
        # The namespace.
        self.namespace = namespace
        # The number of entries to return on each page. Default value: **20**.
        self.page_size = page_size
        # The pod.
        self.pod = pod
        # The ID of the image repository.
        # 
        # >  You can call the [ListRepository](~~ListRepository~~) operation to query the IDs of image repositories from the value of the **RepoId** response parameter.
        self.repo_id = repo_id
        # The ID of the container image.
        # 
        # >  You can call the [ListRepository](~~ListRepository~~) operation to query the IDs of container images from the value of the **InstanceId** response parameter.
        self.repo_instance_id = repo_instance_id
        # The name of the image repository.
        # 
        # >  Fuzzy match is supported.
        self.repo_name = repo_name
        # The namespace to which the image repository belongs.
        # 
        # >  Fuzzy match is supported.
        self.repo_namespace = repo_namespace
        # The region ID of the image repository. Valid values:
        # 
        # *   **cn-beijing**: China (Beijing)
        # *   **cn-zhangjiakou**: China (Zhangjiakou)
        # *   **cn-hangzhou**: China (Hangzhou)
        # *   **cn-shanghai**: China (Shanghai)
        # *   **cn-shenzhen**: China (Shenzhen)
        # *   **cn-hongkong**: China (Hong Kong)
        # *   **ap-southeast-1**: Singapore
        # *   **ap-southeast-5**: Indonesia (Jakarta)
        # *   **us-east-1**: US (Virginia)
        # *   **us-west-1**: US (Silicon Valley)
        # *   **eu-central-1**: Germany (Frankfurt)
        # *   **eu-west-1**: UK (London)
        # *   **ap-south-1**: India (Mumbai)
        self.repo_region_id = repo_region_id
        # The types of the assets that you want to scan.
        self.scan_range = scan_range

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.cluster_name is not None:
            result['ClusterName'] = self.cluster_name
        if self.container_id is not None:
            result['ContainerId'] = self.container_id
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.image is not None:
            result['Image'] = self.image
        if self.image_digest is not None:
            result['ImageDigest'] = self.image_digest
        if self.image_layer is not None:
            result['ImageLayer'] = self.image_layer
        if self.image_tag is not None:
            result['ImageTag'] = self.image_tag
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.levels is not None:
            result['Levels'] = self.levels
        if self.malicious_md_5 is not None:
            result['MaliciousMd5'] = self.malicious_md_5
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.pod is not None:
            result['Pod'] = self.pod
        if self.repo_id is not None:
            result['RepoId'] = self.repo_id
        if self.repo_instance_id is not None:
            result['RepoInstanceId'] = self.repo_instance_id
        if self.repo_name is not None:
            result['RepoName'] = self.repo_name
        if self.repo_namespace is not None:
            result['RepoNamespace'] = self.repo_namespace
        if self.repo_region_id is not None:
            result['RepoRegionId'] = self.repo_region_id
        if self.scan_range is not None:
            result['ScanRange'] = self.scan_range
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('ClusterName') is not None:
            self.cluster_name = m.get('ClusterName')
        if m.get('ContainerId') is not None:
            self.container_id = m.get('ContainerId')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('Image') is not None:
            self.image = m.get('Image')
        if m.get('ImageDigest') is not None:
            self.image_digest = m.get('ImageDigest')
        if m.get('ImageLayer') is not None:
            self.image_layer = m.get('ImageLayer')
        if m.get('ImageTag') is not None:
            self.image_tag = m.get('ImageTag')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('Levels') is not None:
            self.levels = m.get('Levels')
        if m.get('MaliciousMd5') is not None:
            self.malicious_md_5 = m.get('MaliciousMd5')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Pod') is not None:
            self.pod = m.get('Pod')
        if m.get('RepoId') is not None:
            self.repo_id = m.get('RepoId')
        if m.get('RepoInstanceId') is not None:
            self.repo_instance_id = m.get('RepoInstanceId')
        if m.get('RepoName') is not None:
            self.repo_name = m.get('RepoName')
        if m.get('RepoNamespace') is not None:
            self.repo_namespace = m.get('RepoNamespace')
        if m.get('RepoRegionId') is not None:
            self.repo_region_id = m.get('RepoRegionId')
        if m.get('ScanRange') is not None:
            self.scan_range = m.get('ScanRange')
        return self


class DescribeAffectedMaliciousFileImagesResponseBodyAffectedMaliciousFileImagesResponse(TeaModel):
    def __init__(
        self,
        cluster_id: str = None,
        cluster_name: str = None,
        container_id: str = None,
        digest: str = None,
        download_url: str = None,
        file_path: str = None,
        first_scan_timestamp: int = None,
        high_light: str = None,
        image: str = None,
        image_uuid: str = None,
        instance_name: str = None,
        internet_ip: str = None,
        intranet_ip: str = None,
        latest_scan_timestamp: int = None,
        latest_verify_timestamp: int = None,
        layer: str = None,
        level: str = None,
        malicious_md_5: str = None,
        namespace: str = None,
        pod: str = None,
        repo_id: str = None,
        repo_instance_id: str = None,
        repo_name: str = None,
        repo_region_id: str = None,
        status: int = None,
        tag: str = None,
        target_id: str = None,
        target_name: str = None,
        target_type: str = None,
        uuid: str = None,
    ):
        # The ID of the cluster.
        self.cluster_id = cluster_id
        # The name of the cluster.
        self.cluster_name = cluster_name
        # The ID of the container.
        self.container_id = container_id
        # The image digest.
        self.digest = digest
        # The URL to download the malicious image sample.
        self.download_url = download_url
        # The path to the image file.
        self.file_path = file_path
        # The timestamp of the first scan.
        self.first_scan_timestamp = first_scan_timestamp
        # The text that is highlighted.
        self.high_light = high_light
        # The name of the image.
        self.image = image
        # The UUID of the image.
        self.image_uuid = image_uuid
        self.instance_name = instance_name
        self.internet_ip = internet_ip
        self.intranet_ip = intranet_ip
        # The timestamp of the last scan.
        self.latest_scan_timestamp = latest_scan_timestamp
        # The timestamp of the last verification.
        self.latest_verify_timestamp = latest_verify_timestamp
        # The image layer.
        self.layer = layer
        # The severity of the malicious image sample. Valid values:
        # 
        # *   **serious**\
        # *   **suspicious**\
        # *   **remind**\
        self.level = level
        # The MD5 hash value of the malicious image sample.
        self.malicious_md_5 = malicious_md_5
        # The namespace to which the image repository belongs.
        self.namespace = namespace
        # The pod.
        self.pod = pod
        # The ID of the image repository.
        self.repo_id = repo_id
        # The ID of the container image.
        self.repo_instance_id = repo_instance_id
        # The name of the image repository.
        self.repo_name = repo_name
        # The region ID of the image repository.
        self.repo_region_id = repo_region_id
        # The handling status of the malicious image sample. Valid values:
        # 
        # *   **0**: unhandled
        # *   **1**: handled
        # *   **2**: verifying
        # *   **3**: added to the whitelist
        self.status = status
        # The tag that is added to the image.
        self.tag = tag
        self.target_id = target_id
        self.target_name = target_name
        self.target_type = target_type
        self.uuid = uuid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.cluster_name is not None:
            result['ClusterName'] = self.cluster_name
        if self.container_id is not None:
            result['ContainerId'] = self.container_id
        if self.digest is not None:
            result['Digest'] = self.digest
        if self.download_url is not None:
            result['DownloadUrl'] = self.download_url
        if self.file_path is not None:
            result['FilePath'] = self.file_path
        if self.first_scan_timestamp is not None:
            result['FirstScanTimestamp'] = self.first_scan_timestamp
        if self.high_light is not None:
            result['HighLight'] = self.high_light
        if self.image is not None:
            result['Image'] = self.image
        if self.image_uuid is not None:
            result['ImageUuid'] = self.image_uuid
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.internet_ip is not None:
            result['InternetIp'] = self.internet_ip
        if self.intranet_ip is not None:
            result['IntranetIp'] = self.intranet_ip
        if self.latest_scan_timestamp is not None:
            result['LatestScanTimestamp'] = self.latest_scan_timestamp
        if self.latest_verify_timestamp is not None:
            result['LatestVerifyTimestamp'] = self.latest_verify_timestamp
        if self.layer is not None:
            result['Layer'] = self.layer
        if self.level is not None:
            result['Level'] = self.level
        if self.malicious_md_5 is not None:
            result['MaliciousMd5'] = self.malicious_md_5
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.pod is not None:
            result['Pod'] = self.pod
        if self.repo_id is not None:
            result['RepoId'] = self.repo_id
        if self.repo_instance_id is not None:
            result['RepoInstanceId'] = self.repo_instance_id
        if self.repo_name is not None:
            result['RepoName'] = self.repo_name
        if self.repo_region_id is not None:
            result['RepoRegionId'] = self.repo_region_id
        if self.status is not None:
            result['Status'] = self.status
        if self.tag is not None:
            result['Tag'] = self.tag
        if self.target_id is not None:
            result['TargetId'] = self.target_id
        if self.target_name is not None:
            result['TargetName'] = self.target_name
        if self.target_type is not None:
            result['TargetType'] = self.target_type
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('ClusterName') is not None:
            self.cluster_name = m.get('ClusterName')
        if m.get('ContainerId') is not None:
            self.container_id = m.get('ContainerId')
        if m.get('Digest') is not None:
            self.digest = m.get('Digest')
        if m.get('DownloadUrl') is not None:
            self.download_url = m.get('DownloadUrl')
        if m.get('FilePath') is not None:
            self.file_path = m.get('FilePath')
        if m.get('FirstScanTimestamp') is not None:
            self.first_scan_timestamp = m.get('FirstScanTimestamp')
        if m.get('HighLight') is not None:
            self.high_light = m.get('HighLight')
        if m.get('Image') is not None:
            self.image = m.get('Image')
        if m.get('ImageUuid') is not None:
            self.image_uuid = m.get('ImageUuid')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('InternetIp') is not None:
            self.internet_ip = m.get('InternetIp')
        if m.get('IntranetIp') is not None:
            self.intranet_ip = m.get('IntranetIp')
        if m.get('LatestScanTimestamp') is not None:
            self.latest_scan_timestamp = m.get('LatestScanTimestamp')
        if m.get('LatestVerifyTimestamp') is not None:
            self.latest_verify_timestamp = m.get('LatestVerifyTimestamp')
        if m.get('Layer') is not None:
            self.layer = m.get('Layer')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('MaliciousMd5') is not None:
            self.malicious_md_5 = m.get('MaliciousMd5')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('Pod') is not None:
            self.pod = m.get('Pod')
        if m.get('RepoId') is not None:
            self.repo_id = m.get('RepoId')
        if m.get('RepoInstanceId') is not None:
            self.repo_instance_id = m.get('RepoInstanceId')
        if m.get('RepoName') is not None:
            self.repo_name = m.get('RepoName')
        if m.get('RepoRegionId') is not None:
            self.repo_region_id = m.get('RepoRegionId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Tag') is not None:
            self.tag = m.get('Tag')
        if m.get('TargetId') is not None:
            self.target_id = m.get('TargetId')
        if m.get('TargetName') is not None:
            self.target_name = m.get('TargetName')
        if m.get('TargetType') is not None:
            self.target_type = m.get('TargetType')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class DescribeAffectedMaliciousFileImagesResponseBodyPageInfo(TeaModel):
    def __init__(
        self,
        count: int = None,
        current_page: int = None,
        page_size: int = None,
        total_count: int = None,
    ):
        # The number of images that have malicious image samples returned on the current page.
        self.count = count
        # The page number of the returned page. Pages start from page **1**. Default value: **1**.
        self.current_page = current_page
        # The number of entries returned per page. Default value: **20**.
        self.page_size = page_size
        # The total number of images that have malicious image samples.
        self.total_count = total_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeAffectedMaliciousFileImagesResponseBody(TeaModel):
    def __init__(
        self,
        affected_malicious_file_images_response: List[DescribeAffectedMaliciousFileImagesResponseBodyAffectedMaliciousFileImagesResponse] = None,
        page_info: DescribeAffectedMaliciousFileImagesResponseBodyPageInfo = None,
        request_id: str = None,
    ):
        # An array consisting of the images that have malicious image samples.
        self.affected_malicious_file_images_response = affected_malicious_file_images_response
        # The pagination information.
        self.page_info = page_info
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id

    def validate(self):
        if self.affected_malicious_file_images_response:
            for k in self.affected_malicious_file_images_response:
                if k:
                    k.validate()
        if self.page_info:
            self.page_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AffectedMaliciousFileImagesResponse'] = []
        if self.affected_malicious_file_images_response is not None:
            for k in self.affected_malicious_file_images_response:
                result['AffectedMaliciousFileImagesResponse'].append(k.to_map() if k else None)
        if self.page_info is not None:
            result['PageInfo'] = self.page_info.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.affected_malicious_file_images_response = []
        if m.get('AffectedMaliciousFileImagesResponse') is not None:
            for k in m.get('AffectedMaliciousFileImagesResponse'):
                temp_model = DescribeAffectedMaliciousFileImagesResponseBodyAffectedMaliciousFileImagesResponse()
                self.affected_malicious_file_images_response.append(temp_model.from_map(k))
        if m.get('PageInfo') is not None:
            temp_model = DescribeAffectedMaliciousFileImagesResponseBodyPageInfo()
            self.page_info = temp_model.from_map(m['PageInfo'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeAffectedMaliciousFileImagesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeAffectedMaliciousFileImagesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeAffectedMaliciousFileImagesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAgentInstallStatusRequest(TeaModel):
    def __init__(
        self,
        lang: str = None,
        source_ip: str = None,
        uuids: str = None,
    ):
        self.lang = lang
        self.source_ip = source_ip
        self.uuids = uuids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.uuids is not None:
            result['Uuids'] = self.uuids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('Uuids') is not None:
            self.uuids = m.get('Uuids')
        return self


class DescribeAgentInstallStatusResponseBodyAegisClientInvokeStatusResponseList(TeaModel):
    def __init__(
        self,
        message: str = None,
        resule_code: str = None,
        result: int = None,
        uuid: str = None,
    ):
        self.message = message
        self.resule_code = resule_code
        self.result = result
        self.uuid = uuid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.message is not None:
            result['Message'] = self.message
        if self.resule_code is not None:
            result['ResuleCode'] = self.resule_code
        if self.result is not None:
            result['Result'] = self.result
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('ResuleCode') is not None:
            self.resule_code = m.get('ResuleCode')
        if m.get('Result') is not None:
            self.result = m.get('Result')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class DescribeAgentInstallStatusResponseBody(TeaModel):
    def __init__(
        self,
        aegis_client_invoke_status_response_list: List[DescribeAgentInstallStatusResponseBodyAegisClientInvokeStatusResponseList] = None,
        request_id: str = None,
    ):
        self.aegis_client_invoke_status_response_list = aegis_client_invoke_status_response_list
        self.request_id = request_id

    def validate(self):
        if self.aegis_client_invoke_status_response_list:
            for k in self.aegis_client_invoke_status_response_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AegisClientInvokeStatusResponseList'] = []
        if self.aegis_client_invoke_status_response_list is not None:
            for k in self.aegis_client_invoke_status_response_list:
                result['AegisClientInvokeStatusResponseList'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.aegis_client_invoke_status_response_list = []
        if m.get('AegisClientInvokeStatusResponseList') is not None:
            for k in m.get('AegisClientInvokeStatusResponseList'):
                temp_model = DescribeAgentInstallStatusResponseBodyAegisClientInvokeStatusResponseList()
                self.aegis_client_invoke_status_response_list.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeAgentInstallStatusResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeAgentInstallStatusResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeAgentInstallStatusResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAlarmEventDetailRequest(TeaModel):
    def __init__(
        self,
        alarm_unique_info: str = None,
        from_: str = None,
        lang: str = None,
        source_ip: str = None,
    ):
        # The unique ID of the alert event.
        # 
        # >  To query the details of an alert event, you must specify the unique ID of the alert event. You can call the [DescribeAlarmEventList](~~DescribeAlarmEventList~~) operation to query the unique IDs of alert events.
        self.alarm_unique_info = alarm_unique_info
        # The ID of the request source. Set the value to **sas**.
        self.from_ = from_
        # The language of the content within the request and response. Default value: **zh**. Valid values:
        # 
        # *   **zh**: Chinese
        # *   **en**: English
        self.lang = lang
        # The source IP address of the request.
        self.source_ip = source_ip

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alarm_unique_info is not None:
            result['AlarmUniqueInfo'] = self.alarm_unique_info
        if self.from_ is not None:
            result['From'] = self.from_
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AlarmUniqueInfo') is not None:
            self.alarm_unique_info = m.get('AlarmUniqueInfo')
        if m.get('From') is not None:
            self.from_ = m.get('From')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        return self


class DescribeAlarmEventDetailResponseBodyDataCauseDetailsValue(TeaModel):
    def __init__(
        self,
        name: str = None,
        type: str = None,
        value: str = None,
    ):
        # The name of the field that displays tracing information.
        self.name = name
        # The type of the field that displays tracing information. Valid values:
        # 
        # *   **text**\
        # *   **html**\
        self.type = type
        # The value of the field that displays tracing information.
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.type is not None:
            result['Type'] = self.type
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeAlarmEventDetailResponseBodyDataCauseDetails(TeaModel):
    def __init__(
        self,
        key: str = None,
        value: List[DescribeAlarmEventDetailResponseBodyDataCauseDetailsValue] = None,
    ):
        # The key that is used to trace the alert event.
        self.key = key
        # An array consisting of the value that is used to trace the alert event.
        self.value = value

    def validate(self):
        if self.value:
            for k in self.value:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.key is not None:
            result['Key'] = self.key
        result['Value'] = []
        if self.value is not None:
            for k in self.value:
                result['Value'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Key') is not None:
            self.key = m.get('Key')
        self.value = []
        if m.get('Value') is not None:
            for k in m.get('Value'):
                temp_model = DescribeAlarmEventDetailResponseBodyDataCauseDetailsValue()
                self.value.append(temp_model.from_map(k))
        return self


class DescribeAlarmEventDetailResponseBodyData(TeaModel):
    def __init__(
        self,
        alarm_event_alias_name: str = None,
        alarm_event_desc: str = None,
        alarm_unique_info: str = None,
        app_name: str = None,
        can_be_deal_on_line: bool = None,
        can_cancel_fault: bool = None,
        cause_details: List[DescribeAlarmEventDetailResponseBodyDataCauseDetails] = None,
        contain_hw_mode: bool = None,
        container_id: str = None,
        container_image_id: str = None,
        container_image_name: str = None,
        data_source: str = None,
        end_time: int = None,
        instance_name: str = None,
        internet_ip: str = None,
        intranet_ip: str = None,
        k_8s_cluster_id: str = None,
        k_8s_cluster_name: str = None,
        k_8s_namespace: str = None,
        k_8s_node_id: str = None,
        k_8s_node_name: str = None,
        k_8s_pod_name: str = None,
        level: str = None,
        solution: str = None,
        start_time: int = None,
        type: str = None,
        uuid: str = None,
    ):
        # The name of the alert event.
        self.alarm_event_alias_name = alarm_event_alias_name
        # The description of the alert event.
        self.alarm_event_desc = alarm_event_desc
        # The unique ID of the alert event.
        # 
        # >  To query the details about an alert event, you must specify the unique ID of the alert event. You can call the [DescribeAlarmEventList](~~DescribeAlarmEventList~~) operation to query the unique IDs of alert events.
        self.alarm_unique_info = alarm_unique_info
        # The name of the container application.
        self.app_name = app_name
        # Indicates whether the online handling of the alert event is supported. Valid values:
        # 
        # *   **true**: yes
        # *   **false**: no
        self.can_be_deal_on_line = can_be_deal_on_line
        # Indicates whether you can cancel marking the alert event as a false positive. Valid values:
        # 
        # *   **true**: yes
        # *   **false**: no
        self.can_cancel_fault = can_cancel_fault
        # An array consisting of the cause of the alert event, which can be used to trace the alert event.
        self.cause_details = cause_details
        # Indicates whether the Safeguard Mode For Major Activities mode is enabled.
        self.contain_hw_mode = contain_hw_mode
        # The ID of the container application.
        self.container_id = container_id
        # The ID of the image to which the container belongs.
        self.container_image_id = container_image_id
        # The name of the image to which the container belongs.
        self.container_image_name = container_image_name
        # The data source of the alert event.
        self.data_source = data_source
        # The timestamp when the alert event ends. Unit: milliseconds.
        self.end_time = end_time
        # The name of the instance.
        self.instance_name = instance_name
        # The public IP address of the associated instance.
        self.internet_ip = internet_ip
        # The private IP address of the associated instance.
        self.intranet_ip = intranet_ip
        # The ID of the Kubernetes cluster.
        self.k_8s_cluster_id = k_8s_cluster_id
        # The name of the Kubernetes cluster.
        self.k_8s_cluster_name = k_8s_cluster_name
        # The namespace of the Kubernetes cluster.
        self.k_8s_namespace = k_8s_namespace
        # The ID of the Kubernetes cluster node.
        self.k_8s_node_id = k_8s_node_id
        # The name of the Kubernetes cluster node.
        self.k_8s_node_name = k_8s_node_name
        # The name of the Kubernetes pod.
        self.k_8s_pod_name = k_8s_pod_name
        # The severity of the alert event. Valid values:
        # 
        # *   **serious**\
        # *   **suspicious**\
        # *   **remind**\
        self.level = level
        # The solution to the alert event.
        self.solution = solution
        # The timestamp when the alert event starts. Unit: milliseconds.
        self.start_time = start_time
        # The alert type of the alert event. Valid values:
        # 
        # *   Suspicious process
        # *   Webshell
        # *   Unusual logon
        # *   Exception
        # *   Sensitive file tampering
        # *   Malicious process (cloud threat detection)
        # *   Suspicious network connection
        # *   Other
        # *   Abnormal account
        # *   Application intrusion event
        # *   Cloud threat detection
        # *   Precise defense
        # *   Application whitelist
        # *   Persistent webshell
        # *   Web application threat detection
        # *   Malicious script
        # *   Threat intelligence
        # *   Malicious network activity
        # *   Cluster exception
        # *   Webshell (on-premises threat detection)
        # *   Vulnerability exploitation
        # *   Malicious process (on-premises threat detection)
        # *   Trusted exception
        self.type = type
        # The instance UUID of the asset.
        self.uuid = uuid

    def validate(self):
        if self.cause_details:
            for k in self.cause_details:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alarm_event_alias_name is not None:
            result['AlarmEventAliasName'] = self.alarm_event_alias_name
        if self.alarm_event_desc is not None:
            result['AlarmEventDesc'] = self.alarm_event_desc
        if self.alarm_unique_info is not None:
            result['AlarmUniqueInfo'] = self.alarm_unique_info
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.can_be_deal_on_line is not None:
            result['CanBeDealOnLine'] = self.can_be_deal_on_line
        if self.can_cancel_fault is not None:
            result['CanCancelFault'] = self.can_cancel_fault
        result['CauseDetails'] = []
        if self.cause_details is not None:
            for k in self.cause_details:
                result['CauseDetails'].append(k.to_map() if k else None)
        if self.contain_hw_mode is not None:
            result['ContainHwMode'] = self.contain_hw_mode
        if self.container_id is not None:
            result['ContainerId'] = self.container_id
        if self.container_image_id is not None:
            result['ContainerImageId'] = self.container_image_id
        if self.container_image_name is not None:
            result['ContainerImageName'] = self.container_image_name
        if self.data_source is not None:
            result['DataSource'] = self.data_source
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.internet_ip is not None:
            result['InternetIp'] = self.internet_ip
        if self.intranet_ip is not None:
            result['IntranetIp'] = self.intranet_ip
        if self.k_8s_cluster_id is not None:
            result['K8sClusterId'] = self.k_8s_cluster_id
        if self.k_8s_cluster_name is not None:
            result['K8sClusterName'] = self.k_8s_cluster_name
        if self.k_8s_namespace is not None:
            result['K8sNamespace'] = self.k_8s_namespace
        if self.k_8s_node_id is not None:
            result['K8sNodeId'] = self.k_8s_node_id
        if self.k_8s_node_name is not None:
            result['K8sNodeName'] = self.k_8s_node_name
        if self.k_8s_pod_name is not None:
            result['K8sPodName'] = self.k_8s_pod_name
        if self.level is not None:
            result['Level'] = self.level
        if self.solution is not None:
            result['Solution'] = self.solution
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.type is not None:
            result['Type'] = self.type
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AlarmEventAliasName') is not None:
            self.alarm_event_alias_name = m.get('AlarmEventAliasName')
        if m.get('AlarmEventDesc') is not None:
            self.alarm_event_desc = m.get('AlarmEventDesc')
        if m.get('AlarmUniqueInfo') is not None:
            self.alarm_unique_info = m.get('AlarmUniqueInfo')
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('CanBeDealOnLine') is not None:
            self.can_be_deal_on_line = m.get('CanBeDealOnLine')
        if m.get('CanCancelFault') is not None:
            self.can_cancel_fault = m.get('CanCancelFault')
        self.cause_details = []
        if m.get('CauseDetails') is not None:
            for k in m.get('CauseDetails'):
                temp_model = DescribeAlarmEventDetailResponseBodyDataCauseDetails()
                self.cause_details.append(temp_model.from_map(k))
        if m.get('ContainHwMode') is not None:
            self.contain_hw_mode = m.get('ContainHwMode')
        if m.get('ContainerId') is not None:
            self.container_id = m.get('ContainerId')
        if m.get('ContainerImageId') is not None:
            self.container_image_id = m.get('ContainerImageId')
        if m.get('ContainerImageName') is not None:
            self.container_image_name = m.get('ContainerImageName')
        if m.get('DataSource') is not None:
            self.data_source = m.get('DataSource')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('InternetIp') is not None:
            self.internet_ip = m.get('InternetIp')
        if m.get('IntranetIp') is not None:
            self.intranet_ip = m.get('IntranetIp')
        if m.get('K8sClusterId') is not None:
            self.k_8s_cluster_id = m.get('K8sClusterId')
        if m.get('K8sClusterName') is not None:
            self.k_8s_cluster_name = m.get('K8sClusterName')
        if m.get('K8sNamespace') is not None:
            self.k_8s_namespace = m.get('K8sNamespace')
        if m.get('K8sNodeId') is not None:
            self.k_8s_node_id = m.get('K8sNodeId')
        if m.get('K8sNodeName') is not None:
            self.k_8s_node_name = m.get('K8sNodeName')
        if m.get('K8sPodName') is not None:
            self.k_8s_pod_name = m.get('K8sPodName')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('Solution') is not None:
            self.solution = m.get('Solution')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class DescribeAlarmEventDetailResponseBody(TeaModel):
    def __init__(
        self,
        data: DescribeAlarmEventDetailResponseBodyData = None,
        request_id: str = None,
    ):
        # The details about the alert event.
        self.data = data
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = DescribeAlarmEventDetailResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeAlarmEventDetailResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeAlarmEventDetailResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeAlarmEventDetailResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAlarmEventListRequest(TeaModel):
    def __init__(
        self,
        alarm_event_name: str = None,
        alarm_event_type: str = None,
        current_page: int = None,
        dealed: str = None,
        from_: str = None,
        group_id: str = None,
        id: int = None,
        lang: str = None,
        levels: str = None,
        operate_error_code_list: List[str] = None,
        operate_time_end: str = None,
        operate_time_start: str = None,
        page_size: str = None,
        remark: str = None,
        sort_column: str = None,
        sort_type: str = None,
        source_ip: str = None,
        tactic_id: str = None,
        time_end: str = None,
        time_start: str = None,
        unique_info: str = None,
        uuids: str = None,
    ):
        # The name of the alert event.
        # 
        # >  You can call the [DescribeNsasSuspEventType](~~DescribeNsasSuspEventType~~) operation to query the names of alert events.
        self.alarm_event_name = alarm_event_name
        # The type of the alert event.
        # 
        # >  You can call the [DescribeNsasSuspEventType](~~DescribeNsasSuspEventType~~) operation to query the types of alert events.
        self.alarm_event_type = alarm_event_type
        # The number of the page to return. Pages start from page **1**. Default value: **1**.
        self.current_page = current_page
        # Specifies whether the alert event is handled. Valid values:
        # 
        # *   **N**: unhandled
        # *   **Y**: handled
        self.dealed = dealed
        # The ID of the request source. Set the value to **sas**, which indicates that the request is sent from Security Center.
        self.from_ = from_
        # The ID of the asset group to which the affected asset belongs.
        self.group_id = group_id
        # The ID of the alert event.
        self.id = id
        # The language of the content within the request and response. Default value: **zh**. Valid values:
        # 
        # *   **zh**: Chinese
        # *   **en**: English
        self.lang = lang
        # The severity of the alert event. Separate multiple severities with commas (,). Valid values:
        # 
        # *   **serious**\
        # *   **suspicious**\
        # *   **remind**\
        self.levels = levels
        # An array that consists of the handling result codes of alert events.
        self.operate_error_code_list = operate_error_code_list
        # The time when the handling operation ends.
        self.operate_time_end = operate_time_end
        # The time when the handing operation starts.
        self.operate_time_start = operate_time_start
        # The number of entries to return on each page. Default value: **20**.
        self.page_size = page_size
        # The name of the alert or the information about the asset.
        self.remark = remark
        # The custom sorting field. Default value: **operateTime**. Valid values:
        # 
        # *   **lastTime**: the latest occurrence time
        # *   **operateTime**: the handling time
        # 
        # >  This parameter takes effect if you set the **Dealed** parameter to Y.
        self.sort_column = sort_column
        # The custom sorting order. Default value: **desc**. Valid values:
        # 
        # *   **asc**: the ascending order
        # *   **desc**: the descending order
        # 
        # >  This parameter takes effect if you set the **Dealed** parameter to Y.
        self.sort_type = sort_type
        # The source IP address of the request.
        self.source_ip = source_ip
        # The tactic ID of ATT\&CK.
        self.tactic_id = tactic_id
        # The end time when the alert event was last detected.
        self.time_end = time_end
        # The start time when the alert event was last detected.
        self.time_start = time_start
        # The ID of the alert event.
        self.unique_info = unique_info
        # The UUIDs of the assets. Separate multiple UUIDs with commas (,).
        self.uuids = uuids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alarm_event_name is not None:
            result['AlarmEventName'] = self.alarm_event_name
        if self.alarm_event_type is not None:
            result['AlarmEventType'] = self.alarm_event_type
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.dealed is not None:
            result['Dealed'] = self.dealed
        if self.from_ is not None:
            result['From'] = self.from_
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.id is not None:
            result['Id'] = self.id
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.levels is not None:
            result['Levels'] = self.levels
        if self.operate_error_code_list is not None:
            result['OperateErrorCodeList'] = self.operate_error_code_list
        if self.operate_time_end is not None:
            result['OperateTimeEnd'] = self.operate_time_end
        if self.operate_time_start is not None:
            result['OperateTimeStart'] = self.operate_time_start
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.remark is not None:
            result['Remark'] = self.remark
        if self.sort_column is not None:
            result['SortColumn'] = self.sort_column
        if self.sort_type is not None:
            result['SortType'] = self.sort_type
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.tactic_id is not None:
            result['TacticId'] = self.tactic_id
        if self.time_end is not None:
            result['TimeEnd'] = self.time_end
        if self.time_start is not None:
            result['TimeStart'] = self.time_start
        if self.unique_info is not None:
            result['UniqueInfo'] = self.unique_info
        if self.uuids is not None:
            result['Uuids'] = self.uuids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AlarmEventName') is not None:
            self.alarm_event_name = m.get('AlarmEventName')
        if m.get('AlarmEventType') is not None:
            self.alarm_event_type = m.get('AlarmEventType')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('Dealed') is not None:
            self.dealed = m.get('Dealed')
        if m.get('From') is not None:
            self.from_ = m.get('From')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('Levels') is not None:
            self.levels = m.get('Levels')
        if m.get('OperateErrorCodeList') is not None:
            self.operate_error_code_list = m.get('OperateErrorCodeList')
        if m.get('OperateTimeEnd') is not None:
            self.operate_time_end = m.get('OperateTimeEnd')
        if m.get('OperateTimeStart') is not None:
            self.operate_time_start = m.get('OperateTimeStart')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Remark') is not None:
            self.remark = m.get('Remark')
        if m.get('SortColumn') is not None:
            self.sort_column = m.get('SortColumn')
        if m.get('SortType') is not None:
            self.sort_type = m.get('SortType')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('TacticId') is not None:
            self.tactic_id = m.get('TacticId')
        if m.get('TimeEnd') is not None:
            self.time_end = m.get('TimeEnd')
        if m.get('TimeStart') is not None:
            self.time_start = m.get('TimeStart')
        if m.get('UniqueInfo') is not None:
            self.unique_info = m.get('UniqueInfo')
        if m.get('Uuids') is not None:
            self.uuids = m.get('Uuids')
        return self


class DescribeAlarmEventListResponseBodyPageInfo(TeaModel):
    def __init__(
        self,
        count: int = None,
        current_page: int = None,
        page_size: int = None,
        total_count: int = None,
    ):
        # The number of entries returned per page.
        self.count = count
        # The page number of the returned page.
        self.current_page = current_page
        # The number of entries returned per page. Default value: **20**.
        self.page_size = page_size
        # The total number of entries returned.
        self.total_count = total_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeAlarmEventListResponseBodySuspEventsTacticItems(TeaModel):
    def __init__(
        self,
        tactic_display_name: str = None,
        tactic_id: str = None,
    ):
        # The tactic name of ATT\&CK.
        self.tactic_display_name = tactic_display_name
        # The tactic ID of ATT\&CK.
        self.tactic_id = tactic_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tactic_display_name is not None:
            result['TacticDisplayName'] = self.tactic_display_name
        if self.tactic_id is not None:
            result['TacticId'] = self.tactic_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TacticDisplayName') is not None:
            self.tactic_display_name = m.get('TacticDisplayName')
        if m.get('TacticId') is not None:
            self.tactic_id = m.get('TacticId')
        return self


class DescribeAlarmEventListResponseBodySuspEvents(TeaModel):
    def __init__(
        self,
        alarm_event_name: str = None,
        alarm_event_name_original: str = None,
        alarm_event_type: str = None,
        alarm_unique_info: str = None,
        can_be_deal_on_line: bool = None,
        can_cancel_fault: bool = None,
        data_source: str = None,
        dealed: bool = None,
        description: str = None,
        end_time: int = None,
        gmt_modified: int = None,
        has_trace_info: bool = None,
        instance_id: str = None,
        instance_name: str = None,
        internet_ip: str = None,
        intranet_ip: str = None,
        level: str = None,
        operate_error_code: str = None,
        operate_time: int = None,
        sale_version: str = None,
        security_event_ids: str = None,
        solution: str = None,
        stages: str = None,
        start_time: int = None,
        suspicious_event_count: int = None,
        tactic_items: List[DescribeAlarmEventListResponseBodySuspEventsTacticItems] = None,
        uuid: str = None,
    ):
        # The name of the alert event.
        self.alarm_event_name = alarm_event_name
        # The original parent name of the alert event.
        self.alarm_event_name_original = alarm_event_name_original
        # The type of the alert event.
        self.alarm_event_type = alarm_event_type
        # The ID of the alert event.
        self.alarm_unique_info = alarm_unique_info
        # Indicates whether the online processing of the alert event is supported, such as quarantining the source file of the malicious process, adding the alert event to the whitelist, and ignoring the alert event. Valid values:
        # 
        # *   **true**: yes
        # *   **false**: no
        self.can_be_deal_on_line = can_be_deal_on_line
        # Indicates whether you can cancel marking the alert event as a false positive. Valid values:
        # 
        # *   **true**: yes
        # *   **false**: no
        self.can_cancel_fault = can_cancel_fault
        # The data source of the alert event.
        self.data_source = data_source
        # Indicates whether the alert event is handled. Valid values:
        # 
        # *   **true**: yes
        # *   **false**: no
        self.dealed = dealed
        # The description of the alert event.
        self.description = description
        # The timestamp when the alert event was last detected. Unit: milliseconds.
        self.end_time = end_time
        # The timestamp when the alert event was last modified. Unit: milliseconds.
        self.gmt_modified = gmt_modified
        # Indicates whether the alert event has tracing information. Valid values:
        # 
        # *   **true**: yes
        # *   **false**: no
        self.has_trace_info = has_trace_info
        # The ID of the affected asset.
        self.instance_id = instance_id
        # The name of the affected asset.
        self.instance_name = instance_name
        # The public IP address of the affected asset.
        self.internet_ip = internet_ip
        # The private IP address of the affected asset.
        self.intranet_ip = intranet_ip
        # The risk level of the alert event. Valid values:
        # 
        # *   **serious**\
        # *   **suspicious**\
        # *   **remind**\
        self.level = level
        # The handling result code of the alert event.
        self.operate_error_code = operate_error_code
        # The timestamp when the alert event was handled. Unit: milliseconds.
        self.operate_time = operate_time
        # The edition of Security Center in which the alert event can be detected. Valid values:
        # 
        # *   **0**: Basic edition
        # *   **1**: Advanced edition
        # *   **2**: Enterprise edition
        self.sale_version = sale_version
        # The IDs of the associated exceptions.
        self.security_event_ids = security_event_ids
        # The solution to the alert event.
        self.solution = solution
        # The stage at which the attack or intrusion is detected.
        self.stages = stages
        # The timestamp when the alert event starts. Unit: milliseconds.
        self.start_time = start_time
        # The number of associated exceptions.
        self.suspicious_event_count = suspicious_event_count
        # An array that consists of the stage information about ATT\&CK.
        self.tactic_items = tactic_items
        # The ID of the associated instance.
        self.uuid = uuid

    def validate(self):
        if self.tactic_items:
            for k in self.tactic_items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alarm_event_name is not None:
            result['AlarmEventName'] = self.alarm_event_name
        if self.alarm_event_name_original is not None:
            result['AlarmEventNameOriginal'] = self.alarm_event_name_original
        if self.alarm_event_type is not None:
            result['AlarmEventType'] = self.alarm_event_type
        if self.alarm_unique_info is not None:
            result['AlarmUniqueInfo'] = self.alarm_unique_info
        if self.can_be_deal_on_line is not None:
            result['CanBeDealOnLine'] = self.can_be_deal_on_line
        if self.can_cancel_fault is not None:
            result['CanCancelFault'] = self.can_cancel_fault
        if self.data_source is not None:
            result['DataSource'] = self.data_source
        if self.dealed is not None:
            result['Dealed'] = self.dealed
        if self.description is not None:
            result['Description'] = self.description
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.has_trace_info is not None:
            result['HasTraceInfo'] = self.has_trace_info
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.internet_ip is not None:
            result['InternetIp'] = self.internet_ip
        if self.intranet_ip is not None:
            result['IntranetIp'] = self.intranet_ip
        if self.level is not None:
            result['Level'] = self.level
        if self.operate_error_code is not None:
            result['OperateErrorCode'] = self.operate_error_code
        if self.operate_time is not None:
            result['OperateTime'] = self.operate_time
        if self.sale_version is not None:
            result['SaleVersion'] = self.sale_version
        if self.security_event_ids is not None:
            result['SecurityEventIds'] = self.security_event_ids
        if self.solution is not None:
            result['Solution'] = self.solution
        if self.stages is not None:
            result['Stages'] = self.stages
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.suspicious_event_count is not None:
            result['SuspiciousEventCount'] = self.suspicious_event_count
        result['TacticItems'] = []
        if self.tactic_items is not None:
            for k in self.tactic_items:
                result['TacticItems'].append(k.to_map() if k else None)
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AlarmEventName') is not None:
            self.alarm_event_name = m.get('AlarmEventName')
        if m.get('AlarmEventNameOriginal') is not None:
            self.alarm_event_name_original = m.get('AlarmEventNameOriginal')
        if m.get('AlarmEventType') is not None:
            self.alarm_event_type = m.get('AlarmEventType')
        if m.get('AlarmUniqueInfo') is not None:
            self.alarm_unique_info = m.get('AlarmUniqueInfo')
        if m.get('CanBeDealOnLine') is not None:
            self.can_be_deal_on_line = m.get('CanBeDealOnLine')
        if m.get('CanCancelFault') is not None:
            self.can_cancel_fault = m.get('CanCancelFault')
        if m.get('DataSource') is not None:
            self.data_source = m.get('DataSource')
        if m.get('Dealed') is not None:
            self.dealed = m.get('Dealed')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('HasTraceInfo') is not None:
            self.has_trace_info = m.get('HasTraceInfo')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('InternetIp') is not None:
            self.internet_ip = m.get('InternetIp')
        if m.get('IntranetIp') is not None:
            self.intranet_ip = m.get('IntranetIp')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('OperateErrorCode') is not None:
            self.operate_error_code = m.get('OperateErrorCode')
        if m.get('OperateTime') is not None:
            self.operate_time = m.get('OperateTime')
        if m.get('SaleVersion') is not None:
            self.sale_version = m.get('SaleVersion')
        if m.get('SecurityEventIds') is not None:
            self.security_event_ids = m.get('SecurityEventIds')
        if m.get('Solution') is not None:
            self.solution = m.get('Solution')
        if m.get('Stages') is not None:
            self.stages = m.get('Stages')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('SuspiciousEventCount') is not None:
            self.suspicious_event_count = m.get('SuspiciousEventCount')
        self.tactic_items = []
        if m.get('TacticItems') is not None:
            for k in m.get('TacticItems'):
                temp_model = DescribeAlarmEventListResponseBodySuspEventsTacticItems()
                self.tactic_items.append(temp_model.from_map(k))
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class DescribeAlarmEventListResponseBody(TeaModel):
    def __init__(
        self,
        page_info: DescribeAlarmEventListResponseBodyPageInfo = None,
        request_id: str = None,
        susp_events: List[DescribeAlarmEventListResponseBodySuspEvents] = None,
    ):
        # The pagination information.
        self.page_info = page_info
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id
        # An array that consists of the alert events.
        self.susp_events = susp_events

    def validate(self):
        if self.page_info:
            self.page_info.validate()
        if self.susp_events:
            for k in self.susp_events:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_info is not None:
            result['PageInfo'] = self.page_info.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['SuspEvents'] = []
        if self.susp_events is not None:
            for k in self.susp_events:
                result['SuspEvents'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageInfo') is not None:
            temp_model = DescribeAlarmEventListResponseBodyPageInfo()
            self.page_info = temp_model.from_map(m['PageInfo'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.susp_events = []
        if m.get('SuspEvents') is not None:
            for k in m.get('SuspEvents'):
                temp_model = DescribeAlarmEventListResponseBodySuspEvents()
                self.susp_events.append(temp_model.from_map(k))
        return self


class DescribeAlarmEventListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeAlarmEventListResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeAlarmEventListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAlarmEventStackInfoRequest(TeaModel):
    def __init__(
        self,
        event_name: str = None,
        lang: str = None,
        source_ip: str = None,
        unique_info: str = None,
        uuid: str = None,
    ):
        # The name of the event.
        # 
        # >  You can call the [DescribeSuspEvents](~~DescribeSuspEvents~~) operation to query the names of events.
        self.event_name = event_name
        # The language of the content within the request and response. Default value: **zh**. Valid values:
        # 
        # *   **zh**: Chinese
        # *   **en**: English
        self.lang = lang
        # The source IP address of the request.
        self.source_ip = source_ip
        # The ID of the alert event.
        self.unique_info = unique_info
        # The UUID of the server to query.
        # 
        # >  You can call the [DescribeSuspEvents](~~DescribeSuspEvents~~) operation to query the UUIDs of servers.
        self.uuid = uuid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.event_name is not None:
            result['EventName'] = self.event_name
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.unique_info is not None:
            result['UniqueInfo'] = self.unique_info
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EventName') is not None:
            self.event_name = m.get('EventName')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('UniqueInfo') is not None:
            self.unique_info = m.get('UniqueInfo')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class DescribeAlarmEventStackInfoResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        stack_info: str = None,
    ):
        # The ID of the request.
        self.request_id = request_id
        # The stack information of the alert details.
        self.stack_info = stack_info

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.stack_info is not None:
            result['StackInfo'] = self.stack_info
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('StackInfo') is not None:
            self.stack_info = m.get('StackInfo')
        return self


class DescribeAlarmEventStackInfoResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeAlarmEventStackInfoResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeAlarmEventStackInfoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAllEntityResponseBodyEntityList(TeaModel):
    def __init__(
        self,
        group_id: int = None,
        instance_name: str = None,
        internet_ip: str = None,
        intranet_ip: str = None,
        ip: str = None,
        os: str = None,
        uuid: str = None,
    ):
        # The ID of the asset group.
        self.group_id = group_id
        # The name of the server.
        self.instance_name = instance_name
        # The public IP address of the server.
        self.internet_ip = internet_ip
        # The private IP address of the server.
        self.intranet_ip = intranet_ip
        # The IP address of the server.
        self.ip = ip
        # The operating system of the server. Valid values:
        # 
        # *   **linux**\
        # *   **windows**\
        self.os = os
        # The UUID of the server.
        self.uuid = uuid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.internet_ip is not None:
            result['InternetIp'] = self.internet_ip
        if self.intranet_ip is not None:
            result['IntranetIp'] = self.intranet_ip
        if self.ip is not None:
            result['Ip'] = self.ip
        if self.os is not None:
            result['Os'] = self.os
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('InternetIp') is not None:
            self.internet_ip = m.get('InternetIp')
        if m.get('IntranetIp') is not None:
            self.intranet_ip = m.get('IntranetIp')
        if m.get('Ip') is not None:
            self.ip = m.get('Ip')
        if m.get('Os') is not None:
            self.os = m.get('Os')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class DescribeAllEntityResponseBody(TeaModel):
    def __init__(
        self,
        entity_list: List[DescribeAllEntityResponseBodyEntityList] = None,
        request_id: str = None,
    ):
        # An array that consists of servers.
        self.entity_list = entity_list
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id

    def validate(self):
        if self.entity_list:
            for k in self.entity_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['EntityList'] = []
        if self.entity_list is not None:
            for k in self.entity_list:
                result['EntityList'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.entity_list = []
        if m.get('EntityList') is not None:
            for k in m.get('EntityList'):
                temp_model = DescribeAllEntityResponseBodyEntityList()
                self.entity_list.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeAllEntityResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeAllEntityResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeAllEntityResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAllGroupsRequest(TeaModel):
    def __init__(
        self,
        lang: str = None,
    ):
        # The language of the content within the request and the response. Default value: **zh**. Valid values:
        # 
        # *   **zh**: Chinese
        # *   **en**: English
        self.lang = lang

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.lang is not None:
            result['Lang'] = self.lang
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        return self


class DescribeAllGroupsResponseBodyGroups(TeaModel):
    def __init__(
        self,
        group_flag: int = None,
        group_id: int = None,
        group_name: str = None,
    ):
        # The type of the server group. Valid values:
        # 
        # *   **0**: the default group
        # *   **1**: other groups
        self.group_flag = group_flag
        # The ID of the server group.
        self.group_id = group_id
        # The name of the server group.
        self.group_name = group_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_flag is not None:
            result['GroupFlag'] = self.group_flag
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GroupFlag') is not None:
            self.group_flag = m.get('GroupFlag')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        return self


class DescribeAllGroupsResponseBody(TeaModel):
    def __init__(
        self,
        count: int = None,
        groups: List[DescribeAllGroupsResponseBodyGroups] = None,
        request_id: str = None,
    ):
        # The total number of server groups.
        self.count = count
        # An array that consists of the information about server groups.
        self.groups = groups
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        if self.groups:
            for k in self.groups:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        result['Groups'] = []
        if self.groups is not None:
            for k in self.groups:
                result['Groups'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        self.groups = []
        if m.get('Groups') is not None:
            for k in m.get('Groups'):
                temp_model = DescribeAllGroupsResponseBodyGroups()
                self.groups.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeAllGroupsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeAllGroupsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeAllGroupsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAllImageBaselineRequest(TeaModel):
    def __init__(
        self,
        lang: str = None,
    ):
        self.lang = lang

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.lang is not None:
            result['Lang'] = self.lang
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        return self


class DescribeAllImageBaselineResponseBodyImageBaselinesBaselineClassListBaselineNameListBaselineItemList(TeaModel):
    def __init__(
        self,
        alias: str = None,
        class_key: str = None,
        item_key: str = None,
        name_key: str = None,
    ):
        self.alias = alias
        self.class_key = class_key
        self.item_key = item_key
        self.name_key = name_key

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alias is not None:
            result['Alias'] = self.alias
        if self.class_key is not None:
            result['ClassKey'] = self.class_key
        if self.item_key is not None:
            result['ItemKey'] = self.item_key
        if self.name_key is not None:
            result['NameKey'] = self.name_key
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Alias') is not None:
            self.alias = m.get('Alias')
        if m.get('ClassKey') is not None:
            self.class_key = m.get('ClassKey')
        if m.get('ItemKey') is not None:
            self.item_key = m.get('ItemKey')
        if m.get('NameKey') is not None:
            self.name_key = m.get('NameKey')
        return self


class DescribeAllImageBaselineResponseBodyImageBaselinesBaselineClassListBaselineNameList(TeaModel):
    def __init__(
        self,
        alias: str = None,
        baseline_item_list: List[DescribeAllImageBaselineResponseBodyImageBaselinesBaselineClassListBaselineNameListBaselineItemList] = None,
        class_key: str = None,
        name_key: str = None,
    ):
        self.alias = alias
        self.baseline_item_list = baseline_item_list
        self.class_key = class_key
        self.name_key = name_key

    def validate(self):
        if self.baseline_item_list:
            for k in self.baseline_item_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alias is not None:
            result['Alias'] = self.alias
        result['BaselineItemList'] = []
        if self.baseline_item_list is not None:
            for k in self.baseline_item_list:
                result['BaselineItemList'].append(k.to_map() if k else None)
        if self.class_key is not None:
            result['ClassKey'] = self.class_key
        if self.name_key is not None:
            result['NameKey'] = self.name_key
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Alias') is not None:
            self.alias = m.get('Alias')
        self.baseline_item_list = []
        if m.get('BaselineItemList') is not None:
            for k in m.get('BaselineItemList'):
                temp_model = DescribeAllImageBaselineResponseBodyImageBaselinesBaselineClassListBaselineNameListBaselineItemList()
                self.baseline_item_list.append(temp_model.from_map(k))
        if m.get('ClassKey') is not None:
            self.class_key = m.get('ClassKey')
        if m.get('NameKey') is not None:
            self.name_key = m.get('NameKey')
        return self


class DescribeAllImageBaselineResponseBodyImageBaselinesBaselineClassList(TeaModel):
    def __init__(
        self,
        alias: str = None,
        baseline_name_list: List[DescribeAllImageBaselineResponseBodyImageBaselinesBaselineClassListBaselineNameList] = None,
        class_key: str = None,
    ):
        self.alias = alias
        self.baseline_name_list = baseline_name_list
        self.class_key = class_key

    def validate(self):
        if self.baseline_name_list:
            for k in self.baseline_name_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alias is not None:
            result['Alias'] = self.alias
        result['BaselineNameList'] = []
        if self.baseline_name_list is not None:
            for k in self.baseline_name_list:
                result['BaselineNameList'].append(k.to_map() if k else None)
        if self.class_key is not None:
            result['ClassKey'] = self.class_key
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Alias') is not None:
            self.alias = m.get('Alias')
        self.baseline_name_list = []
        if m.get('BaselineNameList') is not None:
            for k in m.get('BaselineNameList'):
                temp_model = DescribeAllImageBaselineResponseBodyImageBaselinesBaselineClassListBaselineNameList()
                self.baseline_name_list.append(temp_model.from_map(k))
        if m.get('ClassKey') is not None:
            self.class_key = m.get('ClassKey')
        return self


class DescribeAllImageBaselineResponseBodyImageBaselines(TeaModel):
    def __init__(
        self,
        baseline_class_list: List[DescribeAllImageBaselineResponseBodyImageBaselinesBaselineClassList] = None,
    ):
        self.baseline_class_list = baseline_class_list

    def validate(self):
        if self.baseline_class_list:
            for k in self.baseline_class_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['BaselineClassList'] = []
        if self.baseline_class_list is not None:
            for k in self.baseline_class_list:
                result['BaselineClassList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.baseline_class_list = []
        if m.get('BaselineClassList') is not None:
            for k in m.get('BaselineClassList'):
                temp_model = DescribeAllImageBaselineResponseBodyImageBaselinesBaselineClassList()
                self.baseline_class_list.append(temp_model.from_map(k))
        return self


class DescribeAllImageBaselineResponseBody(TeaModel):
    def __init__(
        self,
        image_baselines: DescribeAllImageBaselineResponseBodyImageBaselines = None,
        request_id: str = None,
    ):
        self.image_baselines = image_baselines
        self.request_id = request_id

    def validate(self):
        if self.image_baselines:
            self.image_baselines.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.image_baselines is not None:
            result['ImageBaselines'] = self.image_baselines.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ImageBaselines') is not None:
            temp_model = DescribeAllImageBaselineResponseBodyImageBaselines()
            self.image_baselines = temp_model.from_map(m['ImageBaselines'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeAllImageBaselineResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeAllImageBaselineResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeAllImageBaselineResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAntiBruteForceRulesRequest(TeaModel):
    def __init__(
        self,
        id: int = None,
        resource_owner_id: int = None,
        source_ip: str = None,
    ):
        self.id = id
        self.resource_owner_id = resource_owner_id
        # The source IP address of the request.
        self.source_ip = source_ip

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        return self


class DescribeAntiBruteForceRulesResponseBodyPageInfo(TeaModel):
    def __init__(
        self,
        count: int = None,
        current_page: int = None,
        page_size: int = None,
        total_count: int = None,
    ):
        # The number of entries returned on the current page.
        self.count = count
        # The page number of the returned page.
        self.current_page = current_page
        # The number of entries returned per page.
        self.page_size = page_size
        # The total number of entries returned.
        self.total_count = total_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeAntiBruteForceRulesResponseBodyRules(TeaModel):
    def __init__(
        self,
        default_rule: bool = None,
        enable_smart_rule: bool = None,
        fail_count: int = None,
        forbidden_time: int = None,
        id: int = None,
        machine_count: int = None,
        name: str = None,
        span: int = None,
        uuid_list: List[str] = None,
    ):
        # Indicates whether the defense rule is the default rule. Valid values:
        # 
        # *   **true**: yes
        # *   **false**: no
        # 
        # >  The default rule takes effect on all servers that are not protected by defense rules against brute-force attacks.
        self.default_rule = default_rule
        # This parameter is deprecated.
        self.enable_smart_rule = enable_smart_rule
        # The threshold of logon failures that you specify.
        self.fail_count = fail_count
        # The period of time during which logons from an account are not allowed. Unit: minutes.
        self.forbidden_time = forbidden_time
        # The ID of the defense rule.
        self.id = id
        # The number of servers to which the defense rule is applied.
        self.machine_count = machine_count
        # The name of the defense rule.
        self.name = name
        # The period of time during which logon failures from an account are measured. Unit: minutes. If **Span** is set to 10, the defense rule takes effect when the logon failures measured within 10 minutes reaches the specified threshold. The IP address of attackers cannot be used to log on to the server in the specified period of time.
        self.span = span
        # An array consisting of the UUIDs of servers to which the defense rule is applied.
        self.uuid_list = uuid_list

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.default_rule is not None:
            result['DefaultRule'] = self.default_rule
        if self.enable_smart_rule is not None:
            result['EnableSmartRule'] = self.enable_smart_rule
        if self.fail_count is not None:
            result['FailCount'] = self.fail_count
        if self.forbidden_time is not None:
            result['ForbiddenTime'] = self.forbidden_time
        if self.id is not None:
            result['Id'] = self.id
        if self.machine_count is not None:
            result['MachineCount'] = self.machine_count
        if self.name is not None:
            result['Name'] = self.name
        if self.span is not None:
            result['Span'] = self.span
        if self.uuid_list is not None:
            result['UuidList'] = self.uuid_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DefaultRule') is not None:
            self.default_rule = m.get('DefaultRule')
        if m.get('EnableSmartRule') is not None:
            self.enable_smart_rule = m.get('EnableSmartRule')
        if m.get('FailCount') is not None:
            self.fail_count = m.get('FailCount')
        if m.get('ForbiddenTime') is not None:
            self.forbidden_time = m.get('ForbiddenTime')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('MachineCount') is not None:
            self.machine_count = m.get('MachineCount')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Span') is not None:
            self.span = m.get('Span')
        if m.get('UuidList') is not None:
            self.uuid_list = m.get('UuidList')
        return self


class DescribeAntiBruteForceRulesResponseBody(TeaModel):
    def __init__(
        self,
        page_info: DescribeAntiBruteForceRulesResponseBodyPageInfo = None,
        request_id: str = None,
        rules: List[DescribeAntiBruteForceRulesResponseBodyRules] = None,
    ):
        # The pagination information.
        self.page_info = page_info
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id
        # An array that consists of the defense rules returned.
        self.rules = rules

    def validate(self):
        if self.page_info:
            self.page_info.validate()
        if self.rules:
            for k in self.rules:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_info is not None:
            result['PageInfo'] = self.page_info.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['Rules'] = []
        if self.rules is not None:
            for k in self.rules:
                result['Rules'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageInfo') is not None:
            temp_model = DescribeAntiBruteForceRulesResponseBodyPageInfo()
            self.page_info = temp_model.from_map(m['PageInfo'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.rules = []
        if m.get('Rules') is not None:
            for k in m.get('Rules'):
                temp_model = DescribeAntiBruteForceRulesResponseBodyRules()
                self.rules.append(temp_model.from_map(k))
        return self


class DescribeAntiBruteForceRulesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeAntiBruteForceRulesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeAntiBruteForceRulesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAppVulScanCycleResponseBody(TeaModel):
    def __init__(
        self,
        cycle: str = None,
        request_id: str = None,
    ):
        self.cycle = cycle
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cycle is not None:
            result['Cycle'] = self.cycle
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Cycle') is not None:
            self.cycle = m.get('Cycle')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeAppVulScanCycleResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeAppVulScanCycleResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeAppVulScanCycleResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAssetDetailByUuidRequest(TeaModel):
    def __init__(
        self,
        lang: str = None,
        source_ip: str = None,
        uuid: str = None,
    ):
        # The language of the content within the request and response. Default value: **zh**. Valid values:
        # 
        # *   **zh**: Chinese
        # *   **en**: English
        self.lang = lang
        # The source IP address of the request.
        self.source_ip = source_ip
        # The UUID of the server to query.
        # 
        # >  You can call the [DescribeCloudCenterInstances](~~DescribeCloudCenterInstances~~) operation to query the UUIDs of servers.
        self.uuid = uuid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class DescribeAssetDetailByUuidResponseBodyAssetDetail(TeaModel):
    def __init__(
        self,
        asset_type: str = None,
        auth_modify_time: int = None,
        auth_version: int = None,
        bind: bool = None,
        client_status: str = None,
        client_version: str = None,
        cpu: int = None,
        cpu_info: str = None,
        create_time: int = None,
        disk_info_list: List[str] = None,
        flag: int = None,
        group_trace: str = None,
        host_name: str = None,
        instance_id: str = None,
        instance_name: str = None,
        internet_ip: str = None,
        intranet_ip: str = None,
        ip: str = None,
        ip_list: List[str] = None,
        kernel: str = None,
        mac_list: List[str] = None,
        mem: int = None,
        memory: int = None,
        os: str = None,
        os_detail: str = None,
        os_name: str = None,
        region: str = None,
        region_id: str = None,
        region_name: str = None,
        sys_info: str = None,
        tag: str = None,
        uuid: str = None,
        vpc_instance_id: str = None,
    ):
        # The type of the asset. Valid values:
        # 
        # *   **0**: ECS instance
        # *   **1**: Server Load Balancer (SLB) instance
        # *   **2**: NAT gateway
        # *   **3**: ApsaraDB RDS database
        # *   **4**: ApsaraDB for MongoDB database
        # *   **5**: ApsaraDB for Redis database
        # *   **6**: image
        # *   **7**: container
        self.asset_type = asset_type
        # The timestamp when Security Center is authorized to protect the asset. Unit: milliseconds.
        self.auth_modify_time = auth_modify_time
        # The edition of Security Center that is authorized to protect the asset. Valid values:
        # 
        # *   **1**: Basic edition (Unauthorized)
        # *   **6**: Anti-virus edition
        # *   **5**: Advanced edition
        # *   **3**: Enterprise edition
        # *   **7**: Ultimate edition
        # *   **10**: Value-added Plan edition
        self.auth_version = auth_version
        # Indicates whether Security Center is authorized to protect the asset. Valid values:
        # 
        # *   **true**: yes
        # *   **false**: no
        self.bind = bind
        # The status of the Security Center agent. Valid values:
        # 
        # *   **pause**: The Security Center agent suspends protection for your server.
        # *   **online**: The Security Center agent is protecting your server.
        # *   **offline**: The Security Center agent does not protect your server.
        self.client_status = client_status
        # The version of the Security Center agent.
        self.client_version = client_version
        # The number of CPU cores.
        self.cpu = cpu
        # The details of the CPU.
        self.cpu_info = cpu_info
        # The timestamp when Security Center records the details of the server. Unit: milliseconds.
        self.create_time = create_time
        # An array that consists of the information about the disk.
        self.disk_info_list = disk_info_list
        # Indicates whether the asset is provided by Alibaba Cloud. Valid values:
        # 
        # *   **0**: yes
        # *   **1**: no
        self.flag = flag
        # The group to which the server belongs. By default, the servers that are not grouped belong to the **Default** group.
        self.group_trace = group_trace
        # The name of the host.
        self.host_name = host_name
        # The ID of the server.
        self.instance_id = instance_id
        # The name of the server.
        self.instance_name = instance_name
        # The public IP address of the server.
        self.internet_ip = internet_ip
        # The private IP address of the server.
        self.intranet_ip = intranet_ip
        # The IP address that is assigned to the Elastic Compute Service (ECS) instance.
        self.ip = ip
        # The IP addresses of the server.
        self.ip_list = ip_list
        # The kernel version of the operating system.
        self.kernel = kernel
        # The media access control (MAC) addresses of the server.
        self.mac_list = mac_list
        # The memory size of the server. Unit: GB.
        self.mem = mem
        # The memory size of the server. Unit: MB.
        self.memory = memory
        # The operating system type of the server.
        self.os = os
        # The operating system version of the server.
        self.os_detail = os_detail
        # The name of the operating system.
        self.os_name = os_name
        # The region in which the server resides.
        self.region = region
        # The ID of the region in which the asset resides.
        self.region_id = region_id
        # The name of the region in which the server resides.
        self.region_name = region_name
        # The operating system information about the server.
        self.sys_info = sys_info
        # The tag that is added to the server.
        self.tag = tag
        # The UUID of the server.
        self.uuid = uuid
        # The ID of the virtual private cloud (VPC) in which the server resides.
        self.vpc_instance_id = vpc_instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.asset_type is not None:
            result['AssetType'] = self.asset_type
        if self.auth_modify_time is not None:
            result['AuthModifyTime'] = self.auth_modify_time
        if self.auth_version is not None:
            result['AuthVersion'] = self.auth_version
        if self.bind is not None:
            result['Bind'] = self.bind
        if self.client_status is not None:
            result['ClientStatus'] = self.client_status
        if self.client_version is not None:
            result['ClientVersion'] = self.client_version
        if self.cpu is not None:
            result['Cpu'] = self.cpu
        if self.cpu_info is not None:
            result['CpuInfo'] = self.cpu_info
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.disk_info_list is not None:
            result['DiskInfoList'] = self.disk_info_list
        if self.flag is not None:
            result['Flag'] = self.flag
        if self.group_trace is not None:
            result['GroupTrace'] = self.group_trace
        if self.host_name is not None:
            result['HostName'] = self.host_name
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.internet_ip is not None:
            result['InternetIp'] = self.internet_ip
        if self.intranet_ip is not None:
            result['IntranetIp'] = self.intranet_ip
        if self.ip is not None:
            result['Ip'] = self.ip
        if self.ip_list is not None:
            result['IpList'] = self.ip_list
        if self.kernel is not None:
            result['Kernel'] = self.kernel
        if self.mac_list is not None:
            result['MacList'] = self.mac_list
        if self.mem is not None:
            result['Mem'] = self.mem
        if self.memory is not None:
            result['Memory'] = self.memory
        if self.os is not None:
            result['Os'] = self.os
        if self.os_detail is not None:
            result['OsDetail'] = self.os_detail
        if self.os_name is not None:
            result['OsName'] = self.os_name
        if self.region is not None:
            result['Region'] = self.region
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.region_name is not None:
            result['RegionName'] = self.region_name
        if self.sys_info is not None:
            result['SysInfo'] = self.sys_info
        if self.tag is not None:
            result['Tag'] = self.tag
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        if self.vpc_instance_id is not None:
            result['VpcInstanceId'] = self.vpc_instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AssetType') is not None:
            self.asset_type = m.get('AssetType')
        if m.get('AuthModifyTime') is not None:
            self.auth_modify_time = m.get('AuthModifyTime')
        if m.get('AuthVersion') is not None:
            self.auth_version = m.get('AuthVersion')
        if m.get('Bind') is not None:
            self.bind = m.get('Bind')
        if m.get('ClientStatus') is not None:
            self.client_status = m.get('ClientStatus')
        if m.get('ClientVersion') is not None:
            self.client_version = m.get('ClientVersion')
        if m.get('Cpu') is not None:
            self.cpu = m.get('Cpu')
        if m.get('CpuInfo') is not None:
            self.cpu_info = m.get('CpuInfo')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('DiskInfoList') is not None:
            self.disk_info_list = m.get('DiskInfoList')
        if m.get('Flag') is not None:
            self.flag = m.get('Flag')
        if m.get('GroupTrace') is not None:
            self.group_trace = m.get('GroupTrace')
        if m.get('HostName') is not None:
            self.host_name = m.get('HostName')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('InternetIp') is not None:
            self.internet_ip = m.get('InternetIp')
        if m.get('IntranetIp') is not None:
            self.intranet_ip = m.get('IntranetIp')
        if m.get('Ip') is not None:
            self.ip = m.get('Ip')
        if m.get('IpList') is not None:
            self.ip_list = m.get('IpList')
        if m.get('Kernel') is not None:
            self.kernel = m.get('Kernel')
        if m.get('MacList') is not None:
            self.mac_list = m.get('MacList')
        if m.get('Mem') is not None:
            self.mem = m.get('Mem')
        if m.get('Memory') is not None:
            self.memory = m.get('Memory')
        if m.get('Os') is not None:
            self.os = m.get('Os')
        if m.get('OsDetail') is not None:
            self.os_detail = m.get('OsDetail')
        if m.get('OsName') is not None:
            self.os_name = m.get('OsName')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('RegionName') is not None:
            self.region_name = m.get('RegionName')
        if m.get('SysInfo') is not None:
            self.sys_info = m.get('SysInfo')
        if m.get('Tag') is not None:
            self.tag = m.get('Tag')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        if m.get('VpcInstanceId') is not None:
            self.vpc_instance_id = m.get('VpcInstanceId')
        return self


class DescribeAssetDetailByUuidResponseBody(TeaModel):
    def __init__(
        self,
        asset_detail: DescribeAssetDetailByUuidResponseBodyAssetDetail = None,
        request_id: str = None,
    ):
        # The details of the server.
        self.asset_detail = asset_detail
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id

    def validate(self):
        if self.asset_detail:
            self.asset_detail.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.asset_detail is not None:
            result['AssetDetail'] = self.asset_detail.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AssetDetail') is not None:
            temp_model = DescribeAssetDetailByUuidResponseBodyAssetDetail()
            self.asset_detail = temp_model.from_map(m['AssetDetail'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeAssetDetailByUuidResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeAssetDetailByUuidResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeAssetDetailByUuidResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAssetDetailByUuidsRequest(TeaModel):
    def __init__(
        self,
        lang: str = None,
        uuids: str = None,
    ):
        # The language of the content within the request and response. Default value: **zh**. Valid values:
        # 
        # *   **zh**: Chinese
        # *   **en**: English
        self.lang = lang
        # The UUIDs of the ECS instances. Separate multiple UUIDs with commas (,).
        self.uuids = uuids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.uuids is not None:
            result['Uuids'] = self.uuids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('Uuids') is not None:
            self.uuids = m.get('Uuids')
        return self


class DescribeAssetDetailByUuidsResponseBodyAssetList(TeaModel):
    def __init__(
        self,
        asset_type: str = None,
        client_status: str = None,
        flag: int = None,
        instance_id: str = None,
        instance_name: str = None,
        internet_ip: str = None,
        intranet_ip: str = None,
        ip: str = None,
        os: str = None,
        os_name: str = None,
        region: str = None,
        region_id: str = None,
        region_name: str = None,
        uuid: str = None,
        vpc_instance_id: str = None,
    ):
        # The type of the asset.
        # 
        # The value is fixed as **0**, which indicates ECS instances.
        self.asset_type = asset_type
        # The status of the Security Center agent. Valid values:
        # 
        # *   **online**\
        # *   **offline**\
        self.client_status = client_status
        # The type of the asset by source. Valid values:
        # 
        # *   **0**: The asset is provided by Alibaba Cloud.
        # *   **1**: The asset is not provided by Alibaba Cloud.
        # *   **2**: The asset resides in a data center.
        # *   **3**, **4**, **5**, and **7**: other cloud asset.
        # *   **8**: light-weight assets.
        self.flag = flag
        # The ID of the ECS instance.
        self.instance_id = instance_id
        # The name of the ECS instance.
        self.instance_name = instance_name
        # The public IP address of the ECS instance.
        self.internet_ip = internet_ip
        # The private IP address of the ECS instance.
        self.intranet_ip = intranet_ip
        # The IP address of the ECS instance.
        # 
        # >  If the ECS instance has a public IP address, the value of this parameter is the public IP address of the ECS instance. If the ECS instance does not have a public IP address, the value of this parameter is the private IP address of the ECS instance.
        self.ip = ip
        # The operating system of the ECS instance.
        self.os = os
        # The name of the operating system run by the ECS instance.
        self.os_name = os_name
        # The region in which the ECS instance resides.
        self.region = region
        # The region in which the ECS instance resides.
        # 
        # >  For more information about the mapping between region IDs and region names, see [Regions and zones](~~40654~~).
        self.region_id = region_id
        # The name of the region in which the ECS instance resides.
        self.region_name = region_name
        # The UUID of the ECS instance.
        self.uuid = uuid
        # The ID of the virtual private cloud (VPC).
        self.vpc_instance_id = vpc_instance_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.asset_type is not None:
            result['AssetType'] = self.asset_type
        if self.client_status is not None:
            result['ClientStatus'] = self.client_status
        if self.flag is not None:
            result['Flag'] = self.flag
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.internet_ip is not None:
            result['InternetIp'] = self.internet_ip
        if self.intranet_ip is not None:
            result['IntranetIp'] = self.intranet_ip
        if self.ip is not None:
            result['Ip'] = self.ip
        if self.os is not None:
            result['Os'] = self.os
        if self.os_name is not None:
            result['OsName'] = self.os_name
        if self.region is not None:
            result['Region'] = self.region
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.region_name is not None:
            result['RegionName'] = self.region_name
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        if self.vpc_instance_id is not None:
            result['VpcInstanceId'] = self.vpc_instance_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AssetType') is not None:
            self.asset_type = m.get('AssetType')
        if m.get('ClientStatus') is not None:
            self.client_status = m.get('ClientStatus')
        if m.get('Flag') is not None:
            self.flag = m.get('Flag')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('InternetIp') is not None:
            self.internet_ip = m.get('InternetIp')
        if m.get('IntranetIp') is not None:
            self.intranet_ip = m.get('IntranetIp')
        if m.get('Ip') is not None:
            self.ip = m.get('Ip')
        if m.get('Os') is not None:
            self.os = m.get('Os')
        if m.get('OsName') is not None:
            self.os_name = m.get('OsName')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('RegionName') is not None:
            self.region_name = m.get('RegionName')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        if m.get('VpcInstanceId') is not None:
            self.vpc_instance_id = m.get('VpcInstanceId')
        return self


class DescribeAssetDetailByUuidsResponseBody(TeaModel):
    def __init__(
        self,
        asset_list: List[DescribeAssetDetailByUuidsResponseBodyAssetList] = None,
        request_id: str = None,
    ):
        # An array that consists of the details of the ECS instances.
        self.asset_list = asset_list
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id

    def validate(self):
        if self.asset_list:
            for k in self.asset_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AssetList'] = []
        if self.asset_list is not None:
            for k in self.asset_list:
                result['AssetList'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.asset_list = []
        if m.get('AssetList') is not None:
            for k in m.get('AssetList'):
                temp_model = DescribeAssetDetailByUuidsResponseBodyAssetList()
                self.asset_list.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeAssetDetailByUuidsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeAssetDetailByUuidsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeAssetDetailByUuidsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAssetSummaryResponseBodyAssetsSummary(TeaModel):
    def __init__(
        self,
        total_asset_all_region: int = None,
        total_core_all_region: int = None,
        total_core_num: int = None,
    ):
        # The total number of protected assets in all regions.
        self.total_asset_all_region = total_asset_all_region
        # The total number of cores of protected assets in all regions.
        self.total_core_all_region = total_core_all_region
        # The total number of cores of protected assets in the current region.
        self.total_core_num = total_core_num

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.total_asset_all_region is not None:
            result['TotalAssetAllRegion'] = self.total_asset_all_region
        if self.total_core_all_region is not None:
            result['TotalCoreAllRegion'] = self.total_core_all_region
        if self.total_core_num is not None:
            result['TotalCoreNum'] = self.total_core_num
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('TotalAssetAllRegion') is not None:
            self.total_asset_all_region = m.get('TotalAssetAllRegion')
        if m.get('TotalCoreAllRegion') is not None:
            self.total_core_all_region = m.get('TotalCoreAllRegion')
        if m.get('TotalCoreNum') is not None:
            self.total_core_num = m.get('TotalCoreNum')
        return self


class DescribeAssetSummaryResponseBody(TeaModel):
    def __init__(
        self,
        assets_summary: DescribeAssetSummaryResponseBodyAssetsSummary = None,
        request_id: str = None,
    ):
        # The statistical information about the assets.
        self.assets_summary = assets_summary
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id

    def validate(self):
        if self.assets_summary:
            self.assets_summary.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.assets_summary is not None:
            result['AssetsSummary'] = self.assets_summary.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AssetsSummary') is not None:
            temp_model = DescribeAssetSummaryResponseBodyAssetsSummary()
            self.assets_summary = temp_model.from_map(m['AssetsSummary'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeAssetSummaryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeAssetSummaryResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeAssetSummaryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAttackAnalysisDataRequest(TeaModel):
    def __init__(
        self,
        base_64: str = None,
        current_page: int = None,
        data: str = None,
        end_time: int = None,
        lang: str = None,
        page_size: int = None,
        start_time: int = None,
        type: str = None,
    ):
        # Specifies whether to encode the value of the **client_url** field in the query results by using the Base64 algorithm. Valid values:
        # 
        # *   **true**: yes
        # *   **false**: no
        self.base_64 = base_64
        # The number of the page to return. Pages start from page **1**.
        # 
        # >  If the Type parameter is set to **DETAILS**, you must specify the CurrentPage parameter.
        self.current_page = current_page
        # The condition that is used to filter attack events.
        # 
        # >  The following list describes the valid values of crack_type:
        # 
        # *   3: brute-force attack on MySQL
        # 
        # *   4: FTP brute-force attack
        # 
        # *   5: SSH brute-force attack
        # 
        # *   6: RDP brute-force attack
        # 
        # *   9: brute-force attack on Microsoft SQL Server
        # 
        # *   101: intercepted attack on Java Struts 2
        # 
        # *   102: intercepted attack on Redis
        # 
        # *   103: communication with AntSword Webshell
        # 
        # *   104: communication with China Chopper Webshell
        # 
        # *   133: communication with XISE Webshell
        # 
        # *   sqli: SQL injection
        # 
        # *   codei: code execution
        # 
        # *   xss: cross-site scripting (XSS)
        # 
        # *   lfi: local file inclusion
        # 
        # *   rfi: remote file inclusion
        # 
        # *   webshell: trojan script
        # 
        # *   upload: vulnerability upload
        # 
        # *   path: directory traversal
        # 
        # *   bypass: unauthorized access
        # 
        # *   csrf: cross-site request forgery (CSRF)
        # 
        # *   crlf: carriage return line feed (CRLF)
        # 
        # *   other: others
        self.data = data
        # The timestamp when the attack stops. Unit: seconds.
        self.end_time = end_time
        # The language of the content within the request and response. Default value: **zh**. Valid values:
        # 
        # *   **zh**: Chinese
        # *   **en**: English
        self.lang = lang
        # The number of entries to return on each page.
        # 
        # >  If the Type parameter is set to **DETAILS**, you must specify the PageSize parameter.
        self.page_size = page_size
        # The timestamp at which the attack starts. By default, the statistics of the previous seven days are queried. Unit: seconds.
        # 
        # >  The start time that you specify must be within the previous 40 days.
        self.start_time = start_time
        # The details of attack analysis. Valid values:
        # 
        # *   **TOTAL**: number of attacks
        # *   **TREND**: attack trend
        # *   **PIE_CHART**: distribution of attacks by type
        # *   **SOURCE_TOP**: top 5 attack sources
        # *   **CLIENT_TOP**: top 5 attacked assets
        # *   **DETAILS**: attack details
        # 
        # >  If the Type parameter is set to **DETAILS**, you must specify the CurrentPage and PageSize parameters.
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.base_64 is not None:
            result['Base64'] = self.base_64
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.data is not None:
            result['Data'] = self.data
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Base64') is not None:
            self.base_64 = m.get('Base64')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribeAttackAnalysisDataResponseBody(TeaModel):
    def __init__(
        self,
        data: str = None,
        page: int = None,
        page_size: int = None,
        request_id: str = None,
        total: int = None,
    ):
        # The attack events. The value contains the following fields:
        # 
        # *   **client_url**: the URL of the attack request.
        # 
        # *   **internetIp**: the IP address of the asset.
        # 
        # *   **instanceName**: the name of the asset.
        # 
        # *   **table_src**: the source of data.
        # 
        # *   **uuid**: the UUID of the asset.
        # 
        # *   **crack_method**: the method of the attack request.
        # 
        # *   **crack_hour**: the attack time.
        # 
        # *   **crack_src_ip**: the IP address from which the attack is launched.
        # 
        # *   **instanceId**: the ID of the asset.
        # 
        # *   **dst_port**: the attacked port.
        # 
        # *   **client_ip**: the attacked IP address.
        # 
        # *   **location**: the region from which the attack is launched.
        # 
        # *   **aliuid**: the ID of the Alibaba Cloud account.
        # 
        # *   **crack_cnt**: the number of times that the attack is launched.
        # 
        # *   **crack_type**: the type of the attack. Valid values:
        # 
        #     *   **113**: improper authorization
        #     *   **112**: redirection attack
        #     *   **upload**: vulnerability upload
        #     *   **other**: others
        #     *   **webshell**: trojan script
        #     *   **201**: suspicious connection
        #     *   **9**: brute-force attack on Microsoft SQL Server
        #     *   **5**: SSH brute-force attack
        #     *   **6**: RDP brute-force attack
        #     *   **lfi**: local file inclusion
        #     *   **7**: code execution
        #     *   **sqli**: SQL injection
        #     *   **209**: web attack
        #     *   **31**: buffer overflow
        #     *   **3**: brute-force attack on MySQL
        #     *   **30**: clickjacking
        #     *   **4**: FTP brute-force attack
        #     *   **bypass**: unauthorized access
        #     *   **33**: format string
        #     *   **deeplearning**: others
        #     *   **32**: integer overflow
        #     *   **203**: brute-force attack
        #     *   **34**: race condition
        #     *   **rfi**: remote file inclusion
        #     *   **0**: SQL injection
        #     *   **212**: mining behavior
        #     *   **213**: reverse shell
        #     *   **211**: worm
        #     *   **61**: session timeout
        #     *   **20**: directory traversal
        #     *   **xss**: XSS
        #     *   **22**: unauthorized access
        #     *   **21**: scan attack
        #     *   **24**: file modification
        #     *   **26**: file deletion
        #     *   **25**: file reading
        #     *   **28**: CRLF injection
        #     *   **27**: logic error
        #     *   **29**: template injection
        #     *   **csrf**: CSRF
        #     *   **path**: directory traversal
        #     *   **crlf**: CRLF
        #     *   **102**: CSRF
        #     *   **103**: server-side request forgery (SSRF)
        #     *   **101**: XSS
        #     *   **11**: file inclusion
        #     *   **10**: file upload
        #     *   **12**: vulnerability upload
        #     *   **15**: unauthorized access
        #     *   **14**: information leakage
        #     *   **17**: XML entity injection
        #     *   **16**: insecure configuration
        #     *   **19**: Lightweight Directory Access Protocol (LDAP) injection
        #     *   **18**: XPath injection
        #     *   **codei**: code execution
        self.data = data
        # The page number of the returned page.
        self.page = page
        # The number of entries returned per page. Default value: 10.
        self.page_size = page_size
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id
        # The total number of attack events returned.
        self.total = total

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data
        if self.page is not None:
            result['Page'] = self.page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            self.data = m.get('Data')
        if m.get('Page') is not None:
            self.page = m.get('Page')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class DescribeAttackAnalysisDataResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeAttackAnalysisDataResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeAttackAnalysisDataResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeAutoDelConfigResponseBody(TeaModel):
    def __init__(
        self,
        days: int = None,
        request_id: str = None,
    ):
        # The number of days during which a detected vulnerability is retained before the vulnerability is automatically deleted.
        self.days = days
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.days is not None:
            result['Days'] = self.days
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Days') is not None:
            self.days = m.get('Days')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeAutoDelConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeAutoDelConfigResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeAutoDelConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeBackUpExportInfoRequest(TeaModel):
    def __init__(
        self,
        current_page: int = None,
        export_type: str = None,
        lang: str = None,
        page_size: int = None,
    ):
        self.current_page = current_page
        self.export_type = export_type
        self.lang = lang
        self.page_size = page_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.export_type is not None:
            result['ExportType'] = self.export_type
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('ExportType') is not None:
            self.export_type = m.get('ExportType')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class DescribeBackUpExportInfoResponseBodyData(TeaModel):
    def __init__(
        self,
        current_count: int = None,
        file_name: str = None,
        gmt_create: int = None,
        id: int = None,
        link: str = None,
        message: str = None,
        progress: int = None,
        status: str = None,
        total_count: int = None,
    ):
        self.current_count = current_count
        self.file_name = file_name
        self.gmt_create = gmt_create
        self.id = id
        self.link = link
        self.message = message
        self.progress = progress
        self.status = status
        self.total_count = total_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_count is not None:
            result['CurrentCount'] = self.current_count
        if self.file_name is not None:
            result['FileName'] = self.file_name
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.id is not None:
            result['Id'] = self.id
        if self.link is not None:
            result['Link'] = self.link
        if self.message is not None:
            result['Message'] = self.message
        if self.progress is not None:
            result['Progress'] = self.progress
        if self.status is not None:
            result['Status'] = self.status
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentCount') is not None:
            self.current_count = m.get('CurrentCount')
        if m.get('FileName') is not None:
            self.file_name = m.get('FileName')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Link') is not None:
            self.link = m.get('Link')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Progress') is not None:
            self.progress = m.get('Progress')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeBackUpExportInfoResponseBodyPageInfo(TeaModel):
    def __init__(
        self,
        count: int = None,
        current_page: int = None,
        page_size: int = None,
        total_count: int = None,
    ):
        self.count = count
        self.current_page = current_page
        self.page_size = page_size
        self.total_count = total_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeBackUpExportInfoResponseBody(TeaModel):
    def __init__(
        self,
        data: List[DescribeBackUpExportInfoResponseBodyData] = None,
        page_info: DescribeBackUpExportInfoResponseBodyPageInfo = None,
        request_id: str = None,
    ):
        self.data = data
        self.page_info = page_info
        self.request_id = request_id

    def validate(self):
        if self.data:
            for k in self.data:
                if k:
                    k.validate()
        if self.page_info:
            self.page_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Data'] = []
        if self.data is not None:
            for k in self.data:
                result['Data'].append(k.to_map() if k else None)
        if self.page_info is not None:
            result['PageInfo'] = self.page_info.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.data = []
        if m.get('Data') is not None:
            for k in m.get('Data'):
                temp_model = DescribeBackUpExportInfoResponseBodyData()
                self.data.append(temp_model.from_map(k))
        if m.get('PageInfo') is not None:
            temp_model = DescribeBackUpExportInfoResponseBodyPageInfo()
            self.page_info = temp_model.from_map(m['PageInfo'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeBackUpExportInfoResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeBackUpExportInfoResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeBackUpExportInfoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeBackupClientsRequest(TeaModel):
    def __init__(
        self,
        support_region_id: str = None,
    ):
        # The region in which the anti-ransomware feature is supported.
        # > You can call the [DescribeSupportRegion](~~DescribeSupportRegion~~) operation to query the regions in which the anti-ransomware feature is supported.
        self.support_region_id = support_region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.support_region_id is not None:
            result['SupportRegionId'] = self.support_region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SupportRegionId') is not None:
            self.support_region_id = m.get('SupportRegionId')
        return self


class DescribeBackupClientsResponseBodyClients(TeaModel):
    def __init__(
        self,
        client_id: str = None,
        client_status: str = None,
        client_version: str = None,
        instance_id: str = None,
        uuid: str = None,
    ):
        # The ID of the anti-ransomware agent.
        self.client_id = client_id
        # The status of the anti-ransomware agent.
        # 
        # Valid values:
        # 
        # *   **INSTALLING**: The agent is being installed.
        # *   **ONLINE**: The agent is online.
        # *   **UNINSTALLING**: The agent is being uninstalled.
        # *   **NOT_INSTALLED**: The agent is not installed.
        # *   **ACTIVATED**: The agent is enabled.
        # *   **CLIENT\_CONNECTION_ERROR**: A connection error occurs on the agent.
        self.client_status = client_status
        # The version of the anti-ransomware agent.
        self.client_version = client_version
        # The ID of the ECS instance on which the anti-ransomware agent is installed.
        self.instance_id = instance_id
        # The UUID of the Elastic Compute Service (ECS) instance on which the anti-ransomware agent is installed.
        self.uuid = uuid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_id is not None:
            result['ClientId'] = self.client_id
        if self.client_status is not None:
            result['ClientStatus'] = self.client_status
        if self.client_version is not None:
            result['ClientVersion'] = self.client_version
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClientId') is not None:
            self.client_id = m.get('ClientId')
        if m.get('ClientStatus') is not None:
            self.client_status = m.get('ClientStatus')
        if m.get('ClientVersion') is not None:
            self.client_version = m.get('ClientVersion')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class DescribeBackupClientsResponseBody(TeaModel):
    def __init__(
        self,
        clients: List[DescribeBackupClientsResponseBodyClients] = None,
        request_id: str = None,
    ):
        # An array that consists of the information about the anti-ransomware agent.
        self.clients = clients
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id

    def validate(self):
        if self.clients:
            for k in self.clients:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Clients'] = []
        if self.clients is not None:
            for k in self.clients:
                result['Clients'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.clients = []
        if m.get('Clients') is not None:
            for k in m.get('Clients'):
                temp_model = DescribeBackupClientsResponseBodyClients()
                self.clients.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeBackupClientsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeBackupClientsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeBackupClientsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeBackupFilesRequest(TeaModel):
    def __init__(
        self,
        current_page: str = None,
        page_size: str = None,
        path: str = None,
        snapshot_hash: str = None,
        uuid: str = None,
    ):
        # The number of the page to return. Default value: **1**.
        self.current_page = current_page
        # The number of entries to return on each page. Default value: **10**.
        self.page_size = page_size
        # The path to the backup file.
        self.path = path
        # The hash value of the backup file.
        self.snapshot_hash = snapshot_hash
        # The UUID of the server to which an anti-ransomware policy is applied.
        self.uuid = uuid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.path is not None:
            result['Path'] = self.path
        if self.snapshot_hash is not None:
            result['SnapshotHash'] = self.snapshot_hash
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Path') is not None:
            self.path = m.get('Path')
        if m.get('SnapshotHash') is not None:
            self.snapshot_hash = m.get('SnapshotHash')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class DescribeBackupFilesResponseBodyBackupFiles(TeaModel):
    def __init__(
        self,
        name: str = None,
        size: int = None,
        subtree: str = None,
        type: str = None,
    ):
        # The name of the anti-ransomware policy.
        self.name = name
        # The size of the backup file. Unit: bytes.
        self.size = size
        # The path to the subdirectory of the backup file.
        self.subtree = subtree
        # The type of the protected file. Valid values:
        # 
        # *   **file**: files
        # *   **dir**: folders
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.size is not None:
            result['Size'] = self.size
        if self.subtree is not None:
            result['Subtree'] = self.subtree
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Size') is not None:
            self.size = m.get('Size')
        if m.get('Subtree') is not None:
            self.subtree = m.get('Subtree')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribeBackupFilesResponseBodyPageInfo(TeaModel):
    def __init__(
        self,
        count: int = None,
        current_page: int = None,
        page_size: int = None,
        total_count: int = None,
    ):
        # The number of backup files returned on the current page.
        self.count = count
        # The page number of the returned page.
        self.current_page = current_page
        # The number of entries returned per page. Default value: **10**.
        self.page_size = page_size
        # The total number of backup files returned.
        self.total_count = total_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeBackupFilesResponseBody(TeaModel):
    def __init__(
        self,
        backup_files: List[DescribeBackupFilesResponseBodyBackupFiles] = None,
        page_info: DescribeBackupFilesResponseBodyPageInfo = None,
        request_id: str = None,
    ):
        # An array that consists of the backup files returned.
        self.backup_files = backup_files
        # The pagination information.
        self.page_info = page_info
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id

    def validate(self):
        if self.backup_files:
            for k in self.backup_files:
                if k:
                    k.validate()
        if self.page_info:
            self.page_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['BackupFiles'] = []
        if self.backup_files is not None:
            for k in self.backup_files:
                result['BackupFiles'].append(k.to_map() if k else None)
        if self.page_info is not None:
            result['PageInfo'] = self.page_info.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.backup_files = []
        if m.get('BackupFiles') is not None:
            for k in m.get('BackupFiles'):
                temp_model = DescribeBackupFilesResponseBodyBackupFiles()
                self.backup_files.append(temp_model.from_map(k))
        if m.get('PageInfo') is not None:
            temp_model = DescribeBackupFilesResponseBodyPageInfo()
            self.page_info = temp_model.from_map(m['PageInfo'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeBackupFilesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeBackupFilesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeBackupFilesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeBackupMachineStatusRequest(TeaModel):
    def __init__(
        self,
        policy_id: int = None,
        policy_version: str = None,
        uuid: str = None,
    ):
        self.policy_id = policy_id
        self.policy_version = policy_version
        self.uuid = uuid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.policy_id is not None:
            result['PolicyId'] = self.policy_id
        if self.policy_version is not None:
            result['PolicyVersion'] = self.policy_version
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PolicyId') is not None:
            self.policy_id = m.get('PolicyId')
        if m.get('PolicyVersion') is not None:
            self.policy_version = m.get('PolicyVersion')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class DescribeBackupMachineStatusResponseBodyBackupMachineStatusErrorList(TeaModel):
    def __init__(
        self,
        error_code: str = None,
        error_status: str = None,
    ):
        self.error_code = error_code
        self.error_status = error_status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.error_status is not None:
            result['ErrorStatus'] = self.error_status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('ErrorStatus') is not None:
            self.error_status = m.get('ErrorStatus')
        return self


class DescribeBackupMachineStatusResponseBodyBackupMachineStatus(TeaModel):
    def __init__(
        self,
        client_id: str = None,
        client_status: str = None,
        client_version: str = None,
        error_code: str = None,
        error_list: List[DescribeBackupMachineStatusResponseBodyBackupMachineStatusErrorList] = None,
        instance_id: str = None,
        region_id: str = None,
        saved_backup_count: int = None,
        status: str = None,
        uuid: str = None,
        vault_id: str = None,
    ):
        self.client_id = client_id
        self.client_status = client_status
        self.client_version = client_version
        self.error_code = error_code
        self.error_list = error_list
        self.instance_id = instance_id
        self.region_id = region_id
        self.saved_backup_count = saved_backup_count
        self.status = status
        self.uuid = uuid
        self.vault_id = vault_id

    def validate(self):
        if self.error_list:
            for k in self.error_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_id is not None:
            result['ClientId'] = self.client_id
        if self.client_status is not None:
            result['ClientStatus'] = self.client_status
        if self.client_version is not None:
            result['ClientVersion'] = self.client_version
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        result['ErrorList'] = []
        if self.error_list is not None:
            for k in self.error_list:
                result['ErrorList'].append(k.to_map() if k else None)
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.saved_backup_count is not None:
            result['SavedBackupCount'] = self.saved_backup_count
        if self.status is not None:
            result['Status'] = self.status
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        if self.vault_id is not None:
            result['VaultId'] = self.vault_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClientId') is not None:
            self.client_id = m.get('ClientId')
        if m.get('ClientStatus') is not None:
            self.client_status = m.get('ClientStatus')
        if m.get('ClientVersion') is not None:
            self.client_version = m.get('ClientVersion')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        self.error_list = []
        if m.get('ErrorList') is not None:
            for k in m.get('ErrorList'):
                temp_model = DescribeBackupMachineStatusResponseBodyBackupMachineStatusErrorList()
                self.error_list.append(temp_model.from_map(k))
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('SavedBackupCount') is not None:
            self.saved_backup_count = m.get('SavedBackupCount')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        if m.get('VaultId') is not None:
            self.vault_id = m.get('VaultId')
        return self


class DescribeBackupMachineStatusResponseBody(TeaModel):
    def __init__(
        self,
        backup_machine_status: DescribeBackupMachineStatusResponseBodyBackupMachineStatus = None,
        request_id: str = None,
    ):
        self.backup_machine_status = backup_machine_status
        self.request_id = request_id

    def validate(self):
        if self.backup_machine_status:
            self.backup_machine_status.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.backup_machine_status is not None:
            result['BackupMachineStatus'] = self.backup_machine_status.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BackupMachineStatus') is not None:
            temp_model = DescribeBackupMachineStatusResponseBodyBackupMachineStatus()
            self.backup_machine_status = temp_model.from_map(m['BackupMachineStatus'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeBackupMachineStatusResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeBackupMachineStatusResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeBackupMachineStatusResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeBackupPoliciesRequest(TeaModel):
    def __init__(
        self,
        current_page: int = None,
        machine_remark: str = None,
        name: str = None,
        page_size: int = None,
        status: str = None,
    ):
        # The number of the page to return. Default value: 1.
        self.current_page = current_page
        # The information that you want to use to identify the servers protected by the anti-ransomware policy. You can enter the IP address or ID of a server.
        self.machine_remark = machine_remark
        # The name of the anti-ransomware policy that you want to query.
        self.name = name
        # The number of entries to return on each page. Default value: 10.
        self.page_size = page_size
        # The status of the anti-ransomware policy. Valid values:
        # 
        # *   **enabled**: The anti-ransomware policy is manually enabled.
        # *   **disabled**: The anti-ransomware policy is manually disabled. After an anti-ransomware policy is disabled, the data backup task that is running based on the policy stops.
        # *   **closed**: The anti-ransomware policy automatically stops because the anti-ransomware capacity is insufficient.
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.machine_remark is not None:
            result['MachineRemark'] = self.machine_remark
        if self.name is not None:
            result['Name'] = self.name
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('MachineRemark') is not None:
            self.machine_remark = m.get('MachineRemark')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DescribeBackupPoliciesResponseBodyPageInfo(TeaModel):
    def __init__(
        self,
        count: int = None,
        current_page: int = None,
        page_size: int = None,
        total_count: int = None,
    ):
        # The number of entries returned on the current page.
        self.count = count
        # The page number of the returned page.
        self.current_page = current_page
        # The number of entries returned per page. Default value: 10.
        self.page_size = page_size
        # The total number of anti-ransomware policies returned.
        self.total_count = total_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeBackupPoliciesResponseBodyPolicies(TeaModel):
    def __init__(
        self,
        client_error_count: int = None,
        client_error_uuid_list: List[str] = None,
        client_status: str = None,
        health_client_count: int = None,
        health_client_uuid_list: List[str] = None,
        id: int = None,
        name: str = None,
        policy: str = None,
        policy_region_id: str = None,
        policy_version: str = None,
        remarked_uuid_list: List[str] = None,
        server_type: str = None,
        service_error_count: int = None,
        service_error_uuid_list: List[str] = None,
        status: str = None,
        upgrade_status: str = None,
        uuid_list: List[str] = None,
    ):
        # The number of the servers on which the anti-ransomware agent is in an abnormal state.
        self.client_error_count = client_error_count
        # The UUIDs of the servers on which the anti-ransomware agent is in an **abnormal** state.
        self.client_error_uuid_list = client_error_uuid_list
        # The status of the anti-ransomware agent. Valid values:
        # 
        # *   **running**: normal
        # *   **exception**: abnormal
        self.client_status = client_status
        # The number of the servers on which the anti-ransomware agent is in a normal state.
        self.health_client_count = health_client_count
        # The UUIDs of the servers on which the anti-ransomware agent is in a **normal** state.
        self.health_client_uuid_list = health_client_uuid_list
        # The ID of the anti-ransomware policy.
        self.id = id
        # The name of the anti-ransomware policy.
        self.name = name
        # The configurations of the anti-ransomware policy. The value of this parameter is in the JSON format and contains the following fields:
        # 
        # *   **IsDefault**: the type of the anti-ransomware policy. Valid values:
        # 
        #     *   **1**: recommended policy
        #     *   **0**: custom policy
        # 
        # *   **Include**: the format of the files that are protected. If the value of this field is \[], all formats of files are protected.
        # 
        # *   **Source**: the directory that is protected. If the value of this field is \[], all directories are protected.
        # 
        # *   **ExcludeSystemPath**: indicates whether a specified directory is excluded from the anti-ransomware policy. If the value of this field is **true**, the directory is excluded. If this field is left empty, no directories are excluded.
        # 
        # *   **Exclude**: the directory that is excluded from the anti-ransomware policy. If no directory is specified, the value of this field is \[].
        # 
        # *   **Schedule**: the start time and interval of a data backup task. A start time that begins during off-peak hours but does not start on the hour is recommended. Examples:
        # 
        #     *   If the value of this field is I|1583216092|P21D, the data backup task starts from 2020-03-03 14:14:52, and the task is run at an interval of three weeks.
        #     *   If the value of this field is I|1583216092|PT24H, the data backup task starts from 2020-03-03 14:14:52, and the task is run at an interval of 24 hours.
        # 
        # *   **Retention**: the period during which backup data is retained. Unit: days. If the value of this field is 7, backup data is retained for a week. If the value of this field is 365, backup data is retained for a year. If the value of this field is -1, backup data is permanently retained.
        # 
        # *   **SpeedLimiter**: the limit on the network bandwidth for data backup tasks. If the value of this field is 0:24:30720, the maximum bandwidth for a data backup task is 30 MB/s from 00:00 to 24:00.
        # 
        # *   **UseVss**: indicates whether the VSS feature is enabled. The feature is available only for Windows servers. Valid values:
        # 
        #     *   **true**: yes
        #     *   **false**: no
        # 
        # >  The VSS feature is available only if you create the anti-ransomware policy for Windows servers. After you enable the feature, the number of backup failures due to running processes is significantly reduced. We recommend that you enable the VSS feature. After you enable the feature, the data of disks that are in the exFAT and FAT32 formats cannot be backed up.
        self.policy = policy
        # The ID of the region that you specified for data backup when you installed the anti-ransomware agent for the server not deployed on Alibaba Cloud.
        self.policy_region_id = policy_region_id
        # The version of the anti-ransomware policy. Valid values:
        # 
        # *   1.0.0
        # *   2.0.0
        self.policy_version = policy_version
        # The UUIDs that are returned based on the value of the MachineRemark request parameter.
        self.remarked_uuid_list = remarked_uuid_list
        # The type of the server. Valid values:
        # 
        # *   **OUT_CLOUD**: server not deployed on Alibaba Cloud
        # *   **ALIYUN**: Elastic Compute Service (ECS) instance
        # *   **TRIPARTITE**: simple application server
        self.server_type = server_type
        # The number of servers on which data backup is exceptional.
        self.service_error_count = service_error_count
        # The UUIDs of the servers on which data backup is exceptional.
        self.service_error_uuid_list = service_error_uuid_list
        # The status of the anti-ransomware policy. Valid values:
        # 
        # *   **enabled**: The anti-ransomware policy is manually enabled.
        # *   **disabled**: The anti-ransomware policy is manually disabled. After an anti-ransomware policy is disabled, the data backup task that is running based on the policy stops.
        # *   **closed**: The anti-ransomware policy automatically stops because the anti-ransomware capacity is insufficient.
        self.status = status
        # The upgrade status of the anti-ransomware policy. Valid values:
        # 
        # *   **NotUpgraded**\
        # *   **Upgrading**\
        # *   **UpgradeFailed**\
        # *   **UpgradeSuccess**\
        self.upgrade_status = upgrade_status
        # The UUIDs of the servers to which the anti-ransomware policy is applied.
        self.uuid_list = uuid_list

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_error_count is not None:
            result['ClientErrorCount'] = self.client_error_count
        if self.client_error_uuid_list is not None:
            result['ClientErrorUuidList'] = self.client_error_uuid_list
        if self.client_status is not None:
            result['ClientStatus'] = self.client_status
        if self.health_client_count is not None:
            result['HealthClientCount'] = self.health_client_count
        if self.health_client_uuid_list is not None:
            result['HealthClientUuidList'] = self.health_client_uuid_list
        if self.id is not None:
            result['Id'] = self.id
        if self.name is not None:
            result['Name'] = self.name
        if self.policy is not None:
            result['Policy'] = self.policy
        if self.policy_region_id is not None:
            result['PolicyRegionId'] = self.policy_region_id
        if self.policy_version is not None:
            result['PolicyVersion'] = self.policy_version
        if self.remarked_uuid_list is not None:
            result['RemarkedUuidList'] = self.remarked_uuid_list
        if self.server_type is not None:
            result['ServerType'] = self.server_type
        if self.service_error_count is not None:
            result['ServiceErrorCount'] = self.service_error_count
        if self.service_error_uuid_list is not None:
            result['ServiceErrorUuidList'] = self.service_error_uuid_list
        if self.status is not None:
            result['Status'] = self.status
        if self.upgrade_status is not None:
            result['UpgradeStatus'] = self.upgrade_status
        if self.uuid_list is not None:
            result['UuidList'] = self.uuid_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClientErrorCount') is not None:
            self.client_error_count = m.get('ClientErrorCount')
        if m.get('ClientErrorUuidList') is not None:
            self.client_error_uuid_list = m.get('ClientErrorUuidList')
        if m.get('ClientStatus') is not None:
            self.client_status = m.get('ClientStatus')
        if m.get('HealthClientCount') is not None:
            self.health_client_count = m.get('HealthClientCount')
        if m.get('HealthClientUuidList') is not None:
            self.health_client_uuid_list = m.get('HealthClientUuidList')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Policy') is not None:
            self.policy = m.get('Policy')
        if m.get('PolicyRegionId') is not None:
            self.policy_region_id = m.get('PolicyRegionId')
        if m.get('PolicyVersion') is not None:
            self.policy_version = m.get('PolicyVersion')
        if m.get('RemarkedUuidList') is not None:
            self.remarked_uuid_list = m.get('RemarkedUuidList')
        if m.get('ServerType') is not None:
            self.server_type = m.get('ServerType')
        if m.get('ServiceErrorCount') is not None:
            self.service_error_count = m.get('ServiceErrorCount')
        if m.get('ServiceErrorUuidList') is not None:
            self.service_error_uuid_list = m.get('ServiceErrorUuidList')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('UpgradeStatus') is not None:
            self.upgrade_status = m.get('UpgradeStatus')
        if m.get('UuidList') is not None:
            self.uuid_list = m.get('UuidList')
        return self


class DescribeBackupPoliciesResponseBody(TeaModel):
    def __init__(
        self,
        page_info: DescribeBackupPoliciesResponseBodyPageInfo = None,
        policies: List[DescribeBackupPoliciesResponseBodyPolicies] = None,
        request_id: str = None,
    ):
        # The pagination information.
        self.page_info = page_info
        # An array that consists of the anti-ransomware policies returned.
        self.policies = policies
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id

    def validate(self):
        if self.page_info:
            self.page_info.validate()
        if self.policies:
            for k in self.policies:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_info is not None:
            result['PageInfo'] = self.page_info.to_map()
        result['Policies'] = []
        if self.policies is not None:
            for k in self.policies:
                result['Policies'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageInfo') is not None:
            temp_model = DescribeBackupPoliciesResponseBodyPageInfo()
            self.page_info = temp_model.from_map(m['PageInfo'])
        self.policies = []
        if m.get('Policies') is not None:
            for k in m.get('Policies'):
                temp_model = DescribeBackupPoliciesResponseBodyPolicies()
                self.policies.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeBackupPoliciesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeBackupPoliciesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeBackupPoliciesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeBackupPolicyRequest(TeaModel):
    def __init__(
        self,
        id: int = None,
    ):
        # The ID of the anti-ransomware policy.
        # 
        # >  You can call the [DescribeBackupPolicies](~~DescribeBackupPolicies~~) operation to query the IDs of anti-ransomware policies.
        self.id = id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.id is not None:
            result['Id'] = self.id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Id') is not None:
            self.id = m.get('Id')
        return self


class DescribeBackupPolicyResponseBodyBackupPolicyDetail(TeaModel):
    def __init__(
        self,
        client_status: str = None,
        id: int = None,
        name: str = None,
        policy: str = None,
        policy_version: str = None,
        region_id: str = None,
        status: str = None,
        uuid_list: List[str] = None,
    ):
        # The status of the anti-ransomware agent. Valid values:
        # 
        # *   **running**: normal
        # *   **exception**: abnormal
        self.client_status = client_status
        # The ID of the anti-ransomware policy.
        self.id = id
        # The name of the anti-ransomware policy.
        self.name = name
        # *   **IsDefault**: the type of the anti-ransomware policy. Valid values:
        # 
        #     *   **1**: recommended policy
        #     *   **0**: custom policy
        # 
        # *   **Include**: the format of the files that you want to protect. If you want to protect the files in all formats, set this field to \[].
        # 
        # *   **Source**: the directory that you want to protect. If you want to protect all directories, set this field to \[].
        # 
        # *   **ExcludeSystemPath**: specifies whether to exclude a specific directory from the anti-ransomware policy. If you want to exclude a directory, set this field to **true**. If you do not want to exclude a directory, leave this field empty.
        # 
        # *   **Exclude**: the directory that you want to exclude from the anti-ransomware policy. If you do not want to exclude a directory, set this field to \[].
        # 
        # *   **Schedule**: the start time and interval of a data backup task. We recommend that you specify a start time that begins during off-peak hours but does not start on the hour. Examples:
        # 
        #     *   If you set this field to I|1583216092|P21D, the data backup task starts from 2020-03-03 14:14:52, and the task is run at an interval of three weeks.
        #     *   If you set this field to I|1583216092|PT24H, the data backup task starts from 2020-03-03 14:14:52, and the task is run at an interval of 24 hours.
        # 
        # *   **Retention**: the period during which backup data is retained. Unit: days. If you set this field to 7, backup data is retained for a week. If you set this field to 365, backup data is retained for a year. If you set this field to -1, backup data is permanently retained.
        # 
        # *   **SpeedLimiter**: the limit on the network bandwidth for data backup tasks. If you set this field to 0:24:30720, the maximum bandwidth for a data backup task is 30 MB/s from 00:00 to 24:00.
        # 
        # *   **UseVss**: specifies whether to enable the VSS feature. The feature is available only for Windows servers. Valid values:
        # 
        #     *   **true**: yes
        #     *   **false**: no
        # 
        # >  The VSS feature is available only if you create the anti-ransomware policy for Windows servers. After you enable the feature, the number of backup failures due to running processes is significantly reduced. We recommend that you enable the VSS feature. After you enable the feature, the data of disks that are in the exFAT and FAT32 formats cannot be backed up.
        self.policy = policy
        # The version of the anti-ransomware policy.
        # 
        # *   **1.0.0**\
        # *   **2.0.0**\
        self.policy_version = policy_version
        # The ID of the region in which backup data is stored.
        self.region_id = region_id
        # The status of the anti-ransomware policy. Valid values:
        # 
        # *   **enabled**: The anti-ransomware policy is manually enabled.
        # *   **disabled**: The anti-ransomware policy is manually disabled. After an anti-ransomware policy is disabled, the data backup task that is running based on the policy stops.
        # *   **closed**: The anti-ransomware policy automatically stops because the anti-ransomware capacity is insufficient.
        self.status = status
        # An array consisting of the UUIDs of the servers to which the anti-ransomware policy is applied.
        self.uuid_list = uuid_list

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_status is not None:
            result['ClientStatus'] = self.client_status
        if self.id is not None:
            result['Id'] = self.id
        if self.name is not None:
            result['Name'] = self.name
        if self.policy is not None:
            result['Policy'] = self.policy
        if self.policy_version is not None:
            result['PolicyVersion'] = self.policy_version
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.status is not None:
            result['Status'] = self.status
        if self.uuid_list is not None:
            result['UuidList'] = self.uuid_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClientStatus') is not None:
            self.client_status = m.get('ClientStatus')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Policy') is not None:
            self.policy = m.get('Policy')
        if m.get('PolicyVersion') is not None:
            self.policy_version = m.get('PolicyVersion')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('UuidList') is not None:
            self.uuid_list = m.get('UuidList')
        return self


class DescribeBackupPolicyResponseBody(TeaModel):
    def __init__(
        self,
        backup_policy_detail: DescribeBackupPolicyResponseBodyBackupPolicyDetail = None,
        request_id: str = None,
    ):
        # The details of the anti-ransomware policy.
        self.backup_policy_detail = backup_policy_detail
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id

    def validate(self):
        if self.backup_policy_detail:
            self.backup_policy_detail.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.backup_policy_detail is not None:
            result['BackupPolicyDetail'] = self.backup_policy_detail.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BackupPolicyDetail') is not None:
            temp_model = DescribeBackupPolicyResponseBodyBackupPolicyDetail()
            self.backup_policy_detail = temp_model.from_map(m['BackupPolicyDetail'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeBackupPolicyResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeBackupPolicyResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeBackupPolicyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeBackupRestoreCountResponseBodyBackupRestoreCount(TeaModel):
    def __init__(
        self,
        recovering: int = None,
        total: int = None,
    ):
        # The number of the restoration tasks that are in the **being restored** state.
        self.recovering = recovering
        # The total number of the restoration tasks that you create.
        self.total = total

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.recovering is not None:
            result['Recovering'] = self.recovering
        if self.total is not None:
            result['Total'] = self.total
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Recovering') is not None:
            self.recovering = m.get('Recovering')
        if m.get('Total') is not None:
            self.total = m.get('Total')
        return self


class DescribeBackupRestoreCountResponseBody(TeaModel):
    def __init__(
        self,
        backup_restore_count: DescribeBackupRestoreCountResponseBodyBackupRestoreCount = None,
        request_id: str = None,
    ):
        # The statistics of restoration tasks.
        self.backup_restore_count = backup_restore_count
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id

    def validate(self):
        if self.backup_restore_count:
            self.backup_restore_count.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.backup_restore_count is not None:
            result['BackupRestoreCount'] = self.backup_restore_count.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BackupRestoreCount') is not None:
            temp_model = DescribeBackupRestoreCountResponseBodyBackupRestoreCount()
            self.backup_restore_count = temp_model.from_map(m['BackupRestoreCount'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeBackupRestoreCountResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeBackupRestoreCountResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeBackupRestoreCountResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeBruteForceRecordsRequest(TeaModel):
    def __init__(
        self,
        block_ip: str = None,
        current_page: int = None,
        page_size: int = None,
        resource_owner_id: int = None,
        status: int = None,
    ):
        self.block_ip = block_ip
        self.current_page = current_page
        self.page_size = page_size
        self.resource_owner_id = resource_owner_id
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.block_ip is not None:
            result['BlockIp'] = self.block_ip
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BlockIp') is not None:
            self.block_ip = m.get('BlockIp')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DescribeBruteForceRecordsResponseBodyMachineList(TeaModel):
    def __init__(
        self,
        block_expire_date: int = None,
        block_ip: str = None,
        error_code: str = None,
        id: int = None,
        instance_name: str = None,
        internet_ip: str = None,
        intranet_ip: str = None,
        port: str = None,
        rule_name: str = None,
        source: str = None,
        status: int = None,
        uuid: str = None,
    ):
        self.block_expire_date = block_expire_date
        self.block_ip = block_ip
        self.error_code = error_code
        self.id = id
        self.instance_name = instance_name
        self.internet_ip = internet_ip
        self.intranet_ip = intranet_ip
        self.port = port
        self.rule_name = rule_name
        self.source = source
        self.status = status
        self.uuid = uuid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.block_expire_date is not None:
            result['BlockExpireDate'] = self.block_expire_date
        if self.block_ip is not None:
            result['BlockIp'] = self.block_ip
        if self.error_code is not None:
            result['ErrorCode'] = self.error_code
        if self.id is not None:
            result['Id'] = self.id
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.internet_ip is not None:
            result['InternetIp'] = self.internet_ip
        if self.intranet_ip is not None:
            result['IntranetIp'] = self.intranet_ip
        if self.port is not None:
            result['Port'] = self.port
        if self.rule_name is not None:
            result['RuleName'] = self.rule_name
        if self.source is not None:
            result['Source'] = self.source
        if self.status is not None:
            result['Status'] = self.status
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BlockExpireDate') is not None:
            self.block_expire_date = m.get('BlockExpireDate')
        if m.get('BlockIp') is not None:
            self.block_ip = m.get('BlockIp')
        if m.get('ErrorCode') is not None:
            self.error_code = m.get('ErrorCode')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('InternetIp') is not None:
            self.internet_ip = m.get('InternetIp')
        if m.get('IntranetIp') is not None:
            self.intranet_ip = m.get('IntranetIp')
        if m.get('Port') is not None:
            self.port = m.get('Port')
        if m.get('RuleName') is not None:
            self.rule_name = m.get('RuleName')
        if m.get('Source') is not None:
            self.source = m.get('Source')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class DescribeBruteForceRecordsResponseBodyPageInfo(TeaModel):
    def __init__(
        self,
        count: int = None,
        current_page: int = None,
        page_size: int = None,
        total_count: int = None,
    ):
        self.count = count
        self.current_page = current_page
        self.page_size = page_size
        self.total_count = total_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeBruteForceRecordsResponseBody(TeaModel):
    def __init__(
        self,
        machine_list: List[DescribeBruteForceRecordsResponseBodyMachineList] = None,
        page_info: DescribeBruteForceRecordsResponseBodyPageInfo = None,
        request_id: str = None,
    ):
        self.machine_list = machine_list
        self.page_info = page_info
        self.request_id = request_id

    def validate(self):
        if self.machine_list:
            for k in self.machine_list:
                if k:
                    k.validate()
        if self.page_info:
            self.page_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['MachineList'] = []
        if self.machine_list is not None:
            for k in self.machine_list:
                result['MachineList'].append(k.to_map() if k else None)
        if self.page_info is not None:
            result['PageInfo'] = self.page_info.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.machine_list = []
        if m.get('MachineList') is not None:
            for k in m.get('MachineList'):
                temp_model = DescribeBruteForceRecordsResponseBodyMachineList()
                self.machine_list.append(temp_model.from_map(k))
        if m.get('PageInfo') is not None:
            temp_model = DescribeBruteForceRecordsResponseBodyPageInfo()
            self.page_info = temp_model.from_map(m['PageInfo'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeBruteForceRecordsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeBruteForceRecordsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeBruteForceRecordsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeBruteForceSummaryRequest(TeaModel):
    def __init__(
        self,
        resource_owner_id: int = None,
        source_ip: str = None,
    ):
        self.resource_owner_id = resource_owner_id
        # The source IP address of the request.
        self.source_ip = source_ip

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        return self


class DescribeBruteForceSummaryResponseBodyBruteForceSummary(TeaModel):
    def __init__(
        self,
        all_strategy_count: int = None,
        effective_count: int = None,
    ):
        # The total number of IP address blocking policies.
        self.all_strategy_count = all_strategy_count
        # The number of enabled IP address blocking policies.
        self.effective_count = effective_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.all_strategy_count is not None:
            result['AllStrategyCount'] = self.all_strategy_count
        if self.effective_count is not None:
            result['EffectiveCount'] = self.effective_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AllStrategyCount') is not None:
            self.all_strategy_count = m.get('AllStrategyCount')
        if m.get('EffectiveCount') is not None:
            self.effective_count = m.get('EffectiveCount')
        return self


class DescribeBruteForceSummaryResponseBody(TeaModel):
    def __init__(
        self,
        brute_force_summary: DescribeBruteForceSummaryResponseBodyBruteForceSummary = None,
        request_id: str = None,
    ):
        # The statistics of IP address blocking policies.
        self.brute_force_summary = brute_force_summary
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id

    def validate(self):
        if self.brute_force_summary:
            self.brute_force_summary.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.brute_force_summary is not None:
            result['BruteForceSummary'] = self.brute_force_summary.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BruteForceSummary') is not None:
            temp_model = DescribeBruteForceSummaryResponseBodyBruteForceSummary()
            self.brute_force_summary = temp_model.from_map(m['BruteForceSummary'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeBruteForceSummaryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeBruteForceSummaryResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeBruteForceSummaryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCheckEcsWarningsRequest(TeaModel):
    def __init__(
        self,
        source_ip: str = None,
    ):
        # The source IP address of the request.
        self.source_ip = source_ip

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        return self


class DescribeCheckEcsWarningsResponseBody(TeaModel):
    def __init__(
        self,
        can_try: str = None,
        request_id: str = None,
        sas_version: str = None,
        weak_password_count: str = None,
    ):
        # Indicates whether you use the free trial of Security Center. Valid values:
        # 
        # *   **0**: no
        # *   **1**: yes
        self.can_try = can_try
        # The ID of the request.
        self.request_id = request_id
        # The edition of Security Center that you use. Valid values:
        # 
        # *   **1**: Basic edition
        # *   **2** or **3**: Enterprise edition
        # *   **5**: Advanced edition
        # *   **6**: Anti-virus edition
        # 
        # >  Both the value 2 and the value 3 indicate the Enterprise edition.
        self.sas_version = sas_version
        # The number of weak passwords that can cause high risks to your assets.
        self.weak_password_count = weak_password_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.can_try is not None:
            result['CanTry'] = self.can_try
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.sas_version is not None:
            result['SasVersion'] = self.sas_version
        if self.weak_password_count is not None:
            result['WeakPasswordCount'] = self.weak_password_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CanTry') is not None:
            self.can_try = m.get('CanTry')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SasVersion') is not None:
            self.sas_version = m.get('SasVersion')
        if m.get('WeakPasswordCount') is not None:
            self.weak_password_count = m.get('WeakPasswordCount')
        return self


class DescribeCheckEcsWarningsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeCheckEcsWarningsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeCheckEcsWarningsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCheckFixDetailsRequest(TeaModel):
    def __init__(
        self,
        check_ids: str = None,
        lang: str = None,
        risk_id: int = None,
    ):
        self.check_ids = check_ids
        self.lang = lang
        self.risk_id = risk_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.check_ids is not None:
            result['CheckIds'] = self.check_ids
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.risk_id is not None:
            result['RiskId'] = self.risk_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CheckIds') is not None:
            self.check_ids = m.get('CheckIds')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('RiskId') is not None:
            self.risk_id = m.get('RiskId')
        return self


class DescribeCheckFixDetailsResponseBodyCheckFixDetailsRulesParamList(TeaModel):
    def __init__(
        self,
        enum_value: str = None,
        max_value: int = None,
        min_value: int = None,
        param_default_value: str = None,
        param_desc: str = None,
        param_name: str = None,
        param_type: int = None,
        rule_id: str = None,
        value: str = None,
    ):
        self.enum_value = enum_value
        self.max_value = max_value
        self.min_value = min_value
        self.param_default_value = param_default_value
        self.param_desc = param_desc
        self.param_name = param_name
        self.param_type = param_type
        self.rule_id = rule_id
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.enum_value is not None:
            result['EnumValue'] = self.enum_value
        if self.max_value is not None:
            result['MaxValue'] = self.max_value
        if self.min_value is not None:
            result['MinValue'] = self.min_value
        if self.param_default_value is not None:
            result['ParamDefaultValue'] = self.param_default_value
        if self.param_desc is not None:
            result['ParamDesc'] = self.param_desc
        if self.param_name is not None:
            result['ParamName'] = self.param_name
        if self.param_type is not None:
            result['ParamType'] = self.param_type
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EnumValue') is not None:
            self.enum_value = m.get('EnumValue')
        if m.get('MaxValue') is not None:
            self.max_value = m.get('MaxValue')
        if m.get('MinValue') is not None:
            self.min_value = m.get('MinValue')
        if m.get('ParamDefaultValue') is not None:
            self.param_default_value = m.get('ParamDefaultValue')
        if m.get('ParamDesc') is not None:
            self.param_desc = m.get('ParamDesc')
        if m.get('ParamName') is not None:
            self.param_name = m.get('ParamName')
        if m.get('ParamType') is not None:
            self.param_type = m.get('ParamType')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeCheckFixDetailsResponseBodyCheckFixDetailsRules(TeaModel):
    def __init__(
        self,
        check_id: int = None,
        default_value: int = None,
        optional: int = None,
        param_list: List[DescribeCheckFixDetailsResponseBodyCheckFixDetailsRulesParamList] = None,
        rule_desc: str = None,
        rule_id: str = None,
        value: int = None,
        var_name: str = None,
    ):
        self.check_id = check_id
        self.default_value = default_value
        self.optional = optional
        self.param_list = param_list
        self.rule_desc = rule_desc
        self.rule_id = rule_id
        self.value = value
        self.var_name = var_name

    def validate(self):
        if self.param_list:
            for k in self.param_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.check_id is not None:
            result['CheckId'] = self.check_id
        if self.default_value is not None:
            result['DefaultValue'] = self.default_value
        if self.optional is not None:
            result['Optional'] = self.optional
        result['ParamList'] = []
        if self.param_list is not None:
            for k in self.param_list:
                result['ParamList'].append(k.to_map() if k else None)
        if self.rule_desc is not None:
            result['RuleDesc'] = self.rule_desc
        if self.rule_id is not None:
            result['RuleId'] = self.rule_id
        if self.value is not None:
            result['Value'] = self.value
        if self.var_name is not None:
            result['VarName'] = self.var_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CheckId') is not None:
            self.check_id = m.get('CheckId')
        if m.get('DefaultValue') is not None:
            self.default_value = m.get('DefaultValue')
        if m.get('Optional') is not None:
            self.optional = m.get('Optional')
        self.param_list = []
        if m.get('ParamList') is not None:
            for k in m.get('ParamList'):
                temp_model = DescribeCheckFixDetailsResponseBodyCheckFixDetailsRulesParamList()
                self.param_list.append(temp_model.from_map(k))
        if m.get('RuleDesc') is not None:
            self.rule_desc = m.get('RuleDesc')
        if m.get('RuleId') is not None:
            self.rule_id = m.get('RuleId')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        if m.get('VarName') is not None:
            self.var_name = m.get('VarName')
        return self


class DescribeCheckFixDetailsResponseBodyCheckFixDetails(TeaModel):
    def __init__(
        self,
        check_desc: str = None,
        check_id: int = None,
        check_item: str = None,
        rules: List[DescribeCheckFixDetailsResponseBodyCheckFixDetailsRules] = None,
    ):
        self.check_desc = check_desc
        self.check_id = check_id
        self.check_item = check_item
        self.rules = rules

    def validate(self):
        if self.rules:
            for k in self.rules:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.check_desc is not None:
            result['CheckDesc'] = self.check_desc
        if self.check_id is not None:
            result['CheckId'] = self.check_id
        if self.check_item is not None:
            result['CheckItem'] = self.check_item
        result['Rules'] = []
        if self.rules is not None:
            for k in self.rules:
                result['Rules'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CheckDesc') is not None:
            self.check_desc = m.get('CheckDesc')
        if m.get('CheckId') is not None:
            self.check_id = m.get('CheckId')
        if m.get('CheckItem') is not None:
            self.check_item = m.get('CheckItem')
        self.rules = []
        if m.get('Rules') is not None:
            for k in m.get('Rules'):
                temp_model = DescribeCheckFixDetailsResponseBodyCheckFixDetailsRules()
                self.rules.append(temp_model.from_map(k))
        return self


class DescribeCheckFixDetailsResponseBody(TeaModel):
    def __init__(
        self,
        check_fix_details: List[DescribeCheckFixDetailsResponseBodyCheckFixDetails] = None,
        count: int = None,
        request_id: str = None,
    ):
        self.check_fix_details = check_fix_details
        self.count = count
        self.request_id = request_id

    def validate(self):
        if self.check_fix_details:
            for k in self.check_fix_details:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['CheckFixDetails'] = []
        if self.check_fix_details is not None:
            for k in self.check_fix_details:
                result['CheckFixDetails'].append(k.to_map() if k else None)
        if self.count is not None:
            result['Count'] = self.count
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.check_fix_details = []
        if m.get('CheckFixDetails') is not None:
            for k in m.get('CheckFixDetails'):
                temp_model = DescribeCheckFixDetailsResponseBodyCheckFixDetails()
                self.check_fix_details.append(temp_model.from_map(k))
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeCheckFixDetailsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeCheckFixDetailsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeCheckFixDetailsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCheckWarningDetailRequest(TeaModel):
    def __init__(
        self,
        check_warning_id: int = None,
        lang: str = None,
        source_ip: str = None,
    ):
        # The ID of the alert that is triggered by the check item.
        # 
        # >  To query the details about a specified check item, you must provide the ID of the alert that is triggered by the check item. You can call the [DescribeCheckWarnings](~~DescribeCheckWarnings~~) operation to query the IDs of alerts.
        self.check_warning_id = check_warning_id
        # The language of the content within the request and the response. Valid values:
        # 
        # *   **zh**: Chinese
        # *   **en**: English
        self.lang = lang
        # The source IP address of the request.
        self.source_ip = source_ip

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.check_warning_id is not None:
            result['CheckWarningId'] = self.check_warning_id
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CheckWarningId') is not None:
            self.check_warning_id = m.get('CheckWarningId')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        return self


class DescribeCheckWarningDetailResponseBody(TeaModel):
    def __init__(
        self,
        advice: str = None,
        check_id: int = None,
        description: str = None,
        item: str = None,
        level: str = None,
        prompt: str = None,
        request_id: str = None,
        type: str = None,
    ):
        # The suggestion for the management of the risk item.
        self.advice = advice
        # The ID of the check item.
        self.check_id = check_id
        # The additional information about the risk item.
        self.description = description
        # The name of the check item.
        self.item = item
        # The risk level of the check item. Valid values:
        # 
        # *   **high**: The item is a high-risk item and is highlighted in red.
        # *   **medium**: The item is a medium-risk item and is highlighted in orange.
        # *   **low**: The item is a low-risk item and is highlighted in gray.
        self.level = level
        # The prompt for the risk item.
        self.prompt = prompt
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id
        # The type of the check item. Valid values:
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.advice is not None:
            result['Advice'] = self.advice
        if self.check_id is not None:
            result['CheckId'] = self.check_id
        if self.description is not None:
            result['Description'] = self.description
        if self.item is not None:
            result['Item'] = self.item
        if self.level is not None:
            result['Level'] = self.level
        if self.prompt is not None:
            result['Prompt'] = self.prompt
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Advice') is not None:
            self.advice = m.get('Advice')
        if m.get('CheckId') is not None:
            self.check_id = m.get('CheckId')
        if m.get('Description') is not None:
            self.description = m.get('Description')
        if m.get('Item') is not None:
            self.item = m.get('Item')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('Prompt') is not None:
            self.prompt = m.get('Prompt')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribeCheckWarningDetailResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeCheckWarningDetailResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeCheckWarningDetailResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCheckWarningMachinesRequest(TeaModel):
    def __init__(
        self,
        check_id: int = None,
        lang: str = None,
        risk_id: int = None,
        status: int = None,
    ):
        self.check_id = check_id
        self.lang = lang
        self.risk_id = risk_id
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.check_id is not None:
            result['CheckId'] = self.check_id
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.risk_id is not None:
            result['RiskId'] = self.risk_id
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CheckId') is not None:
            self.check_id = m.get('CheckId')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('RiskId') is not None:
            self.risk_id = m.get('RiskId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DescribeCheckWarningMachinesResponseBodyMachines(TeaModel):
    def __init__(
        self,
        bind: bool = None,
        instance_id: str = None,
        instance_name: str = None,
        internet_ip: str = None,
        intranet_ip: str = None,
        region_id: str = None,
        uuid: str = None,
    ):
        self.bind = bind
        self.instance_id = instance_id
        self.instance_name = instance_name
        self.internet_ip = internet_ip
        self.intranet_ip = intranet_ip
        self.region_id = region_id
        self.uuid = uuid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.bind is not None:
            result['Bind'] = self.bind
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.internet_ip is not None:
            result['InternetIp'] = self.internet_ip
        if self.intranet_ip is not None:
            result['IntranetIp'] = self.intranet_ip
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Bind') is not None:
            self.bind = m.get('Bind')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('InternetIp') is not None:
            self.internet_ip = m.get('InternetIp')
        if m.get('IntranetIp') is not None:
            self.intranet_ip = m.get('IntranetIp')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class DescribeCheckWarningMachinesResponseBody(TeaModel):
    def __init__(
        self,
        count: int = None,
        machines: List[DescribeCheckWarningMachinesResponseBodyMachines] = None,
        request_id: str = None,
    ):
        self.count = count
        self.machines = machines
        self.request_id = request_id

    def validate(self):
        if self.machines:
            for k in self.machines:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        result['Machines'] = []
        if self.machines is not None:
            for k in self.machines:
                result['Machines'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        self.machines = []
        if m.get('Machines') is not None:
            for k in m.get('Machines'):
                temp_model = DescribeCheckWarningMachinesResponseBodyMachines()
                self.machines.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeCheckWarningMachinesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeCheckWarningMachinesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeCheckWarningMachinesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCheckWarningSummaryRequest(TeaModel):
    def __init__(
        self,
        cluster_id: str = None,
        container_field_name: str = None,
        container_field_value: str = None,
        current_page: int = None,
        group_id: int = None,
        lang: str = None,
        page_size: int = None,
        risk_name: str = None,
        risk_status: int = None,
        source_ip: str = None,
        status: str = None,
        strategy_id: int = None,
        target_type: str = None,
        type_name: str = None,
        uuids: str = None,
    ):
        # The ID of the container cluster.
        # 
        # >  You can call the [DescribeGroupedContainerInstances](~~DescribeGroupedContainerInstances~~) operation to query the IDs of container clusters.
        self.cluster_id = cluster_id
        # The name of the container field. Valid values:
        # 
        # *   **clusterId**: the ID of the cluster
        # *   **image**: the name of the image
        # *   **imageId**: the ID of the image
        # *   **namespace**: the namespace
        self.container_field_name = container_field_name
        # The value of the container field.
        self.container_field_value = container_field_value
        # The number of the page to return.
        self.current_page = current_page
        self.group_id = group_id
        # The language of the content within the request and the response. Valid values:
        # 
        # *   **zh**: Chinese
        # *   **en**: English
        self.lang = lang
        # The number of entries to return on each page.
        self.page_size = page_size
        # The name of the risk item.
        self.risk_name = risk_name
        # The status of the baseline check. Valid values:
        # 
        # *   **1**: failed
        # *   **3**: passed
        self.risk_status = risk_status
        # The source IP address of the request.
        self.source_ip = source_ip
        # The status of the check item. Valid values:
        # 
        # *   **1**: failed
        # *   **2**: verifying
        # *   **3**: passed
        # *   **5**: expired
        # *   **6**: ignored
        self.status = status
        # The ID of the baseline check policy.
        self.strategy_id = strategy_id
        # The type of the query condition. Valid values:
        # 
        # *   **uuid**: the ID of an asset
        self.target_type = target_type
        # The level-1 type of check items.
        # 
        # >  You can call the [DescribeRiskType](~~DescribeRiskType~~) operation to query the level-1 types of check items.
        self.type_name = type_name
        # The UUID of the asset.
        # 
        # >  You can call the [DescribeCloudCenterInstances](~~DescribeCloudCenterInstances~~) operation to query the UUIDs of assets.
        self.uuids = uuids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.container_field_name is not None:
            result['ContainerFieldName'] = self.container_field_name
        if self.container_field_value is not None:
            result['ContainerFieldValue'] = self.container_field_value
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.risk_name is not None:
            result['RiskName'] = self.risk_name
        if self.risk_status is not None:
            result['RiskStatus'] = self.risk_status
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.status is not None:
            result['Status'] = self.status
        if self.strategy_id is not None:
            result['StrategyId'] = self.strategy_id
        if self.target_type is not None:
            result['TargetType'] = self.target_type
        if self.type_name is not None:
            result['TypeName'] = self.type_name
        if self.uuids is not None:
            result['Uuids'] = self.uuids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('ContainerFieldName') is not None:
            self.container_field_name = m.get('ContainerFieldName')
        if m.get('ContainerFieldValue') is not None:
            self.container_field_value = m.get('ContainerFieldValue')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RiskName') is not None:
            self.risk_name = m.get('RiskName')
        if m.get('RiskStatus') is not None:
            self.risk_status = m.get('RiskStatus')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('StrategyId') is not None:
            self.strategy_id = m.get('StrategyId')
        if m.get('TargetType') is not None:
            self.target_type = m.get('TargetType')
        if m.get('TypeName') is not None:
            self.type_name = m.get('TypeName')
        if m.get('Uuids') is not None:
            self.uuids = m.get('Uuids')
        return self


class DescribeCheckWarningSummaryResponseBodyWarningSummarys(TeaModel):
    def __init__(
        self,
        check_count: int = None,
        check_exploit: bool = None,
        database_risk: bool = None,
        high_warning_count: int = None,
        last_found_time: str = None,
        level: str = None,
        low_warning_count: int = None,
        medium_warning_count: int = None,
        risk_id: int = None,
        risk_name: str = None,
        sub_type_alias: str = None,
        type_alias: str = None,
        warning_machine_count: int = None,
    ):
        # The number of check items.
        self.check_count = check_count
        # Indicates whether the risk item can be exploited. Valid values:
        # 
        # *   **true**: yes
        # *   **false**: no
        self.check_exploit = check_exploit
        # Indicates whether the risk item is a database risk item. Valid values:
        # 
        # *   **true**: yes
        # *   **false**: no
        self.database_risk = database_risk
        # The number of high-risk items.
        self.high_warning_count = high_warning_count
        # The time when the last baseline check was performed.
        self.last_found_time = last_found_time
        # The risk level of the risk item. Valid values:
        # 
        # *   **high**\
        # *   **medium**\
        # *   **low**\
        self.level = level
        # The number of low-risk items.
        self.low_warning_count = low_warning_count
        # The number of medium-risk items.
        self.medium_warning_count = medium_warning_count
        # The ID of the risk item.
        self.risk_id = risk_id
        # The name of the risk item.
        self.risk_name = risk_name
        # The level-2 type of the risk item.
        self.sub_type_alias = sub_type_alias
        # The level-1 type of the check item. Examples: database, system, weak password, and middleware.
        self.type_alias = type_alias
        # The number of assets on which risk items are detected.
        self.warning_machine_count = warning_machine_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.check_count is not None:
            result['CheckCount'] = self.check_count
        if self.check_exploit is not None:
            result['CheckExploit'] = self.check_exploit
        if self.database_risk is not None:
            result['DatabaseRisk'] = self.database_risk
        if self.high_warning_count is not None:
            result['HighWarningCount'] = self.high_warning_count
        if self.last_found_time is not None:
            result['LastFoundTime'] = self.last_found_time
        if self.level is not None:
            result['Level'] = self.level
        if self.low_warning_count is not None:
            result['LowWarningCount'] = self.low_warning_count
        if self.medium_warning_count is not None:
            result['MediumWarningCount'] = self.medium_warning_count
        if self.risk_id is not None:
            result['RiskId'] = self.risk_id
        if self.risk_name is not None:
            result['RiskName'] = self.risk_name
        if self.sub_type_alias is not None:
            result['SubTypeAlias'] = self.sub_type_alias
        if self.type_alias is not None:
            result['TypeAlias'] = self.type_alias
        if self.warning_machine_count is not None:
            result['WarningMachineCount'] = self.warning_machine_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CheckCount') is not None:
            self.check_count = m.get('CheckCount')
        if m.get('CheckExploit') is not None:
            self.check_exploit = m.get('CheckExploit')
        if m.get('DatabaseRisk') is not None:
            self.database_risk = m.get('DatabaseRisk')
        if m.get('HighWarningCount') is not None:
            self.high_warning_count = m.get('HighWarningCount')
        if m.get('LastFoundTime') is not None:
            self.last_found_time = m.get('LastFoundTime')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('LowWarningCount') is not None:
            self.low_warning_count = m.get('LowWarningCount')
        if m.get('MediumWarningCount') is not None:
            self.medium_warning_count = m.get('MediumWarningCount')
        if m.get('RiskId') is not None:
            self.risk_id = m.get('RiskId')
        if m.get('RiskName') is not None:
            self.risk_name = m.get('RiskName')
        if m.get('SubTypeAlias') is not None:
            self.sub_type_alias = m.get('SubTypeAlias')
        if m.get('TypeAlias') is not None:
            self.type_alias = m.get('TypeAlias')
        if m.get('WarningMachineCount') is not None:
            self.warning_machine_count = m.get('WarningMachineCount')
        return self


class DescribeCheckWarningSummaryResponseBody(TeaModel):
    def __init__(
        self,
        count: int = None,
        current_page: int = None,
        page_size: int = None,
        request_id: str = None,
        total_count: int = None,
        warning_summarys: List[DescribeCheckWarningSummaryResponseBodyWarningSummarys] = None,
    ):
        # The number of check items returned on the current page.
        self.count = count
        # The page number of the current page.
        self.current_page = current_page
        # The number of entries to return on each page.
        self.page_size = page_size
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id
        # The total number of check items.
        self.total_count = total_count
        # The statistics of check items.
        self.warning_summarys = warning_summarys

    def validate(self):
        if self.warning_summarys:
            for k in self.warning_summarys:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        result['WarningSummarys'] = []
        if self.warning_summarys is not None:
            for k in self.warning_summarys:
                result['WarningSummarys'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        self.warning_summarys = []
        if m.get('WarningSummarys') is not None:
            for k in m.get('WarningSummarys'):
                temp_model = DescribeCheckWarningSummaryResponseBodyWarningSummarys()
                self.warning_summarys.append(temp_model.from_map(k))
        return self


class DescribeCheckWarningSummaryResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeCheckWarningSummaryResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeCheckWarningSummaryResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCheckWarningsRequest(TeaModel):
    def __init__(
        self,
        check_id: int = None,
        check_type: str = None,
        current_page: int = None,
        lang: str = None,
        page_size: int = None,
        risk_id: int = None,
        risk_status: int = None,
        source_ip: str = None,
        uuid: str = None,
    ):
        # The ID of the check item.
        self.check_id = check_id
        # The type of the check item. Valid values:
        # 
        # *   **hc.check.type.identity_auth**: identity authentication
        # *   **hc.check.type.access_control**: access control
        # *   **hc.check.type.network_service**: network and service
        # *   **hc.check.type.service_conf**: service configuration
        # *   **hc.check.type.file_rights**: file permission
        # *   **hc.check.type.security_audit**: security audit
        # *   **hc.check.type.attack_defense**: intrusion prevention
        # *   **hc.check.type.others**: others
        self.check_type = check_type
        # The number of the page to return. Default value: **1**.
        self.current_page = current_page
        # The language of the content within the request and response. Default value: **zh**. Valid values:
        # 
        # *   **zh**: Chinese
        # *   **en**: English
        self.lang = lang
        # The number of entries to return on each page. Default value: **20**.
        self.page_size = page_size
        # The ID of the risk item.
        # 
        # >  To query specified risk items and the check items of a specified server, you must provide the IDs of the risk items. You can call the [DescribeCheckWarningSummary](~~DescribeCheckWarningSummary~~) operation to query the IDs of risk items.
        self.risk_id = risk_id
        # The status of the check item. Valid values:
        # 
        # *   **1**: failed
        # *   **2**: verifying
        # *   **3**: passed
        # *   **5**: expired
        # *   **6**: ignored
        self.risk_status = risk_status
        # The source IP address of the request.
        self.source_ip = source_ip
        # The UUID of the server on which the baseline check is performed.
        # 
        # >  To query specified risk items and the check items of a specified server, you must provide the ID of the server on which the baseline check is performed. You can call the [DescribeWarningMachines](~~DescribeWarningMachines~~) operation to query the IDs of servers.
        self.uuid = uuid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.check_id is not None:
            result['CheckId'] = self.check_id
        if self.check_type is not None:
            result['CheckType'] = self.check_type
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.risk_id is not None:
            result['RiskId'] = self.risk_id
        if self.risk_status is not None:
            result['RiskStatus'] = self.risk_status
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CheckId') is not None:
            self.check_id = m.get('CheckId')
        if m.get('CheckType') is not None:
            self.check_type = m.get('CheckType')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RiskId') is not None:
            self.risk_id = m.get('RiskId')
        if m.get('RiskStatus') is not None:
            self.risk_status = m.get('RiskStatus')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class DescribeCheckWarningsResponseBodyCheckWarnings(TeaModel):
    def __init__(
        self,
        check_id: int = None,
        check_warning_id: int = None,
        exec_error_message: str = None,
        fix_status: int = None,
        item: str = None,
        level: str = None,
        reason: str = None,
        status: int = None,
        type: str = None,
        uuid: str = None,
    ):
        # The ID of the check item.
        self.check_id = check_id
        # The ID of the alert that is triggered by the check item.
        self.check_warning_id = check_warning_id
        self.exec_error_message = exec_error_message
        # The fixing status of the check item. Valid values:
        # 
        # *   **0**: disabled
        # *   **1**: enabled
        self.fix_status = fix_status
        # The name of the check item.
        self.item = item
        # The risk level of the risk item. Valid values:
        # 
        # *   **high**\
        # *   **medium**\
        # *   **low**\
        self.level = level
        # The remarks.
        self.reason = reason
        # The status of the check item. Valid values:
        # 
        # *   **1**: failed
        # *   **2**: verifying
        # *   **3**: passed
        # *   **5**: expired
        # *   **6**: ignored
        self.status = status
        # The type of the check item.
        self.type = type
        # The UUID of the server on which the baseline check is performed.
        self.uuid = uuid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.check_id is not None:
            result['CheckId'] = self.check_id
        if self.check_warning_id is not None:
            result['CheckWarningId'] = self.check_warning_id
        if self.exec_error_message is not None:
            result['ExecErrorMessage'] = self.exec_error_message
        if self.fix_status is not None:
            result['FixStatus'] = self.fix_status
        if self.item is not None:
            result['Item'] = self.item
        if self.level is not None:
            result['Level'] = self.level
        if self.reason is not None:
            result['Reason'] = self.reason
        if self.status is not None:
            result['Status'] = self.status
        if self.type is not None:
            result['Type'] = self.type
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CheckId') is not None:
            self.check_id = m.get('CheckId')
        if m.get('CheckWarningId') is not None:
            self.check_warning_id = m.get('CheckWarningId')
        if m.get('ExecErrorMessage') is not None:
            self.exec_error_message = m.get('ExecErrorMessage')
        if m.get('FixStatus') is not None:
            self.fix_status = m.get('FixStatus')
        if m.get('Item') is not None:
            self.item = m.get('Item')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('Reason') is not None:
            self.reason = m.get('Reason')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class DescribeCheckWarningsResponseBody(TeaModel):
    def __init__(
        self,
        check_warnings: List[DescribeCheckWarningsResponseBodyCheckWarnings] = None,
        count: int = None,
        current_page: int = None,
        page_size: int = None,
        request_id: str = None,
        total_count: int = None,
    ):
        # An array that consists of the check items.
        self.check_warnings = check_warnings
        # The number of entries returned on the current page.
        self.count = count
        # The page number of the returned page.
        self.current_page = current_page
        # The number of entries returned per page. Default value: **20**.
        self.page_size = page_size
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id
        # The total number of entries returned.
        self.total_count = total_count

    def validate(self):
        if self.check_warnings:
            for k in self.check_warnings:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['CheckWarnings'] = []
        if self.check_warnings is not None:
            for k in self.check_warnings:
                result['CheckWarnings'].append(k.to_map() if k else None)
        if self.count is not None:
            result['Count'] = self.count
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.check_warnings = []
        if m.get('CheckWarnings') is not None:
            for k in m.get('CheckWarnings'):
                temp_model = DescribeCheckWarningsResponseBodyCheckWarnings()
                self.check_warnings.append(temp_model.from_map(k))
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeCheckWarningsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeCheckWarningsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeCheckWarningsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeClientConfSetupRequest(TeaModel):
    def __init__(
        self,
        strategy_tag: str = None,
        strategy_tag_value: str = None,
    ):
        self.strategy_tag = strategy_tag
        self.strategy_tag_value = strategy_tag_value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.strategy_tag is not None:
            result['StrategyTag'] = self.strategy_tag
        if self.strategy_tag_value is not None:
            result['StrategyTagValue'] = self.strategy_tag_value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('StrategyTag') is not None:
            self.strategy_tag = m.get('StrategyTag')
        if m.get('StrategyTagValue') is not None:
            self.strategy_tag_value = m.get('StrategyTagValue')
        return self


class DescribeClientConfSetupResponseBodyClientConf(TeaModel):
    def __init__(
        self,
        config: str = None,
        strategy_tag: str = None,
        strategy_tag_value: str = None,
    ):
        self.config = config
        self.strategy_tag = strategy_tag
        self.strategy_tag_value = strategy_tag_value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config is not None:
            result['Config'] = self.config
        if self.strategy_tag is not None:
            result['StrategyTag'] = self.strategy_tag
        if self.strategy_tag_value is not None:
            result['StrategyTagValue'] = self.strategy_tag_value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Config') is not None:
            self.config = m.get('Config')
        if m.get('StrategyTag') is not None:
            self.strategy_tag = m.get('StrategyTag')
        if m.get('StrategyTagValue') is not None:
            self.strategy_tag_value = m.get('StrategyTagValue')
        return self


class DescribeClientConfSetupResponseBody(TeaModel):
    def __init__(
        self,
        client_conf: DescribeClientConfSetupResponseBodyClientConf = None,
        request_id: str = None,
    ):
        self.client_conf = client_conf
        self.request_id = request_id

    def validate(self):
        if self.client_conf:
            self.client_conf.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.client_conf is not None:
            result['ClientConf'] = self.client_conf.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClientConf') is not None:
            temp_model = DescribeClientConfSetupResponseBodyClientConf()
            self.client_conf = temp_model.from_map(m['ClientConf'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeClientConfSetupResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeClientConfSetupResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeClientConfSetupResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeClientConfStrategyRequest(TeaModel):
    def __init__(
        self,
        tag: str = None,
        tag_value: str = None,
    ):
        self.tag = tag
        self.tag_value = tag_value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.tag is not None:
            result['Tag'] = self.tag
        if self.tag_value is not None:
            result['TagValue'] = self.tag_value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Tag') is not None:
            self.tag = m.get('Tag')
        if m.get('TagValue') is not None:
            self.tag_value = m.get('TagValue')
        return self


class DescribeClientConfStrategyResponseBodyTargetList(TeaModel):
    def __init__(
        self,
        uuid: str = None,
    ):
        self.uuid = uuid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class DescribeClientConfStrategyResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        target_list: List[DescribeClientConfStrategyResponseBodyTargetList] = None,
        total_count: int = None,
    ):
        self.request_id = request_id
        self.target_list = target_list
        self.total_count = total_count

    def validate(self):
        if self.target_list:
            for k in self.target_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['TargetList'] = []
        if self.target_list is not None:
            for k in self.target_list:
                result['TargetList'].append(k.to_map() if k else None)
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.target_list = []
        if m.get('TargetList') is not None:
            for k in m.get('TargetList'):
                temp_model = DescribeClientConfStrategyResponseBodyTargetList()
                self.target_list.append(temp_model.from_map(k))
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeClientConfStrategyResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeClientConfStrategyResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeClientConfStrategyResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCloudCenterInstancesRequest(TeaModel):
    def __init__(
        self,
        criteria: str = None,
        current_page: int = None,
        importance: int = None,
        lang: str = None,
        logical_exp: str = None,
        machine_types: str = None,
        no_group_trace: bool = None,
        page_size: int = None,
        region_id: str = None,
    ):
        # The search conditions that are used to filter assets. The value of this parameter is in the JSON format and is case-sensitive.
        # 
        # >  A search condition can be an instance ID, instance name, VPC ID, region, or public IP address. You can call the [DescribeCriteria](~~DescribeCriteria~~) operation to query the supported search conditions.
        self.criteria = criteria
        # The number of the page to return. Default value: **1**.
        self.current_page = current_page
        # The importance of the asset. Valid values:
        # 
        # *   **2**: an important asset
        # *   **1**: a common asset
        # *   **0**: a test asset
        self.importance = importance
        # The language of the content within the request and response. Default value: **zh**. Valid values:
        # 
        # *   **zh**: Chinese
        # *   **en**: English
        self.lang = lang
        # The logical relationship among multiple search conditions. Valid values:
        # 
        # *   **OR**: The search conditions are evaluated by using a logical **OR**.
        # *   **AND**: The search conditions are evaluated by using a logical **AND**.
        self.logical_exp = logical_exp
        # The type of the assets that you want to query. Valid values:
        # 
        # *   **ecs**: servers
        # *   **cloud_product**: Alibaba Cloud services
        self.machine_types = machine_types
        # Specifies whether to internationalize the name of the default group. Default value: **false** . Valid values:
        # 
        # *   **true**: The system returns the Chinese name of the default group for the GroupTrace response parameter.************\
        # *   **false**: The system returns default for the GroupTrace response parameter.
        self.no_group_trace = no_group_trace
        # The number of entries to return on each page. Default value: **20**.
        self.page_size = page_size
        # The ID of the region in which the asset resides.
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.criteria is not None:
            result['Criteria'] = self.criteria
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.importance is not None:
            result['Importance'] = self.importance
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.logical_exp is not None:
            result['LogicalExp'] = self.logical_exp
        if self.machine_types is not None:
            result['MachineTypes'] = self.machine_types
        if self.no_group_trace is not None:
            result['NoGroupTrace'] = self.no_group_trace
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Criteria') is not None:
            self.criteria = m.get('Criteria')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('Importance') is not None:
            self.importance = m.get('Importance')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('LogicalExp') is not None:
            self.logical_exp = m.get('LogicalExp')
        if m.get('MachineTypes') is not None:
            self.machine_types = m.get('MachineTypes')
        if m.get('NoGroupTrace') is not None:
            self.no_group_trace = m.get('NoGroupTrace')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeCloudCenterInstancesResponseBodyInstances(TeaModel):
    def __init__(
        self,
        alarm_status: str = None,
        asset_type: str = None,
        auth_modify_time: int = None,
        auth_version: int = None,
        auth_version_name: str = None,
        bind: bool = None,
        client_status: str = None,
        cluster_id: str = None,
        cluster_name: str = None,
        cores: int = None,
        cpu_info: str = None,
        created_time: int = None,
        exposed_status: int = None,
        flag: int = None,
        group_id: int = None,
        group_trace: str = None,
        hc_status: str = None,
        health_check_count: int = None,
        importance: int = None,
        instance_id: str = None,
        instance_name: str = None,
        internet_ip: str = None,
        intranet_ip: str = None,
        ip: str = None,
        ip_list_string: str = None,
        kernel: str = None,
        last_login_timestamp: int = None,
        mac_list_string: str = None,
        mem: int = None,
        os: str = None,
        os_name: str = None,
        pod_count: int = None,
        region: str = None,
        region_id: str = None,
        region_name: str = None,
        risk_count: str = None,
        risk_status: str = None,
        safe_event_count: int = None,
        status: str = None,
        tag: str = None,
        tag_id: str = None,
        uuid: str = None,
        vendor: int = None,
        vendor_name: str = None,
        vpc_instance_id: str = None,
        vul_count: int = None,
        vul_status: str = None,
    ):
        # Indicates whether alerts are generated on the asset. Valid values:
        # 
        # *   **YES**\
        # *   **NO**\
        self.alarm_status = alarm_status
        # The type of the asset. Valid values:
        # 
        # *   **0**: an ECS instance
        # *   **1**: a Server Load Balancer (SLB) instance
        # *   **2**: a NAT gateway
        # *   **3**: an ApsaraDB RDS instance
        # *   **4**: an ApsaraDB for MongoDB instance
        # *   **5**: an ApsaraDB for Redis instance
        # *   **6**: a container image
        # *   **7**: a container
        self.asset_type = asset_type
        # The timestamp when Security Center is authorized to scan the asset.
        self.auth_modify_time = auth_modify_time
        # The edition of Security Center that is authorized to protect the asset. Valid values:
        # 
        # *   **1**: Basic edition
        # *   **6**: Anti-virus edition
        # *   **5**: Advanced edition
        # *   **3**: Enterprise edition
        # *   **7**: Ultimate edition
        self.auth_version = auth_version
        # The name of the Security Center edition that is authorized to scan the asset. Valid values:
        # 
        # *   Basic edition
        # *   Anti-virus edition
        # *   Advanced edition
        # *   Enterprise edition
        # *   Ultimate edition
        # *   Value-added Plan edition
        self.auth_version_name = auth_version_name
        # Indicates whether Security Center is authorized to scan the asset. Valid values:
        # 
        # *   **true**: yes
        # *   **false**: no
        self.bind = bind
        # The status of the Security Center agent installed on the asset. Valid values:
        # 
        # *   **online**: The Security Center agent is **enabled**.
        # *   **offline**: The Security Center agent is **disabled**.
        # *   **pause**: The Security Center agent is **suspended**.
        self.client_status = client_status
        # The ID of the cluster.
        self.cluster_id = cluster_id
        # The name of the cluster.
        self.cluster_name = cluster_name
        # The number of the CPU cores used by the asset.
        self.cores = cores
        # The CPU information about the asset.
        self.cpu_info = cpu_info
        # The timestamp when the cluster was created. Unit: milliseconds.
        self.created_time = created_time
        # Indicates whether the asset is exposed. Valid values:
        # 
        # *   **0**: no
        # *   **1**: yes
        self.exposed_status = exposed_status
        # Indicates whether the asset is an Alibaba Cloud asset. Valid values:
        # 
        # *   **0**: yes
        # *   **1**: no
        self.flag = flag
        # The ID of the asset group to which the asset belongs.
        self.group_id = group_id
        # The name of the group to which the asset belongs.
        self.group_trace = group_trace
        # Indicates whether baseline risks are detected on the asset. Valid values:
        # 
        # *   **YES**\
        # *   **NO**\
        self.hc_status = hc_status
        # The number of baseline risks that are detected on the asset.
        self.health_check_count = health_check_count
        # The importance of the asset. Valid values:
        # 
        # *   **2**: an important asset
        # *   **1**: a common asset
        # *   **0**: a test asset
        self.importance = importance
        # The ID of the asset.
        self.instance_id = instance_id
        # The name of the asset.
        self.instance_name = instance_name
        # The public IP address of the asset.
        self.internet_ip = internet_ip
        # The private IP address of the asset.
        self.intranet_ip = intranet_ip
        # The public IP address of the asset.
        self.ip = ip
        # The IP addresses of the system.
        self.ip_list_string = ip_list_string
        # The version of the kernel.
        self.kernel = kernel
        # The timestamp when the Security Center agent was last online. Unit: milliseconds.
        self.last_login_timestamp = last_login_timestamp
        # The MAC address of the system.
        self.mac_list_string = mac_list_string
        # The size of the memory. Unit: MB.
        self.mem = mem
        # The operating system of the asset.
        self.os = os
        # The kernel version of the asset.
        self.os_name = os_name
        # The number of pods.
        self.pod_count = pod_count
        # The region ID of the asset.
        self.region = region
        # The ID of the region in which the asset resides.
        self.region_id = region_id
        # The name of the region in which the asset resides.
        self.region_name = region_name
        # The total number of baseline risks that are detected on the asset. The value of this parameter is in the JSON format and contains the following fields:
        # 
        # *   **account**: the number of accounts that are used to log on from unapproved logon locations and whose passwords are cracked
        # *   **appNum**: the number of scanners
        # *   **asapVulCount**: the total number of high-risk vulnerabilities
        # *   **baselineHigh**: the number of high-risk baseline risks
        # *   **baselineLow**: the number of low-risk baseline risks
        # *   **baselineMedium**: the number of medium-risk baseline risks
        # *   **baselineNum**: the total number of baseline risks
        # *   **cmsNum**: the number of Web-CMS vulnerabilities
        # *   **containerAsap**: the number of high-risk vulnerabilities that are detected on containers
        # *   **containerLater**: the number of medium-risk vulnerabilities that are detected on containers
        # *   **containerNntf**: the number of low-risk vulnerabilities that are detected on containers
        # *   **containerRemind**: the number of alerts whose Emergency level is Reminder on containers
        # *   **containerSerious**: the number of alerts whose Emergency level is Urgent on containers
        # *   **containerSuspicious**: the number of alerts whose Emergency level is Suspicious on containers
        # *   **cveNum**: the number of Linux software vulnerabilities
        # *   **emgNum**: the number of urgent vulnerabilities
        # *   **health**: the number of baseline alerts that are unhandled
        # *   **imageBaselineHigh**: the number of high-risk baseline risks that are detected on images
        # *   **imageBaselineLow**: the number of low-risk baseline risks that are detected on images
        # *   **imageBaselineMedium**: the number of medium-risk baseline risks that are detected on images
        # *   **imageBaselineNum**: the total number of baseline risks that are detected on images
        # *   **imageMaliciousFileRemind**: the number of malicious files that are detected on images and have the Emergency level of Reminder
        # *   **imageMaliciousFileSerious**: the number of malicious files that are detected on images and have the Emergency level of Urgent
        # *   **imageMaliciousFileSuspicious**: the number of malicious files that are detected on images and have the Emergency level of Suspicious
        # *   **imageVulAsap**: the number of high-risk vulnerabilities that are detected on images
        # *   **imageVulLater**: the number of medium-risk vulnerabilities that are detected on an image
        # *   **imageVulNntf**: the number of low-risk vulnerabilities that are detected on an image
        # *   **laterVulCount**: the number of medium-risk vulnerabilities
        # *   **newSuspicious**: the number of alerts
        # *   **nntfVulCount**: the number of low-risk vulnerabilities.
        # *   **remindNum**: the number of alerts whose Emergency level is Reminder
        # *   **scaNum**: the number of vulnerabilities that are detected based on software component analysis
        # *   **seriousNum**: the number of alerts whose Emergency level is Urgent
        # *   **suspNum**: the number of alerts whose Emergency level is Suspicious
        # *   **suspicious**: the total number of alerts
        # *   **sysNum**: the number of Windows system vulnerabilities
        # *   **trojan**: the number of trojans
        # *   **uuid**: the UUIDs of assets
        # *   **vul**: the number of vulnerabilities
        # *   **weakPWNum**: the number of weak passwords
        self.risk_count = risk_count
        # Indicates whether risks are detected on the asset. Valid values:
        # 
        # *   **YES**\
        # *   **NO**\
        self.risk_status = risk_status
        # The number of alerts that are generated on the asset.
        self.safe_event_count = safe_event_count
        # The status of the asset. Valid values:
        # 
        # *   **Running**: running
        # *   **notRunning**: stopped
        self.status = status
        # The name of the asset tag.
        self.tag = tag
        # The ID of the asset tag.
        self.tag_id = tag_id
        # The UUID of the asset.
        self.uuid = uuid
        # The type of the asset by source. Valid values:
        # 
        # *   **0**: an asset provided by Alibaba Cloud.
        # *   **1**: a third-party cloud server
        # *   **2**: a server in a data center
        # *   **3**, **4**, **5**, and **7**: other cloud asset
        # *   **8**: a lightweight asset
        self.vendor = vendor
        # The name of the service provider (SP) for the asset.
        # 
        # Valid values:
        # 
        # *   **ALIYUN**: Alibaba Cloud
        # *   **OUT**: a third-party service provider
        # *   **IDC**: a data center
        # *   **TENCENT**: Tencent Cloud
        # *   **HUAWEICLOUD**: Huawei Cloud
        # *   **Microsoft**: Microsoft
        # *   **AWS**: Amazon Web Services (AWS)
        # *   **TRIPARTITE**: a lightweight server
        self.vendor_name = vendor_name
        # The ID of the VPC to which the asset belongs.
        self.vpc_instance_id = vpc_instance_id
        # The number of vulnerabilities that are detected on the asset.
        self.vul_count = vul_count
        # Indicates whether vulnerabilities are detected on the asset. Valid values:
        # 
        # *   **YES**\
        # *   **NO**\
        self.vul_status = vul_status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alarm_status is not None:
            result['AlarmStatus'] = self.alarm_status
        if self.asset_type is not None:
            result['AssetType'] = self.asset_type
        if self.auth_modify_time is not None:
            result['AuthModifyTime'] = self.auth_modify_time
        if self.auth_version is not None:
            result['AuthVersion'] = self.auth_version
        if self.auth_version_name is not None:
            result['AuthVersionName'] = self.auth_version_name
        if self.bind is not None:
            result['Bind'] = self.bind
        if self.client_status is not None:
            result['ClientStatus'] = self.client_status
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.cluster_name is not None:
            result['ClusterName'] = self.cluster_name
        if self.cores is not None:
            result['Cores'] = self.cores
        if self.cpu_info is not None:
            result['CpuInfo'] = self.cpu_info
        if self.created_time is not None:
            result['CreatedTime'] = self.created_time
        if self.exposed_status is not None:
            result['ExposedStatus'] = self.exposed_status
        if self.flag is not None:
            result['Flag'] = self.flag
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.group_trace is not None:
            result['GroupTrace'] = self.group_trace
        if self.hc_status is not None:
            result['HcStatus'] = self.hc_status
        if self.health_check_count is not None:
            result['HealthCheckCount'] = self.health_check_count
        if self.importance is not None:
            result['Importance'] = self.importance
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.internet_ip is not None:
            result['InternetIp'] = self.internet_ip
        if self.intranet_ip is not None:
            result['IntranetIp'] = self.intranet_ip
        if self.ip is not None:
            result['Ip'] = self.ip
        if self.ip_list_string is not None:
            result['IpListString'] = self.ip_list_string
        if self.kernel is not None:
            result['Kernel'] = self.kernel
        if self.last_login_timestamp is not None:
            result['LastLoginTimestamp'] = self.last_login_timestamp
        if self.mac_list_string is not None:
            result['MacListString'] = self.mac_list_string
        if self.mem is not None:
            result['Mem'] = self.mem
        if self.os is not None:
            result['Os'] = self.os
        if self.os_name is not None:
            result['OsName'] = self.os_name
        if self.pod_count is not None:
            result['PodCount'] = self.pod_count
        if self.region is not None:
            result['Region'] = self.region
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.region_name is not None:
            result['RegionName'] = self.region_name
        if self.risk_count is not None:
            result['RiskCount'] = self.risk_count
        if self.risk_status is not None:
            result['RiskStatus'] = self.risk_status
        if self.safe_event_count is not None:
            result['SafeEventCount'] = self.safe_event_count
        if self.status is not None:
            result['Status'] = self.status
        if self.tag is not None:
            result['Tag'] = self.tag
        if self.tag_id is not None:
            result['TagId'] = self.tag_id
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        if self.vendor is not None:
            result['Vendor'] = self.vendor
        if self.vendor_name is not None:
            result['VendorName'] = self.vendor_name
        if self.vpc_instance_id is not None:
            result['VpcInstanceId'] = self.vpc_instance_id
        if self.vul_count is not None:
            result['VulCount'] = self.vul_count
        if self.vul_status is not None:
            result['VulStatus'] = self.vul_status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AlarmStatus') is not None:
            self.alarm_status = m.get('AlarmStatus')
        if m.get('AssetType') is not None:
            self.asset_type = m.get('AssetType')
        if m.get('AuthModifyTime') is not None:
            self.auth_modify_time = m.get('AuthModifyTime')
        if m.get('AuthVersion') is not None:
            self.auth_version = m.get('AuthVersion')
        if m.get('AuthVersionName') is not None:
            self.auth_version_name = m.get('AuthVersionName')
        if m.get('Bind') is not None:
            self.bind = m.get('Bind')
        if m.get('ClientStatus') is not None:
            self.client_status = m.get('ClientStatus')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('ClusterName') is not None:
            self.cluster_name = m.get('ClusterName')
        if m.get('Cores') is not None:
            self.cores = m.get('Cores')
        if m.get('CpuInfo') is not None:
            self.cpu_info = m.get('CpuInfo')
        if m.get('CreatedTime') is not None:
            self.created_time = m.get('CreatedTime')
        if m.get('ExposedStatus') is not None:
            self.exposed_status = m.get('ExposedStatus')
        if m.get('Flag') is not None:
            self.flag = m.get('Flag')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('GroupTrace') is not None:
            self.group_trace = m.get('GroupTrace')
        if m.get('HcStatus') is not None:
            self.hc_status = m.get('HcStatus')
        if m.get('HealthCheckCount') is not None:
            self.health_check_count = m.get('HealthCheckCount')
        if m.get('Importance') is not None:
            self.importance = m.get('Importance')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('InternetIp') is not None:
            self.internet_ip = m.get('InternetIp')
        if m.get('IntranetIp') is not None:
            self.intranet_ip = m.get('IntranetIp')
        if m.get('Ip') is not None:
            self.ip = m.get('Ip')
        if m.get('IpListString') is not None:
            self.ip_list_string = m.get('IpListString')
        if m.get('Kernel') is not None:
            self.kernel = m.get('Kernel')
        if m.get('LastLoginTimestamp') is not None:
            self.last_login_timestamp = m.get('LastLoginTimestamp')
        if m.get('MacListString') is not None:
            self.mac_list_string = m.get('MacListString')
        if m.get('Mem') is not None:
            self.mem = m.get('Mem')
        if m.get('Os') is not None:
            self.os = m.get('Os')
        if m.get('OsName') is not None:
            self.os_name = m.get('OsName')
        if m.get('PodCount') is not None:
            self.pod_count = m.get('PodCount')
        if m.get('Region') is not None:
            self.region = m.get('Region')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('RegionName') is not None:
            self.region_name = m.get('RegionName')
        if m.get('RiskCount') is not None:
            self.risk_count = m.get('RiskCount')
        if m.get('RiskStatus') is not None:
            self.risk_status = m.get('RiskStatus')
        if m.get('SafeEventCount') is not None:
            self.safe_event_count = m.get('SafeEventCount')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Tag') is not None:
            self.tag = m.get('Tag')
        if m.get('TagId') is not None:
            self.tag_id = m.get('TagId')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        if m.get('Vendor') is not None:
            self.vendor = m.get('Vendor')
        if m.get('VendorName') is not None:
            self.vendor_name = m.get('VendorName')
        if m.get('VpcInstanceId') is not None:
            self.vpc_instance_id = m.get('VpcInstanceId')
        if m.get('VulCount') is not None:
            self.vul_count = m.get('VulCount')
        if m.get('VulStatus') is not None:
            self.vul_status = m.get('VulStatus')
        return self


class DescribeCloudCenterInstancesResponseBodyPageInfo(TeaModel):
    def __init__(
        self,
        count: int = None,
        current_page: int = None,
        page_size: int = None,
        total_count: int = None,
    ):
        # The number of entries returned on the current page.
        self.count = count
        # The page number of the returned page.
        self.current_page = current_page
        # The number of entries returned per page. Default value: **20**.
        self.page_size = page_size
        # The total number of entries returned.
        self.total_count = total_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeCloudCenterInstancesResponseBody(TeaModel):
    def __init__(
        self,
        instances: List[DescribeCloudCenterInstancesResponseBodyInstances] = None,
        page_info: DescribeCloudCenterInstancesResponseBodyPageInfo = None,
        request_id: str = None,
        success: bool = None,
    ):
        # An array that consists of the details about the assets.
        self.instances = instances
        # The pagination information.
        self.page_info = page_info
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id
        # Indicates whether the request was successful. Valid values:
        # 
        # *   **true**: The request was successful.
        # *   **false**: The request failed.
        self.success = success

    def validate(self):
        if self.instances:
            for k in self.instances:
                if k:
                    k.validate()
        if self.page_info:
            self.page_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Instances'] = []
        if self.instances is not None:
            for k in self.instances:
                result['Instances'].append(k.to_map() if k else None)
        if self.page_info is not None:
            result['PageInfo'] = self.page_info.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.instances = []
        if m.get('Instances') is not None:
            for k in m.get('Instances'):
                temp_model = DescribeCloudCenterInstancesResponseBodyInstances()
                self.instances.append(temp_model.from_map(k))
        if m.get('PageInfo') is not None:
            temp_model = DescribeCloudCenterInstancesResponseBodyPageInfo()
            self.page_info = temp_model.from_map(m['PageInfo'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeCloudCenterInstancesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeCloudCenterInstancesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeCloudCenterInstancesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCloudProductFieldStatisticsResponseBodyGroupedFields(TeaModel):
    def __init__(
        self,
        category_count: str = None,
        instance_count: int = None,
        risk_instance_count: int = None,
    ):
        # The statistics of the numbers of assets of different types. **MachineType** indicates the type of the assets. **Count** indicates the number of assets that belong to the type.
        # Valid values of **MachineType**:
        # 
        # *   **1**: a Server Load Balancer (SLB) instance
        # *   **2**: a Network Address Translation (NAT) gateway
        # *   **3**: an ApsaraDB RDS instance
        # *   **4**: an ApsaraDB for MongoDB instance
        self.category_count = category_count
        # The total number of cloud services that are protected by Security Center.
        self.instance_count = instance_count
        # The number of cloud services that are at risk.
        self.risk_instance_count = risk_instance_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.category_count is not None:
            result['CategoryCount'] = self.category_count
        if self.instance_count is not None:
            result['InstanceCount'] = self.instance_count
        if self.risk_instance_count is not None:
            result['RiskInstanceCount'] = self.risk_instance_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CategoryCount') is not None:
            self.category_count = m.get('CategoryCount')
        if m.get('InstanceCount') is not None:
            self.instance_count = m.get('InstanceCount')
        if m.get('RiskInstanceCount') is not None:
            self.risk_instance_count = m.get('RiskInstanceCount')
        return self


class DescribeCloudProductFieldStatisticsResponseBody(TeaModel):
    def __init__(
        self,
        grouped_fields: DescribeCloudProductFieldStatisticsResponseBodyGroupedFields = None,
        request_id: str = None,
    ):
        # The statistics of cloud services.
        self.grouped_fields = grouped_fields
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id

    def validate(self):
        if self.grouped_fields:
            self.grouped_fields.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.grouped_fields is not None:
            result['GroupedFields'] = self.grouped_fields.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GroupedFields') is not None:
            temp_model = DescribeCloudProductFieldStatisticsResponseBodyGroupedFields()
            self.grouped_fields = temp_model.from_map(m['GroupedFields'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeCloudProductFieldStatisticsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeCloudProductFieldStatisticsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeCloudProductFieldStatisticsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeClusterBasicInfoRequest(TeaModel):
    def __init__(
        self,
        cluster_id: str = None,
        target_type: str = None,
        type: str = None,
    ):
        self.cluster_id = cluster_id
        self.target_type = target_type
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.target_type is not None:
            result['TargetType'] = self.target_type
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('TargetType') is not None:
            self.target_type = m.get('TargetType')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribeClusterBasicInfoResponseBodyClusterInfo(TeaModel):
    def __init__(
        self,
        cluster_id: str = None,
        cluster_name: str = None,
        cluster_type: str = None,
        create_time: int = None,
        current_version: str = None,
        instance_count: int = None,
        region_id: str = None,
        state: str = None,
        target_result: bool = None,
    ):
        self.cluster_id = cluster_id
        self.cluster_name = cluster_name
        self.cluster_type = cluster_type
        self.create_time = create_time
        self.current_version = current_version
        self.instance_count = instance_count
        self.region_id = region_id
        self.state = state
        self.target_result = target_result

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.cluster_name is not None:
            result['ClusterName'] = self.cluster_name
        if self.cluster_type is not None:
            result['ClusterType'] = self.cluster_type
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.current_version is not None:
            result['CurrentVersion'] = self.current_version
        if self.instance_count is not None:
            result['InstanceCount'] = self.instance_count
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.state is not None:
            result['State'] = self.state
        if self.target_result is not None:
            result['TargetResult'] = self.target_result
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('ClusterName') is not None:
            self.cluster_name = m.get('ClusterName')
        if m.get('ClusterType') is not None:
            self.cluster_type = m.get('ClusterType')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('CurrentVersion') is not None:
            self.current_version = m.get('CurrentVersion')
        if m.get('InstanceCount') is not None:
            self.instance_count = m.get('InstanceCount')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('State') is not None:
            self.state = m.get('State')
        if m.get('TargetResult') is not None:
            self.target_result = m.get('TargetResult')
        return self


class DescribeClusterBasicInfoResponseBody(TeaModel):
    def __init__(
        self,
        cluster_info: DescribeClusterBasicInfoResponseBodyClusterInfo = None,
        request_id: str = None,
    ):
        self.cluster_info = cluster_info
        self.request_id = request_id

    def validate(self):
        if self.cluster_info:
            self.cluster_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_info is not None:
            result['ClusterInfo'] = self.cluster_info.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClusterInfo') is not None:
            temp_model = DescribeClusterBasicInfoResponseBodyClusterInfo()
            self.cluster_info = temp_model.from_map(m['ClusterInfo'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeClusterBasicInfoResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeClusterBasicInfoResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeClusterBasicInfoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeClusterInfoListRequest(TeaModel):
    def __init__(
        self,
        target: str = None,
        target_type: str = None,
        type: str = None,
    ):
        self.target = target
        self.target_type = target_type
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.target is not None:
            result['Target'] = self.target
        if self.target_type is not None:
            result['TargetType'] = self.target_type
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Target') is not None:
            self.target = m.get('Target')
        if m.get('TargetType') is not None:
            self.target_type = m.get('TargetType')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribeClusterInfoListResponseBodyClusterList(TeaModel):
    def __init__(
        self,
        cluster_id: str = None,
        cluster_name: str = None,
        cluster_type: str = None,
        region_id: str = None,
        state: str = None,
        target_result: bool = None,
    ):
        self.cluster_id = cluster_id
        self.cluster_name = cluster_name
        self.cluster_type = cluster_type
        self.region_id = region_id
        self.state = state
        self.target_result = target_result

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.cluster_name is not None:
            result['ClusterName'] = self.cluster_name
        if self.cluster_type is not None:
            result['ClusterType'] = self.cluster_type
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.state is not None:
            result['State'] = self.state
        if self.target_result is not None:
            result['TargetResult'] = self.target_result
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('ClusterName') is not None:
            self.cluster_name = m.get('ClusterName')
        if m.get('ClusterType') is not None:
            self.cluster_type = m.get('ClusterType')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('State') is not None:
            self.state = m.get('State')
        if m.get('TargetResult') is not None:
            self.target_result = m.get('TargetResult')
        return self


class DescribeClusterInfoListResponseBody(TeaModel):
    def __init__(
        self,
        cluster_list: List[DescribeClusterInfoListResponseBodyClusterList] = None,
        request_id: str = None,
    ):
        self.cluster_list = cluster_list
        self.request_id = request_id

    def validate(self):
        if self.cluster_list:
            for k in self.cluster_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ClusterList'] = []
        if self.cluster_list is not None:
            for k in self.cluster_list:
                result['ClusterList'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.cluster_list = []
        if m.get('ClusterList') is not None:
            for k in m.get('ClusterList'):
                temp_model = DescribeClusterInfoListResponseBodyClusterList()
                self.cluster_list.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeClusterInfoListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeClusterInfoListResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeClusterInfoListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeClusterNetworkRequest(TeaModel):
    def __init__(
        self,
        end_time: int = None,
        start_time: int = None,
    ):
        self.end_time = end_time
        self.start_time = start_time

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.end_time is not None:
            result['EndTime'] = self.end_time
        if self.start_time is not None:
            result['StartTime'] = self.start_time
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('EndTime') is not None:
            self.end_time = m.get('EndTime')
        if m.get('StartTime') is not None:
            self.start_time = m.get('StartTime')
        return self


class DescribeClusterNetworkResponseBodyClusterNetworkEdge(TeaModel):
    def __init__(
        self,
        dst_node_id: str = None,
        dst_node_type: str = None,
        id: str = None,
        port: str = None,
        src_node_id: str = None,
        src_node_type: str = None,
    ):
        self.dst_node_id = dst_node_id
        self.dst_node_type = dst_node_type
        self.id = id
        self.port = port
        self.src_node_id = src_node_id
        self.src_node_type = src_node_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.dst_node_id is not None:
            result['DstNodeId'] = self.dst_node_id
        if self.dst_node_type is not None:
            result['DstNodeType'] = self.dst_node_type
        if self.id is not None:
            result['Id'] = self.id
        if self.port is not None:
            result['Port'] = self.port
        if self.src_node_id is not None:
            result['SrcNodeId'] = self.src_node_id
        if self.src_node_type is not None:
            result['SrcNodeType'] = self.src_node_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DstNodeId') is not None:
            self.dst_node_id = m.get('DstNodeId')
        if m.get('DstNodeType') is not None:
            self.dst_node_type = m.get('DstNodeType')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Port') is not None:
            self.port = m.get('Port')
        if m.get('SrcNodeId') is not None:
            self.src_node_id = m.get('SrcNodeId')
        if m.get('SrcNodeType') is not None:
            self.src_node_type = m.get('SrcNodeType')
        return self


class DescribeClusterNetworkResponseBodyClusterNetworkNode(TeaModel):
    def __init__(
        self,
        cnnf_switch: int = None,
        id: str = None,
        interception_type: int = None,
        name: str = None,
        net_topo_switch: str = None,
        risk_level: str = None,
        type: str = None,
    ):
        self.cnnf_switch = cnnf_switch
        self.id = id
        self.interception_type = interception_type
        self.name = name
        self.net_topo_switch = net_topo_switch
        self.risk_level = risk_level
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cnnf_switch is not None:
            result['CnnfSwitch'] = self.cnnf_switch
        if self.id is not None:
            result['Id'] = self.id
        if self.interception_type is not None:
            result['InterceptionType'] = self.interception_type
        if self.name is not None:
            result['Name'] = self.name
        if self.net_topo_switch is not None:
            result['NetTopoSwitch'] = self.net_topo_switch
        if self.risk_level is not None:
            result['RiskLevel'] = self.risk_level
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CnnfSwitch') is not None:
            self.cnnf_switch = m.get('CnnfSwitch')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('InterceptionType') is not None:
            self.interception_type = m.get('InterceptionType')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('NetTopoSwitch') is not None:
            self.net_topo_switch = m.get('NetTopoSwitch')
        if m.get('RiskLevel') is not None:
            self.risk_level = m.get('RiskLevel')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribeClusterNetworkResponseBodyClusterNetwork(TeaModel):
    def __init__(
        self,
        edge: List[DescribeClusterNetworkResponseBodyClusterNetworkEdge] = None,
        node: List[DescribeClusterNetworkResponseBodyClusterNetworkNode] = None,
    ):
        self.edge = edge
        self.node = node

    def validate(self):
        if self.edge:
            for k in self.edge:
                if k:
                    k.validate()
        if self.node:
            for k in self.node:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Edge'] = []
        if self.edge is not None:
            for k in self.edge:
                result['Edge'].append(k.to_map() if k else None)
        result['Node'] = []
        if self.node is not None:
            for k in self.node:
                result['Node'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.edge = []
        if m.get('Edge') is not None:
            for k in m.get('Edge'):
                temp_model = DescribeClusterNetworkResponseBodyClusterNetworkEdge()
                self.edge.append(temp_model.from_map(k))
        self.node = []
        if m.get('Node') is not None:
            for k in m.get('Node'):
                temp_model = DescribeClusterNetworkResponseBodyClusterNetworkNode()
                self.node.append(temp_model.from_map(k))
        return self


class DescribeClusterNetworkResponseBody(TeaModel):
    def __init__(
        self,
        cluster_network: DescribeClusterNetworkResponseBodyClusterNetwork = None,
        request_id: str = None,
    ):
        self.cluster_network = cluster_network
        self.request_id = request_id

    def validate(self):
        if self.cluster_network:
            self.cluster_network.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_network is not None:
            result['ClusterNetwork'] = self.cluster_network.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClusterNetwork') is not None:
            temp_model = DescribeClusterNetworkResponseBodyClusterNetwork()
            self.cluster_network = temp_model.from_map(m['ClusterNetwork'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeClusterNetworkResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeClusterNetworkResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeClusterNetworkResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeClusterVulStatisticsRequest(TeaModel):
    def __init__(
        self,
        cluster_id: str = None,
        types: str = None,
    ):
        self.cluster_id = cluster_id
        self.types = types

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.types is not None:
            result['Types'] = self.types
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('Types') is not None:
            self.types = m.get('Types')
        return self


class DescribeClusterVulStatisticsResponseBodyVulStat(TeaModel):
    def __init__(
        self,
        asap_count: str = None,
        later_count: str = None,
        nntf_count: str = None,
    ):
        self.asap_count = asap_count
        self.later_count = later_count
        self.nntf_count = nntf_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.asap_count is not None:
            result['AsapCount'] = self.asap_count
        if self.later_count is not None:
            result['LaterCount'] = self.later_count
        if self.nntf_count is not None:
            result['NntfCount'] = self.nntf_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AsapCount') is not None:
            self.asap_count = m.get('AsapCount')
        if m.get('LaterCount') is not None:
            self.later_count = m.get('LaterCount')
        if m.get('NntfCount') is not None:
            self.nntf_count = m.get('NntfCount')
        return self


class DescribeClusterVulStatisticsResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        vul_stat: DescribeClusterVulStatisticsResponseBodyVulStat = None,
    ):
        self.request_id = request_id
        self.vul_stat = vul_stat

    def validate(self):
        if self.vul_stat:
            self.vul_stat.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.vul_stat is not None:
            result['VulStat'] = self.vul_stat.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('VulStat') is not None:
            temp_model = DescribeClusterVulStatisticsResponseBodyVulStat()
            self.vul_stat = temp_model.from_map(m['VulStat'])
        return self


class DescribeClusterVulStatisticsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeClusterVulStatisticsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeClusterVulStatisticsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCommonOverallConfigRequest(TeaModel):
    def __init__(
        self,
        source_ip: str = None,
        type: str = None,
    ):
        # The source IP address of the request.
        self.source_ip = source_ip
        # The type of the feature. Valid values:
        # 
        # *   **kdump_switch**: Active defense experience optimization
        # *   **threat_detect**: Dynamic adaptive threat detection capability
        # *   **suspicious_aggregation**: Alert Association
        # *   **alidetect**: File Test
        # *   **USER-ENABLE-SWITCH-TYPE\_3277**: Suspicious process startup
        # *   **USER-ENABLE-SWITCH-TYPE\_5507**: malicious drivers
        # *   **USER-ENABLE-SWITCH-TYPE\_38857**: Entrance service execution high-risk operation
        # *   **USER-ENABLE-SWITCH-TYPE\_50858**: Web service performs high-risk operations
        # *   **USER-ENABLE-SWITCH-TYPE\_50859**: Entrance service execution suspicious operation
        # *   **USER-ENABLE-SWITCH-TYPE\_50861**: Information detection
        # *   **USER-ENABLE-SWITCH-TYPE\_50862**: Cloud Assistant Advanced Protection
        # *   **USER-ENABLE-SWITCH-TYPE\_50867**: Create malicious files
        # *   **USER-ENABLE-SWITCH-TYPE\_50868**: Create suspicious files
        # *   **USER-ENABLE-SWITCH-TYPE\_50869**: Unauthorized execution of high-risk orders
        # *   **USER-ENABLE-SWITCH-TYPE\_50870**: Rebound Shell
        # *   **USER-ENABLE-SWITCH-TYPE\_50873**: WebShell execute command
        # *   **USER-ENABLE-SWITCH-TYPE\_50876**: Against security software
        # *   **USER-ENABLE-SWITCH-TYPE\_50877**: Malicious soft communication
        # *   **USER-ENABLE-SWITCH-TYPE\_50884**: Suspicious worm script behavior
        # *   **USER-ENABLE-SWITCH-TYPE\_50885**: malicious script behavior
        # *   **USER-ENABLE-SWITCH-TYPE\_50983**: obfuscated command
        # *   **USER-ENABLE-SWITCH-TYPE\_51200**: Command line download and run malicious files
        # *   **USER-ENABLE-SWITCH-TYPE\_51201**: ransomware
        # *   **USER-ENABLE-SWITCH-TYPE\_51202**: Suspected Extortion
        # *   **USER-ENABLE-SWITCH-TYPE\_53168**: process debugging
        # *   **USER-ENABLE-SWITCH-TYPE\_53272**: Exploiting Kernel Vulnerabilities to Elevate Privileges
        # *   **USER-ENABLE-SWITCH-TYPE\_54034**: Intranet scan
        # *   **USER-ENABLE-SWITCH-TYPE\_54265**: Hijacking the PAM Module
        # *   **USER-ENABLE-SWITCH-TYPE\_54395**: Unauthorized reading and writing of sensitive files
        # *   **USER-ENABLE-SWITCH-TYPE\_54699**: Hijack dynamic link library
        # *   **USER-ENABLE-SWITCH-TYPE\_54953**: Hashdump Attack
        # *   **USER-ENABLE-SWITCH-TYPE\_57897**: suspected privilege escalation
        # *   **USER-ENABLE-SWITCH-TYPE\_62981**: Bypassing security monitoring
        # *   **USER-ENABLE-SWITCH-TYPE\_64025**: Ingress service execute command \[enhanced mode]
        # *   **USER-ENABLE-SWITCH-TYPE\_39659**: Sensitive Registry Key Protection
        # *   **USER-ENABLE-SWITCH-TYPE\_51225**: Powershell executes high-risk commands
        # *   **USER-ENABLE-SWITCH-TYPE\_51226**: Powershell execute suspicious command
        # *   **USER-ENABLE-SWITCH-TYPE\_51228**: High-risk lateral penetration tools
        # *   **USER-ENABLE-SWITCH-TYPE\_51229**: Browser service execution a high-risk operation
        # *   **USER-ENABLE-SWITCH-TYPE\_51230**: Entrance service execution suspicious operation
        # *   **USER-ENABLE-SWITCH-TYPE\_51232**: System processes execution high-risk operations
        # *   **USER-ENABLE-SWITCH-TYPE\_51233**: Java service execution high-risk operations
        # *   **USER-ENABLE-SWITCH-TYPE\_51234**: Office components execution high-risk operations
        # *   **USER-ENABLE-SWITCH-TYPE\_51235**: Web service performs high-risk operations
        # *   **USER-ENABLE-SWITCH-TYPE\_51236**: Rebound shells
        # *   **USER-ENABLE-SWITCH-TYPE\_52815**: Load high-risk drivers
        # *   **USER-ENABLE-SWITCH-TYPE\_52816**: high-risk account manipulation behavior
        # *   **USER-ENABLE-SWITCH-TYPE\_52818**: Information detection
        # *   **USER-ENABLE-SWITCH-TYPE\_52820**: Create malicious files
        # *   **USER-ENABLE-SWITCH-TYPE\_52821**: Suspicious process startup
        # *   **USER-ENABLE-SWITCH-TYPE\_52823**: Running high-risk ARK tools
        # *   **USER-ENABLE-SWITCH-TYPE\_52825**: Unauthorized execution of high-risk orders
        # *   **USER-ENABLE-SWITCH-TYPE\_52826**: Entrance service execution high-risk operation
        # *   **USER-ENABLE-SWITCH-TYPE\_52827**: Ransomware
        # *   **USER-ENABLE-SWITCH-TYPE\_52828**: Suspected Extortion
        # *   **USER-ENABLE-SWITCH-TYPE\_52829**: delete system backup behavior
        # *   **USER-ENABLE-SWITCH-TYPE\_54168**: LSA security permission service protection
        # *   **USER-ENABLE-SWITCH-TYPE\_54365**: Create service autorun item
        # *   **USER-ENABLE-SWITCH-TYPE\_54366**: Create high-risk autorun item
        # *   **USER-ENABLE-SWITCH-TYPE\_54367**: Create scheduled task autorun item
        # *   **USER-ENABLE-SWITCH-TYPE\_54368**: Create registry autorun item
        # *   **USER-ENABLE-SWITCH-TYPE\_54369**: Create WMI autorun item
        # *   **USER-ENABLE-SWITCH-TYPE\_54373**: Against security software
        # *   **USER-ENABLE-SWITCH-TYPE\_54374**: Intrusion trace cleanup
        # *   **USER-ENABLE-SWITCH-TYPE\_54384**: Hashdump Attack
        # *   **USER-ENABLE-SWITCH-TYPE\_55251**: Database services execution high-risk operations
        # *   **USER-ENABLE-SWITCH-TYPE\_57242**: Malicious command execution
        # *   **USER-ENABLE-SWITCH-TYPE\_57340**: Command line download and run malicious files
        # *   **USER-ENABLE-SWITCH-TYPE\_62357**: Cloud Assistant service information detection
        # *   **USER-ENABLE-SWITCH-TYPE\_63725**: Ingress service implants suspicious script/binary file
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribeCommonOverallConfigResponseBodyOverallConfig(TeaModel):
    def __init__(
        self,
        config: str = None,
        type: str = None,
    ):
        # The status of the feature. Valid values:
        # 
        # *   **on**: enabled
        # *   **off**: disabled
        self.config = config
        # The type of the feature. Valid values:
        # 
        # *   **kdump_switch**: Active defense experience optimization
        # *   **threat_detect**: Dynamic adaptive threat detection capability
        # *   **suspicious_aggregation**: Alert Association
        # *   **alidetect**: File Test
        # *   **USER-ENABLE-SWITCH-TYPE\_3277**: Suspicious process startup
        # *   **USER-ENABLE-SWITCH-TYPE\_5507**: malicious drivers
        # *   **USER-ENABLE-SWITCH-TYPE\_38857**: Entrance service execution high-risk operation
        # *   **USER-ENABLE-SWITCH-TYPE\_50858**: Web service performs high-risk operations
        # *   **USER-ENABLE-SWITCH-TYPE\_50859**: Entrance service execution suspicious operation
        # *   **USER-ENABLE-SWITCH-TYPE\_50861**: Information detection
        # *   **USER-ENABLE-SWITCH-TYPE\_50862**: Cloud Assistant Advanced Protection
        # *   **USER-ENABLE-SWITCH-TYPE\_50867**: Create malicious files
        # *   **USER-ENABLE-SWITCH-TYPE\_50868**: Create suspicious files
        # *   **USER-ENABLE-SWITCH-TYPE\_50869**: Unauthorized execution of high-risk orders
        # *   **USER-ENABLE-SWITCH-TYPE\_50870**: Rebound Shell
        # *   **USER-ENABLE-SWITCH-TYPE\_50873**: WebShell execute command
        # *   **USER-ENABLE-SWITCH-TYPE\_50876**: Against security software
        # *   **USER-ENABLE-SWITCH-TYPE\_50877**: Malicious soft communication
        # *   **USER-ENABLE-SWITCH-TYPE\_50884**: Suspicious worm script behavior
        # *   **USER-ENABLE-SWITCH-TYPE\_50885**: malicious script behavior
        # *   **USER-ENABLE-SWITCH-TYPE\_50983**: obfuscated command
        # *   **USER-ENABLE-SWITCH-TYPE\_51200**: Command line download and run malicious files
        # *   **USER-ENABLE-SWITCH-TYPE\_51201**: ransomware
        # *   **USER-ENABLE-SWITCH-TYPE\_51202**: Suspected Extortion
        # *   **USER-ENABLE-SWITCH-TYPE\_53168**: process debugging
        # *   **USER-ENABLE-SWITCH-TYPE\_53272**: Exploiting Kernel Vulnerabilities to Elevate Privileges
        # *   **USER-ENABLE-SWITCH-TYPE\_54034**: Intranet scan
        # *   **USER-ENABLE-SWITCH-TYPE\_54265**: Hijacking the PAM Module
        # *   **USER-ENABLE-SWITCH-TYPE\_54395**: Unauthorized reading and writing of sensitive files
        # *   **USER-ENABLE-SWITCH-TYPE\_54699**: Hijack dynamic link library
        # *   **USER-ENABLE-SWITCH-TYPE\_54953**: Hashdump Attack
        # *   **USER-ENABLE-SWITCH-TYPE\_57897**: suspected privilege escalation
        # *   **USER-ENABLE-SWITCH-TYPE\_62981**: Bypassing security monitoring
        # *   **USER-ENABLE-SWITCH-TYPE\_64025**: Ingress service execute command \[enhanced mode]
        # *   **USER-ENABLE-SWITCH-TYPE\_39659**: Sensitive Registry Key Protection
        # *   **USER-ENABLE-SWITCH-TYPE\_51225**: Powershell executes high-risk commands
        # *   **USER-ENABLE-SWITCH-TYPE\_51226**: Powershell execute suspicious command
        # *   **USER-ENABLE-SWITCH-TYPE\_51228**: High-risk lateral penetration tools
        # *   **USER-ENABLE-SWITCH-TYPE\_51229**: Browser service execution a high-risk operation
        # *   **USER-ENABLE-SWITCH-TYPE\_51230**: Entrance service execution suspicious operation
        # *   **USER-ENABLE-SWITCH-TYPE\_51232**: System processes execution high-risk operations
        # *   **USER-ENABLE-SWITCH-TYPE\_51233**: Java service execution high-risk operations
        # *   **USER-ENABLE-SWITCH-TYPE\_51234**: Office components execution high-risk operations
        # *   **USER-ENABLE-SWITCH-TYPE\_51235**: Web service performs high-risk operations
        # *   **USER-ENABLE-SWITCH-TYPE\_51236**: Rebound shells
        # *   **USER-ENABLE-SWITCH-TYPE\_52815**: Load high-risk drivers
        # *   **USER-ENABLE-SWITCH-TYPE\_52816**: high-risk account manipulation behavior
        # *   **USER-ENABLE-SWITCH-TYPE\_52818**: Information detection
        # *   **USER-ENABLE-SWITCH-TYPE\_52820**: Create malicious files
        # *   **USER-ENABLE-SWITCH-TYPE\_52821**: Suspicious process startup
        # *   **USER-ENABLE-SWITCH-TYPE\_52823**: Running high-risk ARK tools
        # *   **USER-ENABLE-SWITCH-TYPE\_52825**: Unauthorized execution of high-risk orders
        # *   **USER-ENABLE-SWITCH-TYPE\_52826**: Entrance service execution high-risk operation
        # *   **USER-ENABLE-SWITCH-TYPE\_52827**: Ransomware
        # *   **USER-ENABLE-SWITCH-TYPE\_52828**: Suspected Extortion
        # *   **USER-ENABLE-SWITCH-TYPE\_52829**: delete system backup behavior
        # *   **USER-ENABLE-SWITCH-TYPE\_54168**: LSA security permission service protection
        # *   **USER-ENABLE-SWITCH-TYPE\_54365**: Create service autorun item
        # *   **USER-ENABLE-SWITCH-TYPE\_54366**: Create high-risk autorun item
        # *   **USER-ENABLE-SWITCH-TYPE\_54367**: Create scheduled task autorun item
        # *   **USER-ENABLE-SWITCH-TYPE\_54368**: Create registry autorun item
        # *   **USER-ENABLE-SWITCH-TYPE\_54369**: Create WMI autorun item
        # *   **USER-ENABLE-SWITCH-TYPE\_54373**: Against security software
        # *   **USER-ENABLE-SWITCH-TYPE\_54374**: Intrusion trace cleanup
        # *   **USER-ENABLE-SWITCH-TYPE\_54384**: Hashdump Attack
        # *   **USER-ENABLE-SWITCH-TYPE\_55251**: Database services execution high-risk operations
        # *   **USER-ENABLE-SWITCH-TYPE\_57242**: Malicious command execution
        # *   **USER-ENABLE-SWITCH-TYPE\_57340**: Command line download and run malicious files
        # *   **USER-ENABLE-SWITCH-TYPE\_62357**: Cloud Assistant service information detection
        # *   **USER-ENABLE-SWITCH-TYPE\_63725**: Ingress service implants suspicious script/binary file
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config is not None:
            result['Config'] = self.config
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Config') is not None:
            self.config = m.get('Config')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribeCommonOverallConfigResponseBody(TeaModel):
    def __init__(
        self,
        overall_config: DescribeCommonOverallConfigResponseBodyOverallConfig = None,
        request_id: str = None,
    ):
        # The information about the feature.
        self.overall_config = overall_config
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id

    def validate(self):
        if self.overall_config:
            self.overall_config.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.overall_config is not None:
            result['OverallConfig'] = self.overall_config.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('OverallConfig') is not None:
            temp_model = DescribeCommonOverallConfigResponseBodyOverallConfig()
            self.overall_config = temp_model.from_map(m['OverallConfig'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeCommonOverallConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeCommonOverallConfigResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeCommonOverallConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCommonOverallConfigListRequest(TeaModel):
    def __init__(
        self,
        source_ip: str = None,
        type_list: List[str] = None,
    ):
        self.source_ip = source_ip
        self.type_list = type_list

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.type_list is not None:
            result['TypeList'] = self.type_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('TypeList') is not None:
            self.type_list = m.get('TypeList')
        return self


class DescribeCommonOverallConfigListResponseBodyOverallList(TeaModel):
    def __init__(
        self,
        config: str = None,
        total_count: int = None,
        type: str = None,
    ):
        self.config = config
        self.total_count = total_count
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config is not None:
            result['Config'] = self.config
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Config') is not None:
            self.config = m.get('Config')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribeCommonOverallConfigListResponseBody(TeaModel):
    def __init__(
        self,
        overall_list: List[DescribeCommonOverallConfigListResponseBodyOverallList] = None,
        request_id: str = None,
    ):
        self.overall_list = overall_list
        self.request_id = request_id

    def validate(self):
        if self.overall_list:
            for k in self.overall_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['OverallList'] = []
        if self.overall_list is not None:
            for k in self.overall_list:
                result['OverallList'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.overall_list = []
        if m.get('OverallList') is not None:
            for k in m.get('OverallList'):
                temp_model = DescribeCommonOverallConfigListResponseBodyOverallList()
                self.overall_list.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeCommonOverallConfigListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeCommonOverallConfigListResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeCommonOverallConfigListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCommonTargetConfigRequest(TeaModel):
    def __init__(
        self,
        type: str = None,
    ):
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribeCommonTargetConfigResponseBodyTargetList(TeaModel):
    def __init__(
        self,
        flag: str = None,
        target: str = None,
        target_type: str = None,
    ):
        self.flag = flag
        self.target = target
        self.target_type = target_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.flag is not None:
            result['Flag'] = self.flag
        if self.target is not None:
            result['Target'] = self.target
        if self.target_type is not None:
            result['TargetType'] = self.target_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Flag') is not None:
            self.flag = m.get('Flag')
        if m.get('Target') is not None:
            self.target = m.get('Target')
        if m.get('TargetType') is not None:
            self.target_type = m.get('TargetType')
        return self


class DescribeCommonTargetConfigResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        target_list: List[DescribeCommonTargetConfigResponseBodyTargetList] = None,
    ):
        self.request_id = request_id
        self.target_list = target_list

    def validate(self):
        if self.target_list:
            for k in self.target_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['TargetList'] = []
        if self.target_list is not None:
            for k in self.target_list:
                result['TargetList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.target_list = []
        if m.get('TargetList') is not None:
            for k in m.get('TargetList'):
                temp_model = DescribeCommonTargetConfigResponseBodyTargetList()
                self.target_list.append(temp_model.from_map(k))
        return self


class DescribeCommonTargetConfigResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeCommonTargetConfigResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeCommonTargetConfigResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCommonTargetResultListRequest(TeaModel):
    def __init__(
        self,
        source_ip: str = None,
        type: str = None,
    ):
        # The source IP address of the request.
        self.source_ip = source_ip
        # The type of the configuration item. Valid values:
        # 
        # *   **webshell_timescan**: webshell detection and removal
        # *   **aliscriptengine**: in-depth detection engine
        # *   **alidetect**: installation scope of local file detection
        # *   **alidetect-scan-enable**: detection scope of local file detection
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribeCommonTargetResultListResponseBodyTargetConfig(TeaModel):
    def __init__(
        self,
        flag: str = None,
        target_default: str = None,
        target_list: List[str] = None,
        target_type: str = None,
        total_count: str = None,
        type: str = None,
    ):
        # The identifier that indicates whether the configuration item is applied to the server. Valid values:
        # 
        # *   **add**: applied
        # *   **del**: not applied
        self.flag = flag
        # The default identifier.
        self.target_default = target_default
        # An array that consists of the IDs of the server groups or the UUIDs of the servers.
        # 
        # >  If **uuid** is returned for the **TargetType** parameter, **UUIDs** of the servers are returned. If **groupId** is returned for the **TargetType** parameter, IDs of the server groups are returned.
        self.target_list = target_list
        # The type of the server to which the configuration item is applied. Valid values:
        # 
        # *   **uuid**: a server
        # *   **groupId**: a server group
        self.target_type = target_type
        # The total number of entries returned.
        self.total_count = total_count
        # The type of the configuration item. Valid values:
        # 
        # *   **webshell_timescan**: webshell detection and removal
        # *   **aliscriptengine**: in-depth detection engine
        # *   **alidetect**: installation scope of local file detection
        # *   **alidetect-scan-enable**: detection scope of local file detection
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.flag is not None:
            result['Flag'] = self.flag
        if self.target_default is not None:
            result['TargetDefault'] = self.target_default
        if self.target_list is not None:
            result['TargetList'] = self.target_list
        if self.target_type is not None:
            result['TargetType'] = self.target_type
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Flag') is not None:
            self.flag = m.get('Flag')
        if m.get('TargetDefault') is not None:
            self.target_default = m.get('TargetDefault')
        if m.get('TargetList') is not None:
            self.target_list = m.get('TargetList')
        if m.get('TargetType') is not None:
            self.target_type = m.get('TargetType')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribeCommonTargetResultListResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        target_config: DescribeCommonTargetResultListResponseBodyTargetConfig = None,
    ):
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id
        # The information about the configuration item.
        self.target_config = target_config

    def validate(self):
        if self.target_config:
            self.target_config.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.target_config is not None:
            result['TargetConfig'] = self.target_config.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TargetConfig') is not None:
            temp_model = DescribeCommonTargetResultListResponseBodyTargetConfig()
            self.target_config = temp_model.from_map(m['TargetConfig'])
        return self


class DescribeCommonTargetResultListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeCommonTargetResultListResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeCommonTargetResultListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeConcernNecessityRequest(TeaModel):
    def __init__(
        self,
        lang: str = None,
    ):
        # The language of the content within the request and response. Valid values:
        # 
        # *   **zh**: Chinese
        # *   **en**: English
        self.lang = lang

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.lang is not None:
            result['Lang'] = self.lang
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        return self


class DescribeConcernNecessityResponseBody(TeaModel):
    def __init__(
        self,
        concern_necessity: List[str] = None,
        request_id: str = None,
    ):
        # The priorities to fix the vulnerabilities. Valid values:
        # 
        # *   asap: high
        # *   later: medium
        # *   nntf: low
        self.concern_necessity = concern_necessity
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.concern_necessity is not None:
            result['ConcernNecessity'] = self.concern_necessity
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConcernNecessity') is not None:
            self.concern_necessity = m.get('ConcernNecessity')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeConcernNecessityResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeConcernNecessityResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeConcernNecessityResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeContainerCriteriaRequest(TeaModel):
    def __init__(
        self,
        group_field: str = None,
        value: str = None,
    ):
        self.group_field = group_field
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.group_field is not None:
            result['GroupField'] = self.group_field
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GroupField') is not None:
            self.group_field = m.get('GroupField')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeContainerCriteriaResponseBodyCriteriaList(TeaModel):
    def __init__(
        self,
        name: str = None,
        type: str = None,
        values: str = None,
    ):
        self.name = name
        self.type = type
        self.values = values

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.type is not None:
            result['Type'] = self.type
        if self.values is not None:
            result['Values'] = self.values
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Values') is not None:
            self.values = m.get('Values')
        return self


class DescribeContainerCriteriaResponseBody(TeaModel):
    def __init__(
        self,
        criteria_list: List[DescribeContainerCriteriaResponseBodyCriteriaList] = None,
        request_id: str = None,
    ):
        self.criteria_list = criteria_list
        self.request_id = request_id

    def validate(self):
        if self.criteria_list:
            for k in self.criteria_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['CriteriaList'] = []
        if self.criteria_list is not None:
            for k in self.criteria_list:
                result['CriteriaList'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.criteria_list = []
        if m.get('CriteriaList') is not None:
            for k in m.get('CriteriaList'):
                temp_model = DescribeContainerCriteriaResponseBodyCriteriaList()
                self.criteria_list.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeContainerCriteriaResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeContainerCriteriaResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeContainerCriteriaResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeContainerInstancesRequest(TeaModel):
    def __init__(
        self,
        criteria: str = None,
        current_page: int = None,
        logical_exp: str = None,
        page_size: int = None,
    ):
        self.criteria = criteria
        self.current_page = current_page
        self.logical_exp = logical_exp
        self.page_size = page_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.criteria is not None:
            result['Criteria'] = self.criteria
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.logical_exp is not None:
            result['LogicalExp'] = self.logical_exp
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Criteria') is not None:
            self.criteria = m.get('Criteria')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('LogicalExp') is not None:
            self.logical_exp = m.get('LogicalExp')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class DescribeContainerInstancesResponseBodyContainerInstanceList(TeaModel):
    def __init__(
        self,
        alarm_count: int = None,
        alarm_status: str = None,
        app_name: str = None,
        cluster_id: str = None,
        cluster_name: str = None,
        container_id: str = None,
        create_timestamp: int = None,
        hc_count: int = None,
        hc_status: str = None,
        host_ip: str = None,
        image: str = None,
        image_digest: str = None,
        image_id: str = None,
        image_repo_name: str = None,
        image_repo_namespace: str = None,
        image_repo_tag: str = None,
        image_uuid: str = None,
        instance_id: str = None,
        namespace: str = None,
        node_info: str = None,
        node_name: str = None,
        pod: str = None,
        pod_ip: str = None,
        region_id: str = None,
        risk_count: str = None,
        risk_status: str = None,
        update_mark: str = None,
        vul_count: int = None,
        vul_status: str = None,
    ):
        self.alarm_count = alarm_count
        self.alarm_status = alarm_status
        self.app_name = app_name
        self.cluster_id = cluster_id
        self.cluster_name = cluster_name
        self.container_id = container_id
        self.create_timestamp = create_timestamp
        self.hc_count = hc_count
        self.hc_status = hc_status
        self.host_ip = host_ip
        self.image = image
        self.image_digest = image_digest
        self.image_id = image_id
        self.image_repo_name = image_repo_name
        self.image_repo_namespace = image_repo_namespace
        self.image_repo_tag = image_repo_tag
        self.image_uuid = image_uuid
        self.instance_id = instance_id
        self.namespace = namespace
        self.node_info = node_info
        self.node_name = node_name
        self.pod = pod
        self.pod_ip = pod_ip
        self.region_id = region_id
        self.risk_count = risk_count
        self.risk_status = risk_status
        self.update_mark = update_mark
        self.vul_count = vul_count
        self.vul_status = vul_status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alarm_count is not None:
            result['AlarmCount'] = self.alarm_count
        if self.alarm_status is not None:
            result['AlarmStatus'] = self.alarm_status
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.cluster_name is not None:
            result['ClusterName'] = self.cluster_name
        if self.container_id is not None:
            result['ContainerId'] = self.container_id
        if self.create_timestamp is not None:
            result['CreateTimestamp'] = self.create_timestamp
        if self.hc_count is not None:
            result['HcCount'] = self.hc_count
        if self.hc_status is not None:
            result['HcStatus'] = self.hc_status
        if self.host_ip is not None:
            result['HostIp'] = self.host_ip
        if self.image is not None:
            result['Image'] = self.image
        if self.image_digest is not None:
            result['ImageDigest'] = self.image_digest
        if self.image_id is not None:
            result['ImageId'] = self.image_id
        if self.image_repo_name is not None:
            result['ImageRepoName'] = self.image_repo_name
        if self.image_repo_namespace is not None:
            result['ImageRepoNamespace'] = self.image_repo_namespace
        if self.image_repo_tag is not None:
            result['ImageRepoTag'] = self.image_repo_tag
        if self.image_uuid is not None:
            result['ImageUuid'] = self.image_uuid
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.node_info is not None:
            result['NodeInfo'] = self.node_info
        if self.node_name is not None:
            result['NodeName'] = self.node_name
        if self.pod is not None:
            result['Pod'] = self.pod
        if self.pod_ip is not None:
            result['PodIp'] = self.pod_ip
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.risk_count is not None:
            result['RiskCount'] = self.risk_count
        if self.risk_status is not None:
            result['RiskStatus'] = self.risk_status
        if self.update_mark is not None:
            result['UpdateMark'] = self.update_mark
        if self.vul_count is not None:
            result['VulCount'] = self.vul_count
        if self.vul_status is not None:
            result['VulStatus'] = self.vul_status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AlarmCount') is not None:
            self.alarm_count = m.get('AlarmCount')
        if m.get('AlarmStatus') is not None:
            self.alarm_status = m.get('AlarmStatus')
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('ClusterName') is not None:
            self.cluster_name = m.get('ClusterName')
        if m.get('ContainerId') is not None:
            self.container_id = m.get('ContainerId')
        if m.get('CreateTimestamp') is not None:
            self.create_timestamp = m.get('CreateTimestamp')
        if m.get('HcCount') is not None:
            self.hc_count = m.get('HcCount')
        if m.get('HcStatus') is not None:
            self.hc_status = m.get('HcStatus')
        if m.get('HostIp') is not None:
            self.host_ip = m.get('HostIp')
        if m.get('Image') is not None:
            self.image = m.get('Image')
        if m.get('ImageDigest') is not None:
            self.image_digest = m.get('ImageDigest')
        if m.get('ImageId') is not None:
            self.image_id = m.get('ImageId')
        if m.get('ImageRepoName') is not None:
            self.image_repo_name = m.get('ImageRepoName')
        if m.get('ImageRepoNamespace') is not None:
            self.image_repo_namespace = m.get('ImageRepoNamespace')
        if m.get('ImageRepoTag') is not None:
            self.image_repo_tag = m.get('ImageRepoTag')
        if m.get('ImageUuid') is not None:
            self.image_uuid = m.get('ImageUuid')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('NodeInfo') is not None:
            self.node_info = m.get('NodeInfo')
        if m.get('NodeName') is not None:
            self.node_name = m.get('NodeName')
        if m.get('Pod') is not None:
            self.pod = m.get('Pod')
        if m.get('PodIp') is not None:
            self.pod_ip = m.get('PodIp')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('RiskCount') is not None:
            self.risk_count = m.get('RiskCount')
        if m.get('RiskStatus') is not None:
            self.risk_status = m.get('RiskStatus')
        if m.get('UpdateMark') is not None:
            self.update_mark = m.get('UpdateMark')
        if m.get('VulCount') is not None:
            self.vul_count = m.get('VulCount')
        if m.get('VulStatus') is not None:
            self.vul_status = m.get('VulStatus')
        return self


class DescribeContainerInstancesResponseBodyPageInfo(TeaModel):
    def __init__(
        self,
        count: int = None,
        current_page: int = None,
        page_size: int = None,
        total_count: int = None,
    ):
        self.count = count
        self.current_page = current_page
        self.page_size = page_size
        self.total_count = total_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeContainerInstancesResponseBody(TeaModel):
    def __init__(
        self,
        container_instance_list: List[DescribeContainerInstancesResponseBodyContainerInstanceList] = None,
        page_info: DescribeContainerInstancesResponseBodyPageInfo = None,
        request_id: str = None,
    ):
        self.container_instance_list = container_instance_list
        self.page_info = page_info
        self.request_id = request_id

    def validate(self):
        if self.container_instance_list:
            for k in self.container_instance_list:
                if k:
                    k.validate()
        if self.page_info:
            self.page_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ContainerInstanceList'] = []
        if self.container_instance_list is not None:
            for k in self.container_instance_list:
                result['ContainerInstanceList'].append(k.to_map() if k else None)
        if self.page_info is not None:
            result['PageInfo'] = self.page_info.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.container_instance_list = []
        if m.get('ContainerInstanceList') is not None:
            for k in m.get('ContainerInstanceList'):
                temp_model = DescribeContainerInstancesResponseBodyContainerInstanceList()
                self.container_instance_list.append(temp_model.from_map(k))
        if m.get('PageInfo') is not None:
            temp_model = DescribeContainerInstancesResponseBodyPageInfo()
            self.page_info = temp_model.from_map(m['PageInfo'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeContainerInstancesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeContainerInstancesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeContainerInstancesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeContainerStatisticsRequest(TeaModel):
    def __init__(
        self,
        cluster_id: str = None,
    ):
        # The ID of the container cluster.
        # 
        # >  You can call the [DescribeGroupedContainerInstances](~~DescribeGroupedContainerInstances~~) operation to query the IDs of container clusters.
        self.cluster_id = cluster_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        return self


class DescribeContainerStatisticsResponseBodyData(TeaModel):
    def __init__(
        self,
        remind_alarm_count: int = None,
        serious_alarm_count: int = None,
        suspicious_alarm_count: int = None,
        total_alarm_count: int = None,
        total_node: int = None,
        has_risk_node: int = None,
    ):
        # The number of alerts whose risk level is **Reminder**.
        self.remind_alarm_count = remind_alarm_count
        # The number of alerts whose risk level is **Urgent**.
        self.serious_alarm_count = serious_alarm_count
        # The number of alerts whose risk level is **Suspicious**.
        self.suspicious_alarm_count = suspicious_alarm_count
        # The total number of alerts that are generated in the current container cluster.
        self.total_alarm_count = total_alarm_count
        # The total number of nodes in the current container cluster.
        self.total_node = total_node
        # The number of nodes on which alerts are generated in the current container cluster.
        self.has_risk_node = has_risk_node

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.remind_alarm_count is not None:
            result['RemindAlarmCount'] = self.remind_alarm_count
        if self.serious_alarm_count is not None:
            result['SeriousAlarmCount'] = self.serious_alarm_count
        if self.suspicious_alarm_count is not None:
            result['SuspiciousAlarmCount'] = self.suspicious_alarm_count
        if self.total_alarm_count is not None:
            result['TotalAlarmCount'] = self.total_alarm_count
        if self.total_node is not None:
            result['TotalNode'] = self.total_node
        if self.has_risk_node is not None:
            result['hasRiskNode'] = self.has_risk_node
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RemindAlarmCount') is not None:
            self.remind_alarm_count = m.get('RemindAlarmCount')
        if m.get('SeriousAlarmCount') is not None:
            self.serious_alarm_count = m.get('SeriousAlarmCount')
        if m.get('SuspiciousAlarmCount') is not None:
            self.suspicious_alarm_count = m.get('SuspiciousAlarmCount')
        if m.get('TotalAlarmCount') is not None:
            self.total_alarm_count = m.get('TotalAlarmCount')
        if m.get('TotalNode') is not None:
            self.total_node = m.get('TotalNode')
        if m.get('hasRiskNode') is not None:
            self.has_risk_node = m.get('hasRiskNode')
        return self


class DescribeContainerStatisticsResponseBody(TeaModel):
    def __init__(
        self,
        data: DescribeContainerStatisticsResponseBodyData = None,
        request_id: str = None,
    ):
        # The alert statistics of container assets.
        self.data = data
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = DescribeContainerStatisticsResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeContainerStatisticsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeContainerStatisticsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeContainerStatisticsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCountNotScannedImageResponseBody(TeaModel):
    def __init__(
        self,
        not_scanned_cnt: int = None,
        request_id: str = None,
    ):
        self.not_scanned_cnt = not_scanned_cnt
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.not_scanned_cnt is not None:
            result['NotScannedCnt'] = self.not_scanned_cnt
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('NotScannedCnt') is not None:
            self.not_scanned_cnt = m.get('NotScannedCnt')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeCountNotScannedImageResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeCountNotScannedImageResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeCountNotScannedImageResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCountScannedImageResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        scanned_count: int = None,
    ):
        self.request_id = request_id
        self.scanned_count = scanned_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.scanned_count is not None:
            result['ScannedCount'] = self.scanned_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ScannedCount') is not None:
            self.scanned_count = m.get('ScannedCount')
        return self


class DescribeCountScannedImageResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeCountScannedImageResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeCountScannedImageResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCriteriaRequest(TeaModel):
    def __init__(
        self,
        machine_types: str = None,
        support_auto_tag: bool = None,
        value: str = None,
    ):
        # The type of the asset. Valid values:
        # 
        # *   **ecs**: Elastic Compute Service (ECS) instance
        self.machine_types = machine_types
        # Specifies whether the keyword that you specify for fuzzy search can be automatically matched. default **false**, Valid values:
        # 
        # *   **true**: yes
        # *   **false**: no
        self.support_auto_tag = support_auto_tag
        # The keyword that you specify for fuzzy search when you query the asset.
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.machine_types is not None:
            result['MachineTypes'] = self.machine_types
        if self.support_auto_tag is not None:
            result['SupportAutoTag'] = self.support_auto_tag
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MachineTypes') is not None:
            self.machine_types = m.get('MachineTypes')
        if m.get('SupportAutoTag') is not None:
            self.support_auto_tag = m.get('SupportAutoTag')
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeCriteriaResponseBodyCriteriaList(TeaModel):
    def __init__(
        self,
        multi_values: str = None,
        name: str = None,
        type: str = None,
        values: str = None,
    ):
        # The structured attribute values of the assets that match the keyword. The value of this parameter is in the JSON format and contains the following fields:
        # 
        # *   **vendor**: providers
        # *   **regionIds**: IDs of supported regions
        self.multi_values = multi_values
        # The name of the filter condition.
        self.name = name
        # The type of the filter condition. Valid values:
        # 
        # *   **input**: The filter condition needs to be specified.
        # *   **select**: The filter condition is an option that can be selected from the drop-down list.
        self.type = type
        # The attribute values of the assets that match the keyword.
        self.values = values

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.multi_values is not None:
            result['MultiValues'] = self.multi_values
        if self.name is not None:
            result['Name'] = self.name
        if self.type is not None:
            result['Type'] = self.type
        if self.values is not None:
            result['Values'] = self.values
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MultiValues') is not None:
            self.multi_values = m.get('MultiValues')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Values') is not None:
            self.values = m.get('Values')
        return self


class DescribeCriteriaResponseBody(TeaModel):
    def __init__(
        self,
        criteria_list: List[DescribeCriteriaResponseBodyCriteriaList] = None,
        request_id: str = None,
    ):
        # An array that consists of the filter conditions.
        self.criteria_list = criteria_list
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id

    def validate(self):
        if self.criteria_list:
            for k in self.criteria_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['CriteriaList'] = []
        if self.criteria_list is not None:
            for k in self.criteria_list:
                result['CriteriaList'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.criteria_list = []
        if m.get('CriteriaList') is not None:
            for k in m.get('CriteriaList'):
                temp_model = DescribeCriteriaResponseBodyCriteriaList()
                self.criteria_list.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeCriteriaResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeCriteriaResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeCriteriaResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCustomBlockRecordsRequest(TeaModel):
    def __init__(
        self,
        block_ip: str = None,
        current_page: int = None,
        page_size: int = None,
        resource_owner_id: int = None,
        status: int = None,
    ):
        self.block_ip = block_ip
        self.current_page = current_page
        self.page_size = page_size
        self.resource_owner_id = resource_owner_id
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.block_ip is not None:
            result['BlockIp'] = self.block_ip
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.resource_owner_id is not None:
            result['ResourceOwnerId'] = self.resource_owner_id
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BlockIp') is not None:
            self.block_ip = m.get('BlockIp')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('ResourceOwnerId') is not None:
            self.resource_owner_id = m.get('ResourceOwnerId')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DescribeCustomBlockRecordsResponseBodyPageInfo(TeaModel):
    def __init__(
        self,
        count: int = None,
        current_page: int = None,
        page_size: int = None,
        total_count: int = None,
    ):
        self.count = count
        self.current_page = current_page
        self.page_size = page_size
        self.total_count = total_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeCustomBlockRecordsResponseBodyRecordListTargetList(TeaModel):
    def __init__(
        self,
        target: str = None,
        target_type: str = None,
    ):
        self.target = target
        self.target_type = target_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.target is not None:
            result['Target'] = self.target
        if self.target_type is not None:
            result['TargetType'] = self.target_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Target') is not None:
            self.target = m.get('Target')
        if m.get('TargetType') is not None:
            self.target_type = m.get('TargetType')
        return self


class DescribeCustomBlockRecordsResponseBodyRecordList(TeaModel):
    def __init__(
        self,
        block_expire_date: int = None,
        block_ip: str = None,
        bound: str = None,
        enable_count: int = None,
        id: int = None,
        server_count: int = None,
        source: str = None,
        status: int = None,
        target_list: List[DescribeCustomBlockRecordsResponseBodyRecordListTargetList] = None,
    ):
        self.block_expire_date = block_expire_date
        self.block_ip = block_ip
        self.bound = bound
        self.enable_count = enable_count
        self.id = id
        self.server_count = server_count
        self.source = source
        self.status = status
        self.target_list = target_list

    def validate(self):
        if self.target_list:
            for k in self.target_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.block_expire_date is not None:
            result['BlockExpireDate'] = self.block_expire_date
        if self.block_ip is not None:
            result['BlockIp'] = self.block_ip
        if self.bound is not None:
            result['Bound'] = self.bound
        if self.enable_count is not None:
            result['EnableCount'] = self.enable_count
        if self.id is not None:
            result['Id'] = self.id
        if self.server_count is not None:
            result['ServerCount'] = self.server_count
        if self.source is not None:
            result['Source'] = self.source
        if self.status is not None:
            result['Status'] = self.status
        result['TargetList'] = []
        if self.target_list is not None:
            for k in self.target_list:
                result['TargetList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BlockExpireDate') is not None:
            self.block_expire_date = m.get('BlockExpireDate')
        if m.get('BlockIp') is not None:
            self.block_ip = m.get('BlockIp')
        if m.get('Bound') is not None:
            self.bound = m.get('Bound')
        if m.get('EnableCount') is not None:
            self.enable_count = m.get('EnableCount')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('ServerCount') is not None:
            self.server_count = m.get('ServerCount')
        if m.get('Source') is not None:
            self.source = m.get('Source')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        self.target_list = []
        if m.get('TargetList') is not None:
            for k in m.get('TargetList'):
                temp_model = DescribeCustomBlockRecordsResponseBodyRecordListTargetList()
                self.target_list.append(temp_model.from_map(k))
        return self


class DescribeCustomBlockRecordsResponseBody(TeaModel):
    def __init__(
        self,
        page_info: DescribeCustomBlockRecordsResponseBodyPageInfo = None,
        record_list: List[DescribeCustomBlockRecordsResponseBodyRecordList] = None,
        request_id: str = None,
    ):
        self.page_info = page_info
        self.record_list = record_list
        self.request_id = request_id

    def validate(self):
        if self.page_info:
            self.page_info.validate()
        if self.record_list:
            for k in self.record_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_info is not None:
            result['PageInfo'] = self.page_info.to_map()
        result['RecordList'] = []
        if self.record_list is not None:
            for k in self.record_list:
                result['RecordList'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageInfo') is not None:
            temp_model = DescribeCustomBlockRecordsResponseBodyPageInfo()
            self.page_info = temp_model.from_map(m['PageInfo'])
        self.record_list = []
        if m.get('RecordList') is not None:
            for k in m.get('RecordList'):
                temp_model = DescribeCustomBlockRecordsResponseBodyRecordList()
                self.record_list.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeCustomBlockRecordsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeCustomBlockRecordsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeCustomBlockRecordsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeCycleTaskListRequest(TeaModel):
    def __init__(
        self,
        current_page: int = None,
        page_size: int = None,
        task_name: str = None,
        task_type: str = None,
    ):
        self.current_page = current_page
        self.page_size = page_size
        self.task_name = task_name
        self.task_type = task_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.task_name is not None:
            result['TaskName'] = self.task_name
        if self.task_type is not None:
            result['TaskType'] = self.task_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TaskName') is not None:
            self.task_name = m.get('TaskName')
        if m.get('TaskType') is not None:
            self.task_type = m.get('TaskType')
        return self


class DescribeCycleTaskListResponseBodyCycleScheduleResponseList(TeaModel):
    def __init__(
        self,
        config_id: str = None,
        enable: int = None,
        first_date_str: int = None,
        interval_period: int = None,
        last_task_id: str = None,
        next_start_time_str: int = None,
        param: str = None,
        period_unit: str = None,
        target_end_time: int = None,
        target_start_time: int = None,
        task_name: str = None,
        task_type: str = None,
    ):
        self.config_id = config_id
        self.enable = enable
        self.first_date_str = first_date_str
        self.interval_period = interval_period
        self.last_task_id = last_task_id
        self.next_start_time_str = next_start_time_str
        self.param = param
        self.period_unit = period_unit
        self.target_end_time = target_end_time
        self.target_start_time = target_start_time
        self.task_name = task_name
        self.task_type = task_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.config_id is not None:
            result['ConfigId'] = self.config_id
        if self.enable is not None:
            result['Enable'] = self.enable
        if self.first_date_str is not None:
            result['FirstDateStr'] = self.first_date_str
        if self.interval_period is not None:
            result['IntervalPeriod'] = self.interval_period
        if self.last_task_id is not None:
            result['LastTaskId'] = self.last_task_id
        if self.next_start_time_str is not None:
            result['NextStartTimeStr'] = self.next_start_time_str
        if self.param is not None:
            result['Param'] = self.param
        if self.period_unit is not None:
            result['PeriodUnit'] = self.period_unit
        if self.target_end_time is not None:
            result['TargetEndTime'] = self.target_end_time
        if self.target_start_time is not None:
            result['TargetStartTime'] = self.target_start_time
        if self.task_name is not None:
            result['TaskName'] = self.task_name
        if self.task_type is not None:
            result['TaskType'] = self.task_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ConfigId') is not None:
            self.config_id = m.get('ConfigId')
        if m.get('Enable') is not None:
            self.enable = m.get('Enable')
        if m.get('FirstDateStr') is not None:
            self.first_date_str = m.get('FirstDateStr')
        if m.get('IntervalPeriod') is not None:
            self.interval_period = m.get('IntervalPeriod')
        if m.get('LastTaskId') is not None:
            self.last_task_id = m.get('LastTaskId')
        if m.get('NextStartTimeStr') is not None:
            self.next_start_time_str = m.get('NextStartTimeStr')
        if m.get('Param') is not None:
            self.param = m.get('Param')
        if m.get('PeriodUnit') is not None:
            self.period_unit = m.get('PeriodUnit')
        if m.get('TargetEndTime') is not None:
            self.target_end_time = m.get('TargetEndTime')
        if m.get('TargetStartTime') is not None:
            self.target_start_time = m.get('TargetStartTime')
        if m.get('TaskName') is not None:
            self.task_name = m.get('TaskName')
        if m.get('TaskType') is not None:
            self.task_type = m.get('TaskType')
        return self


class DescribeCycleTaskListResponseBodyPageInfo(TeaModel):
    def __init__(
        self,
        count: int = None,
        current_page: int = None,
        page_size: int = None,
        total_count: int = None,
    ):
        self.count = count
        self.current_page = current_page
        self.page_size = page_size
        self.total_count = total_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeCycleTaskListResponseBody(TeaModel):
    def __init__(
        self,
        cycle_schedule_response_list: List[DescribeCycleTaskListResponseBodyCycleScheduleResponseList] = None,
        page_info: DescribeCycleTaskListResponseBodyPageInfo = None,
        request_id: str = None,
    ):
        self.cycle_schedule_response_list = cycle_schedule_response_list
        self.page_info = page_info
        self.request_id = request_id

    def validate(self):
        if self.cycle_schedule_response_list:
            for k in self.cycle_schedule_response_list:
                if k:
                    k.validate()
        if self.page_info:
            self.page_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['CycleScheduleResponseList'] = []
        if self.cycle_schedule_response_list is not None:
            for k in self.cycle_schedule_response_list:
                result['CycleScheduleResponseList'].append(k.to_map() if k else None)
        if self.page_info is not None:
            result['PageInfo'] = self.page_info.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.cycle_schedule_response_list = []
        if m.get('CycleScheduleResponseList') is not None:
            for k in m.get('CycleScheduleResponseList'):
                temp_model = DescribeCycleTaskListResponseBodyCycleScheduleResponseList()
                self.cycle_schedule_response_list.append(temp_model.from_map(k))
        if m.get('PageInfo') is not None:
            temp_model = DescribeCycleTaskListResponseBodyPageInfo()
            self.page_info = temp_model.from_map(m['PageInfo'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeCycleTaskListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeCycleTaskListResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeCycleTaskListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDingTalkRequest(TeaModel):
    def __init__(
        self,
        current_page: int = None,
        page_size: int = None,
        rule_action_name: str = None,
    ):
        # The number of the page to return.Default value: 1.
        self.current_page = current_page
        # The number of entries to return on each page.Default value: 20.
        self.page_size = page_size
        # The name of the notification.
        self.rule_action_name = rule_action_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.rule_action_name is not None:
            result['RuleActionName'] = self.rule_action_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RuleActionName') is not None:
            self.rule_action_name = m.get('RuleActionName')
        return self


class DescribeDingTalkResponseBodyActionList(TeaModel):
    def __init__(
        self,
        action_name: str = None,
        ali_uid: int = None,
        config_list: str = None,
        ding_talk_lang: str = None,
        gmt_create: int = None,
        gmt_modified: int = None,
        group_id_list: str = None,
        id: int = None,
        interval_time: int = None,
        status: int = None,
        url: str = None,
    ):
        # The name of the notification.
        self.action_name = action_name
        # The UID of the user.
        self.ali_uid = ali_uid
        # The list of notification settings.
        self.config_list = config_list
        # The language of the content within notifications. Valid values:
        # 
        # *   **zh**: Chinese
        # *   **en**: English
        self.ding_talk_lang = ding_talk_lang
        # The creation time. unit:millisecond.
        self.gmt_create = gmt_create
        # The modification time.
        self.gmt_modified = gmt_modified
        # The group IDs.
        self.group_id_list = group_id_list
        # The ID of the notification.
        self.id = id
        # The interval at which the notifications are sent.unit:minute.
        self.interval_time = interval_time
        # The status of the notification. Valid values:
        # 
        # *   **0**: disabled
        # *   **1**: enabled
        self.status = status
        # The parameters of the notification.
        self.url = url

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.action_name is not None:
            result['ActionName'] = self.action_name
        if self.ali_uid is not None:
            result['AliUid'] = self.ali_uid
        if self.config_list is not None:
            result['ConfigList'] = self.config_list
        if self.ding_talk_lang is not None:
            result['DingTalkLang'] = self.ding_talk_lang
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.gmt_modified is not None:
            result['GmtModified'] = self.gmt_modified
        if self.group_id_list is not None:
            result['GroupIdList'] = self.group_id_list
        if self.id is not None:
            result['Id'] = self.id
        if self.interval_time is not None:
            result['IntervalTime'] = self.interval_time
        if self.status is not None:
            result['Status'] = self.status
        if self.url is not None:
            result['Url'] = self.url
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ActionName') is not None:
            self.action_name = m.get('ActionName')
        if m.get('AliUid') is not None:
            self.ali_uid = m.get('AliUid')
        if m.get('ConfigList') is not None:
            self.config_list = m.get('ConfigList')
        if m.get('DingTalkLang') is not None:
            self.ding_talk_lang = m.get('DingTalkLang')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('GmtModified') is not None:
            self.gmt_modified = m.get('GmtModified')
        if m.get('GroupIdList') is not None:
            self.group_id_list = m.get('GroupIdList')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('IntervalTime') is not None:
            self.interval_time = m.get('IntervalTime')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Url') is not None:
            self.url = m.get('Url')
        return self


class DescribeDingTalkResponseBodyPageInfo(TeaModel):
    def __init__(
        self,
        current_page: int = None,
        page_size: int = None,
        total_count: int = None,
    ):
        # The page number of the returned page.
        self.current_page = current_page
        # The number of entries returned per page.
        self.page_size = page_size
        # The total number of messages.
        self.total_count = total_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeDingTalkResponseBody(TeaModel):
    def __init__(
        self,
        action_list: List[DescribeDingTalkResponseBodyActionList] = None,
        page_info: DescribeDingTalkResponseBodyPageInfo = None,
        request_id: str = None,
    ):
        # An array that consists of details of notifications.
        self.action_list = action_list
        # The pagination information.
        self.page_info = page_info
        # The ID of the request.
        self.request_id = request_id

    def validate(self):
        if self.action_list:
            for k in self.action_list:
                if k:
                    k.validate()
        if self.page_info:
            self.page_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ActionList'] = []
        if self.action_list is not None:
            for k in self.action_list:
                result['ActionList'].append(k.to_map() if k else None)
        if self.page_info is not None:
            result['PageInfo'] = self.page_info.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.action_list = []
        if m.get('ActionList') is not None:
            for k in m.get('ActionList'):
                temp_model = DescribeDingTalkResponseBodyActionList()
                self.action_list.append(temp_model.from_map(k))
        if m.get('PageInfo') is not None:
            temp_model = DescribeDingTalkResponseBodyPageInfo()
            self.page_info = temp_model.from_map(m['PageInfo'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeDingTalkResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeDingTalkResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDingTalkResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDomainCountRequest(TeaModel):
    def __init__(
        self,
        source_ip: str = None,
    ):
        # The source IP address of the request.
        self.source_ip = source_ip

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        return self


class DescribeDomainCountResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        root_domains_count: int = None,
        sub_domains_count: int = None,
        total_domains_count: int = None,
    ):
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id
        # The number of root domains.
        self.root_domains_count = root_domains_count
        # The number of subdomains.
        self.sub_domains_count = sub_domains_count
        # The total number of entries returned.
        self.total_domains_count = total_domains_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.root_domains_count is not None:
            result['RootDomainsCount'] = self.root_domains_count
        if self.sub_domains_count is not None:
            result['SubDomainsCount'] = self.sub_domains_count
        if self.total_domains_count is not None:
            result['TotalDomainsCount'] = self.total_domains_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('RootDomainsCount') is not None:
            self.root_domains_count = m.get('RootDomainsCount')
        if m.get('SubDomainsCount') is not None:
            self.sub_domains_count = m.get('SubDomainsCount')
        if m.get('TotalDomainsCount') is not None:
            self.total_domains_count = m.get('TotalDomainsCount')
        return self


class DescribeDomainCountResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeDomainCountResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDomainCountResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDomainDetailRequest(TeaModel):
    def __init__(
        self,
        domain_name: str = None,
        source_ip: str = None,
    ):
        # The domain name or the name of website that you want to query.
        # 
        # >  Fuzzy match is not supported. You must enter a complete domain name or a website.
        self.domain_name = domain_name
        # The source IP address of the request.
        self.source_ip = source_ip

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain_name is not None:
            result['DomainName'] = self.domain_name
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('DomainName') is not None:
            self.domain_name = m.get('DomainName')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        return self


class DescribeDomainDetailResponseBodyDomainDetailItems(TeaModel):
    def __init__(
        self,
        asset_type: str = None,
        instance_id: str = None,
        instance_name: str = None,
        internet_ip: str = None,
        intranet_ip: str = None,
        uuid: str = None,
    ):
        # The type of the domain asset. Valid values:
        # 
        # *   **0**: an Elastic Compute Service (ECS) instance
        # *   **1**: a Server Load Balancer (SLB) instance
        # *   **2**: a Network Address Translation (NAT) gateway
        # *   **3**: an ApsaraDB RDS instance
        # *   **4**: an ApsaraDB for MongoDB instance
        self.asset_type = asset_type
        # The instance ID of the asset.
        self.instance_id = instance_id
        # The name of the asset.
        self.instance_name = instance_name
        # The public IP address of the asset.
        self.internet_ip = internet_ip
        # The private IP address of the asset.
        self.intranet_ip = intranet_ip
        # The instance UUID of the domain asset.
        self.uuid = uuid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.asset_type is not None:
            result['AssetType'] = self.asset_type
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.internet_ip is not None:
            result['InternetIp'] = self.internet_ip
        if self.intranet_ip is not None:
            result['IntranetIp'] = self.intranet_ip
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AssetType') is not None:
            self.asset_type = m.get('AssetType')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('InternetIp') is not None:
            self.internet_ip = m.get('InternetIp')
        if m.get('IntranetIp') is not None:
            self.intranet_ip = m.get('IntranetIp')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class DescribeDomainDetailResponseBody(TeaModel):
    def __init__(
        self,
        alarm_count: int = None,
        domain: str = None,
        domain_detail_items: List[DescribeDomainDetailResponseBodyDomainDetailItems] = None,
        request_id: str = None,
        root_domain: str = None,
        vul_count: int = None,
    ):
        # The total number of alerts in your website assets.
        self.alarm_count = alarm_count
        # The domain name.
        self.domain = domain
        # An array that consists of the details about the domain asset.
        self.domain_detail_items = domain_detail_items
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id
        # The name of the root domain that corresponds to the domain.
        self.root_domain = root_domain
        # The total number of vulnerabilities in your website assets.
        self.vul_count = vul_count

    def validate(self):
        if self.domain_detail_items:
            for k in self.domain_detail_items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alarm_count is not None:
            result['AlarmCount'] = self.alarm_count
        if self.domain is not None:
            result['Domain'] = self.domain
        result['DomainDetailItems'] = []
        if self.domain_detail_items is not None:
            for k in self.domain_detail_items:
                result['DomainDetailItems'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.root_domain is not None:
            result['RootDomain'] = self.root_domain
        if self.vul_count is not None:
            result['VulCount'] = self.vul_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AlarmCount') is not None:
            self.alarm_count = m.get('AlarmCount')
        if m.get('Domain') is not None:
            self.domain = m.get('Domain')
        self.domain_detail_items = []
        if m.get('DomainDetailItems') is not None:
            for k in m.get('DomainDetailItems'):
                temp_model = DescribeDomainDetailResponseBodyDomainDetailItems()
                self.domain_detail_items.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('RootDomain') is not None:
            self.root_domain = m.get('RootDomain')
        if m.get('VulCount') is not None:
            self.vul_count = m.get('VulCount')
        return self


class DescribeDomainDetailResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeDomainDetailResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDomainDetailResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeDomainListRequest(TeaModel):
    def __init__(
        self,
        current_page: int = None,
        domain_type: str = None,
        fuzzy_domain: str = None,
        page_size: int = None,
        source_ip: str = None,
    ):
        # The number of the page to return. Default value: **1**.
        self.current_page = current_page
        # The type of the domain name that you want to query. Valid values:
        # 
        # *   **root**: root domain name
        # *   **sub**: subdomain name
        self.domain_type = domain_type
        # The keyword that is used to query domain names. Fuzzy match is supported.
        self.fuzzy_domain = fuzzy_domain
        # The number of entries to return on each page. Default value: **10**.
        self.page_size = page_size
        # The source IP address of the request.
        self.source_ip = source_ip

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.domain_type is not None:
            result['DomainType'] = self.domain_type
        if self.fuzzy_domain is not None:
            result['FuzzyDomain'] = self.fuzzy_domain
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.source_ip is not None:
            result['SourceIp'] = self.source_ip
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('DomainType') is not None:
            self.domain_type = m.get('DomainType')
        if m.get('FuzzyDomain') is not None:
            self.fuzzy_domain = m.get('FuzzyDomain')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('SourceIp') is not None:
            self.source_ip = m.get('SourceIp')
        return self


class DescribeDomainListResponseBodyDomainListResponseList(TeaModel):
    def __init__(
        self,
        domain: str = None,
        ip_list: str = None,
    ):
        # The name of the domain or website.
        self.domain = domain
        # The IP addresses of the domain name.
        self.ip_list = ip_list

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.domain is not None:
            result['Domain'] = self.domain
        if self.ip_list is not None:
            result['IpList'] = self.ip_list
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Domain') is not None:
            self.domain = m.get('Domain')
        if m.get('IpList') is not None:
            self.ip_list = m.get('IpList')
        return self


class DescribeDomainListResponseBodyPageInfo(TeaModel):
    def __init__(
        self,
        count: int = None,
        current_page: int = None,
        page_size: int = None,
        total_count: int = None,
    ):
        # The number of entries returned on the current page.
        self.count = count
        # The page number of the returned page.
        self.current_page = current_page
        # The number of entries returned per page. Default value: **10**.
        self.page_size = page_size
        # The total number of entries returned.
        self.total_count = total_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeDomainListResponseBody(TeaModel):
    def __init__(
        self,
        domain_list_response_list: List[DescribeDomainListResponseBodyDomainListResponseList] = None,
        page_info: DescribeDomainListResponseBodyPageInfo = None,
        request_id: str = None,
    ):
        # An array that consists of the information about domain names.
        self.domain_list_response_list = domain_list_response_list
        # The pagination information.
        self.page_info = page_info
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id

    def validate(self):
        if self.domain_list_response_list:
            for k in self.domain_list_response_list:
                if k:
                    k.validate()
        if self.page_info:
            self.page_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['DomainListResponseList'] = []
        if self.domain_list_response_list is not None:
            for k in self.domain_list_response_list:
                result['DomainListResponseList'].append(k.to_map() if k else None)
        if self.page_info is not None:
            result['PageInfo'] = self.page_info.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.domain_list_response_list = []
        if m.get('DomainListResponseList') is not None:
            for k in m.get('DomainListResponseList'):
                temp_model = DescribeDomainListResponseBodyDomainListResponseList()
                self.domain_list_response_list.append(temp_model.from_map(k))
        if m.get('PageInfo') is not None:
            temp_model = DescribeDomainListResponseBodyPageInfo()
            self.page_info = temp_model.from_map(m['PageInfo'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeDomainListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeDomainListResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeDomainListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeEmgUserAgreementResponseBody(TeaModel):
    def __init__(
        self,
        auth: bool = None,
        request_id: str = None,
    ):
        self.auth = auth
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.auth is not None:
            result['Auth'] = self.auth
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Auth') is not None:
            self.auth = m.get('Auth')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeEmgUserAgreementResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeEmgUserAgreementResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeEmgUserAgreementResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeEmgVulItemRequest(TeaModel):
    def __init__(
        self,
        check_type: int = None,
        current_page: int = None,
        lang: str = None,
        page_size: int = None,
        risk_status: str = None,
        scan_type: str = None,
        vul_name: str = None,
    ):
        # The check method. Valid values:
        # 
        # *   **0**: proof of concept (POC) verification
        # *   **1**: version comparison
        self.check_type = check_type
        # The number of the page to return. Default value: **1**.
        self.current_page = current_page
        # The language of the content within the request and response. Default value: **zh**. Valid values:
        # 
        # *   **zh**: Chinese
        # *   **en**: English
        self.lang = lang
        # The number of entries to return on each page. Default value: **10**.
        self.page_size = page_size
        # Specifies whether the vulnerability poses risks.\
        # If you do not specify this parameter, all vulnerabilities are queried regardless of whether the vulnerabilities pose risks. Valid values:
        # 
        # *   **y**: yes
        # *   **n**: no
        self.risk_status = risk_status
        # The method that is used to detect the vulnerability.\
        # If you do not specify this parameter, all vulnerabilities are queried regardless of which method is used. Valid values:
        # 
        # *   **python**: The Version method is used. Security Center checks the software versions of your server to check whether disclosed vulnerabilities exist on your server.
        # *   **scan**: The Network Scan method is used. Security Center analyzes the access traffic to your server over the Internet to check whether vulnerabilities exist on your server.
        self.scan_type = scan_type
        # The name of the urgent vulnerability.
        self.vul_name = vul_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.check_type is not None:
            result['CheckType'] = self.check_type
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.risk_status is not None:
            result['RiskStatus'] = self.risk_status
        if self.scan_type is not None:
            result['ScanType'] = self.scan_type
        if self.vul_name is not None:
            result['VulName'] = self.vul_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CheckType') is not None:
            self.check_type = m.get('CheckType')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RiskStatus') is not None:
            self.risk_status = m.get('RiskStatus')
        if m.get('ScanType') is not None:
            self.scan_type = m.get('ScanType')
        if m.get('VulName') is not None:
            self.vul_name = m.get('VulName')
        return self


class DescribeEmgVulItemResponseBodyGroupedVulItems(TeaModel):
    def __init__(
        self,
        alias_name: str = None,
        check_type: int = None,
        gmt_last_check: int = None,
        gmt_publish: int = None,
        name: str = None,
        pending_count: int = None,
        progress: int = None,
        status: int = None,
        type: str = None,
    ):
        # The name of the urgent vulnerability.
        self.alias_name = alias_name
        # The check method.
        self.check_type = check_type
        # The timestamp when the urgent vulnerability was last detected. Unit: milliseconds.
        self.gmt_last_check = gmt_last_check
        # The timestamp when the vulnerability was disclosed. Unit: milliseconds.
        self.gmt_publish = gmt_publish
        # The name of the detection rule.
        self.name = name
        # The number of unhandled urgent vulnerabilities.
        self.pending_count = pending_count
        # The progress of the urgent vulnerability detection task. Valid values: 0 to 100.
        # 
        # >  This parameter is returned only when an urgent vulnerability is being detected.
        self.progress = progress
        # The detection status of the urgent vulnerability. Valid values:
        # 
        # *   **10**: The urgent vulnerability is not detected.
        # *   **20**: The urgent vulnerability is being detected.
        # *   **30**: The urgent vulnerability detection is complete.
        self.status = status
        # The method that is used to detect the urgent vulnerability. Valid values:
        # 
        # *   **python**: The Version method is used. Security Center checks the software versions of your server to check whether disclosed vulnerabilities exist on your server.
        # *   **scan**: The Network Scan method is used. Security Center analyzes the access traffic to your server over the Internet to check whether vulnerabilities exist on your server.
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alias_name is not None:
            result['AliasName'] = self.alias_name
        if self.check_type is not None:
            result['CheckType'] = self.check_type
        if self.gmt_last_check is not None:
            result['GmtLastCheck'] = self.gmt_last_check
        if self.gmt_publish is not None:
            result['GmtPublish'] = self.gmt_publish
        if self.name is not None:
            result['Name'] = self.name
        if self.pending_count is not None:
            result['PendingCount'] = self.pending_count
        if self.progress is not None:
            result['Progress'] = self.progress
        if self.status is not None:
            result['Status'] = self.status
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AliasName') is not None:
            self.alias_name = m.get('AliasName')
        if m.get('CheckType') is not None:
            self.check_type = m.get('CheckType')
        if m.get('GmtLastCheck') is not None:
            self.gmt_last_check = m.get('GmtLastCheck')
        if m.get('GmtPublish') is not None:
            self.gmt_publish = m.get('GmtPublish')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('PendingCount') is not None:
            self.pending_count = m.get('PendingCount')
        if m.get('Progress') is not None:
            self.progress = m.get('Progress')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribeEmgVulItemResponseBody(TeaModel):
    def __init__(
        self,
        current_page: int = None,
        grouped_vul_items: List[DescribeEmgVulItemResponseBodyGroupedVulItems] = None,
        page_size: int = None,
        request_id: str = None,
        total_count: int = None,
    ):
        # The page number of the returned page. Pages start from page **1**. Default value: **1**.
        self.current_page = current_page
        # An array that consists of the urgent vulnerabilities returned.
        self.grouped_vul_items = grouped_vul_items
        # The number of entries returned per page. Default value: **10**.
        self.page_size = page_size
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id
        # The total number of the urgent vulnerabilities returned.
        self.total_count = total_count

    def validate(self):
        if self.grouped_vul_items:
            for k in self.grouped_vul_items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        result['GroupedVulItems'] = []
        if self.grouped_vul_items is not None:
            for k in self.grouped_vul_items:
                result['GroupedVulItems'].append(k.to_map() if k else None)
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        self.grouped_vul_items = []
        if m.get('GroupedVulItems') is not None:
            for k in m.get('GroupedVulItems'):
                temp_model = DescribeEmgVulItemResponseBodyGroupedVulItems()
                self.grouped_vul_items.append(temp_model.from_map(k))
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeEmgVulItemResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeEmgVulItemResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeEmgVulItemResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeEventLevelCountRequest(TeaModel):
    def __init__(
        self,
        cluster_id: str = None,
        container_field_name: str = None,
        container_field_value: str = None,
        container_ids: str = None,
        from_: str = None,
        target_type: str = None,
    ):
        self.cluster_id = cluster_id
        self.container_field_name = container_field_name
        self.container_field_value = container_field_value
        self.container_ids = container_ids
        self.from_ = from_
        self.target_type = target_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.container_field_name is not None:
            result['ContainerFieldName'] = self.container_field_name
        if self.container_field_value is not None:
            result['ContainerFieldValue'] = self.container_field_value
        if self.container_ids is not None:
            result['ContainerIds'] = self.container_ids
        if self.from_ is not None:
            result['From'] = self.from_
        if self.target_type is not None:
            result['TargetType'] = self.target_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('ContainerFieldName') is not None:
            self.container_field_name = m.get('ContainerFieldName')
        if m.get('ContainerFieldValue') is not None:
            self.container_field_value = m.get('ContainerFieldValue')
        if m.get('ContainerIds') is not None:
            self.container_ids = m.get('ContainerIds')
        if m.get('From') is not None:
            self.from_ = m.get('From')
        if m.get('TargetType') is not None:
            self.target_type = m.get('TargetType')
        return self


class DescribeEventLevelCountResponseBodyEventLevels(TeaModel):
    def __init__(
        self,
        remind: int = None,
        serious: int = None,
        suspicious: int = None,
    ):
        self.remind = remind
        self.serious = serious
        self.suspicious = suspicious

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.remind is not None:
            result['Remind'] = self.remind
        if self.serious is not None:
            result['Serious'] = self.serious
        if self.suspicious is not None:
            result['Suspicious'] = self.suspicious
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Remind') is not None:
            self.remind = m.get('Remind')
        if m.get('Serious') is not None:
            self.serious = m.get('Serious')
        if m.get('Suspicious') is not None:
            self.suspicious = m.get('Suspicious')
        return self


class DescribeEventLevelCountResponseBody(TeaModel):
    def __init__(
        self,
        code: str = None,
        event_levels: DescribeEventLevelCountResponseBodyEventLevels = None,
        message: str = None,
        request_id: str = None,
        success: bool = None,
    ):
        self.code = code
        self.event_levels = event_levels
        self.message = message
        self.request_id = request_id
        self.success = success

    def validate(self):
        if self.event_levels:
            self.event_levels.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.code is not None:
            result['Code'] = self.code
        if self.event_levels is not None:
            result['EventLevels'] = self.event_levels.to_map()
        if self.message is not None:
            result['Message'] = self.message
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Code') is not None:
            self.code = m.get('Code')
        if m.get('EventLevels') is not None:
            temp_model = DescribeEventLevelCountResponseBodyEventLevels()
            self.event_levels = temp_model.from_map(m['EventLevels'])
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeEventLevelCountResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeEventLevelCountResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeEventLevelCountResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeEventOnStageRequest(TeaModel):
    def __init__(
        self,
        lang: str = None,
    ):
        self.lang = lang

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.lang is not None:
            result['Lang'] = self.lang
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        return self


class DescribeEventOnStageResponseBodySecurityEventStageResponse(TeaModel):
    def __init__(
        self,
        security_event_on_stag: Dict[str, Any] = None,
    ):
        self.security_event_on_stag = security_event_on_stag

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.security_event_on_stag is not None:
            result['SecurityEventOnStag'] = self.security_event_on_stag
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('SecurityEventOnStag') is not None:
            self.security_event_on_stag = m.get('SecurityEventOnStag')
        return self


class DescribeEventOnStageResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        security_event_stage_response: DescribeEventOnStageResponseBodySecurityEventStageResponse = None,
    ):
        self.request_id = request_id
        self.security_event_stage_response = security_event_stage_response

    def validate(self):
        if self.security_event_stage_response:
            self.security_event_stage_response.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.security_event_stage_response is not None:
            result['SecurityEventStageResponse'] = self.security_event_stage_response.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('SecurityEventStageResponse') is not None:
            temp_model = DescribeEventOnStageResponseBodySecurityEventStageResponse()
            self.security_event_stage_response = temp_model.from_map(m['SecurityEventStageResponse'])
        return self


class DescribeEventOnStageResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeEventOnStageResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeEventOnStageResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeExcludeSystemPathRequest(TeaModel):
    def __init__(
        self,
        current_page: int = None,
        page_size: int = None,
    ):
        self.current_page = current_page
        self.page_size = page_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class DescribeExcludeSystemPathResponseBodyExcludePaths(TeaModel):
    def __init__(
        self,
        os: str = None,
        path: str = None,
    ):
        self.os = os
        self.path = path

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.os is not None:
            result['Os'] = self.os
        if self.path is not None:
            result['Path'] = self.path
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Os') is not None:
            self.os = m.get('Os')
        if m.get('Path') is not None:
            self.path = m.get('Path')
        return self


class DescribeExcludeSystemPathResponseBodyPageInfo(TeaModel):
    def __init__(
        self,
        count: int = None,
        current_page: int = None,
        page_size: int = None,
        total_count: int = None,
    ):
        self.count = count
        self.current_page = current_page
        self.page_size = page_size
        self.total_count = total_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeExcludeSystemPathResponseBody(TeaModel):
    def __init__(
        self,
        exclude_paths: List[DescribeExcludeSystemPathResponseBodyExcludePaths] = None,
        page_info: DescribeExcludeSystemPathResponseBodyPageInfo = None,
        request_id: str = None,
    ):
        self.exclude_paths = exclude_paths
        self.page_info = page_info
        self.request_id = request_id

    def validate(self):
        if self.exclude_paths:
            for k in self.exclude_paths:
                if k:
                    k.validate()
        if self.page_info:
            self.page_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ExcludePaths'] = []
        if self.exclude_paths is not None:
            for k in self.exclude_paths:
                result['ExcludePaths'].append(k.to_map() if k else None)
        if self.page_info is not None:
            result['PageInfo'] = self.page_info.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.exclude_paths = []
        if m.get('ExcludePaths') is not None:
            for k in m.get('ExcludePaths'):
                temp_model = DescribeExcludeSystemPathResponseBodyExcludePaths()
                self.exclude_paths.append(temp_model.from_map(k))
        if m.get('PageInfo') is not None:
            temp_model = DescribeExcludeSystemPathResponseBodyPageInfo()
            self.page_info = temp_model.from_map(m['PageInfo'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeExcludeSystemPathResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeExcludeSystemPathResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeExcludeSystemPathResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeExportInfoRequest(TeaModel):
    def __init__(
        self,
        export_id: int = None,
    ):
        # The ID of the export task.
        self.export_id = export_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.export_id is not None:
            result['ExportId'] = self.export_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ExportId') is not None:
            self.export_id = m.get('ExportId')
        return self


class DescribeExportInfoResponseBody(TeaModel):
    def __init__(
        self,
        current_count: int = None,
        export_status: str = None,
        file_name: str = None,
        id: int = None,
        link: str = None,
        message: str = None,
        progress: int = None,
        request_id: str = None,
        total_count: int = None,
    ):
        # The number of exported entries.
        self.current_count = current_count
        # The status of the export task.
        # 
        # Valid values:
        # 
        # *   **init**: The task is being initialized.
        # *   **exporting**: The task is in progress.
        # *   **success**: The task is complete.
        self.export_status = export_status
        # The name of the exported Excel file.
        self.file_name = file_name
        # The ID of the export task.
        self.id = id
        # The URL at which you can download the exported Excel file.
        self.link = link
        # The message that shows the task result.
        # 
        # The value is fixed as success, which indicates that the export task is complete.
        self.message = message
        # The progress percentage of the export task.
        self.progress = progress
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id
        # The total number of entries in the exported Excel file.
        self.total_count = total_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_count is not None:
            result['CurrentCount'] = self.current_count
        if self.export_status is not None:
            result['ExportStatus'] = self.export_status
        if self.file_name is not None:
            result['FileName'] = self.file_name
        if self.id is not None:
            result['Id'] = self.id
        if self.link is not None:
            result['Link'] = self.link
        if self.message is not None:
            result['Message'] = self.message
        if self.progress is not None:
            result['Progress'] = self.progress
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentCount') is not None:
            self.current_count = m.get('CurrentCount')
        if m.get('ExportStatus') is not None:
            self.export_status = m.get('ExportStatus')
        if m.get('FileName') is not None:
            self.file_name = m.get('FileName')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Link') is not None:
            self.link = m.get('Link')
        if m.get('Message') is not None:
            self.message = m.get('Message')
        if m.get('Progress') is not None:
            self.progress = m.get('Progress')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeExportInfoResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeExportInfoResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeExportInfoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeExposedCheckWarningRequest(TeaModel):
    def __init__(
        self,
        lang: str = None,
        type_name: str = None,
        uuids: str = None,
    ):
        self.lang = lang
        self.type_name = type_name
        self.uuids = uuids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.type_name is not None:
            result['TypeName'] = self.type_name
        if self.uuids is not None:
            result['Uuids'] = self.uuids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('TypeName') is not None:
            self.type_name = m.get('TypeName')
        if m.get('Uuids') is not None:
            self.uuids = m.get('Uuids')
        return self


class DescribeExposedCheckWarningResponseBodyWarningList(TeaModel):
    def __init__(
        self,
        risk_id: int = None,
        risk_name: str = None,
        sub_type_alias: str = None,
        type_alias: str = None,
        uuid: str = None,
    ):
        self.risk_id = risk_id
        self.risk_name = risk_name
        self.sub_type_alias = sub_type_alias
        self.type_alias = type_alias
        self.uuid = uuid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.risk_id is not None:
            result['RiskId'] = self.risk_id
        if self.risk_name is not None:
            result['RiskName'] = self.risk_name
        if self.sub_type_alias is not None:
            result['SubTypeAlias'] = self.sub_type_alias
        if self.type_alias is not None:
            result['TypeAlias'] = self.type_alias
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RiskId') is not None:
            self.risk_id = m.get('RiskId')
        if m.get('RiskName') is not None:
            self.risk_name = m.get('RiskName')
        if m.get('SubTypeAlias') is not None:
            self.sub_type_alias = m.get('SubTypeAlias')
        if m.get('TypeAlias') is not None:
            self.type_alias = m.get('TypeAlias')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class DescribeExposedCheckWarningResponseBody(TeaModel):
    def __init__(
        self,
        count: int = None,
        request_id: str = None,
        warning_list: List[DescribeExposedCheckWarningResponseBodyWarningList] = None,
    ):
        self.count = count
        self.request_id = request_id
        self.warning_list = warning_list

    def validate(self):
        if self.warning_list:
            for k in self.warning_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['WarningList'] = []
        if self.warning_list is not None:
            for k in self.warning_list:
                result['WarningList'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.warning_list = []
        if m.get('WarningList') is not None:
            for k in m.get('WarningList'):
                temp_model = DescribeExposedCheckWarningResponseBodyWarningList()
                self.warning_list.append(temp_model.from_map(k))
        return self


class DescribeExposedCheckWarningResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeExposedCheckWarningResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeExposedCheckWarningResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeExposedInstanceCriteriaRequest(TeaModel):
    def __init__(
        self,
        value: str = None,
    ):
        # The value of the search condition. Fuzzy match is supported.
        self.value = value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.value is not None:
            result['Value'] = self.value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Value') is not None:
            self.value = m.get('Value')
        return self


class DescribeExposedInstanceCriteriaResponseBodyCriteriaList(TeaModel):
    def __init__(
        self,
        name: str = None,
        type: str = None,
        values: str = None,
    ):
        # The name of the search condition.
        self.name = name
        # The type of the search condition. Valid values:
        # 
        # *   **input**: You must configure the search condition.
        # *   **select**: You must select a search condition from the **Values** list.
        self.type = type
        # The value of the search condition. This parameter is returned only when the value of the **Type** parameter is **select**.
        # 
        # >  If the value of the **Type** parameter is **input**, this parameter is empty.
        self.values = values

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.name is not None:
            result['Name'] = self.name
        if self.type is not None:
            result['Type'] = self.type
        if self.values is not None:
            result['Values'] = self.values
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Values') is not None:
            self.values = m.get('Values')
        return self


class DescribeExposedInstanceCriteriaResponseBody(TeaModel):
    def __init__(
        self,
        criteria_list: List[DescribeExposedInstanceCriteriaResponseBodyCriteriaList] = None,
        request_id: str = None,
    ):
        # The search conditions that are used to search for exposed assets.
        self.criteria_list = criteria_list
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id

    def validate(self):
        if self.criteria_list:
            for k in self.criteria_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['CriteriaList'] = []
        if self.criteria_list is not None:
            for k in self.criteria_list:
                result['CriteriaList'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.criteria_list = []
        if m.get('CriteriaList') is not None:
            for k in m.get('CriteriaList'):
                temp_model = DescribeExposedInstanceCriteriaResponseBodyCriteriaList()
                self.criteria_list.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeExposedInstanceCriteriaResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeExposedInstanceCriteriaResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeExposedInstanceCriteriaResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeExposedInstanceDetailRequest(TeaModel):
    def __init__(
        self,
        uuid: str = None,
    ):
        # The UUID of the server that is exposed on the Internet.
        # 
        # >  You can call the [DescribeExposedInstanceList](~~DescribeExposedInstanceList~~) operation to query the UUIDs of servers.
        self.uuid = uuid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class DescribeExposedInstanceDetailResponseBodyExposedChainsAllVulList(TeaModel):
    def __init__(
        self,
        alias_name: str = None,
        name: str = None,
        necessity: str = None,
        type: str = None,
        uuid: str = None,
    ):
        # The alias of the vulnerability.
        self.alias_name = alias_name
        # The name of the vulnerability.
        self.name = name
        # The priority to fix the vulnerability. Valid values:
        # 
        # *   **asap**: high
        # *   **later**: medium
        # *   **nntf**: low
        # 
        # >  We recommend that you fix the vulnerabilities that have the **high** priority at the earliest opportunity.
        self.necessity = necessity
        # The type of the vulnerability. Valid values:
        # 
        # *   **cve**: Linux software vulnerabilities
        # *   **sys**: Windows system vulnerabilities
        # *   **cms**: Web-CMS vulnerabilities
        # *   **app**: application vulnerabilities
        # *   **emg**: urgent vulnerabilities
        # *   **sca**: middleware vulnerabilities
        self.type = type
        # The UUID of the server.
        self.uuid = uuid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alias_name is not None:
            result['AliasName'] = self.alias_name
        if self.name is not None:
            result['Name'] = self.name
        if self.necessity is not None:
            result['Necessity'] = self.necessity
        if self.type is not None:
            result['Type'] = self.type
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AliasName') is not None:
            self.alias_name = m.get('AliasName')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Necessity') is not None:
            self.necessity = m.get('Necessity')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class DescribeExposedInstanceDetailResponseBodyExposedChainsRealVulList(TeaModel):
    def __init__(
        self,
        alias_name: str = None,
        name: str = None,
        necessity: str = None,
        type: str = None,
        uuid: str = None,
    ):
        # The alias of the vulnerability.
        self.alias_name = alias_name
        # The name of the vulnerability.
        self.name = name
        # The priority to fix the vulnerability. Valid values:
        # 
        # *   **asap**: high
        # *   **later**: medium
        # *   **nntf**: low
        # 
        # >  We recommend that you fix the vulnerabilities that have the **high** priority at the earliest opportunity.
        self.necessity = necessity
        # The type of the vulnerability. Valid values:
        # 
        # *   **cve**: Linux software vulnerabilities
        # *   **sys**: Windows system vulnerabilities
        # *   **cms**: Web-CMS vulnerabilities
        # *   **app**: application vulnerabilities
        # *   **emg**: urgent vulnerabilities
        # *   **sca**: middleware vulnerabilities
        self.type = type
        # The UUID of the server.
        self.uuid = uuid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alias_name is not None:
            result['AliasName'] = self.alias_name
        if self.name is not None:
            result['Name'] = self.name
        if self.necessity is not None:
            result['Necessity'] = self.necessity
        if self.type is not None:
            result['Type'] = self.type
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AliasName') is not None:
            self.alias_name = m.get('AliasName')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('Necessity') is not None:
            self.necessity = m.get('Necessity')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class DescribeExposedInstanceDetailResponseBodyExposedChains(TeaModel):
    def __init__(
        self,
        all_vul_list: List[DescribeExposedInstanceDetailResponseBodyExposedChainsAllVulList] = None,
        exposure_component: str = None,
        exposure_ip: str = None,
        exposure_port: str = None,
        exposure_type: str = None,
        exposure_type_id: str = None,
        group_no: str = None,
        instance_id: str = None,
        instance_name: str = None,
        internet_ip: str = None,
        intranet_ip: str = None,
        real_vul_list: List[DescribeExposedInstanceDetailResponseBodyExposedChainsRealVulList] = None,
        region_id: str = None,
        uuid: str = None,
    ):
        # The information about all vulnerabilities on the server.
        self.all_vul_list = all_vul_list
        # The server component that is exposed on the Internet.
        self.exposure_component = exposure_component
        # The public IP address.
        self.exposure_ip = exposure_ip
        # The port that is exposed on the Internet.
        self.exposure_port = exposure_port
        # The resource from which the server is exposed. Valid values:
        # 
        # *   **INTERNET_IP**: the public IP address of an Elastic Compute Service (ECS) instance
        # *   **SLB**: the public IP address of a Server Load Balancer (SLB) instance
        # *   **EIP**: an elastic IP address (EIP)
        # *   **DNAT**: the NAT gateway that connects to the Internet by using the DNAT feature
        self.exposure_type = exposure_type
        # The ID of the instance to which the resource belongs. The valid values of this parameter vary based on the value of the ExposureType parameter.
        # 
        # *   If the value of the ExposureType parameter is **INTERNET_IP**, the value of this parameter is an empty string.
        # *   If the value of the ExposureType parameter is **SLB**, the value of this parameter is the ID of the Internet-facing SLB instance.
        # *   If the value of the ExposureType parameter is **EIP**, the value of this parameter is the ID of the EIP.
        # *   If the value of the ExposureType parameter is **DNAT**, the value of this parameter is the ID of the NAT gateway.
        self.exposure_type_id = exposure_type_id
        # The server group to which the server belongs.
        self.group_no = group_no
        # The ID of the server.
        self.instance_id = instance_id
        # The name of the server.
        self.instance_name = instance_name
        # The public IP address of the server.
        self.internet_ip = internet_ip
        # The private IP address of the server.
        self.intranet_ip = intranet_ip
        # The information about the vulnerabilities that are exposed on the Internet and can be exploited by attackers.
        self.real_vul_list = real_vul_list
        # The region in which the server resides.
        # 
        # >  For more information about the mapping between region IDs and region names, see [Regions and zones](~~40654~~).
        self.region_id = region_id
        # The UUID of the server.
        self.uuid = uuid

    def validate(self):
        if self.all_vul_list:
            for k in self.all_vul_list:
                if k:
                    k.validate()
        if self.real_vul_list:
            for k in self.real_vul_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['AllVulList'] = []
        if self.all_vul_list is not None:
            for k in self.all_vul_list:
                result['AllVulList'].append(k.to_map() if k else None)
        if self.exposure_component is not None:
            result['ExposureComponent'] = self.exposure_component
        if self.exposure_ip is not None:
            result['ExposureIp'] = self.exposure_ip
        if self.exposure_port is not None:
            result['ExposurePort'] = self.exposure_port
        if self.exposure_type is not None:
            result['ExposureType'] = self.exposure_type
        if self.exposure_type_id is not None:
            result['ExposureTypeId'] = self.exposure_type_id
        if self.group_no is not None:
            result['GroupNo'] = self.group_no
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.internet_ip is not None:
            result['InternetIp'] = self.internet_ip
        if self.intranet_ip is not None:
            result['IntranetIp'] = self.intranet_ip
        result['RealVulList'] = []
        if self.real_vul_list is not None:
            for k in self.real_vul_list:
                result['RealVulList'].append(k.to_map() if k else None)
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.all_vul_list = []
        if m.get('AllVulList') is not None:
            for k in m.get('AllVulList'):
                temp_model = DescribeExposedInstanceDetailResponseBodyExposedChainsAllVulList()
                self.all_vul_list.append(temp_model.from_map(k))
        if m.get('ExposureComponent') is not None:
            self.exposure_component = m.get('ExposureComponent')
        if m.get('ExposureIp') is not None:
            self.exposure_ip = m.get('ExposureIp')
        if m.get('ExposurePort') is not None:
            self.exposure_port = m.get('ExposurePort')
        if m.get('ExposureType') is not None:
            self.exposure_type = m.get('ExposureType')
        if m.get('ExposureTypeId') is not None:
            self.exposure_type_id = m.get('ExposureTypeId')
        if m.get('GroupNo') is not None:
            self.group_no = m.get('GroupNo')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('InternetIp') is not None:
            self.internet_ip = m.get('InternetIp')
        if m.get('IntranetIp') is not None:
            self.intranet_ip = m.get('IntranetIp')
        self.real_vul_list = []
        if m.get('RealVulList') is not None:
            for k in m.get('RealVulList'):
                temp_model = DescribeExposedInstanceDetailResponseBodyExposedChainsRealVulList()
                self.real_vul_list.append(temp_model.from_map(k))
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class DescribeExposedInstanceDetailResponseBody(TeaModel):
    def __init__(
        self,
        exposed_chains: List[DescribeExposedInstanceDetailResponseBodyExposedChains] = None,
        request_id: str = None,
    ):
        # The exposure details about the server.
        self.exposed_chains = exposed_chains
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id

    def validate(self):
        if self.exposed_chains:
            for k in self.exposed_chains:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ExposedChains'] = []
        if self.exposed_chains is not None:
            for k in self.exposed_chains:
                result['ExposedChains'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.exposed_chains = []
        if m.get('ExposedChains') is not None:
            for k in m.get('ExposedChains'):
                temp_model = DescribeExposedInstanceDetailResponseBodyExposedChains()
                self.exposed_chains.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeExposedInstanceDetailResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeExposedInstanceDetailResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeExposedInstanceDetailResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeExposedInstanceListRequest(TeaModel):
    def __init__(
        self,
        current_page: int = None,
        exposure_component: str = None,
        exposure_ip: str = None,
        exposure_port: str = None,
        group_id: int = None,
        health_status: bool = None,
        instance_id: str = None,
        instance_name: str = None,
        page_size: int = None,
        vul_status: bool = None,
    ):
        # The number of the page to return.
        self.current_page = current_page
        # The server component that is exposed on the Internet.
        self.exposure_component = exposure_component
        # The public IP address of the server.
        self.exposure_ip = exposure_ip
        # The port that is exposed on the Internet.
        self.exposure_port = exposure_port
        # The ID of the server group.
        # 
        # > You can call the [DescribeAllGroups](~~DescribeAllGroups~~) operation to query the IDs of server groups.
        self.group_id = group_id
        # The health status of the Elastic Compute Service (ECS) instance in the scaling group. ECS instances that are not in the Running state are considered unhealthy. Valid values:
        # 
        # *   Healthy
        # *   Unhealthy
        # 
        # Auto Scaling automatically removes unhealthy ECS instances from the scaling group and then releases the automatically created instances among the unhealthy instances.
        # 
        # Unhealthy ECS instances that are manually added to the scaling group are released based on the management mode of the instance lifecycle. If the lifecycle of the ECS instances is not managed by the scaling group, Auto Scaling removes the instances from the scaling group but does not release them. If the lifecycle of the ECS instances is managed by the scaling group, Auto Scaling removes the instances from the scaling group and releases them.
        # 
        # >  Make sure that you have sufficient balance within your account. If you have overdue payments in your account, pay-as-you-go and preemptible instances are stopped or released. For information about how the status of ECS instances changes when you have overdue payments in your account, see [Overdue payments](~~170589~~).
        self.health_status = health_status
        # The ID of the server.
        self.instance_id = instance_id
        # The name of the server.
        self.instance_name = instance_name
        # The number of entries to return on each page. Default value: 20. If you leave this parameter empty, 20 entries are returned on each page.
        # 
        # >  We recommend that you do not leave this parameter empty.
        self.page_size = page_size
        # Specifies whether the server has vulnerabilities. Valid values:
        # 
        # *   **true**: The server has vulnerabilities.
        # *   **false**: The server does not have vulnerabilities.
        self.vul_status = vul_status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.exposure_component is not None:
            result['ExposureComponent'] = self.exposure_component
        if self.exposure_ip is not None:
            result['ExposureIp'] = self.exposure_ip
        if self.exposure_port is not None:
            result['ExposurePort'] = self.exposure_port
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.health_status is not None:
            result['HealthStatus'] = self.health_status
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.vul_status is not None:
            result['VulStatus'] = self.vul_status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('ExposureComponent') is not None:
            self.exposure_component = m.get('ExposureComponent')
        if m.get('ExposureIp') is not None:
            self.exposure_ip = m.get('ExposureIp')
        if m.get('ExposurePort') is not None:
            self.exposure_port = m.get('ExposurePort')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('HealthStatus') is not None:
            self.health_status = m.get('HealthStatus')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('VulStatus') is not None:
            self.vul_status = m.get('VulStatus')
        return self


class DescribeExposedInstanceListResponseBodyExposedInstances(TeaModel):
    def __init__(
        self,
        asap_vul_count: int = None,
        exploit_health_count: int = None,
        exposure_component: str = None,
        exposure_ip: str = None,
        exposure_port: str = None,
        exposure_type: str = None,
        exposure_type_id: str = None,
        group_id: int = None,
        group_name: str = None,
        instance_id: str = None,
        instance_name: str = None,
        internet_ip: str = None,
        intranet_ip: str = None,
        later_vul_count: int = None,
        nntf_vul_count: int = None,
        region_id: str = None,
        total_vul_count: int = None,
        uuid: str = None,
    ):
        # The number of high-severity vulnerabilities that are exposed on the Internet and can be exploited by attackers.
        self.asap_vul_count = asap_vul_count
        # The total number of servers that are exposed on the Internet.
        self.exploit_health_count = exploit_health_count
        # The server component that is exposed on the Internet.
        self.exposure_component = exposure_component
        # The public IP address that is exposed on the Internet.
        self.exposure_ip = exposure_ip
        # The port that is exposed on the Internet.
        self.exposure_port = exposure_port
        # The resource from which the asset is exposed. Valid values:
        # 
        # *   **INTERNET_IP**: the public IP address of an ECS instance
        # *   **SLB**: the public IP address of a Server Load Balancer (SLB) instance
        # *   **EIP**: an elastic IP address (EIP)
        # *   **DNAT**: the NAT gateway that connects to the Internet by using the DNAT feature
        self.exposure_type = exposure_type
        # The ID of the instance to which the resource belongs. The valid values of this parameter vary based on the ExposureType parameter.
        # 
        # *   If the value of the ExposureType parameter is **INTERNET_IP**, this parameter is empty.
        # *   If the value of the ExposureType parameter is **SLB**, the value of this parameter is the ID of the SLB instance.
        # *   If the value of the ExposureType parameter is **EIP**, the value of this parameter is the ID of the EIP.
        # *   If the value of the ExposureType parameter is **DNAT**, the value of this parameter is the ID of the NAT gateway.
        self.exposure_type_id = exposure_type_id
        # The ID of the server group.
        self.group_id = group_id
        # The name of the server group.
        self.group_name = group_name
        # The ID of the server.
        self.instance_id = instance_id
        # The name of the server.
        self.instance_name = instance_name
        # The public IP address of the server.
        self.internet_ip = internet_ip
        # The private IP address of the server.
        self.intranet_ip = intranet_ip
        # The number of medium-severity vulnerabilities that are exposed on the Internet and can be exploited by attackers.
        self.later_vul_count = later_vul_count
        # The number of low-severity vulnerabilities that are exposed on the Internet and can be exploited by attackers.
        self.nntf_vul_count = nntf_vul_count
        # The ID of the region where the server resides.
        # 
        # >  For more information about the mapping between region IDs and region names, see [Regions and zones](~~40654~~).
        self.region_id = region_id
        # The total number of vulnerabilities that are exposed on the Internet and can be exploited by attackers.
        self.total_vul_count = total_vul_count
        # The UUID of the server.
        self.uuid = uuid

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.asap_vul_count is not None:
            result['AsapVulCount'] = self.asap_vul_count
        if self.exploit_health_count is not None:
            result['ExploitHealthCount'] = self.exploit_health_count
        if self.exposure_component is not None:
            result['ExposureComponent'] = self.exposure_component
        if self.exposure_ip is not None:
            result['ExposureIp'] = self.exposure_ip
        if self.exposure_port is not None:
            result['ExposurePort'] = self.exposure_port
        if self.exposure_type is not None:
            result['ExposureType'] = self.exposure_type
        if self.exposure_type_id is not None:
            result['ExposureTypeId'] = self.exposure_type_id
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.group_name is not None:
            result['GroupName'] = self.group_name
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.internet_ip is not None:
            result['InternetIp'] = self.internet_ip
        if self.intranet_ip is not None:
            result['IntranetIp'] = self.intranet_ip
        if self.later_vul_count is not None:
            result['LaterVulCount'] = self.later_vul_count
        if self.nntf_vul_count is not None:
            result['NntfVulCount'] = self.nntf_vul_count
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.total_vul_count is not None:
            result['TotalVulCount'] = self.total_vul_count
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AsapVulCount') is not None:
            self.asap_vul_count = m.get('AsapVulCount')
        if m.get('ExploitHealthCount') is not None:
            self.exploit_health_count = m.get('ExploitHealthCount')
        if m.get('ExposureComponent') is not None:
            self.exposure_component = m.get('ExposureComponent')
        if m.get('ExposureIp') is not None:
            self.exposure_ip = m.get('ExposureIp')
        if m.get('ExposurePort') is not None:
            self.exposure_port = m.get('ExposurePort')
        if m.get('ExposureType') is not None:
            self.exposure_type = m.get('ExposureType')
        if m.get('ExposureTypeId') is not None:
            self.exposure_type_id = m.get('ExposureTypeId')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('GroupName') is not None:
            self.group_name = m.get('GroupName')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('InternetIp') is not None:
            self.internet_ip = m.get('InternetIp')
        if m.get('IntranetIp') is not None:
            self.intranet_ip = m.get('IntranetIp')
        if m.get('LaterVulCount') is not None:
            self.later_vul_count = m.get('LaterVulCount')
        if m.get('NntfVulCount') is not None:
            self.nntf_vul_count = m.get('NntfVulCount')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('TotalVulCount') is not None:
            self.total_vul_count = m.get('TotalVulCount')
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class DescribeExposedInstanceListResponseBodyPageInfo(TeaModel):
    def __init__(
        self,
        count: int = None,
        current_page: int = None,
        page_size: int = None,
        total_count: int = None,
    ):
        # The number of entries returned on the current page.
        self.count = count
        # The page number of the returned page.
        self.current_page = current_page
        # The number of entries returned per page.
        self.page_size = page_size
        # The total number of entries about the servers that are exposed on the Internet.
        self.total_count = total_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeExposedInstanceListResponseBody(TeaModel):
    def __init__(
        self,
        exposed_instances: List[DescribeExposedInstanceListResponseBodyExposedInstances] = None,
        page_info: DescribeExposedInstanceListResponseBodyPageInfo = None,
        request_id: str = None,
    ):
        # An array that consists of the details about the exposed asset.
        self.exposed_instances = exposed_instances
        # The pagination information.
        self.page_info = page_info
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id

    def validate(self):
        if self.exposed_instances:
            for k in self.exposed_instances:
                if k:
                    k.validate()
        if self.page_info:
            self.page_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['ExposedInstances'] = []
        if self.exposed_instances is not None:
            for k in self.exposed_instances:
                result['ExposedInstances'].append(k.to_map() if k else None)
        if self.page_info is not None:
            result['PageInfo'] = self.page_info.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.exposed_instances = []
        if m.get('ExposedInstances') is not None:
            for k in m.get('ExposedInstances'):
                temp_model = DescribeExposedInstanceListResponseBodyExposedInstances()
                self.exposed_instances.append(temp_model.from_map(k))
        if m.get('PageInfo') is not None:
            temp_model = DescribeExposedInstanceListResponseBodyPageInfo()
            self.page_info = temp_model.from_map(m['PageInfo'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeExposedInstanceListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeExposedInstanceListResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeExposedInstanceListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeExposedStatisticsResponseBody(TeaModel):
    def __init__(
        self,
        exposed_asap_vul_count: int = None,
        exposed_component_count: int = None,
        exposed_instance_count: int = None,
        exposed_ip_count: int = None,
        exposed_later_vul_count: int = None,
        exposed_nntf_vul_count: int = None,
        exposed_port_count: int = None,
        exposed_week_password_machine_count: int = None,
        gateway_asset_count: int = None,
        request_id: str = None,
    ):
        self.exposed_asap_vul_count = exposed_asap_vul_count
        self.exposed_component_count = exposed_component_count
        self.exposed_instance_count = exposed_instance_count
        self.exposed_ip_count = exposed_ip_count
        self.exposed_later_vul_count = exposed_later_vul_count
        self.exposed_nntf_vul_count = exposed_nntf_vul_count
        self.exposed_port_count = exposed_port_count
        self.exposed_week_password_machine_count = exposed_week_password_machine_count
        self.gateway_asset_count = gateway_asset_count
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.exposed_asap_vul_count is not None:
            result['ExposedAsapVulCount'] = self.exposed_asap_vul_count
        if self.exposed_component_count is not None:
            result['ExposedComponentCount'] = self.exposed_component_count
        if self.exposed_instance_count is not None:
            result['ExposedInstanceCount'] = self.exposed_instance_count
        if self.exposed_ip_count is not None:
            result['ExposedIpCount'] = self.exposed_ip_count
        if self.exposed_later_vul_count is not None:
            result['ExposedLaterVulCount'] = self.exposed_later_vul_count
        if self.exposed_nntf_vul_count is not None:
            result['ExposedNntfVulCount'] = self.exposed_nntf_vul_count
        if self.exposed_port_count is not None:
            result['ExposedPortCount'] = self.exposed_port_count
        if self.exposed_week_password_machine_count is not None:
            result['ExposedWeekPasswordMachineCount'] = self.exposed_week_password_machine_count
        if self.gateway_asset_count is not None:
            result['GatewayAssetCount'] = self.gateway_asset_count
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ExposedAsapVulCount') is not None:
            self.exposed_asap_vul_count = m.get('ExposedAsapVulCount')
        if m.get('ExposedComponentCount') is not None:
            self.exposed_component_count = m.get('ExposedComponentCount')
        if m.get('ExposedInstanceCount') is not None:
            self.exposed_instance_count = m.get('ExposedInstanceCount')
        if m.get('ExposedIpCount') is not None:
            self.exposed_ip_count = m.get('ExposedIpCount')
        if m.get('ExposedLaterVulCount') is not None:
            self.exposed_later_vul_count = m.get('ExposedLaterVulCount')
        if m.get('ExposedNntfVulCount') is not None:
            self.exposed_nntf_vul_count = m.get('ExposedNntfVulCount')
        if m.get('ExposedPortCount') is not None:
            self.exposed_port_count = m.get('ExposedPortCount')
        if m.get('ExposedWeekPasswordMachineCount') is not None:
            self.exposed_week_password_machine_count = m.get('ExposedWeekPasswordMachineCount')
        if m.get('GatewayAssetCount') is not None:
            self.gateway_asset_count = m.get('GatewayAssetCount')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeExposedStatisticsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeExposedStatisticsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeExposedStatisticsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeExposedStatisticsDetailRequest(TeaModel):
    def __init__(
        self,
        current_page: int = None,
        page_size: int = None,
        statistics_type: str = None,
        statistics_type_gateway_type: str = None,
        statistics_type_instance_value: str = None,
    ):
        # The number of the page to return.
        self.current_page = current_page
        # The number of entries to return on each page. Default value: 20. If you leave this parameter empty, 20 entries are returned on each page.
        # 
        # >  We recommend that you do not leave this parameter empty.
        self.page_size = page_size
        # The type of the exposed asset. Valid values:
        # 
        # *   **exposureType**: gateway assets
        # *   **exposurePort**: ports
        # *   **exposureComponent**: system components
        # *   **exposureIp**: IP addresses
        self.statistics_type = statistics_type
        # The type of the gateway asset. This parameter is required when the **StatisticsType** parameter is set to **exposureType**. Valid values:
        # 
        # *   **SLB**: the public IP address of a Server Load Balancer (SLB) instance
        # *   **DNAT**: the NAT gateway that connects to the Internet by using the DNAT feature
        self.statistics_type_gateway_type = statistics_type_gateway_type
        # The ID of the gateway asset. This parameter is required when the **StatisticsType** parameter is set to **exposureType**.
        self.statistics_type_instance_value = statistics_type_instance_value

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.statistics_type is not None:
            result['StatisticsType'] = self.statistics_type
        if self.statistics_type_gateway_type is not None:
            result['StatisticsTypeGatewayType'] = self.statistics_type_gateway_type
        if self.statistics_type_instance_value is not None:
            result['StatisticsTypeInstanceValue'] = self.statistics_type_instance_value
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('StatisticsType') is not None:
            self.statistics_type = m.get('StatisticsType')
        if m.get('StatisticsTypeGatewayType') is not None:
            self.statistics_type_gateway_type = m.get('StatisticsTypeGatewayType')
        if m.get('StatisticsTypeInstanceValue') is not None:
            self.statistics_type_instance_value = m.get('StatisticsTypeInstanceValue')
        return self


class DescribeExposedStatisticsDetailResponseBodyPageInfo(TeaModel):
    def __init__(
        self,
        count: int = None,
        current_page: int = None,
        page_size: int = None,
        total_count: int = None,
    ):
        # The number of entries returned on the current page.
        self.count = count
        # The page number of the returned page.
        self.current_page = current_page
        # The number of entries returned per page.
        self.page_size = page_size
        # The total number of entries returned.
        self.total_count = total_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeExposedStatisticsDetailResponseBodyStatisticsDetails(TeaModel):
    def __init__(
        self,
        exposed_count: int = None,
        exposure_component: str = None,
        exposure_ip: str = None,
        exposure_port: str = None,
        exposure_type: str = None,
        exposure_type_id: str = None,
        exposure_type_instance_name: str = None,
        region_id: str = None,
    ):
        # The total number of system vulnerabilities that are detected on your server and are exposed on the Internet.
        self.exposed_count = exposed_count
        # The system component that is exposed on the Internet.
        self.exposure_component = exposure_component
        # The public IP address that is exposed on the Internet.
        self.exposure_ip = exposure_ip
        # The port that is exposed on the Internet.
        self.exposure_port = exposure_port
        # The resource from which the asset is exposed. Valid values:
        # 
        # *   **INTERNET_IP**: the IP address of the Elastic Compute Service (ECS) instance
        # *   **SLB**: the public IP address of the SLB instance
        # *   **EIP**: the elastic IP address (EIP)
        # *   **DNAT**: the NAT gateway that connects to the Internet by using the DNAT feature
        self.exposure_type = exposure_type
        # The ID of the instance to which the resource belongs. The valid values of this parameter vary based on the value of the ExposureType parameter.
        # 
        # *   If the value of the **ExposureType** parameter is **INTERNET_IP**, the value of this parameter is an empty string.
        # *   If the value of the **ExposureType** parameter is **SLB**, the value of this parameter is the ID of the Internet-facing SLB instance.
        # *   If the value of the **ExposureType** parameter is **EIP**, the value of this parameter is the ID of the EIP.
        # *   If the value of the **ExposureType** parameter is **DNAT**, the value of this parameter is the ID of the NAT gateway.
        self.exposure_type_id = exposure_type_id
        # The name of the gateway asset that is exposed on the Internet.
        self.exposure_type_instance_name = exposure_type_instance_name
        # The region ID of the asset.
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.exposed_count is not None:
            result['ExposedCount'] = self.exposed_count
        if self.exposure_component is not None:
            result['ExposureComponent'] = self.exposure_component
        if self.exposure_ip is not None:
            result['ExposureIp'] = self.exposure_ip
        if self.exposure_port is not None:
            result['ExposurePort'] = self.exposure_port
        if self.exposure_type is not None:
            result['ExposureType'] = self.exposure_type
        if self.exposure_type_id is not None:
            result['ExposureTypeId'] = self.exposure_type_id
        if self.exposure_type_instance_name is not None:
            result['ExposureTypeInstanceName'] = self.exposure_type_instance_name
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ExposedCount') is not None:
            self.exposed_count = m.get('ExposedCount')
        if m.get('ExposureComponent') is not None:
            self.exposure_component = m.get('ExposureComponent')
        if m.get('ExposureIp') is not None:
            self.exposure_ip = m.get('ExposureIp')
        if m.get('ExposurePort') is not None:
            self.exposure_port = m.get('ExposurePort')
        if m.get('ExposureType') is not None:
            self.exposure_type = m.get('ExposureType')
        if m.get('ExposureTypeId') is not None:
            self.exposure_type_id = m.get('ExposureTypeId')
        if m.get('ExposureTypeInstanceName') is not None:
            self.exposure_type_instance_name = m.get('ExposureTypeInstanceName')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeExposedStatisticsDetailResponseBody(TeaModel):
    def __init__(
        self,
        page_info: DescribeExposedStatisticsDetailResponseBodyPageInfo = None,
        request_id: str = None,
        statistics_details: List[DescribeExposedStatisticsDetailResponseBodyStatisticsDetails] = None,
    ):
        # The pagination information.
        self.page_info = page_info
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id
        # An array consisting of the gateway assets, ports, system components, or public IP addresses that are exposed on the Internet and are returned.
        self.statistics_details = statistics_details

    def validate(self):
        if self.page_info:
            self.page_info.validate()
        if self.statistics_details:
            for k in self.statistics_details:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.page_info is not None:
            result['PageInfo'] = self.page_info.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['StatisticsDetails'] = []
        if self.statistics_details is not None:
            for k in self.statistics_details:
                result['StatisticsDetails'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('PageInfo') is not None:
            temp_model = DescribeExposedStatisticsDetailResponseBodyPageInfo()
            self.page_info = temp_model.from_map(m['PageInfo'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.statistics_details = []
        if m.get('StatisticsDetails') is not None:
            for k in m.get('StatisticsDetails'):
                temp_model = DescribeExposedStatisticsDetailResponseBodyStatisticsDetails()
                self.statistics_details.append(temp_model.from_map(k))
        return self


class DescribeExposedStatisticsDetailResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeExposedStatisticsDetailResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeExposedStatisticsDetailResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeFieldStatisticsRequest(TeaModel):
    def __init__(
        self,
        machine_types: str = None,
        region_id: str = None,
    ):
        # The type of the asset to query. If no asset types are specified, all types of assets are returned. Valid values:
        # 
        # *   **ecs**: server
        # *   **cloud_product**: Alibaba Cloud service
        self.machine_types = machine_types
        # The ID of the region in which the asset resides.
        self.region_id = region_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.machine_types is not None:
            result['MachineTypes'] = self.machine_types
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MachineTypes') is not None:
            self.machine_types = m.get('MachineTypes')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        return self


class DescribeFieldStatisticsResponseBodyGroupedFields(TeaModel):
    def __init__(
        self,
        ali_yun_instance_count: int = None,
        aws_instance_count: int = None,
        exposed_instance_count: int = None,
        general_asset_count: int = None,
        group_count: int = None,
        huawei_instance_count: int = None,
        idc_instance_count: int = None,
        important_asset_count: int = None,
        instance_count: int = None,
        instance_sync_task_count: int = None,
        new_instance_count: int = None,
        no_risk_instance_count: int = None,
        not_running_status_count: int = None,
        offline_instance_count: int = None,
        out_machine_instance_count: int = None,
        pause_instance_count: int = None,
        region_count: int = None,
        risk_instance_count: int = None,
        tencent_instance_count: int = None,
        test_asset_count: int = None,
        tripartite_instance_count: int = None,
        un_know_status_instance_count: int = None,
        unprotected_instance_count: int = None,
        vpc_count: int = None,
    ):
        # The number of assets that are deployed on Alibaba Cloud.
        self.ali_yun_instance_count = ali_yun_instance_count
        # The number of servers.
        self.aws_instance_count = aws_instance_count
        # The number of exposed servers.
        self.exposed_instance_count = exposed_instance_count
        # The number of assets whose importance is common.
        self.general_asset_count = general_asset_count
        # The number of server groups.
        self.group_count = group_count
        # The number of instances that are provisioned by third-party providers.
        self.huawei_instance_count = huawei_instance_count
        # The number of assets that can be protected by Security Center.
        self.idc_instance_count = idc_instance_count
        # The number of assets whose importance is important.
        self.important_asset_count = important_asset_count
        # The total number of assets of the specified type. If no asset types are specified, this parameter indicates the total number of all servers and Alibaba Cloud services within your account.
        self.instance_count = instance_count
        # The total number of tasks for the specified type of assets. If no asset types are specified, this parameter indicates the total number of all servers and Alibaba Cloud services within your account.
        self.instance_sync_task_count = instance_sync_task_count
        # The number of newly added servers.
        self.new_instance_count = new_instance_count
        # The number of assets that do not pose risks.
        self.no_risk_instance_count = no_risk_instance_count
        # The number of servers that are shut down.
        self.not_running_status_count = not_running_status_count
        # The number of servers whose Security Center agent status is Offline.
        self.offline_instance_count = offline_instance_count
        # The number of servers outside the cloud.
        self.out_machine_instance_count = out_machine_instance_count
        # The number of servers for which the Security Center agent suspends protection.
        self.pause_instance_count = pause_instance_count
        # The number of regions to which the servers belong.
        self.region_count = region_count
        # The number of assets that are at risk.
        self.risk_instance_count = risk_instance_count
        # The total number of cloud services that are protected by Security Center.
        self.tencent_instance_count = tencent_instance_count
        # The number of assets whose importance is test.
        self.test_asset_count = test_asset_count
        # The number of simple application servers.
        self.tripartite_instance_count = tripartite_instance_count
        # The number of assets whose statuses are unknown.
        self.un_know_status_instance_count = un_know_status_instance_count
        # The number of unprotected assets.
        self.unprotected_instance_count = unprotected_instance_count
        # The number of virtual private clouds (VPCs).
        self.vpc_count = vpc_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.ali_yun_instance_count is not None:
            result['AliYunInstanceCount'] = self.ali_yun_instance_count
        if self.aws_instance_count is not None:
            result['AwsInstanceCount'] = self.aws_instance_count
        if self.exposed_instance_count is not None:
            result['ExposedInstanceCount'] = self.exposed_instance_count
        if self.general_asset_count is not None:
            result['GeneralAssetCount'] = self.general_asset_count
        if self.group_count is not None:
            result['GroupCount'] = self.group_count
        if self.huawei_instance_count is not None:
            result['HuaweiInstanceCount'] = self.huawei_instance_count
        if self.idc_instance_count is not None:
            result['IdcInstanceCount'] = self.idc_instance_count
        if self.important_asset_count is not None:
            result['ImportantAssetCount'] = self.important_asset_count
        if self.instance_count is not None:
            result['InstanceCount'] = self.instance_count
        if self.instance_sync_task_count is not None:
            result['InstanceSyncTaskCount'] = self.instance_sync_task_count
        if self.new_instance_count is not None:
            result['NewInstanceCount'] = self.new_instance_count
        if self.no_risk_instance_count is not None:
            result['NoRiskInstanceCount'] = self.no_risk_instance_count
        if self.not_running_status_count is not None:
            result['NotRunningStatusCount'] = self.not_running_status_count
        if self.offline_instance_count is not None:
            result['OfflineInstanceCount'] = self.offline_instance_count
        if self.out_machine_instance_count is not None:
            result['OutMachineInstanceCount'] = self.out_machine_instance_count
        if self.pause_instance_count is not None:
            result['PauseInstanceCount'] = self.pause_instance_count
        if self.region_count is not None:
            result['RegionCount'] = self.region_count
        if self.risk_instance_count is not None:
            result['RiskInstanceCount'] = self.risk_instance_count
        if self.tencent_instance_count is not None:
            result['TencentInstanceCount'] = self.tencent_instance_count
        if self.test_asset_count is not None:
            result['TestAssetCount'] = self.test_asset_count
        if self.tripartite_instance_count is not None:
            result['TripartiteInstanceCount'] = self.tripartite_instance_count
        if self.un_know_status_instance_count is not None:
            result['UnKnowStatusInstanceCount'] = self.un_know_status_instance_count
        if self.unprotected_instance_count is not None:
            result['UnprotectedInstanceCount'] = self.unprotected_instance_count
        if self.vpc_count is not None:
            result['VpcCount'] = self.vpc_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AliYunInstanceCount') is not None:
            self.ali_yun_instance_count = m.get('AliYunInstanceCount')
        if m.get('AwsInstanceCount') is not None:
            self.aws_instance_count = m.get('AwsInstanceCount')
        if m.get('ExposedInstanceCount') is not None:
            self.exposed_instance_count = m.get('ExposedInstanceCount')
        if m.get('GeneralAssetCount') is not None:
            self.general_asset_count = m.get('GeneralAssetCount')
        if m.get('GroupCount') is not None:
            self.group_count = m.get('GroupCount')
        if m.get('HuaweiInstanceCount') is not None:
            self.huawei_instance_count = m.get('HuaweiInstanceCount')
        if m.get('IdcInstanceCount') is not None:
            self.idc_instance_count = m.get('IdcInstanceCount')
        if m.get('ImportantAssetCount') is not None:
            self.important_asset_count = m.get('ImportantAssetCount')
        if m.get('InstanceCount') is not None:
            self.instance_count = m.get('InstanceCount')
        if m.get('InstanceSyncTaskCount') is not None:
            self.instance_sync_task_count = m.get('InstanceSyncTaskCount')
        if m.get('NewInstanceCount') is not None:
            self.new_instance_count = m.get('NewInstanceCount')
        if m.get('NoRiskInstanceCount') is not None:
            self.no_risk_instance_count = m.get('NoRiskInstanceCount')
        if m.get('NotRunningStatusCount') is not None:
            self.not_running_status_count = m.get('NotRunningStatusCount')
        if m.get('OfflineInstanceCount') is not None:
            self.offline_instance_count = m.get('OfflineInstanceCount')
        if m.get('OutMachineInstanceCount') is not None:
            self.out_machine_instance_count = m.get('OutMachineInstanceCount')
        if m.get('PauseInstanceCount') is not None:
            self.pause_instance_count = m.get('PauseInstanceCount')
        if m.get('RegionCount') is not None:
            self.region_count = m.get('RegionCount')
        if m.get('RiskInstanceCount') is not None:
            self.risk_instance_count = m.get('RiskInstanceCount')
        if m.get('TencentInstanceCount') is not None:
            self.tencent_instance_count = m.get('TencentInstanceCount')
        if m.get('TestAssetCount') is not None:
            self.test_asset_count = m.get('TestAssetCount')
        if m.get('TripartiteInstanceCount') is not None:
            self.tripartite_instance_count = m.get('TripartiteInstanceCount')
        if m.get('UnKnowStatusInstanceCount') is not None:
            self.un_know_status_instance_count = m.get('UnKnowStatusInstanceCount')
        if m.get('UnprotectedInstanceCount') is not None:
            self.unprotected_instance_count = m.get('UnprotectedInstanceCount')
        if m.get('VpcCount') is not None:
            self.vpc_count = m.get('VpcCount')
        return self


class DescribeFieldStatisticsResponseBody(TeaModel):
    def __init__(
        self,
        grouped_fields: DescribeFieldStatisticsResponseBodyGroupedFields = None,
        request_id: str = None,
    ):
        # The information about servers that are returned.
        self.grouped_fields = grouped_fields
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id

    def validate(self):
        if self.grouped_fields:
            self.grouped_fields.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.grouped_fields is not None:
            result['GroupedFields'] = self.grouped_fields.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('GroupedFields') is not None:
            temp_model = DescribeFieldStatisticsResponseBodyGroupedFields()
            self.grouped_fields = temp_model.from_map(m['GroupedFields'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeFieldStatisticsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeFieldStatisticsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeFieldStatisticsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeFrontVulPatchListRequest(TeaModel):
    def __init__(
        self,
        info: str = None,
        lang: str = None,
        operate_type: str = None,
        type: str = None,
    ):
        # The information about the Windows system vulnerability. The value is a JSON string that contains the following fields:
        # 
        # *   **name**: the name of the vulnerability.
        # *   **uuid**: the UUID of the server on which the vulnerability is detected.
        # *   **tag**: the tag that is added to the vulnerability. Set this field to **system**, which indicates Windows system vulnerabilities.
        self.info = info
        # The language of the content within the request and response. Default value: **zh**. Valid values:
        # 
        # *   **zh**: Chinese
        # *   **en**: English
        self.lang = lang
        # The operation that you want to perform on the vulnerability. Set the value to **vul_fix**, which indicates vulnerability fixing.
        self.operate_type = operate_type
        # The type of the vulnerability. Set the value to **sys**, which indicates Windows system vulnerabilities.
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.info is not None:
            result['Info'] = self.info
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.operate_type is not None:
            result['OperateType'] = self.operate_type
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Info') is not None:
            self.info = m.get('Info')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('OperateType') is not None:
            self.operate_type = m.get('OperateType')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribeFrontVulPatchListResponseBodyFrontPatchListPatchList(TeaModel):
    def __init__(
        self,
        alias_name: str = None,
        name: str = None,
    ):
        # The name of the Windows system vulnerability.
        self.alias_name = alias_name
        # The version number of the pre-patch that is required to fix the Windows system vulnerability.
        self.name = name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alias_name is not None:
            result['AliasName'] = self.alias_name
        if self.name is not None:
            result['Name'] = self.name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AliasName') is not None:
            self.alias_name = m.get('AliasName')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        return self


class DescribeFrontVulPatchListResponseBodyFrontPatchList(TeaModel):
    def __init__(
        self,
        patch_list: List[DescribeFrontVulPatchListResponseBodyFrontPatchListPatchList] = None,
        uuid: str = None,
    ):
        # An array consisting of the pre-patches that are required to fix the specified Windows system vulnerability on the server.
        self.patch_list = patch_list
        # The UUID of the server.
        self.uuid = uuid

    def validate(self):
        if self.patch_list:
            for k in self.patch_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['PatchList'] = []
        if self.patch_list is not None:
            for k in self.patch_list:
                result['PatchList'].append(k.to_map() if k else None)
        if self.uuid is not None:
            result['Uuid'] = self.uuid
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.patch_list = []
        if m.get('PatchList') is not None:
            for k in m.get('PatchList'):
                temp_model = DescribeFrontVulPatchListResponseBodyFrontPatchListPatchList()
                self.patch_list.append(temp_model.from_map(k))
        if m.get('Uuid') is not None:
            self.uuid = m.get('Uuid')
        return self


class DescribeFrontVulPatchListResponseBody(TeaModel):
    def __init__(
        self,
        front_patch_list: List[DescribeFrontVulPatchListResponseBodyFrontPatchList] = None,
        request_id: str = None,
    ):
        # An array consisting of the information about the pre-patches that are required to fix the specified Windows system vulnerability.
        self.front_patch_list = front_patch_list
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id

    def validate(self):
        if self.front_patch_list:
            for k in self.front_patch_list:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['FrontPatchList'] = []
        if self.front_patch_list is not None:
            for k in self.front_patch_list:
                result['FrontPatchList'].append(k.to_map() if k else None)
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.front_patch_list = []
        if m.get('FrontPatchList') is not None:
            for k in m.get('FrontPatchList'):
                temp_model = DescribeFrontVulPatchListResponseBodyFrontPatchList()
                self.front_patch_list.append(temp_model.from_map(k))
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeFrontVulPatchListResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeFrontVulPatchListResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeFrontVulPatchListResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeGroupedContainerInstancesRequest(TeaModel):
    def __init__(
        self,
        criteria: str = None,
        current_page: int = None,
        field_value: str = None,
        group_field: str = None,
        logical_exp: str = None,
        page_size: int = None,
    ):
        # The search conditions for assets. Specify the value in the JSON format. Separate multiple search conditions with commas (,). Example: `[{"name":"riskStatus","value":"YES"},{"name":"riskLevel","value":"2"}]`.
        # 
        # >  Supported search conditions include the instance ID, instance name, virtual private cloud (VPC) ID, region, and public IP address. You can call the [DescribeCriteria](~~DescribeCriteria~~) operation to query the supported search conditions.
        self.criteria = criteria
        # The number of the page to return. Default value: **1**.
        self.current_page = current_page
        # The keyword that you want to use to query containers. You must specify this parameter based on the value of the GroupField parameter.
        # 
        # *   If the **GroupField** parameter is set to **pod**, set this parameter to the name of the pod that you want to query.
        # *   If the **GroupField** parameter is set to **appName**, set this parameter to the name of the application that you want to query.
        # *   If the **GroupField** parameter is set to **namespace**, set this parameter to the namespace that you want to query.
        # *   If the **GroupField** parameter is set to **clusterId**, set this parameter to the ID of the cluster that you want to query.
        # 
        # >  Fuzzy match is supported.
        self.field_value = field_value
        # The group type that you want to use to query containers. Valid values:
        # 
        # *   **pod**\
        # *   **appName**\
        # *   **namespace**\
        # *   **clusterId**\
        self.group_field = group_field
        # The logical relationship that you want to use to evaluate multiple search conditions. Valid values:
        # 
        # *   **OR**: Search conditions are evaluated by using a logical **OR**.
        # *   **AND**: Search conditions are evaluated by using a logical **AND**.
        self.logical_exp = logical_exp
        # The number of entries to return on each page. Default value: **20**.
        # 
        # >  We recommend that you do not leave this parameter empty.
        self.page_size = page_size

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.criteria is not None:
            result['Criteria'] = self.criteria
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.field_value is not None:
            result['FieldValue'] = self.field_value
        if self.group_field is not None:
            result['GroupField'] = self.group_field
        if self.logical_exp is not None:
            result['LogicalExp'] = self.logical_exp
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Criteria') is not None:
            self.criteria = m.get('Criteria')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('FieldValue') is not None:
            self.field_value = m.get('FieldValue')
        if m.get('GroupField') is not None:
            self.group_field = m.get('GroupField')
        if m.get('LogicalExp') is not None:
            self.logical_exp = m.get('LogicalExp')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        return self


class DescribeGroupedContainerInstancesResponseBodyGroupedContainerInstanceList(TeaModel):
    def __init__(
        self,
        alarm_count: int = None,
        app_name: str = None,
        cluster_id: str = None,
        cluster_name: str = None,
        cluster_type: str = None,
        create_time: int = None,
        custer_state: str = None,
        hc_count: int = None,
        host_ip: str = None,
        image: str = None,
        image_digest: str = None,
        image_repo_name: str = None,
        image_repo_namespace: str = None,
        image_repo_tag: str = None,
        image_uuid: str = None,
        instance_count: int = None,
        instance_id: str = None,
        namespace: str = None,
        pod: str = None,
        pod_ip: str = None,
        region_id: str = None,
        risk_instance_count: int = None,
        risk_level: str = None,
        risk_status: str = None,
        vul_count: int = None,
    ):
        # The number of alerts that are generated on the current pod, application, namespace, or cluster.
        self.alarm_count = alarm_count
        # The name of the application.
        self.app_name = app_name
        # The ID of cluster.
        self.cluster_id = cluster_id
        # The name of the instance.
        self.cluster_name = cluster_name
        # The type of the cluster. Valid values:
        # 
        # *   **Kubernetes**: dedicated Kubernetes cluster
        # *   **ManagedKubernetes**: standard managed cluster (edge cluster)
        # *   **Ask**: standard serverless cluster
        self.cluster_type = cluster_type
        # The timestamp when the cluster was created. Unit: milliseconds.
        self.create_time = create_time
        # The status of the cluster. Valid values:
        # 
        # *   **running**: The cluster is running.
        # *   **stopped**: The cluster is stopped.
        # *   **deleted**: The cluster is deleted.
        # *   **delete_failed**: The cluster fails to be deleted.
        # *   **failed**: The cluster fails to be created.
        self.custer_state = custer_state
        # The number of baseline risks that are detected on the current pod, application, namespace, or cluster.
        self.hc_count = hc_count
        # The IP address of the host in the container cluster.
        self.host_ip = host_ip
        # The image of the container.
        self.image = image
        # The digest value of the image.
        self.image_digest = image_digest
        # The name of the image repository.
        self.image_repo_name = image_repo_name
        # The namespace to which the image repository belongs.
        self.image_repo_namespace = image_repo_namespace
        # The tag that is added to the image repository.
        self.image_repo_tag = image_repo_tag
        # The UUID of the image.
        self.image_uuid = image_uuid
        # The number of queried pods, applications, clusters, or namespaces.
        self.instance_count = instance_count
        # The ID of the server.
        self.instance_id = instance_id
        # The namespace of the cluster.
        self.namespace = namespace
        # The name of the pod.
        self.pod = pod
        # The IP address of the pod.
        self.pod_ip = pod_ip
        # The ID of the region in which the server resides.
        self.region_id = region_id
        # The number of at-risk instances.
        self.risk_instance_count = risk_instance_count
        # The risk level. Valid values:
        # 
        # *   **high**\
        # *   **medium**\
        # *   **low**\
        self.risk_level = risk_level
        # Indicates whether risks were detected. Valid values:
        # 
        # *   **NO**: No risks were detected.
        # *   **YES**: Risks were detected.
        self.risk_status = risk_status
        # The number of vulnerabilities that are detected on the current pod, application, namespace, or cluster.
        self.vul_count = vul_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alarm_count is not None:
            result['AlarmCount'] = self.alarm_count
        if self.app_name is not None:
            result['AppName'] = self.app_name
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.cluster_name is not None:
            result['ClusterName'] = self.cluster_name
        if self.cluster_type is not None:
            result['ClusterType'] = self.cluster_type
        if self.create_time is not None:
            result['CreateTime'] = self.create_time
        if self.custer_state is not None:
            result['CusterState'] = self.custer_state
        if self.hc_count is not None:
            result['HcCount'] = self.hc_count
        if self.host_ip is not None:
            result['HostIp'] = self.host_ip
        if self.image is not None:
            result['Image'] = self.image
        if self.image_digest is not None:
            result['ImageDigest'] = self.image_digest
        if self.image_repo_name is not None:
            result['ImageRepoName'] = self.image_repo_name
        if self.image_repo_namespace is not None:
            result['ImageRepoNamespace'] = self.image_repo_namespace
        if self.image_repo_tag is not None:
            result['ImageRepoTag'] = self.image_repo_tag
        if self.image_uuid is not None:
            result['ImageUuid'] = self.image_uuid
        if self.instance_count is not None:
            result['InstanceCount'] = self.instance_count
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.namespace is not None:
            result['Namespace'] = self.namespace
        if self.pod is not None:
            result['Pod'] = self.pod
        if self.pod_ip is not None:
            result['PodIp'] = self.pod_ip
        if self.region_id is not None:
            result['RegionId'] = self.region_id
        if self.risk_instance_count is not None:
            result['RiskInstanceCount'] = self.risk_instance_count
        if self.risk_level is not None:
            result['RiskLevel'] = self.risk_level
        if self.risk_status is not None:
            result['RiskStatus'] = self.risk_status
        if self.vul_count is not None:
            result['VulCount'] = self.vul_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AlarmCount') is not None:
            self.alarm_count = m.get('AlarmCount')
        if m.get('AppName') is not None:
            self.app_name = m.get('AppName')
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('ClusterName') is not None:
            self.cluster_name = m.get('ClusterName')
        if m.get('ClusterType') is not None:
            self.cluster_type = m.get('ClusterType')
        if m.get('CreateTime') is not None:
            self.create_time = m.get('CreateTime')
        if m.get('CusterState') is not None:
            self.custer_state = m.get('CusterState')
        if m.get('HcCount') is not None:
            self.hc_count = m.get('HcCount')
        if m.get('HostIp') is not None:
            self.host_ip = m.get('HostIp')
        if m.get('Image') is not None:
            self.image = m.get('Image')
        if m.get('ImageDigest') is not None:
            self.image_digest = m.get('ImageDigest')
        if m.get('ImageRepoName') is not None:
            self.image_repo_name = m.get('ImageRepoName')
        if m.get('ImageRepoNamespace') is not None:
            self.image_repo_namespace = m.get('ImageRepoNamespace')
        if m.get('ImageRepoTag') is not None:
            self.image_repo_tag = m.get('ImageRepoTag')
        if m.get('ImageUuid') is not None:
            self.image_uuid = m.get('ImageUuid')
        if m.get('InstanceCount') is not None:
            self.instance_count = m.get('InstanceCount')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('Namespace') is not None:
            self.namespace = m.get('Namespace')
        if m.get('Pod') is not None:
            self.pod = m.get('Pod')
        if m.get('PodIp') is not None:
            self.pod_ip = m.get('PodIp')
        if m.get('RegionId') is not None:
            self.region_id = m.get('RegionId')
        if m.get('RiskInstanceCount') is not None:
            self.risk_instance_count = m.get('RiskInstanceCount')
        if m.get('RiskLevel') is not None:
            self.risk_level = m.get('RiskLevel')
        if m.get('RiskStatus') is not None:
            self.risk_status = m.get('RiskStatus')
        if m.get('VulCount') is not None:
            self.vul_count = m.get('VulCount')
        return self


class DescribeGroupedContainerInstancesResponseBodyPageInfo(TeaModel):
    def __init__(
        self,
        count: int = None,
        current_page: int = None,
        page_size: int = None,
        total_count: int = None,
    ):
        # The number of container assets returned on the current page.
        self.count = count
        # The page number of the returned page.
        self.current_page = current_page
        # The number of entries returned per page. Default value: **20**.
        self.page_size = page_size
        # The total number of container assets returned.
        self.total_count = total_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeGroupedContainerInstancesResponseBody(TeaModel):
    def __init__(
        self,
        grouped_container_instance_list: List[DescribeGroupedContainerInstancesResponseBodyGroupedContainerInstanceList] = None,
        page_info: DescribeGroupedContainerInstancesResponseBodyPageInfo = None,
        request_id: str = None,
    ):
        # An array that consists of the container assets returned.
        self.grouped_container_instance_list = grouped_container_instance_list
        # The pagination information.
        self.page_info = page_info
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id

    def validate(self):
        if self.grouped_container_instance_list:
            for k in self.grouped_container_instance_list:
                if k:
                    k.validate()
        if self.page_info:
            self.page_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['GroupedContainerInstanceList'] = []
        if self.grouped_container_instance_list is not None:
            for k in self.grouped_container_instance_list:
                result['GroupedContainerInstanceList'].append(k.to_map() if k else None)
        if self.page_info is not None:
            result['PageInfo'] = self.page_info.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.grouped_container_instance_list = []
        if m.get('GroupedContainerInstanceList') is not None:
            for k in m.get('GroupedContainerInstanceList'):
                temp_model = DescribeGroupedContainerInstancesResponseBodyGroupedContainerInstanceList()
                self.grouped_container_instance_list.append(temp_model.from_map(k))
        if m.get('PageInfo') is not None:
            temp_model = DescribeGroupedContainerInstancesResponseBodyPageInfo()
            self.page_info = temp_model.from_map(m['PageInfo'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeGroupedContainerInstancesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeGroupedContainerInstancesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeGroupedContainerInstancesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeGroupedInstancesRequest(TeaModel):
    def __init__(
        self,
        current_page: int = None,
        field_value: str = None,
        group_field: str = None,
        lang: str = None,
        machine_types: str = None,
        no_page: bool = None,
        page_size: int = None,
        vendor: int = None,
        vendors: str = None,
    ):
        # The number of the page to return. Default value: **1**.
        self.current_page = current_page
        # The name of the group to which the assets belong. Fuzzy search is supported.
        self.field_value = field_value
        # The filter condition that you want to use to query the assets. Valid values:
        # 
        # *   **groupId**: the group to which the assets belong
        # *   **regionId**: the region in which the assets reside
        # *   **vpcInstanceId**: the virtual private cloud (VPC) in which the assets reside
        self.group_field = group_field
        # The language of the content within the request and response. Default value: **zh**. Valid values:
        # 
        # *   **zh**: Chinese
        # *   **en**: English
        self.lang = lang
        # The type of the assets that you want to query. Set the value to **ecs**, which indicates Elastic Compute Service (ECS) instances.
        self.machine_types = machine_types
        # Specifies whether to enable paged query. Default value: **true**. Valid values:
        # 
        # *   **true**: yes
        # *   **false**: no
        self.no_page = no_page
        # The number of entries to return on each page. Default value: **20**.
        self.page_size = page_size
        # The source of the server. Valid values:
        # 
        # *   **0**: an asset provided by Alibaba Cloud.
        # *   **1**: a third-party cloud server
        # *   **2**: a server in a data center
        # *   **3**, **4**, **5**, and **7**: other cloud asset
        # *   **8**: a lightweight asset
        self.vendor = vendor
        # The source of the server. Separate multiple sources with commas (,).Valid values:
        # 
        # *   **0**: an asset provided by Alibaba Cloud.
        # *   **1**: a third-party cloud server
        # *   **2**: a server in a data center
        # *   **3**, **4**, **5**, and **7**: other cloud asset
        # *   **8**: a lightweight asset
        self.vendors = vendors

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.field_value is not None:
            result['FieldValue'] = self.field_value
        if self.group_field is not None:
            result['GroupField'] = self.group_field
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.machine_types is not None:
            result['MachineTypes'] = self.machine_types
        if self.no_page is not None:
            result['NoPage'] = self.no_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.vendor is not None:
            result['Vendor'] = self.vendor
        if self.vendors is not None:
            result['Vendors'] = self.vendors
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('FieldValue') is not None:
            self.field_value = m.get('FieldValue')
        if m.get('GroupField') is not None:
            self.group_field = m.get('GroupField')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('MachineTypes') is not None:
            self.machine_types = m.get('MachineTypes')
        if m.get('NoPage') is not None:
            self.no_page = m.get('NoPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('Vendor') is not None:
            self.vendor = m.get('Vendor')
        if m.get('Vendors') is not None:
            self.vendors = m.get('Vendors')
        return self


class DescribeGroupedInstancesResponseBodyInstances(TeaModel):
    def __init__(
        self,
        asap_vul_instance_count: int = None,
        field_alias_name: str = None,
        group_flag: int = None,
        instance_count: str = None,
        risk_instance_count: str = None,
        un_protected_instance_count: str = None,
    ):
        # The number of assets on which high-risk vulnerabilities are detected.
        self.asap_vul_instance_count = asap_vul_instance_count
        # The name of the server group.
        self.field_alias_name = field_alias_name
        # The type of the server group. Valid values:
        # 
        # *   **0**: the default group
        # *   **1**: other group
        self.group_flag = group_flag
        # The total number of assets that belong to the specified type.
        # 
        # >  If the **MachineTypes** request parameter is not specified, the value of the InstanceCount parameter is the total number of your assets.
        self.instance_count = instance_count
        # The number of assets that are at risk.
        self.risk_instance_count = risk_instance_count
        # The number of assets that are not protected by Security Center.
        self.un_protected_instance_count = un_protected_instance_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.asap_vul_instance_count is not None:
            result['AsapVulInstanceCount'] = self.asap_vul_instance_count
        if self.field_alias_name is not None:
            result['FieldAliasName'] = self.field_alias_name
        if self.group_flag is not None:
            result['GroupFlag'] = self.group_flag
        if self.instance_count is not None:
            result['InstanceCount'] = self.instance_count
        if self.risk_instance_count is not None:
            result['RiskInstanceCount'] = self.risk_instance_count
        if self.un_protected_instance_count is not None:
            result['UnProtectedInstanceCount'] = self.un_protected_instance_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AsapVulInstanceCount') is not None:
            self.asap_vul_instance_count = m.get('AsapVulInstanceCount')
        if m.get('FieldAliasName') is not None:
            self.field_alias_name = m.get('FieldAliasName')
        if m.get('GroupFlag') is not None:
            self.group_flag = m.get('GroupFlag')
        if m.get('InstanceCount') is not None:
            self.instance_count = m.get('InstanceCount')
        if m.get('RiskInstanceCount') is not None:
            self.risk_instance_count = m.get('RiskInstanceCount')
        if m.get('UnProtectedInstanceCount') is not None:
            self.un_protected_instance_count = m.get('UnProtectedInstanceCount')
        return self


class DescribeGroupedInstancesResponseBodyPageInfo(TeaModel):
    def __init__(
        self,
        count: int = None,
        current_page: int = None,
        page_size: int = None,
        total_count: int = None,
    ):
        # The number of entries returned on the current page.
        self.count = count
        # The page number of the returned page.
        self.current_page = current_page
        # The number of entries returned per page. Default value: **20**.
        self.page_size = page_size
        # The total number of entries returned.
        self.total_count = total_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeGroupedInstancesResponseBody(TeaModel):
    def __init__(
        self,
        instances: List[DescribeGroupedInstancesResponseBodyInstances] = None,
        page_info: DescribeGroupedInstancesResponseBodyPageInfo = None,
        request_id: str = None,
    ):
        # An array that consists of the information about the assets.
        self.instances = instances
        # The pagination information.
        self.page_info = page_info
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id

    def validate(self):
        if self.instances:
            for k in self.instances:
                if k:
                    k.validate()
        if self.page_info:
            self.page_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['Instances'] = []
        if self.instances is not None:
            for k in self.instances:
                result['Instances'].append(k.to_map() if k else None)
        if self.page_info is not None:
            result['PageInfo'] = self.page_info.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.instances = []
        if m.get('Instances') is not None:
            for k in m.get('Instances'):
                temp_model = DescribeGroupedInstancesResponseBodyInstances()
                self.instances.append(temp_model.from_map(k))
        if m.get('PageInfo') is not None:
            temp_model = DescribeGroupedInstancesResponseBodyPageInfo()
            self.page_info = temp_model.from_map(m['PageInfo'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeGroupedInstancesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeGroupedInstancesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeGroupedInstancesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeGroupedMaliciousFilesRequest(TeaModel):
    def __init__(
        self,
        cluster_id: str = None,
        current_page: int = None,
        fuzzy_malicious_name: str = None,
        image_digest: str = None,
        image_layer: str = None,
        image_tag: str = None,
        lang: str = None,
        levels: str = None,
        malicious_md_5: str = None,
        page_size: str = None,
        repo_id: str = None,
        repo_instance_id: str = None,
        repo_name: str = None,
        repo_namespace: str = None,
        repo_region_id: str = None,
        scan_range: List[str] = None,
    ):
        # The cluster ID of the container on which the malicious image sample is detected.
        self.cluster_id = cluster_id
        # The number of the page to return. Pages start from page **1**. Default value: **1**.
        self.current_page = current_page
        # The name of the malicious image sample that you want to query.
        # 
        # >  Fuzzy match is supported.
        self.fuzzy_malicious_name = fuzzy_malicious_name
        # The image digest.
        self.image_digest = image_digest
        # The image layer.
        self.image_layer = image_layer
        # The image tag.
        self.image_tag = image_tag
        # The language of the content within the request and response. Default value: **zh**. Valid values:
        # 
        # *   **zh**: Chinese
        # *   **en**: English
        self.lang = lang
        # The severity of the malicious image sample that you want to query. You can enter multiple severities. Separate the severities with commas (,). Valid values:
        # 
        # *   **serious**\
        # *   **suspicious**\
        # *   **remind**\
        self.levels = levels
        self.malicious_md_5 = malicious_md_5
        # The number of entries to return on each page. Default value: **20**.
        self.page_size = page_size
        # The ID of the image repository.
        # 
        # >  You can call the [ListRepository](~~145293~~) operation to query the IDs of image repositories from the value of the **RepoId** response parameter.
        self.repo_id = repo_id
        # The ID of the container image.
        # 
        # >  You can call the [ListRepository](~~145293~~) operation to query the IDs of container images from the value of the **InstanceId** response parameter.
        self.repo_instance_id = repo_instance_id
        # The name of the image repository.
        # 
        # >  Fuzzy match is supported.
        self.repo_name = repo_name
        # The namespace to which the image repository belongs.
        # 
        # >  Fuzzy match is supported.
        self.repo_namespace = repo_namespace
        # The region ID of the image repository. Valid values:
        # 
        # *   **cn-beijing**: China (Beijing)
        # *   **cn-zhangjiakou**: China (Zhangjiakou)
        # *   **cn-hangzhou**: China (Hangzhou)
        # *   **cn-shanghai**: China (Shanghai)
        # *   **cn-shenzhen**: China (Shenzhen)
        # *   **cn-hongkong**: China (Hong Kong)
        # *   **ap-southeast-1**: Singapore
        # *   **ap-southeast-5**: Indonesia (Jakarta)
        # *   **us-east-1**: US (Virginia)
        # *   **us-west-1**: US (Silicon Valley)
        # *   **eu-central-1**: Germany (Frankfurt)
        # *   **eu-west-1**: UK (London)
        # *   **ap-south-1**: India (Mumbai)
        self.repo_region_id = repo_region_id
        # The types of the assets that you want to scan.
        self.scan_range = scan_range

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.fuzzy_malicious_name is not None:
            result['FuzzyMaliciousName'] = self.fuzzy_malicious_name
        if self.image_digest is not None:
            result['ImageDigest'] = self.image_digest
        if self.image_layer is not None:
            result['ImageLayer'] = self.image_layer
        if self.image_tag is not None:
            result['ImageTag'] = self.image_tag
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.levels is not None:
            result['Levels'] = self.levels
        if self.malicious_md_5 is not None:
            result['MaliciousMd5'] = self.malicious_md_5
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.repo_id is not None:
            result['RepoId'] = self.repo_id
        if self.repo_instance_id is not None:
            result['RepoInstanceId'] = self.repo_instance_id
        if self.repo_name is not None:
            result['RepoName'] = self.repo_name
        if self.repo_namespace is not None:
            result['RepoNamespace'] = self.repo_namespace
        if self.repo_region_id is not None:
            result['RepoRegionId'] = self.repo_region_id
        if self.scan_range is not None:
            result['ScanRange'] = self.scan_range
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('FuzzyMaliciousName') is not None:
            self.fuzzy_malicious_name = m.get('FuzzyMaliciousName')
        if m.get('ImageDigest') is not None:
            self.image_digest = m.get('ImageDigest')
        if m.get('ImageLayer') is not None:
            self.image_layer = m.get('ImageLayer')
        if m.get('ImageTag') is not None:
            self.image_tag = m.get('ImageTag')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('Levels') is not None:
            self.levels = m.get('Levels')
        if m.get('MaliciousMd5') is not None:
            self.malicious_md_5 = m.get('MaliciousMd5')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RepoId') is not None:
            self.repo_id = m.get('RepoId')
        if m.get('RepoInstanceId') is not None:
            self.repo_instance_id = m.get('RepoInstanceId')
        if m.get('RepoName') is not None:
            self.repo_name = m.get('RepoName')
        if m.get('RepoNamespace') is not None:
            self.repo_namespace = m.get('RepoNamespace')
        if m.get('RepoRegionId') is not None:
            self.repo_region_id = m.get('RepoRegionId')
        if m.get('ScanRange') is not None:
            self.scan_range = m.get('ScanRange')
        return self


class DescribeGroupedMaliciousFilesResponseBodyGroupedMaliciousFileResponse(TeaModel):
    def __init__(
        self,
        first_scan_timestamp: int = None,
        image_count: int = None,
        latest_scan_timestamp: int = None,
        level: str = None,
        malicious_md_5: str = None,
        malicious_name: str = None,
        status: int = None,
    ):
        # The timestamp when the first scan was performed. Unit: milliseconds.
        self.first_scan_timestamp = first_scan_timestamp
        # The number of affected images.
        self.image_count = image_count
        # The timestamp when the last scan was performed. Unit: milliseconds.
        self.latest_scan_timestamp = latest_scan_timestamp
        # The severity of the malicious image sample. Valid values:
        # 
        # *   **serious**\
        # *   **suspicious**\
        # *   **remind**\
        self.level = level
        # The MD5 hash value of the malicious image sample.
        self.malicious_md_5 = malicious_md_5
        # The name of the malicious image sample.
        self.malicious_name = malicious_name
        # The handling status of the malicious image sample. Valid values:
        # 
        # *   **0**: unhandled
        # *   **1**: handled
        # *   **2**: verifying
        # *   **3**: added to the whitelist
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.first_scan_timestamp is not None:
            result['FirstScanTimestamp'] = self.first_scan_timestamp
        if self.image_count is not None:
            result['ImageCount'] = self.image_count
        if self.latest_scan_timestamp is not None:
            result['LatestScanTimestamp'] = self.latest_scan_timestamp
        if self.level is not None:
            result['Level'] = self.level
        if self.malicious_md_5 is not None:
            result['MaliciousMd5'] = self.malicious_md_5
        if self.malicious_name is not None:
            result['MaliciousName'] = self.malicious_name
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('FirstScanTimestamp') is not None:
            self.first_scan_timestamp = m.get('FirstScanTimestamp')
        if m.get('ImageCount') is not None:
            self.image_count = m.get('ImageCount')
        if m.get('LatestScanTimestamp') is not None:
            self.latest_scan_timestamp = m.get('LatestScanTimestamp')
        if m.get('Level') is not None:
            self.level = m.get('Level')
        if m.get('MaliciousMd5') is not None:
            self.malicious_md_5 = m.get('MaliciousMd5')
        if m.get('MaliciousName') is not None:
            self.malicious_name = m.get('MaliciousName')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DescribeGroupedMaliciousFilesResponseBodyPageInfo(TeaModel):
    def __init__(
        self,
        count: int = None,
        current_page: int = None,
        page_size: int = None,
        total_count: int = None,
    ):
        # The number of entries returned on the current page.
        self.count = count
        # The page number of the returned page.
        self.current_page = current_page
        # The number of entries returned per page. Default value: **20**.
        self.page_size = page_size
        # The total number of entries returned.
        self.total_count = total_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeGroupedMaliciousFilesResponseBody(TeaModel):
    def __init__(
        self,
        grouped_malicious_file_response: List[DescribeGroupedMaliciousFilesResponseBodyGroupedMaliciousFileResponse] = None,
        page_info: DescribeGroupedMaliciousFilesResponseBodyPageInfo = None,
        request_id: str = None,
    ):
        # An array that consists of the malicious image samples.
        self.grouped_malicious_file_response = grouped_malicious_file_response
        # The pagination information.
        self.page_info = page_info
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id

    def validate(self):
        if self.grouped_malicious_file_response:
            for k in self.grouped_malicious_file_response:
                if k:
                    k.validate()
        if self.page_info:
            self.page_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['GroupedMaliciousFileResponse'] = []
        if self.grouped_malicious_file_response is not None:
            for k in self.grouped_malicious_file_response:
                result['GroupedMaliciousFileResponse'].append(k.to_map() if k else None)
        if self.page_info is not None:
            result['PageInfo'] = self.page_info.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.grouped_malicious_file_response = []
        if m.get('GroupedMaliciousFileResponse') is not None:
            for k in m.get('GroupedMaliciousFileResponse'):
                temp_model = DescribeGroupedMaliciousFilesResponseBodyGroupedMaliciousFileResponse()
                self.grouped_malicious_file_response.append(temp_model.from_map(k))
        if m.get('PageInfo') is not None:
            temp_model = DescribeGroupedMaliciousFilesResponseBodyPageInfo()
            self.page_info = temp_model.from_map(m['PageInfo'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeGroupedMaliciousFilesResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeGroupedMaliciousFilesResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeGroupedMaliciousFilesResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeGroupedTagsRequest(TeaModel):
    def __init__(
        self,
        machine_types: str = None,
    ):
        # The type of the asset to query. If you do not specify this parameter, the tags of all asset types are queried. Valid values:
        # 
        # *   **ecs**: server
        # *   **cloud_product**: Alibaba Cloud service
        self.machine_types = machine_types

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.machine_types is not None:
            result['MachineTypes'] = self.machine_types
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('MachineTypes') is not None:
            self.machine_types = m.get('MachineTypes')
        return self


class DescribeGroupedTagsResponseBodyGroupedFileds(TeaModel):
    def __init__(
        self,
        count: str = None,
        name: str = None,
        tag_id: int = None,
    ):
        # The number of assets to which the tag is added.
        self.count = count
        # The name of the tag.
        self.name = name
        # The ID of the tag.
        self.tag_id = tag_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.name is not None:
            result['Name'] = self.name
        if self.tag_id is not None:
            result['TagId'] = self.tag_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('TagId') is not None:
            self.tag_id = m.get('TagId')
        return self


class DescribeGroupedTagsResponseBody(TeaModel):
    def __init__(
        self,
        count: int = None,
        grouped_fileds: List[DescribeGroupedTagsResponseBodyGroupedFileds] = None,
        http_status_code: int = None,
        request_id: str = None,
        success: bool = None,
    ):
        # This parameter is deprecated.
        self.count = count
        # An array that consists of the statistics of the asset tags.
        self.grouped_fileds = grouped_fileds
        # The HTTP status code of the request.
        self.http_status_code = http_status_code
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id
        # Indicates whether the request is successful. Valid values:
        # 
        # *   **true**: The request is successful.
        # *   **false**: The request fails.
        self.success = success

    def validate(self):
        if self.grouped_fileds:
            for k in self.grouped_fileds:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        result['GroupedFileds'] = []
        if self.grouped_fileds is not None:
            for k in self.grouped_fileds:
                result['GroupedFileds'].append(k.to_map() if k else None)
        if self.http_status_code is not None:
            result['HttpStatusCode'] = self.http_status_code
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.success is not None:
            result['Success'] = self.success
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        self.grouped_fileds = []
        if m.get('GroupedFileds') is not None:
            for k in m.get('GroupedFileds'):
                temp_model = DescribeGroupedTagsResponseBodyGroupedFileds()
                self.grouped_fileds.append(temp_model.from_map(k))
        if m.get('HttpStatusCode') is not None:
            self.http_status_code = m.get('HttpStatusCode')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('Success') is not None:
            self.success = m.get('Success')
        return self


class DescribeGroupedTagsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeGroupedTagsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeGroupedTagsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeGroupedVulRequest(TeaModel):
    def __init__(
        self,
        alias_name: str = None,
        attach_types: str = None,
        current_page: int = None,
        dealed: str = None,
        group_id: str = None,
        lang: str = None,
        necessity: str = None,
        page_size: int = None,
        search_tags: str = None,
        type: str = None,
        uuids: str = None,
    ):
        # The alias of the vulnerability.
        self.alias_name = alias_name
        # The type of the vulnerability.
        # 
        # >  This parameter is valid only for application vulnerabilities and vulnerabilities that are detected based on software component analysis.
        self.attach_types = attach_types
        # The number of the page to return. Default value: **1**.
        self.current_page = current_page
        # Specifies whether the vulnerability is handled. Valid values:
        # 
        # **y**: yes **n**: no
        self.dealed = dealed
        # The ID of the asset group.
        self.group_id = group_id
        # The language of the content within the request and response. Default value: **zh**. Valid values:
        # 
        # *   **zh**: Chinese
        # *   **en**: English
        self.lang = lang
        # The priority to fix the vulnerability. Separate multiple priorities with commas (,). Valid values:
        # 
        # *   **asap**: high
        # *   **later**: medium
        # *   **nntf**: low
        self.necessity = necessity
        # The number of entries to return on each page. Default value: 10.
        self.page_size = page_size
        # The tag that is used to filter vulnerabilities. Valid values:
        # 
        # *   Restart required
        # *   Remote exploitation
        # *   Exploit exists
        # *   Exploitable
        # *   Privilege escalation
        # *   Code execution
        self.search_tags = search_tags
        # The type of the vulnerability. Valid values:
        # 
        # *   **cve**: Linux software vulnerability
        # *   **sys**: Windows system vulnerability
        # *   **cms**: Web-CMS vulnerability
        # *   **app**: application vulnerability
        # *   **emg**: urgent vulnerability
        # *   **sca**: vulnerability that is detected based on software component analysis
        self.type = type
        # The UUIDs of the servers. Separate multiple UUIDs with commas (,).
        self.uuids = uuids

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alias_name is not None:
            result['AliasName'] = self.alias_name
        if self.attach_types is not None:
            result['AttachTypes'] = self.attach_types
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.dealed is not None:
            result['Dealed'] = self.dealed
        if self.group_id is not None:
            result['GroupId'] = self.group_id
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.necessity is not None:
            result['Necessity'] = self.necessity
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.search_tags is not None:
            result['SearchTags'] = self.search_tags
        if self.type is not None:
            result['Type'] = self.type
        if self.uuids is not None:
            result['Uuids'] = self.uuids
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AliasName') is not None:
            self.alias_name = m.get('AliasName')
        if m.get('AttachTypes') is not None:
            self.attach_types = m.get('AttachTypes')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('Dealed') is not None:
            self.dealed = m.get('Dealed')
        if m.get('GroupId') is not None:
            self.group_id = m.get('GroupId')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('Necessity') is not None:
            self.necessity = m.get('Necessity')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('SearchTags') is not None:
            self.search_tags = m.get('SearchTags')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('Uuids') is not None:
            self.uuids = m.get('Uuids')
        return self


class DescribeGroupedVulResponseBodyGroupedVulItems(TeaModel):
    def __init__(
        self,
        alias_name: str = None,
        asap_count: int = None,
        gmt_last: int = None,
        handled_count: int = None,
        later_count: int = None,
        name: str = None,
        nntf_count: int = None,
        tags: str = None,
        total_fix_count: int = None,
        type: str = None,
    ):
        # The alias of the vulnerability.
        self.alias_name = alias_name
        # The number of vulnerabilities that have the **high** priority.
        self.asap_count = asap_count
        # The timestamp when the vulnerability was last detected. Unit: milliseconds.
        self.gmt_last = gmt_last
        # The number of handled vulnerabilities.
        self.handled_count = handled_count
        # The number of vulnerabilities that have the **medium** priority.
        self.later_count = later_count
        # The name of the vulnerability.
        self.name = name
        # The number of vulnerabilities that have the **low** priority.
        self.nntf_count = nntf_count
        # The tag that is added to the vulnerability. Valid values:
        # 
        # *   Restart required
        # *   Remote exploitation
        # *   Exploit exists
        # *   Exploitable
        # *   Privilege escalation
        # *   Code execution
        self.tags = tags
        # The total number of fixed vulnerabilities.
        self.total_fix_count = total_fix_count
        # The type of the vulnerability. Valid values:
        # 
        # *   **cve**: Linux software vulnerability
        # *   **sys**: Windows system vulnerability
        # *   **cms**: Web-CMS vulnerability
        # *   **app**: application vulnerability
        # *   **emg**: urgent vulnerability
        # *   **sca**: vulnerability that is detected based on software component analysis
        self.type = type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.alias_name is not None:
            result['AliasName'] = self.alias_name
        if self.asap_count is not None:
            result['AsapCount'] = self.asap_count
        if self.gmt_last is not None:
            result['GmtLast'] = self.gmt_last
        if self.handled_count is not None:
            result['HandledCount'] = self.handled_count
        if self.later_count is not None:
            result['LaterCount'] = self.later_count
        if self.name is not None:
            result['Name'] = self.name
        if self.nntf_count is not None:
            result['NntfCount'] = self.nntf_count
        if self.tags is not None:
            result['Tags'] = self.tags
        if self.total_fix_count is not None:
            result['TotalFixCount'] = self.total_fix_count
        if self.type is not None:
            result['Type'] = self.type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('AliasName') is not None:
            self.alias_name = m.get('AliasName')
        if m.get('AsapCount') is not None:
            self.asap_count = m.get('AsapCount')
        if m.get('GmtLast') is not None:
            self.gmt_last = m.get('GmtLast')
        if m.get('HandledCount') is not None:
            self.handled_count = m.get('HandledCount')
        if m.get('LaterCount') is not None:
            self.later_count = m.get('LaterCount')
        if m.get('Name') is not None:
            self.name = m.get('Name')
        if m.get('NntfCount') is not None:
            self.nntf_count = m.get('NntfCount')
        if m.get('Tags') is not None:
            self.tags = m.get('Tags')
        if m.get('TotalFixCount') is not None:
            self.total_fix_count = m.get('TotalFixCount')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        return self


class DescribeGroupedVulResponseBody(TeaModel):
    def __init__(
        self,
        current_page: int = None,
        grouped_vul_items: List[DescribeGroupedVulResponseBodyGroupedVulItems] = None,
        page_size: int = None,
        request_id: str = None,
        total_count: int = None,
    ):
        # The page number of the returned page.
        self.current_page = current_page
        # An array that consists of the vulnerabilities.
        self.grouped_vul_items = grouped_vul_items
        # The number of entries returned per page. Default value: 10.
        self.page_size = page_size
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id
        # The total number of entries returned.
        self.total_count = total_count

    def validate(self):
        if self.grouped_vul_items:
            for k in self.grouped_vul_items:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        result['GroupedVulItems'] = []
        if self.grouped_vul_items is not None:
            for k in self.grouped_vul_items:
                result['GroupedVulItems'].append(k.to_map() if k else None)
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        self.grouped_vul_items = []
        if m.get('GroupedVulItems') is not None:
            for k in m.get('GroupedVulItems'):
                temp_model = DescribeGroupedVulResponseBodyGroupedVulItems()
                self.grouped_vul_items.append(temp_model.from_map(k))
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeGroupedVulResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeGroupedVulResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeGroupedVulResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeHcExportInfoRequest(TeaModel):
    def __init__(
        self,
        export_id: int = None,
    ):
        self.export_id = export_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.export_id is not None:
            result['ExportId'] = self.export_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ExportId') is not None:
            self.export_id = m.get('ExportId')
        return self


class DescribeHcExportInfoResponseBody(TeaModel):
    def __init__(
        self,
        current_count: int = None,
        file_name: str = None,
        gmt_create: int = None,
        id: int = None,
        link: str = None,
        progress: int = None,
        request_id: str = None,
        result_status: str = None,
        total_count: int = None,
    ):
        self.current_count = current_count
        self.file_name = file_name
        self.gmt_create = gmt_create
        self.id = id
        self.link = link
        self.progress = progress
        self.request_id = request_id
        self.result_status = result_status
        self.total_count = total_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.current_count is not None:
            result['CurrentCount'] = self.current_count
        if self.file_name is not None:
            result['FileName'] = self.file_name
        if self.gmt_create is not None:
            result['GmtCreate'] = self.gmt_create
        if self.id is not None:
            result['Id'] = self.id
        if self.link is not None:
            result['Link'] = self.link
        if self.progress is not None:
            result['Progress'] = self.progress
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        if self.result_status is not None:
            result['ResultStatus'] = self.result_status
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('CurrentCount') is not None:
            self.current_count = m.get('CurrentCount')
        if m.get('FileName') is not None:
            self.file_name = m.get('FileName')
        if m.get('GmtCreate') is not None:
            self.gmt_create = m.get('GmtCreate')
        if m.get('Id') is not None:
            self.id = m.get('Id')
        if m.get('Link') is not None:
            self.link = m.get('Link')
        if m.get('Progress') is not None:
            self.progress = m.get('Progress')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        if m.get('ResultStatus') is not None:
            self.result_status = m.get('ResultStatus')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeHcExportInfoResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeHcExportInfoResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeHcExportInfoResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeHoneyPotAuthResponseBody(TeaModel):
    def __init__(
        self,
        honey_pot_auth_count: int = None,
        honey_pot_count: int = None,
        request_id: str = None,
    ):
        # The total quota.
        self.honey_pot_auth_count = honey_pot_auth_count
        # The quota that is consumed.
        self.honey_pot_count = honey_pot_count
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.honey_pot_auth_count is not None:
            result['HoneyPotAuthCount'] = self.honey_pot_auth_count
        if self.honey_pot_count is not None:
            result['HoneyPotCount'] = self.honey_pot_count
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('HoneyPotAuthCount') is not None:
            self.honey_pot_auth_count = m.get('HoneyPotAuthCount')
        if m.get('HoneyPotCount') is not None:
            self.honey_pot_count = m.get('HoneyPotCount')
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeHoneyPotAuthResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeHoneyPotAuthResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeHoneyPotAuthResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeHoneyPotSuspStatisticsRequest(TeaModel):
    def __init__(
        self,
        from_: str = None,
        statistics_days: int = None,
        statistics_key_type: str = None,
    ):
        # The source of the request. Set the value to **honeypot**.
        self.from_ = from_
        # The time range of the data to query. Unit: days.
        self.statistics_days = statistics_days
        # The type of the asset to query. Valid values:
        # 
        # *   **vpcInstanceId**: VPC
        # *   **uuid**: server
        self.statistics_key_type = statistics_key_type

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.from_ is not None:
            result['From'] = self.from_
        if self.statistics_days is not None:
            result['StatisticsDays'] = self.statistics_days
        if self.statistics_key_type is not None:
            result['StatisticsKeyType'] = self.statistics_key_type
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('From') is not None:
            self.from_ = m.get('From')
        if m.get('StatisticsDays') is not None:
            self.statistics_days = m.get('StatisticsDays')
        if m.get('StatisticsKeyType') is not None:
            self.statistics_key_type = m.get('StatisticsKeyType')
        return self


class DescribeHoneyPotSuspStatisticsResponseBodySuspHoneyPotStatisticsResponse(TeaModel):
    def __init__(
        self,
        count: int = None,
        instance_id: str = None,
        instance_name: str = None,
        type: str = None,
        vpc_id: str = None,
        vpc_name: str = None,
    ):
        # The total number of alerts that are generated for the asset.
        self.count = count
        # The ID of the server.
        # 
        # >  This parameter is returned only if **StatisticsKeyType** is set to **uuid**.
        self.instance_id = instance_id
        # The name of the server.
        # 
        # >  This parameter is returned only if **StatisticsKeyType** is set to **uuid**.
        self.instance_name = instance_name
        # The type of the asset. Valid values:
        # 
        # *   **vpcInstanceId**: VPC
        # *   **uuid**: server
        self.type = type
        # The ID of the VPC.
        # 
        # >  This parameter is returned only if **StatisticsKeyType** is set to **vpcInstanceId**.
        self.vpc_id = vpc_id
        # The name of the VPC.
        # 
        # >  This parameter is returned only if **StatisticsKeyType** is set to **vpcInstanceId**.
        self.vpc_name = vpc_name

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.instance_id is not None:
            result['InstanceId'] = self.instance_id
        if self.instance_name is not None:
            result['InstanceName'] = self.instance_name
        if self.type is not None:
            result['Type'] = self.type
        if self.vpc_id is not None:
            result['VpcId'] = self.vpc_id
        if self.vpc_name is not None:
            result['VpcName'] = self.vpc_name
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('InstanceId') is not None:
            self.instance_id = m.get('InstanceId')
        if m.get('InstanceName') is not None:
            self.instance_name = m.get('InstanceName')
        if m.get('Type') is not None:
            self.type = m.get('Type')
        if m.get('VpcId') is not None:
            self.vpc_id = m.get('VpcId')
        if m.get('VpcName') is not None:
            self.vpc_name = m.get('VpcName')
        return self


class DescribeHoneyPotSuspStatisticsResponseBody(TeaModel):
    def __init__(
        self,
        request_id: str = None,
        susp_honey_pot_statistics_response: List[DescribeHoneyPotSuspStatisticsResponseBodySuspHoneyPotStatisticsResponse] = None,
    ):
        # The ID of the request, which is used to locate and troubleshoot issues.
        self.request_id = request_id
        # An array consisting of the top 5 VPCs or assets for which alerts are most frequently generated.
        self.susp_honey_pot_statistics_response = susp_honey_pot_statistics_response

    def validate(self):
        if self.susp_honey_pot_statistics_response:
            for k in self.susp_honey_pot_statistics_response:
                if k:
                    k.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        result['SuspHoneyPotStatisticsResponse'] = []
        if self.susp_honey_pot_statistics_response is not None:
            for k in self.susp_honey_pot_statistics_response:
                result['SuspHoneyPotStatisticsResponse'].append(k.to_map() if k else None)
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        self.susp_honey_pot_statistics_response = []
        if m.get('SuspHoneyPotStatisticsResponse') is not None:
            for k in m.get('SuspHoneyPotStatisticsResponse'):
                temp_model = DescribeHoneyPotSuspStatisticsResponseBodySuspHoneyPotStatisticsResponse()
                self.susp_honey_pot_statistics_response.append(temp_model.from_map(k))
        return self


class DescribeHoneyPotSuspStatisticsResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeHoneyPotSuspStatisticsResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeHoneyPotSuspStatisticsResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeImageRequest(TeaModel):
    def __init__(
        self,
        image_instance_id: str = None,
        image_region_id: str = None,
        image_repo_id: str = None,
        image_tag: str = None,
    ):
        self.image_instance_id = image_instance_id
        self.image_region_id = image_region_id
        self.image_repo_id = image_repo_id
        self.image_tag = image_tag

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.image_instance_id is not None:
            result['ImageInstanceId'] = self.image_instance_id
        if self.image_region_id is not None:
            result['ImageRegionId'] = self.image_region_id
        if self.image_repo_id is not None:
            result['ImageRepoId'] = self.image_repo_id
        if self.image_tag is not None:
            result['ImageTag'] = self.image_tag
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ImageInstanceId') is not None:
            self.image_instance_id = m.get('ImageInstanceId')
        if m.get('ImageRegionId') is not None:
            self.image_region_id = m.get('ImageRegionId')
        if m.get('ImageRepoId') is not None:
            self.image_repo_id = m.get('ImageRepoId')
        if m.get('ImageTag') is not None:
            self.image_tag = m.get('ImageTag')
        return self


class DescribeImageResponseBodyData(TeaModel):
    def __init__(
        self,
        digest: str = None,
    ):
        self.digest = digest

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.digest is not None:
            result['Digest'] = self.digest
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Digest') is not None:
            self.digest = m.get('Digest')
        return self


class DescribeImageResponseBody(TeaModel):
    def __init__(
        self,
        data: DescribeImageResponseBodyData = None,
        request_id: str = None,
    ):
        self.data = data
        self.request_id = request_id

    def validate(self):
        if self.data:
            self.data.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.data is not None:
            result['Data'] = self.data.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Data') is not None:
            temp_model = DescribeImageResponseBodyData()
            self.data = temp_model.from_map(m['Data'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeImageResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeImageResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeImageResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeImageBaselineCheckResultRequest(TeaModel):
    def __init__(
        self,
        criteria: str = None,
        criteria_type: str = None,
        current_page: int = None,
        image_uuid: str = None,
        lang: str = None,
        page_size: int = None,
        risk_level: str = None,
        scan_range: List[str] = None,
    ):
        self.criteria = criteria
        self.criteria_type = criteria_type
        self.current_page = current_page
        self.image_uuid = image_uuid
        self.lang = lang
        self.page_size = page_size
        self.risk_level = risk_level
        self.scan_range = scan_range

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.criteria is not None:
            result['Criteria'] = self.criteria
        if self.criteria_type is not None:
            result['CriteriaType'] = self.criteria_type
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.image_uuid is not None:
            result['ImageUuid'] = self.image_uuid
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.risk_level is not None:
            result['RiskLevel'] = self.risk_level
        if self.scan_range is not None:
            result['ScanRange'] = self.scan_range
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Criteria') is not None:
            self.criteria = m.get('Criteria')
        if m.get('CriteriaType') is not None:
            self.criteria_type = m.get('CriteriaType')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('ImageUuid') is not None:
            self.image_uuid = m.get('ImageUuid')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RiskLevel') is not None:
            self.risk_level = m.get('RiskLevel')
        if m.get('ScanRange') is not None:
            self.scan_range = m.get('ScanRange')
        return self


class DescribeImageBaselineCheckResultResponseBodyBaselineResult(TeaModel):
    def __init__(
        self,
        baseline_class_alias: str = None,
        baseline_item_count: int = None,
        baseline_name_alias: str = None,
        baseline_name_key: str = None,
        baseline_name_level: str = None,
        first_scan_time: int = None,
        high_risk_item_count: int = None,
        last_scan_time: int = None,
        low_risk_item_count: int = None,
        middle_risk_item_count: int = None,
        status: int = None,
    ):
        self.baseline_class_alias = baseline_class_alias
        self.baseline_item_count = baseline_item_count
        self.baseline_name_alias = baseline_name_alias
        self.baseline_name_key = baseline_name_key
        self.baseline_name_level = baseline_name_level
        self.first_scan_time = first_scan_time
        self.high_risk_item_count = high_risk_item_count
        self.last_scan_time = last_scan_time
        self.low_risk_item_count = low_risk_item_count
        self.middle_risk_item_count = middle_risk_item_count
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.baseline_class_alias is not None:
            result['BaselineClassAlias'] = self.baseline_class_alias
        if self.baseline_item_count is not None:
            result['BaselineItemCount'] = self.baseline_item_count
        if self.baseline_name_alias is not None:
            result['BaselineNameAlias'] = self.baseline_name_alias
        if self.baseline_name_key is not None:
            result['BaselineNameKey'] = self.baseline_name_key
        if self.baseline_name_level is not None:
            result['BaselineNameLevel'] = self.baseline_name_level
        if self.first_scan_time is not None:
            result['FirstScanTime'] = self.first_scan_time
        if self.high_risk_item_count is not None:
            result['HighRiskItemCount'] = self.high_risk_item_count
        if self.last_scan_time is not None:
            result['LastScanTime'] = self.last_scan_time
        if self.low_risk_item_count is not None:
            result['LowRiskItemCount'] = self.low_risk_item_count
        if self.middle_risk_item_count is not None:
            result['MiddleRiskItemCount'] = self.middle_risk_item_count
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BaselineClassAlias') is not None:
            self.baseline_class_alias = m.get('BaselineClassAlias')
        if m.get('BaselineItemCount') is not None:
            self.baseline_item_count = m.get('BaselineItemCount')
        if m.get('BaselineNameAlias') is not None:
            self.baseline_name_alias = m.get('BaselineNameAlias')
        if m.get('BaselineNameKey') is not None:
            self.baseline_name_key = m.get('BaselineNameKey')
        if m.get('BaselineNameLevel') is not None:
            self.baseline_name_level = m.get('BaselineNameLevel')
        if m.get('FirstScanTime') is not None:
            self.first_scan_time = m.get('FirstScanTime')
        if m.get('HighRiskItemCount') is not None:
            self.high_risk_item_count = m.get('HighRiskItemCount')
        if m.get('LastScanTime') is not None:
            self.last_scan_time = m.get('LastScanTime')
        if m.get('LowRiskItemCount') is not None:
            self.low_risk_item_count = m.get('LowRiskItemCount')
        if m.get('MiddleRiskItemCount') is not None:
            self.middle_risk_item_count = m.get('MiddleRiskItemCount')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DescribeImageBaselineCheckResultResponseBodyPageInfo(TeaModel):
    def __init__(
        self,
        count: int = None,
        current_page: int = None,
        page_size: int = None,
        total_count: int = None,
    ):
        self.count = count
        self.current_page = current_page
        self.page_size = page_size
        self.total_count = total_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.total_count is not None:
            result['TotalCount'] = self.total_count
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('Count') is not None:
            self.count = m.get('Count')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('TotalCount') is not None:
            self.total_count = m.get('TotalCount')
        return self


class DescribeImageBaselineCheckResultResponseBody(TeaModel):
    def __init__(
        self,
        baseline_result: List[DescribeImageBaselineCheckResultResponseBodyBaselineResult] = None,
        page_info: DescribeImageBaselineCheckResultResponseBodyPageInfo = None,
        request_id: str = None,
    ):
        self.baseline_result = baseline_result
        self.page_info = page_info
        self.request_id = request_id

    def validate(self):
        if self.baseline_result:
            for k in self.baseline_result:
                if k:
                    k.validate()
        if self.page_info:
            self.page_info.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        result['BaselineResult'] = []
        if self.baseline_result is not None:
            for k in self.baseline_result:
                result['BaselineResult'].append(k.to_map() if k else None)
        if self.page_info is not None:
            result['PageInfo'] = self.page_info.to_map()
        if self.request_id is not None:
            result['RequestId'] = self.request_id
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        self.baseline_result = []
        if m.get('BaselineResult') is not None:
            for k in m.get('BaselineResult'):
                temp_model = DescribeImageBaselineCheckResultResponseBodyBaselineResult()
                self.baseline_result.append(temp_model.from_map(k))
        if m.get('PageInfo') is not None:
            temp_model = DescribeImageBaselineCheckResultResponseBodyPageInfo()
            self.page_info = temp_model.from_map(m['PageInfo'])
        if m.get('RequestId') is not None:
            self.request_id = m.get('RequestId')
        return self


class DescribeImageBaselineCheckResultResponse(TeaModel):
    def __init__(
        self,
        headers: Dict[str, str] = None,
        status_code: int = None,
        body: DescribeImageBaselineCheckResultResponseBody = None,
    ):
        self.headers = headers
        self.status_code = status_code
        self.body = body

    def validate(self):
        self.validate_required(self.headers, 'headers')
        self.validate_required(self.status_code, 'status_code')
        self.validate_required(self.body, 'body')
        if self.body:
            self.body.validate()

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.headers is not None:
            result['headers'] = self.headers
        if self.status_code is not None:
            result['statusCode'] = self.status_code
        if self.body is not None:
            result['body'] = self.body.to_map()
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('headers') is not None:
            self.headers = m.get('headers')
        if m.get('statusCode') is not None:
            self.status_code = m.get('statusCode')
        if m.get('body') is not None:
            temp_model = DescribeImageBaselineCheckResultResponseBody()
            self.body = temp_model.from_map(m['body'])
        return self


class DescribeImageBaselineCheckSummaryRequest(TeaModel):
    def __init__(
        self,
        cluster_id: str = None,
        criteria: str = None,
        criteria_type: str = None,
        current_page: int = None,
        lang: str = None,
        page_size: int = None,
        risk_level: str = None,
        scan_range: List[str] = None,
    ):
        self.cluster_id = cluster_id
        self.criteria = criteria
        self.criteria_type = criteria_type
        self.current_page = current_page
        self.lang = lang
        self.page_size = page_size
        self.risk_level = risk_level
        self.scan_range = scan_range

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.cluster_id is not None:
            result['ClusterId'] = self.cluster_id
        if self.criteria is not None:
            result['Criteria'] = self.criteria
        if self.criteria_type is not None:
            result['CriteriaType'] = self.criteria_type
        if self.current_page is not None:
            result['CurrentPage'] = self.current_page
        if self.lang is not None:
            result['Lang'] = self.lang
        if self.page_size is not None:
            result['PageSize'] = self.page_size
        if self.risk_level is not None:
            result['RiskLevel'] = self.risk_level
        if self.scan_range is not None:
            result['ScanRange'] = self.scan_range
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('ClusterId') is not None:
            self.cluster_id = m.get('ClusterId')
        if m.get('Criteria') is not None:
            self.criteria = m.get('Criteria')
        if m.get('CriteriaType') is not None:
            self.criteria_type = m.get('CriteriaType')
        if m.get('CurrentPage') is not None:
            self.current_page = m.get('CurrentPage')
        if m.get('Lang') is not None:
            self.lang = m.get('Lang')
        if m.get('PageSize') is not None:
            self.page_size = m.get('PageSize')
        if m.get('RiskLevel') is not None:
            self.risk_level = m.get('RiskLevel')
        if m.get('ScanRange') is not None:
            self.scan_range = m.get('ScanRange')
        return self


class DescribeImageBaselineCheckSummaryResponseBodyBaselineResultSummary(TeaModel):
    def __init__(
        self,
        baseline_class_alias: str = None,
        baseline_class_key: str = None,
        baseline_name_alias: str = None,
        baseline_name_key: str = None,
        baseline_name_level: str = None,
        first_scan_time: int = None,
        high_risk_image: int = None,
        last_scan_time: int = None,
        low_risk_image: int = None,
        middle_risk_image: int = None,
        status: int = None,
    ):
        self.baseline_class_alias = baseline_class_alias
        self.baseline_class_key = baseline_class_key
        self.baseline_name_alias = baseline_name_alias
        self.baseline_name_key = baseline_name_key
        self.baseline_name_level = baseline_name_level
        self.first_scan_time = first_scan_time
        self.high_risk_image = high_risk_image
        self.last_scan_time = last_scan_time
        self.low_risk_image = low_risk_image
        self.middle_risk_image = middle_risk_image
        self.status = status

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.baseline_class_alias is not None:
            result['BaselineClassAlias'] = self.baseline_class_alias
        if self.baseline_class_key is not None:
            result['BaselineClassKey'] = self.baseline_class_key
        if self.baseline_name_alias is not None:
            result['BaselineNameAlias'] = self.baseline_name_alias
        if self.baseline_name_key is not None:
            result['BaselineNameKey'] = self.baseline_name_key
        if self.baseline_name_level is not None:
            result['BaselineNameLevel'] = self.baseline_name_level
        if self.first_scan_time is not None:
            result['FirstScanTime'] = self.first_scan_time
        if self.high_risk_image is not None:
            result['HighRiskImage'] = self.high_risk_image
        if self.last_scan_time is not None:
            result['LastScanTime'] = self.last_scan_time
        if self.low_risk_image is not None:
            result['LowRiskImage'] = self.low_risk_image
        if self.middle_risk_image is not None:
            result['MiddleRiskImage'] = self.middle_risk_image
        if self.status is not None:
            result['Status'] = self.status
        return result

    def from_map(self, m: dict = None):
        m = m or dict()
        if m.get('BaselineClassAlias') is not None:
            self.baseline_class_alias = m.get('BaselineClassAlias')
        if m.get('BaselineClassKey') is not None:
            self.baseline_class_key = m.get('BaselineClassKey')
        if m.get('BaselineNameAlias') is not None:
            self.baseline_name_alias = m.get('BaselineNameAlias')
        if m.get('BaselineNameKey') is not None:
            self.baseline_name_key = m.get('BaselineNameKey')
        if m.get('BaselineNameLevel') is not None:
            self.baseline_name_level = m.get('BaselineNameLevel')
        if m.get('FirstScanTime') is not None:
            self.first_scan_time = m.get('FirstScanTime')
        if m.get('HighRiskImage') is not None:
            self.high_risk_image = m.get('HighRiskImage')
        if m.get('LastScanTime') is not None:
            self.last_scan_time = m.get('LastScanTime')
        if m.get('LowRiskImage') is not None:
            self.low_risk_image = m.get('LowRiskImage')
        if m.get('MiddleRiskImage') is not None:
            self.middle_risk_image = m.get('MiddleRiskImage')
        if m.get('Status') is not None:
            self.status = m.get('Status')
        return self


class DescribeImageBaselineCheckSummaryResponseBodyPageInfo(TeaModel):
    def __init__(
        self,
        count: int = None,
        current_page: int = None,
        page_size: int = None,
        total_count: int = None,
    ):
        self.count = count
        self.current_page = current_page
        self.page_size = page_size
        self.total_count = total_count

    def validate(self):
        pass

    def to_map(self):
        _map = super().to_map()
        if _map is not None:
            return _map

        result = dict()
        if self.count is not None:
            result['Count'] = self.count
        if self.c