# -*- coding: utf-8 -*-
# This file is auto-generated, don't edit it. Thanks.
from typing import Dict
from Tea.core import TeaCore

from alibabacloud_tea_openapi.client import Client as OpenApiClient
from alibabacloud_tea_openapi import models as open_api_models
from alibabacloud_tea_util.client import Client as UtilClient
from alibabacloud_endpoint_util.client import Client as EndpointUtilClient
from alibabacloud_sas20181203 import models as sas_20181203_models
from alibabacloud_tea_util import models as util_models
from alibabacloud_openapi_util.client import Client as OpenApiUtilClient


class Client(OpenApiClient):
    """
    *\
    """
    def __init__(
        self, 
        config: open_api_models.Config,
    ):
        super().__init__(config)
        self._endpoint_rule = 'regional'
        self._endpoint_map = {
            'cn-hangzhou': 'tds.aliyuncs.com',
            'ap-southeast-1': 'tds.ap-southeast-1.aliyuncs.com',
            'ap-southeast-3': 'tds.ap-southeast-3.aliyuncs.com',
            'ap-northeast-1': 'sas.aliyuncs.com',
            'ap-northeast-2-pop': 'sas.aliyuncs.com',
            'ap-south-1': 'sas.aliyuncs.com',
            'ap-southeast-2': 'sas.aliyuncs.com',
            'ap-southeast-5': 'sas.aliyuncs.com',
            'cn-beijing': 'sas.aliyuncs.com',
            'cn-beijing-finance-1': 'sas.aliyuncs.com',
            'cn-beijing-finance-pop': 'sas.aliyuncs.com',
            'cn-beijing-gov-1': 'sas.aliyuncs.com',
            'cn-beijing-nu16-b01': 'sas.aliyuncs.com',
            'cn-chengdu': 'sas.aliyuncs.com',
            'cn-edge-1': 'sas.aliyuncs.com',
            'cn-fujian': 'sas.aliyuncs.com',
            'cn-haidian-cm12-c01': 'sas.aliyuncs.com',
            'cn-hangzhou-bj-b01': 'sas.aliyuncs.com',
            'cn-hangzhou-finance': 'sas.aliyuncs.com',
            'cn-hangzhou-internal-prod-1': 'sas.aliyuncs.com',
            'cn-hangzhou-internal-test-1': 'sas.aliyuncs.com',
            'cn-hangzhou-internal-test-2': 'sas.aliyuncs.com',
            'cn-hangzhou-internal-test-3': 'sas.aliyuncs.com',
            'cn-hangzhou-test-306': 'sas.aliyuncs.com',
            'cn-hongkong': 'sas.aliyuncs.com',
            'cn-hongkong-finance-pop': 'sas.aliyuncs.com',
            'cn-huhehaote': 'sas.aliyuncs.com',
            'cn-huhehaote-nebula-1': 'sas.aliyuncs.com',
            'cn-north-2-gov-1': 'sas.aliyuncs.com',
            'cn-qingdao': 'sas.aliyuncs.com',
            'cn-qingdao-nebula': 'sas.aliyuncs.com',
            'cn-shanghai': 'sas.aliyuncs.com',
            'cn-shanghai-et15-b01': 'sas.aliyuncs.com',
            'cn-shanghai-et2-b01': 'sas.aliyuncs.com',
            'cn-shanghai-finance-1': 'sas.aliyuncs.com',
            'cn-shanghai-inner': 'sas.aliyuncs.com',
            'cn-shanghai-internal-test-1': 'sas.aliyuncs.com',
            'cn-shenzhen': 'sas.aliyuncs.com',
            'cn-shenzhen-finance-1': 'sas.aliyuncs.com',
            'cn-shenzhen-inner': 'sas.aliyuncs.com',
            'cn-shenzhen-st4-d01': 'sas.aliyuncs.com',
            'cn-shenzhen-su18-b01': 'sas.aliyuncs.com',
            'cn-wuhan': 'sas.aliyuncs.com',
            'cn-wulanchabu': 'sas.aliyuncs.com',
            'cn-yushanfang': 'sas.aliyuncs.com',
            'cn-zhangbei': 'sas.aliyuncs.com',
            'cn-zhangbei-na61-b01': 'sas.aliyuncs.com',
            'cn-zhangjiakou': 'sas.aliyuncs.com',
            'cn-zhangjiakou-na62-a01': 'sas.aliyuncs.com',
            'cn-zhengzhou-nebula-1': 'sas.aliyuncs.com',
            'eu-central-1': 'sas.aliyuncs.com',
            'eu-west-1': 'sas.aliyuncs.com',
            'eu-west-1-oxs': 'sas.aliyuncs.com',
            'me-east-1': 'sas.aliyuncs.com',
            'rus-west-1-pop': 'sas.aliyuncs.com',
            'us-east-1': 'sas.aliyuncs.com',
            'us-west-1': 'sas.aliyuncs.com'
        }
        self.check_config(config)
        self._endpoint = self.get_endpoint('sas', self._region_id, self._endpoint_rule, self._network, self._suffix, self._endpoint_map, self._endpoint)

    def get_endpoint(
        self,
        product_id: str,
        region_id: str,
        endpoint_rule: str,
        network: str,
        suffix: str,
        endpoint_map: Dict[str, str],
        endpoint: str,
    ) -> str:
        if not UtilClient.empty(endpoint):
            return endpoint
        if not UtilClient.is_unset(endpoint_map) and not UtilClient.empty(endpoint_map.get(region_id)):
            return endpoint_map.get(region_id)
        return EndpointUtilClient.get_endpoint_rules(product_id, region_id, endpoint_rule, network, suffix)

    def add_check_instance_result_white_list_with_options(
        self,
        request: sas_20181203_models.AddCheckInstanceResultWhiteListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.AddCheckInstanceResultWhiteListResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.check_group_id):
            query['CheckGroupId'] = request.check_group_id
        if not UtilClient.is_unset(request.check_id):
            query['CheckId'] = request.check_id
        if not UtilClient.is_unset(request.instance_ids):
            query['InstanceIds'] = request.instance_ids
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddCheckInstanceResultWhiteList',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.AddCheckInstanceResultWhiteListResponse(),
            self.call_api(params, req, runtime)
        )

    async def add_check_instance_result_white_list_with_options_async(
        self,
        request: sas_20181203_models.AddCheckInstanceResultWhiteListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.AddCheckInstanceResultWhiteListResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.check_group_id):
            query['CheckGroupId'] = request.check_group_id
        if not UtilClient.is_unset(request.check_id):
            query['CheckId'] = request.check_id
        if not UtilClient.is_unset(request.instance_ids):
            query['InstanceIds'] = request.instance_ids
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddCheckInstanceResultWhiteList',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.AddCheckInstanceResultWhiteListResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def add_check_instance_result_white_list(
        self,
        request: sas_20181203_models.AddCheckInstanceResultWhiteListRequest,
    ) -> sas_20181203_models.AddCheckInstanceResultWhiteListResponse:
        runtime = util_models.RuntimeOptions()
        return self.add_check_instance_result_white_list_with_options(request, runtime)

    async def add_check_instance_result_white_list_async(
        self,
        request: sas_20181203_models.AddCheckInstanceResultWhiteListRequest,
    ) -> sas_20181203_models.AddCheckInstanceResultWhiteListResponse:
        runtime = util_models.RuntimeOptions()
        return await self.add_check_instance_result_white_list_with_options_async(request, runtime)

    def add_check_result_white_list_with_options(
        self,
        request: sas_20181203_models.AddCheckResultWhiteListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.AddCheckResultWhiteListResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.check_ids):
            query['CheckIds'] = request.check_ids
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddCheckResultWhiteList',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.AddCheckResultWhiteListResponse(),
            self.call_api(params, req, runtime)
        )

    async def add_check_result_white_list_with_options_async(
        self,
        request: sas_20181203_models.AddCheckResultWhiteListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.AddCheckResultWhiteListResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.check_ids):
            query['CheckIds'] = request.check_ids
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddCheckResultWhiteList',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.AddCheckResultWhiteListResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def add_check_result_white_list(
        self,
        request: sas_20181203_models.AddCheckResultWhiteListRequest,
    ) -> sas_20181203_models.AddCheckResultWhiteListResponse:
        runtime = util_models.RuntimeOptions()
        return self.add_check_result_white_list_with_options(request, runtime)

    async def add_check_result_white_list_async(
        self,
        request: sas_20181203_models.AddCheckResultWhiteListRequest,
    ) -> sas_20181203_models.AddCheckResultWhiteListResponse:
        runtime = util_models.RuntimeOptions()
        return await self.add_check_result_white_list_with_options_async(request, runtime)

    def add_client_user_define_rule_with_options(
        self,
        request: sas_20181203_models.AddClientUserDefineRuleRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.AddClientUserDefineRuleResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.action_type):
            query['ActionType'] = request.action_type
        if not UtilClient.is_unset(request.cmdline):
            query['Cmdline'] = request.cmdline
        if not UtilClient.is_unset(request.file_path):
            query['FilePath'] = request.file_path
        if not UtilClient.is_unset(request.ip):
            query['IP'] = request.ip
        if not UtilClient.is_unset(request.md_5list):
            query['Md5List'] = request.md_5list
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.new_file_path):
            query['NewFilePath'] = request.new_file_path
        if not UtilClient.is_unset(request.parent_cmdline):
            query['ParentCmdline'] = request.parent_cmdline
        if not UtilClient.is_unset(request.parent_proc_path):
            query['ParentProcPath'] = request.parent_proc_path
        if not UtilClient.is_unset(request.platform):
            query['Platform'] = request.platform
        if not UtilClient.is_unset(request.port):
            query['Port'] = request.port
        if not UtilClient.is_unset(request.port_str):
            query['PortStr'] = request.port_str
        if not UtilClient.is_unset(request.proc_path):
            query['ProcPath'] = request.proc_path
        if not UtilClient.is_unset(request.registry_content):
            query['RegistryContent'] = request.registry_content
        if not UtilClient.is_unset(request.registry_key):
            query['RegistryKey'] = request.registry_key
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddClientUserDefineRule',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.AddClientUserDefineRuleResponse(),
            self.call_api(params, req, runtime)
        )

    async def add_client_user_define_rule_with_options_async(
        self,
        request: sas_20181203_models.AddClientUserDefineRuleRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.AddClientUserDefineRuleResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.action_type):
            query['ActionType'] = request.action_type
        if not UtilClient.is_unset(request.cmdline):
            query['Cmdline'] = request.cmdline
        if not UtilClient.is_unset(request.file_path):
            query['FilePath'] = request.file_path
        if not UtilClient.is_unset(request.ip):
            query['IP'] = request.ip
        if not UtilClient.is_unset(request.md_5list):
            query['Md5List'] = request.md_5list
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.new_file_path):
            query['NewFilePath'] = request.new_file_path
        if not UtilClient.is_unset(request.parent_cmdline):
            query['ParentCmdline'] = request.parent_cmdline
        if not UtilClient.is_unset(request.parent_proc_path):
            query['ParentProcPath'] = request.parent_proc_path
        if not UtilClient.is_unset(request.platform):
            query['Platform'] = request.platform
        if not UtilClient.is_unset(request.port):
            query['Port'] = request.port
        if not UtilClient.is_unset(request.port_str):
            query['PortStr'] = request.port_str
        if not UtilClient.is_unset(request.proc_path):
            query['ProcPath'] = request.proc_path
        if not UtilClient.is_unset(request.registry_content):
            query['RegistryContent'] = request.registry_content
        if not UtilClient.is_unset(request.registry_key):
            query['RegistryKey'] = request.registry_key
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddClientUserDefineRule',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.AddClientUserDefineRuleResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def add_client_user_define_rule(
        self,
        request: sas_20181203_models.AddClientUserDefineRuleRequest,
    ) -> sas_20181203_models.AddClientUserDefineRuleResponse:
        runtime = util_models.RuntimeOptions()
        return self.add_client_user_define_rule_with_options(request, runtime)

    async def add_client_user_define_rule_async(
        self,
        request: sas_20181203_models.AddClientUserDefineRuleRequest,
    ) -> sas_20181203_models.AddClientUserDefineRuleResponse:
        runtime = util_models.RuntimeOptions()
        return await self.add_client_user_define_rule_with_options_async(request, runtime)

    def add_install_code_with_options(
        self,
        request: sas_20181203_models.AddInstallCodeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.AddInstallCodeResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.expired_date):
            query['ExpiredDate'] = request.expired_date
        if not UtilClient.is_unset(request.group_id):
            query['GroupId'] = request.group_id
        if not UtilClient.is_unset(request.only_image):
            query['OnlyImage'] = request.only_image
        if not UtilClient.is_unset(request.os):
            query['Os'] = request.os
        if not UtilClient.is_unset(request.vendor_name):
            query['VendorName'] = request.vendor_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddInstallCode',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.AddInstallCodeResponse(),
            self.call_api(params, req, runtime)
        )

    async def add_install_code_with_options_async(
        self,
        request: sas_20181203_models.AddInstallCodeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.AddInstallCodeResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.expired_date):
            query['ExpiredDate'] = request.expired_date
        if not UtilClient.is_unset(request.group_id):
            query['GroupId'] = request.group_id
        if not UtilClient.is_unset(request.only_image):
            query['OnlyImage'] = request.only_image
        if not UtilClient.is_unset(request.os):
            query['Os'] = request.os
        if not UtilClient.is_unset(request.vendor_name):
            query['VendorName'] = request.vendor_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddInstallCode',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.AddInstallCodeResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def add_install_code(
        self,
        request: sas_20181203_models.AddInstallCodeRequest,
    ) -> sas_20181203_models.AddInstallCodeResponse:
        runtime = util_models.RuntimeOptions()
        return self.add_install_code_with_options(request, runtime)

    async def add_install_code_async(
        self,
        request: sas_20181203_models.AddInstallCodeRequest,
    ) -> sas_20181203_models.AddInstallCodeResponse:
        runtime = util_models.RuntimeOptions()
        return await self.add_install_code_with_options_async(request, runtime)

    def add_tag_with_uuid_with_options(
        self,
        request: sas_20181203_models.AddTagWithUuidRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.AddTagWithUuidResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.tag_name):
            query['TagName'] = request.tag_name
        if not UtilClient.is_unset(request.uuid_list):
            query['UuidList'] = request.uuid_list
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddTagWithUuid',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.AddTagWithUuidResponse(),
            self.call_api(params, req, runtime)
        )

    async def add_tag_with_uuid_with_options_async(
        self,
        request: sas_20181203_models.AddTagWithUuidRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.AddTagWithUuidResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.tag_name):
            query['TagName'] = request.tag_name
        if not UtilClient.is_unset(request.uuid_list):
            query['UuidList'] = request.uuid_list
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddTagWithUuid',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.AddTagWithUuidResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def add_tag_with_uuid(
        self,
        request: sas_20181203_models.AddTagWithUuidRequest,
    ) -> sas_20181203_models.AddTagWithUuidResponse:
        runtime = util_models.RuntimeOptions()
        return self.add_tag_with_uuid_with_options(request, runtime)

    async def add_tag_with_uuid_async(
        self,
        request: sas_20181203_models.AddTagWithUuidRequest,
    ) -> sas_20181203_models.AddTagWithUuidResponse:
        runtime = util_models.RuntimeOptions()
        return await self.add_tag_with_uuid_with_options_async(request, runtime)

    def add_uninstall_clients_by_uuids_with_options(
        self,
        request: sas_20181203_models.AddUninstallClientsByUuidsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.AddUninstallClientsByUuidsResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.call_method):
            query['CallMethod'] = request.call_method
        if not UtilClient.is_unset(request.feedback):
            query['Feedback'] = request.feedback
        if not UtilClient.is_unset(request.region):
            query['Region'] = request.region
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.uuids):
            query['Uuids'] = request.uuids
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddUninstallClientsByUuids',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.AddUninstallClientsByUuidsResponse(),
            self.call_api(params, req, runtime)
        )

    async def add_uninstall_clients_by_uuids_with_options_async(
        self,
        request: sas_20181203_models.AddUninstallClientsByUuidsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.AddUninstallClientsByUuidsResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.call_method):
            query['CallMethod'] = request.call_method
        if not UtilClient.is_unset(request.feedback):
            query['Feedback'] = request.feedback
        if not UtilClient.is_unset(request.region):
            query['Region'] = request.region
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.uuids):
            query['Uuids'] = request.uuids
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddUninstallClientsByUuids',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.AddUninstallClientsByUuidsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def add_uninstall_clients_by_uuids(
        self,
        request: sas_20181203_models.AddUninstallClientsByUuidsRequest,
    ) -> sas_20181203_models.AddUninstallClientsByUuidsResponse:
        runtime = util_models.RuntimeOptions()
        return self.add_uninstall_clients_by_uuids_with_options(request, runtime)

    async def add_uninstall_clients_by_uuids_async(
        self,
        request: sas_20181203_models.AddUninstallClientsByUuidsRequest,
    ) -> sas_20181203_models.AddUninstallClientsByUuidsResponse:
        runtime = util_models.RuntimeOptions()
        return await self.add_uninstall_clients_by_uuids_with_options_async(request, runtime)

    def add_vpc_honey_pot_with_options(
        self,
        request: sas_20181203_models.AddVpcHoneyPotRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.AddVpcHoneyPotResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddVpcHoneyPot',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.AddVpcHoneyPotResponse(),
            self.call_api(params, req, runtime)
        )

    async def add_vpc_honey_pot_with_options_async(
        self,
        request: sas_20181203_models.AddVpcHoneyPotRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.AddVpcHoneyPotResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddVpcHoneyPot',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.AddVpcHoneyPotResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def add_vpc_honey_pot(
        self,
        request: sas_20181203_models.AddVpcHoneyPotRequest,
    ) -> sas_20181203_models.AddVpcHoneyPotResponse:
        runtime = util_models.RuntimeOptions()
        return self.add_vpc_honey_pot_with_options(request, runtime)

    async def add_vpc_honey_pot_async(
        self,
        request: sas_20181203_models.AddVpcHoneyPotRequest,
    ) -> sas_20181203_models.AddVpcHoneyPotResponse:
        runtime = util_models.RuntimeOptions()
        return await self.add_vpc_honey_pot_with_options_async(request, runtime)

    def advance_security_event_operations_with_options(
        self,
        request: sas_20181203_models.AdvanceSecurityEventOperationsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.AdvanceSecurityEventOperationsResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.event_name):
            query['EventName'] = request.event_name
        if not UtilClient.is_unset(request.event_type):
            query['EventType'] = request.event_type
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.rule_id):
            query['RuleId'] = request.rule_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AdvanceSecurityEventOperations',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.AdvanceSecurityEventOperationsResponse(),
            self.call_api(params, req, runtime)
        )

    async def advance_security_event_operations_with_options_async(
        self,
        request: sas_20181203_models.AdvanceSecurityEventOperationsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.AdvanceSecurityEventOperationsResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.event_name):
            query['EventName'] = request.event_name
        if not UtilClient.is_unset(request.event_type):
            query['EventType'] = request.event_type
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.rule_id):
            query['RuleId'] = request.rule_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AdvanceSecurityEventOperations',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.AdvanceSecurityEventOperationsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def advance_security_event_operations(
        self,
        request: sas_20181203_models.AdvanceSecurityEventOperationsRequest,
    ) -> sas_20181203_models.AdvanceSecurityEventOperationsResponse:
        runtime = util_models.RuntimeOptions()
        return self.advance_security_event_operations_with_options(request, runtime)

    async def advance_security_event_operations_async(
        self,
        request: sas_20181203_models.AdvanceSecurityEventOperationsRequest,
    ) -> sas_20181203_models.AdvanceSecurityEventOperationsResponse:
        runtime = util_models.RuntimeOptions()
        return await self.advance_security_event_operations_with_options_async(request, runtime)

    def batch_operate_common_overall_config_with_options(
        self,
        request: sas_20181203_models.BatchOperateCommonOverallConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.BatchOperateCommonOverallConfigResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.config):
            query['Config'] = request.config
        if not UtilClient.is_unset(request.type_list):
            query['TypeList'] = request.type_list
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='BatchOperateCommonOverallConfig',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.BatchOperateCommonOverallConfigResponse(),
            self.call_api(params, req, runtime)
        )

    async def batch_operate_common_overall_config_with_options_async(
        self,
        request: sas_20181203_models.BatchOperateCommonOverallConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.BatchOperateCommonOverallConfigResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.config):
            query['Config'] = request.config
        if not UtilClient.is_unset(request.type_list):
            query['TypeList'] = request.type_list
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='BatchOperateCommonOverallConfig',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.BatchOperateCommonOverallConfigResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def batch_operate_common_overall_config(
        self,
        request: sas_20181203_models.BatchOperateCommonOverallConfigRequest,
    ) -> sas_20181203_models.BatchOperateCommonOverallConfigResponse:
        runtime = util_models.RuntimeOptions()
        return self.batch_operate_common_overall_config_with_options(request, runtime)

    async def batch_operate_common_overall_config_async(
        self,
        request: sas_20181203_models.BatchOperateCommonOverallConfigRequest,
    ) -> sas_20181203_models.BatchOperateCommonOverallConfigResponse:
        runtime = util_models.RuntimeOptions()
        return await self.batch_operate_common_overall_config_with_options_async(request, runtime)

    def bind_auth_to_machine_with_options(
        self,
        request: sas_20181203_models.BindAuthToMachineRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.BindAuthToMachineResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.auth_version):
            query['AuthVersion'] = request.auth_version
        if not UtilClient.is_unset(request.auto_bind):
            query['AutoBind'] = request.auto_bind
        if not UtilClient.is_unset(request.bind):
            query['Bind'] = request.bind
        if not UtilClient.is_unset(request.bind_all):
            query['BindAll'] = request.bind_all
        if not UtilClient.is_unset(request.criteria):
            query['Criteria'] = request.criteria
        if not UtilClient.is_unset(request.logical_exp):
            query['LogicalExp'] = request.logical_exp
        if not UtilClient.is_unset(request.un_bind):
            query['UnBind'] = request.un_bind
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='BindAuthToMachine',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.BindAuthToMachineResponse(),
            self.call_api(params, req, runtime)
        )

    async def bind_auth_to_machine_with_options_async(
        self,
        request: sas_20181203_models.BindAuthToMachineRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.BindAuthToMachineResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.auth_version):
            query['AuthVersion'] = request.auth_version
        if not UtilClient.is_unset(request.auto_bind):
            query['AutoBind'] = request.auto_bind
        if not UtilClient.is_unset(request.bind):
            query['Bind'] = request.bind
        if not UtilClient.is_unset(request.bind_all):
            query['BindAll'] = request.bind_all
        if not UtilClient.is_unset(request.criteria):
            query['Criteria'] = request.criteria
        if not UtilClient.is_unset(request.logical_exp):
            query['LogicalExp'] = request.logical_exp
        if not UtilClient.is_unset(request.un_bind):
            query['UnBind'] = request.un_bind
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='BindAuthToMachine',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.BindAuthToMachineResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def bind_auth_to_machine(
        self,
        request: sas_20181203_models.BindAuthToMachineRequest,
    ) -> sas_20181203_models.BindAuthToMachineResponse:
        runtime = util_models.RuntimeOptions()
        return self.bind_auth_to_machine_with_options(request, runtime)

    async def bind_auth_to_machine_async(
        self,
        request: sas_20181203_models.BindAuthToMachineRequest,
    ) -> sas_20181203_models.BindAuthToMachineResponse:
        runtime = util_models.RuntimeOptions()
        return await self.bind_auth_to_machine_with_options_async(request, runtime)

    def cancel_once_task_with_options(
        self,
        request: sas_20181203_models.CancelOnceTaskRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CancelOnceTaskResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.task_id):
            query['TaskId'] = request.task_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CancelOnceTask',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CancelOnceTaskResponse(),
            self.call_api(params, req, runtime)
        )

    async def cancel_once_task_with_options_async(
        self,
        request: sas_20181203_models.CancelOnceTaskRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CancelOnceTaskResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.task_id):
            query['TaskId'] = request.task_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CancelOnceTask',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CancelOnceTaskResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def cancel_once_task(
        self,
        request: sas_20181203_models.CancelOnceTaskRequest,
    ) -> sas_20181203_models.CancelOnceTaskResponse:
        runtime = util_models.RuntimeOptions()
        return self.cancel_once_task_with_options(request, runtime)

    async def cancel_once_task_async(
        self,
        request: sas_20181203_models.CancelOnceTaskRequest,
    ) -> sas_20181203_models.CancelOnceTaskResponse:
        runtime = util_models.RuntimeOptions()
        return await self.cancel_once_task_with_options_async(request, runtime)

    def change_check_config_with_options(
        self,
        request: sas_20181203_models.ChangeCheckConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.ChangeCheckConfigResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cycle_days):
            query['CycleDays'] = request.cycle_days
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.standard_ids):
            query['StandardIds'] = request.standard_ids
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ChangeCheckConfig',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.ChangeCheckConfigResponse(),
            self.call_api(params, req, runtime)
        )

    async def change_check_config_with_options_async(
        self,
        request: sas_20181203_models.ChangeCheckConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.ChangeCheckConfigResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cycle_days):
            query['CycleDays'] = request.cycle_days
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.standard_ids):
            query['StandardIds'] = request.standard_ids
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ChangeCheckConfig',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.ChangeCheckConfigResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def change_check_config(
        self,
        request: sas_20181203_models.ChangeCheckConfigRequest,
    ) -> sas_20181203_models.ChangeCheckConfigResponse:
        runtime = util_models.RuntimeOptions()
        return self.change_check_config_with_options(request, runtime)

    async def change_check_config_async(
        self,
        request: sas_20181203_models.ChangeCheckConfigRequest,
    ) -> sas_20181203_models.ChangeCheckConfigResponse:
        runtime = util_models.RuntimeOptions()
        return await self.change_check_config_with_options_async(request, runtime)

    def check_quara_file_id_with_options(
        self,
        request: sas_20181203_models.CheckQuaraFileIdRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CheckQuaraFileIdResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.quara_file_ids):
            query['QuaraFileIds'] = request.quara_file_ids
        if not UtilClient.is_unset(request.uuid):
            query['Uuid'] = request.uuid
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CheckQuaraFileId',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CheckQuaraFileIdResponse(),
            self.call_api(params, req, runtime)
        )

    async def check_quara_file_id_with_options_async(
        self,
        request: sas_20181203_models.CheckQuaraFileIdRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CheckQuaraFileIdResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.quara_file_ids):
            query['QuaraFileIds'] = request.quara_file_ids
        if not UtilClient.is_unset(request.uuid):
            query['Uuid'] = request.uuid
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CheckQuaraFileId',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CheckQuaraFileIdResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def check_quara_file_id(
        self,
        request: sas_20181203_models.CheckQuaraFileIdRequest,
    ) -> sas_20181203_models.CheckQuaraFileIdResponse:
        runtime = util_models.RuntimeOptions()
        return self.check_quara_file_id_with_options(request, runtime)

    async def check_quara_file_id_async(
        self,
        request: sas_20181203_models.CheckQuaraFileIdRequest,
    ) -> sas_20181203_models.CheckQuaraFileIdResponse:
        runtime = util_models.RuntimeOptions()
        return await self.check_quara_file_id_with_options_async(request, runtime)

    def check_security_event_id_with_options(
        self,
        request: sas_20181203_models.CheckSecurityEventIdRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CheckSecurityEventIdResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.security_event_ids):
            query['SecurityEventIds'] = request.security_event_ids
        if not UtilClient.is_unset(request.uuid):
            query['Uuid'] = request.uuid
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CheckSecurityEventId',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CheckSecurityEventIdResponse(),
            self.call_api(params, req, runtime)
        )

    async def check_security_event_id_with_options_async(
        self,
        request: sas_20181203_models.CheckSecurityEventIdRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CheckSecurityEventIdResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.security_event_ids):
            query['SecurityEventIds'] = request.security_event_ids
        if not UtilClient.is_unset(request.uuid):
            query['Uuid'] = request.uuid
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CheckSecurityEventId',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CheckSecurityEventIdResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def check_security_event_id(
        self,
        request: sas_20181203_models.CheckSecurityEventIdRequest,
    ) -> sas_20181203_models.CheckSecurityEventIdResponse:
        runtime = util_models.RuntimeOptions()
        return self.check_security_event_id_with_options(request, runtime)

    async def check_security_event_id_async(
        self,
        request: sas_20181203_models.CheckSecurityEventIdRequest,
    ) -> sas_20181203_models.CheckSecurityEventIdResponse:
        runtime = util_models.RuntimeOptions()
        return await self.check_security_event_id_with_options_async(request, runtime)

    def check_user_has_ecs_with_options(
        self,
        request: sas_20181203_models.CheckUserHasEcsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CheckUserHasEcsResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CheckUserHasEcs',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CheckUserHasEcsResponse(),
            self.call_api(params, req, runtime)
        )

    async def check_user_has_ecs_with_options_async(
        self,
        request: sas_20181203_models.CheckUserHasEcsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CheckUserHasEcsResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CheckUserHasEcs',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CheckUserHasEcsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def check_user_has_ecs(
        self,
        request: sas_20181203_models.CheckUserHasEcsRequest,
    ) -> sas_20181203_models.CheckUserHasEcsResponse:
        runtime = util_models.RuntimeOptions()
        return self.check_user_has_ecs_with_options(request, runtime)

    async def check_user_has_ecs_async(
        self,
        request: sas_20181203_models.CheckUserHasEcsRequest,
    ) -> sas_20181203_models.CheckUserHasEcsResponse:
        runtime = util_models.RuntimeOptions()
        return await self.check_user_has_ecs_with_options_async(request, runtime)

    def confirm_virus_events_with_options(
        self,
        request: sas_20181203_models.ConfirmVirusEventsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.ConfirmVirusEventsResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.operation_all):
            query['OperationAll'] = request.operation_all
        if not UtilClient.is_unset(request.operation_code):
            query['OperationCode'] = request.operation_code
        if not UtilClient.is_unset(request.operation_range):
            query['OperationRange'] = request.operation_range
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ConfirmVirusEvents',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.ConfirmVirusEventsResponse(),
            self.call_api(params, req, runtime)
        )

    async def confirm_virus_events_with_options_async(
        self,
        request: sas_20181203_models.ConfirmVirusEventsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.ConfirmVirusEventsResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.operation_all):
            query['OperationAll'] = request.operation_all
        if not UtilClient.is_unset(request.operation_code):
            query['OperationCode'] = request.operation_code
        if not UtilClient.is_unset(request.operation_range):
            query['OperationRange'] = request.operation_range
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ConfirmVirusEvents',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.ConfirmVirusEventsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def confirm_virus_events(
        self,
        request: sas_20181203_models.ConfirmVirusEventsRequest,
    ) -> sas_20181203_models.ConfirmVirusEventsResponse:
        runtime = util_models.RuntimeOptions()
        return self.confirm_virus_events_with_options(request, runtime)

    async def confirm_virus_events_async(
        self,
        request: sas_20181203_models.ConfirmVirusEventsRequest,
    ) -> sas_20181203_models.ConfirmVirusEventsResponse:
        runtime = util_models.RuntimeOptions()
        return await self.confirm_virus_events_with_options_async(request, runtime)

    def create_anti_brute_force_rule_with_options(
        self,
        request: sas_20181203_models.CreateAntiBruteForceRuleRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CreateAntiBruteForceRuleResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.default_rule):
            query['DefaultRule'] = request.default_rule
        if not UtilClient.is_unset(request.fail_count):
            query['FailCount'] = request.fail_count
        if not UtilClient.is_unset(request.forbidden_time):
            query['ForbiddenTime'] = request.forbidden_time
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.span):
            query['Span'] = request.span
        if not UtilClient.is_unset(request.uuid_list):
            query['UuidList'] = request.uuid_list
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateAntiBruteForceRule',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CreateAntiBruteForceRuleResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_anti_brute_force_rule_with_options_async(
        self,
        request: sas_20181203_models.CreateAntiBruteForceRuleRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CreateAntiBruteForceRuleResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.default_rule):
            query['DefaultRule'] = request.default_rule
        if not UtilClient.is_unset(request.fail_count):
            query['FailCount'] = request.fail_count
        if not UtilClient.is_unset(request.forbidden_time):
            query['ForbiddenTime'] = request.forbidden_time
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.span):
            query['Span'] = request.span
        if not UtilClient.is_unset(request.uuid_list):
            query['UuidList'] = request.uuid_list
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateAntiBruteForceRule',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CreateAntiBruteForceRuleResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_anti_brute_force_rule(
        self,
        request: sas_20181203_models.CreateAntiBruteForceRuleRequest,
    ) -> sas_20181203_models.CreateAntiBruteForceRuleResponse:
        runtime = util_models.RuntimeOptions()
        return self.create_anti_brute_force_rule_with_options(request, runtime)

    async def create_anti_brute_force_rule_async(
        self,
        request: sas_20181203_models.CreateAntiBruteForceRuleRequest,
    ) -> sas_20181203_models.CreateAntiBruteForceRuleResponse:
        runtime = util_models.RuntimeOptions()
        return await self.create_anti_brute_force_rule_with_options_async(request, runtime)

    def create_backup_policy_with_options(
        self,
        tmp_req: sas_20181203_models.CreateBackupPolicyRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CreateBackupPolicyResponse:
        UtilClient.validate_model(tmp_req)
        request = sas_20181203_models.CreateBackupPolicyShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.policy):
            request.policy_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.policy, 'Policy', 'json')
        query = {}
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.policy_shrink):
            query['Policy'] = request.policy_shrink
        if not UtilClient.is_unset(request.policy_region_id):
            query['PolicyRegionId'] = request.policy_region_id
        if not UtilClient.is_unset(request.policy_version):
            query['PolicyVersion'] = request.policy_version
        if not UtilClient.is_unset(request.uuid_list):
            query['UuidList'] = request.uuid_list
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateBackupPolicy',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CreateBackupPolicyResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_backup_policy_with_options_async(
        self,
        tmp_req: sas_20181203_models.CreateBackupPolicyRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CreateBackupPolicyResponse:
        UtilClient.validate_model(tmp_req)
        request = sas_20181203_models.CreateBackupPolicyShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.policy):
            request.policy_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.policy, 'Policy', 'json')
        query = {}
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.policy_shrink):
            query['Policy'] = request.policy_shrink
        if not UtilClient.is_unset(request.policy_region_id):
            query['PolicyRegionId'] = request.policy_region_id
        if not UtilClient.is_unset(request.policy_version):
            query['PolicyVersion'] = request.policy_version
        if not UtilClient.is_unset(request.uuid_list):
            query['UuidList'] = request.uuid_list
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateBackupPolicy',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CreateBackupPolicyResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_backup_policy(
        self,
        request: sas_20181203_models.CreateBackupPolicyRequest,
    ) -> sas_20181203_models.CreateBackupPolicyResponse:
        runtime = util_models.RuntimeOptions()
        return self.create_backup_policy_with_options(request, runtime)

    async def create_backup_policy_async(
        self,
        request: sas_20181203_models.CreateBackupPolicyRequest,
    ) -> sas_20181203_models.CreateBackupPolicyResponse:
        runtime = util_models.RuntimeOptions()
        return await self.create_backup_policy_with_options_async(request, runtime)

    def create_container_scan_task_with_options(
        self,
        request: sas_20181203_models.CreateContainerScanTaskRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CreateContainerScanTaskResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cluster_id):
            query['ClusterId'] = request.cluster_id
        if not UtilClient.is_unset(request.container_ids):
            query['ContainerIds'] = request.container_ids
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateContainerScanTask',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CreateContainerScanTaskResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_container_scan_task_with_options_async(
        self,
        request: sas_20181203_models.CreateContainerScanTaskRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CreateContainerScanTaskResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cluster_id):
            query['ClusterId'] = request.cluster_id
        if not UtilClient.is_unset(request.container_ids):
            query['ContainerIds'] = request.container_ids
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateContainerScanTask',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CreateContainerScanTaskResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_container_scan_task(
        self,
        request: sas_20181203_models.CreateContainerScanTaskRequest,
    ) -> sas_20181203_models.CreateContainerScanTaskResponse:
        runtime = util_models.RuntimeOptions()
        return self.create_container_scan_task_with_options(request, runtime)

    async def create_container_scan_task_async(
        self,
        request: sas_20181203_models.CreateContainerScanTaskRequest,
    ) -> sas_20181203_models.CreateContainerScanTaskResponse:
        runtime = util_models.RuntimeOptions()
        return await self.create_container_scan_task_with_options_async(request, runtime)

    def create_custom_block_record_with_options(
        self,
        request: sas_20181203_models.CreateCustomBlockRecordRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CreateCustomBlockRecordResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.block_ip):
            query['BlockIp'] = request.block_ip
        if not UtilClient.is_unset(request.bound):
            query['Bound'] = request.bound
        if not UtilClient.is_unset(request.expire_time):
            query['ExpireTime'] = request.expire_time
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.uuids):
            query['Uuids'] = request.uuids
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateCustomBlockRecord',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CreateCustomBlockRecordResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_custom_block_record_with_options_async(
        self,
        request: sas_20181203_models.CreateCustomBlockRecordRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CreateCustomBlockRecordResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.block_ip):
            query['BlockIp'] = request.block_ip
        if not UtilClient.is_unset(request.bound):
            query['Bound'] = request.bound
        if not UtilClient.is_unset(request.expire_time):
            query['ExpireTime'] = request.expire_time
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.uuids):
            query['Uuids'] = request.uuids
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateCustomBlockRecord',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CreateCustomBlockRecordResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_custom_block_record(
        self,
        request: sas_20181203_models.CreateCustomBlockRecordRequest,
    ) -> sas_20181203_models.CreateCustomBlockRecordResponse:
        runtime = util_models.RuntimeOptions()
        return self.create_custom_block_record_with_options(request, runtime)

    async def create_custom_block_record_async(
        self,
        request: sas_20181203_models.CreateCustomBlockRecordRequest,
    ) -> sas_20181203_models.CreateCustomBlockRecordResponse:
        runtime = util_models.RuntimeOptions()
        return await self.create_custom_block_record_with_options_async(request, runtime)

    def create_cycle_task_with_options(
        self,
        request: sas_20181203_models.CreateCycleTaskRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CreateCycleTaskResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.enable):
            query['Enable'] = request.enable
        if not UtilClient.is_unset(request.first_date_str):
            query['FirstDateStr'] = request.first_date_str
        if not UtilClient.is_unset(request.interval_period):
            query['IntervalPeriod'] = request.interval_period
        if not UtilClient.is_unset(request.param):
            query['Param'] = request.param
        if not UtilClient.is_unset(request.period_unit):
            query['PeriodUnit'] = request.period_unit
        if not UtilClient.is_unset(request.source):
            query['Source'] = request.source
        if not UtilClient.is_unset(request.target_end_time):
            query['TargetEndTime'] = request.target_end_time
        if not UtilClient.is_unset(request.target_start_time):
            query['TargetStartTime'] = request.target_start_time
        if not UtilClient.is_unset(request.task_name):
            query['TaskName'] = request.task_name
        if not UtilClient.is_unset(request.task_type):
            query['TaskType'] = request.task_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateCycleTask',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CreateCycleTaskResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_cycle_task_with_options_async(
        self,
        request: sas_20181203_models.CreateCycleTaskRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CreateCycleTaskResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.enable):
            query['Enable'] = request.enable
        if not UtilClient.is_unset(request.first_date_str):
            query['FirstDateStr'] = request.first_date_str
        if not UtilClient.is_unset(request.interval_period):
            query['IntervalPeriod'] = request.interval_period
        if not UtilClient.is_unset(request.param):
            query['Param'] = request.param
        if not UtilClient.is_unset(request.period_unit):
            query['PeriodUnit'] = request.period_unit
        if not UtilClient.is_unset(request.source):
            query['Source'] = request.source
        if not UtilClient.is_unset(request.target_end_time):
            query['TargetEndTime'] = request.target_end_time
        if not UtilClient.is_unset(request.target_start_time):
            query['TargetStartTime'] = request.target_start_time
        if not UtilClient.is_unset(request.task_name):
            query['TaskName'] = request.task_name
        if not UtilClient.is_unset(request.task_type):
            query['TaskType'] = request.task_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateCycleTask',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CreateCycleTaskResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_cycle_task(
        self,
        request: sas_20181203_models.CreateCycleTaskRequest,
    ) -> sas_20181203_models.CreateCycleTaskResponse:
        runtime = util_models.RuntimeOptions()
        return self.create_cycle_task_with_options(request, runtime)

    async def create_cycle_task_async(
        self,
        request: sas_20181203_models.CreateCycleTaskRequest,
    ) -> sas_20181203_models.CreateCycleTaskResponse:
        runtime = util_models.RuntimeOptions()
        return await self.create_cycle_task_with_options_async(request, runtime)

    def create_file_detect_with_options(
        self,
        request: sas_20181203_models.CreateFileDetectRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CreateFileDetectResponse:
        """
        You can call this operation to push a file to the cloud for detection. Before you call this operation, make sure that the file is uploaded. You can call the CreateFileDetectUploadUrl operation to upload the file.
        The HashKey parameter is included in all API operations that are related to the file detection feature. The parameter specifies the unique identifier of a file. Only MD5 hash values are supported. Before you call this operation, calculate the MD5 hash value of the file.
        
        @param request: CreateFileDetectRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateFileDetectResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.hash_key):
            query['HashKey'] = request.hash_key
        if not UtilClient.is_unset(request.oss_key):
            query['OssKey'] = request.oss_key
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateFileDetect',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CreateFileDetectResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_file_detect_with_options_async(
        self,
        request: sas_20181203_models.CreateFileDetectRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CreateFileDetectResponse:
        """
        You can call this operation to push a file to the cloud for detection. Before you call this operation, make sure that the file is uploaded. You can call the CreateFileDetectUploadUrl operation to upload the file.
        The HashKey parameter is included in all API operations that are related to the file detection feature. The parameter specifies the unique identifier of a file. Only MD5 hash values are supported. Before you call this operation, calculate the MD5 hash value of the file.
        
        @param request: CreateFileDetectRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateFileDetectResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.hash_key):
            query['HashKey'] = request.hash_key
        if not UtilClient.is_unset(request.oss_key):
            query['OssKey'] = request.oss_key
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateFileDetect',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CreateFileDetectResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_file_detect(
        self,
        request: sas_20181203_models.CreateFileDetectRequest,
    ) -> sas_20181203_models.CreateFileDetectResponse:
        """
        You can call this operation to push a file to the cloud for detection. Before you call this operation, make sure that the file is uploaded. You can call the CreateFileDetectUploadUrl operation to upload the file.
        The HashKey parameter is included in all API operations that are related to the file detection feature. The parameter specifies the unique identifier of a file. Only MD5 hash values are supported. Before you call this operation, calculate the MD5 hash value of the file.
        
        @param request: CreateFileDetectRequest
        @return: CreateFileDetectResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_file_detect_with_options(request, runtime)

    async def create_file_detect_async(
        self,
        request: sas_20181203_models.CreateFileDetectRequest,
    ) -> sas_20181203_models.CreateFileDetectResponse:
        """
        You can call this operation to push a file to the cloud for detection. Before you call this operation, make sure that the file is uploaded. You can call the CreateFileDetectUploadUrl operation to upload the file.
        The HashKey parameter is included in all API operations that are related to the file detection feature. The parameter specifies the unique identifier of a file. Only MD5 hash values are supported. Before you call this operation, calculate the MD5 hash value of the file.
        
        @param request: CreateFileDetectRequest
        @return: CreateFileDetectResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_file_detect_with_options_async(request, runtime)

    def create_file_detect_upload_url_with_options(
        self,
        request: sas_20181203_models.CreateFileDetectUploadUrlRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CreateFileDetectUploadUrlResponse:
        """
        You can call the this operation to query the parameters that are required to upload a file for detection. If the value of the response parameter FileExist is true, the file that you want to upload for detection already exists in the cloud. In this case, you can directly push the file for detection. If the value of the response parameter FileExist is false, you must use the form upload method to upload the file to the specified Object Storage Service (OSS) bucket based on the response parameters of this operation.
        The form upload method is provided by OSS. For more information, see [Form upload](https://www.alibabacloud.com/help/en/object-storage-service/latest/upload-objects-form-upload).
        The HashKey parameter is included in all API operations that are related to the file detection feature. The parameter specifies the unique identifier of a file. Only MD5 hash values are supported. Before you call this operation, calculate the MD5 hash value of the file.
        
        @param request: CreateFileDetectUploadUrlRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateFileDetectUploadUrlResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.hash_key_context_list):
            query['HashKeyContextList'] = request.hash_key_context_list
        if not UtilClient.is_unset(request.hash_key_list):
            query['HashKeyList'] = request.hash_key_list
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateFileDetectUploadUrl',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CreateFileDetectUploadUrlResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_file_detect_upload_url_with_options_async(
        self,
        request: sas_20181203_models.CreateFileDetectUploadUrlRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CreateFileDetectUploadUrlResponse:
        """
        You can call the this operation to query the parameters that are required to upload a file for detection. If the value of the response parameter FileExist is true, the file that you want to upload for detection already exists in the cloud. In this case, you can directly push the file for detection. If the value of the response parameter FileExist is false, you must use the form upload method to upload the file to the specified Object Storage Service (OSS) bucket based on the response parameters of this operation.
        The form upload method is provided by OSS. For more information, see [Form upload](https://www.alibabacloud.com/help/en/object-storage-service/latest/upload-objects-form-upload).
        The HashKey parameter is included in all API operations that are related to the file detection feature. The parameter specifies the unique identifier of a file. Only MD5 hash values are supported. Before you call this operation, calculate the MD5 hash value of the file.
        
        @param request: CreateFileDetectUploadUrlRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateFileDetectUploadUrlResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.hash_key_context_list):
            query['HashKeyContextList'] = request.hash_key_context_list
        if not UtilClient.is_unset(request.hash_key_list):
            query['HashKeyList'] = request.hash_key_list
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateFileDetectUploadUrl',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CreateFileDetectUploadUrlResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_file_detect_upload_url(
        self,
        request: sas_20181203_models.CreateFileDetectUploadUrlRequest,
    ) -> sas_20181203_models.CreateFileDetectUploadUrlResponse:
        """
        You can call the this operation to query the parameters that are required to upload a file for detection. If the value of the response parameter FileExist is true, the file that you want to upload for detection already exists in the cloud. In this case, you can directly push the file for detection. If the value of the response parameter FileExist is false, you must use the form upload method to upload the file to the specified Object Storage Service (OSS) bucket based on the response parameters of this operation.
        The form upload method is provided by OSS. For more information, see [Form upload](https://www.alibabacloud.com/help/en/object-storage-service/latest/upload-objects-form-upload).
        The HashKey parameter is included in all API operations that are related to the file detection feature. The parameter specifies the unique identifier of a file. Only MD5 hash values are supported. Before you call this operation, calculate the MD5 hash value of the file.
        
        @param request: CreateFileDetectUploadUrlRequest
        @return: CreateFileDetectUploadUrlResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_file_detect_upload_url_with_options(request, runtime)

    async def create_file_detect_upload_url_async(
        self,
        request: sas_20181203_models.CreateFileDetectUploadUrlRequest,
    ) -> sas_20181203_models.CreateFileDetectUploadUrlResponse:
        """
        You can call the this operation to query the parameters that are required to upload a file for detection. If the value of the response parameter FileExist is true, the file that you want to upload for detection already exists in the cloud. In this case, you can directly push the file for detection. If the value of the response parameter FileExist is false, you must use the form upload method to upload the file to the specified Object Storage Service (OSS) bucket based on the response parameters of this operation.
        The form upload method is provided by OSS. For more information, see [Form upload](https://www.alibabacloud.com/help/en/object-storage-service/latest/upload-objects-form-upload).
        The HashKey parameter is included in all API operations that are related to the file detection feature. The parameter specifies the unique identifier of a file. Only MD5 hash values are supported. Before you call this operation, calculate the MD5 hash value of the file.
        
        @param request: CreateFileDetectUploadUrlRequest
        @return: CreateFileDetectUploadUrlResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_file_detect_upload_url_with_options_async(request, runtime)

    def create_honeypot_with_options(
        self,
        request: sas_20181203_models.CreateHoneypotRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CreateHoneypotResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.honeypot_image_id):
            query['HoneypotImageId'] = request.honeypot_image_id
        if not UtilClient.is_unset(request.honeypot_image_name):
            query['HoneypotImageName'] = request.honeypot_image_name
        if not UtilClient.is_unset(request.honeypot_name):
            query['HoneypotName'] = request.honeypot_name
        if not UtilClient.is_unset(request.meta):
            query['Meta'] = request.meta
        if not UtilClient.is_unset(request.node_id):
            query['NodeId'] = request.node_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateHoneypot',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CreateHoneypotResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_honeypot_with_options_async(
        self,
        request: sas_20181203_models.CreateHoneypotRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CreateHoneypotResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.honeypot_image_id):
            query['HoneypotImageId'] = request.honeypot_image_id
        if not UtilClient.is_unset(request.honeypot_image_name):
            query['HoneypotImageName'] = request.honeypot_image_name
        if not UtilClient.is_unset(request.honeypot_name):
            query['HoneypotName'] = request.honeypot_name
        if not UtilClient.is_unset(request.meta):
            query['Meta'] = request.meta
        if not UtilClient.is_unset(request.node_id):
            query['NodeId'] = request.node_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateHoneypot',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CreateHoneypotResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_honeypot(
        self,
        request: sas_20181203_models.CreateHoneypotRequest,
    ) -> sas_20181203_models.CreateHoneypotResponse:
        runtime = util_models.RuntimeOptions()
        return self.create_honeypot_with_options(request, runtime)

    async def create_honeypot_async(
        self,
        request: sas_20181203_models.CreateHoneypotRequest,
    ) -> sas_20181203_models.CreateHoneypotResponse:
        runtime = util_models.RuntimeOptions()
        return await self.create_honeypot_with_options_async(request, runtime)

    def create_honeypot_node_with_options(
        self,
        request: sas_20181203_models.CreateHoneypotNodeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CreateHoneypotNodeResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.allow_honeypot_access_internet):
            query['AllowHoneypotAccessInternet'] = request.allow_honeypot_access_internet
        if not UtilClient.is_unset(request.available_probe_num):
            query['AvailableProbeNum'] = request.available_probe_num
        if not UtilClient.is_unset(request.node_name):
            query['NodeName'] = request.node_name
        if not UtilClient.is_unset(request.security_group_probe_ip_list):
            query['SecurityGroupProbeIpList'] = request.security_group_probe_ip_list
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateHoneypotNode',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CreateHoneypotNodeResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_honeypot_node_with_options_async(
        self,
        request: sas_20181203_models.CreateHoneypotNodeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CreateHoneypotNodeResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.allow_honeypot_access_internet):
            query['AllowHoneypotAccessInternet'] = request.allow_honeypot_access_internet
        if not UtilClient.is_unset(request.available_probe_num):
            query['AvailableProbeNum'] = request.available_probe_num
        if not UtilClient.is_unset(request.node_name):
            query['NodeName'] = request.node_name
        if not UtilClient.is_unset(request.security_group_probe_ip_list):
            query['SecurityGroupProbeIpList'] = request.security_group_probe_ip_list
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateHoneypotNode',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CreateHoneypotNodeResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_honeypot_node(
        self,
        request: sas_20181203_models.CreateHoneypotNodeRequest,
    ) -> sas_20181203_models.CreateHoneypotNodeResponse:
        runtime = util_models.RuntimeOptions()
        return self.create_honeypot_node_with_options(request, runtime)

    async def create_honeypot_node_async(
        self,
        request: sas_20181203_models.CreateHoneypotNodeRequest,
    ) -> sas_20181203_models.CreateHoneypotNodeResponse:
        runtime = util_models.RuntimeOptions()
        return await self.create_honeypot_node_with_options_async(request, runtime)

    def create_honeypot_preset_with_options(
        self,
        request: sas_20181203_models.CreateHoneypotPresetRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CreateHoneypotPresetResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.honeypot_image_name):
            query['HoneypotImageName'] = request.honeypot_image_name
        if not UtilClient.is_unset(request.meta):
            query['Meta'] = request.meta
        if not UtilClient.is_unset(request.node_id):
            query['NodeId'] = request.node_id
        if not UtilClient.is_unset(request.preset_name):
            query['PresetName'] = request.preset_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateHoneypotPreset',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CreateHoneypotPresetResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_honeypot_preset_with_options_async(
        self,
        request: sas_20181203_models.CreateHoneypotPresetRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CreateHoneypotPresetResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.honeypot_image_name):
            query['HoneypotImageName'] = request.honeypot_image_name
        if not UtilClient.is_unset(request.meta):
            query['Meta'] = request.meta
        if not UtilClient.is_unset(request.node_id):
            query['NodeId'] = request.node_id
        if not UtilClient.is_unset(request.preset_name):
            query['PresetName'] = request.preset_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateHoneypotPreset',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CreateHoneypotPresetResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_honeypot_preset(
        self,
        request: sas_20181203_models.CreateHoneypotPresetRequest,
    ) -> sas_20181203_models.CreateHoneypotPresetResponse:
        runtime = util_models.RuntimeOptions()
        return self.create_honeypot_preset_with_options(request, runtime)

    async def create_honeypot_preset_async(
        self,
        request: sas_20181203_models.CreateHoneypotPresetRequest,
    ) -> sas_20181203_models.CreateHoneypotPresetResponse:
        runtime = util_models.RuntimeOptions()
        return await self.create_honeypot_preset_with_options_async(request, runtime)

    def create_honeypot_probe_with_options(
        self,
        request: sas_20181203_models.CreateHoneypotProbeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CreateHoneypotProbeResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.arp):
            query['Arp'] = request.arp
        if not UtilClient.is_unset(request.business_group_id):
            query['BusinessGroupId'] = request.business_group_id
        if not UtilClient.is_unset(request.control_node_id):
            query['ControlNodeId'] = request.control_node_id
        if not UtilClient.is_unset(request.display_name):
            query['DisplayName'] = request.display_name
        if not UtilClient.is_unset(request.honeypot_bind_list):
            query['HoneypotBindList'] = request.honeypot_bind_list
        if not UtilClient.is_unset(request.ping):
            query['Ping'] = request.ping
        if not UtilClient.is_unset(request.probe_type):
            query['ProbeType'] = request.probe_type
        if not UtilClient.is_unset(request.probe_version):
            query['ProbeVersion'] = request.probe_version
        if not UtilClient.is_unset(request.proxy_ip):
            query['ProxyIp'] = request.proxy_ip
        if not UtilClient.is_unset(request.uuid):
            query['Uuid'] = request.uuid
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateHoneypotProbe',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CreateHoneypotProbeResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_honeypot_probe_with_options_async(
        self,
        request: sas_20181203_models.CreateHoneypotProbeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CreateHoneypotProbeResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.arp):
            query['Arp'] = request.arp
        if not UtilClient.is_unset(request.business_group_id):
            query['BusinessGroupId'] = request.business_group_id
        if not UtilClient.is_unset(request.control_node_id):
            query['ControlNodeId'] = request.control_node_id
        if not UtilClient.is_unset(request.display_name):
            query['DisplayName'] = request.display_name
        if not UtilClient.is_unset(request.honeypot_bind_list):
            query['HoneypotBindList'] = request.honeypot_bind_list
        if not UtilClient.is_unset(request.ping):
            query['Ping'] = request.ping
        if not UtilClient.is_unset(request.probe_type):
            query['ProbeType'] = request.probe_type
        if not UtilClient.is_unset(request.probe_version):
            query['ProbeVersion'] = request.probe_version
        if not UtilClient.is_unset(request.proxy_ip):
            query['ProxyIp'] = request.proxy_ip
        if not UtilClient.is_unset(request.uuid):
            query['Uuid'] = request.uuid
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateHoneypotProbe',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CreateHoneypotProbeResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_honeypot_probe(
        self,
        request: sas_20181203_models.CreateHoneypotProbeRequest,
    ) -> sas_20181203_models.CreateHoneypotProbeResponse:
        runtime = util_models.RuntimeOptions()
        return self.create_honeypot_probe_with_options(request, runtime)

    async def create_honeypot_probe_async(
        self,
        request: sas_20181203_models.CreateHoneypotProbeRequest,
    ) -> sas_20181203_models.CreateHoneypotProbeResponse:
        runtime = util_models.RuntimeOptions()
        return await self.create_honeypot_probe_with_options_async(request, runtime)

    def create_jenkins_image_registry_with_options(
        self,
        request: sas_20181203_models.CreateJenkinsImageRegistryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CreateJenkinsImageRegistryResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        body = {}
        if not UtilClient.is_unset(request.domain_name):
            body['DomainName'] = request.domain_name
        if not UtilClient.is_unset(request.extra_param):
            body['ExtraParam'] = request.extra_param
        if not UtilClient.is_unset(request.net_type):
            body['NetType'] = request.net_type
        if not UtilClient.is_unset(request.password):
            body['Password'] = request.password
        if not UtilClient.is_unset(request.persistence_day):
            body['PersistenceDay'] = request.persistence_day
        if not UtilClient.is_unset(request.protocol_type):
            body['ProtocolType'] = request.protocol_type
        if not UtilClient.is_unset(request.region_id):
            body['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.registry_host_ip):
            body['RegistryHostIp'] = request.registry_host_ip
        if not UtilClient.is_unset(request.registry_name):
            body['RegistryName'] = request.registry_name
        if not UtilClient.is_unset(request.registry_type):
            body['RegistryType'] = request.registry_type
        if not UtilClient.is_unset(request.registry_version):
            body['RegistryVersion'] = request.registry_version
        if not UtilClient.is_unset(request.trans_per_hour):
            body['TransPerHour'] = request.trans_per_hour
        if not UtilClient.is_unset(request.user_name):
            body['UserName'] = request.user_name
        if not UtilClient.is_unset(request.vpc_id):
            body['VpcId'] = request.vpc_id
        if not UtilClient.is_unset(request.white_list):
            body['WhiteList'] = request.white_list
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='CreateJenkinsImageRegistry',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CreateJenkinsImageRegistryResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_jenkins_image_registry_with_options_async(
        self,
        request: sas_20181203_models.CreateJenkinsImageRegistryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CreateJenkinsImageRegistryResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        body = {}
        if not UtilClient.is_unset(request.domain_name):
            body['DomainName'] = request.domain_name
        if not UtilClient.is_unset(request.extra_param):
            body['ExtraParam'] = request.extra_param
        if not UtilClient.is_unset(request.net_type):
            body['NetType'] = request.net_type
        if not UtilClient.is_unset(request.password):
            body['Password'] = request.password
        if not UtilClient.is_unset(request.persistence_day):
            body['PersistenceDay'] = request.persistence_day
        if not UtilClient.is_unset(request.protocol_type):
            body['ProtocolType'] = request.protocol_type
        if not UtilClient.is_unset(request.region_id):
            body['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.registry_host_ip):
            body['RegistryHostIp'] = request.registry_host_ip
        if not UtilClient.is_unset(request.registry_name):
            body['RegistryName'] = request.registry_name
        if not UtilClient.is_unset(request.registry_type):
            body['RegistryType'] = request.registry_type
        if not UtilClient.is_unset(request.registry_version):
            body['RegistryVersion'] = request.registry_version
        if not UtilClient.is_unset(request.trans_per_hour):
            body['TransPerHour'] = request.trans_per_hour
        if not UtilClient.is_unset(request.user_name):
            body['UserName'] = request.user_name
        if not UtilClient.is_unset(request.vpc_id):
            body['VpcId'] = request.vpc_id
        if not UtilClient.is_unset(request.white_list):
            body['WhiteList'] = request.white_list
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='CreateJenkinsImageRegistry',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CreateJenkinsImageRegistryResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_jenkins_image_registry(
        self,
        request: sas_20181203_models.CreateJenkinsImageRegistryRequest,
    ) -> sas_20181203_models.CreateJenkinsImageRegistryResponse:
        runtime = util_models.RuntimeOptions()
        return self.create_jenkins_image_registry_with_options(request, runtime)

    async def create_jenkins_image_registry_async(
        self,
        request: sas_20181203_models.CreateJenkinsImageRegistryRequest,
    ) -> sas_20181203_models.CreateJenkinsImageRegistryResponse:
        runtime = util_models.RuntimeOptions()
        return await self.create_jenkins_image_registry_with_options_async(request, runtime)

    def create_or_update_asset_group_with_options(
        self,
        request: sas_20181203_models.CreateOrUpdateAssetGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CreateOrUpdateAssetGroupResponse:
        """
        A server can belong only to one server group. If you call the CreateOrUpdateAssetGroup operation and the server specified in request parameters belongs to Server Group A, the server is removed from Server Group A and then added to the newly created or specified server group after the call is complete.
        
        @param request: CreateOrUpdateAssetGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateOrUpdateAssetGroupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.group_id):
            query['GroupId'] = request.group_id
        if not UtilClient.is_unset(request.group_name):
            query['GroupName'] = request.group_name
        if not UtilClient.is_unset(request.uuids):
            query['Uuids'] = request.uuids
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateOrUpdateAssetGroup',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CreateOrUpdateAssetGroupResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_or_update_asset_group_with_options_async(
        self,
        request: sas_20181203_models.CreateOrUpdateAssetGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CreateOrUpdateAssetGroupResponse:
        """
        A server can belong only to one server group. If you call the CreateOrUpdateAssetGroup operation and the server specified in request parameters belongs to Server Group A, the server is removed from Server Group A and then added to the newly created or specified server group after the call is complete.
        
        @param request: CreateOrUpdateAssetGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateOrUpdateAssetGroupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.group_id):
            query['GroupId'] = request.group_id
        if not UtilClient.is_unset(request.group_name):
            query['GroupName'] = request.group_name
        if not UtilClient.is_unset(request.uuids):
            query['Uuids'] = request.uuids
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateOrUpdateAssetGroup',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CreateOrUpdateAssetGroupResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_or_update_asset_group(
        self,
        request: sas_20181203_models.CreateOrUpdateAssetGroupRequest,
    ) -> sas_20181203_models.CreateOrUpdateAssetGroupResponse:
        """
        A server can belong only to one server group. If you call the CreateOrUpdateAssetGroup operation and the server specified in request parameters belongs to Server Group A, the server is removed from Server Group A and then added to the newly created or specified server group after the call is complete.
        
        @param request: CreateOrUpdateAssetGroupRequest
        @return: CreateOrUpdateAssetGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_or_update_asset_group_with_options(request, runtime)

    async def create_or_update_asset_group_async(
        self,
        request: sas_20181203_models.CreateOrUpdateAssetGroupRequest,
    ) -> sas_20181203_models.CreateOrUpdateAssetGroupResponse:
        """
        A server can belong only to one server group. If you call the CreateOrUpdateAssetGroup operation and the server specified in request parameters belongs to Server Group A, the server is removed from Server Group A and then added to the newly created or specified server group after the call is complete.
        
        @param request: CreateOrUpdateAssetGroupRequest
        @return: CreateOrUpdateAssetGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_or_update_asset_group_with_options_async(request, runtime)

    def create_restore_job_with_options(
        self,
        request: sas_20181203_models.CreateRestoreJobRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CreateRestoreJobResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.includes):
            query['Includes'] = request.includes
        if not UtilClient.is_unset(request.snapshot_hash):
            query['SnapshotHash'] = request.snapshot_hash
        if not UtilClient.is_unset(request.snapshot_id):
            query['SnapshotId'] = request.snapshot_id
        if not UtilClient.is_unset(request.snapshot_version):
            query['SnapshotVersion'] = request.snapshot_version
        if not UtilClient.is_unset(request.source_type):
            query['SourceType'] = request.source_type
        if not UtilClient.is_unset(request.target):
            query['Target'] = request.target
        if not UtilClient.is_unset(request.uuid):
            query['Uuid'] = request.uuid
        if not UtilClient.is_unset(request.vault_id):
            query['VaultId'] = request.vault_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateRestoreJob',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CreateRestoreJobResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_restore_job_with_options_async(
        self,
        request: sas_20181203_models.CreateRestoreJobRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CreateRestoreJobResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.includes):
            query['Includes'] = request.includes
        if not UtilClient.is_unset(request.snapshot_hash):
            query['SnapshotHash'] = request.snapshot_hash
        if not UtilClient.is_unset(request.snapshot_id):
            query['SnapshotId'] = request.snapshot_id
        if not UtilClient.is_unset(request.snapshot_version):
            query['SnapshotVersion'] = request.snapshot_version
        if not UtilClient.is_unset(request.source_type):
            query['SourceType'] = request.source_type
        if not UtilClient.is_unset(request.target):
            query['Target'] = request.target
        if not UtilClient.is_unset(request.uuid):
            query['Uuid'] = request.uuid
        if not UtilClient.is_unset(request.vault_id):
            query['VaultId'] = request.vault_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateRestoreJob',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CreateRestoreJobResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_restore_job(
        self,
        request: sas_20181203_models.CreateRestoreJobRequest,
    ) -> sas_20181203_models.CreateRestoreJobResponse:
        runtime = util_models.RuntimeOptions()
        return self.create_restore_job_with_options(request, runtime)

    async def create_restore_job_async(
        self,
        request: sas_20181203_models.CreateRestoreJobRequest,
    ) -> sas_20181203_models.CreateRestoreJobResponse:
        runtime = util_models.RuntimeOptions()
        return await self.create_restore_job_with_options_async(request, runtime)

    def create_service_linked_role_with_options(
        self,
        request: sas_20181203_models.CreateServiceLinkedRoleRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CreateServiceLinkedRoleResponse:
        """
        For more information about service-linked roles, see [Service-linked roles](~~160674~~).
        
        @param request: CreateServiceLinkedRoleRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateServiceLinkedRoleResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.service_linked_role):
            query['ServiceLinkedRole'] = request.service_linked_role
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateServiceLinkedRole',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CreateServiceLinkedRoleResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_service_linked_role_with_options_async(
        self,
        request: sas_20181203_models.CreateServiceLinkedRoleRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CreateServiceLinkedRoleResponse:
        """
        For more information about service-linked roles, see [Service-linked roles](~~160674~~).
        
        @param request: CreateServiceLinkedRoleRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateServiceLinkedRoleResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.service_linked_role):
            query['ServiceLinkedRole'] = request.service_linked_role
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateServiceLinkedRole',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CreateServiceLinkedRoleResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_service_linked_role(
        self,
        request: sas_20181203_models.CreateServiceLinkedRoleRequest,
    ) -> sas_20181203_models.CreateServiceLinkedRoleResponse:
        """
        For more information about service-linked roles, see [Service-linked roles](~~160674~~).
        
        @param request: CreateServiceLinkedRoleRequest
        @return: CreateServiceLinkedRoleResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_service_linked_role_with_options(request, runtime)

    async def create_service_linked_role_async(
        self,
        request: sas_20181203_models.CreateServiceLinkedRoleRequest,
    ) -> sas_20181203_models.CreateServiceLinkedRoleResponse:
        """
        For more information about service-linked roles, see [Service-linked roles](~~160674~~).
        
        @param request: CreateServiceLinkedRoleRequest
        @return: CreateServiceLinkedRoleResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_service_linked_role_with_options_async(request, runtime)

    def create_similar_security_events_query_task_with_options(
        self,
        request: sas_20181203_models.CreateSimilarSecurityEventsQueryTaskRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CreateSimilarSecurityEventsQueryTaskResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.security_event_id):
            query['SecurityEventId'] = request.security_event_id
        if not UtilClient.is_unset(request.similar_event_scenario_code):
            query['SimilarEventScenarioCode'] = request.similar_event_scenario_code
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateSimilarSecurityEventsQueryTask',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CreateSimilarSecurityEventsQueryTaskResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_similar_security_events_query_task_with_options_async(
        self,
        request: sas_20181203_models.CreateSimilarSecurityEventsQueryTaskRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CreateSimilarSecurityEventsQueryTaskResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.security_event_id):
            query['SecurityEventId'] = request.security_event_id
        if not UtilClient.is_unset(request.similar_event_scenario_code):
            query['SimilarEventScenarioCode'] = request.similar_event_scenario_code
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateSimilarSecurityEventsQueryTask',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CreateSimilarSecurityEventsQueryTaskResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_similar_security_events_query_task(
        self,
        request: sas_20181203_models.CreateSimilarSecurityEventsQueryTaskRequest,
    ) -> sas_20181203_models.CreateSimilarSecurityEventsQueryTaskResponse:
        runtime = util_models.RuntimeOptions()
        return self.create_similar_security_events_query_task_with_options(request, runtime)

    async def create_similar_security_events_query_task_async(
        self,
        request: sas_20181203_models.CreateSimilarSecurityEventsQueryTaskRequest,
    ) -> sas_20181203_models.CreateSimilarSecurityEventsQueryTaskResponse:
        runtime = util_models.RuntimeOptions()
        return await self.create_similar_security_events_query_task_with_options_async(request, runtime)

    def create_susp_event_note_with_options(
        self,
        request: sas_20181203_models.CreateSuspEventNoteRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CreateSuspEventNoteResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.event_id):
            query['EventId'] = request.event_id
        if not UtilClient.is_unset(request.note):
            query['Note'] = request.note
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateSuspEventNote',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CreateSuspEventNoteResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_susp_event_note_with_options_async(
        self,
        request: sas_20181203_models.CreateSuspEventNoteRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CreateSuspEventNoteResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.event_id):
            query['EventId'] = request.event_id
        if not UtilClient.is_unset(request.note):
            query['Note'] = request.note
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateSuspEventNote',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CreateSuspEventNoteResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_susp_event_note(
        self,
        request: sas_20181203_models.CreateSuspEventNoteRequest,
    ) -> sas_20181203_models.CreateSuspEventNoteResponse:
        runtime = util_models.RuntimeOptions()
        return self.create_susp_event_note_with_options(request, runtime)

    async def create_susp_event_note_async(
        self,
        request: sas_20181203_models.CreateSuspEventNoteRequest,
    ) -> sas_20181203_models.CreateSuspEventNoteResponse:
        runtime = util_models.RuntimeOptions()
        return await self.create_susp_event_note_with_options_async(request, runtime)

    def create_uni_backup_policy_with_options(
        self,
        tmp_req: sas_20181203_models.CreateUniBackupPolicyRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CreateUniBackupPolicyResponse:
        UtilClient.validate_model(tmp_req)
        request = sas_20181203_models.CreateUniBackupPolicyShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.full_plan):
            request.full_plan_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.full_plan, 'FullPlan', 'json')
        if not UtilClient.is_unset(tmp_req.inc_plan):
            request.inc_plan_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.inc_plan, 'IncPlan', 'json')
        query = {}
        if not UtilClient.is_unset(request.account_name):
            query['AccountName'] = request.account_name
        if not UtilClient.is_unset(request.account_password):
            query['AccountPassword'] = request.account_password
        if not UtilClient.is_unset(request.database_add_by_user):
            query['DatabaseAddByUser'] = request.database_add_by_user
        if not UtilClient.is_unset(request.database_type):
            query['DatabaseType'] = request.database_type
        if not UtilClient.is_unset(request.full_plan_shrink):
            query['FullPlan'] = request.full_plan_shrink
        if not UtilClient.is_unset(request.inc_plan_shrink):
            query['IncPlan'] = request.inc_plan_shrink
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.policy_name):
            query['PolicyName'] = request.policy_name
        if not UtilClient.is_unset(request.retention):
            query['Retention'] = request.retention
        if not UtilClient.is_unset(request.speed_limiter):
            query['SpeedLimiter'] = request.speed_limiter
        if not UtilClient.is_unset(request.uni_region_id):
            query['UniRegionId'] = request.uni_region_id
        if not UtilClient.is_unset(request.uuid):
            query['Uuid'] = request.uuid
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateUniBackupPolicy',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CreateUniBackupPolicyResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_uni_backup_policy_with_options_async(
        self,
        tmp_req: sas_20181203_models.CreateUniBackupPolicyRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CreateUniBackupPolicyResponse:
        UtilClient.validate_model(tmp_req)
        request = sas_20181203_models.CreateUniBackupPolicyShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.full_plan):
            request.full_plan_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.full_plan, 'FullPlan', 'json')
        if not UtilClient.is_unset(tmp_req.inc_plan):
            request.inc_plan_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.inc_plan, 'IncPlan', 'json')
        query = {}
        if not UtilClient.is_unset(request.account_name):
            query['AccountName'] = request.account_name
        if not UtilClient.is_unset(request.account_password):
            query['AccountPassword'] = request.account_password
        if not UtilClient.is_unset(request.database_add_by_user):
            query['DatabaseAddByUser'] = request.database_add_by_user
        if not UtilClient.is_unset(request.database_type):
            query['DatabaseType'] = request.database_type
        if not UtilClient.is_unset(request.full_plan_shrink):
            query['FullPlan'] = request.full_plan_shrink
        if not UtilClient.is_unset(request.inc_plan_shrink):
            query['IncPlan'] = request.inc_plan_shrink
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.policy_name):
            query['PolicyName'] = request.policy_name
        if not UtilClient.is_unset(request.retention):
            query['Retention'] = request.retention
        if not UtilClient.is_unset(request.speed_limiter):
            query['SpeedLimiter'] = request.speed_limiter
        if not UtilClient.is_unset(request.uni_region_id):
            query['UniRegionId'] = request.uni_region_id
        if not UtilClient.is_unset(request.uuid):
            query['Uuid'] = request.uuid
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateUniBackupPolicy',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CreateUniBackupPolicyResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_uni_backup_policy(
        self,
        request: sas_20181203_models.CreateUniBackupPolicyRequest,
    ) -> sas_20181203_models.CreateUniBackupPolicyResponse:
        runtime = util_models.RuntimeOptions()
        return self.create_uni_backup_policy_with_options(request, runtime)

    async def create_uni_backup_policy_async(
        self,
        request: sas_20181203_models.CreateUniBackupPolicyRequest,
    ) -> sas_20181203_models.CreateUniBackupPolicyResponse:
        runtime = util_models.RuntimeOptions()
        return await self.create_uni_backup_policy_with_options_async(request, runtime)

    def create_uni_restore_plan_with_options(
        self,
        request: sas_20181203_models.CreateUniRestorePlanRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CreateUniRestorePlanResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.database):
            query['Database'] = request.database
        if not UtilClient.is_unset(request.instance_uuid):
            query['InstanceUuid'] = request.instance_uuid
        if not UtilClient.is_unset(request.policy_id):
            query['PolicyId'] = request.policy_id
        if not UtilClient.is_unset(request.reset_scn):
            query['ResetScn'] = request.reset_scn
        if not UtilClient.is_unset(request.reset_time):
            query['ResetTime'] = request.reset_time
        if not UtilClient.is_unset(request.restore_info):
            query['RestoreInfo'] = request.restore_info
        if not UtilClient.is_unset(request.time_point):
            query['TimePoint'] = request.time_point
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateUniRestorePlan',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CreateUniRestorePlanResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_uni_restore_plan_with_options_async(
        self,
        request: sas_20181203_models.CreateUniRestorePlanRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CreateUniRestorePlanResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.database):
            query['Database'] = request.database
        if not UtilClient.is_unset(request.instance_uuid):
            query['InstanceUuid'] = request.instance_uuid
        if not UtilClient.is_unset(request.policy_id):
            query['PolicyId'] = request.policy_id
        if not UtilClient.is_unset(request.reset_scn):
            query['ResetScn'] = request.reset_scn
        if not UtilClient.is_unset(request.reset_time):
            query['ResetTime'] = request.reset_time
        if not UtilClient.is_unset(request.restore_info):
            query['RestoreInfo'] = request.restore_info
        if not UtilClient.is_unset(request.time_point):
            query['TimePoint'] = request.time_point
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateUniRestorePlan',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CreateUniRestorePlanResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_uni_restore_plan(
        self,
        request: sas_20181203_models.CreateUniRestorePlanRequest,
    ) -> sas_20181203_models.CreateUniRestorePlanResponse:
        runtime = util_models.RuntimeOptions()
        return self.create_uni_restore_plan_with_options(request, runtime)

    async def create_uni_restore_plan_async(
        self,
        request: sas_20181203_models.CreateUniRestorePlanRequest,
    ) -> sas_20181203_models.CreateUniRestorePlanResponse:
        runtime = util_models.RuntimeOptions()
        return await self.create_uni_restore_plan_with_options_async(request, runtime)

    def create_vul_auto_repair_config_with_options(
        self,
        request: sas_20181203_models.CreateVulAutoRepairConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CreateVulAutoRepairConfigResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.reason):
            query['Reason'] = request.reason
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        if not UtilClient.is_unset(request.vul_auto_repair_config_list):
            query['VulAutoRepairConfigList'] = request.vul_auto_repair_config_list
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateVulAutoRepairConfig',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CreateVulAutoRepairConfigResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_vul_auto_repair_config_with_options_async(
        self,
        request: sas_20181203_models.CreateVulAutoRepairConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.CreateVulAutoRepairConfigResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.reason):
            query['Reason'] = request.reason
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        if not UtilClient.is_unset(request.vul_auto_repair_config_list):
            query['VulAutoRepairConfigList'] = request.vul_auto_repair_config_list
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateVulAutoRepairConfig',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.CreateVulAutoRepairConfigResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_vul_auto_repair_config(
        self,
        request: sas_20181203_models.CreateVulAutoRepairConfigRequest,
    ) -> sas_20181203_models.CreateVulAutoRepairConfigResponse:
        runtime = util_models.RuntimeOptions()
        return self.create_vul_auto_repair_config_with_options(request, runtime)

    async def create_vul_auto_repair_config_async(
        self,
        request: sas_20181203_models.CreateVulAutoRepairConfigRequest,
    ) -> sas_20181203_models.CreateVulAutoRepairConfigResponse:
        runtime = util_models.RuntimeOptions()
        return await self.create_vul_auto_repair_config_with_options_async(request, runtime)

    def delete_anti_brute_force_rule_with_options(
        self,
        request: sas_20181203_models.DeleteAntiBruteForceRuleRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DeleteAntiBruteForceRuleResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.ids):
            query['Ids'] = request.ids
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteAntiBruteForceRule',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DeleteAntiBruteForceRuleResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_anti_brute_force_rule_with_options_async(
        self,
        request: sas_20181203_models.DeleteAntiBruteForceRuleRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DeleteAntiBruteForceRuleResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.ids):
            query['Ids'] = request.ids
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteAntiBruteForceRule',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DeleteAntiBruteForceRuleResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_anti_brute_force_rule(
        self,
        request: sas_20181203_models.DeleteAntiBruteForceRuleRequest,
    ) -> sas_20181203_models.DeleteAntiBruteForceRuleResponse:
        runtime = util_models.RuntimeOptions()
        return self.delete_anti_brute_force_rule_with_options(request, runtime)

    async def delete_anti_brute_force_rule_async(
        self,
        request: sas_20181203_models.DeleteAntiBruteForceRuleRequest,
    ) -> sas_20181203_models.DeleteAntiBruteForceRuleResponse:
        runtime = util_models.RuntimeOptions()
        return await self.delete_anti_brute_force_rule_with_options_async(request, runtime)

    def delete_backup_policy_with_options(
        self,
        request: sas_20181203_models.DeleteBackupPolicyRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DeleteBackupPolicyResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.id):
            query['Id'] = request.id
        if not UtilClient.is_unset(request.policy_version):
            query['PolicyVersion'] = request.policy_version
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteBackupPolicy',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DeleteBackupPolicyResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_backup_policy_with_options_async(
        self,
        request: sas_20181203_models.DeleteBackupPolicyRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DeleteBackupPolicyResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.id):
            query['Id'] = request.id
        if not UtilClient.is_unset(request.policy_version):
            query['PolicyVersion'] = request.policy_version
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteBackupPolicy',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DeleteBackupPolicyResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_backup_policy(
        self,
        request: sas_20181203_models.DeleteBackupPolicyRequest,
    ) -> sas_20181203_models.DeleteBackupPolicyResponse:
        runtime = util_models.RuntimeOptions()
        return self.delete_backup_policy_with_options(request, runtime)

    async def delete_backup_policy_async(
        self,
        request: sas_20181203_models.DeleteBackupPolicyRequest,
    ) -> sas_20181203_models.DeleteBackupPolicyResponse:
        runtime = util_models.RuntimeOptions()
        return await self.delete_backup_policy_with_options_async(request, runtime)

    def delete_backup_policy_machine_with_options(
        self,
        request: sas_20181203_models.DeleteBackupPolicyMachineRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DeleteBackupPolicyMachineResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.policy_id):
            query['PolicyId'] = request.policy_id
        if not UtilClient.is_unset(request.policy_version):
            query['PolicyVersion'] = request.policy_version
        if not UtilClient.is_unset(request.uuid):
            query['Uuid'] = request.uuid
        if not UtilClient.is_unset(request.uuid_list):
            query['UuidList'] = request.uuid_list
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteBackupPolicyMachine',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DeleteBackupPolicyMachineResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_backup_policy_machine_with_options_async(
        self,
        request: sas_20181203_models.DeleteBackupPolicyMachineRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DeleteBackupPolicyMachineResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.policy_id):
            query['PolicyId'] = request.policy_id
        if not UtilClient.is_unset(request.policy_version):
            query['PolicyVersion'] = request.policy_version
        if not UtilClient.is_unset(request.uuid):
            query['Uuid'] = request.uuid
        if not UtilClient.is_unset(request.uuid_list):
            query['UuidList'] = request.uuid_list
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteBackupPolicyMachine',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DeleteBackupPolicyMachineResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_backup_policy_machine(
        self,
        request: sas_20181203_models.DeleteBackupPolicyMachineRequest,
    ) -> sas_20181203_models.DeleteBackupPolicyMachineResponse:
        runtime = util_models.RuntimeOptions()
        return self.delete_backup_policy_machine_with_options(request, runtime)

    async def delete_backup_policy_machine_async(
        self,
        request: sas_20181203_models.DeleteBackupPolicyMachineRequest,
    ) -> sas_20181203_models.DeleteBackupPolicyMachineResponse:
        runtime = util_models.RuntimeOptions()
        return await self.delete_backup_policy_machine_with_options_async(request, runtime)

    def delete_client_user_define_rule_with_options(
        self,
        request: sas_20181203_models.DeleteClientUserDefineRuleRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DeleteClientUserDefineRuleResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.id_list):
            query['IdList'] = request.id_list
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteClientUserDefineRule',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DeleteClientUserDefineRuleResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_client_user_define_rule_with_options_async(
        self,
        request: sas_20181203_models.DeleteClientUserDefineRuleRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DeleteClientUserDefineRuleResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.id_list):
            query['IdList'] = request.id_list
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteClientUserDefineRule',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DeleteClientUserDefineRuleResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_client_user_define_rule(
        self,
        request: sas_20181203_models.DeleteClientUserDefineRuleRequest,
    ) -> sas_20181203_models.DeleteClientUserDefineRuleResponse:
        runtime = util_models.RuntimeOptions()
        return self.delete_client_user_define_rule_with_options(request, runtime)

    async def delete_client_user_define_rule_async(
        self,
        request: sas_20181203_models.DeleteClientUserDefineRuleRequest,
    ) -> sas_20181203_models.DeleteClientUserDefineRuleResponse:
        runtime = util_models.RuntimeOptions()
        return await self.delete_client_user_define_rule_with_options_async(request, runtime)

    def delete_custom_block_record_with_options(
        self,
        request: sas_20181203_models.DeleteCustomBlockRecordRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DeleteCustomBlockRecordResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.id):
            query['Id'] = request.id
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteCustomBlockRecord',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DeleteCustomBlockRecordResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_custom_block_record_with_options_async(
        self,
        request: sas_20181203_models.DeleteCustomBlockRecordRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DeleteCustomBlockRecordResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.id):
            query['Id'] = request.id
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteCustomBlockRecord',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DeleteCustomBlockRecordResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_custom_block_record(
        self,
        request: sas_20181203_models.DeleteCustomBlockRecordRequest,
    ) -> sas_20181203_models.DeleteCustomBlockRecordResponse:
        runtime = util_models.RuntimeOptions()
        return self.delete_custom_block_record_with_options(request, runtime)

    async def delete_custom_block_record_async(
        self,
        request: sas_20181203_models.DeleteCustomBlockRecordRequest,
    ) -> sas_20181203_models.DeleteCustomBlockRecordResponse:
        runtime = util_models.RuntimeOptions()
        return await self.delete_custom_block_record_with_options_async(request, runtime)

    def delete_cycle_task_with_options(
        self,
        request: sas_20181203_models.DeleteCycleTaskRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DeleteCycleTaskResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.config_id):
            query['ConfigId'] = request.config_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteCycleTask',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DeleteCycleTaskResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_cycle_task_with_options_async(
        self,
        request: sas_20181203_models.DeleteCycleTaskRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DeleteCycleTaskResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.config_id):
            query['ConfigId'] = request.config_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteCycleTask',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DeleteCycleTaskResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_cycle_task(
        self,
        request: sas_20181203_models.DeleteCycleTaskRequest,
    ) -> sas_20181203_models.DeleteCycleTaskResponse:
        runtime = util_models.RuntimeOptions()
        return self.delete_cycle_task_with_options(request, runtime)

    async def delete_cycle_task_async(
        self,
        request: sas_20181203_models.DeleteCycleTaskRequest,
    ) -> sas_20181203_models.DeleteCycleTaskResponse:
        runtime = util_models.RuntimeOptions()
        return await self.delete_cycle_task_with_options_async(request, runtime)

    def delete_group_with_options(
        self,
        request: sas_20181203_models.DeleteGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DeleteGroupResponse:
        """
        The *Default** server group that is provided by Security Center cannot be deleted. After you delete a group, the assets in this group are moved to the **Default** group.
        
        @param request: DeleteGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteGroupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.group_id):
            query['GroupId'] = request.group_id
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteGroup',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DeleteGroupResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_group_with_options_async(
        self,
        request: sas_20181203_models.DeleteGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DeleteGroupResponse:
        """
        The *Default** server group that is provided by Security Center cannot be deleted. After you delete a group, the assets in this group are moved to the **Default** group.
        
        @param request: DeleteGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteGroupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.group_id):
            query['GroupId'] = request.group_id
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteGroup',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DeleteGroupResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_group(
        self,
        request: sas_20181203_models.DeleteGroupRequest,
    ) -> sas_20181203_models.DeleteGroupResponse:
        """
        The *Default** server group that is provided by Security Center cannot be deleted. After you delete a group, the assets in this group are moved to the **Default** group.
        
        @param request: DeleteGroupRequest
        @return: DeleteGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_group_with_options(request, runtime)

    async def delete_group_async(
        self,
        request: sas_20181203_models.DeleteGroupRequest,
    ) -> sas_20181203_models.DeleteGroupResponse:
        """
        The *Default** server group that is provided by Security Center cannot be deleted. After you delete a group, the assets in this group are moved to the **Default** group.
        
        @param request: DeleteGroupRequest
        @return: DeleteGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_group_with_options_async(request, runtime)

    def delete_honeypot_with_options(
        self,
        request: sas_20181203_models.DeleteHoneypotRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DeleteHoneypotResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.honeypot_id):
            query['HoneypotId'] = request.honeypot_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteHoneypot',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DeleteHoneypotResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_honeypot_with_options_async(
        self,
        request: sas_20181203_models.DeleteHoneypotRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DeleteHoneypotResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.honeypot_id):
            query['HoneypotId'] = request.honeypot_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteHoneypot',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DeleteHoneypotResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_honeypot(
        self,
        request: sas_20181203_models.DeleteHoneypotRequest,
    ) -> sas_20181203_models.DeleteHoneypotResponse:
        runtime = util_models.RuntimeOptions()
        return self.delete_honeypot_with_options(request, runtime)

    async def delete_honeypot_async(
        self,
        request: sas_20181203_models.DeleteHoneypotRequest,
    ) -> sas_20181203_models.DeleteHoneypotResponse:
        runtime = util_models.RuntimeOptions()
        return await self.delete_honeypot_with_options_async(request, runtime)

    def delete_honeypot_node_with_options(
        self,
        request: sas_20181203_models.DeleteHoneypotNodeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DeleteHoneypotNodeResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.node_id):
            query['NodeId'] = request.node_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteHoneypotNode',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DeleteHoneypotNodeResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_honeypot_node_with_options_async(
        self,
        request: sas_20181203_models.DeleteHoneypotNodeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DeleteHoneypotNodeResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.node_id):
            query['NodeId'] = request.node_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteHoneypotNode',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DeleteHoneypotNodeResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_honeypot_node(
        self,
        request: sas_20181203_models.DeleteHoneypotNodeRequest,
    ) -> sas_20181203_models.DeleteHoneypotNodeResponse:
        runtime = util_models.RuntimeOptions()
        return self.delete_honeypot_node_with_options(request, runtime)

    async def delete_honeypot_node_async(
        self,
        request: sas_20181203_models.DeleteHoneypotNodeRequest,
    ) -> sas_20181203_models.DeleteHoneypotNodeResponse:
        runtime = util_models.RuntimeOptions()
        return await self.delete_honeypot_node_with_options_async(request, runtime)

    def delete_honeypot_preset_with_options(
        self,
        request: sas_20181203_models.DeleteHoneypotPresetRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DeleteHoneypotPresetResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.honeypot_preset_id):
            query['HoneypotPresetId'] = request.honeypot_preset_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteHoneypotPreset',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DeleteHoneypotPresetResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_honeypot_preset_with_options_async(
        self,
        request: sas_20181203_models.DeleteHoneypotPresetRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DeleteHoneypotPresetResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.honeypot_preset_id):
            query['HoneypotPresetId'] = request.honeypot_preset_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteHoneypotPreset',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DeleteHoneypotPresetResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_honeypot_preset(
        self,
        request: sas_20181203_models.DeleteHoneypotPresetRequest,
    ) -> sas_20181203_models.DeleteHoneypotPresetResponse:
        runtime = util_models.RuntimeOptions()
        return self.delete_honeypot_preset_with_options(request, runtime)

    async def delete_honeypot_preset_async(
        self,
        request: sas_20181203_models.DeleteHoneypotPresetRequest,
    ) -> sas_20181203_models.DeleteHoneypotPresetResponse:
        runtime = util_models.RuntimeOptions()
        return await self.delete_honeypot_preset_with_options_async(request, runtime)

    def delete_honeypot_probe_with_options(
        self,
        request: sas_20181203_models.DeleteHoneypotProbeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DeleteHoneypotProbeResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.probe_id):
            query['ProbeId'] = request.probe_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteHoneypotProbe',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DeleteHoneypotProbeResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_honeypot_probe_with_options_async(
        self,
        request: sas_20181203_models.DeleteHoneypotProbeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DeleteHoneypotProbeResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.probe_id):
            query['ProbeId'] = request.probe_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteHoneypotProbe',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DeleteHoneypotProbeResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_honeypot_probe(
        self,
        request: sas_20181203_models.DeleteHoneypotProbeRequest,
    ) -> sas_20181203_models.DeleteHoneypotProbeResponse:
        runtime = util_models.RuntimeOptions()
        return self.delete_honeypot_probe_with_options(request, runtime)

    async def delete_honeypot_probe_async(
        self,
        request: sas_20181203_models.DeleteHoneypotProbeRequest,
    ) -> sas_20181203_models.DeleteHoneypotProbeResponse:
        runtime = util_models.RuntimeOptions()
        return await self.delete_honeypot_probe_with_options_async(request, runtime)

    def delete_install_code_with_options(
        self,
        request: sas_20181203_models.DeleteInstallCodeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DeleteInstallCodeResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.captcha_code):
            query['CaptchaCode'] = request.captcha_code
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteInstallCode',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DeleteInstallCodeResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_install_code_with_options_async(
        self,
        request: sas_20181203_models.DeleteInstallCodeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DeleteInstallCodeResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.captcha_code):
            query['CaptchaCode'] = request.captcha_code
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteInstallCode',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DeleteInstallCodeResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_install_code(
        self,
        request: sas_20181203_models.DeleteInstallCodeRequest,
    ) -> sas_20181203_models.DeleteInstallCodeResponse:
        runtime = util_models.RuntimeOptions()
        return self.delete_install_code_with_options(request, runtime)

    async def delete_install_code_async(
        self,
        request: sas_20181203_models.DeleteInstallCodeRequest,
    ) -> sas_20181203_models.DeleteInstallCodeResponse:
        runtime = util_models.RuntimeOptions()
        return await self.delete_install_code_with_options_async(request, runtime)

    def delete_interception_rule_with_options(
        self,
        request: sas_20181203_models.DeleteInterceptionRuleRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DeleteInterceptionRuleResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cluster_id):
            query['ClusterId'] = request.cluster_id
        if not UtilClient.is_unset(request.rule_ids):
            query['RuleIds'] = request.rule_ids
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteInterceptionRule',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DeleteInterceptionRuleResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_interception_rule_with_options_async(
        self,
        request: sas_20181203_models.DeleteInterceptionRuleRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DeleteInterceptionRuleResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cluster_id):
            query['ClusterId'] = request.cluster_id
        if not UtilClient.is_unset(request.rule_ids):
            query['RuleIds'] = request.rule_ids
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteInterceptionRule',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DeleteInterceptionRuleResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_interception_rule(
        self,
        request: sas_20181203_models.DeleteInterceptionRuleRequest,
    ) -> sas_20181203_models.DeleteInterceptionRuleResponse:
        runtime = util_models.RuntimeOptions()
        return self.delete_interception_rule_with_options(request, runtime)

    async def delete_interception_rule_async(
        self,
        request: sas_20181203_models.DeleteInterceptionRuleRequest,
    ) -> sas_20181203_models.DeleteInterceptionRuleResponse:
        runtime = util_models.RuntimeOptions()
        return await self.delete_interception_rule_with_options_async(request, runtime)

    def delete_interception_target_with_options(
        self,
        request: sas_20181203_models.DeleteInterceptionTargetRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DeleteInterceptionTargetResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.target_ids):
            query['TargetIds'] = request.target_ids
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteInterceptionTarget',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DeleteInterceptionTargetResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_interception_target_with_options_async(
        self,
        request: sas_20181203_models.DeleteInterceptionTargetRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DeleteInterceptionTargetResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.target_ids):
            query['TargetIds'] = request.target_ids
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteInterceptionTarget',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DeleteInterceptionTargetResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_interception_target(
        self,
        request: sas_20181203_models.DeleteInterceptionTargetRequest,
    ) -> sas_20181203_models.DeleteInterceptionTargetResponse:
        runtime = util_models.RuntimeOptions()
        return self.delete_interception_target_with_options(request, runtime)

    async def delete_interception_target_async(
        self,
        request: sas_20181203_models.DeleteInterceptionTargetRequest,
    ) -> sas_20181203_models.DeleteInterceptionTargetResponse:
        runtime = util_models.RuntimeOptions()
        return await self.delete_interception_target_with_options_async(request, runtime)

    def delete_login_base_config_with_options(
        self,
        request: sas_20181203_models.DeleteLoginBaseConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DeleteLoginBaseConfigResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.config):
            query['Config'] = request.config
        if not UtilClient.is_unset(request.target):
            query['Target'] = request.target
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteLoginBaseConfig',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DeleteLoginBaseConfigResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_login_base_config_with_options_async(
        self,
        request: sas_20181203_models.DeleteLoginBaseConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DeleteLoginBaseConfigResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.config):
            query['Config'] = request.config
        if not UtilClient.is_unset(request.target):
            query['Target'] = request.target
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteLoginBaseConfig',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DeleteLoginBaseConfigResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_login_base_config(
        self,
        request: sas_20181203_models.DeleteLoginBaseConfigRequest,
    ) -> sas_20181203_models.DeleteLoginBaseConfigResponse:
        runtime = util_models.RuntimeOptions()
        return self.delete_login_base_config_with_options(request, runtime)

    async def delete_login_base_config_async(
        self,
        request: sas_20181203_models.DeleteLoginBaseConfigRequest,
    ) -> sas_20181203_models.DeleteLoginBaseConfigResponse:
        runtime = util_models.RuntimeOptions()
        return await self.delete_login_base_config_with_options_async(request, runtime)

    def delete_security_event_mark_miss_list_with_options(
        self,
        request: sas_20181203_models.DeleteSecurityEventMarkMissListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DeleteSecurityEventMarkMissListResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.ids):
            query['Ids'] = request.ids
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteSecurityEventMarkMissList',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DeleteSecurityEventMarkMissListResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_security_event_mark_miss_list_with_options_async(
        self,
        request: sas_20181203_models.DeleteSecurityEventMarkMissListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DeleteSecurityEventMarkMissListResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.ids):
            query['Ids'] = request.ids
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteSecurityEventMarkMissList',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DeleteSecurityEventMarkMissListResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_security_event_mark_miss_list(
        self,
        request: sas_20181203_models.DeleteSecurityEventMarkMissListRequest,
    ) -> sas_20181203_models.DeleteSecurityEventMarkMissListResponse:
        runtime = util_models.RuntimeOptions()
        return self.delete_security_event_mark_miss_list_with_options(request, runtime)

    async def delete_security_event_mark_miss_list_async(
        self,
        request: sas_20181203_models.DeleteSecurityEventMarkMissListRequest,
    ) -> sas_20181203_models.DeleteSecurityEventMarkMissListResponse:
        runtime = util_models.RuntimeOptions()
        return await self.delete_security_event_mark_miss_list_with_options_async(request, runtime)

    def delete_strategy_with_options(
        self,
        request: sas_20181203_models.DeleteStrategyRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DeleteStrategyResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.id):
            query['Id'] = request.id
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteStrategy',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DeleteStrategyResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_strategy_with_options_async(
        self,
        request: sas_20181203_models.DeleteStrategyRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DeleteStrategyResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.id):
            query['Id'] = request.id
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteStrategy',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DeleteStrategyResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_strategy(
        self,
        request: sas_20181203_models.DeleteStrategyRequest,
    ) -> sas_20181203_models.DeleteStrategyResponse:
        runtime = util_models.RuntimeOptions()
        return self.delete_strategy_with_options(request, runtime)

    async def delete_strategy_async(
        self,
        request: sas_20181203_models.DeleteStrategyRequest,
    ) -> sas_20181203_models.DeleteStrategyResponse:
        runtime = util_models.RuntimeOptions()
        return await self.delete_strategy_with_options_async(request, runtime)

    def delete_susp_event_node_with_options(
        self,
        request: sas_20181203_models.DeleteSuspEventNodeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DeleteSuspEventNodeResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.note_id):
            query['NoteId'] = request.note_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteSuspEventNode',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DeleteSuspEventNodeResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_susp_event_node_with_options_async(
        self,
        request: sas_20181203_models.DeleteSuspEventNodeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DeleteSuspEventNodeResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.note_id):
            query['NoteId'] = request.note_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteSuspEventNode',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DeleteSuspEventNodeResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_susp_event_node(
        self,
        request: sas_20181203_models.DeleteSuspEventNodeRequest,
    ) -> sas_20181203_models.DeleteSuspEventNodeResponse:
        runtime = util_models.RuntimeOptions()
        return self.delete_susp_event_node_with_options(request, runtime)

    async def delete_susp_event_node_async(
        self,
        request: sas_20181203_models.DeleteSuspEventNodeRequest,
    ) -> sas_20181203_models.DeleteSuspEventNodeResponse:
        runtime = util_models.RuntimeOptions()
        return await self.delete_susp_event_node_with_options_async(request, runtime)

    def delete_tag_with_uuid_with_options(
        self,
        request: sas_20181203_models.DeleteTagWithUuidRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DeleteTagWithUuidResponse:
        """
        Security Center provides asset importance tags and custom tags. You can call this operation to remove only the custom tag that is added to an asset.
        
        @param request: DeleteTagWithUuidRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteTagWithUuidResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.tag_name):
            query['TagName'] = request.tag_name
        if not UtilClient.is_unset(request.uuid_list):
            query['UuidList'] = request.uuid_list
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteTagWithUuid',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DeleteTagWithUuidResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_tag_with_uuid_with_options_async(
        self,
        request: sas_20181203_models.DeleteTagWithUuidRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DeleteTagWithUuidResponse:
        """
        Security Center provides asset importance tags and custom tags. You can call this operation to remove only the custom tag that is added to an asset.
        
        @param request: DeleteTagWithUuidRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteTagWithUuidResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.tag_name):
            query['TagName'] = request.tag_name
        if not UtilClient.is_unset(request.uuid_list):
            query['UuidList'] = request.uuid_list
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteTagWithUuid',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DeleteTagWithUuidResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_tag_with_uuid(
        self,
        request: sas_20181203_models.DeleteTagWithUuidRequest,
    ) -> sas_20181203_models.DeleteTagWithUuidResponse:
        """
        Security Center provides asset importance tags and custom tags. You can call this operation to remove only the custom tag that is added to an asset.
        
        @param request: DeleteTagWithUuidRequest
        @return: DeleteTagWithUuidResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_tag_with_uuid_with_options(request, runtime)

    async def delete_tag_with_uuid_async(
        self,
        request: sas_20181203_models.DeleteTagWithUuidRequest,
    ) -> sas_20181203_models.DeleteTagWithUuidResponse:
        """
        Security Center provides asset importance tags and custom tags. You can call this operation to remove only the custom tag that is added to an asset.
        
        @param request: DeleteTagWithUuidRequest
        @return: DeleteTagWithUuidResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_tag_with_uuid_with_options_async(request, runtime)

    def delete_uni_backup_policy_with_options(
        self,
        request: sas_20181203_models.DeleteUniBackupPolicyRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DeleteUniBackupPolicyResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.policy_id):
            query['PolicyId'] = request.policy_id
        if not UtilClient.is_unset(request.policy_ids):
            query['PolicyIds'] = request.policy_ids
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteUniBackupPolicy',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DeleteUniBackupPolicyResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_uni_backup_policy_with_options_async(
        self,
        request: sas_20181203_models.DeleteUniBackupPolicyRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DeleteUniBackupPolicyResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.policy_id):
            query['PolicyId'] = request.policy_id
        if not UtilClient.is_unset(request.policy_ids):
            query['PolicyIds'] = request.policy_ids
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteUniBackupPolicy',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DeleteUniBackupPolicyResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_uni_backup_policy(
        self,
        request: sas_20181203_models.DeleteUniBackupPolicyRequest,
    ) -> sas_20181203_models.DeleteUniBackupPolicyResponse:
        runtime = util_models.RuntimeOptions()
        return self.delete_uni_backup_policy_with_options(request, runtime)

    async def delete_uni_backup_policy_async(
        self,
        request: sas_20181203_models.DeleteUniBackupPolicyRequest,
    ) -> sas_20181203_models.DeleteUniBackupPolicyResponse:
        runtime = util_models.RuntimeOptions()
        return await self.delete_uni_backup_policy_with_options_async(request, runtime)

    def delete_vpc_honey_pot_with_options(
        self,
        request: sas_20181203_models.DeleteVpcHoneyPotRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DeleteVpcHoneyPotResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteVpcHoneyPot',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DeleteVpcHoneyPotResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_vpc_honey_pot_with_options_async(
        self,
        request: sas_20181203_models.DeleteVpcHoneyPotRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DeleteVpcHoneyPotResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteVpcHoneyPot',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DeleteVpcHoneyPotResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_vpc_honey_pot(
        self,
        request: sas_20181203_models.DeleteVpcHoneyPotRequest,
    ) -> sas_20181203_models.DeleteVpcHoneyPotResponse:
        runtime = util_models.RuntimeOptions()
        return self.delete_vpc_honey_pot_with_options(request, runtime)

    async def delete_vpc_honey_pot_async(
        self,
        request: sas_20181203_models.DeleteVpcHoneyPotRequest,
    ) -> sas_20181203_models.DeleteVpcHoneyPotResponse:
        runtime = util_models.RuntimeOptions()
        return await self.delete_vpc_honey_pot_with_options_async(request, runtime)

    def delete_vul_whitelist_with_options(
        self,
        request: sas_20181203_models.DeleteVulWhitelistRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DeleteVulWhitelistResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.id):
            query['Id'] = request.id
        if not UtilClient.is_unset(request.whitelist):
            query['Whitelist'] = request.whitelist
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteVulWhitelist',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DeleteVulWhitelistResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_vul_whitelist_with_options_async(
        self,
        request: sas_20181203_models.DeleteVulWhitelistRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DeleteVulWhitelistResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.id):
            query['Id'] = request.id
        if not UtilClient.is_unset(request.whitelist):
            query['Whitelist'] = request.whitelist
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteVulWhitelist',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DeleteVulWhitelistResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_vul_whitelist(
        self,
        request: sas_20181203_models.DeleteVulWhitelistRequest,
    ) -> sas_20181203_models.DeleteVulWhitelistResponse:
        runtime = util_models.RuntimeOptions()
        return self.delete_vul_whitelist_with_options(request, runtime)

    async def delete_vul_whitelist_async(
        self,
        request: sas_20181203_models.DeleteVulWhitelistRequest,
    ) -> sas_20181203_models.DeleteVulWhitelistResponse:
        runtime = util_models.RuntimeOptions()
        return await self.delete_vul_whitelist_with_options_async(request, runtime)

    def describe_access_key_leak_detail_with_options(
        self,
        request: sas_20181203_models.DescribeAccessKeyLeakDetailRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeAccessKeyLeakDetailResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.id):
            query['Id'] = request.id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeAccessKeyLeakDetail',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeAccessKeyLeakDetailResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_access_key_leak_detail_with_options_async(
        self,
        request: sas_20181203_models.DescribeAccessKeyLeakDetailRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeAccessKeyLeakDetailResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.id):
            query['Id'] = request.id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeAccessKeyLeakDetail',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeAccessKeyLeakDetailResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_access_key_leak_detail(
        self,
        request: sas_20181203_models.DescribeAccessKeyLeakDetailRequest,
    ) -> sas_20181203_models.DescribeAccessKeyLeakDetailResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_access_key_leak_detail_with_options(request, runtime)

    async def describe_access_key_leak_detail_async(
        self,
        request: sas_20181203_models.DescribeAccessKeyLeakDetailRequest,
    ) -> sas_20181203_models.DescribeAccessKeyLeakDetailResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_access_key_leak_detail_with_options_async(request, runtime)

    def describe_accesskey_leak_list_with_options(
        self,
        request: sas_20181203_models.DescribeAccesskeyLeakListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeAccesskeyLeakListResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.query):
            query['Query'] = request.query
        if not UtilClient.is_unset(request.start_ts):
            query['StartTs'] = request.start_ts
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeAccesskeyLeakList',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeAccesskeyLeakListResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_accesskey_leak_list_with_options_async(
        self,
        request: sas_20181203_models.DescribeAccesskeyLeakListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeAccesskeyLeakListResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.query):
            query['Query'] = request.query
        if not UtilClient.is_unset(request.start_ts):
            query['StartTs'] = request.start_ts
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeAccesskeyLeakList',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeAccesskeyLeakListResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_accesskey_leak_list(
        self,
        request: sas_20181203_models.DescribeAccesskeyLeakListRequest,
    ) -> sas_20181203_models.DescribeAccesskeyLeakListResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_accesskey_leak_list_with_options(request, runtime)

    async def describe_accesskey_leak_list_async(
        self,
        request: sas_20181203_models.DescribeAccesskeyLeakListRequest,
    ) -> sas_20181203_models.DescribeAccesskeyLeakListResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_accesskey_leak_list_with_options_async(request, runtime)

    def describe_affected_assets_with_options(
        self,
        request: sas_20181203_models.DescribeAffectedAssetsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeAffectedAssetsResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.current):
            query['Current'] = request.current
        if not UtilClient.is_unset(request.levels):
            query['Levels'] = request.levels
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeAffectedAssets',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeAffectedAssetsResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_affected_assets_with_options_async(
        self,
        request: sas_20181203_models.DescribeAffectedAssetsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeAffectedAssetsResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.current):
            query['Current'] = request.current
        if not UtilClient.is_unset(request.levels):
            query['Levels'] = request.levels
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeAffectedAssets',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeAffectedAssetsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_affected_assets(
        self,
        request: sas_20181203_models.DescribeAffectedAssetsRequest,
    ) -> sas_20181203_models.DescribeAffectedAssetsResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_affected_assets_with_options(request, runtime)

    async def describe_affected_assets_async(
        self,
        request: sas_20181203_models.DescribeAffectedAssetsRequest,
    ) -> sas_20181203_models.DescribeAffectedAssetsResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_affected_assets_with_options_async(request, runtime)

    def describe_affected_malicious_file_images_with_options(
        self,
        request: sas_20181203_models.DescribeAffectedMaliciousFileImagesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeAffectedMaliciousFileImagesResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cluster_id):
            query['ClusterId'] = request.cluster_id
        if not UtilClient.is_unset(request.cluster_name):
            query['ClusterName'] = request.cluster_name
        if not UtilClient.is_unset(request.container_id):
            query['ContainerId'] = request.container_id
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.image):
            query['Image'] = request.image
        if not UtilClient.is_unset(request.image_digest):
            query['ImageDigest'] = request.image_digest
        if not UtilClient.is_unset(request.image_layer):
            query['ImageLayer'] = request.image_layer
        if not UtilClient.is_unset(request.image_tag):
            query['ImageTag'] = request.image_tag
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.levels):
            query['Levels'] = request.levels
        if not UtilClient.is_unset(request.malicious_md_5):
            query['MaliciousMd5'] = request.malicious_md_5
        if not UtilClient.is_unset(request.namespace):
            query['Namespace'] = request.namespace
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.pod):
            query['Pod'] = request.pod
        if not UtilClient.is_unset(request.repo_id):
            query['RepoId'] = request.repo_id
        if not UtilClient.is_unset(request.repo_instance_id):
            query['RepoInstanceId'] = request.repo_instance_id
        if not UtilClient.is_unset(request.repo_name):
            query['RepoName'] = request.repo_name
        if not UtilClient.is_unset(request.repo_namespace):
            query['RepoNamespace'] = request.repo_namespace
        if not UtilClient.is_unset(request.repo_region_id):
            query['RepoRegionId'] = request.repo_region_id
        if not UtilClient.is_unset(request.scan_range):
            query['ScanRange'] = request.scan_range
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeAffectedMaliciousFileImages',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeAffectedMaliciousFileImagesResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_affected_malicious_file_images_with_options_async(
        self,
        request: sas_20181203_models.DescribeAffectedMaliciousFileImagesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeAffectedMaliciousFileImagesResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cluster_id):
            query['ClusterId'] = request.cluster_id
        if not UtilClient.is_unset(request.cluster_name):
            query['ClusterName'] = request.cluster_name
        if not UtilClient.is_unset(request.container_id):
            query['ContainerId'] = request.container_id
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.image):
            query['Image'] = request.image
        if not UtilClient.is_unset(request.image_digest):
            query['ImageDigest'] = request.image_digest
        if not UtilClient.is_unset(request.image_layer):
            query['ImageLayer'] = request.image_layer
        if not UtilClient.is_unset(request.image_tag):
            query['ImageTag'] = request.image_tag
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.levels):
            query['Levels'] = request.levels
        if not UtilClient.is_unset(request.malicious_md_5):
            query['MaliciousMd5'] = request.malicious_md_5
        if not UtilClient.is_unset(request.namespace):
            query['Namespace'] = request.namespace
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.pod):
            query['Pod'] = request.pod
        if not UtilClient.is_unset(request.repo_id):
            query['RepoId'] = request.repo_id
        if not UtilClient.is_unset(request.repo_instance_id):
            query['RepoInstanceId'] = request.repo_instance_id
        if not UtilClient.is_unset(request.repo_name):
            query['RepoName'] = request.repo_name
        if not UtilClient.is_unset(request.repo_namespace):
            query['RepoNamespace'] = request.repo_namespace
        if not UtilClient.is_unset(request.repo_region_id):
            query['RepoRegionId'] = request.repo_region_id
        if not UtilClient.is_unset(request.scan_range):
            query['ScanRange'] = request.scan_range
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeAffectedMaliciousFileImages',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeAffectedMaliciousFileImagesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_affected_malicious_file_images(
        self,
        request: sas_20181203_models.DescribeAffectedMaliciousFileImagesRequest,
    ) -> sas_20181203_models.DescribeAffectedMaliciousFileImagesResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_affected_malicious_file_images_with_options(request, runtime)

    async def describe_affected_malicious_file_images_async(
        self,
        request: sas_20181203_models.DescribeAffectedMaliciousFileImagesRequest,
    ) -> sas_20181203_models.DescribeAffectedMaliciousFileImagesResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_affected_malicious_file_images_with_options_async(request, runtime)

    def describe_agent_install_status_with_options(
        self,
        request: sas_20181203_models.DescribeAgentInstallStatusRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeAgentInstallStatusResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.uuids):
            query['Uuids'] = request.uuids
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeAgentInstallStatus',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeAgentInstallStatusResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_agent_install_status_with_options_async(
        self,
        request: sas_20181203_models.DescribeAgentInstallStatusRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeAgentInstallStatusResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.uuids):
            query['Uuids'] = request.uuids
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeAgentInstallStatus',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeAgentInstallStatusResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_agent_install_status(
        self,
        request: sas_20181203_models.DescribeAgentInstallStatusRequest,
    ) -> sas_20181203_models.DescribeAgentInstallStatusResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_agent_install_status_with_options(request, runtime)

    async def describe_agent_install_status_async(
        self,
        request: sas_20181203_models.DescribeAgentInstallStatusRequest,
    ) -> sas_20181203_models.DescribeAgentInstallStatusResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_agent_install_status_with_options_async(request, runtime)

    def describe_alarm_event_detail_with_options(
        self,
        request: sas_20181203_models.DescribeAlarmEventDetailRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeAlarmEventDetailResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.alarm_unique_info):
            query['AlarmUniqueInfo'] = request.alarm_unique_info
        if not UtilClient.is_unset(request.from_):
            query['From'] = request.from_
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeAlarmEventDetail',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeAlarmEventDetailResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_alarm_event_detail_with_options_async(
        self,
        request: sas_20181203_models.DescribeAlarmEventDetailRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeAlarmEventDetailResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.alarm_unique_info):
            query['AlarmUniqueInfo'] = request.alarm_unique_info
        if not UtilClient.is_unset(request.from_):
            query['From'] = request.from_
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeAlarmEventDetail',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeAlarmEventDetailResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_alarm_event_detail(
        self,
        request: sas_20181203_models.DescribeAlarmEventDetailRequest,
    ) -> sas_20181203_models.DescribeAlarmEventDetailResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_alarm_event_detail_with_options(request, runtime)

    async def describe_alarm_event_detail_async(
        self,
        request: sas_20181203_models.DescribeAlarmEventDetailRequest,
    ) -> sas_20181203_models.DescribeAlarmEventDetailResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_alarm_event_detail_with_options_async(request, runtime)

    def describe_alarm_event_list_with_options(
        self,
        request: sas_20181203_models.DescribeAlarmEventListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeAlarmEventListResponse:
        """
        The alert aggregation feature of Security Center analyzes the paths of alerts to aggregate multiple alerts generated on the intrusions that are launched from the same IP address or service, or on the same user.
        You can call the DescribeAlarmEventList or DescribeSuspEvents operation to query alert events.
        *   If your Security Center runs the Enterprise or Ultimate edition and you turned on **Alert Association** on the **Feature Settings** page of the Security Center console, you can call the DescribeAlarmEventList operation to query alert events.
        *   If your Security Center runs the Enterprise or Ultimate edition but you turned off **Alert Association** on the **Feature Settings** page of the Security Center console, you can call the [DescribeSuspEvents](~~DescribeSuspEvents~~) operation to query alert events.
        *   If your Security Center does not run the Enterprise or Ultimate edition, you can call the [DescribeSuspEvents](~~DescribeSuspEvents~~) operation to query alert events.
        
        @param request: DescribeAlarmEventListRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeAlarmEventListResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.alarm_event_name):
            query['AlarmEventName'] = request.alarm_event_name
        if not UtilClient.is_unset(request.alarm_event_type):
            query['AlarmEventType'] = request.alarm_event_type
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.dealed):
            query['Dealed'] = request.dealed
        if not UtilClient.is_unset(request.from_):
            query['From'] = request.from_
        if not UtilClient.is_unset(request.group_id):
            query['GroupId'] = request.group_id
        if not UtilClient.is_unset(request.id):
            query['Id'] = request.id
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.levels):
            query['Levels'] = request.levels
        if not UtilClient.is_unset(request.operate_error_code_list):
            query['OperateErrorCodeList'] = request.operate_error_code_list
        if not UtilClient.is_unset(request.operate_time_end):
            query['OperateTimeEnd'] = request.operate_time_end
        if not UtilClient.is_unset(request.operate_time_start):
            query['OperateTimeStart'] = request.operate_time_start
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.remark):
            query['Remark'] = request.remark
        if not UtilClient.is_unset(request.sort_column):
            query['SortColumn'] = request.sort_column
        if not UtilClient.is_unset(request.sort_type):
            query['SortType'] = request.sort_type
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.tactic_id):
            query['TacticId'] = request.tactic_id
        if not UtilClient.is_unset(request.time_end):
            query['TimeEnd'] = request.time_end
        if not UtilClient.is_unset(request.time_start):
            query['TimeStart'] = request.time_start
        if not UtilClient.is_unset(request.unique_info):
            query['UniqueInfo'] = request.unique_info
        if not UtilClient.is_unset(request.uuids):
            query['Uuids'] = request.uuids
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeAlarmEventList',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeAlarmEventListResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_alarm_event_list_with_options_async(
        self,
        request: sas_20181203_models.DescribeAlarmEventListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeAlarmEventListResponse:
        """
        The alert aggregation feature of Security Center analyzes the paths of alerts to aggregate multiple alerts generated on the intrusions that are launched from the same IP address or service, or on the same user.
        You can call the DescribeAlarmEventList or DescribeSuspEvents operation to query alert events.
        *   If your Security Center runs the Enterprise or Ultimate edition and you turned on **Alert Association** on the **Feature Settings** page of the Security Center console, you can call the DescribeAlarmEventList operation to query alert events.
        *   If your Security Center runs the Enterprise or Ultimate edition but you turned off **Alert Association** on the **Feature Settings** page of the Security Center console, you can call the [DescribeSuspEvents](~~DescribeSuspEvents~~) operation to query alert events.
        *   If your Security Center does not run the Enterprise or Ultimate edition, you can call the [DescribeSuspEvents](~~DescribeSuspEvents~~) operation to query alert events.
        
        @param request: DescribeAlarmEventListRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeAlarmEventListResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.alarm_event_name):
            query['AlarmEventName'] = request.alarm_event_name
        if not UtilClient.is_unset(request.alarm_event_type):
            query['AlarmEventType'] = request.alarm_event_type
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.dealed):
            query['Dealed'] = request.dealed
        if not UtilClient.is_unset(request.from_):
            query['From'] = request.from_
        if not UtilClient.is_unset(request.group_id):
            query['GroupId'] = request.group_id
        if not UtilClient.is_unset(request.id):
            query['Id'] = request.id
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.levels):
            query['Levels'] = request.levels
        if not UtilClient.is_unset(request.operate_error_code_list):
            query['OperateErrorCodeList'] = request.operate_error_code_list
        if not UtilClient.is_unset(request.operate_time_end):
            query['OperateTimeEnd'] = request.operate_time_end
        if not UtilClient.is_unset(request.operate_time_start):
            query['OperateTimeStart'] = request.operate_time_start
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.remark):
            query['Remark'] = request.remark
        if not UtilClient.is_unset(request.sort_column):
            query['SortColumn'] = request.sort_column
        if not UtilClient.is_unset(request.sort_type):
            query['SortType'] = request.sort_type
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.tactic_id):
            query['TacticId'] = request.tactic_id
        if not UtilClient.is_unset(request.time_end):
            query['TimeEnd'] = request.time_end
        if not UtilClient.is_unset(request.time_start):
            query['TimeStart'] = request.time_start
        if not UtilClient.is_unset(request.unique_info):
            query['UniqueInfo'] = request.unique_info
        if not UtilClient.is_unset(request.uuids):
            query['Uuids'] = request.uuids
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeAlarmEventList',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeAlarmEventListResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_alarm_event_list(
        self,
        request: sas_20181203_models.DescribeAlarmEventListRequest,
    ) -> sas_20181203_models.DescribeAlarmEventListResponse:
        """
        The alert aggregation feature of Security Center analyzes the paths of alerts to aggregate multiple alerts generated on the intrusions that are launched from the same IP address or service, or on the same user.
        You can call the DescribeAlarmEventList or DescribeSuspEvents operation to query alert events.
        *   If your Security Center runs the Enterprise or Ultimate edition and you turned on **Alert Association** on the **Feature Settings** page of the Security Center console, you can call the DescribeAlarmEventList operation to query alert events.
        *   If your Security Center runs the Enterprise or Ultimate edition but you turned off **Alert Association** on the **Feature Settings** page of the Security Center console, you can call the [DescribeSuspEvents](~~DescribeSuspEvents~~) operation to query alert events.
        *   If your Security Center does not run the Enterprise or Ultimate edition, you can call the [DescribeSuspEvents](~~DescribeSuspEvents~~) operation to query alert events.
        
        @param request: DescribeAlarmEventListRequest
        @return: DescribeAlarmEventListResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_alarm_event_list_with_options(request, runtime)

    async def describe_alarm_event_list_async(
        self,
        request: sas_20181203_models.DescribeAlarmEventListRequest,
    ) -> sas_20181203_models.DescribeAlarmEventListResponse:
        """
        The alert aggregation feature of Security Center analyzes the paths of alerts to aggregate multiple alerts generated on the intrusions that are launched from the same IP address or service, or on the same user.
        You can call the DescribeAlarmEventList or DescribeSuspEvents operation to query alert events.
        *   If your Security Center runs the Enterprise or Ultimate edition and you turned on **Alert Association** on the **Feature Settings** page of the Security Center console, you can call the DescribeAlarmEventList operation to query alert events.
        *   If your Security Center runs the Enterprise or Ultimate edition but you turned off **Alert Association** on the **Feature Settings** page of the Security Center console, you can call the [DescribeSuspEvents](~~DescribeSuspEvents~~) operation to query alert events.
        *   If your Security Center does not run the Enterprise or Ultimate edition, you can call the [DescribeSuspEvents](~~DescribeSuspEvents~~) operation to query alert events.
        
        @param request: DescribeAlarmEventListRequest
        @return: DescribeAlarmEventListResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_alarm_event_list_with_options_async(request, runtime)

    def describe_alarm_event_stack_info_with_options(
        self,
        request: sas_20181203_models.DescribeAlarmEventStackInfoRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeAlarmEventStackInfoResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.event_name):
            query['EventName'] = request.event_name
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.unique_info):
            query['UniqueInfo'] = request.unique_info
        if not UtilClient.is_unset(request.uuid):
            query['Uuid'] = request.uuid
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeAlarmEventStackInfo',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeAlarmEventStackInfoResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_alarm_event_stack_info_with_options_async(
        self,
        request: sas_20181203_models.DescribeAlarmEventStackInfoRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeAlarmEventStackInfoResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.event_name):
            query['EventName'] = request.event_name
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.unique_info):
            query['UniqueInfo'] = request.unique_info
        if not UtilClient.is_unset(request.uuid):
            query['Uuid'] = request.uuid
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeAlarmEventStackInfo',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeAlarmEventStackInfoResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_alarm_event_stack_info(
        self,
        request: sas_20181203_models.DescribeAlarmEventStackInfoRequest,
    ) -> sas_20181203_models.DescribeAlarmEventStackInfoResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_alarm_event_stack_info_with_options(request, runtime)

    async def describe_alarm_event_stack_info_async(
        self,
        request: sas_20181203_models.DescribeAlarmEventStackInfoRequest,
    ) -> sas_20181203_models.DescribeAlarmEventStackInfoResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_alarm_event_stack_info_with_options_async(request, runtime)

    def describe_all_entity_with_options(
        self,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeAllEntityResponse:
        req = open_api_models.OpenApiRequest()
        params = open_api_models.Params(
            action='DescribeAllEntity',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeAllEntityResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_all_entity_with_options_async(
        self,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeAllEntityResponse:
        req = open_api_models.OpenApiRequest()
        params = open_api_models.Params(
            action='DescribeAllEntity',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeAllEntityResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_all_entity(self) -> sas_20181203_models.DescribeAllEntityResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_all_entity_with_options(runtime)

    async def describe_all_entity_async(self) -> sas_20181203_models.DescribeAllEntityResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_all_entity_with_options_async(runtime)

    def describe_all_groups_with_options(
        self,
        request: sas_20181203_models.DescribeAllGroupsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeAllGroupsResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeAllGroups',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeAllGroupsResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_all_groups_with_options_async(
        self,
        request: sas_20181203_models.DescribeAllGroupsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeAllGroupsResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeAllGroups',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeAllGroupsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_all_groups(
        self,
        request: sas_20181203_models.DescribeAllGroupsRequest,
    ) -> sas_20181203_models.DescribeAllGroupsResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_all_groups_with_options(request, runtime)

    async def describe_all_groups_async(
        self,
        request: sas_20181203_models.DescribeAllGroupsRequest,
    ) -> sas_20181203_models.DescribeAllGroupsResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_all_groups_with_options_async(request, runtime)

    def describe_all_image_baseline_with_options(
        self,
        request: sas_20181203_models.DescribeAllImageBaselineRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeAllImageBaselineResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeAllImageBaseline',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeAllImageBaselineResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_all_image_baseline_with_options_async(
        self,
        request: sas_20181203_models.DescribeAllImageBaselineRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeAllImageBaselineResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeAllImageBaseline',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeAllImageBaselineResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_all_image_baseline(
        self,
        request: sas_20181203_models.DescribeAllImageBaselineRequest,
    ) -> sas_20181203_models.DescribeAllImageBaselineResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_all_image_baseline_with_options(request, runtime)

    async def describe_all_image_baseline_async(
        self,
        request: sas_20181203_models.DescribeAllImageBaselineRequest,
    ) -> sas_20181203_models.DescribeAllImageBaselineResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_all_image_baseline_with_options_async(request, runtime)

    def describe_anti_brute_force_rules_with_options(
        self,
        request: sas_20181203_models.DescribeAntiBruteForceRulesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeAntiBruteForceRulesResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.id):
            query['Id'] = request.id
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeAntiBruteForceRules',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeAntiBruteForceRulesResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_anti_brute_force_rules_with_options_async(
        self,
        request: sas_20181203_models.DescribeAntiBruteForceRulesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeAntiBruteForceRulesResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.id):
            query['Id'] = request.id
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeAntiBruteForceRules',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeAntiBruteForceRulesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_anti_brute_force_rules(
        self,
        request: sas_20181203_models.DescribeAntiBruteForceRulesRequest,
    ) -> sas_20181203_models.DescribeAntiBruteForceRulesResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_anti_brute_force_rules_with_options(request, runtime)

    async def describe_anti_brute_force_rules_async(
        self,
        request: sas_20181203_models.DescribeAntiBruteForceRulesRequest,
    ) -> sas_20181203_models.DescribeAntiBruteForceRulesResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_anti_brute_force_rules_with_options_async(request, runtime)

    def describe_app_vul_scan_cycle_with_options(
        self,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeAppVulScanCycleResponse:
        req = open_api_models.OpenApiRequest()
        params = open_api_models.Params(
            action='DescribeAppVulScanCycle',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeAppVulScanCycleResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_app_vul_scan_cycle_with_options_async(
        self,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeAppVulScanCycleResponse:
        req = open_api_models.OpenApiRequest()
        params = open_api_models.Params(
            action='DescribeAppVulScanCycle',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeAppVulScanCycleResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_app_vul_scan_cycle(self) -> sas_20181203_models.DescribeAppVulScanCycleResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_app_vul_scan_cycle_with_options(runtime)

    async def describe_app_vul_scan_cycle_async(self) -> sas_20181203_models.DescribeAppVulScanCycleResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_app_vul_scan_cycle_with_options_async(runtime)

    def describe_asset_detail_by_uuid_with_options(
        self,
        request: sas_20181203_models.DescribeAssetDetailByUuidRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeAssetDetailByUuidResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.uuid):
            query['Uuid'] = request.uuid
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeAssetDetailByUuid',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeAssetDetailByUuidResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_asset_detail_by_uuid_with_options_async(
        self,
        request: sas_20181203_models.DescribeAssetDetailByUuidRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeAssetDetailByUuidResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.uuid):
            query['Uuid'] = request.uuid
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeAssetDetailByUuid',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeAssetDetailByUuidResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_asset_detail_by_uuid(
        self,
        request: sas_20181203_models.DescribeAssetDetailByUuidRequest,
    ) -> sas_20181203_models.DescribeAssetDetailByUuidResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_asset_detail_by_uuid_with_options(request, runtime)

    async def describe_asset_detail_by_uuid_async(
        self,
        request: sas_20181203_models.DescribeAssetDetailByUuidRequest,
    ) -> sas_20181203_models.DescribeAssetDetailByUuidResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_asset_detail_by_uuid_with_options_async(request, runtime)

    def describe_asset_detail_by_uuids_with_options(
        self,
        request: sas_20181203_models.DescribeAssetDetailByUuidsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeAssetDetailByUuidsResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.uuids):
            query['Uuids'] = request.uuids
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeAssetDetailByUuids',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeAssetDetailByUuidsResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_asset_detail_by_uuids_with_options_async(
        self,
        request: sas_20181203_models.DescribeAssetDetailByUuidsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeAssetDetailByUuidsResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.uuids):
            query['Uuids'] = request.uuids
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeAssetDetailByUuids',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeAssetDetailByUuidsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_asset_detail_by_uuids(
        self,
        request: sas_20181203_models.DescribeAssetDetailByUuidsRequest,
    ) -> sas_20181203_models.DescribeAssetDetailByUuidsResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_asset_detail_by_uuids_with_options(request, runtime)

    async def describe_asset_detail_by_uuids_async(
        self,
        request: sas_20181203_models.DescribeAssetDetailByUuidsRequest,
    ) -> sas_20181203_models.DescribeAssetDetailByUuidsResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_asset_detail_by_uuids_with_options_async(request, runtime)

    def describe_asset_summary_with_options(
        self,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeAssetSummaryResponse:
        req = open_api_models.OpenApiRequest()
        params = open_api_models.Params(
            action='DescribeAssetSummary',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeAssetSummaryResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_asset_summary_with_options_async(
        self,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeAssetSummaryResponse:
        req = open_api_models.OpenApiRequest()
        params = open_api_models.Params(
            action='DescribeAssetSummary',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeAssetSummaryResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_asset_summary(self) -> sas_20181203_models.DescribeAssetSummaryResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_asset_summary_with_options(runtime)

    async def describe_asset_summary_async(self) -> sas_20181203_models.DescribeAssetSummaryResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_asset_summary_with_options_async(runtime)

    def describe_attack_analysis_data_with_options(
        self,
        request: sas_20181203_models.DescribeAttackAnalysisDataRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeAttackAnalysisDataResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.base_64):
            query['Base64'] = request.base_64
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.data):
            query['Data'] = request.data
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeAttackAnalysisData',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeAttackAnalysisDataResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_attack_analysis_data_with_options_async(
        self,
        request: sas_20181203_models.DescribeAttackAnalysisDataRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeAttackAnalysisDataResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.base_64):
            query['Base64'] = request.base_64
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.data):
            query['Data'] = request.data
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeAttackAnalysisData',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeAttackAnalysisDataResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_attack_analysis_data(
        self,
        request: sas_20181203_models.DescribeAttackAnalysisDataRequest,
    ) -> sas_20181203_models.DescribeAttackAnalysisDataResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_attack_analysis_data_with_options(request, runtime)

    async def describe_attack_analysis_data_async(
        self,
        request: sas_20181203_models.DescribeAttackAnalysisDataRequest,
    ) -> sas_20181203_models.DescribeAttackAnalysisDataResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_attack_analysis_data_with_options_async(request, runtime)

    def describe_auto_del_config_with_options(
        self,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeAutoDelConfigResponse:
        req = open_api_models.OpenApiRequest()
        params = open_api_models.Params(
            action='DescribeAutoDelConfig',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeAutoDelConfigResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_auto_del_config_with_options_async(
        self,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeAutoDelConfigResponse:
        req = open_api_models.OpenApiRequest()
        params = open_api_models.Params(
            action='DescribeAutoDelConfig',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeAutoDelConfigResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_auto_del_config(self) -> sas_20181203_models.DescribeAutoDelConfigResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_auto_del_config_with_options(runtime)

    async def describe_auto_del_config_async(self) -> sas_20181203_models.DescribeAutoDelConfigResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_auto_del_config_with_options_async(runtime)

    def describe_back_up_export_info_with_options(
        self,
        request: sas_20181203_models.DescribeBackUpExportInfoRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeBackUpExportInfoResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.export_type):
            query['ExportType'] = request.export_type
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeBackUpExportInfo',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeBackUpExportInfoResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_back_up_export_info_with_options_async(
        self,
        request: sas_20181203_models.DescribeBackUpExportInfoRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeBackUpExportInfoResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.export_type):
            query['ExportType'] = request.export_type
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeBackUpExportInfo',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeBackUpExportInfoResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_back_up_export_info(
        self,
        request: sas_20181203_models.DescribeBackUpExportInfoRequest,
    ) -> sas_20181203_models.DescribeBackUpExportInfoResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_back_up_export_info_with_options(request, runtime)

    async def describe_back_up_export_info_async(
        self,
        request: sas_20181203_models.DescribeBackUpExportInfoRequest,
    ) -> sas_20181203_models.DescribeBackUpExportInfoResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_back_up_export_info_with_options_async(request, runtime)

    def describe_backup_clients_with_options(
        self,
        request: sas_20181203_models.DescribeBackupClientsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeBackupClientsResponse:
        """
        You can call the DescribeBackupClients operation to query the servers on which the anti-ransomware agent is installed in a specified region.
        
        @param request: DescribeBackupClientsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeBackupClientsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.support_region_id):
            query['SupportRegionId'] = request.support_region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeBackupClients',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeBackupClientsResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_backup_clients_with_options_async(
        self,
        request: sas_20181203_models.DescribeBackupClientsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeBackupClientsResponse:
        """
        You can call the DescribeBackupClients operation to query the servers on which the anti-ransomware agent is installed in a specified region.
        
        @param request: DescribeBackupClientsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeBackupClientsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.support_region_id):
            query['SupportRegionId'] = request.support_region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeBackupClients',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeBackupClientsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_backup_clients(
        self,
        request: sas_20181203_models.DescribeBackupClientsRequest,
    ) -> sas_20181203_models.DescribeBackupClientsResponse:
        """
        You can call the DescribeBackupClients operation to query the servers on which the anti-ransomware agent is installed in a specified region.
        
        @param request: DescribeBackupClientsRequest
        @return: DescribeBackupClientsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_backup_clients_with_options(request, runtime)

    async def describe_backup_clients_async(
        self,
        request: sas_20181203_models.DescribeBackupClientsRequest,
    ) -> sas_20181203_models.DescribeBackupClientsResponse:
        """
        You can call the DescribeBackupClients operation to query the servers on which the anti-ransomware agent is installed in a specified region.
        
        @param request: DescribeBackupClientsRequest
        @return: DescribeBackupClientsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_backup_clients_with_options_async(request, runtime)

    def describe_backup_files_with_options(
        self,
        request: sas_20181203_models.DescribeBackupFilesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeBackupFilesResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.path):
            query['Path'] = request.path
        if not UtilClient.is_unset(request.snapshot_hash):
            query['SnapshotHash'] = request.snapshot_hash
        if not UtilClient.is_unset(request.uuid):
            query['Uuid'] = request.uuid
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeBackupFiles',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeBackupFilesResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_backup_files_with_options_async(
        self,
        request: sas_20181203_models.DescribeBackupFilesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeBackupFilesResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.path):
            query['Path'] = request.path
        if not UtilClient.is_unset(request.snapshot_hash):
            query['SnapshotHash'] = request.snapshot_hash
        if not UtilClient.is_unset(request.uuid):
            query['Uuid'] = request.uuid
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeBackupFiles',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeBackupFilesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_backup_files(
        self,
        request: sas_20181203_models.DescribeBackupFilesRequest,
    ) -> sas_20181203_models.DescribeBackupFilesResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_backup_files_with_options(request, runtime)

    async def describe_backup_files_async(
        self,
        request: sas_20181203_models.DescribeBackupFilesRequest,
    ) -> sas_20181203_models.DescribeBackupFilesResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_backup_files_with_options_async(request, runtime)

    def describe_backup_machine_status_with_options(
        self,
        request: sas_20181203_models.DescribeBackupMachineStatusRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeBackupMachineStatusResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.policy_id):
            query['PolicyId'] = request.policy_id
        if not UtilClient.is_unset(request.policy_version):
            query['PolicyVersion'] = request.policy_version
        if not UtilClient.is_unset(request.uuid):
            query['Uuid'] = request.uuid
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeBackupMachineStatus',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeBackupMachineStatusResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_backup_machine_status_with_options_async(
        self,
        request: sas_20181203_models.DescribeBackupMachineStatusRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeBackupMachineStatusResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.policy_id):
            query['PolicyId'] = request.policy_id
        if not UtilClient.is_unset(request.policy_version):
            query['PolicyVersion'] = request.policy_version
        if not UtilClient.is_unset(request.uuid):
            query['Uuid'] = request.uuid
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeBackupMachineStatus',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeBackupMachineStatusResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_backup_machine_status(
        self,
        request: sas_20181203_models.DescribeBackupMachineStatusRequest,
    ) -> sas_20181203_models.DescribeBackupMachineStatusResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_backup_machine_status_with_options(request, runtime)

    async def describe_backup_machine_status_async(
        self,
        request: sas_20181203_models.DescribeBackupMachineStatusRequest,
    ) -> sas_20181203_models.DescribeBackupMachineStatusResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_backup_machine_status_with_options_async(request, runtime)

    def describe_backup_policies_with_options(
        self,
        request: sas_20181203_models.DescribeBackupPoliciesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeBackupPoliciesResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.machine_remark):
            query['MachineRemark'] = request.machine_remark
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeBackupPolicies',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeBackupPoliciesResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_backup_policies_with_options_async(
        self,
        request: sas_20181203_models.DescribeBackupPoliciesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeBackupPoliciesResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.machine_remark):
            query['MachineRemark'] = request.machine_remark
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeBackupPolicies',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeBackupPoliciesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_backup_policies(
        self,
        request: sas_20181203_models.DescribeBackupPoliciesRequest,
    ) -> sas_20181203_models.DescribeBackupPoliciesResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_backup_policies_with_options(request, runtime)

    async def describe_backup_policies_async(
        self,
        request: sas_20181203_models.DescribeBackupPoliciesRequest,
    ) -> sas_20181203_models.DescribeBackupPoliciesResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_backup_policies_with_options_async(request, runtime)

    def describe_backup_policy_with_options(
        self,
        request: sas_20181203_models.DescribeBackupPolicyRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeBackupPolicyResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.id):
            query['Id'] = request.id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeBackupPolicy',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeBackupPolicyResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_backup_policy_with_options_async(
        self,
        request: sas_20181203_models.DescribeBackupPolicyRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeBackupPolicyResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.id):
            query['Id'] = request.id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeBackupPolicy',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeBackupPolicyResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_backup_policy(
        self,
        request: sas_20181203_models.DescribeBackupPolicyRequest,
    ) -> sas_20181203_models.DescribeBackupPolicyResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_backup_policy_with_options(request, runtime)

    async def describe_backup_policy_async(
        self,
        request: sas_20181203_models.DescribeBackupPolicyRequest,
    ) -> sas_20181203_models.DescribeBackupPolicyResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_backup_policy_with_options_async(request, runtime)

    def describe_backup_restore_count_with_options(
        self,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeBackupRestoreCountResponse:
        """
        If you have created restoration tasks, you can call this operation to query the number of restoration tasks that are in the *restored** or **being restored** state.
        
        @param request: DescribeBackupRestoreCountRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeBackupRestoreCountResponse
        """
        req = open_api_models.OpenApiRequest()
        params = open_api_models.Params(
            action='DescribeBackupRestoreCount',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeBackupRestoreCountResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_backup_restore_count_with_options_async(
        self,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeBackupRestoreCountResponse:
        """
        If you have created restoration tasks, you can call this operation to query the number of restoration tasks that are in the *restored** or **being restored** state.
        
        @param request: DescribeBackupRestoreCountRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeBackupRestoreCountResponse
        """
        req = open_api_models.OpenApiRequest()
        params = open_api_models.Params(
            action='DescribeBackupRestoreCount',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeBackupRestoreCountResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_backup_restore_count(self) -> sas_20181203_models.DescribeBackupRestoreCountResponse:
        """
        If you have created restoration tasks, you can call this operation to query the number of restoration tasks that are in the *restored** or **being restored** state.
        
        @return: DescribeBackupRestoreCountResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_backup_restore_count_with_options(runtime)

    async def describe_backup_restore_count_async(self) -> sas_20181203_models.DescribeBackupRestoreCountResponse:
        """
        If you have created restoration tasks, you can call this operation to query the number of restoration tasks that are in the *restored** or **being restored** state.
        
        @return: DescribeBackupRestoreCountResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_backup_restore_count_with_options_async(runtime)

    def describe_brute_force_records_with_options(
        self,
        request: sas_20181203_models.DescribeBruteForceRecordsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeBruteForceRecordsResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.block_ip):
            query['BlockIp'] = request.block_ip
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeBruteForceRecords',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeBruteForceRecordsResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_brute_force_records_with_options_async(
        self,
        request: sas_20181203_models.DescribeBruteForceRecordsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeBruteForceRecordsResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.block_ip):
            query['BlockIp'] = request.block_ip
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeBruteForceRecords',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeBruteForceRecordsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_brute_force_records(
        self,
        request: sas_20181203_models.DescribeBruteForceRecordsRequest,
    ) -> sas_20181203_models.DescribeBruteForceRecordsResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_brute_force_records_with_options(request, runtime)

    async def describe_brute_force_records_async(
        self,
        request: sas_20181203_models.DescribeBruteForceRecordsRequest,
    ) -> sas_20181203_models.DescribeBruteForceRecordsResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_brute_force_records_with_options_async(request, runtime)

    def describe_brute_force_summary_with_options(
        self,
        request: sas_20181203_models.DescribeBruteForceSummaryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeBruteForceSummaryResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeBruteForceSummary',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeBruteForceSummaryResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_brute_force_summary_with_options_async(
        self,
        request: sas_20181203_models.DescribeBruteForceSummaryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeBruteForceSummaryResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeBruteForceSummary',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeBruteForceSummaryResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_brute_force_summary(
        self,
        request: sas_20181203_models.DescribeBruteForceSummaryRequest,
    ) -> sas_20181203_models.DescribeBruteForceSummaryResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_brute_force_summary_with_options(request, runtime)

    async def describe_brute_force_summary_async(
        self,
        request: sas_20181203_models.DescribeBruteForceSummaryRequest,
    ) -> sas_20181203_models.DescribeBruteForceSummaryResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_brute_force_summary_with_options_async(request, runtime)

    def describe_check_ecs_warnings_with_options(
        self,
        request: sas_20181203_models.DescribeCheckEcsWarningsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeCheckEcsWarningsResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeCheckEcsWarnings',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeCheckEcsWarningsResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_check_ecs_warnings_with_options_async(
        self,
        request: sas_20181203_models.DescribeCheckEcsWarningsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeCheckEcsWarningsResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeCheckEcsWarnings',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeCheckEcsWarningsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_check_ecs_warnings(
        self,
        request: sas_20181203_models.DescribeCheckEcsWarningsRequest,
    ) -> sas_20181203_models.DescribeCheckEcsWarningsResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_check_ecs_warnings_with_options(request, runtime)

    async def describe_check_ecs_warnings_async(
        self,
        request: sas_20181203_models.DescribeCheckEcsWarningsRequest,
    ) -> sas_20181203_models.DescribeCheckEcsWarningsResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_check_ecs_warnings_with_options_async(request, runtime)

    def describe_check_fix_details_with_options(
        self,
        request: sas_20181203_models.DescribeCheckFixDetailsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeCheckFixDetailsResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.check_ids):
            query['CheckIds'] = request.check_ids
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.risk_id):
            query['RiskId'] = request.risk_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeCheckFixDetails',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeCheckFixDetailsResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_check_fix_details_with_options_async(
        self,
        request: sas_20181203_models.DescribeCheckFixDetailsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeCheckFixDetailsResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.check_ids):
            query['CheckIds'] = request.check_ids
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.risk_id):
            query['RiskId'] = request.risk_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeCheckFixDetails',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeCheckFixDetailsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_check_fix_details(
        self,
        request: sas_20181203_models.DescribeCheckFixDetailsRequest,
    ) -> sas_20181203_models.DescribeCheckFixDetailsResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_check_fix_details_with_options(request, runtime)

    async def describe_check_fix_details_async(
        self,
        request: sas_20181203_models.DescribeCheckFixDetailsRequest,
    ) -> sas_20181203_models.DescribeCheckFixDetailsResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_check_fix_details_with_options_async(request, runtime)

    def describe_check_warning_detail_with_options(
        self,
        request: sas_20181203_models.DescribeCheckWarningDetailRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeCheckWarningDetailResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.check_warning_id):
            query['CheckWarningId'] = request.check_warning_id
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeCheckWarningDetail',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeCheckWarningDetailResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_check_warning_detail_with_options_async(
        self,
        request: sas_20181203_models.DescribeCheckWarningDetailRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeCheckWarningDetailResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.check_warning_id):
            query['CheckWarningId'] = request.check_warning_id
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeCheckWarningDetail',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeCheckWarningDetailResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_check_warning_detail(
        self,
        request: sas_20181203_models.DescribeCheckWarningDetailRequest,
    ) -> sas_20181203_models.DescribeCheckWarningDetailResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_check_warning_detail_with_options(request, runtime)

    async def describe_check_warning_detail_async(
        self,
        request: sas_20181203_models.DescribeCheckWarningDetailRequest,
    ) -> sas_20181203_models.DescribeCheckWarningDetailResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_check_warning_detail_with_options_async(request, runtime)

    def describe_check_warning_machines_with_options(
        self,
        request: sas_20181203_models.DescribeCheckWarningMachinesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeCheckWarningMachinesResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.check_id):
            query['CheckId'] = request.check_id
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.risk_id):
            query['RiskId'] = request.risk_id
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeCheckWarningMachines',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeCheckWarningMachinesResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_check_warning_machines_with_options_async(
        self,
        request: sas_20181203_models.DescribeCheckWarningMachinesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeCheckWarningMachinesResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.check_id):
            query['CheckId'] = request.check_id
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.risk_id):
            query['RiskId'] = request.risk_id
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeCheckWarningMachines',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeCheckWarningMachinesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_check_warning_machines(
        self,
        request: sas_20181203_models.DescribeCheckWarningMachinesRequest,
    ) -> sas_20181203_models.DescribeCheckWarningMachinesResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_check_warning_machines_with_options(request, runtime)

    async def describe_check_warning_machines_async(
        self,
        request: sas_20181203_models.DescribeCheckWarningMachinesRequest,
    ) -> sas_20181203_models.DescribeCheckWarningMachinesResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_check_warning_machines_with_options_async(request, runtime)

    def describe_check_warning_summary_with_options(
        self,
        request: sas_20181203_models.DescribeCheckWarningSummaryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeCheckWarningSummaryResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cluster_id):
            query['ClusterId'] = request.cluster_id
        if not UtilClient.is_unset(request.container_field_name):
            query['ContainerFieldName'] = request.container_field_name
        if not UtilClient.is_unset(request.container_field_value):
            query['ContainerFieldValue'] = request.container_field_value
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.group_id):
            query['GroupId'] = request.group_id
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.risk_name):
            query['RiskName'] = request.risk_name
        if not UtilClient.is_unset(request.risk_status):
            query['RiskStatus'] = request.risk_status
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        if not UtilClient.is_unset(request.strategy_id):
            query['StrategyId'] = request.strategy_id
        if not UtilClient.is_unset(request.target_type):
            query['TargetType'] = request.target_type
        if not UtilClient.is_unset(request.type_name):
            query['TypeName'] = request.type_name
        if not UtilClient.is_unset(request.uuids):
            query['Uuids'] = request.uuids
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeCheckWarningSummary',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeCheckWarningSummaryResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_check_warning_summary_with_options_async(
        self,
        request: sas_20181203_models.DescribeCheckWarningSummaryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeCheckWarningSummaryResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cluster_id):
            query['ClusterId'] = request.cluster_id
        if not UtilClient.is_unset(request.container_field_name):
            query['ContainerFieldName'] = request.container_field_name
        if not UtilClient.is_unset(request.container_field_value):
            query['ContainerFieldValue'] = request.container_field_value
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.group_id):
            query['GroupId'] = request.group_id
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.risk_name):
            query['RiskName'] = request.risk_name
        if not UtilClient.is_unset(request.risk_status):
            query['RiskStatus'] = request.risk_status
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        if not UtilClient.is_unset(request.strategy_id):
            query['StrategyId'] = request.strategy_id
        if not UtilClient.is_unset(request.target_type):
            query['TargetType'] = request.target_type
        if not UtilClient.is_unset(request.type_name):
            query['TypeName'] = request.type_name
        if not UtilClient.is_unset(request.uuids):
            query['Uuids'] = request.uuids
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeCheckWarningSummary',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeCheckWarningSummaryResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_check_warning_summary(
        self,
        request: sas_20181203_models.DescribeCheckWarningSummaryRequest,
    ) -> sas_20181203_models.DescribeCheckWarningSummaryResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_check_warning_summary_with_options(request, runtime)

    async def describe_check_warning_summary_async(
        self,
        request: sas_20181203_models.DescribeCheckWarningSummaryRequest,
    ) -> sas_20181203_models.DescribeCheckWarningSummaryResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_check_warning_summary_with_options_async(request, runtime)

    def describe_check_warnings_with_options(
        self,
        request: sas_20181203_models.DescribeCheckWarningsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeCheckWarningsResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.check_id):
            query['CheckId'] = request.check_id
        if not UtilClient.is_unset(request.check_type):
            query['CheckType'] = request.check_type
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.risk_id):
            query['RiskId'] = request.risk_id
        if not UtilClient.is_unset(request.risk_status):
            query['RiskStatus'] = request.risk_status
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.uuid):
            query['Uuid'] = request.uuid
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeCheckWarnings',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeCheckWarningsResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_check_warnings_with_options_async(
        self,
        request: sas_20181203_models.DescribeCheckWarningsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeCheckWarningsResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.check_id):
            query['CheckId'] = request.check_id
        if not UtilClient.is_unset(request.check_type):
            query['CheckType'] = request.check_type
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.risk_id):
            query['RiskId'] = request.risk_id
        if not UtilClient.is_unset(request.risk_status):
            query['RiskStatus'] = request.risk_status
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.uuid):
            query['Uuid'] = request.uuid
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeCheckWarnings',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeCheckWarningsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_check_warnings(
        self,
        request: sas_20181203_models.DescribeCheckWarningsRequest,
    ) -> sas_20181203_models.DescribeCheckWarningsResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_check_warnings_with_options(request, runtime)

    async def describe_check_warnings_async(
        self,
        request: sas_20181203_models.DescribeCheckWarningsRequest,
    ) -> sas_20181203_models.DescribeCheckWarningsResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_check_warnings_with_options_async(request, runtime)

    def describe_client_conf_setup_with_options(
        self,
        request: sas_20181203_models.DescribeClientConfSetupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeClientConfSetupResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.strategy_tag):
            query['StrategyTag'] = request.strategy_tag
        if not UtilClient.is_unset(request.strategy_tag_value):
            query['StrategyTagValue'] = request.strategy_tag_value
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeClientConfSetup',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeClientConfSetupResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_client_conf_setup_with_options_async(
        self,
        request: sas_20181203_models.DescribeClientConfSetupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeClientConfSetupResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.strategy_tag):
            query['StrategyTag'] = request.strategy_tag
        if not UtilClient.is_unset(request.strategy_tag_value):
            query['StrategyTagValue'] = request.strategy_tag_value
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeClientConfSetup',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeClientConfSetupResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_client_conf_setup(
        self,
        request: sas_20181203_models.DescribeClientConfSetupRequest,
    ) -> sas_20181203_models.DescribeClientConfSetupResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_client_conf_setup_with_options(request, runtime)

    async def describe_client_conf_setup_async(
        self,
        request: sas_20181203_models.DescribeClientConfSetupRequest,
    ) -> sas_20181203_models.DescribeClientConfSetupResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_client_conf_setup_with_options_async(request, runtime)

    def describe_client_conf_strategy_with_options(
        self,
        request: sas_20181203_models.DescribeClientConfStrategyRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeClientConfStrategyResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        if not UtilClient.is_unset(request.tag_value):
            query['TagValue'] = request.tag_value
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeClientConfStrategy',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeClientConfStrategyResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_client_conf_strategy_with_options_async(
        self,
        request: sas_20181203_models.DescribeClientConfStrategyRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeClientConfStrategyResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        if not UtilClient.is_unset(request.tag_value):
            query['TagValue'] = request.tag_value
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeClientConfStrategy',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeClientConfStrategyResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_client_conf_strategy(
        self,
        request: sas_20181203_models.DescribeClientConfStrategyRequest,
    ) -> sas_20181203_models.DescribeClientConfStrategyResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_client_conf_strategy_with_options(request, runtime)

    async def describe_client_conf_strategy_async(
        self,
        request: sas_20181203_models.DescribeClientConfStrategyRequest,
    ) -> sas_20181203_models.DescribeClientConfStrategyResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_client_conf_strategy_with_options_async(request, runtime)

    def describe_cloud_center_instances_with_options(
        self,
        request: sas_20181203_models.DescribeCloudCenterInstancesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeCloudCenterInstancesResponse:
        """
        You can search for assets by using search conditions, such as the instance ID, instance name, virtual private cloud (VPC) ID, region, and public IP address. You can also configure a logical relationship between multiple search conditions to search for the assets that meet the search conditions.
        
        @param request: DescribeCloudCenterInstancesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeCloudCenterInstancesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.criteria):
            query['Criteria'] = request.criteria
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.importance):
            query['Importance'] = request.importance
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.logical_exp):
            query['LogicalExp'] = request.logical_exp
        if not UtilClient.is_unset(request.machine_types):
            query['MachineTypes'] = request.machine_types
        if not UtilClient.is_unset(request.no_group_trace):
            query['NoGroupTrace'] = request.no_group_trace
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeCloudCenterInstances',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeCloudCenterInstancesResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_cloud_center_instances_with_options_async(
        self,
        request: sas_20181203_models.DescribeCloudCenterInstancesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeCloudCenterInstancesResponse:
        """
        You can search for assets by using search conditions, such as the instance ID, instance name, virtual private cloud (VPC) ID, region, and public IP address. You can also configure a logical relationship between multiple search conditions to search for the assets that meet the search conditions.
        
        @param request: DescribeCloudCenterInstancesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeCloudCenterInstancesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.criteria):
            query['Criteria'] = request.criteria
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.importance):
            query['Importance'] = request.importance
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.logical_exp):
            query['LogicalExp'] = request.logical_exp
        if not UtilClient.is_unset(request.machine_types):
            query['MachineTypes'] = request.machine_types
        if not UtilClient.is_unset(request.no_group_trace):
            query['NoGroupTrace'] = request.no_group_trace
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeCloudCenterInstances',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeCloudCenterInstancesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_cloud_center_instances(
        self,
        request: sas_20181203_models.DescribeCloudCenterInstancesRequest,
    ) -> sas_20181203_models.DescribeCloudCenterInstancesResponse:
        """
        You can search for assets by using search conditions, such as the instance ID, instance name, virtual private cloud (VPC) ID, region, and public IP address. You can also configure a logical relationship between multiple search conditions to search for the assets that meet the search conditions.
        
        @param request: DescribeCloudCenterInstancesRequest
        @return: DescribeCloudCenterInstancesResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_cloud_center_instances_with_options(request, runtime)

    async def describe_cloud_center_instances_async(
        self,
        request: sas_20181203_models.DescribeCloudCenterInstancesRequest,
    ) -> sas_20181203_models.DescribeCloudCenterInstancesResponse:
        """
        You can search for assets by using search conditions, such as the instance ID, instance name, virtual private cloud (VPC) ID, region, and public IP address. You can also configure a logical relationship between multiple search conditions to search for the assets that meet the search conditions.
        
        @param request: DescribeCloudCenterInstancesRequest
        @return: DescribeCloudCenterInstancesResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_cloud_center_instances_with_options_async(request, runtime)

    def describe_cloud_product_field_statistics_with_options(
        self,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeCloudProductFieldStatisticsResponse:
        req = open_api_models.OpenApiRequest()
        params = open_api_models.Params(
            action='DescribeCloudProductFieldStatistics',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeCloudProductFieldStatisticsResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_cloud_product_field_statistics_with_options_async(
        self,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeCloudProductFieldStatisticsResponse:
        req = open_api_models.OpenApiRequest()
        params = open_api_models.Params(
            action='DescribeCloudProductFieldStatistics',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeCloudProductFieldStatisticsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_cloud_product_field_statistics(self) -> sas_20181203_models.DescribeCloudProductFieldStatisticsResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_cloud_product_field_statistics_with_options(runtime)

    async def describe_cloud_product_field_statistics_async(self) -> sas_20181203_models.DescribeCloudProductFieldStatisticsResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_cloud_product_field_statistics_with_options_async(runtime)

    def describe_cluster_basic_info_with_options(
        self,
        request: sas_20181203_models.DescribeClusterBasicInfoRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeClusterBasicInfoResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cluster_id):
            query['ClusterId'] = request.cluster_id
        if not UtilClient.is_unset(request.target_type):
            query['TargetType'] = request.target_type
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeClusterBasicInfo',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeClusterBasicInfoResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_cluster_basic_info_with_options_async(
        self,
        request: sas_20181203_models.DescribeClusterBasicInfoRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeClusterBasicInfoResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cluster_id):
            query['ClusterId'] = request.cluster_id
        if not UtilClient.is_unset(request.target_type):
            query['TargetType'] = request.target_type
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeClusterBasicInfo',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeClusterBasicInfoResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_cluster_basic_info(
        self,
        request: sas_20181203_models.DescribeClusterBasicInfoRequest,
    ) -> sas_20181203_models.DescribeClusterBasicInfoResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_cluster_basic_info_with_options(request, runtime)

    async def describe_cluster_basic_info_async(
        self,
        request: sas_20181203_models.DescribeClusterBasicInfoRequest,
    ) -> sas_20181203_models.DescribeClusterBasicInfoResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_cluster_basic_info_with_options_async(request, runtime)

    def describe_cluster_info_list_with_options(
        self,
        request: sas_20181203_models.DescribeClusterInfoListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeClusterInfoListResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.target):
            query['Target'] = request.target
        if not UtilClient.is_unset(request.target_type):
            query['TargetType'] = request.target_type
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeClusterInfoList',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeClusterInfoListResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_cluster_info_list_with_options_async(
        self,
        request: sas_20181203_models.DescribeClusterInfoListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeClusterInfoListResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.target):
            query['Target'] = request.target
        if not UtilClient.is_unset(request.target_type):
            query['TargetType'] = request.target_type
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeClusterInfoList',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeClusterInfoListResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_cluster_info_list(
        self,
        request: sas_20181203_models.DescribeClusterInfoListRequest,
    ) -> sas_20181203_models.DescribeClusterInfoListResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_cluster_info_list_with_options(request, runtime)

    async def describe_cluster_info_list_async(
        self,
        request: sas_20181203_models.DescribeClusterInfoListRequest,
    ) -> sas_20181203_models.DescribeClusterInfoListResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_cluster_info_list_with_options_async(request, runtime)

    def describe_cluster_network_with_options(
        self,
        request: sas_20181203_models.DescribeClusterNetworkRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeClusterNetworkResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeClusterNetwork',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeClusterNetworkResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_cluster_network_with_options_async(
        self,
        request: sas_20181203_models.DescribeClusterNetworkRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeClusterNetworkResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeClusterNetwork',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeClusterNetworkResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_cluster_network(
        self,
        request: sas_20181203_models.DescribeClusterNetworkRequest,
    ) -> sas_20181203_models.DescribeClusterNetworkResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_cluster_network_with_options(request, runtime)

    async def describe_cluster_network_async(
        self,
        request: sas_20181203_models.DescribeClusterNetworkRequest,
    ) -> sas_20181203_models.DescribeClusterNetworkResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_cluster_network_with_options_async(request, runtime)

    def describe_cluster_vul_statistics_with_options(
        self,
        request: sas_20181203_models.DescribeClusterVulStatisticsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeClusterVulStatisticsResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cluster_id):
            query['ClusterId'] = request.cluster_id
        if not UtilClient.is_unset(request.types):
            query['Types'] = request.types
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeClusterVulStatistics',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeClusterVulStatisticsResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_cluster_vul_statistics_with_options_async(
        self,
        request: sas_20181203_models.DescribeClusterVulStatisticsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeClusterVulStatisticsResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cluster_id):
            query['ClusterId'] = request.cluster_id
        if not UtilClient.is_unset(request.types):
            query['Types'] = request.types
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeClusterVulStatistics',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeClusterVulStatisticsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_cluster_vul_statistics(
        self,
        request: sas_20181203_models.DescribeClusterVulStatisticsRequest,
    ) -> sas_20181203_models.DescribeClusterVulStatisticsResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_cluster_vul_statistics_with_options(request, runtime)

    async def describe_cluster_vul_statistics_async(
        self,
        request: sas_20181203_models.DescribeClusterVulStatisticsRequest,
    ) -> sas_20181203_models.DescribeClusterVulStatisticsResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_cluster_vul_statistics_with_options_async(request, runtime)

    def describe_common_overall_config_with_options(
        self,
        request: sas_20181203_models.DescribeCommonOverallConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeCommonOverallConfigResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeCommonOverallConfig',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeCommonOverallConfigResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_common_overall_config_with_options_async(
        self,
        request: sas_20181203_models.DescribeCommonOverallConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeCommonOverallConfigResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeCommonOverallConfig',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeCommonOverallConfigResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_common_overall_config(
        self,
        request: sas_20181203_models.DescribeCommonOverallConfigRequest,
    ) -> sas_20181203_models.DescribeCommonOverallConfigResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_common_overall_config_with_options(request, runtime)

    async def describe_common_overall_config_async(
        self,
        request: sas_20181203_models.DescribeCommonOverallConfigRequest,
    ) -> sas_20181203_models.DescribeCommonOverallConfigResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_common_overall_config_with_options_async(request, runtime)

    def describe_common_overall_config_list_with_options(
        self,
        request: sas_20181203_models.DescribeCommonOverallConfigListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeCommonOverallConfigListResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.type_list):
            query['TypeList'] = request.type_list
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeCommonOverallConfigList',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeCommonOverallConfigListResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_common_overall_config_list_with_options_async(
        self,
        request: sas_20181203_models.DescribeCommonOverallConfigListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeCommonOverallConfigListResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.type_list):
            query['TypeList'] = request.type_list
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeCommonOverallConfigList',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeCommonOverallConfigListResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_common_overall_config_list(
        self,
        request: sas_20181203_models.DescribeCommonOverallConfigListRequest,
    ) -> sas_20181203_models.DescribeCommonOverallConfigListResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_common_overall_config_list_with_options(request, runtime)

    async def describe_common_overall_config_list_async(
        self,
        request: sas_20181203_models.DescribeCommonOverallConfigListRequest,
    ) -> sas_20181203_models.DescribeCommonOverallConfigListResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_common_overall_config_list_with_options_async(request, runtime)

    def describe_common_target_config_with_options(
        self,
        request: sas_20181203_models.DescribeCommonTargetConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeCommonTargetConfigResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeCommonTargetConfig',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeCommonTargetConfigResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_common_target_config_with_options_async(
        self,
        request: sas_20181203_models.DescribeCommonTargetConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeCommonTargetConfigResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeCommonTargetConfig',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeCommonTargetConfigResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_common_target_config(
        self,
        request: sas_20181203_models.DescribeCommonTargetConfigRequest,
    ) -> sas_20181203_models.DescribeCommonTargetConfigResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_common_target_config_with_options(request, runtime)

    async def describe_common_target_config_async(
        self,
        request: sas_20181203_models.DescribeCommonTargetConfigRequest,
    ) -> sas_20181203_models.DescribeCommonTargetConfigResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_common_target_config_with_options_async(request, runtime)

    def describe_common_target_result_list_with_options(
        self,
        request: sas_20181203_models.DescribeCommonTargetResultListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeCommonTargetResultListResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeCommonTargetResultList',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeCommonTargetResultListResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_common_target_result_list_with_options_async(
        self,
        request: sas_20181203_models.DescribeCommonTargetResultListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeCommonTargetResultListResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeCommonTargetResultList',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeCommonTargetResultListResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_common_target_result_list(
        self,
        request: sas_20181203_models.DescribeCommonTargetResultListRequest,
    ) -> sas_20181203_models.DescribeCommonTargetResultListResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_common_target_result_list_with_options(request, runtime)

    async def describe_common_target_result_list_async(
        self,
        request: sas_20181203_models.DescribeCommonTargetResultListRequest,
    ) -> sas_20181203_models.DescribeCommonTargetResultListResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_common_target_result_list_with_options_async(request, runtime)

    def describe_concern_necessity_with_options(
        self,
        request: sas_20181203_models.DescribeConcernNecessityRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeConcernNecessityResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeConcernNecessity',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeConcernNecessityResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_concern_necessity_with_options_async(
        self,
        request: sas_20181203_models.DescribeConcernNecessityRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeConcernNecessityResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeConcernNecessity',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeConcernNecessityResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_concern_necessity(
        self,
        request: sas_20181203_models.DescribeConcernNecessityRequest,
    ) -> sas_20181203_models.DescribeConcernNecessityResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_concern_necessity_with_options(request, runtime)

    async def describe_concern_necessity_async(
        self,
        request: sas_20181203_models.DescribeConcernNecessityRequest,
    ) -> sas_20181203_models.DescribeConcernNecessityResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_concern_necessity_with_options_async(request, runtime)

    def describe_container_criteria_with_options(
        self,
        request: sas_20181203_models.DescribeContainerCriteriaRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeContainerCriteriaResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.group_field):
            query['GroupField'] = request.group_field
        if not UtilClient.is_unset(request.value):
            query['Value'] = request.value
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeContainerCriteria',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeContainerCriteriaResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_container_criteria_with_options_async(
        self,
        request: sas_20181203_models.DescribeContainerCriteriaRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeContainerCriteriaResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.group_field):
            query['GroupField'] = request.group_field
        if not UtilClient.is_unset(request.value):
            query['Value'] = request.value
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeContainerCriteria',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeContainerCriteriaResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_container_criteria(
        self,
        request: sas_20181203_models.DescribeContainerCriteriaRequest,
    ) -> sas_20181203_models.DescribeContainerCriteriaResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_container_criteria_with_options(request, runtime)

    async def describe_container_criteria_async(
        self,
        request: sas_20181203_models.DescribeContainerCriteriaRequest,
    ) -> sas_20181203_models.DescribeContainerCriteriaResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_container_criteria_with_options_async(request, runtime)

    def describe_container_instances_with_options(
        self,
        request: sas_20181203_models.DescribeContainerInstancesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeContainerInstancesResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.criteria):
            query['Criteria'] = request.criteria
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.logical_exp):
            query['LogicalExp'] = request.logical_exp
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeContainerInstances',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeContainerInstancesResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_container_instances_with_options_async(
        self,
        request: sas_20181203_models.DescribeContainerInstancesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeContainerInstancesResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.criteria):
            query['Criteria'] = request.criteria
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.logical_exp):
            query['LogicalExp'] = request.logical_exp
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeContainerInstances',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeContainerInstancesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_container_instances(
        self,
        request: sas_20181203_models.DescribeContainerInstancesRequest,
    ) -> sas_20181203_models.DescribeContainerInstancesResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_container_instances_with_options(request, runtime)

    async def describe_container_instances_async(
        self,
        request: sas_20181203_models.DescribeContainerInstancesRequest,
    ) -> sas_20181203_models.DescribeContainerInstancesResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_container_instances_with_options_async(request, runtime)

    def describe_container_statistics_with_options(
        self,
        request: sas_20181203_models.DescribeContainerStatisticsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeContainerStatisticsResponse:
        """
        Only users who created a Container Registry Enterprise Edition instance can call this operation.
        
        @param request: DescribeContainerStatisticsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeContainerStatisticsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cluster_id):
            query['ClusterId'] = request.cluster_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeContainerStatistics',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeContainerStatisticsResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_container_statistics_with_options_async(
        self,
        request: sas_20181203_models.DescribeContainerStatisticsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeContainerStatisticsResponse:
        """
        Only users who created a Container Registry Enterprise Edition instance can call this operation.
        
        @param request: DescribeContainerStatisticsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeContainerStatisticsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cluster_id):
            query['ClusterId'] = request.cluster_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeContainerStatistics',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeContainerStatisticsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_container_statistics(
        self,
        request: sas_20181203_models.DescribeContainerStatisticsRequest,
    ) -> sas_20181203_models.DescribeContainerStatisticsResponse:
        """
        Only users who created a Container Registry Enterprise Edition instance can call this operation.
        
        @param request: DescribeContainerStatisticsRequest
        @return: DescribeContainerStatisticsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_container_statistics_with_options(request, runtime)

    async def describe_container_statistics_async(
        self,
        request: sas_20181203_models.DescribeContainerStatisticsRequest,
    ) -> sas_20181203_models.DescribeContainerStatisticsResponse:
        """
        Only users who created a Container Registry Enterprise Edition instance can call this operation.
        
        @param request: DescribeContainerStatisticsRequest
        @return: DescribeContainerStatisticsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_container_statistics_with_options_async(request, runtime)

    def describe_count_not_scanned_image_with_options(
        self,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeCountNotScannedImageResponse:
        req = open_api_models.OpenApiRequest()
        params = open_api_models.Params(
            action='DescribeCountNotScannedImage',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeCountNotScannedImageResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_count_not_scanned_image_with_options_async(
        self,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeCountNotScannedImageResponse:
        req = open_api_models.OpenApiRequest()
        params = open_api_models.Params(
            action='DescribeCountNotScannedImage',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeCountNotScannedImageResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_count_not_scanned_image(self) -> sas_20181203_models.DescribeCountNotScannedImageResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_count_not_scanned_image_with_options(runtime)

    async def describe_count_not_scanned_image_async(self) -> sas_20181203_models.DescribeCountNotScannedImageResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_count_not_scanned_image_with_options_async(runtime)

    def describe_count_scanned_image_with_options(
        self,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeCountScannedImageResponse:
        req = open_api_models.OpenApiRequest()
        params = open_api_models.Params(
            action='DescribeCountScannedImage',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeCountScannedImageResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_count_scanned_image_with_options_async(
        self,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeCountScannedImageResponse:
        req = open_api_models.OpenApiRequest()
        params = open_api_models.Params(
            action='DescribeCountScannedImage',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeCountScannedImageResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_count_scanned_image(self) -> sas_20181203_models.DescribeCountScannedImageResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_count_scanned_image_with_options(runtime)

    async def describe_count_scanned_image_async(self) -> sas_20181203_models.DescribeCountScannedImageResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_count_scanned_image_with_options_async(runtime)

    def describe_criteria_with_options(
        self,
        request: sas_20181203_models.DescribeCriteriaRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeCriteriaResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.machine_types):
            query['MachineTypes'] = request.machine_types
        if not UtilClient.is_unset(request.support_auto_tag):
            query['SupportAutoTag'] = request.support_auto_tag
        if not UtilClient.is_unset(request.value):
            query['Value'] = request.value
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeCriteria',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeCriteriaResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_criteria_with_options_async(
        self,
        request: sas_20181203_models.DescribeCriteriaRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeCriteriaResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.machine_types):
            query['MachineTypes'] = request.machine_types
        if not UtilClient.is_unset(request.support_auto_tag):
            query['SupportAutoTag'] = request.support_auto_tag
        if not UtilClient.is_unset(request.value):
            query['Value'] = request.value
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeCriteria',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeCriteriaResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_criteria(
        self,
        request: sas_20181203_models.DescribeCriteriaRequest,
    ) -> sas_20181203_models.DescribeCriteriaResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_criteria_with_options(request, runtime)

    async def describe_criteria_async(
        self,
        request: sas_20181203_models.DescribeCriteriaRequest,
    ) -> sas_20181203_models.DescribeCriteriaResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_criteria_with_options_async(request, runtime)

    def describe_custom_block_records_with_options(
        self,
        request: sas_20181203_models.DescribeCustomBlockRecordsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeCustomBlockRecordsResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.block_ip):
            query['BlockIp'] = request.block_ip
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeCustomBlockRecords',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeCustomBlockRecordsResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_custom_block_records_with_options_async(
        self,
        request: sas_20181203_models.DescribeCustomBlockRecordsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeCustomBlockRecordsResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.block_ip):
            query['BlockIp'] = request.block_ip
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeCustomBlockRecords',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeCustomBlockRecordsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_custom_block_records(
        self,
        request: sas_20181203_models.DescribeCustomBlockRecordsRequest,
    ) -> sas_20181203_models.DescribeCustomBlockRecordsResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_custom_block_records_with_options(request, runtime)

    async def describe_custom_block_records_async(
        self,
        request: sas_20181203_models.DescribeCustomBlockRecordsRequest,
    ) -> sas_20181203_models.DescribeCustomBlockRecordsResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_custom_block_records_with_options_async(request, runtime)

    def describe_cycle_task_list_with_options(
        self,
        request: sas_20181203_models.DescribeCycleTaskListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeCycleTaskListResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.task_name):
            query['TaskName'] = request.task_name
        if not UtilClient.is_unset(request.task_type):
            query['TaskType'] = request.task_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeCycleTaskList',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeCycleTaskListResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_cycle_task_list_with_options_async(
        self,
        request: sas_20181203_models.DescribeCycleTaskListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeCycleTaskListResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.task_name):
            query['TaskName'] = request.task_name
        if not UtilClient.is_unset(request.task_type):
            query['TaskType'] = request.task_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeCycleTaskList',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeCycleTaskListResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_cycle_task_list(
        self,
        request: sas_20181203_models.DescribeCycleTaskListRequest,
    ) -> sas_20181203_models.DescribeCycleTaskListResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_cycle_task_list_with_options(request, runtime)

    async def describe_cycle_task_list_async(
        self,
        request: sas_20181203_models.DescribeCycleTaskListRequest,
    ) -> sas_20181203_models.DescribeCycleTaskListResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_cycle_task_list_with_options_async(request, runtime)

    def describe_ding_talk_with_options(
        self,
        request: sas_20181203_models.DescribeDingTalkRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeDingTalkResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.rule_action_name):
            query['RuleActionName'] = request.rule_action_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDingTalk',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeDingTalkResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_ding_talk_with_options_async(
        self,
        request: sas_20181203_models.DescribeDingTalkRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeDingTalkResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.rule_action_name):
            query['RuleActionName'] = request.rule_action_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDingTalk',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeDingTalkResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_ding_talk(
        self,
        request: sas_20181203_models.DescribeDingTalkRequest,
    ) -> sas_20181203_models.DescribeDingTalkResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_ding_talk_with_options(request, runtime)

    async def describe_ding_talk_async(
        self,
        request: sas_20181203_models.DescribeDingTalkRequest,
    ) -> sas_20181203_models.DescribeDingTalkResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_ding_talk_with_options_async(request, runtime)

    def describe_domain_count_with_options(
        self,
        request: sas_20181203_models.DescribeDomainCountRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeDomainCountResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDomainCount',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeDomainCountResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_domain_count_with_options_async(
        self,
        request: sas_20181203_models.DescribeDomainCountRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeDomainCountResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDomainCount',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeDomainCountResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_domain_count(
        self,
        request: sas_20181203_models.DescribeDomainCountRequest,
    ) -> sas_20181203_models.DescribeDomainCountResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_domain_count_with_options(request, runtime)

    async def describe_domain_count_async(
        self,
        request: sas_20181203_models.DescribeDomainCountRequest,
    ) -> sas_20181203_models.DescribeDomainCountResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_domain_count_with_options_async(request, runtime)

    def describe_domain_detail_with_options(
        self,
        request: sas_20181203_models.DescribeDomainDetailRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeDomainDetailResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.domain_name):
            query['DomainName'] = request.domain_name
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDomainDetail',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeDomainDetailResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_domain_detail_with_options_async(
        self,
        request: sas_20181203_models.DescribeDomainDetailRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeDomainDetailResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.domain_name):
            query['DomainName'] = request.domain_name
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDomainDetail',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeDomainDetailResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_domain_detail(
        self,
        request: sas_20181203_models.DescribeDomainDetailRequest,
    ) -> sas_20181203_models.DescribeDomainDetailResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_domain_detail_with_options(request, runtime)

    async def describe_domain_detail_async(
        self,
        request: sas_20181203_models.DescribeDomainDetailRequest,
    ) -> sas_20181203_models.DescribeDomainDetailResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_domain_detail_with_options_async(request, runtime)

    def describe_domain_list_with_options(
        self,
        request: sas_20181203_models.DescribeDomainListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeDomainListResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.domain_type):
            query['DomainType'] = request.domain_type
        if not UtilClient.is_unset(request.fuzzy_domain):
            query['FuzzyDomain'] = request.fuzzy_domain
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDomainList',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeDomainListResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_domain_list_with_options_async(
        self,
        request: sas_20181203_models.DescribeDomainListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeDomainListResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.domain_type):
            query['DomainType'] = request.domain_type
        if not UtilClient.is_unset(request.fuzzy_domain):
            query['FuzzyDomain'] = request.fuzzy_domain
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDomainList',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeDomainListResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_domain_list(
        self,
        request: sas_20181203_models.DescribeDomainListRequest,
    ) -> sas_20181203_models.DescribeDomainListResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_domain_list_with_options(request, runtime)

    async def describe_domain_list_async(
        self,
        request: sas_20181203_models.DescribeDomainListRequest,
    ) -> sas_20181203_models.DescribeDomainListResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_domain_list_with_options_async(request, runtime)

    def describe_emg_user_agreement_with_options(
        self,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeEmgUserAgreementResponse:
        req = open_api_models.OpenApiRequest()
        params = open_api_models.Params(
            action='DescribeEmgUserAgreement',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeEmgUserAgreementResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_emg_user_agreement_with_options_async(
        self,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeEmgUserAgreementResponse:
        req = open_api_models.OpenApiRequest()
        params = open_api_models.Params(
            action='DescribeEmgUserAgreement',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeEmgUserAgreementResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_emg_user_agreement(self) -> sas_20181203_models.DescribeEmgUserAgreementResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_emg_user_agreement_with_options(runtime)

    async def describe_emg_user_agreement_async(self) -> sas_20181203_models.DescribeEmgUserAgreementResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_emg_user_agreement_with_options_async(runtime)

    def describe_emg_vul_item_with_options(
        self,
        request: sas_20181203_models.DescribeEmgVulItemRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeEmgVulItemResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.check_type):
            query['CheckType'] = request.check_type
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.risk_status):
            query['RiskStatus'] = request.risk_status
        if not UtilClient.is_unset(request.scan_type):
            query['ScanType'] = request.scan_type
        if not UtilClient.is_unset(request.vul_name):
            query['VulName'] = request.vul_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeEmgVulItem',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeEmgVulItemResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_emg_vul_item_with_options_async(
        self,
        request: sas_20181203_models.DescribeEmgVulItemRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeEmgVulItemResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.check_type):
            query['CheckType'] = request.check_type
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.risk_status):
            query['RiskStatus'] = request.risk_status
        if not UtilClient.is_unset(request.scan_type):
            query['ScanType'] = request.scan_type
        if not UtilClient.is_unset(request.vul_name):
            query['VulName'] = request.vul_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeEmgVulItem',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeEmgVulItemResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_emg_vul_item(
        self,
        request: sas_20181203_models.DescribeEmgVulItemRequest,
    ) -> sas_20181203_models.DescribeEmgVulItemResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_emg_vul_item_with_options(request, runtime)

    async def describe_emg_vul_item_async(
        self,
        request: sas_20181203_models.DescribeEmgVulItemRequest,
    ) -> sas_20181203_models.DescribeEmgVulItemResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_emg_vul_item_with_options_async(request, runtime)

    def describe_event_level_count_with_options(
        self,
        request: sas_20181203_models.DescribeEventLevelCountRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeEventLevelCountResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cluster_id):
            query['ClusterId'] = request.cluster_id
        if not UtilClient.is_unset(request.container_field_name):
            query['ContainerFieldName'] = request.container_field_name
        if not UtilClient.is_unset(request.container_field_value):
            query['ContainerFieldValue'] = request.container_field_value
        if not UtilClient.is_unset(request.container_ids):
            query['ContainerIds'] = request.container_ids
        if not UtilClient.is_unset(request.from_):
            query['From'] = request.from_
        if not UtilClient.is_unset(request.target_type):
            query['TargetType'] = request.target_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeEventLevelCount',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeEventLevelCountResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_event_level_count_with_options_async(
        self,
        request: sas_20181203_models.DescribeEventLevelCountRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeEventLevelCountResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cluster_id):
            query['ClusterId'] = request.cluster_id
        if not UtilClient.is_unset(request.container_field_name):
            query['ContainerFieldName'] = request.container_field_name
        if not UtilClient.is_unset(request.container_field_value):
            query['ContainerFieldValue'] = request.container_field_value
        if not UtilClient.is_unset(request.container_ids):
            query['ContainerIds'] = request.container_ids
        if not UtilClient.is_unset(request.from_):
            query['From'] = request.from_
        if not UtilClient.is_unset(request.target_type):
            query['TargetType'] = request.target_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeEventLevelCount',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeEventLevelCountResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_event_level_count(
        self,
        request: sas_20181203_models.DescribeEventLevelCountRequest,
    ) -> sas_20181203_models.DescribeEventLevelCountResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_event_level_count_with_options(request, runtime)

    async def describe_event_level_count_async(
        self,
        request: sas_20181203_models.DescribeEventLevelCountRequest,
    ) -> sas_20181203_models.DescribeEventLevelCountResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_event_level_count_with_options_async(request, runtime)

    def describe_event_on_stage_with_options(
        self,
        request: sas_20181203_models.DescribeEventOnStageRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeEventOnStageResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeEventOnStage',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeEventOnStageResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_event_on_stage_with_options_async(
        self,
        request: sas_20181203_models.DescribeEventOnStageRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeEventOnStageResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeEventOnStage',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeEventOnStageResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_event_on_stage(
        self,
        request: sas_20181203_models.DescribeEventOnStageRequest,
    ) -> sas_20181203_models.DescribeEventOnStageResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_event_on_stage_with_options(request, runtime)

    async def describe_event_on_stage_async(
        self,
        request: sas_20181203_models.DescribeEventOnStageRequest,
    ) -> sas_20181203_models.DescribeEventOnStageResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_event_on_stage_with_options_async(request, runtime)

    def describe_exclude_system_path_with_options(
        self,
        request: sas_20181203_models.DescribeExcludeSystemPathRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeExcludeSystemPathResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeExcludeSystemPath',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeExcludeSystemPathResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_exclude_system_path_with_options_async(
        self,
        request: sas_20181203_models.DescribeExcludeSystemPathRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeExcludeSystemPathResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeExcludeSystemPath',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeExcludeSystemPathResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_exclude_system_path(
        self,
        request: sas_20181203_models.DescribeExcludeSystemPathRequest,
    ) -> sas_20181203_models.DescribeExcludeSystemPathResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_exclude_system_path_with_options(request, runtime)

    async def describe_exclude_system_path_async(
        self,
        request: sas_20181203_models.DescribeExcludeSystemPathRequest,
    ) -> sas_20181203_models.DescribeExcludeSystemPathResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_exclude_system_path_with_options_async(request, runtime)

    def describe_export_info_with_options(
        self,
        request: sas_20181203_models.DescribeExportInfoRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeExportInfoResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.export_id):
            query['ExportId'] = request.export_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeExportInfo',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeExportInfoResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_export_info_with_options_async(
        self,
        request: sas_20181203_models.DescribeExportInfoRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeExportInfoResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.export_id):
            query['ExportId'] = request.export_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeExportInfo',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeExportInfoResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_export_info(
        self,
        request: sas_20181203_models.DescribeExportInfoRequest,
    ) -> sas_20181203_models.DescribeExportInfoResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_export_info_with_options(request, runtime)

    async def describe_export_info_async(
        self,
        request: sas_20181203_models.DescribeExportInfoRequest,
    ) -> sas_20181203_models.DescribeExportInfoResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_export_info_with_options_async(request, runtime)

    def describe_exposed_check_warning_with_options(
        self,
        request: sas_20181203_models.DescribeExposedCheckWarningRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeExposedCheckWarningResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.type_name):
            query['TypeName'] = request.type_name
        if not UtilClient.is_unset(request.uuids):
            query['Uuids'] = request.uuids
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeExposedCheckWarning',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeExposedCheckWarningResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_exposed_check_warning_with_options_async(
        self,
        request: sas_20181203_models.DescribeExposedCheckWarningRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeExposedCheckWarningResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.type_name):
            query['TypeName'] = request.type_name
        if not UtilClient.is_unset(request.uuids):
            query['Uuids'] = request.uuids
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeExposedCheckWarning',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeExposedCheckWarningResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_exposed_check_warning(
        self,
        request: sas_20181203_models.DescribeExposedCheckWarningRequest,
    ) -> sas_20181203_models.DescribeExposedCheckWarningResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_exposed_check_warning_with_options(request, runtime)

    async def describe_exposed_check_warning_async(
        self,
        request: sas_20181203_models.DescribeExposedCheckWarningRequest,
    ) -> sas_20181203_models.DescribeExposedCheckWarningResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_exposed_check_warning_with_options_async(request, runtime)

    def describe_exposed_instance_criteria_with_options(
        self,
        request: sas_20181203_models.DescribeExposedInstanceCriteriaRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeExposedInstanceCriteriaResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.value):
            query['Value'] = request.value
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeExposedInstanceCriteria',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeExposedInstanceCriteriaResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_exposed_instance_criteria_with_options_async(
        self,
        request: sas_20181203_models.DescribeExposedInstanceCriteriaRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeExposedInstanceCriteriaResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.value):
            query['Value'] = request.value
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeExposedInstanceCriteria',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeExposedInstanceCriteriaResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_exposed_instance_criteria(
        self,
        request: sas_20181203_models.DescribeExposedInstanceCriteriaRequest,
    ) -> sas_20181203_models.DescribeExposedInstanceCriteriaResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_exposed_instance_criteria_with_options(request, runtime)

    async def describe_exposed_instance_criteria_async(
        self,
        request: sas_20181203_models.DescribeExposedInstanceCriteriaRequest,
    ) -> sas_20181203_models.DescribeExposedInstanceCriteriaResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_exposed_instance_criteria_with_options_async(request, runtime)

    def describe_exposed_instance_detail_with_options(
        self,
        request: sas_20181203_models.DescribeExposedInstanceDetailRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeExposedInstanceDetailResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.uuid):
            query['Uuid'] = request.uuid
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeExposedInstanceDetail',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeExposedInstanceDetailResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_exposed_instance_detail_with_options_async(
        self,
        request: sas_20181203_models.DescribeExposedInstanceDetailRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeExposedInstanceDetailResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.uuid):
            query['Uuid'] = request.uuid
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeExposedInstanceDetail',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeExposedInstanceDetailResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_exposed_instance_detail(
        self,
        request: sas_20181203_models.DescribeExposedInstanceDetailRequest,
    ) -> sas_20181203_models.DescribeExposedInstanceDetailResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_exposed_instance_detail_with_options(request, runtime)

    async def describe_exposed_instance_detail_async(
        self,
        request: sas_20181203_models.DescribeExposedInstanceDetailRequest,
    ) -> sas_20181203_models.DescribeExposedInstanceDetailResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_exposed_instance_detail_with_options_async(request, runtime)

    def describe_exposed_instance_list_with_options(
        self,
        request: sas_20181203_models.DescribeExposedInstanceListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeExposedInstanceListResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.exposure_component):
            query['ExposureComponent'] = request.exposure_component
        if not UtilClient.is_unset(request.exposure_ip):
            query['ExposureIp'] = request.exposure_ip
        if not UtilClient.is_unset(request.exposure_port):
            query['ExposurePort'] = request.exposure_port
        if not UtilClient.is_unset(request.group_id):
            query['GroupId'] = request.group_id
        if not UtilClient.is_unset(request.health_status):
            query['HealthStatus'] = request.health_status
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.instance_name):
            query['InstanceName'] = request.instance_name
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.vul_status):
            query['VulStatus'] = request.vul_status
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeExposedInstanceList',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeExposedInstanceListResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_exposed_instance_list_with_options_async(
        self,
        request: sas_20181203_models.DescribeExposedInstanceListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeExposedInstanceListResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.exposure_component):
            query['ExposureComponent'] = request.exposure_component
        if not UtilClient.is_unset(request.exposure_ip):
            query['ExposureIp'] = request.exposure_ip
        if not UtilClient.is_unset(request.exposure_port):
            query['ExposurePort'] = request.exposure_port
        if not UtilClient.is_unset(request.group_id):
            query['GroupId'] = request.group_id
        if not UtilClient.is_unset(request.health_status):
            query['HealthStatus'] = request.health_status
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.instance_name):
            query['InstanceName'] = request.instance_name
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.vul_status):
            query['VulStatus'] = request.vul_status
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeExposedInstanceList',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeExposedInstanceListResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_exposed_instance_list(
        self,
        request: sas_20181203_models.DescribeExposedInstanceListRequest,
    ) -> sas_20181203_models.DescribeExposedInstanceListResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_exposed_instance_list_with_options(request, runtime)

    async def describe_exposed_instance_list_async(
        self,
        request: sas_20181203_models.DescribeExposedInstanceListRequest,
    ) -> sas_20181203_models.DescribeExposedInstanceListResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_exposed_instance_list_with_options_async(request, runtime)

    def describe_exposed_statistics_with_options(
        self,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeExposedStatisticsResponse:
        req = open_api_models.OpenApiRequest()
        params = open_api_models.Params(
            action='DescribeExposedStatistics',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeExposedStatisticsResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_exposed_statistics_with_options_async(
        self,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeExposedStatisticsResponse:
        req = open_api_models.OpenApiRequest()
        params = open_api_models.Params(
            action='DescribeExposedStatistics',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeExposedStatisticsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_exposed_statistics(self) -> sas_20181203_models.DescribeExposedStatisticsResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_exposed_statistics_with_options(runtime)

    async def describe_exposed_statistics_async(self) -> sas_20181203_models.DescribeExposedStatisticsResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_exposed_statistics_with_options_async(runtime)

    def describe_exposed_statistics_detail_with_options(
        self,
        request: sas_20181203_models.DescribeExposedStatisticsDetailRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeExposedStatisticsDetailResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.statistics_type):
            query['StatisticsType'] = request.statistics_type
        if not UtilClient.is_unset(request.statistics_type_gateway_type):
            query['StatisticsTypeGatewayType'] = request.statistics_type_gateway_type
        if not UtilClient.is_unset(request.statistics_type_instance_value):
            query['StatisticsTypeInstanceValue'] = request.statistics_type_instance_value
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeExposedStatisticsDetail',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeExposedStatisticsDetailResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_exposed_statistics_detail_with_options_async(
        self,
        request: sas_20181203_models.DescribeExposedStatisticsDetailRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeExposedStatisticsDetailResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.statistics_type):
            query['StatisticsType'] = request.statistics_type
        if not UtilClient.is_unset(request.statistics_type_gateway_type):
            query['StatisticsTypeGatewayType'] = request.statistics_type_gateway_type
        if not UtilClient.is_unset(request.statistics_type_instance_value):
            query['StatisticsTypeInstanceValue'] = request.statistics_type_instance_value
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeExposedStatisticsDetail',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeExposedStatisticsDetailResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_exposed_statistics_detail(
        self,
        request: sas_20181203_models.DescribeExposedStatisticsDetailRequest,
    ) -> sas_20181203_models.DescribeExposedStatisticsDetailResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_exposed_statistics_detail_with_options(request, runtime)

    async def describe_exposed_statistics_detail_async(
        self,
        request: sas_20181203_models.DescribeExposedStatisticsDetailRequest,
    ) -> sas_20181203_models.DescribeExposedStatisticsDetailResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_exposed_statistics_detail_with_options_async(request, runtime)

    def describe_field_statistics_with_options(
        self,
        request: sas_20181203_models.DescribeFieldStatisticsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeFieldStatisticsResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.machine_types):
            query['MachineTypes'] = request.machine_types
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeFieldStatistics',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeFieldStatisticsResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_field_statistics_with_options_async(
        self,
        request: sas_20181203_models.DescribeFieldStatisticsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeFieldStatisticsResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.machine_types):
            query['MachineTypes'] = request.machine_types
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeFieldStatistics',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeFieldStatisticsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_field_statistics(
        self,
        request: sas_20181203_models.DescribeFieldStatisticsRequest,
    ) -> sas_20181203_models.DescribeFieldStatisticsResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_field_statistics_with_options(request, runtime)

    async def describe_field_statistics_async(
        self,
        request: sas_20181203_models.DescribeFieldStatisticsRequest,
    ) -> sas_20181203_models.DescribeFieldStatisticsResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_field_statistics_with_options_async(request, runtime)

    def describe_front_vul_patch_list_with_options(
        self,
        request: sas_20181203_models.DescribeFrontVulPatchListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeFrontVulPatchListResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.info):
            query['Info'] = request.info
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.operate_type):
            query['OperateType'] = request.operate_type
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeFrontVulPatchList',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeFrontVulPatchListResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_front_vul_patch_list_with_options_async(
        self,
        request: sas_20181203_models.DescribeFrontVulPatchListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeFrontVulPatchListResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.info):
            query['Info'] = request.info
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.operate_type):
            query['OperateType'] = request.operate_type
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeFrontVulPatchList',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeFrontVulPatchListResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_front_vul_patch_list(
        self,
        request: sas_20181203_models.DescribeFrontVulPatchListRequest,
    ) -> sas_20181203_models.DescribeFrontVulPatchListResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_front_vul_patch_list_with_options(request, runtime)

    async def describe_front_vul_patch_list_async(
        self,
        request: sas_20181203_models.DescribeFrontVulPatchListRequest,
    ) -> sas_20181203_models.DescribeFrontVulPatchListResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_front_vul_patch_list_with_options_async(request, runtime)

    def describe_grouped_container_instances_with_options(
        self,
        request: sas_20181203_models.DescribeGroupedContainerInstancesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeGroupedContainerInstancesResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.criteria):
            query['Criteria'] = request.criteria
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.field_value):
            query['FieldValue'] = request.field_value
        if not UtilClient.is_unset(request.group_field):
            query['GroupField'] = request.group_field
        if not UtilClient.is_unset(request.logical_exp):
            query['LogicalExp'] = request.logical_exp
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeGroupedContainerInstances',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeGroupedContainerInstancesResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_grouped_container_instances_with_options_async(
        self,
        request: sas_20181203_models.DescribeGroupedContainerInstancesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeGroupedContainerInstancesResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.criteria):
            query['Criteria'] = request.criteria
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.field_value):
            query['FieldValue'] = request.field_value
        if not UtilClient.is_unset(request.group_field):
            query['GroupField'] = request.group_field
        if not UtilClient.is_unset(request.logical_exp):
            query['LogicalExp'] = request.logical_exp
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeGroupedContainerInstances',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeGroupedContainerInstancesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_grouped_container_instances(
        self,
        request: sas_20181203_models.DescribeGroupedContainerInstancesRequest,
    ) -> sas_20181203_models.DescribeGroupedContainerInstancesResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_grouped_container_instances_with_options(request, runtime)

    async def describe_grouped_container_instances_async(
        self,
        request: sas_20181203_models.DescribeGroupedContainerInstancesRequest,
    ) -> sas_20181203_models.DescribeGroupedContainerInstancesResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_grouped_container_instances_with_options_async(request, runtime)

    def describe_grouped_instances_with_options(
        self,
        request: sas_20181203_models.DescribeGroupedInstancesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeGroupedInstancesResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.field_value):
            query['FieldValue'] = request.field_value
        if not UtilClient.is_unset(request.group_field):
            query['GroupField'] = request.group_field
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.machine_types):
            query['MachineTypes'] = request.machine_types
        if not UtilClient.is_unset(request.no_page):
            query['NoPage'] = request.no_page
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.vendor):
            query['Vendor'] = request.vendor
        if not UtilClient.is_unset(request.vendors):
            query['Vendors'] = request.vendors
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeGroupedInstances',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeGroupedInstancesResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_grouped_instances_with_options_async(
        self,
        request: sas_20181203_models.DescribeGroupedInstancesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeGroupedInstancesResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.field_value):
            query['FieldValue'] = request.field_value
        if not UtilClient.is_unset(request.group_field):
            query['GroupField'] = request.group_field
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.machine_types):
            query['MachineTypes'] = request.machine_types
        if not UtilClient.is_unset(request.no_page):
            query['NoPage'] = request.no_page
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.vendor):
            query['Vendor'] = request.vendor
        if not UtilClient.is_unset(request.vendors):
            query['Vendors'] = request.vendors
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeGroupedInstances',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeGroupedInstancesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_grouped_instances(
        self,
        request: sas_20181203_models.DescribeGroupedInstancesRequest,
    ) -> sas_20181203_models.DescribeGroupedInstancesResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_grouped_instances_with_options(request, runtime)

    async def describe_grouped_instances_async(
        self,
        request: sas_20181203_models.DescribeGroupedInstancesRequest,
    ) -> sas_20181203_models.DescribeGroupedInstancesResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_grouped_instances_with_options_async(request, runtime)

    def describe_grouped_malicious_files_with_options(
        self,
        request: sas_20181203_models.DescribeGroupedMaliciousFilesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeGroupedMaliciousFilesResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cluster_id):
            query['ClusterId'] = request.cluster_id
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.fuzzy_malicious_name):
            query['FuzzyMaliciousName'] = request.fuzzy_malicious_name
        if not UtilClient.is_unset(request.image_digest):
            query['ImageDigest'] = request.image_digest
        if not UtilClient.is_unset(request.image_layer):
            query['ImageLayer'] = request.image_layer
        if not UtilClient.is_unset(request.image_tag):
            query['ImageTag'] = request.image_tag
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.levels):
            query['Levels'] = request.levels
        if not UtilClient.is_unset(request.malicious_md_5):
            query['MaliciousMd5'] = request.malicious_md_5
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.repo_id):
            query['RepoId'] = request.repo_id
        if not UtilClient.is_unset(request.repo_instance_id):
            query['RepoInstanceId'] = request.repo_instance_id
        if not UtilClient.is_unset(request.repo_name):
            query['RepoName'] = request.repo_name
        if not UtilClient.is_unset(request.repo_namespace):
            query['RepoNamespace'] = request.repo_namespace
        if not UtilClient.is_unset(request.repo_region_id):
            query['RepoRegionId'] = request.repo_region_id
        if not UtilClient.is_unset(request.scan_range):
            query['ScanRange'] = request.scan_range
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeGroupedMaliciousFiles',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeGroupedMaliciousFilesResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_grouped_malicious_files_with_options_async(
        self,
        request: sas_20181203_models.DescribeGroupedMaliciousFilesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeGroupedMaliciousFilesResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cluster_id):
            query['ClusterId'] = request.cluster_id
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.fuzzy_malicious_name):
            query['FuzzyMaliciousName'] = request.fuzzy_malicious_name
        if not UtilClient.is_unset(request.image_digest):
            query['ImageDigest'] = request.image_digest
        if not UtilClient.is_unset(request.image_layer):
            query['ImageLayer'] = request.image_layer
        if not UtilClient.is_unset(request.image_tag):
            query['ImageTag'] = request.image_tag
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.levels):
            query['Levels'] = request.levels
        if not UtilClient.is_unset(request.malicious_md_5):
            query['MaliciousMd5'] = request.malicious_md_5
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.repo_id):
            query['RepoId'] = request.repo_id
        if not UtilClient.is_unset(request.repo_instance_id):
            query['RepoInstanceId'] = request.repo_instance_id
        if not UtilClient.is_unset(request.repo_name):
            query['RepoName'] = request.repo_name
        if not UtilClient.is_unset(request.repo_namespace):
            query['RepoNamespace'] = request.repo_namespace
        if not UtilClient.is_unset(request.repo_region_id):
            query['RepoRegionId'] = request.repo_region_id
        if not UtilClient.is_unset(request.scan_range):
            query['ScanRange'] = request.scan_range
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeGroupedMaliciousFiles',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeGroupedMaliciousFilesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_grouped_malicious_files(
        self,
        request: sas_20181203_models.DescribeGroupedMaliciousFilesRequest,
    ) -> sas_20181203_models.DescribeGroupedMaliciousFilesResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_grouped_malicious_files_with_options(request, runtime)

    async def describe_grouped_malicious_files_async(
        self,
        request: sas_20181203_models.DescribeGroupedMaliciousFilesRequest,
    ) -> sas_20181203_models.DescribeGroupedMaliciousFilesResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_grouped_malicious_files_with_options_async(request, runtime)

    def describe_grouped_tags_with_options(
        self,
        request: sas_20181203_models.DescribeGroupedTagsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeGroupedTagsResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.machine_types):
            query['MachineTypes'] = request.machine_types
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeGroupedTags',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeGroupedTagsResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_grouped_tags_with_options_async(
        self,
        request: sas_20181203_models.DescribeGroupedTagsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeGroupedTagsResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.machine_types):
            query['MachineTypes'] = request.machine_types
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeGroupedTags',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeGroupedTagsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_grouped_tags(
        self,
        request: sas_20181203_models.DescribeGroupedTagsRequest,
    ) -> sas_20181203_models.DescribeGroupedTagsResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_grouped_tags_with_options(request, runtime)

    async def describe_grouped_tags_async(
        self,
        request: sas_20181203_models.DescribeGroupedTagsRequest,
    ) -> sas_20181203_models.DescribeGroupedTagsResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_grouped_tags_with_options_async(request, runtime)

    def describe_grouped_vul_with_options(
        self,
        request: sas_20181203_models.DescribeGroupedVulRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeGroupedVulResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.alias_name):
            query['AliasName'] = request.alias_name
        if not UtilClient.is_unset(request.attach_types):
            query['AttachTypes'] = request.attach_types
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.dealed):
            query['Dealed'] = request.dealed
        if not UtilClient.is_unset(request.group_id):
            query['GroupId'] = request.group_id
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.necessity):
            query['Necessity'] = request.necessity
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.search_tags):
            query['SearchTags'] = request.search_tags
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        if not UtilClient.is_unset(request.uuids):
            query['Uuids'] = request.uuids
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeGroupedVul',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeGroupedVulResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_grouped_vul_with_options_async(
        self,
        request: sas_20181203_models.DescribeGroupedVulRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeGroupedVulResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.alias_name):
            query['AliasName'] = request.alias_name
        if not UtilClient.is_unset(request.attach_types):
            query['AttachTypes'] = request.attach_types
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.dealed):
            query['Dealed'] = request.dealed
        if not UtilClient.is_unset(request.group_id):
            query['GroupId'] = request.group_id
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.necessity):
            query['Necessity'] = request.necessity
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.search_tags):
            query['SearchTags'] = request.search_tags
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        if not UtilClient.is_unset(request.uuids):
            query['Uuids'] = request.uuids
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeGroupedVul',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeGroupedVulResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_grouped_vul(
        self,
        request: sas_20181203_models.DescribeGroupedVulRequest,
    ) -> sas_20181203_models.DescribeGroupedVulResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_grouped_vul_with_options(request, runtime)

    async def describe_grouped_vul_async(
        self,
        request: sas_20181203_models.DescribeGroupedVulRequest,
    ) -> sas_20181203_models.DescribeGroupedVulResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_grouped_vul_with_options_async(request, runtime)

    def describe_hc_export_info_with_options(
        self,
        request: sas_20181203_models.DescribeHcExportInfoRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeHcExportInfoResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.export_id):
            query['ExportId'] = request.export_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeHcExportInfo',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeHcExportInfoResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_hc_export_info_with_options_async(
        self,
        request: sas_20181203_models.DescribeHcExportInfoRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeHcExportInfoResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.export_id):
            query['ExportId'] = request.export_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeHcExportInfo',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeHcExportInfoResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_hc_export_info(
        self,
        request: sas_20181203_models.DescribeHcExportInfoRequest,
    ) -> sas_20181203_models.DescribeHcExportInfoResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_hc_export_info_with_options(request, runtime)

    async def describe_hc_export_info_async(
        self,
        request: sas_20181203_models.DescribeHcExportInfoRequest,
    ) -> sas_20181203_models.DescribeHcExportInfoResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_hc_export_info_with_options_async(request, runtime)

    def describe_honey_pot_auth_with_options(
        self,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeHoneyPotAuthResponse:
        req = open_api_models.OpenApiRequest()
        params = open_api_models.Params(
            action='DescribeHoneyPotAuth',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeHoneyPotAuthResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_honey_pot_auth_with_options_async(
        self,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeHoneyPotAuthResponse:
        req = open_api_models.OpenApiRequest()
        params = open_api_models.Params(
            action='DescribeHoneyPotAuth',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeHoneyPotAuthResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_honey_pot_auth(self) -> sas_20181203_models.DescribeHoneyPotAuthResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_honey_pot_auth_with_options(runtime)

    async def describe_honey_pot_auth_async(self) -> sas_20181203_models.DescribeHoneyPotAuthResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_honey_pot_auth_with_options_async(runtime)

    def describe_honey_pot_susp_statistics_with_options(
        self,
        request: sas_20181203_models.DescribeHoneyPotSuspStatisticsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeHoneyPotSuspStatisticsResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.from_):
            query['From'] = request.from_
        if not UtilClient.is_unset(request.statistics_days):
            query['StatisticsDays'] = request.statistics_days
        if not UtilClient.is_unset(request.statistics_key_type):
            query['StatisticsKeyType'] = request.statistics_key_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeHoneyPotSuspStatistics',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeHoneyPotSuspStatisticsResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_honey_pot_susp_statistics_with_options_async(
        self,
        request: sas_20181203_models.DescribeHoneyPotSuspStatisticsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeHoneyPotSuspStatisticsResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.from_):
            query['From'] = request.from_
        if not UtilClient.is_unset(request.statistics_days):
            query['StatisticsDays'] = request.statistics_days
        if not UtilClient.is_unset(request.statistics_key_type):
            query['StatisticsKeyType'] = request.statistics_key_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeHoneyPotSuspStatistics',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeHoneyPotSuspStatisticsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_honey_pot_susp_statistics(
        self,
        request: sas_20181203_models.DescribeHoneyPotSuspStatisticsRequest,
    ) -> sas_20181203_models.DescribeHoneyPotSuspStatisticsResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_honey_pot_susp_statistics_with_options(request, runtime)

    async def describe_honey_pot_susp_statistics_async(
        self,
        request: sas_20181203_models.DescribeHoneyPotSuspStatisticsRequest,
    ) -> sas_20181203_models.DescribeHoneyPotSuspStatisticsResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_honey_pot_susp_statistics_with_options_async(request, runtime)

    def describe_image_with_options(
        self,
        request: sas_20181203_models.DescribeImageRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeImageResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.image_instance_id):
            query['ImageInstanceId'] = request.image_instance_id
        if not UtilClient.is_unset(request.image_region_id):
            query['ImageRegionId'] = request.image_region_id
        if not UtilClient.is_unset(request.image_repo_id):
            query['ImageRepoId'] = request.image_repo_id
        if not UtilClient.is_unset(request.image_tag):
            query['ImageTag'] = request.image_tag
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeImage',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeImageResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_image_with_options_async(
        self,
        request: sas_20181203_models.DescribeImageRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeImageResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.image_instance_id):
            query['ImageInstanceId'] = request.image_instance_id
        if not UtilClient.is_unset(request.image_region_id):
            query['ImageRegionId'] = request.image_region_id
        if not UtilClient.is_unset(request.image_repo_id):
            query['ImageRepoId'] = request.image_repo_id
        if not UtilClient.is_unset(request.image_tag):
            query['ImageTag'] = request.image_tag
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeImage',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeImageResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_image(
        self,
        request: sas_20181203_models.DescribeImageRequest,
    ) -> sas_20181203_models.DescribeImageResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_image_with_options(request, runtime)

    async def describe_image_async(
        self,
        request: sas_20181203_models.DescribeImageRequest,
    ) -> sas_20181203_models.DescribeImageResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_image_with_options_async(request, runtime)

    def describe_image_baseline_check_result_with_options(
        self,
        request: sas_20181203_models.DescribeImageBaselineCheckResultRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeImageBaselineCheckResultResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.criteria):
            query['Criteria'] = request.criteria
        if not UtilClient.is_unset(request.criteria_type):
            query['CriteriaType'] = request.criteria_type
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.image_uuid):
            query['ImageUuid'] = request.image_uuid
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.risk_level):
            query['RiskLevel'] = request.risk_level
        if not UtilClient.is_unset(request.scan_range):
            query['ScanRange'] = request.scan_range
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeImageBaselineCheckResult',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeImageBaselineCheckResultResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_image_baseline_check_result_with_options_async(
        self,
        request: sas_20181203_models.DescribeImageBaselineCheckResultRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeImageBaselineCheckResultResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.criteria):
            query['Criteria'] = request.criteria
        if not UtilClient.is_unset(request.criteria_type):
            query['CriteriaType'] = request.criteria_type
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.image_uuid):
            query['ImageUuid'] = request.image_uuid
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.risk_level):
            query['RiskLevel'] = request.risk_level
        if not UtilClient.is_unset(request.scan_range):
            query['ScanRange'] = request.scan_range
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeImageBaselineCheckResult',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeImageBaselineCheckResultResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_image_baseline_check_result(
        self,
        request: sas_20181203_models.DescribeImageBaselineCheckResultRequest,
    ) -> sas_20181203_models.DescribeImageBaselineCheckResultResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_image_baseline_check_result_with_options(request, runtime)

    async def describe_image_baseline_check_result_async(
        self,
        request: sas_20181203_models.DescribeImageBaselineCheckResultRequest,
    ) -> sas_20181203_models.DescribeImageBaselineCheckResultResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_image_baseline_check_result_with_options_async(request, runtime)

    def describe_image_baseline_check_summary_with_options(
        self,
        request: sas_20181203_models.DescribeImageBaselineCheckSummaryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeImageBaselineCheckSummaryResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cluster_id):
            query['ClusterId'] = request.cluster_id
        if not UtilClient.is_unset(request.criteria):
            query['Criteria'] = request.criteria
        if not UtilClient.is_unset(request.criteria_type):
            query['CriteriaType'] = request.criteria_type
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.risk_level):
            query['RiskLevel'] = request.risk_level
        if not UtilClient.is_unset(request.scan_range):
            query['ScanRange'] = request.scan_range
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeImageBaselineCheckSummary',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeImageBaselineCheckSummaryResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_image_baseline_check_summary_with_options_async(
        self,
        request: sas_20181203_models.DescribeImageBaselineCheckSummaryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeImageBaselineCheckSummaryResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cluster_id):
            query['ClusterId'] = request.cluster_id
        if not UtilClient.is_unset(request.criteria):
            query['Criteria'] = request.criteria
        if not UtilClient.is_unset(request.criteria_type):
            query['CriteriaType'] = request.criteria_type
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.risk_level):
            query['RiskLevel'] = request.risk_level
        if not UtilClient.is_unset(request.scan_range):
            query['ScanRange'] = request.scan_range
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeImageBaselineCheckSummary',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeImageBaselineCheckSummaryResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_image_baseline_check_summary(
        self,
        request: sas_20181203_models.DescribeImageBaselineCheckSummaryRequest,
    ) -> sas_20181203_models.DescribeImageBaselineCheckSummaryResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_image_baseline_check_summary_with_options(request, runtime)

    async def describe_image_baseline_check_summary_async(
        self,
        request: sas_20181203_models.DescribeImageBaselineCheckSummaryRequest,
    ) -> sas_20181203_models.DescribeImageBaselineCheckSummaryResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_image_baseline_check_summary_with_options_async(request, runtime)

    def describe_image_baseline_detail_with_options(
        self,
        request: sas_20181203_models.DescribeImageBaselineDetailRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeImageBaselineDetailResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.baseline_item_key):
            query['BaselineItemKey'] = request.baseline_item_key
        if not UtilClient.is_unset(request.image_uuid):
            query['ImageUuid'] = request.image_uuid
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeImageBaselineDetail',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeImageBaselineDetailResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_image_baseline_detail_with_options_async(
        self,
        request: sas_20181203_models.DescribeImageBaselineDetailRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeImageBaselineDetailResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.baseline_item_key):
            query['BaselineItemKey'] = request.baseline_item_key
        if not UtilClient.is_unset(request.image_uuid):
            query['ImageUuid'] = request.image_uuid
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeImageBaselineDetail',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeImageBaselineDetailResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_image_baseline_detail(
        self,
        request: sas_20181203_models.DescribeImageBaselineDetailRequest,
    ) -> sas_20181203_models.DescribeImageBaselineDetailResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_image_baseline_detail_with_options(request, runtime)

    async def describe_image_baseline_detail_async(
        self,
        request: sas_20181203_models.DescribeImageBaselineDetailRequest,
    ) -> sas_20181203_models.DescribeImageBaselineDetailResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_image_baseline_detail_with_options_async(request, runtime)

    def describe_image_baseline_item_list_with_options(
        self,
        request: sas_20181203_models.DescribeImageBaselineItemListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeImageBaselineItemListResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.baseline_class_key):
            query['BaselineClassKey'] = request.baseline_class_key
        if not UtilClient.is_unset(request.baseline_name_key):
            query['BaselineNameKey'] = request.baseline_name_key
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.image_uuid):
            query['ImageUuid'] = request.image_uuid
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.scan_range):
            query['ScanRange'] = request.scan_range
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        if not UtilClient.is_unset(request.uuids):
            query['Uuids'] = request.uuids
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeImageBaselineItemList',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeImageBaselineItemListResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_image_baseline_item_list_with_options_async(
        self,
        request: sas_20181203_models.DescribeImageBaselineItemListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeImageBaselineItemListResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.baseline_class_key):
            query['BaselineClassKey'] = request.baseline_class_key
        if not UtilClient.is_unset(request.baseline_name_key):
            query['BaselineNameKey'] = request.baseline_name_key
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.image_uuid):
            query['ImageUuid'] = request.image_uuid
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.scan_range):
            query['ScanRange'] = request.scan_range
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        if not UtilClient.is_unset(request.uuids):
            query['Uuids'] = request.uuids
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeImageBaselineItemList',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeImageBaselineItemListResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_image_baseline_item_list(
        self,
        request: sas_20181203_models.DescribeImageBaselineItemListRequest,
    ) -> sas_20181203_models.DescribeImageBaselineItemListResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_image_baseline_item_list_with_options(request, runtime)

    async def describe_image_baseline_item_list_async(
        self,
        request: sas_20181203_models.DescribeImageBaselineItemListRequest,
    ) -> sas_20181203_models.DescribeImageBaselineItemListResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_image_baseline_item_list_with_options_async(request, runtime)

    def describe_image_baseline_strategy_with_options(
        self,
        request: sas_20181203_models.DescribeImageBaselineStrategyRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeImageBaselineStrategyResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.strategy_id):
            query['StrategyId'] = request.strategy_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeImageBaselineStrategy',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeImageBaselineStrategyResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_image_baseline_strategy_with_options_async(
        self,
        request: sas_20181203_models.DescribeImageBaselineStrategyRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeImageBaselineStrategyResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.strategy_id):
            query['StrategyId'] = request.strategy_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeImageBaselineStrategy',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeImageBaselineStrategyResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_image_baseline_strategy(
        self,
        request: sas_20181203_models.DescribeImageBaselineStrategyRequest,
    ) -> sas_20181203_models.DescribeImageBaselineStrategyResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_image_baseline_strategy_with_options(request, runtime)

    async def describe_image_baseline_strategy_async(
        self,
        request: sas_20181203_models.DescribeImageBaselineStrategyRequest,
    ) -> sas_20181203_models.DescribeImageBaselineStrategyResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_image_baseline_strategy_with_options_async(request, runtime)

    def describe_image_criteria_with_options(
        self,
        request: sas_20181203_models.DescribeImageCriteriaRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeImageCriteriaResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.value):
            query['Value'] = request.value
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeImageCriteria',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeImageCriteriaResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_image_criteria_with_options_async(
        self,
        request: sas_20181203_models.DescribeImageCriteriaRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeImageCriteriaResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.value):
            query['Value'] = request.value
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeImageCriteria',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeImageCriteriaResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_image_criteria(
        self,
        request: sas_20181203_models.DescribeImageCriteriaRequest,
    ) -> sas_20181203_models.DescribeImageCriteriaResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_image_criteria_with_options(request, runtime)

    async def describe_image_criteria_async(
        self,
        request: sas_20181203_models.DescribeImageCriteriaRequest,
    ) -> sas_20181203_models.DescribeImageCriteriaResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_image_criteria_with_options_async(request, runtime)

    def describe_image_fix_task_with_options(
        self,
        request: sas_20181203_models.DescribeImageFixTaskRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeImageFixTaskResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeImageFixTask',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeImageFixTaskResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_image_fix_task_with_options_async(
        self,
        request: sas_20181203_models.DescribeImageFixTaskRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeImageFixTaskResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeImageFixTask',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeImageFixTaskResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_image_fix_task(
        self,
        request: sas_20181203_models.DescribeImageFixTaskRequest,
    ) -> sas_20181203_models.DescribeImageFixTaskResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_image_fix_task_with_options(request, runtime)

    async def describe_image_fix_task_async(
        self,
        request: sas_20181203_models.DescribeImageFixTaskRequest,
    ) -> sas_20181203_models.DescribeImageFixTaskResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_image_fix_task_with_options_async(request, runtime)

    def describe_image_grouped_vul_list_with_options(
        self,
        request: sas_20181203_models.DescribeImageGroupedVulListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeImageGroupedVulListResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.alias_name):
            query['AliasName'] = request.alias_name
        if not UtilClient.is_unset(request.cluster_id):
            query['ClusterId'] = request.cluster_id
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.cve_id):
            query['CveId'] = request.cve_id
        if not UtilClient.is_unset(request.group_id):
            query['GroupId'] = request.group_id
        if not UtilClient.is_unset(request.image_digest):
            query['ImageDigest'] = request.image_digest
        if not UtilClient.is_unset(request.image_layer):
            query['ImageLayer'] = request.image_layer
        if not UtilClient.is_unset(request.image_tag):
            query['ImageTag'] = request.image_tag
        if not UtilClient.is_unset(request.is_latest):
            query['IsLatest'] = request.is_latest
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.necessity):
            query['Necessity'] = request.necessity
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.patch_id):
            query['PatchId'] = request.patch_id
        if not UtilClient.is_unset(request.repo_id):
            query['RepoId'] = request.repo_id
        if not UtilClient.is_unset(request.repo_instance_id):
            query['RepoInstanceId'] = request.repo_instance_id
        if not UtilClient.is_unset(request.repo_name):
            query['RepoName'] = request.repo_name
        if not UtilClient.is_unset(request.repo_namespace):
            query['RepoNamespace'] = request.repo_namespace
        if not UtilClient.is_unset(request.repo_region_id):
            query['RepoRegionId'] = request.repo_region_id
        if not UtilClient.is_unset(request.scan_range):
            query['ScanRange'] = request.scan_range
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        if not UtilClient.is_unset(request.uuids):
            query['Uuids'] = request.uuids
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeImageGroupedVulList',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeImageGroupedVulListResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_image_grouped_vul_list_with_options_async(
        self,
        request: sas_20181203_models.DescribeImageGroupedVulListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeImageGroupedVulListResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.alias_name):
            query['AliasName'] = request.alias_name
        if not UtilClient.is_unset(request.cluster_id):
            query['ClusterId'] = request.cluster_id
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.cve_id):
            query['CveId'] = request.cve_id
        if not UtilClient.is_unset(request.group_id):
            query['GroupId'] = request.group_id
        if not UtilClient.is_unset(request.image_digest):
            query['ImageDigest'] = request.image_digest
        if not UtilClient.is_unset(request.image_layer):
            query['ImageLayer'] = request.image_layer
        if not UtilClient.is_unset(request.image_tag):
            query['ImageTag'] = request.image_tag
        if not UtilClient.is_unset(request.is_latest):
            query['IsLatest'] = request.is_latest
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.necessity):
            query['Necessity'] = request.necessity
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.patch_id):
            query['PatchId'] = request.patch_id
        if not UtilClient.is_unset(request.repo_id):
            query['RepoId'] = request.repo_id
        if not UtilClient.is_unset(request.repo_instance_id):
            query['RepoInstanceId'] = request.repo_instance_id
        if not UtilClient.is_unset(request.repo_name):
            query['RepoName'] = request.repo_name
        if not UtilClient.is_unset(request.repo_namespace):
            query['RepoNamespace'] = request.repo_namespace
        if not UtilClient.is_unset(request.repo_region_id):
            query['RepoRegionId'] = request.repo_region_id
        if not UtilClient.is_unset(request.scan_range):
            query['ScanRange'] = request.scan_range
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        if not UtilClient.is_unset(request.uuids):
            query['Uuids'] = request.uuids
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeImageGroupedVulList',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeImageGroupedVulListResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_image_grouped_vul_list(
        self,
        request: sas_20181203_models.DescribeImageGroupedVulListRequest,
    ) -> sas_20181203_models.DescribeImageGroupedVulListResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_image_grouped_vul_list_with_options(request, runtime)

    async def describe_image_grouped_vul_list_async(
        self,
        request: sas_20181203_models.DescribeImageGroupedVulListRequest,
    ) -> sas_20181203_models.DescribeImageGroupedVulListResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_image_grouped_vul_list_with_options_async(request, runtime)

    def describe_image_info_list_with_options(
        self,
        request: sas_20181203_models.DescribeImageInfoListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeImageInfoListResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.uuids):
            query['Uuids'] = request.uuids
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeImageInfoList',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeImageInfoListResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_image_info_list_with_options_async(
        self,
        request: sas_20181203_models.DescribeImageInfoListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeImageInfoListResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.uuids):
            query['Uuids'] = request.uuids
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeImageInfoList',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeImageInfoListResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_image_info_list(
        self,
        request: sas_20181203_models.DescribeImageInfoListRequest,
    ) -> sas_20181203_models.DescribeImageInfoListResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_image_info_list_with_options(request, runtime)

    async def describe_image_info_list_async(
        self,
        request: sas_20181203_models.DescribeImageInfoListRequest,
    ) -> sas_20181203_models.DescribeImageInfoListResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_image_info_list_with_options_async(request, runtime)

    def describe_image_instances_with_options(
        self,
        request: sas_20181203_models.DescribeImageInstancesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeImageInstancesResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.criteria):
            query['Criteria'] = request.criteria
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.logical_exp):
            query['LogicalExp'] = request.logical_exp
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.scanned):
            query['Scanned'] = request.scanned
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeImageInstances',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeImageInstancesResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_image_instances_with_options_async(
        self,
        request: sas_20181203_models.DescribeImageInstancesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeImageInstancesResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.criteria):
            query['Criteria'] = request.criteria
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.logical_exp):
            query['LogicalExp'] = request.logical_exp
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.scanned):
            query['Scanned'] = request.scanned
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeImageInstances',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeImageInstancesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_image_instances(
        self,
        request: sas_20181203_models.DescribeImageInstancesRequest,
    ) -> sas_20181203_models.DescribeImageInstancesResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_image_instances_with_options(request, runtime)

    async def describe_image_instances_async(
        self,
        request: sas_20181203_models.DescribeImageInstancesRequest,
    ) -> sas_20181203_models.DescribeImageInstancesResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_image_instances_with_options_async(request, runtime)

    def describe_image_latest_scan_task_with_options(
        self,
        request: sas_20181203_models.DescribeImageLatestScanTaskRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeImageLatestScanTaskResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.digest):
            query['Digest'] = request.digest
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeImageLatestScanTask',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeImageLatestScanTaskResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_image_latest_scan_task_with_options_async(
        self,
        request: sas_20181203_models.DescribeImageLatestScanTaskRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeImageLatestScanTaskResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.digest):
            query['Digest'] = request.digest
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeImageLatestScanTask',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeImageLatestScanTaskResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_image_latest_scan_task(
        self,
        request: sas_20181203_models.DescribeImageLatestScanTaskRequest,
    ) -> sas_20181203_models.DescribeImageLatestScanTaskResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_image_latest_scan_task_with_options(request, runtime)

    async def describe_image_latest_scan_task_async(
        self,
        request: sas_20181203_models.DescribeImageLatestScanTaskRequest,
    ) -> sas_20181203_models.DescribeImageLatestScanTaskResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_image_latest_scan_task_with_options_async(request, runtime)

    def describe_image_list_by_sensitive_file_with_options(
        self,
        tmp_req: sas_20181203_models.DescribeImageListBySensitiveFileRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeImageListBySensitiveFileResponse:
        UtilClient.validate_model(tmp_req)
        request = sas_20181203_models.DescribeImageListBySensitiveFileShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.scan_range):
            request.scan_range_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.scan_range, 'ScanRange', 'json')
        query = {}
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.image_digest):
            query['ImageDigest'] = request.image_digest
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.repo_instance_id):
            query['RepoInstanceId'] = request.repo_instance_id
        if not UtilClient.is_unset(request.repo_name):
            query['RepoName'] = request.repo_name
        if not UtilClient.is_unset(request.repo_namespace):
            query['RepoNamespace'] = request.repo_namespace
        if not UtilClient.is_unset(request.risk_level):
            query['RiskLevel'] = request.risk_level
        if not UtilClient.is_unset(request.scan_range_shrink):
            query['ScanRange'] = request.scan_range_shrink
        if not UtilClient.is_unset(request.sensitive_file_key):
            query['SensitiveFileKey'] = request.sensitive_file_key
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeImageListBySensitiveFile',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeImageListBySensitiveFileResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_image_list_by_sensitive_file_with_options_async(
        self,
        tmp_req: sas_20181203_models.DescribeImageListBySensitiveFileRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeImageListBySensitiveFileResponse:
        UtilClient.validate_model(tmp_req)
        request = sas_20181203_models.DescribeImageListBySensitiveFileShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.scan_range):
            request.scan_range_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.scan_range, 'ScanRange', 'json')
        query = {}
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.image_digest):
            query['ImageDigest'] = request.image_digest
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.repo_instance_id):
            query['RepoInstanceId'] = request.repo_instance_id
        if not UtilClient.is_unset(request.repo_name):
            query['RepoName'] = request.repo_name
        if not UtilClient.is_unset(request.repo_namespace):
            query['RepoNamespace'] = request.repo_namespace
        if not UtilClient.is_unset(request.risk_level):
            query['RiskLevel'] = request.risk_level
        if not UtilClient.is_unset(request.scan_range_shrink):
            query['ScanRange'] = request.scan_range_shrink
        if not UtilClient.is_unset(request.sensitive_file_key):
            query['SensitiveFileKey'] = request.sensitive_file_key
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeImageListBySensitiveFile',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeImageListBySensitiveFileResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_image_list_by_sensitive_file(
        self,
        request: sas_20181203_models.DescribeImageListBySensitiveFileRequest,
    ) -> sas_20181203_models.DescribeImageListBySensitiveFileResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_image_list_by_sensitive_file_with_options(request, runtime)

    async def describe_image_list_by_sensitive_file_async(
        self,
        request: sas_20181203_models.DescribeImageListBySensitiveFileRequest,
    ) -> sas_20181203_models.DescribeImageListBySensitiveFileResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_image_list_by_sensitive_file_with_options_async(request, runtime)

    def describe_image_list_with_baseline_name_with_options(
        self,
        request: sas_20181203_models.DescribeImageListWithBaselineNameRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeImageListWithBaselineNameResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.baseline_name_key):
            query['BaselineNameKey'] = request.baseline_name_key
        if not UtilClient.is_unset(request.cluster_id):
            query['ClusterId'] = request.cluster_id
        if not UtilClient.is_unset(request.cluster_name):
            query['ClusterName'] = request.cluster_name
        if not UtilClient.is_unset(request.container_id):
            query['ContainerId'] = request.container_id
        if not UtilClient.is_unset(request.criteria):
            query['Criteria'] = request.criteria
        if not UtilClient.is_unset(request.criteria_type):
            query['CriteriaType'] = request.criteria_type
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.image):
            query['Image'] = request.image
        if not UtilClient.is_unset(request.image_digest):
            query['ImageDigest'] = request.image_digest
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.namespace):
            query['Namespace'] = request.namespace
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.pod):
            query['Pod'] = request.pod
        if not UtilClient.is_unset(request.repo_instance_id):
            query['RepoInstanceId'] = request.repo_instance_id
        if not UtilClient.is_unset(request.repo_name):
            query['RepoName'] = request.repo_name
        if not UtilClient.is_unset(request.repo_namespace):
            query['RepoNamespace'] = request.repo_namespace
        if not UtilClient.is_unset(request.scan_range):
            query['ScanRange'] = request.scan_range
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeImageListWithBaselineName',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeImageListWithBaselineNameResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_image_list_with_baseline_name_with_options_async(
        self,
        request: sas_20181203_models.DescribeImageListWithBaselineNameRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeImageListWithBaselineNameResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.baseline_name_key):
            query['BaselineNameKey'] = request.baseline_name_key
        if not UtilClient.is_unset(request.cluster_id):
            query['ClusterId'] = request.cluster_id
        if not UtilClient.is_unset(request.cluster_name):
            query['ClusterName'] = request.cluster_name
        if not UtilClient.is_unset(request.container_id):
            query['ContainerId'] = request.container_id
        if not UtilClient.is_unset(request.criteria):
            query['Criteria'] = request.criteria
        if not UtilClient.is_unset(request.criteria_type):
            query['CriteriaType'] = request.criteria_type
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.image):
            query['Image'] = request.image
        if not UtilClient.is_unset(request.image_digest):
            query['ImageDigest'] = request.image_digest
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.namespace):
            query['Namespace'] = request.namespace
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.pod):
            query['Pod'] = request.pod
        if not UtilClient.is_unset(request.repo_instance_id):
            query['RepoInstanceId'] = request.repo_instance_id
        if not UtilClient.is_unset(request.repo_name):
            query['RepoName'] = request.repo_name
        if not UtilClient.is_unset(request.repo_namespace):
            query['RepoNamespace'] = request.repo_namespace
        if not UtilClient.is_unset(request.scan_range):
            query['ScanRange'] = request.scan_range
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeImageListWithBaselineName',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeImageListWithBaselineNameResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_image_list_with_baseline_name(
        self,
        request: sas_20181203_models.DescribeImageListWithBaselineNameRequest,
    ) -> sas_20181203_models.DescribeImageListWithBaselineNameResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_image_list_with_baseline_name_with_options(request, runtime)

    async def describe_image_list_with_baseline_name_async(
        self,
        request: sas_20181203_models.DescribeImageListWithBaselineNameRequest,
    ) -> sas_20181203_models.DescribeImageListWithBaselineNameResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_image_list_with_baseline_name_with_options_async(request, runtime)

    def describe_image_repo_criteria_with_options(
        self,
        request: sas_20181203_models.DescribeImageRepoCriteriaRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeImageRepoCriteriaResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.value):
            query['Value'] = request.value
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeImageRepoCriteria',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeImageRepoCriteriaResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_image_repo_criteria_with_options_async(
        self,
        request: sas_20181203_models.DescribeImageRepoCriteriaRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeImageRepoCriteriaResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.value):
            query['Value'] = request.value
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeImageRepoCriteria',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeImageRepoCriteriaResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_image_repo_criteria(
        self,
        request: sas_20181203_models.DescribeImageRepoCriteriaRequest,
    ) -> sas_20181203_models.DescribeImageRepoCriteriaResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_image_repo_criteria_with_options(request, runtime)

    async def describe_image_repo_criteria_async(
        self,
        request: sas_20181203_models.DescribeImageRepoCriteriaRequest,
    ) -> sas_20181203_models.DescribeImageRepoCriteriaResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_image_repo_criteria_with_options_async(request, runtime)

    def describe_image_repo_detail_list_with_options(
        self,
        request: sas_20181203_models.DescribeImageRepoDetailListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeImageRepoDetailListResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.criteria):
            query['Criteria'] = request.criteria
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.logical_exp):
            query['LogicalExp'] = request.logical_exp
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeImageRepoDetailList',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeImageRepoDetailListResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_image_repo_detail_list_with_options_async(
        self,
        request: sas_20181203_models.DescribeImageRepoDetailListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeImageRepoDetailListResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.criteria):
            query['Criteria'] = request.criteria
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.logical_exp):
            query['LogicalExp'] = request.logical_exp
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeImageRepoDetailList',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeImageRepoDetailListResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_image_repo_detail_list(
        self,
        request: sas_20181203_models.DescribeImageRepoDetailListRequest,
    ) -> sas_20181203_models.DescribeImageRepoDetailListResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_image_repo_detail_list_with_options(request, runtime)

    async def describe_image_repo_detail_list_async(
        self,
        request: sas_20181203_models.DescribeImageRepoDetailListRequest,
    ) -> sas_20181203_models.DescribeImageRepoDetailListResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_image_repo_detail_list_with_options_async(request, runtime)

    def describe_image_repo_list_with_options(
        self,
        request: sas_20181203_models.DescribeImageRepoListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeImageRepoListResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.field_name):
            query['FieldName'] = request.field_name
        if not UtilClient.is_unset(request.field_value):
            query['FieldValue'] = request.field_value
        if not UtilClient.is_unset(request.operate_type):
            query['OperateType'] = request.operate_type
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.repo_name):
            query['RepoName'] = request.repo_name
        if not UtilClient.is_unset(request.repo_namespace):
            query['RepoNamespace'] = request.repo_namespace
        if not UtilClient.is_unset(request.target_type):
            query['TargetType'] = request.target_type
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeImageRepoList',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeImageRepoListResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_image_repo_list_with_options_async(
        self,
        request: sas_20181203_models.DescribeImageRepoListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeImageRepoListResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.field_name):
            query['FieldName'] = request.field_name
        if not UtilClient.is_unset(request.field_value):
            query['FieldValue'] = request.field_value
        if not UtilClient.is_unset(request.operate_type):
            query['OperateType'] = request.operate_type
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.repo_name):
            query['RepoName'] = request.repo_name
        if not UtilClient.is_unset(request.repo_namespace):
            query['RepoNamespace'] = request.repo_namespace
        if not UtilClient.is_unset(request.target_type):
            query['TargetType'] = request.target_type
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeImageRepoList',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeImageRepoListResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_image_repo_list(
        self,
        request: sas_20181203_models.DescribeImageRepoListRequest,
    ) -> sas_20181203_models.DescribeImageRepoListResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_image_repo_list_with_options(request, runtime)

    async def describe_image_repo_list_async(
        self,
        request: sas_20181203_models.DescribeImageRepoListRequest,
    ) -> sas_20181203_models.DescribeImageRepoListResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_image_repo_list_with_options_async(request, runtime)

    def describe_image_scan_auth_count_with_options(
        self,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeImageScanAuthCountResponse:
        req = open_api_models.OpenApiRequest()
        params = open_api_models.Params(
            action='DescribeImageScanAuthCount',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeImageScanAuthCountResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_image_scan_auth_count_with_options_async(
        self,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeImageScanAuthCountResponse:
        req = open_api_models.OpenApiRequest()
        params = open_api_models.Params(
            action='DescribeImageScanAuthCount',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeImageScanAuthCountResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_image_scan_auth_count(self) -> sas_20181203_models.DescribeImageScanAuthCountResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_image_scan_auth_count_with_options(runtime)

    async def describe_image_scan_auth_count_async(self) -> sas_20181203_models.DescribeImageScanAuthCountResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_image_scan_auth_count_with_options_async(runtime)

    def describe_image_scan_authorization_with_options(
        self,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeImageScanAuthorizationResponse:
        req = open_api_models.OpenApiRequest()
        params = open_api_models.Params(
            action='DescribeImageScanAuthorization',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeImageScanAuthorizationResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_image_scan_authorization_with_options_async(
        self,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeImageScanAuthorizationResponse:
        req = open_api_models.OpenApiRequest()
        params = open_api_models.Params(
            action='DescribeImageScanAuthorization',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeImageScanAuthorizationResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_image_scan_authorization(self) -> sas_20181203_models.DescribeImageScanAuthorizationResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_image_scan_authorization_with_options(runtime)

    async def describe_image_scan_authorization_async(self) -> sas_20181203_models.DescribeImageScanAuthorizationResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_image_scan_authorization_with_options_async(runtime)

    def describe_image_sensitive_file_by_key_with_options(
        self,
        tmp_req: sas_20181203_models.DescribeImageSensitiveFileByKeyRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeImageSensitiveFileByKeyResponse:
        UtilClient.validate_model(tmp_req)
        request = sas_20181203_models.DescribeImageSensitiveFileByKeyShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.scan_range):
            request.scan_range_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.scan_range, 'ScanRange', 'json')
        query = {}
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.image_uuid):
            query['ImageUuid'] = request.image_uuid
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.scan_range_shrink):
            query['ScanRange'] = request.scan_range_shrink
        if not UtilClient.is_unset(request.sensitive_file_key):
            query['SensitiveFileKey'] = request.sensitive_file_key
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeImageSensitiveFileByKey',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeImageSensitiveFileByKeyResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_image_sensitive_file_by_key_with_options_async(
        self,
        tmp_req: sas_20181203_models.DescribeImageSensitiveFileByKeyRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeImageSensitiveFileByKeyResponse:
        UtilClient.validate_model(tmp_req)
        request = sas_20181203_models.DescribeImageSensitiveFileByKeyShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.scan_range):
            request.scan_range_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.scan_range, 'ScanRange', 'json')
        query = {}
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.image_uuid):
            query['ImageUuid'] = request.image_uuid
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.scan_range_shrink):
            query['ScanRange'] = request.scan_range_shrink
        if not UtilClient.is_unset(request.sensitive_file_key):
            query['SensitiveFileKey'] = request.sensitive_file_key
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeImageSensitiveFileByKey',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeImageSensitiveFileByKeyResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_image_sensitive_file_by_key(
        self,
        request: sas_20181203_models.DescribeImageSensitiveFileByKeyRequest,
    ) -> sas_20181203_models.DescribeImageSensitiveFileByKeyResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_image_sensitive_file_by_key_with_options(request, runtime)

    async def describe_image_sensitive_file_by_key_async(
        self,
        request: sas_20181203_models.DescribeImageSensitiveFileByKeyRequest,
    ) -> sas_20181203_models.DescribeImageSensitiveFileByKeyResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_image_sensitive_file_by_key_with_options_async(request, runtime)

    def describe_image_sensitive_file_list_with_options(
        self,
        tmp_req: sas_20181203_models.DescribeImageSensitiveFileListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeImageSensitiveFileListResponse:
        UtilClient.validate_model(tmp_req)
        request = sas_20181203_models.DescribeImageSensitiveFileListShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.scan_range):
            request.scan_range_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.scan_range, 'ScanRange', 'json')
        query = {}
        if not UtilClient.is_unset(request.criteria):
            query['Criteria'] = request.criteria
        if not UtilClient.is_unset(request.criteria_type):
            query['CriteriaType'] = request.criteria_type
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.image_uuid):
            query['ImageUuid'] = request.image_uuid
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.risk_level):
            query['RiskLevel'] = request.risk_level
        if not UtilClient.is_unset(request.scan_range_shrink):
            query['ScanRange'] = request.scan_range_shrink
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeImageSensitiveFileList',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeImageSensitiveFileListResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_image_sensitive_file_list_with_options_async(
        self,
        tmp_req: sas_20181203_models.DescribeImageSensitiveFileListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeImageSensitiveFileListResponse:
        UtilClient.validate_model(tmp_req)
        request = sas_20181203_models.DescribeImageSensitiveFileListShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.scan_range):
            request.scan_range_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.scan_range, 'ScanRange', 'json')
        query = {}
        if not UtilClient.is_unset(request.criteria):
            query['Criteria'] = request.criteria
        if not UtilClient.is_unset(request.criteria_type):
            query['CriteriaType'] = request.criteria_type
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.image_uuid):
            query['ImageUuid'] = request.image_uuid
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.risk_level):
            query['RiskLevel'] = request.risk_level
        if not UtilClient.is_unset(request.scan_range_shrink):
            query['ScanRange'] = request.scan_range_shrink
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeImageSensitiveFileList',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeImageSensitiveFileListResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_image_sensitive_file_list(
        self,
        request: sas_20181203_models.DescribeImageSensitiveFileListRequest,
    ) -> sas_20181203_models.DescribeImageSensitiveFileListResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_image_sensitive_file_list_with_options(request, runtime)

    async def describe_image_sensitive_file_list_async(
        self,
        request: sas_20181203_models.DescribeImageSensitiveFileListRequest,
    ) -> sas_20181203_models.DescribeImageSensitiveFileListResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_image_sensitive_file_list_with_options_async(request, runtime)

    def describe_image_statistics_with_options(
        self,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeImageStatisticsResponse:
        """
        Security Center can scan for security risks and collect statistics only for *Container Registry Enterprise Edition instances**.
        >  Security Center cannot scan for security risks or collect statistics for **default** Container Registry instances.
        
        @param request: DescribeImageStatisticsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeImageStatisticsResponse
        """
        req = open_api_models.OpenApiRequest()
        params = open_api_models.Params(
            action='DescribeImageStatistics',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeImageStatisticsResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_image_statistics_with_options_async(
        self,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeImageStatisticsResponse:
        """
        Security Center can scan for security risks and collect statistics only for *Container Registry Enterprise Edition instances**.
        >  Security Center cannot scan for security risks or collect statistics for **default** Container Registry instances.
        
        @param request: DescribeImageStatisticsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeImageStatisticsResponse
        """
        req = open_api_models.OpenApiRequest()
        params = open_api_models.Params(
            action='DescribeImageStatistics',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeImageStatisticsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_image_statistics(self) -> sas_20181203_models.DescribeImageStatisticsResponse:
        """
        Security Center can scan for security risks and collect statistics only for *Container Registry Enterprise Edition instances**.
        >  Security Center cannot scan for security risks or collect statistics for **default** Container Registry instances.
        
        @return: DescribeImageStatisticsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_image_statistics_with_options(runtime)

    async def describe_image_statistics_async(self) -> sas_20181203_models.DescribeImageStatisticsResponse:
        """
        Security Center can scan for security risks and collect statistics only for *Container Registry Enterprise Edition instances**.
        >  Security Center cannot scan for security risks or collect statistics for **default** Container Registry instances.
        
        @return: DescribeImageStatisticsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_image_statistics_with_options_async(runtime)

    def describe_image_vul_list_with_options(
        self,
        request: sas_20181203_models.DescribeImageVulListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeImageVulListResponse:
        """
        To query the information about the recently detected image vulnerabilities, call the [PublicCreateImageScanTask](~~PublicCreateImageScanTask~~) operation. Wait 1 to 5 minutes until the call is successful and call the DescribeImageVulList operation.
        
        @param request: DescribeImageVulListRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeImageVulListResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.alias_name):
            query['AliasName'] = request.alias_name
        if not UtilClient.is_unset(request.cluster_id):
            query['ClusterId'] = request.cluster_id
        if not UtilClient.is_unset(request.cluster_name):
            query['ClusterName'] = request.cluster_name
        if not UtilClient.is_unset(request.container_id):
            query['ContainerId'] = request.container_id
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.dealed):
            query['Dealed'] = request.dealed
        if not UtilClient.is_unset(request.digest):
            query['Digest'] = request.digest
        if not UtilClient.is_unset(request.image):
            query['Image'] = request.image
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.namespace):
            query['Namespace'] = request.namespace
        if not UtilClient.is_unset(request.necessity):
            query['Necessity'] = request.necessity
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.pod):
            query['Pod'] = request.pod
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.repo_id):
            query['RepoId'] = request.repo_id
        if not UtilClient.is_unset(request.repo_id):
            query['RepoId'] = request.repo_id
        if not UtilClient.is_unset(request.repo_instance_id):
            query['RepoInstanceId'] = request.repo_instance_id
        if not UtilClient.is_unset(request.repo_name):
            query['RepoName'] = request.repo_name
        if not UtilClient.is_unset(request.repo_name):
            query['RepoName'] = request.repo_name
        if not UtilClient.is_unset(request.repo_namespace):
            query['RepoNamespace'] = request.repo_namespace
        if not UtilClient.is_unset(request.repo_region_id):
            query['RepoRegionId'] = request.repo_region_id
        if not UtilClient.is_unset(request.scan_range):
            query['ScanRange'] = request.scan_range
        if not UtilClient.is_unset(request.status_list):
            query['StatusList'] = request.status_list
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        if not UtilClient.is_unset(request.uuids):
            query['Uuids'] = request.uuids
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeImageVulList',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeImageVulListResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_image_vul_list_with_options_async(
        self,
        request: sas_20181203_models.DescribeImageVulListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeImageVulListResponse:
        """
        To query the information about the recently detected image vulnerabilities, call the [PublicCreateImageScanTask](~~PublicCreateImageScanTask~~) operation. Wait 1 to 5 minutes until the call is successful and call the DescribeImageVulList operation.
        
        @param request: DescribeImageVulListRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeImageVulListResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.alias_name):
            query['AliasName'] = request.alias_name
        if not UtilClient.is_unset(request.cluster_id):
            query['ClusterId'] = request.cluster_id
        if not UtilClient.is_unset(request.cluster_name):
            query['ClusterName'] = request.cluster_name
        if not UtilClient.is_unset(request.container_id):
            query['ContainerId'] = request.container_id
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.dealed):
            query['Dealed'] = request.dealed
        if not UtilClient.is_unset(request.digest):
            query['Digest'] = request.digest
        if not UtilClient.is_unset(request.image):
            query['Image'] = request.image
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.namespace):
            query['Namespace'] = request.namespace
        if not UtilClient.is_unset(request.necessity):
            query['Necessity'] = request.necessity
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.pod):
            query['Pod'] = request.pod
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.repo_id):
            query['RepoId'] = request.repo_id
        if not UtilClient.is_unset(request.repo_id):
            query['RepoId'] = request.repo_id
        if not UtilClient.is_unset(request.repo_instance_id):
            query['RepoInstanceId'] = request.repo_instance_id
        if not UtilClient.is_unset(request.repo_name):
            query['RepoName'] = request.repo_name
        if not UtilClient.is_unset(request.repo_name):
            query['RepoName'] = request.repo_name
        if not UtilClient.is_unset(request.repo_namespace):
            query['RepoNamespace'] = request.repo_namespace
        if not UtilClient.is_unset(request.repo_region_id):
            query['RepoRegionId'] = request.repo_region_id
        if not UtilClient.is_unset(request.scan_range):
            query['ScanRange'] = request.scan_range
        if not UtilClient.is_unset(request.status_list):
            query['StatusList'] = request.status_list
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        if not UtilClient.is_unset(request.uuids):
            query['Uuids'] = request.uuids
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeImageVulList',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeImageVulListResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_image_vul_list(
        self,
        request: sas_20181203_models.DescribeImageVulListRequest,
    ) -> sas_20181203_models.DescribeImageVulListResponse:
        """
        To query the information about the recently detected image vulnerabilities, call the [PublicCreateImageScanTask](~~PublicCreateImageScanTask~~) operation. Wait 1 to 5 minutes until the call is successful and call the DescribeImageVulList operation.
        
        @param request: DescribeImageVulListRequest
        @return: DescribeImageVulListResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_image_vul_list_with_options(request, runtime)

    async def describe_image_vul_list_async(
        self,
        request: sas_20181203_models.DescribeImageVulListRequest,
    ) -> sas_20181203_models.DescribeImageVulListResponse:
        """
        To query the information about the recently detected image vulnerabilities, call the [PublicCreateImageScanTask](~~PublicCreateImageScanTask~~) operation. Wait 1 to 5 minutes until the call is successful and call the DescribeImageVulList operation.
        
        @param request: DescribeImageVulListRequest
        @return: DescribeImageVulListResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_image_vul_list_with_options_async(request, runtime)

    def describe_install_captcha_with_options(
        self,
        request: sas_20181203_models.DescribeInstallCaptchaRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeInstallCaptchaResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.deadline):
            query['Deadline'] = request.deadline
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeInstallCaptcha',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeInstallCaptchaResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_install_captcha_with_options_async(
        self,
        request: sas_20181203_models.DescribeInstallCaptchaRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeInstallCaptchaResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.deadline):
            query['Deadline'] = request.deadline
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeInstallCaptcha',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeInstallCaptchaResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_install_captcha(
        self,
        request: sas_20181203_models.DescribeInstallCaptchaRequest,
    ) -> sas_20181203_models.DescribeInstallCaptchaResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_install_captcha_with_options(request, runtime)

    async def describe_install_captcha_async(
        self,
        request: sas_20181203_models.DescribeInstallCaptchaRequest,
    ) -> sas_20181203_models.DescribeInstallCaptchaResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_install_captcha_with_options_async(request, runtime)

    def describe_install_code_with_options(
        self,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeInstallCodeResponse:
        req = open_api_models.OpenApiRequest()
        params = open_api_models.Params(
            action='DescribeInstallCode',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeInstallCodeResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_install_code_with_options_async(
        self,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeInstallCodeResponse:
        req = open_api_models.OpenApiRequest()
        params = open_api_models.Params(
            action='DescribeInstallCode',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeInstallCodeResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_install_code(self) -> sas_20181203_models.DescribeInstallCodeResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_install_code_with_options(runtime)

    async def describe_install_code_async(self) -> sas_20181203_models.DescribeInstallCodeResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_install_code_with_options_async(runtime)

    def describe_install_codes_with_options(
        self,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeInstallCodesResponse:
        req = open_api_models.OpenApiRequest()
        params = open_api_models.Params(
            action='DescribeInstallCodes',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeInstallCodesResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_install_codes_with_options_async(
        self,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeInstallCodesResponse:
        req = open_api_models.OpenApiRequest()
        params = open_api_models.Params(
            action='DescribeInstallCodes',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeInstallCodesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_install_codes(self) -> sas_20181203_models.DescribeInstallCodesResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_install_codes_with_options(runtime)

    async def describe_install_codes_async(self) -> sas_20181203_models.DescribeInstallCodesResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_install_codes_with_options_async(runtime)

    def describe_instance_anti_brute_force_rules_with_options(
        self,
        request: sas_20181203_models.DescribeInstanceAntiBruteForceRulesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeInstanceAntiBruteForceRulesResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.uuid_list):
            query['UuidList'] = request.uuid_list
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeInstanceAntiBruteForceRules',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeInstanceAntiBruteForceRulesResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_instance_anti_brute_force_rules_with_options_async(
        self,
        request: sas_20181203_models.DescribeInstanceAntiBruteForceRulesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeInstanceAntiBruteForceRulesResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.uuid_list):
            query['UuidList'] = request.uuid_list
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeInstanceAntiBruteForceRules',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeInstanceAntiBruteForceRulesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_instance_anti_brute_force_rules(
        self,
        request: sas_20181203_models.DescribeInstanceAntiBruteForceRulesRequest,
    ) -> sas_20181203_models.DescribeInstanceAntiBruteForceRulesResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_instance_anti_brute_force_rules_with_options(request, runtime)

    async def describe_instance_anti_brute_force_rules_async(
        self,
        request: sas_20181203_models.DescribeInstanceAntiBruteForceRulesRequest,
    ) -> sas_20181203_models.DescribeInstanceAntiBruteForceRulesResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_instance_anti_brute_force_rules_with_options_async(request, runtime)

    def describe_instance_reboot_status_with_options(
        self,
        request: sas_20181203_models.DescribeInstanceRebootStatusRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeInstanceRebootStatusResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.uuids):
            query['Uuids'] = request.uuids
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeInstanceRebootStatus',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeInstanceRebootStatusResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_instance_reboot_status_with_options_async(
        self,
        request: sas_20181203_models.DescribeInstanceRebootStatusRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeInstanceRebootStatusResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.uuids):
            query['Uuids'] = request.uuids
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeInstanceRebootStatus',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeInstanceRebootStatusResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_instance_reboot_status(
        self,
        request: sas_20181203_models.DescribeInstanceRebootStatusRequest,
    ) -> sas_20181203_models.DescribeInstanceRebootStatusResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_instance_reboot_status_with_options(request, runtime)

    async def describe_instance_reboot_status_async(
        self,
        request: sas_20181203_models.DescribeInstanceRebootStatusRequest,
    ) -> sas_20181203_models.DescribeInstanceRebootStatusResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_instance_reboot_status_with_options_async(request, runtime)

    def describe_instance_statistics_with_options(
        self,
        request: sas_20181203_models.DescribeInstanceStatisticsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeInstanceStatisticsResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.from_):
            query['From'] = request.from_
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.uuid):
            query['Uuid'] = request.uuid
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeInstanceStatistics',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeInstanceStatisticsResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_instance_statistics_with_options_async(
        self,
        request: sas_20181203_models.DescribeInstanceStatisticsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeInstanceStatisticsResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.from_):
            query['From'] = request.from_
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.uuid):
            query['Uuid'] = request.uuid
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeInstanceStatistics',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeInstanceStatisticsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_instance_statistics(
        self,
        request: sas_20181203_models.DescribeInstanceStatisticsRequest,
    ) -> sas_20181203_models.DescribeInstanceStatisticsResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_instance_statistics_with_options(request, runtime)

    async def describe_instance_statistics_async(
        self,
        request: sas_20181203_models.DescribeInstanceStatisticsRequest,
    ) -> sas_20181203_models.DescribeInstanceStatisticsResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_instance_statistics_with_options_async(request, runtime)

    def describe_ip_tags_with_options(
        self,
        request: sas_20181203_models.DescribeIpTagsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeIpTagsResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.ip):
            query['Ip'] = request.ip
        if not UtilClient.is_unset(request.security_event_id):
            query['SecurityEventId'] = request.security_event_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeIpTags',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeIpTagsResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_ip_tags_with_options_async(
        self,
        request: sas_20181203_models.DescribeIpTagsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeIpTagsResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.ip):
            query['Ip'] = request.ip
        if not UtilClient.is_unset(request.security_event_id):
            query['SecurityEventId'] = request.security_event_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeIpTags',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeIpTagsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_ip_tags(
        self,
        request: sas_20181203_models.DescribeIpTagsRequest,
    ) -> sas_20181203_models.DescribeIpTagsResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_ip_tags_with_options(request, runtime)

    async def describe_ip_tags_async(
        self,
        request: sas_20181203_models.DescribeIpTagsRequest,
    ) -> sas_20181203_models.DescribeIpTagsResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_ip_tags_with_options_async(request, runtime)

    def describe_latest_scan_task_with_options(
        self,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeLatestScanTaskResponse:
        req = open_api_models.OpenApiRequest()
        params = open_api_models.Params(
            action='DescribeLatestScanTask',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeLatestScanTaskResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_latest_scan_task_with_options_async(
        self,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeLatestScanTaskResponse:
        req = open_api_models.OpenApiRequest()
        params = open_api_models.Params(
            action='DescribeLatestScanTask',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeLatestScanTaskResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_latest_scan_task(self) -> sas_20181203_models.DescribeLatestScanTaskResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_latest_scan_task_with_options(runtime)

    async def describe_latest_scan_task_async(self) -> sas_20181203_models.DescribeLatestScanTaskResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_latest_scan_task_with_options_async(runtime)

    def describe_log_meta_with_options(
        self,
        request: sas_20181203_models.DescribeLogMetaRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeLogMetaResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.from_):
            query['From'] = request.from_
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeLogMeta',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeLogMetaResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_log_meta_with_options_async(
        self,
        request: sas_20181203_models.DescribeLogMetaRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeLogMetaResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.from_):
            query['From'] = request.from_
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeLogMeta',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeLogMetaResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_log_meta(
        self,
        request: sas_20181203_models.DescribeLogMetaRequest,
    ) -> sas_20181203_models.DescribeLogMetaResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_log_meta_with_options(request, runtime)

    async def describe_log_meta_async(
        self,
        request: sas_20181203_models.DescribeLogMetaRequest,
    ) -> sas_20181203_models.DescribeLogMetaResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_log_meta_with_options_async(request, runtime)

    def describe_log_shipper_status_with_options(
        self,
        request: sas_20181203_models.DescribeLogShipperStatusRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeLogShipperStatusResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.from_):
            query['From'] = request.from_
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeLogShipperStatus',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeLogShipperStatusResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_log_shipper_status_with_options_async(
        self,
        request: sas_20181203_models.DescribeLogShipperStatusRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeLogShipperStatusResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.from_):
            query['From'] = request.from_
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeLogShipperStatus',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeLogShipperStatusResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_log_shipper_status(
        self,
        request: sas_20181203_models.DescribeLogShipperStatusRequest,
    ) -> sas_20181203_models.DescribeLogShipperStatusResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_log_shipper_status_with_options(request, runtime)

    async def describe_log_shipper_status_async(
        self,
        request: sas_20181203_models.DescribeLogShipperStatusRequest,
    ) -> sas_20181203_models.DescribeLogShipperStatusResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_log_shipper_status_with_options_async(request, runtime)

    def describe_login_base_configs_with_options(
        self,
        request: sas_20181203_models.DescribeLoginBaseConfigsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeLoginBaseConfigsResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.target):
            query['Target'] = request.target
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeLoginBaseConfigs',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeLoginBaseConfigsResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_login_base_configs_with_options_async(
        self,
        request: sas_20181203_models.DescribeLoginBaseConfigsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeLoginBaseConfigsResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.target):
            query['Target'] = request.target
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeLoginBaseConfigs',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeLoginBaseConfigsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_login_base_configs(
        self,
        request: sas_20181203_models.DescribeLoginBaseConfigsRequest,
    ) -> sas_20181203_models.DescribeLoginBaseConfigsResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_login_base_configs_with_options(request, runtime)

    async def describe_login_base_configs_async(
        self,
        request: sas_20181203_models.DescribeLoginBaseConfigsRequest,
    ) -> sas_20181203_models.DescribeLoginBaseConfigsResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_login_base_configs_with_options_async(request, runtime)

    def describe_login_switch_configs_with_options(
        self,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeLoginSwitchConfigsResponse:
        req = open_api_models.OpenApiRequest()
        params = open_api_models.Params(
            action='DescribeLoginSwitchConfigs',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeLoginSwitchConfigsResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_login_switch_configs_with_options_async(
        self,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeLoginSwitchConfigsResponse:
        req = open_api_models.OpenApiRequest()
        params = open_api_models.Params(
            action='DescribeLoginSwitchConfigs',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeLoginSwitchConfigsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_login_switch_configs(self) -> sas_20181203_models.DescribeLoginSwitchConfigsResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_login_switch_configs_with_options(runtime)

    async def describe_login_switch_configs_async(self) -> sas_20181203_models.DescribeLoginSwitchConfigsResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_login_switch_configs_with_options_async(runtime)

    def describe_logstore_storage_with_options(
        self,
        request: sas_20181203_models.DescribeLogstoreStorageRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeLogstoreStorageResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.from_):
            query['From'] = request.from_
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeLogstoreStorage',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeLogstoreStorageResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_logstore_storage_with_options_async(
        self,
        request: sas_20181203_models.DescribeLogstoreStorageRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeLogstoreStorageResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.from_):
            query['From'] = request.from_
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeLogstoreStorage',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeLogstoreStorageResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_logstore_storage(
        self,
        request: sas_20181203_models.DescribeLogstoreStorageRequest,
    ) -> sas_20181203_models.DescribeLogstoreStorageResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_logstore_storage_with_options(request, runtime)

    async def describe_logstore_storage_async(
        self,
        request: sas_20181203_models.DescribeLogstoreStorageRequest,
    ) -> sas_20181203_models.DescribeLogstoreStorageResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_logstore_storage_with_options_async(request, runtime)

    def describe_machine_can_reboot_with_options(
        self,
        request: sas_20181203_models.DescribeMachineCanRebootRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeMachineCanRebootResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        if not UtilClient.is_unset(request.uuid):
            query['Uuid'] = request.uuid
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeMachineCanReboot',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeMachineCanRebootResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_machine_can_reboot_with_options_async(
        self,
        request: sas_20181203_models.DescribeMachineCanRebootRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeMachineCanRebootResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        if not UtilClient.is_unset(request.uuid):
            query['Uuid'] = request.uuid
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeMachineCanReboot',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeMachineCanRebootResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_machine_can_reboot(
        self,
        request: sas_20181203_models.DescribeMachineCanRebootRequest,
    ) -> sas_20181203_models.DescribeMachineCanRebootResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_machine_can_reboot_with_options(request, runtime)

    async def describe_machine_can_reboot_async(
        self,
        request: sas_20181203_models.DescribeMachineCanRebootRequest,
    ) -> sas_20181203_models.DescribeMachineCanRebootResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_machine_can_reboot_with_options_async(request, runtime)

    def describe_module_config_with_options(
        self,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeModuleConfigResponse:
        req = open_api_models.OpenApiRequest()
        params = open_api_models.Params(
            action='DescribeModuleConfig',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeModuleConfigResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_module_config_with_options_async(
        self,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeModuleConfigResponse:
        req = open_api_models.OpenApiRequest()
        params = open_api_models.Params(
            action='DescribeModuleConfig',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeModuleConfigResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_module_config(self) -> sas_20181203_models.DescribeModuleConfigResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_module_config_with_options(runtime)

    async def describe_module_config_async(self) -> sas_20181203_models.DescribeModuleConfigResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_module_config_with_options_async(runtime)

    def describe_notice_config_with_options(
        self,
        request: sas_20181203_models.DescribeNoticeConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeNoticeConfigResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeNoticeConfig',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeNoticeConfigResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_notice_config_with_options_async(
        self,
        request: sas_20181203_models.DescribeNoticeConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeNoticeConfigResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeNoticeConfig',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeNoticeConfigResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_notice_config(
        self,
        request: sas_20181203_models.DescribeNoticeConfigRequest,
    ) -> sas_20181203_models.DescribeNoticeConfigResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_notice_config_with_options(request, runtime)

    async def describe_notice_config_async(
        self,
        request: sas_20181203_models.DescribeNoticeConfigRequest,
    ) -> sas_20181203_models.DescribeNoticeConfigResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_notice_config_with_options_async(request, runtime)

    def describe_nsas_susp_event_type_with_options(
        self,
        request: sas_20181203_models.DescribeNsasSuspEventTypeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeNsasSuspEventTypeResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.container_field_name):
            query['ContainerFieldName'] = request.container_field_name
        if not UtilClient.is_unset(request.container_field_value):
            query['ContainerFieldValue'] = request.container_field_value
        if not UtilClient.is_unset(request.from_):
            query['From'] = request.from_
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.remark):
            query['Remark'] = request.remark
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.uuids):
            query['Uuids'] = request.uuids
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeNsasSuspEventType',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeNsasSuspEventTypeResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_nsas_susp_event_type_with_options_async(
        self,
        request: sas_20181203_models.DescribeNsasSuspEventTypeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeNsasSuspEventTypeResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.container_field_name):
            query['ContainerFieldName'] = request.container_field_name
        if not UtilClient.is_unset(request.container_field_value):
            query['ContainerFieldValue'] = request.container_field_value
        if not UtilClient.is_unset(request.from_):
            query['From'] = request.from_
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.remark):
            query['Remark'] = request.remark
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.uuids):
            query['Uuids'] = request.uuids
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeNsasSuspEventType',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeNsasSuspEventTypeResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_nsas_susp_event_type(
        self,
        request: sas_20181203_models.DescribeNsasSuspEventTypeRequest,
    ) -> sas_20181203_models.DescribeNsasSuspEventTypeResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_nsas_susp_event_type_with_options(request, runtime)

    async def describe_nsas_susp_event_type_async(
        self,
        request: sas_20181203_models.DescribeNsasSuspEventTypeRequest,
    ) -> sas_20181203_models.DescribeNsasSuspEventTypeResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_nsas_susp_event_type_with_options_async(request, runtime)

    def describe_offline_machines_with_options(
        self,
        request: sas_20181203_models.DescribeOfflineMachinesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeOfflineMachinesResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.os):
            query['Os'] = request.os
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id_str):
            query['RegionIdStr'] = request.region_id_str
        if not UtilClient.is_unset(request.region_no):
            query['RegionNo'] = request.region_no
        if not UtilClient.is_unset(request.remark):
            query['Remark'] = request.remark
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.vendor):
            query['Vendor'] = request.vendor
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeOfflineMachines',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeOfflineMachinesResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_offline_machines_with_options_async(
        self,
        request: sas_20181203_models.DescribeOfflineMachinesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeOfflineMachinesResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.os):
            query['Os'] = request.os
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id_str):
            query['RegionIdStr'] = request.region_id_str
        if not UtilClient.is_unset(request.region_no):
            query['RegionNo'] = request.region_no
        if not UtilClient.is_unset(request.remark):
            query['Remark'] = request.remark
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.vendor):
            query['Vendor'] = request.vendor
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeOfflineMachines',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeOfflineMachinesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_offline_machines(
        self,
        request: sas_20181203_models.DescribeOfflineMachinesRequest,
    ) -> sas_20181203_models.DescribeOfflineMachinesResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_offline_machines_with_options(request, runtime)

    async def describe_offline_machines_async(
        self,
        request: sas_20181203_models.DescribeOfflineMachinesRequest,
    ) -> sas_20181203_models.DescribeOfflineMachinesResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_offline_machines_with_options_async(request, runtime)

    def describe_once_task_with_options(
        self,
        request: sas_20181203_models.DescribeOnceTaskRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeOnceTaskResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.end_time_query):
            query['EndTimeQuery'] = request.end_time_query
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.root_task_id):
            query['RootTaskId'] = request.root_task_id
        if not UtilClient.is_unset(request.start_time_query):
            query['StartTimeQuery'] = request.start_time_query
        if not UtilClient.is_unset(request.task_id):
            query['TaskId'] = request.task_id
        if not UtilClient.is_unset(request.task_type):
            query['TaskType'] = request.task_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeOnceTask',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeOnceTaskResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_once_task_with_options_async(
        self,
        request: sas_20181203_models.DescribeOnceTaskRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeOnceTaskResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.end_time_query):
            query['EndTimeQuery'] = request.end_time_query
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.root_task_id):
            query['RootTaskId'] = request.root_task_id
        if not UtilClient.is_unset(request.start_time_query):
            query['StartTimeQuery'] = request.start_time_query
        if not UtilClient.is_unset(request.task_id):
            query['TaskId'] = request.task_id
        if not UtilClient.is_unset(request.task_type):
            query['TaskType'] = request.task_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeOnceTask',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeOnceTaskResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_once_task(
        self,
        request: sas_20181203_models.DescribeOnceTaskRequest,
    ) -> sas_20181203_models.DescribeOnceTaskResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_once_task_with_options(request, runtime)

    async def describe_once_task_async(
        self,
        request: sas_20181203_models.DescribeOnceTaskRequest,
    ) -> sas_20181203_models.DescribeOnceTaskResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_once_task_with_options_async(request, runtime)

    def describe_once_task_leaf_record_page_with_options(
        self,
        request: sas_20181203_models.DescribeOnceTaskLeafRecordPageRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeOnceTaskLeafRecordPageResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.relate_info):
            query['RelateInfo'] = request.relate_info
        if not UtilClient.is_unset(request.source):
            query['Source'] = request.source
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        if not UtilClient.is_unset(request.status_list):
            query['StatusList'] = request.status_list
        if not UtilClient.is_unset(request.task_id):
            query['TaskId'] = request.task_id
        if not UtilClient.is_unset(request.task_type):
            query['TaskType'] = request.task_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeOnceTaskLeafRecordPage',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeOnceTaskLeafRecordPageResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_once_task_leaf_record_page_with_options_async(
        self,
        request: sas_20181203_models.DescribeOnceTaskLeafRecordPageRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeOnceTaskLeafRecordPageResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.relate_info):
            query['RelateInfo'] = request.relate_info
        if not UtilClient.is_unset(request.source):
            query['Source'] = request.source
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        if not UtilClient.is_unset(request.status_list):
            query['StatusList'] = request.status_list
        if not UtilClient.is_unset(request.task_id):
            query['TaskId'] = request.task_id
        if not UtilClient.is_unset(request.task_type):
            query['TaskType'] = request.task_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeOnceTaskLeafRecordPage',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeOnceTaskLeafRecordPageResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_once_task_leaf_record_page(
        self,
        request: sas_20181203_models.DescribeOnceTaskLeafRecordPageRequest,
    ) -> sas_20181203_models.DescribeOnceTaskLeafRecordPageResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_once_task_leaf_record_page_with_options(request, runtime)

    async def describe_once_task_leaf_record_page_async(
        self,
        request: sas_20181203_models.DescribeOnceTaskLeafRecordPageRequest,
    ) -> sas_20181203_models.DescribeOnceTaskLeafRecordPageResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_once_task_leaf_record_page_with_options_async(request, runtime)

    def describe_property_count_with_options(
        self,
        request: sas_20181203_models.DescribePropertyCountRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribePropertyCountResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        if not UtilClient.is_unset(request.uuid_list):
            query['UuidList'] = request.uuid_list
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribePropertyCount',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribePropertyCountResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_property_count_with_options_async(
        self,
        request: sas_20181203_models.DescribePropertyCountRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribePropertyCountResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        if not UtilClient.is_unset(request.uuid_list):
            query['UuidList'] = request.uuid_list
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribePropertyCount',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribePropertyCountResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_property_count(
        self,
        request: sas_20181203_models.DescribePropertyCountRequest,
    ) -> sas_20181203_models.DescribePropertyCountResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_property_count_with_options(request, runtime)

    async def describe_property_count_async(
        self,
        request: sas_20181203_models.DescribePropertyCountRequest,
    ) -> sas_20181203_models.DescribePropertyCountResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_property_count_with_options_async(request, runtime)

    def describe_property_cron_detail_with_options(
        self,
        request: sas_20181203_models.DescribePropertyCronDetailRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribePropertyCronDetailResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.extend):
            query['Extend'] = request.extend
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.remark):
            query['Remark'] = request.remark
        if not UtilClient.is_unset(request.source):
            query['Source'] = request.source
        if not UtilClient.is_unset(request.user):
            query['User'] = request.user
        if not UtilClient.is_unset(request.uuid):
            query['Uuid'] = request.uuid
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribePropertyCronDetail',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribePropertyCronDetailResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_property_cron_detail_with_options_async(
        self,
        request: sas_20181203_models.DescribePropertyCronDetailRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribePropertyCronDetailResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.extend):
            query['Extend'] = request.extend
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.remark):
            query['Remark'] = request.remark
        if not UtilClient.is_unset(request.source):
            query['Source'] = request.source
        if not UtilClient.is_unset(request.user):
            query['User'] = request.user
        if not UtilClient.is_unset(request.uuid):
            query['Uuid'] = request.uuid
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribePropertyCronDetail',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribePropertyCronDetailResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_property_cron_detail(
        self,
        request: sas_20181203_models.DescribePropertyCronDetailRequest,
    ) -> sas_20181203_models.DescribePropertyCronDetailResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_property_cron_detail_with_options(request, runtime)

    async def describe_property_cron_detail_async(
        self,
        request: sas_20181203_models.DescribePropertyCronDetailRequest,
    ) -> sas_20181203_models.DescribePropertyCronDetailResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_property_cron_detail_with_options_async(request, runtime)

    def describe_property_cron_item_with_options(
        self,
        request: sas_20181203_models.DescribePropertyCronItemRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribePropertyCronItemResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.force_flush):
            query['ForceFlush'] = request.force_flush
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.source):
            query['Source'] = request.source
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribePropertyCronItem',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribePropertyCronItemResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_property_cron_item_with_options_async(
        self,
        request: sas_20181203_models.DescribePropertyCronItemRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribePropertyCronItemResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.force_flush):
            query['ForceFlush'] = request.force_flush
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.source):
            query['Source'] = request.source
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribePropertyCronItem',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribePropertyCronItemResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_property_cron_item(
        self,
        request: sas_20181203_models.DescribePropertyCronItemRequest,
    ) -> sas_20181203_models.DescribePropertyCronItemResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_property_cron_item_with_options(request, runtime)

    async def describe_property_cron_item_async(
        self,
        request: sas_20181203_models.DescribePropertyCronItemRequest,
    ) -> sas_20181203_models.DescribePropertyCronItemResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_property_cron_item_with_options_async(request, runtime)

    def describe_property_port_detail_with_options(
        self,
        request: sas_20181203_models.DescribePropertyPortDetailRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribePropertyPortDetailResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.bind_ip):
            query['BindIp'] = request.bind_ip
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.extend):
            query['Extend'] = request.extend
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.port):
            query['Port'] = request.port
        if not UtilClient.is_unset(request.proc_name):
            query['ProcName'] = request.proc_name
        if not UtilClient.is_unset(request.remark):
            query['Remark'] = request.remark
        if not UtilClient.is_unset(request.uuid):
            query['Uuid'] = request.uuid
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribePropertyPortDetail',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribePropertyPortDetailResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_property_port_detail_with_options_async(
        self,
        request: sas_20181203_models.DescribePropertyPortDetailRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribePropertyPortDetailResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.bind_ip):
            query['BindIp'] = request.bind_ip
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.extend):
            query['Extend'] = request.extend
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.port):
            query['Port'] = request.port
        if not UtilClient.is_unset(request.proc_name):
            query['ProcName'] = request.proc_name
        if not UtilClient.is_unset(request.remark):
            query['Remark'] = request.remark
        if not UtilClient.is_unset(request.uuid):
            query['Uuid'] = request.uuid
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribePropertyPortDetail',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribePropertyPortDetailResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_property_port_detail(
        self,
        request: sas_20181203_models.DescribePropertyPortDetailRequest,
    ) -> sas_20181203_models.DescribePropertyPortDetailResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_property_port_detail_with_options(request, runtime)

    async def describe_property_port_detail_async(
        self,
        request: sas_20181203_models.DescribePropertyPortDetailRequest,
    ) -> sas_20181203_models.DescribePropertyPortDetailResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_property_port_detail_with_options_async(request, runtime)

    def describe_property_port_item_with_options(
        self,
        request: sas_20181203_models.DescribePropertyPortItemRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribePropertyPortItemResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.force_flush):
            query['ForceFlush'] = request.force_flush
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.port):
            query['Port'] = request.port
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribePropertyPortItem',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribePropertyPortItemResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_property_port_item_with_options_async(
        self,
        request: sas_20181203_models.DescribePropertyPortItemRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribePropertyPortItemResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.force_flush):
            query['ForceFlush'] = request.force_flush
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.port):
            query['Port'] = request.port
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribePropertyPortItem',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribePropertyPortItemResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_property_port_item(
        self,
        request: sas_20181203_models.DescribePropertyPortItemRequest,
    ) -> sas_20181203_models.DescribePropertyPortItemResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_property_port_item_with_options(request, runtime)

    async def describe_property_port_item_async(
        self,
        request: sas_20181203_models.DescribePropertyPortItemRequest,
    ) -> sas_20181203_models.DescribePropertyPortItemResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_property_port_item_with_options_async(request, runtime)

    def describe_property_proc_detail_with_options(
        self,
        request: sas_20181203_models.DescribePropertyProcDetailRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribePropertyProcDetailResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cmdline):
            query['Cmdline'] = request.cmdline
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.extend):
            query['Extend'] = request.extend
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.proc_time_end):
            query['ProcTimeEnd'] = request.proc_time_end
        if not UtilClient.is_unset(request.proc_time_start):
            query['ProcTimeStart'] = request.proc_time_start
        if not UtilClient.is_unset(request.remark):
            query['Remark'] = request.remark
        if not UtilClient.is_unset(request.user):
            query['User'] = request.user
        if not UtilClient.is_unset(request.uuid):
            query['Uuid'] = request.uuid
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribePropertyProcDetail',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribePropertyProcDetailResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_property_proc_detail_with_options_async(
        self,
        request: sas_20181203_models.DescribePropertyProcDetailRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribePropertyProcDetailResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cmdline):
            query['Cmdline'] = request.cmdline
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.extend):
            query['Extend'] = request.extend
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.proc_time_end):
            query['ProcTimeEnd'] = request.proc_time_end
        if not UtilClient.is_unset(request.proc_time_start):
            query['ProcTimeStart'] = request.proc_time_start
        if not UtilClient.is_unset(request.remark):
            query['Remark'] = request.remark
        if not UtilClient.is_unset(request.user):
            query['User'] = request.user
        if not UtilClient.is_unset(request.uuid):
            query['Uuid'] = request.uuid
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribePropertyProcDetail',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribePropertyProcDetailResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_property_proc_detail(
        self,
        request: sas_20181203_models.DescribePropertyProcDetailRequest,
    ) -> sas_20181203_models.DescribePropertyProcDetailResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_property_proc_detail_with_options(request, runtime)

    async def describe_property_proc_detail_async(
        self,
        request: sas_20181203_models.DescribePropertyProcDetailRequest,
    ) -> sas_20181203_models.DescribePropertyProcDetailResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_property_proc_detail_with_options_async(request, runtime)

    def describe_property_proc_item_with_options(
        self,
        request: sas_20181203_models.DescribePropertyProcItemRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribePropertyProcItemResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.force_flush):
            query['ForceFlush'] = request.force_flush
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribePropertyProcItem',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribePropertyProcItemResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_property_proc_item_with_options_async(
        self,
        request: sas_20181203_models.DescribePropertyProcItemRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribePropertyProcItemResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.force_flush):
            query['ForceFlush'] = request.force_flush
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribePropertyProcItem',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribePropertyProcItemResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_property_proc_item(
        self,
        request: sas_20181203_models.DescribePropertyProcItemRequest,
    ) -> sas_20181203_models.DescribePropertyProcItemResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_property_proc_item_with_options(request, runtime)

    async def describe_property_proc_item_async(
        self,
        request: sas_20181203_models.DescribePropertyProcItemRequest,
    ) -> sas_20181203_models.DescribePropertyProcItemResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_property_proc_item_with_options_async(request, runtime)

    def describe_property_sca_detail_with_options(
        self,
        request: sas_20181203_models.DescribePropertyScaDetailRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribePropertyScaDetailResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.biz):
            query['Biz'] = request.biz
        if not UtilClient.is_unset(request.biz_type):
            query['BizType'] = request.biz_type
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.pid):
            query['Pid'] = request.pid
        if not UtilClient.is_unset(request.port):
            query['Port'] = request.port
        if not UtilClient.is_unset(request.process_started_end):
            query['ProcessStartedEnd'] = request.process_started_end
        if not UtilClient.is_unset(request.process_started_start):
            query['ProcessStartedStart'] = request.process_started_start
        if not UtilClient.is_unset(request.remark):
            query['Remark'] = request.remark
        if not UtilClient.is_unset(request.sca_name):
            query['ScaName'] = request.sca_name
        if not UtilClient.is_unset(request.sca_name_pattern):
            query['ScaNamePattern'] = request.sca_name_pattern
        if not UtilClient.is_unset(request.sca_version):
            query['ScaVersion'] = request.sca_version
        if not UtilClient.is_unset(request.search_info):
            query['SearchInfo'] = request.search_info
        if not UtilClient.is_unset(request.search_info_sub):
            query['SearchInfoSub'] = request.search_info_sub
        if not UtilClient.is_unset(request.search_item):
            query['SearchItem'] = request.search_item
        if not UtilClient.is_unset(request.search_item_sub):
            query['SearchItemSub'] = request.search_item_sub
        if not UtilClient.is_unset(request.user):
            query['User'] = request.user
        if not UtilClient.is_unset(request.uuid):
            query['Uuid'] = request.uuid
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribePropertyScaDetail',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribePropertyScaDetailResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_property_sca_detail_with_options_async(
        self,
        request: sas_20181203_models.DescribePropertyScaDetailRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribePropertyScaDetailResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.biz):
            query['Biz'] = request.biz
        if not UtilClient.is_unset(request.biz_type):
            query['BizType'] = request.biz_type
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.pid):
            query['Pid'] = request.pid
        if not UtilClient.is_unset(request.port):
            query['Port'] = request.port
        if not UtilClient.is_unset(request.process_started_end):
            query['ProcessStartedEnd'] = request.process_started_end
        if not UtilClient.is_unset(request.process_started_start):
            query['ProcessStartedStart'] = request.process_started_start
        if not UtilClient.is_unset(request.remark):
            query['Remark'] = request.remark
        if not UtilClient.is_unset(request.sca_name):
            query['ScaName'] = request.sca_name
        if not UtilClient.is_unset(request.sca_name_pattern):
            query['ScaNamePattern'] = request.sca_name_pattern
        if not UtilClient.is_unset(request.sca_version):
            query['ScaVersion'] = request.sca_version
        if not UtilClient.is_unset(request.search_info):
            query['SearchInfo'] = request.search_info
        if not UtilClient.is_unset(request.search_info_sub):
            query['SearchInfoSub'] = request.search_info_sub
        if not UtilClient.is_unset(request.search_item):
            query['SearchItem'] = request.search_item
        if not UtilClient.is_unset(request.search_item_sub):
            query['SearchItemSub'] = request.search_item_sub
        if not UtilClient.is_unset(request.user):
            query['User'] = request.user
        if not UtilClient.is_unset(request.uuid):
            query['Uuid'] = request.uuid
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribePropertyScaDetail',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribePropertyScaDetailResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_property_sca_detail(
        self,
        request: sas_20181203_models.DescribePropertyScaDetailRequest,
    ) -> sas_20181203_models.DescribePropertyScaDetailResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_property_sca_detail_with_options(request, runtime)

    async def describe_property_sca_detail_async(
        self,
        request: sas_20181203_models.DescribePropertyScaDetailRequest,
    ) -> sas_20181203_models.DescribePropertyScaDetailResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_property_sca_detail_with_options_async(request, runtime)

    def describe_property_sca_item_with_options(
        self,
        request: sas_20181203_models.DescribePropertyScaItemRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribePropertyScaItemResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.biz):
            query['Biz'] = request.biz
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.force_flush):
            query['ForceFlush'] = request.force_flush
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.search_info):
            query['SearchInfo'] = request.search_info
        if not UtilClient.is_unset(request.search_item):
            query['SearchItem'] = request.search_item
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribePropertyScaItem',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribePropertyScaItemResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_property_sca_item_with_options_async(
        self,
        request: sas_20181203_models.DescribePropertyScaItemRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribePropertyScaItemResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.biz):
            query['Biz'] = request.biz
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.force_flush):
            query['ForceFlush'] = request.force_flush
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.search_info):
            query['SearchInfo'] = request.search_info
        if not UtilClient.is_unset(request.search_item):
            query['SearchItem'] = request.search_item
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribePropertyScaItem',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribePropertyScaItemResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_property_sca_item(
        self,
        request: sas_20181203_models.DescribePropertyScaItemRequest,
    ) -> sas_20181203_models.DescribePropertyScaItemResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_property_sca_item_with_options(request, runtime)

    async def describe_property_sca_item_async(
        self,
        request: sas_20181203_models.DescribePropertyScaItemRequest,
    ) -> sas_20181203_models.DescribePropertyScaItemResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_property_sca_item_with_options_async(request, runtime)

    def describe_property_schedule_config_with_options(
        self,
        request: sas_20181203_models.DescribePropertyScheduleConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribePropertyScheduleConfigResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribePropertyScheduleConfig',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribePropertyScheduleConfigResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_property_schedule_config_with_options_async(
        self,
        request: sas_20181203_models.DescribePropertyScheduleConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribePropertyScheduleConfigResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribePropertyScheduleConfig',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribePropertyScheduleConfigResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_property_schedule_config(
        self,
        request: sas_20181203_models.DescribePropertyScheduleConfigRequest,
    ) -> sas_20181203_models.DescribePropertyScheduleConfigResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_property_schedule_config_with_options(request, runtime)

    async def describe_property_schedule_config_async(
        self,
        request: sas_20181203_models.DescribePropertyScheduleConfigRequest,
    ) -> sas_20181203_models.DescribePropertyScheduleConfigResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_property_schedule_config_with_options_async(request, runtime)

    def describe_property_software_detail_with_options(
        self,
        request: sas_20181203_models.DescribePropertySoftwareDetailRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribePropertySoftwareDetailResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.extend):
            query['Extend'] = request.extend
        if not UtilClient.is_unset(request.install_time_end):
            query['InstallTimeEnd'] = request.install_time_end
        if not UtilClient.is_unset(request.install_time_start):
            query['InstallTimeStart'] = request.install_time_start
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.path):
            query['Path'] = request.path
        if not UtilClient.is_unset(request.remark):
            query['Remark'] = request.remark
        if not UtilClient.is_unset(request.software_version):
            query['SoftwareVersion'] = request.software_version
        if not UtilClient.is_unset(request.uuid):
            query['Uuid'] = request.uuid
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribePropertySoftwareDetail',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribePropertySoftwareDetailResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_property_software_detail_with_options_async(
        self,
        request: sas_20181203_models.DescribePropertySoftwareDetailRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribePropertySoftwareDetailResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.extend):
            query['Extend'] = request.extend
        if not UtilClient.is_unset(request.install_time_end):
            query['InstallTimeEnd'] = request.install_time_end
        if not UtilClient.is_unset(request.install_time_start):
            query['InstallTimeStart'] = request.install_time_start
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.path):
            query['Path'] = request.path
        if not UtilClient.is_unset(request.remark):
            query['Remark'] = request.remark
        if not UtilClient.is_unset(request.software_version):
            query['SoftwareVersion'] = request.software_version
        if not UtilClient.is_unset(request.uuid):
            query['Uuid'] = request.uuid
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribePropertySoftwareDetail',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribePropertySoftwareDetailResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_property_software_detail(
        self,
        request: sas_20181203_models.DescribePropertySoftwareDetailRequest,
    ) -> sas_20181203_models.DescribePropertySoftwareDetailResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_property_software_detail_with_options(request, runtime)

    async def describe_property_software_detail_async(
        self,
        request: sas_20181203_models.DescribePropertySoftwareDetailRequest,
    ) -> sas_20181203_models.DescribePropertySoftwareDetailResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_property_software_detail_with_options_async(request, runtime)

    def describe_property_software_item_with_options(
        self,
        request: sas_20181203_models.DescribePropertySoftwareItemRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribePropertySoftwareItemResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.force_flush):
            query['ForceFlush'] = request.force_flush
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribePropertySoftwareItem',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribePropertySoftwareItemResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_property_software_item_with_options_async(
        self,
        request: sas_20181203_models.DescribePropertySoftwareItemRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribePropertySoftwareItemResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.force_flush):
            query['ForceFlush'] = request.force_flush
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribePropertySoftwareItem',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribePropertySoftwareItemResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_property_software_item(
        self,
        request: sas_20181203_models.DescribePropertySoftwareItemRequest,
    ) -> sas_20181203_models.DescribePropertySoftwareItemResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_property_software_item_with_options(request, runtime)

    async def describe_property_software_item_async(
        self,
        request: sas_20181203_models.DescribePropertySoftwareItemRequest,
    ) -> sas_20181203_models.DescribePropertySoftwareItemResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_property_software_item_with_options_async(request, runtime)

    def describe_property_type_sca_item_with_options(
        self,
        request: sas_20181203_models.DescribePropertyTypeScaItemRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribePropertyTypeScaItemResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribePropertyTypeScaItem',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribePropertyTypeScaItemResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_property_type_sca_item_with_options_async(
        self,
        request: sas_20181203_models.DescribePropertyTypeScaItemRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribePropertyTypeScaItemResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribePropertyTypeScaItem',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribePropertyTypeScaItemResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_property_type_sca_item(
        self,
        request: sas_20181203_models.DescribePropertyTypeScaItemRequest,
    ) -> sas_20181203_models.DescribePropertyTypeScaItemResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_property_type_sca_item_with_options(request, runtime)

    async def describe_property_type_sca_item_async(
        self,
        request: sas_20181203_models.DescribePropertyTypeScaItemRequest,
    ) -> sas_20181203_models.DescribePropertyTypeScaItemResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_property_type_sca_item_with_options_async(request, runtime)

    def describe_property_usage_newest_with_options(
        self,
        request: sas_20181203_models.DescribePropertyUsageNewestRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribePropertyUsageNewestResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribePropertyUsageNewest',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribePropertyUsageNewestResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_property_usage_newest_with_options_async(
        self,
        request: sas_20181203_models.DescribePropertyUsageNewestRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribePropertyUsageNewestResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribePropertyUsageNewest',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribePropertyUsageNewestResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_property_usage_newest(
        self,
        request: sas_20181203_models.DescribePropertyUsageNewestRequest,
    ) -> sas_20181203_models.DescribePropertyUsageNewestResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_property_usage_newest_with_options(request, runtime)

    async def describe_property_usage_newest_async(
        self,
        request: sas_20181203_models.DescribePropertyUsageNewestRequest,
    ) -> sas_20181203_models.DescribePropertyUsageNewestResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_property_usage_newest_with_options_async(request, runtime)

    def describe_property_user_detail_with_options(
        self,
        request: sas_20181203_models.DescribePropertyUserDetailRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribePropertyUserDetailResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.extend):
            query['Extend'] = request.extend
        if not UtilClient.is_unset(request.is_root):
            query['IsRoot'] = request.is_root
        if not UtilClient.is_unset(request.last_login_time_end):
            query['LastLoginTimeEnd'] = request.last_login_time_end
        if not UtilClient.is_unset(request.last_login_time_start):
            query['LastLoginTimeStart'] = request.last_login_time_start
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.remark):
            query['Remark'] = request.remark
        if not UtilClient.is_unset(request.user):
            query['User'] = request.user
        if not UtilClient.is_unset(request.uuid):
            query['Uuid'] = request.uuid
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribePropertyUserDetail',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribePropertyUserDetailResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_property_user_detail_with_options_async(
        self,
        request: sas_20181203_models.DescribePropertyUserDetailRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribePropertyUserDetailResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.extend):
            query['Extend'] = request.extend
        if not UtilClient.is_unset(request.is_root):
            query['IsRoot'] = request.is_root
        if not UtilClient.is_unset(request.last_login_time_end):
            query['LastLoginTimeEnd'] = request.last_login_time_end
        if not UtilClient.is_unset(request.last_login_time_start):
            query['LastLoginTimeStart'] = request.last_login_time_start
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.remark):
            query['Remark'] = request.remark
        if not UtilClient.is_unset(request.user):
            query['User'] = request.user
        if not UtilClient.is_unset(request.uuid):
            query['Uuid'] = request.uuid
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribePropertyUserDetail',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribePropertyUserDetailResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_property_user_detail(
        self,
        request: sas_20181203_models.DescribePropertyUserDetailRequest,
    ) -> sas_20181203_models.DescribePropertyUserDetailResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_property_user_detail_with_options(request, runtime)

    async def describe_property_user_detail_async(
        self,
        request: sas_20181203_models.DescribePropertyUserDetailRequest,
    ) -> sas_20181203_models.DescribePropertyUserDetailResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_property_user_detail_with_options_async(request, runtime)

    def describe_property_user_item_with_options(
        self,
        request: sas_20181203_models.DescribePropertyUserItemRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribePropertyUserItemResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.force_flush):
            query['ForceFlush'] = request.force_flush
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.user):
            query['User'] = request.user
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribePropertyUserItem',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribePropertyUserItemResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_property_user_item_with_options_async(
        self,
        request: sas_20181203_models.DescribePropertyUserItemRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribePropertyUserItemResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.force_flush):
            query['ForceFlush'] = request.force_flush
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.user):
            query['User'] = request.user
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribePropertyUserItem',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribePropertyUserItemResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_property_user_item(
        self,
        request: sas_20181203_models.DescribePropertyUserItemRequest,
    ) -> sas_20181203_models.DescribePropertyUserItemResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_property_user_item_with_options(request, runtime)

    async def describe_property_user_item_async(
        self,
        request: sas_20181203_models.DescribePropertyUserItemRequest,
    ) -> sas_20181203_models.DescribePropertyUserItemResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_property_user_item_with_options_async(request, runtime)

    def describe_quara_file_download_info_with_options(
        self,
        request: sas_20181203_models.DescribeQuaraFileDownloadInfoRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeQuaraFileDownloadInfoResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.from_):
            query['From'] = request.from_
        if not UtilClient.is_unset(request.quara_file_id):
            query['QuaraFileId'] = request.quara_file_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeQuaraFileDownloadInfo',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeQuaraFileDownloadInfoResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_quara_file_download_info_with_options_async(
        self,
        request: sas_20181203_models.DescribeQuaraFileDownloadInfoRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeQuaraFileDownloadInfoResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.from_):
            query['From'] = request.from_
        if not UtilClient.is_unset(request.quara_file_id):
            query['QuaraFileId'] = request.quara_file_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeQuaraFileDownloadInfo',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeQuaraFileDownloadInfoResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_quara_file_download_info(
        self,
        request: sas_20181203_models.DescribeQuaraFileDownloadInfoRequest,
    ) -> sas_20181203_models.DescribeQuaraFileDownloadInfoResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_quara_file_download_info_with_options(request, runtime)

    async def describe_quara_file_download_info_async(
        self,
        request: sas_20181203_models.DescribeQuaraFileDownloadInfoRequest,
    ) -> sas_20181203_models.DescribeQuaraFileDownloadInfoResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_quara_file_download_info_with_options_async(request, runtime)

    def describe_restore_jobs_with_options(
        self,
        request: sas_20181203_models.DescribeRestoreJobsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeRestoreJobsResponse:
        """
        If the data on your servers is encrypted by ransomware, you can create a restoration task to restore the data on your servers by using backup data in Security Center.
        >  After you enable an anti-ransomware policy, the data on your servers is backed up based on the policy. For more information about anti-ransomware policies, see [Manage protection policies](~~164781~~).
        
        @param request: DescribeRestoreJobsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeRestoreJobsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.machine_remark):
            query['MachineRemark'] = request.machine_remark
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeRestoreJobs',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeRestoreJobsResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_restore_jobs_with_options_async(
        self,
        request: sas_20181203_models.DescribeRestoreJobsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeRestoreJobsResponse:
        """
        If the data on your servers is encrypted by ransomware, you can create a restoration task to restore the data on your servers by using backup data in Security Center.
        >  After you enable an anti-ransomware policy, the data on your servers is backed up based on the policy. For more information about anti-ransomware policies, see [Manage protection policies](~~164781~~).
        
        @param request: DescribeRestoreJobsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeRestoreJobsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.machine_remark):
            query['MachineRemark'] = request.machine_remark
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeRestoreJobs',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeRestoreJobsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_restore_jobs(
        self,
        request: sas_20181203_models.DescribeRestoreJobsRequest,
    ) -> sas_20181203_models.DescribeRestoreJobsResponse:
        """
        If the data on your servers is encrypted by ransomware, you can create a restoration task to restore the data on your servers by using backup data in Security Center.
        >  After you enable an anti-ransomware policy, the data on your servers is backed up based on the policy. For more information about anti-ransomware policies, see [Manage protection policies](~~164781~~).
        
        @param request: DescribeRestoreJobsRequest
        @return: DescribeRestoreJobsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_restore_jobs_with_options(request, runtime)

    async def describe_restore_jobs_async(
        self,
        request: sas_20181203_models.DescribeRestoreJobsRequest,
    ) -> sas_20181203_models.DescribeRestoreJobsResponse:
        """
        If the data on your servers is encrypted by ransomware, you can create a restoration task to restore the data on your servers by using backup data in Security Center.
        >  After you enable an anti-ransomware policy, the data on your servers is backed up based on the policy. For more information about anti-ransomware policies, see [Manage protection policies](~~164781~~).
        
        @param request: DescribeRestoreJobsRequest
        @return: DescribeRestoreJobsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_restore_jobs_with_options_async(request, runtime)

    def describe_restore_plans_with_options(
        self,
        request: sas_20181203_models.DescribeRestorePlansRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeRestorePlansResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.instance_name):
            query['InstanceName'] = request.instance_name
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeRestorePlans',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeRestorePlansResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_restore_plans_with_options_async(
        self,
        request: sas_20181203_models.DescribeRestorePlansRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeRestorePlansResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.instance_name):
            query['InstanceName'] = request.instance_name
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeRestorePlans',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeRestorePlansResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_restore_plans(
        self,
        request: sas_20181203_models.DescribeRestorePlansRequest,
    ) -> sas_20181203_models.DescribeRestorePlansResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_restore_plans_with_options(request, runtime)

    async def describe_restore_plans_async(
        self,
        request: sas_20181203_models.DescribeRestorePlansRequest,
    ) -> sas_20181203_models.DescribeRestorePlansResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_restore_plans_with_options_async(request, runtime)

    def describe_risk_check_item_result_with_options(
        self,
        request: sas_20181203_models.DescribeRiskCheckItemResultRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeRiskCheckItemResultResponse:
        """
        @deprecated
        
        @param request: DescribeRiskCheckItemResultRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeRiskCheckItemResultResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.item_id):
            query['ItemId'] = request.item_id
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeRiskCheckItemResult',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeRiskCheckItemResultResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_risk_check_item_result_with_options_async(
        self,
        request: sas_20181203_models.DescribeRiskCheckItemResultRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeRiskCheckItemResultResponse:
        """
        @deprecated
        
        @param request: DescribeRiskCheckItemResultRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeRiskCheckItemResultResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.item_id):
            query['ItemId'] = request.item_id
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeRiskCheckItemResult',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeRiskCheckItemResultResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_risk_check_item_result(
        self,
        request: sas_20181203_models.DescribeRiskCheckItemResultRequest,
    ) -> sas_20181203_models.DescribeRiskCheckItemResultResponse:
        """
        @deprecated
        
        @param request: DescribeRiskCheckItemResultRequest
        @return: DescribeRiskCheckItemResultResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_risk_check_item_result_with_options(request, runtime)

    async def describe_risk_check_item_result_async(
        self,
        request: sas_20181203_models.DescribeRiskCheckItemResultRequest,
    ) -> sas_20181203_models.DescribeRiskCheckItemResultResponse:
        """
        @deprecated
        
        @param request: DescribeRiskCheckItemResultRequest
        @return: DescribeRiskCheckItemResultResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_risk_check_item_result_with_options_async(request, runtime)

    def describe_risk_check_result_with_options(
        self,
        request: sas_20181203_models.DescribeRiskCheckResultRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeRiskCheckResultResponse:
        """
        @deprecated
        
        @param request: DescribeRiskCheckResultRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeRiskCheckResultResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.asset_type):
            query['AssetType'] = request.asset_type
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.group_id):
            query['GroupId'] = request.group_id
        if not UtilClient.is_unset(request.item_ids):
            query['ItemIds'] = request.item_ids
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.query_flag):
            query['QueryFlag'] = request.query_flag
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.risk_level):
            query['RiskLevel'] = request.risk_level
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeRiskCheckResult',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeRiskCheckResultResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_risk_check_result_with_options_async(
        self,
        request: sas_20181203_models.DescribeRiskCheckResultRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeRiskCheckResultResponse:
        """
        @deprecated
        
        @param request: DescribeRiskCheckResultRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeRiskCheckResultResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.asset_type):
            query['AssetType'] = request.asset_type
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.group_id):
            query['GroupId'] = request.group_id
        if not UtilClient.is_unset(request.item_ids):
            query['ItemIds'] = request.item_ids
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.query_flag):
            query['QueryFlag'] = request.query_flag
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.risk_level):
            query['RiskLevel'] = request.risk_level
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeRiskCheckResult',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeRiskCheckResultResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_risk_check_result(
        self,
        request: sas_20181203_models.DescribeRiskCheckResultRequest,
    ) -> sas_20181203_models.DescribeRiskCheckResultResponse:
        """
        @deprecated
        
        @param request: DescribeRiskCheckResultRequest
        @return: DescribeRiskCheckResultResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_risk_check_result_with_options(request, runtime)

    async def describe_risk_check_result_async(
        self,
        request: sas_20181203_models.DescribeRiskCheckResultRequest,
    ) -> sas_20181203_models.DescribeRiskCheckResultResponse:
        """
        @deprecated
        
        @param request: DescribeRiskCheckResultRequest
        @return: DescribeRiskCheckResultResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_risk_check_result_with_options_async(request, runtime)

    def describe_risk_check_summary_with_options(
        self,
        request: sas_20181203_models.DescribeRiskCheckSummaryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeRiskCheckSummaryResponse:
        """
        @deprecated
        
        @param request: DescribeRiskCheckSummaryRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeRiskCheckSummaryResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.resource_directory_account_id):
            query['ResourceDirectoryAccountId'] = request.resource_directory_account_id
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeRiskCheckSummary',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeRiskCheckSummaryResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_risk_check_summary_with_options_async(
        self,
        request: sas_20181203_models.DescribeRiskCheckSummaryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeRiskCheckSummaryResponse:
        """
        @deprecated
        
        @param request: DescribeRiskCheckSummaryRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeRiskCheckSummaryResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.resource_directory_account_id):
            query['ResourceDirectoryAccountId'] = request.resource_directory_account_id
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeRiskCheckSummary',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeRiskCheckSummaryResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_risk_check_summary(
        self,
        request: sas_20181203_models.DescribeRiskCheckSummaryRequest,
    ) -> sas_20181203_models.DescribeRiskCheckSummaryResponse:
        """
        @deprecated
        
        @param request: DescribeRiskCheckSummaryRequest
        @return: DescribeRiskCheckSummaryResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_risk_check_summary_with_options(request, runtime)

    async def describe_risk_check_summary_async(
        self,
        request: sas_20181203_models.DescribeRiskCheckSummaryRequest,
    ) -> sas_20181203_models.DescribeRiskCheckSummaryResponse:
        """
        @deprecated
        
        @param request: DescribeRiskCheckSummaryRequest
        @return: DescribeRiskCheckSummaryResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_risk_check_summary_with_options_async(request, runtime)

    def describe_risk_item_type_with_options(
        self,
        request: sas_20181203_models.DescribeRiskItemTypeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeRiskItemTypeResponse:
        """
        @deprecated
        
        @param request: DescribeRiskItemTypeRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeRiskItemTypeResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeRiskItemType',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeRiskItemTypeResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_risk_item_type_with_options_async(
        self,
        request: sas_20181203_models.DescribeRiskItemTypeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeRiskItemTypeResponse:
        """
        @deprecated
        
        @param request: DescribeRiskItemTypeRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeRiskItemTypeResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeRiskItemType',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeRiskItemTypeResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_risk_item_type(
        self,
        request: sas_20181203_models.DescribeRiskItemTypeRequest,
    ) -> sas_20181203_models.DescribeRiskItemTypeResponse:
        """
        @deprecated
        
        @param request: DescribeRiskItemTypeRequest
        @return: DescribeRiskItemTypeResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_risk_item_type_with_options(request, runtime)

    async def describe_risk_item_type_async(
        self,
        request: sas_20181203_models.DescribeRiskItemTypeRequest,
    ) -> sas_20181203_models.DescribeRiskItemTypeResponse:
        """
        @deprecated
        
        @param request: DescribeRiskItemTypeRequest
        @return: DescribeRiskItemTypeResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_risk_item_type_with_options_async(request, runtime)

    def describe_risk_list_check_result_with_options(
        self,
        request: sas_20181203_models.DescribeRiskListCheckResultRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeRiskListCheckResultResponse:
        """
        @deprecated
        
        @param request: DescribeRiskListCheckResultRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeRiskListCheckResultResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.instance_ids):
            query['InstanceIds'] = request.instance_ids
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeRiskListCheckResult',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeRiskListCheckResultResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_risk_list_check_result_with_options_async(
        self,
        request: sas_20181203_models.DescribeRiskListCheckResultRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeRiskListCheckResultResponse:
        """
        @deprecated
        
        @param request: DescribeRiskListCheckResultRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeRiskListCheckResultResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.instance_ids):
            query['InstanceIds'] = request.instance_ids
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeRiskListCheckResult',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeRiskListCheckResultResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_risk_list_check_result(
        self,
        request: sas_20181203_models.DescribeRiskListCheckResultRequest,
    ) -> sas_20181203_models.DescribeRiskListCheckResultResponse:
        """
        @deprecated
        
        @param request: DescribeRiskListCheckResultRequest
        @return: DescribeRiskListCheckResultResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_risk_list_check_result_with_options(request, runtime)

    async def describe_risk_list_check_result_async(
        self,
        request: sas_20181203_models.DescribeRiskListCheckResultRequest,
    ) -> sas_20181203_models.DescribeRiskListCheckResultResponse:
        """
        @deprecated
        
        @param request: DescribeRiskListCheckResultRequest
        @return: DescribeRiskListCheckResultResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_risk_list_check_result_with_options_async(request, runtime)

    def describe_risk_type_with_options(
        self,
        request: sas_20181203_models.DescribeRiskTypeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeRiskTypeResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeRiskType',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeRiskTypeResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_risk_type_with_options_async(
        self,
        request: sas_20181203_models.DescribeRiskTypeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeRiskTypeResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeRiskType',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeRiskTypeResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_risk_type(
        self,
        request: sas_20181203_models.DescribeRiskTypeRequest,
    ) -> sas_20181203_models.DescribeRiskTypeResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_risk_type_with_options(request, runtime)

    async def describe_risk_type_async(
        self,
        request: sas_20181203_models.DescribeRiskTypeRequest,
    ) -> sas_20181203_models.DescribeRiskTypeResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_risk_type_with_options_async(request, runtime)

    def describe_risks_with_options(
        self,
        request: sas_20181203_models.DescribeRisksRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeRisksResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.limit):
            query['Limit'] = request.limit
        if not UtilClient.is_unset(request.risk_id):
            query['RiskId'] = request.risk_id
        if not UtilClient.is_unset(request.risk_name):
            query['RiskName'] = request.risk_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeRisks',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeRisksResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_risks_with_options_async(
        self,
        request: sas_20181203_models.DescribeRisksRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeRisksResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.limit):
            query['Limit'] = request.limit
        if not UtilClient.is_unset(request.risk_id):
            query['RiskId'] = request.risk_id
        if not UtilClient.is_unset(request.risk_name):
            query['RiskName'] = request.risk_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeRisks',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeRisksResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_risks(
        self,
        request: sas_20181203_models.DescribeRisksRequest,
    ) -> sas_20181203_models.DescribeRisksResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_risks_with_options(request, runtime)

    async def describe_risks_async(
        self,
        request: sas_20181203_models.DescribeRisksRequest,
    ) -> sas_20181203_models.DescribeRisksResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_risks_with_options_async(request, runtime)

    def describe_sas_pm_agent_list_with_options(
        self,
        request: sas_20181203_models.DescribeSasPmAgentListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeSasPmAgentListResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.uuids):
            query['Uuids'] = request.uuids
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeSasPmAgentList',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeSasPmAgentListResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_sas_pm_agent_list_with_options_async(
        self,
        request: sas_20181203_models.DescribeSasPmAgentListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeSasPmAgentListResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.uuids):
            query['Uuids'] = request.uuids
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeSasPmAgentList',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeSasPmAgentListResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_sas_pm_agent_list(
        self,
        request: sas_20181203_models.DescribeSasPmAgentListRequest,
    ) -> sas_20181203_models.DescribeSasPmAgentListResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_sas_pm_agent_list_with_options(request, runtime)

    async def describe_sas_pm_agent_list_async(
        self,
        request: sas_20181203_models.DescribeSasPmAgentListRequest,
    ) -> sas_20181203_models.DescribeSasPmAgentListResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_sas_pm_agent_list_with_options_async(request, runtime)

    def describe_scan_task_progress_with_options(
        self,
        request: sas_20181203_models.DescribeScanTaskProgressRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeScanTaskProgressResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.task_id):
            query['TaskId'] = request.task_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeScanTaskProgress',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeScanTaskProgressResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_scan_task_progress_with_options_async(
        self,
        request: sas_20181203_models.DescribeScanTaskProgressRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeScanTaskProgressResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.task_id):
            query['TaskId'] = request.task_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeScanTaskProgress',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeScanTaskProgressResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_scan_task_progress(
        self,
        request: sas_20181203_models.DescribeScanTaskProgressRequest,
    ) -> sas_20181203_models.DescribeScanTaskProgressResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_scan_task_progress_with_options(request, runtime)

    async def describe_scan_task_progress_async(
        self,
        request: sas_20181203_models.DescribeScanTaskProgressRequest,
    ) -> sas_20181203_models.DescribeScanTaskProgressResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_scan_task_progress_with_options_async(request, runtime)

    def describe_scan_task_statistics_with_options(
        self,
        request: sas_20181203_models.DescribeScanTaskStatisticsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeScanTaskStatisticsResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.levels):
            query['Levels'] = request.levels
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeScanTaskStatistics',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeScanTaskStatisticsResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_scan_task_statistics_with_options_async(
        self,
        request: sas_20181203_models.DescribeScanTaskStatisticsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeScanTaskStatisticsResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.levels):
            query['Levels'] = request.levels
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeScanTaskStatistics',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeScanTaskStatisticsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_scan_task_statistics(
        self,
        request: sas_20181203_models.DescribeScanTaskStatisticsRequest,
    ) -> sas_20181203_models.DescribeScanTaskStatisticsResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_scan_task_statistics_with_options(request, runtime)

    async def describe_scan_task_statistics_async(
        self,
        request: sas_20181203_models.DescribeScanTaskStatisticsRequest,
    ) -> sas_20181203_models.DescribeScanTaskStatisticsResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_scan_task_statistics_with_options_async(request, runtime)

    def describe_search_condition_with_options(
        self,
        request: sas_20181203_models.DescribeSearchConditionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeSearchConditionResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeSearchCondition',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeSearchConditionResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_search_condition_with_options_async(
        self,
        request: sas_20181203_models.DescribeSearchConditionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeSearchConditionResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeSearchCondition',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeSearchConditionResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_search_condition(
        self,
        request: sas_20181203_models.DescribeSearchConditionRequest,
    ) -> sas_20181203_models.DescribeSearchConditionResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_search_condition_with_options(request, runtime)

    async def describe_search_condition_async(
        self,
        request: sas_20181203_models.DescribeSearchConditionRequest,
    ) -> sas_20181203_models.DescribeSearchConditionResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_search_condition_with_options_async(request, runtime)

    def describe_secure_suggestion_with_options(
        self,
        request: sas_20181203_models.DescribeSecureSuggestionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeSecureSuggestionResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeSecureSuggestion',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeSecureSuggestionResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_secure_suggestion_with_options_async(
        self,
        request: sas_20181203_models.DescribeSecureSuggestionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeSecureSuggestionResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeSecureSuggestion',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeSecureSuggestionResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_secure_suggestion(
        self,
        request: sas_20181203_models.DescribeSecureSuggestionRequest,
    ) -> sas_20181203_models.DescribeSecureSuggestionResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_secure_suggestion_with_options(request, runtime)

    async def describe_secure_suggestion_async(
        self,
        request: sas_20181203_models.DescribeSecureSuggestionRequest,
    ) -> sas_20181203_models.DescribeSecureSuggestionResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_secure_suggestion_with_options_async(request, runtime)

    def describe_security_check_schedule_config_with_options(
        self,
        request: sas_20181203_models.DescribeSecurityCheckScheduleConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeSecurityCheckScheduleConfigResponse:
        """
        @deprecated
        
        @param request: DescribeSecurityCheckScheduleConfigRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeSecurityCheckScheduleConfigResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeSecurityCheckScheduleConfig',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeSecurityCheckScheduleConfigResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_security_check_schedule_config_with_options_async(
        self,
        request: sas_20181203_models.DescribeSecurityCheckScheduleConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeSecurityCheckScheduleConfigResponse:
        """
        @deprecated
        
        @param request: DescribeSecurityCheckScheduleConfigRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeSecurityCheckScheduleConfigResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeSecurityCheckScheduleConfig',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeSecurityCheckScheduleConfigResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_security_check_schedule_config(
        self,
        request: sas_20181203_models.DescribeSecurityCheckScheduleConfigRequest,
    ) -> sas_20181203_models.DescribeSecurityCheckScheduleConfigResponse:
        """
        @deprecated
        
        @param request: DescribeSecurityCheckScheduleConfigRequest
        @return: DescribeSecurityCheckScheduleConfigResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_security_check_schedule_config_with_options(request, runtime)

    async def describe_security_check_schedule_config_async(
        self,
        request: sas_20181203_models.DescribeSecurityCheckScheduleConfigRequest,
    ) -> sas_20181203_models.DescribeSecurityCheckScheduleConfigResponse:
        """
        @deprecated
        
        @param request: DescribeSecurityCheckScheduleConfigRequest
        @return: DescribeSecurityCheckScheduleConfigResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_security_check_schedule_config_with_options_async(request, runtime)

    def describe_security_event_operation_status_with_options(
        self,
        request: sas_20181203_models.DescribeSecurityEventOperationStatusRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeSecurityEventOperationStatusResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.security_event_ids):
            query['SecurityEventIds'] = request.security_event_ids
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.task_id):
            query['TaskId'] = request.task_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeSecurityEventOperationStatus',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeSecurityEventOperationStatusResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_security_event_operation_status_with_options_async(
        self,
        request: sas_20181203_models.DescribeSecurityEventOperationStatusRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeSecurityEventOperationStatusResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.security_event_ids):
            query['SecurityEventIds'] = request.security_event_ids
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.task_id):
            query['TaskId'] = request.task_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeSecurityEventOperationStatus',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeSecurityEventOperationStatusResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_security_event_operation_status(
        self,
        request: sas_20181203_models.DescribeSecurityEventOperationStatusRequest,
    ) -> sas_20181203_models.DescribeSecurityEventOperationStatusResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_security_event_operation_status_with_options(request, runtime)

    async def describe_security_event_operation_status_async(
        self,
        request: sas_20181203_models.DescribeSecurityEventOperationStatusRequest,
    ) -> sas_20181203_models.DescribeSecurityEventOperationStatusResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_security_event_operation_status_with_options_async(request, runtime)

    def describe_security_event_operations_with_options(
        self,
        request: sas_20181203_models.DescribeSecurityEventOperationsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeSecurityEventOperationsResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.security_event_id):
            query['SecurityEventId'] = request.security_event_id
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeSecurityEventOperations',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeSecurityEventOperationsResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_security_event_operations_with_options_async(
        self,
        request: sas_20181203_models.DescribeSecurityEventOperationsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeSecurityEventOperationsResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.security_event_id):
            query['SecurityEventId'] = request.security_event_id
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeSecurityEventOperations',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeSecurityEventOperationsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_security_event_operations(
        self,
        request: sas_20181203_models.DescribeSecurityEventOperationsRequest,
    ) -> sas_20181203_models.DescribeSecurityEventOperationsResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_security_event_operations_with_options(request, runtime)

    async def describe_security_event_operations_async(
        self,
        request: sas_20181203_models.DescribeSecurityEventOperationsRequest,
    ) -> sas_20181203_models.DescribeSecurityEventOperationsResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_security_event_operations_with_options_async(request, runtime)

    def describe_security_stat_info_with_options(
        self,
        request: sas_20181203_models.DescribeSecurityStatInfoRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeSecurityStatInfoResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.resource_directory_account_id):
            query['ResourceDirectoryAccountId'] = request.resource_directory_account_id
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeSecurityStatInfo',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeSecurityStatInfoResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_security_stat_info_with_options_async(
        self,
        request: sas_20181203_models.DescribeSecurityStatInfoRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeSecurityStatInfoResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.resource_directory_account_id):
            query['ResourceDirectoryAccountId'] = request.resource_directory_account_id
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeSecurityStatInfo',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeSecurityStatInfoResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_security_stat_info(
        self,
        request: sas_20181203_models.DescribeSecurityStatInfoRequest,
    ) -> sas_20181203_models.DescribeSecurityStatInfoResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_security_stat_info_with_options(request, runtime)

    async def describe_security_stat_info_async(
        self,
        request: sas_20181203_models.DescribeSecurityStatInfoRequest,
    ) -> sas_20181203_models.DescribeSecurityStatInfoResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_security_stat_info_with_options_async(request, runtime)

    def describe_service_linked_role_status_with_options(
        self,
        request: sas_20181203_models.DescribeServiceLinkedRoleStatusRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeServiceLinkedRoleStatusResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.service_linked_role):
            query['ServiceLinkedRole'] = request.service_linked_role
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeServiceLinkedRoleStatus',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeServiceLinkedRoleStatusResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_service_linked_role_status_with_options_async(
        self,
        request: sas_20181203_models.DescribeServiceLinkedRoleStatusRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeServiceLinkedRoleStatusResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.service_linked_role):
            query['ServiceLinkedRole'] = request.service_linked_role
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeServiceLinkedRoleStatus',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeServiceLinkedRoleStatusResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_service_linked_role_status(
        self,
        request: sas_20181203_models.DescribeServiceLinkedRoleStatusRequest,
    ) -> sas_20181203_models.DescribeServiceLinkedRoleStatusResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_service_linked_role_status_with_options(request, runtime)

    async def describe_service_linked_role_status_async(
        self,
        request: sas_20181203_models.DescribeServiceLinkedRoleStatusRequest,
    ) -> sas_20181203_models.DescribeServiceLinkedRoleStatusResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_service_linked_role_status_with_options_async(request, runtime)

    def describe_similar_event_scenarios_with_options(
        self,
        request: sas_20181203_models.DescribeSimilarEventScenariosRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeSimilarEventScenariosResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.security_event_id):
            query['SecurityEventId'] = request.security_event_id
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeSimilarEventScenarios',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeSimilarEventScenariosResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_similar_event_scenarios_with_options_async(
        self,
        request: sas_20181203_models.DescribeSimilarEventScenariosRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeSimilarEventScenariosResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.security_event_id):
            query['SecurityEventId'] = request.security_event_id
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeSimilarEventScenarios',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeSimilarEventScenariosResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_similar_event_scenarios(
        self,
        request: sas_20181203_models.DescribeSimilarEventScenariosRequest,
    ) -> sas_20181203_models.DescribeSimilarEventScenariosResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_similar_event_scenarios_with_options(request, runtime)

    async def describe_similar_event_scenarios_async(
        self,
        request: sas_20181203_models.DescribeSimilarEventScenariosRequest,
    ) -> sas_20181203_models.DescribeSimilarEventScenariosResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_similar_event_scenarios_with_options_async(request, runtime)

    def describe_similar_security_events_with_options(
        self,
        request: sas_20181203_models.DescribeSimilarSecurityEventsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeSimilarSecurityEventsResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.task_id):
            query['TaskId'] = request.task_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeSimilarSecurityEvents',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeSimilarSecurityEventsResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_similar_security_events_with_options_async(
        self,
        request: sas_20181203_models.DescribeSimilarSecurityEventsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeSimilarSecurityEventsResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.task_id):
            query['TaskId'] = request.task_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeSimilarSecurityEvents',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeSimilarSecurityEventsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_similar_security_events(
        self,
        request: sas_20181203_models.DescribeSimilarSecurityEventsRequest,
    ) -> sas_20181203_models.DescribeSimilarSecurityEventsResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_similar_security_events_with_options(request, runtime)

    async def describe_similar_security_events_async(
        self,
        request: sas_20181203_models.DescribeSimilarSecurityEventsRequest,
    ) -> sas_20181203_models.DescribeSimilarSecurityEventsResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_similar_security_events_with_options_async(request, runtime)

    def describe_snapshots_with_options(
        self,
        request: sas_20181203_models.DescribeSnapshotsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeSnapshotsResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.api_version):
            query['ApiVersion'] = request.api_version
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.is_ali_yun_ecs):
            query['IsAliYunEcs'] = request.is_ali_yun_ecs
        if not UtilClient.is_unset(request.machine_region):
            query['MachineRegion'] = request.machine_region
        if not UtilClient.is_unset(request.machine_remark):
            query['MachineRemark'] = request.machine_remark
        if not UtilClient.is_unset(request.next_token):
            query['NextToken'] = request.next_token
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.status_list):
            query['StatusList'] = request.status_list
        if not UtilClient.is_unset(request.uuid):
            query['Uuid'] = request.uuid
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeSnapshots',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeSnapshotsResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_snapshots_with_options_async(
        self,
        request: sas_20181203_models.DescribeSnapshotsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeSnapshotsResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.api_version):
            query['ApiVersion'] = request.api_version
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.is_ali_yun_ecs):
            query['IsAliYunEcs'] = request.is_ali_yun_ecs
        if not UtilClient.is_unset(request.machine_region):
            query['MachineRegion'] = request.machine_region
        if not UtilClient.is_unset(request.machine_remark):
            query['MachineRemark'] = request.machine_remark
        if not UtilClient.is_unset(request.next_token):
            query['NextToken'] = request.next_token
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.status_list):
            query['StatusList'] = request.status_list
        if not UtilClient.is_unset(request.uuid):
            query['Uuid'] = request.uuid
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeSnapshots',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeSnapshotsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_snapshots(
        self,
        request: sas_20181203_models.DescribeSnapshotsRequest,
    ) -> sas_20181203_models.DescribeSnapshotsResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_snapshots_with_options(request, runtime)

    async def describe_snapshots_async(
        self,
        request: sas_20181203_models.DescribeSnapshotsRequest,
    ) -> sas_20181203_models.DescribeSnapshotsResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_snapshots_with_options_async(request, runtime)

    def describe_strategy_with_options(
        self,
        request: sas_20181203_models.DescribeStrategyRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeStrategyResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.custom_type):
            query['CustomType'] = request.custom_type
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.strategy_ids):
            query['StrategyIds'] = request.strategy_ids
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeStrategy',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeStrategyResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_strategy_with_options_async(
        self,
        request: sas_20181203_models.DescribeStrategyRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeStrategyResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.custom_type):
            query['CustomType'] = request.custom_type
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.strategy_ids):
            query['StrategyIds'] = request.strategy_ids
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeStrategy',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeStrategyResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_strategy(
        self,
        request: sas_20181203_models.DescribeStrategyRequest,
    ) -> sas_20181203_models.DescribeStrategyResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_strategy_with_options(request, runtime)

    async def describe_strategy_async(
        self,
        request: sas_20181203_models.DescribeStrategyRequest,
    ) -> sas_20181203_models.DescribeStrategyResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_strategy_with_options_async(request, runtime)

    def describe_strategy_detail_with_options(
        self,
        request: sas_20181203_models.DescribeStrategyDetailRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeStrategyDetailResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.id):
            query['Id'] = request.id
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeStrategyDetail',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeStrategyDetailResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_strategy_detail_with_options_async(
        self,
        request: sas_20181203_models.DescribeStrategyDetailRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeStrategyDetailResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.id):
            query['Id'] = request.id
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeStrategyDetail',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeStrategyDetailResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_strategy_detail(
        self,
        request: sas_20181203_models.DescribeStrategyDetailRequest,
    ) -> sas_20181203_models.DescribeStrategyDetailResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_strategy_detail_with_options(request, runtime)

    async def describe_strategy_detail_async(
        self,
        request: sas_20181203_models.DescribeStrategyDetailRequest,
    ) -> sas_20181203_models.DescribeStrategyDetailResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_strategy_detail_with_options_async(request, runtime)

    def describe_strategy_exec_detail_with_options(
        self,
        request: sas_20181203_models.DescribeStrategyExecDetailRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeStrategyExecDetailResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.strategy_id):
            query['StrategyId'] = request.strategy_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeStrategyExecDetail',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeStrategyExecDetailResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_strategy_exec_detail_with_options_async(
        self,
        request: sas_20181203_models.DescribeStrategyExecDetailRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeStrategyExecDetailResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.strategy_id):
            query['StrategyId'] = request.strategy_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeStrategyExecDetail',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeStrategyExecDetailResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_strategy_exec_detail(
        self,
        request: sas_20181203_models.DescribeStrategyExecDetailRequest,
    ) -> sas_20181203_models.DescribeStrategyExecDetailResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_strategy_exec_detail_with_options(request, runtime)

    async def describe_strategy_exec_detail_async(
        self,
        request: sas_20181203_models.DescribeStrategyExecDetailRequest,
    ) -> sas_20181203_models.DescribeStrategyExecDetailResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_strategy_exec_detail_with_options_async(request, runtime)

    def describe_strategy_target_with_options(
        self,
        request: sas_20181203_models.DescribeStrategyTargetRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeStrategyTargetResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.config):
            query['Config'] = request.config
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeStrategyTarget',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeStrategyTargetResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_strategy_target_with_options_async(
        self,
        request: sas_20181203_models.DescribeStrategyTargetRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeStrategyTargetResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.config):
            query['Config'] = request.config
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeStrategyTarget',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeStrategyTargetResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_strategy_target(
        self,
        request: sas_20181203_models.DescribeStrategyTargetRequest,
    ) -> sas_20181203_models.DescribeStrategyTargetResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_strategy_target_with_options(request, runtime)

    async def describe_strategy_target_async(
        self,
        request: sas_20181203_models.DescribeStrategyTargetRequest,
    ) -> sas_20181203_models.DescribeStrategyTargetResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_strategy_target_with_options_async(request, runtime)

    def describe_summary_info_with_options(
        self,
        request: sas_20181203_models.DescribeSummaryInfoRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeSummaryInfoResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeSummaryInfo',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeSummaryInfoResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_summary_info_with_options_async(
        self,
        request: sas_20181203_models.DescribeSummaryInfoRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeSummaryInfoResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeSummaryInfo',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeSummaryInfoResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_summary_info(
        self,
        request: sas_20181203_models.DescribeSummaryInfoRequest,
    ) -> sas_20181203_models.DescribeSummaryInfoResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_summary_info_with_options(request, runtime)

    async def describe_summary_info_async(
        self,
        request: sas_20181203_models.DescribeSummaryInfoRequest,
    ) -> sas_20181203_models.DescribeSummaryInfoResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_summary_info_with_options_async(request, runtime)

    def describe_support_region_with_options(
        self,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeSupportRegionResponse:
        req = open_api_models.OpenApiRequest()
        params = open_api_models.Params(
            action='DescribeSupportRegion',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeSupportRegionResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_support_region_with_options_async(
        self,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeSupportRegionResponse:
        req = open_api_models.OpenApiRequest()
        params = open_api_models.Params(
            action='DescribeSupportRegion',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeSupportRegionResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_support_region(self) -> sas_20181203_models.DescribeSupportRegionResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_support_region_with_options(runtime)

    async def describe_support_region_async(self) -> sas_20181203_models.DescribeSupportRegionResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_support_region_with_options_async(runtime)

    def describe_susp_event_detail_with_options(
        self,
        request: sas_20181203_models.DescribeSuspEventDetailRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeSuspEventDetailResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.from_):
            query['From'] = request.from_
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.suspicious_event_id):
            query['SuspiciousEventId'] = request.suspicious_event_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeSuspEventDetail',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeSuspEventDetailResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_susp_event_detail_with_options_async(
        self,
        request: sas_20181203_models.DescribeSuspEventDetailRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeSuspEventDetailResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.from_):
            query['From'] = request.from_
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.suspicious_event_id):
            query['SuspiciousEventId'] = request.suspicious_event_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeSuspEventDetail',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeSuspEventDetailResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_susp_event_detail(
        self,
        request: sas_20181203_models.DescribeSuspEventDetailRequest,
    ) -> sas_20181203_models.DescribeSuspEventDetailResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_susp_event_detail_with_options(request, runtime)

    async def describe_susp_event_detail_async(
        self,
        request: sas_20181203_models.DescribeSuspEventDetailRequest,
    ) -> sas_20181203_models.DescribeSuspEventDetailResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_susp_event_detail_with_options_async(request, runtime)

    def describe_susp_event_export_info_with_options(
        self,
        request: sas_20181203_models.DescribeSuspEventExportInfoRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeSuspEventExportInfoResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.export_id):
            query['ExportId'] = request.export_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeSuspEventExportInfo',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeSuspEventExportInfoResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_susp_event_export_info_with_options_async(
        self,
        request: sas_20181203_models.DescribeSuspEventExportInfoRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeSuspEventExportInfoResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.export_id):
            query['ExportId'] = request.export_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeSuspEventExportInfo',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeSuspEventExportInfoResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_susp_event_export_info(
        self,
        request: sas_20181203_models.DescribeSuspEventExportInfoRequest,
    ) -> sas_20181203_models.DescribeSuspEventExportInfoResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_susp_event_export_info_with_options(request, runtime)

    async def describe_susp_event_export_info_async(
        self,
        request: sas_20181203_models.DescribeSuspEventExportInfoRequest,
    ) -> sas_20181203_models.DescribeSuspEventExportInfoResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_susp_event_export_info_with_options_async(request, runtime)

    def describe_susp_event_quara_files_with_options(
        self,
        request: sas_20181203_models.DescribeSuspEventQuaraFilesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeSuspEventQuaraFilesResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.from_):
            query['From'] = request.from_
        if not UtilClient.is_unset(request.group_id):
            query['GroupId'] = request.group_id
        if not UtilClient.is_unset(request.grouping_id):
            query['GroupingId'] = request.grouping_id
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.quara_tag):
            query['QuaraTag'] = request.quara_tag
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeSuspEventQuaraFiles',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeSuspEventQuaraFilesResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_susp_event_quara_files_with_options_async(
        self,
        request: sas_20181203_models.DescribeSuspEventQuaraFilesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeSuspEventQuaraFilesResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.from_):
            query['From'] = request.from_
        if not UtilClient.is_unset(request.group_id):
            query['GroupId'] = request.group_id
        if not UtilClient.is_unset(request.grouping_id):
            query['GroupingId'] = request.grouping_id
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.quara_tag):
            query['QuaraTag'] = request.quara_tag
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeSuspEventQuaraFiles',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeSuspEventQuaraFilesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_susp_event_quara_files(
        self,
        request: sas_20181203_models.DescribeSuspEventQuaraFilesRequest,
    ) -> sas_20181203_models.DescribeSuspEventQuaraFilesResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_susp_event_quara_files_with_options(request, runtime)

    async def describe_susp_event_quara_files_async(
        self,
        request: sas_20181203_models.DescribeSuspEventQuaraFilesRequest,
    ) -> sas_20181203_models.DescribeSuspEventQuaraFilesResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_susp_event_quara_files_with_options_async(request, runtime)

    def describe_susp_event_user_setting_with_options(
        self,
        request: sas_20181203_models.DescribeSuspEventUserSettingRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeSuspEventUserSettingResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.from_):
            query['From'] = request.from_
        if not UtilClient.is_unset(request.id):
            query['Id'] = request.id
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeSuspEventUserSetting',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeSuspEventUserSettingResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_susp_event_user_setting_with_options_async(
        self,
        request: sas_20181203_models.DescribeSuspEventUserSettingRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeSuspEventUserSettingResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.from_):
            query['From'] = request.from_
        if not UtilClient.is_unset(request.id):
            query['Id'] = request.id
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeSuspEventUserSetting',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeSuspEventUserSettingResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_susp_event_user_setting(
        self,
        request: sas_20181203_models.DescribeSuspEventUserSettingRequest,
    ) -> sas_20181203_models.DescribeSuspEventUserSettingResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_susp_event_user_setting_with_options(request, runtime)

    async def describe_susp_event_user_setting_async(
        self,
        request: sas_20181203_models.DescribeSuspEventUserSettingRequest,
    ) -> sas_20181203_models.DescribeSuspEventUserSettingResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_susp_event_user_setting_with_options_async(request, runtime)

    def describe_susp_events_with_options(
        self,
        request: sas_20181203_models.DescribeSuspEventsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeSuspEventsResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.alarm_unique_info):
            query['AlarmUniqueInfo'] = request.alarm_unique_info
        if not UtilClient.is_unset(request.assets_type_list):
            query['AssetsTypeList'] = request.assets_type_list
        if not UtilClient.is_unset(request.cluster_id):
            query['ClusterId'] = request.cluster_id
        if not UtilClient.is_unset(request.container_field_name):
            query['ContainerFieldName'] = request.container_field_name
        if not UtilClient.is_unset(request.container_field_value):
            query['ContainerFieldValue'] = request.container_field_value
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.dealed):
            query['Dealed'] = request.dealed
        if not UtilClient.is_unset(request.event_names):
            query['EventNames'] = request.event_names
        if not UtilClient.is_unset(request.from_):
            query['From'] = request.from_
        if not UtilClient.is_unset(request.group_id):
            query['GroupId'] = request.group_id
        if not UtilClient.is_unset(request.id):
            query['Id'] = request.id
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.levels):
            query['Levels'] = request.levels
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.operate_error_code_list):
            query['OperateErrorCodeList'] = request.operate_error_code_list
        if not UtilClient.is_unset(request.operate_time_end):
            query['OperateTimeEnd'] = request.operate_time_end
        if not UtilClient.is_unset(request.operate_time_start):
            query['OperateTimeStart'] = request.operate_time_start
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.parent_event_types):
            query['ParentEventTypes'] = request.parent_event_types
        if not UtilClient.is_unset(request.remark):
            query['Remark'] = request.remark
        if not UtilClient.is_unset(request.sort_column):
            query['SortColumn'] = request.sort_column
        if not UtilClient.is_unset(request.sort_type):
            query['SortType'] = request.sort_type
        if not UtilClient.is_unset(request.source):
            query['Source'] = request.source
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        if not UtilClient.is_unset(request.target_type):
            query['TargetType'] = request.target_type
        if not UtilClient.is_unset(request.time_end):
            query['TimeEnd'] = request.time_end
        if not UtilClient.is_unset(request.time_start):
            query['TimeStart'] = request.time_start
        if not UtilClient.is_unset(request.unique_info):
            query['UniqueInfo'] = request.unique_info
        if not UtilClient.is_unset(request.uuids):
            query['Uuids'] = request.uuids
        body = {}
        if not UtilClient.is_unset(request.tactic_id):
            body['TacticId'] = request.tactic_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='DescribeSuspEvents',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeSuspEventsResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_susp_events_with_options_async(
        self,
        request: sas_20181203_models.DescribeSuspEventsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeSuspEventsResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.alarm_unique_info):
            query['AlarmUniqueInfo'] = request.alarm_unique_info
        if not UtilClient.is_unset(request.assets_type_list):
            query['AssetsTypeList'] = request.assets_type_list
        if not UtilClient.is_unset(request.cluster_id):
            query['ClusterId'] = request.cluster_id
        if not UtilClient.is_unset(request.container_field_name):
            query['ContainerFieldName'] = request.container_field_name
        if not UtilClient.is_unset(request.container_field_value):
            query['ContainerFieldValue'] = request.container_field_value
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.dealed):
            query['Dealed'] = request.dealed
        if not UtilClient.is_unset(request.event_names):
            query['EventNames'] = request.event_names
        if not UtilClient.is_unset(request.from_):
            query['From'] = request.from_
        if not UtilClient.is_unset(request.group_id):
            query['GroupId'] = request.group_id
        if not UtilClient.is_unset(request.id):
            query['Id'] = request.id
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.levels):
            query['Levels'] = request.levels
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.operate_error_code_list):
            query['OperateErrorCodeList'] = request.operate_error_code_list
        if not UtilClient.is_unset(request.operate_time_end):
            query['OperateTimeEnd'] = request.operate_time_end
        if not UtilClient.is_unset(request.operate_time_start):
            query['OperateTimeStart'] = request.operate_time_start
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.parent_event_types):
            query['ParentEventTypes'] = request.parent_event_types
        if not UtilClient.is_unset(request.remark):
            query['Remark'] = request.remark
        if not UtilClient.is_unset(request.sort_column):
            query['SortColumn'] = request.sort_column
        if not UtilClient.is_unset(request.sort_type):
            query['SortType'] = request.sort_type
        if not UtilClient.is_unset(request.source):
            query['Source'] = request.source
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        if not UtilClient.is_unset(request.target_type):
            query['TargetType'] = request.target_type
        if not UtilClient.is_unset(request.time_end):
            query['TimeEnd'] = request.time_end
        if not UtilClient.is_unset(request.time_start):
            query['TimeStart'] = request.time_start
        if not UtilClient.is_unset(request.unique_info):
            query['UniqueInfo'] = request.unique_info
        if not UtilClient.is_unset(request.uuids):
            query['Uuids'] = request.uuids
        body = {}
        if not UtilClient.is_unset(request.tactic_id):
            body['TacticId'] = request.tactic_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='DescribeSuspEvents',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeSuspEventsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_susp_events(
        self,
        request: sas_20181203_models.DescribeSuspEventsRequest,
    ) -> sas_20181203_models.DescribeSuspEventsResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_susp_events_with_options(request, runtime)

    async def describe_susp_events_async(
        self,
        request: sas_20181203_models.DescribeSuspEventsRequest,
    ) -> sas_20181203_models.DescribeSuspEventsResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_susp_events_with_options_async(request, runtime)

    def describe_suspicious_overall_config_with_options(
        self,
        request: sas_20181203_models.DescribeSuspiciousOverallConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeSuspiciousOverallConfigResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeSuspiciousOverallConfig',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeSuspiciousOverallConfigResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_suspicious_overall_config_with_options_async(
        self,
        request: sas_20181203_models.DescribeSuspiciousOverallConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeSuspiciousOverallConfigResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeSuspiciousOverallConfig',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeSuspiciousOverallConfigResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_suspicious_overall_config(
        self,
        request: sas_20181203_models.DescribeSuspiciousOverallConfigRequest,
    ) -> sas_20181203_models.DescribeSuspiciousOverallConfigResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_suspicious_overall_config_with_options(request, runtime)

    async def describe_suspicious_overall_config_async(
        self,
        request: sas_20181203_models.DescribeSuspiciousOverallConfigRequest,
    ) -> sas_20181203_models.DescribeSuspiciousOverallConfigResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_suspicious_overall_config_with_options_async(request, runtime)

    def describe_suspicious_uuidconfig_with_options(
        self,
        request: sas_20181203_models.DescribeSuspiciousUUIDConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeSuspiciousUUIDConfigResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeSuspiciousUUIDConfig',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeSuspiciousUUIDConfigResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_suspicious_uuidconfig_with_options_async(
        self,
        request: sas_20181203_models.DescribeSuspiciousUUIDConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeSuspiciousUUIDConfigResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeSuspiciousUUIDConfig',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeSuspiciousUUIDConfigResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_suspicious_uuidconfig(
        self,
        request: sas_20181203_models.DescribeSuspiciousUUIDConfigRequest,
    ) -> sas_20181203_models.DescribeSuspiciousUUIDConfigResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_suspicious_uuidconfig_with_options(request, runtime)

    async def describe_suspicious_uuidconfig_async(
        self,
        request: sas_20181203_models.DescribeSuspiciousUUIDConfigRequest,
    ) -> sas_20181203_models.DescribeSuspiciousUUIDConfigResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_suspicious_uuidconfig_with_options_async(request, runtime)

    def describe_target_with_options(
        self,
        request: sas_20181203_models.DescribeTargetRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeTargetResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.config):
            query['Config'] = request.config
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeTarget',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeTargetResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_target_with_options_async(
        self,
        request: sas_20181203_models.DescribeTargetRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeTargetResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.config):
            query['Config'] = request.config
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeTarget',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeTargetResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_target(
        self,
        request: sas_20181203_models.DescribeTargetRequest,
    ) -> sas_20181203_models.DescribeTargetResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_target_with_options(request, runtime)

    async def describe_target_async(
        self,
        request: sas_20181203_models.DescribeTargetRequest,
    ) -> sas_20181203_models.DescribeTargetResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_target_with_options_async(request, runtime)

    def describe_task_error_log_with_options(
        self,
        request: sas_20181203_models.DescribeTaskErrorLogRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeTaskErrorLogResponse:
        """
        # Usage notes
        You can call the DescribeTaskErrorLog operation to query the error logs that record tasks failed to fix image vulnerabilities. If a task fails to fix an image vulnerability, Security Center generates an error log. You can identify the cause of the failure based on the error log.
        
        # Limits
        You can call this operation up to 10 times per second for each account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DescribeTaskErrorLogRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeTaskErrorLogResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.build_task_id):
            query['BuildTaskId'] = request.build_task_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeTaskErrorLog',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeTaskErrorLogResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_task_error_log_with_options_async(
        self,
        request: sas_20181203_models.DescribeTaskErrorLogRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeTaskErrorLogResponse:
        """
        # Usage notes
        You can call the DescribeTaskErrorLog operation to query the error logs that record tasks failed to fix image vulnerabilities. If a task fails to fix an image vulnerability, Security Center generates an error log. You can identify the cause of the failure based on the error log.
        
        # Limits
        You can call this operation up to 10 times per second for each account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DescribeTaskErrorLogRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeTaskErrorLogResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.build_task_id):
            query['BuildTaskId'] = request.build_task_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeTaskErrorLog',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeTaskErrorLogResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_task_error_log(
        self,
        request: sas_20181203_models.DescribeTaskErrorLogRequest,
    ) -> sas_20181203_models.DescribeTaskErrorLogResponse:
        """
        # Usage notes
        You can call the DescribeTaskErrorLog operation to query the error logs that record tasks failed to fix image vulnerabilities. If a task fails to fix an image vulnerability, Security Center generates an error log. You can identify the cause of the failure based on the error log.
        
        # Limits
        You can call this operation up to 10 times per second for each account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DescribeTaskErrorLogRequest
        @return: DescribeTaskErrorLogResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_task_error_log_with_options(request, runtime)

    async def describe_task_error_log_async(
        self,
        request: sas_20181203_models.DescribeTaskErrorLogRequest,
    ) -> sas_20181203_models.DescribeTaskErrorLogResponse:
        """
        # Usage notes
        You can call the DescribeTaskErrorLog operation to query the error logs that record tasks failed to fix image vulnerabilities. If a task fails to fix an image vulnerability, Security Center generates an error log. You can identify the cause of the failure based on the error log.
        
        # Limits
        You can call this operation up to 10 times per second for each account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DescribeTaskErrorLogRequest
        @return: DescribeTaskErrorLogResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_task_error_log_with_options_async(request, runtime)

    def describe_total_statistics_with_options(
        self,
        request: sas_20181203_models.DescribeTotalStatisticsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeTotalStatisticsResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.from_):
            query['From'] = request.from_
        if not UtilClient.is_unset(request.group_id):
            query['GroupId'] = request.group_id
        if not UtilClient.is_unset(request.remark):
            query['Remark'] = request.remark
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeTotalStatistics',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeTotalStatisticsResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_total_statistics_with_options_async(
        self,
        request: sas_20181203_models.DescribeTotalStatisticsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeTotalStatisticsResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.from_):
            query['From'] = request.from_
        if not UtilClient.is_unset(request.group_id):
            query['GroupId'] = request.group_id
        if not UtilClient.is_unset(request.remark):
            query['Remark'] = request.remark
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeTotalStatistics',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeTotalStatisticsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_total_statistics(
        self,
        request: sas_20181203_models.DescribeTotalStatisticsRequest,
    ) -> sas_20181203_models.DescribeTotalStatisticsResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_total_statistics_with_options(request, runtime)

    async def describe_total_statistics_async(
        self,
        request: sas_20181203_models.DescribeTotalStatisticsRequest,
    ) -> sas_20181203_models.DescribeTotalStatisticsResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_total_statistics_with_options_async(request, runtime)

    def describe_trace_info_detail_with_options(
        self,
        request: sas_20181203_models.DescribeTraceInfoDetailRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeTraceInfoDetailResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.from_):
            query['From'] = request.from_
        if not UtilClient.is_unset(request.incident_time):
            query['IncidentTime'] = request.incident_time
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        if not UtilClient.is_unset(request.uuid):
            query['Uuid'] = request.uuid
        if not UtilClient.is_unset(request.vertex_id):
            query['VertexId'] = request.vertex_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeTraceInfoDetail',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeTraceInfoDetailResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_trace_info_detail_with_options_async(
        self,
        request: sas_20181203_models.DescribeTraceInfoDetailRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeTraceInfoDetailResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.from_):
            query['From'] = request.from_
        if not UtilClient.is_unset(request.incident_time):
            query['IncidentTime'] = request.incident_time
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        if not UtilClient.is_unset(request.uuid):
            query['Uuid'] = request.uuid
        if not UtilClient.is_unset(request.vertex_id):
            query['VertexId'] = request.vertex_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeTraceInfoDetail',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeTraceInfoDetailResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_trace_info_detail(
        self,
        request: sas_20181203_models.DescribeTraceInfoDetailRequest,
    ) -> sas_20181203_models.DescribeTraceInfoDetailResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_trace_info_detail_with_options(request, runtime)

    async def describe_trace_info_detail_async(
        self,
        request: sas_20181203_models.DescribeTraceInfoDetailRequest,
    ) -> sas_20181203_models.DescribeTraceInfoDetailResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_trace_info_detail_with_options_async(request, runtime)

    def describe_trace_info_node_with_options(
        self,
        request: sas_20181203_models.DescribeTraceInfoNodeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeTraceInfoNodeResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.event_name):
            query['EventName'] = request.event_name
        if not UtilClient.is_unset(request.from_):
            query['From'] = request.from_
        if not UtilClient.is_unset(request.incident_time):
            query['IncidentTime'] = request.incident_time
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        if not UtilClient.is_unset(request.uuid):
            query['Uuid'] = request.uuid
        if not UtilClient.is_unset(request.vertex_id):
            query['VertexId'] = request.vertex_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeTraceInfoNode',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeTraceInfoNodeResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_trace_info_node_with_options_async(
        self,
        request: sas_20181203_models.DescribeTraceInfoNodeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeTraceInfoNodeResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.event_name):
            query['EventName'] = request.event_name
        if not UtilClient.is_unset(request.from_):
            query['From'] = request.from_
        if not UtilClient.is_unset(request.incident_time):
            query['IncidentTime'] = request.incident_time
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        if not UtilClient.is_unset(request.uuid):
            query['Uuid'] = request.uuid
        if not UtilClient.is_unset(request.vertex_id):
            query['VertexId'] = request.vertex_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeTraceInfoNode',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeTraceInfoNodeResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_trace_info_node(
        self,
        request: sas_20181203_models.DescribeTraceInfoNodeRequest,
    ) -> sas_20181203_models.DescribeTraceInfoNodeResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_trace_info_node_with_options(request, runtime)

    async def describe_trace_info_node_async(
        self,
        request: sas_20181203_models.DescribeTraceInfoNodeRequest,
    ) -> sas_20181203_models.DescribeTraceInfoNodeResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_trace_info_node_with_options_async(request, runtime)

    def describe_uni_backup_database_with_options(
        self,
        request: sas_20181203_models.DescribeUniBackupDatabaseRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeUniBackupDatabaseResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.database_type):
            query['DatabaseType'] = request.database_type
        if not UtilClient.is_unset(request.instance_name):
            query['InstanceName'] = request.instance_name
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.query_type):
            query['QueryType'] = request.query_type
        if not UtilClient.is_unset(request.uni_region_id):
            query['UniRegionId'] = request.uni_region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeUniBackupDatabase',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeUniBackupDatabaseResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_uni_backup_database_with_options_async(
        self,
        request: sas_20181203_models.DescribeUniBackupDatabaseRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeUniBackupDatabaseResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.database_type):
            query['DatabaseType'] = request.database_type
        if not UtilClient.is_unset(request.instance_name):
            query['InstanceName'] = request.instance_name
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.query_type):
            query['QueryType'] = request.query_type
        if not UtilClient.is_unset(request.uni_region_id):
            query['UniRegionId'] = request.uni_region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeUniBackupDatabase',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeUniBackupDatabaseResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_uni_backup_database(
        self,
        request: sas_20181203_models.DescribeUniBackupDatabaseRequest,
    ) -> sas_20181203_models.DescribeUniBackupDatabaseResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_uni_backup_database_with_options(request, runtime)

    async def describe_uni_backup_database_async(
        self,
        request: sas_20181203_models.DescribeUniBackupDatabaseRequest,
    ) -> sas_20181203_models.DescribeUniBackupDatabaseResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_uni_backup_database_with_options_async(request, runtime)

    def describe_uni_backup_policies_with_options(
        self,
        request: sas_20181203_models.DescribeUniBackupPoliciesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeUniBackupPoliciesResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.policy_name):
            query['PolicyName'] = request.policy_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeUniBackupPolicies',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeUniBackupPoliciesResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_uni_backup_policies_with_options_async(
        self,
        request: sas_20181203_models.DescribeUniBackupPoliciesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeUniBackupPoliciesResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.policy_name):
            query['PolicyName'] = request.policy_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeUniBackupPolicies',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeUniBackupPoliciesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_uni_backup_policies(
        self,
        request: sas_20181203_models.DescribeUniBackupPoliciesRequest,
    ) -> sas_20181203_models.DescribeUniBackupPoliciesResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_uni_backup_policies_with_options(request, runtime)

    async def describe_uni_backup_policies_async(
        self,
        request: sas_20181203_models.DescribeUniBackupPoliciesRequest,
    ) -> sas_20181203_models.DescribeUniBackupPoliciesResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_uni_backup_policies_with_options_async(request, runtime)

    def describe_uni_backup_policy_detail_with_options(
        self,
        request: sas_20181203_models.DescribeUniBackupPolicyDetailRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeUniBackupPolicyDetailResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.policy_id):
            query['PolicyId'] = request.policy_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeUniBackupPolicyDetail',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeUniBackupPolicyDetailResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_uni_backup_policy_detail_with_options_async(
        self,
        request: sas_20181203_models.DescribeUniBackupPolicyDetailRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeUniBackupPolicyDetailResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.policy_id):
            query['PolicyId'] = request.policy_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeUniBackupPolicyDetail',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeUniBackupPolicyDetailResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_uni_backup_policy_detail(
        self,
        request: sas_20181203_models.DescribeUniBackupPolicyDetailRequest,
    ) -> sas_20181203_models.DescribeUniBackupPolicyDetailResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_uni_backup_policy_detail_with_options(request, runtime)

    async def describe_uni_backup_policy_detail_async(
        self,
        request: sas_20181203_models.DescribeUniBackupPolicyDetailRequest,
    ) -> sas_20181203_models.DescribeUniBackupPolicyDetailResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_uni_backup_policy_detail_with_options_async(request, runtime)

    def describe_uni_recoverable_list_with_options(
        self,
        request: sas_20181203_models.DescribeUniRecoverableListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeUniRecoverableListResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.database):
            query['Database'] = request.database
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.policy_id):
            query['PolicyId'] = request.policy_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeUniRecoverableList',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeUniRecoverableListResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_uni_recoverable_list_with_options_async(
        self,
        request: sas_20181203_models.DescribeUniRecoverableListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeUniRecoverableListResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.database):
            query['Database'] = request.database
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.policy_id):
            query['PolicyId'] = request.policy_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeUniRecoverableList',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeUniRecoverableListResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_uni_recoverable_list(
        self,
        request: sas_20181203_models.DescribeUniRecoverableListRequest,
    ) -> sas_20181203_models.DescribeUniRecoverableListResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_uni_recoverable_list_with_options(request, runtime)

    async def describe_uni_recoverable_list_async(
        self,
        request: sas_20181203_models.DescribeUniRecoverableListRequest,
    ) -> sas_20181203_models.DescribeUniRecoverableListResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_uni_recoverable_list_with_options_async(request, runtime)

    def describe_uni_support_region_with_options(
        self,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeUniSupportRegionResponse:
        req = open_api_models.OpenApiRequest()
        params = open_api_models.Params(
            action='DescribeUniSupportRegion',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeUniSupportRegionResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_uni_support_region_with_options_async(
        self,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeUniSupportRegionResponse:
        req = open_api_models.OpenApiRequest()
        params = open_api_models.Params(
            action='DescribeUniSupportRegion',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeUniSupportRegionResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_uni_support_region(self) -> sas_20181203_models.DescribeUniSupportRegionResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_uni_support_region_with_options(runtime)

    async def describe_uni_support_region_async(self) -> sas_20181203_models.DescribeUniSupportRegionResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_uni_support_region_with_options_async(runtime)

    def describe_user_backup_machines_with_options(
        self,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeUserBackupMachinesResponse:
        req = open_api_models.OpenApiRequest()
        params = open_api_models.Params(
            action='DescribeUserBackupMachines',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeUserBackupMachinesResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_user_backup_machines_with_options_async(
        self,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeUserBackupMachinesResponse:
        req = open_api_models.OpenApiRequest()
        params = open_api_models.Params(
            action='DescribeUserBackupMachines',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeUserBackupMachinesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_user_backup_machines(self) -> sas_20181203_models.DescribeUserBackupMachinesResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_user_backup_machines_with_options(runtime)

    async def describe_user_backup_machines_async(self) -> sas_20181203_models.DescribeUserBackupMachinesResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_user_backup_machines_with_options_async(runtime)

    def describe_user_baseline_authorization_with_options(
        self,
        request: sas_20181203_models.DescribeUserBaselineAuthorizationRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeUserBaselineAuthorizationResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeUserBaselineAuthorization',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeUserBaselineAuthorizationResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_user_baseline_authorization_with_options_async(
        self,
        request: sas_20181203_models.DescribeUserBaselineAuthorizationRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeUserBaselineAuthorizationResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeUserBaselineAuthorization',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeUserBaselineAuthorizationResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_user_baseline_authorization(
        self,
        request: sas_20181203_models.DescribeUserBaselineAuthorizationRequest,
    ) -> sas_20181203_models.DescribeUserBaselineAuthorizationResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_user_baseline_authorization_with_options(request, runtime)

    async def describe_user_baseline_authorization_async(
        self,
        request: sas_20181203_models.DescribeUserBaselineAuthorizationRequest,
    ) -> sas_20181203_models.DescribeUserBaselineAuthorizationResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_user_baseline_authorization_with_options_async(request, runtime)

    def describe_user_layout_authorization_with_options(
        self,
        request: sas_20181203_models.DescribeUserLayoutAuthorizationRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeUserLayoutAuthorizationResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeUserLayoutAuthorization',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeUserLayoutAuthorizationResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_user_layout_authorization_with_options_async(
        self,
        request: sas_20181203_models.DescribeUserLayoutAuthorizationRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeUserLayoutAuthorizationResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeUserLayoutAuthorization',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeUserLayoutAuthorizationResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_user_layout_authorization(
        self,
        request: sas_20181203_models.DescribeUserLayoutAuthorizationRequest,
    ) -> sas_20181203_models.DescribeUserLayoutAuthorizationResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_user_layout_authorization_with_options(request, runtime)

    async def describe_user_layout_authorization_async(
        self,
        request: sas_20181203_models.DescribeUserLayoutAuthorizationRequest,
    ) -> sas_20181203_models.DescribeUserLayoutAuthorizationResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_user_layout_authorization_with_options_async(request, runtime)

    def describe_uuids_by_vul_names_with_options(
        self,
        request: sas_20181203_models.DescribeUuidsByVulNamesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeUuidsByVulNamesResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dealed):
            query['Dealed'] = request.dealed
        if not UtilClient.is_unset(request.field_name):
            query['FieldName'] = request.field_name
        if not UtilClient.is_unset(request.field_value):
            query['FieldValue'] = request.field_value
        if not UtilClient.is_unset(request.group_id):
            query['GroupId'] = request.group_id
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.level):
            query['Level'] = request.level
        if not UtilClient.is_unset(request.necessity):
            query['Necessity'] = request.necessity
        if not UtilClient.is_unset(request.remark):
            query['Remark'] = request.remark
        if not UtilClient.is_unset(request.search_tags):
            query['SearchTags'] = request.search_tags
        if not UtilClient.is_unset(request.status_list):
            query['StatusList'] = request.status_list
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        if not UtilClient.is_unset(request.target_type):
            query['TargetType'] = request.target_type
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        if not UtilClient.is_unset(request.vpc_instance_ids):
            query['VpcInstanceIds'] = request.vpc_instance_ids
        if not UtilClient.is_unset(request.vul_names):
            query['VulNames'] = request.vul_names
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeUuidsByVulNames',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeUuidsByVulNamesResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_uuids_by_vul_names_with_options_async(
        self,
        request: sas_20181203_models.DescribeUuidsByVulNamesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeUuidsByVulNamesResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dealed):
            query['Dealed'] = request.dealed
        if not UtilClient.is_unset(request.field_name):
            query['FieldName'] = request.field_name
        if not UtilClient.is_unset(request.field_value):
            query['FieldValue'] = request.field_value
        if not UtilClient.is_unset(request.group_id):
            query['GroupId'] = request.group_id
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.level):
            query['Level'] = request.level
        if not UtilClient.is_unset(request.necessity):
            query['Necessity'] = request.necessity
        if not UtilClient.is_unset(request.remark):
            query['Remark'] = request.remark
        if not UtilClient.is_unset(request.search_tags):
            query['SearchTags'] = request.search_tags
        if not UtilClient.is_unset(request.status_list):
            query['StatusList'] = request.status_list
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        if not UtilClient.is_unset(request.target_type):
            query['TargetType'] = request.target_type
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        if not UtilClient.is_unset(request.vpc_instance_ids):
            query['VpcInstanceIds'] = request.vpc_instance_ids
        if not UtilClient.is_unset(request.vul_names):
            query['VulNames'] = request.vul_names
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeUuidsByVulNames',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeUuidsByVulNamesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_uuids_by_vul_names(
        self,
        request: sas_20181203_models.DescribeUuidsByVulNamesRequest,
    ) -> sas_20181203_models.DescribeUuidsByVulNamesResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_uuids_by_vul_names_with_options(request, runtime)

    async def describe_uuids_by_vul_names_async(
        self,
        request: sas_20181203_models.DescribeUuidsByVulNamesRequest,
    ) -> sas_20181203_models.DescribeUuidsByVulNamesResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_uuids_by_vul_names_with_options_async(request, runtime)

    def describe_vendor_list_with_options(
        self,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeVendorListResponse:
        req = open_api_models.OpenApiRequest()
        params = open_api_models.Params(
            action='DescribeVendorList',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeVendorListResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_vendor_list_with_options_async(
        self,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeVendorListResponse:
        req = open_api_models.OpenApiRequest()
        params = open_api_models.Params(
            action='DescribeVendorList',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeVendorListResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_vendor_list(self) -> sas_20181203_models.DescribeVendorListResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_vendor_list_with_options(runtime)

    async def describe_vendor_list_async(self) -> sas_20181203_models.DescribeVendorListResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_vendor_list_with_options_async(runtime)

    def describe_version_config_with_options(
        self,
        request: sas_20181203_models.DescribeVersionConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeVersionConfigResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.resource_directory_account_id):
            query['ResourceDirectoryAccountId'] = request.resource_directory_account_id
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeVersionConfig',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeVersionConfigResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_version_config_with_options_async(
        self,
        request: sas_20181203_models.DescribeVersionConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeVersionConfigResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.resource_directory_account_id):
            query['ResourceDirectoryAccountId'] = request.resource_directory_account_id
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeVersionConfig',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeVersionConfigResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_version_config(
        self,
        request: sas_20181203_models.DescribeVersionConfigRequest,
    ) -> sas_20181203_models.DescribeVersionConfigResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_version_config_with_options(request, runtime)

    async def describe_version_config_async(
        self,
        request: sas_20181203_models.DescribeVersionConfigRequest,
    ) -> sas_20181203_models.DescribeVersionConfigResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_version_config_with_options_async(request, runtime)

    def describe_vpc_honey_pot_criteria_with_options(
        self,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeVpcHoneyPotCriteriaResponse:
        req = open_api_models.OpenApiRequest()
        params = open_api_models.Params(
            action='DescribeVpcHoneyPotCriteria',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeVpcHoneyPotCriteriaResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_vpc_honey_pot_criteria_with_options_async(
        self,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeVpcHoneyPotCriteriaResponse:
        req = open_api_models.OpenApiRequest()
        params = open_api_models.Params(
            action='DescribeVpcHoneyPotCriteria',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeVpcHoneyPotCriteriaResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_vpc_honey_pot_criteria(self) -> sas_20181203_models.DescribeVpcHoneyPotCriteriaResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_vpc_honey_pot_criteria_with_options(runtime)

    async def describe_vpc_honey_pot_criteria_async(self) -> sas_20181203_models.DescribeVpcHoneyPotCriteriaResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_vpc_honey_pot_criteria_with_options_async(runtime)

    def describe_vpc_honey_pot_list_with_options(
        self,
        request: sas_20181203_models.DescribeVpcHoneyPotListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeVpcHoneyPotListResponse:
        """
        If you specify only the Action request parameter in your request, Security Center returns the list of all virtual private clouds (VPCs) regardless of whether a honeypot is deployed on a VPC.
        
        @param request: DescribeVpcHoneyPotListRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeVpcHoneyPotListResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.honey_pot_existence):
            query['HoneyPotExistence'] = request.honey_pot_existence
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        if not UtilClient.is_unset(request.vpc_name):
            query['VpcName'] = request.vpc_name
        if not UtilClient.is_unset(request.vpc_region_id):
            query['VpcRegionId'] = request.vpc_region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeVpcHoneyPotList',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeVpcHoneyPotListResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_vpc_honey_pot_list_with_options_async(
        self,
        request: sas_20181203_models.DescribeVpcHoneyPotListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeVpcHoneyPotListResponse:
        """
        If you specify only the Action request parameter in your request, Security Center returns the list of all virtual private clouds (VPCs) regardless of whether a honeypot is deployed on a VPC.
        
        @param request: DescribeVpcHoneyPotListRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeVpcHoneyPotListResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.honey_pot_existence):
            query['HoneyPotExistence'] = request.honey_pot_existence
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        if not UtilClient.is_unset(request.vpc_name):
            query['VpcName'] = request.vpc_name
        if not UtilClient.is_unset(request.vpc_region_id):
            query['VpcRegionId'] = request.vpc_region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeVpcHoneyPotList',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeVpcHoneyPotListResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_vpc_honey_pot_list(
        self,
        request: sas_20181203_models.DescribeVpcHoneyPotListRequest,
    ) -> sas_20181203_models.DescribeVpcHoneyPotListResponse:
        """
        If you specify only the Action request parameter in your request, Security Center returns the list of all virtual private clouds (VPCs) regardless of whether a honeypot is deployed on a VPC.
        
        @param request: DescribeVpcHoneyPotListRequest
        @return: DescribeVpcHoneyPotListResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_vpc_honey_pot_list_with_options(request, runtime)

    async def describe_vpc_honey_pot_list_async(
        self,
        request: sas_20181203_models.DescribeVpcHoneyPotListRequest,
    ) -> sas_20181203_models.DescribeVpcHoneyPotListResponse:
        """
        If you specify only the Action request parameter in your request, Security Center returns the list of all virtual private clouds (VPCs) regardless of whether a honeypot is deployed on a VPC.
        
        @param request: DescribeVpcHoneyPotListRequest
        @return: DescribeVpcHoneyPotListResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_vpc_honey_pot_list_with_options_async(request, runtime)

    def describe_vpc_list_with_options(
        self,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeVpcListResponse:
        req = open_api_models.OpenApiRequest()
        params = open_api_models.Params(
            action='DescribeVpcList',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeVpcListResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_vpc_list_with_options_async(
        self,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeVpcListResponse:
        req = open_api_models.OpenApiRequest()
        params = open_api_models.Params(
            action='DescribeVpcList',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeVpcListResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_vpc_list(self) -> sas_20181203_models.DescribeVpcListResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_vpc_list_with_options(runtime)

    async def describe_vpc_list_async(self) -> sas_20181203_models.DescribeVpcListResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_vpc_list_with_options_async(runtime)

    def describe_vul_check_task_status_detail_with_options(
        self,
        request: sas_20181203_models.DescribeVulCheckTaskStatusDetailRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeVulCheckTaskStatusDetailResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.task_ids):
            query['TaskIds'] = request.task_ids
        if not UtilClient.is_unset(request.types):
            query['Types'] = request.types
        if not UtilClient.is_unset(request.uuid):
            query['Uuid'] = request.uuid
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeVulCheckTaskStatusDetail',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeVulCheckTaskStatusDetailResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_vul_check_task_status_detail_with_options_async(
        self,
        request: sas_20181203_models.DescribeVulCheckTaskStatusDetailRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeVulCheckTaskStatusDetailResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.task_ids):
            query['TaskIds'] = request.task_ids
        if not UtilClient.is_unset(request.types):
            query['Types'] = request.types
        if not UtilClient.is_unset(request.uuid):
            query['Uuid'] = request.uuid
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeVulCheckTaskStatusDetail',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeVulCheckTaskStatusDetailResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_vul_check_task_status_detail(
        self,
        request: sas_20181203_models.DescribeVulCheckTaskStatusDetailRequest,
    ) -> sas_20181203_models.DescribeVulCheckTaskStatusDetailResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_vul_check_task_status_detail_with_options(request, runtime)

    async def describe_vul_check_task_status_detail_async(
        self,
        request: sas_20181203_models.DescribeVulCheckTaskStatusDetailRequest,
    ) -> sas_20181203_models.DescribeVulCheckTaskStatusDetailResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_vul_check_task_status_detail_with_options_async(request, runtime)

    def describe_vul_config_with_options(
        self,
        request: sas_20181203_models.DescribeVulConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeVulConfigResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeVulConfig',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeVulConfigResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_vul_config_with_options_async(
        self,
        request: sas_20181203_models.DescribeVulConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeVulConfigResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeVulConfig',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeVulConfigResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_vul_config(
        self,
        request: sas_20181203_models.DescribeVulConfigRequest,
    ) -> sas_20181203_models.DescribeVulConfigResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_vul_config_with_options(request, runtime)

    async def describe_vul_config_async(
        self,
        request: sas_20181203_models.DescribeVulConfigRequest,
    ) -> sas_20181203_models.DescribeVulConfigResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_vul_config_with_options_async(request, runtime)

    def describe_vul_details_with_options(
        self,
        request: sas_20181203_models.DescribeVulDetailsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeVulDetailsResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.alias_name):
            query['AliasName'] = request.alias_name
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeVulDetails',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeVulDetailsResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_vul_details_with_options_async(
        self,
        request: sas_20181203_models.DescribeVulDetailsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeVulDetailsResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.alias_name):
            query['AliasName'] = request.alias_name
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeVulDetails',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeVulDetailsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_vul_details(
        self,
        request: sas_20181203_models.DescribeVulDetailsRequest,
    ) -> sas_20181203_models.DescribeVulDetailsResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_vul_details_with_options(request, runtime)

    async def describe_vul_details_async(
        self,
        request: sas_20181203_models.DescribeVulDetailsRequest,
    ) -> sas_20181203_models.DescribeVulDetailsResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_vul_details_with_options_async(request, runtime)

    def describe_vul_export_info_with_options(
        self,
        request: sas_20181203_models.DescribeVulExportInfoRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeVulExportInfoResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.export_id):
            query['ExportId'] = request.export_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeVulExportInfo',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeVulExportInfoResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_vul_export_info_with_options_async(
        self,
        request: sas_20181203_models.DescribeVulExportInfoRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeVulExportInfoResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.export_id):
            query['ExportId'] = request.export_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeVulExportInfo',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeVulExportInfoResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_vul_export_info(
        self,
        request: sas_20181203_models.DescribeVulExportInfoRequest,
    ) -> sas_20181203_models.DescribeVulExportInfoResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_vul_export_info_with_options(request, runtime)

    async def describe_vul_export_info_async(
        self,
        request: sas_20181203_models.DescribeVulExportInfoRequest,
    ) -> sas_20181203_models.DescribeVulExportInfoResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_vul_export_info_with_options_async(request, runtime)

    def describe_vul_fix_statistics_with_options(
        self,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeVulFixStatisticsResponse:
        req = open_api_models.OpenApiRequest()
        params = open_api_models.Params(
            action='DescribeVulFixStatistics',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeVulFixStatisticsResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_vul_fix_statistics_with_options_async(
        self,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeVulFixStatisticsResponse:
        req = open_api_models.OpenApiRequest()
        params = open_api_models.Params(
            action='DescribeVulFixStatistics',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeVulFixStatisticsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_vul_fix_statistics(self) -> sas_20181203_models.DescribeVulFixStatisticsResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_vul_fix_statistics_with_options(runtime)

    async def describe_vul_fix_statistics_async(self) -> sas_20181203_models.DescribeVulFixStatisticsResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_vul_fix_statistics_with_options_async(runtime)

    def describe_vul_list_with_options(
        self,
        request: sas_20181203_models.DescribeVulListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeVulListResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.alias_name):
            query['AliasName'] = request.alias_name
        if not UtilClient.is_unset(request.attach_types):
            query['AttachTypes'] = request.attach_types
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.dealed):
            query['Dealed'] = request.dealed
        if not UtilClient.is_unset(request.group_id):
            query['GroupId'] = request.group_id
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.necessity):
            query['Necessity'] = request.necessity
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.remark):
            query['Remark'] = request.remark
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        if not UtilClient.is_unset(request.uuids):
            query['Uuids'] = request.uuids
        if not UtilClient.is_unset(request.vpc_instance_ids):
            query['VpcInstanceIds'] = request.vpc_instance_ids
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeVulList',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeVulListResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_vul_list_with_options_async(
        self,
        request: sas_20181203_models.DescribeVulListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeVulListResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.alias_name):
            query['AliasName'] = request.alias_name
        if not UtilClient.is_unset(request.attach_types):
            query['AttachTypes'] = request.attach_types
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.dealed):
            query['Dealed'] = request.dealed
        if not UtilClient.is_unset(request.group_id):
            query['GroupId'] = request.group_id
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.necessity):
            query['Necessity'] = request.necessity
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.remark):
            query['Remark'] = request.remark
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        if not UtilClient.is_unset(request.uuids):
            query['Uuids'] = request.uuids
        if not UtilClient.is_unset(request.vpc_instance_ids):
            query['VpcInstanceIds'] = request.vpc_instance_ids
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeVulList',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeVulListResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_vul_list(
        self,
        request: sas_20181203_models.DescribeVulListRequest,
    ) -> sas_20181203_models.DescribeVulListResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_vul_list_with_options(request, runtime)

    async def describe_vul_list_async(
        self,
        request: sas_20181203_models.DescribeVulListRequest,
    ) -> sas_20181203_models.DescribeVulListResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_vul_list_with_options_async(request, runtime)

    def describe_vul_list_page_with_options(
        self,
        request: sas_20181203_models.DescribeVulListPageRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeVulListPageResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.cve_id):
            query['CveId'] = request.cve_id
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.vul_name_like):
            query['VulNameLike'] = request.vul_name_like
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeVulListPage',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeVulListPageResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_vul_list_page_with_options_async(
        self,
        request: sas_20181203_models.DescribeVulListPageRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeVulListPageResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.cve_id):
            query['CveId'] = request.cve_id
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.vul_name_like):
            query['VulNameLike'] = request.vul_name_like
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeVulListPage',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeVulListPageResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_vul_list_page(
        self,
        request: sas_20181203_models.DescribeVulListPageRequest,
    ) -> sas_20181203_models.DescribeVulListPageResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_vul_list_page_with_options(request, runtime)

    async def describe_vul_list_page_async(
        self,
        request: sas_20181203_models.DescribeVulListPageRequest,
    ) -> sas_20181203_models.DescribeVulListPageResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_vul_list_page_with_options_async(request, runtime)

    def describe_vul_num_statistics_with_options(
        self,
        request: sas_20181203_models.DescribeVulNumStatisticsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeVulNumStatisticsResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.from_):
            query['From'] = request.from_
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeVulNumStatistics',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeVulNumStatisticsResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_vul_num_statistics_with_options_async(
        self,
        request: sas_20181203_models.DescribeVulNumStatisticsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeVulNumStatisticsResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.from_):
            query['From'] = request.from_
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeVulNumStatistics',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeVulNumStatisticsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_vul_num_statistics(
        self,
        request: sas_20181203_models.DescribeVulNumStatisticsRequest,
    ) -> sas_20181203_models.DescribeVulNumStatisticsResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_vul_num_statistics_with_options(request, runtime)

    async def describe_vul_num_statistics_async(
        self,
        request: sas_20181203_models.DescribeVulNumStatisticsRequest,
    ) -> sas_20181203_models.DescribeVulNumStatisticsResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_vul_num_statistics_with_options_async(request, runtime)

    def describe_vul_target_config_with_options(
        self,
        request: sas_20181203_models.DescribeVulTargetConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeVulTargetConfigResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        if not UtilClient.is_unset(request.uuid):
            query['Uuid'] = request.uuid
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeVulTargetConfig',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeVulTargetConfigResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_vul_target_config_with_options_async(
        self,
        request: sas_20181203_models.DescribeVulTargetConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeVulTargetConfigResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        if not UtilClient.is_unset(request.uuid):
            query['Uuid'] = request.uuid
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeVulTargetConfig',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeVulTargetConfigResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_vul_target_config(
        self,
        request: sas_20181203_models.DescribeVulTargetConfigRequest,
    ) -> sas_20181203_models.DescribeVulTargetConfigResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_vul_target_config_with_options(request, runtime)

    async def describe_vul_target_config_async(
        self,
        request: sas_20181203_models.DescribeVulTargetConfigRequest,
    ) -> sas_20181203_models.DescribeVulTargetConfigResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_vul_target_config_with_options_async(request, runtime)

    def describe_vul_target_statistics_with_options(
        self,
        request: sas_20181203_models.DescribeVulTargetStatisticsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeVulTargetStatisticsResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeVulTargetStatistics',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeVulTargetStatisticsResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_vul_target_statistics_with_options_async(
        self,
        request: sas_20181203_models.DescribeVulTargetStatisticsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeVulTargetStatisticsResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeVulTargetStatistics',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeVulTargetStatisticsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_vul_target_statistics(
        self,
        request: sas_20181203_models.DescribeVulTargetStatisticsRequest,
    ) -> sas_20181203_models.DescribeVulTargetStatisticsResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_vul_target_statistics_with_options(request, runtime)

    async def describe_vul_target_statistics_async(
        self,
        request: sas_20181203_models.DescribeVulTargetStatisticsRequest,
    ) -> sas_20181203_models.DescribeVulTargetStatisticsResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_vul_target_statistics_with_options_async(request, runtime)

    def describe_vul_whitelist_with_options(
        self,
        request: sas_20181203_models.DescribeVulWhitelistRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeVulWhitelistResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeVulWhitelist',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeVulWhitelistResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_vul_whitelist_with_options_async(
        self,
        request: sas_20181203_models.DescribeVulWhitelistRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeVulWhitelistResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeVulWhitelist',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeVulWhitelistResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_vul_whitelist(
        self,
        request: sas_20181203_models.DescribeVulWhitelistRequest,
    ) -> sas_20181203_models.DescribeVulWhitelistResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_vul_whitelist_with_options(request, runtime)

    async def describe_vul_whitelist_async(
        self,
        request: sas_20181203_models.DescribeVulWhitelistRequest,
    ) -> sas_20181203_models.DescribeVulWhitelistResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_vul_whitelist_with_options_async(request, runtime)

    def describe_warning_export_info_with_options(
        self,
        request: sas_20181203_models.DescribeWarningExportInfoRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeWarningExportInfoResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.export_id):
            query['ExportId'] = request.export_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeWarningExportInfo',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeWarningExportInfoResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_warning_export_info_with_options_async(
        self,
        request: sas_20181203_models.DescribeWarningExportInfoRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeWarningExportInfoResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.export_id):
            query['ExportId'] = request.export_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeWarningExportInfo',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeWarningExportInfoResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_warning_export_info(
        self,
        request: sas_20181203_models.DescribeWarningExportInfoRequest,
    ) -> sas_20181203_models.DescribeWarningExportInfoResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_warning_export_info_with_options(request, runtime)

    async def describe_warning_export_info_async(
        self,
        request: sas_20181203_models.DescribeWarningExportInfoRequest,
    ) -> sas_20181203_models.DescribeWarningExportInfoResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_warning_export_info_with_options_async(request, runtime)

    def describe_warning_machines_with_options(
        self,
        request: sas_20181203_models.DescribeWarningMachinesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeWarningMachinesResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cluster_id):
            query['ClusterId'] = request.cluster_id
        if not UtilClient.is_unset(request.container_field_name):
            query['ContainerFieldName'] = request.container_field_name
        if not UtilClient.is_unset(request.container_field_value):
            query['ContainerFieldValue'] = request.container_field_value
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.group_id):
            query['GroupId'] = request.group_id
        if not UtilClient.is_unset(request.have_risk):
            query['HaveRisk'] = request.have_risk
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.machine_name):
            query['MachineName'] = request.machine_name
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.risk_id):
            query['RiskId'] = request.risk_id
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.strategy_id):
            query['StrategyId'] = request.strategy_id
        if not UtilClient.is_unset(request.target_type):
            query['TargetType'] = request.target_type
        if not UtilClient.is_unset(request.uuids):
            query['Uuids'] = request.uuids
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeWarningMachines',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeWarningMachinesResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_warning_machines_with_options_async(
        self,
        request: sas_20181203_models.DescribeWarningMachinesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeWarningMachinesResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cluster_id):
            query['ClusterId'] = request.cluster_id
        if not UtilClient.is_unset(request.container_field_name):
            query['ContainerFieldName'] = request.container_field_name
        if not UtilClient.is_unset(request.container_field_value):
            query['ContainerFieldValue'] = request.container_field_value
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.group_id):
            query['GroupId'] = request.group_id
        if not UtilClient.is_unset(request.have_risk):
            query['HaveRisk'] = request.have_risk
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.machine_name):
            query['MachineName'] = request.machine_name
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.risk_id):
            query['RiskId'] = request.risk_id
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.strategy_id):
            query['StrategyId'] = request.strategy_id
        if not UtilClient.is_unset(request.target_type):
            query['TargetType'] = request.target_type
        if not UtilClient.is_unset(request.uuids):
            query['Uuids'] = request.uuids
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeWarningMachines',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeWarningMachinesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_warning_machines(
        self,
        request: sas_20181203_models.DescribeWarningMachinesRequest,
    ) -> sas_20181203_models.DescribeWarningMachinesResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_warning_machines_with_options(request, runtime)

    async def describe_warning_machines_async(
        self,
        request: sas_20181203_models.DescribeWarningMachinesRequest,
    ) -> sas_20181203_models.DescribeWarningMachinesResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_warning_machines_with_options_async(request, runtime)

    def describe_web_lock_bind_list_with_options(
        self,
        request: sas_20181203_models.DescribeWebLockBindListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeWebLockBindListResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.remark):
            query['Remark'] = request.remark
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeWebLockBindList',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeWebLockBindListResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_web_lock_bind_list_with_options_async(
        self,
        request: sas_20181203_models.DescribeWebLockBindListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeWebLockBindListResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.remark):
            query['Remark'] = request.remark
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeWebLockBindList',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeWebLockBindListResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_web_lock_bind_list(
        self,
        request: sas_20181203_models.DescribeWebLockBindListRequest,
    ) -> sas_20181203_models.DescribeWebLockBindListResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_web_lock_bind_list_with_options(request, runtime)

    async def describe_web_lock_bind_list_async(
        self,
        request: sas_20181203_models.DescribeWebLockBindListRequest,
    ) -> sas_20181203_models.DescribeWebLockBindListResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_web_lock_bind_list_with_options_async(request, runtime)

    def describe_web_lock_config_list_with_options(
        self,
        request: sas_20181203_models.DescribeWebLockConfigListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeWebLockConfigListResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.uuid):
            query['Uuid'] = request.uuid
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeWebLockConfigList',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeWebLockConfigListResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_web_lock_config_list_with_options_async(
        self,
        request: sas_20181203_models.DescribeWebLockConfigListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeWebLockConfigListResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.uuid):
            query['Uuid'] = request.uuid
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeWebLockConfigList',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeWebLockConfigListResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_web_lock_config_list(
        self,
        request: sas_20181203_models.DescribeWebLockConfigListRequest,
    ) -> sas_20181203_models.DescribeWebLockConfigListResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_web_lock_config_list_with_options(request, runtime)

    async def describe_web_lock_config_list_async(
        self,
        request: sas_20181203_models.DescribeWebLockConfigListRequest,
    ) -> sas_20181203_models.DescribeWebLockConfigListResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_web_lock_config_list_with_options_async(request, runtime)

    def describe_web_lock_exclusive_file_type_with_options(
        self,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeWebLockExclusiveFileTypeResponse:
        req = open_api_models.OpenApiRequest()
        params = open_api_models.Params(
            action='DescribeWebLockExclusiveFileType',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeWebLockExclusiveFileTypeResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_web_lock_exclusive_file_type_with_options_async(
        self,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeWebLockExclusiveFileTypeResponse:
        req = open_api_models.OpenApiRequest()
        params = open_api_models.Params(
            action='DescribeWebLockExclusiveFileType',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeWebLockExclusiveFileTypeResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_web_lock_exclusive_file_type(self) -> sas_20181203_models.DescribeWebLockExclusiveFileTypeResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_web_lock_exclusive_file_type_with_options(runtime)

    async def describe_web_lock_exclusive_file_type_async(self) -> sas_20181203_models.DescribeWebLockExclusiveFileTypeResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_web_lock_exclusive_file_type_with_options_async(runtime)

    def describe_web_lock_file_change_statistics_with_options(
        self,
        request: sas_20181203_models.DescribeWebLockFileChangeStatisticsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeWebLockFileChangeStatisticsResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeWebLockFileChangeStatistics',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeWebLockFileChangeStatisticsResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_web_lock_file_change_statistics_with_options_async(
        self,
        request: sas_20181203_models.DescribeWebLockFileChangeStatisticsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeWebLockFileChangeStatisticsResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeWebLockFileChangeStatistics',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeWebLockFileChangeStatisticsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_web_lock_file_change_statistics(
        self,
        request: sas_20181203_models.DescribeWebLockFileChangeStatisticsRequest,
    ) -> sas_20181203_models.DescribeWebLockFileChangeStatisticsResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_web_lock_file_change_statistics_with_options(request, runtime)

    async def describe_web_lock_file_change_statistics_async(
        self,
        request: sas_20181203_models.DescribeWebLockFileChangeStatisticsRequest,
    ) -> sas_20181203_models.DescribeWebLockFileChangeStatisticsResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_web_lock_file_change_statistics_with_options_async(request, runtime)

    def describe_web_lock_file_events_with_options(
        self,
        request: sas_20181203_models.DescribeWebLockFileEventsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeWebLockFileEventsResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.dealed):
            query['Dealed'] = request.dealed
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.process_name):
            query['ProcessName'] = request.process_name
        if not UtilClient.is_unset(request.remark):
            query['Remark'] = request.remark
        if not UtilClient.is_unset(request.ts_begin):
            query['TsBegin'] = request.ts_begin
        if not UtilClient.is_unset(request.ts_end):
            query['TsEnd'] = request.ts_end
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeWebLockFileEvents',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeWebLockFileEventsResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_web_lock_file_events_with_options_async(
        self,
        request: sas_20181203_models.DescribeWebLockFileEventsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeWebLockFileEventsResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.dealed):
            query['Dealed'] = request.dealed
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.process_name):
            query['ProcessName'] = request.process_name
        if not UtilClient.is_unset(request.remark):
            query['Remark'] = request.remark
        if not UtilClient.is_unset(request.ts_begin):
            query['TsBegin'] = request.ts_begin
        if not UtilClient.is_unset(request.ts_end):
            query['TsEnd'] = request.ts_end
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeWebLockFileEvents',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeWebLockFileEventsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_web_lock_file_events(
        self,
        request: sas_20181203_models.DescribeWebLockFileEventsRequest,
    ) -> sas_20181203_models.DescribeWebLockFileEventsResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_web_lock_file_events_with_options(request, runtime)

    async def describe_web_lock_file_events_async(
        self,
        request: sas_20181203_models.DescribeWebLockFileEventsRequest,
    ) -> sas_20181203_models.DescribeWebLockFileEventsResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_web_lock_file_events_with_options_async(request, runtime)

    def describe_web_lock_file_type_summary_with_options(
        self,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeWebLockFileTypeSummaryResponse:
        req = open_api_models.OpenApiRequest()
        params = open_api_models.Params(
            action='DescribeWebLockFileTypeSummary',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeWebLockFileTypeSummaryResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_web_lock_file_type_summary_with_options_async(
        self,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeWebLockFileTypeSummaryResponse:
        req = open_api_models.OpenApiRequest()
        params = open_api_models.Params(
            action='DescribeWebLockFileTypeSummary',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeWebLockFileTypeSummaryResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_web_lock_file_type_summary(self) -> sas_20181203_models.DescribeWebLockFileTypeSummaryResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_web_lock_file_type_summary_with_options(runtime)

    async def describe_web_lock_file_type_summary_async(self) -> sas_20181203_models.DescribeWebLockFileTypeSummaryResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_web_lock_file_type_summary_with_options_async(runtime)

    def describe_web_lock_inclusive_file_type_with_options(
        self,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeWebLockInclusiveFileTypeResponse:
        req = open_api_models.OpenApiRequest()
        params = open_api_models.Params(
            action='DescribeWebLockInclusiveFileType',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeWebLockInclusiveFileTypeResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_web_lock_inclusive_file_type_with_options_async(
        self,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeWebLockInclusiveFileTypeResponse:
        req = open_api_models.OpenApiRequest()
        params = open_api_models.Params(
            action='DescribeWebLockInclusiveFileType',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeWebLockInclusiveFileTypeResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_web_lock_inclusive_file_type(self) -> sas_20181203_models.DescribeWebLockInclusiveFileTypeResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_web_lock_inclusive_file_type_with_options(runtime)

    async def describe_web_lock_inclusive_file_type_async(self) -> sas_20181203_models.DescribeWebLockInclusiveFileTypeResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_web_lock_inclusive_file_type_with_options_async(runtime)

    def describe_web_lock_process_block_statistics_with_options(
        self,
        request: sas_20181203_models.DescribeWebLockProcessBlockStatisticsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeWebLockProcessBlockStatisticsResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeWebLockProcessBlockStatistics',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeWebLockProcessBlockStatisticsResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_web_lock_process_block_statistics_with_options_async(
        self,
        request: sas_20181203_models.DescribeWebLockProcessBlockStatisticsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeWebLockProcessBlockStatisticsResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeWebLockProcessBlockStatistics',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeWebLockProcessBlockStatisticsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_web_lock_process_block_statistics(
        self,
        request: sas_20181203_models.DescribeWebLockProcessBlockStatisticsRequest,
    ) -> sas_20181203_models.DescribeWebLockProcessBlockStatisticsResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_web_lock_process_block_statistics_with_options(request, runtime)

    async def describe_web_lock_process_block_statistics_async(
        self,
        request: sas_20181203_models.DescribeWebLockProcessBlockStatisticsRequest,
    ) -> sas_20181203_models.DescribeWebLockProcessBlockStatisticsResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_web_lock_process_block_statistics_with_options_async(request, runtime)

    def describe_web_lock_process_list_with_options(
        self,
        request: sas_20181203_models.DescribeWebLockProcessListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeWebLockProcessListResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.process_name):
            query['ProcessName'] = request.process_name
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeWebLockProcessList',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeWebLockProcessListResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_web_lock_process_list_with_options_async(
        self,
        request: sas_20181203_models.DescribeWebLockProcessListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeWebLockProcessListResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.process_name):
            query['ProcessName'] = request.process_name
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeWebLockProcessList',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeWebLockProcessListResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_web_lock_process_list(
        self,
        request: sas_20181203_models.DescribeWebLockProcessListRequest,
    ) -> sas_20181203_models.DescribeWebLockProcessListResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_web_lock_process_list_with_options(request, runtime)

    async def describe_web_lock_process_list_async(
        self,
        request: sas_20181203_models.DescribeWebLockProcessListRequest,
    ) -> sas_20181203_models.DescribeWebLockProcessListResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_web_lock_process_list_with_options_async(request, runtime)

    def describe_web_lock_status_with_options(
        self,
        request: sas_20181203_models.DescribeWebLockStatusRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeWebLockStatusResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.from_):
            query['From'] = request.from_
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeWebLockStatus',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeWebLockStatusResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_web_lock_status_with_options_async(
        self,
        request: sas_20181203_models.DescribeWebLockStatusRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeWebLockStatusResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.from_):
            query['From'] = request.from_
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeWebLockStatus',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeWebLockStatusResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_web_lock_status(
        self,
        request: sas_20181203_models.DescribeWebLockStatusRequest,
    ) -> sas_20181203_models.DescribeWebLockStatusResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_web_lock_status_with_options(request, runtime)

    async def describe_web_lock_status_async(
        self,
        request: sas_20181203_models.DescribeWebLockStatusRequest,
    ) -> sas_20181203_models.DescribeWebLockStatusResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_web_lock_status_with_options_async(request, runtime)

    def describe_web_lock_total_file_change_count_with_options(
        self,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeWebLockTotalFileChangeCountResponse:
        req = open_api_models.OpenApiRequest()
        params = open_api_models.Params(
            action='DescribeWebLockTotalFileChangeCount',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeWebLockTotalFileChangeCountResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_web_lock_total_file_change_count_with_options_async(
        self,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeWebLockTotalFileChangeCountResponse:
        req = open_api_models.OpenApiRequest()
        params = open_api_models.Params(
            action='DescribeWebLockTotalFileChangeCount',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeWebLockTotalFileChangeCountResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_web_lock_total_file_change_count(self) -> sas_20181203_models.DescribeWebLockTotalFileChangeCountResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_web_lock_total_file_change_count_with_options(runtime)

    async def describe_web_lock_total_file_change_count_async(self) -> sas_20181203_models.DescribeWebLockTotalFileChangeCountResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_web_lock_total_file_change_count_with_options_async(runtime)

    def describe_web_path_with_options(
        self,
        request: sas_20181203_models.DescribeWebPathRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeWebPathResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeWebPath',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeWebPathResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_web_path_with_options_async(
        self,
        request: sas_20181203_models.DescribeWebPathRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DescribeWebPathResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeWebPath',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DescribeWebPathResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_web_path(
        self,
        request: sas_20181203_models.DescribeWebPathRequest,
    ) -> sas_20181203_models.DescribeWebPathResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_web_path_with_options(request, runtime)

    async def describe_web_path_async(
        self,
        request: sas_20181203_models.DescribeWebPathRequest,
    ) -> sas_20181203_models.DescribeWebPathResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_web_path_with_options_async(request, runtime)

    def disable_brute_force_record_with_options(
        self,
        request: sas_20181203_models.DisableBruteForceRecordRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DisableBruteForceRecordResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.block_ip):
            query['BlockIp'] = request.block_ip
        if not UtilClient.is_unset(request.bound):
            query['Bound'] = request.bound
        if not UtilClient.is_unset(request.id):
            query['Id'] = request.id
        if not UtilClient.is_unset(request.port):
            query['Port'] = request.port
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.uuid):
            query['Uuid'] = request.uuid
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DisableBruteForceRecord',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DisableBruteForceRecordResponse(),
            self.call_api(params, req, runtime)
        )

    async def disable_brute_force_record_with_options_async(
        self,
        request: sas_20181203_models.DisableBruteForceRecordRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DisableBruteForceRecordResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.block_ip):
            query['BlockIp'] = request.block_ip
        if not UtilClient.is_unset(request.bound):
            query['Bound'] = request.bound
        if not UtilClient.is_unset(request.id):
            query['Id'] = request.id
        if not UtilClient.is_unset(request.port):
            query['Port'] = request.port
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.uuid):
            query['Uuid'] = request.uuid
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DisableBruteForceRecord',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DisableBruteForceRecordResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def disable_brute_force_record(
        self,
        request: sas_20181203_models.DisableBruteForceRecordRequest,
    ) -> sas_20181203_models.DisableBruteForceRecordResponse:
        runtime = util_models.RuntimeOptions()
        return self.disable_brute_force_record_with_options(request, runtime)

    async def disable_brute_force_record_async(
        self,
        request: sas_20181203_models.DisableBruteForceRecordRequest,
    ) -> sas_20181203_models.DisableBruteForceRecordResponse:
        runtime = util_models.RuntimeOptions()
        return await self.disable_brute_force_record_with_options_async(request, runtime)

    def disable_custom_block_record_with_options(
        self,
        request: sas_20181203_models.DisableCustomBlockRecordRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DisableCustomBlockRecordResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.block_ip):
            query['BlockIp'] = request.block_ip
        if not UtilClient.is_unset(request.bound):
            query['Bound'] = request.bound
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DisableCustomBlockRecord',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DisableCustomBlockRecordResponse(),
            self.call_api(params, req, runtime)
        )

    async def disable_custom_block_record_with_options_async(
        self,
        request: sas_20181203_models.DisableCustomBlockRecordRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.DisableCustomBlockRecordResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.block_ip):
            query['BlockIp'] = request.block_ip
        if not UtilClient.is_unset(request.bound):
            query['Bound'] = request.bound
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DisableCustomBlockRecord',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.DisableCustomBlockRecordResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def disable_custom_block_record(
        self,
        request: sas_20181203_models.DisableCustomBlockRecordRequest,
    ) -> sas_20181203_models.DisableCustomBlockRecordResponse:
        runtime = util_models.RuntimeOptions()
        return self.disable_custom_block_record_with_options(request, runtime)

    async def disable_custom_block_record_async(
        self,
        request: sas_20181203_models.DisableCustomBlockRecordRequest,
    ) -> sas_20181203_models.DisableCustomBlockRecordResponse:
        runtime = util_models.RuntimeOptions()
        return await self.disable_custom_block_record_with_options_async(request, runtime)

    def enable_brute_force_record_with_options(
        self,
        request: sas_20181203_models.EnableBruteForceRecordRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.EnableBruteForceRecordResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.block_ip):
            query['BlockIp'] = request.block_ip
        if not UtilClient.is_unset(request.bound):
            query['Bound'] = request.bound
        if not UtilClient.is_unset(request.id):
            query['Id'] = request.id
        if not UtilClient.is_unset(request.port):
            query['Port'] = request.port
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.uuid):
            query['Uuid'] = request.uuid
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='EnableBruteForceRecord',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.EnableBruteForceRecordResponse(),
            self.call_api(params, req, runtime)
        )

    async def enable_brute_force_record_with_options_async(
        self,
        request: sas_20181203_models.EnableBruteForceRecordRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.EnableBruteForceRecordResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.block_ip):
            query['BlockIp'] = request.block_ip
        if not UtilClient.is_unset(request.bound):
            query['Bound'] = request.bound
        if not UtilClient.is_unset(request.id):
            query['Id'] = request.id
        if not UtilClient.is_unset(request.port):
            query['Port'] = request.port
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.uuid):
            query['Uuid'] = request.uuid
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='EnableBruteForceRecord',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.EnableBruteForceRecordResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def enable_brute_force_record(
        self,
        request: sas_20181203_models.EnableBruteForceRecordRequest,
    ) -> sas_20181203_models.EnableBruteForceRecordResponse:
        runtime = util_models.RuntimeOptions()
        return self.enable_brute_force_record_with_options(request, runtime)

    async def enable_brute_force_record_async(
        self,
        request: sas_20181203_models.EnableBruteForceRecordRequest,
    ) -> sas_20181203_models.EnableBruteForceRecordResponse:
        runtime = util_models.RuntimeOptions()
        return await self.enable_brute_force_record_with_options_async(request, runtime)

    def enable_custom_block_record_with_options(
        self,
        request: sas_20181203_models.EnableCustomBlockRecordRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.EnableCustomBlockRecordResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.block_ip):
            query['BlockIp'] = request.block_ip
        if not UtilClient.is_unset(request.bound):
            query['Bound'] = request.bound
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='EnableCustomBlockRecord',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.EnableCustomBlockRecordResponse(),
            self.call_api(params, req, runtime)
        )

    async def enable_custom_block_record_with_options_async(
        self,
        request: sas_20181203_models.EnableCustomBlockRecordRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.EnableCustomBlockRecordResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.block_ip):
            query['BlockIp'] = request.block_ip
        if not UtilClient.is_unset(request.bound):
            query['Bound'] = request.bound
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='EnableCustomBlockRecord',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.EnableCustomBlockRecordResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def enable_custom_block_record(
        self,
        request: sas_20181203_models.EnableCustomBlockRecordRequest,
    ) -> sas_20181203_models.EnableCustomBlockRecordResponse:
        runtime = util_models.RuntimeOptions()
        return self.enable_custom_block_record_with_options(request, runtime)

    async def enable_custom_block_record_async(
        self,
        request: sas_20181203_models.EnableCustomBlockRecordRequest,
    ) -> sas_20181203_models.EnableCustomBlockRecordResponse:
        runtime = util_models.RuntimeOptions()
        return await self.enable_custom_block_record_with_options_async(request, runtime)

    def exec_strategy_with_options(
        self,
        request: sas_20181203_models.ExecStrategyRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.ExecStrategyResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.strategy_id):
            query['StrategyId'] = request.strategy_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ExecStrategy',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.ExecStrategyResponse(),
            self.call_api(params, req, runtime)
        )

    async def exec_strategy_with_options_async(
        self,
        request: sas_20181203_models.ExecStrategyRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.ExecStrategyResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.strategy_id):
            query['StrategyId'] = request.strategy_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ExecStrategy',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.ExecStrategyResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def exec_strategy(
        self,
        request: sas_20181203_models.ExecStrategyRequest,
    ) -> sas_20181203_models.ExecStrategyResponse:
        runtime = util_models.RuntimeOptions()
        return self.exec_strategy_with_options(request, runtime)

    async def exec_strategy_async(
        self,
        request: sas_20181203_models.ExecStrategyRequest,
    ) -> sas_20181203_models.ExecStrategyResponse:
        runtime = util_models.RuntimeOptions()
        return await self.exec_strategy_with_options_async(request, runtime)

    def export_record_with_options(
        self,
        request: sas_20181203_models.ExportRecordRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.ExportRecordResponse:
        """
        You can call the operation to export the following check result lists:
        *   The list of servers on the Host page.
        *   The lists of image system vulnerabilities, image application vulnerabilities, image baseline check results, and malicious image samples on the Image Security page.
        *   The list of attack analysis data on the Attack Awareness page.
        *   The list of check results for AccessKey pair leaks on the AccessKey Leak page.
        
        @param request: ExportRecordRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ExportRecordResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.export_type):
            query['ExportType'] = request.export_type
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.params):
            query['Params'] = request.params
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ExportRecord',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.ExportRecordResponse(),
            self.call_api(params, req, runtime)
        )

    async def export_record_with_options_async(
        self,
        request: sas_20181203_models.ExportRecordRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.ExportRecordResponse:
        """
        You can call the operation to export the following check result lists:
        *   The list of servers on the Host page.
        *   The lists of image system vulnerabilities, image application vulnerabilities, image baseline check results, and malicious image samples on the Image Security page.
        *   The list of attack analysis data on the Attack Awareness page.
        *   The list of check results for AccessKey pair leaks on the AccessKey Leak page.
        
        @param request: ExportRecordRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ExportRecordResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.export_type):
            query['ExportType'] = request.export_type
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.params):
            query['Params'] = request.params
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ExportRecord',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.ExportRecordResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def export_record(
        self,
        request: sas_20181203_models.ExportRecordRequest,
    ) -> sas_20181203_models.ExportRecordResponse:
        """
        You can call the operation to export the following check result lists:
        *   The list of servers on the Host page.
        *   The lists of image system vulnerabilities, image application vulnerabilities, image baseline check results, and malicious image samples on the Image Security page.
        *   The list of attack analysis data on the Attack Awareness page.
        *   The list of check results for AccessKey pair leaks on the AccessKey Leak page.
        
        @param request: ExportRecordRequest
        @return: ExportRecordResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.export_record_with_options(request, runtime)

    async def export_record_async(
        self,
        request: sas_20181203_models.ExportRecordRequest,
    ) -> sas_20181203_models.ExportRecordResponse:
        """
        You can call the operation to export the following check result lists:
        *   The list of servers on the Host page.
        *   The lists of image system vulnerabilities, image application vulnerabilities, image baseline check results, and malicious image samples on the Image Security page.
        *   The list of attack analysis data on the Attack Awareness page.
        *   The list of check results for AccessKey pair leaks on the AccessKey Leak page.
        
        @param request: ExportRecordRequest
        @return: ExportRecordResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.export_record_with_options_async(request, runtime)

    def export_susp_events_with_options(
        self,
        request: sas_20181203_models.ExportSuspEventsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.ExportSuspEventsResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.assets_type_list):
            query['AssetsTypeList'] = request.assets_type_list
        if not UtilClient.is_unset(request.cluster_id):
            query['ClusterId'] = request.cluster_id
        if not UtilClient.is_unset(request.container_field_name):
            query['ContainerFieldName'] = request.container_field_name
        if not UtilClient.is_unset(request.container_field_value):
            query['ContainerFieldValue'] = request.container_field_value
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.dealed):
            query['Dealed'] = request.dealed
        if not UtilClient.is_unset(request.from_):
            query['From'] = request.from_
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.levels):
            query['Levels'] = request.levels
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.parent_event_types):
            query['ParentEventTypes'] = request.parent_event_types
        if not UtilClient.is_unset(request.remark):
            query['Remark'] = request.remark
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        if not UtilClient.is_unset(request.target_type):
            query['TargetType'] = request.target_type
        if not UtilClient.is_unset(request.time_end):
            query['TimeEnd'] = request.time_end
        if not UtilClient.is_unset(request.time_start):
            query['TimeStart'] = request.time_start
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ExportSuspEvents',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.ExportSuspEventsResponse(),
            self.call_api(params, req, runtime)
        )

    async def export_susp_events_with_options_async(
        self,
        request: sas_20181203_models.ExportSuspEventsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.ExportSuspEventsResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.assets_type_list):
            query['AssetsTypeList'] = request.assets_type_list
        if not UtilClient.is_unset(request.cluster_id):
            query['ClusterId'] = request.cluster_id
        if not UtilClient.is_unset(request.container_field_name):
            query['ContainerFieldName'] = request.container_field_name
        if not UtilClient.is_unset(request.container_field_value):
            query['ContainerFieldValue'] = request.container_field_value
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.dealed):
            query['Dealed'] = request.dealed
        if not UtilClient.is_unset(request.from_):
            query['From'] = request.from_
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.levels):
            query['Levels'] = request.levels
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.parent_event_types):
            query['ParentEventTypes'] = request.parent_event_types
        if not UtilClient.is_unset(request.remark):
            query['Remark'] = request.remark
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        if not UtilClient.is_unset(request.target_type):
            query['TargetType'] = request.target_type
        if not UtilClient.is_unset(request.time_end):
            query['TimeEnd'] = request.time_end
        if not UtilClient.is_unset(request.time_start):
            query['TimeStart'] = request.time_start
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ExportSuspEvents',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.ExportSuspEventsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def export_susp_events(
        self,
        request: sas_20181203_models.ExportSuspEventsRequest,
    ) -> sas_20181203_models.ExportSuspEventsResponse:
        runtime = util_models.RuntimeOptions()
        return self.export_susp_events_with_options(request, runtime)

    async def export_susp_events_async(
        self,
        request: sas_20181203_models.ExportSuspEventsRequest,
    ) -> sas_20181203_models.ExportSuspEventsResponse:
        runtime = util_models.RuntimeOptions()
        return await self.export_susp_events_with_options_async(request, runtime)

    def export_vul_with_options(
        self,
        request: sas_20181203_models.ExportVulRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.ExportVulResponse:
        """
        You can call the ExportVul operation to export the following types of vulnerabilities: Linux software vulnerabilities, Windows system vulnerabilities, Web-CMS vulnerabilities, application vulnerabilities, and urgent vulnerabilities.
        You can use this operation together with the DescribeVulExportInfo operation. After you call the ExportVul operation to create a vulnerability export task, you can call the DescribeVulExportInfo operation to query the progress of the task by specifying the ID of the task.
        ### Limits
        You can call this operation up to 10 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: ExportVulRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ExportVulResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.alias_name):
            query['AliasName'] = request.alias_name
        if not UtilClient.is_unset(request.attach_types):
            query['AttachTypes'] = request.attach_types
        if not UtilClient.is_unset(request.dealed):
            query['Dealed'] = request.dealed
        if not UtilClient.is_unset(request.group_id):
            query['GroupId'] = request.group_id
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.necessity):
            query['Necessity'] = request.necessity
        if not UtilClient.is_unset(request.search_tags):
            query['SearchTags'] = request.search_tags
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        if not UtilClient.is_unset(request.uuids):
            query['Uuids'] = request.uuids
        if not UtilClient.is_unset(request.vpc_instance_ids):
            query['VpcInstanceIds'] = request.vpc_instance_ids
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ExportVul',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.ExportVulResponse(),
            self.call_api(params, req, runtime)
        )

    async def export_vul_with_options_async(
        self,
        request: sas_20181203_models.ExportVulRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.ExportVulResponse:
        """
        You can call the ExportVul operation to export the following types of vulnerabilities: Linux software vulnerabilities, Windows system vulnerabilities, Web-CMS vulnerabilities, application vulnerabilities, and urgent vulnerabilities.
        You can use this operation together with the DescribeVulExportInfo operation. After you call the ExportVul operation to create a vulnerability export task, you can call the DescribeVulExportInfo operation to query the progress of the task by specifying the ID of the task.
        ### Limits
        You can call this operation up to 10 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: ExportVulRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ExportVulResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.alias_name):
            query['AliasName'] = request.alias_name
        if not UtilClient.is_unset(request.attach_types):
            query['AttachTypes'] = request.attach_types
        if not UtilClient.is_unset(request.dealed):
            query['Dealed'] = request.dealed
        if not UtilClient.is_unset(request.group_id):
            query['GroupId'] = request.group_id
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.necessity):
            query['Necessity'] = request.necessity
        if not UtilClient.is_unset(request.search_tags):
            query['SearchTags'] = request.search_tags
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        if not UtilClient.is_unset(request.uuids):
            query['Uuids'] = request.uuids
        if not UtilClient.is_unset(request.vpc_instance_ids):
            query['VpcInstanceIds'] = request.vpc_instance_ids
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ExportVul',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.ExportVulResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def export_vul(
        self,
        request: sas_20181203_models.ExportVulRequest,
    ) -> sas_20181203_models.ExportVulResponse:
        """
        You can call the ExportVul operation to export the following types of vulnerabilities: Linux software vulnerabilities, Windows system vulnerabilities, Web-CMS vulnerabilities, application vulnerabilities, and urgent vulnerabilities.
        You can use this operation together with the DescribeVulExportInfo operation. After you call the ExportVul operation to create a vulnerability export task, you can call the DescribeVulExportInfo operation to query the progress of the task by specifying the ID of the task.
        ### Limits
        You can call this operation up to 10 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: ExportVulRequest
        @return: ExportVulResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.export_vul_with_options(request, runtime)

    async def export_vul_async(
        self,
        request: sas_20181203_models.ExportVulRequest,
    ) -> sas_20181203_models.ExportVulResponse:
        """
        You can call the ExportVul operation to export the following types of vulnerabilities: Linux software vulnerabilities, Windows system vulnerabilities, Web-CMS vulnerabilities, application vulnerabilities, and urgent vulnerabilities.
        You can use this operation together with the DescribeVulExportInfo operation. After you call the ExportVul operation to create a vulnerability export task, you can call the DescribeVulExportInfo operation to query the progress of the task by specifying the ID of the task.
        ### Limits
        You can call this operation up to 10 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: ExportVulRequest
        @return: ExportVulResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.export_vul_with_options_async(request, runtime)

    def export_warning_with_options(
        self,
        request: sas_20181203_models.ExportWarningRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.ExportWarningResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dealed):
            query['Dealed'] = request.dealed
        if not UtilClient.is_unset(request.export_type):
            query['ExportType'] = request.export_type
        if not UtilClient.is_unset(request.is_cleartext_pwd):
            query['IsCleartextPwd'] = request.is_cleartext_pwd
        if not UtilClient.is_unset(request.is_summary_export):
            query['IsSummaryExport'] = request.is_summary_export
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.risk_ids):
            query['RiskIds'] = request.risk_ids
        if not UtilClient.is_unset(request.risk_levels):
            query['RiskLevels'] = request.risk_levels
        if not UtilClient.is_unset(request.risk_name):
            query['RiskName'] = request.risk_name
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.status_list):
            query['StatusList'] = request.status_list
        if not UtilClient.is_unset(request.strategy_id):
            query['StrategyId'] = request.strategy_id
        if not UtilClient.is_unset(request.sub_type_names):
            query['SubTypeNames'] = request.sub_type_names
        if not UtilClient.is_unset(request.type_name):
            query['TypeName'] = request.type_name
        if not UtilClient.is_unset(request.type_names):
            query['TypeNames'] = request.type_names
        if not UtilClient.is_unset(request.uuids):
            query['Uuids'] = request.uuids
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ExportWarning',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.ExportWarningResponse(),
            self.call_api(params, req, runtime)
        )

    async def export_warning_with_options_async(
        self,
        request: sas_20181203_models.ExportWarningRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.ExportWarningResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dealed):
            query['Dealed'] = request.dealed
        if not UtilClient.is_unset(request.export_type):
            query['ExportType'] = request.export_type
        if not UtilClient.is_unset(request.is_cleartext_pwd):
            query['IsCleartextPwd'] = request.is_cleartext_pwd
        if not UtilClient.is_unset(request.is_summary_export):
            query['IsSummaryExport'] = request.is_summary_export
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.risk_ids):
            query['RiskIds'] = request.risk_ids
        if not UtilClient.is_unset(request.risk_levels):
            query['RiskLevels'] = request.risk_levels
        if not UtilClient.is_unset(request.risk_name):
            query['RiskName'] = request.risk_name
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.status_list):
            query['StatusList'] = request.status_list
        if not UtilClient.is_unset(request.strategy_id):
            query['StrategyId'] = request.strategy_id
        if not UtilClient.is_unset(request.sub_type_names):
            query['SubTypeNames'] = request.sub_type_names
        if not UtilClient.is_unset(request.type_name):
            query['TypeName'] = request.type_name
        if not UtilClient.is_unset(request.type_names):
            query['TypeNames'] = request.type_names
        if not UtilClient.is_unset(request.uuids):
            query['Uuids'] = request.uuids
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ExportWarning',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.ExportWarningResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def export_warning(
        self,
        request: sas_20181203_models.ExportWarningRequest,
    ) -> sas_20181203_models.ExportWarningResponse:
        runtime = util_models.RuntimeOptions()
        return self.export_warning_with_options(request, runtime)

    async def export_warning_async(
        self,
        request: sas_20181203_models.ExportWarningRequest,
    ) -> sas_20181203_models.ExportWarningResponse:
        runtime = util_models.RuntimeOptions()
        return await self.export_warning_with_options_async(request, runtime)

    def find_container_network_connect_with_options(
        self,
        tmp_req: sas_20181203_models.FindContainerNetworkConnectRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.FindContainerNetworkConnectResponse:
        UtilClient.validate_model(tmp_req)
        request = sas_20181203_models.FindContainerNetworkConnectShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.dst_node):
            request.dst_node_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.dst_node, 'DstNode', 'json')
        if not UtilClient.is_unset(tmp_req.src_node):
            request.src_node_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.src_node, 'SrcNode', 'json')
        query = {}
        if not UtilClient.is_unset(request.criteria_type):
            query['CriteriaType'] = request.criteria_type
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.dst_node_shrink):
            query['DstNode'] = request.dst_node_shrink
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.src_node_shrink):
            query['SrcNode'] = request.src_node_shrink
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='FindContainerNetworkConnect',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.FindContainerNetworkConnectResponse(),
            self.call_api(params, req, runtime)
        )

    async def find_container_network_connect_with_options_async(
        self,
        tmp_req: sas_20181203_models.FindContainerNetworkConnectRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.FindContainerNetworkConnectResponse:
        UtilClient.validate_model(tmp_req)
        request = sas_20181203_models.FindContainerNetworkConnectShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.dst_node):
            request.dst_node_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.dst_node, 'DstNode', 'json')
        if not UtilClient.is_unset(tmp_req.src_node):
            request.src_node_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.src_node, 'SrcNode', 'json')
        query = {}
        if not UtilClient.is_unset(request.criteria_type):
            query['CriteriaType'] = request.criteria_type
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.dst_node_shrink):
            query['DstNode'] = request.dst_node_shrink
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.src_node_shrink):
            query['SrcNode'] = request.src_node_shrink
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='FindContainerNetworkConnect',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.FindContainerNetworkConnectResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def find_container_network_connect(
        self,
        request: sas_20181203_models.FindContainerNetworkConnectRequest,
    ) -> sas_20181203_models.FindContainerNetworkConnectResponse:
        runtime = util_models.RuntimeOptions()
        return self.find_container_network_connect_with_options(request, runtime)

    async def find_container_network_connect_async(
        self,
        request: sas_20181203_models.FindContainerNetworkConnectRequest,
    ) -> sas_20181203_models.FindContainerNetworkConnectResponse:
        runtime = util_models.RuntimeOptions()
        return await self.find_container_network_connect_with_options_async(request, runtime)

    def fix_check_warnings_with_options(
        self,
        request: sas_20181203_models.FixCheckWarningsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.FixCheckWarningsResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.check_params):
            query['CheckParams'] = request.check_params
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.risk_id):
            query['RiskId'] = request.risk_id
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.uuids):
            query['Uuids'] = request.uuids
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='FixCheckWarnings',
            version='2018-12-03',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            sas_20181203_models.FixCheckWarningsResponse(),
            self.call_api(params, req, runtime)
        )

    async def fix_check_warnings_with_options_async(
        self,
        request: sas_20181203_models.FixCheckWarningsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> sas_20181203_models.FixCheckWarningsResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.check_params):
            query['CheckParams'] = request.check_params
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.risk_id):
            query['RiskId'] = request.risk_id
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.uuids):
            query['Uuids'] =