/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.skin.rose;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.ThemeStyle;
import net.sourceforge.plantuml.UseStyle;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.skin.AbstractComponent;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.skin.ArrowConfiguration;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColor;
import net.sourceforge.plantuml.ugraphic.color.HColorSet;

public class ComponentRoseLine
extends AbstractComponent {
    private final HColor color;
    private final boolean continueLine;
    private final UStroke stroke;

    public ComponentRoseLine(ThemeStyle themeStyle, Style style, HColor color, boolean continueLine, UStroke stroke, HColorSet set) {
        super(style);
        if (UseStyle.useBetaStyle()) {
            this.color = style.value(PName.LineColor).asColor(themeStyle, set);
            this.stroke = style.getStroke();
        } else {
            this.color = color;
            this.stroke = stroke;
        }
        this.continueLine = continueLine;
    }

    @Override
    protected void drawInternalU(UGraphic ug, Area area) {
        Dimension2D dimensionToUse = area.getDimensionToUse();
        ug = ug.apply(this.color);
        ug = UseStyle.useBetaStyle() ? ug.apply(this.stroke) : (this.continueLine ? ug.apply(new UStroke()) : ArrowConfiguration.stroke(ug, 5.0, 5.0, this.stroke.getThickness()));
        int x = (int)(dimensionToUse.getWidth() / 2.0);
        ug.apply(UTranslate.dx(x)).draw(ULine.vline(dimensionToUse.getHeight()));
    }

    @Override
    public double getPreferredHeight(StringBounder stringBounder) {
        return 20.0;
    }

    @Override
    public double getPreferredWidth(StringBounder stringBounder) {
        return 1.0;
    }
}

