/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.logo;

import java.util.HashMap;
import java.util.Map;
import net.sourceforge.plantuml.logo.LogoToken;

class LogoScanner {
    private final Map<String, Integer> keywordTable = new HashMap<String, Integer>();
    private char[] sourceString;
    private int sourceLength;
    private int i;

    public LogoScanner() {
        this.keywordTable.put("forward", new Integer(260));
        this.keywordTable.put("fd", new Integer(260));
        this.keywordTable.put("back", new Integer(261));
        this.keywordTable.put("bk", new Integer(261));
        this.keywordTable.put("right", new Integer(263));
        this.keywordTable.put("rt", new Integer(263));
        this.keywordTable.put("left", new Integer(262));
        this.keywordTable.put("lt", new Integer(262));
        this.keywordTable.put("penup", new Integer(264));
        this.keywordTable.put("pu", new Integer(264));
        this.keywordTable.put("pendown", new Integer(265));
        this.keywordTable.put("pd", new Integer(265));
        this.keywordTable.put("hideturtle", new Integer(266));
        this.keywordTable.put("ht", new Integer(266));
        this.keywordTable.put("showturtle", new Integer(267));
        this.keywordTable.put("st", new Integer(267));
        this.keywordTable.put("clearscreen", new Integer(268));
        this.keywordTable.put("cs", new Integer(268));
        this.keywordTable.put("repeat", new Integer(269));
        this.keywordTable.put("rep", new Integer(269));
        this.keywordTable.put("to", new Integer(271));
        this.keywordTable.put("setpc", new Integer(272));
        this.keywordTable.put("pc", new Integer(272));
    }

    public int getPosition() {
        return this.i;
    }

    public void setPosition(int newPosition) {
        this.i = this.i >= 0 && this.i <= this.sourceLength ? newPosition : this.sourceLength;
    }

    public void setSourceString(String newSourceString) {
        this.sourceLength = newSourceString.length();
        this.sourceString = newSourceString.concat("\u0000").toCharArray();
        this.i = 0;
    }

    public String getSourceString() {
        return new String(this.sourceString);
    }

    public String getRestAsString() {
        this.skipWhitespace();
        String rest = new String(this.sourceString, this.i, this.sourceLength - this.i + 1);
        this.i = this.sourceLength;
        return rest;
    }

    void skipWhitespace() {
        char c;
        while ((c = this.sourceString[this.i++]) == ' ' || c == '\t') {
        }
        --this.i;
    }

    public LogoToken getToken() {
        LogoToken token = new LogoToken();
        StringBuilder lexeme = new StringBuilder();
        if (this.i >= this.sourceLength) {
            token.kind = 256;
            return token;
        }
        this.skipWhitespace();
        char c = this.sourceString[this.i++];
        if (c == '[' || c == ']') {
            token.kind = c;
            token.lexeme = String.valueOf(c);
        } else if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') {
            do {
                lexeme.append(c);
            } while ((c = this.sourceString[this.i++]) >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z');
            --this.i;
            token.lexeme = lexeme.toString();
            token.kind = 258;
            Integer keyword = this.keywordTable.get(token.lexeme);
            if (keyword != null) {
                token.kind = keyword;
            }
        } else if (c >= '0' && c <= '9') {
            do {
                lexeme.append(c);
            } while ((c = this.sourceString[this.i++]) >= '0' && c <= '9');
            boolean hasDecimalPart = false;
            if (c == '.') {
                do {
                    lexeme.append(c);
                } while ((c = this.sourceString[this.i++]) >= '0' && c <= '9');
                hasDecimalPart = true;
            }
            --this.i;
            token.lexeme = lexeme.toString();
            token.value = Float.valueOf(token.lexeme).floatValue();
            if (hasDecimalPart) {
                token.kind = 259;
            } else {
                token.kind = 270;
                token.intValue = Integer.valueOf(token.lexeme);
            }
        } else if (c == '\u0000') {
            --this.i;
            token.kind = 256;
        } else {
            --this.i;
            token.kind = 257;
        }
        return token;
    }
}

