/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.emoji;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.emoji.UGraphicWithScale;
import net.sourceforge.plantuml.emoji.data.Dummy;
import net.sourceforge.plantuml.openiconic.SvgPath;
import net.sourceforge.plantuml.ugraphic.UEllipse;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.color.HColor;
import net.sourceforge.plantuml.ugraphic.color.HColorNone;
import net.sourceforge.plantuml.ugraphic.color.HColorSet;
import net.sourceforge.plantuml.ugraphic.color.HColorSimple;

public class Emoji {
    private static final Map<String, Emoji> ALL = new HashMap<String, Emoji>();
    private final List<String> data = new ArrayList<String>();
    private final String unicode;
    private final String shortcut;

    public static Map<String, Emoji> getAll() {
        return Collections.unmodifiableMap(new TreeMap<String, Emoji>(ALL));
    }

    private Emoji(String unicode) {
        int x = unicode.indexOf(59);
        if (x == -1) {
            this.shortcut = null;
        } else {
            this.shortcut = unicode.substring(x + 1);
            ALL.put(this.shortcut, this);
            unicode = unicode.substring(0, x);
        }
        this.unicode = unicode;
        ALL.put(unicode, this);
    }

    public static String pattern() {
        StringBuilder sb = new StringBuilder("\\<(#\\w+)?:(");
        for (String s : ALL.keySet()) {
            if (!sb.toString().endsWith("(")) {
                sb.append("|");
            }
            sb.append(s);
        }
        sb.append("):\\>");
        return sb.toString();
    }

    public static Emoji retrieve(String name) {
        return ALL.get(name.toLowerCase());
    }

    private String extractData(String name, String s) {
        Pattern p = Pattern.compile(name + "=\"([^\"]+)\"");
        Matcher m = p.matcher(s);
        if (m.find()) {
            return m.group(1);
        }
        return null;
    }

    private synchronized void loadIfNeed() throws IOException {
        if (this.data.size() > 0) {
            return;
        }
        try (BufferedReader br = new BufferedReader(new InputStreamReader(Dummy.class.getResourceAsStream(this.unicode + ".svg")));){
            String singleLine = br.readLine();
            Pattern p = Pattern.compile("\\<[^<>]+\\>");
            Matcher m = p.matcher(singleLine);
            while (m.find()) {
                String s = m.group(0);
                if (s.contains("<path") || s.contains("<g ") || s.contains("<g>") || s.contains("</g>") || s.contains("<circle ") || s.contains("<ellipse ")) {
                    this.data.add(s);
                    continue;
                }
                System.err.println("???=" + s);
            }
        }
    }

    public void drawU(UGraphic ug, double scale, HColor colorForMonochrome) {
        try {
            this.loadIfNeed();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        UGraphicWithScale ugs = new UGraphicWithScale(ug, scale);
        ArrayList<UGraphicWithScale> stack = new ArrayList<UGraphicWithScale>();
        for (String s : this.data) {
            if (s.contains("<path ")) {
                this.drawPath(ugs, s, colorForMonochrome);
                continue;
            }
            if (s.contains("</g>")) {
                ugs = (UGraphicWithScale)stack.remove(0);
                continue;
            }
            if (s.contains("<g>")) {
                stack.add(0, ugs);
                continue;
            }
            if (s.contains("<g ")) {
                stack.add(0, ugs);
                ugs = this.applyFill(ugs, s, colorForMonochrome);
                ugs = this.applyTransform(ugs, s);
                continue;
            }
            if (s.contains("<circle ")) {
                this.drawCircle(ugs, s, colorForMonochrome);
                continue;
            }
            if (s.contains("<ellipse ")) {
                this.drawEllipse(ugs, s, colorForMonochrome);
                continue;
            }
            System.err.println("**?=" + s);
        }
    }

    private UGraphicWithScale applyFill(UGraphicWithScale ugs, String s, HColor colorForMonochrome) {
        String fillString = this.extractData("fill", s);
        if (fillString == null) {
            return ugs;
        }
        if (fillString.equals("none")) {
            String strokeString = this.extractData("stroke", s);
            if (strokeString == null) {
                return ugs;
            }
            ugs = ugs.apply(new HColorNone().bg());
            HColor stroke = this.getTrueColor(strokeString, colorForMonochrome);
            ugs = ugs.apply(stroke);
            String strokeWidth = this.extractData("stroke-width", s);
            if (strokeWidth != null) {
                ugs = ugs.apply(new UStroke(Double.parseDouble(strokeWidth)));
            }
        } else {
            HColor fill = this.getTrueColor(fillString, colorForMonochrome);
            ugs = ugs.apply(fill).apply(fill.bg());
        }
        return ugs;
    }

    private HColor getTrueColor(String code, HColor colorForMonochrome) {
        HColorSimple result = (HColorSimple)HColorSet.instance().getColorOrWhite(code);
        if (colorForMonochrome == null) {
            return result;
        }
        return result.asMonochrome((HColorSimple)colorForMonochrome);
    }

    private void drawCircle(UGraphicWithScale ugs, String s, HColor colorForMonochrome) {
        ugs = this.applyFill(ugs, s, colorForMonochrome);
        ugs = this.applyTransform(ugs, s);
        double scalex = ugs.getAffineTransform().getScaleX();
        double scaley = ugs.getAffineTransform().getScaleY();
        double deltax = ugs.getAffineTransform().getTranslateX();
        double deltay = ugs.getAffineTransform().getTranslateY();
        double cx = Double.parseDouble(this.extractData("cx", s)) * scalex;
        double cy = Double.parseDouble(this.extractData("cy", s)) * scaley;
        double rx = Double.parseDouble(this.extractData("r", s)) * scalex;
        double ry = Double.parseDouble(this.extractData("r", s)) * scaley;
        UTranslate translate = new UTranslate(deltax + cx - rx, deltay + cy - ry);
        ugs.apply(translate).draw(new UEllipse(rx * 2.0, ry * 2.0));
    }

    private void drawEllipse(UGraphicWithScale ugs, String s, HColor colorForMonochrome) {
        ugs = this.applyFill(ugs, s, colorForMonochrome);
        ugs = this.applyTransform(ugs, s);
        double scalex = ugs.getAffineTransform().getScaleX();
        double scaley = ugs.getAffineTransform().getScaleY();
        double deltax = ugs.getAffineTransform().getTranslateX();
        double deltay = ugs.getAffineTransform().getTranslateY();
        double cx = Double.parseDouble(this.extractData("cx", s)) * scalex;
        double cy = Double.parseDouble(this.extractData("cy", s)) * scaley;
        double rx = Double.parseDouble(this.extractData("rx", s)) * scalex;
        double ry = Double.parseDouble(this.extractData("ry", s)) * scaley;
        UTranslate translate = new UTranslate(deltax + cx - rx, deltay + cy - ry);
        ugs.apply(translate).draw(new UEllipse(rx * 2.0, ry * 2.0));
    }

    private void drawPath(UGraphicWithScale ugs, String s, HColor colorForMonochrome) {
        s = s.replace("id=\"", "ID=\"");
        ugs = this.applyFill(ugs, s, colorForMonochrome);
        ugs = this.applyTransform(ugs, s);
        int x1 = s.indexOf("d=\"");
        int x2 = s.indexOf(34, x1 + 3);
        String tmp = s.substring(x1 + 3, x2);
        SvgPath svgPath = new SvgPath(tmp);
        svgPath.drawMe(ugs.getUg(), ugs.getAffineTransform());
    }

    private UGraphicWithScale applyTransform(UGraphicWithScale ugs, String s) {
        String transform = this.extractData("transform", s);
        if (transform == null) {
            return ugs;
        }
        if (transform.contains("rotate(")) {
            return this.applyRotate(ugs, transform);
        }
        if (transform.contains("matrix(")) {
            return this.applyMatrix(ugs, transform);
        }
        double[] scale = this.getScale(transform);
        UTranslate translate = this.getTranslate(transform);
        ugs = ugs.applyTranslate(translate.getDx(), translate.getDy());
        return ugs.applyScale(scale[0], scale[1]);
    }

    private UGraphicWithScale applyMatrix(UGraphicWithScale ugs, String transform) {
        Pattern p3 = Pattern.compile("matrix\\(([-.0-9]+)[ ,]+([-.0-9]+)[ ,]+([-.0-9]+)[ ,]+([-.0-9]+)[ ,]+([-.0-9]+)[ ,]+([-.0-9]+)\\)");
        Matcher m3 = p3.matcher(transform);
        if (m3.find()) {
            double v1 = Double.parseDouble(m3.group(1));
            double v2 = Double.parseDouble(m3.group(2));
            double v3 = Double.parseDouble(m3.group(3));
            double v4 = Double.parseDouble(m3.group(4));
            double v5 = Double.parseDouble(m3.group(5));
            double v6 = Double.parseDouble(m3.group(6));
            ugs = ugs.applyMatrix(v1, v2, v3, v4, v5, v6);
        } else {
            System.err.println("WARNING: " + transform);
        }
        return ugs;
    }

    private UGraphicWithScale applyRotate(UGraphicWithScale ugs, String transform) {
        Pattern p3 = Pattern.compile("rotate\\(([-.0-9]+)[ ,]+([-.0-9]+)[ ,]+([-.0-9]+)\\)");
        Matcher m3 = p3.matcher(transform);
        if (m3.find()) {
            double angle = Double.parseDouble(m3.group(1));
            double x = Double.parseDouble(m3.group(2));
            double y = Double.parseDouble(m3.group(3));
            ugs = ugs.applyRotate(angle, x, y);
        } else {
            System.err.println("WARNING: " + transform);
        }
        return ugs;
    }

    private UTranslate getTranslate(String transform) {
        double x = 0.0;
        double y = 0.0;
        Pattern p3 = Pattern.compile("translate\\(([-.0-9]+)[ ,]+([-.0-9]+)\\)");
        Matcher m3 = p3.matcher(transform);
        if (m3.find()) {
            x = Double.parseDouble(m3.group(1));
            y = Double.parseDouble(m3.group(2));
        } else {
            Pattern p4 = Pattern.compile("translate\\(([-.0-9]+)\\)");
            Matcher m4 = p4.matcher(transform);
            if (m4.find()) {
                x = Double.parseDouble(m4.group(1));
                y = Double.parseDouble(m4.group(1));
            }
        }
        return new UTranslate(x, y);
    }

    private double[] getScale(String transform) {
        double[] scale = new double[]{1.0, 1.0};
        Pattern p1 = Pattern.compile("scale\\(([-.0-9]+)\\)");
        Matcher m1 = p1.matcher(transform);
        if (m1.find()) {
            scale[0] = Double.parseDouble(m1.group(1));
            scale[1] = scale[0];
        } else {
            Pattern p2 = Pattern.compile("scale\\(([-.0-9]+)[ ,]+([-.0-9]+)\\)");
            Matcher m2 = p2.matcher(transform);
            if (m2.find()) {
                scale[0] = Double.parseDouble(m2.group(1));
                scale[1] = Double.parseDouble(m2.group(2));
            }
        }
        return scale;
    }

    public String getShortcut() {
        return this.shortcut;
    }

    static {
        InputStream is = Dummy.class.getResourceAsStream("emoji.txt");
        try (BufferedReader br = new BufferedReader(new InputStreamReader(is));){
            String s = null;
            while ((s = br.readLine()) != null) {
                new Emoji(s);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

