/*
 * Decompiled with CFR 0.152.
 */
package jcckit.renderer;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import jcckit.graphic.BasicGraphicalElement;
import jcckit.graphic.ClippingRectangle;
import jcckit.graphic.ClippingShape;
import jcckit.graphic.FillAttributes;
import jcckit.graphic.FontStyle;
import jcckit.graphic.GraphPoint;
import jcckit.graphic.GraphicAttributes;
import jcckit.graphic.GraphicalComposite;
import jcckit.graphic.GraphicalCompositeRenderer;
import jcckit.graphic.LineAttributes;
import jcckit.graphic.Oval;
import jcckit.graphic.OvalRenderer;
import jcckit.graphic.Polygon;
import jcckit.graphic.PolygonRenderer;
import jcckit.graphic.Rectangle;
import jcckit.graphic.RectangleRenderer;
import jcckit.graphic.Text;
import jcckit.graphic.TextAttributes;
import jcckit.graphic.TextRenderer;

public class Graphics2DRenderer
implements GraphicalCompositeRenderer,
PolygonRenderer,
OvalRenderer,
TextRenderer,
RectangleRenderer {
    private static final int FS = 1;
    private static final String DEFAULT_FONT_NAME = "SansSerif";
    private static final FontStyle DEFAULT_FONT_STYLE = FontStyle.NORMAL;
    private static final int DEFAULT_FONT_SIZE = 12;
    private Color _defaultColor;
    private Graphics2D _graphics;

    public Graphics2DRenderer init(Graphics2D graphics) {
        this._graphics = graphics;
        this._defaultColor = graphics.getColor();
        return this;
    }

    @Override
    public void startRendering(GraphicalComposite composite) {
        ClippingShape shape = composite.getClippingShape();
        if (shape != null) {
            ClippingRectangle rect = shape.getBoundingBox();
            this._graphics.clip(new Rectangle2D.Double(rect.getMinX(), rect.getMinY(), rect.getMaxX() - rect.getMinX(), rect.getMaxY() - rect.getMinY()));
        }
    }

    @Override
    public void finishRendering(GraphicalComposite composite) {
        this._graphics.setClip(null);
    }

    @Override
    public void render(Polygon polygon) {
        int numberOfPoints = polygon.getNumberOfPoints();
        if (numberOfPoints > 0) {
            Color currentColor = this._graphics.getColor();
            GeneralPath p = new GeneralPath(0, numberOfPoints);
            p.moveTo((float)polygon.getPoint(0).getX(), (float)polygon.getPoint(0).getY());
            for (int i = 1; i < numberOfPoints; ++i) {
                p.lineTo((float)polygon.getPoint(i).getX(), (float)polygon.getPoint(i).getY());
            }
            if (polygon.isClosed()) {
                p.closePath();
            }
            this.drawShape(p, polygon, currentColor);
        }
    }

    @Override
    public void render(Rectangle rectangle) {
        Color currentColor = this._graphics.getColor();
        GraphPoint center = rectangle.getCenter();
        double width = rectangle.getWidth();
        double height = rectangle.getHeight();
        Rectangle2D.Double rect = new Rectangle2D.Double(center.getX() - 0.5 * width, center.getY() - 0.5 * height, width, height);
        this.drawShape(rect, rectangle, currentColor);
    }

    @Override
    public void render(Oval oval) {
        Color currentColor = this._graphics.getColor();
        GraphPoint center = oval.getCenter();
        double width = oval.getWidth();
        double height = oval.getHeight();
        Ellipse2D.Double ellipse = new Ellipse2D.Double(center.getX() - 0.5 * width, center.getY() - 0.5 * height, width, height);
        this.drawShape(ellipse, oval, currentColor);
    }

    private void drawShape(Shape shape, BasicGraphicalElement element, Color backupColor) {
        GraphicAttributes attributes = element.getGraphicAttributes();
        Color fillColor = null;
        if (element.isClosed() && attributes instanceof FillAttributes) {
            fillColor = ((FillAttributes)attributes).getFillColor();
        }
        if (fillColor != null) {
            this._graphics.setColor(fillColor);
            this._graphics.fill(shape);
        }
        Color lineColor = this._defaultColor;
        if (attributes instanceof LineAttributes) {
            LineAttributes la = (LineAttributes)attributes;
            BasicStroke stroke = new BasicStroke((float)la.getLineThickness());
            double[] linePattern = la.getLinePattern();
            if (linePattern != null) {
                float[] dash = new float[linePattern.length];
                for (int i = 0; i < dash.length; ++i) {
                    dash[i] = (float)la.getLinePattern()[i];
                }
                stroke = new BasicStroke(stroke.getLineWidth(), 0, 0, 10.0f, dash, 0.0f);
            }
            this._graphics.setStroke(stroke);
            if (la.getLineColor() != null || fillColor != null) {
                lineColor = la.getLineColor();
            }
        }
        if (lineColor != null) {
            this._graphics.setColor(lineColor);
            this._graphics.draw(shape);
        }
        this._graphics.setColor(backupColor);
    }

    @Override
    public void render(Text text) {
        GraphicAttributes ga = text.getGraphicAttributes();
        if (ga instanceof TextAttributes) {
            TextAttributes ta = (TextAttributes)ga;
            Color currentColor = this._graphics.getColor();
            Color fontColor = ta.getTextColor();
            if (fontColor == null) {
                fontColor = this._defaultColor;
            }
            this._graphics.setColor(fontColor);
            double scale = this._graphics.getTransform().getScaleX();
            String str = text.getText();
            AffineTransform before = this._graphics.getTransform();
            this._graphics.setTransform(new AffineTransform());
            double fs = ta.getFontSize();
            fs = fs == 0.0 ? 1.0 : fs * scale / 12.0;
            Font font = Graphics2DRenderer.createFont(ta, 0);
            AffineTransform fontTransform = new AffineTransform();
            fontTransform.scale(fs, fs);
            fontTransform.rotate(-ta.getOrientationAngle() * Math.PI / 180.0);
            font = font.deriveFont(fontTransform);
            this._graphics.setFont(font);
            Rectangle2D bounds = this._graphics.getFontMetrics().getStringBounds(str, this._graphics);
            fontTransform.rotate(-ta.getOrientationAngle() * Math.PI / 180.0);
            double yy = bounds.getHeight() + bounds.getY();
            Point2D.Double pos = new Point2D.Double(text.getPosition().getX(), text.getPosition().getY());
            before.transform(pos, pos);
            double x = 0.0;
            double y = 0.0;
            if (ta.getOrientationAngle() == 0.0) {
                x = -0.5 * (double)ta.getHorizontalAnchor().getFactor() * bounds.getWidth();
                y = 0.5 * (double)ta.getVerticalAnchor().getFactor() * bounds.getHeight() - yy;
                x = pos.x + x;
                y = pos.y + y;
            } else {
                x = 0.5 * (double)ta.getVerticalAnchor().getFactor() * bounds.getHeight();
                y = 0.5 * (double)ta.getHorizontalAnchor().getFactor() * bounds.getWidth();
                x = pos.x + x;
                y = pos.y + y;
            }
            this._graphics.drawString(str, (float)x, (float)y);
            this._graphics.setTransform(before);
            this._graphics.setColor(currentColor);
        }
    }

    static Font createFont(TextAttributes attributes, int size) {
        FontStyle fontStyle;
        String fontName = attributes.getFontName();
        if (fontName == null) {
            fontName = DEFAULT_FONT_NAME;
        }
        if ((fontStyle = attributes.getFontStyle()) == null) {
            fontStyle = DEFAULT_FONT_STYLE;
        }
        int style = 0;
        if (fontStyle == FontStyle.BOLD) {
            style = 1;
        } else if (fontStyle == FontStyle.ITALIC) {
            style = 2;
        } else if (fontStyle == FontStyle.BOLD_ITALIC) {
            style = 3;
        }
        if (size == 0) {
            size = 12;
        }
        return new Font(fontName, style, size);
    }
}

