# APIs for Windows 32-bit user32 library.
# Format:  rettype, retname, callconv, exactname, arglist(type, name)
#          arglist type is one of ['int', 'void *']
#          arglist name is one of [None, 'funcptr', 'obj', 'ptr']

api_defs = {
    'user32.main_entry':( 'int', None, 'stdcall', 'user32.main_entry', (('int', None), ('int', None), ('int', None)) ),
    'user32.activatekeyboardlayout':( 'int', None, 'stdcall', 'user32.ActivateKeyboardLayout', (('int', None), ('int', None)) ),
    'user32.adjustwindowrect':( 'int', None, 'stdcall', 'user32.AdjustWindowRect', (('void *', 'ptr'), ('int', None), ('int', None)) ),
    'user32.adjustwindowrectex':( 'int', None, 'stdcall', 'user32.AdjustWindowRectEx', (('void *', 'ptr'), ('int', None), ('int', None), ('int', None)) ),
    'user32.alignrects':( 'int', None, 'stdcall', 'user32.AlignRects', (('void *', 'ptr'), ('int', None), ('int', None), ('int', None)) ),
    'user32.allowforegroundactivation':( 'int', None, 'cdecl', 'user32.AllowForegroundActivation', () ),
    'user32.allowsetforegroundwindow':( 'int', None, 'stdcall', 'user32.AllowSetForegroundWindow', (('int', None),) ),
    'user32.animatewindow':( 'int', None, 'stdcall', 'user32.AnimateWindow', (('int', None), ('int', None), ('int', None)) ),
    'user32.anypopup':( 'int', None, 'cdecl', 'user32.AnyPopup', () ),
    'user32.appendmenua':( 'int', None, 'stdcall', 'user32.AppendMenuA', (('int', None), ('int', None), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'user32.appendmenuw':( 'int', None, 'stdcall', 'user32.AppendMenuW', (('int', None), ('int', None), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'user32.arrangeiconicwindows':( 'int', None, 'stdcall', 'user32.ArrangeIconicWindows', (('int', None),) ),
    'user32.attachthreadinput':( 'int', None, 'stdcall', 'user32.AttachThreadInput', (('int', None), ('int', None), ('int', None)) ),
    'user32.begindeferwindowpos':( 'int', None, 'stdcall', 'user32.BeginDeferWindowPos', (('int', None),) ),
    'user32.beginpaint':( 'int', None, 'stdcall', 'user32.BeginPaint', (('int', None), ('void *', 'ptr')) ),
    'user32.blockinput':( 'int', None, 'stdcall', 'user32.BlockInput', (('int', None),) ),
    'user32.bringwindowtotop':( 'int', None, 'stdcall', 'user32.BringWindowToTop', (('int', None),) ),
    'user32.broadcastsystemmessage':( 'int', None, 'stdcall', 'user32.BroadcastSystemMessage', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.broadcastsystemmessagea':( 'int', None, 'stdcall', 'user32.BroadcastSystemMessageA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.broadcastsystemmessageexa':( 'int', None, 'stdcall', 'user32.BroadcastSystemMessageExA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.broadcastsystemmessageexw':( 'int', None, 'stdcall', 'user32.BroadcastSystemMessageExW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.broadcastsystemmessagew':( 'int', None, 'stdcall', 'user32.BroadcastSystemMessageW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.buildreasonarray':( 'int', None, 'stdcall', 'user32.BuildReasonArray', (('int', None), ('int', None), ('int', None)) ),
    'user32.calcmenubar':( 'int', None, 'stdcall', 'user32.CalcMenuBar', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.callmsgfilter':( 'int', None, 'stdcall', 'user32.CallMsgFilter', (('int', None), ('int', None)) ),
    'user32.callmsgfiltera':( 'int', None, 'stdcall', 'user32.CallMsgFilterA', (('int', None), ('int', None)) ),
    'user32.callmsgfilterw':( 'int', None, 'stdcall', 'user32.CallMsgFilterW', (('void *', 'ptr'), ('int', None)) ),
    'user32.callnexthookex':( 'int', None, 'stdcall', 'user32.CallNextHookEx', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.callwindowproca':( 'int', None, 'stdcall', 'user32.CallWindowProcA', (('void *', 'obj'), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.callwindowprocw':( 'int', None, 'stdcall', 'user32.CallWindowProcW', (('void *', 'obj'), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.cascadechildwindows':( 'int', None, 'stdcall', 'user32.CascadeChildWindows', ( ('int', None),) ),
    'user32.cascadewindows':( 'int', None, 'stdcall', 'user32.CascadeWindows', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('void *', 'ptr')) ),
    'user32.changeclipboardchain':( 'int', None, 'stdcall', 'user32.ChangeClipboardChain', (('int', None), ('int', None)) ),
    'user32.changedisplaysettingsa':( 'int', None, 'stdcall', 'user32.ChangeDisplaySettingsA', (('int', None), ('int', None)) ),
    'user32.changedisplaysettingsexa':( 'int', None, 'stdcall', 'user32.ChangeDisplaySettingsExA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.changedisplaysettingsexw':( 'int', None, 'stdcall', 'user32.ChangeDisplaySettingsExW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.changedisplaysettingsw':( 'int', None, 'stdcall', 'user32.ChangeDisplaySettingsW', (('int', None), ('int', None)) ),
    'user32.changemenua':( 'int', None, 'stdcall', 'user32.ChangeMenuA', ( ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.changemenuw':( 'int', None, 'stdcall', 'user32.ChangeMenuW', ( ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.charlowera':( 'int', None, 'stdcall', 'user32.CharLowerA', (('int', None),) ),
    'user32.charlowerbuffa':( 'int', None, 'stdcall', 'user32.CharLowerBuffA', (('int', None), ('int', None)) ),
    'user32.charlowerbuffw':( 'int', None, 'stdcall', 'user32.CharLowerBuffW', (('void *', 'ptr'), ('int', None)) ),
    'user32.charlowerw':( 'int', None, 'stdcall', 'user32.CharLowerW', (('void *', 'ptr'),) ),
    'user32.charnexta':( 'int', None, 'stdcall', 'user32.CharNextA', (('int', None),) ),
    'user32.charnextexa':( 'int', None, 'stdcall', 'user32.CharNextExA', (('int', None), ('int', None), ('int', None)) ),
    'user32.charnextw':( 'int', None, 'stdcall', 'user32.CharNextW', (('int', None),) ),
    'user32.charpreva':( 'int', None, 'stdcall', 'user32.CharPrevA', (('int', None), ('int', None)) ),
    'user32.charprevexa':( 'int', None, 'stdcall', 'user32.CharPrevExA', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.charprevw':( 'int', None, 'stdcall', 'user32.CharPrevW', (('int', None), ('int', None)) ),
    'user32.chartooema':( 'int', None, 'stdcall', 'user32.CharToOemA', (('int', None), ('int', None)) ),
    'user32.chartooembuffa':( 'int', None, 'stdcall', 'user32.CharToOemBuffA', (('int', None), ('int', None), ('int', None)) ),
    'user32.chartooembuffw':( 'int', None, 'stdcall', 'user32.CharToOemBuffW', (('int', None), ('int', None), ('int', None)) ),
    'user32.chartooemw':( 'int', None, 'stdcall', 'user32.CharToOemW', (('int', None), ('int', None)) ),
    'user32.charuppera':( 'int', None, 'stdcall', 'user32.CharUpperA', (('int', None),) ),
    'user32.charupperbuffa':( 'int', None, 'stdcall', 'user32.CharUpperBuffA', (('int', None), ('int', None)) ),
    'user32.charupperbuffw':( 'int', None, 'stdcall', 'user32.CharUpperBuffW', (('void *', 'ptr'), ('int', None)) ),
    'user32.charupperw':( 'int', None, 'stdcall', 'user32.CharUpperW', (('void *', 'ptr'),) ),
    'user32.checkdlgbutton':( 'int', None, 'stdcall', 'user32.CheckDlgButton', (('int', None), ('int', None), ('int', None)) ),
    'user32.checkmenuitem':( 'int', None, 'stdcall', 'user32.CheckMenuItem', (('int', None), ('int', None), ('int', None)) ),
    'user32.checkmenuradioitem':( 'int', None, 'stdcall', 'user32.CheckMenuRadioItem', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.checkradiobutton':( 'int', None, 'stdcall', 'user32.CheckRadioButton', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.childwindowfrompoint':( 'int', None, 'stdcall', 'user32.ChildWindowFromPoint', ( ('int', None), ('int', None)) ),
    'user32.childwindowfrompointex':( 'int', None, 'stdcall', 'user32.ChildWindowFromPointEx', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.cliimmsethotkey':( 'int', None, 'stdcall', 'user32.CliImmSetHotKey', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.clientthreadsetup':( 'int', None, 'cdecl', 'user32.ClientThreadSetup', () ),
    'user32.clienttoscreen':( 'int', None, 'stdcall', 'user32.ClientToScreen', (('int', None), ('void *', 'ptr'),) ),
    'user32.clipcursor':( 'int', None, 'stdcall', 'user32.ClipCursor', (('int', None),) ),
    'user32.closeclipboard':( 'int', None, 'cdecl', 'user32.CloseClipboard', () ),
    'user32.closedesktop':( 'int', None, 'stdcall', 'user32.CloseDesktop', (('int', None),) ),
    'user32.closewindow':( 'int', None, 'stdcall', 'user32.CloseWindow', (('int', None),) ),
    'user32.closewindowstation':( 'int', None, 'stdcall', 'user32.CloseWindowStation', (('int', None),) ),
    'user32.copyacceleratortablea':( 'int', None, 'stdcall', 'user32.CopyAcceleratorTableA', (('int', None), ('int', None), ('int', None)) ),
    'user32.copyacceleratortablew':( 'int', None, 'stdcall', 'user32.CopyAcceleratorTableW', (('int', None), ('int', None), ('int', None)) ),
    'user32.copyicon':( 'int', None, 'stdcall', 'user32.CopyIcon', (('int', None),) ),
    'user32.copyimage':( 'int', None, 'stdcall', 'user32.CopyImage', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.copyrect':( 'int', None, 'stdcall', 'user32.CopyRect', (('int', None), ('int', None)) ),
    'user32.countclipboardformats':( 'int', None, 'cdecl', 'user32.CountClipboardFormats', () ),
    'user32.createacceleratortablea':( 'int', None, 'stdcall', 'user32.CreateAcceleratorTableA', (('int', None), ('int', None)) ),
    'user32.createacceleratortablew':( 'int', None, 'stdcall', 'user32.CreateAcceleratorTableW', (('int', None), ('int', None)) ),
    'user32.createcaret':( 'int', None, 'stdcall', 'user32.CreateCaret', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.createcursor':( 'int', None, 'stdcall', 'user32.CreateCursor', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.createdesktopa':( 'int', None, 'stdcall', 'user32.CreateDesktopA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.createdesktopw':( 'int', None, 'stdcall', 'user32.CreateDesktopW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.createdialogindirectparama':( 'int', None, 'stdcall', 'user32.CreateDialogIndirectParamA', (('FileNameW', None), ('int', None), ('void *', 'obj'), ('int', None), ('void *', 'obj')) ),
    'user32.createdialogindirectparamaorw':( 'int', None, 'stdcall', 'user32.CreateDialogIndirectParamAorW', (('FileNameW', None), ('int', None), ('void *', 'obj'), ('int', None), ('void *', 'obj'), ('int', None)) ),
    'user32.createdialogindirectparamw':( 'int', None, 'stdcall', 'user32.CreateDialogIndirectParamW', (('FileNameW', None), ('int', None), ('void *', 'obj'), ('int', None), ('void *', 'obj')) ),
    'user32.createdialogparama':( 'int', None, 'stdcall', 'user32.CreateDialogParamA', (('FileNameW', None), ('int', None), ('void *', 'obj'), ('int', None), ('void *', 'obj')) ),
    'user32.createdialogparamw':( 'int', None, 'stdcall', 'user32.CreateDialogParamW', (('FileNameW', None), ('int', None), ('void *', 'obj'), ('int', None), ('void *', 'obj')) ),
    'user32.createicon':( 'int', None, 'stdcall', 'user32.CreateIcon', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.createiconfromresource':( 'int', None, 'stdcall', 'user32.CreateIconFromResource', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.createiconfromresourceex':( 'int', None, 'stdcall', 'user32.CreateIconFromResourceEx', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.createiconindirect':( 'int', None, 'stdcall', 'user32.CreateIconIndirect', (('void *', 'ptr'),) ),
    'user32.createmdiwindowa':( 'int', None, 'stdcall', 'user32.CreateMDIWindowA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'obj'), ('int', None), ('int', None)) ),
    'user32.createmdiwindoww':( 'int', None, 'stdcall', 'user32.CreateMDIWindowW', (('void *', 'ptr'), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'obj'), ('int', None), ('int', None)) ),
    'user32.createmenu':( 'int', None, 'cdecl', 'user32.CreateMenu', () ),
    'user32.createpopupmenu':( 'int', None, 'cdecl', 'user32.CreatePopupMenu', () ),
    'user32.createsystemthreads':( 'int', None, 'stdcall', 'user32.CreateSystemThreads', (('int', None), ('int', None)) ),
    'user32.createwindowexa':( 'int', None, 'stdcall', 'user32.CreateWindowExA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'obj'), ('int', None), ('int', None), ('int', None)) ),
    'user32.createwindowexw':( 'int', None, 'stdcall', 'user32.CreateWindowExW', (('int', None), ('void *', 'ptr'), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'obj'), ('int', None), ('int', None), ('int', None)) ),
    'user32.createwindowstationa':( 'int', None, 'stdcall', 'user32.CreateWindowStationA', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.createwindowstationw':( 'int', None, 'stdcall', 'user32.CreateWindowStationW', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.csrbroadcastsystemmessageexw':( 'int', None, 'stdcall', 'user32.CsrBroadcastSystemMessageExW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.ctxinituser32':( 'int', None, 'cdecl', 'user32.CtxInitUser32', () ),
    'user32.ddeabandontransaction':( 'int', None, 'stdcall', 'user32.DdeAbandonTransaction', (('int', None), ('int', None), ('int', None)) ),
    'user32.ddeaccessdata':( 'int', None, 'stdcall', 'user32.DdeAccessData', (('int', None), ('int', None)) ),
    'user32.ddeadddata':( 'int', None, 'stdcall', 'user32.DdeAddData', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.ddeclienttransaction':( 'int', None, 'stdcall', 'user32.DdeClientTransaction', (('int', None), ('DWORD', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.ddecmpstringhandles':( 'int', None, 'stdcall', 'user32.DdeCmpStringHandles', (('int', None), ('int', None)) ),
    'user32.ddeconnect':( 'int', None, 'stdcall', 'user32.DdeConnect', (('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'user32.ddeconnectlist':( 'int', None, 'stdcall', 'user32.DdeConnectList', (('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'user32.ddecreatedatahandle':( 'int', None, 'stdcall', 'user32.DdeCreateDataHandle', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.ddecreatestringhandlea':( 'int', None, 'stdcall', 'user32.DdeCreateStringHandleA', (('int', None), ('int', None), ('int', None)) ),
    'user32.ddecreatestringhandlew':( 'int', None, 'stdcall', 'user32.DdeCreateStringHandleW', (('int', None), ('int', None), ('int', None)) ),
    'user32.ddedisconnect':( 'int', None, 'stdcall', 'user32.DdeDisconnect', (('int', None),) ),
    'user32.ddedisconnectlist':( 'int', None, 'stdcall', 'user32.DdeDisconnectList', (('int', None),) ),
    'user32.ddeenablecallback':( 'int', None, 'stdcall', 'user32.DdeEnableCallback', (('int', None), ('int', None), ('void *', 'obj')) ),
    'user32.ddefreedatahandle':( 'int', None, 'stdcall', 'user32.DdeFreeDataHandle', (('int', None),) ),
    'user32.ddefreestringhandle':( 'int', None, 'stdcall', 'user32.DdeFreeStringHandle', (('int', None), ('int', None)) ),
    'user32.ddegetdata':( 'int', None, 'stdcall', 'user32.DdeGetData', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.ddegetlasterror':( 'int', None, 'stdcall', 'user32.DdeGetLastError', (('int', None),) ),
    'user32.ddegetqualityofservice':( 'int', None, 'stdcall', 'user32.DdeGetQualityOfService', (('int', None), ('int', None), ('void *', 'ptr')) ),
    'user32.ddeimpersonateclient':( 'int', None, 'stdcall', 'user32.DdeImpersonateClient', (('int', None),) ),
    'user32.ddeinitializea':( 'int', None, 'stdcall', 'user32.DdeInitializeA', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.ddeinitializew':( 'int', None, 'stdcall', 'user32.DdeInitializeW', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.ddekeepstringhandle':( 'int', None, 'stdcall', 'user32.DdeKeepStringHandle', (('int', None), ('int', None)) ),
    'user32.ddenameservice':( 'int', None, 'stdcall', 'user32.DdeNameService', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.ddepostadvise':( 'int', None, 'stdcall', 'user32.DdePostAdvise', (('int', None), ('int', None), ('int', None)) ),
    'user32.ddequeryconvinfo':( 'int', None, 'stdcall', 'user32.DdeQueryConvInfo', (('int', None), ('int', None), ('int', None)) ),
    'user32.ddequerynextserver':( 'int', None, 'stdcall', 'user32.DdeQueryNextServer', (('int', None), ('int', None)) ),
    'user32.ddequerystringa':( 'int', None, 'stdcall', 'user32.DdeQueryStringA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.ddequerystringw':( 'int', None, 'stdcall', 'user32.DdeQueryStringW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.ddereconnect':( 'int', None, 'stdcall', 'user32.DdeReconnect', (('int', None),) ),
    'user32.ddesetqualityofservice':( 'int', None, 'stdcall', 'user32.DdeSetQualityOfService', (('int', None), ('int', None), ('int', None)) ),
    'user32.ddesetuserhandle':( 'int', None, 'stdcall', 'user32.DdeSetUserHandle', (('int', None), ('int', None), ('int', None)) ),
    'user32.ddeunaccessdata':( 'int', None, 'stdcall', 'user32.DdeUnaccessData', (('int', None),) ),
    'user32.ddeuninitialize':( 'int', None, 'stdcall', 'user32.DdeUninitialize', (('int', None),) ),
    'user32.defdlgproca':( 'int', None, 'stdcall', 'user32.DefDlgProcA', ( ('void *', 'obj'), ('void *', 'obj'), ('void *', 'obj')) ),
    'user32.defdlgprocw':( 'int', None, 'stdcall', 'user32.DefDlgProcW', ( ('void *', 'obj'), ('void *', 'obj'), ('void *', 'obj')) ),
    'user32.defframeproca':( 'int', None, 'stdcall', 'user32.DefFrameProcA', (('int', None), ('int', None), ('int', None), ('void *', 'obj'), ('void *', 'obj')) ),
    'user32.defframeprocw':( 'int', None, 'stdcall', 'user32.DefFrameProcW', (('int', None), ('int', None), ('int', None), ('void *', 'obj'), ('void *', 'obj')) ),
    'user32.defmdichildproca':( 'int', None, 'stdcall', 'user32.DefMDIChildProcA', (('int', None), ('int', None), ('void *', 'obj'), ('void *', 'obj')) ),
    'user32.defmdichildprocw':( 'int', None, 'stdcall', 'user32.DefMDIChildProcW', (('int', None), ('int', None), ('void *', 'obj'), ('void *', 'obj')) ),
    'user32.defrawinputproc':( 'int', None, 'stdcall', 'user32.DefRawInputProc', (('int', None), ('int', None), ('int', None)) ),
    'user32.defwindowproca':( 'int', None, 'stdcall', 'user32.DefWindowProcA', (('int', None), ('int', None), ('void *', 'obj'), ('void *', 'obj')) ),
    'user32.defwindowprocw':( 'int', None, 'stdcall', 'user32.DefWindowProcW', (('int', None), ('int', None), ('void *', 'obj'), ('void *', 'obj')) ),
    'user32.deferwindowpos':( 'int', None, 'stdcall', 'user32.DeferWindowPos', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.deletemenu':( 'int', None, 'stdcall', 'user32.DeleteMenu', (('int', None), ('int', None), ('int', None)) ),
    'user32.deregistershellhookwindow':( 'int', None, 'stdcall', 'user32.DeregisterShellHookWindow', (('int', None),) ),
    'user32.destroyacceleratortable':( 'int', None, 'stdcall', 'user32.DestroyAcceleratorTable', (('int', None),) ),
    'user32.destroycaret':( 'int', None, 'cdecl', 'user32.DestroyCaret', () ),
    'user32.destroycursor':( 'int', None, 'stdcall', 'user32.DestroyCursor', (('int', None),) ),
    'user32.destroyicon':( 'int', None, 'stdcall', 'user32.DestroyIcon', (('int', None),) ),
    'user32.destroymenu':( 'int', None, 'stdcall', 'user32.DestroyMenu', (('int', None),) ),
    'user32.destroyreasons':( 'int', None, 'stdcall', 'user32.DestroyReasons', (('int', None),) ),
    'user32.destroywindow':( 'int', None, 'stdcall', 'user32.DestroyWindow', (('int', None),) ),
    'user32.deviceeventworker':( 'int', None, 'stdcall', 'user32.DeviceEventWorker', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.dialogboxindirectparama':( 'int', None, 'stdcall', 'user32.DialogBoxIndirectParamA', (('FileNameW', None), ('int', None), ('void *', 'obj'), ('int', None), ('void *', 'obj')) ),
    'user32.dialogboxindirectparamaorw':( 'int', None, 'stdcall', 'user32.DialogBoxIndirectParamAorW', (('FileNameW', None), ('int', None), ('void *', 'obj'), ('int', None), ('void *', 'obj'), ('int', None)) ),
    'user32.dialogboxindirectparamw':( 'int', None, 'stdcall', 'user32.DialogBoxIndirectParamW', (('FileNameW', None), ('int', None), ('void *', 'obj'), ('int', None), ('void *', 'obj')) ),
    'user32.dialogboxparama':( 'int', None, 'stdcall', 'user32.DialogBoxParamA', (('FileNameW', None), ('int', None), ('void *', 'obj'), ('int', None), ('void *', 'obj')) ),
    'user32.dialogboxparamw':( 'int', None, 'stdcall', 'user32.DialogBoxParamW', (('FileNameW', None), ('int', None), ('void *', 'obj'), ('int', None), ('void *', 'obj')) ),
    'user32.disableprocesswindowsghosting':( 'int', None, 'cdecl', 'user32.DisableProcessWindowsGhosting', () ),
    'user32.dispatchmessagea':( 'int', None, 'stdcall', 'user32.DispatchMessageA', (('int', None),) ),
    'user32.dispatchmessagew':( 'int', None, 'stdcall', 'user32.DispatchMessageW', (('void *', 'ptr'),) ),
    'user32.displayexitwindowswarnings':( 'int', None, 'stdcall', 'user32.DisplayExitWindowsWarnings', (('int', None),) ),
    'user32.dlgdirlista':( 'int', None, 'stdcall', 'user32.DlgDirListA', (('int', None), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None)) ),
    'user32.dlgdirlistcomboboxa':( 'int', None, 'stdcall', 'user32.DlgDirListComboBoxA', (('int', None), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None)) ),
    'user32.dlgdirlistcomboboxw':( 'int', None, 'stdcall', 'user32.DlgDirListComboBoxW', (('int', None), ('void *', 'obj'), ('int', None), ('int', None), ('int', None)) ),
    'user32.dlgdirlistw':( 'int', None, 'stdcall', 'user32.DlgDirListW', (('int', None), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None)) ),
    'user32.dlgdirselectcomboboxexa':( 'int', None, 'stdcall', 'user32.DlgDirSelectComboBoxExA', (('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'user32.dlgdirselectcomboboxexw':( 'int', None, 'stdcall', 'user32.DlgDirSelectComboBoxExW', (('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'user32.dlgdirselectexa':( 'int', None, 'stdcall', 'user32.DlgDirSelectExA', (('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'user32.dlgdirselectexw':( 'int', None, 'stdcall', 'user32.DlgDirSelectExW', (('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'user32.dragdetect':( 'int', None, 'stdcall', 'user32.DragDetect', (('int', None), ('int', None), ('int', None)) ),
    'user32.dragobject':( 'int', None, 'stdcall', 'user32.DragObject', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.drawanimatedrects':( 'int', None, 'stdcall', 'user32.DrawAnimatedRects', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.drawcaption':( 'int', None, 'stdcall', 'user32.DrawCaption', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.drawcaptiontempa':( 'int', None, 'stdcall', 'user32.DrawCaptionTempA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'user32.drawcaptiontempw':( 'int', None, 'stdcall', 'user32.DrawCaptionTempW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.drawedge':( 'int', None, 'stdcall', 'user32.DrawEdge', (('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'user32.drawfocusrect':( 'int', None, 'stdcall', 'user32.DrawFocusRect', (('int', None), ('void *', 'ptr')) ),
    'user32.drawframe':( 'int', None, 'stdcall', 'user32.DrawFrame', (('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'user32.drawframecontrol':( 'int', None, 'stdcall', 'user32.DrawFrameControl', (('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'user32.drawicon':( 'int', None, 'stdcall', 'user32.DrawIcon', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.drawiconex':( 'int', None, 'stdcall', 'user32.DrawIconEx', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.drawmenubar':( 'int', None, 'stdcall', 'user32.DrawMenuBar', (('int', None),) ),
    'user32.drawmenubartemp':( 'int', None, 'stdcall', 'user32.DrawMenuBarTemp', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.drawstatea':( 'int', None, 'stdcall', 'user32.DrawStateA', (('int', None), ('int', None), ('void *', 'funcptr'), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.drawstatew':( 'int', None, 'stdcall', 'user32.DrawStateW', (('int', None), ('int', None), ('void *', 'funcptr'), ('void *', 'ptr'), ('DWORD', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.drawtexta':( 'int', None, 'stdcall', 'user32.DrawTextA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.drawtextexa':( 'int', None, 'stdcall', 'user32.DrawTextExA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'user32.drawtextexw':( 'int', None, 'stdcall', 'user32.DrawTextExW', (('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('void *', 'ptr')) ),
    'user32.drawtextw':( 'int', None, 'stdcall', 'user32.DrawTextW', (('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'user32.editwndproc':( 'int', None, 'stdcall', 'user32.EditWndProc', (('int', None), ('void *', 'obj'), ('void *', 'obj'), ('void *', 'obj')) ),
    'user32.emptyclipboard':( 'int', None, 'cdecl', 'user32.EmptyClipboard', () ),
    'user32.enablemenuitem':( 'int', None, 'stdcall', 'user32.EnableMenuItem', (('int', None), ('int', None), ('int', None)) ),
    'user32.enablescrollbar':( 'int', None, 'stdcall', 'user32.EnableScrollBar', (('int', None), ('int', None), ('int', None)) ),
    'user32.enablewindow':( 'int', None, 'stdcall', 'user32.EnableWindow', (('int', None), ('int', None)) ),
    'user32.enddeferwindowpos':( 'int', None, 'stdcall', 'user32.EndDeferWindowPos', (('int', None),) ),
    'user32.enddialog':( 'int', None, 'stdcall', 'user32.EndDialog', (('int', None), ('int', None)) ),
    'user32.endmenu':( 'int', None, 'cdecl', 'user32.EndMenu', () ),
    'user32.endpaint':( 'int', None, 'stdcall', 'user32.EndPaint', (('int', None), ('void *', 'ptr')) ),
    'user32.endtask':( 'int', None, 'stdcall', 'user32.EndTask', (('int', None), ('int', None), ('int', None)) ),
    'user32.enterreadermodehelper':( 'int', None, 'stdcall', 'user32.EnterReaderModeHelper', () ),
    'user32.enumchildwindows':( 'int', None, 'stdcall', 'user32.EnumChildWindows', (('int', None), ('void *', 'funcptr'), ('void *', 'ptr')) ),
    'user32.enumclipboardformats':( 'int', None, 'stdcall', 'user32.EnumClipboardFormats', (('int', None),) ),
    'user32.enumdesktopwindows':( 'int', None, 'stdcall', 'user32.EnumDesktopWindows', (('int', None), ('void *', 'funcptr'), ('int', None)) ),
    'user32.enumdesktopsa':( 'int', None, 'stdcall', 'user32.EnumDesktopsA', (('int', None), ('void *', 'funcptr'), ('int', None)) ),
    'user32.enumdesktopsw':( 'int', None, 'stdcall', 'user32.EnumDesktopsW', (('int', None), ('void *', 'funcptr'), ('int', None)) ),
    'user32.enumdisplaydevicesa':( 'int', None, 'stdcall', 'user32.EnumDisplayDevicesA', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.enumdisplaydevicesw':( 'int', None, 'stdcall', 'user32.EnumDisplayDevicesW', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.enumdisplaymonitors':( 'int', None, 'stdcall', 'user32.EnumDisplayMonitors', (('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'user32.enumdisplaysettingsa':( 'int', None, 'stdcall', 'user32.EnumDisplaySettingsA', (('int', None), ('int', None), ('int', None)) ),
    'user32.enumdisplaysettingsexa':( 'int', None, 'stdcall', 'user32.EnumDisplaySettingsExA', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.enumdisplaysettingsexw':( 'int', None, 'stdcall', 'user32.EnumDisplaySettingsExW', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.enumdisplaysettingsw':( 'int', None, 'stdcall', 'user32.EnumDisplaySettingsW', (('int', None), ('int', None), ('int', None)) ),
    'user32.enumpropsa':( 'int', None, 'stdcall', 'user32.EnumPropsA', (('int', None), ('void *', 'funcptr')) ),
    'user32.enumpropsexa':( 'int', None, 'stdcall', 'user32.EnumPropsExA', (('int', None), ('void *', 'funcptr'), ('int', None)) ),
    'user32.enumpropsexw':( 'int', None, 'stdcall', 'user32.EnumPropsExW', (('int', None), ('void *', 'funcptr'), ('int', None)) ),
    'user32.enumpropsw':( 'int', None, 'stdcall', 'user32.EnumPropsW', (('int', None), ('void *', 'funcptr')) ),
    'user32.enumthreadwindows':( 'int', None, 'stdcall', 'user32.EnumThreadWindows', (('int', None), ('void *', 'funcptr'), ('int', None)) ),
    'user32.enumwindowstationsa':( 'int', None, 'stdcall', 'user32.EnumWindowStationsA', (('void *', 'funcptr'), ('int', None)) ),
    'user32.enumwindowstationsw':( 'int', None, 'stdcall', 'user32.EnumWindowStationsW', (('void *', 'funcptr'), ('int', None)) ),
    'user32.enumwindows':( 'int', None, 'stdcall', 'user32.EnumWindows', (('void *', 'funcptr'), ('void *', 'ptr')) ),
    'user32.equalrect':( 'int', None, 'stdcall', 'user32.EqualRect', (('int', None), ('int', None)) ),
    'user32.excludeupdatergn':( 'int', None, 'stdcall', 'user32.ExcludeUpdateRgn', (('int', None), ('int', None)) ),
    'user32.exitwindowsex':( 'int', None, 'stdcall', 'user32.ExitWindowsEx', ( ('int', None), ('int', None)) ),
    'user32.fillrect':( 'int', None, 'stdcall', 'user32.FillRect', (('int', None), ('void *', 'ptr'), ('int', None)) ),
    'user32.findwindowa':( 'int', None, 'stdcall', 'user32.FindWindowA', (('int', None), ('int', None)) ),
    'user32.findwindowexa':( 'int', None, 'stdcall', 'user32.FindWindowExA', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.findwindowexw':( 'int', None, 'stdcall', 'user32.FindWindowExW', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.findwindoww':( 'int', None, 'stdcall', 'user32.FindWindowW', (('int', None), ('int', None)) ),
    'user32.flashwindow':( 'int', None, 'stdcall', 'user32.FlashWindow', (('int', None), ('int', None)) ),
    'user32.flashwindowex':( 'int', None, 'stdcall', 'user32.FlashWindowEx', (('void *', 'ptr'),) ),
    'user32.framerect':( 'int', None, 'stdcall', 'user32.FrameRect', (('int', None), ('int', None), ('int', None)) ),
    'user32.freeddelparam':( 'int', None, 'stdcall', 'user32.FreeDDElParam', (('int', None), ('void *', 'ptr')) ),
    'user32.getactivewindow':( 'int', None, 'cdecl', 'user32.GetActiveWindow', () ),
    'user32.getalttabinfo':( 'int', None, 'stdcall', 'user32.GetAltTabInfo', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.getalttabinfoa':( 'int', None, 'stdcall', 'user32.GetAltTabInfoA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.getalttabinfow':( 'int', None, 'stdcall', 'user32.GetAltTabInfoW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.getancestor':( 'int', None, 'stdcall', 'user32.GetAncestor', (('int', None), ('int', None)) ),
    'user32.getappcompatflags':( 'int', None, 'stdcall', 'user32.GetAppCompatFlags', (('int', None),) ),
    'user32.getappcompatflags2':( 'int', None, 'stdcall', 'user32.GetAppCompatFlags2', (('int', None),) ),
    'user32.getasynckeystate':( 'int', None, 'stdcall', 'user32.GetAsyncKeyState', (('int', None),) ),
    'user32.getcapture':( 'int', None, 'cdecl', 'user32.GetCapture', () ),
    'user32.getcaretblinktime':( 'int', None, 'cdecl', 'user32.GetCaretBlinkTime', () ),
    'user32.getcaretpos':( 'int', None, 'stdcall', 'user32.GetCaretPos', (('void *', 'ptr'),) ),
    'user32.getclassinfoa':( 'int', None, 'stdcall', 'user32.GetClassInfoA', (('int', None), ('int', None), ('int', None)) ),
    'user32.getclassinfoexa':( 'int', None, 'stdcall', 'user32.GetClassInfoExA', (('int', None), ('int', None), ('void *', 'ptr')) ),
    'user32.getclassinfoexw':( 'int', None, 'stdcall', 'user32.GetClassInfoExW', (('int', None), ('int', None), ('void *', 'ptr')) ),
    'user32.getclassinfow':( 'int', None, 'stdcall', 'user32.GetClassInfoW', (('int', None), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'user32.getclasslonga':( 'int', None, 'stdcall', 'user32.GetClassLongA', (('int', None), ('int', None)) ),
    'user32.getclasslongw':( 'int', None, 'stdcall', 'user32.GetClassLongW', (('int', None), ('int', None)) ),
    'user32.getclassnamea':( 'int', None, 'stdcall', 'user32.GetClassNameA', (('int', None), ('void *', 'ptr'), ('int', None)) ),
    'user32.getclassnamew':( 'int', None, 'stdcall', 'user32.GetClassNameW', (('int', None), ('void *', 'ptr'), ('int', None)) ),
    'user32.getclassword':( 'int', None, 'stdcall', 'user32.GetClassWord', (('int', None), ('int', None)) ),
    'user32.getclientrect':( 'int', None, 'stdcall', 'user32.GetClientRect', (('int', None), ('void *', 'ptr')) ),
    'user32.getclipcursor':( 'int', None, 'stdcall', 'user32.GetClipCursor', (('int', None),) ),
    'user32.getclipboarddata':( 'int', None, 'stdcall', 'user32.GetClipboardData', ( ('int', None),) ),
    'user32.getclipboardformatnamea':( 'int', None, 'stdcall', 'user32.GetClipboardFormatNameA', (('int', None), ('int', None), ('int', None)) ),
    'user32.getclipboardformatnamew':( 'int', None, 'stdcall', 'user32.GetClipboardFormatNameW', (('int', None), ('int', None), ('int', None)) ),
    'user32.getclipboardowner':( 'int', None, 'cdecl', 'user32.GetClipboardOwner', () ),
    'user32.getclipboardsequencenumber':( 'int', None, 'cdecl', 'user32.GetClipboardSequenceNumber', () ),
    'user32.getclipboardviewer':( 'int', None, 'cdecl', 'user32.GetClipboardViewer', () ),
    'user32.getcomboboxinfo':( 'int', None, 'stdcall', 'user32.GetComboBoxInfo', (('int', None), ('int', None)) ),
    'user32.getcursor':( 'int', None, 'cdecl', 'user32.GetCursor', () ),
    'user32.getcursorframeinfo':( 'int', None, 'stdcall', 'user32.GetCursorFrameInfo', (('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'user32.getcursorinfo':( 'int', None, 'stdcall', 'user32.GetCursorInfo', (('int', None),) ),
    'user32.getcursorpos':( 'int', None, 'stdcall', 'user32.GetCursorPos', (('void *', 'ptr'),) ),
    'user32.getdc':( 'int', None, 'stdcall', 'user32.GetDC', (('int', None),) ),
    'user32.getdcex':( 'int', None, 'stdcall', 'user32.GetDCEx', (('int', None), ('int', None), ('int', None)) ),
    'user32.getdesktopwindow':( 'int', None, 'cdecl', 'user32.GetDesktopWindow', () ),
    'user32.getdialogbaseunits':( 'int', None, 'cdecl', 'user32.GetDialogBaseUnits', () ),
    'user32.getdlgctrlid':( 'int', None, 'stdcall', 'user32.GetDlgCtrlID', (('int', None),) ),
    'user32.getdlgitem':( 'int', None, 'stdcall', 'user32.GetDlgItem', ( ('int', None), ('int', None)) ),
    'user32.getdlgitemint':( 'int', None, 'stdcall', 'user32.GetDlgItemInt', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'user32.getdlgitemtexta':( 'int', None, 'stdcall', 'user32.GetDlgItemTextA', (('int', None), ('int', None), ('void *', 'obj'), ('int', None)) ),
    'user32.getdlgitemtextw':( 'int', None, 'stdcall', 'user32.GetDlgItemTextW', (('int', None), ('int', None), ('void *', 'obj'), ('int', None)) ),
    'user32.getdoubleclicktime':( 'int', None, 'cdecl', 'user32.GetDoubleClickTime', () ),
    'user32.getfocus':( 'int', None, 'cdecl', 'user32.GetFocus', () ),
    'user32.getforegroundwindow':( 'int', None, 'cdecl', 'user32.GetForegroundWindow', () ),
    'user32.getguithreadinfo':( 'int', None, 'stdcall', 'user32.GetGUIThreadInfo', (('int', None), ('int', None)) ),
    'user32.getguiresources':( 'int', None, 'stdcall', 'user32.GetGuiResources', (('int', None), ('int', None)) ),
    'user32.geticoninfo':( 'int', None, 'stdcall', 'user32.GetIconInfo', (('int', None), ('void *', 'ptr')) ),
    'user32.getinputdesktop':( 'int', None, 'cdecl', 'user32.GetInputDesktop', () ),
    'user32.getinputstate':( 'int', None, 'cdecl', 'user32.GetInputState', () ),
    'user32.getinternalwindowpos':( 'int', None, 'stdcall', 'user32.GetInternalWindowPos', (('int', None), ('int', None), ('int', None)) ),
    'user32.getkbcodepage':( 'int', None, 'stdcall', 'user32.GetKBCodePage', () ),
    'user32.getkeynametexta':( 'int', None, 'stdcall', 'user32.GetKeyNameTextA', (('int', None), ('int', None), ('int', None)) ),
    'user32.getkeynametextw':( 'int', None, 'stdcall', 'user32.GetKeyNameTextW', (('int', None), ('int', None), ('int', None)) ),
    'user32.getkeystate':( 'int', None, 'stdcall', 'user32.GetKeyState', (('int', None),) ),
    'user32.getkeyboardlayout':( 'int', None, 'stdcall', 'user32.GetKeyboardLayout', (('int', None),) ),
    'user32.getkeyboardlayoutlist':( 'int', None, 'stdcall', 'user32.GetKeyboardLayoutList', (('int', None), ('int', None)) ),
    'user32.getkeyboardlayoutnamea':( 'int', None, 'stdcall', 'user32.GetKeyboardLayoutNameA', (('int', None),) ),
    'user32.getkeyboardlayoutnamew':( 'int', None, 'stdcall', 'user32.GetKeyboardLayoutNameW', (('int', None),) ),
    'user32.getkeyboardstate':( 'int', None, 'stdcall', 'user32.GetKeyboardState', (('int', None),) ),
    'user32.getkeyboardtype':( 'int', None, 'stdcall', 'user32.GetKeyboardType', (('int', None),) ),
    'user32.getlastactivepopup':( 'int', None, 'stdcall', 'user32.GetLastActivePopup', (('int', None),) ),
    'user32.getlastinputinfo':( 'int', None, 'stdcall', 'user32.GetLastInputInfo', (('int', None),) ),
    'user32.getlayeredwindowattributes':( 'int', None, 'stdcall', 'user32.GetLayeredWindowAttributes', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.getlistboxinfo':( 'int', None, 'stdcall', 'user32.GetListBoxInfo', (('int', None),) ),
    'user32.getmenu':( 'int', None, 'stdcall', 'user32.GetMenu', (('int', None),) ),
    'user32.getmenubarinfo':( 'int', None, 'stdcall', 'user32.GetMenuBarInfo', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.getmenucheckmarkdimensions':( 'int', None, 'cdecl', 'user32.GetMenuCheckMarkDimensions', () ),
    'user32.getmenucontexthelpid':( 'int', None, 'stdcall', 'user32.GetMenuContextHelpId', (('int', None),) ),
    'user32.getmenudefaultitem':( 'int', None, 'stdcall', 'user32.GetMenuDefaultItem', (('int', None), ('int', None), ('int', None)) ),
    'user32.getmenuinfo':( 'int', None, 'stdcall', 'user32.GetMenuInfo', (('int', None), ('void *', 'ptr')) ),
    'user32.getmenuitemcount':( 'int', None, 'stdcall', 'user32.GetMenuItemCount', (('int', None),) ),
    'user32.getmenuitemid':( 'int', None, 'stdcall', 'user32.GetMenuItemID', (('int', None), ('int', None)) ),
    'user32.getmenuiteminfoa':( 'int', None, 'stdcall', 'user32.GetMenuItemInfoA', (('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'user32.getmenuiteminfow':( 'int', None, 'stdcall', 'user32.GetMenuItemInfoW', (('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'user32.getmenuitemrect':( 'int', None, 'stdcall', 'user32.GetMenuItemRect', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.getmenustate':( 'int', None, 'stdcall', 'user32.GetMenuState', (('int', None), ('int', None), ('int', None)) ),
    'user32.getmenustringa':( 'int', None, 'stdcall', 'user32.GetMenuStringA', (('int', None), ('int', None), ('void *', 'obj'), ('int', None), ('int', None)) ),
    'user32.getmenustringw':( 'int', None, 'stdcall', 'user32.GetMenuStringW', (('int', None), ('int', None), ('void *', 'obj'), ('int', None), ('int', None)) ),
    'user32.getmessagea':( 'int', None, 'stdcall', 'user32.GetMessageA', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.getmessageextrainfo':( 'int', None, 'cdecl', 'user32.GetMessageExtraInfo', () ),
    'user32.getmessagepos':( 'int', None, 'cdecl', 'user32.GetMessagePos', () ),
    'user32.getmessagetime':( 'int', None, 'cdecl', 'user32.GetMessageTime', () ),
    'user32.getmessagew':( 'int', None, 'stdcall', 'user32.GetMessageW', (('void *', 'ptr'), ('int', None), ('int', None), ('int', None)) ),
    'user32.getmonitorinfoa':( 'int', None, 'stdcall', 'user32.GetMonitorInfoA', (('void *', 'ptr'), ('int', None)) ),
    'user32.getmonitorinfow':( 'int', None, 'stdcall', 'user32.GetMonitorInfoW', (('void *', 'ptr'), ('void *', 'ptr')) ),
    'user32.getmousemovepointsex':( 'int', None, 'stdcall', 'user32.GetMouseMovePointsEx', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.getnextdlggroupitem':( 'int', None, 'stdcall', 'user32.GetNextDlgGroupItem', (('int', None), ('int', None), ('int', None)) ),
    'user32.getnextdlgtabitem':( 'int', None, 'stdcall', 'user32.GetNextDlgTabItem', (('int', None), ('int', None), ('int', None)) ),
    'user32.getopenclipboardwindow':( 'int', None, 'cdecl', 'user32.GetOpenClipboardWindow', () ),
    'user32.getparent':( 'int', None, 'stdcall', 'user32.GetParent', (('int', None),) ),
    'user32.getpriorityclipboardformat':( 'int', None, 'stdcall', 'user32.GetPriorityClipboardFormat', (('int', None), ('int', None)) ),
    'user32.getprocessdefaultlayout':( 'int', None, 'stdcall', 'user32.GetProcessDefaultLayout', (('int', None),) ),
    'user32.getprocesswindowstation':( 'int', None, 'cdecl', 'user32.GetProcessWindowStation', () ),
    'user32.getprogmanwindow':( 'int', None, 'cdecl', 'user32.GetProgmanWindow', () ),
    'user32.getpropa':( 'int', None, 'stdcall', 'user32.GetPropA', (('int', None), ('void *', 'ptr')) ),
    'user32.getpropw':( 'int', None, 'stdcall', 'user32.GetPropW', (('int', None), ('void *', 'ptr')) ),
    'user32.getqueuestatus':( 'int', None, 'stdcall', 'user32.GetQueueStatus', (('int', None),) ),
    'user32.getrawinputbuffer':( 'int', None, 'stdcall', 'user32.GetRawInputBuffer', (('int', None), ('int', None), ('int', None)) ),
    'user32.getrawinputdata':( 'int', None, 'stdcall', 'user32.GetRawInputData', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.getrawinputdeviceinfoa':( 'int', None, 'stdcall', 'user32.GetRawInputDeviceInfoA', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'user32.getrawinputdeviceinfow':( 'int', None, 'stdcall', 'user32.GetRawInputDeviceInfoW', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.getrawinputdevicelist':( 'int', None, 'stdcall', 'user32.GetRawInputDeviceList', (('int', None), ('int', None), ('int', None)) ),
    'user32.getreasontitlefromreasoncode':( 'int', None, 'stdcall', 'user32.GetReasonTitleFromReasonCode', (('int', None), ('void *', 'ptr'), ('int', None)) ),
    'user32.getregisteredrawinputdevices':( 'int', None, 'stdcall', 'user32.GetRegisteredRawInputDevices', (('int', None), ('int', None), ('int', None)) ),
    'user32.getscrollbarinfo':( 'int', None, 'stdcall', 'user32.GetScrollBarInfo', (('int', None), ('int', None), ('int', None)) ),
    'user32.getscrollinfo':( 'int', None, 'stdcall', 'user32.GetScrollInfo', (('int', None), ('int', None), ('void *', 'obj')) ),
    'user32.getscrollpos':( 'int', None, 'stdcall', 'user32.GetScrollPos', (('int', None), ('int', None)) ),
    'user32.getscrollrange':( 'int', None, 'stdcall', 'user32.GetScrollRange', (('int', None), ('int', None), ('void *', 'obj'), ('void *', 'obj')) ),
    'user32.getshellwindow':( 'int', None, 'cdecl', 'user32.GetShellWindow', () ),
    'user32.getsubmenu':( 'int', None, 'stdcall', 'user32.GetSubMenu', (('int', None), ('int', None)) ),
    'user32.getsyscolor':( 'int', None, 'stdcall', 'user32.GetSysColor', (('int', None),) ),
    'user32.getsyscolorbrush':( 'int', None, 'stdcall', 'user32.GetSysColorBrush', (('int', None),) ),
    'user32.getsystemmenu':( 'int', None, 'stdcall', 'user32.GetSystemMenu', (('int', None), ('int', None)) ),
    'user32.getsystemmetrics':( 'int', None, 'stdcall', 'user32.GetSystemMetrics', (('int', None),) ),
    'user32.gettabbedtextextenta':( 'int', None, 'stdcall', 'user32.GetTabbedTextExtentA', ( ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.gettabbedtextextentw':( 'int', None, 'stdcall', 'user32.GetTabbedTextExtentW', (('int', None), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None)) ),
    'user32.gettaskmanwindow':( 'int', None, 'cdecl', 'user32.GetTaskmanWindow', () ),
    'user32.getthreaddesktop':( 'int', None, 'stdcall', 'user32.GetThreadDesktop', (('int', None),) ),
    'user32.gettitlebarinfo':( 'int', None, 'stdcall', 'user32.GetTitleBarInfo', (('int', None), ('int', None)) ),
    'user32.gettopwindow':( 'int', None, 'stdcall', 'user32.GetTopWindow', (('int', None),) ),
    'user32.getupdaterect':( 'int', None, 'stdcall', 'user32.GetUpdateRect', (('int', None), ('void *', 'ptr'), ('int', None)) ),
    'user32.getupdatergn':( 'int', None, 'stdcall', 'user32.GetUpdateRgn', (('int', None), ('int', None), ('int', None)) ),
    'user32.getuserobjectinformationa':( 'int', None, 'stdcall', 'user32.GetUserObjectInformationA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.getuserobjectinformationw':( 'int', None, 'stdcall', 'user32.GetUserObjectInformationW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.getuserobjectsecurity':( 'int', None, 'stdcall', 'user32.GetUserObjectSecurity', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.getwinstationinfo':( 'int', None, 'stdcall', 'user32.GetWinStationInfo', (('int', None),) ),
    'user32.getwindow':( 'int', None, 'stdcall', 'user32.GetWindow', (('int', None), ('int', None)) ),
    'user32.getwindowcontexthelpid':( 'int', None, 'stdcall', 'user32.GetWindowContextHelpId', (('int', None),) ),
    'user32.getwindowdc':( 'int', None, 'stdcall', 'user32.GetWindowDC', (('int', None),) ),
    'user32.getwindowinfo':( 'int', None, 'stdcall', 'user32.GetWindowInfo', ( ('int', None), ('void *', 'ptr')) ),
    'user32.getwindowlonga':( 'int', None, 'stdcall', 'user32.GetWindowLongA', (('int', None), ('int', None)) ),
    'user32.getwindowlongw':( 'int', None, 'stdcall', 'user32.GetWindowLongW', (('int', None), ('int', None)) ),
    'user32.getwindowmodulefilename':( 'int', None, 'stdcall', 'user32.GetWindowModuleFileName', ( ('int', None), ('int', None)) ),
    'user32.getwindowmodulefilenamea':( 'int', None, 'stdcall', 'user32.GetWindowModuleFileNameA', (('int', None), ('void *', 'ptr'), ('int', None)) ),
    'user32.getwindowmodulefilenamew':( 'int', None, 'stdcall', 'user32.GetWindowModuleFileNameW', (('int', None), ('void *', 'ptr'), ('int', None)) ),
    'user32.getwindowplacement':( 'int', None, 'stdcall', 'user32.GetWindowPlacement', (('int', None), ('void *', 'ptr')) ),
    'user32.getwindowrect':( 'int', None, 'stdcall', 'user32.GetWindowRect', (('int', None), ('void *', 'ptr')) ),
    'user32.getwindowrgn':( 'int', None, 'stdcall', 'user32.GetWindowRgn', (('int', None), ('int', None)) ),
    'user32.getwindowrgnbox':( 'int', None, 'stdcall', 'user32.GetWindowRgnBox', (('int', None), ('void *', 'ptr')) ),
    'user32.getwindowtexta':( 'int', None, 'stdcall', 'user32.GetWindowTextA', (('int', None), ('void *', 'obj'), ('int', None)) ),
    'user32.getwindowtextlengtha':( 'int', None, 'stdcall', 'user32.GetWindowTextLengthA', (('int', None),) ),
    'user32.getwindowtextlengthw':( 'int', None, 'stdcall', 'user32.GetWindowTextLengthW', (('int', None),) ),
    'user32.getwindowtextw':( 'int', None, 'stdcall', 'user32.GetWindowTextW', (('int', None), ('void *', 'obj'), ('int', None)) ),
    'user32.getwindowthreadprocessid':( 'int', None, 'stdcall', 'user32.GetWindowThreadProcessId', (('int', None), ('void *', 'ptr')) ),
    'user32.getwindowword':( 'int', None, 'stdcall', 'user32.GetWindowWord', ( ('int', None),) ),
    'user32.graystringa':( 'int', None, 'stdcall', 'user32.GrayStringA', (('int', None), ('int', None), ('void *', 'funcptr'), ('void *', 'ptr'), ('DWORD', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.graystringw':( 'int', None, 'stdcall', 'user32.GrayStringW', (('int', None), ('int', None), ('void *', 'funcptr'), ('void *', 'ptr'), ('DWORD', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.hidecaret':( 'int', None, 'stdcall', 'user32.HideCaret', (('int', None),) ),
    'user32.hilitemenuitem':( 'int', None, 'stdcall', 'user32.HiliteMenuItem', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.impgetimea':( 'int', None, 'stdcall', 'user32.IMPGetIMEA', (('int', None), ('int', None)) ),
    'user32.impgetimew':( 'int', None, 'stdcall', 'user32.IMPGetIMEW', (('int', None), ('int', None)) ),
    'user32.impqueryimea':( 'int', None, 'stdcall', 'user32.IMPQueryIMEA', (('int', None),) ),
    'user32.impqueryimew':( 'int', None, 'stdcall', 'user32.IMPQueryIMEW', (('int', None),) ),
    'user32.impsetimea':( 'int', None, 'stdcall', 'user32.IMPSetIMEA', (('int', None), ('int', None)) ),
    'user32.impsetimew':( 'int', None, 'stdcall', 'user32.IMPSetIMEW', (('int', None), ('int', None)) ),
    'user32.impersonateddeclientwindow':( 'int', None, 'stdcall', 'user32.ImpersonateDdeClientWindow', (('int', None), ('int', None)) ),
    'user32.insendmessage':( 'int', None, 'cdecl', 'user32.InSendMessage', () ),
    'user32.insendmessageex':( 'int', None, 'stdcall', 'user32.InSendMessageEx', (('int', None),) ),
    'user32.inflaterect':( 'int', None, 'stdcall', 'user32.InflateRect', (('void *', 'ptr'), ('int', None), ('int', None)) ),
    'user32.initializelpkhooks':( 'int', None, 'stdcall', 'user32.InitializeLpkHooks', (('int', None),) ),
    'user32.initializewin32entrytable':( 'int', None, 'stdcall', 'user32.InitializeWin32EntryTable', (('int', None),) ),
    'user32.insertmenua':( 'int', None, 'stdcall', 'user32.InsertMenuA', (('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'user32.insertmenuitema':( 'int', None, 'stdcall', 'user32.InsertMenuItemA', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.insertmenuitemw':( 'int', None, 'stdcall', 'user32.InsertMenuItemW', (('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'user32.insertmenuw':( 'int', None, 'stdcall', 'user32.InsertMenuW', (('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'user32.internalgetwindowtext':( 'int', None, 'stdcall', 'user32.InternalGetWindowText', (('int', None), ('int', None), ('int', None)) ),
    'user32.intersectrect':( 'int', None, 'stdcall', 'user32.IntersectRect', (('void *', 'ptr'), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'user32.invalidaterect':( 'int', None, 'stdcall', 'user32.InvalidateRect', (('int', None), ('void *', 'ptr'), ('int', None)) ),
    'user32.invalidatergn':( 'int', None, 'stdcall', 'user32.InvalidateRgn', (('int', None), ('int', None), ('int', None)) ),
    'user32.invertrect':( 'int', None, 'stdcall', 'user32.InvertRect', (('int', None), ('int', None)) ),
    'user32.ischaralphaa':( 'int', None, 'stdcall', 'user32.IsCharAlphaA', (('int', None),) ),
    'user32.ischaralphanumerica':( 'int', None, 'stdcall', 'user32.IsCharAlphaNumericA', (('int', None),) ),
    'user32.ischaralphanumericw':( 'int', None, 'stdcall', 'user32.IsCharAlphaNumericW', (('int', None),) ),
    'user32.ischaralphaw':( 'int', None, 'stdcall', 'user32.IsCharAlphaW', (('int', None),) ),
    'user32.ischarlowera':( 'int', None, 'stdcall', 'user32.IsCharLowerA', (('int', None),) ),
    'user32.ischarlowerw':( 'int', None, 'stdcall', 'user32.IsCharLowerW', (('int', None),) ),
    'user32.ischaruppera':( 'int', None, 'stdcall', 'user32.IsCharUpperA', (('int', None),) ),
    'user32.ischarupperw':( 'int', None, 'stdcall', 'user32.IsCharUpperW', (('int', None),) ),
    'user32.ischild':( 'int', None, 'stdcall', 'user32.IsChild', (('int', None), ('int', None)) ),
    'user32.isclipboardformatavailable':( 'int', None, 'stdcall', 'user32.IsClipboardFormatAvailable', (('int', None),) ),
    'user32.isdialogmessage':( 'int', None, 'stdcall', 'user32.IsDialogMessage', (('void *', 'obj'),) ),
    'user32.isdialogmessagea':( 'int', None, 'stdcall', 'user32.IsDialogMessageA', (('int', None), ('void *', 'obj')) ),
    'user32.isdialogmessagew':( 'int', None, 'stdcall', 'user32.IsDialogMessageW', (('int', None), ('void *', 'obj')) ),
    'user32.isdlgbuttonchecked':( 'int', None, 'stdcall', 'user32.IsDlgButtonChecked', (('int', None), ('int', None)) ),
    'user32.isguithread':( 'int', None, 'stdcall', 'user32.IsGUIThread', (('int', None),) ),
    'user32.ishungappwindow':( 'int', None, 'stdcall', 'user32.IsHungAppWindow', (('int', None),) ),
    'user32.isiconic':( 'int', None, 'stdcall', 'user32.IsIconic', (('int', None),) ),
    'user32.ismenu':( 'int', None, 'stdcall', 'user32.IsMenu', (('int', None),) ),
    'user32.isrectempty':( 'int', None, 'stdcall', 'user32.IsRectEmpty', (('int', None),) ),
    'user32.isserversidewindow':( 'int', None, 'stdcall', 'user32.IsServerSideWindow', () ),
    'user32.iswineventhookinstalled':( 'int', None, 'stdcall', 'user32.IsWinEventHookInstalled', (('int', None),) ),
    'user32.iswindow':( 'int', None, 'stdcall', 'user32.IsWindow', (('int', None),) ),
    'user32.iswindowenabled':( 'int', None, 'stdcall', 'user32.IsWindowEnabled', (('int', None),) ),
    'user32.iswindowindestroy':( 'int', None, 'stdcall', 'user32.IsWindowInDestroy', () ),
    'user32.iswindowunicode':( 'int', None, 'stdcall', 'user32.IsWindowUnicode', (('int', None),) ),
    'user32.iswindowvisible':( 'int', None, 'stdcall', 'user32.IsWindowVisible', (('int', None),) ),
    'user32.iszoomed':( 'int', None, 'stdcall', 'user32.IsZoomed', (('int', None),) ),
    'user32.killsystemtimer':( 'int', None, 'stdcall', 'user32.KillSystemTimer', (('int', None), ('int', None)) ),
    'user32.killtimer':( 'int', None, 'stdcall', 'user32.KillTimer', (('int', None), ('int', None)) ),
    'user32.loadacceleratorsa':( 'int', None, 'stdcall', 'user32.LoadAcceleratorsA', (('void *', 'ptr'), ('int', None)) ),
    'user32.loadacceleratorsw':( 'int', None, 'stdcall', 'user32.LoadAcceleratorsW', (('void *', 'ptr'), ('int', None)) ),
    'user32.loadbitmapa':( 'int', None, 'stdcall', 'user32.LoadBitmapA', (('int', None), ('void *', 'ptr')) ),
    'user32.loadbitmapw':( 'int', None, 'stdcall', 'user32.LoadBitmapW', (('int', None), ('int', None)) ),
    'user32.loadcursora':( 'int', None, 'stdcall', 'user32.LoadCursorA', (('int', None), ('void *', 'ptr')) ),
    'user32.loadcursorfromfilea':( 'int', None, 'stdcall', 'user32.LoadCursorFromFileA', (('void *', 'ptr'),) ),
    'user32.loadcursorfromfilew':( 'int', None, 'stdcall', 'user32.LoadCursorFromFileW', (('int', None),) ),
    'user32.loadcursorw':( 'int', None, 'stdcall', 'user32.LoadCursorW', (('int', None), ('int', None)) ),
    'user32.loadicona':( 'int', None, 'stdcall', 'user32.LoadIconA', (('int', None), ('void *', 'ptr')) ),
    'user32.loadiconw':( 'int', None, 'stdcall', 'user32.LoadIconW', (('int', None), ('int', None)) ),
    'user32.loadimagea':( 'int', None, 'stdcall', 'user32.LoadImageA', (('int', None), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.loadimagew':( 'int', None, 'stdcall', 'user32.LoadImageW', (('int', None), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.loadkeyboardlayouta':( 'int', None, 'stdcall', 'user32.LoadKeyboardLayoutA', (('int', None), ('int', None)) ),
    'user32.loadkeyboardlayoutex':( 'int', None, 'stdcall', 'user32.LoadKeyboardLayoutEx', (('int', None), ('int', None), ('int', None)) ),
    'user32.loadkeyboardlayoutw':( 'int', None, 'stdcall', 'user32.LoadKeyboardLayoutW', (('void *', 'ptr'), ('int', None)) ),
    'user32.loadlocalfonts':( 'int', None, 'cdecl', 'user32.LoadLocalFonts', () ),
    'user32.loadmenua':( 'int', None, 'stdcall', 'user32.LoadMenuA', (('int', None), ('int', None)) ),
    'user32.loadmenuindirecta':( 'int', None, 'stdcall', 'user32.LoadMenuIndirectA', (('int', None),) ),
    'user32.loadmenuindirectw':( 'int', None, 'stdcall', 'user32.LoadMenuIndirectW', (('int', None),) ),
    'user32.loadmenuw':( 'int', None, 'stdcall', 'user32.LoadMenuW', (('int', None), ('int', None)) ),
    'user32.loadremotefonts':( 'int', None, 'cdecl', 'user32.LoadRemoteFonts', () ),
    'user32.loadstringa':( 'int', None, 'stdcall', 'user32.LoadStringA', (('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'user32.loadstringw':( 'int', None, 'stdcall', 'user32.LoadStringW', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'user32.locksetforegroundwindow':( 'int', None, 'stdcall', 'user32.LockSetForegroundWindow', (('int', None),) ),
    'user32.lockwindowstation':( 'int', None, 'stdcall', 'user32.LockWindowStation', (('int', None),) ),
    'user32.lockwindowupdate':( 'int', None, 'stdcall', 'user32.LockWindowUpdate', (('int', None),) ),
    'user32.lockworkstation':( 'int', None, 'cdecl', 'user32.LockWorkStation', () ),
    'user32.lookupiconidfromdirectory':( 'int', None, 'stdcall', 'user32.LookupIconIdFromDirectory', (('int', None), ('int', None)) ),
    'user32.lookupiconidfromdirectoryex':( 'int', None, 'stdcall', 'user32.LookupIconIdFromDirectoryEx', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.mbtowcsex':( 'int', None, 'stdcall', 'user32.MBToWCSEx', (('int', None), ('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'user32.mb_getstring':( 'int', None, 'stdcall', 'user32.MB_GetString', (('int', None),) ),
    'user32.mapdialogrect':( 'int', None, 'stdcall', 'user32.MapDialogRect', ( ('int', None), ('void *', 'ptr')) ),
    'user32.mapvirtualkeya':( 'int', None, 'stdcall', 'user32.MapVirtualKeyA', (('int', None), ('int', None)) ),
    'user32.mapvirtualkeyexa':( 'int', None, 'stdcall', 'user32.MapVirtualKeyExA', (('int', None), ('int', None), ('int', None)) ),
    'user32.mapvirtualkeyexw':( 'int', None, 'stdcall', 'user32.MapVirtualKeyExW', (('int', None), ('int', None), ('int', None)) ),
    'user32.mapvirtualkeyw':( 'int', None, 'stdcall', 'user32.MapVirtualKeyW', (('int', None), ('int', None)) ),
    'user32.mapwindowpoints':( 'int', None, 'stdcall', 'user32.MapWindowPoints', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'user32.menuitemfrompoint':( 'int', None, 'stdcall', 'user32.MenuItemFromPoint', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.menuwindowproca':( 'int', None, 'stdcall', 'user32.MenuWindowProcA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.menuwindowprocw':( 'int', None, 'stdcall', 'user32.MenuWindowProcW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.messagebeep':( 'int', None, 'stdcall', 'user32.MessageBeep', (('int', None),) ),
    'user32.messageboxa':( 'int', None, 'stdcall', 'user32.MessageBoxA', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.messageboxexa':( 'int', None, 'stdcall', 'user32.MessageBoxExA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.messageboxexw':( 'int', None, 'stdcall', 'user32.MessageBoxExW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.messageboxindirecta':( 'int', None, 'stdcall', 'user32.MessageBoxIndirectA', (('int', None),) ),
    'user32.messageboxindirectw':( 'int', None, 'stdcall', 'user32.MessageBoxIndirectW', (('int', None),) ),
    'user32.messageboxtimeouta':( 'int', None, 'stdcall', 'user32.MessageBoxTimeoutA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.messageboxtimeoutw':( 'int', None, 'stdcall', 'user32.MessageBoxTimeoutW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.messageboxw':( 'int', None, 'stdcall', 'user32.MessageBoxW', (('int', None), ('void *', 'ptr'), ('void *', 'ptr'), ('int', None)) ),
    'user32.modifymenua':( 'int', None, 'stdcall', 'user32.ModifyMenuA', (('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'user32.modifymenuw':( 'int', None, 'stdcall', 'user32.ModifyMenuW', (('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'user32.monitorfrompoint':( 'int', None, 'stdcall', 'user32.MonitorFromPoint', (('int', None), ('int', None), ('int', None)) ),
    'user32.monitorfromrect':( 'int', None, 'stdcall', 'user32.MonitorFromRect', (('void *', 'ptr'), ('int', None)) ),
    'user32.monitorfromwindow':( 'int', None, 'stdcall', 'user32.MonitorFromWindow', (('int', None), ('int', None)) ),
    'user32.movewindow':( 'int', None, 'stdcall', 'user32.MoveWindow', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.msgwaitformultipleobjects':( 'int', None, 'stdcall', 'user32.MsgWaitForMultipleObjects', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.msgwaitformultipleobjectsex':( 'int', None, 'stdcall', 'user32.MsgWaitForMultipleObjectsEx', (('int', None), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None)) ),
    'user32.notifywinevent':( 'int', None, 'stdcall', 'user32.NotifyWinEvent', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.oemkeyscan':( 'int', None, 'stdcall', 'user32.OemKeyScan', ( ('int', None),) ),
    'user32.oemtochara':( 'int', None, 'stdcall', 'user32.OemToCharA', (('int', None), ('int', None)) ),
    'user32.oemtocharbuffa':( 'int', None, 'stdcall', 'user32.OemToCharBuffA', (('int', None), ('int', None), ('int', None)) ),
    'user32.oemtocharbuffw':( 'int', None, 'stdcall', 'user32.OemToCharBuffW', (('int', None), ('void *', 'ptr'), ('int', None)) ),
    'user32.oemtocharw':( 'int', None, 'stdcall', 'user32.OemToCharW', (('int', None), ('int', None)) ),
    'user32.offsetrect':( 'int', None, 'stdcall', 'user32.OffsetRect', (('void *', 'ptr'), ('int', None), ('int', None)) ),
    'user32.openclipboard':( 'int', None, 'stdcall', 'user32.OpenClipboard', (('int', None),) ),
    'user32.opendesktopa':( 'int', None, 'stdcall', 'user32.OpenDesktopA', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.opendesktopw':( 'int', None, 'stdcall', 'user32.OpenDesktopW', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.openicon':( 'int', None, 'stdcall', 'user32.OpenIcon', (('int', None),) ),
    'user32.openinputdesktop':( 'int', None, 'stdcall', 'user32.OpenInputDesktop', (('int', None), ('int', None), ('int', None)) ),
    'user32.openwindowstationa':( 'int', None, 'stdcall', 'user32.OpenWindowStationA', (('int', None), ('int', None), ('int', None)) ),
    'user32.openwindowstationw':( 'int', None, 'stdcall', 'user32.OpenWindowStationW', (('int', None), ('int', None), ('int', None)) ),
    'user32.packddelparam':( 'int', None, 'stdcall', 'user32.PackDDElParam', (('int', None), ('int', None), ('int', None)) ),
    'user32.paintdesktop':( 'int', None, 'stdcall', 'user32.PaintDesktop', (('int', None),) ),
    'user32.paintmenubar':( 'int', None, 'stdcall', 'user32.PaintMenuBar', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.peekmessagea':( 'int', None, 'stdcall', 'user32.PeekMessageA', (('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.peekmessagew':( 'int', None, 'stdcall', 'user32.PeekMessageW', (('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.postmessagea':( 'int', None, 'stdcall', 'user32.PostMessageA', (('int', None), ('int', None), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'user32.postmessagew':( 'int', None, 'stdcall', 'user32.PostMessageW', (('int', None), ('int', None), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'user32.postquitmessage':( 'int', None, 'stdcall', 'user32.PostQuitMessage', (('int', None),) ),
    'user32.postthreadmessagea':( 'int', None, 'stdcall', 'user32.PostThreadMessageA', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.postthreadmessagew':( 'int', None, 'stdcall', 'user32.PostThreadMessageW', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.printwindow':( 'int', None, 'stdcall', 'user32.PrintWindow', (('int', None), ('int', None), ('int', None)) ),
    'user32.privateextracticonexa':( 'int', None, 'stdcall', 'user32.PrivateExtractIconExA', (('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.privateextracticonexw':( 'int', None, 'stdcall', 'user32.PrivateExtractIconExW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.privateextracticonsa':( 'int', None, 'stdcall', 'user32.PrivateExtractIconsA', (('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.privateextracticonsw':( 'int', None, 'stdcall', 'user32.PrivateExtractIconsW', (('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None)) ),
    'user32.privatesetdbgtag':( 'int', None, 'stdcall', 'user32.PrivateSetDbgTag', (('int', None), ('int', None)) ),
    'user32.privatesetripflags':( 'int', None, 'stdcall', 'user32.PrivateSetRipFlags', (('int', None), ('int', None)) ),
    'user32.ptinrect':( 'int', None, 'stdcall', 'user32.PtInRect', (('void *', 'ptr'), ('int', None), ('int', None)) ),
    'user32.querysendmessage':( 'int', None, 'stdcall', 'user32.QuerySendMessage', (('int', None),) ),
    'user32.queryusercounters':( 'int', None, 'stdcall', 'user32.QueryUserCounters', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.realchildwindowfrompoint':( 'int', None, 'stdcall', 'user32.RealChildWindowFromPoint', (('int', None), ('int', None), ('int', None)) ),
    'user32.realgetwindowclass':( 'int', None, 'stdcall', 'user32.RealGetWindowClass', (('int', None), ('int', None), ('int', None)) ),
    'user32.realgetwindowclassa':( 'int', None, 'stdcall', 'user32.RealGetWindowClassA', (('int', None), ('int', None), ('int', None)) ),
    'user32.realgetwindowclassw':( 'int', None, 'stdcall', 'user32.RealGetWindowClassW', (('int', None), ('int', None), ('int', None)) ),
    'user32.reasoncodeneedsbugid':( 'int', None, 'stdcall', 'user32.ReasonCodeNeedsBugID', (('int', None),) ),
    'user32.reasoncodeneedscomment':( 'int', None, 'stdcall', 'user32.ReasonCodeNeedsComment', (('int', None),) ),
    'user32.recordshutdownreason':( 'int', None, 'stdcall', 'user32.RecordShutdownReason', ( ('void *', 'ptr'),) ),
    'user32.redrawwindow':( 'int', None, 'stdcall', 'user32.RedrawWindow', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.registerclassa':( 'int', None, 'stdcall', 'user32.RegisterClassA', (('int', None),) ),
    'user32.registerclassexa':( 'int', None, 'stdcall', 'user32.RegisterClassExA', (('void *', 'ptr'),) ),
    'user32.registerclassexw':( 'int', None, 'stdcall', 'user32.RegisterClassExW', (('void *', 'ptr'),) ),
    'user32.registerclassw':( 'int', None, 'stdcall', 'user32.RegisterClassW', (('int', None),) ),
    'user32.registerclipboardformata':( 'int', None, 'stdcall', 'user32.RegisterClipboardFormatA', (('int', None),) ),
    'user32.registerclipboardformatw':( 'int', None, 'stdcall', 'user32.RegisterClipboardFormatW', (('int', None),) ),
    'user32.registerdevicenotificationa':( 'int', None, 'stdcall', 'user32.RegisterDeviceNotificationA', (('int', None), ('int', None), ('int', None)) ),
    'user32.registerdevicenotificationw':( 'int', None, 'stdcall', 'user32.RegisterDeviceNotificationW', (('int', None), ('int', None), ('int', None)) ),
    'user32.registerhotkey':( 'int', None, 'stdcall', 'user32.RegisterHotKey', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.registerlogonprocess':( 'int', None, 'stdcall', 'user32.RegisterLogonProcess', (('void *', 'ptr'), ('void *', 'ptr')) ),
    'user32.registermessagepumphook':( 'int', None, 'stdcall', 'user32.RegisterMessagePumpHook', (('void *', 'funcptr'),) ),
    'user32.registerrawinputdevices':( 'int', None, 'stdcall', 'user32.RegisterRawInputDevices', (('int', None), ('int', None), ('int', None)) ),
    'user32.registerservicesprocess':( 'int', None, 'stdcall', 'user32.RegisterServicesProcess', (('int', None),) ),
    'user32.registershellhookwindow':( 'int', None, 'stdcall', 'user32.RegisterShellHookWindow', (('int', None),) ),
    'user32.registersystemthread':( 'int', None, 'stdcall', 'user32.RegisterSystemThread', (('void *', 'ptr'), ('void *', 'ptr')) ),
    'user32.registertasklist':( 'int', None, 'stdcall', 'user32.RegisterTasklist', (('int', None),) ),
    'user32.registeruserapihook':( 'int', None, 'stdcall', 'user32.RegisterUserApiHook', (('int', None), ('int', None)) ),
    'user32.registerwindowmessagea':( 'int', None, 'stdcall', 'user32.RegisterWindowMessageA', (('int', None),) ),
    'user32.registerwindowmessagew':( 'int', None, 'stdcall', 'user32.RegisterWindowMessageW', (('int', None),) ),
    'user32.releasecapture':( 'int', None, 'cdecl', 'user32.ReleaseCapture', () ),
    'user32.releasedc':( 'int', None, 'stdcall', 'user32.ReleaseDC', (('int', None), ('int', None)) ),
    'user32.removemenu':( 'int', None, 'stdcall', 'user32.RemoveMenu', (('int', None), ('int', None), ('int', None)) ),
    'user32.removepropa':( 'int', None, 'stdcall', 'user32.RemovePropA', (('int', None), ('int', None)) ),
    'user32.removepropw':( 'int', None, 'stdcall', 'user32.RemovePropW', (('int', None), ('int', None)) ),
    'user32.replymessage':( 'int', None, 'stdcall', 'user32.ReplyMessage', (('int', None),) ),
    'user32.resolvedesktopforwow':( 'int', None, 'stdcall', 'user32.ResolveDesktopForWOW', (('int', None),) ),
    'user32.reuseddelparam':( 'int', None, 'stdcall', 'user32.ReuseDDElParam', (('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.screentoclient':( 'int', None, 'stdcall', 'user32.ScreenToClient', (('int', None), ('void *', 'ptr')) ),
    'user32.scrollchildren':( 'int', None, 'stdcall', 'user32.ScrollChildren', ( ('int', None), ('int', None)) ),
    'user32.scrolldc':( 'int', None, 'stdcall', 'user32.ScrollDC', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.scrollwindow':( 'int', None, 'stdcall', 'user32.ScrollWindow', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.scrollwindowex':( 'int', None, 'stdcall', 'user32.ScrollWindowEx', (('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'user32.senddlgitemmessagea':( 'int', None, 'stdcall', 'user32.SendDlgItemMessageA', (('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'user32.senddlgitemmessagew':( 'int', None, 'stdcall', 'user32.SendDlgItemMessageW', (('int', None), ('int', None), ('int', None), ('void *', 'obj'), ('void *'), 'ptr') ),
    'user32.sendimemessageexa':( 'int', None, 'stdcall', 'user32.SendIMEMessageExA', (('int', None), ('int', None)) ),
    'user32.sendimemessageexw':( 'int', None, 'stdcall', 'user32.SendIMEMessageExW', (('int', None), ('int', None)) ),
    'user32.sendinput':( 'int', None, 'stdcall', 'user32.SendInput', (('int', None), ('void *', 'ptr'), ('int', None)) ),
    'user32.sendmessagea':( 'int', None, 'stdcall', 'user32.SendMessageA', (('int', None), ('int', None), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'user32.sendmessagecallbacka':( 'int', None, 'stdcall', 'user32.SendMessageCallbackA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.sendmessagecallbackw':( 'int', None, 'stdcall', 'user32.SendMessageCallbackW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.sendmessagetimeouta':( 'int', None, 'stdcall', 'user32.SendMessageTimeoutA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.sendmessagetimeoutw':( 'int', None, 'stdcall', 'user32.SendMessageTimeoutW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'user32.sendmessagew':( 'int', None, 'stdcall', 'user32.SendMessageW', (('int', None), ('int', None), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'user32.sendnotifymessagea':( 'int', None, 'stdcall', 'user32.SendNotifyMessageA', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.sendnotifymessagew':( 'int', None, 'stdcall', 'user32.SendNotifyMessageW', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.setactivewindow':( 'int', None, 'stdcall', 'user32.SetActiveWindow', (('int', None),) ),
    'user32.setcapture':( 'int', None, 'stdcall', 'user32.SetCapture', (('int', None),) ),
    'user32.setcaretblinktime':( 'int', None, 'stdcall', 'user32.SetCaretBlinkTime', (('int', None),) ),
    'user32.setcaretpos':( 'int', None, 'stdcall', 'user32.SetCaretPos', (('void *', 'ptr'), ('void *', 'ptr')) ),
    'user32.setclasslonga':( 'int', None, 'stdcall', 'user32.SetClassLongA', (('int', None), ('int', None), ('int', None)) ),
    'user32.setclasslongw':( 'int', None, 'stdcall', 'user32.SetClassLongW', (('int', None), ('int', None), ('void *', 'ptr')) ),
    'user32.setclassword':( 'int', None, 'stdcall', 'user32.SetClassWord', (('int', None), ('int', None), ('int', None)) ),
    'user32.setclipboarddata':( 'int', None, 'stdcall', 'user32.SetClipboardData', (('int', None), ('int', None)) ),
    'user32.setclipboardviewer':( 'int', None, 'stdcall', 'user32.SetClipboardViewer', (('int', None),) ),
    'user32.setconsolereservekeys':( 'int', None, 'stdcall', 'user32.SetConsoleReserveKeys', (('int', None), ('int', None)) ),
    'user32.setcursor':( 'int', None, 'stdcall', 'user32.SetCursor', (('int', None),) ),
    'user32.setcursorcontents':( 'int', None, 'stdcall', 'user32.SetCursorContents', (('int', None), ('int', None)) ),
    'user32.setcursorpos':( 'int', None, 'stdcall', 'user32.SetCursorPos', (('void *', 'ptr'), ('void *', 'ptr')) ),
    'user32.setdebugerrorlevel':( 'int', None, 'stdcall', 'user32.SetDebugErrorLevel', (('int', None),) ),
    'user32.setdeskwallpaper':( 'int', None, 'stdcall', 'user32.SetDeskWallpaper', (('void *', 'ptr'),) ),
    'user32.setdlgitemint':( 'int', None, 'stdcall', 'user32.SetDlgItemInt', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.setdlgitemtexta':( 'int', None, 'stdcall', 'user32.SetDlgItemTextA', (('int', None), ('int', None), ('void *', 'obj')) ),
    'user32.setdlgitemtextw':( 'int', None, 'stdcall', 'user32.SetDlgItemTextW', (('int', None), ('int', None), ('void *', 'obj')) ),
    'user32.setdoubleclicktime':( 'int', None, 'stdcall', 'user32.SetDoubleClickTime', (('int', None),) ),
    'user32.setfocus':( 'int', None, 'stdcall', 'user32.SetFocus', (('int', None),) ),
    'user32.setforegroundwindow':( 'int', None, 'stdcall', 'user32.SetForegroundWindow', (('int', None),) ),
    'user32.setinternalwindowpos':( 'int', None, 'stdcall', 'user32.SetInternalWindowPos', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.setkeyboardstate':( 'int', None, 'stdcall', 'user32.SetKeyboardState', (('int', None),) ),
    'user32.setlasterrorex':( 'int', None, 'stdcall', 'user32.SetLastErrorEx', (('int', None), ('int', None)) ),
    'user32.setlayeredwindowattributes':( 'int', None, 'stdcall', 'user32.SetLayeredWindowAttributes', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.setlogonnotifywindow':( 'int', None, 'stdcall', 'user32.SetLogonNotifyWindow', (('int', None),) ),
    'user32.setmenu':( 'int', None, 'stdcall', 'user32.SetMenu', (('int', None), ('int', None)) ),
    'user32.setmenucontexthelpid':( 'int', None, 'stdcall', 'user32.SetMenuContextHelpId', (('int', None), ('int', None)) ),
    'user32.setmenudefaultitem':( 'int', None, 'stdcall', 'user32.SetMenuDefaultItem', (('int', None), ('int', None), ('int', None)) ),
    'user32.setmenuinfo':( 'int', None, 'stdcall', 'user32.SetMenuInfo', (('int', None), ('int', None)) ),
    'user32.setmenuitembitmaps':( 'int', None, 'stdcall', 'user32.SetMenuItemBitmaps', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.setmenuiteminfoa':( 'int', None, 'stdcall', 'user32.SetMenuItemInfoA', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.setmenuiteminfow':( 'int', None, 'stdcall', 'user32.SetMenuItemInfoW', (('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'user32.setmessageextrainfo':( 'int', None, 'stdcall', 'user32.SetMessageExtraInfo', (('int', None),) ),
    'user32.setmessagequeue':( 'int', None, 'stdcall', 'user32.SetMessageQueue', (('int', None),) ),
    'user32.setparent':( 'int', None, 'stdcall', 'user32.SetParent', (('int', None), ('int', None)) ),
    'user32.setprocessdefaultlayout':( 'int', None, 'stdcall', 'user32.SetProcessDefaultLayout', (('int', None),) ),
    'user32.setprocesswindowstation':( 'int', None, 'stdcall', 'user32.SetProcessWindowStation', (('int', None),) ),
    'user32.setprogmanwindow':( 'int', None, 'stdcall', 'user32.SetProgmanWindow', (('int', None),) ),
    'user32.setpropa':( 'int', None, 'stdcall', 'user32.SetPropA', (('int', None), ('int', None), ('int', None)) ),
    'user32.setpropw':( 'int', None, 'stdcall', 'user32.SetPropW', (('int', None), ('int', None), ('int', None)) ),
    'user32.setrect':( 'int', None, 'stdcall', 'user32.SetRect', (('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.setrectempty':( 'int', None, 'stdcall', 'user32.SetRectEmpty', (('int', None),) ),
    'user32.setscrollinfo':( 'int', None, 'stdcall', 'user32.SetScrollInfo', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'user32.setscrollpos':( 'int', None, 'stdcall', 'user32.SetScrollPos', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.setscrollrange':( 'int', None, 'stdcall', 'user32.SetScrollRange', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.setshellwindow':( 'int', None, 'stdcall', 'user32.SetShellWindow', (('int', None),) ),
    'user32.setshellwindowex':( 'int', None, 'stdcall', 'user32.SetShellWindowEx', (('int', None), ('int', None)) ),
    'user32.setsyscolors':( 'int', None, 'stdcall', 'user32.SetSysColors', (('int', None), ('void *', 'ptr'), ('int', None)) ),
    'user32.setsyscolorstemp':( 'int', None, 'stdcall', 'user32.SetSysColorsTemp', (('int', None), ('int', None), ('int', None)) ),
    'user32.setsystemcursor':( 'int', None, 'stdcall', 'user32.SetSystemCursor', (('int', None), ('int', None)) ),
    'user32.setsystemmenu':( 'int', None, 'stdcall', 'user32.SetSystemMenu', (('int', None), ('int', None)) ),
    'user32.setsystemtimer':( 'int', None, 'stdcall', 'user32.SetSystemTimer', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.settaskmanwindow':( 'int', None, 'stdcall', 'user32.SetTaskmanWindow', (('int', None),) ),
    'user32.setthreaddesktop':( 'int', None, 'stdcall', 'user32.SetThreadDesktop', (('int', None),) ),
    'user32.settimer':( 'int', None, 'stdcall', 'user32.SetTimer', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.setuserobjectinformationa':( 'int', None, 'stdcall', 'user32.SetUserObjectInformationA', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.setuserobjectinformationw':( 'int', None, 'stdcall', 'user32.SetUserObjectInformationW', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.setuserobjectsecurity':( 'int', None, 'stdcall', 'user32.SetUserObjectSecurity', (('int', None), ('int', None), ('int', None)) ),
    'user32.setwineventhook':( 'int', None, 'stdcall', 'user32.SetWinEventHook', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.setwindowcontexthelpid':( 'int', None, 'stdcall', 'user32.SetWindowContextHelpId', (('int', None), ('int', None)) ),
    'user32.setwindowlonga':( 'int', None, 'stdcall', 'user32.SetWindowLongA', (('int', None), ('int', None), ('void *', 'obj')) ),
    'user32.setwindowlongw':( 'int', None, 'stdcall', 'user32.SetWindowLongW', (('int', None), ('int', None), ('void *', 'obj')) ),
    'user32.setwindowplacement':( 'int', None, 'stdcall', 'user32.SetWindowPlacement', (('int', None), ('int', None)) ),
    'user32.setwindowpos':( 'int', None, 'stdcall', 'user32.SetWindowPos', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.setwindowrgn':( 'int', None, 'stdcall', 'user32.SetWindowRgn', (('int', None), ('int', None), ('int', None)) ),
    'user32.setwindowstationuser':( 'int', None, 'stdcall', 'user32.SetWindowStationUser', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.setwindowtexta':( 'int', None, 'stdcall', 'user32.SetWindowTextA', (('int', None), ('void *', 'obj')) ),
    'user32.setwindowtextw':( 'int', None, 'stdcall', 'user32.SetWindowTextW', (('int', None), ('void *', 'obj')) ),
    'user32.setwindowword':( 'int', None, 'stdcall', 'user32.SetWindowWord', (('int', None), ('int', None), ('int', None)) ),
    'user32.setwindowshooka':( 'int', None, 'stdcall', 'user32.SetWindowsHookA', (('int', None), ('int', None)) ),
    'user32.setwindowshookexa':( 'int', None, 'stdcall', 'user32.SetWindowsHookExA', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.setwindowshookexw':( 'int', None, 'stdcall', 'user32.SetWindowsHookExW', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.setwindowshookw':( 'int', None, 'stdcall', 'user32.SetWindowsHookW', (('int', None), ('int', None)) ),
    'user32.showcaret':( 'int', None, 'stdcall', 'user32.ShowCaret', (('int', None),) ),
    'user32.showcursor':( 'int', None, 'stdcall', 'user32.ShowCursor', (('int', None),) ),
    'user32.showownedpopups':( 'int', None, 'stdcall', 'user32.ShowOwnedPopups', (('int', None), ('int', None)) ),
    'user32.showscrollbar':( 'int', None, 'stdcall', 'user32.ShowScrollBar', (('int', None), ('int', None), ('int', None)) ),
    'user32.showstartglass':( 'int', None, 'stdcall', 'user32.ShowStartGlass', (('int', None),) ),
    'user32.showwindow':( 'int', None, 'stdcall', 'user32.ShowWindow', (('int', None), ('int', None)) ),
    'user32.showwindowasync':( 'int', None, 'stdcall', 'user32.ShowWindowAsync', (('int', None), ('int', None)) ),
    'user32.softmodalmessagebox':( 'int', None, 'stdcall', 'user32.SoftModalMessageBox', () ),
    'user32.subtractrect':( 'int', None, 'stdcall', 'user32.SubtractRect', (('int', None), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'user32.swapmousebutton':( 'int', None, 'stdcall', 'user32.SwapMouseButton', (('int', None),) ),
    'user32.switchdesktop':( 'int', None, 'stdcall', 'user32.SwitchDesktop', (('int', None),) ),
    'user32.switchtothiswindow':( 'int', None, 'stdcall', 'user32.SwitchToThisWindow', (('int', None), ('int', None)) ),
    'user32.systemparametersinfoa':( 'int', None, 'stdcall', 'user32.SystemParametersInfoA', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'user32.systemparametersinfow':( 'int', None, 'stdcall', 'user32.SystemParametersInfoW', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.tabbedtextouta':( 'int', None, 'stdcall', 'user32.TabbedTextOutA', ( ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.tabbedtextoutw':( 'int', None, 'stdcall', 'user32.TabbedTextOutW', (('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.tilechildwindows':( 'int', None, 'stdcall', 'user32.TileChildWindows', ( ('int', None),) ),
    'user32.tilewindows':( 'int', None, 'stdcall', 'user32.TileWindows', ( ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.toascii':( 'int', None, 'stdcall', 'user32.ToAscii', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.toasciiex':( 'int', None, 'stdcall', 'user32.ToAsciiEx', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.tounicode':( 'int', None, 'stdcall', 'user32.ToUnicode', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.tounicodeex':( 'int', None, 'stdcall', 'user32.ToUnicodeEx', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.trackmouseevent':( 'int', None, 'stdcall', 'user32.TrackMouseEvent', (('int', None),) ),
    'user32.trackpopupmenu':( 'int', None, 'stdcall', 'user32.TrackPopupMenu', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.trackpopupmenuex':( 'int', None, 'stdcall', 'user32.TrackPopupMenuEx', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.translateaccelerator':( 'int', None, 'stdcall', 'user32.TranslateAccelerator', (('int', None), ('int', None), ('int', None)) ),
    'user32.translateacceleratora':( 'int', None, 'stdcall', 'user32.TranslateAcceleratorA', (('int', None), ('int', None), ('int', None)) ),
    'user32.translateacceleratorw':( 'int', None, 'stdcall', 'user32.TranslateAcceleratorW', (('int', None), ('int', None), ('int', None)) ),
    'user32.translatemdisysaccel':( 'int', None, 'stdcall', 'user32.TranslateMDISysAccel', (('int', None), ('void *', 'ptr')) ),
    'user32.translatemessage':( 'int', None, 'stdcall', 'user32.TranslateMessage', (('void *', 'ptr'),) ),
    'user32.translatemessageex':( 'int', None, 'stdcall', 'user32.TranslateMessageEx', (('int', None), ('int', None)) ),
    'user32.unhookwinevent':( 'int', None, 'stdcall', 'user32.UnhookWinEvent', (('int', None),) ),
    'user32.unhookwindowshook':( 'int', None, 'stdcall', 'user32.UnhookWindowsHook', (('void *', 'ptr'), ('void *', 'ptr')) ),
    'user32.unhookwindowshookex':( 'int', None, 'stdcall', 'user32.UnhookWindowsHookEx', (('int', None),) ),
    'user32.unionrect':( 'int', None, 'stdcall', 'user32.UnionRect', (('void *', 'ptr'), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'user32.unloadkeyboardlayout':( 'int', None, 'stdcall', 'user32.UnloadKeyboardLayout', (('int', None),) ),
    'user32.unlockwindowstation':( 'int', None, 'stdcall', 'user32.UnlockWindowStation', (('int', None),) ),
    'user32.unpackddelparam':( 'int', None, 'stdcall', 'user32.UnpackDDElParam', (('int', None), ('int', None), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'user32.unregisterclassa':( 'int', None, 'stdcall', 'user32.UnregisterClassA', (('int', None), ('int', None)) ),
    'user32.unregisterclassw':( 'int', None, 'stdcall', 'user32.UnregisterClassW', (('int', None), ('int', None)) ),
    'user32.unregisterdevicenotification':( 'int', None, 'stdcall', 'user32.UnregisterDeviceNotification', (('int', None),) ),
    'user32.unregisterhotkey':( 'int', None, 'stdcall', 'user32.UnregisterHotKey', (('int', None), ('int', None)) ),
    'user32.unregistermessagepumphook':( 'int', None, 'cdecl', 'user32.UnregisterMessagePumpHook', () ),
    'user32.unregisteruserapihook':( 'int', None, 'cdecl', 'user32.UnregisterUserApiHook', () ),
    'user32.updatelayeredwindow':( 'int', None, 'stdcall', 'user32.UpdateLayeredWindow', (('int', None), ('int', None), ('void *', 'ptr'), ('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None)) ),
    'user32.updateperusersystemparameters':( 'int', None, 'stdcall', 'user32.UpdatePerUserSystemParameters', (('int', None), ('int', None)) ),
    'user32.updatewindow':( 'int', None, 'stdcall', 'user32.UpdateWindow', (('int', None),) ),
    'user32.user32initializeimmentrytable':( 'int', None, 'stdcall', 'user32.User32InitializeImmEntryTable', (('int', None),) ),
    'user32.userclientdllinitialize':( 'int', None, 'stdcall', 'user32.UserClientDllInitialize', (('int', None), ('int', None), ('int', None)) ),
    'user32.userhandlegrantaccess':( 'int', None, 'stdcall', 'user32.UserHandleGrantAccess', (('int', None), ('int', None), ('int', None)) ),
    'user32.userlpkpsmtextout':( 'int', None, 'stdcall', 'user32.UserLpkPSMTextOut', (('int', None), ('int', None), ('DWORD', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.userlpktabbedtextout':( 'int', None, 'stdcall', 'user32.UserLpkTabbedTextOut', (('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.userrealizepalette':( 'int', None, 'stdcall', 'user32.UserRealizePalette', (('int', None),) ),
    'user32.userregisterwowhandlers':( 'int', None, 'stdcall', 'user32.UserRegisterWowHandlers', (('int', None), ('int', None)) ),
    'user32.vripoutput':( 'int', None, 'cdecl', 'user32.VRipOutput', () ),
    'user32.vtagoutput':( 'int', None, 'cdecl', 'user32.VTagOutput', () ),
    'user32.validaterect':( 'int', None, 'stdcall', 'user32.ValidateRect', (('int', None), ('int', None)) ),
    'user32.validatergn':( 'int', None, 'stdcall', 'user32.ValidateRgn', (('int', None), ('int', None)) ),
    'user32.vkkeyscana':( 'int', None, 'stdcall', 'user32.VkKeyScanA', ( ('int', None),) ),
    'user32.vkkeyscanexa':( 'int', None, 'stdcall', 'user32.VkKeyScanExA', ( ('int', None), ('int', None)) ),
    'user32.vkkeyscanexw':( 'int', None, 'stdcall', 'user32.VkKeyScanExW', (('int', None), ('int', None)) ),
    'user32.vkkeyscanw':( 'int', None, 'stdcall', 'user32.VkKeyScanW', (('int', None),) ),
    'user32.wcstombex':( 'int', None, 'stdcall', 'user32.WCSToMBEx', (('int', None), ('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'user32.winnlsenableime':( 'int', None, 'stdcall', 'user32.WINNLSEnableIME', (('int', None), ('int', None)) ),
    'user32.winnlsgetenablestatus':( 'int', None, 'stdcall', 'user32.WINNLSGetEnableStatus', (('int', None),) ),
    'user32.winnlsgetimehotkey':( 'int', None, 'stdcall', 'user32.WINNLSGetIMEHotkey', (('int', None),) ),
    'user32.waitforinputidle':( 'int', None, 'stdcall', 'user32.WaitForInputIdle', (('int', None), ('int', None)) ),
    'user32.waitmessage':( 'int', None, 'cdecl', 'user32.WaitMessage', () ),
    'user32.win32poolallocationstats':( 'int', None, 'stdcall', 'user32.Win32PoolAllocationStats', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.winhelpa':( 'int', None, 'stdcall', 'user32.WinHelpA', (('int', None), ('void *', 'ptr'), ('int', None), ('void *', 'ptr')) ),
    'user32.winhelpw':( 'int', None, 'stdcall', 'user32.WinHelpW', (('int', None), ('void *', 'ptr'), ('int', None), ('void *', 'ptr')) ),
    'user32.windowfromdc':( 'int', None, 'stdcall', 'user32.WindowFromDC', (('int', None),) ),
    'user32.windowfrompoint':( 'int', None, 'stdcall', 'user32.WindowFromPoint', (('int', None), ('int', None)) ),
    'user32.keybd_event':( 'int', None, 'stdcall', 'user32.keybd_event', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.mouse_event':( 'int', None, 'stdcall', 'user32.mouse_event', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'user32.wsprintfa':( 'int', None, 'cdecl', 'user32.wsprintfA', (('int', None), ('int', None)) ),
    'user32.wsprintfw':( 'int', None, 'cdecl', 'user32.wsprintfW', (('void *', 'ptr'), ('int', None)) ),
    'user32.wvsprintfa':( 'int', None, 'stdcall', 'user32.wvsprintfA', (('int', None), ('int', None), ('int', None)) ),
    'user32.wvsprintfw':( 'int', None, 'stdcall', 'user32.wvsprintfW', (('int', None), ('int', None), ('int', None)) ),
    }
