# APIs for Windows 32-bit kernel32 library.
# Format:  rettype, retname, callconv, exactname, arglist(type, name)
#          arglist type is one of ['int', 'void *']
#          arglist name is one of [None, 'funcptr', 'obj', 'ptr']

api_defs = {
    'kernel32.main_entry':( 'int', None, 'stdcall', 'kernel32.main_entry', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.activateactctx':( 'int', None, 'stdcall', 'kernel32.ActivateActCtx', (('int', None), ('int', None)) ),
    'kernel32.addatoma':( 'int', None, 'stdcall', 'kernel32.AddAtomA', (('int', None),) ),
    'kernel32.addatomw':( 'int', None, 'stdcall', 'kernel32.AddAtomW', (('int', None),) ),
    'kernel32.addconsolealiasa':( 'int', None, 'stdcall', 'kernel32.AddConsoleAliasA', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.addconsolealiasw':( 'int', None, 'stdcall', 'kernel32.AddConsoleAliasW', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.addlocalalternatecomputernamea':( 'int', None, 'stdcall', 'kernel32.AddLocalAlternateComputerNameA', (('int', None), ('int', None)) ),
    'kernel32.addlocalalternatecomputernamew':( 'int', None, 'stdcall', 'kernel32.AddLocalAlternateComputerNameW', (('int', None), ('int', None)) ),
    'kernel32.addrefactctx':( 'int', None, 'stdcall', 'kernel32.AddRefActCtx', (('int', None)) ),
    'kernel32.allocconsole':( 'int', None, 'cdecl', 'kernel32.AllocConsole', () ),
    'kernel32.allocateuserphysicalpages':( 'int', None, 'stdcall', 'kernel32.AllocateUserPhysicalPages', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.arefileapisansi':( 'int', None, 'cdecl', 'kernel32.AreFileApisANSI', () ),
    'kernel32.assignprocesstojobobject':( 'int', None, 'stdcall', 'kernel32.AssignProcessToJobObject', (('int', None), ('int', None)) ),
    'kernel32.attachconsole':( 'int', None, 'stdcall', 'kernel32.AttachConsole', (('int', None),) ),
    'kernel32.backupread':( 'int', None, 'stdcall', 'kernel32.BackupRead', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.backupseek':( 'int', None, 'stdcall', 'kernel32.BackupSeek', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.backupwrite':( 'int', None, 'stdcall', 'kernel32.BackupWrite', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.basecheckappcompatcache':( 'int', None, 'stdcall', 'kernel32.BaseCheckAppcompatCache', (('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'kernel32.basecleanupappcompatcache':( 'int', None, 'cdecl', 'kernel32.BaseCleanupAppcompatCache', () ),
    'kernel32.basecleanupappcompatcachesupport':( 'int', None, 'stdcall', 'kernel32.BaseCleanupAppcompatCacheSupport', (('int', None),) ),
    'kernel32.basedumpappcompatcache':( 'int', None, 'cdecl', 'kernel32.BaseDumpAppcompatCache', () ),
    'kernel32.baseflushappcompatcache':( 'int', None, 'cdecl', 'kernel32.BaseFlushAppcompatCache', () ),
    'kernel32.baseinitappcompatcache':( 'int', None, 'cdecl', 'kernel32.BaseInitAppcompatCache', () ),
    'kernel32.baseinitappcompatcachesupport':( 'int', None, 'cdecl', 'kernel32.BaseInitAppcompatCacheSupport', () ),
    'kernel32.baseprocessinitpostimport':( 'int', None, 'cdecl', 'kernel32.BaseProcessInitPostImport', () ),
    'kernel32.basequerymoduledata':( 'int', None, 'stdcall', 'kernel32.BaseQueryModuleData', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.baseupdateappcompatcache':( 'int', None, 'stdcall', 'kernel32.BaseUpdateAppcompatCache', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.basepcheckwinsaferrestrictions':( 'int', None, 'stdcall', 'kernel32.BasepCheckWinSaferRestrictions', (('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'kernel32.beep':( 'int', None, 'stdcall', 'kernel32.Beep', (('int', None), ('int', None)) ),
    'kernel32.beginupdateresourcea':( 'int', None, 'stdcall', 'kernel32.BeginUpdateResourceA', ( ('int', None), ('int', None)) ),
    'kernel32.beginupdateresourcew':( 'int', None, 'stdcall', 'kernel32.BeginUpdateResourceW', ( ('void *', 'ptr'), ('int', None)) ),
    'kernel32.bindiocompletioncallback':( 'int', None, 'stdcall', 'kernel32.BindIoCompletionCallback', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.buildcommdcba':( 'int', None, 'stdcall', 'kernel32.BuildCommDCBA', (('void *', 'ptr'), ('void *', 'ptr')) ),
    'kernel32.buildcommdcbandtimeoutsa':( 'int', None, 'stdcall', 'kernel32.BuildCommDCBAndTimeoutsA', (('int', None), ('int', None), ('void *', 'ptr')) ),
    'kernel32.buildcommdcbandtimeoutsw':( 'int', None, 'stdcall', 'kernel32.BuildCommDCBAndTimeoutsW', (('int', None), ('int', None), ('void *', 'ptr')) ),
    'kernel32.buildcommdcbw':( 'int', None, 'stdcall', 'kernel32.BuildCommDCBW', (('int', None), ('int', None)) ),
    'kernel32.callnamedpipea':( 'int', None, 'stdcall', 'kernel32.CallNamedPipeA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.callnamedpipew':( 'int', None, 'stdcall', 'kernel32.CallNamedPipeW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.canceldevicewakeuprequest':( 'int', None, 'stdcall', 'kernel32.CancelDeviceWakeupRequest', (('int', None),) ),
    'kernel32.cancelio':( 'int', None, 'stdcall', 'kernel32.CancelIo', (('int', None),) ),
    'kernel32.canceltimerqueuetimer':( 'int', None, 'stdcall', 'kernel32.CancelTimerQueueTimer', (('int', None), ('int', None)) ),
    'kernel32.cancelwaitabletimer':( 'int', None, 'stdcall', 'kernel32.CancelWaitableTimer', (('int', None),) ),
    'kernel32.changetimerqueuetimer':( 'int', None, 'stdcall', 'kernel32.ChangeTimerQueueTimer', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.checknamelegaldos8dot3a':( 'int', None, 'stdcall', 'kernel32.CheckNameLegalDOS8Dot3A', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.checknamelegaldos8dot3w':( 'int', None, 'stdcall', 'kernel32.CheckNameLegalDOS8Dot3W', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.checkremotedebuggerpresent':( 'int', None, 'stdcall', 'kernel32.CheckRemoteDebuggerPresent', (('int', None), ('int', None)) ),
    'kernel32.clearcommbreak':( 'int', None, 'stdcall', 'kernel32.ClearCommBreak', (('int', None),) ),
    'kernel32.clearcommerror':( 'int', None, 'stdcall', 'kernel32.ClearCommError', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.closeconsolehandle':( 'int', None, 'stdcall', 'kernel32.CloseConsoleHandle', (('int', None),) ),
    'kernel32.closehandle':( 'int', None, 'stdcall', 'kernel32.CloseHandle', (('int', None),) ),
    'kernel32.closeprofileusermapping':( 'int', None, 'cdecl', 'kernel32.CloseProfileUserMapping', () ),
    'kernel32.cmdbatnotification':( 'int', None, 'stdcall', 'kernel32.CmdBatNotification', (('int', None),) ),
    'kernel32.commconfigdialoga':( 'int', None, 'stdcall', 'kernel32.CommConfigDialogA', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.commconfigdialogw':( 'int', None, 'stdcall', 'kernel32.CommConfigDialogW', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.comparefiletime':( 'int', None, 'stdcall', 'kernel32.CompareFileTime', (('int', None), ('int', None)) ),
    'kernel32.comparestringa':( 'int', None, 'stdcall', 'kernel32.CompareStringA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.comparestringw':( 'int', None, 'stdcall', 'kernel32.CompareStringW', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'kernel32.connectnamedpipe':( 'int', None, 'stdcall', 'kernel32.ConnectNamedPipe', (('int', None), ('int', None)) ),
    'kernel32.consolemenucontrol':( 'int', None, 'stdcall', 'kernel32.ConsoleMenuControl', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.continuedebugevent':( 'int', None, 'stdcall', 'kernel32.ContinueDebugEvent', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.convertdefaultlocale':( 'int', None, 'stdcall', 'kernel32.ConvertDefaultLocale', (('int', None),) ),
    'kernel32.convertfibertothread':( 'int', None, 'cdecl', 'kernel32.ConvertFiberToThread', () ),
    'kernel32.convertthreadtofiber':( 'int', None, 'stdcall', 'kernel32.ConvertThreadToFiber', (('int', None),) ),
    'kernel32.copyfilea':( 'int', None, 'stdcall', 'kernel32.CopyFileA', ( ('int', None), ('int', None), ('int', None)) ),
    'kernel32.copyfileexa':( 'int', None, 'stdcall', 'kernel32.CopyFileExA', ( ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.copyfileexw':( 'int', None, 'stdcall', 'kernel32.CopyFileExW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.copyfilew':( 'int', None, 'stdcall', 'kernel32.CopyFileW', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.copylzfile':( 'int', None, 'stdcall', 'kernel32.CopyLZFile', (('int', None), ('int', None)) ),
    'kernel32.createactctxa':( 'int', None, 'stdcall', 'kernel32.CreateActCtxA', (('int', None),) ),
    'kernel32.createactctxw':( 'int', None, 'stdcall', 'kernel32.CreateActCtxW', (('void *', 'ptr'),) ),
    'kernel32.createconsolescreenbuffer':( 'int', None, 'stdcall', 'kernel32.CreateConsoleScreenBuffer', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.createdirectorya':( 'int', None, 'stdcall', 'kernel32.CreateDirectoryA', (('int', None), ('int', None)) ),
    'kernel32.createdirectoryexa':( 'int', None, 'stdcall', 'kernel32.CreateDirectoryExA', ( ('int', None), ('int', None), ('int', None)) ),
    'kernel32.createdirectoryexw':( 'int', None, 'stdcall', 'kernel32.CreateDirectoryExW', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.createdirectoryw':( 'int', None, 'stdcall', 'kernel32.CreateDirectoryW', (('int', None), ('int', None)) ),
    'kernel32.createeventa':( 'int', None, 'stdcall', 'kernel32.CreateEventA', (('void *', 'ptr'), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.createeventw':( 'int', None, 'stdcall', 'kernel32.CreateEventW', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.createfiber':( 'int', None, 'stdcall', 'kernel32.CreateFiber', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.createfiberex':( 'int', None, 'stdcall', 'kernel32.CreateFiberEx', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.createfilea':( 'int', None, 'stdcall', 'kernel32.CreateFileA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.createfilemappinga':( 'int', None, 'stdcall', 'kernel32.CreateFileMappingA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.createfilemappingw':( 'int', None, 'stdcall', 'kernel32.CreateFileMappingW', (('int', None), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.createfilew':( 'int', None, 'stdcall', 'kernel32.CreateFileW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.createhardlinka':( 'int', None, 'stdcall', 'kernel32.CreateHardLinkA', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.createhardlinkw':( 'int', None, 'stdcall', 'kernel32.CreateHardLinkW', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.createiocompletionport':( 'int', None, 'stdcall', 'kernel32.CreateIoCompletionPort', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.createjobobjecta':( 'int', None, 'stdcall', 'kernel32.CreateJobObjectA', (('int', None), ('int', None)) ),
    'kernel32.createjobobjectw':( 'int', None, 'stdcall', 'kernel32.CreateJobObjectW', (('int', None), ('int', None)) ),
    'kernel32.createjobset':( 'int', None, 'stdcall', 'kernel32.CreateJobSet', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.createmailslota':( 'int', None, 'stdcall', 'kernel32.CreateMailslotA', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.createmailslotw':( 'int', None, 'stdcall', 'kernel32.CreateMailslotW', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.creatememoryresourcenotification':( 'int', None, 'stdcall', 'kernel32.CreateMemoryResourceNotification', (('int', None),) ),
    'kernel32.createmutexa':( 'int', None, 'stdcall', 'kernel32.CreateMutexA', (('void *', 'ptr'), ('int', None), ('int', None)) ),
    'kernel32.createmutexw':( 'int', None, 'stdcall', 'kernel32.CreateMutexW', (('void *', 'ptr'), ('int', None), ('int', None)) ),
    'kernel32.createnamedpipea':( 'int', None, 'stdcall', 'kernel32.CreateNamedPipeA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.createnamedpipew':( 'int', None, 'stdcall', 'kernel32.CreateNamedPipeW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.createnlssecuritydescriptor':( 'int', None, 'stdcall', 'kernel32.CreateNlsSecurityDescriptor', (('void *', 'ptr'), ('int', None), ('int', None)) ),
    'kernel32.createpipe':( 'int', None, 'stdcall', 'kernel32.CreatePipe', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.createprocessa':( 'int', None, 'stdcall', 'kernel32.CreateProcessA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'kernel32.createprocessinternala':( 'int', None, 'stdcall', 'kernel32.CreateProcessInternalA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('void *', 'ptr'), ('int', None)) ),
    'kernel32.createprocessinternalw':( 'int', None, 'stdcall', 'kernel32.CreateProcessInternalW', (('int', None), ('int', None), ('void *', 'obj'), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'kernel32.createprocessinternalwsecure':( 'int', None, 'cdecl', 'kernel32.CreateProcessInternalWSecure', () ),
    'kernel32.createprocessw':( 'int', None, 'stdcall', 'kernel32.CreateProcessW', (('int', None), ('void *', 'obj'), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'kernel32.createremotethread':( 'int', None, 'stdcall', 'kernel32.CreateRemoteThread', (('int', None), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.createsemaphorea':( 'int', None, 'stdcall', 'kernel32.CreateSemaphoreA', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.createsemaphorew':( 'int', None, 'stdcall', 'kernel32.CreateSemaphoreW', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.createsockethandle':( 'int', None, 'cdecl', 'kernel32.CreateSocketHandle', () ),
    'kernel32.createtapepartition':( 'int', None, 'stdcall', 'kernel32.CreateTapePartition', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.createthread':( 'int', None, 'stdcall', 'kernel32.CreateThread', (('void *', 'ptr'), ('int', None), ('void *', 'funcptr'), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.createtimerqueue':( 'int', None, 'stdcall', 'kernel32.CreateTimerQueue', () ),
    'kernel32.createtimerqueuetimer':( 'int', None, 'stdcall', 'kernel32.CreateTimerQueueTimer', ( ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.createtoolhelp32snapshot':( 'int', None, 'stdcall', 'kernel32.CreateToolhelp32Snapshot', (('int', None), ('int', None)) ),
    'kernel32.createvirtualbuffer':( 'int', None, 'stdcall', 'kernel32.CreateVirtualBuffer', (('void *', 'ptr'), ('int', None), ('int', None)) ),
    'kernel32.createwaitabletimera':( 'int', None, 'stdcall', 'kernel32.CreateWaitableTimerA', (('void *', 'ptr'), ('int', None), ('int', None)) ),
    'kernel32.createwaitabletimerw':( 'int', None, 'stdcall', 'kernel32.CreateWaitableTimerW', (('void *', 'ptr'), ('int', None), ('int', None)) ),
    'kernel32.deactivateactctx':( 'int', None, 'stdcall', 'kernel32.DeactivateActCtx', (('int', None), ('int', None)) ),
    'kernel32.debugactiveprocess':( 'int', None, 'stdcall', 'kernel32.DebugActiveProcess', (('int', None),) ),
    'kernel32.debugactiveprocessstop':( 'int', None, 'stdcall', 'kernel32.DebugActiveProcessStop', (('int', None),) ),
    'kernel32.debugbreak':( 'int', None, 'cdecl', 'kernel32.DebugBreak', () ),
    'kernel32.debugbreakprocess':( 'int', None, 'stdcall', 'kernel32.DebugBreakProcess', (('int', None),) ),
    'kernel32.debugsetprocesskillonexit':( 'int', None, 'stdcall', 'kernel32.DebugSetProcessKillOnExit', (('int', None),) ),
    'kernel32.definedosdevicea':( 'int', None, 'stdcall', 'kernel32.DefineDosDeviceA', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.definedosdevicew':( 'int', None, 'stdcall', 'kernel32.DefineDosDeviceW', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.delayloadfailurehook':( 'int', None, 'stdcall', 'kernel32.DelayLoadFailureHook', (('int', None), ('int', None)) ),
    'kernel32.deleteatom':( 'int', None, 'stdcall', 'kernel32.DeleteAtom', (('int', None),) ),
    'kernel32.deletefiber':( 'int', None, 'stdcall', 'kernel32.DeleteFiber', (('DWORD', None),) ),
    'kernel32.deletefilea':( 'int', None, 'stdcall', 'kernel32.DeleteFileA', (('int', None),) ),
    'kernel32.deletefilew':( 'int', None, 'stdcall', 'kernel32.DeleteFileW', (('void *', 'ptr'),) ),
    'kernel32.deletetimerqueue':( 'int', None, 'stdcall', 'kernel32.DeleteTimerQueue', (('int', None),) ),
    'kernel32.deletetimerqueueex':( 'int', None, 'stdcall', 'kernel32.DeleteTimerQueueEx', (('int', None), ('int', None)) ),
    'kernel32.deletetimerqueuetimer':( 'int', None, 'stdcall', 'kernel32.DeleteTimerQueueTimer', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.deletevolumemountpointa':( 'int', None, 'stdcall', 'kernel32.DeleteVolumeMountPointA', (('int', None),) ),
    'kernel32.deletevolumemountpointw':( 'int', None, 'stdcall', 'kernel32.DeleteVolumeMountPointW', (('int', None),) ),
    'kernel32.deviceiocontrol':( 'int', None, 'stdcall', 'kernel32.DeviceIoControl', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'kernel32.disablethreadlibrarycalls':( 'int', None, 'stdcall', 'kernel32.DisableThreadLibraryCalls', (('int', None),) ),
    'kernel32.disconnectnamedpipe':( 'int', None, 'stdcall', 'kernel32.DisconnectNamedPipe', (('int', None),) ),
    'kernel32.dnshostnametocomputernamea':( 'int', None, 'stdcall', 'kernel32.DnsHostnameToComputerNameA', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.dnshostnametocomputernamew':( 'int', None, 'stdcall', 'kernel32.DnsHostnameToComputerNameW', (('int', None), ('int', None), ('void *', 'ptr')) ),
    'kernel32.dosdatetimetofiletime':( 'int', None, 'stdcall', 'kernel32.DosDateTimeToFileTime', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.dospathtosessionpatha':( 'int', None, 'stdcall', 'kernel32.DosPathToSessionPathA', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.dospathtosessionpathw':( 'int', None, 'stdcall', 'kernel32.DosPathToSessionPathW', (('int', None), ('int', None), ('void *', 'ptr')) ),
    'kernel32.duplicateconsolehandle':( 'int', None, 'stdcall', 'kernel32.DuplicateConsoleHandle', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.duplicatehandle':( 'int', None, 'stdcall', 'kernel32.DuplicateHandle', (('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.endupdateresourcea':( 'int', None, 'stdcall', 'kernel32.EndUpdateResourceA', (('void *', 'ptr'), ('int', None)) ),
    'kernel32.endupdateresourcew':( 'int', None, 'stdcall', 'kernel32.EndUpdateResourceW', (('void *', 'ptr'), ('int', None)) ),
    'kernel32.enumcalendarinfoa':( 'int', None, 'stdcall', 'kernel32.EnumCalendarInfoA', (('void *', 'funcptr'), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.enumcalendarinfoexa':( 'int', None, 'stdcall', 'kernel32.EnumCalendarInfoExA', (('void *', 'funcptr'), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.enumcalendarinfoexw':( 'int', None, 'stdcall', 'kernel32.EnumCalendarInfoExW', (('void *', 'funcptr'), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.enumcalendarinfow':( 'int', None, 'stdcall', 'kernel32.EnumCalendarInfoW', (('void *', 'funcptr'), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.enumdateformatsa':( 'int', None, 'stdcall', 'kernel32.EnumDateFormatsA', (('void *', 'funcptr'), ('int', None), ('int', None)) ),
    'kernel32.enumdateformatsexa':( 'int', None, 'stdcall', 'kernel32.EnumDateFormatsExA', (('void *', 'funcptr'), ('int', None), ('int', None)) ),
    'kernel32.enumdateformatsexw':( 'int', None, 'stdcall', 'kernel32.EnumDateFormatsExW', (('void *', 'funcptr'), ('int', None), ('int', None)) ),
    'kernel32.enumdateformatsw':( 'int', None, 'stdcall', 'kernel32.EnumDateFormatsW', (('void *', 'funcptr'), ('int', None), ('int', None)) ),
    'kernel32.enumlanguagegrouplocalesa':( 'int', None, 'stdcall', 'kernel32.EnumLanguageGroupLocalesA', (('void *', 'funcptr'), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.enumlanguagegrouplocalesw':( 'int', None, 'stdcall', 'kernel32.EnumLanguageGroupLocalesW', (('void *', 'funcptr'), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.enumresourcelanguagesa':( 'int', None, 'stdcall', 'kernel32.EnumResourceLanguagesA', (('int', None), ('int', None), ('int', None), ('void *', 'funcptr'), ('int', None)) ),
    'kernel32.enumresourcelanguagesw':( 'int', None, 'stdcall', 'kernel32.EnumResourceLanguagesW', (('int', None), ('int', None), ('int', None), ('void *', 'funcptr'), ('int', None)) ),
    'kernel32.enumresourcenamesa':( 'int', None, 'stdcall', 'kernel32.EnumResourceNamesA', (('int', None), ('int', None), ('void *', 'funcptr'), ('int', None)) ),
    'kernel32.enumresourcenamesw':( 'int', None, 'stdcall', 'kernel32.EnumResourceNamesW', (('int', None), ('int', None), ('void *', 'funcptr'), ('void *', 'ptr')) ),
    'kernel32.enumresourcetypesa':( 'int', None, 'stdcall', 'kernel32.EnumResourceTypesA', (('int', None), ('void *', 'funcptr'), ('int', None)) ),
    'kernel32.enumresourcetypesw':( 'int', None, 'stdcall', 'kernel32.EnumResourceTypesW', (('int', None), ('void *', 'funcptr'), ('int', None)) ),
    'kernel32.enumsystemcodepagesa':( 'int', None, 'stdcall', 'kernel32.EnumSystemCodePagesA', (('void *', 'funcptr'), ('int', None)) ),
    'kernel32.enumsystemcodepagesw':( 'int', None, 'stdcall', 'kernel32.EnumSystemCodePagesW', (('void *', 'funcptr'), ('int', None)) ),
    'kernel32.enumsystemgeoid':( 'int', None, 'stdcall', 'kernel32.EnumSystemGeoID', ( ('int', None), ('int', None), ('void *', 'funcptr')) ),
    'kernel32.enumsystemlanguagegroupsa':( 'int', None, 'stdcall', 'kernel32.EnumSystemLanguageGroupsA', (('void *', 'funcptr'), ('int', None), ('int', None)) ),
    'kernel32.enumsystemlanguagegroupsw':( 'int', None, 'stdcall', 'kernel32.EnumSystemLanguageGroupsW', (('void *', 'funcptr'), ('int', None), ('int', None)) ),
    'kernel32.enumsystemlocalesa':( 'int', None, 'stdcall', 'kernel32.EnumSystemLocalesA', (('void *', 'funcptr'), ('int', None)) ),
    'kernel32.enumsystemlocalesw':( 'int', None, 'stdcall', 'kernel32.EnumSystemLocalesW', (('void *', 'funcptr'), ('int', None)) ),
    'kernel32.enumtimeformatsa':( 'int', None, 'stdcall', 'kernel32.EnumTimeFormatsA', (('void *', 'funcptr'), ('int', None), ('int', None)) ),
    'kernel32.enumtimeformatsw':( 'int', None, 'stdcall', 'kernel32.EnumTimeFormatsW', (('void *', 'funcptr'), ('int', None), ('int', None)) ),
    'kernel32.enumuilanguagesa':( 'int', None, 'stdcall', 'kernel32.EnumUILanguagesA', (('void *', 'funcptr'), ('int', None), ('int', None)) ),
    'kernel32.enumuilanguagesw':( 'int', None, 'stdcall', 'kernel32.EnumUILanguagesW', (('void *', 'funcptr'), ('int', None), ('int', None)) ),
    'kernel32.enumeratelocalcomputernamesa':( 'int', None, 'stdcall', 'kernel32.EnumerateLocalComputerNamesA', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.enumeratelocalcomputernamesw':( 'int', None, 'stdcall', 'kernel32.EnumerateLocalComputerNamesW', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.erasetape':( 'int', None, 'stdcall', 'kernel32.EraseTape', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.escapecommfunction':( 'int', None, 'stdcall', 'kernel32.EscapeCommFunction', (('int', None), ('int', None)) ),
    'kernel32.exitprocess':( 'int', None, 'cdecl', 'kernel32.ExitProcess', (('int', None),) ),
    'kernel32.exitthread':( 'int', None, 'cdecl', 'kernel32.ExitThread', (('int', None),) ),
    'kernel32.exitvdm':( 'int', None, 'stdcall', 'kernel32.ExitVDM', (('int', None), ('int', None)) ),
    'kernel32.expandenvironmentstringsa':( 'int', None, 'stdcall', 'kernel32.ExpandEnvironmentStringsA', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.expandenvironmentstringsw':( 'int', None, 'stdcall', 'kernel32.ExpandEnvironmentStringsW', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.expungeconsolecommandhistorya':( 'int', None, 'stdcall', 'kernel32.ExpungeConsoleCommandHistoryA', (('int', None),) ),
    'kernel32.expungeconsolecommandhistoryw':( 'int', None, 'stdcall', 'kernel32.ExpungeConsoleCommandHistoryW', (('int', None),) ),
    'kernel32.extendvirtualbuffer':( 'int', None, 'stdcall', 'kernel32.ExtendVirtualBuffer', (('int', None), ('int', None)) ),
    'kernel32.fatalappexita':( 'int', None, 'stdcall', 'kernel32.FatalAppExitA', (('int', None), ('int', None)) ),
    'kernel32.fatalappexitw':( 'int', None, 'stdcall', 'kernel32.FatalAppExitW', (('int', None), ('int', None)) ),
    'kernel32.fatalexit':( 'int', None, 'cdecl', 'kernel32.FatalExit', (('int', None),) ),
    'kernel32.filetimetodosdatetime':( 'int', None, 'stdcall', 'kernel32.FileTimeToDosDateTime', (('void *', 'ptr'), ('int', None), ('int', None)) ),
    'kernel32.filetimetolocalfiletime':( 'int', None, 'stdcall', 'kernel32.FileTimeToLocalFileTime', (('void *', 'ptr'), ('int', None)) ),
    'kernel32.filetimetosystemtime':( 'int', None, 'stdcall', 'kernel32.FileTimeToSystemTime', (('void *', 'ptr'), ('int', None)) ),
    'kernel32.fillconsoleoutputattribute':( 'int', None, 'stdcall', 'kernel32.FillConsoleOutputAttribute', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.fillconsoleoutputcharactera':( 'int', None, 'stdcall', 'kernel32.FillConsoleOutputCharacterA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.fillconsoleoutputcharacterw':( 'int', None, 'stdcall', 'kernel32.FillConsoleOutputCharacterW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.findactctxsectionguid':( 'int', None, 'stdcall', 'kernel32.FindActCtxSectionGuid', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.findactctxsectionstringa':( 'int', None, 'stdcall', 'kernel32.FindActCtxSectionStringA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.findactctxsectionstringw':( 'int', None, 'stdcall', 'kernel32.FindActCtxSectionStringW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.findatoma':( 'int', None, 'stdcall', 'kernel32.FindAtomA', (('int', None),) ),
    'kernel32.findatomw':( 'int', None, 'stdcall', 'kernel32.FindAtomW', (('int', None),) ),
    'kernel32.findclose':( 'int', None, 'stdcall', 'kernel32.FindClose', (('void *', 'ptr'),) ),
    'kernel32.findclosechangenotification':( 'int', None, 'stdcall', 'kernel32.FindCloseChangeNotification', (('int', None),) ),
    'kernel32.findfirstchangenotificationa':( 'int', None, 'stdcall', 'kernel32.FindFirstChangeNotificationA', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.findfirstchangenotificationw':( 'int', None, 'stdcall', 'kernel32.FindFirstChangeNotificationW', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.findfirstfilea':( 'int', None, 'stdcall', 'kernel32.FindFirstFileA', (('int', None), ('int', None)) ),
    'kernel32.findfirstfileexa':( 'int', None, 'stdcall', 'kernel32.FindFirstFileExA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.findfirstfileexw':( 'int', None, 'stdcall', 'kernel32.FindFirstFileExW', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.findfirstfilew':( 'int', None, 'stdcall', 'kernel32.FindFirstFileW', (('int', None), ('void *', 'ptr')) ),
    'kernel32.findfirstvolumea':( 'int', None, 'stdcall', 'kernel32.FindFirstVolumeA', (('int', None), ('int', None)) ),
    'kernel32.findfirstvolumemountpointa':( 'int', None, 'stdcall', 'kernel32.FindFirstVolumeMountPointA', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.findfirstvolumemountpointw':( 'int', None, 'stdcall', 'kernel32.FindFirstVolumeMountPointW', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.findfirstvolumew':( 'int', None, 'stdcall', 'kernel32.FindFirstVolumeW', (('int', None), ('int', None)) ),
    'kernel32.findnextchangenotification':( 'int', None, 'stdcall', 'kernel32.FindNextChangeNotification', (('int', None),) ),
    'kernel32.findnextfilea':( 'int', None, 'stdcall', 'kernel32.FindNextFileA', (('int', None), ('int', None)) ),
    'kernel32.findnextfilew':( 'int', None, 'stdcall', 'kernel32.FindNextFileW', (('int', None), ('void *', 'ptr')) ),
    'kernel32.findnextvolumea':( 'int', None, 'stdcall', 'kernel32.FindNextVolumeA', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.findnextvolumemountpointa':( 'int', None, 'stdcall', 'kernel32.FindNextVolumeMountPointA', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.findnextvolumemountpointw':( 'int', None, 'stdcall', 'kernel32.FindNextVolumeMountPointW', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.findnextvolumew':( 'int', None, 'stdcall', 'kernel32.FindNextVolumeW', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.findresourcea':( 'int', None, 'stdcall', 'kernel32.FindResourceA', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.findresourceexa':( 'int', None, 'stdcall', 'kernel32.FindResourceExA', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.findresourceexw':( 'int', None, 'stdcall', 'kernel32.FindResourceExW', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.findresourcew':( 'int', None, 'stdcall', 'kernel32.FindResourceW', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.findvolumeclose':( 'int', None, 'stdcall', 'kernel32.FindVolumeClose', (('void *', 'ptr'),) ),
    'kernel32.findvolumemountpointclose':( 'int', None, 'stdcall', 'kernel32.FindVolumeMountPointClose', (('int', None),) ),
    'kernel32.flushconsoleinputbuffer':( 'int', None, 'stdcall', 'kernel32.FlushConsoleInputBuffer', (('int', None),) ),
    'kernel32.flushfilebuffers':( 'int', None, 'stdcall', 'kernel32.FlushFileBuffers', (('int', None),) ),
    'kernel32.flushinstructioncache':( 'int', None, 'stdcall', 'kernel32.FlushInstructionCache', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.flushviewoffile':( 'int', None, 'stdcall', 'kernel32.FlushViewOfFile', (('int', None), ('int', None)) ),
    'kernel32.foldstringa':( 'int', None, 'stdcall', 'kernel32.FoldStringA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.foldstringw':( 'int', None, 'stdcall', 'kernel32.FoldStringW', (('int', None), ('void *', 'obj'), ('int', None), ('void *', 'obj'), ('int', None)) ),
    'kernel32.formatmessagea':( 'int', None, 'stdcall', 'kernel32.FormatMessageA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.formatmessagew':( 'int', None, 'stdcall', 'kernel32.FormatMessageW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.freeconsole':( 'int', None, 'cdecl', 'kernel32.FreeConsole', () ),
    'kernel32.freeenvironmentstringsa':( 'int', None, 'stdcall', 'kernel32.FreeEnvironmentStringsA', (('void *', 'ptr'),) ),
    'kernel32.freeenvironmentstringsw':( 'int', None, 'stdcall', 'kernel32.FreeEnvironmentStringsW', (('int', None),) ),
    'kernel32.freelibrary':( 'int', None, 'stdcall', 'kernel32.FreeLibrary', (('int', None),) ),
    'kernel32.freelibraryandexitthread':( 'int', None, 'stdcall', 'kernel32.FreeLibraryAndExitThread', (('int', None), ('int', None)) ),
    'kernel32.freeresource':( 'int', None, 'stdcall', 'kernel32.FreeResource', (('int', None),) ),
    'kernel32.freeuserphysicalpages':( 'int', None, 'stdcall', 'kernel32.FreeUserPhysicalPages', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.freevirtualbuffer':( 'int', None, 'stdcall', 'kernel32.FreeVirtualBuffer', (('void *', 'ptr'),) ),
    'kernel32.generateconsolectrlevent':( 'int', None, 'stdcall', 'kernel32.GenerateConsoleCtrlEvent', (('int', None), ('int', None)) ),
    'kernel32.getacp':( 'int', None, 'cdecl', 'kernel32.GetACP', () ),
    'kernel32.getatomnamea':( 'int', None, 'stdcall', 'kernel32.GetAtomNameA', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.getatomnamew':( 'int', None, 'stdcall', 'kernel32.GetAtomNameW', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.getbinarytype':( 'int', None, 'stdcall', 'kernel32.GetBinaryType', (('int', None), ('int', None)) ),
    'kernel32.getbinarytypea':( 'int', None, 'stdcall', 'kernel32.GetBinaryTypeA', (('int', None), ('int', None)) ),
    'kernel32.getbinarytypew':( 'int', None, 'stdcall', 'kernel32.GetBinaryTypeW', (('int', None), ('int', None)) ),
    'kernel32.getcpfilenamefromregistry':( 'int', None, 'stdcall', 'kernel32.GetCPFileNameFromRegistry', (('int', None), ('void *', 'ptr'), ('int', None)) ),
    'kernel32.getcpinfo':( 'int', None, 'stdcall', 'kernel32.GetCPInfo', (('int', None), ('void *', 'ptr')) ),
    'kernel32.getcpinfoexa':( 'int', None, 'stdcall', 'kernel32.GetCPInfoExA', (('int', None), ('int', None), ('void *', 'ptr')) ),
    'kernel32.getcpinfoexw':( 'int', None, 'stdcall', 'kernel32.GetCPInfoExW', (('int', None), ('int', None), ('void *', 'ptr')) ),
    'kernel32.getcalendarinfoa':( 'int', None, 'stdcall', 'kernel32.GetCalendarInfoA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.getcalendarinfow':( 'int', None, 'stdcall', 'kernel32.GetCalendarInfoW', (('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'kernel32.getcompluspackageinstallstatus':( 'int', None, 'cdecl', 'kernel32.GetComPlusPackageInstallStatus', () ),
    'kernel32.getcommconfig':( 'int', None, 'stdcall', 'kernel32.GetCommConfig', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.getcommmask':( 'int', None, 'stdcall', 'kernel32.GetCommMask', (('int', None), ('int', None)) ),
    'kernel32.getcommmodemstatus':( 'int', None, 'stdcall', 'kernel32.GetCommModemStatus', (('int', None), ('int', None)) ),
    'kernel32.getcommproperties':( 'int', None, 'stdcall', 'kernel32.GetCommProperties', (('int', None), ('int', None)) ),
    'kernel32.getcommstate':( 'int', None, 'stdcall', 'kernel32.GetCommState', (('int', None), ('void *', 'ptr')) ),
    'kernel32.getcommtimeouts':( 'int', None, 'stdcall', 'kernel32.GetCommTimeouts', (('int', None), ('int', None)) ),
    'kernel32.getcommandlinea':( 'int', None, 'cdecl', 'kernel32.GetCommandLineA', () ),
    'kernel32.getcommandlinew':( 'int', None, 'cdecl', 'kernel32.GetCommandLineW', () ),
    'kernel32.getcompressedfilesizea':( 'int', None, 'stdcall', 'kernel32.GetCompressedFileSizeA', (('int', None), ('void *', 'ptr')) ),
    'kernel32.getcompressedfilesizew':( 'int', None, 'stdcall', 'kernel32.GetCompressedFileSizeW', (('int', None), ('void *', 'ptr')) ),
    'kernel32.getcomputernamea':( 'int', None, 'stdcall', 'kernel32.GetComputerNameA', (('int', None), ('int', None)) ),
    'kernel32.getcomputernameexa':( 'int', None, 'stdcall', 'kernel32.GetComputerNameExA', (('int', None), ('int', None), ('void *', 'ptr')) ),
    'kernel32.getcomputernameexw':( 'int', None, 'stdcall', 'kernel32.GetComputerNameExW', (('int', None), ('int', None), ('void *', 'ptr')) ),
    'kernel32.getcomputernamew':( 'int', None, 'stdcall', 'kernel32.GetComputerNameW', (('int', None), ('void *', 'ptr')) ),
    'kernel32.getconsolealiasa':( 'int', None, 'stdcall', 'kernel32.GetConsoleAliasA', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.getconsolealiasexesa':( 'int', None, 'stdcall', 'kernel32.GetConsoleAliasExesA', (('int', None), ('int', None)) ),
    'kernel32.getconsolealiasexeslengtha':( 'int', None, 'cdecl', 'kernel32.GetConsoleAliasExesLengthA', () ),
    'kernel32.getconsolealiasexeslengthw':( 'int', None, 'cdecl', 'kernel32.GetConsoleAliasExesLengthW', () ),
    'kernel32.getconsolealiasexesw':( 'int', None, 'stdcall', 'kernel32.GetConsoleAliasExesW', (('int', None), ('int', None)) ),
    'kernel32.getconsolealiasw':( 'int', None, 'stdcall', 'kernel32.GetConsoleAliasW', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.getconsolealiasesa':( 'int', None, 'stdcall', 'kernel32.GetConsoleAliasesA', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.getconsolealiaseslengtha':( 'int', None, 'stdcall', 'kernel32.GetConsoleAliasesLengthA', (('int', None),) ),
    'kernel32.getconsolealiaseslengthw':( 'int', None, 'stdcall', 'kernel32.GetConsoleAliasesLengthW', (('int', None),) ),
    'kernel32.getconsolealiasesw':( 'int', None, 'stdcall', 'kernel32.GetConsoleAliasesW', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.getconsolecp':( 'int', None, 'cdecl', 'kernel32.GetConsoleCP', () ),
    'kernel32.getconsolechartype':( 'int', None, 'stdcall', 'kernel32.GetConsoleCharType', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.getconsolecommandhistorya':( 'int', None, 'stdcall', 'kernel32.GetConsoleCommandHistoryA', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.getconsolecommandhistorylengtha':( 'int', None, 'stdcall', 'kernel32.GetConsoleCommandHistoryLengthA', (('int', None),) ),
    'kernel32.getconsolecommandhistorylengthw':( 'int', None, 'stdcall', 'kernel32.GetConsoleCommandHistoryLengthW', (('int', None),) ),
    'kernel32.getconsolecommandhistoryw':( 'int', None, 'stdcall', 'kernel32.GetConsoleCommandHistoryW', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.getconsolecursorinfo':( 'int', None, 'stdcall', 'kernel32.GetConsoleCursorInfo', (('int', None), ('int', None)) ),
    'kernel32.getconsolecursormode':( 'int', None, 'stdcall', 'kernel32.GetConsoleCursorMode', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.getconsoledisplaymode':( 'int', None, 'stdcall', 'kernel32.GetConsoleDisplayMode', (('void *', 'ptr'),) ),
    'kernel32.getconsolefontinfo':( 'int', None, 'stdcall', 'kernel32.GetConsoleFontInfo', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.getconsolefontsize':( 'int', None, 'stdcall', 'kernel32.GetConsoleFontSize', (('int', None), ('int', None)) ),
    'kernel32.getconsolehardwarestate':( 'int', None, 'stdcall', 'kernel32.GetConsoleHardwareState', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.getconsoleinputexenamea':( 'int', None, 'stdcall', 'kernel32.GetConsoleInputExeNameA', (('int', None), ('int', None)) ),
    'kernel32.getconsoleinputexenamew':( 'int', None, 'stdcall', 'kernel32.GetConsoleInputExeNameW', (('int', None), ('void *', 'ptr')) ),
    'kernel32.getconsoleinputwaithandle':( 'int', None, 'cdecl', 'kernel32.GetConsoleInputWaitHandle', () ),
    'kernel32.getconsolekeyboardlayoutnamea':( 'int', None, 'stdcall', 'kernel32.GetConsoleKeyboardLayoutNameA', (('int', None),) ),
    'kernel32.getconsolekeyboardlayoutnamew':( 'int', None, 'stdcall', 'kernel32.GetConsoleKeyboardLayoutNameW', (('int', None),) ),
    'kernel32.getconsolemode':( 'int', None, 'stdcall', 'kernel32.GetConsoleMode', (('int', None), ('void *', 'ptr')) ),
    'kernel32.getconsolenlsmode':( 'int', None, 'stdcall', 'kernel32.GetConsoleNlsMode', (('int', None), ('int', None)) ),
    'kernel32.getconsoleoutputcp':( 'int', None, 'cdecl', 'kernel32.GetConsoleOutputCP', () ),
    'kernel32.getconsoleprocesslist':( 'int', None, 'stdcall', 'kernel32.GetConsoleProcessList', (('int', None), ('int', None)) ),
    'kernel32.getconsolescreenbufferinfo':( 'int', None, 'stdcall', 'kernel32.GetConsoleScreenBufferInfo', (('int', None), ('int', None)) ),
    'kernel32.getconsoleselectioninfo':( 'int', None, 'stdcall', 'kernel32.GetConsoleSelectionInfo', (('int', None),) ),
    'kernel32.getconsoletitlea':( 'int', None, 'stdcall', 'kernel32.GetConsoleTitleA', (('int', None), ('int', None)) ),
    'kernel32.getconsoletitlew':( 'int', None, 'stdcall', 'kernel32.GetConsoleTitleW', (('int', None), ('int', None)) ),
    'kernel32.getconsolewindow':( 'int', None, 'cdecl', 'kernel32.GetConsoleWindow', () ),
    'kernel32.getcurrencyformata':( 'int', None, 'stdcall', 'kernel32.GetCurrencyFormatA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.getcurrencyformatw':( 'int', None, 'stdcall', 'kernel32.GetCurrencyFormatW', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'kernel32.getcurrentactctx':( 'int', None, 'stdcall', 'kernel32.GetCurrentActCtx', (('int', None),) ),
    'kernel32.getcurrentconsolefont':( 'int', None, 'stdcall', 'kernel32.GetCurrentConsoleFont', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.getcurrentdirectorya':( 'int', None, 'stdcall', 'kernel32.GetCurrentDirectoryA', (('int', None), ('int', None)) ),
    'kernel32.getcurrentdirectoryw':( 'int', None, 'stdcall', 'kernel32.GetCurrentDirectoryW', (('int', None), ('int', None)) ),
    'kernel32.getcurrentprocess':( 'int', None, 'cdecl', 'kernel32.GetCurrentProcess', () ),
    'kernel32.getcurrentprocessid':( 'int', None, 'cdecl', 'kernel32.GetCurrentProcessId', () ),
    'kernel32.getcurrentthread':( 'int', None, 'cdecl', 'kernel32.GetCurrentThread', () ),
    'kernel32.getcurrentthreadid':( 'int', None, 'cdecl', 'kernel32.GetCurrentThreadId', () ),
    'kernel32.getdateformata':( 'int', None, 'stdcall', 'kernel32.GetDateFormatA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.getdateformatw':( 'int', None, 'stdcall', 'kernel32.GetDateFormatW', (('int', None), ('int', None), ('int', None), ('void *', 'obj'), ('void *', 'ptr'), ('int', None)) ),
    'kernel32.getdefaultcommconfiga':( 'int', None, 'stdcall', 'kernel32.GetDefaultCommConfigA', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.getdefaultcommconfigw':( 'int', None, 'stdcall', 'kernel32.GetDefaultCommConfigW', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.getdefaultsortkeysize':( 'int', None, 'stdcall', 'kernel32.GetDefaultSortkeySize', (('int', None),) ),
    'kernel32.getdevicepowerstate':( 'int', None, 'stdcall', 'kernel32.GetDevicePowerState', (('int', None), ('int', None)) ),
    'kernel32.getdiskfreespacea':( 'int', None, 'stdcall', 'kernel32.GetDiskFreeSpaceA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.getdiskfreespaceexa':( 'int', None, 'stdcall', 'kernel32.GetDiskFreeSpaceExA', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.getdiskfreespaceexw':( 'int', None, 'stdcall', 'kernel32.GetDiskFreeSpaceExW', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.getdiskfreespacew':( 'int', None, 'stdcall', 'kernel32.GetDiskFreeSpaceW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.getdlldirectorya':( 'int', None, 'stdcall', 'kernel32.GetDllDirectoryA', (('int', None), ('int', None)) ),
    'kernel32.getdlldirectoryw':( 'int', None, 'stdcall', 'kernel32.GetDllDirectoryW', (('int', None), ('int', None)) ),
    'kernel32.getdrivetypea':( 'int', None, 'stdcall', 'kernel32.GetDriveTypeA', (('int', None),) ),
    'kernel32.getdrivetypew':( 'int', None, 'stdcall', 'kernel32.GetDriveTypeW', (('int', None),) ),
    'kernel32.getenvironmentstrings':( 'int', None, 'cdecl', 'kernel32.GetEnvironmentStrings', () ),
    'kernel32.getenvironmentstringsa':( 'int', None, 'cdecl', 'kernel32.GetEnvironmentStringsA', () ),
    'kernel32.getenvironmentstringsw':( 'int', None, 'cdecl', 'kernel32.GetEnvironmentStringsW', () ),
    'kernel32.getenvironmentvariablea':( 'int', None, 'stdcall', 'kernel32.GetEnvironmentVariableA', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.getenvironmentvariablew':( 'int', None, 'stdcall', 'kernel32.GetEnvironmentVariableW', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.getexitcodeprocess':( 'int', None, 'stdcall', 'kernel32.GetExitCodeProcess', (('int', None), ('int', None)) ),
    'kernel32.getexitcodethread':( 'int', None, 'stdcall', 'kernel32.GetExitCodeThread', (('int', None), ('int', None)) ),
    'kernel32.getexpandednamea':( 'int', None, 'stdcall', 'kernel32.GetExpandedNameA', (('void *', 'ptr'), ('int', None)) ),
    'kernel32.getexpandednamew':( 'int', None, 'stdcall', 'kernel32.GetExpandedNameW', (('int', None), ('int', None)) ),
    'kernel32.getfileattributesa':( 'int', None, 'stdcall', 'kernel32.GetFileAttributesA', (('int', None),) ),
    'kernel32.getfileattributesexa':( 'int', None, 'stdcall', 'kernel32.GetFileAttributesExA', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.getfileattributesexw':( 'int', None, 'stdcall', 'kernel32.GetFileAttributesExW', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.getfileattributesw':( 'int', None, 'stdcall', 'kernel32.GetFileAttributesW', (('int', None),) ),
    'kernel32.getfileinformationbyhandle':( 'int', None, 'stdcall', 'kernel32.GetFileInformationByHandle', (('int', None), ('int', None)) ),
    'kernel32.getfilesize':( 'int', None, 'stdcall', 'kernel32.GetFileSize', (('int', None), ('void *', 'ptr')) ),
    'kernel32.getfilesizeex':( 'int', None, 'stdcall', 'kernel32.GetFileSizeEx', (('int', None), ('void *', 'ptr')) ),
    'kernel32.getfiletime':( 'int', None, 'stdcall', 'kernel32.GetFileTime', (('int', None), ('void *', 'ptr'), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'kernel32.getfiletype':( 'int', None, 'stdcall', 'kernel32.GetFileType', (('int', None),) ),
    'kernel32.getfirmwareenvironmentvariablea':( 'int', None, 'stdcall', 'kernel32.GetFirmwareEnvironmentVariableA', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.getfirmwareenvironmentvariablew':( 'int', None, 'stdcall', 'kernel32.GetFirmwareEnvironmentVariableW', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.getfullpathnamea':( 'int', None, 'stdcall', 'kernel32.GetFullPathNameA', (('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'kernel32.getfullpathnamew':( 'int', None, 'stdcall', 'kernel32.GetFullPathNameW', (('int', None), ('int', None), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'kernel32.getgeoinfoa':( 'int', None, 'stdcall', 'kernel32.GetGeoInfoA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.getgeoinfow':( 'int', None, 'stdcall', 'kernel32.GetGeoInfoW', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'kernel32.gethandlecontext':( 'int', None, 'stdcall', 'kernel32.GetHandleContext', (('int', None),) ),
    'kernel32.gethandleinformation':( 'int', None, 'stdcall', 'kernel32.GetHandleInformation', (('int', None), ('void *', 'ptr')) ),
    'kernel32.getlargestconsolewindowsize':( 'int', None, 'stdcall', 'kernel32.GetLargestConsoleWindowSize', (('int', None),) ),
    'kernel32.getlinguistlangsize':( 'int', None, 'stdcall', 'kernel32.GetLinguistLangSize', (('int', None),) ),
    'kernel32.getlocaltime':( 'int', None, 'stdcall', 'kernel32.GetLocalTime', (('void *', 'ptr'),) ),
    'kernel32.getlocaleinfoa':( 'int', None, 'stdcall', 'kernel32.GetLocaleInfoA', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.getlocaleinfow':( 'int', None, 'stdcall', 'kernel32.GetLocaleInfoW', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'kernel32.getlogicaldrivestringsa':( 'int', None, 'stdcall', 'kernel32.GetLogicalDriveStringsA', (('int', None), ('int', None)) ),
    'kernel32.getlogicaldrivestringsw':( 'int', None, 'stdcall', 'kernel32.GetLogicalDriveStringsW', (('int', None), ('int', None)) ),
    'kernel32.getlogicaldrives':( 'int', None, 'cdecl', 'kernel32.GetLogicalDrives', () ),
    'kernel32.getlogicalprocessorinformation':( 'int', None, 'stdcall', 'kernel32.GetLogicalProcessorInformation', (('int', None), ('int', None)) ),
    'kernel32.getlongpathnamea':( 'int', None, 'stdcall', 'kernel32.GetLongPathNameA', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.getlongpathnamew':( 'int', None, 'stdcall', 'kernel32.GetLongPathNameW', (('int', None), ('void *', 'ptr'), ('int', None)) ),
    'kernel32.getmailslotinfo':( 'int', None, 'stdcall', 'kernel32.GetMailslotInfo', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.getmodulefilenamea':( 'int', None, 'stdcall', 'kernel32.GetModuleFileNameA', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.getmodulefilenamew':( 'int', None, 'stdcall', 'kernel32.GetModuleFileNameW', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.getmodulehandlea':( 'int', None, 'stdcall', 'kernel32.GetModuleHandleA', (('int', None),) ),
    'kernel32.getmodulehandleexa':( 'int', None, 'stdcall', 'kernel32.GetModuleHandleExA', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.getmodulehandleexw':( 'int', None, 'stdcall', 'kernel32.GetModuleHandleExW', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.getmodulehandlew':( 'int', None, 'stdcall', 'kernel32.GetModuleHandleW', (('int', None),) ),
    'kernel32.getnamedpipehandlestatea':( 'int', None, 'stdcall', 'kernel32.GetNamedPipeHandleStateA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.getnamedpipehandlestatew':( 'int', None, 'stdcall', 'kernel32.GetNamedPipeHandleStateW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.getnamedpipeinfo':( 'int', None, 'stdcall', 'kernel32.GetNamedPipeInfo', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.getnativesysteminfo':( 'int', None, 'stdcall', 'kernel32.GetNativeSystemInfo', (('int', None),) ),
    'kernel32.getnextvdmcommand':( 'int', None, 'stdcall', 'kernel32.GetNextVDMCommand', (('int', None),) ),
    'kernel32.getnlssectionname':( 'int', None, 'stdcall', 'kernel32.GetNlsSectionName', (('int', None), ('int', None), ('int', None), ('void *', 'obj'), ('void *', 'obj'), ('int', None)) ),
    'kernel32.getnumaavailablememory':( 'int', None, 'stdcall', 'kernel32.GetNumaAvailableMemory', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.getnumaavailablememorynode':( 'int', None, 'stdcall', 'kernel32.GetNumaAvailableMemoryNode', (('int', None), ('int', None)) ),
    'kernel32.getnumahighestnodenumber':( 'int', None, 'stdcall', 'kernel32.GetNumaHighestNodeNumber', (('int', None),) ),
    'kernel32.getnumanodeprocessormask':( 'int', None, 'stdcall', 'kernel32.GetNumaNodeProcessorMask', (('int', None), ('int', None)) ),
    'kernel32.getnumaprocessormap':( 'int', None, 'stdcall', 'kernel32.GetNumaProcessorMap', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.getnumaprocessornode':( 'int', None, 'stdcall', 'kernel32.GetNumaProcessorNode', (('int', None), ('int', None)) ),
    'kernel32.getnumberformata':( 'int', None, 'stdcall', 'kernel32.GetNumberFormatA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.getnumberformatw':( 'int', None, 'stdcall', 'kernel32.GetNumberFormatW', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'kernel32.getnumberofconsolefonts':( 'int', None, 'cdecl', 'kernel32.GetNumberOfConsoleFonts', () ),
    'kernel32.getnumberofconsoleinputevents':( 'int', None, 'stdcall', 'kernel32.GetNumberOfConsoleInputEvents', (('int', None), ('int', None)) ),
    'kernel32.getnumberofconsolemousebuttons':( 'int', None, 'stdcall', 'kernel32.GetNumberOfConsoleMouseButtons', (('int', None),) ),
    'kernel32.getoemcp':( 'int', None, 'cdecl', 'kernel32.GetOEMCP', () ),
    'kernel32.getoverlappedresult':( 'int', None, 'stdcall', 'kernel32.GetOverlappedResult', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.getpriorityclass':( 'int', None, 'stdcall', 'kernel32.GetPriorityClass', (('int', None),) ),
    'kernel32.getprivateprofileinta':( 'int', None, 'stdcall', 'kernel32.GetPrivateProfileIntA', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.getprivateprofileintw':( 'int', None, 'stdcall', 'kernel32.GetPrivateProfileIntW', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.getprivateprofilesectiona':( 'int', None, 'stdcall', 'kernel32.GetPrivateProfileSectionA', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.getprivateprofilesectionnamesa':( 'int', None, 'stdcall', 'kernel32.GetPrivateProfileSectionNamesA', (('void *', 'ptr'), ('int', None), ('int', None)) ),
    'kernel32.getprivateprofilesectionnamesw':( 'int', None, 'stdcall', 'kernel32.GetPrivateProfileSectionNamesW', (('void *', 'ptr'), ('int', None), ('int', None)) ),
    'kernel32.getprivateprofilesectionw':( 'int', None, 'stdcall', 'kernel32.GetPrivateProfileSectionW', (('void *', 'ptr'), ('void *', 'ptr'), ('int', None), ('void *', 'ptr')) ),
    'kernel32.getprivateprofilestringa':( 'int', None, 'stdcall', 'kernel32.GetPrivateProfileStringA', (('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'kernel32.getprivateprofilestringw':( 'int', None, 'stdcall', 'kernel32.GetPrivateProfileStringW', (('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'kernel32.getprivateprofilestructa':( 'int', None, 'stdcall', 'kernel32.GetPrivateProfileStructA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.getprivateprofilestructw':( 'int', None, 'stdcall', 'kernel32.GetPrivateProfileStructW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.getprocaddress':( 'int', None, 'stdcall', 'kernel32.GetProcAddress', (('int', None), ('int', None)) ),
    'kernel32.getprocessaffinitymask':( 'int', None, 'stdcall', 'kernel32.GetProcessAffinityMask', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.getprocessdeppolicy':( 'int', None, 'stdcall', 'kernel32.GetProcessDEPPolicy', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.getprocesshandlecount':( 'int', None, 'stdcall', 'kernel32.GetProcessHandleCount', (('int', None), ('int', None)) ),
    'kernel32.getprocessheap':( 'int', None, 'cdecl', 'kernel32.GetProcessHeap', () ),
    'kernel32.getprocessheaps':( 'int', None, 'stdcall', 'kernel32.GetProcessHeaps', (('int', None), ('void *', 'ptr')) ),
    'kernel32.getprocessid':( 'int', None, 'stdcall', 'kernel32.GetProcessId', (('int', None),) ),
    'kernel32.getprocessiocounters':( 'int', None, 'stdcall', 'kernel32.GetProcessIoCounters', (('int', None), ('int', None)) ),
    'kernel32.getprocesspriorityboost':( 'int', None, 'stdcall', 'kernel32.GetProcessPriorityBoost', (('int', None), ('int', None)) ),
    'kernel32.getprocessshutdownparameters':( 'int', None, 'stdcall', 'kernel32.GetProcessShutdownParameters', (('int', None), ('int', None)) ),
    'kernel32.getprocesstimes':( 'int', None, 'stdcall', 'kernel32.GetProcessTimes', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.getprocessversion':( 'int', None, 'stdcall', 'kernel32.GetProcessVersion', (('int', None),) ),
    'kernel32.getprocessworkingsetsize':( 'int', None, 'stdcall', 'kernel32.GetProcessWorkingSetSize', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.getprofileinta':( 'int', None, 'stdcall', 'kernel32.GetProfileIntA', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.getprofileintw':( 'int', None, 'stdcall', 'kernel32.GetProfileIntW', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.getprofilesectiona':( 'int', None, 'stdcall', 'kernel32.GetProfileSectionA', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.getprofilesectionw':( 'int', None, 'stdcall', 'kernel32.GetProfileSectionW', (('void *', 'ptr'), ('void *', 'ptr'), ('int', None)) ),
    'kernel32.getprofilestringa':( 'int', None, 'stdcall', 'kernel32.GetProfileStringA', (('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'kernel32.getprofilestringw':( 'int', None, 'stdcall', 'kernel32.GetProfileStringW', (('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'kernel32.getqueuedcompletionstatus':( 'int', None, 'stdcall', 'kernel32.GetQueuedCompletionStatus', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.getshortpathnamea':( 'int', None, 'stdcall', 'kernel32.GetShortPathNameA', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.getshortpathnamew':( 'int', None, 'stdcall', 'kernel32.GetShortPathNameW', (('void *', 'ptr'), ('void *', 'ptr'), ('int', None)) ),
    'kernel32.getstartupinfoa':( 'int', None, 'stdcall', 'kernel32.GetStartupInfoA', (('int', None),) ),
    'kernel32.getstartupinfow':( 'int', None, 'stdcall', 'kernel32.GetStartupInfoW', (('void *', 'ptr'),) ),
    'kernel32.getstdhandle':( 'int', None, 'stdcall', 'kernel32.GetStdHandle', (('int', None),) ),
    'kernel32.getstringtypea':( 'int', None, 'stdcall', 'kernel32.GetStringTypeA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.getstringtypeexa':( 'int', None, 'stdcall', 'kernel32.GetStringTypeExA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.getstringtypeexw':( 'int', None, 'stdcall', 'kernel32.GetStringTypeExW', (('int', None), ('int', None), ('void *', 'obj'), ('int', None), ('int', None)) ),
    'kernel32.getstringtypew':( 'int', None, 'stdcall', 'kernel32.GetStringTypeW', (('int', None), ('void *', 'obj'), ('int', None), ('void *', 'ptr')) ),
    'kernel32.getsystemdeppolicy':( 'int', None, 'cdecl', 'kernel32.GetSystemDEPPolicy', () ),
    'kernel32.getsystemdefaultlcid':( 'int', None, 'cdecl', 'kernel32.GetSystemDefaultLCID', () ),
    'kernel32.getsystemdefaultlangid':( 'int', None, 'cdecl', 'kernel32.GetSystemDefaultLangID', () ),
    'kernel32.getsystemdefaultuilanguage':( 'int', None, 'cdecl', 'kernel32.GetSystemDefaultUILanguage', () ),
    'kernel32.getsystemdirectorya':( 'int', None, 'stdcall', 'kernel32.GetSystemDirectoryA', (('int', None), ('int', None)) ),
    'kernel32.getsystemdirectoryw':( 'int', None, 'stdcall', 'kernel32.GetSystemDirectoryW', (('void *', 'ptr'), ('int', None)) ),
    'kernel32.getsysteminfo':( 'int', None, 'stdcall', 'kernel32.GetSystemInfo', (('int', None),) ),
    'kernel32.getsystempowerstatus':( 'int', None, 'stdcall', 'kernel32.GetSystemPowerStatus', (('int', None),) ),
    'kernel32.getsystemregistryquota':( 'int', None, 'stdcall', 'kernel32.GetSystemRegistryQuota', (('int', None), ('int', None)) ),
    'kernel32.getsystemtime':( 'int', None, 'stdcall', 'kernel32.GetSystemTime', (('void *', 'ptr'),) ),
    'kernel32.getsystemtimeadjustment':( 'int', None, 'stdcall', 'kernel32.GetSystemTimeAdjustment', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.getsystemtimeasfiletime':( 'int', None, 'stdcall', 'kernel32.GetSystemTimeAsFileTime', (('void *', 'ptr'),) ),
    'kernel32.getsystemtimes':( 'int', None, 'stdcall', 'kernel32.GetSystemTimes', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.getsystemwindowsdirectorya':( 'int', None, 'stdcall', 'kernel32.GetSystemWindowsDirectoryA', (('int', None), ('int', None)) ),
    'kernel32.getsystemwindowsdirectoryw':( 'int', None, 'stdcall', 'kernel32.GetSystemWindowsDirectoryW', (('void *', 'ptr'), ('int', None)) ),
    'kernel32.getsystemwow64directorya':( 'int', None, 'stdcall', 'kernel32.GetSystemWow64DirectoryA', (('int', None), ('int', None)) ),
    'kernel32.getsystemwow64directoryw':( 'int', None, 'stdcall', 'kernel32.GetSystemWow64DirectoryW', (('int', None), ('int', None)) ),
    'kernel32.gettapeparameters':( 'int', None, 'stdcall', 'kernel32.GetTapeParameters', (('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'kernel32.gettapeposition':( 'int', None, 'stdcall', 'kernel32.GetTapePosition', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.gettapestatus':( 'int', None, 'stdcall', 'kernel32.GetTapeStatus', (('int', None),) ),
    'kernel32.gettempfilenamea':( 'int', None, 'stdcall', 'kernel32.GetTempFileNameA', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.gettempfilenamew':( 'int', None, 'stdcall', 'kernel32.GetTempFileNameW', (('void *', 'ptr'), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'kernel32.gettemppatha':( 'int', None, 'stdcall', 'kernel32.GetTempPathA', (('int', None), ('int', None)) ),
    'kernel32.gettemppathw':( 'int', None, 'stdcall', 'kernel32.GetTempPathW', (('int', None), ('void *', 'ptr')) ),
    'kernel32.getthreadcontext':( 'int', None, 'stdcall', 'kernel32.GetThreadContext', (('int', None), ('int', None)) ),
    'kernel32.getthreadiopendingflag':( 'int', None, 'stdcall', 'kernel32.GetThreadIOPendingFlag', (('int', None), ('int', None)) ),
    'kernel32.getthreadlocale':( 'int', None, 'cdecl', 'kernel32.GetThreadLocale', () ),
    'kernel32.getthreadpriority':( 'int', None, 'stdcall', 'kernel32.GetThreadPriority', (('int', None),) ),
    'kernel32.getthreadpriorityboost':( 'int', None, 'stdcall', 'kernel32.GetThreadPriorityBoost', (('int', None), ('int', None)) ),
    'kernel32.getthreadselectorentry':( 'int', None, 'stdcall', 'kernel32.GetThreadSelectorEntry', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.getthreadtimes':( 'int', None, 'stdcall', 'kernel32.GetThreadTimes', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.gettickcount':( 'int', None, 'cdecl', 'kernel32.GetTickCount', () ),
    'kernel32.gettimeformata':( 'int', None, 'stdcall', 'kernel32.GetTimeFormatA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.gettimeformatw':( 'int', None, 'stdcall', 'kernel32.GetTimeFormatW', (('int', None), ('int', None), ('int', None), ('void *', 'obj'), ('void *', 'ptr'), ('int', None)) ),
    'kernel32.gettimezoneinformation':( 'int', None, 'stdcall', 'kernel32.GetTimeZoneInformation', (('void *', 'ptr'),) ),
    'kernel32.getuserdefaultlcid':( 'int', None, 'cdecl', 'kernel32.GetUserDefaultLCID', () ),
    'kernel32.getuserdefaultlangid':( 'int', None, 'cdecl', 'kernel32.GetUserDefaultLangID', () ),
    'kernel32.getuserdefaultuilanguage':( 'int', None, 'cdecl', 'kernel32.GetUserDefaultUILanguage', () ),
    'kernel32.getusergeoid':( 'int', None, 'stdcall', 'kernel32.GetUserGeoID', (('int', None),) ),
    'kernel32.getvdmcurrentdirectories':( 'int', None, 'stdcall', 'kernel32.GetVDMCurrentDirectories', (('int', None), ('int', None)) ),
    'kernel32.getversion':( 'int', None, 'cdecl', 'kernel32.GetVersion', () ),
    'kernel32.getversionexa':( 'int', None, 'stdcall', 'kernel32.GetVersionExA', (('int', None),) ),
    'kernel32.getversionexw':( 'int', None, 'stdcall', 'kernel32.GetVersionExW', (('void *', 'ptr'),) ),
    'kernel32.getvolumeinformationa':( 'int', None, 'stdcall', 'kernel32.GetVolumeInformationA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.getvolumeinformationw':( 'int', None, 'stdcall', 'kernel32.GetVolumeInformationW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.getvolumenameforvolumemountpointa':( 'int', None, 'stdcall', 'kernel32.GetVolumeNameForVolumeMountPointA', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.getvolumenameforvolumemountpointw':( 'void', None, 'stdcall', 'kernel32.GetVolumeNameForVolumeMountPointW', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.getvolumepathnamea':( 'int', None, 'stdcall', 'kernel32.GetVolumePathNameA', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.getvolumepathnamew':( 'int', None, 'stdcall', 'kernel32.GetVolumePathNameW', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.getvolumepathnamesforvolumenamea':( 'int', None, 'stdcall', 'kernel32.GetVolumePathNamesForVolumeNameA', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.getvolumepathnamesforvolumenamew':( 'int', None, 'stdcall', 'kernel32.GetVolumePathNamesForVolumeNameW', (('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'kernel32.getwindowsdirectorya':( 'int', None, 'stdcall', 'kernel32.GetWindowsDirectoryA', (('int', None), ('int', None)) ),
    'kernel32.getwindowsdirectoryw':( 'int', None, 'stdcall', 'kernel32.GetWindowsDirectoryW', (('void *', 'ptr'), ('int', None)) ),
    'kernel32.getwritewatch':( 'int', None, 'stdcall', 'kernel32.GetWriteWatch', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.globaladdatoma':( 'int', None, 'stdcall', 'kernel32.GlobalAddAtomA', (('int', None),) ),
    'kernel32.globaladdatomw':( 'int', None, 'stdcall', 'kernel32.GlobalAddAtomW', (('int', None),) ),
    'kernel32.globalalloc':( 'int', None, 'stdcall', 'kernel32.GlobalAlloc', (('int', None), ('DWORD', None)) ),
    'kernel32.globalcompact':( 'int', None, 'stdcall', 'kernel32.GlobalCompact', (('int', None),) ),
    'kernel32.globaldeleteatom':( 'int', None, 'stdcall', 'kernel32.GlobalDeleteAtom', (('int', None),) ),
    'kernel32.globalfindatoma':( 'int', None, 'stdcall', 'kernel32.GlobalFindAtomA', (('int', None),) ),
    'kernel32.globalfindatomw':( 'int', None, 'stdcall', 'kernel32.GlobalFindAtomW', (('int', None),) ),
    'kernel32.globalfix':( 'int', None, 'stdcall', 'kernel32.GlobalFix', (('int', None),) ),
    'kernel32.globalflags':( 'int', None, 'stdcall', 'kernel32.GlobalFlags', (('int', None),) ),
    'kernel32.globalfree':( 'int', None, 'stdcall', 'kernel32.GlobalFree', (('void *', 'ptr'),) ),
    'kernel32.globalgetatomnamea':( 'int', None, 'stdcall', 'kernel32.GlobalGetAtomNameA', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.globalgetatomnamew':( 'int', None, 'stdcall', 'kernel32.GlobalGetAtomNameW', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.globalhandle':( 'int', None, 'stdcall', 'kernel32.GlobalHandle', (('int', None),) ),
    'kernel32.globallock':( 'int', None, 'stdcall', 'kernel32.GlobalLock', (('int', None),) ),
    'kernel32.globalmemorystatus':( 'int', None, 'stdcall', 'kernel32.GlobalMemoryStatus', (('int', None),) ),
    'kernel32.globalmemorystatusex':( 'int', None, 'stdcall', 'kernel32.GlobalMemoryStatusEx', (('int', None),) ),
    'kernel32.globalrealloc':( 'int', None, 'stdcall', 'kernel32.GlobalReAlloc', (('void *', 'ptr'), ('DWORD', None), ('int', None)) ),
    'kernel32.globalsize':( 'int', None, 'stdcall', 'kernel32.GlobalSize', (('int', None),) ),
    'kernel32.globalunwire':( 'int', None, 'stdcall', 'kernel32.GlobalUnWire', (('int', None),) ),
    'kernel32.globalunfix':( 'int', None, 'stdcall', 'kernel32.GlobalUnfix', (('int', None),) ),
    'kernel32.globalunlock':( 'int', None, 'stdcall', 'kernel32.GlobalUnlock', (('int', None),) ),
    'kernel32.globalwire':( 'int', None, 'stdcall', 'kernel32.GlobalWire', (('int', None),) ),
    'kernel32.heap32first':( 'int', None, 'stdcall', 'kernel32.Heap32First', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.heap32listfirst':( 'int', None, 'stdcall', 'kernel32.Heap32ListFirst', (('int', None), ('int', None)) ),
    'kernel32.heap32listnext':( 'int', None, 'stdcall', 'kernel32.Heap32ListNext', (('int', None), ('int', None)) ),
    'kernel32.heap32next':( 'int', None, 'stdcall', 'kernel32.Heap32Next', (('int', None),) ),
    'kernel32.heapcompact':( 'int', None, 'stdcall', 'kernel32.HeapCompact', (('int', None), ('int', None)) ),
    'kernel32.heapcreate':( 'int', None, 'stdcall', 'kernel32.HeapCreate', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.heapcreatetagsw':( 'int', None, 'cdecl', 'kernel32.HeapCreateTagsW', () ),
    'kernel32.heapdestroy':( 'int', None, 'stdcall', 'kernel32.HeapDestroy', (('int', None),) ),
    'kernel32.heapextend':( 'int', None, 'stdcall', 'kernel32.HeapExtend', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.heaplock':( 'int', None, 'stdcall', 'kernel32.HeapLock', (('int', None),) ),
    'kernel32.heapqueryinformation':( 'int', None, 'stdcall', 'kernel32.HeapQueryInformation', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.heapquerytagw':( 'int', None, 'cdecl', 'kernel32.HeapQueryTagW', () ),
    'kernel32.heapsetinformation':( 'int', None, 'stdcall', 'kernel32.HeapSetInformation', (('HEAP', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.heapsummary':( 'int', None, 'stdcall', 'kernel32.HeapSummary', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.heapunlock':( 'int', None, 'stdcall', 'kernel32.HeapUnlock', (('int', None),) ),
    'kernel32.heapusage':( 'int', None, 'stdcall', 'kernel32.HeapUsage', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.heapvalidate':( 'int', None, 'stdcall', 'kernel32.HeapValidate', (('HEAP', None), ('int', None), ('int', None)) ),
    'kernel32.heapwalk':( 'int', None, 'stdcall', 'kernel32.HeapWalk', (('HEAP', None), ('int', None)) ),
    'kernel32.initatomtable':( 'int', None, 'stdcall', 'kernel32.InitAtomTable', (('int', None),) ),
    'kernel32.initializecriticalsectionandspincount':( 'int', None, 'stdcall', 'kernel32.InitializeCriticalSectionAndSpinCount', (('int', None), ('int', None)) ),
    'kernel32.interlockedcompareexchange':( 'int', None, 'stdcall', 'kernel32.InterlockedCompareExchange', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.interlockeddecrement':( 'int', None, 'stdcall', 'kernel32.InterlockedDecrement', (('int', None),) ),
    'kernel32.interlockedexchange':( 'int', None, 'stdcall', 'kernel32.InterlockedExchange', (('int', None), ('int', None)) ),
    'kernel32.interlockedexchangeadd':( 'int', None, 'stdcall', 'kernel32.InterlockedExchangeAdd', (('int', None), ('int', None)) ),
    'kernel32.interlockedincrement':( 'int', None, 'stdcall', 'kernel32.InterlockedIncrement', (('int', None),) ),
    'kernel32.invalidateconsoledibits':( 'int', None, 'stdcall', 'kernel32.InvalidateConsoleDIBits', (('int', None), ('int', None)) ),
    'kernel32.isbadcodeptr':( 'int', None, 'stdcall', 'kernel32.IsBadCodePtr', (('int', None),) ),
    'kernel32.isbadhugereadptr':( 'int', None, 'stdcall', 'kernel32.IsBadHugeReadPtr', (('int', None), ('int', None)) ),
    'kernel32.isbadhugewriteptr':( 'int', None, 'stdcall', 'kernel32.IsBadHugeWritePtr', (('int', None), ('int', None)) ),
    'kernel32.isbadreadptr':( 'int', None, 'stdcall', 'kernel32.IsBadReadPtr', (('int', None), ('int', None)) ),
    'kernel32.isbadstringptra':( 'int', None, 'stdcall', 'kernel32.IsBadStringPtrA', (('int', None), ('int', None)) ),
    'kernel32.isbadstringptrw':( 'int', None, 'stdcall', 'kernel32.IsBadStringPtrW', (('int', None), ('int', None)) ),
    'kernel32.isbadwriteptr':( 'int', None, 'stdcall', 'kernel32.IsBadWritePtr', (('int', None), ('int', None)) ),
    'kernel32.isdbcsleadbyte':( 'int', None, 'stdcall', 'kernel32.IsDBCSLeadByte', (('int', None),) ),
    'kernel32.isdbcsleadbyteex':( 'int', None, 'stdcall', 'kernel32.IsDBCSLeadByteEx', (('int', None), ('int', None)) ),
    'kernel32.isdebuggerpresent':( 'int', None, 'cdecl', 'kernel32.IsDebuggerPresent', () ),
    'kernel32.isprocessinjob':( 'int', None, 'stdcall', 'kernel32.IsProcessInJob', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.isprocessorfeaturepresent':( 'int', None, 'stdcall', 'kernel32.IsProcessorFeaturePresent', (('int', None),) ),
    'kernel32.issystemresumeautomatic':( 'int', None, 'stdcall', 'kernel32.IsSystemResumeAutomatic', () ),
    'kernel32.isvalidcodepage':( 'int', None, 'stdcall', 'kernel32.IsValidCodePage', (('int', None),) ),
    'kernel32.isvalidlanguagegroup':( 'int', None, 'stdcall', 'kernel32.IsValidLanguageGroup', (('int', None), ('int', None)) ),
    'kernel32.isvalidlocale':( 'int', None, 'stdcall', 'kernel32.IsValidLocale', (('int', None), ('int', None)) ),
    'kernel32.isvaliduilanguage':( 'int', None, 'stdcall', 'kernel32.IsValidUILanguage', (('int', None),) ),
    'kernel32.iswow64process':( 'int', None, 'stdcall', 'kernel32.IsWow64Process', (('int', None), ('int', None)) ),
    'kernel32.lcmapstringa':( 'int', None, 'stdcall', 'kernel32.LCMapStringA', (('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'kernel32.lcmapstringw':( 'int', None, 'stdcall', 'kernel32.LCMapStringW', (('int', None), ('int', None), ('void *', 'obj'), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'kernel32.lzclose':( 'int', None, 'stdcall', 'kernel32.LZClose', (('int', None),) ),
    'kernel32.lzclosefile':( 'int', None, 'stdcall', 'kernel32.LZCloseFile', (('int', None),) ),
    'kernel32.lzcopy':( 'int', None, 'stdcall', 'kernel32.LZCopy', (('int', None), ('int', None)) ),
    'kernel32.lzcreatefilew':( 'int', None, 'stdcall', 'kernel32.LZCreateFileW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.lzdone':( 'int', None, 'cdecl', 'kernel32.LZDone', () ),
    'kernel32.lzinit':( 'int', None, 'stdcall', 'kernel32.LZInit', (('int', None),) ),
    'kernel32.lzopenfilea':( 'int', None, 'stdcall', 'kernel32.LZOpenFileA', (('void *', 'ptr'), ('int', None), ('int', None)) ),
    'kernel32.lzopenfilew':( 'int', None, 'stdcall', 'kernel32.LZOpenFileW', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.lzread':( 'int', None, 'stdcall', 'kernel32.LZRead', (('int', None), ('void *', 'ptr'), ('int', None)) ),
    'kernel32.lzseek':( 'int', None, 'stdcall', 'kernel32.LZSeek', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.lzstart':( 'int', None, 'cdecl', 'kernel32.LZStart', () ),
    'kernel32.loadlibrarya':( 'int', None, 'stdcall', 'kernel32.LoadLibraryA', (('int', None),) ),
    'kernel32.loadlibraryexa':( 'int', None, 'stdcall', 'kernel32.LoadLibraryExA', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.loadlibraryexw':( 'int', None, 'stdcall', 'kernel32.LoadLibraryExW', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.loadlibraryw':( 'int', None, 'stdcall', 'kernel32.LoadLibraryW', (('void *', 'ptr'),) ),
    'kernel32.loadmodule':( 'int', None, 'stdcall', 'kernel32.LoadModule', (('int', None), ('int', None)) ),
    'kernel32.loadresource':( 'int', None, 'stdcall', 'kernel32.LoadResource', (('int', None), ('int', None)) ),
    'kernel32.localalloc':( 'int', None, 'stdcall', 'kernel32.LocalAlloc', (('int', None), ('DWORD', None)) ),
    'kernel32.localcompact':( 'int', None, 'stdcall', 'kernel32.LocalCompact', (('int', None),) ),
    'kernel32.localfiletimetofiletime':( 'int', None, 'stdcall', 'kernel32.LocalFileTimeToFileTime', (('int', None), ('int', None)) ),
    'kernel32.localflags':( 'int', None, 'stdcall', 'kernel32.LocalFlags', (('int', None),) ),
    'kernel32.localfree':( 'int', None, 'stdcall', 'kernel32.LocalFree', (('void *', 'ptr'),) ),
    'kernel32.localhandle':( 'int', None, 'stdcall', 'kernel32.LocalHandle', (('int', None),) ),
    'kernel32.locallock':( 'int', None, 'stdcall', 'kernel32.LocalLock', (('int', None),) ),
    'kernel32.localrealloc':( 'int', None, 'stdcall', 'kernel32.LocalReAlloc', (('int', None), ('DWORD', None), ('int', None)) ),
    'kernel32.localshrink':( 'int', None, 'stdcall', 'kernel32.LocalShrink', (('int', None), ('int', None)) ),
    'kernel32.localsize':( 'int', None, 'stdcall', 'kernel32.LocalSize', (('int', None),) ),
    'kernel32.localunlock':( 'int', None, 'stdcall', 'kernel32.LocalUnlock', (('int', None),) ),
    'kernel32.lockfile':( 'int', None, 'stdcall', 'kernel32.LockFile', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.lockfileex':( 'int', None, 'stdcall', 'kernel32.LockFileEx', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.lockresource':( 'int', None, 'stdcall', 'kernel32.LockResource', (('int', None),) ),
    'kernel32.mapuserphysicalpages':( 'int', None, 'stdcall', 'kernel32.MapUserPhysicalPages', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.mapuserphysicalpagesscatter':( 'int', None, 'stdcall', 'kernel32.MapUserPhysicalPagesScatter', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.mapviewoffile':( 'int', None, 'stdcall', 'kernel32.MapViewOfFile', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.mapviewoffileex':( 'int', None, 'stdcall', 'kernel32.MapViewOfFileEx', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.module32first':( 'int', None, 'stdcall', 'kernel32.Module32First', (('int', None), ('int', None)) ),
    'kernel32.module32firstw':( 'int', None, 'stdcall', 'kernel32.Module32FirstW', (('int', None), ('void *', 'ptr')) ),
    'kernel32.module32next':( 'int', None, 'stdcall', 'kernel32.Module32Next', (('int', None), ('int', None)) ),
    'kernel32.module32nextw':( 'int', None, 'stdcall', 'kernel32.Module32NextW', (('int', None), ('void *', 'ptr')) ),
    'kernel32.movefilea':( 'int', None, 'stdcall', 'kernel32.MoveFileA', (('int', None), ('int', None)) ),
    'kernel32.movefileexa':( 'int', None, 'stdcall', 'kernel32.MoveFileExA', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.movefileexw':( 'int', None, 'stdcall', 'kernel32.MoveFileExW', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.movefilew':( 'int', None, 'stdcall', 'kernel32.MoveFileW', (('void *', 'ptr'), ('int', None)) ),
    'kernel32.movefilewithprogressa':( 'int', None, 'stdcall', 'kernel32.MoveFileWithProgressA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.movefilewithprogressw':( 'int', None, 'stdcall', 'kernel32.MoveFileWithProgressW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.muldiv':( 'int', None, 'stdcall', 'kernel32.MulDiv', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.multibytetowidechar':( 'int', None, 'stdcall', 'kernel32.MultiByteToWideChar', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('void *', 'obj'), ('int', None)) ),
    'kernel32.nlsconvertintegertostring':( 'int', None, 'stdcall', 'kernel32.NlsConvertIntegerToString', (('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'kernel32.nlsgetcacheupdatecount':( 'int', None, 'cdecl', 'kernel32.NlsGetCacheUpdateCount', () ),
    'kernel32.nlsresetprocesslocale':( 'int', None, 'cdecl', 'kernel32.NlsResetProcessLocale', () ),
    'kernel32.numavirtualquerynode':( 'int', None, 'stdcall', 'kernel32.NumaVirtualQueryNode', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.openconsolew':( 'int', None, 'stdcall', 'kernel32.OpenConsoleW', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.opendatafile':( 'int', None, 'stdcall', 'kernel32.OpenDataFile', (('void *', 'ptr'), ('int', None)) ),
    'kernel32.openeventa':( 'int', None, 'stdcall', 'kernel32.OpenEventA', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.openeventw':( 'int', None, 'stdcall', 'kernel32.OpenEventW', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.openfile':( 'int', None, 'stdcall', 'kernel32.OpenFile', (('void *', 'ptr'), ('void *', 'ptr'), ('int', None)) ),
    'kernel32.openfilemappinga':( 'int', None, 'stdcall', 'kernel32.OpenFileMappingA', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.openfilemappingw':( 'int', None, 'stdcall', 'kernel32.OpenFileMappingW', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.openjobobjecta':( 'int', None, 'stdcall', 'kernel32.OpenJobObjectA', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.openjobobjectw':( 'int', None, 'stdcall', 'kernel32.OpenJobObjectW', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.openmutexa':( 'int', None, 'stdcall', 'kernel32.OpenMutexA', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.openmutexw':( 'int', None, 'stdcall', 'kernel32.OpenMutexW', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.openprocess':( 'int', None, 'stdcall', 'kernel32.OpenProcess', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.openprofileusermapping':( 'int', None, 'cdecl', 'kernel32.OpenProfileUserMapping', () ),
    'kernel32.opensemaphorea':( 'int', None, 'stdcall', 'kernel32.OpenSemaphoreA', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.opensemaphorew':( 'int', None, 'stdcall', 'kernel32.OpenSemaphoreW', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.openthread':( 'int', None, 'stdcall', 'kernel32.OpenThread', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.openwaitabletimera':( 'int', None, 'stdcall', 'kernel32.OpenWaitableTimerA', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.openwaitabletimerw':( 'int', None, 'stdcall', 'kernel32.OpenWaitableTimerW', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.outputdebugstringa':( 'int', None, 'stdcall', 'kernel32.OutputDebugStringA', (('int', None),) ),
    'kernel32.outputdebugstringw':( 'int', None, 'stdcall', 'kernel32.OutputDebugStringW', (('int', None),) ),
    'kernel32.peekconsoleinputa':( 'int', None, 'stdcall', 'kernel32.PeekConsoleInputA', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.peekconsoleinputw':( 'int', None, 'stdcall', 'kernel32.PeekConsoleInputW', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.peeknamedpipe':( 'int', None, 'stdcall', 'kernel32.PeekNamedPipe', (('int', None), ('int', None), ('DWORD', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.postqueuedcompletionstatus':( 'int', None, 'stdcall', 'kernel32.PostQueuedCompletionStatus', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.preparetape':( 'int', None, 'stdcall', 'kernel32.PrepareTape', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.privcopyfileexw':( 'int', None, 'stdcall', 'kernel32.PrivCopyFileExW', (('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'kernel32.privmovefileidentityw':( 'int', None, 'stdcall', 'kernel32.PrivMoveFileIdentityW', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.process32first':( 'int', None, 'stdcall', 'kernel32.Process32First', (('int', None), ('int', None)) ),
    'kernel32.process32firstw':( 'int', None, 'stdcall', 'kernel32.Process32FirstW', (('int', None), ('void *', 'ptr')) ),
    'kernel32.process32next':( 'int', None, 'stdcall', 'kernel32.Process32Next', (('int', None), ('int', None)) ),
    'kernel32.process32nextw':( 'int', None, 'stdcall', 'kernel32.Process32NextW', (('int', None), ('void *', 'ptr')) ),
    'kernel32.processidtosessionid':( 'int', None, 'stdcall', 'kernel32.ProcessIdToSessionId', (('int', None), ('int', None)) ),
    'kernel32.pulseevent':( 'int', None, 'stdcall', 'kernel32.PulseEvent', (('int', None),) ),
    'kernel32.purgecomm':( 'int', None, 'stdcall', 'kernel32.PurgeComm', (('int', None), ('int', None)) ),
    'kernel32.queryactctxw':( 'int', None, 'stdcall', 'kernel32.QueryActCtxW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.querydosdevicea':( 'int', None, 'stdcall', 'kernel32.QueryDosDeviceA', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.querydosdevicew':( 'int', None, 'stdcall', 'kernel32.QueryDosDeviceW', (('void *', 'ptr'), ('void *', 'ptr'), ('int', None)) ),
    'kernel32.queryinformationjobobject':( 'int', None, 'stdcall', 'kernel32.QueryInformationJobObject', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.querymemoryresourcenotification':( 'int', None, 'stdcall', 'kernel32.QueryMemoryResourceNotification', (('int', None), ('int', None)) ),
    'kernel32.queryperformancecounter':( 'int', None, 'stdcall', 'kernel32.QueryPerformanceCounter', (('int', None),) ),
    'kernel32.queryperformancefrequency':( 'int', None, 'stdcall', 'kernel32.QueryPerformanceFrequency', (('int', None),) ),
    'kernel32.querywin31inifilesmappedtoregistry':( 'int', None, 'stdcall', 'kernel32.QueryWin31IniFilesMappedToRegistry', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.queueuserapc':( 'int', None, 'stdcall', 'kernel32.QueueUserAPC', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.queueuserworkitem':( 'int', None, 'stdcall', 'kernel32.QueueUserWorkItem', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.raiseexception':( 'int', None, 'stdcall', 'kernel32.RaiseException', (('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'kernel32.readconsolea':( 'int', None, 'stdcall', 'kernel32.ReadConsoleA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.readconsoleinputa':( 'int', None, 'stdcall', 'kernel32.ReadConsoleInputA', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.readconsoleinputexa':( 'int', None, 'stdcall', 'kernel32.ReadConsoleInputExA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.readconsoleinputexw':( 'int', None, 'stdcall', 'kernel32.ReadConsoleInputExW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.readconsoleinputw':( 'int', None, 'stdcall', 'kernel32.ReadConsoleInputW', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.readconsoleoutputa':( 'int', None, 'stdcall', 'kernel32.ReadConsoleOutputA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.readconsoleoutputattribute':( 'int', None, 'stdcall', 'kernel32.ReadConsoleOutputAttribute', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.readconsoleoutputcharactera':( 'int', None, 'stdcall', 'kernel32.ReadConsoleOutputCharacterA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.readconsoleoutputcharacterw':( 'int', None, 'stdcall', 'kernel32.ReadConsoleOutputCharacterW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.readconsoleoutputw':( 'int', None, 'stdcall', 'kernel32.ReadConsoleOutputW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.readconsolew':( 'int', None, 'stdcall', 'kernel32.ReadConsoleW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.readdirectorychangesw':( 'int', None, 'stdcall', 'kernel32.ReadDirectoryChangesW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.readfile':( 'int', None, 'stdcall', 'kernel32.ReadFile', (('int', None), ('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'kernel32.readfileex':( 'int', None, 'stdcall', 'kernel32.ReadFileEx', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.readfilescatter':( 'int', None, 'stdcall', 'kernel32.ReadFileScatter', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.readprocessmemory':( 'int', None, 'stdcall', 'kernel32.ReadProcessMemory', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'kernel32.registerconsoleime':( 'int', None, 'stdcall', 'kernel32.RegisterConsoleIME', (('int', None), ('int', None)) ),
    'kernel32.registerconsoleos2':( 'int', None, 'stdcall', 'kernel32.RegisterConsoleOS2', (('int', None),) ),
    'kernel32.registerconsolevdm':( 'int', None, 'stdcall', 'kernel32.RegisterConsoleVDM', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.registerwaitforinputidle':( 'int', None, 'stdcall', 'kernel32.RegisterWaitForInputIdle', (('int', None),) ),
    'kernel32.registerwaitforsingleobject':( 'int', None, 'stdcall', 'kernel32.RegisterWaitForSingleObject', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.registerwaitforsingleobjectex':( 'int', None, 'stdcall', 'kernel32.RegisterWaitForSingleObjectEx', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.registerwowbasehandlers':( 'int', None, 'stdcall', 'kernel32.RegisterWowBaseHandlers', (('int', None),) ),
    'kernel32.registerwowexec':( 'int', None, 'stdcall', 'kernel32.RegisterWowExec', (('int', None),) ),
    'kernel32.releaseactctx':( 'int', None, 'cdecl', 'kernel32.ReleaseActCtx', () ),
    'kernel32.releasemutex':( 'int', None, 'stdcall', 'kernel32.ReleaseMutex', (('int', None),) ),
    'kernel32.releasesemaphore':( 'int', None, 'stdcall', 'kernel32.ReleaseSemaphore', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.removedirectorya':( 'int', None, 'stdcall', 'kernel32.RemoveDirectoryA', (('int', None),) ),
    'kernel32.removedirectoryw':( 'int', None, 'stdcall', 'kernel32.RemoveDirectoryW', (('int', None),) ),
    'kernel32.removelocalalternatecomputernamea':( 'int', None, 'stdcall', 'kernel32.RemoveLocalAlternateComputerNameA', (('int', None), ('int', None)) ),
    'kernel32.removelocalalternatecomputernamew':( 'int', None, 'stdcall', 'kernel32.RemoveLocalAlternateComputerNameW', (('int', None), ('int', None)) ),
    'kernel32.replacefile':( 'int', None, 'stdcall', 'kernel32.ReplaceFile', (('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.replacefilea':( 'int', None, 'stdcall', 'kernel32.ReplaceFileA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.replacefilew':( 'int', None, 'stdcall', 'kernel32.ReplaceFileW', (('void *', 'ptr'), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.requestdevicewakeup':( 'int', None, 'stdcall', 'kernel32.RequestDeviceWakeup', (('int', None),) ),
    'kernel32.requestwakeuplatency':( 'int', None, 'stdcall', 'kernel32.RequestWakeupLatency', (('int', None),) ),
    'kernel32.resetevent':( 'int', None, 'stdcall', 'kernel32.ResetEvent', (('int', None),) ),
    'kernel32.resetwritewatch':( 'int', None, 'stdcall', 'kernel32.ResetWriteWatch', (('int', None), ('int', None)) ),
    'kernel32.resumethread':( 'int', None, 'stdcall', 'kernel32.ResumeThread', (('int', None),) ),
    'kernel32.scrollconsolescreenbuffera':( 'int', None, 'stdcall', 'kernel32.ScrollConsoleScreenBufferA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.scrollconsolescreenbufferw':( 'int', None, 'stdcall', 'kernel32.ScrollConsoleScreenBufferW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.searchpatha':( 'int', None, 'stdcall', 'kernel32.SearchPathA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'kernel32.searchpathw':( 'int', None, 'stdcall', 'kernel32.SearchPathW', (('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'kernel32.setcpglobal':( 'int', None, 'stdcall', 'kernel32.SetCPGlobal', (('int', None),) ),
    'kernel32.setcalendarinfoa':( 'int', None, 'stdcall', 'kernel32.SetCalendarInfoA', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.setcalendarinfow':( 'int', None, 'stdcall', 'kernel32.SetCalendarInfoW', (('int', None), ('int', None), ('int', None), ('void *', 'obj')) ),
    'kernel32.setclienttimezoneinformation':( 'int', None, 'stdcall', 'kernel32.SetClientTimeZoneInformation', (('int', None),) ),
    'kernel32.setcompluspackageinstallstatus':( 'int', None, 'stdcall', 'kernel32.SetComPlusPackageInstallStatus', (('int', None),) ),
    'kernel32.setcommbreak':( 'int', None, 'stdcall', 'kernel32.SetCommBreak', (('int', None),) ),
    'kernel32.setcommconfig':( 'int', None, 'stdcall', 'kernel32.SetCommConfig', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.setcommmask':( 'int', None, 'stdcall', 'kernel32.SetCommMask', (('int', None), ('int', None)) ),
    'kernel32.setcommstate':( 'int', None, 'stdcall', 'kernel32.SetCommState', (('int', None), ('int', None)) ),
    'kernel32.setcommtimeouts':( 'int', None, 'stdcall', 'kernel32.SetCommTimeouts', (('int', None), ('int', None)) ),
    'kernel32.setcomputernamea':( 'int', None, 'stdcall', 'kernel32.SetComputerNameA', (('int', None),) ),
    'kernel32.setcomputernameexa':( 'int', None, 'stdcall', 'kernel32.SetComputerNameExA', (('int', None), ('int', None)) ),
    'kernel32.setcomputernameexw':( 'int', None, 'stdcall', 'kernel32.SetComputerNameExW', (('int', None), ('int', None)) ),
    'kernel32.setcomputernamew':( 'int', None, 'stdcall', 'kernel32.SetComputerNameW', (('int', None),) ),
    'kernel32.setconsoleactivescreenbuffer':( 'int', None, 'stdcall', 'kernel32.SetConsoleActiveScreenBuffer', (('int', None),) ),
    'kernel32.setconsolecp':( 'int', None, 'stdcall', 'kernel32.SetConsoleCP', (('int', None),) ),
    'kernel32.setconsolecommandhistorymode':( 'int', None, 'stdcall', 'kernel32.SetConsoleCommandHistoryMode', (('int', None),) ),
    'kernel32.setconsolectrlhandler':( 'int', None, 'stdcall', 'kernel32.SetConsoleCtrlHandler', (('int', None), ('int', None)) ),
    'kernel32.setconsolecursor':( 'int', None, 'stdcall', 'kernel32.SetConsoleCursor', (('int', None), ('int', None)) ),
    'kernel32.setconsolecursorinfo':( 'int', None, 'stdcall', 'kernel32.SetConsoleCursorInfo', (('int', None), ('int', None)) ),
    'kernel32.setconsolecursormode':( 'int', None, 'stdcall', 'kernel32.SetConsoleCursorMode', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.setconsolecursorposition':( 'int', None, 'stdcall', 'kernel32.SetConsoleCursorPosition', (('int', None), ('int', None)) ),
    'kernel32.setconsoledisplaymode':( 'int', None, 'stdcall', 'kernel32.SetConsoleDisplayMode', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.setconsolefont':( 'int', None, 'stdcall', 'kernel32.SetConsoleFont', (('int', None), ('int', None)) ),
    'kernel32.setconsolehardwarestate':( 'int', None, 'stdcall', 'kernel32.SetConsoleHardwareState', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.setconsoleicon':( 'int', None, 'stdcall', 'kernel32.SetConsoleIcon', (('int', None),) ),
    'kernel32.setconsoleinputexenamea':( 'int', None, 'stdcall', 'kernel32.SetConsoleInputExeNameA', (('int', None),) ),
    'kernel32.setconsoleinputexenamew':( 'int', None, 'stdcall', 'kernel32.SetConsoleInputExeNameW', (('int', None),) ),
    'kernel32.setconsolekeyshortcuts':( 'int', None, 'stdcall', 'kernel32.SetConsoleKeyShortcuts', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.setconsolelocaleudc':( 'int', None, 'stdcall', 'kernel32.SetConsoleLocalEUDC', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.setconsolemaximumwindowsize':( 'int', None, 'stdcall', 'kernel32.SetConsoleMaximumWindowSize', (('int', None), ('int', None)) ),
    'kernel32.setconsolemenuclose':( 'int', None, 'stdcall', 'kernel32.SetConsoleMenuClose', (('int', None),) ),
    'kernel32.setconsolemode':( 'int', None, 'stdcall', 'kernel32.SetConsoleMode', (('int', None), ('int', None)) ),
    'kernel32.setconsolenlsmode':( 'int', None, 'stdcall', 'kernel32.SetConsoleNlsMode', (('int', None), ('int', None)) ),
    'kernel32.setconsolenumberofcommandsa':( 'int', None, 'stdcall', 'kernel32.SetConsoleNumberOfCommandsA', (('int', None), ('int', None)) ),
    'kernel32.setconsolenumberofcommandsw':( 'int', None, 'stdcall', 'kernel32.SetConsoleNumberOfCommandsW', (('int', None), ('int', None)) ),
    'kernel32.setconsoleos2oemformat':( 'int', None, 'stdcall', 'kernel32.SetConsoleOS2OemFormat', (('int', None),) ),
    'kernel32.setconsoleoutputcp':( 'int', None, 'stdcall', 'kernel32.SetConsoleOutputCP', (('int', None),) ),
    'kernel32.setconsolepalette':( 'int', None, 'stdcall', 'kernel32.SetConsolePalette', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.setconsolescreenbuffersize':( 'int', None, 'stdcall', 'kernel32.SetConsoleScreenBufferSize', (('int', None), ('int', None)) ),
    'kernel32.setconsoletextattribute':( 'int', None, 'stdcall', 'kernel32.SetConsoleTextAttribute', (('int', None), ('int', None)) ),
    'kernel32.setconsoletitlea':( 'int', None, 'stdcall', 'kernel32.SetConsoleTitleA', (('int', None),) ),
    'kernel32.setconsoletitlew':( 'int', None, 'stdcall', 'kernel32.SetConsoleTitleW', (('int', None),) ),
    'kernel32.setconsolewindowinfo':( 'int', None, 'stdcall', 'kernel32.SetConsoleWindowInfo', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.setcurrentdirectorya':( 'int', None, 'stdcall', 'kernel32.SetCurrentDirectoryA', (('int', None),) ),
    'kernel32.setcurrentdirectoryw':( 'int', None, 'stdcall', 'kernel32.SetCurrentDirectoryW', (('int', None),) ),
    'kernel32.setdefaultcommconfiga':( 'int', None, 'stdcall', 'kernel32.SetDefaultCommConfigA', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.setdefaultcommconfigw':( 'int', None, 'stdcall', 'kernel32.SetDefaultCommConfigW', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.setdlldirectorya':( 'int', None, 'stdcall', 'kernel32.SetDllDirectoryA', (('int', None),) ),
    'kernel32.setdlldirectoryw':( 'int', None, 'stdcall', 'kernel32.SetDllDirectoryW', (('int', None),) ),
    'kernel32.setendoffile':( 'int', None, 'stdcall', 'kernel32.SetEndOfFile', (('int', None),) ),
    'kernel32.setenvironmentvariablea':( 'int', None, 'stdcall', 'kernel32.SetEnvironmentVariableA', (('int', None), ('int', None)) ),
    'kernel32.setenvironmentvariablew':( 'int', None, 'stdcall', 'kernel32.SetEnvironmentVariableW', (('int', None), ('int', None)) ),
    'kernel32.seterrormode':( 'int', None, 'stdcall', 'kernel32.SetErrorMode', (('int', None),) ),
    'kernel32.setevent':( 'int', None, 'stdcall', 'kernel32.SetEvent', (('int', None),) ),
    'kernel32.setfileapistoansi':( 'int', None, 'cdecl', 'kernel32.SetFileApisToANSI', () ),
    'kernel32.setfileapistooem':( 'int', None, 'cdecl', 'kernel32.SetFileApisToOEM', () ),
    'kernel32.setfileattributesa':( 'int', None, 'stdcall', 'kernel32.SetFileAttributesA', (('int', None), ('int', None)) ),
    'kernel32.setfileattributesw':( 'int', None, 'stdcall', 'kernel32.SetFileAttributesW', (('int', None), ('int', None)) ),
    'kernel32.setfilepointer':( 'int', None, 'stdcall', 'kernel32.SetFilePointer', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'kernel32.setfilepointerex':( 'int', None, 'stdcall', 'kernel32.SetFilePointerEx', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.setfileshortnamea':( 'int', None, 'stdcall', 'kernel32.SetFileShortNameA', (('int', None), ('int', None)) ),
    'kernel32.setfileshortnamew':( 'int', None, 'stdcall', 'kernel32.SetFileShortNameW', (('int', None), ('int', None)) ),
    'kernel32.setfiletime':( 'int', None, 'stdcall', 'kernel32.SetFileTime', (('int', None), ('void *', 'ptr'), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'kernel32.setfilevaliddata':( 'int', None, 'stdcall', 'kernel32.SetFileValidData', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.setfirmwareenvironmentvariablea':( 'int', None, 'stdcall', 'kernel32.SetFirmwareEnvironmentVariableA', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.setfirmwareenvironmentvariablew':( 'int', None, 'stdcall', 'kernel32.SetFirmwareEnvironmentVariableW', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.sethandlecontext':( 'int', None, 'stdcall', 'kernel32.SetHandleContext', (('int', None), ('int', None)) ),
    'kernel32.sethandlecount':( 'int', None, 'stdcall', 'kernel32.SetHandleCount', (('int', None),) ),
    'kernel32.sethandleinformation':( 'int', None, 'stdcall', 'kernel32.SetHandleInformation', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.setinformationjobobject':( 'int', None, 'stdcall', 'kernel32.SetInformationJobObject', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'kernel32.setlastconsoleeventactive':( 'int', None, 'cdecl', 'kernel32.SetLastConsoleEventActive', () ),
    'kernel32.setlocalprimarycomputernamea':( 'int', None, 'stdcall', 'kernel32.SetLocalPrimaryComputerNameA', (('int', None), ('int', None)) ),
    'kernel32.setlocalprimarycomputernamew':( 'int', None, 'stdcall', 'kernel32.SetLocalPrimaryComputerNameW', (('int', None), ('int', None)) ),
    'kernel32.setlocaltime':( 'int', None, 'stdcall', 'kernel32.SetLocalTime', (('int', None),) ),
    'kernel32.setlocaleinfoa':( 'int', None, 'stdcall', 'kernel32.SetLocaleInfoA', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.setlocaleinfow':( 'int', None, 'stdcall', 'kernel32.SetLocaleInfoW', (('int', None), ('int', None), ('void *', 'obj')) ),
    'kernel32.setmailslotinfo':( 'int', None, 'stdcall', 'kernel32.SetMailslotInfo', (('int', None), ('int', None)) ),
    'kernel32.setmessagewaitingindicator':( 'int', None, 'stdcall', 'kernel32.SetMessageWaitingIndicator', (('int', None), ('int', None)) ),
    'kernel32.setnamedpipehandlestate':( 'int', None, 'stdcall', 'kernel32.SetNamedPipeHandleState', (('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'kernel32.setpriorityclass':( 'int', None, 'stdcall', 'kernel32.SetPriorityClass', ( ('int', None), ('int', None)) ),
    'kernel32.setprocessaffinitymask':( 'int', None, 'stdcall', 'kernel32.SetProcessAffinityMask', (('int', None), ('int', None)) ),
    'kernel32.setprocessdeppolicy':( 'int', None, 'stdcall', 'kernel32.SetProcessDEPPolicy', (('int', None),) ),
    'kernel32.setprocesspriorityboost':( 'int', None, 'stdcall', 'kernel32.SetProcessPriorityBoost', (('int', None), ('int', None)) ),
    'kernel32.setprocessshutdownparameters':( 'int', None, 'stdcall', 'kernel32.SetProcessShutdownParameters', (('int', None), ('int', None)) ),
    'kernel32.setprocessworkingsetsize':( 'int', None, 'stdcall', 'kernel32.SetProcessWorkingSetSize', (('int', None), ('void *', 'ptr'), ('int', None)) ),
    'kernel32.setsearchpathmode':( 'int', None, 'stdcall', 'kernel32.SetSearchPathMode', (('int', None),) ),
    'kernel32.setstdhandle':( 'int', None, 'stdcall', 'kernel32.SetStdHandle', (('int', None), ('int', None)) ),
    'kernel32.setsystempowerstate':( 'int', None, 'stdcall', 'kernel32.SetSystemPowerState', (('int', None), ('int', None)) ),
    'kernel32.setsystemtime':( 'int', None, 'stdcall', 'kernel32.SetSystemTime', (('void *', 'ptr'),) ),
    'kernel32.setsystemtimeadjustment':( 'int', None, 'stdcall', 'kernel32.SetSystemTimeAdjustment', (('int', None), ('int', None)) ),
    'kernel32.settapeparameters':( 'int', None, 'stdcall', 'kernel32.SetTapeParameters', (('int', None), ('int', None), ('void *', 'ptr')) ),
    'kernel32.settapeposition':( 'int', None, 'stdcall', 'kernel32.SetTapePosition', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.settermsrvappinstallmode':( 'int', None, 'stdcall', 'kernel32.SetTermsrvAppInstallMode', (('int', None),) ),
    'kernel32.setthreadaffinitymask':( 'int', None, 'stdcall', 'kernel32.SetThreadAffinityMask', (('int', None), ('int', None)) ),
    'kernel32.setthreadcontext':( 'int', None, 'stdcall', 'kernel32.SetThreadContext', (('int', None), ('int', None)) ),
    'kernel32.setthreadexecutionstate':( 'int', None, 'stdcall', 'kernel32.SetThreadExecutionState', (('int', None),) ),
    'kernel32.setthreadidealprocessor':( 'int', None, 'stdcall', 'kernel32.SetThreadIdealProcessor', (('int', None), ('int', None)) ),
    'kernel32.setthreadlocale':( 'int', None, 'stdcall', 'kernel32.SetThreadLocale', (('int', None),) ),
    'kernel32.setthreadpriority':( 'int', None, 'stdcall', 'kernel32.SetThreadPriority', (('int', None), ('int', None)) ),
    'kernel32.setthreadpriorityboost':( 'int', None, 'stdcall', 'kernel32.SetThreadPriorityBoost', (('int', None), ('int', None)) ),
    'kernel32.setthreaduilanguage':( 'int', None, 'stdcall', 'kernel32.SetThreadUILanguage', (('int', None),) ),
    'kernel32.settimezoneinformation':( 'int', None, 'stdcall', 'kernel32.SetTimeZoneInformation', ( ('int', None),) ),
    'kernel32.settimerqueuetimer':( 'int', None, 'stdcall', 'kernel32.SetTimerQueueTimer', ( ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.setunhandledexceptionfilter':( 'int', None, 'stdcall', 'kernel32.SetUnhandledExceptionFilter', (('int', None),) ),
    'kernel32.setusergeoid':( 'int', None, 'stdcall', 'kernel32.SetUserGeoID', (('int', None),) ),
    'kernel32.setvdmcurrentdirectories':( 'int', None, 'stdcall', 'kernel32.SetVDMCurrentDirectories', (('int', None), ('int', None)) ),
    'kernel32.setvolumelabela':( 'int', None, 'stdcall', 'kernel32.SetVolumeLabelA', (('int', None), ('int', None)) ),
    'kernel32.setvolumelabelw':( 'int', None, 'stdcall', 'kernel32.SetVolumeLabelW', (('int', None), ('int', None)) ),
    'kernel32.setvolumemountpointa':( 'int', None, 'stdcall', 'kernel32.SetVolumeMountPointA', (('int', None), ('int', None)) ),
    'kernel32.setvolumemountpointw':( 'int', None, 'stdcall', 'kernel32.SetVolumeMountPointW', (('int', None), ('int', None)) ),
    'kernel32.setwaitabletimer':( 'int', None, 'stdcall', 'kernel32.SetWaitableTimer', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.setupcomm':( 'int', None, 'stdcall', 'kernel32.SetupComm', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.showconsolecursor':( 'int', None, 'stdcall', 'kernel32.ShowConsoleCursor', (('int', None), ('int', None)) ),
    'kernel32.signalobjectandwait':( 'int', None, 'stdcall', 'kernel32.SignalObjectAndWait', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.sizeofresource':( 'int', None, 'stdcall', 'kernel32.SizeofResource', (('int', None), ('int', None)) ),
    'kernel32.sleep':( 'int', None, 'stdcall', 'kernel32.Sleep', (('int', None),) ),
    'kernel32.sleepex':( 'int', None, 'stdcall', 'kernel32.SleepEx', (('int', None), ('int', None)) ),
    'kernel32.suspendthread':( 'int', None, 'stdcall', 'kernel32.SuspendThread', (('int', None),) ),
    'kernel32.switchtofiber':( 'int', None, 'cdecl', 'kernel32.SwitchToFiber', (('int', None),) ),
    'kernel32.switchtothread':( 'int', None, 'stdcall', 'kernel32.SwitchToThread', () ),
    'kernel32.systemtimetofiletime':( 'int', None, 'stdcall', 'kernel32.SystemTimeToFileTime', (('void *', 'ptr'), ('void *', 'ptr')) ),
    'kernel32.systemtimetotzspecificlocaltime':( 'int', None, 'stdcall', 'kernel32.SystemTimeToTzSpecificLocalTime', (('void *', 'ptr'), ('void *', 'ptr'), ('int', None)) ),
    'kernel32.terminatejobobject':( 'int', None, 'stdcall', 'kernel32.TerminateJobObject', (('int', None), ('int', None)) ),
    'kernel32.terminateprocess':( 'int', None, 'stdcall', 'kernel32.TerminateProcess', (('int', None), ('int', None)) ),
    'kernel32.terminatethread':( 'int', None, 'stdcall', 'kernel32.TerminateThread', (('int', None), ('int', None)) ),
    'kernel32.termsrvappinstallmode':( 'int', None, 'cdecl', 'kernel32.TermsrvAppInstallMode', () ),
    'kernel32.thread32first':( 'int', None, 'stdcall', 'kernel32.Thread32First', (('int', None), ('int', None)) ),
    'kernel32.thread32next':( 'int', None, 'stdcall', 'kernel32.Thread32Next', (('int', None), ('int', None)) ),
    'kernel32.tlsalloc':( 'int', None, 'cdecl', 'kernel32.TlsAlloc', () ),
    'kernel32.tlsfree':( 'int', None, 'stdcall', 'kernel32.TlsFree', (('int', None),) ),
    'kernel32.tlsgetvalue':( 'int', None, 'stdcall', 'kernel32.TlsGetValue', (('int', None),) ),
    'kernel32.tlssetvalue':( 'int', None, 'stdcall', 'kernel32.TlsSetValue', (('int', None), ('int', None)) ),
    'kernel32.toolhelp32readprocessmemory':( 'int', None, 'stdcall', 'kernel32.Toolhelp32ReadProcessMemory', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None), ('int', None)) ),
    'kernel32.transactnamedpipe':( 'int', None, 'stdcall', 'kernel32.TransactNamedPipe', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.transmitcommchar':( 'int', None, 'stdcall', 'kernel32.TransmitCommChar', (('int', None), ('int', None)) ),
    'kernel32.trimvirtualbuffer':( 'int', None, 'stdcall', 'kernel32.TrimVirtualBuffer', (('int', None),) ),
    'kernel32.tzspecificlocaltimetosystemtime':( 'int', None, 'stdcall', 'kernel32.TzSpecificLocalTimeToSystemTime', (('void *', 'ptr'), ('int', None), ('int', None)) ),
    'kernel32.utregister':( 'int', None, 'stdcall', 'kernel32.UTRegister', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.utunregister':( 'int', None, 'stdcall', 'kernel32.UTUnRegister', (('int', None),) ),
    'kernel32.unhandledexceptionfilter':( 'int', None, 'stdcall', 'kernel32.UnhandledExceptionFilter', (('int', None),) ),
    'kernel32.unlockfile':( 'int', None, 'stdcall', 'kernel32.UnlockFile', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.unlockfileex':( 'int', None, 'stdcall', 'kernel32.UnlockFileEx', (('int', None), ('int', None), ('int', None), ('int', None), ('void *', 'ptr')) ),
    'kernel32.unmapviewoffile':( 'int', None, 'stdcall', 'kernel32.UnmapViewOfFile', (('int', None),) ),
    'kernel32.unregisterconsoleime':( 'int', None, 'cdecl', 'kernel32.UnregisterConsoleIME', () ),
    'kernel32.unregisterwait':( 'int', None, 'stdcall', 'kernel32.UnregisterWait', (('void *', 'ptr'),) ),
    'kernel32.unregisterwaitex':( 'int', None, 'stdcall', 'kernel32.UnregisterWaitEx', (('void *', 'ptr'), ('int', None)) ),
    'kernel32.updateresourcea':( 'int', None, 'stdcall', 'kernel32.UpdateResourceA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('DWORD', None)) ),
    'kernel32.updateresourcew':( 'int', None, 'stdcall', 'kernel32.UpdateResourceW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None), ('DWORD', None)) ),
    'kernel32.vdmconsoleoperation':( 'int', None, 'stdcall', 'kernel32.VDMConsoleOperation', (('int', None), ('int', None)) ),
    'kernel32.vdmoperationstarted':( 'int', None, 'stdcall', 'kernel32.VDMOperationStarted', (('int', None),) ),
    'kernel32.validatelctype':( 'int', None, 'stdcall', 'kernel32.ValidateLCType', (('int', None), ('int', None), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'kernel32.validatelocale':( 'int', None, 'stdcall', 'kernel32.ValidateLocale', (('int', None),) ),
    'kernel32.verlanguagenamea':( 'int', None, 'stdcall', 'kernel32.VerLanguageNameA', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.verlanguagenamew':( 'int', None, 'stdcall', 'kernel32.VerLanguageNameW', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.verifyconsoleiohandle':( 'int', None, 'stdcall', 'kernel32.VerifyConsoleIoHandle', (('int', None),) ),
    'kernel32.verifyversioninfoa':( 'int', None, 'stdcall', 'kernel32.VerifyVersionInfoA', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.verifyversioninfow':( 'int', None, 'stdcall', 'kernel32.VerifyVersionInfoW', (('void *', 'ptr'), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.virtualalloc':( 'int', None, 'stdcall', 'kernel32.VirtualAlloc', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.virtualallocex':( 'int', None, 'stdcall', 'kernel32.VirtualAllocEx', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.virtualbufferexceptionhandler':( 'int', None, 'stdcall', 'kernel32.VirtualBufferExceptionHandler', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.virtualfree':( 'int', None, 'stdcall', 'kernel32.VirtualFree', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.virtualfreeex':( 'int', None, 'stdcall', 'kernel32.VirtualFreeEx', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.virtuallock':( 'int', None, 'stdcall', 'kernel32.VirtualLock', (('int', None), ('int', None)) ),
    'kernel32.virtualprotect':( 'int', None, 'stdcall', 'kernel32.VirtualProtect', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.virtualprotectex':( 'int', None, 'stdcall', 'kernel32.VirtualProtectEx', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.virtualquery':( 'int', None, 'stdcall', 'kernel32.VirtualQuery', (('int', None), ('void *', 'ptr'), ('int', None)) ),
    'kernel32.virtualqueryex':( 'int', None, 'stdcall', 'kernel32.VirtualQueryEx', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.virtualunlock':( 'int', None, 'stdcall', 'kernel32.VirtualUnlock', (('int', None), ('int', None)) ),
    'kernel32.wtsgetactiveconsolesessionid':( 'int', None, 'cdecl', 'kernel32.WTSGetActiveConsoleSessionId', () ),
    'kernel32.waitcommevent':( 'int', None, 'stdcall', 'kernel32.WaitCommEvent', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.waitfordebugevent':( 'int', None, 'stdcall', 'kernel32.WaitForDebugEvent', (('int', None), ('int', None)) ),
    'kernel32.waitformultipleobjects':( 'int', None, 'stdcall', 'kernel32.WaitForMultipleObjects', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.waitformultipleobjectsex':( 'int', None, 'stdcall', 'kernel32.WaitForMultipleObjectsEx', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.waitforsingleobject':( 'int', None, 'stdcall', 'kernel32.WaitForSingleObject', (('int', None), ('int', None)) ),
    'kernel32.waitforsingleobjectex':( 'int', None, 'stdcall', 'kernel32.WaitForSingleObjectEx', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.waitnamedpipea':( 'int', None, 'stdcall', 'kernel32.WaitNamedPipeA', ( ('int', None), ('int', None)) ),
    'kernel32.waitnamedpipew':( 'int', None, 'stdcall', 'kernel32.WaitNamedPipeW', (('int', None), ('int', None)) ),
    'kernel32.widechartomultibyte':( 'int', None, 'stdcall', 'kernel32.WideCharToMultiByte', (('int', None), ('int', None), ('void *', 'obj'), ('int', None), ('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('void *', 'ptr')) ),
    'kernel32.winexec':( 'int', None, 'stdcall', 'kernel32.WinExec', (('int', None), ('int', None)) ),
    'kernel32.writeconsolea':( 'int', None, 'stdcall', 'kernel32.WriteConsoleA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.writeconsoleinputa':( 'int', None, 'stdcall', 'kernel32.WriteConsoleInputA', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.writeconsoleinputvdma':( 'int', None, 'stdcall', 'kernel32.WriteConsoleInputVDMA', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.writeconsoleinputvdmw':( 'int', None, 'stdcall', 'kernel32.WriteConsoleInputVDMW', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.writeconsoleinputw':( 'int', None, 'stdcall', 'kernel32.WriteConsoleInputW', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.writeconsoleoutputa':( 'int', None, 'stdcall', 'kernel32.WriteConsoleOutputA', (('int', None), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.writeconsoleoutputattribute':( 'int', None, 'stdcall', 'kernel32.WriteConsoleOutputAttribute', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.writeconsoleoutputcharactera':( 'int', None, 'stdcall', 'kernel32.WriteConsoleOutputCharacterA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.writeconsoleoutputcharacterw':( 'int', None, 'stdcall', 'kernel32.WriteConsoleOutputCharacterW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.writeconsoleoutputw':( 'int', None, 'stdcall', 'kernel32.WriteConsoleOutputW', (('int', None), ('void *', 'ptr'), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.writeconsolew':( 'int', None, 'stdcall', 'kernel32.WriteConsoleW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.writefile':( 'int', None, 'stdcall', 'kernel32.WriteFile', (('int', None), ('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'kernel32.writefileex':( 'int', None, 'stdcall', 'kernel32.WriteFileEx', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.writefilegather':( 'int', None, 'stdcall', 'kernel32.WriteFileGather', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.writeprivateprofilesectiona':( 'int', None, 'stdcall', 'kernel32.WritePrivateProfileSectionA', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.writeprivateprofilesectionw':( 'int', None, 'stdcall', 'kernel32.WritePrivateProfileSectionW', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.writeprivateprofilestringa':( 'int', None, 'stdcall', 'kernel32.WritePrivateProfileStringA', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'kernel32.writeprivateprofilestringw':( 'int', None, 'stdcall', 'kernel32.WritePrivateProfileStringW', (('int', None), ('int', None), ('void *', 'ptr'), ('int', None)) ),
    'kernel32.writeprivateprofilestructa':( 'int', None, 'stdcall', 'kernel32.WritePrivateProfileStructA', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.writeprivateprofilestructw':( 'int', None, 'stdcall', 'kernel32.WritePrivateProfileStructW', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.writeprocessmemory':( 'int', None, 'stdcall', 'kernel32.WriteProcessMemory', (('int', None), ('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.writeprofilesectiona':( 'int', None, 'stdcall', 'kernel32.WriteProfileSectionA', (('int', None), ('int', None)) ),
    'kernel32.writeprofilesectionw':( 'int', None, 'stdcall', 'kernel32.WriteProfileSectionW', (('int', None), ('int', None)) ),
    'kernel32.writeprofilestringa':( 'int', None, 'stdcall', 'kernel32.WriteProfileStringA', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.writeprofilestringw':( 'int', None, 'stdcall', 'kernel32.WriteProfileStringW', (('int', None), ('int', None), ('void *', 'ptr')) ),
    'kernel32.writetapemark':( 'int', None, 'stdcall', 'kernel32.WriteTapemark', (('int', None), ('int', None), ('int', None), ('int', None)) ),
    'kernel32.zombifyactctx':( 'int', None, 'stdcall', 'kernel32.ZombifyActCtx', (('int', None),) ),
    'kernel32._hread':( 'int', None, 'stdcall', 'kernel32._hread', (('int', None), ('void *', 'ptr'), ('int', None)) ),
    'kernel32._hwrite':( 'int', None, 'stdcall', 'kernel32._hwrite', (('int', None), ('void *', 'ptr'), ('int', None)) ),
    'kernel32._lclose':( 'int', None, 'stdcall', 'kernel32._lclose', (('int', None),) ),
    'kernel32._lcreat':( 'int', None, 'stdcall', 'kernel32._lcreat', (('int', None), ('int', None)) ),
    'kernel32._llseek':( 'int', None, 'stdcall', 'kernel32._llseek', (('int', None), ('int', None), ('int', None)) ),
    'kernel32._lopen':( 'int', None, 'stdcall', 'kernel32._lopen', (('int', None), ('int', None)) ),
    'kernel32._lread':( 'int', None, 'stdcall', 'kernel32._lread', (('int', None), ('void *', 'ptr'), ('int', None)) ),
    'kernel32._lwrite':( 'int', None, 'stdcall', 'kernel32._lwrite', (('int', None), ('void *', 'ptr'), ('int', None)) ),
    'kernel32.lstrcat':( 'int', None, 'stdcall', 'kernel32.lstrcat', (('int', None), ('int', None)) ),
    'kernel32.lstrcata':( 'int', None, 'stdcall', 'kernel32.lstrcatA', (('int', None), ('int', None)) ),
    'kernel32.lstrcatw':( 'int', None, 'stdcall', 'kernel32.lstrcatW', (('int', None), ('void *', 'ptr')) ),
    'kernel32.lstrcmp':( 'int', None, 'stdcall', 'kernel32.lstrcmp', (('void *', 'ptr'), ('int', None)) ),
    'kernel32.lstrcmpa':( 'int', None, 'stdcall', 'kernel32.lstrcmpA', (('void *', 'ptr'), ('int', None)) ),
    'kernel32.lstrcmpw':( 'int', None, 'stdcall', 'kernel32.lstrcmpW', (('void *', 'ptr'), ('void *', 'ptr')) ),
    'kernel32.lstrcmpi':( 'int', None, 'stdcall', 'kernel32.lstrcmpi', (('int', None), ('int', None)) ),
    'kernel32.lstrcmpia':( 'int', None, 'stdcall', 'kernel32.lstrcmpiA', (('int', None), ('int', None)) ),
    'kernel32.lstrcmpiw':( 'int', None, 'stdcall', 'kernel32.lstrcmpiW', (('int', None), ('int', None)) ),
    'kernel32.lstrcpy':( 'int', None, 'stdcall', 'kernel32.lstrcpy', (('int', None), ('int', None)) ),
    'kernel32.lstrcpya':( 'int', None, 'stdcall', 'kernel32.lstrcpyA', (('int', None), ('int', None)) ),
    'kernel32.lstrcpyw':( 'int', None, 'stdcall', 'kernel32.lstrcpyW', (('int', None), ('int', None)) ),
    'kernel32.lstrcpyn':( 'int', None, 'stdcall', 'kernel32.lstrcpyn', (('void *', 'ptr'), ('int', None), ('int', None)) ),
    'kernel32.lstrcpyna':( 'int', None, 'stdcall', 'kernel32.lstrcpynA', (('void *', 'ptr'), ('int', None), ('int', None)) ),
    'kernel32.lstrcpynw':( 'int', None, 'stdcall', 'kernel32.lstrcpynW', (('int', None), ('int', None), ('int', None)) ),
    'kernel32.lstrlen':( 'int', None, 'stdcall', 'kernel32.lstrlen', (('int', None),) ),
    'kernel32.lstrlena':( 'int', None, 'stdcall', 'kernel32.lstrlenA', (('int', None),) ),
    'kernel32.lstrlenw':( 'int', None, 'stdcall', 'kernel32.lstrlenW', (('int', None),) ),
    # These functions are forwarded to ntdll functions.
    'kernel32.addvectoredexceptionhandler':('int', None, 'stdcall', 'ntdll.RtlAddVectoredExceptionHandler', ( ('int', None), ('int', None))),
    'kernel32.decodepointer':('int', None, 'stdcall', 'ntdll.RtlDecodePointer', (('int', None),)),
    'kernel32.decodesystempointer':('int', None, 'stdcall', 'ntdll.RtlDecodeSystemPointer', (('int', None),)),
    'kernel32.deletecriticalsection':('int', None, 'stdcall', 'ntdll.RtlDeleteCriticalSection', (('int', None),) ),
    'kernel32.encodepointer':('int', None, 'stdcall', 'ntdll.RtlEncodePointer', (('int', None),)),
    'kernel32.encodesystempointer':('int', None, 'stdcall', 'ntdll.RtlEncodeSystemPointer', (('int', None),)),
    'kernel32.entercriticalsection':('int', None, 'stdcall', 'ntdll.RtlEnterCriticalSection', (('int', None),)),
    'kernel32.getlasterror':('int', None, 'cdecl', 'ntdll.RtlGetLastWin32Error', ()),
    'kernel32.heapalloc':('int', None, 'stdcall', 'ntdll.RtlAllocateHeap', (('void *', 'ptr'), ('int', None), ('int', None))),
    'kernel32.heapfree':('int', None, 'stdcall', 'ntdll.RtlFreeHeap', (('void *', 'ptr'), ('int', None), ('void *', 'ptr'))),
    'kernel32.heaprealloc':('int', None, 'stdcall', 'ntdll.RtlReAllocateHeap', ( ('void *', 'ptr'), ('int', None), ('void *', 'ptr'), ('int', None))),
    'kernel32.heapsize':('int', None, 'stdcall', 'ntdll.RtlSizeHeap', ( ('void *', 'ptr'), ('int', None), ('int', None))),
    'kernel32.initializeslisthead':('int', None, 'stdcall', 'ntdll.RtlInitializeSListHead', (('int', None),)),
    'kernel32.interlockedflushslist':('int', None, 'stdcall', 'ntdll.RtlInterlockedFlushSList', ()),
    'kernel32.interlockedpopentryslist':('int', None, 'stdcall', 'ntdll.RtlInterlockedPopEntrySList', ()),
    'kernel32.interlockedpushentryslist':('int', None, 'stdcall', 'ntdll.RtlInterlockedPushEntrySList', (('int', None), ('int', None))),
    'kernel32.leavecriticalsection':('int', None, 'stdcall', 'ntdll.RtlLeaveCriticalSection', ( ('int', None),)),
    'kernel32.querydepthslist':('int', None, 'stdcall', 'ntdll.RtlQueryDepthSList', (('int', None),)),
    'kernel32.removevectoredexceptionhandler':('int', None, 'stdcall', 'ntdll.RtlRemoveVectoredExceptionHandler', ( ('int', None),)),
    'kernel32.restorelasterror':('int', None, 'stdcall', 'ntdll.RtlRestoreLastWin32Error', (('int', None),)),
    'kernel32.rtlcapturecontext':('int', None, 'stdcall', 'ntdll.RtlCaptureContext', (('void *', 'ptr'),)),
    'kernel32.rtlcapturestackbacktrace':('int', None, 'stdcall', 'ntdll.RtlCaptureStackBackTrace', (('int', None), ('int', None), ('void *', 'ptr'), ('void *', 'ptr'))),
    'kernel32.rtlfillmemory':('int', None, 'stdcall', 'ntdll.RtlFillMemory', (('int', None), ('int', None), ('int', None))),
    'kernel32.initializecriticalsection':( 'int', None, 'stdcall', 'ntdll.RtlInitializeCriticalSection', (('int', None),) ),
    'kernel32.rtlmovememory':('int', None, 'stdcall', 'ntdll.RtlMoveMemory', (('int', None), ('int', None), ('int', None))),
    'kernel32.rtlunwind':('int', None, 'stdcall', 'ntdll.RtlUnwind', (('int', None), ('int', None), ('int', None), ('int', None))),
    'kernel32.rtlzeromemory':('int', None, 'stdcall', 'ntdll.RtlZeroMemory', (('int', None), ('int', None))),
    'kernel32.setcriticalsectionspincount':('int', None, 'stdcall', 'ntdll.RtlSetCriticalSectionSpinCount', (('int', None), ('int', None))),
    'kernel32.setlasterror':('int', None, 'stdcall', 'ntdll.RtlSetLastWin32Error', (('int', None),)),
    'kernel32.tryentercriticalsection':('int', None, 'stdcall', 'ntdll.RtlTryEnterCriticalSection', (('int', None),)),
    'kernel32.versetconditionmask':('int', None, 'stdcall', 'ntdll.VerSetConditionMask', (('int', None), ('int', None), ('int', None), ('int', None))),
    }
