"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.StaticWebsite = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cloudfront_1 = require("@aws-cdk/aws-cloudfront");
const aws_route53_targets_1 = require("@aws-cdk/aws-route53-targets");
const core_1 = require("@aws-cdk/core");
const website_alias_record_1 = require("./website-alias-record");
const website_bucket_1 = require("./website-bucket");
class StaticWebsite extends core_1.Construct {
    constructor(scope, id, props = {}) {
        super(scope, id);
        const { aliasConfiguration, bucketConfiguration, webACLId, disableIPv6, errorConfigurations } = props;
        const websiteBucket = new website_bucket_1.WebsiteBucket(this, 'Bucket', {
            ...bucketConfiguration,
        });
        const distibutionConfig = {
            webACLId,
            enableIpV6: !disableIPv6,
            originConfigs: [
                {
                    s3OriginSource: {
                        ...websiteBucket.s3OriginConfig,
                    },
                    behaviors: [{ isDefaultBehavior: true }],
                },
            ],
            aliasConfiguration,
            errorConfigurations,
        };
        this.distribution = new aws_cloudfront_1.CloudFrontWebDistribution(this, 'Distribution', distibutionConfig);
        if (aliasConfiguration) {
            new website_alias_record_1.WebsiteAliasRecord(this, 'AliasRecord', {
                domainName: aliasConfiguration.domainName,
                recordNames: aliasConfiguration.names,
                target: new aws_route53_targets_1.CloudFrontTarget(this.distribution),
                disableIPv6,
                privateZone: aliasConfiguration.privateZone,
                vpcId: aliasConfiguration.vpcId,
            });
        }
    }
    addLambdaFunctionAssociation(assosiation) {
        this.addLambdaFunctionAssociations([assosiation]);
    }
    addLambdaFunctionAssociations(assosiations) {
        const cfDist = this.distribution.node.findChild('CFDistribution');
        cfDist.addOverride('Properties.DistributionConfig.DefaultCacheBehavior.LambdaFunctionAssociations', assosiations.map((assosiation) => ({
            EventType: assosiation.eventType,
            LambdaFunctionARN: assosiation.lambdaFunction.functionArn,
        })));
    }
}
exports.StaticWebsite = StaticWebsite;
_a = JSII_RTTI_SYMBOL_1;
StaticWebsite[_a] = { fqn: "@cloudcomponents/cdk-static-website.StaticWebsite", version: "1.26.0" };
//# sourceMappingURL=data:application/json;base64,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