#include "../../../lv_examples.h"
#if LV_USE_IMG

LV_IMG_DECLARE(img_cogwheel_argb);

void lv_ex_img_3(void)
{
    /* Now create the actual image */
    lv_obj_t * img = lv_img_create(lv_scr_act(), NULL);
    lv_img_set_src(img, &img_cogwheel_argb);
    lv_obj_align(img, NULL, LV_ALIGN_CENTER, 50, 50);
    lv_img_set_pivot(img, 0, 0);    /*Rotate around the top left corner*/

    lv_anim_t a;
    lv_anim_init(&a);
    lv_anim_set_var(&a, img);
    lv_anim_set_exec_cb(&a, (lv_anim_exec_xcb_t)lv_img_set_angle);
    lv_anim_set_values(&a, 0, 3600);
    lv_anim_set_time(&a, 5000);
    lv_anim_set_repeat_count(&a, LV_ANIM_REPEAT_INFINITE);
    lv_anim_start(&a);

    lv_anim_set_exec_cb(&a, (lv_anim_exec_xcb_t)lv_img_set_zoom);
    lv_anim_set_values(&a, 128, 400);
    lv_anim_set_playback_time(&a, 1000);
    lv_anim_start(&a);

}

#endif
