#!/usr/bin/env python

# Copyright (c) 2019, Ulf Magnusson
# SPDX-License-Identifier: ISC

"""
Reads a specified configuration file, then writes a new configuration file.
This can be used to initialize the configuration from e.g. an arch-specific
configuration file. This input configuration file would usually be a minimal
configuration file, as generated by e.g. savedefconfig.

The default output filename is '.config'. A different filename can be passed in
the KCONFIG_CONFIG environment variable.
"""
import argparse

import kconfiglib


def main():
    parser = argparse.ArgumentParser(
        formatter_class=argparse.RawDescriptionHelpFormatter,
        description=__doc__)

    parser.add_argument(
        "--kconfig",
        default="Kconfig",
        help="Base Kconfig file (default: Kconfig)")

    parser.add_argument(
        "config",
        metavar="CONFIGURATION",
        help="Input configuration file")

    args = parser.parse_args()

    kconf = kconfiglib.Kconfig(args.kconfig)
    print(kconf.load_config(args.config))
    print(kconf.write_config())


if __name__ == "__main__":
    main()
