# autogenerated module
from typing import List, Optional, TYPE_CHECKING

from ._schema import dataclass, field, DictMixin

if TYPE_CHECKING:   # Fix for pycharm autocompletion https://youtrack.jetbrains.com/issue/PY-54560
    from dataclasses import dataclass, field



@dataclass
class Info(DictMixin):
    r"""Info contains versioning information. how we'll want to distribute that
      information.

      **parameters**

      * **buildDate** ``str`` - 
      * **compiler** ``str`` - 
      * **gitCommit** ``str`` - 
      * **gitTreeState** ``str`` - 
      * **gitVersion** ``str`` - 
      * **goVersion** ``str`` - 
      * **major** ``str`` - Major is the major version of the binary version
      * **minor** ``str`` - Minor is the minor version of the binary version
      * **platform** ``str`` - 
      * **emulationMajor** ``Optional[str]`` - EmulationMajor is the major version of the emulation version
      * **emulationMinor** ``Optional[str]`` - EmulationMinor is the minor version of the emulation version
      * **minCompatibilityMajor** ``Optional[str]`` - MinCompatibilityMajor is the major version of the minimum compatibility
        version
      * **minCompatibilityMinor** ``Optional[str]`` - MinCompatibilityMinor is the minor version of the minimum compatibility
        version
    """
    buildDate: 'str'
    compiler: 'str'
    gitCommit: 'str'
    gitTreeState: 'str'
    gitVersion: 'str'
    goVersion: 'str'
    major: 'str'
    minor: 'str'
    platform: 'str'
    emulationMajor: 'Optional[str]' = None
    emulationMinor: 'Optional[str]' = None
    minCompatibilityMajor: 'Optional[str]' = None
    minCompatibilityMinor: 'Optional[str]' = None


