# autogenerated module
from typing import List, Optional, TYPE_CHECKING

from ._schema import dataclass, field, DictMixin

if TYPE_CHECKING:   # Fix for pycharm autocompletion https://youtrack.jetbrains.com/issue/PY-54560
    from dataclasses import dataclass, field

from . import meta_v1


@dataclass
class GroupVersionResource(DictMixin):
    r"""The names of the group, the version, and the resource.

      **parameters**

      * **group** ``Optional[str]`` - The name of the group.
      * **resource** ``Optional[str]`` - The name of the resource.
      * **version** ``Optional[str]`` - The name of the version.
    """
    group: 'Optional[str]' = None
    resource: 'Optional[str]' = None
    version: 'Optional[str]' = None


@dataclass
class MigrationCondition(DictMixin):
    r"""Describes the state of a migration at a certain point.

      **parameters**

      * **status** ``str`` - Status of the condition, one of True, False, Unknown.
      * **type** ``str`` - Type of the condition.
      * **lastUpdateTime** ``Optional[meta_v1.Time]`` - The last time this condition was updated.
      * **message** ``Optional[str]`` - A human readable message indicating details about the transition.
      * **reason** ``Optional[str]`` - The reason for the condition's last transition.
    """
    status: 'str'
    type: 'str'
    lastUpdateTime: 'Optional[meta_v1.Time]' = None
    message: 'Optional[str]' = None
    reason: 'Optional[str]' = None


@dataclass
class StorageVersionMigration(DictMixin):
    r"""StorageVersionMigration represents a migration of stored data to the latest
      storage version.

      **parameters**

      * **apiVersion** ``Optional[str]`` - APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **kind** ``Optional[str]`` - Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``Optional[meta_v1.ObjectMeta]`` - Standard object metadata. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
      * **spec** ``Optional[StorageVersionMigrationSpec]`` - Specification of the migration.
      * **status** ``Optional[StorageVersionMigrationStatus]`` - Status of the migration.
    """
    apiVersion: 'Optional[str]' = None
    kind: 'Optional[str]' = None
    metadata: 'Optional[meta_v1.ObjectMeta]' = None
    spec: 'Optional[StorageVersionMigrationSpec]' = None
    status: 'Optional[StorageVersionMigrationStatus]' = None

    def __post_init__(self):
        self.apiVersion = 'storagemigration.k8s.io/v1alpha1'
        self.kind = 'StorageVersionMigration'


@dataclass
class StorageVersionMigrationList(DictMixin):
    r"""StorageVersionMigrationList is a collection of storage version migrations.

      **parameters**

      * **items** ``List[StorageVersionMigration]`` - Items is the list of StorageVersionMigration
      * **apiVersion** ``Optional[str]`` - APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **kind** ``Optional[str]`` - Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``Optional[meta_v1.ListMeta]`` - Standard list metadata More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
    """
    items: 'List[StorageVersionMigration]'
    apiVersion: 'Optional[str]' = None
    kind: 'Optional[str]' = None
    metadata: 'Optional[meta_v1.ListMeta]' = None

    def __post_init__(self):
        self.apiVersion = 'storagemigration.k8s.io/v1alpha1'
        self.kind = 'StorageVersionMigrationList'


@dataclass
class StorageVersionMigrationSpec(DictMixin):
    r"""Spec of the storage version migration.

      **parameters**

      * **resource** ``GroupVersionResource`` - The resource that is being migrated. The migrator sends requests to the
        endpoint serving the resource. Immutable.
      * **continueToken** ``Optional[str]`` - The token used in the list options to get the next chunk of objects to
        migrate. When the .status.conditions indicates the migration is "Running",
        users can use this token to check the progress of the migration.
    """
    resource: 'GroupVersionResource'
    continueToken: 'Optional[str]' = None


@dataclass
class StorageVersionMigrationStatus(DictMixin):
    r"""Status of the storage version migration.

      **parameters**

      * **conditions** ``Optional[List[MigrationCondition]]`` - The latest available observations of the migration's current state.
      * **resourceVersion** ``Optional[str]`` - ResourceVersion to compare with the GC cache for performing the migration.
        This is the current resource version of given group, version and resource when
        kube-controller-manager first observes this StorageVersionMigration resource.
    """
    conditions: 'Optional[List[MigrationCondition]]' = None
    resourceVersion: 'Optional[str]' = None


