# autogenerated module
from typing import List, Optional, TYPE_CHECKING

from ._schema import dataclass, field, DictMixin

if TYPE_CHECKING:   # Fix for pycharm autocompletion https://youtrack.jetbrains.com/issue/PY-54560
    from dataclasses import dataclass, field

from . import meta_v1
from . import resource
from . import core_v1


@dataclass
class CSIDriver(DictMixin):
    r"""CSIDriver captures information about a Container Storage Interface (CSI)
      volume driver deployed on the cluster. Kubernetes attach detach controller
      uses this object to determine whether attach is required. Kubelet uses this
      object to determine whether pod information needs to be passed on mount.
      CSIDriver objects are non-namespaced.

      **parameters**

      * **spec** ``CSIDriverSpec`` - spec represents the specification of the CSI Driver.
      * **apiVersion** ``Optional[str]`` - APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **kind** ``Optional[str]`` - Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``Optional[meta_v1.ObjectMeta]`` - Standard object metadata. metadata.Name indicates the name of the CSI driver
        that this object refers to; it MUST be the same name returned by the CSI
        GetPluginName() call for that driver. The driver name must be 63 characters or
        less, beginning and ending with an alphanumeric character ([a-z0-9A-Z]) with
        dashes (-), dots (.), and alphanumerics between. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
    """
    spec: 'CSIDriverSpec'
    apiVersion: 'Optional[str]' = None
    kind: 'Optional[str]' = None
    metadata: 'Optional[meta_v1.ObjectMeta]' = None

    def __post_init__(self):
        self.apiVersion = 'storage.k8s.io/v1'
        self.kind = 'CSIDriver'


@dataclass
class CSIDriverList(DictMixin):
    r"""CSIDriverList is a collection of CSIDriver objects.

      **parameters**

      * **items** ``List[CSIDriver]`` - items is the list of CSIDriver
      * **apiVersion** ``Optional[str]`` - APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **kind** ``Optional[str]`` - Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``Optional[meta_v1.ListMeta]`` - Standard list metadata More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
    """
    items: 'List[CSIDriver]'
    apiVersion: 'Optional[str]' = None
    kind: 'Optional[str]' = None
    metadata: 'Optional[meta_v1.ListMeta]' = None

    def __post_init__(self):
        self.apiVersion = 'storage.k8s.io/v1'
        self.kind = 'CSIDriverList'


@dataclass
class CSIDriverSpec(DictMixin):
    r"""CSIDriverSpec is the specification of a CSIDriver.

      **parameters**

      * **attachRequired** ``Optional[bool]`` - attachRequired indicates this CSI volume driver requires an attach operation
        (because it implements the CSI ControllerPublishVolume() method), and that the
        Kubernetes attach detach controller should call the attach volume interface
        which checks the volumeattachment status and waits until the volume is
        attached before proceeding to mounting. The CSI external-attacher coordinates
        with CSI volume driver and updates the volumeattachment status when the attach
        operation is complete. If the CSIDriverRegistry feature gate is enabled and
        the value is specified to false, the attach operation will be skipped.
        Otherwise the attach operation will be called.
        This field is immutable.
      * **fsGroupPolicy** ``Optional[str]`` - fsGroupPolicy defines if the underlying volume supports changing ownership and
        permission of the volume before being mounted. Refer to the specific
        FSGroupPolicy values for additional details.
        This field was immutable in Kubernetes < 1.29 and now is mutable.
        Defaults to ReadWriteOnceWithFSType, which will examine each volume to
        determine if Kubernetes should modify ownership and permissions of the volume.
        With the default policy the defined fsGroup will only be applied if a fstype
        is defined and the volume's access mode contains ReadWriteOnce.
      * **nodeAllocatableUpdatePeriodSeconds** ``Optional[int]`` - nodeAllocatableUpdatePeriodSeconds specifies the interval between periodic
        updates of the CSINode allocatable capacity for this driver. When set, both
        periodic updates and updates triggered by capacity-related failures are
        enabled. If not set, no updates occur (neither periodic nor upon detecting
        capacity-related failures), and the allocatable.count remains static. The
        minimum allowed value for this field is 10 seconds.
        This is an alpha feature and requires the MutableCSINodeAllocatableCount
        feature gate to be enabled.
        This field is mutable.
      * **podInfoOnMount** ``Optional[bool]`` - podInfoOnMount indicates this CSI volume driver requires additional pod
        information (like podName, podUID, etc.) during mount operations, if set to
        true. If set to false, pod information will not be passed on mount. Default is
        false.
        The CSI driver specifies podInfoOnMount as part of driver deployment. If true,
        Kubelet will pass pod information as VolumeContext in the CSI
        NodePublishVolume() calls. The CSI driver is responsible for parsing and
        validating the information passed in as VolumeContext.
        The following VolumeContext will be passed if podInfoOnMount is set to true.
        This list might grow, but the prefix will be used.
        "csi.storage.k8s.io/pod.name": pod.Name "csi.storage.k8s.io/pod.namespace":
        pod.Namespace "csi.storage.k8s.io/pod.uid": string(pod.UID)
        "csi.storage.k8s.io/ephemeral": "true" if the volume is an ephemeral inline
        volume
                                        defined by a CSIVolumeSource, otherwise
        "false"
        "csi.storage.k8s.io/ephemeral" is a new feature in Kubernetes 1.16. It is only
        required for drivers which support both the "Persistent" and "Ephemeral"
        VolumeLifecycleMode. Other drivers can leave pod info disabled and/or ignore
        this field. As Kubernetes 1.15 doesn't support this field, drivers can only
        support one mode when deployed on such a cluster and the deployment determines
        which mode that is, for example via a command line parameter of the driver.
        This field was immutable in Kubernetes < 1.29 and now is mutable.
      * **requiresRepublish** ``Optional[bool]`` - requiresRepublish indicates the CSI driver wants `NodePublishVolume` being
        periodically called to reflect any possible change in the mounted volume. This
        field defaults to false.
        Note: After a successful initial NodePublishVolume call, subsequent calls to
        NodePublishVolume should only update the contents of the volume. New mount
        points will not be seen by a running container.
      * **seLinuxMount** ``Optional[bool]`` - seLinuxMount specifies if the CSI driver supports "-o context" mount option.
        When "true", the CSI driver must ensure that all volumes provided by this CSI
        driver can be mounted separately with different `-o context` options. This is
        typical for storage backends that provide volumes as filesystems on block
        devices or as independent shared volumes. Kubernetes will call NodeStage /
        NodePublish with "-o context=xyz" mount option when mounting a
        ReadWriteOncePod volume used in Pod that has explicitly set SELinux context.
        In the future, it may be expanded to other volume AccessModes. In any case,
        Kubernetes will ensure that the volume is mounted only with a single SELinux
        context.
        When "false", Kubernetes won't pass any special SELinux mount options to the
        driver. This is typical for volumes that represent subdirectories of a bigger
        shared filesystem.
        Default is "false".
      * **storageCapacity** ``Optional[bool]`` - storageCapacity indicates that the CSI volume driver wants pod scheduling to
        consider the storage capacity that the driver deployment will report by
        creating CSIStorageCapacity objects with capacity information, if set to true.
        The check can be enabled immediately when deploying a driver. In that case,
        provisioning new volumes with late binding will pause until the driver
        deployment has published some suitable CSIStorageCapacity object.
        Alternatively, the driver can be deployed with the field unset or false and it
        can be flipped later when storage capacity information has been published.
        This field was immutable in Kubernetes <= 1.22 and now is mutable.
      * **tokenRequests** ``Optional[List[TokenRequest]]`` - tokenRequests indicates the CSI driver needs pods' service account tokens it
        is mounting volume for to do necessary authentication. Kubelet will pass the
        tokens in VolumeContext in the CSI NodePublishVolume calls. The CSI driver
        should parse and validate the following VolumeContext:
        "csi.storage.k8s.io/serviceAccount.tokens": {
          "<audience>": {
            "token": <token>,
            "expirationTimestamp": <expiration timestamp in RFC3339>,
          },
          ...
        }
        Note: Audience in each TokenRequest should be different and at most one token
        is empty string. To receive a new token after expiry, RequiresRepublish can be
        used to trigger NodePublishVolume periodically.
      * **volumeLifecycleModes** ``Optional[List[str]]`` - volumeLifecycleModes defines what kind of volumes this CSI volume driver
        supports. The default if the list is empty is "Persistent", which is the usage
        defined by the CSI specification and implemented in Kubernetes via the usual
        PV/PVC mechanism.
        The other mode is "Ephemeral". In this mode, volumes are defined inline inside
        the pod spec with CSIVolumeSource and their lifecycle is tied to the lifecycle
        of that pod. A driver has to be aware of this because it is only going to get
        a NodePublishVolume call for such a volume.
        For more information about implementing this mode, see
        https://kubernetes-csi.github.io/docs/ephemeral-local-volumes.html A driver
        can support one or more of these modes and more modes may be added in the
        future.
        This field is beta. This field is immutable.
    """
    attachRequired: 'Optional[bool]' = None
    fsGroupPolicy: 'Optional[str]' = None
    nodeAllocatableUpdatePeriodSeconds: 'Optional[int]' = None
    podInfoOnMount: 'Optional[bool]' = None
    requiresRepublish: 'Optional[bool]' = None
    seLinuxMount: 'Optional[bool]' = None
    storageCapacity: 'Optional[bool]' = None
    tokenRequests: 'Optional[List[TokenRequest]]' = None
    volumeLifecycleModes: 'Optional[List[str]]' = None


@dataclass
class CSINode(DictMixin):
    r"""CSINode holds information about all CSI drivers installed on a node. CSI
      drivers do not need to create the CSINode object directly. As long as they use
      the node-driver-registrar sidecar container, the kubelet will automatically
      populate the CSINode object for the CSI driver as part of kubelet plugin
      registration. CSINode has the same name as a node. If the object is missing,
      it means either there are no CSI Drivers available on the node, or the Kubelet
      version is low enough that it doesn't create this object. CSINode has an
      OwnerReference that points to the corresponding node object.

      **parameters**

      * **spec** ``CSINodeSpec`` - spec is the specification of CSINode
      * **apiVersion** ``Optional[str]`` - APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **kind** ``Optional[str]`` - Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``Optional[meta_v1.ObjectMeta]`` - Standard object's metadata. metadata.name must be the Kubernetes node name.
    """
    spec: 'CSINodeSpec'
    apiVersion: 'Optional[str]' = None
    kind: 'Optional[str]' = None
    metadata: 'Optional[meta_v1.ObjectMeta]' = None

    def __post_init__(self):
        self.apiVersion = 'storage.k8s.io/v1'
        self.kind = 'CSINode'


@dataclass
class CSINodeDriver(DictMixin):
    r"""CSINodeDriver holds information about the specification of one CSI driver
      installed on a node

      **parameters**

      * **name** ``str`` - name represents the name of the CSI driver that this object refers to. This
        MUST be the same name returned by the CSI GetPluginName() call for that
        driver.
      * **nodeID** ``str`` - nodeID of the node from the driver point of view. This field enables
        Kubernetes to communicate with storage systems that do not share the same
        nomenclature for nodes. For example, Kubernetes may refer to a given node as
        "node1", but the storage system may refer to the same node as "nodeA". When
        Kubernetes issues a command to the storage system to attach a volume to a
        specific node, it can use this field to refer to the node name using the ID
        that the storage system will understand, e.g. "nodeA" instead of "node1". This
        field is required.
      * **allocatable** ``Optional[VolumeNodeResources]`` - allocatable represents the volume resources of a node that are available for
        scheduling. This field is beta.
      * **topologyKeys** ``Optional[List[str]]`` - topologyKeys is the list of keys supported by the driver. When a driver is
        initialized on a cluster, it provides a set of topology keys that it
        understands (e.g. "company.com/zone", "company.com/region"). When a driver is
        initialized on a node, it provides the same topology keys along with values.
        Kubelet will expose these topology keys as labels on its own node object. When
        Kubernetes does topology aware provisioning, it can use this list to determine
        which labels it should retrieve from the node object and pass back to the
        driver. It is possible for different nodes to use different topology keys.
        This can be empty if driver does not support topology.
    """
    name: 'str'
    nodeID: 'str'
    allocatable: 'Optional[VolumeNodeResources]' = None
    topologyKeys: 'Optional[List[str]]' = None


@dataclass
class CSINodeList(DictMixin):
    r"""CSINodeList is a collection of CSINode objects.

      **parameters**

      * **items** ``List[CSINode]`` - items is the list of CSINode
      * **apiVersion** ``Optional[str]`` - APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **kind** ``Optional[str]`` - Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``Optional[meta_v1.ListMeta]`` - Standard list metadata More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
    """
    items: 'List[CSINode]'
    apiVersion: 'Optional[str]' = None
    kind: 'Optional[str]' = None
    metadata: 'Optional[meta_v1.ListMeta]' = None

    def __post_init__(self):
        self.apiVersion = 'storage.k8s.io/v1'
        self.kind = 'CSINodeList'


@dataclass
class CSINodeSpec(DictMixin):
    r"""CSINodeSpec holds information about the specification of all CSI drivers
      installed on a node

      **parameters**

      * **drivers** ``List[CSINodeDriver]`` - drivers is a list of information of all CSI Drivers existing on a node. If all
        drivers in the list are uninstalled, this can become empty.
    """
    drivers: 'List[CSINodeDriver]'


@dataclass
class CSIStorageCapacity(DictMixin):
    r"""CSIStorageCapacity stores the result of one CSI GetCapacity call. For a given
      StorageClass, this describes the available capacity in a particular topology
      segment.  This can be used when considering where to instantiate new
      PersistentVolumes.
      
      For example this can express things like: - StorageClass "standard" has "1234
      GiB" available in "topology.kubernetes.io/zone=us-east1" - StorageClass
      "localssd" has "10 GiB" available in "kubernetes.io/hostname=knode-abc123"
      
      The following three cases all imply that no capacity is available for a
      certain combination: - no object exists with suitable topology and storage
      class name - such an object exists, but the capacity is unset - such an object
      exists, but the capacity is zero
      
      The producer of these objects can decide which approach is more suitable.
      
      They are consumed by the kube-scheduler when a CSI driver opts into
      capacity-aware scheduling with CSIDriverSpec.StorageCapacity. The scheduler
      compares the MaximumVolumeSize against the requested size of pending volumes
      to filter out unsuitable nodes. If MaximumVolumeSize is unset, it falls back
      to a comparison against the less precise Capacity. If that is also unset, the
      scheduler assumes that capacity is insufficient and tries some other node.

      **parameters**

      * **storageClassName** ``str`` - storageClassName represents the name of the StorageClass that the reported
        capacity applies to. It must meet the same requirements as the name of a
        StorageClass object (non-empty, DNS subdomain). If that object no longer
        exists, the CSIStorageCapacity object is obsolete and should be removed by its
        creator. This field is immutable.
      * **apiVersion** ``Optional[str]`` - APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **capacity** ``Optional[resource.Quantity]`` - capacity is the value reported by the CSI driver in its GetCapacityResponse
        for a GetCapacityRequest with topology and parameters that match the previous
        fields.
        The semantic is currently (CSI spec 1.2) defined as: The available capacity,
        in bytes, of the storage that can be used to provision volumes. If not set,
        that information is currently unavailable.
      * **kind** ``Optional[str]`` - Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **maximumVolumeSize** ``Optional[resource.Quantity]`` - maximumVolumeSize is the value reported by the CSI driver in its
        GetCapacityResponse for a GetCapacityRequest with topology and parameters that
        match the previous fields.
        This is defined since CSI spec 1.4.0 as the largest size that may be used in a
        CreateVolumeRequest.capacity_range.required_bytes field to create a volume
        with the same parameters as those in GetCapacityRequest. The corresponding
        value in the Kubernetes API is ResourceRequirements.Requests in a volume
        claim.
      * **metadata** ``Optional[meta_v1.ObjectMeta]`` - Standard object's metadata. The name has no particular meaning. It must be a
        DNS subdomain (dots allowed, 253 characters). To ensure that there are no
        conflicts with other CSI drivers on the cluster, the recommendation is to use
        csisc-<uuid>, a generated name, or a reverse-domain name which ends with the
        unique CSI driver name.
        Objects are namespaced.
        More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
      * **nodeTopology** ``Optional[meta_v1.LabelSelector]`` - nodeTopology defines which nodes have access to the storage for which capacity
        was reported. If not set, the storage is not accessible from any node in the
        cluster. If empty, the storage is accessible from all nodes. This field is
        immutable.
    """
    storageClassName: 'str'
    apiVersion: 'Optional[str]' = None
    capacity: 'Optional[resource.Quantity]' = None
    kind: 'Optional[str]' = None
    maximumVolumeSize: 'Optional[resource.Quantity]' = None
    metadata: 'Optional[meta_v1.ObjectMeta]' = None
    nodeTopology: 'Optional[meta_v1.LabelSelector]' = None

    def __post_init__(self):
        self.apiVersion = 'storage.k8s.io/v1'
        self.kind = 'CSIStorageCapacity'


@dataclass
class CSIStorageCapacityList(DictMixin):
    r"""CSIStorageCapacityList is a collection of CSIStorageCapacity objects.

      **parameters**

      * **items** ``List[CSIStorageCapacity]`` - items is the list of CSIStorageCapacity objects.
      * **apiVersion** ``Optional[str]`` - APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **kind** ``Optional[str]`` - Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``Optional[meta_v1.ListMeta]`` - Standard list metadata More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
    """
    items: 'List[CSIStorageCapacity]'
    apiVersion: 'Optional[str]' = None
    kind: 'Optional[str]' = None
    metadata: 'Optional[meta_v1.ListMeta]' = None

    def __post_init__(self):
        self.apiVersion = 'storage.k8s.io/v1'
        self.kind = 'CSIStorageCapacityList'


@dataclass
class StorageClass(DictMixin):
    r"""StorageClass describes the parameters for a class of storage for which
      PersistentVolumes can be dynamically provisioned.
      
      StorageClasses are non-namespaced; the name of the storage class according to
      etcd is in ObjectMeta.Name.

      **parameters**

      * **provisioner** ``str`` - provisioner indicates the type of the provisioner.
      * **allowVolumeExpansion** ``Optional[bool]`` - allowVolumeExpansion shows whether the storage class allow volume expand.
      * **allowedTopologies** ``Optional[List[core_v1.TopologySelectorTerm]]`` - allowedTopologies restrict the node topologies where volumes can be
        dynamically provisioned. Each volume plugin defines its own supported topology
        specifications. An empty TopologySelectorTerm list means there is no topology
        restriction. This field is only honored by servers that enable the
        VolumeScheduling feature.
      * **apiVersion** ``Optional[str]`` - APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **kind** ``Optional[str]`` - Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``Optional[meta_v1.ObjectMeta]`` - Standard object's metadata. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
      * **mountOptions** ``Optional[List[str]]`` - mountOptions controls the mountOptions for dynamically provisioned
        PersistentVolumes of this storage class. e.g. ["ro", "soft"]. Not validated -
        mount of the PVs will simply fail if one is invalid.
      * **parameters** ``Optional[dict]`` - parameters holds the parameters for the provisioner that should create volumes
        of this storage class.
      * **reclaimPolicy** ``Optional[str]`` - reclaimPolicy controls the reclaimPolicy for dynamically provisioned
        PersistentVolumes of this storage class. Defaults to Delete.
      * **volumeBindingMode** ``Optional[str]`` - volumeBindingMode indicates how PersistentVolumeClaims should be provisioned
        and bound.  When unset, VolumeBindingImmediate is used. This field is only
        honored by servers that enable the VolumeScheduling feature.
    """
    provisioner: 'str'
    allowVolumeExpansion: 'Optional[bool]' = None
    allowedTopologies: 'Optional[List[core_v1.TopologySelectorTerm]]' = None
    apiVersion: 'Optional[str]' = None
    kind: 'Optional[str]' = None
    metadata: 'Optional[meta_v1.ObjectMeta]' = None
    mountOptions: 'Optional[List[str]]' = None
    parameters: 'Optional[dict]' = None
    reclaimPolicy: 'Optional[str]' = None
    volumeBindingMode: 'Optional[str]' = None

    def __post_init__(self):
        self.apiVersion = 'storage.k8s.io/v1'
        self.kind = 'StorageClass'


@dataclass
class StorageClassList(DictMixin):
    r"""StorageClassList is a collection of storage classes.

      **parameters**

      * **items** ``List[StorageClass]`` - items is the list of StorageClasses
      * **apiVersion** ``Optional[str]`` - APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **kind** ``Optional[str]`` - Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``Optional[meta_v1.ListMeta]`` - Standard list metadata More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
    """
    items: 'List[StorageClass]'
    apiVersion: 'Optional[str]' = None
    kind: 'Optional[str]' = None
    metadata: 'Optional[meta_v1.ListMeta]' = None

    def __post_init__(self):
        self.apiVersion = 'storage.k8s.io/v1'
        self.kind = 'StorageClassList'


@dataclass
class TokenRequest(DictMixin):
    r"""TokenRequest contains parameters of a service account token.

      **parameters**

      * **audience** ``str`` - audience is the intended audience of the token in "TokenRequestSpec". It will
        default to the audiences of kube apiserver.
      * **expirationSeconds** ``Optional[int]`` - expirationSeconds is the duration of validity of the token in
        "TokenRequestSpec". It has the same default value of "ExpirationSeconds" in
        "TokenRequestSpec".
    """
    audience: 'str'
    expirationSeconds: 'Optional[int]' = None


@dataclass
class VolumeAttachment(DictMixin):
    r"""VolumeAttachment captures the intent to attach or detach the specified volume
      to/from the specified node.
      
      VolumeAttachment objects are non-namespaced.

      **parameters**

      * **spec** ``VolumeAttachmentSpec`` - spec represents specification of the desired attach/detach volume behavior.
        Populated by the Kubernetes system.
      * **apiVersion** ``Optional[str]`` - APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **kind** ``Optional[str]`` - Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``Optional[meta_v1.ObjectMeta]`` - Standard object metadata. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
      * **status** ``Optional[VolumeAttachmentStatus]`` - status represents status of the VolumeAttachment request. Populated by the
        entity completing the attach or detach operation, i.e. the external-attacher.
    """
    spec: 'VolumeAttachmentSpec'
    apiVersion: 'Optional[str]' = None
    kind: 'Optional[str]' = None
    metadata: 'Optional[meta_v1.ObjectMeta]' = None
    status: 'Optional[VolumeAttachmentStatus]' = None

    def __post_init__(self):
        self.apiVersion = 'storage.k8s.io/v1'
        self.kind = 'VolumeAttachment'


@dataclass
class VolumeAttachmentList(DictMixin):
    r"""VolumeAttachmentList is a collection of VolumeAttachment objects.

      **parameters**

      * **items** ``List[VolumeAttachment]`` - items is the list of VolumeAttachments
      * **apiVersion** ``Optional[str]`` - APIVersion defines the versioned schema of this representation of an object.
        Servers should convert recognized schemas to the latest internal value, and
        may reject unrecognized values. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#resources
      * **kind** ``Optional[str]`` - Kind is a string value representing the REST resource this object represents.
        Servers may infer this from the endpoint the client submits requests to.
        Cannot be updated. In CamelCase. More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#types-kinds
      * **metadata** ``Optional[meta_v1.ListMeta]`` - Standard list metadata More info:
        https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata
    """
    items: 'List[VolumeAttachment]'
    apiVersion: 'Optional[str]' = None
    kind: 'Optional[str]' = None
    metadata: 'Optional[meta_v1.ListMeta]' = None

    def __post_init__(self):
        self.apiVersion = 'storage.k8s.io/v1'
        self.kind = 'VolumeAttachmentList'


@dataclass
class VolumeAttachmentSource(DictMixin):
    r"""VolumeAttachmentSource represents a volume that should be attached. Right now
      only PersistentVolumes can be attached via external attacher, in the future we
      may allow also inline volumes in pods. Exactly one member can be set.

      **parameters**

      * **inlineVolumeSpec** ``Optional[core_v1.PersistentVolumeSpec]`` - inlineVolumeSpec contains all the information necessary to attach a persistent
        volume defined by a pod's inline VolumeSource. This field is populated only
        for the CSIMigration feature. It contains translated fields from a pod's
        inline VolumeSource to a PersistentVolumeSpec. This field is beta-level and is
        only honored by servers that enabled the CSIMigration feature.
      * **persistentVolumeName** ``Optional[str]`` - persistentVolumeName represents the name of the persistent volume to attach.
    """
    inlineVolumeSpec: 'Optional[core_v1.PersistentVolumeSpec]' = None
    persistentVolumeName: 'Optional[str]' = None


@dataclass
class VolumeAttachmentSpec(DictMixin):
    r"""VolumeAttachmentSpec is the specification of a VolumeAttachment request.

      **parameters**

      * **attacher** ``str`` - attacher indicates the name of the volume driver that MUST handle this
        request. This is the name returned by GetPluginName().
      * **nodeName** ``str`` - nodeName represents the node that the volume should be attached to.
      * **source** ``VolumeAttachmentSource`` - source represents the volume that should be attached.
    """
    attacher: 'str'
    nodeName: 'str'
    source: 'VolumeAttachmentSource'


@dataclass
class VolumeAttachmentStatus(DictMixin):
    r"""VolumeAttachmentStatus is the status of a VolumeAttachment request.

      **parameters**

      * **attached** ``bool`` - attached indicates the volume is successfully attached. This field must only
        be set by the entity completing the attach operation, i.e. the
        external-attacher.
      * **attachError** ``Optional[VolumeError]`` - attachError represents the last error encountered during attach operation, if
        any. This field must only be set by the entity completing the attach
        operation, i.e. the external-attacher.
      * **attachmentMetadata** ``Optional[dict]`` - attachmentMetadata is populated with any information returned by the attach
        operation, upon successful attach, that must be passed into subsequent
        WaitForAttach or Mount calls. This field must only be set by the entity
        completing the attach operation, i.e. the external-attacher.
      * **detachError** ``Optional[VolumeError]`` - detachError represents the last error encountered during detach operation, if
        any. This field must only be set by the entity completing the detach
        operation, i.e. the external-attacher.
    """
    attached: 'bool'
    attachError: 'Optional[VolumeError]' = None
    attachmentMetadata: 'Optional[dict]' = None
    detachError: 'Optional[VolumeError]' = None


@dataclass
class VolumeError(DictMixin):
    r"""VolumeError captures an error encountered during a volume operation.

      **parameters**

      * **errorCode** ``Optional[int]`` - errorCode is a numeric gRPC code representing the error encountered during
        Attach or Detach operations.
        This is an optional, alpha field that requires the
        MutableCSINodeAllocatableCount feature gate being enabled to be set.
      * **message** ``Optional[str]`` - message represents the error encountered during Attach or Detach operation.
        This string may be logged, so it should not contain sensitive information.
      * **time** ``Optional[meta_v1.Time]`` - time represents the time the error was encountered.
    """
    errorCode: 'Optional[int]' = None
    message: 'Optional[str]' = None
    time: 'Optional[meta_v1.Time]' = None


@dataclass
class VolumeNodeResources(DictMixin):
    r"""VolumeNodeResources is a set of resource limits for scheduling of volumes.

      **parameters**

      * **count** ``Optional[int]`` - count indicates the maximum number of unique volumes managed by the CSI driver
        that can be used on a node. A volume that is both attached and mounted on a
        node is considered to be used once, not twice. The same rule applies for a
        unique volume that is shared among multiple pods on the same node. If this
        field is not specified, then the supported number of volumes on this node is
        unbounded.
    """
    count: 'Optional[int]' = None


